import sqlite3
import os

def create_sqlite_db( path,file_name ) :

    if not os.path.exists( path ):
        print( "path %s not exist" %path )
        return -1

    full_file_path = path + file_name

    try :
    
        conn = sqlite3.connect( full_file_path )

        #create the info_object table
        conn.execute( '''CREATE TABLE info_object
                ( version varchar(128),
                title varchar(128),
                description varchar(128),
                contact varchar(128),
                license varchar(128),
                components varchar(4096) )''')

        #create the server_object table
        conn.execute( '''CREATE TABLE server_object 
        ( id integer primary key autoincrement not null,
        raw_server varchar( 256 ) not null,
        host varchar(256) not null,
        partial_url varchar(256) )''' )
        
        #create path_object table
        conn.execute( '''CREATE TABLE path_object
        ( id  integer primary key autoincrement not null,
        raw_path varchar(256) not null,
        is_template integer not null,
        path_regex varchar(256),
        path_template varchar( 256 ) )
        ''' )

        #create path_parameters table
        conn.execute( '''CREATE TABLE path_parameters
        ( id integer primary key autoincrement not null,
          path_id integer not null,
          param_index integer not null,
          param_name varchar( 128 ) not null,
          flag integer not null

        )'''
        )

        #create operation_method table
        conn.execute( '''CREATE TABLE operation_method
        ( id  integer primary key autoincrement not null,
        path_id integer not null,
        method integer not null,
        summary varchar( 256 ),
        operationid varchar( 256)
        )''')

        #create parameters table
        conn.execute( '''CREATE TABLE parameters 
        ( id  integer primary key autoincrement not null,
        operation_method_id integer,
        param_name varchar( 256 ) not null,
        description varchar(256),
        param_in integer not null,
        style integer not null,
        type integer not null,
        explode integer not null,
        required integer not null,
        allow_empty integer not null,
        path_template_id integer,
        schema varchar( 4096 ),
        schema_reference integer not null )
        ''')

        #create request_body table
        conn.execute( '''CREATE TABLE request_body
        (
            id  integer primary key autoincrement not null,
            operation_method_id integer not null,
            required integer not null,
            description varchar( 256 )
        )''')

        #create request_body_content table

        conn.execute( '''CREATE TABLE request_body_content
        (
            id  integer primary key autoincrement not null,
            request_body_id integer not null,
            content_type varchar( 128 ) not null,
            body_schema varchar( 4096 ),
            is_reference integer
        )''')

        #create parameters_ext table

        conn.execute( '''CREATE TABLE parameters_ext
        (
            id  integer primary key autoincrement not null,
            parameter_id integer not null,
            param_name varchar(128) not null,
            type varchar(128) not null
        )''')

        conn.execute( '''CREATE TABLE tag_object
        (
            id  integer primary key autoincrement not null,
            tag_name varchar( 128 ) not null,
            description varchar( 256 )
        )'''
        )

        conn.execute( '''CREATE TABLE method_tags
                (
                    method_id integer not null,
                    tag_id integer not null
                )''')


        #conn.execute( '''insert into path_object( raw_path,is_template ) values( 'aaa',1 )''' )
        #conn.execute( '''insert into path_object( raw_path,is_template ) values( 'aaa',1 )''' )
        #conn.commit()
        
        conn.close()
    except Exception as err:
        print(err)
        return -1;
    
    return 0;
    
#create_sqlite_db( "/root/pythonc/product/","test.db")
