import os
import json
from yaml_conv import conv_yaml_json 
from schema_check import schema_validate
from create_db import create_sqlite_db
from parse_json_to_db import parse_json
from comm_dbg import enable_dbg

'''Return Values :
	0 : Success
	-1 : Can't find database file
	-2 : Can't find JSON file
	-3 : Not a valid JSON file
	-4 : Parse info object failed
	-5 : Parse server object failed
	-6 : Parse path file failed
	-20 : Yaml file does not exist
	-21 : Not a valid YAML file for OpenAPI	
	-22 : Create database failed
'''

schema_file_path = "/data/etc/openapi/openapi.schema"
#schema_file_path = "openapi.schema"
db_file_name = "openapi.db"

def parse_yaml( path,file_name ) :
    file_full_path = path + file_name 
    file_name_no_ext = ''
    ext_name = ''
    js_file_name = ''
    ret = 0
    
    if not os.path.exists( file_full_path ):
	if enable_dbg :
        	print( "Yaml file %s not exists" %file_full_path )
        return -20
  
    yaml_file = open( file_full_path,"rb" )
    yaml_str = yaml_file.read()
    yaml_file.close()
    json_dict = conv_yaml_json( yaml_str )
    if json_dict == None:
        return -21
    json_str = json.dumps( json_dict )
    #print json_str

    file_name_no_ext = os.path.splitext( file_name )[0] 
    ext_name = os.path.splitext( file_name )[1] 

    if cmp( ext_name.lower(),'.yaml' ) == 0 :
        js_file_name = file_name_no_ext + ".json"

    else :
        js_file_name =  file_name_no_ext + ".json"

    js_full_name = path + js_file_name  

    js_file = open( js_full_name,"wb" )
    js_file.write( json_str )
    js_file.close()


    ret = schema_validate( js_full_name,schema_file_path )

    if ret < 0 :
	if enable_dbg :
        	print( "schema validation failed" )
        return -21


    if os.path.exists( path + db_file_name ):
	if enable_dbg :
        	print( "Database file %s already exists,need to remove it" %( path + db_file_name ) )
        os.remove( path + db_file_name )

    ret = create_sqlite_db( path,db_file_name )

    if ret < 0 :
	if enable_dbg :
	       	print( "create_sqlite_db failed" )
        return -22

    ret = parse_json( path,js_file_name,db_file_name )
    
    if ret < 0 :
	if enable_dbg :
        	print( "parse_json failed" )
        return ret

    return 0

    
#parse_yaml( "/root/pythonc/product/output/","sample.yaml" )
