import sqlite3
import json as js
import os
import re
from comm_dbg import enable_dbg

MAX_COMPONENT_LEN=4096

'''
def list_all_dict(dict_a):
    if isinstance(dict_a,dict) :
        for x in range(len(dict_a)):
            temp_key = dict_a.keys()[x]
            temp_value = dict_a[temp_key]
            print( "%s : %s" %(temp_key,temp_value) )
            list_all_dict(temp_value)
'''
#-----------------------parsing info object---------------------------------------
def get_dict_value( from_dict,to_dict,key_str ) :
    
    if from_dict.has_key( key_str ) :
        if isinstance( from_dict[ key_str ],dict ) :
            js_str = js.dumps( from_dict[ key_str ] )
            to_dict[ key_str ] = js_str
        else:  
            to_dict[ key_str ] = from_dict[ key_str ]

    else :
        to_dict[ key_str ] = None 

def put_info_to_db( info_dict,comp_js,path,db_file_name ):

    full_db_path = path + db_file_name

    sql = '''insert into info_object(version,title,description,contact,
    license,components ) values (?,?,?,?,?,?)'''

    para = ( info_dict['version'],info_dict['title'],info_dict['description'],info_dict['contact'],info_dict['license'],comp_js )
    
    try :
        conn = sqlite3.connect( full_db_path )
        conn.execute( sql,para )
        conn.commit()
        conn.close()
    except Exception as err:
	if enable_dbg :
        	print(err)
        return -1
    
    return 0

def parse_info_object( api_dict,path,db_file_name ) :

    open_api_ver = ""
    info_temp = {}
    comp_js = ""
    ret = 0

    info_temp['version'] = None
    info_temp['title'] = None
    info_temp['description'] = None
    info_temp['contact'] = None
    info_temp['license'] = None
    
    if not api_dict.has_key( 'openapi' ) :
	if enable_dbg :
        	print( "No openAPI announcement in json" )
        return  -1

    open_api_ver = api_dict['openapi']

    if open_api_ver != "3.0.0" :
	if enable_dbg :
        	print( "Wrong Open Api version %s" %open_api_ver )
        return -1

    if api_dict.has_key( 'info' ) :
        info_dict = api_dict['info']
        for x in range( len( info_temp ) ):
            temp_key = info_temp.keys()[x]
            get_dict_value( info_dict,info_temp,temp_key )   

    if api_dict.has_key( 'components' ) :
        component_content = api_dict[ 'components' ]
        comp_dict = {}
        comp_dict['components'] = component_content
        comp_js = js.dumps( comp_dict )
        #print( comp_js )
    else:
        comp_js = None

    if comp_js and len( comp_js ) >= MAX_COMPONENT_LEN :
	if enable_dbg :
        	print( "the component length exceeds the limit" )
        return -1

    ret = put_info_to_db( info_temp,comp_js,path,db_file_name )

    if ret != 0 :
	if enable_dbg :
        	print( "put_info_to_db failed" )
        return -1

    #for ( key,value )  in info_dict.items():
    #    print( key )
    #    print( value )

    #list_all_dict( api_dict )
    return 0


#-------------------------------------Parsing tag object--------------------------------------

def parse_single_tag( tag_dict ):

    my_dict = {}
    my_dict['tag_name'] = None
    my_dict['description'] = None

    if not isinstance( tag_dict,dict ):
	if enable_dbg :
        	print( "tag_dict is not a dict" )
        return None


    if not tag_dict.has_key( 'name' ) :
	if enable_dbg :
        	print( "tag_dict has no key name" )
        return -1

    my_dict['tag_name'] = tag_dict['name']

    if tag_dict.has_key( 'description' ) :
        my_dict['description'] = tag_dict['description']

    return my_dict

def put_tag_to_db( tag_dic_list,db_full_path,is_default ) :
    sql = '''insert into tag_object( tag_name,description ) values( ?,? )'''

    try :
        conn = sqlite3.connect( db_full_path )
	
	if is_default == 0 :
		para2 = ( 'default',None )
		conn.execute( sql,para2 )
		conn.commit()

        for x in range( len( tag_dic_list ) ) :
            my_dict = tag_dic_list[ x ]
            para = ( my_dict['tag_name'],my_dict['description'] )
            conn.execute( sql,para )
            conn.commit()

        conn.close()
        return 0

    except Exception as err:
	if enable_dbg :
        	print(err)
        return -1

def parse_tag_object( api_dict,path,db_file_name ) :
    
    tag_list = []
    tag_dic_list = []
    is_default = 0

    db_full_path = path + db_file_name
    
    if not api_dict.has_key( 'tags' ) :
	if enable_dbg :
        	print( "This doc does not contain tag object !" )
        return 0

    tag_list = api_dict['tags']

    if not isinstance( tag_list,list ):
	if enable_dbg :
        	print( "The tag array is not a list" )
        return -1

    for x in range( len( tag_list ) ) :
        my_dict  = parse_single_tag(  tag_list[x] )

        if my_dict == None :
	    if enable_dbg :	
            	print( "parse single tag failed" )
            return -1
	
    	if cmp( my_dict['tag_name'],'default' ) == 0 :
		is_default = 1

        tag_dic_list.append( my_dict )

    ret = put_tag_to_db( tag_dic_list,db_full_path,is_default )

    if ret < 0 :
	if enable_dbg :
        	print( "put_tag_to_db failed" )
        return -1

    return 0


#-------------------------------------Parsing server object--------------------------------------

def put_server_obj_to_db( server_list,path,db_file_name ) :

    full_db_path = path + db_file_name
    sql = '''insert into server_object( raw_server,host,partial_url) values(?,?,?)'''

    try :
        conn = sqlite3.connect( full_db_path )

        for x in range( len( server_list ) ):
            server_dict = server_list[ x ]
            para = ( server_dict ['raw_server'],server_dict['host'],server_dict['partial_url'] )
            conn.execute( sql,para )

        conn.commit()
        conn.close()
    except Exception as err:
	if enable_dbg :
        	print(err)
        return -1

def parse_single_server( server_node ) :

    server_temp = {}
    server_temp['raw_server'] = ''
    server_temp['host'] = ''
    server_temp[ 'partial_url'] = ''
    server_url = ''
    pos = 0
    index = 0
    is_ssl = 0
    match_str = ""

    if not server_node.has_key( 'url' ) :
	if enable_dbg :
		print( "No server in the server node" )
        return None

    server_url = server_node['url']
    
    if isinstance( server_url,dict ) :
	if enable_dbg :
        	print( "Server url is an instance %s" %server_url )
        return None

    server_temp['raw_server'] = server_url

    pos = server_url.lower().find( "http://" )

    if pos < 0 :
	pos = server_url.lower().find( "https://" )

	if pos < 0 :
		if enable_dbg :
			print( "can't find http:// or https:// in server url %s" %server_url )
        	return None
	else:
		is_ssl = 1

    if is_ssl == 1:
	    match_str = "https://"
    else:
	    match_str = "http://"

    index = pos + len( match_str ) 
    
    temp_host = []

    while index < len( server_url ):
        if server_url[index] == '/' :
            break

        temp_host.append( server_url[index] )
        index = index + 1

    server_temp['host'] = ''.join( temp_host )

    if len( server_temp['host']  ) <= 0 :
	if enable_dbg :
        	print( "Invalid server host" )
        return None

    if index < len( server_url ) - 1 :
        temp_part_url = server_url[ index : ]
        server_temp['partial_url'] = temp_part_url
    else :
        server_temp['partial_url'] = None
    
    
    return server_temp


def parse_server_object( api_dict,path,db_file_name ) :
    
    server_dict = {}
    server_count = 0
    server_dict_temp = {}
    ret = 0
    server_list = []

    if not api_dict.has_key( 'servers' ) :
	if enable_dbg :
        	print( "No servers field in the json")
        return 0

    server_dict = api_dict['servers']
    server_count = len( server_dict )


    server_dict_temp['raw_server'] = ''
    server_dict_temp['host'] = ''
    server_dict_temp[ 'partial_url'] = ''

    if server_count <= 0 :
	if enable_dbg :
        	print( "no servers defined in the server object" )
        return 0

    for x in range( server_count ) :
        new_dict = parse_single_server( server_dict[x] )
        
        if new_dict == None :
	    if enable_dbg :	
            	print( "parse_single_server failed for %s" %server_dict[x] )
            return -1
        
        server_list.append( new_dict )

    put_server_obj_to_db( server_list,path,db_file_name )

    return 0


#----------------------------------------Parse path key-------------------------------

def get_param_str( from_str,start,end ):
    
    mid_str = ''
    param_str = ''

    mid_str = from_str[ start:end ]
    param_str = mid_str.lstrip('{').rstrip('}')

    return param_str

def put_path_obj_to_db( path_dict,param_list,db_full_path ) :

    sql = '''insert into path_object( raw_path,is_template,path_regex,path_template ) values(?,?,?,? )'''
    insert_id = 0
    index = 0

    if path_dict['is_template'] != 0 :
        if not param_list :
	    if enable_dbg :
            	print( "is_template not 0,but param_list is null" )
            return -1,insert_id
    
    try:
        conn = sqlite3.connect( db_full_path )
        para = ( path_dict['raw_path'],path_dict['is_template'],path_dict['path_regex'],path_dict['path_template'] )
        cursor = conn.cursor()
        cursor.execute( sql,para )
        insert_id = int( cursor.lastrowid )
        conn.commit()
        conn.close()
    except Exception as err:
	if enable_dbg :
        	print(err)
        return -1,insert_id


    if path_dict['is_template'] == 0 :
        return 0,insert_id


    sql = '''insert into path_parameters( path_id,param_index,param_name,flag ) values(?,?,?,? )'''

    try:
        conn = sqlite3.connect( db_full_path )

        for x in range( len( param_list ) ):
            para = ( insert_id,x,param_list[x],0 )
            conn.execute( sql,para )
        
        conn.commit()
        conn.close()
    
    except Exception as err:
	if enable_dbg :     
		print( err )
        return -1,insert_id

    return 0,insert_id


def parse_path_key( path_str,db_full_path ) :

    count = 0
    gen_regex = ""
    param_list = []
    rep_count = 0
    rep_str = ''
    ret = 0
    path_id = 0
    reg_str = "[^/]+"

    temp_path_dict = {}
    temp_path_dict['raw_path'] = None
    temp_path_dict['is_template'] = 0
    temp_path_dict['path_regex'] = None
    temp_path_dict['path_template'] = None

    temp_path_dict['raw_path'] = path_str

    pattern = re.compile( r'{.*?}',re.I )
    it = pattern.finditer( path_str )

    for match in it:
        count = count + 1
        param_str = get_param_str( path_str,match.start(0),match.end(0) )
        param_list.append( param_str )

    if count == 0 :
	if enable_dbg :
        	print( "URL is not a template" )
        
        ret,path_id = put_path_obj_to_db( temp_path_dict,param_list,db_full_path )

        if ret < 0 :
	    if enable_dbg :
            	print( "put_path_obj_to_db failed" )
            return -1,path_id

        return 0,path_id

    if count >= 9 :
	if enable_dbg :
        	print( "to many items in the template,we only support 9" )
        return -1,path_id

    temp_path_dict['is_template'] = 1
    
    gen_regex = re.subn( pattern,reg_str,path_str )[ 0 ]

    if not gen_regex :
	if enable_dbg :
        	print( "run subn failed ,gen_regex is null" )
        return -1,path_id

    temp_path_dict['path_regex'] = gen_regex + "$"
    rep_str = gen_regex

    while 1 :
        str1 = '{#' + str( rep_count ) + '}'
        str2 = rep_str
        rep_str = rep_str.replace( reg_str,str1,1 )
        
        if cmp( str2,rep_str ) == 0 :
            break;

        rep_count = rep_count + 1

    if( rep_count != count ):
	if enable_dbg :
		print( "rep_count=%d,count=%d,not equal"%( rep_count,count ) )
        return -1,path_id

    temp_path_dict['path_template'] = rep_str
    
    ret,path_id = put_path_obj_to_db( temp_path_dict,param_list,db_full_path )

    if ret < 0 :
	if enable_dbg :
        	print( "put_path_obj_to_db failed" )
        return -1,path_id
    
    return 0,path_id



#------------------------------parse method------------------------------------

def get_method_num( method ) :
    method_str = method.lower()

    if cmp( method_str,'get' ) == 0 :
        return 1

    if cmp( method_str,'post' ) == 0 :
        return 2


    if cmp( method_str,'put' ) == 0 :
        return 3

    if cmp( method_str,'delete' ) == 0 :
        return 4

    if enable_dbg :
    	print( "Unsupported method" )
    return -1


def put_method_to_db( method_dict,db_full_path,path_id ) :

    sql = '''insert into operation_method( path_id,method,summary,operationid ) values(?,?,?,? )'''
    insert_id = 0

    try :
        conn = sqlite3.connect( db_full_path )
        para = ( method_dict['path_id'],method_dict['method'],method_dict['summary'],method_dict['operationid'] )
        cursor = conn.cursor()
        cursor.execute( sql,para )
        insert_id = int( cursor.lastrowid )
        conn.commit()
        conn.close()
    except Exception as err:
	if enable_dbg :
		print( err )
        return -1,insert_id

    return 0,insert_id


def get_tag_id( tag,db_full_path ):

    tag_id = 0

    sql = '''select id from tag_object where tag_name = ?'''
    sql2 = '''insert into tag_object( tag_name,description ) values( ?,? )'''
    
    try :
        conn = sqlite3.connect( db_full_path )
        para = ( tag, )
        cursor = conn.cursor()
        cursor.execute( sql,para )
        values = cursor.fetchall()
        count = len( values )
        
        if count > 0 :
            row = values[ 0 ]
            tag_id = int( row[ 0 ] )
            cursor.close()
            conn.close()
            return tag_id
        
        
        para2 = ( tag,None )
        cursor.execute( sql2,para2 )
        tag_id = int( cursor.lastrowid )
        conn.commit()
        cursor.close()
        conn.close()

        return tag_id

    except Exception as err:
	if enable_dbg :
		print( err )
        return -1


def process_single_tag( tag,method_id,db_full_path ) :
    tag_id = 0
    
    tag_id = get_tag_id( tag,db_full_path )

    if tag_id < 0 :
	if enable_dbg :
        	print( "get_tag_id failed" )
        return -1

    sql = '''insert into method_tags( method_id,tag_id ) values( ?,? )'''

    try :
        conn = sqlite3.connect( db_full_path )
        para = ( method_id,tag_id )
        conn.execute( sql,para )
        conn.commit()
        conn.close()
        return 0
    except Exception as err:
	if enable_dbg :
		print( err )
        return -1

def process_method_tag( tag_array,method_id,db_full_path ) :

    ret = 0
    
    for x in range( len( tag_array ) ):
        ret = process_single_tag( tag_array[x],method_id,db_full_path )

        if ret < 0 :
	    if enable_dbg :	
            	print( "process tag %s for method id %d failed" %( tag_array[x],method_id  ) )
            return -1

    return 0
    

def parse_operation_method( key,value,path_id,db_full_path ) :
    
    method_dict = {}
    ret = 0
    method_id = 0
    method_num = 0
    cur_dict = {}
    tag_array = []

    method_dict['path_id'] = None
    method_dict['method'] = None
    method_dict['summary'] = None
    method_dict['operationid'] = None

    method_num = get_method_num( key )

    if method_num < 0 :
        return -1,method_id
    
    method_dict['path_id'] = path_id
    method_dict['method'] = method_num
    
    if not isinstance( value,dict) :     
	if enable_dbg :
        	print( "Invalid type for method value" )
        return -1,method_id

    cur_dict = value

    if cur_dict.has_key( 'summary' ):
        method_dict['summary'] = cur_dict['summary']

    if cur_dict.has_key( 'operationId' ) :
        method_dict['operationid'] = cur_dict['operationId']

    if cur_dict.has_key('tags') :
        tag_array = cur_dict['tags']

        if not isinstance( tag_array,list ) :
	    if enable_dbg :
            	print( "the tag_array is not a list" )
            return -1,method_id
    else:
	tag_array.append('default')

    ret,method_id = put_method_to_db( method_dict,db_full_path,path_id )

    if ret < 0 :
	if enable_dbg :
        	print( "put_method_to_db failed" )
        return -1,method_id

    if len( tag_array ) > 0 :
        ret = process_method_tag( tag_array,method_id,db_full_path )    

        if ret < 0 :
	    if enable_dbg :
            	print( "process_method_tag failed" )
            return -1,method_id

    return 0,method_id

#-----------------------------parse method parameters-------------------------------

def get_in_num( in_str ) :

    str1 = in_str.lower()

    if cmp( str1,'query' ) == 0  :
        return 1

    if cmp( str1,'header' ) == 0 :
        return 2

    if cmp( str1,'path' ) == 0 :
        return 3

    if cmp( str1,'cookie' ) == 0 :
        return 4

    return -1

def get_style_num( style_str ) :

    str1 = style_str.lower()

    if cmp( str1,'simple' ) == 0:
        return 1

    if cmp( str1,'form' ) == 0:
        return 2

    return -1

def return_true_false_num( val_str ) :
    
    '''
    str1 = val_str.lower()

    if cmp( str1,'true' ) :
        return 1

    if cmp( str1,'false' ) :
        return 0
    '''

    if val_str == True :
        return 1
    else : 
        return 0

    return -1


def get_components( db_full_path ) :
    components = ''
    sql = '''select components from info_object'''

    try :
        conn = sqlite3.connect( db_full_path )
        cursor = conn.cursor()
        cursor.execute( sql )
        values = cursor.fetchall()
        count = len( values )
        

        if count <= 0 :
            cursor.close()
            conn.close()
	    if enable_dbg :
            	print( "cant get the components" )
            return None

        row = values[ 0 ]
        components = row[ 0 ]
        cursor.close()
        conn.close()

        return components
    
    except Exception as err:
	if enable_dbg :
        	print(err)
        return None


'''
def parse_simple_reference( schema_dict ) :
    schema_str = ''
    gen_dict = {}

    if schema_dict.has_key( '$ref' ) :
        if( len( schema_dict ) > 1  ) :
	    if enable_dbg :
            	print( "Unsupported schema type" )
            return -1,schema_str

            gen_dict['allOf'] = []
            gen_dict['allOf'].append( schema_dict )
            schema_str = js.dumps( gen_dict )

	    if enable_dbg :
            	print schema_str
            
	    return 0,schema_str 
            
    else :
        schema_str = js.dumps( schema_dict )
        print( schema_str )
        return 0,schema_str
'''

def get_component_ref_dict( reference,db_full_path ) :

    temp_dict1 = {}
    temp_dict2 = {}
    ref_str = reference

    comp_str = get_components( db_full_path )

    if not comp_str :
        return None

    ref_str = ref_str.lstrip( '#' )
    ref_str = ref_str.lstrip( '/' )
    paths = ref_str.split( "/" )
    
    try :
        comp_dict = js.loads( comp_str )
        temp_dict1 = comp_dict

        for x in range( len( paths ) ) :
            temp_dict2 = temp_dict1[ paths[x] ]
            temp_dict1 = temp_dict2
        
        return temp_dict2
    
    except Exception as err:
	if enable_dbg :
        	print( err )
        return None



def get_param_type( schema_dict,db_full_path ) :

    get_type = ''
    ref_str = ''
    temp_dict = {}

    if schema_dict.has_key( 'type' ) :
        get_type = schema_dict['type']
        return 0,get_type

    
    if not schema_dict.has_key('$ref') :
	if enable_dbg :
        	print( "schema has no type and $ref field" )
        return -1,None

    ref_str = schema_dict['$ref']

    temp_dict = get_component_ref_dict( ref_str,db_full_path )

    if temp_dict == None :
	if enable_dbg :
        	print( "get_component_ref_dict failed" )
        return -1,None

    '''
    comp_str = get_components( db_full_path )

    if not comp_str :
	if enable_dbg :
        	print( "get components failed" )
        return -1,None

    ref_str = ref_str.lstrip( '#' )
    ref_str = ref_str.lstrip( '/' )
    paths = ref_str.split( "/" )'''

    try :
        
        '''
        temp_dict1 = {}
        temp_dict2 = {}
        comp_dict = js.loads( comp_str )
        temp_dict1 = comp_dict
        
        for x in range( len( paths ) ) :
            temp_dict2 = temp_dict1[ paths[x] ]
            temp_dict1 = temp_dict2
        '''

        get_type = temp_dict['type'] 
        return 1,get_type
    
    except Exception as err:
	if enable_dbg :
        	print(err)
        return -1,None


def search_reference( schema_dict ) :

    ret = 0

    if isinstance( schema_dict,dict ) :
        for x in range(len( schema_dict )):
            temp_key = schema_dict.keys()[x]

            if cmp( temp_key,"$ref" ) == 0 :
                return 1

            temp_value = schema_dict[temp_key]
            ret = search_reference( temp_value )

            if ret > 0 :
                return 1

    return 0


def get_main_dict( schema_dict,db_full_path ) :

    main_dict = {}
    
    if schema_dict.has_key( "type" ) :
        main_dict = schema_dict
        return main_dict
    
    elif schema_dict.has_key( '$ref' ) :
        ref_str = schema_dict['$ref']
        main_dict = get_component_ref_dict( ref_str,db_full_path )

        if main_dict == None :
	    if enable_dbg :
            	print( "get main_dict using get_component_ref_dict failed" )
            return None

        return main_dict

    else:
	if enable_dbg :
        	print( "schema no type and can't get reference" )
        return None


def parse_array_child_type( main_dict,my_dict,db_full_path ) :

    item_dict = {}
    sub_dict = {}
    child_type = {}
    get_type = ''
    
    child_type['parameter_id'] = None
    child_type['param_name'] = None
    child_type['type'] = None

    if main_dict.has_key( 'items' ) :
        item_dict = main_dict['items']
    else :
	if enable_dbg :
        	print( "parse_array_chile_type : has no items" )
        return -1
        
    if not item_dict.has_key( "$ref" ):
        if not item_dict.has_key( 'type' ) :
	    if enable_dbg :
            	print( "item has not type"  )
            return -1
        get_type = item_dict['type']

    else :
        ref_str = item_dict['$ref']
        sub_dict = get_component_ref_dict( ref_str,db_full_path )

        if sub_dict == None :
	    if enable_dbg :
            	print( "get_component_ref_dict can't get sub_dict" )
            return -1

        if not sub_dict.has_key( 'type' ):
	    if enable_dbg :
            	print( "sub dict has not type" )
            return -1

        get_type = sub_dict['type']

    child_type[ 'param_name' ] = 'items'
    child_type['type'] = get_type

    my_dict[ 'child_types' ].append( child_type )

    return 0

def parse_obj_child_type( main_dict,my_dict,db_full_path ) :

    sub_dict = {}
    child_type = {}
    get_type = ''
    
    child_type['parameter_id'] = None
    child_type['param_name'] = None
    child_type['type'] = None

    if main_dict.has_key( 'properties' ) :
        sub_dict = main_dict['properties']
    else :
	if enable_dbg :
        	print( " parse_obj_child_type: has no properties" )
        return -1

    for( key,value ) in sub_dict.items():
        if not isinstance( value,dict ) :
	    if enable_dbg :
            	print( "value for properties not a dict" )
            return -1
        if not value.has_key( "type" ) :
	    if enable_dbg :
            	print( "value has not type in properties for key %s" %key )
            return -1
        
        get_type = value['type']

        child_type = {}
        child_type['parameter_id'] = None
        child_type['param_name'] = key
        child_type['type'] = get_type
        my_dict['child_types'].append( child_type )
        
    return 0



def parse_param_child_type( schema_dict,my_dict,type_val,db_full_path ) :

    child_type = {}
    main_dict = {}
    ret = 0

    main_dict = get_main_dict( schema_dict,db_full_path )

    if main_dict == None :
	if enable_dbg :
        	print( "get main dict failed" )
        return -1
    
    
    if cmp( type_val,'array' ) == 0 :
        ret = parse_array_child_type( main_dict,my_dict,db_full_path )

        if ret < 0 :
	    if enable_dbg :
            	print( "parse_array_chile_type failed" )
            return -1

    if cmp( type_val,'object' ) == 0 :
        ret = parse_obj_child_type( main_dict,my_dict,db_full_path )

        if ret < 0 :
	    if enable_dbg :
            	print( "parse_obj_child_type failed" )
            return -1

    return 0

        
def parse_schema( param_dict,my_dict,db_full_path ) :
    schema_str = ''
    schema_dict = {}
    type_val = ''
    is_ref = 0

    if not param_dict.has_key( 'schema' ) :
	if enable_dbg :
        	print( "No schema in the parameter" )
        return -1

    schema_dict = param_dict[ 'schema' ]

    if not isinstance( schema_dict,dict) :
	if enable_dbg :
        	print( "Invalid type for schema_dict" )
        return -1

    is_ref,type_val = get_param_type( schema_dict,db_full_path )
    type_val = type_val.lower()
    my_dict['type']  = type_val

    if cmp( type_val ,'array') == 0 or cmp( type_val ,'object') == 0 :
        ret = parse_param_child_type( schema_dict,my_dict,type_val,db_full_path )

        if ret < 0 :
	    if enable_dbg :
            	print( "parse_param_child_type failed" )
            return -1


    ret = search_reference( schema_dict )

    if ret > 0 :
        is_ref = 1

    schema_str = js.dumps( schema_dict )

    my_dict['schema_reference'] = is_ref
    my_dict['schema'] = schema_str

    return 0


def parse_single_param(  value_dict,path_id,method_id,db_full_path ) :
    param_dict = {}
    my_dict = {}
    param_dict = value_dict

    if not isinstance( param_dict,dict ):
	if enable_dbg :
        	print( "Invalid type for param_dict" )
        return None
    
    my_dict[ 'operation_method_id' ] = method_id
    my_dict[ 'param_name' ] = None
    my_dict[ 'description' ] = None
    my_dict[ 'param_in' ] = None
    my_dict[ 'style' ] = None
    my_dict[ 'type' ] = None
    my_dict[ 'explode' ] = None
    my_dict[ 'required' ] = None
    my_dict[ 'allow_empty' ] = None
    my_dict[ 'path_template_id' ] = None
    my_dict[ 'schema '] = None
    my_dict[ 'schema_reference' ] = None
    my_dict[ 'child_types' ] = []

    if not param_dict.has_key( 'name' ) :
	if enable_dbg :
        	print( "error,the parameter has not name" )
        return None

    my_dict[ 'param_name' ] = param_dict[ 'name' ]

    if param_dict.has_key( 'description' ) :
        my_dict[ 'description' ] = param_dict[ 'description' ]

    if not param_dict.has_key( 'in' ) :
	if enable_dbg :
        	print( "the parameter has not in field" )
        return None

    in_str = param_dict['in']
    in_num = get_in_num( in_str )
    
    if in_num < 0 :
	if enable_dbg :
        	print( "Invalid in value : %s" %in_str )
        return None

    my_dict[ 'param_in' ] = in_num

    if param_dict.has_key( 'style' ) :
        style_str = param_dict[ 'style' ]
        style_num = get_style_num( style_str )

        if style_num < 0 :
	    if enable_dbg :
            	print( "invalid style %s" %style_str )
            return None

        my_dict['style'] = style_num
    else :
        if my_dict[ 'param_in' ] == 1 or my_dict[ 'param_in' ] == 4 :
            my_dict['style'] = 2
        else :
            my_dict['style'] = 1

    
    if param_dict.has_key( 'explode' ) :
        
        explode_str = param_dict[ 'explode' ]
        explode_num = return_true_false_num( explode_str )

        if explode_num < 0 :
	    if enable_dbg :
            	print( "Invalid exploed %s" %exploed_str )
            return None
        
        my_dict['explode'] = explode_num

    else :
        if my_dict['style'] == 2 :
            my_dict['explode'] = 1
        else :
            my_dict['explode'] = 0

 
    if param_dict.has_key( 'required' ) :
        
        required_str = param_dict[ 'required' ]
        required_num = return_true_false_num( required_str )

        if required_num < 0 :
	    if enable_dbg :
            	print( "Invalid required value %s" %required_str )
            return None
        
        my_dict['required'] = required_num

    else :
        if my_dict['param_in'] == 3 :
            my_dict['required'] = 1
        else :
	    #my_dict['explode'] = 0
	    my_dict['required'] = 0
    
    
    if param_dict.has_key( 'allowEmptyValue' ) :
        
        empty_str = param_dict[ 'allowEmptyValue' ]
        empty_num = return_true_false_num( empty_str )

        if empty_num < 0 :
            print( "Invalid empty value %s" %empty_str )
            return None
        
        my_dict['allow_empty'] = empty_num

    else :
        my_dict['allow_empty'] = 0
    
    
    if param_dict.has_key( 'operationId' ) :
        my_dict[ 'operation_method_id' ] = param_dict[ 'operationId' ]

    ret = parse_schema( param_dict,my_dict,db_full_path )
    
    if ret < 0 :
	if enable_dbg :
        	print( "parse schema failed" )
        return None

    return my_dict

    return 0

def search_temp_index( my_dict,path_id,method_id,db_full_path ) :
    
    index = 0

    sql = '''select param_index from path_parameters where path_id = ? and param_name= ?'''
    sql2 = '''update path_parameters set flag=1 where path_id = ? and param_name = ? '''

    try :
        conn = sqlite3.connect( db_full_path )
        para = ( path_id,my_dict['param_name'] )
        cursor = conn.cursor()
        cursor.execute( sql,para )
        values = cursor.fetchall()
        count = len( values )

        if count <= 0 :
            cursor.close()
            conn.close()
            return 0,0
        
        row = values[ 0 ]
        index  = int( row[ 0 ] )

        conn.execute( sql2,para )
        conn.commit()

        cursor.close()
        conn.close()

        return 1,index

    except Exception as err:
	if enable_dbg :
        	print(err)
        return -1,-1

def check_path_parameter( path_id,db_full_path  ) :
    sql = '''select id from path_parameters where path_id = ? and flag=?'''
    count = 0
    
    try :
        conn = sqlite3.connect( db_full_path )
        para = ( path_id,0 )
        cursor = conn.cursor()
        cursor.execute( sql,para )
        values = cursor.fetchall()
        count = len( values )

        cursor.close()
        conn.close()
        
        if count > 0 :
	    if enable_dbg :
            	print( "checked the path_parameters tables ,but there are %d records invalid" %count )
            return -1

        return 0
        
    except Exception as err:
	if enable_dbg :
        	print( err )
        return -1


def process_temp_index( dict_array,path_id,method_id,db_full_path ) :
    
    path_param = 0
    ret = 0
    index = 0

    for x in range( len( dict_array ) ) :
        
        my_dict = dict_array[ x ]

	if enable_dbg :
        	print( "my_dict[ 'param_in' ] = %d" %my_dict[ "param_in" ] )

        if my_dict[ "param_in" ] != 3 :
            continue

        ret,index = search_temp_index( my_dict,path_id,method_id,db_full_path )


        if ret < 0 :
	    if enable_dbg :
            	print( " search_temp_index failed ")
            return -1

        if ret == 1 :
            path_param = 1
            my_dict[ 'path_template_id' ] = index



    if path_param > 0 :
        ret = check_path_parameter( path_id,db_full_path  )

        if ret < 0 :
	    if enable_dbg :
            	print( "check_path_parameter failed" )
            return -1

    return 0

def insert_child_types( records,cursor,insert_id ) :

    sql = '''insert into parameters_ext( parameter_id,param_name,type ) values( ?,?,? )'''
    
    for x in range( len( records ) ) :
        type_rec = records[ x ]
        para = ( insert_id,type_rec['param_name'],type_rec['type'] )
        cursor.execute( sql,para )

def put_parameter_to_db( dict_array,db_full_path,path_id,method_id ) :
   
    sql = '''insert into parameters( operation_method_id,param_name,description,param_in,
    style,type,explode,required,allow_empty,path_template_id,schema,schema_reference ) values
    ( ?,?,?,?,?,?,?,?,?,?,?,? )'''

    try :
        conn = sqlite3.connect( db_full_path )

        for x in range( len( dict_array ) ) :
            my_dict = dict_array[ x ]
        
	    para = ( my_dict['operation_method_id'],my_dict['param_name'],my_dict['description'],\
                    my_dict['param_in'],my_dict['style'],my_dict['type'],my_dict['explode'],\
                    my_dict['required'],my_dict['allow_empty'],my_dict['path_template_id'],\
                    my_dict['schema'],my_dict['schema_reference'] )
            
            cursor = conn.cursor()
            cursor.execute( sql,para )
            insert_id = int( cursor.lastrowid )

            if( len( my_dict['child_types'] ) > 0 ) :
                insert_child_types( my_dict['child_types'],cursor,insert_id )

            conn.commit()

        #conn.commit()
        conn.close()

        return 0

    except Exception as err:
	if enable_dbg :
		print(err)
        return -1

def parse_parameters( value_dict,path_id,method_id,db_full_path ) :
    
    param_array = {}
    param_array = value_dict
    ret = 0
    param_dict_array = []
    
    if not isinstance( param_array,list ):
	if enable_dbg :
        	print( "Invalid type for param_dict" )
        return -1

    for x in range( len( param_array ) ) :
        my_dict  = parse_single_param(  param_array[x],path_id,method_id,db_full_path )

        if my_dict == None :
	    if enable_dbg :
            	print( "parse_single_param failed for parameter %d " %x  )
            return -1
        param_dict_array.append( my_dict )

    ret = process_temp_index( param_dict_array,path_id,method_id,db_full_path )

    if ret < 0 :
	if enable_dbg :
        	print( "process_temp_index failed" )
        return -1

    ret = put_parameter_to_db( param_dict_array,db_full_path,path_id,method_id )
    
    if ret < 0 :
	if enable_dbg :
        	print( "put_parameter_to_db failed" )
        return -1

    
    return 0

def put_request_body_db( db_full_path,body_rec ) :
    sql = '''insert into request_body( operation_method_id,required,description ) values(?,?,? )'''
    insert_id = 0

    try:
        conn = sqlite3.connect( db_full_path )
        para = ( body_rec['operation_method_id'],body_rec['required'],body_rec['description'] )
        cursor = conn.cursor()
        cursor.execute( sql,para )
        insert_id = int( cursor.lastrowid )
        conn.commit()
        conn.close()
        return 0,insert_id

    except Exception as err:
	if enable_dbg :
    		print(err)
        return -1,-1

def parse_body_content( key,value,body_id ) :
    c_type = key
    c_dict = value
    my_dict = {}
    schema_dict = {}
    
    if not isinstance( c_dict,dict ):
	if enable_dbg :
        	print( "c_dict is not a dict" )
        return -1,None

    my_dict['request_body_id'] = body_id
    my_dict['content_type'] = None
    my_dict['body_schema'] = None
    my_dict['is_reference'] = None

    my_dict['content_type'] = c_type

    if cmp( c_type,'application/json' ) == 0 :
        if not c_dict.has_key('schema') :
	    if enable_dbg :
            	print( "the content type is json ,but no schema found" )
            return -1,None

        schema_dict = c_dict['schema']
        ret = search_reference( schema_dict )

        if ret == 0 :
            my_dict[ 'is_reference' ] = 0
        else :
            my_dict[ 'is_reference' ] = 1

        schema_str = js.dumps( schema_dict )
        my_dict['body_schema'] = schema_str

    return 0,my_dict

def put_content_to_db( db_full_path,content_list  ) :
    
    sql = '''insert into request_body_content( request_body_id,content_type,body_schema,is_reference ) values(?,?,?,? )'''
    
    try:
        conn = sqlite3.connect( db_full_path )

        for x in range( len(content_list) ) :
            my_dict = content_list[x]
            para = ( my_dict['request_body_id'],my_dict['content_type'],my_dict['body_schema'],my_dict['is_reference'] )

            conn.execute( sql,para )
        conn.commit()
        conn.close()

        return 0

    except Exception as err:
	if enable_dbg :
        	print( err )
        return -1


def parse_request_body( value,path_id,method_id,db_full_path ) :
    
    body_dict = value
    body_rec = {}
    req_val = 0
    body_id = 0
    content_dict = {}
    content_list = []

    if not isinstance( body_dict,dict ):
	if enable_dbg :
        	print( "body_dict is not a dict" )
        return -1

    body_rec['operation_method_id'] = None
    body_rec['description'] = None
    body_rec['required'] = None

    body_rec['operation_method_id'] = method_id

    if body_dict.has_key( "description" ) :
        body_rec['description'] = body_dict['description']

    if body_dict.has_key('required') :
        req_val = return_true_false_num( body_dict['required'] )
        body_rec['required'] = req_val
    else :
        body_rec['required'] = 0

    if not body_dict.has_key( 'content' ) :
	if enable_dbg :
        	print( "the request body has no content" )
        return -1

    ret,body_id = put_request_body_db( db_full_path,body_rec )

    if ret < 0 :
	if enable_dbg :
        	print( "put_request_body_db failed" )
        return -1
    
    content_dict = body_dict[ 'content' ]

    if not isinstance( content_dict,dict ):
	if enable_dbg :
        	print( "body_dict is not a dict" )
        return -1

    for( key,value ) in content_dict.items():
        ret,content_rec = parse_body_content( key,value,body_id )

        if ret < 0 :
	    if enable_dbg :
            	print( "parse_body_content failed" )

        content_list.append( content_rec )

    ret = put_content_to_db( db_full_path,content_list  )

    if ret < 0 :
	if enable_dbg :
        	print( "put_content_to_db failed" )
        return -1
    
    return 0

def parse_method_params( dict_value,path_id,method_id,db_full_path ) :
    
    content_dict = {}
    content_dict = dict_value
    ret = 0

    if not isinstance( content_dict,dict) :
	if enable_dbg :
        	print( "Invalid type for content dict" )
        return -1

    for( key,value ) in content_dict.items():
        
        if cmp( key, "parameters" ) == 0 :
            ret = parse_parameters( value,path_id,method_id,db_full_path )

            if ret < 0 :
		if enable_dbg :
                	print( "parse_parameters failed" )
                return -1
        
        if cmp( key.lower(),"requestbody" ) == 0 :
            ret = parse_request_body( value,path_id,method_id,db_full_path )

            if ret < 0 :
		if enable_dbg :
               		print( "parse_request_body failed" )
                return -1
        
    return 0

        #if cmp( key,requestBody ) == 0 :


#-----------------------------parse path value----------------------------------
def parse_path_value( path_value,path_id,db_full_path ) :

    result = 0
    method_id = 0
    path_value_dict = {}
    
    if not isinstance( path_value,dict) :
	if enable_dbg :
        	print( "Invalid type for path value" )
        return -1

    path_value_dict = path_value
    
    for( key,value ) in path_value_dict.items():
        result,method_id = parse_operation_method( key,value,path_id,db_full_path )

        if result < 0 :
	    if enable_dbg :
            	print( "parse_operation_method failed" )
            return -1

        result = parse_method_params( value,path_id,method_id,db_full_path ) 

        if result < 0 :
	    if enable_dbg :
            	print( "parse_method_params failed" )
            return -1

    return 0

#----------------------------parse path-----------------------------------
def parse_paths( api_dict,path,db_file_name ) :

    path_dict = {}
    db_full_path = path + db_file_name
    ret = 0
    path_id = 0

    if not api_dict.has_key( 'paths' ) :
	if enable_dbg :
        	print( "no path found in json" )
        return -1

    path_dict = api_dict['paths']

    for( key,value ) in path_dict.items():
        ret,path_id = parse_path_key( key,db_full_path )
        
        if ret < 0 :
	    if enable_dbg :
            	print( "parse_path_key failed" )
            return -1

        if path_id <= 0 :
	    if enable_dbg :
            	print( "parse_path_key,path_id failed" )
            return -1

        parse_path_value( value,path_id,db_full_path )
        
    return 0 


#------------------------------------------Main entry------------------------------------------------------
def parse_json( path,json_file,db_file_name ) :
    
    db_full_path = path + db_file_name
    json_full_path = path + json_file
    ret = 0
    
    if not os.path.exists( db_full_path ):
	if enable_dbg :
        	print( "Database file %s not exists" %db_full_path )
        return -1

    if not os.path.exists( json_full_path ):
	if enable_dbg :
        	print( "Json file %s not exists" %json_full_path )
        return -2

    f = open( json_full_path, 'rb')
    json_str = f.read()
    f.close();

    try :
        api_dict = js.loads( json_str )      
    except Exception as err:
	if enable_dbg :
        	print( "Json parse failed" )
        	print(err)
        return -3

    ret = parse_info_object( api_dict,path,db_file_name )

    if ret < 0 :
	if enable_dbg :
        	print( "parse_info_object failed" )
        return -4

    ret = parse_server_object( api_dict,path,db_file_name )
    
    if ret < 0 :
	if enable_dbg :
        	print( "parse server object failed" )
        return -5

    ret = parse_tag_object( api_dict,path,db_file_name )

    if ret < 0 :
	if enable_dbg :
        	print( "parse tag object failed" )
        return -7

    ret = parse_paths( api_dict,path,db_file_name )

    if ret < 0 :
	if enable_dbg :    
        	print( "parse paths failed" )
        return -6

    
    return 0

#parse_json( "/root/pythonc/","sample.json","test.db" )
