/*
 * 
 * This file is part of Ext JS 4
 * 
 * Copyright (c) 2011 Sencha Inc
 * 
 * Contact: http://www.sencha.com/contact
 * 
 * GNU General Public License Usage This file may be used under the terms of the
 * GNU General Public License version 3.0 as published by the Free Software
 * Foundation and appearing in the file LICENSE included in the packaging of
 * this file. Please review the following information to ensure the GNU General
 * Public License version 3.0 requirements will be met:
 * http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you are unsure which license is appropriate for your use, please contact
 * the sales department at http://www.sencha.com/contact.
 * 
 */

Ext.define('FortiWeb.view.status.classes.NetworkChartPortlet', 
{
	extend : 'Ext.panel.Panel',
	alias : 'widget.chartnetportlet',

	requires: ['Ext.data.JsonStore', 'Ext.chart.theme.Base',
			'Ext.chart.series.Series', 'Ext.chart.series.Line',
			'Ext.chart.axis.Numeric'],
	
	traStore: null,
	currTraPolicy: null,
	datapollingInterval : 1,
	timeout: null,

	genTrafficData : function(num) 
	{
		var data = [];
		var i;

		for (i = 0; i < num; i++) {
		data.push({
			time: i,
			count: 0
		});
		}
		return data;
	},
	
	initComponent: function()
	{
		this.traStore = Ext.create('Ext.data.JsonStore',
		{
			fields: ['time', 'count'],
			data: this.genTrafficData(60),
			feedData: function(records)
			{
				for(var i = 0; i < records.length; i++)
				{
					records[i].count *= 8;
					records[i].count /= 1000;
				}
				this.loadData(records);
			}
		}
		);
		
		Ext.apply(this,
		{
			layout:
			{
				type: 'vbox',
				align: 'stretch'
			},
			defaults:
			{
				bodyStyle: 'padding: 10px'
			},
			width: "100%",
			height: 350,
			
			items:
			[
			{
				xtype: 'container',
				width: "100%",
				style:
				{
					backgroundColor: '#aaa'
				},
				layout:
				{
					type: 'column'
				},
				items:
				[
				{
					xtype: 'displayfield',
					value: '<b>&nbsp;'+lang_str.throughput+' </b>',
					columnWidth: .5
				},
				{
					xtype: 'combo',
					fieldLabel: lang_str.policy,
					columnWidth: .5,
					id: 'policy_combo',
					labelAlign: 'right',
					emptyText : lang_str.select,
					queryParam : 'comboFilterString',
					displayField: 'label',
					valueField: 'label',
					editable: false,
					store: Ext.create('Ext.data.Store',
						{
							autoLoad: true,
							fields: ['label'],
							proxy:
							{
								type: 'ajax',
								url: '/system/status/policy-list?check=1&include_total=1&is_traffic=1',
								reader:
								{
									type: 'json',
									root: ''
								}
							}
						}
					),
					
					listeners:
					{
						scope: this,
						load: function(store, records, successful, operation, eOpts)
						{
						},
												
						beforequery: function(qe)
						{
							qe.combo.clearValue();
							delete qe.combo.lastQuery;
						},
									
						select: function(f, record, eOpts)
						{						
							var r = record[0];
							var policy = r.get('label');
							
							//if old value eq to new value, not need to refresh the data
							if(this.currTraPolicy == policy)
							{
								return;
							}

							if(this.timeout)
								clearTimeout(this.timeout);
							
							this.currTraPolicy = policy;
							
							this.getMoreData(this.currTraPolicy);
						}
					}
				}
				]
			},

		
			{
				xtype: 'chart',
				shadow: false,
				width: '99%',
				height: 330,
				style : 'background: #fff',
				store: this.traStore,
				axes:
				[
					{
						type: 'Numeric',
						position: 'left',
						fields: ['count'],
						minimum: 0,
						title: '',
						grid: true,
						label: {
							renderer: function(v)
							{
								if(v > 10 * 1000)
									return (Number(v/1000)).toFixed(2) + 'Mb';
								else
									return (Number(v)).toFixed(2) + 'kb';
							}
						}
					},
					{
						type: 'Category',
						position: 'bottom',
						fields: ['time'],
						title: '',
						grid: true,
						label: 
						{
						    rotate: {degrees: 315},
				                    renderer: function(name) 
				                    {
							var val = parseInt(name);
							if((val+5) % 10 != 0)	
								return '';
							else
							{
				                        	var ret = 60 - val + 5;
								return "Last " + String(ret) + ' seconds';
							}
				                    }
					        }
					}
				],
				
				series:
				[
					{
						type: 'line',
						fill: true,
						smooth: true,
						showMarkers: false,
						highlight: false,
						axis: 'left',
						xField: 'time',
						yField: 'count',
						style : {
                                                stroke : '#880000',
                                                'stroke-width' : 2
						},

						label : {
                                                color : '#880000'
						},

					        tips: 
					 	{
				                  trackMouse: true,
				                  width: 100,
				                  height: 30,
				                  renderer: function(storeItem, item) 
				                  {
//				                    this.setTitle(storeItem.get('count') + 'kb/s');
							var val = storeItem.get('count');
							if(val > 10 * 1000)
								this.setTitle((Number(val/1000)).toFixed(3) + 'Mb/s');
							else
								this.setTitle(val + 'kb/s');
				                  }
				            	}
					}
				]
			}
			]
		}
		);
		
		this.callParent(arguments);

		var combo = Ext.getCmp('policy_combo');
		combo.store.load(
			{
				callback: function(records, operation, success)
				{
					var recs = [];
					for(var i = 0; i < records.length; i++)
					{
						recs.push(records[i].data);
					}
					this.loadData(recs);

					if(records.length > 0)
					{
						var data = [];
						data.push(records[0]);
						combo.fireEvent('select', combo, data);
						combo.setValue(recs[0].label);
					}
				}
			}
		);
	},
	
	getTraData: function(rate, policy)
	{
		var records = [];
		for(var i = 0; i < 60; i++)
		{
			records.push({time: i.toString(), count: 10 + Math.floor(Math.random() * 30)});
		}
		
		this.traStore.loadData(records);
	},

	getMoreData: function(policy)
	{
/*
		if(policy == null)	return;

		if(this.currTraPolicy != policy)
		{
			this.currTraPolicy = policy;
		}
*/

		var storeTmp = Ext.create("Ext.data.Store",
			{
				fields: ["time", "count"],
				proxy: {
					type: "ajax",
					url: "/system/status/policy-stats?policy=" + this.currTraPolicy,
					reader: {type: "json", root: ""}
				},
				listeners: 
				{
					scope: this,
					load: function(store, records, suc, op, eOpts)
					{
						if(records[0].raw.status == 1)
						{
							var data = [];
							for(var i = 0; i < records[0].raw.data.length; i++)
							{
								data.push({time: records[0].raw.data[i].time, count: records[0].raw.data[i].count});
							}
							this.feedDataAndPoolNext(data, this.currTraPolicy);
						}
						else
						{
							var msg_id = records[0].raw.msg_id;
							switch(msg_id)
							{
								case 0:
									document.location.href = "/system/traffic_chart/list";
									break;
								case -30:
									top.top.location.href = "/login";
									break;
								case -37:
									document.location.href = "/noaccess?redir=/system/traffic_chart/list";
									break;
								default:
									document.location.href = "/error?msg=" + msg_id;
									break;
							}
						}
					}
				}
			}
		);
		storeTmp.load();
	},

	feedDataAndPoolNext: function(record, policy)
	{
		if(record)
		{
			this.traStore.feedData(record);
		}

		var nextInterval = this.datapollingInterval;

		var tmp =  function()
		{
			this.getMoreData(policy);
		}

		var func = function()
		{
			return this.getMoreData(policy);
		}

//		this.timeout = setTimeout(this.getMoreData, nextInterval * 1000);

		this.timeout = Ext.defer(function() {
                                        this.getMoreData(policy);
                                }, nextInterval * 1000, this);
	}
});
