var columnPanel = (function(){

	function draw(data)
	{
		var time = [];
		var other = [];
		var robot = [];
		var search = [];

		$j.each(data, function(index, obj){
			time.push(obj.time);
			other.push(obj.Other);
			robot.push(obj['Bad Robot']);
			search.push(obj['Known Search Engines']);
		});

		var options = {
			chart: {
				type: 'column'
			},
			title: {
				style: {
					'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 
					'fontSize': '15px',
					'color': '#262626'
				},
				text: ''
			},
			subtitle: {
				text: ''
			},
			xAxis: {
				type: 'category',
				labels: {
					rotation: 270,
					style: {
						'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 
						'fontSize': '12px',
						'color': '#262626'
					},
				},
				lineWidth :2,
				categories: time
			},
			yAxis: {
				min: 0,
				title: {
					text: lang_str.left_title
				},
				tickWidth: 1,
				lineWidth: 2,
				gridLineWidth: 0,
				labels: {
					style: {
						'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 
						'fontSize': '12px',
						'color': '#262626'
					},
					formatter: function() {
						return this.value ;
					}
				}
			},
			credits:{
				enabled: false
			},
			legend: {
				itemStyle: {
					'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 
					'fontSize': '15px', 
					'fontWeight': '400',
					'color': '#262626'
				},
				enabled: true,
				borderWidth: 1,
				borderColor: '#b4b4b4'
			},
			tooltip: {
				style: {
					'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 
					'fontWeight': '400', 
					'fontSize': '15px',
					'color': '#262626'
				},
				headerFormat: '<span>{point.series.name}:</span><br />',
				pointFormat: '{point.y}'
			},
			plotOptions: {
				column: {
					stacking: 'y'
				},
				series: {
					borderWidth: 0
				}
			},
			series: [
				{
					name: 'Other',
					data: other,
					color: '#1c2a37'
				},
				{
					name: 'Bad Robot',
					data: robot,
					color: '#de202f'
				},
				{
					name: 'Known Search Engines',
					data: search,
					color: '#4c6b7d'
				}
			]
		};

		$j('#column').highcharts(options);
	}


	function changeData()
	{
		$j.ajax({
			'url': '/bot_analysis/column?type=' + getTimeValue() + '&policy=' + getPolicyValue(),
			'cache': false,
			'dataType': 'json',
			'error': function(){
			},
			'success': function(res){
				if(res.status == 'ok')
				{
					draw(res.data);
				}
				else if(res.status == 'error')
					alert(res.error);
			}
		});
	}

	function resize() {
		$j('#column').highcharts().reflow();
	}

	return {
		'changeData': changeData,
		'resize': resize
	};
})(jQuery);
