var trafficChart = (function($){
	'use strict';

	Highcharts.setOptions({
		colors: ['#1c2a37', '#de202f', '#4c6b7d', '#9c5f66', '#94ae0a', '#115fa6', 
		         '#a61120', '#ff8809', '#ffd13e', '#a61187', '#24ad9a', '#7c7474', 
			 '#a66111']
	});

	var type;
	var policy;
	var all_zero = false;

	function alertError(msg)
	{
		alert(msg);
	}
	function processData(data) {
		var empty = true;
		var total = 0;
		data.forEach(function(e){
			e.name = e.type;
			total += e.count;
			
			if(e.count != 0){ empty = false; }
			
		});

		data.forEach(function(e){
			var percentage = new Number((e.count / total) * 100);
			/*exact to 0.001*/
			e.y = Number(percentage.toFixed(3));
		});

		if(empty)
		{
			all_zero = true;
			data.forEach(function(e){ e.y = 0.0001; });
		} else {
			all_zero = false;
		}

		return data;
	}
	function changeData()
	{
		type = getTimeValue() + 3;
		policy = getPolicyValue();

		$.ajax({
		            "url" : '/bot_analysis/pie',
		            "data" : { "type" : type, "policy": policy},
		            "dataType" : "json",
		            "success" : drawChart,
		            "error": function(){
				    alertError("Failed to get pie chart data.");
			    },
		            "cache" : false
		});
	}

	function drawChart(result, textStatus)
	{
		var commonData;
		var engineData;
		
		if(result.status == 'error')
		{
			alertError(result.error);
		}
		else if(result.status == 'ok')
		{
			commonData = processData(result.data.common);

			$("div.type").highcharts({
				credits:{
					enabled:false
				},
				chart: {
					type: 'pie'
				},
				title: {
					text: null 
				},
				tooltip: {
					style: {
						'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 
						'fontWeight': '400', 
						'fontSize': '15px',
						'color': '#262626'
					},
					headerFormat: '',
					pointFormat: all_zero?'{point.type}: 0%':'{point.type}: {point.y}%'
				},
				plotOptions: {
					pie: {
						cursor: 'pointer',
						dataLabels: {
							enabled: false
						},
						showInLegend: true,
						borderWidth: 0,
						size: "85%"
					}
				},
				legend: {
					itemStyle: {
						'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 
						'fontSize': '15px', 
						'fontWeight': '400',
						'color': '#262626'
					},
					align: 'right',
					verticalAlign: 'middle',
					borderColor: '#b4b4b4',
					layout: 'vertical',
					padding: 5,
					borderWidth: 1,
					itemMarginTop: 3,
					itemMarginBottom: 3,
					x: -50
				},
				series: [{
					name: 'common',
					colorByPoint: true,
					data: commonData 
				}]
			});

			engineData = processData(result.data.engine);
			$("div.search").highcharts({
				credits:{
					enabled:false
				},
				chart: {
					type: 'pie'
				},
				title: {
					text: null 
				},
				tooltip: {
					style: {
						'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 
						'fontWeight': '400', 
						'fontSize': '15px',
						'color': '#262626'
					},
					headerFormat: '',
					pointFormat: all_zero?'{point.type}: 0%':'{point.type}: {point.y}%'
				},
				plotOptions: {
					pie: {
						cursor: 'pointer',
						dataLabels: {
							enabled: false
						},
						showInLegend: true,
						borderWidth: 0,
						size: "90%"
					}
				},
				legend: {
					itemStyle: {
						'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 
						'fontSize': '15px', 
						'fontWeight': '400',
						'color': '#262626'
					},
					align: 'right',
					verticalAlign: 'middle',
					layout: 'vertical',
					padding: 5,
					borderWidth: 1,
					itemMarginTop: 3,
					itemMarginBottom: 3,
					x: -50
				},
				series: [{
					name: 'common',
					colorByPoint: true,
					data: engineData 
				}]

			});
		}
		else
		{
			return;
		}
	}

	function resize(argument) {
		$("div.type").highcharts().reflow();
		$("div.search").highcharts().reflow();
	}

	return {
		'changeData': changeData,
		'resize': resize
	}
})(jQuery);
