var rootLayout, southLayout, centerLayout;

var layoutSettingRoot = {
	name: "RootLayout",
	maskPanesEarly: true,
	defaults: {
		size: "auto",
		resizerTip: "",
		minSize: 0
	},
	north: {
		paneSelector: ".banner",
		resizable: false,
		slidable: false,
		closable: false,
		spacing_open: 0
	},
	center: {
		paneSelector: ".content",
		closable: false,
	}
};

var layoutSettingCenter = {
	maskPanesEarly: true,
	south: {
		paneSelector: ".south",
		resizable: false,
		slidable: false,
		closable: false,
		spacing_open: 0,
		size: '50%'
	},
	center: {
		paneSelector: ".center",
		closable: false,
		size: '50%'
	}
};

var layoutSettingSouth = {
	maskPanesEarly: true,
	east: {
		paneSelector: ".south_east",
		resizable: false,
		slidable: false,
		maskContents: false,
		closable: false,
		spacing_open: 0,
		onresize_end: on_resize,
		size: '50%'
	},
	center: {
		paneSelector: ".south_center",
		resizable: false,
		maskContents: false,
		maskObjects: false,
		closable: false,
		spacing_open: 0,
		size: '50%'
	}
};

function changeData()
{
	columnPanel.changeData();
	//trafficChart.changeData();
	setTimeout(trafficChart.changeData, 1000);
}

function on_resize()
{
	columnPanel.resize();
	trafficChart.resize();
}

function getTimeValue()
{
	return parseInt($j('#time_select').val());
}

function getPolicyValue()
{
	var val = $j('#policy_select').val();

	if(val == null)
		return '';
	else
		return val;
}

$j(document).ready(function() {
	rootLayout = $j("body").layout(layoutSettingRoot);
	centerLayout = $j(".content").layout(layoutSettingCenter);
	southLayout = $j(".south").layout(layoutSettingSouth);

	$j('#time_select').on('change', function(){
		changeData();
	});

	$j('#policy_select').on('change', function(){
		changeData();
	});

	$j.ajax({
		'url': "/system/status/policy-list?is_hit=1",
		'dataType': 'json',
		'success': function(response){
			var policy = document.getElementById('policy_select');
			for(var i = 0; i < response.length; i++)
			{
				var val = response[i].label;
				var option = new Option(val, val);
				policy.options.add(option);
			}

			policy.selectedIndex = 0;

			changeData();
		},
		'error': function() {
		},
		'cache': false
	});
});
