#!/data/bin/python
import os
import sys
import cgi
import cgitb; cgitb.enable()

os.environ[ 'HOME' ] = '/tmp/'

import time
import MySQLdb
from datetime import datetime

import matplotlib
matplotlib.use( 'Agg' )

import pylab
form = cgi.FieldStorage()

import numpy as np
from numpy import array

sample_list = [];

mean = 0.0;
sigma = 0.0;

def fetch_hmm_info_from_db(db_name, arg_id):
	global mean, sigma;

	db = None;
	cur = None;

	try:
		db = conn_mysql_db(db_name);
		if db is None:
			return -1
		cur = db.cursor();
		sql = "SELECT prob_mean_ex, variance_ex FROM url_args_info where arg_id=" + str(arg_id);
		cur.execute(sql);

	except MySQLdb.Warning as w:
		pass

	except:
		print("fetch_hmm_info_from_db() got exception1.");
		if (cur != None) :
			cur.close();

		if (db != None) :
			db.close();

		return -1;

	for row in cur.fetchall() : 
		mean = float(row[0]);
		sigma = float(row[1]);

	cur.close();
	db.close();
	return 0;

def draw_pic(mean, sigma, sd, debug):
    global sample_list;

    #np.random.seed(6789)
    #x = np.random.gamma(4, 0.5, 1000)
    x = array(sample_list);
    pylab.figure(figsize=(8, 4))
    pylab.hist(x, bins=20, color='c', edgecolor='k', alpha=0.65, align='left')

    mystd = sigma;

    pylab.axvline(mean, color='k', linestyle='dashed', linewidth=1) 
    _, max_ = pylab.ylim()
    _, max_x = pylab.xlim()
    pylab.text(mean, max_ - max_/10, r'$\mu$')

    line_x_1 = mean + sd * mystd;

    if debug != None:
    	print("Mean: %f std: %f" %(mean, mystd));

    pylab.axvline(line_x_1, color='r', linestyle='dashed', linewidth=1) 
    _, max_ = pylab.ylim()
    tip = "$\mu + " + str(sd) + "\sigma$"
    if mystd == 0:
    	pylab.text(line_x_1, max_ - max_/10 - max_/10, tip)
    else:	
    	pylab.text(line_x_1, max_ - max_/10, tip)

    left, max_x = pylab.xlim()

    if max_x < line_x_1 + max_x/20:
	pylab.xlim(left, max_x + max_x/20)
	left, max_x = pylab.xlim()

    anomaly = 0;
    
    for i in sample_list:
	if i > line_x_1:
  	    anomaly = anomaly + 1;

    percent = 0.0;
    percent = float(anomaly) / float(len(sample_list)) * 100;
    percent = round(percent, 2);

    percent_str = str(percent) + "%";

    pylab.annotate ('', (line_x_1, max_ - max_/2), (max_x, max_ - max_/2), arrowprops={'arrowstyle':'<->'})
    pylab.text(line_x_1 + (max_x - line_x_1) / 2, max_ - max_/2 + 1, percent_str, horizontalalignment='center')

    pylab.ylabel("Samples", fontsize=10)
    tip = "Probability\n";
    tip += "$\mu$ " + ": Mean " + " level" ;
    tip += "      ";
    tip += "$\sigma$ " + ": Standard Deviation";
    tip += "      ";
    tip += "$\mu + " + str(sd) + "\sigma$ ";
    tip += ": Anomaly Threshold";
    tip += "                            ";
    pylab.xlabel(tip, fontsize=10)

    if debug == None:
   	print "Content-Type: image/png\n"
    	pylab.savefig( sys.stdout, format='png', bbox_inches='tight' )   


def conn_mysql_db(db_name=None):
    try:
        if db_name is None:        
            db = MySQLdb.connect(user='root')
        else:
            db = MySQLdb.connect(user='root', database=db_name)
    except MySQLdb.Warning as w:
        DbgErr("Warning: %s" % repr(w))
        return None            
    except MySQLdb.OperationalError as e:	
        DbgErr("OperationalError: %s" % repr(e))
        return None
    except Exception as e:
        DbgErr("OperationalError: %s" % repr(e))    
        return None

    return db;


def fetch_data_from_db(db_name, arg_id):
	global sample_list;
	db = None;
	cur = None;
	table = "url_args_pattern_" + str(int(arg_id) % 16)

	try:
		db = conn_mysql_db(db_name);
		if db is None:
			return -1
		cur = db.cursor();
		sql = "SELECT sum(pattern_count) FROM " + table + " where arg_id=" + str(arg_id) + " and noise_flag=0";
		cur.execute(sql);

	except MySQLdb.Warning as w:
		pass

	except:
		print("fetch_data_from_db() got exception1.");
		if (cur != None) :
			cur.close();

		if (db != None) :
			db.close();

		return -1;

	total = 0;

	for row in cur.fetchall() : 
		#print row[0], " ", row[1], " ", row[2]
		total = row[0];
		
	count = total / 1000;
	if count < 100:
		count = 100;

	cur.close();

	try: 
		cur = db.cursor();
		sql = "SELECT average_probability, pattern_count FROM " + table + " where arg_id=" + str(arg_id) + " and noise_flag=0" + " order by average_probability DESC";
		cur.execute(sql);
	
	except MySQLdb.Warning as w:
		pass

	except:
		print("fetch_data_from_db() got exception2.");
		if (cur != None) :
			cur.close();

		if (db != None) :
			db.close();

		return -1;

	avg_pro = 0.0;

	for row in cur.fetchall() : 
		avg_pro = row[0];

		for item in range(row[1]): 
			if count <= 0:
				break;

			sample_list.append(avg_pro);
			count = count - 1;

		if count <= 0: 
			break;

	cur.close();
	db.close();

	#print len(sample_list);
	#print sample_list


def check_cgi_input(db_name, domain_id, arg_id, sd):
	for i in range(len(arg_id)):
		cur = ord(arg_id[i]);
		if (cur >= 48 and cur <= 57) == False:
			return -1;

	for i in range(len(domain_id)):
		cur = ord(domain_id[i]);
		if (cur >= 48 and cur <= 57) == False:
			return -1;

	for i in range(len(sd)):                                                                     
                cur = ord(sd[i]);                                                                    
                if (cur >= 48 and cur <= 57) == False:                                                   
                        return -1; 

	for i in range(len(db_name)):
		cur = ord(db_name[i]);
		if ((cur >= 48 and cur <= 57) or (cur >= 65 and cur <= 90) or (cur >= 97 and cur <= 122) or (cur == 95)) == False :
			return -1;

	return 0;

def main():
	arguments = cgi.FieldStorage() 

	db_name = None;
	arg_id = None;
	sd = None;
	debug = None;

	for i in arguments.keys():
		if i == "db_name":
			db_name = arguments[i].value

		if i == "domain_id":
			domain_id = arguments[i].value

		if i == "arg_id":
			arg_id = arguments[i].value

		if i == "sd":
			sd = arguments[i].value

		if i == "debug":
			debug = arguments[i].value	

	if db_name == None:
		exit(-1);

	if domain_id == None:
		exit(-1);

	if arg_id == None:
		exit(-1);

	if sd == None:
		exit(-1);

	if debug != None:
		print "Content-Type: text/html\n"

	ret = check_cgi_input(db_name, domain_id, arg_id, sd);                                                       
        if ret != 0:                                                                                  
                exit(-1); 

	fetch_data_from_db(db_name, arg_id);

	ret = fetch_hmm_info_from_db(db_name, arg_id);
        if ret != 0:                                                                                  
                exit(-1); 

	if debug != None:
		print sample_list;
		print("<br>");

	if len(sample_list) > 0:
        	draw_pic(mean, sigma, int(sd), debug);

if __name__ == "__main__": 
	main();

