/******************************
 Javascript Console Customizer
 Init by A. Krywaniuk, Mar 2006
 Copyright Fortinet, inc.
 All rights reserved
 ******************************/

// STRIP-FUNCTION: debug_msg

//EXPORT_SYMBOL end_dialog
//EXPORT_SYMBOL chooserModeChange
//EXPORT_SYMBOL colorAll
//EXPORT_SYMBOL showcmd_clicked
//EXPORT_SYMBOL fontFamilyChange
//EXPORT_SYMBOL fontSizeChange
//EXPORT_SYMBOL resetDefaults
//EXPORT_SYMBOL customize_page_startit
//EXPORT_SYMBOL on_customize_beforeunload

// Must include jsconsole.js to use this file.


// add_sample_items - uses functions from jsconsole.js
function add_sample_items(cnt)
{
	var tbody = getConsoleTbody();
	
//	append_complete_row(tbody, "")
	append_complete_row(tbody, "fw1042 login: jsmith")
	append_complete_row(tbody, "Password: *******")
	append_complete_row(tbody, "Welcome !")
	append_complete_row(tbody, "")
	append_complete_row(tbody, "fw1042 # ")
}


var selectMode = 'text';

// 'inset' vs. 'outset' appears to be the best button style combination.
// 'double' also looks reasonable.
var selected_border_style = 'inset';
var unselected_border_style = 'outset';

// chooserModeChange - event handler when the user changes the chooser mode.
// Can also be called to change the current value.
function chooserModeChange(mode)
{
	var this_elem;
	var other_elem;
	
	if (mode == 'text')
	{
		this_elem = window.document.getElementById("colorbox_text");
		other_elem = window.document.getElementById("colorbox_back");
	}
	else if (mode == 'back')
	{
		this_elem = window.document.getElementById("colorbox_back");
		other_elem = window.document.getElementById("colorbox_text");
	}
	else
	{
		return;
	}

	this_elem.style.borderStyle = selected_border_style;
	this_elem.disabled = true;
	this_elem.blur();
	
	other_elem.style.borderStyle = unselected_border_style;
	other_elem.disabled = false;

	selectMode = mode;
}

function setTextColor(color)
{
	window.document.getElementById("colorbox_text").style.backgroundColor = color;
	window.document.getElementById("txt_value").value = color;
}

function setBgColor(color)
{
	window.document.getElementById("colorbox_back").style.backgroundColor = color;
	window.document.getElementById("bg_value").value = color;
}

function setBufLen(buflen)
{
	window.document.getElementById("buf_limit").value = buflen;
}

function setShowCmdState(val)
{
	window.document.getElementById("chk_showcmd").checked = val;
}

function setFontFamily(val)
{
	window.document.getElementById("font_family_value").value = val;
	// Set select on the list
	list = window.document.getElementById("fontfamily");
	for(i = 0; i < list.options.length; i++) {
		if(list.options[i].value == val) {
			list.options[i].selected = true; 
			break;
		}
	}
}

function setFontSize(val)
{
	window.document.getElementById("font_size_value").value = val;
	//remove 'pt' from the val
	i = val.indexOf('pt');
	val = val.substring(0, i);
	// Set select on the list
	list = window.document.getElementById("fontsize");
	for(i = 0; i < list.options.length; i++) {
		if(list.options[i].value == val) {
			list.options[i].selected = true; 
			break;
		}
	}
}

function colorAll(RGB)
{
	if (selectMode == 'text')
	{
	 	acon_prefs.acon_fgColor = RGB;
	 	setTextColor(RGB);
	}
	else if (selectMode == 'back')
	{
		acon_prefs.acon_bgColor = RGB;
		setBgColor(RGB);
	}
	
	// Apply to the local (preview pane) console window.
	var cnsl_doc = getConsoleDoc();
	apply_console_prefs(cnsl_doc);
}

function fontFamilyChange(val)
{
	acon_prefs.acon_font_family = val;
	window.document.getElementById("font_family_value").value = val;
	
	var cnsl_doc = getConsoleDoc();
	apply_console_prefs(cnsl_doc);
}

function fontSizeChange(val)
{
	val += "pt";
	acon_prefs.acon_font_size = val;
	window.document.getElementById("font_size_value").value = val;
	
	var cnsl_doc = getConsoleDoc();
	apply_console_prefs(cnsl_doc);
}

function showcmd_clicked(val)
{
	acon_prefs.acon_showcmd = val;
	
	var cnsl_doc = getConsoleDoc();
	apply_console_prefs(cnsl_doc);
}

var initial_acon_prefs = new Object();

function resetDefaults()
{
	var cnsl = getConsoleWin();

	// Apply to the local (preview pane) console window.
	var cnsl_doc = getConsoleDoc();
	
	clone_console_prefs(acon_prefs, initial_acon_prefs);
	
	setTextColor('FFFFFF');
	setBgColor('000000');
	
	setFontFamily('monospace');
	setFontSize('10pt');
	
	setBufLen(50);
	setShowCmdState(false);
	
	apply_console_prefs(cnsl_doc);
}

function store_console_cookie()
{
	// The cookie format is: "fnjsconsole=version&fgColor&bgColor&hist_len&
	//    &font_family&font_size&cons_buf_size&show_command;" 
	//
	// '=' and ';' are the delimiters used by HTML.
	// '&' is our own delimiter for individual fields.
	
	// It will only be accessed by /system/jsconsole, /system/status,
	// and /system/consolecustomize, hence path=/system.
	// An alternate design would be to let the consoleframe call the
	// function by itself.
	
	// Set expiry date to 2 years from now. We have to set an expiry or else
	// the cookie will be deleted when the browser session ends.
	
	// Once we release the feature, try to keep the cookie format backwards compatible
	// by only adding fields at the end.
	
	var cookie_version = 1;
  
	try
	{
		// The feature to persistently store the preferences in a cookie was cancelled.
		// But we still use the cookie to apply the changes for this session when they
		// are changed. So don't use the expire date & just make this a session cookie.
		var expireDate = new Date();
		expireDate.setTime(expireDate.getTime() + (365 * 24 * 3600 * 1000));

		var str = "fnjsconsole=" + cookie_version + "&"
			+ acon_prefs.acon_fgColor + "&"
			+ acon_prefs.acon_bgColor + "&" 
			+ acon_prefs.acon_histbuflen + "&"
			+ acon_prefs.acon_font_family + "&"
			+ acon_prefs.acon_font_size + "&"
			+ acon_prefs.acon_consbuflen + "&" 
			+ (acon_prefs.acon_showcmd ? "1" : "0")
//			+ "; expires=" + expireDate.toGMTString()
			+ "; path=/system";
			
		document.cookie = str;
	}
	catch (e)
	{
		debug_msg("failed to save cookie");
		alert(alert_strings_obj.cookie_save_failed + e);
	}
}


// customize_page_startit - startup function for the customize page.
function customize_page_startit()
{
	// Suppress redrawing the window while we resize it (not sure 
	// if this actually does anything).
	try
	{
		// IE only.
		window.offscreenBuffering = true;
	}
	catch (e)
	{
	}
	
	// Resize the window to match the size of the contents.
	auto_resize_popup();

	conscustpg_finish_initialization();
}


// conscustpg_finish_initialization - delayed initialization routines.
function conscustpg_finish_initialization()
{
	// Since we add a div & resize the page after loading, the window may
	// not be fully loaded now (specifically the console document). So we
	// may have to retry this function several times before it works.
	if (!test_window_loaded())
	{
		setTimeout("conscustpg_finish_initialization()", 10);
		return;
	}

	// Must call the original startit, since we are overriding the window's existing 
	// onload handler rather than adding an extra one.
// (Shouldn't be necessary now that we use addEvent.)
//	startit();
	
	// Override the global default preferences with the CMDB user preferences.
	// Save a backup of the original prefs first (for use by reset_default);
	clone_console_prefs(initial_acon_prefs, acon_prefs);
	override_default_console_prefs();
	
	try
	{
		// If a cookie exists, override the CMDB user preferences with the cookie
		// preferences.
		parse_console_cookie();
		
		var cnsl_doc = getConsoleDoc();
	
		// Apply changes to the preview window.
		apply_console_prefs(cnsl_doc);

		// Apply changes to the various control elements.
		setTextColor(acon_prefs.acon_fgColor);
		setBgColor(acon_prefs.acon_bgColor);
		
		setFontFamily(acon_prefs.acon_font_family);
		setFontSize(acon_prefs.acon_font_size);
		
		setBufLen(acon_prefs.acon_consbuflen);
		setShowCmdState(acon_prefs.acon_showcmd);

		add_sample_items();
		chooserModeChange('back');
	}
	catch (e)
	{
		alert(alert_strings_obj.page_init_failed + " " + e);
	}
	
	debug_msg("initialization complete");
}

// Change the color and font properties on console
function apply_changes(opener_hdl)
{
	try {
		cnsl_doc = opener_hdl.frames.console_iframe.document;
		if(cnsl_doc) {
			apply_console_prefs(cnsl_doc);
		}
	}
	catch (e)
	{
		alert(alert_strings_obj.setting_failed);
	}
}

// Change the max buffer size on console
function click_cnsl_setting_changed(opener_hdl)
{
	try {
		var oElem = opener_hdl.document.getElementById('cnsl_setting_changed');
		if(oElem)
			oElem.click();
	}
	catch (e)
	{}
}

// apply_changes_locally - apply the changes to the other GUI windows.
function apply_changes_locally()
{
	try
	{
		// Apply the changes to the parent's console window.
		var opener_hdl = window.opener;
		if(opener_hdl) {
			// click_cnsl_setting_changed will call apply_changes, so it doesn't
			// seem necessary for us to do it as well.
			//modified by lk, in Fortiweb case call the apply_changes() is OK and call click_cnsl_setting_changed() will throw except cause the changing not take effect
			apply_changes(opener_hdl);
//			click_cnsl_setting_changed(opener_hdl);

			// If we are called from the popup, maybe we can even get the console
			// on the dashboard page as well.
			opener_hdl = opener_hdl.opener;
			if(opener_hdl) {
				apply_changes(opener_hdl);
//				click_cnsl_setting_changed(opener_hdl);
			}
		}
			
	}
	catch (e)
	{
		// We expect to hit this exception quite frequently, since neither
		// of the above windows is guaranteed to still exist.
	}
}

// end_dialog - called when the ok button is clicked. (not cancel)
function end_dialog()
{
	// TODO: it would be nice to trap the change event instead, and then put a
	// variable size scrollbar on the side of the window.
	acon_prefs.acon_consbuflen = window.document.getElementById("buf_limit").value;
	acon_prefs.acon_showcmd = 
		window.document.getElementById("chk_showcmd").checked?true:false;
		
	// Note that we currently always save the settings in the cookie, even if we are
	// saving to the server as well. This is potentially not what we really want,
	// however changing it may cause some tricky side-effects.
	// (e.g. this cookie will be used by click_cnsl_setting_changed when we call
	// apply_changes_locally().)
	store_console_cookie();
	
	apply_changes_locally();
	
	// Currently we are alway returning true to submit the page to the server. If the
	// user doesn't choose to apply the changes to the CMDB, the server will just ignore
	// the request. It's not really what I intended to do here, but it works okay.
	
	// (It would still be nicer just to return false and close the window here. We could
	// do that... it's just not tested.)
}

function on_customize_beforeunload()
{
	try {
		// Assign window handle hPopupCustomize in logo to null
		var popup_hdl = window.opener;
		if(!popup_hdl) return;
		set_console_window_focus(popup_hdl);
		if(popup_hdl.opener)
			popup_hdl = popup_hdl.opener;
		popup_hdl.top.window.hPopupCustomize = null;
	}
	catch (e)
	{}
}
