/******************************
 Javascript Console
 Init by A. Krywaniuk, Jan 2006
 Copyright Fortinet, inc.
 All rights reserved
 ******************************/

// STRIP-FUNCTION: debug_msg
// STRIP-FUNCTION: debug_kbd
 
// EXPORT_SYMBOL on_connect_clicked
// EXPORT_SYMBOL on_disconnect_clicked
// EXPORT_SYMBOL acon_tx_buffer()


/******************************
      Ajax IO functions
 ******************************/

var glob_outbuf = "";

var tx_loop_timer = null;
var rx_loop_timer = null;

var acon_connecting = false;
var acon_disconnecting = false;
var acon_tx_success = false;

// Throttling counter.
var rx_since_last_tx = 0;


// on_acon_tx_done - called when the Ajax tx is complete.
function on_acon_tx_done()
{
//debug_msg("on_acon_tx_done");

	var reply_txt = this.xmlhttp.responseText;

	if(this.xmlhttp.status != 200)
	{
		this.cleanup();
		handler_disconnect_event(connection_lost);
		return;
	}

	this.cleanup();

	// In case anyone is listening, notify them of the successful transaction
	if (acon_connecting)
	{
		acon_tx_success = true;
		handle_connection_result(reply_txt);
	}
	else if (acon_disconnecting)
	{
debug_msg("Handle successful disconnect.");
		acon_tx_success = true;
		handle_disconnect_event(connection_lost);
	}
}


// acon_tx_buffer - transmit the global buffer.
// Returns 0 if the call did nothing, 1 if the request was sent, and 2 if the 
// object is busy and you should retry later.
function acon_tx_buffer()
{
//debug_msg(" acon_tx_buffer ");
	// Check & set the semaphore/watchdog.
	if (acon_tx.in_progress)
		return 2;
	
	acon_tx.set_watchdog();

	// Choose the command action and URL format based on our current state.
	var str_body;
	if (acon_connecting)
	{
		str_body = "act=connect";
	}
	else if (acon_disconnecting)
	{
		str_body = "act=disconnect&sid=" + console_session_id;
	}
	else if (glob_outbuf.length > 0)
	{
		str_body = "act=xmit&sid=" + console_session_id + "&cmd=" + encodeURIComponent(glob_outbuf);
	}
	else
	{
		// If the buffer is empty, just send a keepalive.
//debug_msg("Send keepalive packet");
		str_body = "act=keepalive&sid=" + console_session_id;
	}

	/* for csrf token */
	str_body += '&session_id='+session_id;

	var xml_obj = get_xmlhttp();
	acon_tx.xmlhttp = xml_obj;
	
	// Not sure if the line below actually does anything (fails on IE)
//	xml_obj.async = use_async;
	
	xml_obj.onreadystatechange = acon_tx.readystatechg_fn_i;
	
	// AFAICT, string method will always be POST here.
	var str_method = ((str_body == "") ? "GET" : "POST");
	
	try
	{
		// True means to use an asynchronous connection. Always do this, since
		// blocking connections may hang the browser if they fail. 
		xml_obj.open(str_method, "/httpclirqst", true);
		
		// Set the request header to make sure the browser won't use cache content 
		xml_obj.setRequestHeader("Pragma", "no-cache");
		xml_obj.setRequestHeader("Cache-Control", "no-store, no-cache, must-revalidate");
		xml_obj.setRequestHeader("If-Modified-Since", 0);
		
		xml_obj.send(str_body);
	}
	catch (e)
	{
		acon_tx.clear_watchdog();
debug_msg("Fatal error in acon_tx_buffer()");
	}

	// DEBUG: write pending text to display textarea
	if (verbose_debug)
	{
		var outbuf = document.getElementById("txt_outbuf");
		if (outbuf) outbuf.value = glob_outbuf;
	}

	// Delay to the end of the file to reset glob_outbuf because we may
	// want to display it in the debug window above.
	glob_outbuf = "";
	
	// Reset the rx throttling counter.
	rx_since_last_tx = 0;

	return 1;
}


// acon_rx_poll - called to begin an Ajax poll.
function acon_rx_poll()
{
	// Check & set the semaphore/watchdog.
	if (acon_rx.in_progress)
	{
//debug_msg("ignore poll");
		return;
	}
		
	acon_rx.set_watchdog();
	
	var xml_obj = get_xmlhttp();
	acon_rx.xmlhttp = xml_obj;

	xml_obj.onreadystatechange = acon_rx.readystatechg_fn_i;
	
// debug_msg("acon: poll");
	try
	{
		// Use "get" instead of "post" for the polling requests.
		// Use "true" as the 2nd parameter for async.
		var str_body = "/httpclirqst?act=poll&sid=" + console_session_id;
		/* for csrf token */
		str_body += '&session_id='+session_id;
		xml_obj.open("GET", str_body, true);
		
		// Set the request header to make sure the browser won't use cache content 
		xml_obj.setRequestHeader("Pragma", "no-cache");
		xml_obj.setRequestHeader("Cache-Control", "no-store, no-cache, must-revalidate");
		xml_obj.setRequestHeader("If-Modified-Since", 0);
		
		xml_obj.send("");
	}
	catch (e)
	{
		acon_rx.clear_watchdog();
debug_msg("Fatal error in acon_rx_poll()");
	}
}


// acon_tx_loop - timer callback to send any data in the queue.
function acon_tx_loop()
{
	tx_loop_timer = null;
	
	if (!cons_connected)
		return;
		
	try
	{
		if (glob_outbuf.length > 0)
		{
			var rv = acon_tx_buffer();
			// Reset GUI idle timer when there is activity at the console.
			reset_gui_idle_timer();
			
			// If we were blocked because the acon_tx object is busy, then
			// set another timer to retry later. (No need to make this timer
			// too quick, since the user is probably typing at the same time.)
			if (rv == 2)
			{
				tx_loop_timer = setTimeout("acon_tx_loop()", 50);
				return;
			}
		}
		else
		{
			// Since glob_outbuf.length is 0, this will send a keepalive.
			acon_tx_buffer();
		}
	}
	catch (e)
	{
	}

	// We used to run this as a loop, hence the name. But now we will trigger a
	// tx whenever the user enters some data, so it is unnecessary to poll for
	// tx data here. We just set a very long timeout (30 seconds) for sending
	// keepalive packets.
	tx_loop_timer = setTimeout("acon_tx_loop()", 30000);
}


// acon_rx_loop - Make sure there is always a polling request active 
// whenever we are connected. This is important for for error recovery.
function acon_rx_loop()
{
	// Reset variables relating to the loop timer.
	if (rx_loop_timer)
	{
		clearTimeout(rx_loop_timer);
		rx_loop_timer = null;
	}
	
	// Check if we're in a state where polling is not necessary.
	if (!cons_connected || acon_disconnecting)
		return;
	
	// Run the poll.
	try
	{
		if (!acon_rx.in_progress)
			acon_rx_poll();
	}
	catch (e)
	{
	}

	// Make sure there is always another poll request pending.
	if (!rx_loop_timer)
		rx_loop_timer = setTimeout("acon_rx_loop()", 60000);
}


/******************************
    Ajax Class Implementation
 ******************************/

// acon_obj::acon_cleanup - delete the ajax objects.
function acon_cleanup()
{
	this.clear_watchdog();

	if (this.xmlhttp)
	{
		try
		{
			this.xmlhttp.abort();
			delete this.xmlhttp;
			this.xmlhttp = null;
		}
		catch (e)
		{
			debug_msg("Failed to cleanup old xmlhttp obj: " + e);
		}
	}
}

// acon_obj::acon_set_watchdog - set the watchdog timer.
function acon_set_watchdog()
{
	this.in_progress = true;
	this.timeout = setTimeout(this.watchdog_fn_i, 30000);
}
 

// acon_obj::acon_clear_watchdog - clear the watchdog timer.
function acon_clear_watchdog()
{
	this.in_progress = false;
	
	if (this.timeout)
	{
		clearTimeout(this.timeout);
		this.timeout = null;
	}
}

// acon_tx_watchdog_fn - called when the TX watchdog times out.
function acon_tx_watchdog_fn()
{
	this.cleanup();
	
	if (acon_connecting)
	{
debug_msg("Hard timeout during connect attempt.");
		handle_connection_result("");
	}
	else if (acon_disconnecting)
	{
debug_msg("Hard timeout during disconnect attempt.");
		handle_disconnect_event(connection_lost);
	}
	else
	{
debug_msg("Hard timeout during TX request.");
		handle_disconnect_event(connection_lost);
	}
}

// acon_rx_watchdog_fn - called when the RX watchdog times out.
function acon_rx_watchdog_fn()
{
	// no longer a fatal error.
//	handle_disconnect_event();
//	acon_obj.clear_watchdog();

	// Currently we have no error handling here.
	// Probably we need to retry the poll.
}

// acon_obj::acon_onreadystatechg - even filter for onreadystatechange.
function acon_onreadystatechg(ev)
{
//debug_msg("acon_onreadystatechg: state = " + this.xmlhttp.readyState);
	if (this.xmlhttp.readyState == 4) // 4 == complete
	{
		// On Mozilla, the callback will be called repeatedly w/ state 4 if
		// you try to abort() on a successful transaction (which we do, just
		// for safety's sake). So unset the event handler to avoid this bug.
		try
		{
			this.xmlhttp.onreadystatechange = null;
		}
		catch (e)
		{
			// This will fail on IE, but it doesn't matter since IE doesn't
			// exhibit the above behaviour.
		}
		
		this.buffer_ready_fn();
	}
}

// For event handlers, we couldn't set them to dynamically created functions since those
// are anonymous. libPrototype has some solution for this, although I can't figure it out.
function on_tx_readystatechg(ev)
{
	acon_tx.readystatechg_fn(ev);
}

function on_rx_readystatechg(ev)
{
	acon_rx.readystatechg_fn(ev);
}


// acon_obj::acon_obj_init - initialization function for acon_obj
function acon_obj_init()
{
	this.in_progress = false;
	this.timeout = null;
	this.xmlhttp = null;
	
	this.clear_watchdog = acon_clear_watchdog;
	this.set_watchdog = acon_set_watchdog;
	this.watchdog_fn = this.is_rx ? acon_rx_watchdog_fn : acon_tx_watchdog_fn;
	this.watchdog_fn_i = "" + this.obj_name + ".watchdog_fn();";
	this.buffer_ready_fn = this.is_rx ? on_acon_buffer_ready : on_acon_tx_done;
	this.readystatechg_fn = acon_onreadystatechg;
	this.readystatechg_fn_i = this.is_rx ? on_rx_readystatechg : on_tx_readystatechg;
	this.cleanup = acon_cleanup;	
}


// acon_obj::acon_obj_bootstrap - convert an object into an acon_obj.
function acon_obj_bootstrap(acon_obj, obj_name, is_rx)
{
	acon_obj.obj_name = obj_name;
	acon_obj.is_rx = is_rx; // default;
	
	acon_obj.init = acon_obj_init;
	acon_obj.init();
}


/* These are the global acon_obj objects and the global initialization function.
Almost everything else will be done via callbacks. 

Javascript is not as OO as Java. Basically, there is no low level class support.
It's a bit like perl. Basically we just create two objects and then bless them into 
acon_obj variables by initializing them to have the same structure. 

*/

var acon_rx = new Object();
var acon_tx = new Object();

function init_acon_objs()
{
debug_msg("init_acon_objs");
	acon_obj_bootstrap(acon_rx, "acon_rx", true);
	acon_obj_bootstrap(acon_tx, "acon_tx", false);
}


/******************************
      Connect/Disconnect
 ******************************/

var cons_connected = false;

// Session id so we can distinguish between multiple sessions w/ the same cookie.
var console_session_id = 0;

// Default string to display when the connection is lost. (For any other
// type of event, we are guaranteed to get a string from the server.)
var connection_lost = "Connection lost.";


// begin_acon_polling - called at startup and whenever we reconnect in
// order to start the Ajax threads. 
function begin_acon_polling()
{
	acon_tx.clear_watchdog();
	acon_rx.clear_watchdog();
	
	// Start the polling loop.
	acon_rx_loop();
	
	// The tx loop (to send keepalives) won't be started until we transmit
	// some data first.
}


// stop_ajax - abort and kill all pending Ajax objects. This is particularly
// necessary on IE, since they have a tendency to hang the browser.
function stop_ajax()
{
	// TODO: we didn't used to kill the watchdog timers here... any reason?
	acon_rx.cleanup();
	acon_tx.cleanup();

	// Kill the polling interval timer.
	if (rx_loop_timer)
	{
		clearTimeout(rx_loop_timer);
		rx_loop_timer = null;
	}

	// Kill the tx timer if it is active.
	if (tx_loop_timer)
	{
		clearTimeout(tx_loop_timer);
		tx_loop_timer = null;
	}
}

var con_active_icon_path = "/images/connect_active.gif";
var con_inactive_icon_path = "/images/connect_inactive.gif";
var discon_active_icon_path = "/images/disconnect_active.gif";
var discon_inactive_icon_path = "/images/disconnect_inactive.gif";

// set_connect_button_state
// param bConnected is 0 if disconnected (enable connect button),
// 1 if connected (enable disconnect button), 
// or -1 while connecting (disable both buttons).
function set_connection_button_states(bConnected)
{
	// Not sure how Boolean<->int equivalence would be handled by the
	// switch statement below, so do an explicit conversion.
	if (bConnected == true) bConnected = 1;
	if (bConnected == false) bConnected = 0;
	
	// Disable buttons during the connection attempt.
	try
	{
		var em_connect = document.getElementById("jsconn_connect_btn");
		var em_disconnect = document.getElementById("jsconn_disconnect_btn");
		
		switch (bConnected)
		{
		case -1: // connecting
			em_connect.disabled = true;
			em_connect.src = con_inactive_icon_path;
			em_disconnect.disabled = true;
			em_disconnect.src = discon_inactive_icon_path;
			break;
		case 0: // disconnected
			em_connect.disabled = false;
			em_connect.src = con_active_icon_path;
			em_disconnect.disabled = true;
			em_disconnect.src = discon_inactive_icon_path;
			break;
		case 1: // connected
			em_connect.disabled = true;
			em_connect.src = con_inactive_icon_path;
			em_disconnect.disabled = false;
			em_disconnect.src = discon_active_icon_path;
			break;
		}
	}
	catch (e)
	{
		debug_msg("failed to update button state.");
	}
}


// on_connect_clicked - called when the user presses the "connect" button.
// Also called automatically when the user opens the console page.
function on_connect_clicked()
{
debug_msg("on_connect_clicked");
	if (cons_connected)
		return;
		
	// Disable buttons during the connection attempt.
	set_connection_button_states(-1);

	// Try to connect with a simple query.
	try
	{
		// Reset the success flag so we may test it later.
		acon_connecting = true;
		acon_disconnecting = false;
		acon_tx_success = false;
		
		acon_tx_buffer();
		// Reset GUI idle timer when there is activity at the console.
		reset_gui_idle_timer();
	}
	catch (e)
	{
debug_msg("on_connect_clicked: connect failed");
		handle_connection_result("");
		
		// Will this work?
		throw(e);
	}
}


// handle_connection_result - callback when the Ajax connect either
// succeeds or fails.
function handle_connection_result(reply_txt)
{
debug_msg(" handle_connection_result ");

	// The global variable acon_tx_success is reset when we attempt the connection
	// and will be set to true if we received a reply.
	acon_connecting = false;
	
	// Check if the operation failed at the connection level. (This results in an
	// alert box rather than an inline... sort of a more alarming notification.)
	if (!acon_tx_success)
	{
		set_connection_button_states(false);
		setTimeout("alert('" + alert_strings_obj.conn_failed + "');", 1);
		return;
	}
	
	// Parse the message into status code, display text and session id (connect messages only).
	var status_code = reply_txt.charAt(0);
	var display_msg = "";
	
	var i = reply_txt.indexOf(":");
	
	if (i >= 0)
	{
		console_session_id = parseInt(reply_txt.substring(1,i));
		set_logo_text('saved_session_id', console_session_id);
		display_msg = reply_txt.substring(i+1);
	}
	else
	{
		// Shouldn't happen (invalid response from server).
		console_session_id = -1;
		display_msg = reply_txt.substring(1);
	}
	
	try
	{
		// Clear the timeout in disconnection that shows the welcome message
		if(reset_welcome_ctime) {
			clearTimeout(reset_welcome_ctime);
			reset_welcome_ctime = null;
		}
		
		var tbody = getConsoleTbody();
		
		// Finalize the last row before adding a new one (otherwise we may
		// end up with multiple cursors).
		inBuf = "";
		finalize_row(tbody, inBuf);
		
		// Add the response from the server. If we couldn't parse the reply, just add
		// some boilerplate text.
		if (display_msg.length > 0) 
		{
			append_complete_row(tbody, display_msg);
		}
		else if (status_code == '0')
		{
			append_complete_row(tbody, "(Connected.)")
		}
		else
		{
			append_complete_row(tbody, "(Connection failed.)")
		}
		
		// Add a blank line - as a matter of form, we should also initialize
		// the next partial row as well.
		append_complete_row(tbody, "")
		append_partial_row(tbody, "")
		
		set_connection_button_states((status_code == '0'));
		setTimeout("rescroll_history();", 1);
	}
	catch (e)
	{
	}
	
	if (status_code == '9')
	{
		//logout (e.g. cookie expired)
		on_close_console_logo();
		setTimeout("window.location=\"/logout\"", 50);
		return;
	}

	// Check if the server rejected the login (e.g. too many concurrent connections)
	if (status_code != '0')
	{
		return;
	}


debug_msg("Connection succeeded.");
	cons_connected = true;
	store_connection_cookie();
	update_connected_status_notifier();
	// Set the focus to the console window.
	set_console_window_focus(this);
	
	// Store the connection state in the logo frame.
	try
	{
		set_logo_checkbox('saved_cnsl_enabled', true);
		if (!window.opener)
		{
			oElem = top.document.getElementById('saved_cnsl_hist');
			oElem.value = "";
		}
	}
	catch (e)
	{
		// Failure here probably indicates that this is not the dashboard frame.
	}
	
	begin_acon_polling();
}

// handle_disconnect_event - called when the user disconnects or when
// there is a TX failure.
function handle_disconnect_event(msg)
{
	if (!cons_connected)
		return;
		
	cons_connected = false;
	set_logo_checkbox('saved_cnsl_enabled', false);
	store_connection_cookie();
	
	try
	{
		// Destroy the ajax objects.
		stop_ajax();
	}
	catch (e)
	{
debug_msg("failed to clear loop timers.");
	}
	
	// Update the buttons & cmd window
	set_connection_button_states(0);
	
	// Display "Connection lost" on GUI.
	try
	{
		var tbody = getConsoleTbody();
		finalize_row(tbody, inBuf);
		append_complete_row(tbody, "")
		append_complete_row(tbody, msg)
		append_partial_row(tbody, "")
		setTimeout("rescroll_history();", 1);
	}
	catch (e)
	{
		setTimeout("alert('"+ alert_strings_obj.conn_lost + "');", 1);
	}
	
	update_connected_status_notifier();
	
	
	// If we don't have the connect/disconnect buttons, we need to always
	// display the "click here" message. Give the user 4 seconds to read
	// any error message and then redirect to that.
	if (!acon_prefs.use_connect_btns)
	{
		reset_welcome_ctime = setTimeout("reset_welcome_text()", 4000);
	}
}


// on_disconnect_clicked - called when the user presses the disconnect
// button. We will always report the connection as lost, but we try
// to do it gracefully if possible.
function on_disconnect_clicked()
{
debug_msg("on_disconnect_clicked.");

	// If we are already connecting but haven't succeeded yet, we should
	// be able to use the watchdog to simulate a connection failure.
	// (We might also just be xmitting here.)
	if (acon_tx.in_progress)
	{
debug_msg("on_disconnect_clicked: abort current connection attempt.");
		if (acon_tx.xmlhttp)
			acon_tx.xmlhttp.abort();
		acon_tx.watchdog_fn();
		return;
	}
	
	// Store the dashboard connection state in the logo frame.
	try
	{
		if (!window.opener)
		{
			var oElem = top.document.getElementById('saved_cnsl_enabled');
			oElem.checked = false;
			
			oElem = top.document.getElementById('saved_cnsl_hist');
			oElem.value = "";
		}
	}
	catch (e)
	{
		// Failure here probably indicates that this is not the dashboard frame.
	}

	
	// Try to disconnect with a simple query.
	try
	{
		// Reset the success flag so we may test it later.
		acon_disconnecting = true;
		acon_tx_success = false;

		acon_tx_buffer();
		store_connection_cookie();
	}
	catch (e)
	{
debug_msg("on_disconnect_clicked: disconnect failed");
		handle_disconnect_event(connection_lost);
		
		// Will this work?
		throw(e);
	}
}


// update_connected_status_notifier - update the window title (or the
// widget title on the dashboard) to reflect the connection state.
function update_connected_status_notifier()
{
	var window_name = alert_strings_obj.title_name;
	var st_str = cons_connected ? 
		alert_strings_obj.connected_st : alert_strings_obj.disconnected_st;

	// Switch to an alternate message when the console is detached.
	try
	{
		if (!window.opener)
		{
			var hdr_doc = top.document;
			var oElem_d = hdr_doc.getElementById('cnsl_detached');
			
			if (oElem_d.checked)
				st_str = alert_strings_obj.detached_st;
		}
	}
	catch (e)
	{
	}

	// Now display the message on either the widget title or the window title.
	try
	{
		if (window.opener)
		{
			// For the popup console, update the title bar.
			document.title = window_name + " " + st_str;
		}
		else
		{
			// For the dashboard console, update the widget header.
			var oElem = document.getElementById("jsconn_state");
			oElem.innerHTML = st_str;
		}
	}
	catch (e)
	{
		debug_msg("Failed to update connection status bar");
	}
}

