/******************************
 Javascript Console
 Init by A. Krywaniuk, Jan 2006
 Copyright Fortinet, inc.
 All rights reserved
 ******************************/

// STRIP-FUNCTION: debug_msg
// STRIP-FUNCTION: debug_kbd

// EXPORT_SYMBOL dashboard_detach_console
// EXPORT_SYMBOL jsconsole_init
// EXPORT_SYMBOL on_call_back_clicked
// EXPORT_SYMBOL display_console_window
// EXPORT_SYMBOL on_close_console_logo

/******************************
        Initialization
 ******************************/

// These variables protect against some race conditions that used to happen when
// the initialization was called from the document.onload or window.onload handlers.
// The problems don't seem to occur now that we use the iframe's onload handler.
var jsconn_init_done = false;
var startup_tries = 0;


// test_window_loaded - check whether the window has finished loading. Basically,
// we just want to verify that essential elements and functions are accessible.
function test_window_loaded()
{
	// Tends to fail on all browsers during startup.
	try
	{
		var hist_elem = getConsoleTable();
		if (!hist_elem) return 0;
	
		// Not sure if the test below is useful.
		var xml_test = get_xmlhttp();
		if (!xml_test) return 0;
		
		delete xml_test;
		xml_test = null;

		// Cache the console document so we don't have to look it up 1000 times.
		// (This doesn't seem to work, unfortunately.)
		console_document = getConsoleDoc();
		if (!console_document) return 0;
	}
	catch (e)
	{
		return 0;
	}
	
	return 1;
}


var other_console_elems = new Array("jsconn_customize", "jsconn_popup", "cons_cmd_span");

// set_console_elems_visibility - enable/disable the 4 buttons and the console window in 
// the dashboard widget. If we are disabling the console elements then enable some alternate
// elements (a message stating that the console is detached).
function set_console_elems_visibility(open_hdl, enable)
{
	try 
	{
		var doc = open_hdl.document;
		var i, elem;
		
		// Hide or show the console iframe, and preserve the height to
		// use in the detached message.
		var orig_height = 200; // arbitrary size.
		elem = doc.getElementById("console_iframe");
		if (elem)
		{
			orig_height = elem.offsetHeight;
			elem.style.display = enable ? "" : "none";
		}
		
		// If the console iframe is hidden, show the detached message
		st = enable ? "hidden" : "visible";
		var disp = enable ? "none" : "block";
		
		elem = doc.getElementById("cons_detach_msg");
		if (elem)
		{
			if (!enable)
				elem.style.height = "" + orig_height + "px";
			elem.style.visibility = st;
			elem.style.display = disp;
		}

		// For the customize & detach buttons, these are now enabled/disabled by the D&D dashboard title
		// bar mouseover. The reason this still works is because we set the visibility to visible/hidden,
		// whereas the dashboard sets the display to block/none. So we don't stomp on each others' feet.
		var st = enable ? "visible" : "hidden";
		for (i=0; i < other_console_elems.length; i++)
		{
			elem = doc.getElementById(other_console_elems[i]);
			if (elem)
				elem.style.visibility = st;
		}
		
/*		// The connect buttons are always hidden if the use_connect_btns
		// flag is not set in the preferences.
		// Note: these buttons have been removed now.
		{
			if (!acon_prefs.use_connect_btns)
				st = "hidden";
			else
				st = "visible";
			
			doc.getElementById("jsconn_connect_btn").style.visibility = st;
			doc.getElementById("jsconn_disconnect_btn").style.visibility = st;
		}*/
	}
	catch (e)
	{
		debug_msg("Failed to set console elems visibility" + e);
	}
}


// hide_console_window - hide the console widget on the dashboard.
function hide_console_window(open_hdl)
{
	set_console_elems_visibility(open_hdl, false);
}

// show_console_window - show the console widget on the dashboard.
function show_console_window(open_hdl)
{
	set_console_elems_visibility(open_hdl, true);
}

// Set focus on console window. If the connection is on, focuses on cmd or 
// iframe according to cmd box is displayed or not. Otherwise, focuses on 
// connection button if there is the button
function set_console_window_focus(open_hdl)
{
	if(open_hdl.cons_connected) {
		if (open_hdl.acon_prefs.acon_showcmd)
			open_hdl.document.getElementById("jsconn_cmd").focus();
		else
			open_hdl.document.getElementById("console_iframe").contentWindow.focus();
	}
	else if(acon_prefs.use_connect_btns) {
		open_hdl.document.getElementById("jsconn_connect_btn").focus();
	}
	else
		return;
	
	// set in_hist_wnd to true to make cursor blink
	in_hist_wnd = true;
}

/* Part of the jsconsole_init initialization function is written as a co-routine.
 Some steps cannot be completed right away, so we keep track of what we have done
 and skip those steps when the function is called a second time. Basically, the
 independent stages are: 
 
 1. loading the preferences
 2. auto-resizing the window
 3. everything else
 
 Stage 3 is considered the general initialization routine. It is run after the
 window state has been verified, and it fails atomically.
*/

// load_prefs_done is the state flag for coroutine section 1 above.
var load_prefs_done = false;


// jsconsole_init - initialize the JS console iframe.
// Note: All the parameters to this function are currently incomplete. We ought to 
// change it to receive a single parameter, which is default_acon_prefs.
function jsconsole_init()
{
	// Many segements of the initialization depend on whether this is the dashboard console
	// or the detached console.
	var is_popup = (window.opener != null);

	// Load our preferences first (since they may affect the window layout & size)
	// We no longer want to use this semaphore in the D&D dashboard, since it would result in the
	// preferences not being reapplied after a drag.
//	if (!load_prefs_done)
	{
		override_default_console_prefs();

		try
		{
			// Override any of the global prefs values if the user has a prefs cookie from this
			// session. If two users login from the same account and both change the settings, we can
			// handle it in two ways. Either the change takes place immediately, or each user's custom
			// settings are in effect until they restart the browser.
			parse_console_cookie();

			// Apply the settings from the CMDB/cookie.
			var cnsl_doc = getConsoleDoc();
			apply_console_prefs(cnsl_doc);

		}
		catch (e)
		{
			debug_msg("Failed to load settings from cookies.");
		}
		
		load_prefs_done = true;
	}
	
	// Auto-resize the popup window. Only do this once... resizing may affect the result 
	// of test_window_loaded, so it is protected internally as a coroutine segment.
	if (is_popup)
	{
		do_auto_resize();
	}
	

	// There are some race conditions that occur during startup, so we want to make sure
	// that all the essential elements are loaded before initializing.
	// TODO: Not sure if this still happens... the code below doesn't look like it will work.
	if (!test_window_loaded())
	{
		startup_tries++;
		
		if (startup_tries < 5)
		{
			debug_msg("Window not ready... retry");
			setTimeout("jsconsole_init();", 100);
		}
		
		if (startup_tries == 5)
		{
			alert(alert_strings_obj.page_init_failed);
		}
		return;
	}

	create_console_input_shunt();
	
	init_acon_objs();
	
	init_cnsl_event_handlers();

	
	// Load our connection state & preferences.
	try
	{
		// Read the connection state from the connections cookie.
		parse_connection_cookie();
	}
	catch (e)
	{
		debug_msg("Failed to load settings from cookies.");
	}
	
	// Initialize the console frame with the saved connection & history state.
	// The implementation is different, depending on whether this is the dashboard
	// console or the detached console. (This is for historical reasons.)
	if (is_popup)
	{
		// If the dashboard console is being detached, copy the current state 
		// of the console from the opener window.
		try
		{
			var opener_hdl = window.opener;
			
			// Stop any current activity on the dashboard... otherwise we will compete.
			opener_hdl.stop_ajax();
			
			// Currently we can only be popped up from the dashboard, so we assume 
			// that we can get access to all the variables from the dashboard console.
			cons_connected = opener_hdl.cons_connected;
			console_session_id = opener_hdl.console_session_id;
			cursor_x_pos = opener_hdl.cursor_x_pos;
			inBuf = opener_hdl.inBuf;
			editline_buffer_maybe_dirty = opener_hdl.editline_buffer_maybe_dirty;
			for ( i = 0; i < opener_hdl.console_history.length; i++ ) 
				console_history.push(opener_hdl.console_history[i]);

			// Right now, we always copy the contents of the dashboard console (including the
			// "please connect" message if we are not connected.
			var openerelem = opener_hdl.getConsoleDoc().getElementById("cons_span");
			var curelem = getConsoleDoc().getElementById("cons_span");
			
			curelem.innerHTML = openerelem.innerHTML;
		}
		catch (e)
		{
			debug_msg("Failed to transfer console state.");
		}
	}
	else
	{
	    if (!jsconn_init_done) // whole page reload
		// If we are in the main window, and browsing back to the status page, try
		// to restore the saved state from the logo frame.
		try
		{
			var hdr_doc = top.document;
			var oElem_c = hdr_doc.getElementById('saved_cnsl_enabled');
			var oElem_d = hdr_doc.getElementById('cnsl_detached');
			
			// cons_connected is a local variable to say whether *this frame* is 
			// connected, so check if we are detached as well.
			cons_connected = oElem_c.checked && !oElem_d.checked;

			// 3 cases: detached, attached & connected, attached & not connected.
			if (oElem_d.checked)
			{
				hide_console_window(window);
			}
			else if (cons_connected)
			{
				cursor_x_pos = hdr_doc.getElementById('saved_cursor_pos').value;
				//inBuf = hdr_doc.getElementById('saved_inBuf').value;
				editline_buffer_maybe_dirty = 
					hdr_doc.getElementById('saved_editline_buf_dirty').checked;
				oElem = hdr_doc.getElementById('saved_session_id');
				console_session_id = oElem.value;
				oElem = hdr_doc.getElementById('saved_cnsl_hist');
				rawBuf = oElem.value;
				process_rx_buffer();
			}
			else
			{
				reset_welcome_text();
			}
		}
		catch (e)
		{
			debug_msg("Failed to load saved console state.");
		}
	    // iframe reload()
	    else {
		if (cons_connected) {
		    if (cons_span)
			getConsoleDoc().getElementById('cons_span').innerHTML = cons_span;
		    process_rx_buffer();
		}
		else
		    reset_welcome_text();
	    }
	}


	// If we are already connected, start the polling.
	if (cons_connected)
	{
		// Update the buttons & cmd window
		set_connection_button_states(1);

		begin_acon_polling();
	}
	else
		set_connection_button_states(0);

	
	// If we are detaching then update the variable in the header frame and send a message 
	// to the dashboard window so it can update its state (e.g. hide the console widget).
	if (is_popup)
	{
		// Make the opener window blank
		try
		{
			var opener_hdl = window.opener;
			
			var oElem = opener_hdl.top.document.getElementById('cnsl_detached');
			if (oElem)
				oElem.checked = true;
				
			// Click the hidden button on the opener window to send a notification message.
			var oElem = opener_hdl.document.getElementById('call_back');
			if(oElem)
				oElem.click();
			
			
			// Set the connect/disconnect button visibility.
			var st = acon_prefs.use_connect_btns ? "" : "none";
			document.getElementById("jsconn_cnct_btn_span").style.display = st;
		}
		catch (e)
		{
		}
	}

	// Setup the event handlers for closing the page.
	if (is_popup)
	{
		window.onbeforeunload = on_close_console_popup;
		window.onunload = on_close_console_final;
	}
	else
		window.onbeforeunload = on_leave_page;

	
	cursor_blink_loop();
	update_connected_status_notifier();
	
	// Set a couple of things to happen after the window is loaded - (the timeout
	// values here are arbitrary fudge values based on experimentation, and
	// may be incorrect.)
	setTimeout("rescroll_history();", 300);
	
	// If we are detached, set the input focus. (If this is on the dashboard,
	// don't presume that the user is interested in the console specifically.)
	if (is_popup)
	{
		setTimeout("set_console_window_focus(this);", 400);
	}
	
	debug_msg("Initialization succeeded.");
	jsconn_init_done = true;

	on_console_focus();
	send_one_character('\n');
}

function is_status_page(opener_hdl)
{
	if(opener_hdl.location.href.indexOf("status") == -1)
		return false;
	return true;
}

function is_logo_page(opener_hdl)
{
	var loc = opener_hdl.location.href;
	var pos = loc.indexOf("logo");
	if(pos == -1)
		return false;
	// Need to check it's a real "logo" page or "logo..." page
	if( (pos + 4) == loc.length)
		return true;
	return false;
}

// on_close_console_popup - onbeforeclose handler for the popup console.
// The current behaviour is to reattach the console to the dashboard and
// preserve the current state.
function on_close_console_popup()
{
	var opener_hdl = window.opener;
	
	// window.opener shouldn't normally be null here. If the main window is closed, we
	// would be automatically closed before it happened.
	if (!opener_hdl)
		return;
		
	try 
	{
		var isstatus = is_status_page(opener_hdl);
		if(isstatus) {
			// Since the opener page won't be reloaded here, we need to copy the innerHTML,
			// connection status, current cursor position, inBuf and console history to
			// the opener page.
			
			// Copy the resource to opener window
			var openerelem = opener_hdl.getConsoleDoc().getElementById("cons_span");
			var curelem = getConsoleDoc().getElementById("cons_span");
			openerelem.innerHTML = curelem.innerHTML;
			opener_hdl.cons_span = curelem.innerHTML; // also save history in opener for restore if iframe reload
			opener_hdl.cons_connected = cons_connected;
			opener_hdl.console_session_id = console_session_id;
			opener_hdl.cursor_x_pos = cursor_x_pos;
			opener_hdl.editline_buffer_maybe_dirty = editline_buffer_maybe_dirty;
			opener_hdl.inBuf = inBuf;
			opener_hdl.console_history.length = 0;
			for ( i = 0; i < console_history.length; i++ ) 
				opener_hdl.console_history.push(console_history[i]);
		}
		else {
			// If we mean to close the popup window when the current page is not status
			// we need to store the history, connection status, cursor position and
			// to temporary logo variables so that the status page can get all the
			// information when it's loaded next time.
			store_console_hist(opener_hdl);
			var opener_doc;
			opener_doc = opener_hdl.top.document;
			opener_doc.getElementById('saved_cnsl_enabled').checked = cons_connected;
			opener_doc.getElementById('saved_editline_buf_dirty').checked =
 				editline_buffer_maybe_dirty;
			opener_doc.getElementById('saved_cursor_pos').value = cursor_x_pos;
			opener_doc.getElementById('saved_session_id').value = console_session_id;
			//opener_doc.getElementById('saved_inBuf').value = inBuf;
		}
	}
	catch(e)
	{
	}
		
	try 
	{
		oElem = opener_hdl.top.document.getElementById('cnsl_detached');
		if(oElem)
			oElem.checked = false;
			
		// Try to click one hidden button on opener window to begin polling
		var oElem = opener_hdl.document.getElementById('call_back');
		if(oElem)
			oElem.click();
		
		// TODO: Yanna said that setting hPopupConsole = null in the logo frame is needed here
		// but not tested...
		
		// Close myself
		// TODO: this shouldn't be necessary... this function is only called in response to a close event.
		// window.close();
	}
	catch(e)
	{
	}
}


// display_console_window - bad name... actually the console window is displayed by default,
// and this function may only hide it.
function display_console_window()
{
	// If elem_d is null, that means the logo frame is not loaded... probably we refreshed
	// the frameset, so the default should be to show the console window.
	
	var elem_d = top.document.getElementById('cnsl_detached');
	
	if (elem_d && elem_d.checked)
	{
		hide_console_window(window);
	}
	else
	{
		show_console_window(window);
	}
}


// reset_welcome_text - blank out the window and set the text back to the default.
function reset_welcome_text()
{
	var tbody = getConsoleTbody();
	
	// Remove all console history.
	while (tbody.childNodes.length)
	{
		tbody.removeChild(tbody.childNodes[0]);
	}
	
	cnsl_buffer_cur_len = 0;

	
	var msg = alert_strings_obj.conn_msg;
	
	if (acon_prefs.use_connect_btns)
	{
		msg = "Click \"Connect\" to begin...";
	}
	
	// We actually want this message to be overwritten... so don't
	// add an empty row afterwards.
	append_welcome_msg(tbody, msg)
//	append_complete_row(tbody, "")
}


// Unsure whether document.onload or window.onload is the better one. They both work, and they
// both seem to be called multiple times. MS documentation says document.onload doesn't exist,
// so window.onload seems better. (Anyway, don't set this here... let the HTML file call it.)
//window.onload = custom_startit;
//document.onload = custom_startit;

// add_console_focus_listeners - watch the console window for focus/blur events
function add_console_focus_listeners()
{
	try
	{
		var xdoc = getConsoleDoc();

		if (xdoc.addEventListener)
		{
			// Mozilla case (doesn't work on IE).
			//xdoc.addEventListener("focus", on_console_focus, true);
			xdoc.addEventListener("blur", on_console_blur, true);
			xdoc.addEventListener("click", on_console_focus, true);
		}
		else
		{
			// IE case (doesn't work on Mozilla).
			xdoc.onclick = on_console_focus;
			var oFrame = document.getElementById("console_iframe");
			//oFrame.onfocus = on_console_focus;
			oFrame.onblur = on_console_blur;
		}
	}
	catch (e)
	{
		debug_msg("Failed to initialize console focus listeners.");
	}
}

// init_cnsl_event_handlers - initialize the event handlers for keyboard
// and focus events.
function init_cnsl_event_handlers()
{
debug_msg("in init_cnsl_event_handlers");

	// Watch the command window for keypresses (inexplicably, this appears to work 
	// on both IE and Mozilla)
	try
	{
		// Initialize the command edit box listeners.
		// (This component is optional.) 
		var oCmd = document.getElementById("jsconn_cmd");
		if (oCmd)
		{
			oCmd.onkeyup     = cmd_keyup;
			oCmd.onkeydown   = cmd_keydown;
			oCmd.onkeypress  = cmd_keypress;
		}
	}
	catch (e)
	{
		debug_msg("Failed to initialize keyboard event listeners.");
	}

	// Watch the console window for keypresses. The console document object automatically 
	// receives all these events when the console iframe has the focus.
	try
	{
		var xdoc = getConsoleDoc();
		xdoc.onkeypress = cons_keypress;
		xdoc.onkeydown = cons_keydown;
		xdoc.onkeyup = cons_keyup;
	
		// Most sample pages include the below code... Allegedly it does something
		// on Mozilla, although I don't see it being called.
		if (xdoc.layers)
		{
			debug_msg("Initializing captureEvents for layers");
			xdoc.captureEvents(Event.KEYDOWN);
			xdoc.captureEvents(Event.KEYPRESS);
			xdoc.captureEvents(Event.KEYUP);
		}
	}
	catch (e)
	{
		debug_msg("Failed to initialize keyboard event listeners.");
	}

	// Watch the console window for focus/blur events.
	add_console_focus_listeners();
	
	window.onresize = resize_handler;
}

/******************************
         Cleanup
 ******************************/

// ie_pause - pause function (only works on IE).
function ie_pause(numberMillis) 
{
	// This function implements a pause on IE browsers by creating a hidden modal
	// dialog. It will throw an exception on Mozilla because the showModalDialog 
	// function doesn't exist (it can be implemented by calling openDialog
	// with the modal flag, but that feature is only available to trusted scripts).
	var dialogScript = 
	   'window.setTimeout(' +
	   ' function () { window.close(); }, ' + numberMillis + ');';
	var result = 
	 window.showModalDialog(
	   'javascript:document.writeln(' +
		'"<script>' + dialogScript + '<' + '/script>")');
}

 
/* 

 The logic when the user closes the popup window is a bit tricky... 
 we would like to send a disconnect
 message before closing the window, but we won't be around to process
 the reply. That's not really important... we just want the browser to
 finish sending the message before ending the script. So we try this:
 
 1. Send the disconnect message from the onbeforeunload handler and then
 stop ajax from the onunload handler. This adds a small window of opportunity
 for the browser to finish sending the request.
 
 2. On IE, sleep for half a second to give the browser time to send
 the message. Then stop Ajax in the onunload handler.
 
 Unfortunately, the disconnect feature is fairly unreliable on Mozilla
 due to the cases mentioned above.

*/

 
// on_close_console - onbeforeunload and logout handler for the logo frame.
function on_close_console_logo()
{
	var topdoc = top.document;
	var oElem = topdoc.getElementById('saved_cnsl_enabled');
	cons_connected = oElem.checked;
	oElem = topdoc.getElementById('saved_session_id');
	console_session_id = oElem.value;
	
	if (cons_connected)
	{
		// Because logo frame never initializes the acon objects, we need to do
		// it here
		init_acon_objs();
		
		// Must set the cons_connected flag to false so the rx_loop doesn't
		// retry the poll request while we are in the process of closing.
		cons_connected = false;

		// Stop all other ajax calls before sending the disconnect event. We want 
		// to maximize the probability of the event getting through.
		try
		{
			stop_ajax();
			on_disconnect_clicked();
		}
		catch (e)
		{
		}
		
		try
		{
			// Sleep long enough to give the browser a chance to send the
			// ajax disconnect message.
			ie_pause(500);
		}
		catch (e)
		{
			// If ie_pause throws an exception, this is presumably not IE.
			// The disconnect event may not always be called before the
			// window closes.
		}
	}
}


/* 

 IE seems to have a bug where it will continue to process XML requests
 after the user has closed the window. Thus, it is imperative that we
 always cleanup any active requests before closing. (The symptom of the
 bug is that if you open the window and close it 2 times in the same
 browser session then the 3rd attempt to open the window will cause the
 browser to hang. 
 
*/


// on_close_console_final - onunload handler for the popup window.
function on_close_console_final()
{
	// On IE, it is imperative that we call stop_ajax() any time
	// the window is closed. Hopefully, the disconnect message has
	// been sent by now.
	stop_ajax();
}


// on_leave_page - onbeforeunload handler for the dashboard window.
// (Called when the user closes the window or browses to another page...
// probably to difficult for us to tell the difference, so we will
// assume they are just leaving the page. Let the logo's onbeforeunload
// callback handle the case where the user closes the whole window.)
function on_leave_page()
{
	// Kill the ajax objects in order to avoid the IE bug.
	// (But don't disconnect, since this is the dashboard console.)
	stop_ajax();

	// Store the connection state and console history in the logo frame.
	try
	{
		// If the console window is detached but the current window is not
		// on the popup one, we do nothing.
		if(is_logo_page(top)) {
			if(top.document.getElementById('cnsl_detached').checked)
				return;
		}
		
		var topdoc = top.document;
		var oElem = topdoc.getElementById('saved_cnsl_enabled');
		if(oElem) 
			oElem.checked = cons_connected;
		var oElem = topdoc.getElementById('saved_session_id');
		if(oElem) 
			oElem.value = console_session_id;
		var oElem = topdoc.getElementById('saved_editline_buf_dirty');
		if(oElem) 
			oElem.checked = editline_buffer_maybe_dirty;
			
		if (cons_connected)
		{
			store_console_hist(window);
		}
	}
	catch (e)
	{
		alert(e);
	}
}


// dashboard_detach_console - detach the console from the dashboard and display
// it in a new window.
function dashboard_detach_console()
{
	// Launch the popup window using the approximate final size.
//	var new_wnd = popup_resizable('/system/jsconsole', 'js_console', 600, 425);
	var new_wnd = popup_nonscrollable('/system/jsconsole', 'js_console', 600, 425);

	// Test: store reference to this window in the logo frame
	top.window.hPopupConsole = new_wnd;
}



// Call back function to be called in the opener window when something happens
// on the popup window.
// flag: 0 -- the consolecustomize page is called, we need to parse the cookie
//       1 -- when the detached window is attached back, we need to enable/disable
//            the connection/disconnection buttons and begin polling
function on_call_back_clicked(flag)
{
	switch(flag) {
		case 0: // the console setting is changed
			debug_msg("Notification from customize page: reload settings");
			parse_console_cookie();
			
			var cnsl_doc = getConsoleDoc();
			apply_console_prefs(cnsl_doc);
			
			// If the layout has potentially changed, then re-layout the popup window.
			if (window.opener && wnd_size_st.need_resync)
			{
				wnd_size_st.already_resized = false;
				do_auto_resize();
			}
			break;
			
		case 1: // called on both detach and re-attach.
			debug_msg("Notification from jsconsole popup: the window was attached/detached.");
		
			var oElem = top.document.getElementById('cnsl_detached');
			var is_detached = oElem.checked;
			
			// If the console is being reattached, update the button state and begin
			// the polling if we are connected.
			if (!is_detached)
			{
				// Update the buttons & cmd window
				set_connection_button_states(cons_connected);
				
				// cons_connected was copied over by the popup window's JS code during
				// reattachment.
				if (cons_connected)
					begin_acon_polling();
					
				setTimeout("rescroll_history();", 100);
			}
			
			// Show/hide the console widget elements
			if (is_detached)
			{
				hide_console_window(this);
			}
			else
			{
				show_console_window(this);
				//set_console_window_focus(this);
			}

			// Now update the connected status notifier in the widget header. 
			update_connected_status_notifier();
			
			break;
	}
}


// create_console_input_shunt - Create the console input shunt text area. Whenever the
// user focuses on the console window, divert the focus here. That way we can capture
// the input from paste events.
function create_console_input_shunt()
{
	var cnsl_doc = getConsoleDoc();
	
	var elem = cnsl_doc.createElement("textarea");
	elem.id = "cons_input_shunt";
	
	with (elem.style)
	{
		// Set the position to be at the desired initial scroll position.
		position = "absolute";
		left = 0;
		top = 0;
		
		// IE won't let us set the focus on a hidden element, so make sure the element
		// is visible but with 0 size.
		width = 0;
		height = 0;
		lineHeight = 0;
		border = "none"
	}
	
	cnsl_doc.body.appendChild(elem);
	debug_msg("Added console input shunt.");
}

// focus_on_cons_input_shunt - set the focus to the input shunt, but make sure to
// preserve the scroll position.
function focus_on_cons_input_shunt()
{
	align_shunt_to_window();
	
	// For some reason, we need to let the repositioning take effect before setting
	// the focus to the shunt.
	setTimeout("shunt_focus_part2()",1);
}

// align_shunt_to_window - place the shunt so it is in the top left of the
// visible portion of the window.
function align_shunt_to_window()
{
	var xdoc = getConsoleDoc();
	var elem = xdoc.getElementById("cons_input_shunt");
	
	var st_x = xdoc.body.scrollLeft;
	var st_y = xdoc.body.scrollTop - 1;
	
	debug_msg("set scroll height = " + st_y + ", width = " + st_x);

	with (elem.style)
	{
		// When we set the position, the browser will scroll the window to put the
		// element in view. So we need to make sure that the input shunt is always
		// at the appropriate screen location before setting the focus.
		left = "" + st_x + "px";
		top = "" + st_y + "px";
	}
}

function shunt_focus_part2()
{
	var xdoc = getConsoleDoc();
	var elem = xdoc.getElementById("cons_input_shunt");
	elem.focus();
}

