/******************************
 Javascript Console
 Init by A. Krywaniuk, Jan 2006
 Copyright Fortinet, inc.
 All rights reserved
 ******************************/

// STRIP-FUNCTION: debug_msg
// STRIP-FUNCTION: debug_kbd



/******************************
      Keyboard Events
 ******************************/

var last_keydown = 0;
var last_keypress = 0;
var cachedCtrl = false;
var cancel_keypress = false;
var key_repeat_count = 0;


// kbevent_dbg_timer - timer for update_kbevent_debugging
var kbevent_dbg_timer = null;

var reset_welcome_ctime = null;

// Judge whether there is text selection on console window
function isConsoleDocTxtSelected()
{
	try {
		// Mozilla supports window.getSelection
		var cslWin = getConsoleWin();
		if(cslWin && cslWin.getSelection) {
			if(cslWin.getSelection().toString().length > 0)
				return true;
			return false;
		}
		
		var cslDoc = getConsoleDoc();
		if(cslDoc) {
			// Mozilla also supports document.getSelection
			if(cslDoc.getSelection) {
				if(cslDoc.getSelection().length > 0)
					return true;
				return false;
			}
			// IE supports document.selection
			if(cslDoc.selection) {
				if(cslDoc.selection.createRange().text.length > 0)
					return true;
				return false;
			}
			return false;
		}
	}
	catch (e)
	{}
}

// Judge whether there is text selection on console window
function isCmdTxtSelected()
{
	try {
		// TODO: Does not work on Mozilla
		if (window.getSelection)
		{
			if(window.getSelection().toString().length > 0)
				return true;
			return false;
		}
		else if (document.getSelection)
		{
			if(document.getSelection().length > 0)
				return true;
			return false;
		}
		else if(document.selection) {
			if(document.selection.createRange().text.length > 0)
				return true;
			return false;
		}
		return false;
	}
	catch (e)
	{}
}

// update_kbevent_debugging - update the outbuf and last key debug windows.
// (only used when verbose_debug is on)
function update_kbevent_debugging()
{
	var outbuf = document.getElementById("txt_outbuf");
	if (outbuf) outbuf.value = glob_outbuf;

	// Also update "last key" debug window
	var lkelem = document.getElementById("jsconn_lastkey");
	if (lkelem) lkelem.value = last_keydown + ";" + last_keypress;
}


// trigger_acon_timers - setup a timer to transmit the buffer. Make sure there
// is an active poll request as well.
function trigger_acon_timers()
{
	if (tx_loop_timer) clearTimeout(tx_loop_timer);
	tx_loop_timer = setTimeout("acon_tx_loop()", 10);

	// As a safety measure, make sure there is an active RX and if not, 
	// then make sure it will happen quickly.
	if (!acon_rx.in_progress)
	{
		if (rx_loop_timer) clearTimeout(rx_loop_timer);
		rx_loop_timer = setTimeout("acon_rx_loop()", 10);
	}
}

// act_on_keypress - send the data and update the debug windows
function act_on_keypress()
{
//debug_msg(" act_on_keypress ");
	// This timeout determines the responsiveness vs. bandwidth tradeoff. If the
	// user types very quickly, we will batch the input and delay sending it until
	// there is an N millisecond pause.
	
	// Set a timeout to send the buffer.
	trigger_acon_timers();
}


// send_one_keypress - will add one keypress from the console into the global buffer.
function send_one_keypress(charCode)
{
	glob_outbuf += String.fromCharCode(charCode);
	act_on_keypress();
}

// send_one_character - will add one ASCII character into the global buffer.
function send_one_character(ch)
{
	glob_outbuf += ch;
	act_on_keypress();
}


var vt100_escseq_cmd = "\033["; // 033 = 27 = Esc

// send_esc_sequence - implemented as a virtual keypress.
function send_esc_sequence(ch)
{
	glob_outbuf += vt100_escseq_cmd;
	glob_outbuf += ch;
	act_on_keypress();
}


// get_cons_kbd_event - Resolve the IE/Mozilla incompatibility in accessing 
// the keyboard event object.
function get_cons_kbd_event(evt_p)
{
	if (evt_p)
	{
		// Mozilla case - event passed as a parameter.
		return evt_p;
	}
	
	// IE case - get event from window object.
	evt = getConsoleFrame().event;
	if (evt) return evt;
	
debug_msg("event is null in console key handler");
	throw("event is null in console key handler");
}


// get_cmd_kbd_event - same as get_cons_kbd_event, but uses different document object
function get_cmd_kbd_event(evt_p)
{
	if (evt_p)
	{
		// Mozilla case - event passed as a parameter.
		return evt_p;
	}
	
	// IE case - get event from window object.
	evt = window.event;
	if (evt) return evt;
	
debug_msg("event is null in command key handler");
	throw("event is null in command key handler");
}


// crack_kbd_event - Returns the keypress code associated with the event.
function crack_kbd_event(evt)
{
//debug_kbd("crack_kbd_event: which= " + evt.which + ", keyCode= " + evt.keyCode + ", charCode=" + evt.charCode);

	if (evt.which)
	{
		// Mozilla - standard case (e.g. alpha-numeric keys)
		return evt.which;
	}
	else if (evt.keyCode)
	{
		// IE - standard case (all keys)
		// Mozilla - a few special keys (esc, tab)
		return evt.keyCode;
	}
	else if (evt.charCode)
	{
		// I never saw this case happen - but found others who used it on the web.
		// Basically, on Mozilla, "charCode" is always the same as "which",
		// except that that charCode of CR is 0, while which is 13.
		return evt.charCode;
	}
	
debug_msg("No key code in keypress");
	throw("No key code in keypress");
}


/* DHTML keyboard event processing.

Keycode cracking is a bizarre and difficult chore. The keycodes correspond partially to
ASCII, but there is a lot of additional interpretation required to interpret them.

A table of ASCII codes is at www.lookuptables.com.

A-Z: 65;65 (65='A')
a-z: 65;97 (65='A', 97='a')
0-9: 48;48 (48='0')
tab: 9;9 (9=tab) - keydown only
del: 46;46 (46='.') - we translate this to ASCII DEL, which is effectively BS
ins: 45;45 (45='-') - we ignore it
home: 36;36
end: 35;35
alt: 18;18 (device control) - ignore it
sysreq: 44;44 (44=',') - ignore it
caps: 20;20 (device control) - no special handling
!@#$%^&*() [top row]: (unpredictable) - no special handling
F1-F12: 112;112 (112='p') - ignore it

Each time the user presses a key, we receive one keydown events, one (or more or zero) 
keypress events, and one key up event. Generally, it is 1-1-1, but some of the extended
keys are stolen by the OS and don't translate into a keypress. Also, if the user holds
a key down then auto-repeat kicks in and you may get multiple keypresses for one keydown.

We can detect the difference between tab & shift-tab, but there is no way to translate this
into ASCII. It would be nice to do the command iteration in reverse with shift-tab, but I
checked on the regular console and it appears to treat shift-tab just like tab as well.

Caps lock is only detected on Linux - good thing we don't need it.
SysRq is also only captured on Linux.

A few keys can only be captured in keydown: arrow keys, tab, BS, alt. 
This can even vary on a per-platform basis. For IE, PgUp, PgDown, and Del are also not
translated into keypress events, although they are on Mozilla.

*/


// cons_keydown - on_keypress handler for the console window.
function cons_keydown(evt_p) 
{
debug_kbd(" cons_keydown ");

	try
	{
		var evt = get_cons_kbd_event(evt_p);
		var key_code = crack_kbd_event(evt);
	}
	catch (e)
	{
		// Unable to handle keydown.
		debug_msg("Unable to crack console keydown");
		return true;
	}
	
	last_keydown = key_code;
	last_keypress = 0;
	key_repeat_count = 0;
	
	// Reset the cmd window's last keydown flag as well. Typing in the console
	// window should interrupt a repeated tab sequence.
	last_cmd_keydown = 0;

	// Set the editline buffer as possibly dirty, which means that we will have to
	// send the "clear line" command if the user switches to the command window.
	editline_buffer_maybe_dirty = true;
	
	// Not sure if we really need this. (I guess the user could release the
	// control key during a repeated keypress sequence.)
	cachedCtrl = evt.ctrlKey;  
  
	// If this is a special key, handle it here, since we won't necessarily
	// receive the keypress event.
	if (!handle_kd_special_key(evt, last_keydown))
	{
		cancel_keypress = true;
		return false;
	}
	
	// The standard case - handle the event in the keydown handler.
	cancel_keypress = false;
	return true ;
}

var editline_buffer_maybe_dirty = false;
// cons_keypress - on_keypress handler for the console window.
function cons_keypress(evt_p)
{
debug_kbd(" cons_keypress ");
	try
	{
		var evt = get_cons_kbd_event(evt_p);
		var key_code = crack_kbd_event(evt);
		last_keypress = key_code;
	}
	catch (e)
	{
		// Unable to handle keypress.
		// Returning true here may have some effect on event bubbling (need to check it)
		debug_msg("Unable to crack console keypress");
		return true;
	}
	
	// DEBUG: display the contents of the buffer on the GUI
	// Do this prior to possibly ignoring the keypress & returning false below.
	if (verbose_debug)
	{
		try
		{
			// No one wants to see this info when they are typing quickly.
			// Use a timeout for a) rate-limiting, and b) to give the Tx event priority.
			if (kbevent_dbg_timer) clearTimeout(kbevent_dbg_timer);
			kbevent_dbg_timer = setTimeout("update_kbevent_debugging()", 100);
		}
		catch (e)
		{
		}
	}

	// Cancel the keypress if it was handled in keydown.
	if (cancel_keypress)
	{
		key_repeat_count++;
		
		if (key_repeat_count > 1)
		{
debug_kbd("kp - repeat special keypress: " + last_keypress);
			if (handle_kd_special_key(evt, last_keydown))
			{
debug_kbd("unexpected result of repeating special keypress");
			}
		}
		else
		{
debug_kbd("kp - ignore cancelled keypress: " + last_keypress);
		}

		return false;
	}
	
	// A variety of keystrokes have the same keypress and keydown values
	if (last_keypress == last_keydown)
	{
		// F1 to F12 - ignore them
		if (last_keypress >= 112 && last_keypress <= 123)
		{
debug_kbd("kp - special Fn key case: " + last_keypress);
			return false;
		}
		
		switch (last_keypress)
		{
		case 33: // PgUp
		case 34: // PgDown
			// Return true, which will allow the event to bubble on Mozilla.
			// (IE can only capture this event in keydown, so it will be
			// bubbled there instead.)
			return true;
			
		case 44: // SysRq/Print Screen
debug_kbd("kp - ignore SysRq");
			return false;
			
		case 45: // Ins
			return false;
			
		// The next 4 should be trapped in keydown.
		case 18: // Alt
		case 35: // End
		case 36: // Home
		case 46: // Del
			debug_msg("kp - key was not trapped in keydown: " + last_keypress);
			return false;
		}
	}
	
	// Sending Ctrl characters can do various bad things, such as
	// possibly hanging the browser or generating VT sequences that
	// we haven't considered. So we only allow a few "known safe"
	// ones.
	if (cachedCtrl)
	{
		// Only consider ctrl-<Alpha char>
		// Use last keydown, which should have the uppercase version of the key.
		if (last_keydown >= 65 && last_keydown <= 90)
		{
			var ch = String.fromCharCode(last_keydown);

			switch(ch)
			{
				case 'C':
					// Our handling of Ctrl-C is schizophrenic by design. If there is some selected
					// text in the console window, we allow the OS to steal the keypress
					// (for copy & paste). Otherwise, we send it to the console. (Calling
					// send_one_keypress is unneccessary because it's already done in
					// cons_keydown.)
					if(isConsoleDocTxtSelected())
						return true;
					break;
					
				case 'V':
					// We handle Ctrl-V in handle_kd_special_key (because IE doesn't seem
					// to support it here). So no need to handle it twice.
					return true;
					
				// These are a few emacs editing commands that are known to be safe.
				case 'B':
				case 'E':
				case 'W':
					// Convert to ctrl-character.
					send_one_keypress(last_keydown - 64);
					return false;
			}
		}

		return false;
	}

	// Some sanity checks - extended ASCII (don't know how this would happen)
	if (last_keypress > 127)
		return true;
		
	send_one_keypress(last_keypress);

	return false;
}


// cons_keyup - we don't do anything important here currently.
function cons_keyup(evt)
{
// Don't reset these here... they are used for debugging.
//	last_keypress = 0;
//	last_keydown = 0;
	return true ;
}


// send_pasted_data - called when the keyboard routines detect a ctrl-v in the 
// console input shunt.
function send_pasted_data(evt)
{
debug_msg("send_pasted_data called");
	var xdoc = getConsoleDoc();
	var elem = xdoc.getElementById("cons_input_shunt");
	
	var str = elem.value;
	glob_outbuf += str;
	elem.value = "";
	
	act_on_keypress();
}

// handle_kd_special_key - handling for extended keys that can't be processed
// in the keypress handler.
function handle_kd_special_key(evt, key_code)
{
	switch (key_code)
	{
	case 8: // BS
		send_one_keypress(127); // DEL
		return false;
	
	case 9: // TAB
		// It is possible to detect shift-tab using (evt.shiftKey), but there is
		// no way to encode that in ASCII anyway.
debug_msg("kd - tab: " + last_keydown);
		send_one_keypress(last_keydown);
		return false;

	// CR - The Unix standard return character is \n, not \r so to avoid interoperability
	// problems we had better translate.
	case 13:
		send_one_character('\n');
		return false;
		
	case 18: // ALT - ignore it
debug_kbd("kd - alt: " + last_keydown);
		return false;
		
	case 38 :
debug_kbd("kd - up-arrow: " + last_keypress);
		send_esc_sequence('A') ;
		return false ;

	case 40:
		send_esc_sequence('B') ;
		return false ;

	case 39:
		send_esc_sequence('C') ;
		return false ;

	case 37:
		send_esc_sequence('D') ;
		return false ;
		
	case 35: // End
		// Ctrl-E: Emacs command to go to the end of the line.
		send_one_keypress(5);
		return false;

	case 36: // Home
		send_esc_sequence('H') ;
		return false;
			
	case 46: // Del
		// We treat this as backspace, which is the same as
		// the serial console.
		send_one_keypress(127); // ASCII DEL = 127
		return false;

	case 67: // c
		if(cachedCtrl) {// Ctrl-c
			if(isConsoleDocTxtSelected())
				return true;
			// There is nothing selected on console window, we add the 
			// cmd to global buffer
			send_one_keypress(key_code - 64);
			return false;
		}
		return true;
		
	case 85: // u
		if(cachedCtrl) {// Ctrl-u
			send_one_keypress(key_code - 64);
			return false;
		}
		return true;
		
	case 86: // v
		if(cachedCtrl)
		{
			align_shunt_to_window();
			setTimeout("send_pasted_data()",1);
			return true;
		}
		return true;

	default:
		return true;
	}
}


/* Predefined VT-100/Emacs escape sequences. */

// Clear line - used to clear the current line in case the user starts typing in
// the console window and switches to the command window later.
// Another one that works is "\033[H\013" ^[H (VT-100 home) + Ctrl-K (Emacs kill to EOL).

var vt100_clearline_cmd = "\025"; // Ctrl-U (Emacs kill full line).


/*

Most standard alphanumeric and system keys can be captured & handled in keypress,
and it is preferable to handle them there.

However, on IE, a number of the ones we are interested in, such as the arrow keys 
and TAB key can only be caught in keydown.

TAB requires special processing in the command edit window, since we need to copy the
results of the completion into the window after we receive them. Also, the CLI
processing of tab relies on internal variables, and not just the current buffer state.
So if we want to send multiple consecutive tabs, we *cannot* resend the whole
current line.

*/


// Command window tab processing state
var tab_proc_st = {
	pre_cmd : "",
	in_proc : false,
	recent_typing : false,
	stage : 1
};


var last_cmd_keydown = 0;


// cmd_keydown - keydown handler for the command window.
function cmd_keydown(evt_p)
{
//debug_msg(" cmd_keydown ");

	try
	{
		var evt = get_cmd_kbd_event(evt_p);
		var key_code = crack_kbd_event(evt);
	}
	catch (e)
	{
		// Unable to handle keypress.
		// Returning true here may have some effect on event bubbling (need to check it)
		return true;
	}
	
	var rv = false; // false if we handle the event.
	
	cachedCtrl = evt.ctrlKey;
	tab_proc_st.recent_typing = true;
	
	if(cachedCtrl && key_code == 67) { // Ctrl-c
		if(!isCmdTxtSelected())
			// Send "Ctrl-c" to the global buffer
			send_one_keypress(key_code - 64);
		return false;
	}
	else if (key_code == 38) // up arrow
	{
//debug_kbd("keydown:handle up arrow");
		var str = cmd_hist_up();
		
		if (str)
		{
//debug_kbd("up arrow - using: " + str);
			var cmd_elem = document.getElementById("jsconn_cmd")
			cmd_elem.value = str;
		}
	}
	else if (key_code == 40) // down arrow
	{
//debug_kbd("keydown:handle down arrow");
		var str = cmd_hist_down();
		var cmd_elem = document.getElementById("jsconn_cmd");
		cmd_elem.value = str;
debug_kbd("down arrow - using: " + str);
	}
	else if (key_code == 9) // TAB command completion
	{
debug_kbd("keydown:handle TAB");
		// We need to do some kind of kludgy command window fixup, so save the
		// current state of the command window & input buffer.
		var cmd_elem = document.getElementById("jsconn_cmd");
		tab_proc_st.pre_cmd = cmd_elem.value;
		tab_proc_st.stage = 1;
		tab_proc_st.recent_typing = false;
		tab_proc_st.in_proc = true;
		
		// Again, this is a little kludgy. We use buffer_cmd to trigger a TX
		// event, but then overwrite the buffer later. For consecutive tabs
		// we need a special way of handling the event since we couldn't just
		// resend the whole buffer.
		if (last_cmd_keydown == 9)
		{
			buffer_cmd(false, false);
			glob_outbuf = '\t';
		}
		else
		{
			buffer_cmd(false, false);
			glob_outbuf = vt100_clearline_cmd + glob_outbuf + '\t';
		}
	}
	else
	{
		rv = true;
	}

	// IE's way of cancelling the event.
	evt.returnValue = rv;
	
	// Setting this *after* processing the tab key.
	last_cmd_keydown = key_code;
	
	return rv;
}

// cmd_keypress - keypress handler for the command window.
function cmd_keypress(evt_p)
{
//debug_kbd(" cmd_keypress ");

	try
	{
		var evt = get_cmd_kbd_event(evt_p);
		var key_code = crack_kbd_event(evt);
	}
	catch (e)
	{
		// Unable to handle keypress.
		// Returning true here may have some effect on event bubbling (need to check it)
		return true;
	}
	
	var rv = false; // false if we handle the event.
	
	if (key_code == 13) // CR
	{
debug_kbd("keydown:handle CR");
		if(editline_buffer_maybe_dirty)
			glob_outbuf += vt100_clearline_cmd;
		buffer_cmd(true, true);
	}
	else if (key_code == 63) // ? command completion
	{
debug_kbd("keydown:handle ?");
		buffer_cmd(false, false);
		glob_outbuf = vt100_clearline_cmd + glob_outbuf + '?';
	}
	else if (key_code == 9) // TAB command completion
	{
		// On Mozilla, this will still be called, even if we try
		// to cancel the event in cmd_keydown. We need to cancel
		// it again here (this is specific to old Mozilla, not Firefox).
	}
	else
	{
		rv = true;
	}

	// IE's way of cancelling the event.
	evt.returnValue = rv;
	
	return rv;
}


// cmd_keyup - not really needed.
function cmd_keyup(evt_p)
{
//debug_kbd("cmd_keyup");
}


var saved_glob_outbuf;

// buffer_cmd - Add the contents of the command window to the global
// buffer and trigger a send event. In some cases, we are doing ? or
// tab completion, so we don't want to add the CR and reset the
// command window afterwards.
function buffer_cmd(add_cr, clear_line)
{
	var cmd_elem = document.getElementById("jsconn_cmd");
	var new_str = cmd_elem.value;
	
	// Preserve anything remaining in the buffer if the console is
	// connected. Otherwise, just overwrite it.
	if (cons_connected)
	{
		glob_outbuf += new_str;
	}
	else
	{
		glob_outbuf = new_str;
	}
	
	
	// Clear the edit box when sending the text (differs between tab 
	// completion and regular cases).
	if (clear_line)
	{
		cmd_elem.value = "";
	}
	
	// CR-terminate the line (also differs w/ tab completion).
	if (add_cr)
	{
		add_to_cmd_history(new_str);
		glob_outbuf += "\n";
		editline_buffer_maybe_dirty = false;
	}
	else
	{
		// We are transmitting a partial command (e.g. command completion), which
		// means that the edit buffer will now be dirty.
		editline_buffer_maybe_dirty = true;
	}
	
	
	// DEBUG: resync the debug buffer display
	if (verbose_debug)
	{
		var outbuf = document.getElementById("txt_outbuf");
		if (outbuf) outbuf.value = glob_outbuf;
	}
	
	
	// If the console is connected, just send the buffer. If we are not
	// connected, delay sending the buffer for 1 second (a bit of a
	// kludge, but good enough for this case).
	if (cons_connected)
	{
		// Set a timer to send the buffer.
		trigger_acon_timers();
	}
	else
	{
		// Save the glob_outbuf, since tx_buffer will clear it during the connection
		// attempt.
		saved_glob_outbuf = glob_outbuf;
		
		// Connect, and then send the command.
		on_connect_clicked();
		
		// Blindly waiting for 1 second isn't ideal, but it solves the general problem.
		setTimeout("send_delayed_cmd();", 1000);
		
	}
}


// send_delayed_cmd - wait until the console is connected, then send a command.
function send_delayed_cmd()
{
	// Make sure the connection completed.
	if (!cons_connected)
		return;
		
	// Sanity check: make sure the user isn't typing right now.
	if (glob_outbuf.length > 0)
		return;
	
	// Clear the current line before sending.
	glob_outbuf = vt100_clearline_cmd + saved_glob_outbuf;
	saved_glob_outbuf = "";
	
	trigger_acon_timers();
}


// buffer_and_submit - called when the "go" button is clicked. Not currently used.
function buffer_and_submit()
{
	buffer_cmd(true, true);
}

