/******************************
 wij_logger.js - centralized logging module.
 Init by A. Krywaniuk, Mar 2008
 GUI widgetization project
 Copyright Fortinet, inc.
 All rights reserved
 ******************************/


// TODO: temporary debug logger (this one goes to the Firebug console)
var clogger = {
    enabled : false,
    debug : function(msg)
    {
        if (this.enabled)
        {
            if (window.console)
                window.console.log(msg);
        }
    }
};


// tlogger - like clogger, but disabled by default.
// turn it on for brief periods during debugging.
var tlogger = {};
jQuery.extend(tlogger, clogger);
tlogger.enabled = false;


// qlogger - debug logger to output a string directly to the navbar.
var qlogger = {
    enabled : false,
    debug : function(str)
    {
        if (!this.enabled) return;

        var nv_logger = top.mainnav.document.getElementById("nv_logger");
        if (nv_logger)
        {
            nv_logger.innerHTML = str;
            nv_logger.style.display = "";
        }
    }
}

var mlogger = {
    enabled : false,
    logger_obj : null,
    debug : function(msg)
    {
        if (!this.enabled)
            return;
        if (!this.logger_obj)
            this.enable();
        if (!this.logger_obj)
            return;

        this.logger_obj.debug(msg);
    },
    enable : function()
    {
        this.enabled = true;
        // Set the desired output target:
        this.logger_obj = top.alogger_obj;
//        this.logger_obj = top.frames.mainnav.mlogger_obj;
        if (!this.logger_obj)
            return;
        this.logger_obj.enabled = true;
    }
}

/*var mlogger = {
    enabled : false,
    mlogger_obj : null,
    debug : function(msg)
    {
        if (this.enabled)
        {
            var mlogger_obj = top.frames.mainnav.mlogger_obj;
        }
    },
    enable : function()
    {
        var obj = top.frames.mainnav.mlogger_obj;
        if (!obj.DEBUG_ENABLED)
        {
            top.frames.mainnav.setup_logger_div();
        }
        this.mlogger_obj = obj;
    }
}*/

var mLogger = mlogger; // frequent typo



/******************************
 wij_dragdrop_core.js - Core drag & drop code for navbar, subnav,
    & icontainer frames.
 Init by A. Krywaniuk, Jan 2008 (extracted from dashboard.js & customized)
 GUI widgetization project
 Copyright Fortinet, inc.
 All rights reserved
 ******************************/

// EXPORT_SYMBOL findPosX
// EXPORT_SYMBOL findPosY

/* Functions from Util.js: */
// EXPORT_SYMBOL is_left_button_event

/* Variables conflicting with HTML element ids: */
// EXPORT_SYMBOL moduleGhost


/******************************
    Logging
******************************/


// ddlogger - drag & drop logger (output to navbar frame)
var ddlogger =
{
    enabled : false,
    output_doc : null,

    enable : function()
    {
        output_doc = top.frames.mainnav.document;
        var dv = output_doc.getElementById("nv_testarea");
        dv.style.display = "";
        this.enabled = true;
    },

    set_mousemove_loc : function(frm, ev_x, ev_y, calc_x, calc_y)
    {
        if (!this.enabled) return;
        var spn = output_doc.getElementById("nvd_mm_loc");
        spn.innerHTML = (frm ? "iframe" : "main");

        spn = output_doc.getElementById("nvd_mm_loc_coords");
        spn.innerHTML = ev_x + "," + ev_y;

        spn = output_doc.getElementById("nvd_mm_real_coords");
        spn.innerHTML = calc_x + "," + calc_y;
    },

    set_start_pos : function(dv, ev_x, ev_y)
    {
        if (!this.enabled) return;
        spn = output_doc.getElementById("nvd_start_pos");
        spn.innerHTML = ev_x + "," + ev_y;
    },

    set_click_offset : function(dv, ev_x, ev_y)
    {
        if (!this.enabled) return;
        var spn = output_doc.getElementById("nvd_clk_div");
        spn.innerHTML = dv.id;

        spn = output_doc.getElementById("nvd_clk_offset");
        spn.innerHTML = ev_x + "," + ev_y;
    },

    set_in_drag : function(bInProgress)
    {
        if (!this.enabled) return;
        var spn = output_doc.getElementById("nvd_in_drag");
        spn.innerHTML = (bInProgress ? "yes" : "no");
    }
};


/******************************
    Global definitions
******************************/

// moduleGhost - global ghost div object that is used for all drag & drop operations.
// The id "moduleGhost" is important, since it has some style rules associated with it.
var moduleGhost = document.createElement("div");
moduleGhost.id = "moduleGhost";


/******************************
    Utility functions
******************************/

// findPosX - find an object's X position while dragging.
// This is basically just a more optimized version of the
// expression "Position.positionedOffset(obj)[0]".
function findPosX(obj)
{
    // TODO: this was obviously left in here by accident. Should we just
    // switch to using the generic function?
    return Position.positionedOffset(obj)[0];

	var curleft = 0;
	if (obj && obj.offsetParent) {
		while (obj.offsetParent) {
			curleft += obj.offsetLeft;
			obj = obj.offsetParent;
		}
	} else if (obj && obj.x) curleft += obj.x;
	return curleft;
}

// findPosY - find an object's Y position while dragging.
// This is basically just a more optimized version of the
// expression "Position.positionedOffset(obj)[1]".
function findPosY(obj)
{
	var curtop = 0;
	if (obj && obj.offsetParent) {
		while (obj.offsetParent) {
			curtop += obj.offsetTop;
			obj = obj.offsetParent;
		}
	} else if (obj && obj.y) curtop += obj.y;
	return curtop;
}

// insertAfter - JavaScript doesn't have an element.insertAfter function for
// some reason, so create our own.
function insertAfter(parent, node, referenceNode)
{
    parent.insertBefore(node, referenceNode.nextSibling);
}


/******************************
    Drag & Drop class
******************************/

// Parameters to control Drag & Drop behaviour.
// (set on a per-page basis)
var drag_x_only = false;
var drag_y_only = false;


// Drag class - adapted from the original dashboard.js module
// NOTE: Rather than applying the incremental mouse offsets, this new
// solution stores the offset of the click position within the drag handle
// and then adjusts the element position to just track the mouse cursor.
var Drag =
{
    obj: null,
    clickTimeout: null,

    // NOTE: there used to be a case here where the init function could also
    // take a 3rd parameter (event), which would allow the drag object to
    // be initialized and then immediately start a drag event in the same
    // operation. I don't think we need to support that.
    init: function(dv_handle, dv_elem)
    {
        // TODO: can we use a less generic name than "root"?
        dv_handle.root = dv_elem;

        // Make sure the element has a valid starting position.
        // (Probably not very necessary.)
        if (isNaN(parseInt(dv_elem.style.left))) dv_elem.style.left="0px";
        if (isNaN(parseInt(dv_elem.style.top))) dv_elem.style.top="0px";

        dv_handle.onmousedown = Drag.start;

        // These callbacks need to be provided by the caller. I guess we just
        // initialize them here as placeholders?
        dv_elem.onDragStart = new Function();
        dv_elem.onDragEnd = new Function();
        dv_elem.onDrag = new Function();

/*	
			if (ee ==null) {
				a.onmousedown=Drag.start;
			}
*/
/*			if (ee !=null) {
				var b=Drag.obj=a;
				ee=Drag.fixE(ee);
				var c=parseInt(b.root.style.top);
				var d=parseInt(b.root.style.left);
				b.root.onDragStart(d,c,ee.clientX,ee.clientY);
				b.lastMouseX=ee.clientX;
				b.lastMouseY=ee.clientY;
				document.onmousemove=Drag.drag;
				document.onmouseup=Drag.end;
			}*/
			
    },

    // Drag.start
    start: function(ev)
    {
        ev = Drag.fixE(ev);
        if (!is_left_button_event(ev)) return false;

        var dv_handle = this;

        // What if we are already dragging?
        if (Drag.obj)
        {
            // If we were previously dragging the same item then it was probably just
            // a glitch related to the user leaving & re-entering the frame. Let's
            // continue the operation and hope it works.
            if (Drag.obj == dv_handle)
                return false;

            // Finish the old drag operation and begin a new one.
            // TODO: is it better to end it or cancel it?
            Drag.end_drag();
        }

        Drag.obj = dv_handle;
        dv_elem = dv_handle.root;

        dv_handle.lastMouseX = ev.clientX;
        dv_handle.lastMouseY = ev.clientY;

        // Get the initial position of the element's drag handle within the main frame window.
        // (Use Position.page() rather than cumulativeOffset() in order to neglect
        // the scroll position.)
        var pos = Position.page(dv_elem);
        //var pos = Position.cumulativeOffset(b.root);
        //var pos = Position.realOffset(b.root);

        // Convert the mouse click coordinates to be relative to the element (not the drag handle).
        var offset_x = ev.clientX - pos[0];
        var offset_y = ev.clientY - pos[1];

        dv_handle.clickOffsetX = offset_x;
        dv_handle.clickOffsetY = offset_y;

        // Update the logger, if we are using that.
        // TODO: disable in production build.
        ddlogger.set_start_pos(dv_handle, pos[0], pos[1]);
        ddlogger.set_click_offset(dv_handle, dv_handle.clickOffsetX, dv_handle.clickOffsetY);

        // To distinguish between a drag and a mere mouse click, wait until the user either
        // holds down the mouse button for a few milliseconds or moves the mouse beyond a
        // certain threshhold.
        document.onmousemove = Drag.checkdragcondition;
        document.onmouseup = Drag.cancelpending;

        var drag_threshold_tm = 250;
        Drag.clickTimeout = setTimeout(Drag.realstart, drag_threshold_tm);

        return false;
    },

    cancelpending: function()
        {
            Drag.obj = null;

            if (Drag.clickTimeout)
            {
                clearTimeout(Drag.clickTimeout);
                Drag.clickTimeout = null;

                document.onmousemove=null;
                document.onmouseup=null;
            }
        },

    checkdragcondition: function(a)
    {
        var b=Drag.obj;
        a=Drag.fixE(a);

        // If the mouse has moved more than N pixels, cancel
        // the timeout and start the drag right away.
        var drag_threshold_xy = 10;
        var distX = Math.abs(b.lastMouseX - a.clientX);
        var distY = Math.abs(b.lastMouseY - a.clientY);

        if (distX + distY > drag_threshold_xy)
        {
            // Cancelpending will remove the current drag obj,
            // so restore the saved one.
            Drag.cancelpending();
            Drag.obj = b;
            Drag.realstart();
        }
    },

    realstart : function()
    {
        if (Drag.clickTimeout)
            Drag.clickTimeout = null;

        var b=Drag.obj;
        var c=parseInt(b.root.style.top);
        var d=parseInt(b.root.style.left);
        b.root.onDragStart(d, c, b.lastMouseX, b.lastMouseY);

        document.onmousemove=Drag.drag;
        document.onmouseup=Drag.end;
        ddlogger.set_in_drag(true);
    },

    // Drag.drag
    drag: function(a)
    {
        a=Drag.fixE(a);
        var b=Drag.obj;
        var c=a.clientY;
        var d=a.clientX;
        var e=parseInt(b.root.style.top);
        var f=parseInt(b.root.style.left);
        var h,g;
        h=f+d-b.lastMouseX;
        g=e+c-b.lastMouseY;
        b.lastMouseX=d;
        b.lastMouseY=c;


        // Get the current position of the element excluding scrolling.
        var elem = b.root;
        var pos = Position.page(elem);

        // Now calculate the same offsets that we previously stored in clickOffsetX/Y.
        // If the element hasn't moved, these would give the same result.
        var offset_x = a.clientX - pos[0];
        var offset_y = a.clientY - pos[1];

        var cx = offset_x - b.clickOffsetX;
        var cy = offset_y - b.clickOffsetY;

        // Now adjust the position of the element by the differential of these offsets.
        if (!drag_y_only) elem.style.left = (elem.offsetLeft + cx) + "px";
        if (!drag_x_only) elem.style.top = (elem.offsetTop + cy) + "px";


        // When forwarding events from an iframe, we may use some "fake" (not built-in)
        // mouse objects.
        if (!a.is_fake)
            ddlogger.set_mousemove_loc(null, a.clientX, a.clientY, h, g);

        b.root.onDrag(h,g,a.clientX,a.clientY);

        return false;
    },

    // Drag.end - event handler for mouseup.
    end: function(ev)
    {
        ev = Drag.fixE(ev);
        if (!is_left_button_event(ev)) return false;

        Drag.end_drag();
        return true;
    },

    // Drag.end_drag - internal API to finish dragging.
    end_drag: function()
    {
        document.onmousemove=null;
        document.onmouseup=null;

        var dv_elem = Drag.obj.root;
        dv_elem.onDragEnd(parseInt(dv_elem.style.left), parseInt(dv_elem.style.top));
        Drag.obj=null;
    },


	// dragging_l2_menuitem - used in navbar frame
	dragging_l2_menuitem : function()
	{
	   var drag_obj = Drag.obj;
	   if (!drag_obj || !drag_obj.menu_ref) return false;
	   return (drag_obj.menu_ref.menu_level == 2);
	},
	
    // reset - cancel any current drag operation and reset the object state.
    reset: function()
    {
        if (Drag.obj)
        {
            // Is it necessary to do this?
            Drag.obj.root.onDragEnd(parseInt(Drag.obj.root.style.left),parseInt(Drag.obj.root.style.top));
            Drag.obj = null;
        }

        Drag.clickTimeout = null;
        document.onmousemove=null;
        document.onmouseup=null;

        ddlogger.set_in_drag(false);
    },
		
		
	"fixE":function(a){
			if(typeof a=="undefined")a=window.event;
			if(typeof a.layerX=="undefined")a.layerX=a.offsetX;
			if(typeof a.layerY=="undefined")a.layerY=a.offsetY;
			return a;
		}
};


// delayed_clear_dragging_flag - set a timer to clear the isDragging flag
// TODO: so far, this function is called by every D&D module. Maybe we
// should move it into the framework instead.
function delayed_clear_dragging_flag(elem)
{
    // Turn off the isDragging flag after processing any onclick events.
    // (This lets us ignore the spurious click event that normally
    // gets triggered immediately after a drag.)
    // We do this by setting an immediate pending JS timeout that will
    // occur after all system events are finished processing.
    function mk_setIsDragging_callback(obj)
    {
        return (function() {
//            clogger.debug("setIsDragging_callback"); 
            obj.isDragging = false;
        } );
    }

    var cb = mk_setIsDragging_callback(elem);
    setTimeout(cb, 1);
}




/******************************
 wij_menu_core.js - menu library with cross-frame support.
 Init by A. Krywaniuk, Feb 2008
 GUI widgetization project
 Copyright Fortinet, inc.
 All rights reserved
 ******************************/

// The API is intended to be similar to that of the YUI menu.js in
// order to give us an easier migration path.

/******************************
    Menu class
******************************/

var WIJ_ContextMenu = function(div_id, menu_params)
{
    // The following parameters may be overridden after the menu has been created:
    // ignore_y_coord, output_document, click_fn, move_fn
    this.init(div_id, menu_params);
}

WIJ_ContextMenu.prototype =
{
    div_id : null,
    element : null,
    trigger_elem_id : null, // where to listen for events (in the current frame)
    output_document : null, // in which frame to render the menu
    output_window : null,
    click_fn : null,
    move_fn : null,
    aMenuItems : [],
    menu_id_map : null,
    menu_displayed : false,
    contextEventTarget : null, // current triggering element
    right_click_triggered : false,
    ignore_y_coord: false, // used to fix the Y position of the subnav menu
    use_modal_menu : true,

    init : function(div_id_P, menu_params)
    {
        this.menu_id_map = new Object();
        this.div_id = div_id_P;
        this.trigger_elem_id = menu_params.trigger;
        this.output_window = menu_params.output_window ? menu_params.output_window : window;
        this.output_document = this.output_window.document;

        this.click_fn = menu_params.click_fn;
        this.move_fn = menu_params.move_fn;

        // Make an event listener for mousedown on the background element.
        function mk_cm_cb(oMenu) { return function(ev) { return wij_menu_on_bg_trigger(oMenu, ev); } };
        function mk_md_cb(oMenu) { return function(ev) { return wij_menu_on_bg_mousedown(oMenu, ev); } };
        function mk_mc_cb(oMenu) { return function(ev) { return wij_menu_on_bg_click(oMenu, ev); } };

        var trigger_elem = $j(this.trigger_elem_id);
        // Using "contextmenu" rather than "mousedown" allows us to suppress the browser's
        // default context menu.
        Event.observe(trigger_elem, "contextmenu", mk_cm_cb(this), false);
        Event.observe(trigger_elem, "mousedown", mk_md_cb(this), false);
        Event.observe(trigger_elem, "mouseclick", mk_mc_cb(this), false);

    },

    addItem : function(oItem)
    {
        var arr = this.aMenuItems;
        // Add the new element into the array.
        arr.push(oItem);
        // Create a reverse lookup map for the item's menu id.
        this.menu_id_map[oItem.menu_id] = arr[arr.length-1];
    },

    // render - create the HTML elements to represent the menu (though
    // not displayed to the user yet).
    render : function()
    {
        // If the document is not loaded yet then we must delay the rendering.
        if (!this.output_document.body)
            return;

        var old_dv = $j(this.div_id);
        if (old_dv)
            Element.remove(old_dv);

        var dv = this.output_document.createElement("DIV");
        dv.id = this.div_id;
        dv.className = "wij_menu";
        dv.menu_obj = this;

        // Create the HTML code.
        var aHTML = [];

        var oList = this.aMenuItems;
        var len = oList.length;

        for (var i=0; i<len; i++)
        {
            var menu_item = oList[i];

            aTpl_menu_item[1] = i;
            aTpl_menu_item[3] = menu_item.menu_name;
            aTpl_menu_item[4] = menu_item.html_extra ? menu_item.html_extra : "";

            aHTML.push(aTpl_menu_item.join(""));
        }

        dv.innerHTML = aHTML.join("");

        this.output_document.body.appendChild(dv);
        this.element = dv;

        // Fixup JS variables.
        var eList = dv.childNodes;

        for (var i=0; i<len; i++)
        {
            var menu_item = oList[i];
            var menu_elem = eList[i];

            // Make linkages based on element ids in case we want to re-render later.
            menu_item.elem_id = menu_elem.id;
            menu_elem.menu_id = menu_item.menu_id;
        }
    },

    // trigger_context_menu - initiate the display of the context menu.
    trigger_context_menu : function(x, y, elem, right_align)
    {
        var oMenu = this;

        // When some tabs are loaded in "direct render" mode instead of through the icontainer,
        // the cached output_document becomes invalid as the pages change. So, if the
        // document has been updated, we need to re-render the context menu.
        // This seems to work so far during my testing, but a timeout may need to be added
        // to ensure the elements have rendered correctly.
        if (oMenu.output_document != oMenu.output_window.document)
        {
            oMenu.output_document = oMenu.output_window.document;
            oMenu.render();
        }

        // When displaying the menu in a different frame, we don't want to use the
        // Y coordinate of the mouse event. However, we still need to account for
        // the scroll position of the target frame.
        if (oMenu.ignore_y_coord)
        {
//            y = 0;
            y = oMenu.output_document.body.scrollTop;
clogger.debug("trigger_context_menu - y=" + y);
        }

        // Handle the delayed rendering if need be.
        if (!oMenu.element)
            oMenu.render();

        // Create a background mask in the output window to make the menu modal.
        if (oMenu.use_modal_menu)
        {
            function mk_cb(oMenu) { return function() { oMenu.end_context_menu(); } };
            var cb_end = mk_cb(oMenu);

/*
            function mk_cb_scroll(oMenu) { return function() { reposition_top_aligned_menu(oMenu); } };
            var cb_scroll = (oMenu.ignore_y_coord) ? mk_cb_scroll(oMenu) : null;

            oMenu.output_window.wij_display_contextmenu_mask(cb_end, cb_scroll);
*/

            oMenu.output_window.wij_display_contextmenu_mask(cb_end, oMenu);
        }

        // Execute the callback to update the displayed menu items to
        // reflect the triggering element.
        oMenu.contextEventTarget = elem;
        oMenu.menu_displayed = true;

        // Invoke the callback to let the owner frame suppress or
        // modify some of the menu items depending on context.
        oMenu.move_fn();

        // Allow the new menu items to render off-screen so we can measure
        // the menu width prior to doing the alignment.
        var dv = oMenu.output_document.getElementById(oMenu.div_id);
        dv.style.left = "-1000" + "px";
        dv.style.top = "-1000" + "px";
        dv.style.visibility = "visible";
        dv.style.display = "";

        function mk_st_cb(oMenu,x,y,r) { return function() { return wij_align_and_display_menu(oMenu,x,y,r); } };
        var cb = mk_st_cb(oMenu,x,y,right_align);
        setTimeout(cb, 5);
    },

    // end_context_menu - end the context menu, either by selecting an
    // item or cancelling the menu.
    end_context_menu : function()
    {
        var oMenu = this;

        if (!oMenu.menu_displayed)
            return;

        var dv = oMenu.output_document.getElementById(oMenu.div_id);
        dv.style.visibility = "";
        dv.style.left = "";
        dv.style.top = "";

        oMenu.menu_displayed = false;
        oMenu.contextEventTarget = null;

        if (oMenu.use_modal_menu)
        {
            oMenu.output_window.wij_end_contextmenu_mask();
        }
    },

    // reset_all_items - suppress (hide) & reset all the menu items.
    reset_all_items : function()
    {
        var oList = this.aMenuItems;
        var len = oList.length;

        for (var i=0; i<len; i++)
        {
            var menu_item = oList[i];
            var elem = this.output_document.getElementById(menu_item.elem_id);
            elem.style.display = "none";
            elem.disabled = false;
        }
    },

    // unsuppress_items - unsuppress (show) the menu items.
    unsuppress_items : function(aItems)
    {
        var len = aItems.length;

        for (var i=0; i<len; i++)
        {
            var menu_id = aItems[i];
            var menu_item = this.menu_id_map[menu_id];
            var elem = this.output_document.getElementById(menu_item.elem_id);
            elem.style.display = "";
        }
    },

    // enable_item - enable/disable (grey out) the menu item.
    enable_item : function(menu_id, bEnabled)
    {
        var menu_item = this.menu_id_map[menu_id];
        var elem = this.output_document.getElementById(menu_item.elem_id);
        elem.disabled = !bEnabled;
        elem.style.color = bEnabled ? "" : "gray";
    }
}


// wij_align_and_display_menu - position the context menu on the screen
// and display it to the user after the offset width is known.
function wij_align_and_display_menu(oMenu, x, y, right_align)
{
    var dv = oMenu.output_document.getElementById(oMenu.div_id);
    var db = oMenu.output_document.body;

    if (right_align)
        x -= dv.offsetWidth;

    // If possible, try to fit the div entirely within the document body.
    // TODO: this doesn't account for the possibility that the document will
    // be clipped due to scrolling.
    if (x + dv.offsetWidth > db.offsetWidth)
        x = db.offsetWidth - dv.offsetWidth;
    if (x < 0)
        x = 0;
    if (y + dv.offsetHeight > db.offsetHeight)
        y = db.offsetHeight - dv.offsetHeight;
    if (y < 0)
        y = 0;

clogger.debug("x=" + x + ", y=" + y);
    dv.style.left = x + "px";
    dv.style.top = y + "px";

    dv.style.visibility = "visible";
    dv.style.display = "";
}

// wij_menu_on_bg_trigger - display the context menu when triggered by a
// right-click on the target area.
function wij_menu_on_bg_trigger(oMenu, ev)
{
    var obj = Event.element(ev);

    // We don't support recursive modal operations, so watch out...
    if (oMenu.use_modal_menu)
    {
        // This spurious event can happen if the user right-clicks on the navbar
        // frame and the oncontextmenu event falls through to the root element.
        if (InlineModal.in_modal_op)
        {
            Event.stop(ev);
            return false;
        }
    }

    // Get the mouse click position (adjusting for scrolling)
    var bd = document.documentElement;
    var x = ev.clientX + bd.scrollLeft;
    var y = ev.clientY + bd.scrollTop;

    oMenu.right_click_triggered = true;
    oMenu.trigger_context_menu(x, y, obj, false);

    Event.stop(ev);
    return false;
}

// wij_menu_on_btn_trigger - display the context menu when triggered by
// an HTML button press.
function wij_menu_on_btn_trigger(oMenu, btn, ev)
{
    if (!ev) ev = window.event;

    var pos = Position.cumulativeOffset(btn);
    var x = pos[0] + 20;
    var y = pos[1] + btn.offsetHeight;

    oMenu.right_click_triggered = false;
    oMenu.trigger_context_menu(x, y, btn.parentNode, true);

    if (ev) Event.stop(ev);
}

// wij_menu_on_bg_mousedown - handler for bg mousedown
// TODO: we don't need this w/ the modal mask & it interferes with any defined
// background menu action.
function wij_menu_on_bg_mousedown(oMenu, ev)
{
clogger.debug("wij_menu_on_bg_mousedown");
//    oMenu.end_context_menu();
}

// TODO: maybe unneeded?
function wij_menu_on_bg_click(oMenu, ev)
{
clogger.debug("wij_menu_on_bg_click");
//    oMenu.end_context_menu();

/*    if (ev.button == 2)
    {
        Event.stop(ev);
    } */
}


/******************************
    Menu item class
******************************/

var WIJ_ContextMenuItem = function(name, id)
{
    this.init(name, id);
}

WIJ_ContextMenuItem.prototype =
{
    menu_name : null, // display text for the menu
    menu_id : null, // numerical id for demultiplexing
    elem_id : null, // set after rendering
    html_extra : null, // extra HTML after the menu name.

    init : function(name, id)
    {
        this.menu_name = name;
        this.menu_id = id;
    }
}


// aTpl_menu_item - HTML StringBuffer template for context menu items.
var aTpl_menu_item = [
"<div NOWRAP id='mi_wij_",
"", // [1] = serialno
"' class='wij_menu_item' onclick='wij_menu_handle_click(this)' onmouseover='wij_menu_on_mouseover(this)' onmouseout='wij_menu_on_mouseout(this)'>",
"", // [3] = display name
"", // [4] = extra HTML
"</div>"
];


// wij_menu_append_checkmark - add a check mark after the menu item to implement an
// option w/ persistent state.
function wij_menu_append_checkmark(oMenu, menu_id)
{
    var menu_item = oMenu.menu_id_map[menu_id];
    menu_item.html_extra = "<img src='/images/check.gif'>";
}


// find_containing_menu_obj - find the global JS menu object associated
// with this menu item.
function find_containing_menu_obj(obj)
{
    while (obj)
    {
        if (obj.className && obj.className == "wij_menu")
        {
            return obj.menu_obj;
        }

        obj = obj.parentNode;
    }

    return null;
}

// wij_menu_handle_click - handle a click on a menu item and invoke
// the appropriate callback function.
function wij_menu_handle_click(obj)
{
    if (obj.disabled)
        return false;

    var oMenu = find_containing_menu_obj(obj);
    oMenu.end_context_menu();

    // Invoke the callback.
    oMenu.click_fn(obj.menu_id);
}

// wij_menu_on_mouseover - display the mouseover highlight.
function wij_menu_on_mouseover(elem)
{
    if (elem.disabled)
        return;

    elem.style.backgroundColor = "#535377"; //"darkgray";
    elem.style.color = "white";
}

// wij_menu_on_mouseout - remove the mouseover highlight.
function wij_menu_on_mouseout(elem)
{
    if (elem.disabled)
        return;

    elem.style.backgroundColor = "";
    elem.style.color = "";
}




