/******************************
 wij_icontainer.js - Basic widget layout container w/ iframe support
 Init by A. Krywaniuk, Feb 2008
 GUI widgetization project
 Copyright Fortinet, inc.
 All rights reserved
 ******************************/

/* Functions used by wij_icontainer.html: */
// EXPORT_SYMBOL init_icontainer

/* Functions used by logo.js: */
// EXPORT_SYMBOL wij_run_edit_page_dialog
// EXPORT_SYMBOL wij_add_content
// EXPORT_SYMBOL wij_enable_widget_previews

/* Functions used by wij_addcontent.html: */
// EXPORT_SYMBOL wij_end_addcontent_dialog

/* Variables used by ?: */
// EXPORT_SYMBOL ignore_mouse_event
// EXPORT_SYMBOL wij_showhide


var FF = (navigator.userAgent.indexOf("Firefox")!=-1);
var IE = window.ActiveXObject;


// Global options:

// allow_customize_std_pages - whether to allow the user to customize the
// standard L3 menu items.
var allow_customize_std_pages = false;


/* Initialization state: */

// icontainer_is_init - page loading state.
var icontainer_is_init = false;


/* State variables: */

// cur_displayed_l3_menu - which tab is currently being displayed.
var cur_displayed_l3_menu = null;

// wij_previews_enabled - reflects the state of the "Show preview" checkbox in
// the edit bar.
var wij_previews_enabled = false;


/* Constants: */

// TODO: user_defined_menu_id is duplicated from navbar.js.
var user_defined_menu_id = "user_defined";


// iframes_list - global list of iframes to monitor.
// TODO: could optimize these as maps instead of arrays?
var iframes_list = new Object();
var widget_list = [];
// iframe_widget_map - associative array of widgets containing iframes.
// TODO: probably not needed for anything, currently.
var widget_iframe_map = new Object();




/******************************
  Widget creation/initialization
******************************/

// Widget layout modes.
// (I don't normally start my enums at 0, but in this case the 1 & 2 for
// 1 & 2-column layout was too intuitive to pass up on.)
var wij_layout_single = 0;
var wij_layout_1column = 1;
var wij_layout_2column = 2;

var wij_cur_layout = wij_layout_single;

var next_widget_serialno = 1;
var next_iframe_revised_serialno = 1;

var ht_def_wb_fullscreen = "95%";
var ht_def_wb_incolumn = "120px";


// wij_nopreview_body_tpl - StringBuffer template for iframe widget contents in no preview mode.
var wij_nopreview_body_tpl = [
    '<div style="background-color:#ddeeee; height:',
    '', // [1] = ht_def
    '; vertical-align:middle"><img class="wij_nopreview_icon" style="',
    '', // [3] = pos_def (optional) + height/width (optional)
    '" label="',
    '', // [5] = show preview text
    '" src="/images/wij_nopreview.gif" onclick="wij_show_preview(this)" /></div>'
];

// gen_show_preview_html - get the HTML string for the generic dialog contents w/ no preview.
function gen_show_preview_html(layout_mode)
{
    // We could show a message here (e.g. "Show Preview" in blue), or we can show a generic icon that looks
    // vaguely like a dialog box...

    // In full page mode, we try to put the icon in the middle of the screen, whereas
    // in widget mode we align it to the center of the widget.
    var pos_def = (layout_mode == wij_layout_single && have_position_fixed) ? "position:fixed;" : "position:absolute;";
    // We also need to change the widget body from full screen (95%) to fixed (120px).
    var ht_def = (layout_mode == wij_layout_single) ? ht_def_wb_fullscreen : ht_def_wb_incolumn;
    // icon_scaling - we want to make the central icon look bigger in full screen mode.
    // (default dimensions are 65x52)
    var icon_scaling = (layout_mode == wij_layout_single) ? "width:98px; height:78px;" : "";

    var aHTML = wij_nopreview_body_tpl;
    aHTML[1] = ht_def;
    aHTML[3] = pos_def + icon_scaling;
    aHTML[5] = wij_string("show_preview");

    return aHTML.join("");
}


// wij_preview_unanavailable_body_tpl - StringBuffer template for iframe widget contents in no preview mode.
var wij_preview_unanavailable_body_tpl = [
    '<div style="background-color:#ddeeee; height:',
    '', // [1] = ht_def
    '; vertical-align:middle"><div class="wij_previewmask_label" style="top:48%; left:45%; ',
    '', // [3] = pos_def (optional)
    '">',
    '', // [5] = no preview text
    '</div>'
];

// gen_preview_unavailable_html - get the HTML string for the "Preview not available" message.
// (We display this when viewing a direct_load widget in edit mode.)
function gen_preview_unavailable_html()
{
    // In full page mode, we try to put the icon in the middle of the screen, whereas
    // in widget mode we align it to the center of the widget.
    var pos_def = have_position_fixed ? "position:fixed;" : "position:absolute;";

    var aHTML = wij_preview_unanavailable_body_tpl;
    aHTML[1] = ht_def_wb_fullscreen;
    aHTML[3] = pos_def;
    aHTML[5] = wij_string("preview_unavailable");

    return aHTML.join("");
}


// wij_preview_body_overlay_tpl - StringBuffer template for iframe mask div & label overlay in preview mode.
// TODO: put this stuff in the CSS definition
var wij_preview_body_overlay_tpl = [
    '<div class="wij_previewmask ',
    '', // [1] = 2nd class name
    '">&nbsp;</div><div class="wij_previewmask_label" style="',
    '', // [3] = pos_def
    'top:48%; left:45%;" onclick="wij_hide_preview(this)">',
    '', // [5] = hide preview text
    '</div>'
];

// gen_hide_preview_html - get the HTML string for the hide preview button.
// (We also include the translucent mask div.)
function gen_hide_preview_html(layout_mode)
{
    // In full page mode, we try to put the label in the middle of the screen, whereas
    // in widget mode we align it to the center of the widget.
    var pos_def = (layout_mode == wij_layout_single && have_position_fixed) ? "position:fixed;" : "position:absolute;";

    var aHTML = wij_preview_body_overlay_tpl;
    // The 2nd class fixes the height of the preview mask on IE6.
    aHTML[1] = (IE6) ? "wij_previewmask_ie6" : "wij_previewmask_normal";
    aHTML[3] = pos_def;
    aHTML[5] = wij_string("hide_preview");

    return aHTML.join("");

/*    // TODO: this is looking a lot like our existing inline modal dialog class, with all the usual
    // problems of measuring size that is > the window height.
    var hide_preview_txt = "Hide Preview";
    var hide_preview_html1 = '<div class="wij_previewmask">&nbsp;</div><div class="wij_previewmask_label" style="'
    var hide_preview_html2 = 'top:48%; left:45%; cursor:pointer; z-index:501; color:darkred; background-color:yellow; padding:2px; padding-left:6px; padding-right:6px" onclick="wij_hide_preview(this)">' + hide_preview_txt + '</div>';


    var html_str = hide_preview_html1 + pos_def + hide_preview_html2;
    return html_str;
*/
}


// wij_html_tpl - StringBuffer template for iframe widgets.
var wij_html_tpl = [
    '<div id="',
    '', // [1] = hdr_id
    '" class="module_header" style="',
    '', // [3] = title_style
    '">',
    // [5] = right button array - close & edit buttons (edit mode only)
    // The edit & close buttons have an implicit float:right style, so they need to be
    // declared before the buttons on the left.
    null,
    '<div class="module_showhide" style="width:17px;" onclick="wij_showhide(this)" onmousedown="ignore_mouse_event(arguments[0])"><img src="/images/db_hide.png"/></div><div class="module_title">',
    '', // [7] = title
    ' <span class="wij_header_comment"></span></div></div>',
    // end header, begin main body
    // Set relative positioning so we can align the mask_div within the widget body if necessary.
    '<div style="width:100%; position:relative;',
    '', // [10] = body_style
    '">',
    '', // [12] = body_html
    '</div>'
];

// wij_btn_html_tpl - StringBuffer template for the button array at the right of the widget
// header (in edit mode).
var wij_btn_html_tpl = [
    '<div style="float:right; cursor:default" onmousedown="return ignore_mouse_event(arguments)" onclick="return ignore_mouse_event(arguments)"><div class="module_edit" style="display:inline; float:none; visibility:hidden;" onclick="wij_edit_params(this)"><img title="',
    '#Edit', // [1] = "Edit"
    '" src="/images/db_edit.png" /></div><div class="module_close" style="display:inline; float:none;" onclick="wij_close(this)" onmousedown="ignore_mouse_event(arguments[0])"><img title="',
    '#Close', // [3] = "Close"
    '" src="/images/db_close.png"/></div></div>'
];



// wij_add_widget - add a widget to the main page.
// NOTE: it is possible for menu_ref to be an L3 menu (in full page view).
function wij_add_widget(menu_ref, container, hide_frame)
{
    // In edit mode, by default we just create a placeholder div. The user
    // can convert this to a full-fledged widget by clicking "show preview".
    var using_iframe = (!in_edit_mode);
    // If showing_preview then we also create an iframe, but it is done by
    // an external function, so we don't need to initialize it here.
    var showing_preview = (in_edit_mode && wij_previews_enabled && !menu_ref.direct_load);

    var serialno = menu_ref.serialno;
    var div_id = "wij_dv_" + serialno;
    var hdr_id = "wij_hdr_" + serialno;
    // Don't bind the iframe serial number to the menu serial number. It is safer
    // to avoid reusing iframe names if the user comes back to this page.
    var ifrm_id = "wij_ifr_" + next_iframe_revised_serialno++;

    var title_style = "";
    if (hide_frame) title_style = "display:none; "
    if (!in_edit_mode) title_style += "cursor:default; "

    var body_style = "";
//    if (!hide_frame) body_style = "border:1px solid grey;"

    var dv = document.createElement("DIV");
    dv.id = div_id;
    dv.ifrm_id = null;
    dv.serialno = serialno; // redundant?
    dv.menu_ref = menu_ref;
    dv.preview = false;
    dv.className = "wij_widget";
    if (hide_frame) dv.style.border = "none";


    // Generate the HTML for the full widget.
    var body_html = null;

    if (using_iframe)
    {
        // Generate the extended URL.
        var url = menu_ref.menu_url;
        if (menu_ref.cust_url_ext)
            url += menu_ref.cust_url_ext;

        var ht = get_wij_def_height(menu_ref);

        body_html = gen_iframe_html(ifrm_id, url, ht);
    }
    else if (showing_preview)
        body_html = ""; // delayed initialization.
    else if (menu_ref.direct_load)
        body_html = gen_preview_unavailable_html();
    else
        body_html = gen_show_preview_html(wij_cur_layout);

    var arr = wij_html_tpl;
    arr[1] = hdr_id;
    arr[3] = title_style;

    // Setup the right button bar portion of the widget header.
    if (!arr[5])
    {
        if (in_edit_mode)
        {
            wij_btn_html_tpl[1] = wij_string("edit");
            wij_btn_html_tpl[3] = wij_string("close");
            arr[5] = wij_btn_html_tpl.join("");
        }
        else
        {
            // no button bar in use mode currently.
            arr[5] = "";
        }
    }

    arr[7] = menu_ref.menu_name;
    arr[10] = body_style;
    arr[12] = body_html;

    dv.innerHTML = arr.join("");

    container.appendChild(dv);
    Element.extend(dv);

    widget_list.push(div_id);


    // Enable the edit button if the page has customization options.
    if (in_edit_mode && menu_ref.menu_customizable)
    {
        var aBtns = document.getElementsByClassName("module_edit", dv);
        aBtns[0].style.visibility = "visible";
    }

    if (menu_ref.cust_hdr_color || menu_ref.cust_hdr_comment)
    {
        wij_update_widget_header(dv);
    }


    if (using_iframe)
    {
        // Setup the iframe auto-sizing, mouse callbacks, etc.
        init_widget_iframe(dv, ifrm_id, true);
    }
    else if (showing_preview)
    {
        wij_show_preview(dv);
    }

    return dv;
}


// fixup_pregen_widgets - fixup the JS variables for any pre-generated widgets.
// (This is only called in use mode in 1/2 column mode, so we can make a few
// simplifications/optimizations.)
function fixup_pregen_widgets()
{
    var aWidgets = document.getElementsByClassName("wij_widget");
    var len = aWidgets.length;

    for (var i=0; i<len; i++)
    {
        var dv = aWidgets[i];

        dv.ifrm_id = ""; // TODO: do we need this?
        dv.serialno = ""; // TODO: do we need this?
        // We at least need menu_ref to exist, since init_widget_iframe will
        // try to dereference it. Whether any of the subvariables are needed
        // is a different question.
        dv.menu_ref = new Object();
        dv.preview = false;

        Element.extend(dv);

        widget_list.push(dv.id);

        var frm = wij_get_first_iframe(dv);
        if (frm)
        {
            init_widget_iframe(dv, frm.id, false)
        }
    }
}


// get_wij_def_height - Set the height to either the starting size of auto-sizing widgets,
// the default size for fixed height widgets, or the custom override size.
function get_wij_def_height(menu_ref)
{
    var def_autosize_ifrm_height = 90;
    var def_fixedsize_ifrm_height = 200;

    var ht = menu_ref.cust_height;
    if (!ht) ht = (menu_ref.menu_fixedsize ? def_fixedsize_ifrm_height : def_autosize_ifrm_height);

    return ht;
}


/*
// object_html_tpl (obsolete) - StringBuffer template for the body contents of iframe widgets.
// TODO: Using OBJECT doesn't apear to have any concrete advantage over iframe on FF and it
// is worse on IE.
var object_html_tpl = [
    '<object FRAMEBORDER=0 id="',
    '', // [1] = ifrm_id
    '" name="',
    '', // [3] = ifrm_id
    '" data="',
    '', // [5] = url
    '" type="text/html" style="width:100%; border: none; ',
    '', // [7] = more styles (e.g. height)
    '"></iframe>'
]; */

// iframe_html_tpl - StringBuffer template for the body contents of iframe widgets.
var iframe_html_tpl = [
    '<iframe FRAMEBORDER=0 id="',
    '', // [1] = ifrm_id
    '" name="',
    '', // [3] = ifrm_id
    '" src="',
    '', // [5] = url
    '" style="width:100%; border: none; ',
    '', // [7] = more styles (e.g. height)
    '"></iframe>'
];

// gen_iframe_html - generate the HTML code for the widget iframe.
function gen_iframe_html(id, url, ht)
{
//    var aHTML = object_html_tpl;
    var aHTML = iframe_html_tpl;
    aHTML[1] = id;
    aHTML[3] = id;
    aHTML[5] = url;
    aHTML[7] = ht ? ("height: " + ht + "px;") : "";
    return aHTML.join("");
}


// wij_add_iframe_to_widget - add an iframe into the widget, either because the
// user clicked "show preview" in edit mode, or if they dragged the widget in
// Firefox.
function wij_add_iframe_to_widget(wij, ht)
{
    // Use "a" to distinguish replacement serial #s from regular ones.
    // TODO: maybe this is no longer necessary because we no longer link the iframe
    // serial number to the menu serial number on the first load.
    var ifrm_serialno = "a" + (next_iframe_revised_serialno++);
    var ifrm_id = "wij_ifr_" + ifrm_serialno;

    // Generate the extended URL.
    var menu_ref = wij.menu_ref;
    var url = menu_ref.menu_url;
    if (menu_ref.cust_url_ext)
        url += menu_ref.cust_url_ext;

    if (!ht) ht = get_wij_def_height(menu_ref);

    // Generate the new iframe in raw html.
    // Use the same basic innerHTML code from wij_add_widget, but this time
    // we (optionally) specify the desired height.
    var bdy = wij.childNodes[1];
    var iframe_html = gen_iframe_html(ifrm_id, url, ht);

    // Account for the fact that there may be other nodes inside the widget
    // that we want to preserve, such as the hide preview button & mask div.
    if (bdy.childNodes.length)
    {
        var tmp_div = document.createElement("DIV");
        tmp_div.innerHTML = iframe_html;
        var iframe = tmp_div.childNodes[0];
        Element.remove(iframe);
        bdy.appendChild(iframe);
    }
    else
    {
        bdy.innerHTML = iframe_html;
    }


    // Setup the iframe auto-sizing, mouse callbacks, etc.
    init_widget_iframe(wij, ifrm_id, false);
}


// wij_show_header_bar - show or hide the header bar & frame around the widget.
function wij_show_header_bar(dv, bShow)
{
    var hdr = dv.firstDescendant();

    if (bShow)
    {
        // setting the style to "" to revert to the CSS version doesn't work on IE.
//        dv.style.border = "";
        dv.style.border = "1px solid #bbbbbb";
        hdr.style.display = "";
    }
    else
    {
        dv.style.border = "none";
        hdr.style.display = "none";
    }
}


// wij_update_widget_header - update the widget header display to reflect the JS state.
// (E.g. when the background colour has changed.)
function wij_update_widget_header(wij)
{
    try
    {
        // Update the header background colour.
        var hdr = wij.firstDescendant();
        var hdr_color = wij.menu_ref.cust_hdr_color;

        if (hdr_color)
        {
            hdr.style.backgroundImage = "none";
            hdr.style.backgroundColor = hdr_color;
        }
        else
        {
//clogger.debug("Request to unset the widget header colour.");
            hdr.style.backgroundColor = "";
            hdr.style.backgroundImage = "";
        }

        // Update the comment string in the header.
        var comment_str = wij.menu_ref.cust_hdr_comment;
        var aCommentElems = document.getElementsByClassName("wij_header_comment", wij);
        var spn_comment = aCommentElems[0];

        if (comment_str)
        {
            spn_comment.innerHTML = " - " + comment_str;
        }
        else
        {
            spn_comment.innerHTML = "";
        }
    }
    catch (e)
    {
        alert("Failed to set the widget colour to: '" + hdr_color + "' - " + e);
    }
}


// wij_update_widget_header - update the widget display to reflect the new URL.
function wij_update_widget_url(wij)
{
    // Make use of the firefox kludge to reload the widget w/ the new URL.
    ff_replace_iframe(wij);
}


// wij_update_widget_height - update the height of the widget to reflect the menu definition.
function wij_update_widget_height(wij)
{
    var ifrm = wij_get_first_iframe(wij);
    if (!ifrm)
        return;

    // Preserve the existing iframe height.
    var ht = wij.menu_ref.cust_height;

    if (ht)
    {
        ifrm.style.height = ht + "px";
        ifrm.height = ht;
    }
    else
    {
        ifrm.style.height = "auto";
        ifrm.height = "";
    }
}


// destroy_all_widgets - remove all the widgets from the page.
function destroy_all_widgets()
{
    var container = $j("wij_layout_container");

    container.innerHTML = "";
    widget_list = [];
    iframes_list = new Object();
}


// wij_create_2col_layout - add the boilerplate HTML code for
// the 2 column layout.
function wij_create_2col_layout()
{
    container = $j("wij_layout_container");

    // Create a table to manage the 2-column layout.
    // TODO: the spec says that the widgets may overflow the screen horizontally, triggering
    // scrollbars, but I think it looks better to keep each column at 50%.
    if (autosize_iframe_widths)
    {
        container.innerHTML = "<table width='100%'><tr><td style='vertical-align:top; padding-right:5px;'><div id='wij_dv_col1'></td><td style='vertical-align:top;'><div id='wij_dv_col2'></td></tr></table>";
    }
    else
    {
        container.innerHTML = "<table width='100%'><tr><td style='width:50%; vertical-align:top; padding-right:5px;'><div id='wij_dv_col1'></td><td style='width:50%; vertical-align:top;'><div id='wij_dv_col2'></td></tr></table>";
    }
}


// display_widgets - display multiple widgets in either a 1-column or 2-column layout.
// NOTE: static_elem is an optional element to add at the beginning of column 1.
function display_widgets(aElems, two_col, static_elem)
{
    if (!icontainer_is_init)
        return;

    wij_reset_icontainer();

    var col1;
    var col2;

    if (two_col)
    {
        wij_create_2col_layout();
        wij_cur_layout = wij_layout_2column;
        drag_y_only = false;

        col1 = $j("wij_dv_col1");
        col2 = $j("wij_dv_col2");
    }
    else
    {
        wij_cur_layout = wij_layout_1column;
        drag_y_only = true;
        col1 = $j("wij_layout_container");
        col2 = col1;
    }

    if (static_elem)
    {
        wij_add_widget(static_elem, col1, false);
    }

    var len = aElems.length;

    for (var i=0; i<len; i++)
    {
        var l4_menu = aElems[i];
        var target = (l4_menu.menu_col == 2) ? col2 : col1;
        wij_add_widget(l4_menu, target, false);
    }

    if (in_edit_mode)
    {
        init_icontainer_dragdrop()
    }
}


// display_1_widget - display a widget in the single-item layout.
// NOTE: currently, menu_ref could be either an L3 or L4 menu item.
function display_1_widget(menu_ref)
{
//mlogger.debug("begin display_1_widget");
    if (!icontainer_is_init)
        return;

/*var tm = (new Date()).getTime();
var intvl = (tm - last_ifrm_monitor_tm);
clogger.debug("display_1_widget - Last iframe monitor was " + intvl + " ms ago.");
*/

    wij_reset_icontainer();
    wij_cur_layout = wij_layout_single;
    var container = $j("wij_layout_container");

    var wij = wij_add_widget(menu_ref, container, true);

    if (in_edit_mode)
    {
        // We don't actually need drag & drop in full page mode. This would
        // only be used if we switched layout modes later on.
        init_icontainer_dragdrop()
    }

    // Set the initial size of the widget to the full page. (This is effective
    // for correcting the display of auto-sizing pages such as the TP viewer.)
    if (!in_edit_mode || wij.preview)
    {
        var frm_id = widget_iframe_map[wij.serialno];
        if (frm_id)
        {
            resize_iframe_to_fullpage(frm_id);
        }
    }
//mlogger.debug("end display_1_widget");
}


// display_l3_menuitem - called by the subnav frame when the user navigates to
// a new L3 tab.
function display_l3_menuitem(menu_ref)
{
    // Update the global reference to the current page.
    cur_displayed_l3_menu = menu_ref;
    var l4elems = menu_ref.child_nodes;

    // TODO: maybe all these special cases are too complicated (due to treating
    // standard pages as L3 menus rather than L4s).
    switch (menu_ref.menu_layout)
    {
        case wij_layout_single:
            // Sanity check - if there is more than 1 widget in single-layout
            // mode then better fall through to 1-column.
            if (menu_ref.menu_id == user_defined_menu_id && l4elems.length == 1)
            {
                // Display a single custom widget.
                display_1_widget(l4elems[0]);
                break;
            }
            else if (l4elems.length == 0)
            {
                // Display a standard page with no added widgets.
                display_1_widget(menu_ref);
                break;
            }

        case wij_layout_2column:
        case wij_layout_1column:
            // Display a page of custom widgets.
            var two_col = (menu_ref.menu_layout == wij_layout_2column);
            var static_elem = null;

            // If this is an edited version of a standard page then also
            // include the standard L3 element at the top of the page.
            if (menu_ref.menu_id != user_defined_menu_id)
                static_elem = menu_ref;

            display_widgets(l4elems, two_col, static_elem);
            break;

        default:
            //clogger.debug("Unspecified menu layout in display_l3_menuitem - menu_ref=" + menu_ref.menu_name);
            break;
    }
}


// realign_wij_preview_labels - realign the labels in the preview widgets to
// match the new layout mode.
function realign_wij_preview_labels(to_screen)
{
    // Not supported on IE6.
    if (!have_position_fixed)
        return;

    var pos_type = to_screen ? "fixed" : "absolute";

    // Re-align any widget labels to the centre of the div.
    var aLabels = document.getElementsByClassName("wij_previewmask_label");
    // There should only be one.
    var elem = aLabels[0];
    if (elem)
        elem.style.position = pos_type;

    // Ditto for no-preview icons.
    var aLabels = document.getElementsByClassName("wij_nopreview_icon");
    // There should only be one.
    var elem = aLabels[0];
    if (elem)
        elem.style.position = pos_type;
}


// wij_change_layout_mode - change the layout mode, possibly switching between
// column & non-column mode.
function wij_change_layout_mode(new_layout_mode)
{
//clogger.debug("wij_change_layout_mode - new_layout_mode = " + new_layout_mode);
    // The rest of the function assumes that the old & new modes are
    // not the same, so be sure to check this case.
    if (new_layout_mode == wij_cur_layout)
        return;

    var container = $j("wij_layout_container");
    var reparented_widgets = false;

    // Changing from standalone mode to widgetized.
    if (wij_cur_layout == wij_layout_single)
    {
        // Add the header bar to the widget.
        var aWidgets = document.getElementsByClassName("wij_widget");
        var wij = aWidgets[0];
        if (wij)
        {
            wij_show_header_bar(wij, true);

            // If not in preview mode, we also need to reset the size of the
            // widget body.
            if (!wij.preview)
            {
                var wij_bd = wij.childNodes[1];
                wij_bd.style.height = ht_def_wb_incolumn; // includes "px"
            }
        }

        // Re-align any widget labels to the centre of the div.
        realign_wij_preview_labels(false);
    }

    // Changing from 2 column mode to single column.
    if (wij_cur_layout == wij_layout_2column)
    {
        // Collapse all the widgets down into 1 column.
        var container1 = $j("wij_dv_col1");
        var container2 = $j("wij_dv_col2");
        move_all_children(container1, container);
        move_all_children(container2, container);
        Element.remove(container1);
        Element.remove(container2);
        reparented_widgets = true;
        drag_y_only = true;
    }

    // Changing from widget mode to standalone.
    if (new_layout_mode == wij_layout_single)
    {
        // Remove the header bar from the widget.
        var aWidgets = document.getElementsByClassName("wij_widget");
        var wij = aWidgets[0];
        if (wij)
        {
            wij_show_header_bar(wij, false);

            // Also, make sure the widget is not collapsed in full screen mode.
            if (wij.wij_hidden)
                wij_showhide(wij);
        }

        // Re-align any widget labels to the centre of the screen.
        realign_wij_preview_labels(true);
    }

    // Changing from single column mode to 2 column.
    if (new_layout_mode == wij_layout_2column)
    {
        // Move the elements into a placeholder div.
        var tmp_div = document.createElement("DIV");
        move_all_children(container, tmp_div);

        wij_create_2col_layout();

        // Distribute the children among the 2 divs.
        var container1 = $j("wij_dv_col1");
        var container2 = $j("wij_dv_col2");
        move_all_children_alt(tmp_div, container1, container2);
        reparented_widgets = true;
        drag_y_only = false;
    }

    wij_cur_layout = new_layout_mode;
    if (cur_displayed_l3_menu) cur_displayed_l3_menu.menu_layout = new_layout_mode;


    if (new_layout_mode == wij_layout_2column)
    {
        // Since we are using move_all_children_alt to move some of the children into
        // column 2, we also need to update the column state. (Do this after updating
        // the wij_cur_layout variable.)
        update_layout_in_menu_defn();
    }

    // Update the columns definition in the drag & drop handler.
    init_dragdrop_columns();

    // Work around a Firefox bug w/ reparenting iframes.
//clogger.debug("wij_change_layout_mode - reparented_widgets = " + reparented_widgets);
    if (need_iframe_FF_workaround && reparented_widgets)
    {
//clogger.debug("wij_change_layout_mode - calling ff_replace_all_iframes");
        ff_replace_all_iframes();
    }
}


// wij_addwidget_from_dlg - add a widget selected via the add content dialog.
function wij_addwidget_from_dlg(id, title, url)
{
    // If adding a 2nd widget while in single layout mode, we need to switch to 1column mode.
    if (wij_cur_layout == wij_layout_single && widget_list.length)
    {
        wij_change_layout_mode(wij_layout_1column);
    }

    var l3_menu = cur_displayed_l3_menu;
    var l4_menu = top.frames.mainnav.append_new_L4_menu(title, l3_menu, url, id);

    // Place the widget in the first available column.
    // TODO: or maybe whichever is currently shorter?
    var container_id = (wij_cur_layout == wij_layout_2column) ? "wij_dv_col1" : "wij_layout_container";
    var container = $j(container_id);

    var hide_frame = (wij_cur_layout == wij_layout_single);
    var wij = wij_add_widget(l4_menu, container, hide_frame);

    // Setup the drag & drop for the new widget (still needed in full page mode).
    if (in_edit_mode)
    {
        var hdr = wij.firstDescendant();
        setupdrag(hdr, wij);
    }
}


/******************************
  Misc
******************************/

// wij_reset_icontainer - reset the icontainer page.
// TODO: this is now being called twice in most cases, as we call it one time to
// confirm that we can unload the pages and a second time to actually do the unloading.
function wij_reset_icontainer()
{
    // TODO: this is sometimes being called before the page is loaded.
    if (!icontainer_is_init)
        return true;

    // Give each of the iframes a chance to abort the action.
    if (!wij_unload_all_frames())
        return false;

    destroy_all_widgets();

    Drag.reset();
    return true;
}


// clear_icontainer_page - clear the current browsing context.
function clear_icontainer_page()
{
    cur_displayed_l3_menu = null;
    wij_reset_icontainer();
}


// move_all_children - move all children from one div to another.
function move_all_children(src, dst)
{
    var oList = src.childNodes;
    var cnt = oList.length;

    for (var i=0; i<cnt; i++)
    {
        var elem = src.childNodes[0];
        src.removeChild(elem);
        dst.appendChild(elem);
    }
}

// move_all_children_alt - move all children, alternating between
// output columns.
function move_all_children_alt(src, dst, dst2)
{
    var oList = src.childNodes;
    var cnt = oList.length;

    for (var i=0; i<cnt; i++)
    {
        var elem = src.childNodes[0];
        src.removeChild(elem);

        if (i % 2)
            dst2.appendChild(elem);
        else
            dst.appendChild(elem);
    }
}


// wij_change_tab_layout_info - callback function when the user closes
// the edit layout dialog.
function wij_change_tab_layout_info(new_tab_name, new_layout_mode)
{
    if (new_tab_name != cur_displayed_l3_menu.menu_name)
    {
        cur_displayed_l3_menu.menu_name = new_tab_name;
        top.frames.subnav.update_tab_names();
    }

    if (new_layout_mode != wij_cur_layout)
    {
        wij_change_layout_mode(new_layout_mode);
    }
}


// update_layout_in_menu_defn - build a new (sorted) l4 menu list based on 
// the current layout.
function update_layout_in_menu_defn()
{
    var l4elems = [];

    // While we have a chance, let's also rebuild the global widget_list array.
    // This could change if the user has called us after deleting an element.
    // (For the sake of self-healing code, regenerating the list from the DOM is
    // preferable to incremental updates.)
    var new_widget_list = [];

    var aWidgets = document.getElementsByClassName("wij_widget");
    var len = aWidgets.length;

    for (var i=0; i<len; i++)
    {
        var wij = aWidgets[i];
        new_widget_list.push(wij.id);

        // Ignore L3 menu items, if present.
        if (wij.menu_ref.menu_level != 4)
            continue;

        if (wij_cur_layout == wij_layout_2column && wij.parentNode.id == "wij_dv_col2")
            wij.menu_ref.menu_col = 2;
        else 
            wij.menu_ref.menu_col = 1;

        l4elems.push(wij.menu_ref);
    }

    cur_displayed_l3_menu.child_nodes = l4elems;
    widget_list = new_widget_list;
}


/******************************
  Widget event handlers
******************************/

function get_containing_widget(obj)
{
    while (obj)
    {
        if (obj.className == "wij_widget")
            return obj;

        obj = obj.parentNode;
    }

    return null;
}


// wij_close - onclick handler for the close button in the widget header.
// TODO: we may want to use a confirmation dialog here.
function wij_close(obj)
{
    var wij = get_containing_widget(obj);

    // Remove the widget from the global data structures.
    var old_ifrm = wij_get_first_iframe(wij);
    if (old_ifrm)
    {
        // Remove the old iframe from the global data structures.
        var ifrm_id = old_ifrm.id;
        iframes_list[ifrm_id] = null;
        delete iframes_list[ifrm_id];
        wij.ifrm_id = null;
    }

    // And from the DOM.
    Element.remove(wij);

    // Update the global menu definition structure. (As a side-effect, this
    // will also update the global widget_list array, so we don't need to
    // do that here.)
    // TODO: this isn't necessarily the most efficient place to do this.
    // We could do it on a timer, or when the user leaves the page.
    update_layout_in_menu_defn();

    return true;
}


// wij_showhide - onclick handler for the show/hide button in the widget header.
// (May also be called directly to expand/collapse the widget.)
function wij_showhide(obj)
{
    var wij = get_containing_widget(obj);

    // If we are invoked via the onclick handler then obj will already be the
    // show/hide button. But it is better not to rely on that, since there are
    // some cases where we want to programatically expand/collapse the widget.
    var aBtns = document.getElementsByClassName("module_showhide", wij);
    var btn_showhide = aBtns.length ? aBtns[0] : obj;

    var hdr = wij.childNodes[0];
    var bdy = wij.childNodes[1];

    if (wij.wij_hidden)
    {
        bdy.style.display = "";
        btn_showhide.childNodes[0].src = "/images/db_hide.png";
        wij.wij_hidden = false;
    }
    else
    {
        bdy.style.display = "none";
        btn_showhide.childNodes[0].src = "/images/db_show.png";
        wij.wij_hidden = true;
    }

    return true;
}


// wij_show_preview - display a preview widget covered by a translucent mask.
function wij_show_preview(obj)
{
    var wij = get_containing_widget(obj);
    var bdy = wij.childNodes[1];

    bdy.innerHTML = "";
    wij_add_iframe_to_widget(wij, null)

    // Display the mask div immediately when loading the widget,
    // but wait until the page size has stabilized a bit before
    // showing the more visually striking "hide preview" button.
    var tmp_div = document.createElement("DIV");
    tmp_div.innerHTML = gen_hide_preview_html(wij_cur_layout);

    var mask_div = tmp_div.childNodes[0];
    var hide_btn = tmp_div.childNodes[1];

    hide_btn.style.visibility = "hidden";

    Element.remove(mask_div);
    Element.remove(hide_btn);

    bdy.appendChild(mask_div);
    bdy.appendChild(hide_btn);

    function make_cb(btn) { return function() { btn.style.visibility = "visible"; } };
    var cb = make_cb(hide_btn);
    setTimeout(cb, 1300);

    if (wij_cur_layout == wij_layout_single)
    {
        // Set the initial size of the widget to the full page. (This is effective
        // for correcting the display of auto-sizing pages such as the TP viewer.)
        var frm_id = widget_iframe_map[wij.serialno];
        if (frm_id)
        {
            resize_iframe_to_fullpage(frm_id);
        }
    }

    wij.preview = true;
}


// wij_hide_preview - remove the widget preview display and just display the generic icon.
function wij_hide_preview(obj)
{
    var wij = get_containing_widget(obj);
    var bdy = wij.childNodes[1];

    // Remove the widget from the global data structures.
    // TODO: this is duplicated with wij_onclose - need to refactor.
    var old_ifrm = wij_get_first_iframe(wij);
    if (old_ifrm)
    {
        // Remove the old iframe from the global data structures.
        var ifrm_id = old_ifrm.id;
        iframes_list[ifrm_id] = null;
        delete iframes_list[ifrm_id];
        wij.ifrm_id = null;
    }

    bdy.innerHTML = gen_show_preview_html(wij_cur_layout);
    wij.preview = false;
}


// wij_enable_widget_previews - toggle the show/hide preview state for all widgets on the page.
function wij_enable_widget_previews(bShow)
{
    // Update the default for new elements.
    wij_previews_enabled = bShow;

    var aWidgets = document.getElementsByClassName("wij_widget");
    var len = aWidgets.length;

    for (var i=0; i<len; i++)
    {
        var wij = aWidgets[i];

        // Direct load widgets are not toggle-able.
        if (wij.menu_ref.direct_load)
            continue;

        if (bShow && !wij.preview)
        {
            wij_show_preview(wij);
        }
        else if (!bShow && wij.preview)
        {
            wij_hide_preview(wij);
        }
    }
}


/******************************
  Customize widget dialog
******************************/

var customize_dlg_target = null;

// wij_edit_params - handler for the edit button in the widget header.
function wij_edit_params(obj)
{
    customize_dlg_target = get_containing_widget(obj);

    // TODO: which is better for the widget customization? Popup window or inline modal dialog?
    if (1)
    {
        wij_display_modal_dlg("/wij_customize_dlg.html", 480, 300, "lightblue");
    }
    else
    {
        window.open("/wij_customize_dlg.html","","width=450,height=428,top=100,left=200,resizable=1");
    }
}


// wij_end_customize_dialog - close the customize widget inline modal dialog.
function wij_end_customize_dialog()
{
    customize_dlg_target = null;
    wij_end_modal_dialog();
}


/******************************
  Add content dialog
******************************/

// wij_add_content - display the add content dialog.
function wij_add_content()
{
    if (!cur_displayed_l3_menu)
    {
        alert(wij_string("no_page"));
        return;
    }

    if (cur_displayed_l3_menu.menu_readonly && !allow_customize_std_pages)
    {
        alert(wij_string("cant_customize"));
        return;
    }

    // Direct load pages can't be customized because they are not viewed from within
    // the icontainer. This is a safety measure so we can handle any pages that are
    // grossly incompatible w/ widgetization (none exist as of May 2008).
    if (cur_displayed_l3_menu.direct_load)
    {
        alert(wij_string("cant_customize"));
        return;
    }

    // Popup the inline modal dialog.
    wij_display_modal_dlg("/wij_addcontent.html", 500, 340, "#bbbbbb");
}



// wij_end_addcontent_dialog - close the add content dialog.
// NOTE: this is currently called directly from the dialog's close
// button event handler.
function wij_end_addcontent_dialog()
{
    wij_end_modal_dialog();
}



/******************************
  Edit layout dialog
******************************/

// wij_run_edit_page_dialog - display the edit tab dialog.
function wij_run_edit_page_dialog()
{
    if (!cur_displayed_l3_menu)
    {
        alert(wij_string("no_page"));
        return;
    }

    if (cur_displayed_l3_menu.menu_readonly && !allow_customize_std_pages)
    {
        alert(wij_string("cant_customize"));
        return;
    }

    wij_display_modal_dlg("/wij_editlayout.html", 350, 250, "lightblue");
}

// get_edit_layout_dlg_dat - called by the edit dialog to extract the
// relevant data off the calling page.
function get_edit_layout_dlg_dat()
{
    var dat = new Object();
    dat.menu_ref = cur_displayed_l3_menu;
    // TODO: these other items are potentially redundant (if we trust everything to
    // be in sync at this point).
    dat.layout = wij_cur_layout;
    dat.num_widgets = widget_list.length;
    return dat;
}

// wij_end_editlayout_dialog - close the edit layout dialog.
function wij_end_editlayout_dialog()
{
    wij_end_modal_dialog();
}


/******************************
  System event handlers
******************************/

// ignore_mouse_event - stub function to discard mouse events (but it still lets
// us verify that they were generated).
function ignore_mouse_event(ev)
{
    if (!ev) ev = window.event;

    Event.stop(ev);
//clogger.debug("in ignore_mouse_event");
    return true;
}


// ie_on_select_start - callback when the user is about to start a selection on IE.
// This usually results in ridiculous shaded areas on the screen. So generally we
// want to prevent it.
function ie_on_select_start(ev)
{
    // TODO: there may some cases where we want to allow this later, but for now
//     // just always disable selection within the icontainer window.
/*
    if (!ev) ev = window.event;
    var elem = ev.srcElement;
*/

//clogger.debug("ie_on_select_start");
    return false;
}


// wij_icontainer_onbeforeunload - onbeforeunload handler for the icontainer page.
function wij_icontainer_onbeforeunload(ev)
{
    // Cancel the interval timer.
    stop_iframe_monitor_size();

    // Unload all the iframes first to check if they have unsaved data.
    if (!wij_reset_icontainer())
    {
        var str = wij_string("warn_unsaved_data");
        ev.returnValue = str;
        return str;
    }
}


document.onselectstart = ie_on_select_start;


// sync_icontainer_to_subnav - reload the widgets based on the currently selected
// L3 tab in the subnav frame.
function sync_icontainer_to_subnav()
{
//clogger.debug("sync_icontainer_to_subnav");
    // Make sure we have finished loading.
    if (!icontainer_is_init)
        return;

    // Sync the page state with the subnav frame (making
    // sure the subnav has finished loading).
    var sync_fn = parent.subnav.get_current_widget_set;
    if (!sync_fn)
        return;

    var menu_ref = sync_fn();
    if (!menu_ref)
        return;

    display_l3_menuitem(menu_ref);
}


// init_1col_pregen_container - alternate window.onload handler for pages
// using a statically configured 1 column widget display.
// (Currently used by the policylist module.)
function init_1col_pregen_container()
{
    window.in_edit_mode = false;
    wij_pregen_content = true 
    wij_cur_layout = wij_layout_1column
    init_icontainer();
}


// init_icontainer - window.onload handler.
function init_icontainer()
{
//clogger.debug("init_icontainer");
//mlogger.enable();
    monitor_iframe_size();
    icontainer_is_init = true;

    // In edit mode, check the flag in the logo frame to see if we should enable
    // previews for newly added widgets.
    if (in_edit_mode)
    {
        try
        {
            var elem = top.document.getElementById("cb_wij_show_preview");
            wij_previews_enabled = elem.checked;
        }
        catch (e)
        {
            //clogger.debug("init_icontainer - failed to get show preview state: " + e);
        }
    }

    // Resync the icontainer state with the currently selected subnav tab.
    // (Being aware of race-conditions...)
    if (!window.wij_pregen_content)
    {
        //sync_icontainer_to_subnav();
    }
    else
    {
        // The wij_pregen_content flag indicates that the page was called with pre-generated
        // dynamic contents, so don't resync to the subnav frame now.
        fixup_pregen_widgets();
    }

    addEvent(window, "resize", wij_icontainer_onresize);
    addEvent(window, "beforeunload", wij_icontainer_onbeforeunload);
}




/******************************
 wij_icontainer_ifrm.js - Iframe support within icontainer widgets.
 Init by A. Krywaniuk, Apr 2008
 GUI widgetization project
 Copyright Fortinet, inc.
 All rights reserved
 ******************************/


// need_iframe_FF_workaround - whether to enable the workaround for the
// iframe reparenting bug on Firefox.
// (NOTE: We don't currently appear to require this workaround because
// we are using the iframe.contentDocument to measure the client size,
// and the mask divs on the preview windows obviate the need for
// forwarding the mouse messages.)
var need_iframe_FF_workaround = false; // FF;

// autosize_iframe_widths - whether the iframe auto-sizing is done in both
// directions or the vertical direction only. If disabled then the widget
// widths will just be matched to the icontainer columns.
// TODO: the internal resizing doesn't work reliably on a lot of pages.
var autosize_iframe_widths = false; // true;


// wij_resize_iframe_to_fullpage - whether we should try to resize the
// iframes to match the full page size when in full page mode. Otherwise
// the preview mask will not cover the full screen.
var wij_resize_iframe_to_fullpage = true;


/******************************
  Utility/debugging functions
******************************/

// dbg_update_iframe_size (debugging function) - outputs the current size 
// to the debug area at the top of the page.
function dbg_update_iframe_size()
{
    var frm_id = $j("dbg_iframe_name").value;

    var frm = document.getElementById(frm_id);
    var frm_doc = window.frames[frm_id].document;

    var wnd_sz = $j("iframe_sz");
    var body_sz = $j("body_sz");

    wnd_sz.innerHTML = frm.offsetWidth + ", " + frm.offsetHeight;
    body_sz.innerHTML = frm_doc.body.offsetWidth + ", " + frm_doc.body.offsetHeight;
}


// dbg_fit_iframe_to_contents (debugging function) - trigger a resizing operation
// on an iframe.
function dbg_fit_iframe_to_contents()
{
    var frm_id = $j("dbg_iframe_name").value;
    check_iframe_size(frm_id, true);
}


// dbg_dump_all_iframes (test function) - print all the known iframe ids.
function dbg_dump_all_iframes()
{
    var str = "";
    for (var id in iframes_list)
    {
        str += id + "(" + iframes_list[id] + "), ";
    }

    //clogger.debug("iframes list: " + str);

    str = "";
    var len = window.frames.length;

    for (var i=0; i<len; i++)
    {
        var frm = window.frames[i];
        var id = frm.id;
        var name = frm.name;
        str += id + "(" + name + "), ";
    }

    // It may be convenient to initialize the edit box to the first known
    // iframe id here.
//    $j("dbg_iframe_name").value = window.frames[0].name;

    //clogger.debug("window.frames array: " + str);
}


// get_iframe_document - get the document inside the iframe. (Use contentDocument
// on Firefox to work around the reparenting bug.)
function get_iframe_document(frm)
{
    if (FF)
        return frm.contentDocument;
    else
        return window.frames[frm.id].document;
}



/******************************
  Iframe size auto-adjustment
******************************/

// Automatic monitoring of iframe sizing events.
// Unfortunately, we can't set a callback for when the iframe's content
// size changes, so the best we can do is just to add a polling function.

// ifrm_monitor_timer - interval timer for monitoring widget size
var ifrm_monitor_timer = null;


// autosize_iframe - auto-resize the iframe based on content size.
// TODO: unless we change things later, the caller would already have
// looked up both frm & frm_doc, so we could optimize the parameter
// passing here.
function autosize_iframe(frm_id)
{
    // Setting the width of the iframe to match the client area of the dialog doesn't
    // seem to work. I don't know why this fudge factor is needed.
    // (I think it represents the size and/or margins of the enclosing widget frame.)
    var upload_frm_fudge_w = 10;
    var upload_frm_fudge_h = 5;
    var scrollbar_fudge = IE ? 15 : 10;

    // It is safe to redirect debug output in this function if we so desire, since
    // it is only called when we detect that the size has changed.
//    var tlogger = mlogger;

    // anti_thrash - count the frequency of resizing operations to detect any thrashing.
    // TODO: this alg isn't good because it isn't bound within a time period.
    function anti_thrash(frm)
    {
        // Sometimes if we get the margins wrong then the page will get into an
        // endless loop where the sizing operation triggers scrollbars, which changes
        // the window size, which causes another size correction, and we are
        // in an endless loop.
        var autosize_cnt = frm.autosize_cnt;
        if (autosize_cnt)
            autosize_cnt++;
        else
            autosize_cnt = 0;

        // Update the value in the iframe.
        frm.autosize_cnt = autosize_cnt;

        // If we detect thrashing then use a bigger margin.
        if (autosize_cnt > 6)
        {
            //mlogger.debug("autosize_iframe - detect thrashing then use a bigger margin.");
            upload_frm_fudge_w = 0;
            upload_frm_fudge_h = 0;
        }

        if (autosize_cnt > 12)
        {
            // Too much thrashing... Give up.
            //mlogger.debug("autosize_iframe - Too much thrashing... Give up.");
            return true;
        }

        return false;
    }


    // Abort (or apply corrective measures) if we detect thrashing.
    var frm = $j(frm_id);
    if (anti_thrash(frm))
        return;


    // get_document_extent - measure the document extent.
    // returns an array of [width, height].
    function get_document_extent(frm_doc)
    {
        var ht;
        var wd;

        // Set the iframe height to be the same as the container div inside
        // the iframe document.
        var xdiv = frm_doc.getElementById("autosizing_div");

        if (xdiv)
        {
            ht = xdiv.offsetHeight;
            wd = xdiv.offsetWidth;
        }
        else
        {
            var root = frm_doc.documentElement;
            var bd = frm_doc.body;
            // TODO: need a safer way to do this:
            var elem1 = IE ? bd.childNodes[0] : bd.childNodes[1];

//tlogger.debug("root.tagName = " + root.tagName + ", height = " + root.offsetHeight + ", width = " + root.offsetWidth);
//tlogger.debug("bd.tagName = " + bd.tagName + ", height = " + bd.offsetHeight + ", width = " + bd.offsetWidth);
//if (elem1) tlogger.debug("elem1.tagName = " + elem1.tagName + ", height = " + elem1.offsetHeight + ", width = " + elem1.offsetWidth);

            // Implement a 3-way max.
            ht = bd.offsetHeight + 2*bd.offsetTop;
            wd = bd.offsetWidth + 2*bd.offsetLeft;

            // The HTML element height does *not* shrink-wrap on IE, so
            // it would never be less than the existing window size.
            if (!IE)
            {
                ht = Math.max(ht, root.offsetHeight);
            }

            wd = Math.max(ht, root.offsetWidth);

            if (elem1)
            {
                ht = Math.max(ht, elem1.offsetHeight);
                wd = Math.max(wd, elem1.offsetWidth);
            }
        }

        return [wd, ht];
    }


    // Now do the sizing. This is a tricky subject & very browser-dependent.
    var frm_doc = get_iframe_document(frm);
    var extent = get_document_extent(frm_doc);

    var wd = extent[0] + upload_frm_fudge_w;
    var ht = extent[1] + upload_frm_fudge_h;

//tlogger.debug("Final height = " + ht + ", width = " + wd);

    // TODO: this is a test... is it necessary to set a timeout here?
    frm.width = "" + wd + "px";

    if (extent[0] > frm.offsetWidth)
    {
//tlogger.debug("wd=" + wd + ", frm.offsetWidth=" + frm.offsetWidth + " (expecting scrollbars)");
        ht += scrollbar_fudge;
    }

    // Update the height & width of the iframe. (For some reason, it is
    // necessary to set frm.style.height but not frm.style.width.)
    frm.height = "" + ht + "px";
    frm.style.height = "" + ht + "px";


    // autosize_iframe_widths - try to auto-size the width as well as the height.
    // (NOTE: This option generally screws things up. Many pages have variable width
    // tables that have a minimum width, but which will also stretch out to
    // fill the available space.)
    if (autosize_iframe_widths)
    {
        frm.style.width = "" + wd + "px";
    }
}


// check_iframe_size - check if the iframe contents size has changed since the
// last poll, and if so then update the containing window.
function check_iframe_size(frm_id, force_resize)
{
    var frm = $j(frm_id);

/*
    // Check that the frame isn't missing - this can happen legitimately during
    // the unload sequence for the page. (Should be fixed now.)
    if (!frm)
    {
        clogger.debug("frame not found in check_iframe_size: " + frm_id);
        return;
    }
*/

    // Skip any widgets for which auto-sizing has been explicitly turned off.
    if (frm.autosizing_disabled)
        return;

    var frm_doc = get_iframe_document(frm);

    // If the frame hasn't finished loading then skip it this time.
    if (!frm_doc || !frm_doc.body)
        return;


    // Skip the resizing for a couple of times to give the size/contents a chance to
    // stabilize when the iframe is first loaded.
    if (frm.skip_resize_cnt)
    {
        frm.skip_resize_cnt--;
        return;
    }


    // handle_scalable_widget - handle the sizing for a variable-sized document. If a
    // document doesn't have a fixed size then we can't shrink-wrap the widget frame
    // to surround it.
    function handle_scalable_widget(frm, frm_doc)
    {
        // Use the icontainer margin instead of the interior one. Otherwise the
        // 100% scaling inside the iframe will be screwed up by the margin.
        // TODO: For columnated layout, we could add a margin on the iframe instead.
        frm_doc.body.style.margin = "0";

        if (wij_cur_layout == wij_layout_single)
        {
//tlogger.debug("Scaling page in single layout mode - call resize_iframe_to_fullpage");
            resize_iframe_to_fullpage(frm.id);
        }
        else
        {
//tlogger.debug("Scaling page in column layout mode - use fixed height");
            var wij_bd = frm.parentNode;
            var wd = wij_bd.offsetWidth;
            // We arbitrarily pick half the screen size in 1/2 column mode.
            var ht = (document.documentElement.clientHeight / 2);

            frm.height = "" + ht + "px";
            frm.style.height = "" + ht + "px";
            frm.width = "" + wd + "px";
        }
    }


    // handle_shrinkwrap_widget - If this is a regular (implicit-height)
    // page then shrink-wrap to that height.
    function handle_shrinkwrap_widget(frm, frm_doc)
    {
        var bd = frm_doc.body;
        var new_width = bd.offsetWidth;
        var new_height = bd.offsetHeight;

        var size_changed = (new_width != frm_doc.last_ifrm_width || new_height != frm_doc.last_ifrm_height);

        if (size_changed || force_resize)
        {
            if (wij_cur_layout == wij_layout_single && wij_resize_iframe_to_fullpage)
            {
                //tlogger.debug("Non-scaling page in single layout mode - call resize_iframe_to_fullpage");
                resize_iframe_to_fullpage(frm.id);
            }
            else
            {
                //tlogger.debug("Content-driven page size has changed - call autosize_iframe");
                autosize_iframe(frm.id);
            }
        }
        //else tlogger.debug("Content-driven page - size has not changed");

        frm_doc.last_ifrm_width = bd.offsetWidth;
        frm_doc.last_ifrm_height = bd.offsetHeight;
    }


    // Check if this page is meant to be displayed as full screen.
    // NOTE: can't match "100%" because sometimes we need to use "99%" in the
    // height definition to avoid scrollbars.
    // TODO: this is all very kludgy.
    if (frm_doc.body.style.height.match("%"))
    {
        handle_scalable_widget(frm, frm_doc);
    }
    else
    {
        handle_shrinkwrap_widget(frm, frm_doc);
    }
}


// last_ifrm_monitor_tm - debug variable for sanity check.
var last_ifrm_monitor_tm = null;

// check_all_iframe_sizes - callback function to do the monitoring.
function check_all_iframe_sizes()
{
//tlogger.debug("*** BEGIN check_all_iframe_sizes ***");
    // For debugging, track the iframe monitor check.
    last_ifrm_monitor_tm = (new Date()).getTime();

/*
    // In full-page layout mode, it's easier just to set the iframe to the dimensions
    // of the main window and let the client page handle the scrolling or auto-sizing.
    if (wij_cur_layout == wij_layout_single)
        return;
*/

    for (var frm_id in iframes_list)
    {
//tlogger.debug("check_iframe_size for frm_id=" + frm_id);
        check_iframe_size(frm_id);
    }

/*
    // TODO: this may be a little less efficient than iterating the iframes
    // directly, but it means one less list to worry about, and it gives
    // us automatic access to the widgets in the child functions (which is
    // important). The alternative would probably be just to iterate up the
    // DOM until we hit a widget.
    for (var wij_id in widget_list)
    {
        var wij = $j(wij_id);
        if (wij.
    }
*/
//tlogger.debug("*** END check_all_iframe_sizes ***");
}


// monitor_iframe_size - add a callback to monitor if the size of the iframe changes.
function monitor_iframe_size()
{
    if (ifrm_monitor_timer) clearInterval(ifrm_monitor_timer);
    ifrm_monitor_timer = setInterval("check_all_iframe_sizes()", 500);
}


// stop_iframe_monitor_size - stop the monitoring when the page is unloaded.
function stop_iframe_monitor_size()
{
    //clogger.debug("stop_iframe_monitor_size was called to end the iframe monitoring.");
    if (ifrm_monitor_timer) clearInterval(ifrm_monitor_timer);
    ifrm_monitor_timer = null;
}


// resize_iframe_to_fullpage (deprecated) - resize an iframe to the full main frame size.
// (available in layout_mode_single only)
function resize_iframe_to_fullpage(frm_id)
{
//tlogger.debug("resize_iframe_to_fullpage");

    var frm = document.getElementById(frm_id);
    var ht = document.documentElement.clientHeight;
    var wd = document.documentElement.clientWidth;


    // Adjust for the 5px margin all around the main window.
    ht -= 10;
    wd -= 10;

    // Account for the real offset of the iframe within the parent (but don't count
    // the 5px margin twice).
    var pos = Position.cumulativeOffset(frm);
    var tmargin = pos[1];
    ht -= tmargin - 5;

    // There is a problem that happens on IE only, which is that resizing the iframe
    // can trigger another wij_icontainer_onresize event. On IE6, this can result in
    // an infinite loop (on IE7 it seems to stabilize after a few iterations).
/*    if (IE)
    {
        ht -= 20;
        wd -= 20;
    } */

    if (ht < 0)
    {
        // This will crash on IE and FF will set an incorrect size. (So far it only
        // happened when the function was incorrectly called in 1 column mode.)
        //clogger.debug("XX_resize_iframe_to_fullpage: **ERROR** - ht = " + ht);
        return;
    }

    frm.height = "" + ht + "px";
    frm.style.height = "" + ht + "px";
}


// wij_delayed_resize_timer - semaphore timer for delayed resizing events.
var wij_delayed_resize_timer = null;

// wij_icontainer_on_delayed_resize - delayed onresize handler for the icontainer frame.
function wij_icontainer_on_delayed_resize()
{
    wij_delayed_resize_timer = null;


    if (!wij_resize_iframe_to_fullpage)
        return;

    if (wij_cur_layout != wij_layout_single)
        return;

    // In full-page layout mode, it's easier just to set the iframe to the dimensions
    // of the main window and let the client page handle the scrolling or auto-sizing.
    for (var frm_id in iframes_list)
    {
        // There should only be one.
        resize_iframe_to_fullpage(frm_id);
    }
}

// wij_icontainer_onresize - onresize handler for the icontainer frame.
function wij_icontainer_onresize()
{
//mlogger.debug("begin wij_icontainer_onresize");
    // Wait until the window size begins to stabilize.
    // (This avoids any unnecessary computation and it also prevents the browser
    // from hanging if we do run into the infinite recursion bug.)
    if (wij_delayed_resize_timer) clearTimeout(wij_delayed_resize_timer);
    wij_delayed_resize_timer = setTimeout(wij_icontainer_on_delayed_resize, 500);
//mlogger.debug("end wij_icontainer_onresize");
}



/******************************
  Iframe initialization/cleanup
******************************/


// wij_unload_all_frames - check if there is a window.onbeforeunload handler for any
// of the embedded iframes, and if so then emulate it. (The onbeforeunload event gives
// the page a chance to present the user with an "are you sure you want to leave?" dialog).
// Return value is false if the unload was aborted, true if it succeeded.
function wij_unload_all_frames()
{
    // TODO: accessing the variables frm_wnd.onbeforeunload & frm_wnd.onunload works fine
    // in FF, but it doesn't seem to work in IE. The (kludgy) solution we use is to create
    // a list of known event handler functions that may be used by a widget.
    // The topology viewer has two.
    // The JS console has three, but only on_leave_page is for inline mode (the others are
    // for the popup console).
    var onbeforeunload_strs = {
        "onbeforeunload" : 1, // FF case
        "on_topol_beforeunload" : 1, // Topology Viewer
        "on_leave_page" : 1 // JS console
    };

    var onunload_strs = {
        "onunload" : 1,
        "on_topol_unload" : 1
    };


    // invoke_onbeforeunload_callbacks - Iterate all the frames to invoke any
    // special behaviour and confirm that we are allowed to leave the page.
    // Returns true if the user aborts the action, false otherwise.
    function invoke_onbeforeunload_callbacks()
    {
        for (var frm_id in iframes_list)
        {
            var frm_wnd = window.frames[frm_id];
            var cb_fn = null;

            // First try to locate one of the known callback functions.
            for (name in onbeforeunload_strs)
            {
                if (frm_wnd[name])
                {
                    cb_fn = frm_wnd[name];
                    break;
                }
            }

            if (!cb_fn)
                continue;

            // We located a callback - now give the user a chance to cancel the action.
            var fake_ev = new Object();
            var rv = cb_fn(fake_ev);

            // If defined, rv should be a string prompting the user if they really want
            // to leave the page.
            if (!rv)
                continue;

            // Emulate the confirmation dialog from the standard onbeforeunload handler.
            if (!confirm(rv))
            {
                return true;
            }
        }

        return false;
    }


    // invoke_onunload_callbacks - manually invoke the onunload handlers. This avoids
    // some race-conditions that often cause the unload handlers to be called after
    // the window object has gone out of scope.
    function invoke_onunload_callbacks()
    {
        for (var frm_id in iframes_list)
        {
            var frm_wnd = window.frames[frm_id];
            var cb_fn = null;

            // First try to locate one of the known callback functions.
            for (name in onunload_strs)
            {
                if (frm_wnd[name])
                {
                    cb_fn = frm_wnd[name];
                    // Try to reset the event handler so we don't call it twice.
                    frm_wnd[name] = null;
                    break;
                }
            }

            // Invoke the callback.
            if (cb_fn)
            {
                var fake_ev = new Object();
                cb_fn(fake_ev);
            }
        }
    }


    // Pause the iframe size monitoring during this action.
    stop_iframe_monitor_size();

    // Invoke the beforeunload callbacks.
    var unload_aborted = invoke_onbeforeunload_callbacks();

    // I'm not sure if it makes sense to invoke the onunload handlers for IE. If we do it
    // here then the event will be more timely (otherwise it tends to happen well after the
    // next page has begun loading). But we can't prevent the previously registered event
    // from being called on IE.
    if (!unload_aborted && !IE)
    {
        invoke_onunload_callbacks();
    }

    // Resume iframe monitoring.
    monitor_iframe_size();

    return (!unload_aborted);
}


// init_widget_iframe - setup some JavaScript properties related to the iframe
// inside the widget.
function init_widget_iframe(wij, ifrm_id, new_widget)
{
    // Update the global iframe-widget maps/arrays.
    // (This will be used by the auto-sizing monitor, among other things.)
    widget_iframe_map[wij.serialno] = ifrm_id;
    iframes_list[ifrm_id] = 1;
    wij.ifrm_id = ifrm_id;

    // But skip the resize on the first couple of passes (to avoid a lot of extra
    // resizing while the page is still loading).
    // TODO: this probably isn't tuned all that well.
    var frm = $j(ifrm_id);
    frm.skip_resize_cnt = 3;

    var menu_ref = wij.menu_ref;
    if (menu_ref.menu_fixedsize)
    {
        frm.autosizing_disabled = true;
    }

    // We are capturing the mouse messages for drag & drop in edit mode only.
    // No need to do this in use mode (in fact, it could conflict with the
    // operation of the target page).
    if (in_edit_mode)
    {
        // Wait until after the page has probably loaded before setting up the
        // event handlers.
        // TODO: may need a more reliable solution to the race condition.
        var timeout = new_widget ? 3000 : 1000;

        var cb = "mk_iframe_mouse_event_handlers('" + ifrm_id + "')";
        setTimeout(cb, timeout);
    }
}


// wij_get_first_iframe - Get the iframe inside the widget. (We are assuming
// that there will be a maximum of 1 frame per widget, which is true as of Feb 2008.)
function wij_get_first_iframe(wij)
{
    var aFrames = wij.getElementsByTagName("IFRAME");
    if (!aFrames.length)
        return null;

    return aFrames[0];
}


// ff_replace_iframe - replace the iframe inside a widget with an
// identical new one (to fix a Firefox-specific bug).
function ff_replace_iframe(wij)
{
    // Re-parenting an element containing an iframe in FF causes the iframe
    // to refresh. This is a stupid browser bug and there's not much we
    // can do about it, other than to simply reset the callbacks.
    // TODO: This is too ugly.

    var old_ifrm = wij_get_first_iframe(wij);
    if (!old_ifrm)
        return;

    // Preserve the existing iframe height.
    var ht = old_ifrm.offsetHeight;

    // Remove the old iframe from the global data structures.
    var ifrm_id = old_ifrm.id;
    iframes_list[ifrm_id] = null;
    delete iframes_list[ifrm_id];
    wij.ifrm_id = null;

    // Add the replacement iframe.
    Element.remove(old_ifrm);
    wij_add_iframe_to_widget(wij, ht);
}


// ff_replace_all_iframes - Replace all the iframes on the page with new ones.
function ff_replace_all_iframes()
{
    var len = widget_list.length;

    for (var i=0; i<len; i++)
    {
        var wij = $j(widget_list[i]);
        if (!wij) continue;
        ff_replace_iframe(wij);
    }
}



/******************************
 wij_icontainer_drag.js - Navbar support code
 Init by A. Krywaniuk, Jan 2008 (duplicated from navbar_drag.js)
 GUI widgetization project
 Copyright Fortinet, inc.
 All rights reserved
 ******************************/


// Enable ddlogger at page startup.
//setTimeout("ddlogger.enable()", 3000);



/******************************
    Code from dashboard.js
******************************/

var icontainer = new Object();

icontainer.getModuleArr = function(column) {
	var arr = [];
	var ln = column.childNodes.length;
	for (var z=0; z<ln; z++) {
		if (
//		    !column.childNodes[z].dataObj
		    !column.childNodes[z].serialno
			&& column.childNodes[z] != moduleGhost) {
			continue;
		};

		if (!column.childNodes[z].isDragging) {
			arr.push(column.childNodes[z]);
		}
	}
	return arr;
}



// wij_bottom_margin - margin-bottom of the widget class (should be a constant for
// all icontainer widgets, thus we can cache it).
var wij_bottom_margin = null;


// wic_update_ghost_style - set the margins on the ghost div.
function wic_update_ghost_style(dv_ghost)
{
    var ghost_style = dv_ghost.style;

    // Use the -1 pixel margin to prevent the border from altering the layout of the
    // other elements on the page.
    ghost_style.marginLeft = "-1px";
    ghost_style.marginRight = "-1px";
    ghost_style.marginTop = "-1px";
    ghost_style.marginBottom = (wij_bottom_margin - 1) + "px";

    // IE6 has trouble with negative margins. If the negative margin is abutting the padding
    // inside the body then the dotted border won't be drawn. Thus to prevent clipping,
    // we can't make ghost div bigger than the dragged element. And the dragged element will
    // initially cover the ghost div on 3 sides (only the bottom border is showing).
    if (IE6)
    {
        ghost_style.marginLeft = "0";
        ghost_style.marginTop = "0";
        ghost_style.height = (dv_elem.offsetHeight - 1) + "px";
        ghost_style.width = (dv_elem.offsetWidth - 2) + "px";
    }
}


// nb_dragstart - drag start handler for navbar menuitems
function nb_dragstart(x,y,mousex,mousey)
{
    var dv_elem = this;
    var dv_ghost = moduleGhost;

    var aCols = icontainer.columnsObj;
    var cur_col = dv_elem.parentNode;

    // Retrieve & cache the margin-bottom attribute from the widget style.
    if (!wij_bottom_margin)
        wij_bottom_margin = parseInt(Element.getStyle(dv_elem, 'marginBottom')); // 10px

    // Initialize the ghost style so its border will exactly surround the target div,
    // without causing any other elements to move. Since the ghost div has a border, that
    // means we have to adjust for the differences in box-border model between FF & IE.
    // NOTE: we setup the ghost *before* changing any attributes of the target element -
    // otherwise we would need to cache the measurements.
    var ghost_style = dv_ghost.style;

    // After switching to HTML standards mode, it doesn't look like we need to make any
    // browser-specific adjustments here. IE7 & FF display the same, but IE6 is still a
    // problem.
    var fudge1 = -2;

    ghost_style.height = (dv_elem.offsetHeight) + "px";
    ghost_style.width = (dv_elem.offsetWidth) + "px";

    // Set the margins on the ghost div.
    wic_update_ghost_style(dv_ghost);

    // Set ourselves to have an absolute width while dragging. Otherwise we will use
    // 100% of the parent container (which screws up while detached in 2-column mode).
    dv_elem.style.width = (dv_elem.offsetWidth + fudge1) + "px";

    // Increase zIndex while dragging. This makes a difference when mixing statically
    // & relatively positioned items.
    dv_elem.saved_zIndex = dv_elem.style.zIndex;
    dv_elem.style.zIndex = 600;

    // Hide the widget while we swap it out for the ghost div. Otherwise, it will
    // briefly teleport lower down on the screen.
    dv_elem.style.visibility = "hidden";
    Position.absolutize(dv_elem);

    // On IE, we also need to account for the margin on the document body.
    // (TODO: I'm not sure why this correction is specific to IE.)
    if (IE)
    {
        var fudge_bd_margin = 5;
        var o_left = parseInt(dv_elem.style.left);
        var o_top = parseInt(dv_elem.style.top);
        dv_elem.style.left = (o_left + fudge_bd_margin) + "px";
        dv_elem.style.top = (o_top + fudge_bd_margin) + "px";
    }

    // Now insert the ghost right before us in the DOM, which should cause it to be
    // displayed at the widget's former position.
    cur_col.insertBefore(dv_ghost, dv_elem);
    dv_ghost.col = cur_col;
    dv_elem.style.visibility = "visible";


    // We're done... fixup some JS variables.
    this.isDragging = true;
    icontainer.draggingItem = true;

    this.col1X = findPosX(aCols.col1);
    if ((wij_cur_layout == wij_layout_2column)) this.col2X = findPosX(aCols.col2);

}


// nb_drag - drag handler for navbar menuitems
// AFAICT, the difference between x & mousex is that mousex is
// the position of the mouse on the screen, whereas x is the
// position of the drag object relative to the start position.
function nb_drag(x,y,mousex,mousey)
{
//clogger.debug("nb_drag: x=" + x + ", y=" + y + ", mousex=" + mousex + ", mousey=" + mousey);

    var dv_elem = this;
    var dv_ghost = moduleGhost;
    var col = dv_ghost.col;

    // See if we are switching columns.
    var aCols = icontainer.columnsObj;
    if ((x+this.offsetWidth/2)>=this.col1X) col=aCols.col1;
    if ((wij_cur_layout == wij_layout_2column)) if ((x+this.offsetWidth/2)>=this.col2X) col=aCols.col2;


    // Move the ghost to the new column if necessary.
    if (dv_ghost.col != col)
    {
        // Temporarily append the ghost at the end of the list.
        // we may move it up later.
        if (dv_ghost.parentNode)
            Element.remove(dv_ghost);

        dv_ghost.col = col;
        col.appendChild(dv_ghost);
    }


    // TODO: isn't this a little inefficient?
    var elems = icontainer.getModuleArr(col);

    // Remember the previous sibling rather than the index in the array.
    // This avoids the complicated logic involved in sometimes skipping
    // the ghost entry and sometimes not.
    var old_prev_sibling = dv_ghost.previousSibling;
    var new_prev_sibling = null;

    var len = elems.length;
    for (var i=len-1; i >= 0; i--)
    {
        var elem = elems[i];
        if (y > findPosY(elem) + (elem.offsetHeight * 1/3))
        {
            new_prev_sibling = elem;
            break;
        }
    }

    if (new_prev_sibling != old_prev_sibling && new_prev_sibling != dv_ghost)
    {
        if (dv_ghost.parentNode)
            Element.remove(dv_ghost);

        if (new_prev_sibling)
        {
            insertAfter(col, dv_ghost, new_prev_sibling);
        }
        else
        {
            col.insertBefore(dv_ghost, col.firstChild);
        }
    }

    // We don't need to update the ghost style during drag on the icontainer page
    // currently, since the margins don't depend on the current ghost position.
}


// nb_dragend - drag end handler for navbar menuitems
function nb_dragend(x,y,el)
{
    var dv_elem = this;
    var dv_ghost = moduleGhost;

    this.style.zIndex = this.saved_zIndex;

    // Turn off the isDragging flag after processing any onclick events.
    delayed_clear_dragging_flag(dv_elem);

    // bug fix?
//    Drag.obj.container = moduleGhost.col.getAttribute("colnum");
    var col = moduleGhost.col;
    if (!moduleGhost.parentNode) {
        moduleGhost.col.appendChild(moduleGhost);
    }
    col.insertBefore(this, moduleGhost);
    Element.remove(moduleGhost);

    icontainer.draggingItem = false;


    this.style.position = "static";
    // Hmm... do "auto" and "" do the same thing?
    this.style.width = "auto";
    this.style.height = "";

    // Since we may be reparenting a window containing an iframe, we
    // need to work around the Firefox bug.
    if (need_iframe_FF_workaround)
    {
        ff_replace_iframe(this);
    }

    // Update the global menu definition structure.
    // TODO: this isn't necessarily the most efficient place to do this.
    // We could do it on a timer, or when the user leaves the page.
    update_layout_in_menu_defn();
}

function setupdrag(divModuleHeader, divModule)
{
    // Setup the drag event callbacks.
    Drag.init(divModuleHeader, divModule);
    divModule.onDragStart = nb_dragstart;
    divModule.onDrag = nb_drag;
    divModule.onDragEnd = nb_dragend;
}


/******************************
    Custom code
******************************/

function init_dragdrop_columns()
{
    if (wij_cur_layout == wij_layout_2column)
    {
        icontainer.columnsObj.col1 = $j("wij_dv_col1")
        icontainer.columnsObj.col2 = $j("wij_dv_col2")
    }
    else
    {
        icontainer.columnsObj.col1 = $j("wij_layout_container")
        icontainer.columnsObj.col2 = null;
    }
}

// init_icontainer_dragdrop - setup drag & drop for the icontainer frame.
function init_icontainer_dragdrop()
{
    if (!icontainer.columnsObj)
        icontainer.columnsObj = new Object();

    init_dragdrop_columns();

    // Setup drag & drop.
    for (var i=0; i < widget_list.length; i++)
    {
        var div_id = widget_list[i];
        var elem = $j(div_id);
        var hdr = elem.firstDescendant();

        setupdrag(hdr, elem);
    }
}





/******************************
    Iframe mouse events
******************************/

// TODO: this was just duplicated from the jsconsole special case in the icontainer.
// Need to make it generic.

// iframe_fixE - gets the appropriate event object for the iframe.
function iframe_fixE(ev, ifrm_id)
{
    // Handle Firefox.
    if (ev) return ev;

    // Handle IE.
    // I don't claim to understand why we need to return the console window's event in
    // this case. Apparently, "window" in the event handler context is set to the window
    // that set the callback rather than the window that fired the event.

    var frm = window.frames[ifrm_id];
    if (!frm)
        return null;

    return frm.event;
}

// on_iframe_mousemove - internal implementation of JS console mousemove handling.
function on_iframe_mousemove(ev, ifrm_id)
{
    if (!Drag.obj)
        return;

// TODO: Position.cumulativeOffset doesn't appear to correctly account for the
// horizontal scroll position of the icontainer. This is not a major problem
// because the icontainer is not supposed to require scrollbars. However, there
// is currently a bug in which scrollbars often appear on IE.
//    var iframe_pos = Position.cumulativeOffset(ifrm);

    var ifrm = $j(ifrm_id);
    var iframe_pos = Position.page(ifrm);
    
/*clogger.debug("ifrm = " + ifrm);
clogger.debug("Position.page(ifrm) = " + Position.page(ifrm));
clogger.debug("Position.cumulativeOffset(ifrm) = " + Position.cumulativeOffset(ifrm)); */

    var fake_ev = new Object();
    fake_ev.is_fake = true;
    fake_ev.clientX = ev.clientX + iframe_pos[0];
    fake_ev.clientY = ev.clientY + iframe_pos[1];

    ddlogger.set_mousemove_loc(ifrm, ev.clientX, ev.clientY, fake_ev.clientX, fake_ev.clientY);

    // Pass the move event to either the drag handler or the checkdragcondition handler
    // depending on whether the drag threshold has already been met.
    if (Drag.clickTimeout)
        Drag.checkdragcondition(fake_ev);
    else
        Drag.drag(fake_ev);
}

// handle_jsconsole_mousemove - callback function to handle mousemove
// notifications from the JS console embedded iframe.
function handle_iframe_mousemove(ev, ifrm_id)
{
//clogger.debug("in handle_iframe_mousemove");
    // Get the event from the iframe context.
    ev = iframe_fixE(ev, ifrm_id);
    if (!ev) return false;

    // Switch into the main frame context (possibly not needed?)
    with (window.parent)
    {
        on_iframe_mousemove(ev, ifrm_id);
    }

    return true;
}

// on_iframe_mouseup - internal implementation of JS console mouseup handling.
function on_iframe_mouseup(ev, ifrm)
{
    if (!Drag.obj)
        return;

    // Pass the click to either the drag handler or the checkdragcondition handler
    // depending on whether the drag threshold has already been met.
    if (Drag.clickTimeout)
        Drag.cancelPending();
    else
        Drag.end(ev);
}


// handle_iframe_mouseup - callback function to handle mouseup
// notifications from the JS console embedded iframe.
// Note: this doesn't normally happen because the mousemove fix ensures that the
// mouse normally remains over the titlebar. However, it occasionally does happen
// and the results are very annoying when it does.
function handle_iframe_mouseup(ev, ifrm_id)
{
//clogger.debug("in handle_iframe_mouseup");
    // Get the event from the iframe context.
    ev = iframe_fixE(ev, ifrm_id);
    if (!ev) return false;

    // Switch into the main frame context (possibly not needed?)
    with (window.parent)
    {
        on_iframe_mouseup(ev, ifrm_id);
    }

    return true;
}


// mk_iframe_mouse_event_handlers - Create custom callback functions for
// each iframe id. This is wasteful,
// but I don't know another way to determine the iframe id from within
// the event handler.
function mk_iframe_mouse_event_handlers(ifrm_id)
{
    var frm = $j(ifrm_id);
    if (!frm)
    {
        // Since we are invoked by a callback function, it is possible that the frame
        // would be deleted by the time we get here (e.g. if the user toggles the
        // "show preview" button several times quickly).
        //clogger.debug("mk_iframe_mouse_event_handlers - frm no longer exists for ifrm_id=" + ifrm_id);
        return;
    }

    if (FF)
        var frm_doc = frm.contentDocument;
    else
        var frm_doc = window.frames[ifrm_id].document;

//clogger.debug("mk_iframe_mouse_event_handlers - frm_doc = " + frm_doc);
    // Make mousemove & mouseup callbacks for each iframe.
/*    var mm_cb = mk_mm_cb(ifrm_id);
    var mu_cb = mk_mu_cb(ifrm_id); */

    var mm_cb = function(ev) { handle_iframe_mousemove(ev, ifrm_id); }
    var mu_cb = function(ev) { handle_iframe_mouseup(ev, ifrm_id); }

    // TODO: We are overriding the global handlers for the target page (rather than
    // using something like addEvent). That's fine for edit mode previews, but we
    // wouldn't want to do it for use mode, as it may interfere w/ the operation of
    // certain pages (e.g. the topology viewer).
    frm_doc.onmousemove = mm_cb
    frm_doc.onmouseup = mu_cb;
}



