/******************************
 Top Sessions
 Init by J. Thompson, Jan 2008
 Based on jsconsole_init.js
 Copyright Fortinet, inc.
 All rights reserved
 ******************************/

// EXPORT_SYMBOL dashboard_detach_sessions
// EXPORT_SYMBOL on_ts_call_back_clicked
// EXPORT_SYMBOL top_sessions_init

// EXPORT_SYMBOL change_sessions_display
// EXPORT_SYMBOL load_saved_sessions_iframe

/******************************
        Initialization
 ******************************/

var other_sessions_elems = new Array("_customize", "_popup");

// set_sessions_elems_visibility - enable/disable the buttons on the widget
// navigation bar (refresh/edit/detach/close) depending on detached state. Also,
// the detach message is shown or hidden.
function set_sessions_elems_visibility(open_hdl, id, enable)
{
    try 
    {
        var doc = open_hdl.document;
        var i, elem;

        // Hide or show the sessions iframe 
        elem = doc.getElementById("db_" + id + "_iframe");
        if (elem)
        {
            elem.style.display = enable ? "" : "none";
        }

        // If the sessions iframe is hidden, show the detached message
        st = enable ? "hidden" : "visible";
        var disp = enable ? "none" : "block";

        elem = doc.getElementById("db_" + id + "_detach_msg");
        if (elem)
        {
            elem.style.visibility = st;
            elem.style.display = disp;
        }

        // For the customize & detach buttons, these are now enabled/disabled by the D&D dashboard title
        // bar mouseover. The reason this still works is because we set the visibility to visible/hidden,
        // whereas the dashboard sets the display to block/none. So we don't stomp on each others' feet.
        var st = enable ? "visible" : "hidden";
        for (i=0; i < other_sessions_elems.length; i++)
        {
            elem = doc.getElementById("db_" + id + other_sessions_elems[i]);
            if (elem)
                elem.style.visibility = st;
        }
    }
    catch (e)
    {
//        debug_msg("Failed to set console elems visibility" + e);
    }
}


// hide_sessions_window - hide the top sessions widget on the dashboard.
function hide_sessions_window(open_hdl, id)
{
    set_sessions_elems_visibility(open_hdl, id, false);
}

// show_sessions_window - show the top sessions widget on the dashboard.
function show_sessions_window(open_hdl, id)
{
    set_sessions_elems_visibility(open_hdl, id, true);
}


// top_sessions_init - initialize the top sessions widget 
function top_sessions_init(id)
{
    // Many segements of the initialization depend on whether this is the
    // dashboard widget or the detached sessions widget.
    var is_popup = (window.opener != null);

    // Auto-resize the popup window. The dashboard widget is not resized,
    // as there are various onload handlers in the content of the widget
    // to do this already.
    if (is_popup)
    {
        do_auto_resize("db_" + id + "_iframe");
    }

    if (is_popup)
    {
        // If the dashboard widget is being detached, we need to load the
        //  popup window from the current dashboard state. 
        try
        {
            // TODO: A future enhancement would preserve the page number or other
            // details of the session widget at the time of detach.
            load_saved_sessions_iframe(true, id);
        }
        catch (e)
        {
//            debug_msg("Failed to transfer sessions state.");
        }
    }
    else
    {
        // If we are in the main window, and browsing back to the status page, try
        // to restore the saved state from the logo frame.
        try
        {
            var wdg_prop = get_logo_obj(id);

            if (wdg_prop.detached)
            {
                // The sessions widget is currently detached
                hide_sessions_window(window, id);
            }
            else
            {
                // The page onload handlers will automatically update the height of
                // this iframe.
                load_saved_sessions_iframe(false, id);
            }
        }
        catch (e)
        {
//            debug_msg("Failed to load saved sessions state.");
        }
    }
    
    // If we are detaching then update the variable in the header frame and send a message 
    // to the dashboard window so it can update its state (e.g. hide the sessions widget).
    if (is_popup)
    {
        // Make the opener window blank
        try
        {
            var opener_hdl = window.opener;
            var wdg_prop = get_logo_obj(id);

            if (wdg_prop)
            {
                wdg_prop.detached = true;
            }

            // Click the hidden button on the opener window to send a notification message.
            var oElem = opener_hdl.document.getElementById("db_" + id + "_call_back");
            if(oElem)
                oElem.click();

            // Initialize some event handlers for the widget.
            init_sessions_event_handlers(id);
        }
        catch (e)
        {
        }
    }
}

// init_sessions_event_handlers - initialize the event handlers for resizing 
// This is curently only used for the pop-up widget. The dashboard wigets should
// auto-resize on their own if the window changes.
function init_sessions_event_handlers(id)
{
    window.onbeforeunload = function(evt) {
        on_close_sessions_popup(evt, id);
    }

    $j(window).resize( function(evt) {
        sessions_resize_handler(evt, id);
    });
}

/******************************
     Window Size functions
 ******************************/

// popup_min_sz - minimum size of the popup window. These values match
// the default widget size when detaching, and are roughly the minimum
// size of chart we support.
var popup_min_sz = {
    h: 320,
    w: 650
};

// sessions_resize_handler - window.onresize event handler
// Adjust the div & iframe elements to have the appropriate size - this is a wrapper
// for resize_handler (wij_detach.js).
function sessions_resize_handler(evt, id)
{
    var wdg_prop = get_logo_obj(id);

    // Time in milliseconds to wait before resizing the image
    var rsz_timeout = 500;

    // rsz_timeout - this is used to delay the auto-resize until a small period of
    // time has passed since we have received on an onresize event. This will help
    // mitigate the number of requests sent for various sized chart images.
    if (wdg_prop.rsz_timeout_h)
    {
        // If we receive an onresize event and we are currently already scheduled to
        // resize the popup, we need to clear that request and start over until
        // a period of time has passed (rsz_timeout).
        clearTimeout(wdg_prop.rsz_timeout_h);
    }

    wdg_prop.rsz_timeout_h = setTimeout(function() {
        resize_handler(evt, 'db_' + id + '_iframe');

        update_widget_frame(id, "/system/widget/sessions");
    }, rsz_timeout);
}


/******************************
         Cleanup
 ******************************/

// on_close_sessions_popup - onbeforeclose handler for the popup console.
// The current behaviour is to reattach the console to the dashboard and
// preserve the current state.
function on_close_sessions_popup(evt, id)
{
    // window.opener shouldn't normally be null here. If the main window is closed, we
    // would be automatically closed before it happened. However, if the console was
    // originally detached from inside a widget, then we may very well lose our back
    // pointer to the opener (which was an iframe). Thus we always keep a cached reference
    // to the logo frame just for this reason.
    // TODO: the cached reference to the logo frame doesn't work in IE if the parent
    // window is closed.
    var opener_hdl = window.opener;
    var wdg_prop = get_logo_obj(id);

    try
    {
        wdg_prop.detached = false;

        // Save the current session state in the logo frame so that the dashboard widget
        // can recover to the same position we were in before.
        save_sessions_state(id);

        // Try to click one hidden button on opener window to begin polling
        // TODO: this doesn't look like it will be compatible with widgetization.
        var oElem = opener_hdl.document.getElementById("db_" + id + "_call_back");
        if(oElem)
            oElem.click();

        // hPopupSessions doesn't need to be to set to "null" here because in dashboard.js
        // we check if it is defined & still open ("not closed").
    }
    catch(e)
    {
//        logo_frm.console.log("error2 in on_close_console_popup: " + e);
    }
}
function is_sessions_table_page(url)
{
    if(url.indexOf('session_table') != -1)
        return true;

    return false;
}

// save_sessions_state - This is used to preserve the view state when switching from
// the dashboard widget to the detached popup window. Currently the only thing
// we save is whether or not the user was viewing the "details" page or the standard
// chart/table view.
function save_sessions_state(id)
{
    var sessions_iframe = document.getElementById("db_" + id + "_iframe");
    var wdg_prop = get_logo_obj(id);

    if (wdg_prop)
    {
        if (is_sessions_table_page(sessions_iframe.src))
        {
            wdg_prop.details = true;

            // TODO: As discussed in comments elsewhere, it could be useful to preserve
            // the session list page number that is currently being viewed.
        }
        else
        {
            wdg_prop.details = false;
        }
    }
}

// load_saved_sessions_iframe - This function will set the source for the
// top sessions iframe based on the current saved settings stored in the
// logo frame.
// If show_table is set, then we are interested in the value of 
// "sessions_details", which is used to indicate whether or not we are
// looking at the detailed view when attaching & detaching. When this
// value is false, we will always show chart/table view.
function load_saved_sessions_iframe(show_table, id)
{
    // The default address for the top sessions widget, if no settings
    // are present yet.
    var new_url = "/system/widget/sessions";

    var sessions_iframe = document.getElementById("db_" + id + "_iframe");

    var wdg_prop = get_logo_obj(id);

    if (show_table && wdg_prop.details)
    {
        new_url = "/system/widget/session_table";
    }

    if (sessions_iframe)
    {
        // The onload handler for the iframe is set to null here to avoid
        // an infinite refresh loop when setting the source below.
        sessions_iframe.onload = null;

        // The iframe src is intentionally undefined on page load. The onload
        // handler for the iframe will set the source to the appropriate
        // address given the current stored settings.
        change_sessions_display(new_url, id);
    }
}

// dashboard_detach_sessions - detach the top sessions widget from the 
// dashboard and display it in a new window.
function dashboard_detach_sessions(id)
{
    var wdg_prop = get_logo_obj(id);

    save_sessions_state(id);

    // Launch the popup window using the approximate final size.
    var new_wnd = popup_nonscrollable('/system/widget/sessions_detach?id=' + id, 'sessions_' + id, 600, 425);

    wdg_prop.hPopupHandle = new_wnd;
}



// Call back function to be called in the opener window when something happens
// on the popup window.
// flag: 0 -- the consolecustomize page is called, we need to parse the cookie
//       1 -- when the detached window is attached back, we need to enable/disable
//            the connection/disconnection buttons and begin polling
function on_ts_call_back_clicked(flag, id)
{
    switch(flag) {
        // NOTE: The console page has an additional case here to support preference
        // changes while detached. This may need to be revised if the dashboard
        // flicker is an issue.

        case 1: // called on both detach and re-attach.

            var wdg_prop = get_logo_obj(id);

            // Show/hide the console widget elements
            if (wdg_prop.detached)
            {
                hide_sessions_window(this, id);
            }
            else
            {
                // This should start the refresh timer again.
                load_saved_sessions_iframe(true, id);

                show_sessions_window(this, id);
            }

            break;
    }
}

// add_sessions_filter - Creates a single filter entry to add to
// the sessions filter cookie.
function add_sessions_filter(filter)
{
    var filter_display = new FilterDisplay(filter.field, 0, 1, 0, 0, [filter.value]);

    filter_display.toArray = function toArray() {
        return new Array(this.fieldName, this.enable, this.negate, this.contains, 0, this.value);
    };

    return filter_display;
}

// Clear/set filters for the sessions list page
function set_sessions_filter(filter)
{
    var filterCookieArray = [];

    if (filter.field && filter.value)
    {
        setFilterDisplay(filterCookieArray, add_sessions_filter(filter));
    }
    else if (filter.length)
    {
        for (var i=0; i<filter.length; i++)
        {
            setFilterDisplay(filterCookieArray, add_sessions_filter(filter[i]));
        }
    }

    return serializeArray(filterCookieArray);
}


function change_sessions_display(url, id, filter)
{
    var page_url = url + "?id=" + id;
    var old_frame = document.getElementById("db_" + id + "_iframe");
    if (!old_frame)
    {
        old_frame = window.frameElement;
    }

    // When changing the sessions iframe location, a filter can be passed in
    // to either a) clear all current filters, or b) apply some new ones.
    // This is used when drilling down into the current sessions list from the
    // top sessions widget.
    if (filter)
    {
        var sflt = set_sessions_filter(filter);
        page_url += "&filter=" + escape(sflt);
        if (filter.ipver)
            page_url += "&af=" + filter.ipver;
    }

    // Scrolling is applied when we are viewing the session list.
    var frame_scroll = "no";
    if (is_sessions_table_page(page_url) || filter)
    {
        frame_scroll = "auto";
    }

    // The scrolling attribute cannot be changed on a loaded iframe in
    // MSIE. Here we add a browser specific function to replace the iframe
    // with a new one (same properties), with the scrolling attribute changed.
    if ($j.browser.msie)
    {
        msie_replace_iframe(old_frame, frame_scroll, page_url);
        return;
    }

    // Other browsers can change scrolling as expected.
    old_frame.scrolling = frame_scroll;
    old_frame.src = page_url;
}

// msie_replace_iframe - Replace an iframe with a new one, changing
// the scrolling attribute and/or the URL.
// NOTE: This method generally also works in other browsers, however occasionally
// the replaced iframe is duplicated into other frames in the document. The
// preferred method for other browsers is to change the scrolling attribute directly
// as is done in change_sessions_display.
function msie_replace_iframe(old_frame, frame_scroll, page_url)
{
    var old_w = old_frame.style.width;
    var old_h = old_frame.style.height;

    // We create a new iframe here and replace the old one to get around
    // an IE issue that won't allow the scrolling attribute to be modified.
    var iframe_html =
            "<iframe class=\"widget-iframe\" " +
            " id=\"" + old_frame.id + "\" scrolling=\"" + frame_scroll + "\"" +
            " style=\"height: " + old_h + "; width: " + old_w + ";\"" +
            " src=\"" + page_url + "\"" +
            "></iframe>\n";

    jQuery(old_frame).parent().html( iframe_html );

    return false;
}


/******************************
 wij_detach.js - Detaching & auto-resizing related functions
 Init by A. Krywaniuk, Jan 2006
 Split from jsconsole.js and jsconsole_init.js by J. Thompson
 Copyright Fortinet, inc.
 All rights reserved
 ******************************/

//EXPORT_SYMBOL get_logo_obj

// get_logo_frame - access the logo (header) frame, taking into account that:
// a) this may be a popup window or inline
// b) the parent may be a widget rather than a standalone page.
function get_logo_frame()
{
    var wnd = window;
    var opener = wnd.opener || wnd.parent.opener;

    if (opener)
    {
        wnd = opener.parent || opener;
    }

    return wnd.top;
}

function get_logo_obj(id)
{
    var wdg = get_logo_frame().widget_states;
    if (!wdg)
    {
        // Note that this is really an error, as if the widget_states object
        // is not located, it means get_logo_frame found the wrong window.
        // Using an empty object will allow modules that depend on this to
        // run as expected, but may have some side-effects.
        wdg = new Object();
    }

    var key = '' + id;
    var obj = wdg[key];

    if (!obj)
    {
        obj = wdg[key] = new Object();
    }

    return obj;
}

// Set the checkbox value to true or false on logo frame
// name_t:   checkbox id on logo frame
// value_t:  true or false
function set_logo_checkbox(name_t, value_t)
{
	var logo_frm = get_logo_frame();
	var logo_doc = logo_frm.document;
	var oElem = logo_doc.getElementById(name_t);
	oElem.checked = value_t;
}

// Set the text box value on logo frame
// name_t:   text box id on logo frame
// value_t:  value
function set_logo_text(name_t, value_t)
{
	var logo_frm = get_logo_frame();
	var logo_doc = logo_frm.document;
	var oElem = logo_doc.getElementById(name_t);
	oElem.value = value_t;
}


/******************************
     Window Size functions
 ******************************/

// wnd_size_st - This object is used by the popup window to cache
// various size values. Currently, only the sessions widget &
// console use it. If it is determined that they both require a 
// local copy, this should be moved into the individual modules and
// use references below.
var wnd_size_st = {
	already_resized: false,
	need_resync: false,
	
	// Window size
	orig_w: 0,
	orig_h: 0,
	auto_w: 0,
	auto_h: 0,
	cur_w: 0,
	cur_h: 0,
	
	// Frame size
	orig_fw: 0,
	orig_fh: 0,
	
	// Div size
	orig_dw: 0,
	orig_dh: 0,
	auto_dw: 0,
	auto_dh: 0
};

// sz_obj - global object to hold size calculations.
// Used to hold the return value of calc_client_sz, calc_elem_sz, etc.
var sz_obj = {
	w:0,
	h:0
};

function calc_client_sz(rv)
{
  var x = window; 
  var myW = 0, myH = 0, d = x.document.documentElement, b = x.document.body;
	  if( x.innerWidth ) { myW = x.innerWidth; myH = x.innerHeight; }
	  else if( d && d.clientWidth ) { myW = d.clientWidth; myH = d.clientHeight; }
	  else if( b && b.clientWidth ) { myW = b.clientWidth; myH = b.clientHeight; }
	
	rv.w = myW;
	rv.h = myH;
}

function calc_elem_sz(id, rv)
{
	var elem = document.getElementById(id);
	rv.w = parseInt(elem.style.width);
	rv.h = parseInt(elem.style.height);
}

function calc_autodiv_sz(rv)
{
	calc_elem_sz('autosizing_div', rv);
}


/* Window resizing event handlers:

 We want to do two things when the window is resized:
 
 1. Adjust the size of the console window to match the outer window.
 2. Prevent the user from resizing the window beyond a certain minimum size.
 
 Unfortunately, this is amazingly complicated to do (not surprisingly, pretty much
 every API function works differently on each browser). For the most part, the
 size adjustment of the console window works well. The difficulties come in adjusting
 for the case where the window goes below the minimum size.
 
 Complications:
 
 1. I didn't see any way to retrieve both the new size and the old size at the same
 time, so we store the previous values in a global variable.
 2. IE seems to receive this event twice. The second call is basically sprurious.
 3. We have to deal with the client area of the window, which is different from the
 size of the window frame.
 4. If we call resizeTo() or resizeBy() from the onresize handler, we have to deal
 with various amounts of recursion.
 
 Issues 3 & 4 means that we can't just resize exactly to the desired final size.
 Basically, we have to take an iterative approach and be happy if the final size is
 within close enough limits. (Also, we layout the page in such a way that most of
 the realignment happens automatically.)

 There is also a strange bug that I could only reproduce on old Mozilla. If the user
 resizes the window below the minimum reasonable size (at which it can display all
 the content), then scrolls the client area (using the mouse drag), then resizes
 the window again (to make it bigger), the clipping area won't match the client area
 and there will be garbage displayed on the screen. We use an extra scrollTo to
 correct that problem.
 
 Various error messages come up in the Javascript console about failure to parse the
 value for attribute height or width. I'm not sure exactly when these errors are
 generated, but they don't appear to come from the JS in this file. (It is possibly due 
 to an attempt to read the values before the window is redrawn.
 
*/

// resize_handler - window.onresize event handler
// Adjust the div & iframe elements to have the appropriate size.
function resize_handler(evt, iframe_id)
{
	// save old size
	var old_w = wnd_size_st.cur_w;
	var old_h = wnd_size_st.cur_h;

	// store new size
	calc_client_sz(sz_obj);
	wnd_size_st.cur_w = sz_obj.w;
	wnd_size_st.cur_h = sz_obj.h;
	
	// reset the semaphore
	wnd_size_st.need_resync = false;

	// Don't do anything else if we are still in the auto-size phase.
	if (!wnd_size_st.already_resized)
	{
		return;
	}

//	debug_msg("resizing: width " + old_w + "->" + wnd_size_st.cur_w);
//	debug_msg("resizing: height " + old_h + "->" + wnd_size_st.cur_h);
	
	// Base all the adjustments relative to the initial (auto-calculated)
	// window & div size.
	var dw = wnd_size_st.cur_w - wnd_size_st.auto_w;
	var dh = wnd_size_st.cur_h - wnd_size_st.auto_h;
	
	try
	{
		var em_ifrm = document.getElementById(iframe_id);
		if (em_ifrm)
		{
			em_ifrm.style.width = "" + (wnd_size_st.orig_fw + dw) + "px";
			em_ifrm.style.height = "" + (wnd_size_st.orig_fh + dh) + "px";
		}
	}
	catch (e)
	{
		// This fails in IE when you try to resize the frame to be larger
		// than the current dimensions of the window. It should correct
		// itself iteratively.
	}
	
	try
	{
		em_div = document.getElementById('autosizing_div');
		if (em_div)
		{
			em_div.style.width = "" + (wnd_size_st.auto_dw + dw) + "px";
			em_div.style.height = "" + (wnd_size_st.auto_dh + dh) + "px";
		}
	}
	catch (e)
	{
		// This fails on IE for some reason. However, the layout generally
		// looks ok.
	}
	
	// Don't let the user set the size below a certain minimum.
	// We can't prevent them from doing it, but we can immediately revert
	// the change.
	var rsz_w = 0;
	var rsz_h = 0;
	
	// Resize a minimum of 50 pixels at a time - we are comparing the client area 
	// with the frame size here, so the values aren't going to match exactly.
	if (wnd_size_st.cur_w < popup_min_sz.w)
		rsz_w = Math.max(popup_min_sz.w - wnd_size_st.cur_w, 50);
	if (wnd_size_st.cur_h < popup_min_sz.h)
		rsz_h = Math.max(popup_min_sz.h - wnd_size_st.cur_h, 50);

	// The reason we use resizeBy rather than resizeTo is because the outer window
	// contains various non-client elements (e.g. status bar), and it's difficult
	// for us to predict the size. If we got it wrong, we could get into an endless
	// loop. With resizeBy, we are guaranteed to terminate.
	if (rsz_w || rsz_h)
	{
		var new_cmd = "window.resizeBy(" + rsz_w + "," + rsz_h + ");";
		setTimeout(new_cmd, 5);
	}
	
	
	// Fix the old-Mozilla clipping area bug.
	// We don't want to run this on IE. (Possibly there are bad side effects.)
	if (evt)
	{
		try
		{
			setTimeout("window.scrollTo(0,0);", 2);
		}
		catch (e)
		{
		}
	}
}

// store_orig_size - store the size of the window prior to the auto-resize.
// (this is probably not needed)
function store_orig_size(iframe_id)
{
	calc_client_sz(sz_obj);
	wnd_size_st.orig_w = sz_obj.w;
	wnd_size_st.orig_h = sz_obj.h;
	
	calc_autodiv_sz(sz_obj);
	wnd_size_st.orig_dw = sz_obj.w;
	wnd_size_st.orig_dh = sz_obj.h;
	
	calc_elem_sz(iframe_id, sz_obj)
	wnd_size_st.orig_fw = sz_obj.w;
	wnd_size_st.orig_fh = sz_obj.h;
}

// store_auto_size - store the size of the window after the auto-resize.
// (all future adjustments are calculated relative to this size)
function store_auto_size()
{
	calc_client_sz(sz_obj);
	wnd_size_st.auto_w = sz_obj.w;
	wnd_size_st.auto_h = sz_obj.h;

	calc_autodiv_sz(sz_obj);
	wnd_size_st.auto_dw = sz_obj.w;
	wnd_size_st.auto_dh = sz_obj.h;
}


// do_auto_resize - called when the popup window is loaded, or
// when the layout changes.
function do_auto_resize(iframe_id)
{
	if (!wnd_size_st.already_resized)
	{
		store_orig_size(iframe_id, wnd_size_st);
		auto_resize_popup();
		store_auto_size(wnd_size_st);
		wnd_size_st.already_resized = true;
	}
}



