/******************************
 wij_string.js - String table for the widget & navbar framework
 Init by A. Krywaniuk, May 2008
 GUI widgetization project
 Copyright Fortinet, inc.
 All rights reserved
 ******************************/

/* Symbols referenced by the C modules: */
//EXPORT_SYMBOL wij_str_tbl

/* Symbols referenced by logo.js: */
//EXPORT_SYMBOL wij_string


// wij_def_str_tbl - untranslated strings. The '#' is a special marker that indicates
// that a string has not been translated. (This is to help us catch errors during
// testing without affecting functionality.)
var wij_def_str_tbl = {

    // Strings used by several frames:
    create_new : "#[Create New...]",
    def_menu_name : "#custom menu",
    edit : "#Edit",
    close : "#Close",
    save : "#Save",
    btn_save : "#Save",
    cancel : "#Cancel",
    edit_layout : "#Edit Layout",
    add_content : "#Add Content",

    // Strings used by the navbar frame:
    err_save_menu_failed : "#Failed to save menu configuration",
    save_in_progress : "#Saving...",
    reset_menus : "#Reset menus",
    err_no_access : "#The requested page has been disabled by an administrator.",
    current_vdom : "#Current VDOM",
    global : "#Global",

    // Strings used by the icontainer frame:
    show_preview : "#Show Preview",
    preview_unavailable : "#Preview not available",
    hide_preview : "#Hide Preview",
    no_page : "#No page is being displayed.",
    cant_customize : "#This page cannot be customized.",
    warn_unsaved_data : "#One or more of the windows in this page contains unsaved data.",

    // Strings used by the add contents page:
    at_widget_limit : "#The maximum number of widgets per page has been reached.",
    search : "#Search",
    ac_dlg_title1 : "#Add content to the",
    ac_dlg_title3 : "#tab",
    Categories : "#Categories",

    // Strings used by the edit layout page:
    name : "#Name:",
    layout : "#Layout:",
    full_page : "#Full page",
    one_column : "#1 column",
    two_column : "#2 columns",
    el_dlg_title : "Edit this tab",

    // Strings used by the widget customize page:
    updating : "#Updating...",
    header_color : "#Header Color",
    reset : "#reset",
    wcu_dlg_title : "Customize this widget",
    comment : "#Comment",
    height : "#Height",
    pixels : "#(pixels)",

    // Strings used by the context menus:
    hide_menu : "#hide",
    rename_menu : "#rename",
    del_menu : "#delete",
    reset_def_menu : "#reset to default",
    newchild_menu : "#create new",
    reset_menu : "#reset all",
    showall_menu : "#show all",
    hideall_menu : "#hide all",

    // For the sake of IE, make sure the final entry doesn't have a trailing comma.
    dummy: ""
};

var wij_str_tbl = {};

// Placeholder marker for the pre-processor module to insert the custom
// string table.
// NOTE: be wary of strings containing embedded quote characters, since these can cause
// fatal JS errors.
// %%EXTRA_SCRIPTS%%

// The "save" attribute causes some conflicts in the logo frame, so we rename it but provide
// a backwards compatibility path.
if (wij_str_tbl["save_btn"])
    wij_str_tbl["save"] = wij_str_tbl["save_btn"];

// wij_string - main string lookup API for the wij framework.
function wij_string(id)
{
    // Return the translated string. If this doesn't exist, it is an
    // error (or we are doing some offline testing).
    var str = wij_str_tbl[id];
    if (str) return str;

    // If the translated string doesn't exist, fall back to the default
    // version, or failing that just return the id.
    str = wij_def_str_tbl[id];
    if (str) return str;

    return id;
}

