
MODULE_SYSINFO = "sysinfo"
MODULE_LICINFO = "licinfo"
MODULE_SYSOP = "sysop"
MODULE_SYSRES = "sysres"
MODULE_ALERT = "alert"
MODULE_EVENT = "event-log"
MODULE_STATS = "statistics"
MODULE_JSCONSOLE = "jsconsole"
MODULE_SESSIONS = "sessions"
MODULE_TOP_VIRUSES = "top-viruses"
MODULE_TOP_ATTACKS = "top-attacks"
MODULE_TR_HISTORY = "tr-history"
MODULE_SERVICES = "services"
MODULE_PSESSION = "policy-sessions"
MODULE_GUARD = "fortiguard"

Column_Num = 2;
URL_SysStatus = "/system/status/status";
URL_GetTexts = "/system/status/status_text";
var moduleGhost = document.createElement("div");
moduleGhost.id = "moduleGhost";
dashboard.moduleList = [];
LINK_ON = 1;
LINK_OFF = 0;

timer_sess = null;

function findPosX(obj) {
	var curleft = 0;
	if (obj && obj.offsetParent) {
		while (obj.offsetParent) {
			curleft += obj.offsetLeft;
			obj = obj.offsetParent;
		}
	} else if (obj && obj.x) curleft += obj.x;
	return curleft;
}

function findPosY(obj) {
	var curtop = 0;
	if (obj && obj.offsetParent) {
		while (obj.offsetParent) {
			curtop += obj.offsetTop;
			obj = obj.offsetParent;
		}
	} else if (obj && obj.y) curtop += obj.y;
	return curtop;
}

dashboard.getModuleArr = function(column) {
	var arr = [];
	var ln = column.childNodes.length;
	for (var z=0; z<ln; z++) {
		if (!column.childNodes[z].dataObj
			&& column.childNodes[z] != moduleGhost) {
			continue;
		};

		if (!column.childNodes[z].isDragging) {
			arr.push(column.childNodes[z]);
		}
	}
	return arr;
}

dashboard.getGhostPos = function(arr, y) {
	var ln = arr.length;
	for (var z=0; z<ln; z++) {
		if (arr[z]==moduleGhost) return z;
	}
}

dashboard.ifModuleExist = function(id) {
	for(var i=0; i < dashboard.moduleList.length; i++) {
		if (id == dashboard.moduleList[i].dataObj.id)
			return 1;
	}
	return 0;
}

dashboard.start = function() {
	var container = $("modulesArea");
	dashboard.columnsObj = {};

	//column #1
	var col1 = document.createElement("td");
	col1.style.minHeight = "1px";
	col1.className = "column_layout_" + Column_Num;
	col1.setAttribute("colnum", 1);
	dashboard.columnsObj.col1 = col1;

	//column #2
	var col2 = document.createElement("td");
	col2.style.minHeight = "1px";
	col2.className = "column_layout_" + Column_Num;
	col2.setAttribute("colnum", 2);
	dashboard.columnsObj.col2 = col2;

	container.appendChild(col1);
	container.appendChild(col2);

	function displayModules(response) {
		var rootNode = response.responseXML.documentElement;
		//alert(response.responseText);
			var mods = rootNode.getElementsByTagName("module");
			
			for (var m=0; m<mods.length; m++) {
				dashboard.addModule(mods[m]);
			}

	}
	
	Request.sendGET(URL_SysStatus + "?getPage=1&nocache="+Math.random(), displayModules);
} //end of dashboard.start()

var callbackRedirect = function(response)
{
	var len = response.responseText.indexOf(":");
	var val = response.responseText.substring(len+1, response.responseText.length);

	if(val == "noaccess")
	{
		window.document.location = "/noaccess";
	}
}

var Module = function(obj) {
	var self = this;
	this.dataObj = obj;
	this.isNew = (obj.isNew) ? true : false;
	this.refreshMode = true;
	this.fireOnShowHide = false;
	
	this.build = function() {

		var divModule = document.createElement("div");
		this.elm_module = divModule;
		divModule.className = "module";
		divModule.dataObj = obj;
		divModule.style.display = 'block';

		var divModuleFrame = document.createElement("div");
		this.elm_moduleFrame = divModuleFrame;
		divModuleFrame.className = "module_frame";

		var divModuleHeader = document.createElement("div");
		this.elm_moduleHeader = divModuleHeader;
		divModuleHeader.className = "module_header";
		/*
		divModuleHeader.onmouseover = function(){
			self.highlight();
		}
		divModuleHeader.onmouseout = function(){
			self.unHighlight();
		}
		*/
		var divShowHide = document.createElement("button");
		this.elm_showHide = divShowHide;
		divShowHide.className = "module_showhide bare";
		divShowHide.innerHTML = (obj.status==0) ? '<f-icon class="fa-minus"></f-icon>' : '<f-icon class="fa-plus"></f-icon>';
		//divShowHide.style.visibility = "hidden";
		Event.observe(divShowHide, 'mousedown', showHide, false);

		//var divIcon = document.createElement("div");
		//this.elm_icon = divIcon;
		//divIcon.className = "module_icon";
		//divIcon.innerHTML = "<img src='/images/" + obj.icon +"' width='17' height='15'>";
		//divIcon.firstChild.onload = function () {
		//	this.style.display = "block";
		//}

		var divTitle = document.createElement("div");
		this.elm_title = divTitle;
		divTitle.className = "module_title";
		divTitle.appendChild(document.createTextNode(obj.title));

		if (obj.extra)
		{
		var divExtra = document.createElement("div");
		this.elm_extra = divExtra;
		divExtra.className = "module_extra";
		divExtra.appendChild(document.createTextNode(obj.extra));
		}
		else if (obj.id == MODULE_JSCONSOLE)
		{
			// The console requires a span here instead of a text node. The contents of the span will
			// be dynamically updated as the connection status changes.
			var divExtra = document.createElement("div");
			this.elm_extra = divExtra;
			divExtra.className = "module_extra";
			divExtra.innerHTML += "&nbsp<span id=\"jsconn_state\" style=\"vertical-align:bottom\"></span>";
		}

		
		var divClose = document.createElement("button");
		this.elm_close = divClose;
		divClose.className = "module_close bare";
		divClose.innerHTML = '<f-icon class="fa-times" title="' + dashboard.texts.close + '"></f-icon>';//'<img src="/images/db_close.gif" title="' + dashboard.texts.close + '">';
		//divClose.style.display = "none";
		Event.observe(divClose, 'mousedown', close, false);
		
		if (obj.refresh == 1)
		{
		var divRefresh = document.createElement("button");
		this.elm_refresh = divRefresh;
		divRefresh.className = "module_refresh bare";
		divRefresh.innerHTML = '<f-icon class="fa-refresh" title="' + dashboard.texts.refresh +'"></f-icon>';
		//divRefresh.style.display = "none";
		Event.observe(divRefresh, 'mousedown', this.refresh, false);
		}

		if (obj.edit == 1)
		{
			var divEdit = document.createElement("div");
			this.elm_edit = divEdit;
			divEdit.className = "module_edit";
			if (obj.id == MODULE_JSCONSOLE)
			{
				// The console will change the visibility of this id when attached/detached.
				divEdit.id = "jsconn_customize";
				divEdit.innerHTML = '<a href="javascript:on_customize_clicked()"><img src="/images/db_edit.gif" title="' + dashboard.texts.edit +'"></a>';
			}
			else if (obj.id == MODULE_ALERT)
			{
				divEdit.innerHTML = '<a href="javascript:custom_alert_display()"><img src="/images/db_edit.gif" title="' + dashboard.texts.edit +'"></a>';
			}
			else if (obj.id == MODULE_SYSRES)
			{
				divEdit.innerHTML = '<a href="javascript:custom_sysres_display()"><img src="/images/db_edit.gif" title="' + dashboard.texts.edit +'"></a>';
			}
			else if (obj.id == MODULE_GUARD)
			{
				divEdit.innerHTML = '<a href="javascript:custom_guard_display()"><img src="/images/db_edit.gif" title="' + dashboard.texts.edit + '"></a>';
			}
			else if(obj.id == MODULE_EVENT)
			{
				divEdit.innerHTLML = '<a href="javascript:custom_event_display()"><img src="/images/db_edit.gif" title="' + dashboard.texts.edit + '"></a>';
			}
			else if (obj.id == MODULE_SESSIONS)
			{
				divEdit.innerHTML = '<a href="javascript:custom_sessions_display()"><img src="/images/db_edit.gif" title="' + dashboard.texts.edit +'"></a>';
			}
			else if (obj.id == MODULE_TOP_VIRUSES)
			{
				divEdit.innerHTML = '<a href="javascript:custom_viruses_display()"><img src="/images/db_edit.gif" title="' + dashboard.texts.edit +'"></a>';
			}
			else if (obj.id == MODULE_TOP_ATTACKS)
			{
				divEdit.innerHTML = '<a href="javascript:custom_attacks_display()"><img src="/images/db_edit.gif" title="' + dashboard.texts.edit +'"></a>';
			}
			else if (obj.id == MODULE_TR_HISTORY)
			{
				divEdit.innerHTML = '<a href="javascript:custom_tr_history_display()"><img src="/images/db_edit.gif" title="' + dashboard.texts.edit +'"></a>';
			}
			else
				divEdit.innerHTML = '<a href=""><img src="/images/db_edit.gif" title="' + dashboard.texts.edit + '"></a>';

			Event.observe(divEdit, 'mousedown', editModule, false);

			divEdit.style.display = "none";
		}
		
		if (obj.history == 1)
		{
			var divHistory = document.createElement("div");
			this.elm_history = divHistory;
			divHistory.className = "module_history";
			if (obj.id == MODULE_TOP_VIRUSES)
			{
				divHistory.innerHTML = '<a href="javascript:virus_history_display()"><img src="/images/db_history.gif" title="' + dashboard.texts.history + '"></a>';
			}
			else if (obj.id == MODULE_TOP_ATTACKS)
			{
				divHistory.innerHTML = '<a href="javascript:attack_history_display()"><img src="/images/db_history.gif" title="' + dashboard.texts.history + '"></a>';
			}
			else if (obj.id == MODULE_ALERT)
			{
				divHistory.innerHTML = '<a href="javascript:alert_history_display()"><img src="/images/db_history.gif" title="' + dashboard.texts.history + '"></a>';
			}
			else
				divHistory.innerHTML = '<a href=""><img src="/images/db_history.gif" title="' + dashboard.texts.history + '"></a>';

			Event.observe(divHistory, 'mousedown', showHistory, false);

			divHistory.style.display = "none";
		}

		//hyper-links
		if (obj.links.length > 0)
		{
			//links
			var divLinks = document.createElement("div");
			this.elm_links = divLinks;
			divLinks.className = "module_links";
			for(var i=0; i < obj.links.length; i++)
			{
				var l = document.createElement("a");
				l.setAttribute("href", obj.links[i].url);
				l.appendChild(document.createTextNode(obj.links[i].name));
				divLinks.appendChild(l);
				Event.observe(l, "mousedown", openLink, true);
			}
			//divLinks.style.display = "none"; /*fixed bug 0298918*/
			
			// The console will change the visibility of this id when attached/detached.
			if (obj.id == MODULE_JSCONSOLE)
				divLinks.id = "jsconn_popup";
		}
		var divModuleContent = document.createElement("div");
		this.elm_moduleContent = divModuleContent;
		divModuleContent.className = "module_content";
		divModuleContent.innerHTML = "<img src='/images/loading.gif'>";
		if (obj.status==0) divModuleContent.style.display = "none";
		
		divModuleHeader.appendChild(divTitle);
		divModuleHeader.appendChild(divShowHide);
		if (divRefresh) divModuleHeader.appendChild(divRefresh);
		divModuleHeader.appendChild(divClose);
		if (divEdit)    divModuleHeader.appendChild(divEdit);
		if (divHistory) divModuleHeader.appendChild(divHistory);
		if (divLinks)   divModuleHeader.appendChild(divLinks);
		
		//divModuleHeader.appendChild(divIcon);
		if (divExtra)   divModuleHeader.appendChild(divExtra);
		
		divModuleFrame.appendChild(divModuleHeader);
		divModuleFrame.appendChild(divModuleContent);

		divModule.appendChild(divModuleFrame);

		Drag.init(divModuleHeader, divModule);
		divModule.onDragStart = function(x,y,mousex, mousey) {
			var left = findPosX(this);
			var top = findPosY(this);
			var w = this.offsetWidth;
			this.style.width = (w-5)+"px";
			this.style.left = (left-5)+"px";
			this.style.top = (top-4)+"px";
			moduleGhost.style.height = this.offsetHeight+"px";
			this.parentNode.insertBefore(moduleGhost, this);
			this.style.position = "absolute";
			this.isDragging = true;
			dashboard.draggingItem = true;
			moduleGhost.col=this.parentNode;
			
			this.col1X = findPosX(dashboard.columnsObj.col1);
			this.col2X = findPosX(dashboard.columnsObj.col2);
			moduleGhost.style.display = "block";
		}
		divModule.onDrag = function(x,y, mousex, mousey) {
		
			var op = 100;
			this.style.opacity = op/100;
			this.style.filter = 'alpha(opacity=' + op + ')';
				
			if ((x+this.offsetWidth/2)>=this.col1X) col=dashboard.columnsObj.col1;
			if ((x+this.offsetWidth/2)>=this.col2X) col=dashboard.columnsObj.col2;
			
			if (moduleGhost.col!=col) {
				Element.remove(moduleGhost);
				moduleGhost.col = col;
				col.appendChild(moduleGhost);
			}
			var elems = dashboard.getModuleArr(col);
			var myPos = dashboard.getGhostPos(elems, y);
			
			if (myPos!=0 && y<=findPosY(elems[myPos-1])) {
				Element.remove(moduleGhost);
				col.insertBefore(moduleGhost, elems[myPos-1]);
			}
			if (myPos!=(elems.length-1) && y>=findPosY(elems[myPos+1])) {
				if (elems[myPos+2]) {
					col.insertBefore(moduleGhost, elems[myPos+2]);
				} else {
					col.appendChild(moduleGhost);
				}
			}
		}
		divModule.onDragEnd = function(x,y,el) {
			this.isDragging = false;
			var op = 100;
			this.style.opacity = op/100;
			this.style.filter = 'alpha(opacity=' + op + ')';
			
			//self.unHighlight();

			obj.container = moduleGhost.col.getAttribute("colnum");
			var col = moduleGhost.col;
			if (!moduleGhost.parentNode) {
				moduleGhost.col.appendChild(moduleGhost);
			}
			col.insertBefore(this, moduleGhost);
			Element.remove(moduleGhost);
			dashboard.saveDashboard();
			dashboard.draggingItem = false;
			this.style.position = "static";
			this.style.width = "auto";
		}

		function showHide(e) {
			e.cancelBubble = true;
			self.showHideModule();
			var obj = self.dataObj;
			Request.sendGET(URL_SysStatus + "?trigger=" + obj.id + "&status=" + obj.status + "&nocache=" + Math.random() + "&session_id=" + session_id, callbackRedirect);
		}
		function close(e) {
			e.cancelBubble = true;
			self.close();
		}
		function openLink(e) {
			e.cancelBubble = true;
		}

		if (Number(obj.container) > 0) {
			if (this.isNew && dashboard.columnsObj["col"+obj.container].hasChildNodes()) {
				dashboard.columnsObj["col"+obj.container].insertBefore(divModule, dashboard.columnsObj["col"+obj.container].firstChild);
			} else {
				dashboard.columnsObj["col"+obj.container].appendChild(divModule);
			}
		}

	} 

	this.refresh = function(e) {
		if (e) e.cancelBubble = true;
//		self.elm_moduleContent.innerHTML = "<img src='/images/loading.gif'>";
		self.elm_moduleContent.style.height = self.elm_moduleContent.offsetHeight + "px";
		self.elm_moduleContent.style.width = self.elm_moduleContent.offsetWidth + "px";
		self.elm_moduleContent.innerHTML = "<table align=center height='100%'><tr><td valign=middle><img src='/images/loading.gif'></td></tr></table>";
		self.attachContent();
	}

	function editModule(e) {
		if (e) e.cancelBubble = true;
		if (self.dataObj.id == MODULE_JSCONSOLE) return;

	}

	function showHistory(e) {
		if (e) e.cancelBubble = true;
	}

	this.highlight = function() {
				this.elm_showHide.style.visibility = "visible";
				this.elm_showHide.style.width = "17px";
				this.elm_icon.style.display = "none";
				this.elm_close.style.display = "block";
				if (this.dataObj.id == MODULE_JSCONSOLE)
				{
					if (top.window.hPopupConsole != null &&
						top.window.hPopupConsole.closed != true)
						this.elm_close.style.display = "none";
				}
				if (this.elm_links) this.elm_links.style.display = "block";
				if (this.elm_refresh) this.elm_refresh.style.display = "block";
				if (this.elm_edit) this.elm_edit.style.display = "block";
				if (this.elm_history) this.elm_history.style.display = "block";
	}

	this.unHighlight = function() {
			this.elm_showHide.style.visibility = "hidden";
			this.elm_showHide.style.width = "0px";
			this.elm_icon.style.display = "block";
			this.elm_close.style.display = "none";
			if (this.elm_refresh) this.elm_refresh.style.display = "none";
			if (this.elm_links) this.elm_links.style.display = "none";
			if (this.elm_edit) this.elm_edit.style.display = "none";
			if (this.elm_history) this.elm_history.style.display = "none";
	}

	this.showHideModule = function() {
		if (arguments[0] != undefined) {
			arguments[0] ? this.show() : this.hide();
		} else {
			this.elm_moduleContent.style.display=='none' ? this.show() : this.hide();
		}
	}

	this.close = function() {
		if (window.confirm(dashboard.texts.confirm_close + ' ' + obj.title + '?')) {
				
				var ln = dashboard.moduleList.length;
				for (var z=0; z<ln; z++) {
					if (self == dashboard.moduleList[z]) {
						dashboard.moduleList.splice(z, 1);
						break;
					}
				}
				
				Element.remove(this.elm_module);
				dashboard.addContent.update(self.dataObj.id, LINK_ON);
                Request.sendGET(URL_SysStatus + "?delete=" + obj.id + "&nocache=" + Math.random() + "&session_id=" + session_id, callbackRedirect);

				delete self;
				return true;
		}
		return false;
	}
	this.show = function() {
		this.elm_module.style.display = 'block';
		this.elm_moduleContent.style.display = 'block';
		this.elm_showHide.firstChild.className = "fa-minus";//.setAttribute("src", "/images/fa-minus.gif");
		obj.status = 1;

		// Ensure correct height is set for widgets which display in iframes
		if (obj.id == MODULE_SESSIONS)
			update_iframe_height('top_sessions_iframe');
		else if (obj.id == MODULE_TOP_VIRUSES)
			update_iframe_height('top_viruses_iframe');
		else if (obj.id == MODULE_TOP_ATTACKS)
			update_iframe_height('top_attacks_iframe');

		if (this.fireOnShowHide)
			self.content.onShowHide(true);
	}

	this.hide = function() {
		this.elm_module.style.display = 'block';
		this.elm_moduleContent.style.display = 'none';
		this.elm_showHide.firstChild.className = "fa-plus";//.setAttribute("src", "/images/fa-plus.gif");
		obj.status = 0;

		if (this.fireOnShowHide)
			self.content.onShowHide(false);
	}

	this.attachContent = function() {
		//Request.sendGET(URL_SysStatus + "?getModuleContent="+this.dataObj.id+"&nocache="+Math.random(), oncontentload);
		var pars = "getModuleContent="+this.dataObj.id+"&nocache="+Math.random();
		
		var myAjax = new Ajax.Request(
			URL_SysStatus, 
			{
				method: 'get', 
				parameters: pars, 
				onComplete: oncontentload 
			});

		function oncontentload(response) {
			self.elm_moduleContent.innerHTML = response.responseText;
			self.elm_moduleContent.style.height = "auto";
			self.elm_moduleContent.style.width = "auto";
			if (self.dataObj.isNew)
			{
				//module - xxx - has been successfully added to dashboard
				//alert(dashboard.texts.mod + ' - ' + self.dataObj.title + " " + dashboard.texts.mod_added);
				self.dataObj.isNew = false;
			}
			if(obj.id == MODULE_SYSRES)
			{
				$j('#cpu_meter').progressbar({
					value: Number($j("#cpu_text").text())
				});
				$j('#mem_meter').progressbar({
					value: Number($j("#mem_text").text())
				});
				$j('#disk_meter').progressbar({
					value: Number($j("#disk_text").text())
				});
				sys_res_refresh(10);
			}
			else if(obj.id == MODULE_PSESSION)
			{
				function self_refresh()
				{
					self.refresh();
				}

				if(timer_sess)
					clearTimeout(timer_sess);

				var inter = 5;
				if(typeof top.sess_refresh_interval != undefined)
					inter = parseInt(top.sess_refresh_interval);

				timer_sess = setTimeout(self_refresh, inter*1000);
			}
		}
	}

	this.pageBuild = function() {
		if (!self.elm_module) {
			self.build();
		}

		self.attachContent();
		if (self.dataObj.status != 0) 
			self.show();
		else 
			self.hide();

	}
	this.pageBuild();
}
	
//add an individual module from "add content" panel.
dashboard.addNew = function(response) {
	var rootNode = response.responseXML.documentElement;

	var noaccess = rootNode.getElementsByTagName("noaccess")[0];
	if(noaccess)
	{
		window.document.location = "/noaccess?redir=";
		return;
	}

	var mod = rootNode.getElementsByTagName("module")[0];

	if (mod == null) return;
	dashboard.addModule(mod);
}

dashboard.addModule = function(m) {
		var id = m.getAttribute("id");		
		var isNew = m.getAttribute("isNew");		
		var title = m.getElementsByTagName("description")[0];		
		var icon = m.getElementsByTagName("icon")[0];		
		var option_refresh = m.getElementsByTagName("refresh")[0];		
		var option_edit = m.getElementsByTagName("edit")[0];		
		var option_history = m.getElementsByTagName("history")[0];
		var column = m.getElementsByTagName("column")[0];		
		var status = m.getElementsByTagName("status")[0];		
		var links = m.getElementsByTagName("links");		
		var extra = m.getElementsByTagName("extra")[0];		
		var dataObj = new Object();
		//alert(response.responseText);
		
		if (id == null) return;

		dataObj.id = id; 
		dataObj.title = title.firstChild.nodeValue;
		dataObj.icon = icon.firstChild.nodeValue;
		dataObj.refresh = option_refresh.firstChild.nodeValue;
		dataObj.edit = option_edit.firstChild.nodeValue;
		//		dataObj.history = option_history.firstChild.nodeValue;
		dataObj.container = column.firstChild.nodeValue;
		dataObj.status = status.firstChild.nodeValue; 
		if (isNew == 1) dataObj.isNew = true;

		if (extra)
			dataObj.extra = extra.firstChild.nodeValue; 

		dataObj.links = [];
		for (var i=0; i < links.length; i++) {
			var l = new Object();

			l.name = links.item(i).firstChild.nodeValue;
			l.url = links.item(i).getAttribute("url");

			dataObj.links.push(l);
		}

		var mod = new Module(dataObj);
		dashboard.moduleList.push(mod);

		if (dataObj.isNew)
		{
			dashboard.saveDashboard();
			dashboard.addContent.update(dataObj.id, LINK_OFF);
		}

}

//data format: module1{column, open/close status}&module2...
dashboard.saveDashboard = function() {
	function getOrder() {
		var str_modules = "";
		for (var z=1; z<=Column_Num; z++) {
			var col = dashboard.columnsObj["col"+z];
			var ln = col.childNodes.length;	
			for (var i=0; i<ln; i++) {
				var obj = col.childNodes[i].dataObj;
				var cell = "";
				if (obj && obj.id!=null) {
					if (str_modules != '') str_modules += "&";
					cell = obj.id +"{" + z +"," + obj.status +"}";
					str_modules += cell;
				}
			}
		}
		return str_modules;
	}

	var data = '';
	data = 'order='+encodeURIComponent(getOrder());
	Request.sendGET(URL_SysStatus + "?"+data+"&nocache="+Math.random()+"&session_id="+session_id, callbackRedirect);
}

function $nodisplay(e){
	if(typeof e=="object") e.style.display="none";
	else if($(e)!=null) $(e).style.display="none";
}

function $display(e){
	if(typeof e=="object") e.style.display="block";
	else if($(e)!=null) $(e).style.display="block";
}

//======= Add Content/Module ============
dashboard.addContent = new Object();
dashboard.addContent.isOpen = false;
dashboard.addContent.width = 220;

dashboard.addContent.display = function() {
	var mlist = $("moduleList");

	if (mlist.hasChildNodes()) {
		var tree = $("selectionTree");
		if (mlist.firstChild.style.display == "none") {
			mlist.firstChild.style.display = "block";
			dashboard.addContent.isOpen = true;
		} else {
			mlist.firstChild.style.display = "none";
			dashboard.addContent.isOpen = false;
		}
	} else {
		mlist.style.width = dashboard.addContent.width + "px";
		dashboard.addContent.build();
		dashboard.addContent.isOpen = true;
		mlist.style.display = 'block';
	}
}

dashboard.addContent.build = function() {

	Request.sendGET(URL_SysStatus + "?getModuleList=1&nocache="+Math.random(), onlistload);
	
	function onlistload(response) {
		var rootNode = response.responseXML.documentElement;
		var mods = rootNode.getElementsByTagName("module");
	
		var mlist = $("moduleList");
		var moduleSelection = document.createElement("div");
		moduleSelection.id = "moduleSelection";

		var selectionFrame = document.createElement("div");
		selectionFrame.id = "moduleSelectionFrame";

		var frame2 = document.createElement("div");
		frame2.id = "widgetsList";
		frame2.style.margin = "3px";

		var i = 0;
		var moduleListContent = "";

		for(i=0; i < mods.length; i++)
		{
			var m = mods[i]; 
			var name = mods[i].firstChild.nodeValue;
			var icon = mods[i].getAttribute("icon");
			var id = mods[i].getAttribute("id");

			if ((id == MODULE_ALERT) || (id == MODULE_JSCONSOLE) || (id == MODULE_SESSIONS))
			{
				moduleListContent += '<div class="separator"></div>';
			}

			var if_exist = dashboard.ifModuleExist(id);
			moduleListContent += '<div class="mod" mod="' + id +'" name="mod_' + id +'">' +
							'<div class="item">' +
							'<div class="icon"><img src="/images/' + icon + '"></div>';
			if (if_exist)
				moduleListContent += '<div class="name_off">' + name + '</div>'; 
			else
				moduleListContent += '<div class="name_on">' + name + '</div>'; 
			moduleListContent += '</div></div>';
		}

		var content = '<div class="addModules">'+
				'<div style="width: 100%;"><a class="db_sprite db_close" style="float:right" title="' +
				dashboard.texts.close + '"></a></div>'+
				moduleListContent+
				'<div class="separator"></div>' +
				'<div class="mod" mod="reset_to_default">' +
				'<div class="item">' +
				'<div class="icon"><img src="/images/db_reset1.gif"></div>' +
				'<div class="name_on">' + dashboard.texts.page_reset + '</div>' +
				'</div>' + 
				'</div>';

		frame2.innerHTML = content;

		selectionFrame.appendChild(frame2);
		moduleSelection.appendChild(selectionFrame);
		mlist.appendChild(moduleSelection);

		var closeNode = frame2.firstChild.firstChild;	
		closeNode.style.cursor = "pointer";
		closeNode.onclick = function(e) {
			if (e) e.cancelBubble = true;
			dashboard.addContent.display();
		}
	
		var itms = frame2.firstChild.childNodes;
		var items = [];
		for (var z=0; z<itms.length; z++) {
			if (itms[z].getAttribute("mod")) {
				items.push(itms[z]);
			}
		}

		var ln = items.length;
		for (var z=0; z<ln; z++) {

			items[z].firstChild.onclick = function(e) {

				var id = this.parentNode.getAttribute("mod");
				var n;
				var found = 0;

				if (e) e.cancelBubble = true;

				if (id == "reset_to_default") {
					dashboard_reset();
					return;
				}
				//check if already exists on dashboard
				for(n=0; n < dashboard.moduleList.length; n++)
				{
					//if yes, display a message
					if (id == dashboard.moduleList[n].dataObj.id)
					{
						//This module already exists on dasboard.
						alert(dashboard.texts.mod_exist);
						found = 1;
					}
				}

				if (found == 0)
				{
					//if no, send request to aquire latest module info
					var data = URL_SysStatus + "?getModule=" + encodeURIComponent(id) + "&isNew=1&nocache=" +Math.random() + "&session_id=" + session_id;
					Request.sendGET(data, dashboard.addNew);
				}	
			}
		}

		function dashboard_reset() {
			if(window.confirm(dashboard.texts.confirm_reset))
			{
				var data = URL_SysStatus + "?reset_dashboard=1&nocache=" +Math.random() + "&session_id=" + session_id;
				Request.sendGET(data, onresetdone);
			}
			else 
				return false;

			function onresetdone(response) {
				var rootNode = response.responseXML.documentElement;
				var status = rootNode.getElementsByTagName("reset_status")[0];
				if (status.firstChild.nodeValue == "OK"){
					//alert("Dashboard has been reset to default settings.");
					window.document.location = URL_SysStatus;
				}
				else if(status.firstChild.nodeValue == "NOACCESS")
				{
					window.document.location = "/noaccess";
				}
			}
		} 
	}
}

dashboard.addContent.update = function(id, status) {
	var r = $("widgetsList");
	
	if (r && r.hasChildNodes) {
		mods = r.firstChild.childNodes;
		for(var i=0; i<mods.length; i++) {
			if (mods[i].getAttribute("mod") == id) {
				if (status == LINK_ON)
					mods[i].firstChild.lastChild.className = "name_on";
				else
					mods[i].firstChild.lastChild.className = "name_off";
			}
		}
	}
}

var Drag={
        "obj":null,
	"init":function(a, aRoot, ee){
			if (ee ==null) {
				a.onmousedown=Drag.start;
			}
			a.root = aRoot;
			if(isNaN(parseInt(a.root.style.left)))a.root.style.left="0px";
			if(isNaN(parseInt(a.root.style.top)))a.root.style.top="0px";
			a.root.onDragStart=new Function();
			a.root.onDragEnd=new Function();
			a.root.onDrag=new Function();
			if (ee !=null) {
				var b=Drag.obj=a;
				ee=Drag.fixE(ee);
				var c=parseInt(b.root.style.top);
				var d=parseInt(b.root.style.left);
				b.root.onDragStart(d,c,ee.clientX,ee.clientY);
				b.lastMouseX=ee.clientX;
				b.lastMouseY=ee.clientY;
				document.onmousemove=Drag.drag;
				document.onmouseup=Drag.end;
			}
			
		},
	"start":function(a){
			var b=Drag.obj=this;
			a=Drag.fixE(a);
			var c=parseInt(b.root.style.top);
			var d=parseInt(b.root.style.left);
			b.root.onDragStart(d,c,a.clientX,a.clientY);
			b.lastMouseX=a.clientX;
			b.lastMouseY=a.clientY;
			document.onmousemove=Drag.drag;
			document.onmouseup=Drag.end;
			return false;
		},	
	"drag":function(a){
			a=Drag.fixE(a);
			var b=Drag.obj;
			var c=a.clientY;
			var d=a.clientX;
			var e=parseInt(b.root.style.top);
			var f=parseInt(b.root.style.left);
			var h,g;
			h=f+d-b.lastMouseX;
			g=e+c-b.lastMouseY;
			b.root.style.left=h+"px";
			b.root.style.top=g+"px";
			b.lastMouseX=d;
			b.lastMouseY=c;
			b.root.onDrag(h,g,a.clientX,a.clientY);
			return false;
		},
	"end":function(){
			document.onmousemove=null;
			document.onmouseup=null;
			Drag.obj.root.onDragEnd(parseInt(Drag.obj.root.style.left),parseInt(Drag.obj.root.style.top));
			Drag.obj=null;
		},
	"fixE":function(a){
			if(typeof a=="undefined")a=window.event;
			if(typeof a.layerX=="undefined")a.layerX=a.offsetX;
			if(typeof a.layerY=="undefined")a.layerY=a.offsetY;
			return a;
		}
};
function percent2rotate(perc) {
	return (perc - 50) * 3;
}

function sys_res_refresh(id) {
	var refresh_interval = 5 * 1000;
	clearTimeout(window['timer' + id]);
	//if (!$j("#mem_meter").length) return;
	$j.ajax({
		'url': '/system/status/res',
		'data': {
			'path': 'system',
			'name': 'resource',
			'q': Math.random()
		},
		'success': function(data) {
			var res = data.results;
			window['timer' + id] = setTimeout(function() {
				sys_res_refresh(id);
			}, refresh_interval);
			if (!res) return;
			//$j("#cpu_meter").rotate(percent2rotate(res.cpu[0]));
			//$j(res.cpu).each(function(i, cpu) {
				//$j("#cpu" + i + "_text").text(cpu);
				//$j("#cpu" + i + "_text").text(cpu)[0] || $j("#cpu" + i + "_bar").width(cpu + '%');
			//});
			$j("#cpu_text").text(res.cpu[0]);
			$j('#cpu_meter').progressbar({
				value: res.cpu[0]
			});
			$j("#cpu_meter").attr("title",$j('#lab_cpu').text() + res.cpu[0] + "%");

			$j("#mem_text").text(res.mem);
			$j('#mem_meter').progressbar({
				value: res.mem
			});
			$j("#mem_meter").attr("title",$j('#lab_mem').text() + res.mem + "%");

			$j("#disk_text").text(res.disk);
			$j('#disk_meter').progressbar({
				value: res.disk
			});
			$j("#disk_meter").attr("title",$j('#lab_disk').text() + res.disk + "%");

			$j("#session_text").text(res.session);
			$j("#session_sec_text").text(res.session_sec);
			//$j("#mem_meter").rotate(percent2rotate(res.mem));
			//$j("#mem_text").text(res.mem);
			//$j("#disk_meter").rotate(percent2rotate(res.disk));
			//$j("#disk_text").text(res.disk);
		}
	});
}
window.onunload = function() {
	try {
		var ln = dashboard.moduleList.length;
		for (var z=0; z<ln; z++) {
			delete dashboard.moduleList[z];
			dashboard.moduleList[z] = null;
		}
		delete dashboard;
		dashboard = null;
	}
	catch (e) {}
}
