Column_Num = 2;
LINK_ON = 1;
LINK_OFF = 0;


var widgetpanel = function ()
{
	this.moduleList = [];
	this.columnsObj = {};
	var self = this;

	this.ifModuleExist = function(type) {
		for(var i=0; i < this.moduleList.length; i++) {
			if (type == this.moduleList[i].dataObj.widget_type)
				return true;
		}
		return false;
	}

	this.getModuleCount = function(type) {
		var found = 0;
		for(var i=0; i < this.moduleList.length; i++) {
			if (type == this.moduleList[i].dataObj.widget_type)
				found++;
		}
		return found;
	}

	this.start = function() {
		var container = $("modulesArea");
	
		//column #1
		var col1 = document.createElement("td");
		col1.style.minHeight = "1px";
		col1.className = "column";
		col1.setAttribute("colnum", 1);
		this.columnsObj.col1 = col1;

		//column #2
		var col2 = document.createElement("td");
		col2.style.minHeight = "1px";
		col2.className = "column";
		col2.setAttribute("colnum", 2);
		this.columnsObj.col2 = col2;

		container.appendChild(col1);
		container.appendChild(col2);

		this.displayModules=function(response, obj) {
			var rootNode = response.responseXML.documentElement;
			var mods = rootNode.getElementsByTagName("module");
				
			for (var m=0; m<mods.length; m++) {
				obj.addModule(mods[m]);
			}

		}

		this.sendGetPageRequest();
	} 

	this.addNew = function(response) {
		var rootNode = response.responseXML.documentElement;
		var mod = rootNode.getElementsByTagName("module")[0];

		if (mod == null) return;
		self.addModule(mod);
	}


	this.addModule = function(m) {
		var id = m.getAttribute("id");
		var widget_type = m.getAttribute("widget-type");
		var isNew = m.getAttribute("isNew");
		var title = m.getElementsByTagName("description")[0];
		var icon = m.getElementsByTagName("icon")[0];
		var option_refresh = m.getElementsByTagName("refresh")[0];
		var option_edit = m.getElementsByTagName("edit")[0];
		var option_history = m.getElementsByTagName("history")[0];
		var option_reset = m.getElementsByTagName("reset")[0];
		var column = m.getElementsByTagName("column")[0];
		var status = m.getElementsByTagName("status")[0];
		var links = m.getElementsByTagName("links");
		var extra = m.getElementsByTagName("extra")[0];
		var closeTag = m.getElementsByTagName("close")[0];
		var moveTag = m.getElementsByTagName("move")[0];
		var dataObj = new Object();
		
		if (id == null) return;

		dataObj.id = id;
		dataObj.widget_type = widget_type;
		dataObj.title = title.firstChild.nodeValue;
		//icon could be optional because of #119214
		if (icon)
			dataObj.icon = icon.firstChild.nodeValue;
		dataObj.refresh = option_refresh.firstChild.nodeValue;
		dataObj.edit = option_edit.firstChild.nodeValue;
		dataObj.history = option_history.firstChild.nodeValue;
		dataObj.container = column.firstChild.nodeValue;
		dataObj.status = status.firstChild.nodeValue; 
		dataObj.close = 1;
		dataObj.move = 1;
		if (isNew == 1) dataObj.isNew = true;

		if(option_reset)
			dataObj.reset = option_reset.firstChild.nodeValue;
		if (extra && extra.firstChild)
		{
			dataObj.extra = extra.firstChild.nodeValue;
		}
		else
		{
		    // always create extra element for the case of updating a new extra information with blank
		    dataObj.extra = " ";
		}

		if (closeTag)
			dataObj.close = closeTag.firstChild.nodeValue; 
		if (moveTag)
			dataObj.move = moveTag.firstChild.nodeValue; 

		dataObj.links = [];
		for (var i=0; i < links.length; i++) {
			var l = new Object();

			l.name = links.item(i).firstChild.nodeValue;
			l.url = links.item(i).getAttribute("url");
			l.onclick = links.item(i).getAttribute("onclick");

			dataObj.links.push(l);
		}

		var mod = new Module(dataObj, this);
		this.moduleList.push(mod);

		if (dataObj.isNew)
		{
			self.isNewAction(dataObj.id, dataObj.widget_type);
		}

	}

	//data format: module1{column, open/close status}&module2...
	this.savePanelContent = function() {
		function getOrder() {
			var str_modules = "";
			for (var z=1; z<=Column_Num; z++) {
				var col = self.columnsObj["col"+z];
				var ln = col.childNodes.length;	
				for (var i=0; i<ln; i++) {
					var obj = col.childNodes[i].dataObj;
					var cell = "";
					if (obj && obj.id!=null) {
						if (str_modules != '') str_modules += "&";
						cell = obj.id +"{" + z +"," + obj.status +"}";
						str_modules += cell;
					}
				}
			}
			return str_modules;
		}

		var data = '';
		data = 'order='+encodeURIComponent(getOrder());
		self.sendReorderRequest(data)
	}

	this.getModuleArr = function(column) {
	        var arr = [];
	        var ln = column.childNodes.length;
	        for (var z=0; z<ln; z++) {
	                if (!column.childNodes[z].dataObj
	                        && column.childNodes[z] != moduleGhost) {
				continue;
			};

			if (!column.childNodes[z].isDragging) {
				arr.push(column.childNodes[z]);
			}
		}
		return arr;
	}

}


function Module(obj, widgetpanelobj) {
	var self = this;
	this.dataObj = obj;
	this.isNew = (obj.isNew) ? true : false;
	this.refreshMode = true;
	this.fireOnShowHide = false;
	this.wpObj = widgetpanelobj;
	
	this.build = function() {

		var divModule = document.createElement("div");
		this.elm_module = divModule;
		divModule.className = "module";
		divModule.dataObj = obj;
		divModule.style.display = 'block';

		var divModuleFrame = document.createElement("div");
		this.elm_moduleFrame = divModuleFrame;
		divModuleFrame.className = "module_frame";

		var divModuleHeader = document.createElement("div");
		this.elm_moduleHeader = divModuleHeader;
		divModuleHeader.className = "module_header";
		divModuleHeader.onmouseover = function(){
			self.highlight();
		}
		divModuleHeader.onmouseout = function(){
			self.unHighlight();
		}

		if (obj.icon)
		{
			var divIcon = document.createElement("div");
			this.elm_icon = divIcon;
			divIcon.className = "module_icon " + obj.icon;
		}

		var divShowHide = document.createElement("div");
		this.elm_showHide = divShowHide;
		divShowHide.className = "module_showhide";
		divShowHide.innerHTML = (obj.status==0) ? '<a class="fa-minus"></a>' : '<a class="fa-plus"></a>';
		if (obj.icon) //dashboard widgets don't show widget icon
			divShowHide.style.visibility = "hidden";

		Event.observe(divShowHide, 'mousedown', showHide, false);


		var divTitle = document.createElement("div");
		this.elm_title = divTitle;
		divTitle.className = "module_title";
		divTitle.appendChild(document.createTextNode(obj.title));

		var divExtra = this.buildExtra(obj);

		
		if(obj.close == 1) {
			var divClose = document.createElement("div");
			this.elm_close = divClose;
			divClose.className = "module_close";
			divClose.innerHTML = '<a class="fa-times" title="' + this.wpObj.texts.close + '"></a>';
			divClose.style.display = "none";
			Event.observe(divClose, 'mousedown', close, false);
		}
		
		if (obj.refresh == 1)
		{
			var divRefresh = document.createElement("div");
			this.elm_refresh = divRefresh;
			divRefresh.className = "module_refresh";
			divRefresh.innerHTML = '<a class="fa_refresh" title="' + this.wpObj.texts.refresh +'"></a>';
			divRefresh.style.display = "none";
			Event.observe(divRefresh, 'mousedown', this.refresh.bind(this), false);
		}

		if (obj.edit == 1)
		{
			var divEdit = document.createElement("div");
			this.elm_edit = divEdit;
			divEdit.className = "module_edit";
			this.buildEditLink(obj, divEdit);
		}
		
		if (obj.history == 1)
		{
			var divHistory=this.buildHistory(obj);
		}

		if (obj.reset == 1)
		{
			var divReset = document.createElement("div");
			this.elm_reset = divReset;
			divReset.className = "module_reset";

			divReset.innerHTML = '<a class="db_reset" title="' + this.wpObj.texts.reset + '"></a>';

			Event.observe(divReset, 'mousedown', this.reset.bind(this), false);

			divReset.style.display = "none";
		}

		//hyper-links
		if (obj.links.length > 0)
		{

			//links
			var divLinks = document.createElement("div");
			this.elm_links = divLinks;
			divLinks.className = "module_links";
			for(var i=0; i < obj.links.length; i++)
			{
				var l = document.createElement("a");
				l.setAttribute("href", obj.links[i].url);

				var oClick = obj.links[i].onclick;
				if (oClick && oClick.length)
				{
					l.onclick = function() {
						eval(oClick)(obj.id);
						return false;
					};
				}

				l.appendChild(document.createTextNode(obj.links[i].name));
				divLinks.appendChild(l);
				Event.observe(l, "mousedown", openLink, true);
			}
			divLinks.style.display = "none";
			
			// The console will change the visibility of this id when attached/detached.
			this.buildHyperLink(obj, divLinks);
		}
		var divModuleContent = document.createElement("div");
		this.elm_moduleContent = divModuleContent;
		divModuleContent.className = "module_content";
		divModuleContent.innerHTML = "<img src='/images/loading.gif'>";
		if (obj.status==0) divModuleContent.style.display = "none";
		
		divModuleHeader.appendChild(divShowHide);
		if (divClose) divModuleHeader.appendChild(divClose);
		if (divRefresh) divModuleHeader.appendChild(divRefresh);
		if (divEdit)    divModuleHeader.appendChild(divEdit);
		if (divHistory) divModuleHeader.appendChild(divHistory);
		if (divReset)   divModuleHeader.appendChild(divReset);
		if (divLinks)   divModuleHeader.appendChild(divLinks);
		if (divIcon)	divModuleHeader.appendChild(divIcon);
		divModuleHeader.appendChild(divTitle);
		if (divExtra)   divModuleHeader.appendChild(divExtra);
		
		divModuleFrame.appendChild(divModuleHeader);
		divModuleFrame.appendChild(divModuleContent);

		divModule.appendChild(divModuleFrame);

		if(obj.move == 1)
			db_setupdrag(divModuleHeader, divModule, this.wpObj);

		function showHide(e) {
			e.cancelBubble = true;
			self.showHideModule();
		}
		function close(e) {
			e.cancelBubble = true;
			self.close();
		}
		function openLink(e) {
			e.cancelBubble = true;
		}

		if (Number(obj.container) > 0) {
			if (this.isNew && this.wpObj.columnsObj["col"+obj.container].hasChildNodes()) {
				this.wpObj.columnsObj["col"+obj.container].insertBefore(divModule, this.wpObj.columnsObj["col"+obj.container].firstChild);
			} else {
				this.wpObj.columnsObj["col"+obj.container].appendChild(divModule);
			}
		}

	} 

	this.highlight = function() {
		this.elm_close.style.display = "block";
		if (this.elm_icon)	{
			this.elm_icon.style.display = "none";
			this.elm_showHide.style.visibility = "visible";
			//this.elm_showHide.style.width = "20px";
		}
		if (this.elm_links) this.elm_links.style.display = "block";
		if (this.elm_refresh) this.elm_refresh.style.display = "block";
		if (this.elm_edit) this.elm_edit.style.display = "block";
		if (this.elm_history) this.elm_history.style.display = "block";
		if (this.elm_reset) this.elm_reset.style.display = "block";
		this.highlightExtra()
	}

	this.unHighlight = function() {
			this.elm_close.style.display = "none";
			if (this.elm_icon)	{
				this.elm_icon.style.display = "block";
				this.elm_showHide.style.visibility = "hidden";
				//this.elm_showHide.style.width = "0px";
			}
			if (this.elm_refresh) this.elm_refresh.style.display = "none";
			if (this.elm_links) this.elm_links.style.display = "none";
			if (this.elm_edit) this.elm_edit.style.display = "none";
			if (this.elm_history) this.elm_history.style.display = "none";
			if (this.elm_reset) this.elm_reset.style.display = "none";
	}

	this.showHideModule = function() {
		if (arguments[0] != undefined) {
			arguments[0] ? this.show() : this.hide();
		} else {
			this.elm_moduleContent.style.display=='none' ? this.show() : this.hide();
		}
	}

	this.close = function() {
		if (window.confirm(this.wpObj.texts.confirm_close + ' ' + obj.title + '?')) {
				
				var ln = this.wpObj.moduleList.length;
				for (var z=0; z<ln; z++) {
					if (self == this.wpObj.moduleList[z]) {
						this.wpObj.moduleList.splice(z, 1);
						break;
					}
				}
				
				Element.remove(this.elm_module);
				this.closeAction(this.dataObj)
				delete self;
				return true;
		}
		return false;
	}
	this.show = function() {
		this.elm_module.style.display = 'block';
		this.elm_moduleContent.style.display = 'block';
		this.elm_showHide.firstChild.className = "fa-plus";
		this.showSpecific();

		if (this.fireOnShowHide)
			self.content.onShowHide(true);

		if (obj.status != 1)
		{
			obj.status = 1;
			this.showAction(obj);
		}
	}

	this.hide = function() {
		this.elm_module.style.display = 'block';
		this.elm_moduleContent.style.display = 'none';
		this.elm_showHide.firstChild.className = "fa-minus";

		if (this.fireOnShowHide)
			self.content.onShowHide(false);

		if (obj.status != 0)
		{
			obj.status = 0;
			this.hideAction(obj);
		}
	}

	this.pageBuild = function() {
		if (!self.elm_module) {
			self.build();
		}

		self.attachContent(0);
		if (self.dataObj.status != 0) 
			self.show();
		else 
			self.hide();

	}
	this.pageBuild();
}

function $nodisplay(e){
	if(typeof e=="object") e.style.display="none";
	else if($(e)!=null) $(e).style.display="none";
}

function $display(e){
	if(typeof e=="object") e.style.display="block";
	else if($(e)!=null) $(e).style.display="block";
}


/******************************
 wij_dragdrop_core.js - Core drag & drop code for navbar, subnav,
    & icontainer frames.
 Init by A. Krywaniuk, Jan 2008 (extracted from dashboard.js & customized)
 GUI widgetization project
 Copyright Fortinet, inc.
 All rights reserved
 ******************************/

// EXPORT_SYMBOL findPosX
// EXPORT_SYMBOL findPosY

/* Functions from Util.js: */
// EXPORT_SYMBOL is_left_button_event

/* Variables conflicting with HTML element ids: */
// EXPORT_SYMBOL moduleGhost


/******************************
    Logging
******************************/


// ddlogger - drag & drop logger (output to navbar frame)
var ddlogger =
{
    enabled : false,
    output_doc : null,

    enable : function()
    {
        output_doc = top.frames.mainnav.document;
        var dv = output_doc.getElementById("nv_testarea");
        dv.style.display = "";
        this.enabled = true;
    },

    set_mousemove_loc : function(frm, ev_x, ev_y, calc_x, calc_y)
    {
        if (!this.enabled) return;
        var spn = output_doc.getElementById("nvd_mm_loc");
        spn.innerHTML = (frm ? "iframe" : "main");

        spn = output_doc.getElementById("nvd_mm_loc_coords");
        spn.innerHTML = ev_x + "," + ev_y;

        spn = output_doc.getElementById("nvd_mm_real_coords");
        spn.innerHTML = calc_x + "," + calc_y;
    },

    set_start_pos : function(dv, ev_x, ev_y)
    {
        if (!this.enabled) return;
        spn = output_doc.getElementById("nvd_start_pos");
        spn.innerHTML = ev_x + "," + ev_y;
    },

    set_click_offset : function(dv, ev_x, ev_y)
    {
        if (!this.enabled) return;
        var spn = output_doc.getElementById("nvd_clk_div");
        spn.innerHTML = dv.id;

        spn = output_doc.getElementById("nvd_clk_offset");
        spn.innerHTML = ev_x + "," + ev_y;
    },

    set_in_drag : function(bInProgress)
    {
        if (!this.enabled) return;
        var spn = output_doc.getElementById("nvd_in_drag");
        spn.innerHTML = (bInProgress ? "yes" : "no");
    }
};


/******************************
    Global definitions
******************************/

// moduleGhost - global ghost div object that is used for all drag & drop operations.
// The id "moduleGhost" is important, since it has some style rules associated with it.
var moduleGhost = document.createElement("div");
moduleGhost.id = "moduleGhost";


/******************************
    Utility functions
******************************/

// findPosX - find an object's X position while dragging.
// This is basically just a more optimized version of the
// expression "Position.positionedOffset(obj)[0]".
function findPosX(obj)
{
    // TODO: this was obviously left in here by accident. Should we just
    // switch to using the generic function?
    return Position.positionedOffset(obj)[0];

	var curleft = 0;
	if (obj && obj.offsetParent) {
		while (obj.offsetParent) {
			curleft += obj.offsetLeft;
			obj = obj.offsetParent;
		}
	} else if (obj && obj.x) curleft += obj.x;
	return curleft;
}

// findPosY - find an object's Y position while dragging.
// This is basically just a more optimized version of the
// expression "Position.positionedOffset(obj)[1]".
function findPosY(obj)
{
	var curtop = 0;
	if (obj && obj.offsetParent) {
		while (obj.offsetParent) {
			curtop += obj.offsetTop;
			obj = obj.offsetParent;
		}
	} else if (obj && obj.y) curtop += obj.y;
	return curtop;
}

// insertAfter - JavaScript doesn't have an element.insertAfter function for
// some reason, so create our own.
function insertAfter(parent, node, referenceNode)
{
    parent.insertBefore(node, referenceNode.nextSibling);
}


/******************************
    Drag & Drop class
******************************/

// Parameters to control Drag & Drop behaviour.
// (set on a per-page basis)
var drag_x_only = false;
var drag_y_only = false;


// Drag class - adapted from the original dashboard.js module
// NOTE: Rather than applying the incremental mouse offsets, this new
// solution stores the offset of the click position within the drag handle
// and then adjusts the element position to just track the mouse cursor.
var Drag =
{
    obj: null,
    clickTimeout: null,

    // NOTE: there used to be a case here where the init function could also
    // take a 3rd parameter (event), which would allow the drag object to
    // be initialized and then immediately start a drag event in the same
    // operation. I don't think we need to support that.
    init: function(dv_handle, dv_elem)
    {
        // TODO: can we use a less generic name than "root"?
        dv_handle.root = dv_elem;

        // Make sure the element has a valid starting position.
        // (Probably not very necessary.)
        if (isNaN(parseInt(dv_elem.style.left))) dv_elem.style.left="0px";
        if (isNaN(parseInt(dv_elem.style.top))) dv_elem.style.top="0px";

        dv_handle.onmousedown = Drag.start;

        // These callbacks need to be provided by the caller. I guess we just
        // initialize them here as placeholders?
        dv_elem.onDragStart = new Function();
        dv_elem.onDragEnd = new Function();
        dv_elem.onDrag = new Function();

/*	
			if (ee ==null) {
				a.onmousedown=Drag.start;
			}
*/
/*			if (ee !=null) {
				var b=Drag.obj=a;
				ee=Drag.fixE(ee);
				var c=parseInt(b.root.style.top);
				var d=parseInt(b.root.style.left);
				b.root.onDragStart(d,c,ee.clientX,ee.clientY);
				b.lastMouseX=ee.clientX;
				b.lastMouseY=ee.clientY;
				document.onmousemove=Drag.drag;
				document.onmouseup=Drag.end;
			}*/
			
    },

    // Drag.start
    start: function(ev)
    {
        ev = Drag.fixE(ev);
        if (!is_left_button_event(ev)) return false;

        var dv_handle = this;

        // What if we are already dragging?
        if (Drag.obj)
        {
            // If we were previously dragging the same item then it was probably just
            // a glitch related to the user leaving & re-entering the frame. Let's
            // continue the operation and hope it works.
            if (Drag.obj == dv_handle)
                return false;

            // Finish the old drag operation and begin a new one.
            // TODO: is it better to end it or cancel it?
            Drag.end_drag();
        }

        Drag.obj = dv_handle;
        dv_elem = dv_handle.root;

        dv_handle.lastMouseX = ev.clientX;
        dv_handle.lastMouseY = ev.clientY;

        // Get the initial position of the element's drag handle within the main frame window.
        // (Use Position.page() rather than cumulativeOffset() in order to neglect
        // the scroll position.)
        var pos = Position.page(dv_elem);
        //var pos = Position.cumulativeOffset(b.root);
        //var pos = Position.realOffset(b.root);

        // Convert the mouse click coordinates to be relative to the element (not the drag handle).
        var offset_x = ev.clientX - pos[0];
        var offset_y = ev.clientY - pos[1];

        dv_handle.clickOffsetX = offset_x;
        dv_handle.clickOffsetY = offset_y;

        // Update the logger, if we are using that.
        // TODO: disable in production build.
        ddlogger.set_start_pos(dv_handle, pos[0], pos[1]);
        ddlogger.set_click_offset(dv_handle, dv_handle.clickOffsetX, dv_handle.clickOffsetY);

        // To distinguish between a drag and a mere mouse click, wait until the user either
        // holds down the mouse button for a few milliseconds or moves the mouse beyond a
        // certain threshhold.
        document.onmousemove = Drag.checkdragcondition;
        document.onmouseup = Drag.cancelpending;

        var drag_threshold_tm = 250;
        Drag.clickTimeout = setTimeout(Drag.realstart, drag_threshold_tm);

        return false;
    },

    cancelpending: function()
        {
            Drag.obj = null;

            if (Drag.clickTimeout)
            {
                clearTimeout(Drag.clickTimeout);
                Drag.clickTimeout = null;

                document.onmousemove=null;
                document.onmouseup=null;
            }
        },

    checkdragcondition: function(a)
    {
        var b=Drag.obj;
        a=Drag.fixE(a);

        // If the mouse has moved more than N pixels, cancel
        // the timeout and start the drag right away.
        var drag_threshold_xy = 10;
        var distX = Math.abs(b.lastMouseX - a.clientX);
        var distY = Math.abs(b.lastMouseY - a.clientY);

        if (distX + distY > drag_threshold_xy)
        {
            // Cancelpending will remove the current drag obj,
            // so restore the saved one.
            Drag.cancelpending();
            Drag.obj = b;
            Drag.realstart();
        }
    },

    realstart : function()
    {
        if (Drag.clickTimeout)
            Drag.clickTimeout = null;

        var b=Drag.obj;
        var c=parseInt(b.root.style.top);
        var d=parseInt(b.root.style.left);
        b.root.onDragStart(d, c, b.lastMouseX, b.lastMouseY);

        document.onmousemove=Drag.drag;
        document.onmouseup=Drag.end;
        ddlogger.set_in_drag(true);
    },

    // Drag.drag
    drag: function(a)
    {
        a=Drag.fixE(a);
        var b=Drag.obj;
        var c=a.clientY;
        var d=a.clientX;
        var e=parseInt(b.root.style.top);
        var f=parseInt(b.root.style.left);
        var h,g;
        h=f+d-b.lastMouseX;
        g=e+c-b.lastMouseY;
        b.lastMouseX=d;
        b.lastMouseY=c;


        // Get the current position of the element excluding scrolling.
        var elem = b.root;
        var pos = Position.page(elem);

        // Now calculate the same offsets that we previously stored in clickOffsetX/Y.
        // If the element hasn't moved, these would give the same result.
        var offset_x = a.clientX - pos[0];
        var offset_y = a.clientY - pos[1];

        var cx = offset_x - b.clickOffsetX;
        var cy = offset_y - b.clickOffsetY;

        // Now adjust the position of the element by the differential of these offsets.
        if (!drag_y_only) elem.style.left = (elem.offsetLeft + cx) + "px";
        if (!drag_x_only) elem.style.top = (elem.offsetTop + cy) + "px";


        // When forwarding events from an iframe, we may use some "fake" (not built-in)
        // mouse objects.
        if (!a.is_fake)
            ddlogger.set_mousemove_loc(null, a.clientX, a.clientY, h, g);

        b.root.onDrag(h,g,a.clientX,a.clientY);

        return false;
    },

    // Drag.end - event handler for mouseup.
    end: function(ev)
    {
        ev = Drag.fixE(ev);
        if (!is_left_button_event(ev)) return false;

        Drag.end_drag();
        return true;
    },

    // Drag.end_drag - internal API to finish dragging.
    end_drag: function()
    {
        document.onmousemove=null;
        document.onmouseup=null;

        var dv_elem = Drag.obj.root;
        dv_elem.onDragEnd(parseInt(dv_elem.style.left), parseInt(dv_elem.style.top));
        Drag.obj=null;
    },


	// dragging_l2_menuitem - used in navbar frame
	dragging_l2_menuitem : function()
	{
	   var drag_obj = Drag.obj;
	   if (!drag_obj || !drag_obj.menu_ref) return false;
	   return (drag_obj.menu_ref.menu_level == 2);
	},
	
    // reset - cancel any current drag operation and reset the object state.
    reset: function()
    {
        if (Drag.obj)
        {
            // Is it necessary to do this?
            Drag.obj.root.onDragEnd(parseInt(Drag.obj.root.style.left),parseInt(Drag.obj.root.style.top));
            Drag.obj = null;
        }

        Drag.clickTimeout = null;
        document.onmousemove=null;
        document.onmouseup=null;

        ddlogger.set_in_drag(false);
    },
		
		
	"fixE":function(a){
			if(typeof a=="undefined")a=window.event;
			if(typeof a.layerX=="undefined")a.layerX=a.offsetX;
			if(typeof a.layerY=="undefined")a.layerY=a.offsetY;
			return a;
		}
};


// delayed_clear_dragging_flag - set a timer to clear the isDragging flag
// TODO: so far, this function is called by every D&D module. Maybe we
// should move it into the framework instead.
function delayed_clear_dragging_flag(elem)
{
    // Turn off the isDragging flag after processing any onclick events.
    // (This lets us ignore the spurious click event that normally
    // gets triggered immediately after a drag.)
    // We do this by setting an immediate pending JS timeout that will
    // occur after all system events are finished processing.
    function mk_setIsDragging_callback(obj)
    {
        return (function() {
//            clogger.debug("setIsDragging_callback"); 
            obj.isDragging = false;
        } );
    }

    var cb = mk_setIsDragging_callback(elem);
    setTimeout(cb, 1);
}




/******************************
 widgetpanel_drag.js - Dashboard support code
 Init by A. Krywaniuk, Sept 2008
 (Adapted from wij_icontainer_drag.js)
 GUI widgetization project
 Copyright Fortinet, inc.
 All rights reserved
 ******************************/

// NOTE: This page uses the drag & drop core library from the widgetization
// project (wij_dragdrop_core.js). The callbacks also share quite a lot
// of redundant code with other modules (e.g. wij_icontainer_drag.js). However,
// there are also just enough page-specific differences to make it difficult
// to further encapsulate the code without over-complicating the design.

/* Functions used by dashboard.js: */
// EXPORT_SYMBOL db_setupdrag

/* Variables used by dashboard.js: */
// EXPORT_SYMBOL col1
// EXPORT_SYMBOL col2


/******************************
    Drag & Drop code
******************************/

// TODO: temporary debug logger (this one goes to the Firebug console)
// Since one of our dependencies (wij_dragdrop_core.js) may include references
// to clogger, we need to make sure it is defined.
var clogger = {
    enabled : true,
    debug : function(msg)
    {
        if (this.enabled)
        {
            if (window.console)
                window.console.log(msg);
        }
    }
};


// Browser detection.
var IE = window.ActiveXObject;
var IE6 = (IE && getInternetExplorerVersion() < 7.0);

// wij_bottom_margin - margin-bottom of the widget class (should be a constant for
// all icontainer widgets, thus we can cache it).
var wij_bottom_margin = null;
var wpanel_drag_obj;


// db_update_ghost_style - update the ghost style based on its position within
// the widget layout.
function db_update_ghost_style(dv_ghost, is_col2)
{
    // is_at_end_of_col - Determining if the ghost is the last entry in the column
    // is not just as simple as checking if we have a next sibling. The element
    // being dragged is still in the DOM, so we may need to skip it.
    function is_at_end_of_col()
    {
        var next_sib = dv_ghost.nextSibling;

        if (!next_sib)
            return true;

        // Kludgy way of detecting the element being dragged. :-(
        if (!next_sib.nextSibling && next_sib.position == "absolute")
            return true;

        return false;
    }


    // Setup the ghost's margins.
    var ml = 3;
    var mr = -1;
    var mt = -1;
    var mb = (wij_bottom_margin - 5);

    if (is_col2)
        ml = 2;

    // Special case for first position in column.
    if (!dv_ghost.previousSibling)
        mt = 3;

    if (is_at_end_of_col())
        mb = 3

    // IE6 has trouble with negative margins. If the negative margin is abutting the padding
    // inside the body then the dotted border won't be drawn. Thus to prevent clipping,
    // we can't make ghost div bigger than the dragged element. And the dragged element will
    // initially cover the ghost div on 3 sides (only the bottom border is showing).
    if (IE6)
    {
        if (mt < 0) mt = 0;
        if (ml < 0) ml = 0;
    }

    var ghost_style = dv_ghost.style;
    ghost_style.marginTop = "" + mt + "px";
    ghost_style.marginLeft = "" + ml + "px";
    ghost_style.marginBottom = "" + mb + "px";
    ghost_style.marginRight = "" + mr + "px";
}


// db_mask_iframe_modules - add a transparent mask on top of all the iframes in order to
// prevent mouse message stealing during drag.
function db_mask_iframe_modules()
{
    // Cleanup any existing mask elements (this shouldn't happen).
    db_unmask_iframe_modules();


    // create_mask - create a mask div within a widgetpanel module content div.
    function create_mask(dv_elem)
    {
        var dv_mask = document.createElement("div");

        var aObj = document.getElementsByClassName("module_content", dv_elem);
        var dv_content = aObj[0];

        var dv_tmp = document.createElement("div");
        dv_tmp.innerHTML = '<div class="iframe_mask" style="position:absolute; top:0; left:0; height:100%; width:100%; zIndex:700; -moz-user-select:none" onselectstart="return false">&nbsp;</div>';

        var dv_mask = dv_tmp.firstChild;
        Element.remove(dv_mask);

        // Make sure the content div's style is relative, which allows us to place
        // absolutely-positioned elements within it.
        dv_elem.style.position = "relative";
        dv_elem.appendChild(dv_mask);

        return dv_mask;
    }

    // Iterate all the widgetpanel modules and mask off any that contain embedded iframes.
    var aObjs = document.getElementsByClassName("module_content");
    var aMask_elems = [];

    var len = aObjs.length;
    for (var i=0; i<len; i++)
    {
        var dv_elem = aObjs[i];
        var aFrames = dv_elem.getElementsByTagName("IFRAME");
        if (aFrames.length)
        {
            var dv_mask = create_mask(dv_elem);
            aMask_elems.push(dv_mask);
        }
    }

    // Save the list of mask elements so we can clean them up later.
    Drag.aMask_elems = aMask_elems;
}


// db_unmask_iframe_modules - remove all the masks on the widgetpanel modules containing
// iframes.
function db_unmask_iframe_modules()
{
    var aObjs = Drag.aMask_elems;
    if (!aObjs)
        return;

    var len = aObjs.length;
    for (var i=0; i<len; i++)
    {
        var dv_mask = aObjs[i];
        Element.remove(dv_mask);
    }

    Drag.aMask_elems = null;
}


// db_dragstart - drag start handler for widgetpanel widgets
function db_dragstart(x,y,mousex,mousey)
{
    var dv_elem = this;
    var dv_ghost = moduleGhost;

    this.col1X = findPosX(wpanel_drag_obj.columnsObj.col1);
    this.col2X = findPosX(wpanel_drag_obj.columnsObj.col2);
    var aCols = wpanel_drag_obj.columnsObj;
    var cur_col = dv_elem.parentNode;

    // Retrieve & cache the margin-bottom attribute from the widget style.
    if (!wij_bottom_margin)
        wij_bottom_margin = parseInt(Element.getStyle(dv_elem, 'marginBottom'));

    // If the module contains embedded iframes (the JS console), then put up a hidden mask
    // div to prevent the mouse input from being captured by the iframe.
    // Note: we have to do this for all modules that we might move the mouse over, 
    // not just the one we are dragging.
    db_mask_iframe_modules();


    // Initialize the ghost style so its border will exactly surround the target div,
    // without causing any other elements to move. Since the ghost div has a border, that
    // means we have to adjust for the differences in box-border model between FF & IE.
    // NOTE: we setup the ghost *before* changing any attributes of the target element -
    // otherwise we would need to cache the measurements.
    var ghost_style = dv_ghost.style;

    // Setup the height & width (will remain constant throughout the drag operation).
    if (IE6)
    {
        // IE6 has trouble with negative margins. If the negative margin is abutting the padding
        // inside the body then the dotted border won't be drawn. Thus to prevent clipping,
        // we can't make ghost div bigger than the dragged element. And the dragged element will
        // initially cover the ghost div on 3 sides (only the bottom border is showing).
        ghost_style.height = (dv_elem.offsetHeight - 1) + "px";
        ghost_style.width = (dv_elem.offsetWidth - 2) + "px";
    }
    else
    {
        ghost_style.height = (dv_elem.offsetHeight) + "px";
        ghost_style.width = (dv_elem.offsetWidth) + "px";
    }

    // Set the initial margins (these will be tweaked at runtime depending on the
    // ghost location).
    var is_col2 = (cur_col == aCols.col2)
    db_update_ghost_style(dv_ghost, is_col2);


    // Set ourselves to have an absolute width while dragging. Otherwise we will use
    // 100% of the parent container (which screws up while detached in 2-column mode).
    dv_elem.style.width = dv_elem.offsetWidth + "px";

    // Increase zIndex while dragging. This makes a difference when mixing statically
    // & relatively positioned items.
    dv_elem.saved_zIndex = dv_elem.style.zIndex;
    dv_elem.style.zIndex = 600;

    // Hide the widget while we swap it out for the ghost div. Otherwise, it will
    // briefly teleport lower down on the screen.
    dv_elem.style.visibility = "hidden";
    Position.absolutize(dv_elem);

    // On IE, we also need to account for the margin on the document body.
    // (TODO: I'm not sure why this correction is specific to IE.)
    var fudge_bd_margin = IE ? 1 : -4;

    if (fudge_bd_margin)
    {
        var o_left = parseInt(dv_elem.style.left);
        var o_top = parseInt(dv_elem.style.top);
        dv_elem.style.left = (o_left + fudge_bd_margin) + "px";
        dv_elem.style.top = (o_top + fudge_bd_margin) + "px";
    }

    // Now insert the ghost right before us in the DOM, which should cause it to be
    // displayed at the widget's former position.
    cur_col.insertBefore(dv_ghost, dv_elem);
    dv_ghost.col = cur_col;

    // Update the ghost margins after finalizing the position in the layout.
    db_update_ghost_style(dv_ghost, is_col2);
    dv_elem.style.visibility = "visible";


    // We're done... fixup some JS variables.
    this.isDragging = true;
    wpanel_drag_obj.draggingItem = true;

    this.col1X = findPosX(aCols.col1);
    this.col2X = findPosX(aCols.col2);
}


// db_drag - drag handler for widget panel widgets
// AFAICT, the difference between x & mousex is that mousex is
// the position of the mouse on the screen, whereas x is the
// position of the drag object relative to the start position.
function db_drag(x,y,mousex,mousey)
{
    var dv_elem = this;
    var dv_ghost = moduleGhost;
    var col = dv_ghost.col;

    // See if we are switching columns.
    var aCols = wpanel_drag_obj.columnsObj;
    if ((x+this.offsetWidth/2)>=this.col1X) col=aCols.col1;
//    if ((wij_cur_layout == wij_layout_2column))
    if ((x+this.offsetWidth/2)>=this.col2X) col=aCols.col2;



    // Move the ghost to the new column if necessary.
    if (dv_ghost.col != col)
    {
        // Temporarily append the ghost at the end of the list.
        // we may move it up later.
        if (dv_ghost.parentNode)
            Element.remove(dv_ghost);

        dv_ghost.col = col;
        col.appendChild(dv_ghost);
    }


    // TODO: isn't this a little inefficient?
    var elems = wpanel_drag_obj.getModuleArr(col);

    // Remember the previous sibling rather than the index in the array.
    // This avoids the complicated logic involved in sometimes skipping
    // the ghost entry and sometimes not.
    var old_prev_sibling = dv_ghost.previousSibling;
    var new_prev_sibling = null;

    var len = elems.length;
    for (var i=len-1; i >= 0; i--)
    {
        var elem = elems[i];
//        if (y > findPosY(elem) + (elem.offsetHeight/4))
        if (y > findPosY(elem))
        {
            new_prev_sibling = elem;
            break;
        }
    }

    if (new_prev_sibling != old_prev_sibling && new_prev_sibling != dv_ghost)
    {
        if (dv_ghost.parentNode)
            Element.remove(dv_ghost);

        if (new_prev_sibling)
        {
            insertAfter(col, dv_ghost, new_prev_sibling);
        }
        else
        {
            col.insertBefore(dv_ghost, col.firstChild);
        }
    }

    // Update the ghost div's margins to fit the layout.
    var is_col2 = (col == aCols.col2)
    db_update_ghost_style(dv_ghost, is_col2);
}


// db_dragend - drag end handler for dashboard widgets
function db_dragend(x,y,el)
{
    var dv_elem = this;
    var dv_ghost = moduleGhost;

    dv_elem.style.zIndex = dv_elem.saved_zIndex;

    // If we have added any iframe mask divs, then remove them.
    db_unmask_iframe_modules();

    // Turn off the isDragging flag after processing any onclick events.
    delayed_clear_dragging_flag(dv_elem);

    var col = moduleGhost.col;
    if (!moduleGhost.parentNode) {
        moduleGhost.col.appendChild(moduleGhost);
    }
    col.insertBefore(dv_elem, moduleGhost);
    Element.remove(moduleGhost);

    wpanel_drag_obj.savePanelContent();
    wpanel_drag_obj.draggingItem = false;

    dv_elem.style.position = "static";
    // Hmm... do "auto" and "" do the same thing?
    dv_elem.style.width = "auto";
    dv_elem.style.height = "";
}

function db_setupdrag(divModuleHeader, divModule, wpObj)
{
    // Setup the drag event callbacks.
    Drag.init(divModuleHeader, divModule);
    divModule.onDragStart = db_dragstart;
    divModule.onDrag = db_drag;
    divModule.onDragEnd = db_dragend;
    wpanel_drag_obj = wpObj;
}



URL_SysStatus = "/system/status/status";
URL_GetTexts = "/system/status/status_text";
MOD_MAX = 16;

var dashboard = new widgetpanel();


dashboard.sendGetPageRequest = function()
{
	//Use the specified tab_id for all future requests.
	URL_SysStatus += "?tab_id=" + dashboard.tab_id;
	Request.sendGET(URL_SysStatus + "&getPage=1&nocache="+Math.random(), this.displayModules, this);
}


Module.prototype.buildExtra = function(obj) {
	if (obj.extra)
	{
		var divExtra = document.createElement("div");
		this.elm_extra = divExtra;
		divExtra.className = "module_extra";
		divExtra.appendChild(document.createTextNode(obj.extra));
		return divExtra;
	}
	else if (obj.widget_type == MODULE_JSCONSOLE)
	{
		// The console requires a span here instead of a text node. The contents of the span will
		// be dynamically updated as the connection status changes.
		var divExtra = document.createElement("div");
		this.elm_extra = divExtra;
		divExtra.className = "module_extra";
		divExtra.innerHTML += "&nbsp<span id=\"jsconn_state\" style=\"vertical-align:bottom\"></span>";
		return divExtra;
	}
}

Module.prototype.buildEditLink = function(obj, divEdit)
{
	var divEditLink = "#";
	divEdit.id = "db_" + obj.id + "_customize";
	if (obj.widget_type == MODULE_JSCONSOLE)
	{
		// The console will change the visibility of this id when attached/detached.
		divEdit.id = "jsconn_customize";
		divEditLink = 'javascript:on_customize_clicked()';
	}
	else if (obj.widget_type == MODULE_ALERT)
	{
		if (this.elm_reset) this.elm_reset.style.display = "block";
	}
	else if (obj.widget_type == MODULE_SYSRES)
	{
		if (this.elm_reset) this.elm_reset.style.display = "none";
	}

	divEdit.innerHTML = '<a href="' + divEditLink + '" class="db_edit" title="' + this.wpObj.texts.edit + '"></a>';
	Event.observe(divEdit, 'mousedown', this.editModule.bind(this), false);

	divEdit.style.display = "none";
}

Module.prototype.buildHistory = function (obj)
{
	var divHistory = document.createElement("div");
	var divHistoryLink = "";
	this.elm_history = divHistory;
	divHistory.className = "module_history";
	if (obj.widget_type == MODULE_TOP_VIRUSES)
	{
		divHistoryLink = 'javascript:virus_history_display()';
	}
	else if (obj.widget_type == MODULE_TOP_ATTACKS)
	{
		divHistoryLink = 'javascript:attack_history_display()';
	}
	else if (obj.widget_type == MODULE_ALERT)
	{
		divHistoryLink = 'javascript:alert_history_display(' + obj.id + ')';
	}

	divHistory.innerHTML = '<a href="' + divHistoryLink + '" class="db_history" title="' + dashboard.texts.history + '"></a>';

	Event.observe(divHistory, 'mousedown', showHistory, false);

	divHistory.style.display = "none";

        function showHistory(e) {
                if (e) e.cancelBubble = true;
        }

	return divHistory;
}

Module.prototype.buildHyperLink = function(obj, divLinks)
{
	if (obj.widget_type == MODULE_JSCONSOLE)
		divLinks.id = "jsconn_popup";
	else
		divLinks.id = "db_" + obj.id + "_popup";
}

Module.prototype.reset = function(e){
	if (e) e.cancelBubble = true;
	ResetURL = "/system/status/status?";
	if (this.dataObj.widget_type == MODULE_STATS)
	{
		ResetURL += "reset_clog";
	}
	else if (this.dataObj.widget_type == MODULE_APP_USAGE)
	{
		ResetURL += "reset_app";
	}
	else if (this.dataObj.widget_type == MODULE_POL_USAGE)
	{
		ResetURL += "reset_pol=" + this.dataObj.id;
	}
	else if (this.dataObj.widget_type == MODULE_DLP_USAGE)
	{
		ResetURL += "reset_dlp";
	}
	else if (this.dataObj.widget_type == MODULE_IM_USAGE)
	{
		ResetURL += "reset_im";
	}
	else if (this.dataObj.widget_type == MODULE_P2P_USAGE)
	{
		ResetURL += "reset_p2p";
	}
	else if (this.dataObj.widget_type == MODULE_VOIP_USAGE)
	{
		ResetURL += "reset_voip";
	}
	else if (this.dataObj.widget_type == MODULE_TOP_VIRUSES)
	{
		ResetURL += "reset_av";
	}
	else if (this.dataObj.widget_type == MODULE_TOP_ATTACKS)
	{
		ResetURL += "reset_ids";
	}

	Request.sendPOST(ResetURL, null, this.refresh.bind(this));
	
	return false;
}

Module.prototype.refresh = function(e) {
	if (e) e.cancelBubble = true;
	this.elm_moduleContent.style.height = this.elm_moduleContent.offsetHeight + "px";
	this.elm_moduleContent.style.width = this.elm_moduleContent.offsetWidth + "px";
	this.elm_moduleContent.innerHTML = "<table align=center height='100%'><tr><td valign=middle><img src='/images/loading.gif'></td></tr></table>";
	this.attachContent(false);
}

Module.prototype.editModule = function(e) {
	var id = this.dataObj.id;
	var type = this.dataObj.widget_type;
	var editHandler = custom_widget_display;
	if (e) e.cancelBubble = true;

	if (type == MODULE_JSCONSOLE)
	{
		return false;
	}
	else if (type == MODULE_ALERT)
	{
		editHandler = custom_alert_display;
	}
	else if (type == MODULE_SYSRES || type == MODULE_SESSIONS_HISTORY)
	{
		editHandler = custom_sysres_display;
	}
	else if (type == MODULE_SESSIONS)
	{
		editHandler = custom_sessions_display;
	}
	else if (type == MODULE_TOP_VIRUSES)
	{
		editHandler = custom_viruses_display;
	}
	else if (type == MODULE_TOP_ATTACKS)
	{
		editHandler = custom_attacks_display;
	}
	else if (type == MODULE_TR_HISTORY)
	{
		editHandler = custom_tr_history_display;
	}
	else if (type == MODULE_APP_USAGE)
	{
		editHandler = custom_app_usage_display;
	}
	else if (type == MODULE_POL_USAGE)
	{
		editHandler = custom_pol_usage_display;
	}
	else if (type == MODULE_DLP_USAGE)
	{
		editHandler = custom_dlp_usage_display;
	}
	else if (type == MODULE_PER_IP_USAGE)
	{
		editHandler = custom_per_ip_usage_display;
	}
	else if (type == MODULE_PROTOCOL_USAGE)
	{
		editHandler = custom_protocol_usage_display;
	}

	editHandler(id);
}

Module.prototype.highlightExtra = function() {
	if (this.dataObj.widget_type == MODULE_JSCONSOLE)
	{
		if (top.window.hPopupConsole != null &&
		top.window.hPopupConsole.closed != true)
		this.elm_close.style.display = "none";
	}
	else
	{
		var wdg_prop = get_logo_obj(this.dataObj.id);

		if (wdg_prop && wdg_prop.hPopupHandle != null &&
		wdg_prop.hPopupHandle.closed != true)
		{
			this.elm_close.style.display = "none";
			this.elm_refresh.style.display = "none";
		}
	}
}


Module.prototype.closeAction = function(obj) {
	this.wpObj.addContent.update();
	Request.sendGET(URL_SysStatus + "&delete=" + obj.id + "&nocache=" + Math.random());
}

Module.prototype.showAction = function(obj) {
	Request.sendGET(URL_SysStatus + "&show=" + obj.id + "&nocache=" + Math.random());
}

Module.prototype.hideAction = function(obj) {
	Request.sendGET(URL_SysStatus + "&hide=" + obj.id + "&nocache=" + Math.random());
}

Module.prototype.showSpecific = function() {
	// Ensure correct height is set for widgets which display in iframes
	update_iframe_height("db_" + this.dataObj.id + "_iframe");
}

Module.prototype.attachContent = function(skip_content) {
	//skip content is always false for dashboard, but true for report summary
	
	Request.sendGET(URL_SysStatus + "&getModuleContent="+this.dataObj.id+"&nocache="+Math.random(), oncontentload, this);

	function oncontentload(response, moduleObj) {
		var obj = response.responseXML;

		var module = obj.getElementsByTagName("module")[0];
		if (!module) return;

		var title = module.getElementsByTagName("description")[0];
		var extra = module.getElementsByTagName("extra")[0];

		var content = obj.getElementsByTagName("content")[0];

		if (!skip_content)
		{
			moduleObj.elm_moduleContent.innerHTML = content.firstChild.nodeValue;
			moduleObj.elm_moduleContent.style.height = "auto";
			moduleObj.elm_moduleContent.style.width = "auto";

			//apply alternative colors for certain modules
			var t = moduleObj.dataObj.widget_type;
			if ((t == MODULE_SYSINFO) || (t == MODULE_LICINFO) ||
				(t == MODULE_ALERT) || (t == MODULE_STATS))
			{
				$j("table:first > tbody > tr:odd", moduleObj.elm_moduleContent).addClass("odd");
			}
		}

		if (moduleObj.dataObj.isNew)
		{
			moduleObj.dataObj.isNew = false;
		}

		// Refresh widget title if it's changed since last refresh.
		moduleObj.elm_title.innerHTML = title.firstChild.nodeValue;

		// Refresh widget "extra" section if it's changed.
		if (moduleObj.elm_extra)
		{
		    // the extra could be blank
			moduleObj.elm_extra.innerHTML =  (extra && extra.firstChild) ? extra.firstChild.nodeValue : " ";
		}
	}
}
	
dashboard.isNewAction = function(objId, objType) {
	dashboard.savePanelContent();
	dashboard.addContent.update();
}

dashboard.sendReorderRequest = function(data) {
	Request.sendGET(URL_SysStatus + "&"+data+"&nocache="+Math.random());
}

//======= Add Content/Module ============
dashboard.addContent = new Object();
dashboard.addContent.isOpen = false;
dashboard.addContent.width = 220;

dashboard.addContent.display = function() {
	var mlist = $("moduleList");

	if (mlist.hasChildNodes()) {
		var tree = $("selectionTree");
		if (mlist.firstChild.style.display == "none") {
			mlist.firstChild.style.display = "block";
			dashboard.addContent.isOpen = true;
		} else {
			mlist.firstChild.style.display = "none";
			dashboard.addContent.isOpen = false;
		}
	} else {
		mlist.style.width = dashboard.addContent.width + "px";
		dashboard.addContent.build();
		dashboard.addContent.isOpen = true;
		mlist.style.display = 'block';
	}
}

dashboard.addContent.reset = function()
{
	if(window.confirm(dashboard.texts.confirm_reset))
	{
		var data = URL_SysStatus + "&reset_dashboard=1&nocache=" + Math.random();
		Request.sendGET(data, onresetdone);
	}
	else 
		return false;

	function onresetdone(response) {
		var rootNode = response.responseXML.documentElement;
		var status = rootNode.getElementsByTagName("reset_status")[0];
		if (status.firstChild.nodeValue == "OK"){
			// Close the content menu first.
			if (wij_in_modal_op && wij_in_modal_op())
				wij_end_modal_dialog();
			//alert("Dashboard has been reset to default settings.");

			// Refresh navbar to get new tab list.
			var frm = top.frames.mainnav;
			frm.nb_refresh_menu();
		}
	}
	return false;
} 

dashboard.getModuleByType = function(type) {
	for (var i = 0; i < dashboard.moduleList.length; i++) {
	if (type == dashboard.moduleList[i].dataObj.widget_type)
		return dashboard.moduleList[i];
	}
}

dashboard.addContent.build = function() {
	dashboard.addContent.show();

	Request.sendGET(URL_SysStatus + "&getModuleList=1&nocache="+Math.random(), onlistload);
	
	function onlistload(r) {
		var ctype = r.getResponseHeader("Content-Type");
		var content = ctype == "text/xml" ? r.responseXML.documentElement.firstChild.nodeValue : r.responseText;
		if (ctype != "text/xml" && content.indexOf("try_login()") > 0)  { // looks like a login page
			top.location.reload();
			return;
		}

		var rootNode = r.responseXML.documentElement;
		var mods = rootNode.getElementsByTagName("module");

		$("setting_caption").innerHTML = dashboard.texts.setting_title;

		var moduleListContent = "<table class='widget'>";

		var delta = 0;
		var cols = 3;
		for (var i = 0; i < mods.length; i++)
		{
			var m = mods[i]; 
			var name = mods[i].firstChild ? mods[i].firstChild.nodeValue : "";
			var id = mods[i].getAttribute("id");
			var type = mods[i].getAttribute("type");
			var maxInstances = mods[i].getAttribute("max-instances");

			if (id && (i + delta) % cols == 0)
				moduleListContent += '<tr>';

			if (!id) { // split line
				if ((i + delta) % cols)
					moduleListContent += "<td colspan=" + 2*(cols - (i + delta) % cols) + "></td></tr>";
				moduleListContent += "<tr><td colspan=6 height=5><hr size=1 noshade=\"\"/></td></tr>";
				delta += cols - (i + delta) % cols - 1;
				continue;
			}

			var found = dashboard.getModuleCount(type);
			var widget_on = true;
			if ((dashboard.moduleList.length >= MOD_MAX) || ((maxInstances != 0) && (found >= maxInstances)))
			{
				widget_on = false;
			}
			var mod = dashboard.getModuleByType(type);
			moduleListContent += '<td class="mod" mod="' + id +'" type=' + type + ' max-instances=' + maxInstances + '>'
			    + '<div class="icon ' + (widget_on ? "widget_on" : "widget_off") + '" /></td>';

			var cls;
			if (!widget_on)
				cls = "name_off";
			else
				cls = "name_on";
			moduleListContent += '<td class="' + cls
				+ '" mod="' + id + '" type=' + type  + ' max-instances=' + maxInstances + '>' + name + '</td>';

			if ((i + delta) % cols == cols - 1)
			    moduleListContent += '</tr>';

		}
		// TODO: where to put reset button
		moduleListContent += "</tr>";
		moduleListContent += "</table>";

		var td = $("widgetsList");
		td.innerHTML = moduleListContent;

		var items = [];
		function addItems(itms) {
			if (!itms || !itms.childNodes) return;
			for (var z=0; itms.childNodes[z]; z++) {
				if (itms.childNodes[z].getAttribute && itms.childNodes[z].getAttribute("mod")) {
					items.push(itms.childNodes[z]);
				}
				else if (itms.childNodes[z].hasChildNodes)
					addItems(itms.childNodes[z]);
			}
		}
		var selectionFrame = $("moduleSelectionFrame");
		addItems(selectionFrame);

		var ln = items.length;
		for (var z=0; z<ln; z++) {
			items[z].style.MozUserSelect = "none";
			items[z].onclick = function(e) {
				var maxInstances = this.getAttribute("max-instances");
				var type = this.getAttribute("type");
				var n;
				var found = dashboard.getModuleCount(type);

				if (e) e.cancelBubble = true;

				if (dashboard.moduleList.length >= MOD_MAX)
				{
					// Maximum # of mods per tab reached.
					alert(dashboard.texts.mod_max);
				}
				else if (maxInstances > 0 && found >= maxInstances)
				{
					//This module already exists on dasboard.
					alert(dashboard.texts.mod_exist);
				}
				else
				{
					//if no, send request to aquire latest module info
					var data = URL_SysStatus + "&getModule=" + encodeURIComponent(type) +
					           "&isNew=1&nocache=" + Math.random();
					Request.sendGET(data, dashboard.addNew);
				}
			}
		}
	}
}

dashboard.addContent.show = function() {
	var moduleSelectionHtml =
		"<table id=moduleSelection style=\"padding: 1px; background-color: #eee; display: \">"
		+ "<tbody id=moduleSelectionFrame>"
		+ "<tr id=content_header class=module_title>"
		+ "<td class=title height=20 style>"
		+ "<img id=dashboard_setting_close src=\"/images/x_small.gif\" "
		+ "style=\"float:right; cursor: pointer; width: 15px; height: 15px;\" "
		+ "onclick=\"wij_end_modal_dialog();\" "
		+ "title=\"" + dashboard.texts.close + "\">"
		+ "<nobr id=\"setting_caption\">" + dashboard.texts.setting_title + "</nobr>"
		+ "</td></tr>"
		+ "<tr height=100%><td id=widgetsList>"
		+ "<table class=widget height=100%><tr><td align=center><img src='/images/loading.gif'></td></tr></table>"
		+ "</td></tr></tbody></table>";
	wij_display_modal_content(moduleSelectionHtml, "");
}

dashboard.addContent.update = function() {
	var root = $("widgetsList");

	function updateChildNodes(r) {
		if (r && r.hasChildNodes) {
			var mods = r.childNodes;
			for(var i=0; i<mods.length; i++) {
				var mod = mods[i];
				if (mod.className != "mod")
					updateChildNodes(mods[i]);

				if (mod.getAttribute) {
					var count = dashboard.getModuleCount(mod.getAttribute("type"));
					var maxInstances = mod.getAttribute("max-instances");

					if (maxInstances != null && mods[i + 1]) {
						if ((dashboard.moduleList.length >= MOD_MAX) || (maxInstances != "0" && count >= maxInstances))
						{
						        $j("div", $j(mods[i])).addClass("widget_off") .removeClass("widget_on");     
							mods[i + 1].className = "name_off";
						}
						else
						{
						        $j("div", $j(mods[i])).addClass("widget_on") .removeClass("widget_off");     
							mods[i + 1].className = "name_on";
						}
					}
				}
				updateChildNodes(mods[i]);
			}
		}
	}
	updateChildNodes(root);
}

dashboard.refreshModule = function(id)
{
	for (var n=0; n < dashboard.moduleList.length; n++)
	{
		if (id == dashboard.moduleList[n].dataObj.id)
		{
			dashboard.moduleList[n].refresh();
			break;
		}
	}
}

window.onunload = function() {
	try {
		var ln = dashboard.moduleList.length;
		for (var z=0; z<ln; z++) {
			delete dashboard.moduleList[z];
			dashboard.moduleList[z] = null;
		}
		delete dashboard;
		dashboard = null;
	}
	catch (e) {}
}




MODULE_SYSINFO = 0
MODULE_LICINFO = 1
MODULE_SYSOP = 2
MODULE_SYSRES = 3
MODULE_ALERT = 4
MODULE_STATS = 5
MODULE_JSCONSOLE = 6
MODULE_SESSIONS = 7
MODULE_RAID = 8
MODULE_TOP_VIRUSES = 9
MODULE_TOP_ATTACKS = 10
MODULE_TR_HISTORY = 11
MODULE_APP_USAGE = 12
MODULE_POL_USAGE = 13
MODULE_DLP_USAGE = 14
MODULE_PER_IP_USAGE = 15
MODULE_IM_USAGE = 16
MODULE_P2P_USAGE = 17
MODULE_VOIP_USAGE = 18
MODULE_STORAGE = 19
MODULE_PROTOCOL_USAGE = 20
MODULE_LOG_MONITOR = 21
MODULE_SESSIONS_HISTORY = 22

function custom_widget_display(id) {
	wij_display_modal_dlg('/system/status/custom_widget?id=' + id, { "width": 500 });
}
function custom_alert_display(id) {
	wij_display_modal_dlg('/system/status/custom_alert?id=' + id, { "width": 500 });
}
function custom_sysres_display(id) {
	wij_display_modal_dlg('/system/status/custom_sysres?id=' + id, { "width": 500 });
}
function custom_sessions_display(id) {
	if (window.opener) {
		new_win('/system/widget/sessions_custom?id=' + id, 'custom_sessions_' + id, 500, 300);
	} else {
		wij_display_modal_dlg('/system/widget/sessions_custom?id=' + id, { "width": 500 });
	}
}
function custom_viruses_display(id) {
	wij_display_modal_dlg('/system/widget/virus_custom?id=' + id,  { "width": 500 });
}
function custom_attacks_display(id) {
	wij_display_modal_dlg('/system/widget/attack_custom?id=' + id, { "width": 500 });
}
function custom_tr_history_display(id) {
	wij_display_modal_dlg('/system/widget/tr_history_settings?id=' + id, { "width": 500 });
}
function custom_app_usage_display(id) {
	wij_display_modal_dlg('/system/widget/app_usage_custom?id=' + id, { "width": 500 });
}
function custom_pol_usage_display(id) {
	wij_display_modal_dlg('/system/widget/pol_usage_custom?id=' + id, { "width": 500 });
}
function custom_dlp_usage_display(id) {
	wij_display_modal_dlg('/system/widget/dlp_usage_custom?id=' + id, { "width": 500 });
}
function custom_per_ip_usage_display(id) {
	wij_display_modal_dlg('/system/widget/per_ip_usage_custom?id=' + id, { "width": 500 });
}
function custom_protocol_usage_display(id) {
	wij_display_modal_dlg('/system/widget/protocol_usage_custom?id=' + id, { "width": 600 });
}

function traffic_history_display(id, period) {
    popup_nonscrollable("/system/widget/tr_history_enlarge?id=" + id + "&period=" + period, "tr_history", 800, 600);
}

function alert_history_display(id) {
	wij_display_modal_dlg('/system/alert/console?id=' + id, { "width": 600, "height": 400 });
}

function virus_history_display() {
	wij_display_modal_dlg('/system/widget/virus_history', { "width": 600 });
}

function attack_history_display() {
	wij_display_modal_dlg('/system/widget/attack_history', { "width": 600 });
}

function get_iframe_doc_by_prefix(prefix)
{
    // The default document is used from the dashboard.
    var hDocument = document;

    var iframe = document.getElementById(prefix + "_iframe");

    // From the detached widget, we get the width & height internally, as we need
    // to know the height minus the time stamp, etc.
    if (iframe)
    {
        var oDoc = iframe.contentWindow || iframe.contentDocument;
        if (oDoc && oDoc.document)
        {
            hDocument = oDoc.document;
        }
    }

    return hDocument;
}

function is_iframe_detached(prefix)
{
    var msg = parent.document.getElementById(prefix + "_detach_msg");
    
    if (msg && msg.style.visibility == "visible")
    {
        return 1;
    }

    return 0;
}

function update_widget_frame(id, base_url, interval, params)
{
    var width = null;
    var height = null;

    var prefix = 'db_' + id;

    var hDocument = get_iframe_doc_by_prefix(prefix);

    // There was a reason behind this, but I can't recall it.
    var fuzz = 6;

    var img = hDocument.getElementById(prefix + '_img');
    var table = hDocument.getElementById(prefix + '_table');

    // Nothing to update - timer will be removed here.
    if (!img && !table)
        return;

    // If the widget is detached, we want to stop the refresh timers.
    // Aborting this function here will not do any refresh, nor will
    // it renew the timer. If the widget is attached again, the auto
    // refresh will be turned on.
    if (is_iframe_detached(prefix))
        return;

    var elem = hDocument.getElementById(prefix);
    if (elem && img)
    {
        // From the popup window, we change the image to the 
        // loading gif for two reasons - it looks nicer than displaying
        // an improperly sized image, and if we are downsizing the
        // window the larger image will throw off the height & width
        // calculations below.
        // If there is some flicker during refresh, this could be changed
        // to only happen on a resize event.
        img.src = "/images/loading.gif";
        img.height = "16";
        img.width = "16";

        width = elem.offsetWidth - fuzz;
        height = elem.offsetHeight - fuzz;

        // The manually set height & width are removed here to allow
        // the new image to take its appropriate size.
        img.removeAttribute("height");
        img.removeAttribute("width");

        // Prevent negative width & heights from being used, and just
        // stick with the default image size provided to us.
        if (width < 0) width = null;
        if (height < 0) height = null;
    }

    if (!params) params = "";

    // The image will be updated in update_widget_display based on the XML
    // data returned via the "getContent" request.

    var content_url = base_url + '?getContent';

    content_url += '&id=' + id;
    content_url += '&nocache=' + Math.random();

    // These parameters are used so that the request handled by update_widget_display
    // has the correct co-ordinates to use in the image map.
    if (width) content_url += '&w=' + width;
    if (height) content_url += '&h=' + height;

    if (params) content_url += params;

    Request.sendGET(content_url, update_widget_display);

    if (interval > 0) setTimeout("update_widget_frame(" + id + ", '" + base_url + "', " + interval + ", '" + params + "');", interval * 1000);
}

// Populate data into widget tables
function update_widget_display(response)
{
    try
    {
        var rootNode = response.responseXML.documentElement;

        var widgetNode = rootNode.getElementsByTagName("top_widget")[0];

        var Widget = new DashboardChart( widgetNode );

        Widget.refresh();

        return true;
    }
    catch (e)
    {
        return false;
    } 
}

/***********************
 * DashboardChart Class - Parses various XML responses related to GUI dashboard
 * charts, and refreshes the display based on the settings.
 *
 * The XML format is as follows:
 * 
 * Bar Chart:
 *
 * <top_widget style="bar" id="1" type="7" width="w" height="h">
 *   <total>n</total>
 *   <time>2009-04-28 13:00:00</time>
 *   <sort_column>saddr</saddr>
 *
 *   <segment name="name">
 *     <value count="n" shape="rect">0, 0, 0, 0</value>
 *   </segment>
 * </top_widget>
 *
 * Stacked Bar Chart:
 *
 * <top_widget type="stacked" prefix="dlp_usage" width="w" height="h">
 *   <time>2009-04-28 13:00:00</time>
 *
 *   <segment name="name">
 *     <value count="50" shape="rect">0, 0, 0, 100</value>
       <value count="100" shape="rect">0, 110, 100, 210</value>
 *   </segment>
 *
 *   <legend>Bytes In</legend>
 *   <legend>Bytes Out</legend>
 * </top_widget>
 *
 * Line Chart:
 *
 * For line chart, instead of introducing a new XML response definition,
 * we reuse the framework of stacked (bar) chart only with 3 diffences
 *  - One more segment, for start and end points are both needed for drawing line chart
 *  - There could be <segment name="">, in case that more data is provided inside each grid for drawing finer graphic
 *  - no map support
 *
 * <top_widget type="line"  id="1" type="7" width="w" height="h>
 *   <time>2009-04-28 13:00:00</time>
 *
 *   <segment name="name">
 *     <value count="50"></value>
 *     <value count="100"></value>
 *   </segment>
 *   <segment name="">
 *     <value count="50"></value>
 *     <value count="100"></value>
 *   </segment>
 *   <segment name="name">
 *     <value count="50"></value>
 *     <value count="100"></value>
 *   </segment>
 *
 *   <legend>Bytes In</legend>
 *   <legend>Bytes Out</legend>
 * </top_widget>
 *
 *
 * *********************/

function DashboardChart(obj)
{
    try
    {
        this.xml_response = obj;

        this.type = obj.getAttribute("type");
        this.id = obj.getAttribute("id");
        this.prefix = "db_" + this.id;

        this.hDocument = get_iframe_doc_by_prefix( this.prefix );

        // Chart type (bar, stacked, line, etc)
        this.style = obj.getAttribute("style");

        // Expected chart width & height
        this.width = obj.getAttribute("width");
        this.height = obj.getAttribute("height");

        // The x-axis label orientation defaults to "angled", which is 45
        // degrees. It can be overriden with options like "horizontal".
        this.x_angle = "angled";

        this.y_caption = obj.getAttribute("y_caption");

        this.flags = obj.getAttribute("flags");

        // the URL could be given for case of drawing chart graphic directly
        this.url = obj.getAttribute("url");

        this.total = xnode2String(obj.getElementsByTagName("total"));
        this.cps= xnode2String(obj.getElementsByTagName("cps")); //top session widget only
        this.time = xnode2String(obj.getElementsByTagName("time"));

        this.global_mode = xnode2String(obj.getElementsByTagName("global_mode"));

        // Initialize segments list.
        this.segments = new Array();

        this.addSegments();

        // Initialize legends list.
        this.legends = new Array();

        this.addLegends();
    }
    catch (e)
    {
        // Error parsing XML Response.
    }
}

// DashboardChart.refresh - Update the chart based on the parsed values.
DashboardChart.prototype.refresh = function()
{
    this.refreshTable();

    this.refreshMap();

    this.refreshImage();

    this.refreshTime();

    this.refreshTotal();

    this.refreshCPS();
}

// DashboardChart.addSegments - Add each individual chart segment from the XML response.
DashboardChart.prototype.addSegments = function()
{
    var segmentList = this.xml_response.getElementsByTagName("segment");

    this.segments.length = 0;

    for (var i=0; i<segmentList.length; i++)
    {
        if (this.type == MODULE_SESSIONS)
        {
            var obj = new SessionsChartSegment(segmentList[i], this);
        }
        else if (this.type == MODULE_APP_USAGE)
        {
            var obj = new ApplicationChartSegment(segmentList[i], this);
        }
        else if (this.type == MODULE_POL_USAGE)
        {
            var obj = new PolicyChartSegment(segmentList[i], this);
        }
        else if (this.type == MODULE_DLP_USAGE)
        {
            var obj = new ArchiveChartSegment(segmentList[i], this);
        }
        else if (this.type == MODULE_PER_IP_USAGE)
        {
            var obj = new PerIPChartSegment(segmentList[i], this);
        }
        else if (this.type == MODULE_TOP_VIRUSES)
        {
            var obj = new VirusChartSegment(segmentList[i], this);
        }
        else if (this.type == MODULE_TOP_ATTACKS)
        {
            var obj = new AttackChartSegment(segmentList[i], this);
        }
        else if (this.type == MODULE_PROTOCOL_USAGE)
        {
            var obj = new ProtocolUsageChartSegment(segmentList[i], this);
        }
        else
        {
            var obj = new DashboardChartSegment(segmentList[i], this);
        }

        this.segments.push( obj );
    }
}

// DashboardChart.addLegends - Add each individual legend from the XML response.
DashboardChart.prototype.addLegends = function()
{
    var legendList = this.xml_response.getElementsByTagName("legend");

    this.legends.length = 0;

    for (var i=0; i<legendList.length; i++)
    {
        this.legends.push( new DashboardChartLegend(legendList[i]) );
    }
}

// DashboardChart.clearTable - Clear all entries in the table.
DashboardChart.prototype.clearTable = function()
{
    try
    {
        var el_table = this.hDocument.getElementById(this.prefix + "_table");

        // Remove existing entries from the table, leave the heading
        for (var i=el_table.rows.length-1; i > 0; i--)
        {
            el_table.deleteRow(i);
        }
    }
    catch (e)
    {
    }
}

// DashboardChart.refreshTable - Remove any existing table entries, and
// add all of the entries known to the object.
DashboardChart.prototype.refreshTable = function()
{
    var el_table = this.hDocument.getElementById(this.prefix + "_table");

    if (el_table)
    {
        this.clearTable();

        for (var i=0; i<this.segments.length; i++)
        {
            this.segments[i].addToTable(el_table);
        }

        var vID = 1;
        for (var i=0; i<this.segments.length; i++)
        {
            vID += this.segments[i].adjustUsage(vID);
        }

        update_iframe_height(this.prefix + "_iframe", window.parent, 1);
    }
}

DashboardChart.prototype.refreshMap = function()
{
    try
    {
        var el_map = this.hDocument.getElementById(this.prefix + "_map");

        // Remove existing map entries
        el_map.innerHTML = "";

        for (var i=0; i<this.segments.length; i++)
        {
            this.segments[i].addToMap(el_map);
        }
    }
    catch (e)
    {
    }
}

DashboardChart.prototype.refreshTime = function()
{
    var el_time = this.hDocument.getElementById(this.prefix + "_time");

    if (el_time)
    {
        el_time.innerHTML = this.time;
    }
}

DashboardChart.prototype.refreshTotal = function()
{
    var el_total = this.hDocument.getElementById(this.prefix + "_total");

    if (el_total)
    {
        el_total.innerHTML = this.total;
    }
}

DashboardChart.prototype.refreshCPS = function()
{
    var el_cps = this.hDocument.getElementById(this.prefix + "_cps");

    if (el_cps)
    {
        el_cps.innerHTML = this.cps;
    }
}

DashboardChart.prototype.getURLPrefix = function()
{
    URLPrefix = "/chart/bar?";

    if (this.style == "bar")
    {
        URLPrefix = "/chart/bar?";
    }
    else if (this.style == "stacked")
    {
        URLPrefix = "/chart/stacked?";
    }
    else if (this.style == "line")
    {
        URLPrefix = "/chart/line?";
    }

    return URLPrefix;
}

DashboardChart.prototype.toURLString = function()
{
    var URLString = "";

    try
    {
        if (this.url)
        {
            // the URL is given in the XML response
            URLString += this.url + "&";
        }
        else
        {
            URLString += this.getURLPrefix();
        }


        URLString += "w=" + this.width + "&";

        URLString += "h=" + this.height + "&";

        if (this.flags)
        {
            URLString += "f=" + this.flags + "&";
        }

        if (this.y_caption)
        {
            URLString += "yc=" + this.y_caption + "&";
        }

        if (this.x_angle == "horizontal")
        {
            URLString += "hl&";
        }

        if (this.bar_type)
        {
            URLString += "bt=" + this.bar_type + "&";
        }

        if (this.template)
        {
            URLString += "t=" + this.template + "&";
        }

        // In case that URL is given, only need the basic options above
        if (this.url) {
            // unlike the image generated by GUI chart interface,
            // image generated by given URL could be different, though the URL could be the same. 
            // so avoid image caching here
            return URLString + "nocache=" + Math.random();
        }
        
        // Previously a random number was appended to this URL to prevent image
        // caching, however each URL now uniquely represents a given chart. In
        // the new implementation it's beneficial to have the browser cache
        // each chart.

        // the URL format for line chart is different from that of bar/stacked chart,
        // though they share the same definition of segment in XML response
        if (this.style == "line" && this.segments.length >0)
        {
            // the URL format is like 
            //    /chart/line?v=4100,4101,1900,191,1,6,3,1,1,1&v=4200,1101,200,191,1,2,444,8,9,10&l=2010/01/01&l=2010/02/01&l=2010/03/01&l=2010/04/01
            // the "v" is composed from value with the same index inside each segment

            // first compose "v"
            var sig_idx = 0;
            var sig_length = this.segments.length;
            var val_length = this.segments[0].values.length;
            for (var val_idx = 0; val_idx < val_length; val_idx++)
            {
                var vURL = "v=";
                for (sig_idx = 0; sig_idx < sig_length; sig_idx++)
                {
                    if (val_idx >= this.segments[sig_idx].values.length)
                    {
                        // Invalid XML reponse, just skip
                        break;
                    }
                    else
                    {
                        vURL += (sig_idx > 0 ? "," : "") + this.segments[sig_idx].values[val_idx].count;
                    }
                }
                if (sig_idx < sig_length)
                {
                    // Invalid XML reponse, just stop
                    break;
                }
                else
                {
                    URLString += vURL + "&";
                }
            }

            // then compose "l"
            for (sig_idx = 0; sig_idx < sig_length; sig_idx++)
            {
                var labelString = this.segments[sig_idx].getLabel();
                // skip data point which is inside each grid and only for drawing finer graphic
                if (labelString != "")
                {
                    URLString += "l=" + labelString + "&";
                }
            }
        }
        else
        {
            for (var i=0; i<this.segments.length; i++)
            {
                URLString += this.segments[i].toURLString();
            }
        }

        for (var i=0; i<this.legends.length; i++)
        {
            URLString += this.legends[i].toURLString();
        }
    }
    catch (e)
    {
    }

    return URLString;
}

DashboardChart.prototype.refreshImage = function()
{
    try
    {
        var prefix = this.prefix;

        var img = this.hDocument.getElementById(prefix + '_img');

        var URLString = this.toURLString();

        // This updates the widget iframe height on the dashboard after
        // the image is loaded to ensure that it is fully visible.
        img.onload = function() {
            update_iframe_height(prefix + '_iframe', window.parent);
        };

        img.src = URLString;
    }
    catch (e)
    {
    }
}

DashboardChart.prototype.getLegendName = function( index )
{
    if ( index < this.legends.length )
    {
        return this.legends[ index ].toString();
    }

    return "";
}

DashboardChart.prototype.isGlobalMode = function()
{
    if (this.global_mode == "1")
    {
        return true;
    }

    return false;
}

DashboardChart.prototype.getMaximumUsage = function()
{
    var max = 0;

    for (var i = 0; i < this.segments.length; i++)
    {
        var v = this.segments[ i ].getMaximumUsage();

        if ( v > max ) max = v;
    }

    return max;
}


/********************
 * DashboardChartSegment Class - Each "Segment" on a displayed chart
 * is represented by a ChartSegment instance. In the case of stacked 
 * bars or line charts, the "Segment" will have multiple values. 
 ********************/

function DashboardChartSegment(chartSegment, dashboardChart)
{
    try
    {
        this.dashboardChart = dashboardChart;
        this.hDocument = dashboardChart.hDocument;

        this.chartSegment = chartSegment;

        this.name = chartSegment.getAttribute("name");

        this.values = new Array();

        var valueList = this.chartSegment.getElementsByTagName("value");

        for (var j=0; j<valueList.length; j++)
        {
            this.addValue( valueList[j] );
        }
    }
    catch (e)
    {
    }
}

DashboardChartSegment.prototype.addValue = function( value )
{
    this.values.push( new DashboardChartSegmentValue( value, this ) );
}

DashboardChartSegment.prototype.addToMap = function(el_map)
{
    for (var i=0; i<this.values.length; i++)
    {
        // there could be no map support for charts like line chart
        if (this.values[i].shape)
        {
            this.values[i].addToMap(el_map);
        }
    }
}

DashboardChartSegment.prototype.addToTable = function(el_table)
{
    for (var i=0; i<this.values.length; i++)
    {
        this.values[i].addToTable(el_table);
    }
}

DashboardChartSegment.prototype.adjustUsage = function(vID)
{
    for (var i=0; i<this.values.length; i++)
    {
        if (this.values[i].adjustUsage)
        {
            this.values[i].adjustUsage(vID + i);
        }
    }

    return this.values.length;
}

DashboardChartSegment.prototype.getLabel = function()
{
    return this.name;
}

DashboardChartSegment.prototype.toURLString = function()
{
    var URLString = "";

    URLString += "l=" + this.getLabel() + "&";

    for (var i=0; i<this.values.length; i++)
    {
        URLString += this.values[i].toURLString();
    }

    return URLString;
}

DashboardChartSegment.prototype.getMaximumUsage = function()
{
    var max = 0;

    for (var i = 0; i < this.values.length; i++)
    {
        var v = this.values[i].count;

        if ( v > max ) max = v;
    }

    return max;
}

DashboardChartSegment.prototype.getTotalUsage = function()
{
    var total = 0;

    for (var i = 0; i < this.values.length; i++)
    {
        total += this.values[i].count;
    }

    return total;
}


/********************
 * DashboardChartSegmentValue Class - Each "Value" on a displayed chart
 * is represented by a ChartSegmentValue instance. A single slice on a 
 * pie chart would be one value of a segment, however, a stacked bar
 * segment would contain multiple values. 
 ********************/

function DashboardChartSegmentValue(value, chartSegment)
{
    try
    {
        this.chartSegment = chartSegment;
        this.hDocument = chartSegment.hDocument;

        this.valueIndex = chartSegment.values.length;

        this.count = Number(value.getAttribute("count"));

        this.shape = value.getAttribute("shape");
        // there could be no map support for charts like line chart
        if (this.shape)
        {
            this.map_coords = value.firstChild.data;
        }
    }
    catch (e)
    {
    }
}


// addToMap - generic add to map
DashboardChartSegmentValue.prototype.addToMap = function(el_map)
{
    var el_area = this.hDocument.createElement("area");
    var title = "[" + this.count + "] " + this.chartSegment.name;

    el_area.shape = this.shape;
    el_area.coords = this.map_coords;

    el_area.onmouseout = function() { 
        nd();
    };

    el_area.onmouseover = function() {
        overlib(title, HAUTO, VAUTO);
    };

    el_map.appendChild(el_area);
}

DashboardChartSegmentValue.prototype.getLegendName = function()
{
    return this.chartSegment.dashboardChart.getLegendName( this.valueIndex );
}

// DashboardChartSegmentValue.toURLString - Convert a segment value
// to a URL suitable for passing to the FortiGate chart rendering interface.
DashboardChartSegmentValue.prototype.toURLString = function()
{
    var URLString = "v=" + this.count + "&";

    return URLString;
}

// usagePercent - The maximum % of the available space in the table cell that
// can be used by the volume bar.
DashboardChartSegmentValue.prototype.usagePercent = 0.8;

// getUsageWidth - Calculates a width in pixels based on the available space
// within the table cell, and the overall usage percentage of this value compared
// to the maximum value.
DashboardChartSegmentValue.prototype.getUsageWidth = function()
{
    var maxUsage = this.chartSegment.dashboardChart.getMaximumUsage();

    var usagePercent = (this.count / maxUsage);

    var availableWidth = (this.usageCell.offsetWidth - this.usageSpan.offsetWidth) * this.usagePercent;
    
    return (availableWidth * usagePercent);
}

/********************
 * SessionsChartSegment Class
 * - Overrides DashboardChartSegment
 * - Provides top-sessions specific features.
 ********************/

function SessionsChartSegment(chartSegment, dashboardChart)
{
    DashboardChartSegment.call(this, chartSegment, dashboardChart);

    var resolved = this.chartSegment.getElementsByTagName("resolved");

    if (resolved && resolved.length)
    {
        this.resolved = xnode2String(resolved);
    }

    var username = this.chartSegment.getElementsByTagName("username");

    if (username && username.length)
    {
        this.username = xnode2String(username);
    }

    this.sort_column = xnode2String(this.dashboardChart.xml_response.getElementsByTagName("sort_column"));

    this.dashboardChart.bar_type = "bar_h";
    this.dashboardChart.template = "simple";

    var ip_ver = xnode2String(this.dashboardChart.xml_response.getElementsByTagName("ip_ver"));

    var id = this.dashboardChart.id;
    var sort_column = this.sort_column;

    this.drillDown = function() {
        var sort_obj = {
            ipver: ip_ver,
            field: sort_column,
            value: this.getAttribute("name")
        };

        return change_sessions_display("/system/widget/session_table", id, sort_obj);
    }
}

SessionsChartSegment.prototype = new DashboardChartSegment();

SessionsChartSegment.prototype.constructor = SessionsChartSegment;

SessionsChartSegment.prototype.getLabel = function()
{
    // Only display if the username is actually set
    if (this.username)
    {
        return this.username;
    }
    else if (this.resolved)
    {
        return this.resolved;
    }

    return DashboardChartSegment.prototype.getLabel.apply(this);
}

SessionsChartSegment.prototype.addValue = function( value )
{
    this.values.push( new SessionsChartSegmentValue( value, this ) );
}


/********************
 * SessionsChartSegmentValue Class
 * - Overrides DashboardChartSegmentValue
 * - Provides top-sessions specific features.
 ********************/

function SessionsChartSegmentValue(value, chartSegment)
{
    DashboardChartSegmentValue.call(this, value, chartSegment);
}

SessionsChartSegmentValue.prototype = new DashboardChartSegmentValue();

SessionsChartSegmentValue.prototype.constructor = SessionsChartSegmentValue;

SessionsChartSegmentValue.prototype.addToTable = function(el_table)
{
    var el_row = el_table.insertRow(el_table.rows.length);

    var el_id = this.hDocument.createElement("td");
    var el_name = this.hDocument.createElement("td");
    var el_username = this.hDocument.createElement("td");
    var el_count = this.hDocument.createElement("td");
    var el_action = this.hDocument.createElement("td");

    el_id.innerHTML = (el_table.rows.length - 1);

    el_row.appendChild(el_id);

    el_name.innerHTML = this.chartSegment.name;

    if (this.chartSegment.resolved)
    {
        el_name.innerHTML += " (" + this.chartSegment.resolved + ")";
    }

    el_row.appendChild(el_name);

    // If we are using the username column, this attribute will be included
    if (typeof this.chartSegment.username != "undefined")
    {
        el_username.innerHTML = this.chartSegment.username;
        el_row.appendChild(el_username);
    }

    el_count.innerHTML = this.count;
    el_row.appendChild(el_count);

    var el_link = this.hDocument.createElement("a");
    var el_img = this.hDocument.createElement("img");

    el_img.src = "/images/view.gif";

    el_link.href = "#";
    el_link.setAttribute("name", this.chartSegment.name);
    el_link.onclick = this.chartSegment.drillDown;

    el_link.appendChild(el_img);
    el_action.appendChild(el_link);
    el_row.appendChild(el_action);
}

SessionsChartSegmentValue.prototype.addToMap = function(el_map)
{
    var el_area = this.hDocument.createElement("area");

    el_area.shape = this.shape;
    el_area.coords = this.map_coords;

    var title = "[" + this.count + "] " + this.chartSegment.name;

    // Only display if the username is actually set
    if (this.chartSegment.username)
    {
        title += " (" + this.chartSegment.username + ")";
    }
    else if (this.chartSegment.resolved)
    {
        title += " (" + this.chartSegment.resolved + ")";
    }

    el_area.onmouseout = function() { 
        nd();
    };

    el_area.onmouseover = function() {
        overlib(title, HAUTO, VAUTO);
    };

    el_area.href = "#";
    el_area.setAttribute("name", this.chartSegment.name);

    el_area.onclick = this.chartSegment.drillDown;

    el_map.appendChild(el_area);   
}



/********************
 * PolicyChartSegment Class
 * - Overrides DashboardChartSegment
 * - Provides Policy Usage specific features.
 ********************/

function PolicyChartSegment(chartSegment, dashboardChart)
{
    DashboardChartSegment.call(this, chartSegment, dashboardChart);

    var sort_by = this.dashboardChart.xml_response.getElementsByTagName("sort_by")[0];

    this.sort_by = sort_by.getAttribute("id");
    this.sort_by_str = sort_by.firstChild.data; 

    this.vdom = xnode2String(chartSegment.getElementsByTagName("vdom"));

    this.from_zone = xnode2String(chartSegment.getElementsByTagName("from_zone"));

    this.to_zone = xnode2String(chartSegment.getElementsByTagName("to_zone"));

    this.action = xnode2String(chartSegment.getElementsByTagName("action"));

    this.identity = xnode2String(chartSegment.getElementsByTagName("identity"));

    this.dashboardChart.x_angle = "horizontal";

    var vdom = this.vdom;
    var global_mode = this.dashboardChart.isGlobalMode();

    this.drillDown = function() {
        var policy_id = this.getAttribute("name");
        
        if (global_mode)
        {
            return show_policy_details(policy_id, vdom);
        }

        return show_policy_details(policy_id, vdom);
    }
}

PolicyChartSegment.prototype = new DashboardChartSegment();

PolicyChartSegment.prototype.constructor = PolicyChartSegment;

PolicyChartSegment.prototype.addValue = function( value )
{
    this.values.push( new PolicyChartSegmentValue( value, this ) );
}


/********************
 * PolicyChartSegmentValue Class
 * - Overrides DashboardChartSegmentValue
 * - Provides Policy Usage specific features.
 ********************/

function PolicyChartSegmentValue(value, chartSegment)
{
    DashboardChartSegmentValue.call(this, value, chartSegment);
}

PolicyChartSegmentValue.prototype = new DashboardChartSegmentValue();

PolicyChartSegmentValue.prototype.constructor = PolicyChartSegmentValue;

PolicyChartSegmentValue.prototype.addToTable = function(el_table)
{
    var el_row = el_table.insertRow(el_table.rows.length);

    var el = this.hDocument.createElement("td");
    el.innerHTML = (el_table.rows.length - 1);
    el_row.appendChild(el);

    el = this.hDocument.createElement("td");
    el.innerHTML = this.chartSegment.name;
    el_row.appendChild(el);

    if (this.chartSegment.dashboardChart.isGlobalMode())
    {
        el = this.hDocument.createElement("td");
        el.innerHTML = this.chartSegment.vdom;
        el_row.appendChild(el);
    }

    // Add "Usage" column.
    el = this.hDocument.createElement("td");
    el.className = "dashboard-usage";

    div = this.hDocument.createElement("div");
    el_img = this.hDocument.createElement("img");
    el_img.src = "/images/blank.gif";

    div.appendChild(el_img);
    el.appendChild(div);

    sp = this.hDocument.createElement("span");

    sp.innerHTML = this.formatCount(this.count);

    el.appendChild(sp);

    el_row.appendChild(el);

    // Maintain references to some elements for width calculations
    // and volume bar generation.
    this.usageSpan = sp;
    this.usageImage = el_img;
    this.usageCell = el;

    el = this.hDocument.createElement("td");
    var el_link = this.hDocument.createElement("a");
    el_img = this.hDocument.createElement("img");

    el_img.src = "/images/view.gif";

    el_link.href = "#";
    el_link.setAttribute("name", this.chartSegment.name);
    el_link.onclick = this.chartSegment.drillDown;

    el_link.appendChild(el_img);
    el.appendChild(el_link);
    el_row.appendChild(el);
}

PolicyChartSegmentValue.prototype.adjustUsage = function(vID)
{
    if (this.usageImage)
    {
        this.usageImage.style.width = this.getUsageWidth() + "px";
    }
}

PolicyChartSegmentValue.prototype.addToMap = function(el_map)
{
    var title = "";
    var el_area = this.hDocument.createElement("area");

    el_area.shape = this.shape;
    el_area.coords = this.map_coords;

    title += pol_usage_texts.policy_id + ": " + this.chartSegment.name + "<br>";

    // Only show VDOM information when in Global mode.
    if (this.chartSegment.dashboardChart.isGlobalMode())
    {
        title += pol_usage_texts.vdom + ": " + this.chartSegment.vdom + "<br>";
    }

    title += pol_usage_texts.total + ": " + this.formatCount(this.count) + "<br>";

    title += pol_usage_texts.src_zone + ": " + this.chartSegment.from_zone + "<br>";
    title += pol_usage_texts.dst_zone + ": " + this.chartSegment.to_zone + "<br>";
    title += pol_usage_texts.action + ": " + this.chartSegment.action + "<br>";

    if (this.chartSegment.identity == "1")
    {
        title += pol_usage_texts.identity + "<br>";
    }

    el_area.onmouseout = function() { 
        nd();
    };

    el_area.onmouseover = function() {
        overlib(title, HAUTO, VAUTO);
    };

    el_area.href = "#";
    el_area.setAttribute("name", this.chartSegment.name);

    el_area.onclick = this.chartSegment.drillDown;

    el_map.appendChild(el_area);
}

PolicyChartSegmentValue.prototype.formatCount = function(count)
{
    if (this.chartSegment.sort_by == pol_usage_opts.sort_by_bytes)
    {
        return ConvertNumberToUnits(count);
    }

    return count + " " + this.chartSegment.sort_by_str;
}

/********************
 * ArchiveChartSegment Class
 * - Overrides DashboardChartSegment
 * - Provides DLP Archive Usage specific features.
 ********************/

function ArchiveChartSegment(chartSegment, dashboardChart)
{
    DashboardChartSegment.call(this, chartSegment, dashboardChart);

    this.vdom = xnode2String(chartSegment.getElementsByTagName("vdom"));

    this.clog_prefix = xnode2String(chartSegment.getElementsByTagName("clog_prefix"));

    var sort_by = this.dashboardChart.xml_response.getElementsByTagName("sort_by")[0];

    this.sort_by = sort_by.getAttribute("id");
    this.sort_by_str = sort_by.firstChild.data; 

    var report_by = this.dashboardChart.xml_response.getElementsByTagName("report_by")[0];

    this.report_by = report_by.getAttribute("id");
    this.report_by_str = report_by.firstChild.data; 

    var clog_prefix = this.clog_prefix;
    var vdom = this.vdom;
    var global_mode = this.dashboardChart.isGlobalMode();

    if (this.report_by == dlp_usage_opts.report_by_policy)
    {
        this.dashboardChart.x_angle = "horizontal";

        this.drillDown = function() {
            var policy_id = this.getAttribute("name");

            if (global_mode)
            {
                return show_policy_details(policy_id, vdom);
            }

            return show_policy_details(policy_id);
        }
    }
    else if (this.report_by == dlp_usage_opts.report_by_protocol)
    {
        this.drillDown = function() {
            new_win("/system/status/" + clog_prefix, clog_prefix, 800, 500);
        };
    }
}

ArchiveChartSegment.prototype = new DashboardChartSegment();

ArchiveChartSegment.prototype.constructor = ArchiveChartSegment;

ArchiveChartSegment.prototype.addValue = function( value )
{
    this.values.push( new ArchiveChartSegmentValue( value, this ) );
}


/********************
 * ArchiveChartSegmentValue Class
 * - Overrides DashboardChartSegmentValue
 * - Provides DLP Archive Usage specific features.
 ********************/

function ArchiveChartSegmentValue(value, chartSegment)
{
    DashboardChartSegmentValue.call(this, value, chartSegment);
}

ArchiveChartSegmentValue.prototype = new DashboardChartSegmentValue();

ArchiveChartSegmentValue.prototype.constructor = ArchiveChartSegmentValue;

ArchiveChartSegmentValue.prototype.addToMap = function(el_map)
{
    var title = "";
    var el_area = this.hDocument.createElement("area");

    el_area.shape = this.shape;
    el_area.coords = this.map_coords;

    title += this.chartSegment.report_by_str + ": " + this.chartSegment.name + "<br>";

    // Only show VDOM information when in Global mode.
    if (this.chartSegment.dashboardChart.isGlobalMode() &&
        this.chartSegment.vdom.length &&
        this.chartSegment.report_by != dlp_usage_opts.report_by_protocol)
    {
        title += dlp_usage_texts.vdom + ": " + this.chartSegment.vdom + "<br>";
    }

    if (this.chartSegment.report_by == dlp_usage_opts.report_by_policy)
    {
        title += this.getLegendName() + ": " + this.formatCount(this.count) + "<br>";
    }

    title += dlp_usage_texts.total + ": " + this.formatCount(this.chartSegment.getTotalUsage()) + "<br>";

    el_area.onmouseout = function() { 
        nd();
    };

    el_area.onmouseover = function() {
        overlib(title, HAUTO, VAUTO);
    };

    if (this.chartSegment.drillDown)
    {
        el_area.href = "#";
        el_area.setAttribute("name", this.chartSegment.name);

        el_area.onclick = this.chartSegment.drillDown;
    }

    el_map.appendChild(el_area);   
}

ArchiveChartSegmentValue.prototype.formatCount = function(count)
{
    if (this.chartSegment.sort_by == dlp_usage_opts.sort_by_bytes)
    {
        return ConvertNumberToUnits(count);
    }

    return count + " " + this.chartSegment.sort_by_str;
}

/********************
 * ApplicationChartSegment Class
 * - Overrides DashboardChartSegment
 * - Provides Application Usage specific features.
 ********************/

function ApplicationChartSegment(chartSegment, dashboardChart)
{
    DashboardChartSegment.call(this, chartSegment, dashboardChart);

    var resolved = this.chartSegment.getElementsByTagName("resolved");

    if (resolved && resolved.length)
    {
        this.resolved = xnode2String(resolved);
    }

    var username = this.chartSegment.getElementsByTagName("username");

    if (username && username.length)
    {
        this.username = xnode2String(username);
    }

    var sort_by = this.dashboardChart.xml_response.getElementsByTagName("sort_by")[0];

    this.sort_by = sort_by.getAttribute("id");
    this.sort_by_str = sort_by.firstChild.data; 

    var report_by = this.dashboardChart.xml_response.getElementsByTagName("report_by")[0];

    this.report_by = report_by.getAttribute("id");
    this.report_by_str = report_by.firstChild.data; 

    this.app_id = xnode2String(chartSegment.getElementsByTagName("app_id"));

    this.vdom = xnode2String(chartSegment.getElementsByTagName("vdom"));

    var id = this.dashboardChart.id;
    var vdom = this.vdom;
    var app_id = this.app_id;
    var global_mode = this.dashboardChart.isGlobalMode();

    if (app_id.length)
    {
        this.drillDown = function() {
            // now top app drill down move into app monitor
            app_drilldown(app_id, vdom);
        }
    }
}

ApplicationChartSegment.prototype = new DashboardChartSegment();

ApplicationChartSegment.prototype.constructor = ApplicationChartSegment;

ApplicationChartSegment.prototype.addValue = function( value )
{
    this.values.push( new ApplicationChartSegmentValue( value, this ) );
}

ApplicationChartSegment.prototype.getLabel = function()
{
    // Only display if the username is actually set
    if (this.username)
    {
        return this.username;
    }
    else if (this.resolved)
    {
        return this.resolved;
    }

    return DashboardChartSegment.prototype.getLabel.apply(this);
}


/********************
 * ApplicationChartSegmentValue Class
 * - Overrides DashboardChartSegmentValue
 * - Provides Application Usage specific features.
 ********************/

function ApplicationChartSegmentValue(value, chartSegment)
{
    DashboardChartSegmentValue.call(this, value, chartSegment);
}

ApplicationChartSegmentValue.prototype = new DashboardChartSegmentValue();

ApplicationChartSegmentValue.prototype.constructor = ApplicationChartSegmentValue;

ApplicationChartSegmentValue.prototype.getDetails = function()
{
    var details = "";

    details += this.chartSegment.report_by_str + ": " + this.chartSegment.name;

    if (this.chartSegment.resolved)
    {
        details += " (" + this.chartSegment.resolved + ")";
    }

    details += "<br>";

    if (this.chartSegment.username)
    {
        details += app_usage_texts.username + ": " + this.chartSegment.username + "<br>";
    }

    // Only show VDOM information when in Global mode.
    if (this.chartSegment.dashboardChart.isGlobalMode() &&
        this.chartSegment.vdom.length)
    {
        details += app_usage_texts.vdom + ": " + this.chartSegment.vdom + "<br>";
    }

    details += app_usage_texts.total + ": " + this.formatCount(this.count) + " " + "<br>";

    return details;
}

ApplicationChartSegmentValue.prototype.formatCount = function(count)
{
    if (this.chartSegment.sort_by == app_usage_opts.sort_by_bytes)
    {
        return ConvertNumberToUnits(count);
    }

    return count + " " + this.chartSegment.sort_by_str;
}

ApplicationChartSegmentValue.prototype.addToMap = function(el_map)
{
    var title = this.getDetails();
    var el_area = this.hDocument.createElement("area");

    el_area.shape = this.shape;
    el_area.coords = this.map_coords;


    el_area.onmouseout = function() { 
        nd();
    };

    el_area.onmouseover = function() {
        overlib(title, HAUTO, VAUTO);
    };

    if (this.chartSegment.drillDown)
    {
        el_area.href = "#";

        el_area.onclick = this.chartSegment.drillDown;
    }

    el_map.appendChild(el_area);   
}

ApplicationChartSegmentValue.prototype.addToTable = function(el_table)
{
    var title = this.getDetails();
    var el_row = el_table.insertRow(el_table.rows.length);

    var el = this.hDocument.createElement("td");
    el.innerHTML = (el_table.rows.length - 1);
    el_row.appendChild(el);

    el = this.hDocument.createElement("td");
    el.innerHTML = this.chartSegment.name;

    if (this.chartSegment.resolved)
    {
        el.innerHTML += " (" + this.chartSegment.resolved + ")";
    }

    el.onmouseover = function() {
        overlib(title, HAUTO, VAUTO);
    }

    el.onmouseout = function() {
        nd();
    };

    el_row.appendChild(el);

    if (this.chartSegment.dashboardChart.isGlobalMode())
    {
        el = this.hDocument.createElement("td");
        el.innerHTML = this.chartSegment.vdom;
        el_row.appendChild(el);
    }

    // Add "Usage" column.
    el = this.hDocument.createElement("td");
    el.className = "dashboard-usage";

    div = this.hDocument.createElement("div");
    el_img = this.hDocument.createElement("img");
    el_img.src = "/images/blank.gif";

    div.appendChild(el_img);
    el.appendChild(div);

    sp = this.hDocument.createElement("span");

    sp.innerHTML = this.formatCount(this.count);

    el.appendChild(sp);

    el_row.appendChild(el);

    // Maintain references to some elements for width calculations
    // and volume bar generation.
    this.usageSpan = sp;
    this.usageImage = el_img;
    this.usageCell = el;

    // The drill-down column is only available when viewing "all applications".
    if (this.chartSegment.app_id.length)
    {
        el = this.hDocument.createElement("td");
        var el_link = this.hDocument.createElement("a");
        el_img = this.hDocument.createElement("img");

        el_img.src = "/images/view.gif";

        el_link.href = "#";
        el_link.onclick = this.chartSegment.drillDown;

        el_link.appendChild(el_img);
        el.appendChild(el_link);

        el_row.appendChild(el);
    }
}

ApplicationChartSegmentValue.prototype.adjustUsage = function(vID)
{
    if (this.usageImage)
    {
        this.usageImage.style.width = this.getUsageWidth() + "px";
    }
}

/********************
 * PerIPChartSegment Class
 * - Overrides DashboardChartSegment
 * - Provides Per-IP Bandwidth Usage specific features.
 ********************/

function PerIPChartSegment(chartSegment, dashboardChart)
{
    DashboardChartSegment.call(this, chartSegment, dashboardChart);

    var resolved = this.chartSegment.getElementsByTagName("resolved");

    if (resolved && resolved.length)
    {
        this.resolved = xnode2String(resolved);
    }

    this.vdom = xnode2String(chartSegment.getElementsByTagName("vdom"));

    var vdom = this.vdom;
    var global_mode = this.dashboardChart.isGlobalMode();
}

PerIPChartSegment.prototype = new DashboardChartSegment();

PerIPChartSegment.prototype.constructor = PerIPChartSegment;

PerIPChartSegment.prototype.addValue = function( value )
{
    this.values.push( new PerIPChartSegmentValue( value, this ) );
}

PerIPChartSegment.prototype.getLabel = function()
{
    if (this.resolved)
    {
        return this.resolved;
    }

    return DashboardChartSegment.prototype.getLabel.apply(this);
}


/********************
 * PerIPChartSegmentValue Class
 * - Overrides DashboardChartSegmentValue
 * - Provides Per-IP Bandwidth Usage specific features.
 ********************/

function PerIPChartSegmentValue(value, chartSegment)
{
    DashboardChartSegmentValue.call(this, value, chartSegment);
}

PerIPChartSegmentValue.prototype = new DashboardChartSegmentValue();

PerIPChartSegmentValue.prototype.constructor = PerIPChartSegmentValue;

PerIPChartSegmentValue.prototype.getDetails = function()
{
    var details = "";

    details += per_ip_usage_texts.ip + ": " + this.chartSegment.name;

    if (this.chartSegment.resolved)
    {
        details += " (" + this.chartSegment.resolved + ")";
    }

    details += "<br>";

    // Only show VDOM information when in Global mode.
    if (this.chartSegment.dashboardChart.isGlobalMode() &&
        this.chartSegment.vdom.length)
    {
        details += per_ip_usage_texts.vdom + ": " + this.chartSegment.vdom + "<br>";
    }

    details += per_ip_usage_texts.bw + ": " + this.formatCount(this.count) + "<br>";

    return details;
}

PerIPChartSegmentValue.prototype.addToMap = function(el_map)
{
    var title = this.getDetails();
    var el_area = this.hDocument.createElement("area");

    el_area.shape = this.shape;
    el_area.coords = this.map_coords;

    el_area.onmouseout = function() { 
        nd();
    };

    el_area.onmouseover = function() {
        overlib(title, HAUTO, VAUTO);
    };

    el_map.appendChild(el_area);   
}

PerIPChartSegmentValue.prototype.addToTable = function(el_table)
{
    var title = this.getDetails();
    var el_row = el_table.insertRow(el_table.rows.length);

    var el = this.hDocument.createElement("td");
    el.innerHTML = (el_table.rows.length - 1);
    el_row.appendChild(el);

    el = this.hDocument.createElement("td");
    el.innerHTML = this.chartSegment.name;

	if (this.chartSegment.resolved)
	{
		el.innerHTML += " (" + this.chartSegment.resolved + ")";
	}

    el.onmouseover = function() {
        overlib(title, HAUTO, VAUTO);
    }

    el.onmouseout = function() {
        nd();
    };

    el_row.appendChild(el);

    if (this.chartSegment.dashboardChart.isGlobalMode())
    {
        el = this.hDocument.createElement("td");
        el.innerHTML = this.chartSegment.vdom;
        el_row.appendChild(el);
    }

    // Add "Usage" column.
    el = this.hDocument.createElement("td");
    el.className = "dashboard-usage";

    div = this.hDocument.createElement("div");
    el_img = this.hDocument.createElement("img");
    el_img.src = "/images/blank.gif";

    div.appendChild(el_img);
    el.appendChild(div);

    sp = this.hDocument.createElement("span");

    sp.innerHTML = this.formatCount(this.count);

    el.appendChild(sp);

    el_row.appendChild(el);

    // Maintain references to some elements for width calculations
    // and volume bar generation.
    this.usageSpan = sp;
    this.usageImage = el_img;
    this.usageCell = el;
}

PerIPChartSegmentValue.prototype.formatCount = function(count)
{
    return ConvertBpsToUnits(count);
}

PerIPChartSegmentValue.prototype.adjustUsage = function(vID)
{
    if (this.usageImage)
    {
        this.usageImage.style.width = this.getUsageWidth() + "px";
    }
}

/********************
 * VirusChartSegment Class
 * - Overrides DashboardChartSegment
 * - Provides Top Viruses specific features.
 ********************/

function VirusChartSegment(chartSegment, dashboardChart)
{
    DashboardChartSegment.call(this, chartSegment, dashboardChart);
}

VirusChartSegment.prototype = new DashboardChartSegment();

VirusChartSegment.prototype.constructor = VirusChartSegment;

VirusChartSegment.prototype.addValue = function( value )
{
    this.values.push( new VirusChartSegmentValue( value, this ) );
}

VirusChartSegment.prototype.getLabel = function()
{
    return DashboardChartSegment.prototype.getLabel.apply(this);
}

/********************
 * VirusChartSegmentValue Class
 * - Overrides DashboardChartSegmentValue
 * - Provides Top Viruses specific features.
 ********************/

function VirusChartSegmentValue(value, chartSegment)
{
    DashboardChartSegmentValue.call(this, value, chartSegment);
}

VirusChartSegmentValue.prototype = new DashboardChartSegmentValue();

VirusChartSegmentValue.prototype.constructor = VirusChartSegmentValue;

VirusChartSegmentValue.prototype.addToMap = function(el_map)
{
    var title = "[" + this.count + "] " + this.chartSegment.name;
    var el_area = this.hDocument.createElement("area");

    el_area.shape = this.shape;
    el_area.coords = this.map_coords;

    el_area.onmouseout = function() { 
        nd();
    };

    el_area.onmouseover = function() {
        overlib(title, HAUTO, VAUTO);
    };

    var virus_name = this.chartSegment.name;
    el_area.href = "#";
    el_area.onclick = function() {
        // TODO: Convert to modal dialog. Currently not supported due to
        // propagation bugs + lack of close button for external windows.
        popup("http://www.fortinet.com/ve?vn=" + virus_name, 'link', 750, 520);
        return false;
    }

    el_map.appendChild(el_area);   
}

/********************
 * AttackChartSegment Class
 * - Overrides DashboardChartSegment
 * - Provides Top Attacks specific features.
 ********************/

function AttackChartSegment(chartSegment, dashboardChart)
{
    DashboardChartSegment.call(this, chartSegment, dashboardChart);

    var attack_id = this.chartSegment.getElementsByTagName("attack_id");

    if (attack_id && attack_id.length)
    {
        this.attack_id = xnode2String(attack_id);
    }
}

AttackChartSegment.prototype = new DashboardChartSegment();

AttackChartSegment.prototype.constructor = AttackChartSegment;

AttackChartSegment.prototype.addValue = function( value )
{
    this.values.push( new AttackChartSegmentValue( value, this ) );
}

AttackChartSegment.prototype.getLabel = function()
{
    return DashboardChartSegment.prototype.getLabel.apply(this);
}

/********************
 * AttackChartSegmentValue Class
 * - Overrides DashboardChartSegmentValue
 * - Provides Top Attacks specific features.
 ********************/

function AttackChartSegmentValue(value, chartSegment)
{
    DashboardChartSegmentValue.call(this, value, chartSegment);
}

AttackChartSegmentValue.prototype = new DashboardChartSegmentValue();

AttackChartSegmentValue.prototype.constructor = AttackChartSegmentValue;

AttackChartSegmentValue.prototype.addToMap = function(el_map)
{
    var title = "[" + this.count + "] " + this.chartSegment.name;
    var el_area = this.hDocument.createElement("area");

    el_area.shape = this.shape;
    el_area.coords = this.map_coords;

    el_area.onmouseout = function() { 
        nd();
    };

    el_area.onmouseover = function() {
        overlib(title, HAUTO, VAUTO);
    };

    var attack_id = this.chartSegment.attack_id;
    if (attack_id)
    {
        el_area.href = "#";
        el_area.onclick = function() {
            popup("http://www.fortinet.com/ids/VID" + attack_id, 'link', 750, 520);
            return false;
        }
    }

    el_map.appendChild(el_area);   
}

/********************
 * ProtocolUsageChartSegment Class
 * - Overrides DashboardChartSegment
 * - Provides protocol usage specific features.
 ********************/

function ProtocolUsageChartSegment(chartSegment, dashboardChart)
{
    DashboardChartSegment.call(this, chartSegment, dashboardChart);
}

ProtocolUsageChartSegment.prototype = new DashboardChartSegment();

ProtocolUsageChartSegment.prototype.constructor = ProtocolUsageChartSegment;

ProtocolUsageChartSegment.prototype.addValue = function( value )
{
    this.values.push( new ProtocolUsageChartSegmentValue( value, this ) );
}


/********************
 * ProtocolUsageChartSegmentValue Class
 * - Overrides DashboardChartSegmentValue
 * - Provides top-sessions specific features.
 ********************/

function ProtocolUsageChartSegmentValue(value, chartSegment)
{
    DashboardChartSegmentValue.call(this, value, chartSegment);
}

ProtocolUsageChartSegmentValue.prototype = new DashboardChartSegmentValue();

ProtocolUsageChartSegmentValue.prototype.constructor = ProtocolUsageChartSegmentValue;

ProtocolUsageChartSegmentValue.prototype.addToMap = function(el_map)
{
    var el_area = this.hDocument.createElement("area");

    el_area.shape = this.shape;
    el_area.coords = this.map_coords;

    var title = this.chartSegment.name + ": " + ConvertNumberToUnits(this.count);

    el_area.onmouseout = function() { 
        nd();
    };

    el_area.onmouseover = function() {
        overlib(title, HAUTO, VAUTO);
    };

    el_map.appendChild(el_area);   
}


/********************
 * DashboardChartLegend Class - Each Legend on a displayed chart
 * is represented by a ChartLegend instance. The legends are primarily
 * used when displaying stacked bar charts.
 ********************/

function DashboardChartLegend(obj)
{
    this.name = obj.firstChild.data;
}

// DashboardChartLegend.toURLString - Convert a ChartLegend object into
// a URL suitable for passing to the FortiGate.
DashboardChartLegend.prototype.toURLString = function()
{
    var URLString = "s=" + this.name + "&";

    return URLString;
}

DashboardChartLegend.prototype.toString = function()
{
    return this.name;
}


