var FilterDialog = (function() {
	
	var policy = '';
	var host = '';
	var url = '';
	var case_sensitive = false;
	var use_time = false;

	var fromyear = 0;
	var frommon = 0;
	var fromday = 0;
	var fromhour = 0;
	var frommin = 0;
	var fromsec = 0;

	var toyear = 0;
	var tomon = 0;
	var today = 0;
	var tohour = 0;
	var tomin = 0;
	var tosec = 0;

	var firstShow = true;
	var error_time_range = l_qed_strtbl.error_time_range;
	var time_too_large = l_qed_strtbl.time_too_large;
	var time_too_large_new_range = l_qed_strtbl.time_too_large_new_range;

	function closeFilter()
	{
		$j('.filter_panel').dialog('close');
	}

	function showFilter(){

		var filterDialog = $j('.filter_panel').dialog({
			modal: true,
		    	width: 560,
		    	autoOpen: false,
		    	dialogClass: "no-close"
		});

		var buttons = [
			{
				text: l_qed_strtbl.reset,
    				click: function() 
				{
					ResetFilter();
				}
			},
    			{
				text: l_qed_strtbl.ok,
    				click: function()
				{
					DoFilter();
				}
			}
		];

		if(!firstShow)
		{
			buttons.push({
				text: l_qed_strtbl.cancel,
				click: function(){
					LoadLastConfig();
					closeFilter();
				}
			});
		}

		filterDialog.dialog('option', 'buttons', buttons);
		filterDialog.dialog('open');

		if(firstShow)
		{
			var date = new Date();

			$j('#filter_f_date').datepicker('setDate', date);
			$j('#filter_t_date').datepicker('setDate', date);

			$j('#filter_f_hour')[0].selectedIndex = date.getHours();
			$j('#filter_f_min')[0].selectedIndex = date.getMinutes();
			$j('#filter_f_sec')[0].selectedIndex = date.getSeconds();
			$j('#filter_t_hour')[0].selectedIndex = date.getHours();
			$j('#filter_t_min')[0].selectedIndex = date.getMinutes();
			$j('#filter_t_sec')[0].selectedIndex = date.getSeconds();
		}

		changeStatus();
		firstShow = false;
	}

	function ResetFilter()
	{
		$j('#filter_policy')[0].value = '';
		$j('#filter_host')[0].value = '';
		$j('#filter_url')[0].value = '';
		$j('#filter_case')[0].checked = false;
		$j('#filter_use_time')[0].checked = false;

		changeStatus();

		var date = new Date();

		$j('#filter_f_date').datepicker('setDate', date);
		$j('#filter_t_date').datepicker('setDate', date);

		$j('#filter_f_hour')[0].selectedIndex = date.getHours();
		$j('#filter_f_min')[0].selectedIndex = date.getMinutes();
		$j('#filter_f_sec')[0].selectedIndex = date.getSeconds();
		$j('#filter_t_hour')[0].selectedIndex = date.getHours();
		$j('#filter_t_min')[0].selectedIndex = date.getMinutes();
		$j('#filter_t_sec')[0].selectedIndex = date.getSeconds();
	}

	function SaveLastConfig()
	{
		policy = $j('#filter_policy')[0].value;
		host = $j('#filter_host')[0].value;
		url = $j('#filter_url')[0].value;
		case_sensitive = $j('#filter_case')[0].checked;
		use_time = $j('#filter_use_time')[0].checked;

		var curDate = $j('#filter_f_date').datepicker('getDate');
		fromyear = curDate.getFullYear();
		frommon = curDate.getMonth();
		fromday = curDate.getDate();

		curDate = $j('#filter_t_date').datepicker('getDate');
		toyear = curDate.getFullYear();
		tomon = curDate.getMonth();
		today = curDate.getDate();

		fromhour = $j('#filter_f_hour')[0].selectedIndex;
		frommin = $j('#filter_f_min')[0].selectedIndex;
		fromsec = $j('#filter_f_sec')[0].selectedIndex;

		tohour = $j('#filter_t_hour')[0].selectedIndex;
		tomin = $j('#filter_t_min')[0].selectedIndex;
		tosec = $j('#filter_t_sec')[0].selectedIndex;
	}

	function DoFilter()
	{
		if(!CheckTimeRange())
			return;

		if(!$j('#filter_use_time')[0].checked)
		{
			changeData();
			SaveLastConfig();
			closeFilter();
		}
		else
		{
			if(isConfigChanged())
			{
				$j.ajax({
					'url': '/data_analytics/time_check?'+ getFilterParam(),
					'cache': false,
					'dataType': 'json',
					'error': function(){
						closeFilter();
					},
					'success': function(data){
						var status = data.status;
						if(status == 'ok')
						{
							var valid = data.valid;
							if(valid == 0)
							{
								changeData();
								SaveLastConfig();
								closeFilter();
							}
							else if(valid == 1)
							{
								$j('#filter_f_hour')[0].selectedIndex = data.fromhour;
								$j('#filter_t_hour')[0].selectedIndex = data.tohour;
								$j('#filter_f_min')[0].selectedIndex = data.frommin;
								$j('#filter_t_min')[0].selectedIndex = data.tomin;
								$j('#filter_f_sec')[0].selectedIndex = data.fromsec;
								$j('#filter_t_sec')[0].selectedIndex = data.tosec;

								var date = new Date();
								date.setFullYear(data.fromyear);
								date.setMonth(data.frommon-1);
								date.setDate(data.fromday);
								$j('#filter_f_date').datepicker('setDate', date);

								date.setFullYear(data.toyear);
								date.setMonth(data.tomon-1);
								date.setDate(data.today);
								$j('#filter_t_date').datepicker('setDate', date);

								alert(time_too_large_new_range);
							}
						}
						else if(status == 'error')
						{
							alert(data.error);
							closeFilter();
						}
					}
				});
			}
			else
			{
				changeData();
				SaveLastConfig();
				closeFilter();
			}
		}
	}

	function LoadLastConfig()
	{
		$j('#filter_policy')[0].value = policy;
		$j('#filter_host')[0].value = host;
		$j('#filter_url')[0].value = url;
		$j('#filter_case')[0].checked = case_sensitive;
		$j('#filter_use_time')[0].checked = use_time;

		changeStatus();

		var date = new Date();
		date.setFullYear(fromyear);
		date.setMonth(frommon);
		date.setDate(fromday);
		$j('#filter_f_date').datepicker('setDate', date);

		date.setFullYear(toyear);
		date.setMonth(tomon);
		date.setDate(today);
		$j('#filter_t_date').datepicker('setDate', date);

		$j('#filter_f_hour')[0].selectedIndex = fromhour;
		$j('#filter_f_min')[0].selectedIndex = frommin;
		$j('#filter_f_sec')[0].selectedIndex = fromsec;

		$j('#filter_t_hour')[0].selectedIndex = tohour;
		$j('#filter_t_min')[0].selectedIndex = tomin;
		$j('#filter_t_sec')[0].selectedIndex = tosec;
	}

	function isConfigChanged()
	{
		if(policy != $j('#filter_policy')[0].value ||
		host != $j('#filter_host')[0].value ||
		url != $j('#filter_url')[0].value ||
		case_sensitive != $j('#filter_case')[0].checked
		)
			return true;

		if(use_time != $j('#filter_use_time')[0].checked)
			return true;
		else
		{
			if(use_time)
			{
				if($j('#filter_f_hour')[0].selectedIndex != fromhour||
				$j('#filter_f_min')[0].selectedIndex != frommin||
				$j('#filter_f_sec')[0].selectedIndex != fromsec
					)
					return true;

				if($j('#filter_t_hour')[0].selectedIndex != tohour||
				$j('#filter_t_min')[0].selectedIndex != tomin||
				$j('#filter_t_sec')[0].selectedIndex != tosec 
				  )
					return true;

				var fromDate = $j('#filter_f_date').datepicker('getDate');
				if(fromyear != fromDate.getFullYear() ||
				frommon != fromDate.getMonth() ||
				fromday != fromDate.getDate()
				)
					return true;

				var toDate = $j('#filter_t_date').datepicker('getDate');
				if(toyear != toDate.getFullYear() ||
				tomon != toDate.getMonth() ||
				today != toDate.getDate()
				  )
					return true;
			}
		}

		return false;
	}

	function CheckTimeRange()
	{
		if(!$j('#filter_use_time')[0].checked)
			return true;

		var fromdate = $j('#filter_f_date').datepicker('getDate');
		var todate = $j('#filter_t_date').datepicker('getDate');

		if(fromdate.getTime() > todate.getTime())
		{
			alert(error_time_range);
			return false;
		}
		else if(fromdate.getTime() == todate.getTime())
		{
			if($j('#filter_f_hour')[0].selectedIndex > $j('#filter_t_hour')[0].selectedIndex)
			{
				alert(error_time_range);
				return false;
			}
			else if($j('#filter_f_hour')[0].selectedIndex == $j('#filter_t_hour')[0].selectedIndex)
			{
				if($j('#filter_f_min')[0].selectedIndex > $j('#filter_t_min')[0].selectedIndex)
				{
					alert(error_time_range);
					return false;
				}
				else if($j('#filter_f_min')[0].selectedIndex == $j('#filter_t_min')[0].selectedIndex)
				{
					if($j('#filter_f_sec')[0].selectedIndex > $j('#filter_t_sec')[0].selectedIndex)
					{
						alert(error_time_range);
						return false;
					}
				}
			}
		}

		if( (todate.getTime() - fromdate.getTime()) > (365 * 24 * 60 * 60 * 1000 * 2))
		{
			alert(time_too_large);
			return false;
		}

		return true;
	}

	function GetTimeRange()
	{
		var range = 0;

		if($j('#filter_use_time')[0].checked)
		{
			var diff_day = $j('#filter_t_date').datepicker('getDate').getTime() - $j('#filter_f_date').datepicker('getDate').getTime();

			var diff_hour = ($j('#filter_t_hour')[0].selectedIndex - $j('#filter_f_hour')[0].selectedIndex) * 60 * 60 * 1000;
			var diff_min = ($j('#filter_t_min')[0].selectedIndex - $j('#filter_f_min')[0].selectedIndex) * 60 * 1000;
			var diff_sec = ($j('#filter_t_sec')[0].selectedIndex - $j('#filter_f_sec')[0].selectedIndex) * 1000;

			range = (diff_day + diff_hour + diff_min + diff_sec) / 1000;
		}
		else
		{
			range =  30 * 24 * 60 * 60;
		}

		return range;
	}

	return {
		'GetTimeRange': GetTimeRange,
		'showFilter': showFilter
	};

})(jQuery);

function changeStatus()
{
	var used = $j('#filter_use_time')[0].checked;

	$j('#filter_f_date')[0].disabled = !used;
	$j('#filter_t_date')[0].disabled = !used;
	$j('#filter_f_hour')[0].disabled = !used;
	$j('#filter_f_min')[0].disabled = !used;
	$j('#filter_f_sec')[0].disabled = !used;
	$j('#filter_t_hour')[0].disabled = !used;
	$j('#filter_t_min')[0].disabled = !used;
	$j('#filter_t_sec')[0].disabled = !used;
}
