var attackPanel = (function($) {
	var all_zero = false;
	var pointFormat = '<span style="color:{point.color};">{point.name}</span>: <b>{point.percentage:.2f}%</b> ({point.y:.0f})';
	var zeroFormat = '<span style="color:{point.color};">{point.name}</span>: <b>0.00%</b> ({point.y:.0f})';

	function processData(data) {
		var empty = true;
		data.forEach(function(e){
			e.name = e.type;
			e.y = e.count;
			if(e.count != 0){ empty = false; }
		});

		if(empty)
		{
			all_zero = true;
			data.forEach(function(e){ e.y = 0.0001; });
		} else {
			all_zero = false;
		}

		return data;
	}

	function changeData() {
		var uri = '/data_analytics/web/attack?type=0&code=0&' + getFilterParam();
		var data = data_util.get_cache_data(uri);

		if(data  === null || !data.length)
		{
			loading_dlg.show();
			$.ajax({
				'url': uri,
				'dataType': 'json',
				'success': function(response)
				{
					loading_dlg.hide();
					data = response.data;
					data_util.put_cache_data(uri, data);
					drawChart(data);

				},
				'error': function(){
					loading_dlg.hide();
				},
				'cache': false
			});
			
		} else {
			drawChart(data);
		}
	}

	function showSubchart(code) {
		var uri = '/data_analytics/web/attack?type=1&code=' + code + '&' + getFilterParam();
		var data = data_util.get_cache_data(uri);

		if(data  === null || !data.length)
		{
			loading_dlg.show();
			$.ajax({
				'url': uri,
				'dataType': 'json',
				'success': function(response)
				{
					loading_dlg.hide();
					data = response.data;
					data_util.put_cache_data(uri, data);
					drawSubchart(data);

				},
				'error': function(){
					loading_dlg.hide();
				},
				'cache': false
			});
			
		} else {
			drawSubchart(data);
		}
	}

	function drawChart(data) {
		data = processData(data);
		$('#attack_chart').highcharts({
			credits:{enabled:false},
			chart: {type: 'pie'},
			title: {
				text: null
			},
			plotOptions: {
				series: {
					dataLabels: {
						enabled: false,
						//format: '<span style="color:{point.color};max-width:100px;">{point.name}</span>: {point.percentage:.1f}% ({point.y:.0f})<br/>'
					}
				},
				pie: {
					size: '75%'
					/*,
					point: {
	                    events: {
	                        mouseOver: function(evt){
	                            this.slice();
	                        }
	                    }
	                }*/
				}
			},

			tooltip: {
				headerFormat: '',
				pointFormat: (all_zero?zeroFormat:pointFormat),
				style: {'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 'fontSize': '15px'}
			},
			colors: ['#E8A02B','#FFE326','#BDEA2D','#31BD4C','#32A2A6','#2A60A6','#434348','#7429A6','#A63077','#BD1F08','#A6602D'],
			series: [{
				name: 'Count',
				colorByPoint: true,
				point: {
					events: {
						click: function () {showSubchart(this.id)}
					}
				},
				data: data
			}]
		});
	}

	function drawSubchart(data) {
		data = processData(data);
		$('#attack_chart').highcharts({
			credits:{enabled:false},
			chart: {type: 'pie'},
			title: {
				text: null
			},
			plotOptions: {
				series: {
					dataLabels: {
						enabled: false,
						//format: '<span style="color:{point.color};max-width:100px;">{point.name}</span>: {point.percentage:.1f}% ({point.y:.0f})<br/>'
					}
				},
				pie: {
					size: '75%'
					/*,
					point: {
	                    events: {
	                        mouseOver: function(evt){
	                            this.slice();
	                        }
	                    }
	                }*/
				}
			},

			tooltip: {
				headerFormat: '',
				pointFormat: (all_zero?zeroFormat:pointFormat),
				style: {'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 'fontSize': '15px'}
			},
			series: [{
				name: 'Count',
				colorByPoint: true,
				point: {
					events: {
						click: function () {changeData()}
					}
				},
				data: data
			}]
		});
	}

	return {changeData: changeData};

})(jQuery);
