var rootLayout, mapLayout, map_southLayout, webLayout, web_eastLayout;

var curCode = 0;
var curType = 1;
var currentCountry = '';
var currentMapCountry = '';
var currentStates = '';
var currentCity = '';
var isMapSub = false;
var mapToList = false;
var com_util = {
	'TYPE_HIT': 1,
	'TYPE_FLOW': 2,
	'TYPE_ATTACK': 3
};

var layoutSettingRoot = {
	name: "RootLayout",
	maskPanesEarly: true,
	defaults: {
		size: "auto",
		resizerTip: "",
		minSize: 0
	},
	north: {
		paneSelector: ".banner",
		resizable: false,
		slidable: false,
		closable: false,
		spacing_open: 0
	},
	center: {
		paneSelector: ".content",
		closable: false,
//		onresize: "centerLayout.resizeAll"
	}
};

var layoutSettingMap = {
	maskPanesEarly: true,
	south: {
		paneSelector: ".map_south",
		resizable: true,
		slidable: false,
		togglerLength_open: 0,
		togglerLength_closed: 0,
		maskContents: false,
		size: '40%',
		closable: false
	},
	center: {
		paneSelector: ".map_center",
		resizable: true,
		maskContents: false,
		maskObjects: false,
		size: '60%',
		closable: false,
	}
};

var layoutSettingMapsouth = {
	maskPanesEarly: true,
	west: {
		paneSelector: ".map_attack",
		resizeable: true,
		closable: true,
		slidable: false,
		maskContents: false,
		//onresize_end: changeData
	},
	center: {
		paneSelector: ".map_top10",
		resizeable: true,
		maskContents: false,
		maskObjects: false,
		closable: false,
		onresize_end: changeData
	}
};

var layoutSettingWeb = {
	maskPanesEarly: true,
	east: {
		paneSelector: ".web_east",
		resizable: true,
		slidable: false,
		togglerLength_open: 0,
		togglerLength_closed: 0,
		maskContents: false,
		size: '50%',
		closable: false,
		onresize_end: changeData
	},
	center: {
		paneSelector: ".web_center",
		maskContents: false,
		maskObjects: false,
		closable: false,
		size: '50%'
	}
};

var layoutSettingWebEast = {
	maskPanesEarly: true,
	north: {
		paneSelector: ".web_type",
		resizeable: true,
		slidable: false,
		maskContents: false,
		closable: false,
		size: '50%'
	},
	center: {
		paneSelector: ".web_trend",
		maskContents: false,
		maskObjects: false,
		closable: false,
		size: '50%'
	}
};

function RefreshData()
{
	data_util.invalid_data();
	changeData();
}

function changeFilterType()
{
	var filterPre = document.getElementById("filter_pre");
	var filterCustom = document.getElementById("filter_custom");

	if(filterPre.checked == true)
	{
		$j("#filter_time_option").css('display', '');
		$j("#filter_custom_button").css('display', 'none');
		changeData();
	}
	else if(filterCustom.checked == true)
	{
		$j("#filter_time_option").css('display', 'none');
		$j("#filter_custom_button").css('display', '');
		FilterDialog.showFilter();
	}
}

function changeMapType()
{
	if($j('#map_type_hit').is(':checked'))
	{
		curType = 1;
	}
	else if($j('#map_type_flow').is(':checked'))
	{
		curType = 2;
	}
	else if($j('#map_type_attack').is(':checked'))
	{
		curType = 3;
	}

	if(curType == 3)
	{
		$j('#map_attack').css('display', '');
		$j('#map_attack').css('width', '30%');
		$j('#map_top10').css('width', '70%');
	}
	else
	{
		$j('#map_attack').css('display', 'none');
		$j('#map_attack').css('width', '0%');
		$j('#map_top10').css('width', '100%');
	}

	rootLayout.resizeAll();	
	changeTopData();
	//listPanel.changeData(curCode);
}

function changePageType()
{
	if($j("#show_world").is(":checked"))
	{
		$j(".map_content").show();
		$j(".web_content").hide();
		$j(".filter_right").show();
	}
	else if($j("#show_web").is(":checked"))
	{
		$j(".map_content").hide();
		$j(".web_content").show();
		$j(".filter_right").hide();
	}

	changeData();
}

function mapToggle()
{
	var radio_map = document.getElementById("map_mode");
	var radio_list = document.getElementById("list_mode");
	if(radio_map.checked == true)
	{
		 $j("div.map_map").css('display', '');
		 $j("div.map_list").css('display', 'none');
	}
	else if(radio_list.checked == true)
	{
		if($j("div.map_list").css('display') != 'none')
			currentMapCountry = '';

		 $j("div.map_map").css('display', 'none');
		 $j("div.map_list").css('display', '');
	}

	changeTopData();
}

$j(document).ready(function() {
	rootLayout = $j("body").layout(layoutSettingRoot);
	mapLayout = $j("div.map_content").layout(layoutSettingMap);
	map_southLayout = $j("div.map_south").layout(layoutSettingMapsouth);
	webLayout = $j("div.web_content").layout(layoutSettingWeb);
	web_eastLayout = $j("div.web_east").layout(layoutSettingWebEast);
	
	loading_dlg.init();
	
	changePageType();
	changeMapType();

	$j('#filter_use_time').on('click', function(){
		changeStatus();
	});
	$j('#time_select').on('change', function(){
		changeData();
	});

	$j('#trend_type').on('change', function(){
		timePanel.changeData();
	});
	$j('#trend_interval').on('change', function(){
		timePanel.changeData();
	});
	$j('#trend_next_btn').on('click', function(){
		timePanel.nextClick();
	});
	$j('#trend_pre_btn').on('click', function(){
		timePanel.preClick();
	});

	$j('#filter_f_date').datepicker();
	$j('#filter_t_date').datepicker();

	$j("#type_select").change(function(){
		typePanel.changeData();
	});
	$j("#category_select").change(function(){
		typePanel.changeData();
	});	

	$j('#map_attack').css('display', 'none');
	$j('#map_attack').css('width', '0%');
	$j('#map_top10').css('width', '100%');

});

function changeTopData()
{
	//if(curType == 3) mapAttackPanel.changeData(0);
	if($j('#map_mode').is(':checked'))
	{
		mapPanel.changeData(curCode);
		if($j('#map_list').is(':visible'))
		{
			statePanel.changeData(curCode);
		}
	}
	else if($j('#list_mode').is(':checked'))
	{
		listPanel.changeData(curCode);
	}
}

function changeData()
{
	if($j("#show_world").is(":checked"))
	{
		changeTopData();
		//listPanel.changeData(curCode);
	}
	else if($j("#show_web").is(":checked"))
	{
		timePanel.changeData();
		attackPanel.changeData();
		typePanel.changeData();
	}
}

function getFilterParam()
{
	var res = '';

	var filter_type = getRadioValue(document.getElementsByName('filter_type'));

	res += 'filter_type=' + filter_type;

	if(parseInt(filter_type) == 2)
	{
		var interval = $j('#time_select')[0].value;
		res += '&filter_interval=' + interval;
	}
	else if(parseInt(filter_type) == 1)
	{
		res += '&policy=' + encodeURIComponent($j('#filter_policy')[0].value);
		res += '&host=' + encodeURIComponent($j('#filter_host')[0].value);
		res += '&url=' + encodeURIComponent($j('#filter_url')[0].value);
		var str_case = $j('#filter_case')[0].checked ? '1' : '0';
		res += '&case_sensitive=' + str_case;

		if($j('#filter_use_time')[0].checked)
		{
			res += '&time_filter=1';
			res += '&fromhour=' + $j('#filter_f_hour')[0].selectedIndex;
			res += '&tohour=' + $j('#filter_t_hour')[0].selectedIndex;
			res += '&frommin=' + $j('#filter_f_min')[0].selectedIndex;
			res += '&tomin=' + $j('#filter_t_min')[0].selectedIndex;
			res += '&fromsec=' + $j('#filter_f_sec')[0].selectedIndex;
			res += '&tosec=' + $j('#filter_t_sec')[0].selectedIndex;

			var date = $j('#filter_f_date').datepicker('getDate');
			res += '&fromyear=' + date.getFullYear();
			res += '&frommon=' + parseInt(date.getMonth()+1).toString();
			res += '&fromday=' + date.getDate();

			date = $j('#filter_t_date').datepicker('getDate');
			res += '&toyear=' + date.getFullYear();
			res += '&tomon=' + parseInt(date.getMonth()+1).toString();
			res += '&today=' + date.getDate();
		}
	}

	return res;
}

function getTypeParam(code)
{
	var res = '';

	res += '&type=' + curType;

	if($j('#map_mode').is(':checked'))
		res += "&country=" + currentMapCountry;
	else if($j('#list_mode').is(':checked'))
		res += "&country=" + currentCountry;

	res += "&state=" + currentStates;
	res += "&city=" + currentCity;
	res += "&attack_code=" + code;
	return res;
}

function getPercentIcon(percent, country)
{

	var levl = "";
	if(country == 'Total')  return levl;

	if(percent >= 0 && percent <= 3)
		levl = "level1";
	else if(percent > 3 && percent <= 6)
		levl = "level2";
	else if(percent > 6 && percent <= 9)
		levl = "level3";
	else if(percent > 9 && percent <= 12)
		levl = "level4";
	else if(percent > 12 && percent <= 100)
		levl = "level5";
	else
		levl = "";

	return levl;
}

function add_to_geo(ths, e)
{
	e.stopPropagation();	
	geoPanel.open(ths.id);
}

