var data_util = (function() {
	'use strict';
	var cache = [];

	function get_hash(str) {
		var hash = 0, i, chr, len;
		if (str.length === 0) return hash;
		for (i = 0, len = str.length; i < len; i++) {
			chr   = str.charCodeAt(i);
			hash  = ((hash << 5) - hash) + chr;
			hash |= 0; // Convert to 32bit integer
		}
		return hash;
	}

	function get_cache_data(uri) {
		var hash = 0;
		var data = null;
		hash = get_hash(uri);

		if(hash && (hash in cache))
			data = cache[hash];
		
		return data;
	}

	function put_cache_data(uri, data) {
		var hash = 0;
		hash = get_hash(uri);

		cache[hash] = data;
	}

	function invalid_data() {
		cache = [];
	}

	return {
		'get_cache_data': get_cache_data,
		'put_cache_data': put_cache_data,
		'invalid_data': invalid_data
	};
})();