var geoPanel = (function($){
	'use strict';

	var time = 1 + Math.round(Math.random() * 100000);
	var addCountry = '';
	var noGeoPolicy = false;
	
	function popAlertMsg(msg)
	{
		alert(msg);
	}
	function sendGeoRequest()
	{
		if(noGeoPolicy)
		{
			closeGeo();
			return;
		}
		var country = addCountry;
		var policy = $("select#geo_block_policy")[0].value;
		var url = "/waf/geo_block_list/json_add";
		
		if(policy == null || policy == "")
		{
			popAlertMsg(l_qed_strtbl.select);
			return;
		}

		$.ajax({
		    'url': url,
		    'type': 'GET',
		    'data': {table_key: encodeURIComponent(policy), time: (time++).toString(), country: encodeURIComponent(country)},
		    'success': function(result){
			    if(result.status == "error")
			    {
				    popAlertMsg(result.error);
			    }
			    closeGeo();
		    },
		    'error': function(){
			    closeGeo();
		    }
		});
	}
	function parsePolicyList()
	{
		var policyHTML = "";

		var createElement = function(data){

			if(data.length == 0)
			{
				noGeoPolicy = true;
				$("div#tip_container").css('display', '');
				$("div#policy_container").css('display', 'none');
			}
			else
			{
				var   select = document.createElement("select");
				var   opt = document.createElement("option");
				var   label = document.createElement("label");

				label.innerHTML = l_qed_strtbl.geo_block_list;
				select.setAttribute("name", "geo_block_policy");
				select.setAttribute("id", "geo_block_policy");
				opt.setAttribute("value", "");
				opt.innerHTML = l_qed_strtbl.select;
				select.appendChild(opt);

				$.each(data, function(index, obj){
					opt = "";
					opt = document.createElement("option");
					opt.setAttribute("value", obj.name);
					opt.innerHTML = obj.name;
					select.appendChild(opt);
				});
				
				$("div#policy_container").empty().append(label, select).css('display', '');
				
				$("div#tip_container").css('display', 'none');
			}
		};

		$j.getJSON('/cli-direct-action', {table_gid:l_qed_strtbl.g_cmdb_geo_table_id,vdom:l_qed_strtbl.vdom, _: (time++).toString()},
				function(results) {
					if(results.status == 1) {
						createElement(results.datas);
					} else {
						var data = [];
						createElement(data);
						popAlertMsg(l_qed_strtbl.geo_err_msg)
					}
				});
	}
	function InitGeo(country)
	{
		addCountry = country;
		
		parsePolicyList();
		
		$("#geo_panel").dialog({
			modal: true,
		    	width: 400,
		    	autoOpen: false,
		    	dialogClass: "no-close",
			buttons:[{
				   text: l_qed_strtbl.ok,
				   click: sendGeoRequest 
				},
			        {
				   text: l_qed_strtbl.cancel,
				   click: function(){
					$("#geo_panel").dialog('close');
				   }
			   	}]
		});
		$("#geo_panel").dialog('open');
	}

	function closeGeo()
	{
		$("#geo_panel").dialog('close');
	}
	
	return{
		'open': InitGeo,
		'close': closeGeo
	}
})(jQuery);
