var listPanel = (function($){
	'use strict';

	var source;
	var flowLabel = l_qed_strtbl.count;

	function changeHeaderText()
	{
		var type = curType;
		
		if(type == com_util.TYPE_FLOW)
		{
			flowLabel = l_qed_strtbl.flow + '(KB)';
		}
		else
		{
			flowLabel = l_qed_strtbl.count;
		}
	}

	function perIcon_format_fn(td, col, row_data)
	{
		var percent = parseInt(row_data['percent']);
		var country = row_data['country'];
		var level = getPercentIcon(percent, country);

		if(level == "")
			return '';
		else 
			return '<image src="/images/'+ level + '.png">';
	}

	function add_to_geo_format_fn(td, col, row_data)
	{
		var country = row_data['country'];
		
		if(country == 'Total' || country == 'Internal IPs' || country == 'Unknown Locations' || country == '--' || country == 'Undetermined City/State')
		{
			return '';
		}
		else
		{
			return '<input type="button" class="geo_button" id="' + country + '" value="' + l_qed_strtbl.add + '" onclick="add_to_geo(this, event);">';
		}
	}

	function content_loaded(qlist)
	{
		$('.qlist-container .qlist').css('width', '99.5%');

		var data = source;
		if(data === null || data.length <= 0)
			return;

		$("tr.qlist_row").each(function(index){
			
			var key = data[index].key;
			var per = data[index].percent;

			if(qlist.prefix === 'da_country_list')
			{
				if(key == "Internal IPs" || key == "Unknown Locations" || (key == "Total" && per == 100))
				{
					return;	
				}
				else
				{
					var clickHandler = function(){
						clickCountry(key);
					};
					this.addEventListener('click', clickHandler);
				}
			}
		});
	}

	function genCountryList(data)
	{
		source = data;
		changeHeaderText();
		var qlist_settings = {
			'prefix': 'da_country_list',
			'source': source,
			'row_attr': [
			        {name: 'key', selector: 'key'}
			],
			'columns': [
				{'selector': 'country', 'lang_key': l_qed_strtbl.country},
	        		{'selector': 'count', 'lang_key': flowLabel},
	        		{'selector': 'percent', 'lang_key': l_qed_strtbl.percent},
				{'selector': 'add_to_geo', 'lang_key': l_qed_strtbl.add_to_geo},
				{'selector': 'perIcon', 'lang_key': ' '}
			],
			'options':{
				'ref_column': false,
				'sorting': false,
				'hide_default_buttons': true,
				'hide_menu': true,
				'fixed_header': false
			},
			'format_fn': {
				'add_to_geo': add_to_geo_format_fn,
				'perIcon': perIcon_format_fn
			},
			'callbacks': {
				'load': content_loaded
			}
		};
		var $container = $("#map_list");
		$container.qlist(qlist_settings);
	}
	
	function changeData(code)
	{
		var type = curType;
		//curCode = code;

		var url = "/data_analytics/map/data_view?" + getFilterParam() + getTypeParam(code);
		var data = data_util.get_cache_data(url);

		$("div#btn_back").css('display', 'none');

		if(data == null || data.length == 0)
		{
			loading_dlg.show();
			$j.ajax({
				'url': url,
				'cache': false,
				'dataType': 'json',
				'error': function(){
					loading_dlg.hide();
				},
				'success': function(response)
				{
					loading_dlg.hide();
					resultHandler(response);
					topPanel.changeData(code);

				}
			});
		}
		else
		{
			if(currentCountry === '')
			{
				genCountryList(data);
			}
			else
			{
				statePanel.changeData(code);
			}
			if(type === com_util.TYPE_ATTACK)
				mapAttackPanel.changeData(code);
			topPanel.changeData(code);
		}
	}
	function resultHandler(response){
		
		var type = curType;
		var code = curCode;
		var url = "/data_analytics/map/data_view?" + getFilterParam() + getTypeParam(code);
		var data = data_util.get_cache_data(url);
		var data = [];
		var hitData = [];
		var flowData = [];
		
		if(response.status == 'ok')	
		{
			if(type == com_util.TYPE_ATTACK)
			{
				data = response.data;
				data_util.put_cache_data(url, data);
				if(currentCountry === '')
				{
					mapAttackPanel.changeData(code);
					genCountryList(data);
				}
				else
				{
					statePanel.changeData(code);
				}

			}
			else
			{
				hitData = response.hitdata;
				flowData = response.flowdata;
				if(type == com_util.TYPE_HIT)
				{
					data_util.put_cache_data(url, hitData);
					if(currentCountry === '')
					{
						genCountryList(hitData);
					}
					else
					{
						statePanel.changeData(code);
					}
				}
				else if(type == com_util.TYPE_FLOW)
				{
					data_util.put_cache_data(url, flowData);
					if(currentCountry === '')
					{
						genCountryList(flowData);
					}
					else
					{
						statePanel.changeData(code);
					}
				}
			}
		}
		else if(response.status == 'error')
		{
			alert(response.error);
		}
		
	} 
	
	function clickCountry(countryKey)
	{
		currentCountry = countryKey;
		statePanel.changeData(curCode);
	}

	return {
		'changeData': changeData,
		'clickCountry': clickCountry
	};
})(jQuery);
