var mapAttackPanel = (function($) {
	var all_zero = false;
	var pointFormat = '<span style="color:{point.color};">{point.name}</span>: <b>{point.percentage:.2f}%</b> ({point.y:.0f})';
	var zeroFormat = '<span style="color:{point.color};">{point.name}</span>: <b>0.00%</b> ({point.y:.0f})';


	function processData(data) {
		var empty = true;
		data.forEach(function(e){
			e.name = e.type;
			e.y = e.count;
			if(e.count != 0){ empty = false; }
		});

		if(empty)
		{
			all_zero = true;
			data.forEach(function(e){ e.y = 0.0001; });
		} else {
			all_zero = false;
		}

		return data;
	}

	function changeData(code) {
		var uri = '/data_analytics/map/attack?' + getFilterParam() + getTypeParam(code);
		var data = data_util.get_cache_data(uri);

		if(code === 0){
			isMapSub = true;
		}else{
			isMapSub = false;
		}

		if(data  === null || !data.length)
		{
			loading_dlg.show();
			$.ajax({
				'url': uri,
				'dataType': 'json',
				'success': function(response)
				{
					loading_dlg.hide();
					data = response.data;
					data_util.put_cache_data(uri, data);
					drawChart(data);

				},
				'error': function(){
					loading_dlg.hide();
				},
				'cache': true
			});
			
		} else {
			drawChart(data);
		}
	}
	
	function drawChart(data) {
		data = processData(data);
		$('#map_attack_chart').highcharts({
			credits:{enabled:false},
			chart: {type: 'pie'},
			title: {
				text: null
			},
			plotOptions: {
				series: {
					dataLabels: {
						enabled: false
					}
				},
				pie: {
					size: "95%"
					/*,
					point: {
	                    events: {
	                        mouseOver: function(evt){
	                            this.slice();
	                        }
	                    }
	                }*/
				}
			},

			tooltip: {
				style: {'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 'fontSize': '15px'},
				headerFormat: '',
				useHTML:true,
				pointFormat: (all_zero?zeroFormat:pointFormat),
				formatter : function(){
					$("div.highcharts-tooltip span").css("white-space", "inherit");//允许换行
					//重新生成

					var percentage = !this.point.percentage ? this.point.percentage : this.point.percentage.toFixed(1);   
					var pointFormater = '<span>'+this.series.name+'</span>: <b>'+percentage+'%</b> ('+this.point.y+')</span>';
					var zeroFormater = '<span>'+this.series.name+'</span>: <b>0.00%</b> (0)</span>';					
					var content = '<div style="font-size: 10px;width: 200px;display:block;word-break: break-all;word-wrap: break-word;"><span style="color:'+this.point.color+';">' + this.key + '</span><br/>';
					if(all_zero) 
						content += zeroFormater;
					else 
						content += pointFormater;

					content += '</div>';
					return content;
				}
			},
			colors: ['#E8A02B','#FFE326','#BDEA2D','#31BD4C','#32A2A6','#2A60A6','#434348','#7429A6','#A63077','#BD1F08','#A6602D'],
			series: [{
				name: 'Count',
				colorByPoint: true,
				point: {
					events: {
						click: function () {
							if(isMapSub)
							{
								//changeData(this.id);
								curCode = this.id;
							}else{
								//changeData(0);
								curCode = 0;
							}
							changeTopData();
						}
					}
				},
				data: data
			}]
		});
	}

	return {changeData: changeData};

})(jQuery);
