var mapPanel = (function($) {
	var curCountry = 'world';
	var mapMenu = new YAHOO.widget.Menu('map_menu');
	
	var maps = {
		'world': 'custom/world',
		'US': 'countries/us/us-all',
		'CA': 'countries/ca/ca-all',
//		'GB': 'countries/gb/gb-all',
		'FR': 'countries/fr/fr-all',
		'DE': 'countries/de/de-all',
		'ES': 'countries/es/es-all'/*,
		'RU': 'countries/ru/ru-all',
		'IS': 'countries/is/is-all',
		'FO': 'countries/fo/fo-all',
		'NO': 'countries/no/no-all',
		'SE': 'countries/se/se-all',
		'FI': 'countries/fi/fi-all',
		'EE': 'countries/ee/ee-all',
		'LV': 'countries/lv/lv-all',
		'LT': 'countries/lt/lt-all',
		'BY': 'countries/by/by-all',
		'UA': 'countries/ua/ua-all',
		'IE': 'countries/ie/ie-all',
		'PT': 'countries/pt/pt-all',
		'IT': 'countries/it/it-all',
		'BE': 'countries/be/be-all',
		'NL': 'countries/nl/nl-all',
		'LU': 'countries/lu/lu-all',
		'AD': 'countries/ad/ad-all',
		'MC': 'countries/mc/mc-all',
		'CH': 'countries/ch/ch-all',
		'AT': 'countries/at/at-all',
		'MT': 'countries/mt/mt-all',
		'SM': 'countries/sm/sm-all',
		'DK': 'countries/dk/dk-all',
		'PL': 'countries/pl/pl-all',
		'MD': 'countries/md/md-all',
		'CZ': 'countries/cz/cz-all',
		'HU': 'countries/hu/hu-all',
		'SI': 'countries/si/si-all',
		'HR': 'countries/hr/hr-all',
		'BA': 'countries/ba/ba-all',
		'RS': 'countries/rs/rs-all',
		'RO': 'countries/ro/ro-all',
		'BG': 'countries/bg/bg-all',
		'KV': 'countries/kv/kv-all',
		'AL': 'countries/al/al-all',
		'MK': 'countries/mk/mk-all',
		'GR': 'countries/gr/gr-all',
		'TR': 'countries/tr/tr-all',
		'NC': 'countries/nc/nc-all',
		'LI': 'countries/li/li-all'*/
	};

	var all_countries = {
		'RESERVED': 'Reserved',
		'AP': 'Asia/Pacific Region',
		'EU': 'Europe',
		'AD': 'Andorra',
		'AE': 'United Arab Emirates',
		'AF': 'Afghanistan',
		'AG': 'Antigua and Barbuda',
		'AI': 'Anguilla',
		'AL': 'Albania',
		'AM': 'Armenia',
		'AN': 'Netherlands Antilles',
		'AO': 'Angola',
		'AQ': 'Antarctica',
		'AR': 'Argentina',
		'AS': 'American Samoa',
		'AT': 'Austria',
		'AU': 'Australia',
		'AW': 'Aruba',
		'AZ': 'Azerbaijan',
		'BA': 'Bosnia and Herzegovina',
		'BB': 'Barbados',
		'BD': 'Bangladesh',
		'BE': 'Belgium',
		'BF': 'Burkina Faso',
		'BG': 'Bulgaria',
		'BH': 'Bahrain',
		'BI': 'Burundi',
		'BJ': 'Benin',
		'BM': 'Bermuda',
		'BN': 'Brunei Darussalam',
		'BO': 'Bolivia',
		'BR': 'Brazil',
		'BS': 'Bahamas',
		'BT': 'Bhutan',
		'BV': 'Bouvet Island',
		'BW': 'Botswana',
		'BY': 'Belarus',
		'BZ': 'Belize',
		'CA': 'Canada',
		'CC': 'Cocos (Keeling) Islands',
		'CD': 'Democratic Republic of the Congo',
		'CF': 'Central African Republic',
		'CG': 'Congo',
		'CH': 'Switzerland',
		'CI': 'Cote D\'Ivoire',
		'CK': 'Cook Islands',
		'CL': 'Chile',
		'CM': 'Cameroon',
		'CN': 'China',
		'CO': 'Colombia',
		'CR': 'Costa Rica',
		'CU': 'Cuba',
		'CV': 'Cape Verde',
		'CX': 'Christmas Island',
		'CY': 'Cyprus',
		'CZ': 'Czech Republic',
		'DE': 'Germany',
		'DJ': 'Djibouti',
		'DK': 'Denmark',
		'DM': 'Dominica',
		'DO': 'Dominican Republic',
		'DZ': 'Algeria',
		'EC': 'Ecuador',
		'EE': 'Estonia',
		'EG': 'Egypt',
		'EH': 'Western Sahara',
		'ER': 'Eritrea',
		'ES': 'Spain',
		'ET': 'Ethiopia',
		'FI': 'Finland',
		'FJ': 'Fiji',
		'FK': 'Falkland Islands (Malvinas)',
		'FM': 'Federated States of Micronesia',
		'FO': 'Faroe Islands',
		'FR': 'France',
		'FX': 'France, Metropolitan',
		'GA': 'Gabon',
		'GB': 'United Kingdom',
		'GD': 'Grenada',
		'GE': 'Georgia',
		'GF': 'French Guiana',
		'GH': 'Ghana',
		'GI': 'Gibraltar',
		'GL': 'Greenland',
		'GM': 'Gambia',
		'GN': 'Guinea',
		'GP': 'Guadeloupe',
		'GQ': 'Equatorial Guinea',
		'GR': 'Greece',
		'GS': 'South Georgia and the South Sandwich Islands',
		'GT': 'Guatemala',
		'GU': 'Guam',
		'GW': 'Guinea-Bissau',
		'GY': 'Guyana',
		'HK': 'Hong Kong',
		'HM': 'Heard Island and McDonald Islands',
		'HN': 'Honduras',
		'HR': 'Croatia',
		'HT': 'Haiti',
		'HU': 'Hungary',
		'ID': 'Indonesia',
		'IE': 'Ireland',
		'IL': 'Israel',
		'IN': 'India',
		'IO': 'British Indian Ocean Territory',
		'IQ': 'Iraq',
		'IR': 'Islamic Republic of Iran',
		'IS': 'Iceland',
		'IT': 'Italy',
		'JM': 'Jamaica',
		'JO': 'Jordan',
		'JP': 'Japan',
		'KE': 'Kenya',
		'KG': 'Kyrgyzstan',
		'KH': 'Cambodia',
		'KI': 'Kiribati',
		'KM': 'Comoros',
		'KN': 'Saint Kitts and Nevis',
		'KP': 'Democratic People\'s Republic of Korea',
		'KR': 'Republic of Korea',
		'KW': 'Kuwait',
		'KY': 'Cayman Islands',
		'KZ': 'Kazakhstan',
		'LA': 'Lao People\'s Democratic Republic',
		'LB': 'Lebanon',
		'LC': 'Saint Lucia',
		'LI': 'Liechtenstein',
		'LK': 'Sri Lanka',
		'LR': 'Liberia',
		'LS': 'Lesotho',
		'LT': 'Lithuania',
		'LU': 'Luxembourg',
		'LV': 'Latvia',
		'LY': 'Libyan Arab Jamahiriya',
		'MA': 'Morocco',
		'MC': 'Monaco',
		'MD': 'Republic of Moldova',
		'MG': 'Madagascar',
		'MH': 'Marshall Islands',
		'MK': 'Macedonia',
		'ML': 'Mali',
		'MM': 'Myanmar',
		'MN': 'Mongolia',
		'MO': 'Macau',
		'MP': 'Northern Mariana Islands',
		'MQ': 'Martinique',
		'MR': 'Mauritania',
		'MS': 'Montserrat',
		'MT': 'Malta',
		'MU': 'Mauritius',
		'MV': 'Maldives',
		'MW': 'Malawi',
		'MX': 'Mexico',
		'MY': 'Malaysia',
		'MZ': 'Mozambique',
		'NA': 'Namibia',
		'NC': 'New Caledonia',
		'NE': 'Niger',
		'NF': 'Norfolk Island',
		'NG': 'Nigeria',
		'NI': 'Nicaragua',
		'NL': 'Netherlands',
		'NO': 'Norway',
		'NP': 'Nepal',
		'NR': 'Nauru',
		'NU': 'Niue',
		'NZ': 'New Zealand',
		'OM': 'Oman',
		'PA': 'Panama',
		'PE': 'Peru',
		'PF': 'French Polynesia',
		'PG': 'Papua New Guinea',
		'PH': 'Philippines',
		'PK': 'Pakistan',
		'PL': 'Poland',
		'PM': 'Saint Pierre and Miquelon',
		'PN': 'Pitcairn Islands',
		'PR': 'Puerto Rico',
		'PS': 'Palestinian Territory',
		'PT': 'Portugal',
		'PW': 'Palau',
		'PY': 'Paraguay',
		'QA': 'Qatar',
		'RE': 'Reunion',
		'RO': 'Romania',
		'RU': 'Russian Federation',
		'RW': 'Rwanda',
		'SA': 'Saudi Arabia',
		'SB': 'Solomon Islands',
		'SC': 'Seychelles',
		'SD': 'Sudan',
		'SE': 'Sweden',
		'SG': 'Singapore',
		'SH': 'Saint Helena',
		'SI': 'Slovenia',
		'SJ': 'Svalbard and Jan Mayen',
		'SK': 'Slovakia',
		'SL': 'Sierra Leone',
		'SM': 'San Marino',
		'SN': 'Senegal',
		'SO': 'Somalia',
		'SR': 'Suriname',
		'ST': 'Sao Tome and Principe',
		'SV': 'El Salvador',
		'SY': 'Syrian Arab Republic',
		'SZ': 'Swaziland',
		'TC': 'Turks and Caicos Islands',
		'TD': 'Chad',
		'TF': 'French Southern Territories',
		'TG': 'Togo',
		'TH': 'Thailand',
		'TJ': 'Tajikistan',
		'TK': 'Tokelau',
		'TM': 'Turkmenistan',
		'TN': 'Tunisia',
		'TO': 'Tonga',
		'TL': 'Timor-Leste',
		'TR': 'Turkey',
		'TT': 'Trinidad and Tobago',
		'TV': 'Tuvalu',
		'TW': 'Taiwan',
		'TZ': 'United Republic of Tanzania',
		'UA': 'Ukraine',
		'UG': 'Uganda',
		'UM': 'United States Minor Outlying Islands',
		'US': 'United States',
		'UY': 'Uruguay',
		'UZ': 'Uzbekistan',
		'VA': 'Holy See (Vatican City State)',
		'VC': 'Saint Vincent and the Grenadines',
		'VE': 'Venezuela',
		'VG': 'Virgin Islands, British',
		'VI': 'Virgin Islands, U.S.',
		'VN': 'Vietnam',
		'VU': 'Vanuatu',
		'WF': 'Wallis and Futuna',
		'WS': 'Samoa',
		'YE': 'Yemen',
		'YT': 'Mayotte',
		'RS': 'Serbia',
		'ZA': 'South Africa',
		'ZM': 'Zambia',
		'ME': 'Montenegro',
		'ZW': 'Zimbabwe',
		'A1': 'Anonymous Proxy',
		'A2': 'Satellite Provider',
		'O1': 'Other',
		'AX': 'Aland Islands',
		'GG': 'Guernsey',
		'IM': 'Isle of Man',
		'JE': 'Jersey',
		'BL': 'Saint Barthelemy',
		'MF': 'Saint Martin'
	}

	// this object use for GEO database state code convert to highmap state index code
	var map_states = {
		// because spain's state hc-a2 key mas duplicate cause map display error, so ES's convert to ha-key
		'ES': {
			'07': 'es-pm', //"Islas Baleares"
			'27': 'es-lo', //"La Rioja"
			'29': 'es-m', //"Madrid"
			'31': 'es-mu', //"Murcia"
			'32': 'es-na', //"Navarra"
			'34': 'es-o', //"Asturias"
			'39': 'es-s', //"Cantabria"
			'51': 'es-gr', //"Andalucia"
			'52': 'es-hu', //"Aragon"
//			'53': '', //"Canarias"
			'54': 'es-gu', //"Castilla-La Mancha"
			'55': 'es-va', //"Castilla y Leon"
			'56': 'es-t', //"Catalonia"
			'57': 'es-cc', //"Extremadura"
			'58': 'es-or', //"Galicia"
			'59': 'es-vi', //"Pais Vasco"
			'60': 'es-v', //"Comunidad Valenciana"
		},

    		'DE': {
			'01': 'BW', //"Baden-Wurttemberg"
			'02': 'BY', //"Bayern"
			'03': 'HB', //"Bremen"
			'04': 'HH', //"Hamburg"
			'05': 'HE', //"Hessen"
			'06': 'NI', //"Niedersachsen"
			'07': 'NW', //"Nordrhein-Westfalen"
			'08': 'RP', //"Rheinland-Pfalz"
			'09': 'SL', //"Saarland"
			'10': 'SH', //"Schleswig-Holstein"
			'11': 'BB', //"Brandenburg"
			'12': 'MV', //"Mecklenburg-Vorpommern"
			'13': 'SN', //"Sachsen"
			'14': 'ST', //"Sachsen-Anhalt"
			'15': 'TH', //"Thuringen"
			'16': 'BE', //"Berlin"
		},

    		'FR': {
			'97': 'AQ', //"Aquitaine"
			'98': 'AU', //"Auvergne"
			'99': 'BN', //"Basse-Normandie"
			'A1': 'BO', //"Bourgogne"
			'A2': 'BR', //"Bretagne"
			'A3': 'CE', //"Centre"
			'A4': 'CA', //"Champagne-Ardenne"
			'A5': 'CO', //"Corse"
			'A6': 'FC', //"Franche-Comte"
			'A7': 'HN', //"Haute-Normandie"
			'A8': 'ÎD', //"Ile-de-France"
			'A9': 'LR', //"Languedoc-Roussillon"
			'B1': 'LI', //"Limousin"
			'B2': 'LO', //"Lorraine"
			'B3': 'MP', //"Midi-Pyrenees"
			'B4': 'NP', //"Nord-Pas-de-Calais"
			'B5': 'PD', //"Pays de la Loire"
			'B6': 'PI', //"Picardie"
			'B7': 'PC', //"Poitou-Charentes"
			'B8': 'PA', //"Provence-Alpes-Cote d'Azur"
			'B9': 'RA', //"Rhone-Alpes"
			'C1': 'AL', //"Alsace"
		}
	};

	function convert_state_key(key)
	{
		if(map_states[curCountry] == undefined)
			return key;

		if(map_states[curCountry][key] != undefined)
			return map_states[curCountry][key];

		return key;
	}

	function convertkeyToName(key) {
		var name = '';
		if(key in all_countries)
			name = all_countries[key];

		return name;
	}

	function shouldConvertState()
	{
		if(curCountry == 'ES' || curCountry == 'DE' || curCountry == 'FR')
			return true;
		return false;
	}

	function changeData(code) {
		var uri = '/data_analytics/map/data_view?' + getFilterParam() + getTypeParam(code);
		var data = data_util.get_cache_data(uri);

		if(data  === null || !data.length)
		{
			loading_dlg.show();
			$.ajax({
				'url': uri,
				'dataType': 'json',
				'success': function(response)
				{
					var map_data;
				
					switch(curType)
					{
						case com_util.TYPE_HIT:
							map_data = response.hitdata;
						break;
						case com_util.TYPE_FLOW:
							map_data = response.flowdata;
						break;
						case com_util.TYPE_ATTACK:
							map_data = response.data;
						break;
						default:
							return;
					}

					map_data = map_data || [];

					data_util.put_cache_data(uri, map_data);

					FillMapData(map_data);

					topPanel.changeData(curCode);
					if(curType == com_util.TYPE_ATTACK) mapAttackPanel.changeData(curCode);

					loading_dlg.hide();
				},
				'error': function(){
					loading_dlg.hide();
				},
				'cache': false
			});
			
		} else {
			FillMapData(data);

			topPanel.changeData(curCode);
			if(curType == com_util.TYPE_ATTACK) mapAttackPanel.changeData(curCode);
		}
	}

	function mapOnLoad(e) {
		var chart = this;

		// Bind right click event in world map
		chart.container.oncontextmenu = function (e) {
			if(curCountry == 'world' && chart.hoverPoint) {
				mapOnContextMenu(e, chart.hoverPoint);
			}

			e.stopPropagation();
			e.preventDefault();
			return false;
		};
	}

	function mapOnClick() {
		var point = this;
		if(curCountry != 'world')
			return;

		currentMapCountry = point.key;

		if(point.key in maps){
			curCountry = point.key;
			changeData(curCode);
		} else {
			mapToList = true;
			statePanel.changeData(curCode);
		}
	}

	// open right click context menu
	function mapOnContextMenu(e, point) {
		if(!point.key)
			return;

		var country = convertkeyToName(point.key);
		if(!country.length)
			return;

		mapMenu.clearContent();
		mapMenu.addItems([[{
			text: l_qed_strtbl.add_to_geo,
			classname: 'tool_sprite tool_edit',
			onclick: {
				fn: function() {
					geoPanel.open(country);
				}
			}
		}]]);
		mapMenu.cfg.setProperty('position', 'dynamic');
		mapMenu.cfg.setProperty('x', e.clientX + 10);
		mapMenu.cfg.setProperty('y', e.clientY + 10);
		mapMenu.render($j('#map_context_menu')[0]);
		mapMenu.show();
	}

	function FillMapData(data) {

		var map_data = [];
		var map_keys = {};
		var show_back_button = false;

		var map_key = maps[curCountry];
		var geo_data = Highcharts.maps[map_key];
		var geo_key = '';

		if(curCountry != 'world') {
			show_back_button = true;
			geo_key = 'hc-a2'
			if(curCountry == 'ES')
				geo_key = 'hc-key';
		} else {
			geo_key = 'iso-a2';
		}

		data.forEach(function(e){
			if(!shouldConvertState())
			{
				map_data.push({'key': e.key, 'value': e.count, 'percent': e.percent });
				map_keys[e.key] = 1;
			}
			else
			{
				var key = e.key;
				var real_key = convert_state_key(key);
				map_data.push({'key': real_key, value: e.count, 'percent': e.percent});
				map_keys[real_key] = 1;
			}
		});

		geo_data.features.forEach(function(e){
			var key = e.properties[geo_key];
			if(!(key in map_keys)) {
				map_data.push({'key': key, 'value': 0, 'percent': 0});
			}
		});

		var map_option = {
			chart: {
				backgroundColor: '#F2F2F1',
				events: {
					load: mapOnLoad
				}
			},
			credits: {
			 	enabled: show_back_button,
				text: l_qed_strtbl.back_to_world,
				mapText: '',
				href: 'javascript:mapPanel.backToWorld();',
				position: {
					align: 'left',
					x: 100,
					verticalAlign: 'top',
					y: 50
				},
				style: {
					"cursor": "pointer", "color": "#999999", "fontSize": "15px"
				}
			},

			title: {
				text: null
			},

			tooltip: {
				headerFormat: '',
				pointFormat: '{point.name}: {point.value} ({point.percent:.2f}%)',
				style: {'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 'fontSize': '15px'}
			},

			mapNavigation: {
				enabled: true
			},

			colorAxis: {
				min: 0,
				stops: [
				[0, '#7BA1C1'],
				[0.001,'#005689'],//[0.001, Highcharts.getOptions().colors[0]],
				[1,Highcharts.Color('#003859').brighten(-0.5).get()],//[1, Highcharts.Color(Highcharts.getOptions().colors[0]).brighten(-0.5).get()]
				]
			},

			legend: {
				enabled: false
			},

			series: [{
				data: map_data,
				mapData: geo_data,
				joinBy: [geo_key, 'key'],
				name: 'data',
				states: {
					hover: {
						color: '#5C9EC2',//Highcharts.getOptions().colors[2]
					}
				},
				point: {
					events: {
						click: mapOnClick
					}
				},
				dataLabels: {
					enabled: false
				}

			}, {
				type: 'mapline',
				name: "Separators",
				data: Highcharts.geojson(geo_data, 'mapline'),
				nullColor: 'gray',
				showInLegend: false,
				enableMouseTracking: false
			}]
		};

		var chart = $j('#map_map').highcharts('Map', map_option);
	}

	function backToWorld(){
		curCountry = "world";
		currentMapCountry = "";
		changeData(curCode);
	}

	return {
		changeData: changeData,
		curCountry: curCountry,
		backToWorld: backToWorld
	};

})(jQuery);
