var statePanel = (function($){
	'use strict';

	var source;
	var flowLabel = l_qed_strtbl.count;
	function changeHeaderText()
	{
		var type = curType;
		
		if(type == com_util.TYPE_FLOW)
		{
			flowLabel = l_qed_strtbl.flow + '(KB)';
		}
		else
		{
			flowLabel = l_qed_strtbl.count;
		}
	}
	function perIcon_format_fn(td, col, row_data)
	{
		var percent = parseInt(row_data['percent']);
		var country = row_data['country'];
		var level = getPercentIcon(percent, country);

		if(level == "")
			return '';
		else 
			return '<image src="/images/'+ level + '.png">';
	}
	function genStateList(data)
	{
		source = data;
		changeHeaderText();
		var qlist_settings = {
			'prefix': 'da_state_list',
			'source': source,
			'row_attr': [
			        {name: 'key', selector: 'key'}
			],
			'columns': [
				{'selector': 'country', 'lang_key': l_qed_strtbl.state},
	        		{'selector': 'count', 'lang_key': flowLabel},
	        		{'selector': 'percent', 'lang_key': l_qed_strtbl.percent},
				{'selector': 'perIcon', 'lang_key': ' '}
			],
			'options':{
				'ref_column': false,
				'sorting': false,
				'hide_default_buttons': true,
				'hide_menu': true,
				'fixed_header': false
			},
			'format_fn': {
				'perIcon': perIcon_format_fn,
			}
		};
		var $container = $("#map_list");
		$container.qlist(qlist_settings);
	}
	function changeData(code)
	{
		var type = curType;
		var url = "/data_analytics/map/data_view?"+ getFilterParam() + getTypeParam(code);
		var data = data_util.get_cache_data(url);

		if(mapToList === true)
		{
			$("div#map_list").css('display', '');
			$("div#map_map").css('display', 'none');
		}

		$("div#btn_back").css('display', '');
		
		if(data == null || data.length == 0)
		{
			loading_dlg.show();
			$j.ajax({
				'url': url,
				'cache': false,
				'dataType': 'json',
				'error': function(){
					loading_dlg.hide();
				},
				'success': function(response)
				{
					loading_dlg.hide();
					if(response.status == 'ok')
					{
						var data=[];
						
						if(type === com_util.TYPE_FLOW)
							data = response.flowdata;
						else if(type === com_util.TYPE_HIT)
							data = response.hitdata;
						else if(type === com_util.TYPE_ATTACK)
						{
							data = response.data;
							mapAttackPanel.changeData(code);
						}
						
						data_util.put_cache_data(url, data);
						genStateList(data);
						
						topPanel.changeData(curCode);
					}

				}
			});
		}
		else
		{
			if(type == com_util.TYPE_ATTACK)
				mapAttackPanel.changeData(code);
			
			genStateList(data);
			topPanel.changeData(curCode);
		}
	}
	function backToCountry()
	{
		if(mapToList === true)
		{
			$("div#map_list").css('display', 'none');
			$("div#map_map").css('display', '');
			$("div#btn_back").css('display', 'none');

			currentMapCountry = "";
			mapToList = false;
			mapPanel.changeData(curCode);
		}
		else
		{
			currentCountry = "";
			listPanel.changeData(curCode);
		}
	}
	return {
		'changeData': changeData,
		'backToCountry': backToCountry,
	};
})(jQuery);
