var timePanel = (function(){

	var PER_PERIOD_DATA = 5;
	var cur_period = 0;
	var period_num = 0;
	var total = 0;
	var timeArray = [];
	var tmpArray = [];

	function changeData()
	{
		changeSelectOptions();
		cur_period = 0;
		tmpArray = [];

		nextData();
	}

	function doubleDigitFormat(num)
	{
		if(num < 10)
			return '0' + num.toString();

		return num.toString();
	}

	function nextData()
	{
		var type = parseInt($j('#trend_type').val());
		var interval = parseInt($j('#trend_interval').val());

		cal_len();

		loading_dlg.show();
		$j.ajax({
			'url': '/data_analytics/web/time_trend?page=' + cur_period+ '&type='+type+'&interval='+interval+'&'+getFilterParam(),
			'cache': false,
			'dataType': 'json',
			'error': function(){
				loading_dlg.hide();
			},
			'success': function(data)
			{
				loading_dlg.hide();

				var i = 0;
				var count = 0;
				var time = '';

				if(data.status == 'ok')
				{
					timeArray = [];

					var d = data.data;

					for(i = 0; i < d.length; i++)
					{
						var obj = d[i];
						time = '';
						count = 0;

						time = obj.time;
						count = obj.count;

						tmpArray.push({'time': time, 'count': count, 'interval': i});
					}

					var date = new Date();
					var t = date.getFullYear() + '-' + (date.getMonth()+1) + '-' + date.getDate() + '\n  ' +
						doubleDigitFormat(date.getHours()) + ':' + doubleDigitFormat(date.getMinutes());

					var filterStr = getFilterParam();
					var shour = '', smin = '', syear = '', smon = '', sday = '';
					if(filterStr.indexOf('time_filter') != -1)
					{
						var params = filterStr.split('&');
						for(var k = 0; k < params.length; k++)
						{
							var p = params[k];
							if(p.indexOf('thour') != -1)
								shour = doubleDigitFormat( parseInt(p.substring(p.indexOf("=")+1 )));

							if(p.indexOf("tomin") != -1)
								smin = doubleDigitFormat( parseInt( p.substring(p.indexOf("=")+1)));

							if(p.indexOf("toyear") != -1)
								syear = p.substring(p.indexOf("=")+1);

							if(p.indexOf("tomon") != -1)
								smon = p.substring(p.indexOf("=")+1);

							if(p.indexOf("today") != -1)
								sday = p.substring(p.indexOf("=")+1);
						}

						t = syear + "-" + smon + "-" + sday + "\n   " + shour + ":" + smin;
					}

					if(tmpArray.length % PER_PERIOD_DATA == 1)
					{
						tmpArray.push({'time': t, 'count': 0, 'interval': tmpArray.length});
						total += 1;
					}

					var len = tmpArray.length - cur_period * PER_PERIOD_DATA;
					var start = cur_period * PER_PERIOD_DATA;
					for(i = start; i < start+len; i++)
					{
						timeArray.push(tmpArray[i]);
					}
					draw(timeArray);
					changeBtnState();
				}
				else if(data.status == 'error')
				{
					alert(data.error);
				}
			}
		});
	}

	function draw(data)
	{
		var cate = [];
		var count = [];
		for(var i = 0; i < data.length; i++)
		{
			cate.push(data[i].time);
			count.push(data[i].count);
		}

		var options = {
			credits:{enabled:false},
			legend:{enabled:false},
			chart: {
				type: 'spline'
			},
			title: {
				text: null
			},
			xAxis: {
				lineWidth: 2,
				categories: cate,
				labels: {
					style: {'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 'fontSize': '12px'}
				}
			},
			yAxis: {
				lineWidth: 2,
				title: {
					text: null
				},
				labels: {
					style: {'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 'fontSize': '12px'},
					formatter: function(){
						var type = parseInt($j('#trend_type').val());
						var label = this.value;
						if(type===2) label = this.value+'KB';
						return label;
					}
				},
			},
			tooltip: {
				style: {'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 'fontSize': '15px'},
				pointFormatter: function(){
					var type = parseInt($j('#trend_type').val());
					var tip = '<span style="color:{'+this.series.color+'}"></span> <b>'+this.y+'</b><br/>';
					if(type===2) tip = '<span style="color:{'+this.series.color+'}"></span> <b>'+this.y+'KB</b><br/>';
					return tip;
				}
			},
			plotOptions: {
				spline: {
					marker: {
						radius: 4,
						lineColor: '#666666',
						lineWidth: 1
					}
				}
			},
			series: [{
				marker: {
					symbol: 'square'
				},
				data: count
			}]
		};
		$j('#trend_chart').highcharts(options);
	}

	function cal_len()
	{
		total = 0;
		period_num = 0;

		var range = 0;
		var interval = $j('#trend_interval').val();

		if($j('#filter_pre').is(':checked'))
		{
			range = parseInt($j('#time_select').val());
		}
		else if($j('#filter_custom').is(':checked'))
		{
			range = FilterDialog.GetTimeRange();
		}

		total = range / interval;
		if(range % interval != 0)
			total += 1;

		period_num = parseInt((total-1) / PER_PERIOD_DATA);
	}

	function preClick()
	{
		if(cur_period == 0)
			return;

		var len = PER_PERIOD_DATA;
		var start = (cur_period - 1) * PER_PERIOD_DATA;

		timeArray = [];
		for(var i = start; i < start+len; i++)
		{
			timeArray.push(tmpArray[i]);
		}

		cur_period--;
		draw(timeArray);
		changeBtnState();
	}

	function nextClick()
	{
		if(cur_period == period_num)
			return;

		if(tmpArray.length > ((cur_period+1)*PER_PERIOD_DATA ))
		{
			var start = (cur_period+1) * PER_PERIOD_DATA;
			var len = ((total - start) < PER_PERIOD_DATA) ? (total-start) : (PER_PERIOD_DATA);

			timeArray = [];
			for(var i = start; i < start+len; i++)
			{
				timeArray.push(tmpArray[i]);
			}
			cur_period++;
			draw(timeArray);

			changeBtnState();
		}
		else
		{
			cur_period++;
			nextData();
		}
	}

	function changeBtnState()
	{
		if(cur_period == 0)
			$j('#trend_pre_btn').prop('disabled', 'disabled');
		else
			$j('#trend_pre_btn').prop('disabled', '');

		if(cur_period == period_num)
			$j('#trend_next_btn').prop('disabled', 'disabled');
		else
			$j('#trend_next_btn').prop('disabled', '');
	}

	function changeSelectOptions() {
		var interval = parseInt($j('#time_select').val());

		$j("select#trend_interval option").each(function(){
			var value = $j(this).val();
			if(parseInt(value) < interval || $j('#filter_custom').prop('checked')){
				$j(this).prop('disabled', '');
			} else {
				if(value == $j("#trend_interval").val()){
					$j("#trend_interval").val($j("select#trend_interval option:first").val());
				}
				$j(this).prop('disabled', 'disabled');
			}
		});
	}

	return {
		'changeData': changeData,
		'nextClick': nextClick,
		'preClick': preClick,
		'changeSelectOptions': changeSelectOptions
	};
})(jQuery);
