var topPanel = (function(){

	var curCode = 0;

	function draw(data)
	{
		var len = data.length > 11 ? 11 : data.length;
		var cat = [];
		var count = [];

		// index from 1, cut off the Total data
		for(var i = 1; i < len; i++)
		{
			var obj = data[i];
			cat.push(obj.country);
			count.push(obj.count);
		}

		var options = {
			chart: {
				type: 'column'
			},
			title: {
				text: ''
			},
			subtitle: {
				text: ''
			},
			xAxis: {
				type: 'category',
				labels: {
					enabled:true,
					style: {'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 'fontSize': '12px'}
				},
				lineWidth :3,
				categories: cat,
				lineColor: '#555555'
			},
			yAxis: {
				min: 0,
				title: {
					text: ''
				},
				labels: {
					style: {'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 'fontSize': '12px'},
					formatter: function(){
						var type = parseInt($j('input[name=map_type_radio]:checked').val());
						var label = this.value;
						if(type===2) label = this.value+'KB';
						return label;
					}
				},
				lineWidth :3,
				lineColor: '#555555'
			},
			credits:{enabled:false},
			legend: {enabled: false},
			tooltip: {
				style: {'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 'fontSize': '15px'},
				headerFormat:  '<span></span>',
				pointFormatter: function(){
					var type = '';
					if($j('#map_type_hit').is(':checked'))
						type = $j('#map_type_hit').next('label').text();
					else if($j('#map_type_flow').is(':checked'))
						type = $j('#map_type_flow').next('label').text();
					else if($j('#map_type_attack').is(':checked'))
						type = $j('#map_type_attack').next('label').text();

					var map_type = parseInt($j('input[name=map_type_radio]:checked').val());
					var unit = '';
					if(map_type===2) unit = 'KB';

					return '<span style="color:{'+this.series.color+'}"></span>'+this.category + ' ' + type +' '+l_qed_strtbl.count + ': ' + this.y + unit;
				}
			},
			//colors: ['#E8A02B','#FFE326','#BDEA2D','#31BD4C','#32A2A6','#2A60A6','#434348','#7429A6','#A63077','#BD1F08','#A6602D'],
			series: [{
				name: 'data',
				//colorByPoint:true,
				data: count,
				color: '#003859'//'#4c6b7d'
			}]
		};

		$j('#top10_chart').highcharts(options);
	}

	function changeData(code)
	{
		curCode = code;

		var url = '/data_analytics/map/data_view?' + getFilterParam() + getTypeParam(curCode);
		var data = data_util.get_cache_data(url);
		if(data === null)
			data = [];

		// data format
		/*
		var data1 = [
			{count: 17, percent: 100, key: 'Total', country: 'Total'},
			{count: 8, percent: 100, key: 'Internal IPs', country: 'Internal IPs'},
			{count: 5, percent: 100, key: 'NL', country: 'Netherlands'},
			{count: 4, percent: 100, key: 'US', country: 'United States'},
			];
			*/
		draw(data);
	}

	return {
		'curCode': curCode,
		'changeData': changeData
	};

})(jQuery);
