var typePanel = (function(){
	
    var options = {
        chart: {
            type: 'column'
        },
        title: {
            text: ''
        },
        subtitle: {
            text: ''
        },
        xAxis: {
            type: 'category',
            labels: {
                enabled:false                
            },
            lineWidth :2
        },
        yAxis: {
            min: 0,
            title: {
                text: ''
            },
            lineWidth :2,
            labels: {
		style: {'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 'fontSize': '12px'},
                formatter: function() {
                    return ($j("#type_select").val() === '2')?this.value+'KB':this.value ;
                }
            }
        },
        credits:{enabled:false},
        legend: {enabled: false},
        tooltip: {
	    style: {'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 'fontSize': '15px'},
            pointFormatter: function(){
            	return ($j("#type_select").val() === '2')?'<b>'+this.y+'KB':'<b>'+this.y+'</b>';
            }
        },
        series: [{
            name: 'web type chart',
            data: []
        }]
    };

    function set_chart(value){
		var categories = [];
		var data = [];		

		$j.each(value, function(itemNo, item) {
			categories.push(item.name);
			data.push(item.count);
		});

		options.xAxis.categories = categories;
		options.series[0].data = data;

		$j('#web_type_chart').highcharts(options);
    }
	function changeData() {
		var type = $j("#type_select").val();
		var category = $j("#category_select").val();

		options.xAxis.categories = [];
		options.series[0].data = [];
		var  uri = '/data_analytics/web/type_view?type='+encodeURIComponent(type)+'&category='+encodeURIComponent(category)+'&'+getFilterParam();
		var cache_data = data_util.get_cache_data(uri);

		if(cache_data  !== null && cache_data.length > 0)
		{
			set_chart(cache_data);
		}else{
			loading_dlg.show();
			$j.ajax({
				'url': uri,
				'dataType': 'json',
				'success': function(results)
				{
					loading_dlg.hide();
					if(results.status == 'ok')
					{
						data_util.put_cache_data(uri,results.data);
						set_chart(results.data);
					}else{
						alert(results.error);
					}
				},
				'error': function(XMLHttpRequest, textStatus)
				{
					loading_dlg.hide();
					$j('#web_type_chart').highcharts(options);
				},
				'cache': true
			});			
		}


	}

	return {
		'changeData': changeData
	}
	/*
	$j(document).ready(function() {

		changeData();

		$j("#type_select").change(function(){
			changeData();
		});
		$j("#category_select").change(function(){
			changeData();
		});
	});    
*/
})(jQuery);

