function Device(dom, options) {
	var __device = this; // used for callback handlers

	this.update_id = 0; // used for clearing interval
	this.obj = null; // for updating
	this.obj_type = "device";

	// options
	this.options = options;
	this.type = this.options.type;
	this.model = this.options.model.toLowerCase();
	this.ready = this.options.ready;
	this.debug = this.options.debug;

	// dom
	this.dom = dom;
	this.dom.className = this.type + " " + this.model;

	// device status
	this.is_vdom_admin = 0;
	this.vdom = "";
	this.ha = 0;
	this.vcluster_id = 0;
	this.opmode = "nat";
	this["internal-switch-mode"] = "interface";

	// components
	this.ports = [];
	this.connections = [];
	this.portgroups = [];
	this.slots = [];
	this.labels = [];

	this.loadXML = function (root) {
		var type;
		var nodeList, node;
		var devices = {};

		// get device types hash
		nodeList = root.getElementsByTagName("device");
		for (var i = 0; i < nodeList.length; i++) {
			node = nodeList[i].cloneNode(true);
			type = node.getAttribute("type");
			devices[type] = node;
		}

		// get specified model
		nodeList = root.getElementsByTagName("model");
		for (var i = 0; i < nodeList.length; i++) {
			if (nodeList[i].getAttribute("type") == this.model) {
				node = nodeList[i];
				break;
			}
		}

		// sanity check
		if (node == null) {
			return;
		};
	
		// iterate through all subnodes and load XML for each component
		nodeList = node.childNodes;
		for (var i = 0; i < nodeList.length; i++) {
			node = nodeList[i];
			
			switch (node.nodeName) {
				case "port" : {
					var port = new Port({parent: this, device: this});
					port.loadXML(node);
					this.ports.push(port);
				}
				break;

				case "portgroup" : {
					portgroup = new PortGroup({parent: this, device: this});
					portgroup.loadXML(node, devices);
					this.portgroups.push(portgroup);
				}
				break;

				case "slot" : {
					var slot = new Slot({parent: this, device: this});
					slot.loadXML(node, devices);
					this.slots.push(slot);
				}
				break;

				case "label" : {
					var label = new Label({parent: this, device: this});
					label.loadXML(node);
					this.labels.push(label);
				}
				break;

				case "connection" : {
					var connection = new Connection({parent: this, device: this});
					connection.loadXML(node);
					this.connections.push(connection);
				}
				break;
			}
		}
		
		// add default labels (should be through XML template)
		this.labels.push(new Label({parent: this, device: this, id: "label_model"}));

		// add connections by default (should be through XML)
		if (this.options['show_connections']) {
			this.connections.push(new Connection({parent: this, device: this, id: "faz"}));
			this.connections.push(new Connection({parent: this, device: this, id: "fmg"}));
			this.connections.push(new Connection({parent: this, device: this, id: "fc"}));
		}
	};

	// update info
	// eventually replace different types of components with just 1, and use a "type" parameter to determine behaviour
	// perhaps just call the extend function without overwriting objects, only simple values and non-existent objects
	this.update = function (obj) {
		var id;
		jQuery.extend(this, obj.device);
		this.obj = obj;

		for (var i = 0; i < this.ports.length; i++) {
			id = this.ports[i].id;
			this.ports[i].update(obj.ports[id]);
		}

		for (var i = 0; i < this.connections.length; i++) {
			id = this.connections[i].id;
			this.connections[i].update(obj.connections[id]);
		}

		for (var i = 0; i < this.portgroups.length; i++) {
			this.portgroups[i].update(obj.ports);
		}

		for (var i = 0; i < this.slots.length; i++) {
			id = this.slots[i].id;
			this.slots[i].update(obj.slots[id]);
		}

		for (var i = 0; i < this.labels.length; i++) {
			id = this.labels[i].id;
			this.labels[i].update(obj.labels[id]);
		}
	};
	
	// render DOM
	this.render = function (obj) {
		// ports
		for (var i = 0; i < this.ports.length; i++) {
			this.ports[i].render(this.dom);
		}

		// connections
		for (var i = 0; i < this.connections.length; i++) {
			this.connections[i].render(this.dom);
		}

		// portgroups
		for (var i = 0; i < this.portgroups.length; i++) {
			this.portgroups[i].render(this.dom);
		}

		// slots
		for (var i = 0; i < this.slots.length; i++) {
			this.slots[i].render(this.dom);
		}

		// labels
		for (var i = 0; i < this.labels.length; i++) {
			this.labels[i].render(this.dom);
		}
/*
		// ha
		if (!this.dom.ha) {
			this.dom.ha = document.createElement("div");
			this.dom.appendChild(this.dom.ha);
			this.dom.ha.style.top = this.dom.clientHeight + 'px';
			if (this.ready) {
				this.ready();
			}
		}
*/
		// debug info
		if (this.debug && !this.dom.debug) {
			this.dom.debug = document.createElement("pre");
			this.dom.debug.className = "debug";
			this.dom.debug.style.display = "none";
			this.dom.appendChild(this.dom.debug);
			this.dom.ondblclick = function () {
				__device.dom.debug.style.display = "";
			};
		}

		//this.dom.ha.className = (this.ha && this.options.show_ha) ? "ha" : "";
	};

	// update from a url
	this.remoteupdate = function (url, interval) {
		var device = __device;

		var __remoteupdate = function () {
			var response_handler = function (response) {
				try {
					message(response.responseText, device.dom.debug);
					var obj = eval("(" + response.responseText + ")");

					device.update(obj);
					device.render();
				}
				catch (e) {
					message(e.message, device.dom.debug);
				}
			};
			Request.sendGET(uncache_url(url), response_handler);
   		};

		if (typeof(interval) == "undefined") {
			__remoteupdate();  // execute immediately
		}
		else if (interval == 0) {
			clearInterval(this.update_id);  // clear previous update
		}
		else if (interval > 0) {
			clearInterval(this.update_id);  // clear previous update
			__remoteupdate();  // execute immediately
			this.update_id = setInterval(__remoteupdate, interval * 1000); // interval in seconds
		}
	};
}

function Label(obj) {
	this.parent = obj.parent;
	this.device = obj.device;
	this.obj_type = "label";

	this.id = obj.id;
	this.text = obj.text ? obj.text : "";

	this.dom = null;

	this.loadXML = function (node) {
		this.id = node.getAttribute("id");
		this.text = node.firstChild ? node.firstChild.nodeValue : "";
	};

	this.update = function (obj) {
		jQuery.extend(this, obj);
	};

	this.render = function (parent) {
		if (!this.dom) {
			this.dom = document.createElement("span");
			this.dom.className = this.id;
			parent.appendChild(this.dom);
		}

		this.dom.innerHTML = this.text;
	};
}

function Connection(obj) {
	this.parent = obj.parent;
	this.device = obj.device;
	this.obj_type = "connection";

	this.dom = null;

	this.id = obj.id;
	this.type = obj.type ? obj.type : "";
	this.status = obj.status ? obj.status : "";
	this.label = obj.label ? obj.label : "";

	this.loadXML = function (node) {

	};

	this.update = function (obj) {
		jQuery.extend(this, obj);
	};

	this.render = function (parent) {

		if (!this.dom) {
			// namespace div
			this.dom = document.createElement("div");
			this.dom.className = "connection";

			// connection div
			this.dom.connection = document.createElement("div");
	
			// status
			this.dom.connection.status = document.createElement("div");
			this.dom.connection.appendChild(this.dom.connection.status);

			// label
			this.dom.connection.label = document.createElement("div");
			this.dom.connection.appendChild(this.dom.connection.label);

			// append to DOM
			this.dom.appendChild(this.dom.connection);
			parent.appendChild(this.dom);
		}

		// add onclick handlers
		switch (this.type) {
			case "faz_device" :
				this.dom.onclick = goto_fa;
				this.dom.style.cursor = "pointer";
			break;

			case "faz_service" :
				this.dom.onclick = goto_fa;
				this.dom.style.cursor = "pointer";
			break;

			case "fmg_device" :
				this.dom.onclick = goto_fmg;
				this.dom.style.cursor = "pointer";
			break;

			case "fmg_service" :
				this.dom.onclick = goto_fmg;
				this.dom.style.cursor = "pointer";
			break;

			case "fc_service" :
				this.dom.onclick = goto_fc;
				this.dom.style.cursor = "pointer";
			break;
		}

		this.dom.connection.label.className = "label";
		this.dom.connection.label.innerHTML = this.label;
		this.dom.connection.className = this.id + " " + this.type;
		this.dom.connection.status.className = "status" + " " + this.status;
	};
}

function Slot(obj) {
	this.parent = obj.parent;
	this.device = obj.device;
	this.obj_type = "slot";

	this.dom = null;
	this.obj = null;
	
	this.parent = parent;
	this.id = "";
	this.type = "";
	this.module = "";
	
	this.types = {};

	this.loadXML = function (slot, devices) {
		// set object values first
		this.id = slot.getAttribute("id");
		this.type = slot.getAttribute("type");
		
		// grab different module types
		var device = devices[this.type];
		var nodeList = device.childNodes;

		for (var i = 0; i < nodeList.length; i++) {
			node = nodeList[i];

			switch (node.nodeName) {
				case "module" : {
					var name = node.getAttribute("type");
					var module = new Module({parent: this, device: this.device});
					module.loadXML(node, devices);
					this.types[name] = module;
				}
				break;
			}
		}
	};

	this.update = function (obj) {
		if (obj && this.types[obj.module]) {
			jQuery.extend(this, obj);
			this.obj = this.types[this.module];
			this.obj.update(obj);
		}
		else {
			this.module = null;
			this.obj = null;
		}
	};
	
	this.render = function (parent) {
		if (!this.dom) {
			this.dom = document.createElement("div");
			this.dom.className = this.id + " " + this.type; 
			parent.appendChild(this.dom);
		}
		removeAllChildNodes(this.dom);

		if (this.obj) {
			this.obj.render(this.dom);
		}
	};
}

function Module(obj) {
	this.parent = obj.parent;
	this.device = obj.device;
	this.obj_type = "module";

	this.dom = null;
	this.type = "";
	this.mode = "";
	
	this.components = [];
	this.slots = [];
	
	this.loadXML = function (module, devices) {
		var nodeList = module.childNodes;
		var node;
		var tmp;

		if ((tmp = module.getAttribute("type"))) this.type = tmp;

		for (var i = 0; i < nodeList.length; i++) {
			node = nodeList[i];

			switch (node.nodeName) {
				case "slot" : {
					var slot = new Slot({parent: this, device: this.device});
					slot.loadXML(node, devices);
					this.slots.push(slot);
				}
				break;

				case "label" : {
					var label = new Label({parent: this, device: this.device});
					label.loadXML(node);
					this.components.push(labels);
				}
				break;
					
				case "portgroup" : {
					var portgroup = new PortGroup({parent: this, device: this.device});
					portgroup.loadXML(node, devices);
                    this.components.push(portgroup);
				}
				break;
			}
		}
	};
	
	this.update = function (obj) {
		if (obj.mode) {
			this.mode = obj.mode;
		}

		for (var i = 0; i < this.components.length; i++) {
			this.components[i].update(obj);
		}

		if (obj.slots) {
			for (var i = 0; i < this.slots.length; i++) {
				if (obj.slots[this.slots[i].id]) {
					this.slots[i].update(obj.slots[this.slots[i].id]);
				}
			}

		}
	};
	
	this.render = function (parent) {
		if (!this.dom) {
			this.dom = document.createElement("div");
			this.dom.className = this.type;

			this.dom.mode = document.createElement("div");
			this.dom.mode.className = "mode";
			this.dom.appendChild(this.dom.mode);

			this.dom.mode.value = document.createElement("div");
			this.dom.mode.appendChild(this.dom.mode.value);
		}

		this.dom.mode.value.className = this.mode;
		parent.appendChild(this.dom);
		
		// components
		for (var i = 0; i < this.components.length; i++) {
			this.components[i].render(this.dom);
		}

		// slots
		for (var i = 0; i < this.slots.length; i++) {
			this.slots[i].render(this.dom);
		}
	};
}

function PortGroup(obj) {
	this.parent = obj.parent;
	this.device = obj.device;
	this.obj_type = "portgroup";

	this.id = null;
	this.dom = null;
	this.label = "";
	this.auto = false; // auto rendering of ports not implemented - supposed to be non-explicit rendering of ports
	this.ports = []; // array of arrays

	this.loadXML = function (node, devices) {
		var childNodeList, childNode;
		var port, portgroup;
		var rows, num;
		var start, end;
		var attr;
		var is_switch = false;
		var type = "rj45";
		var prefix = "";

		for (var parent = this.parent; parent && parent.obj_type; parent = parent.parent) {
			if (parent.obj_type == "slot") {
				prefix = parent.id + "/" + prefix;
			}
		}

		this.id = node.getAttribute("id");
		this.label = node.getAttribute("label");
		attr = node.getAttribute("auto");
		this.auto = attr ? true : false;
		if (this.auto) {
			return;
		}

		rows = parseInt(node.getAttribute("rows"));
		if (!rows) rows = 1;
					
		for (j = 0; j < rows; j++) {
			this.ports.push([]); // create rows
		}

		childNodeList = node.childNodes;
		for (var j = 0; j < childNodeList.length; j++) {
			childNode = childNodeList[j];
			if (childNode.nodeName != "port") {
				continue;
			}

			attr = childNode.getAttribute("start");
			start = attr ? parseInt(attr) : 1;

			attr = childNode.getAttribute("num");
			num = (attr ? parseInt(attr) : 1);
			end = start + num;

			attr = childNode.getAttribute("switch_only");
			is_switch = (attr && attr == "true") ? true : false;

			attr = childNode.getAttribute("type");
			type = attr ? attr : "rj45";

			for (var k = start; k < end; k++) {
				port = new Port({parent: this, device: this.device});

				port.type = type;
				port.id = prefix + childNode.getAttribute("id");
				port.name = childNode.getAttribute("id");
				port.label = childNode.getAttribute("label");
				port.switch_name = childNode.getAttribute("switch_name");
				port.index = k;

				if (num > 1) {
					port.label += k;
					if (!is_switch) {
						port.id += k;
					}
				}

				this.ports[(k - 1) % rows].push(port);
			}
		}
	};

	this.update = function (obj) { // ignore obj (json format should be structured the same, but isn't)
		if (this.auto) {
			var port = null;
			this.ports = [];
			this.ports.push([]);

			for (var i in this.device.obj.ports) {
				port = new Port({ parent: this, device: this.device });
				jQuery.extend(port, this.device.obj.ports[i]);
				port.label = port.id;
				this.ports[0].push(port);
			}

			return;
		}

		for (var i = 0; i < this.ports.length; i++) {
			for (var j = 0; j < this.ports[i].length; j++) {
				this.ports[i][j].update(this.device.obj.ports);
			}
		}
	};
	
	this.render = function (parent) {
		if (this.auto) {
			removeAllChildNodes(this.dom);
			this.dom = null;
		}

		if (!this.ports.length) {
			return;
		}

		if (!this.dom) {
			var tbody, tr_labels, tr_ports, tr, td, text, label;

			this.dom = document.createElement("table");
			this.dom.className = "portgroup" + " " + this.id;
			this.dom.cellPadding = 0;
			this.dom.cellSpacing = 0;

			tbody = document.createElement("tbody");
			tr_labels = [];
			tr_ports = [];

			// portgroup label
			if (this.label != null) {
				tr = document.createElement("tr");
				td = document.createElement("td");
				td.innerHTML = (this.label != "") ? this.label : "&nbsp;";
				td.colSpan = this.ports[0].length;
				tr.appendChild(td);
				tbody.appendChild(tr);
			}

			// port labels
			for (var i = 0; i < this.ports.length; i++) {
				tr_labels[i] = document.createElement("tr");

				for (var j = 0; j < this.ports[i].length; j++) {
					//if(this.ports[i][j].name.indexOf('mgmt') != -1 && this.ports[i][j].name != 'mgmt1')
					//	continue;

					td = document.createElement("td");
					//if(this.ports[i][j].name == 'mgmt1')
					//	text = document.createTextNode('mgmt(1,2)');
					if(this.ports[i][j].name.indexOf('mgmt') != -1)
						text = document.createTextNode(this.ports[i][j].id);
					else
						text = document.createTextNode(this.ports[i][j].label ? this.ports[i][j].label : "");
					td.appendChild(text);
					/*
					if(this.ports[i][j].name == 'mgmt1')
					{
						td.setAttribute('colspan', "2");
					}
					*/
					tr_labels[i].appendChild(td);
				}
			}

			// ports
			for (var i = 0; i < this.ports.length; i++) {
				tr_ports[i] = document.createElement("tr");

				for (var j = 0; j < this.ports[i].length; j++) {
					this.ports[i][j].render(tr_ports[i]);
				}
			}

			// append 1st row of labels
			tbody.appendChild(tr_labels[0]);
			
			// append ports
			for (var i = 0; i < tr_ports.length; i++) {
				tbody.appendChild(tr_ports[i]);
			}

			// append 2nd row of labels
			if (tr_labels.length > 1) {
				tbody.appendChild(tr_labels[1]);
			}
			
			this.dom.appendChild(tbody);
			parent.appendChild(this.dom);
		}

		// just update ports
		for (var i = 0; i < this.ports.length; i++) {
			for (var j = 0; j < this.ports[i].length; j++) {
				this.ports[i][j].render();
			}
		}
		
		return this.dom;
	};
}

function Port(obj) {
	var port = this;

	this.parent = obj.parent;
	this.device = obj.device;
	this.obj_type = "port";

	this.dom = null;
	this.name = "";
	this.alias = "";
	this.ip = "0.0.0.0";
	this.mask = 24;
	this.link = "";
	this.speed = -1;
	this.duplex = 0;
	this.rx = 0;
	this.tx = 0;
	this.label = "";

	this.update = function (obj) {
		if (obj[this.id]) {
			jQuery.extend(this, obj[this.id]);
		}
		else if (this.device["internal-switch-mode"] != "interface") {
			if (this.switch_name && obj[this.switch_name]) {
				jQuery.extend(this, obj[this.switch_name]);
			}
		}
	};
	
	this.render = function (parent) {
		if (!this.dom) {
			this.dom = document.createElement("td");
			this.dom.className = this.type;

			this.dom.status = document.createElement("div");

			if(port.id) {
				this.dom.status.setAttribute("port_id", port.id);
			}

			this.dom.appendChild(this.dom.status);
			parent.appendChild(this.dom);
		}

		var className = this.link;

		//allow interface list to use 'selected' class to highlight selected ports
		var selected = /\bselected\b/.test(this.dom.status.className);
		this.dom.status.className = className;

		if(selected) {
			this.dom.status.className += ' selected';
		}

		if (this.device.is_vdom_admin && (this.device.vdom != "")) {
			return this.dom;
		}

		this.dom.onmouseover = function() {
			switch (port.name) {
			case "adsl":
				var info_html =
					port.name + port.alias + "<br>" +
					"Physical Mode: " + port.phymode + "<br>" +
					"IP/Netmask:" + port.ip + "/" + port.mask + "<br>" +
					"<br>Link" + ": " + (port.link == "connected" ? "Up" : "Down");
				break;
	
			default:
				var info_html = port.id + port.alias;

				if (port.device.opmode != "transparent") { // not transparent mode
					info_html += "<br>" + "IP/Netmask:" + port.ip + "/" + port.mask;
				}

				// will work on multi-language support later and support modem/wireless interfaces
				// ie. port.link == "dialing" ---> "Dialing..."
				if (port.type != "wireless") {
					info_html += "<br>" + "Link" + ": " + (port.link == "connected" ? "Up" : "Down");
				}

				if (port.device.opmode != "transparent") { // not transparent mode
					if(port.speed >= 0)
						info_html += 	"<br>" + "Speed" + ": " + port.speed + " Mbps" + (port.duplex ? ("/" + (port.duplex == 2 ? "Full Duplex" : "Half Duplex")) : "") ;
					info_html += 	"<br>" + "Tx packets" + ":" + port.tx +
						"<br>" + "Rx packets" + ":" + port.rx;
				}
			}

			overlib(info_html, ABOVE);
		};

		this.dom.onmouseout = nd;

		return this.dom;
	};
}
