function Device(data) {
    var getFortiguardExpired = function(){
	    var expired = false;
	    var path = "/manager_redir";
	    var restApiUrl = "api/v1.0/System/Config/FortiGuard";
	    $j.ajaxSetup({ async: false});
	    $j.getJSON(path, {"uri": restApiUrl, "ip": data.ip}, function(result){
		    if(result.securityService.expired.indexOf("Expired")>=0 || 
				    result.antivirusService.anti_expired.indexOf("Expired") >= 0 ||
				    result.reputationService.reputation_expired.indexOf("Expired") >= 0 ||
				    result.credentialStuffingDefense.expired.indexOf("Expired") >= 0){
			   expired = true;
		    }
	    });
	    return expired;
    };
    this.ips = [];
    for (var key in data) {
        if ({}.hasOwnProperty.call(data, key)) {
            this[key] = data[key];
        }
        if(key == 'ip')
            this.ips.push({'ip':(data[key] === '127.0.0.1')?'*':data[key]});
    }

    this.iconType = 'text';
    this.icon = '\uf108';
    this.id = this.device_number;
    this.name = this.device_number;
    this.status = /*((this.mode=='mode_ap'&&this.role=='Server')?'mode_aa':this.mode)*/ this.mode;
    this.expired = getFortiguardExpired();

    if(this.is_current) {
        this.name += (' ('+$j.getInfo('this_host',flt_lang)+')')
    }
}

var i = 0;

manager_topology = {
    model: null ,
    fa_globe_glyph: '\uf0ac',
    fa_globe_glyph_width: 15,
    svg: '#topology_canvas',
    nodes: [],
    links: [],
    data: [],
    zoom: d3.behavior.zoom(),
    data_loaded: false,
    svg_container: '#topologyCanvasContainer',
    balloonTmpl: null ,
    balloon_deviceTmpl: null ,
    balloon_instanceTmpl: null ,
    balloonID: null ,
    reload_duration: 10000,
    host_is_master: false,
    init: function() {
        var self = this;
        //$j(self.svg_container).spin(horizon.conf.spinner_options.modal);
        if ($j('#networktopology').length === 0) {
            return;
        }
        self.data = {};
        self.data.devices = {};
        self.data.master = [];
        self.data.slaves = [];
        self.balloonTmpl = Hogan.compile($j('#balloon_container').html());
        self.balloon_deviceTmpl = Hogan.compile($j('#balloon_device').html());
        self.balloon_instanceTmpl = Hogan.compile($j('#balloon_instance').html());
        $j(document).on('click', 'a.closeTopologyBalloon', function(e) {
            e.preventDefault();
            self.delete_balloon();
        }).on('click', '.topologyBalloon', function(e) {
            e.stopPropagation();
        });
        /*$j('#toggle_labels').click(function() {
            if ($j('.nodeLabel').css('display') == 'none') {
                $j('.nodeLabel').show();
                fweb.util.persist.put('manager_show_labels', true);
            } else {
                $j('.nodeLabel').hide();
                fweb.util.persist.put('manager_show_labels', false);
            }
        });*/
        fweb.util.persist.put('manager_show_labels', true);
        //$j('#topologyCanvasContainer').spin(horizon.conf.spinner_options.modal);
        self.create_vis();
        self.loading();
        self.force_direction(0.05, 70, -700);
        self.retrieve_network_info(true);
        
    },
    retrieve_network_info: function(force_start) {
        var self = this;
        if ($j('#networktopology').length === 0) {
            return;
        }
        $j.getJSON($j('#networktopology').data('networktopology') + '?' + $j.now(), function(data) {
            self.data_loaded = true;
            self.load_topology(data);
            if (force_start) {
                var i = 0;
                self.force.start();
                while (i <= 100) {
                    self.force.tick();
                    i++;
                }
                $j('.node').qtip({
                    content: $j.getInfo('click_to_show',flt_lang),
                    position: {
                        target: 'mouse', // Track the mouse as the positioning target
                        adjust: { x: 10, y: 10 } // Offset it slightly from under the mouse
                    }
                });
            }
            setTimeout(function() {
                self.retrieve_network_info();
            }, self.reload_duration);
        });
    },
    load_config: function() {
        var labels = true;
        labels = fweb.util.persist.get('manager_show_labels');
        if (labels) {
            $j('.nodeLabel').show();
            $j('#toggle_labels').addClass('active');
        } else {
            $j('.nodeLabel').hide();
        }
        
    },
    getScreenCoords: function(x, y) {
        var self = this;
        if (self.translate) {
            var xn = self.translate[0] + x * self.zoom.scale();
            var yn = self.translate[1] + y * self.zoom.scale();
            return {
                x: xn,
                y: yn
            };
        } else {
            return {
                x: x,
                y: y
            };
        }
    },
    create_vis: function() {
        var self = this;
        $j('#topologyCanvasContainer').html('');
        self.outer_group = d3.select('#topologyCanvasContainer').append('svg').attr('width', '100%').attr('height', $j(document).height() - 40 + "px").attr('pointer-events', 'all').append('g').call(self.zoom.scaleExtent([0.1, 1.5]).on('zoom', function() {
            self.delete_balloon();
            self.vis.attr('transform', 'translate(' + d3.event.translate + ')scale(' + self.zoom.scale() + ')');
            self.translate = d3.event.translate;
        })).on('dblclick.zoom', null );
        self.outer_group.append('rect').attr('width', '100%').attr('height', '100%').attr('fill', 'white').on('click', function(d) {
            self.delete_balloon();
        });
        self.vis = self.outer_group.append('g');
    },
    loading: function() {
        var self = this;
        var load_text = self.vis.append('text').style('fill', 'black').style('font-size', '40').attr('x', '50%').attr('y', '50%').text('');
        var counter = 0;
        var timer = setInterval(function() {
            var i;
            var str = '';
            for (i = 0; i <= counter; i++) {
                str += '.';
            }
            load_text.text(str);
            if (counter >= 9) {
                counter = 0;
            } else {
                counter++;
            }
            if (self.data_loaded) {
                clearInterval(timer);
                load_text.remove();
            }
        }, 100);
    },

    force_direction: function(grav, dist, ch) {
        var self = this;
        /*$j('[data-toggle="tooltip"]').tooltip({
            container: 'body'
        });*/
        self.curve = d3.svg.line().interpolate('cardinal-closed').tension(0.85);
        self.fill = d3.scale.category10();
        self.force = d3.layout.force().gravity(grav).linkDistance(200).charge(ch).size([$j('#topologyCanvasContainer').width(), $j('#topologyCanvasContainer').height()]).nodes(self.nodes).links(self.links).on('tick', function() {
            self.vis.selectAll('g.node').attr('transform', function(d) {
                return 'translate(' + d.x + ',' + d.y + ')';
            });
            self.vis.selectAll('line.link').attr('x1', function(d) {
                return d.source.x;
            }).attr('y1', function(d) {
                return d.source.y;
            }).attr('x2', function(d) {
                return d.target.x;
            }).attr('y2', function(d) {
                return d.target.y;
            });
            
        });
    },
    new_node: function(data, x, y) {
        var self = this;
        data = {
            data: data
        };
        if (x && y) {
            data.x = x;
            data.y = y;
        }
        self.nodes.push(data);
        var node = self.vis.selectAll('g.node').data(self.nodes);
	var nodeEnter = node.enter().append('g').attr('class', 'node').style('fill', 'white').call(self.force.drag);
	var roleCircleFn = function(d){
		if(d.data.role == "Server")
			return 25;
		else
			return 20;
	};
	var translateFn = function(d){
		if(d.data.role == "Server")
			return 'translate(30, 3)';
		else
			return 'translate(25, 3)';
	};
	var colorFn = function(d){
		if(d.data.expired === true)
			return '#f0ad4e';
		else
			return 'black';
	};
        nodeEnter.append('circle').attr('class', 'frame').attr('r', roleCircleFn).style('fill', 'white').style('stroke', colorFn).style('stroke-width', 3);
        nodeEnter.append('text').style('fill', colorFn).style('font', '20px FontAwesome').attr('text-anchor', 'middle')/*.attr('dominant-baseline', 'central')*/.text(function(d) {
            return d.data.icon;
        }).attr('transform', 'scale(1) translate(0, 7)');
        nodeEnter.append('text').attr('class', 'nodeLabel').style('display', function() {
            return 'inline';
            var labels = fweb.util.persist.get('manager_show_labels');
            if (labels) {
                return 'inline';
            } else {
                return 'none';
            }
        }).style('fill', 'black').text(function(d) {
            return d.data.name;
        }).attr('transform', translateFn);
        nodeEnter.on('click', function(d) {
            self.show_balloon(d.data, d, $j(this));
        });
        nodeEnter.on('mouseover', function(d) {
            self.vis.selectAll('line.link').filter(function(z) {
                if (z.source === d || z.target === d) {
                    return true;
                } else {
                    return false;
                }
            }).style('stroke-width', '3px');
        });
        nodeEnter.on('mouseout', function() {
            self.vis.selectAll('line.link').style('stroke-width', '1px');
        });
    },
    new_link: function(source, target) {
        var self = this;
        self.links.push({
            source: source,
            target: target
        });
        //var i = 0;
        var line = self.vis.selectAll('line.link').data(self.links, function(d){return d.id || (d.id = ++i);});
        line.enter().insert('line', 'g.node').attr('class', 'link').attr('x1', function(d) {
            return d.source.x;
        }).attr('y1', function(d) {
            return d.source.y;
        }).attr('x2', function(d) {
            return d.target.x;
        }).attr('y2', function(d) {
            return d.target.y;
        }).style('stroke', 'black').style('stroke-width', 2);
    },
    find_by_id: function(id) {
        var self = this;
        var obj, _i, _len, _ref;
        _ref = self.vis.selectAll('g.node').data();
        for (_i = 0,
        _len = _ref.length; _i < _len; _i++) {
            obj = _ref[_i];
            if (obj.data.id == id) {
                return obj;
            }
        }
        return undefined;
    },
    node_in_graph: function(data, node) {
    	for (var n in data) {
            if (n == node.id) {
                return true;
            }
        }
        return false;
        
    },
    link_in_graph: function(data, node1, node2) {
    	for(var i=0;i<data.length;i++) {
            if ((data[i].source.id == node1.id &&  data[i].source.id == node2.id)
                || (data[i].source.id == node2.id &&  data[i].source.id == node1.id)){
                return true;
            }
        }
        return false;
    },
    load_topology: function(data) {
        var self = this;
        var net, _i, _netlen, _netref, rou, _j, _roulen, _rouref, port, _l, _portlen, _portref, ser, _k, _serlen, _serref, obj, vmCount;
        var change = false;
        var filterNode = function(obj) {
            return function(d) {
                return obj == d.data;
            }
            ;
        }
	self.data.master = [];
        self.data.slaves = [];
	self.links = [];
	i = 0;
        ;
        _devref = data;
        for (_k = 0,
        _devlen = _devref.length; _k < _devlen; _k++) {
            dev = _devref[_k];
            var device = new Device(dev);
	        if(device.is_current && device.role == 'Server')
                self.host_is_master = true;
            if (!self.node_in_graph(self.data.devices, device)) {
                self.new_node(device);
                change = true;
            } else {
                obj = self.find_by_id(device.id);
                
            }
            self.data.devices[device.id] = device;
            if(device.role=='Server')
                self.data.master.push(device);
            else if (device.role=='Client')
                self.data.slaves.push(device);
        }

        for (_i = 0,
        _slavelen = self.data.slaves.length; _i < _slavelen; _i++) {
            if(!self.link_in_graph(self.links, self.data.master[0], self.data.slaves[_i])){
                self.new_link(self.find_by_id(self.data.master[0].id), self.find_by_id(self.data.slaves[_i].id));
            	change = true;
            }
        };

        if (change) {
            self.force.start();
        }
        self.load_config();
    },
    show_balloon: function(d, d2, element) {
        var self = this;
        var balloonTmpl = self.balloonTmpl;
        var deviceTmpl = self.balloon_deviceTmpl;
        var instanceTmpl = self.balloon_instanceTmpl;
        var balloonID = 'bl_' + d.id;
        if (self.balloonID) {
            if (self.balloonID == balloonID) {
                self.delete_balloon();
                return;
            }
            self.delete_balloon();
        }
        self.force.stop();
        var htmlData = {
            balloon_id: balloonID,
            host_name: d.host_name,
            id: d.id,
            ip: d.ip,
            name: d.role,
            status: $j.getInfo(d.status,flt_lang),
            status_class: 'active',
            host_is_master: ((d.mode!='mode_standalone'&&self.host_is_master)?true:false),
            show_disconnect: show_disconnect,
            show_log: true,
            show_fortiguard: true,
            show_ip: ((d.mode!='mode_standalone'&&d.role!='INIT')?true:false),
            status_label: $j.getInfo('status',flt_lang),
            id_label: $j.getInfo('serial_number',flt_lang),
            host_name_label: $j.getInfo('hostname',flt_lang),
            disconnect_label: $j.getInfo('disconnect_label',flt_lang),
            view_alog_label: $j.getInfo('view_alog',flt_lang),
            view_elog_label: $j.getInfo('view_elog',flt_lang),
            view_tlog_label: $j.getInfo('view_tlog',flt_lang),
            view_fortiguard_label: $j.getInfo('view_fortiguard', flt_lang),
            ips_label: $j.getInfo('ip_addresse',flt_lang),
            priority_label: $j.getInfo('priority',flt_lang)
        };
        var html;
        if (d instanceof Device) {
            htmlData.ips = d.ips;
            htmlData.priority = d.priority;
            html = balloonTmpl.render(htmlData, {
                table1: deviceTmpl,
                table2: instanceTmpl
            });
        } 


        $j(self.svg_container).append(html);
        var devicePosition = self.getScreenCoords(d2.x, d2.y);
        var x = devicePosition.x;
        var y = devicePosition.y;
        var xoffset = 40;
        var yoffset = 10;
        $j('#' + balloonID).css({
            'left': x + xoffset + 'px',
            'top': y + yoffset + 'px'
        }).show();
        var _balloon = $j('#' + balloonID);
        if (element.x + _balloon.outerWidth() > $j(window).outerWidth()) {
            _balloon.css({
                'left': 0 + 'px'
            }).css({
                'left': (x - _balloon.outerWidth() + 'px')
            }).addClass('leftPosition');
        }

        self.balloonID = balloonID;
    },
    delete_balloon: function() {
        var self = this;
        if (self.balloonID) {
            $j('#' + self.balloonID).remove();
            self.balloonID = null ;
            self.force.start();
        }
    }

};
