(function($) {

	var options = {
		credits:{enabled:false},
		legend:{enabled:false},
		chart: {
			type: 'spline'
		},
		title: {
			text: null
		},
		xAxis: {
			categories: [],
			labels: {
				style: {'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 'fontSize': '12px'}
			}
		},
		yAxis: {
			//minRange : 40,
			title: {
				text: null
			},
			labels: {
				format: '{value:.,0f}',
				style: {'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 'fontSize': '12px'}
			}
		},
		tooltip: {
			crosshairs: true,
			shared: true,
			style: {'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 'fontSize': '15px'}
		},
		plotOptions: {
			spline: {
				marker: {
					radius: 4,
					lineColor: '#666666',
					lineWidth: 1
				}
			}
		},
		series: [{
			name: 'Hit',
			marker: {
				symbol: 'square'
			},
			data: []

		}]
	};	

	function draw_chart() {
		var policy = $("#policy_select").val();
		var time = $("#time_select").val();

		options.xAxis.categories = [];
		options.series[0].data = [];

		$.ajax({
			'url': '/system/status/policy_hit?policy='+encodeURIComponent(policy)+'&time='+encodeURIComponent(time),
			'dataType': 'json',
			'success': function(results)
			{
				var categories = [];
				var data = [];

				$.each(results, function(itemNo, item) {
					categories.push(item.time);
					data.push(item.count);
				});

				options.xAxis.categories = categories;
				options.series[0].data = data;

				$('#container').highcharts(options);
			},
			'error': function(XMLHttpRequest, textStatus)
			{
				$('#container').highcharts(options);
			},
			'cache': false
		});
	}

	$(document).ready(function() {

		$.ajax({
			'url': '/system/status/policy-list',
			'data' : { "check" : 1, "include_total": 1, "is_hit": 1},
			'dataType': 'json',
			'success': function(results)
			{
				$.each(results, function(itemNo, item) {
					"<option value=\"%s\">%s</option>\n"
					$("#policy_select").append('<option value="'+item.label+'">'+item.label+'</option>');
				});
				draw_chart();
			},
			'error': function(XMLHttpRequest, textStatus)
			{
				draw_chart();
			},
			'cache': false
		});

		$("#policy_select").change(function(){
			draw_chart();
		});
		$("#time_select").change(function(){
			draw_chart();
		});
	});
})(jQuery);
