// Create the chart
var chartPanel = (function($){

    var highchart_reset_function = Highcharts.Pointer.prototype.reset;
    var statistics_chart_name = "model-statistics-chart";// model-statistics linkage charts div class
        
    // install set line data
    function reset_data(data, xArr) {
        // red:#FF4747 blue:08CECE
        // relation : (xAxis & yAxis) (colors & series)

        /*
        *  Highcharts parallel chart number of maximum lines is 2000, More browser card dead.
        *  so there are up to 1000 allowed. Red is displayed, and the rest is Green.
        *  but chart legend show real value (num_regular,num_anomaly).
        */

        var max_num = 1000;// number of Maximum Lines
        var num_regular = 0, num_anomaly = 0;// green.red line total num
        var color = ['rgba(11, 200, 200, 0.1)','#FF4747'];//label  green: 1  red: -1 
        var yAxis_item = {min: 0,title: {text:''}};
        var yAxis_data = [];
        var colors_data = [];
        var series_data = [];

        var colors_data_green = [];
        var colors_data_red = [];
        var series_data_green = [];
        var series_data_red = [];

        data.forEach(function(item, index) {
            var v_label = item.label;
            var v_name = item.name;
            var v_data = botObj.toFloat(item.data);

            if(v_label == 1) {
                num_regular++;
                colors_data_green.push(color[0]);
                series_data_green.push({name: "L"+v_name, data: v_data, shadow: false});
            } else if (v_label == -1) {
                num_anomaly++;
                colors_data_red.push(color[1]);
                series_data_red.push({name: "L"+v_name, data: v_data, shadow: false});
            }
        });

        if(data.length > max_num) {
            if(num_anomaly > max_num) {
                colors_data_red.splice(max_num);
                series_data_red.splice(max_num);
                colors_data_green = [];
                series_data_green = [];
            } else {
                var n = max_num - num_anomaly;
                colors_data_green.splice(n);
                series_data_green.splice(n);
            }
        }
        colors_data = colors_data_green.push.apply(colors_data_green, colors_data_red);colors_data=colors_data_green;
        series_data = series_data_green.push.apply(series_data_green, series_data_red);series_data=series_data_green;

        xArr.forEach(function(item, index) {
            yAxis_data.push(yAxis_item);
        });

        return {
            yAxis_data: yAxis_data,
            colors_data: colors_data,
            series_data: series_data,
            num_regular: num_regular,
            num_anomaly: num_anomaly
        };
    }

    function makeSetLineOptions(line_data, xArr)
    {
        var options = {
            chart: {
                type: 'spline'
                ,parallelCoordinates: true
                ,parallelAxes: {
                    lineWidth: 2
                }
            },
            title: {text: ''},
            credits:{enabled:false},
            legend: {enabled: false},
            plotOptions: {
                series: {
                    animation: false,
                    marker: {
                        enabled: false,
                        states: {
                            hover: {
                                enabled: false
                            }
                        }
                    }
                }
            },
            // tooltip: {enabled: false},
            tooltip: {
                // pointFormat: '<span style="color:{point.color}">\u25CF</span>' + '{series.name}: <b>{point.formattedValue}</b><br/>'
                headerFormat: '{point.x} : <b>{point.formattedValue}</b>',
                pointFormat: ''
            },
            xAxis: {
                categories: xArr,//["TCP Connections","HTTP Requests without Referer","HTTP A","HTTP B","HTTP C","HTTP D","HTTP E"],
                offset: 10
            },
            yAxis: line_data.yAxis_data,//[{min: 0,title: {text:''}}, {min: 0,title: {text:''}}]
            colors: line_data.colors_data,
            series: line_data.series_data
        };
        return options;
        // $j(id).highcharts(options);

    }

    function initSetLine(id,xAxis_column) {
        var series_data = [];
        var yAxis_data = [];
        xAxis_column.forEach(function(item, index) {
            series_data.push(0);
            yAxis_data.push({min: 0,title: {text:''}});
        });
        var data = {
            yAxis_data: yAxis_data,
            colors_data: [],
            series_data: [{"label":1,"name":3,"data":series_data}]
        };
        Highcharts.chart(id, makeSetLineOptions(data, xAxis_column));
    }

    function drawSetLine(id, line_data, xArr) {

        Highcharts.chart(id, makeSetLineOptions(line_data, xArr));

        /* invalid why?
        var options = {
                yAxis: line_data.yAxis_data,
                colors: line_data.colors_data,
                series: line_data.series_data
            }
        ooo.update(options);*/
    }

    function drawComparisionBar(id, data1, data2) {
        data1 = resetArr(data1);
        data2 = resetArr(data2);

        var x_categories = [$j.getInfo('chart_traning_accuracy'), $j.getInfo('chart_test_accuracy'), $j.getInfo('chart_cross_validation')];
        var legend_arr = [$j.getInfo('loose'), $j.getInfo('strict')];

        var options = {
            chart: {
                type: 'column'
            },
            colors: ['#90ED7D','#7CB5EC','#99CC66'],
            title: {text: ''},
            credits:{enabled:false},
            legend: {
                align: 'center',
                verticalAlign: 'bottom',
                layout: 'horizontal'
            },
            tooltip: {
                headerFormat: '{point.x} : <b>{point.y}%</b>',//<b>{series.name}</b>
                pointFormat: ''
            },
            xAxis: {
                categories: x_categories//['Training Accuracy','Testing Accuracy','Cross Validation']
            },
            yAxis: {
                allowDecimals: false,
                title: {text:''}
            },
            series: [{
                name: legend_arr[0],//'Looser',
                data: data1//[1, 4, 3]
            }, {
                name: legend_arr[1],//'Strict',
                data: data2//[6, 4, 2]
            }]
        };
        $j(id).highcharts(options);
    
    }

    function drawTrendLine(id, data, xArr) {
        if(data == undefined || data == "") return;

        var colorArr = ['#99CC66', '#F7A55E', '#7CB5EC'];
        var xaxis = resetArr(xArr);

        $.each(data, function(i, dataset){
            data[i].color = colorArr[i];// add line color
        });

        var data1 = resetArr(data[0]);
        var data2 = resetArr(data[1]);
        var data3 = resetArr(data[2]);


        /**
         * Processing mouse influence prompt box, 
         * the prompt box of linkage chart is not hidden, the prompt box of other chart is hidden
         * 
         */
        $('.bot-status-info div').bind('mousemove', function (e) {
            var div_id = this.id;

            if(!div_id) return;

            if (div_id == id.slice(1)) {// "#trend_line"
                Highcharts.Pointer.prototype.reset = function () {return undefined;};
            } else {
                Highcharts.Pointer.prototype.reset = highchart_reset_function;
            }
        });

        /**
         * In order to synchronize tooltips and crosshairs, override the
         * built-in events with handlers defined on the parent element.
         */
        $(id).bind('mousemove touchmove touchstart', function (e) {
            var chart,
                point,
                i,
                event;
            for (i = 0; i < Highcharts.charts.length; i = i + 1) {
                if (Highcharts.charts[i] && Highcharts.charts[i].renderTo.className == statistics_chart_name){//only get linkage charts to set event
                    chart = Highcharts.charts[i];
                    event = chart.pointer.normalize(e.originalEvent); // Find coordinates within the chart
                    point = chart.series[0].searchPoint(event, true); // Get the hovered point
                    if (point) {
                        point.highlight(e);
                    }
                }
            }
        });
        /**
         * Highlight a point by showing tooltip, setting hover state and draw crosshair
         */
        Highcharts.Point.prototype.highlight = function (event) {
            this.onMouseOver(); // Show the hover marker
            // this.series.chart.tooltip.refresh(this); // Show the tooltip
            this.series.chart.xAxis[0].drawCrosshair(event, this); // Show the crosshair
        };
        /**
         * Synchronize zooming through the setExtremes event handler.
         */
        function syncExtremes(e) {
            var thisChart = this.chart;
            if (e.trigger !== 'syncExtremes') { 
                Highcharts.each(Highcharts.charts, function (chart) {
                    if (chart !== thisChart) {
                        if (chart.xAxis[0].setExtremes) { // It is null while updating
                            chart.xAxis[0].setExtremes(e.min, e.max, undefined, false, { trigger: 'syncExtremes' });
                        }
                    }
                });
            }
        }

        // draw top chart, draw down chart 
        setChart([data2,data3], xaxis, true);
        setChart([data1], xaxis, false);

        function setChart(dataArr, xaxis, disableXData) {
            var options = setChartOption(dataArr, xaxis, disableXData);
            $('<div class="' + statistics_chart_name + '">').appendTo(id).highcharts(options);
        }

        function setChartOption(dataArr, xaxis, disableXData) {
            var x_format = disableXData ? ' ' : '{value}';// 是否隐藏x轴数据
            
            var options = {
                chart: {
                    marginLeft: 40, // Keep all charts left aligned
                    spacingTop: 20,
                    spacingBottom: 20,
                    zoomType: 'x'
                },
                title: {text: null},
                credits: {
                    enabled: false
                },
                legend: {
                    enabled: false
                },
                xAxis: {
                    categories: xaxis,
                    crosshair: true,
                    events: {
                        setExtremes: syncExtremes
                    },
                    labels: {
                        format: x_format
                    }
                },
                yAxis: {
                    title: {text: null}
                },
                tooltip: {
                    crosshairs: true,
                    shared: true
                },
                series: []
            }

            dataArr.forEach(function(value, index){
                var series_item = {
                        data: value.data,
                        name: value.name,
                        type: 'spline',
                        color: value.color,
                        marker: {
                            symbol: 'circle'
                        }
                    };
                options.series[index] = series_item; 
            }); 
            
            return options;
        } 
    }

    function refreshTrendLine(id, data, xArr) {
        if(data == undefined || data == "") return;

        var xaxis = resetArr(xArr);
        var data1 = resetArr(data[0].data);// down chart data
        var data2 = resetArr(data[1].data);// top chart1 data
        var data3 = resetArr(data[2].data);// top chart2 data

        var highchart_top = $j(id +" ." + statistics_chart_name + ":nth-child(1)").highcharts();
        var highchart_down = $j(id + " ." + statistics_chart_name + ":nth-child(2)").highcharts();

        var line_xAxis_1 = highchart_top.xAxis;
        var line_seriesArr_1 = highchart_top.series;
        var line_xAxis_2 = highchart_down.xAxis;
        var line_seriesArr_2 = highchart_down.series;
        line_xAxis_1[0].setCategories(xaxis);
        line_seriesArr_1[0].setData(data2, true, false, false);
        line_seriesArr_1[1].setData(data3, true, false, false);
        line_xAxis_2[0].setCategories(xaxis);
        line_seriesArr_2[0].setData(data1, true, false, false);

    }

    function destoryHighcharts() {
        Highcharts.charts.forEach(function(value, index, arr){
            if(value) value.destroy();
        })
    }
    function clearData(id) {
        $j(id).empty();
    }

    function resetArr(data) {
        if(data == undefined || data == "")
            data = [];
        return data;
    }
    return {
        'reset_data': reset_data
        ,'initSetLine': initSetLine
        ,'drawSetLine': drawSetLine
        ,'drawComparisionBar': drawComparisionBar
        ,'drawTrendLine': drawTrendLine
        ,'refreshTrendLine': refreshTrendLine
        ,'clearData': clearData
        ,'destoryHighcharts': destoryHighcharts
    }
})(jQuery);