

$j(document).ready(function() {

    // init dialog
    $j('<div id="loading_dialog" style="display:none;"><div id="loading"><img src="/theme/images/loading.gif"></img></div></div>').appendTo($j('body'));
    loading_dialog.init({
        title: $j.getInfo("load_wait")
    });

    // init page data
    botObj.init();

});

var progress_bar = (function($){
    function initDiv(key) {
        var htmlStr = [
            '<div class="bar-warp">',
            '   <div class="bar-inner">',
            '       <div class="bar-value-a" style="width: 0%;">',
            '       </div>',
            '       <div class="bar-value-b" style="width: 100%;">',
            '       </div>',
            '   </div>',
            '   <div class="bar-value-c">0%</div>',
            '</div>',
            ].join('');

        $(key).html(htmlStr);
    }

    function resetValue(key, value) {
        value = value + '%';
        $(key+' .bar-warp .bar-value-c').html(value);
        $(key+' .bar-warp .bar-value-a').css('width', value);
    }

    function emptyDiv(key) {
        $(key).empty();
    }

    return {
        init: initDiv,
        reset_value: resetValue,
        empty: emptyDiv
    }
})(jQuery);

var loading_dialog = (function($) {
    'use strict';
    function init(option)
    {
        $("#loading_dialog").dialog({
            resizable: false,
            width: 250,
            height: 70,
            autoOpen: false,
            draggable: false,
            modal: true,
            dialogClass: "bot_loading_dialog"
        });
        $("#loading_dialog").dialog("option",option);
    }
    function show_dialog()
    {
        $("#loading_dialog").dialog("open");
    }
    function close_dialog()
    {
        $("#loading_dialog").dialog("close");
    }
    return {
        'init' : init,
        'show' : show_dialog,
        'hide': close_dialog
    };
})(jQuery);



var botObj = (function($) {
    var STATUS_COLLECTING = "Collecting";
    var STATUS_BUILDING = "Building";
    var STATUS_RUNNING = "Running";
    var STATUS_FAILURE = "Failure";

    var status_lang = {
        "None":$j.getInfo('status_none'), 
        "Collecting":$j.getInfo('status_collecting'),
        "Building":$j.getInfo('status_building'),
        "Testing":$j.getInfo('status_testing'),
        "Running":$j.getInfo('status_running'),
        "Failure":$j.getInfo('status_failure'),
        "Deleting":$j.getInfo('status_Deleting')
    };

    var LOOSE_VALUE = 1, STRICT_VALUE = 2;// STRICT_VALUE = 1,LOOSE_VALUE = 2;
    var modelArr = [$j.getInfo('loose_model'),$j.getInfo('strict_model')];// cmdb data reverse, use by switch 
    // var current_model = 1;// record current model in .titleb use by switch : Loose Strict (Moderate Model/Strict Model). move to .c

    var dataJson = "";// ajax get all data
    var refresh_time = 10000;//5000;

    var isFirstFlag = true;// fist load GUI
    var isFirstLoadEventArr = [];// fist load Events

    function init_status() {

        // diff status has diff content
        init_get_model_status();
        event_table();

        setTimeout(timeout_refresh, refresh_time);

        // reset_json  0==only status and ratio, 1== rebuild, 2==refresh
        // click [rebuildBtn]
        $("#rebuildBtn").click(function(){
            if(confirm($j.getInfo('rebuild_confirm'))) {
                init_panel(false);
                $.ajax({
                    'url': "/waf/bot_detection/reset_json",
                    'dataType': 'json',
                    'type':"POST",
                    'data':{'policy_id':policy_id, 'type': 1},
                    'success': function(response){
                        if (response && response.status == 1) {
                            dataJson = response;
                            var v_status = response.model_status;
                            current_model_status = v_status;
                            set_status_label(v_status, response.ratio);
                            if(v_status == STATUS_RUNNING) {
                                // reload_page();
                                make_data();// do not reload_page(),because event unread data need show at current page.
                            }
                        } else {
                            alert("rebuild failed");
                        }
                        
                    },
                    beforeSend: function () {
                        loading_dialog.show();
                    },
                    complete: function () {
                        loading_dialog.hide();
                    },
                    'error': function() {
                    },
                    'cache': false
                });
            }
        });

        // click [refresh]
        $("#refreshBtn").click(function(){
            if(confirm($j.getInfo('refresh_confirm'))) {
                init_panel(false);
                $.ajax({
                    'url': "/waf/bot_detection/reset_json",
                    'dataType': 'json',
                    'type':"POST",
                    'data':{'policy_id':policy_id, 'type': 2},
                    'success': function(response){
                        if (response && response.status == 1) {
                            var v_status = response.model_status;
                            current_model_status = v_status;
                            set_status_label(v_status, response.ratio);
                            if(v_status == STATUS_RUNNING) {
                                // reload_page();
                                make_data();// do not reload_page(),because event unread data need show at current page.
                            }
                        } else {
                            alert("refresh failed");
                        }
                        
                    },
                    beforeSend: function () {
                        loading_dialog.show();
                    },
                    complete: function () {
                        loading_dialog.hide();
                    },
                    'error': function() {
                    },
                    'cache': false
                });
            }
        });

        // click [Training Set][Testing Set]
        $("input[name='model_set_type']").click(function(){
            /*var tab_value = $( this ).val();
            if (tab_value == 1) {
                $("#train_line").show();
                $("#test_line").hide();
                change_model_set_legend_num(dataJson.train_num_regular, dataJson.train_num_anomaly);
            } else {
                $("#train_line").hide();
                $("#test_line").show();
                change_model_set_legend_num(dataJson.test_num_regular, dataJson.test_num_anomaly);
            }*/
            change_model_set_line();
        });

        // click switch '< Loose Model >'
        $("#switch_up").click(function(){
            current_model = parseInt(current_model);
            if (current_model <= 1) return;
            current_model = current_model-1;
            use_model_value_change_page_data(current_model);
        });
        $("#switch_down").click(function(){
            current_model = parseInt(current_model);
            if (current_model >= modelArr.length) return;
            current_model = current_model+1;
            use_model_value_change_page_data(current_model);
        });
    }

    function init_get_model_status() {
        $.ajax({
            'url': "/waf/bot_detection/reset_json",
            'dataType': 'json',
            'type':"POST",
            'data':{'policy_id':policy_id, 'type': 0},
            'success': function(response){
                if (response && response.status == 1) {
                    var v_status = response.model_status;
                    current_model_status = v_status;

                    set_status_label(v_status, response.ratio);

                    if(v_status == STATUS_RUNNING) {
                        make_data();
                    } 
                } 
            },
            beforeSend: function () {
                // loading_dialog.show();
            },
            complete: function () {
                // loading_dialog.hide();
            },
            'error': function() {
            },
            'cache': false
        });
    }

    // diff status page has diff content
    function reset_get_model_status() {
        $.ajax({
            'url': "/waf/bot_detection/reset_json",
            'dataType': 'json',
            'type':"POST",
            'data':{'policy_id':policy_id, 'type': 0},
            'success': function(response){
                if (response && response.status == 1) {
                    var v_status = response.model_status;
                    current_model_status = v_status;
                    
                    if(v_status == STATUS_RUNNING) {
                        set_status_label_2(v_status, response.ratio);//only this use
                        // reload_page();
                        make_data();//do not reload_page(),because event unread data need show at current page.
                    } else {
                        set_status_label(v_status, response.ratio);
                    } 

                } 
            },
            beforeSend: function () {
                // loading_dialog.show();
            },
            complete: function () {
                // loading_dialog.hide();
            },
            'error': function() {
            },
            'cache': false
        });
    }
    function reload_page() {
        window.location.reload();
    }

    // update cmdb model_status or model_selected
    function update_bot_attr(key,value) {
        var dataObj = {
            'update': 1, 
            'policy_id':policy_id, 
            'mkey':mkey
        }
        dataObj[key] = value;

        $.ajax({
            'url': "/waf/ml_bot_detection_policy/model_status",
            'dataType': 'json',
            'type':"POST",
            'data': dataObj,
            'success': function(response){
                // error info
                if (response && response.status != 0) {
                    alert($j.getInfo(response.status));
                } 
            },
            beforeSend: function () {
                loading_dialog.show();
            },
            complete: function () {
                loading_dialog.hide();
            },
            'error': function() {
            },
            'cache': false
        });
    }

    // click status radio event
    function update_status(obj) {
        update_bot_attr("model_status",(obj.checked ? 1 : 0));
    }

    function use_model_value_change_page_data(value) {
        change_model_title(value);

        var train_line_data = "", test_line_data = "", percent_data = "";

        if (value == LOOSE_VALUE) {
            train_line_data = dataJson.loose_training_set;
            test_line_data = dataJson.loose_test_set;

            percent_data = dataJson.loose_model_comparison;
        } else {
            train_line_data = dataJson.strict_training_set;
            test_line_data = dataJson.strict_test_set;

            percent_data = dataJson.strict_model_comparison;
        }

        // 1. set-line percent show num
        change_model_set_percent('#set_percent', percent_data);

        // 2. set-line legend show num  (dataJson object add obj_train obj_test attribute to use for legend etc.)
        var obj_train = chartPanel.reset_data(train_line_data, dataJson.column_name);
        var obj_test =chartPanel.reset_data(test_line_data, dataJson.column_name);

        dataJson.obj_train = obj_train;
        dataJson.obj_test = obj_test;

        change_model_set_line();

        // if(obj_train) {
        //     dataJson.train_num_regular = obj_train.num_regular;
        //     dataJson.train_num_anomaly = obj_train.num_anomaly;
        // }
        // if(obj_test) {
        //     dataJson.test_num_regular = obj_test.num_regular;
        //     dataJson.test_num_anomaly = obj_test.num_anomaly;
        // }
        // var set_line_model_value = $("input[name='model_set_type']:checked").val();
        // if(set_line_model_value == 1) {
        //     change_model_set_legend_num(dataJson.train_num_regular, dataJson.train_num_anomaly);
        // } else {
        //     change_model_set_legend_num(dataJson.test_num_regular, dataJson.test_num_anomaly);
        // }

        // 3. set-line line  (setTimeout resolve slow card)
        // setTimeout(function() {
        //     change_model_set_line(obj_train, obj_test, dataJson.column_name);
        // });
    }

    // change switch model title 
    function change_model_title(value) {
        current_model = parseInt(value);

        // change switch title
        $("#titleb_model").html(modelArr[current_model-1]);

        var enable_color = "#333333";
        var disable_color = "#beb8b8";
        if (current_model == 1) {
            $("#switch_up").attr({disabled: "disabled"});
            $("#switch_up f-icon").css({color: disable_color});
            $("#switch_down").removeAttr('disabled');
            $("#switch_down f-icon").css({color: enable_color});
        } else if (current_model == modelArr.length) {
            $("#switch_up").removeAttr('disabled');
            $("#switch_up f-icon").css({color: enable_color});
            $("#switch_down").attr({disabled: "disabled"});
            $("#switch_down f-icon").css({color: disable_color});
        } else {
            $("#switch_up").removeAttr('disabled');
            $("#switch_down").removeAttr('disabled');
            $("#switch_up f-icon").css({color: enable_color});
            $("#switch_down f-icon").css({color: enable_color});
        }

    }

    // function change_model_set_line(train_line_data, test_line_data, column_name) {
    //     chartPanel.drawSetLine('#train_line', train_line_data, column_name);
    //     chartPanel.drawSetLine('#test_line', test_line_data, column_name);
    // }

    // var train_chart,test_chart;
    function change_model_set_line() {
        
        var tab_value = $("input[name='model_set_type']:checked").val();
        if (tab_value == 1) {
            $("#train_line").show();
            $("#test_line").hide();
            change_model_set_legend_num(dataJson.obj_train.num_regular, dataJson.obj_train.num_anomaly);
            chartPanel.initSetLine('train_line', dataJson.column_name);
            setTimeout(function() {
                chartPanel.drawSetLine('train_line', dataJson.obj_train, dataJson.column_name);  
            });
        } else {
            $("#train_line").hide();
            $("#test_line").show();
            change_model_set_legend_num(dataJson.obj_test.num_regular, dataJson.obj_test.num_anomaly);
            chartPanel.initSetLine('test_line', dataJson.column_name);
            setTimeout(function() {
                chartPanel.drawSetLine('test_line', dataJson.obj_test, dataJson.column_name); 
            });
        }
        
    }

    function change_model_set_legend_num(num_regular,num_anomaly) {
        $("#num_regular").html(num_regular);
        $("#num_anomaly").html(num_anomaly);
    }

    function change_model_set_percent(id, arr) {
        $(id+" span:eq(0)").html(arr[0]);
        $(id+" span:eq(1)").html(arr[1]);
        $(id+" span:eq(2)").html(arr[2]);
    }

    function toFloat(arr) {
        if(arr == undefined || arr == "") return;
        arr.forEach(function(item, index, arr0) {
            var num = parseFloat(item);
            arr0[index] = Math.round(num * 100) / 100;
        });
        return arr;
    }

    function clear_data() {
        dataJson = "";

        change_model_set_percent('#set_percent', ["_","_","_"]);

        chartPanel.destoryHighcharts();
        chartPanel.clearData('#train_line');
        chartPanel.clearData('#test_line');
        chartPanel.clearData('#trend_line');
    }

    // only reset status and progress
    function set_status_label_2(v_status, v_ratio) {
        //1.
        reset_status_span(v_status);

        //2.
        reset_status_progress_enable(true, v_status, v_ratio);
    }

    function set_status_label(v_status, v_ratio) {
        //1.
        reset_status_span(v_status);

        //2.
        var status_radio_enable = false;
        var status_progress_enable = false;
        var rebuild_btn_enable = true;
        var chart_enable = false;
        
        if(write_only) {
            if(v_status == STATUS_RUNNING) {
                status_radio_enable = true;
                chart_enable = true;
            } else if(v_status == STATUS_COLLECTING){
                rebuild_btn_enable = false;
                status_progress_enable = true;
            } else if(v_status == STATUS_BUILDING){
                status_progress_enable = true;
            } else {
                
            }
        } else {//read only

            rebuild_btn_enable = false;

            if(v_status == STATUS_RUNNING) {
                status_radio_enable = false;
                chart_enable = true;
            } else if(v_status == STATUS_COLLECTING){
                status_progress_enable = true;
            } else if(v_status == STATUS_BUILDING){
                status_progress_enable = true;
            } else {
                
            }
        }


        if(rebuild_btn_enable) {
            $("#rebuildBtn").removeAttr("disabled");
        } else {
            $("#rebuildBtn").attr({ disabled: "disabled"});
        }

        if(status_radio_enable) {
            // $("#statusRadio").css("display","");
            $("#status").removeAttr("disabled");
        } else {
            // $("#statusRadio").css("display","none");
            $("#status").attr({ disabled: "disabled"});
        }
        
        reset_status_progress_enable(status_progress_enable, v_status, v_ratio);

        init_panel(chart_enable);

    }
    function reset_status_span(v_status) {
        $("#statusSpan").html(status_lang[v_status]);
    }
    function reset_status_progress_enable(flag_enable, v_status, v_ratio) {
        if(flag_enable) {
            progress_bar.init("#statusProgress");
            progress_bar.reset_value("#statusProgress", v_ratio);// only value no %
        } else {
            progress_bar.empty("#statusProgress");
            var html_str = "";
            if(v_status == STATUS_RUNNING) {
                html_str = '<f-icon class="fa-check"></f-icon>';
            } else if(v_status == STATUS_FAILURE) {
                html_str = '<f-icon class="fa-dismiss"></f-icon>';
            }
            $("#statusProgress").append(html_str);
        }
    }
    function init_panel(chart_enable) {
        if(chart_enable) {
            $(".bot-status-info").show();
        } else {
            $(".bot-status-info").hide();
        }
    }


    function get_trend_line_data() {
        $.ajax({
            'url': "/waf/bot_detection/model_json",
            'dataType': 'json',
            'type':"POST",
            'data':{'policy_id':policy_id, 'type':'statistics'},
            'success': function(response){
                // test data
                // response = chart_trend_data_test;

                if (response && response.status == 1) {
                    //1.
                    set_status_label(response.model_status, response.ratio);
                    //2.
                    current_model_status = response.model_status;
                    if(response.model_status == STATUS_RUNNING) {
                        chartPanel.refreshTrendLine('#trend_line', response.anomaly_trend_line.series, response.anomaly_trend_line.xaxis);
                    } 
                }

            },
            'error': function() {
            },
            'cache': false
        });
    }

    // get all page data
    function make_data() {
        clear_data();

        $.ajax({
            'url': "/waf/bot_detection/model_json",
            'dataType': 'json',
            'type':"POST",
            'data':{'policy_id':policy_id,'type':'all'},
            'success': function(response){
                // test data
                // response = chart_data_test;

                loading_dialog.hide();
                if (response && response.status == 1) {
                    response.loose_model_comparison = toFloat(response.loose_model_comparison);
                    response.strict_model_comparison = toFloat(response.strict_model_comparison);
                    dataJson = response;
                    current_model_status = response.model_status;
                    //1.
                    set_status_label(response.model_status, response.ratio);
                    //2.
                    if(response.model_status == STATUS_RUNNING) {
                        
                        use_model_value_change_page_data(current_model);

                        chartPanel.drawTrendLine('#trend_line', response.anomaly_trend_line.series, response.anomaly_trend_line.xaxis);
                    }
                }
            },
            beforeSend: function () {
                loading_dialog.show();
            },
            complete: function () {
                loading_dialog.hide();
            },
            'error': function() {
            },
            'cache': false
        });
    }

    // get event table data
    function event_table() {
        $j.ajax({
            'url': "/waf/bot_detection/event_json",
            'dataType': 'json',
            'type':"POST",
            'data':{'policy_id':policy_id},
            'success': function(response){
                // test data
                // response = event_data_test;

                // show event div area
                if(response.status){
                    show_event(response.results);
                }
                isFirstFlag = false;
            },
            'error': function() {
            },
            'cache': false
        });
    }

    function show_event(events) {
        /** if first enter current page,need record events data, 
          * then tiemout_refresh() get data everytime, need to update hava_read value.
          *     1.include record events data  if have_read is 'unread' new refresh data have_read is 'read', need show sign 'read' to 'unread'
          *     2.not include record events data need show sign 'read' to 'unread'
          */
        if(isFirstFlag) {
            isFirstLoadEventArr = events;
        }

        var icon_class = ['ftnt-settings', 'ftnt-collectings', 'fa-puzzle-piece', 'fa-rocket', 'fa-refresh', 'fa-undo', 'ftnt-no'];// e.type  0~6
        var signRead_class = ['unread', 'read'];// e.have_read  0: unread 1:read

        $j('.table_wrap').empty();
        for (var i = 0; i < events.length; i++) {

            var e = events[i];
            var msg = ['Model status changed ',
                'from ',
                e.from,
                ' to ',
                e.to,
                ' by ',
                e.source,
                '. ',
                e.reason,//[e.reason[0].toLowerCase(),e.reason.substr(1)].join(''),
                '.'].join('');

            // update hava_read
            var in_flag = false;// record if in the isFirstLoadEventArr
            var h_r = '';
            isFirstLoadEventArr.forEach(function(value, index){
                if(value.id == e.id) {
                    in_flag = true;
                    h_r = value.have_read;
                }
            });
            if(in_flag) {
                e.have_read = h_r == 0 ?  0 : e.have_read;
            } else {
                e.have_read = 0;
            }

            var isFontWeight = e.have_read == 0 ? 'unread-ft' : 'read-ft';// text font style
            var row = ['<div class="notice">',
                        '<div class="flex-item-b t-border b-wt ', signRead_class[e.have_read], '">',
                            '<f-icon class="', icon_class[e.type], ' ', isFontWeight,'"></f-icon>',
                        '</div>',
                        '<div class="flex-item-a t-border ', signRead_class[e.have_read], '">',
                            '<span class="item-text ', isFontWeight,'">', escapeHTML(msg),'</span>',
                        '</div>',
                        '<div class="flex-item-b t-border ', signRead_class[e.have_read], '">',
                            '<span class="item-text ', isFontWeight,'">', e.time_stamp,'</span>',
                        '</div>',
                      '</div>'].join('');
            $j('.table_wrap').append(row);
        }
    }

    // page timer
    function timeout_refresh() {
        // 1. event table
        event_table();

        // 2. anomaly trend line refresh data
        var obj = document.getElementById('status');
        if (obj.checked && current_model_status == STATUS_RUNNING) {
            get_trend_line_data();
        }

        // 3. when model_status is not Running ,refresh model_status. (1).cmdb can change model_status (2).click [refresh] or [rebuild] btn can change model_status 
        if(current_model_status != STATUS_RUNNING) { 
            reset_get_model_status();
        }
        // notice:when create page html,must set var current_model_status,not use ajax reset this value,because asynchronous never get here.

        setTimeout(timeout_refresh, refresh_time);
    }

    return {
        init: init_status
        ,toFloat: toFloat
        ,update_status: update_status
        // ,update_model: update_model
    }

})(jQuery);

// var event_data_test = {"status":1,"results":[{"time_stamp":"2018-12-17 18:28:48","from":"Collecting","to":"Building","source":"FortiWeb daemon","reason":"Model samples were collected successfully","type":0,"have_read":0},{"time_stamp":"2018-12-17 18:28:42","from":"Running","to":"Collecting","source":"FortiWeb GUI","reason":"Model was refreshed","type":1,"have_read":0},{"time_stamp":"2018-12-17 18:27:31","from":"Building","to":"Running","source":"FortiWeb daemon","reason":"Model was built successfully","type":2,"have_read":0},{"time_stamp":"2018-12-17 18:26:50","from":"Collecting","to":"Building","source":"FortiWeb daemon","reason":"Model samples were collected successfully","type":3,"have_read":1},{"time_stamp":"2018-12-17 18:18:00","from":"Running","to":"Collecting","source":"FortiWeb GUI","reason":"Model was refreshed","type":4,"have_read":1},{"time_stamp":"2018-12-17 18:17:22","from":"Building","to":"Running","source":"FortiWeb daemon","reason":"Model was built successfully","type":5,"have_read":1},{"time_stamp":"2018-12-17 18:16:41","from":"Running","to":"Building","source":"FortiWeb GUI","reason":"Model was rebuilt","type":6,"have_read":1}]};
// var event_data_test = {"status":1,"results":[{"time_stamp":"2018-09-29 18:06:48","from":"Building","to":"Running","source":"FortiWeb daemon","reason":"Build successfully"},{"time_stamp":"2018-09-29 18:05:21","from":"Collecting","to":"Building","source":"FortiWeb daemon","reason":"Collect successfully"},{"time_stamp":"2018-09-29 17:56:52","from":"None","to":"Collecting","source":"FortiWeb GUI","reason":"New bot detection policy created"},{"time_stamp":"2018-09-29 18:06:48","from":"Building","to":"Running","source":"FortiWeb daemon","reason":"Build successfully"},{"time_stamp":"2018-09-29 18:05:21","from":"Collecting","to":"Building","source":"FortiWeb daemon","reason":"Collect successfully"},{"time_stamp":"2018-09-29 17:56:52","from":"None","to":"Collecting","source":"FortiWeb GUI","reason":"New bot detection policy created"},{"time_stamp":"2018-09-29 18:06:48","from":"Building","to":"Running","source":"FortiWeb daemon","reason":"Build successfully"},{"time_stamp":"2018-09-29 18:05:21","from":"Collecting","to":"Building","source":"FortiWeb daemon","reason":"Collect successfully"},{"time_stamp":"2018-09-29 17:56:52","from":"None","to":"Collecting","source":"FortiWeb GUI","reason":"New bot detection policy created"},{"time_stamp":"2018-09-29 18:05:21","from":"Collecting","to":"Building","source":"FortiWeb daemon","reason":"Collect successfully"},{"time_stamp":"2018-09-29 17:56:52","from":"None","to":"Collecting","source":"FortiWeb GUI","reason":"New bot detection policy created"},{"time_stamp":"2018-09-29 18:06:48","from":"Building","to":"Running","source":"FortiWeb daemon","reason":"Build successfully"},{"time_stamp":"2018-09-29 18:05:21","from":"Collecting","to":"Building","source":"FortiWeb daemon","reason":"Collect successfully"},{"time_stamp":"2018-09-29 17:56:52","from":"None","to":"Collecting","source":"FortiWeb GUI","reason":"New bot detection policy created"}]};

// var chart_data_test = {"status":1,"model_status":"Running","ratio":100,"column_name":["TCP Connection","HTTP Request","HTTP Head Methods","HTTP Error Responses","HTTP Requests without Referer","HTML Pages","Javascript/CSS Responses","JSON/XML Resources","Request for robots.txt","Seconds with Throughput","Average Duration with Throughput"],"loose_model_comparison":["98.269","97.1888","98.1358"],"loose_training_set":[{"label":-1,"name":1,"data":["14","70","0","16","0","70","0","0","0","68","1.15"]},{"label":-1,"name":1,"data":["14","70","0","16","0","70","0","0","0","68","1.15"]},{"label":1,"name":2,"data":["35","85","0","47","0","83","0","0","0","76","1.81"]}],"loose_test_set":[{"label":-1,"name":16,"data":["2","2","2","0","0","2","0","0","0","2","1"]},{"label":-1,"name":18,"data":["58","193","0","121","1","190","0","0","0","174","3.41"]}],"strict_model_comparison":["98.0027","96.3855","96.0053"],"strict_training_set":[{"label":-1,"name":1,"data":["14","70","0","16","0","70","0","0","0","68","1.15"]},{"label":-1,"name":2,"data":["35","85","0","47","0","83","0","0","0","76","1.81"]}],"strict_test_set":[{"label":1,"name":16,"data":["2","2","2","0","0","2","0","0","0","2","1"]},{"label":1,"name":18,"data":["58","193","0","121","1","190","0","0","0","174","3.41"]}],"anomaly_trend_line":{"series":[{"name":"Traffic trend","data":[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]},{"name":"Anomaly Trend","data":[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]},{"name":"Confirmed Bots","data":[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]}],"xaxis":["09 18","09 19","09 20","09 21","09 22","09 23","10 00","10 01","10 02","10 03","10 04","10 05","10 06","10 07","10 08","10 09","10 10","10 11","10 12","10 13","10 14","10 15","10 16","10 17"]}};

// var reset_data_test = { "status": 1, "model_status": "Building", "ratio": 10 };

// var chart_trend_data_test = {"status":1,"model_status":"Running","ratio":100,"anomaly_trend_line":{"series":[{"name":"Traffic trend","data":[10,530,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,10,10]},{"name":"Anomaly Trend","data":[0,10,10,10,0,0,0,0,0,0,20,30,0,0,0,0,0,0,0,0,0,0,0,0]},{"name":"Confirmed Bots","data":[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]}],"xaxis":["2018-10-11 01","2018-10-11 02","2018-10-11 03","2018-10-11 04","2018-10-11 05","2018-10-11 06","2018-10-11 07","2018-10-11 08","2018-10-11 09","2018-10-11 10","2018-10-11 11","2018-10-11 12","2018-10-11 13","2018-10-11 14","2018-10-11 15","2018-10-11 16","2018-10-11 17","2018-10-11 18","2018-10-11 19","2018-10-11 20","2018-10-11 21","2018-10-11 22","2018-10-11 23","2018-10-12 00"]}};
