// Create the chart

var hmmPanel = (function(){
    var all_zero = false;
    function processData(data) {
        var empty = true;
        var total = 0;
        data.forEach(function(e){
            total += e.y;              
        });
        
        if(total != 0){ empty = false; }    
        if(empty)
        {
            all_zero = true;
            data.forEach(function(e){ e.y = 0.0001; });
        } else {
            all_zero = false;
        }

        return data;
    }
    function draw(data,innerSize,id)
    {

        var commonData;
        commonData = processData(data)
        var options = {
            title: {
                text: ''
            },
            colors: ['#92E9E0', '#7BB5EB', '#EAB5B1', '#EEA35F', '#E9595F'],
            subtitle: {
                text: ''
            },
            chart: {
                plotBackgroundColor: null,
                plotBorderWidth: null,
                plotShadow: false,
                type: 'pie'
            },
            xAxis: {
                type: 'category',
                 title: {
                    text: ''
                }
            },
            yAxis: {       
                    title: {text:''}
            },
            legend: {
                layout: 'vertical',
                align: 'right',
                verticalAlign: 'middle'
            },
            credits:{enabled:false},
            plotOptions: {
                pie: {
                    allowPointSelect: true,
                    cursor: 'pointer',
                    dataLabels: {
                        enabled: false
                    },
                    showInLegend: true
                }
            },
            tooltip: {
                headerFormat: '',
                pointFormat: all_zero?'<span style="color:{point.color}">{point.name}</span>: <b>0</b><br/>':'<span style="color:{point.color}">{point.name}</span>: <b>{point.y}</b><br/>'
            },

            series: [{
                name: 'Brands',
                colorByPoint: true,
                innerSize: innerSize,
                data: commonData
            }]
        };
        $j(id).highcharts(options);

    }

    return {
        'drawHmm':draw
    }
})(jQuery);