// Create the chart

var top10Panel = (function(){

    function draw(data)
    {
        var options = {
            title: {
                text: ''
            },
            colors: ['#7CB5EC','#EAB5B1','#434348','#90ED7D','#F7A35D','#8085E9','#30C7EC','#31FFEC','#FFD600','#FF77A7'],
            subtitle: {
                text: ''
            },
            chart: {
                type: 'column'
            },
            xAxis: {
                type: 'category',
                 title: {
                    text: ''
                },
                labels:{
                    enabled: false
                }
            },
            yAxis: {       
                    title: {text:''}
            },
            legend: {
                enabled: false
            },
            credits:{enabled:false},
            plotOptions: {
                series: {
                    borderWidth: 0,
                    pointWidth: 20,
                    dataLabels: {
                        enabled: true,
                        format: '{point.y}'
                    }
                }
            },

            tooltip: {
                headerFormat: '',
                pointFormat: '<span style="color:{point.color}">{point.name}</span>: <b>{point.y}</b><br/>'
            },

            series: [{
                name: 'Brands',
                colorByPoint: true,
                data: data
            }]
        };
        $j('#top10_chart').highcharts(options);

    }

    return {
        'drawTop10':draw
    }
})(jQuery);