// Create the chart

var trendPanel = (function(){

    function draw(series,categories,id,colors)
    {
        var options = {
            title: {
                text: ''
            },
            colors: colors,
            subtitle: {
                text: ''
            },
            xAxis: {
                categories:categories,
                labels:{
                    enabled: false
                }
            },
            yAxis: {       
                    title: {text:''}
            },
            legend: {
                layout: 'vertical',
                align: 'right',
                verticalAlign: 'top'
            },
            credits:{enabled:false},
            plotOptions: {
                series: {
                    label: {
                        connectorAllowed: false
                    },
                    lineWidth: 1,
                    //pointStart: pointStart
                }
            },
            tooltip: {
                //headerFormat: '',
                pointFormat: '<span style="color:{point.color}"></span> <b>{series.name}: {point.y}</b><br/>',
        		shared: true
            },

            series: series,

            responsive: {
                rules: [{
                    condition: {
                        maxWidth: 500
                    },
                    chartOptions: {
                        legend: {
                            layout: 'horizontal',
                            align: 'center',
                            verticalAlign: 'bottom'
                        }
                    }
                }]
            }
        };
        $j(id).highcharts(options);

    }

    return {
        'drawTrend':draw
    }
})(jQuery);