/**
 * Attack chart on dashboard;
 * */

(function($, _) {

	// var FTVW_MSG_STAT_SUB_ATTACK   = 1,
	// 	FTVW_MSG_STAT_SUB_TRAFFIC  = 2,
	// 	FTVW_MSG_STAT_SUB_TEND_A   = 3,
	// 	FTVW_MSG_STAT_SUB_TEND_T   = 4,
	// 	FTVW_MSG_STAT_SUB_FABRIC_A = 5,
	// 	FTVW_MSG_STAT_SUB_FABRIC_T = 6;

	var FORTIVIEW_DATA_TIMEOUT = 50 * 60 * 1000; // timeout in milliseconds

	var rest_url = '/rest_redir?uri=';

	var urls = {
		"signature":  "/system/status/policy_attack",
		"hpc": "/system/status/hpc_attack",
		"file_upload" : "/system/status/file_upload_attack"
	};

	var drilldown_info = {
		available_items: ['policy', 'src', 'time']
	};

	var color_mapping = {};
	var threat_level_color_mapping = {
		'Critical': 'rgb(217, 83, 79)',//'rgb(243, 46, 43)',
		'High': 'rgb(226, 135, 34)',//'rgb(255, 202, 92)',
		'Medium': 'rgb(243, 187, 45)',//'rgb(250, 255, 165)',
		'Low': 'rgb(255, 228, 90)',//'rgb(212, 251, 255)',
		// 'Off': 'rgb(192, 192, 192)'
	};
	var threat_level_values = _.map(threat_level_color_mapping, function(value, key){
		return key;
	});

	var start_time, time_offset;

	var abort_url = '/ng/fortiview/clear';
	function send_abort_request() {
		$.ajax({
			type: 'GET',
			url: abort_url,
			async: false // required, otherwise browser shows "Failed to load response data"
		});
	}

	$(window).on('unload', function(event){
		send_abort_request();
	});

	var request_count = 0;
	function increase_count() {
		request_count++;
		if (request_count > 0) {
			show_loading('body');
		}
	}
	function decrease_count() {
		request_count--;
		if (request_count == 0) {
			hide_loading('body');
		}
	}

	function init_menu()
	{
		var time_array = ['1', '12', '48', '1week'];
		var type_array = ['threat_level', 'attack_type'];
		var timeDiv= $('#time');
		var typeDiv = $('#table_type');

		function setup_time_menu()
		{
			var select = document.createElement("select");
			select.setAttribute("name", "time");
			$(select).bind("change", function(){
				change_menu();
			});

			$.each(time_array, function(index, elem){
				var opt = document.createElement("option");
				opt.setAttribute("value", elem);
				if (elem == '1') {
					opt.innerHTML = elem + ' ' + $.getInfo("1hour", flt_lang);
				} else if (elem == '1week') {
					opt.setAttribute("value", 7*24);
					opt.innerHTML = $.getInfo('1week', flt_lang);
				} else {
					opt.innerHTML = elem + ' ' + $.getInfo("hours", flt_lang);
				}
				select.appendChild(opt);
			});
			timeDiv.append(select);
		}
		setup_time_menu();
		
		function setup_table_select_menu()
		{
			var table_select = document.createElement("select");
			table_select.setAttribute("name", "tableType");
			$(table_select).bind("change", function(){
				change_menu();
			});
			$.each(type_array, function(index, elem){
				var opt;
				opt = document.createElement("option");
				opt.setAttribute("value", elem);
				opt.innerHTML = $.getInfo(elem, flt_lang);
				table_select.appendChild(opt);

			});
			typeDiv.append(table_select);
		}
		setup_table_select_menu();

		// function setup_policy_menu(data, textStatus)
		// {
		// 	var policy_select = document.createElement("select");
		// 	policy_select.setAttribute("name", "policy");
		// 	policy_select.setAttribute('style', 'width:170px');
		// 	$(policy_select).bind("change", function(){
		// 		change_menu();
		// 	});

		// 	$.each(data, function (index, arg) {
		// 		var opt;
		// 		opt = document.createElement('option');
		// 		opt.setAttribute("value", arg.label);
		// 		opt.innerHTML = arg.label;
		// 		policy_select.appendChild(opt);
		// 	});

		// 	policyDiv.append(policy_select);
		// }

		// $.ajax({
		//             "url" : '/system/status/policy-list',
		//             "data" : { "check" : 1, "include_total": 1, "is_attack": 1},
		//             "dataType" : "json",
		//             "success" : setup_policy_menu,
		//             "cache" : false
		// });
		function change_menu()
		{
			var time = document.getElementsByName("time")[0].value;
			// var policy = document.getElementsByName("policy")[0].value;
			var url;
			var chart_func;
			/*
			var table = document.getElementsByName("tableType")[0].value;
			if(table === "signature") {
				url = urls.signature;
				chart_func = display_signature_chart;
			} 
			else if(table === "hpc")
			{
				url = urls.hpc;
				chart_func = display_hpc_chart;
			}
			else if(table === "file_upload")
			{
				url = urls.file_upload;
				chart_func = display_file_upload_chart;
			}
			*/
			url = urls.signature;
			chart_func = display_signature_chart;
			menu_selection_handler(url, chart_func, time/*, encodeURIComponent(policy)*/);
		}
	}

	init_menu();

	function display_signature_chart(result, textStatus){
		if (result.sum == undefined || result.sum.graph == undefined) {
			result.sum = {
				graph: []
			};
		}
		if (result.types == undefined) {
			result.types = [''];
		}
		// var data = result.types;
		// var series = [];
		// var tmp_data = 0;
		// var i = 0, j =0, k=0;
		var all_field = [];
		var alerts_by = $('[name=tableType]').val();
		// $.each(data, function(index, obj) {
		// 	var t = {};
		// 	t.name = obj[alerts_by];
		// 	t.data = [];
		// 	t.data.push(obj.TNumber?parseInt(obj.TNumber):"");
		// 	series.push(t);

		// 	if(t.name in all_field) return;
		// 	all_field.push(t.name);
		// });
		/*
		$.each(data, function(index, obj){
			var x = {}, t={};
			if(index === 0  || index === 2 || index ===4)
			{
				var extObj = data[index+1];
				tmp_data = obj.data + extObj.data;
				x.name = obj.name;
				x.data = [];
				x.data.push(tmp_data?tmp_data:'');
				series.push(x);
			}
			else if(index === 1 || index ===3 || index ===5)
			{
			}
			else
			{
				t.name = obj.name;
				t.data = [];
				t.data.push(obj.data?obj.data:'');
				series.push(t);
			}
		});
		*/

		// $('#attack_container').highcharts({
		// 	chart: {
		// 		type: 'bar'
		// 	},
		// 	title: {
		// 		text: ''
		// 	},
		// 	subtitle: {
		// 		text: ''
		// 	},
		// 	exporting: {
		// 		enabled : false
		// 	},
		// 	xAxis: {
		// 		categories: [],
		// 		labels: {
		// 			enabled: false
		// 		},
		// 		lineWidth: 1,
		// 		tickWidth: 0
		// 	},
		// 	yAxis: {
		// 		title: {
		// 			enabled: false 
		// 		},
		// 		min: 0,
		// 		lineWidth: 1,
		// 		tickWidth: 1
		// 	},
		// 	legend: {
		// 		itemWidth:  170,
		// 		style: {'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 'fontSize': '15px'}
		// 	},
		// 	tooltip: {
		// 		style: {'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 'fontSize': '15px'},
		// 		shared: false,
		// 		formatter: function(){
		// 			return '<b>' + this.series.name + ': ' + this.y + '</b>';
		// 		}
		// 	},
		// 	plotOptions: {
		// 		bar: {
		// 			dataLabels: {
		// 				enabled: true,
		// 				style: {'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 'fontSize': '15px'},
		// 				allowOverlap: true
		// 			}
		// 		}
		// 	},
		// 	credits: {
		// 		enabled: false
		// 	},
		// 	series: series
		// });

		var graph = result.sum.graph;
		var series1 = [], cats = [];
		var special_fields = ['count', 'time', 'time_str'];
		if (alerts_by == 'threat_level') {
			all_field = threat_level_values;
		}
		$.each(graph, function(index, obj) {
			cats.push(obj.time_str);

			if (alerts_by != 'threat_level') {
				_.each(obj, function(value, key){
					if (_.contains(special_fields, key))
						return;

					if (_.contains(all_field, key))
						return;

					all_field.push(key);
				});
			}
		});

		if (all_field.length == 0) {
			all_field = result.types;
		}

		$.each(all_field, function(i, field) {
			var t = {
				name: field,
				data: []
			};
			
			if (alerts_by == 'threat_level') {
				t.color = threat_level_color_mapping[field];
			}

			$.each(graph, function(index, obj) {
				var c = obj[field] ? obj[field] : 0;
				t.data.push(c);
			});

			series1.push(t);
		});

		var $chart_container = $('#attack_container').children('#chart_container');
		if ($chart_container.length == 0) {
			$chart_container = $('<div id="chart_container">');
			$chart_container.appendTo('#attack_container');
		}

		$chart_container.highcharts({
			chart: {
				type: 'column'
			},
			title: {
				text: ''
			},
			subtitle: {
				text: ''
			},
			exporting: {
				enabled : false
			},
			xAxis: {
				categories: cats,
				labels: {
					enabled: true
				},
				lineWidth: 1,
				tickWidth: 0
			},
			yAxis: {
				title: {
					enabled: false
				},
				min: 0,
				lineWidth: 1,
				tickWidth: 1
			},
			legend: {
				itemWidth:  (alerts_by == 'threat_level') ? 120 : 170,
				itemStyle: {
					'fontFamily': 'Lato,Helvetica,Arial,sans-serif',
					'fontSize': '15px',
					'width': '140px',
					'textOverflow': 'ellipsis'
				},
				labelFormatter: function () {
					color_mapping[this.name] = this.color;
					return this.name;
				}
			},
			tooltip: {
				style: {'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 'fontSize': '15px'},
				shared: false,
				formatter: function(){
					return '<b>' + this.series.name + ': ' + this.y + '</b>';
				}
			},
			plotOptions: {
				column: {
					stacking: 'normal',
					dataLabels: {
						enabled: false,
						style: {'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 'fontSize': '15px'},
						allowOverlap: true
					}
				}
			},
			credits: {
				enabled: false
			},
			series: series1
		});
		
		if ($('#table_container > table').length > 0) {
			$('#table_container > table > tbody > tr').each(function(index){
				var $tr = $(this);
				var value = $tr.data('primary-value');
				var color;
				if (value) {
					color = color_mapping[value];
					if (color) {
						$tr.find('td:first > f-icon').css('color', color);
						$tr.find('td[field=TNumber] .inner-bar').css('background-color', color);
					}
				}
			});
		}
	}

	function display_hpc_chart(result, textStatus){
		var data = result.datas;
		var series = [];
		$.each(data, function(index, obj){
			var d = [];
			var t = {};
			d.push(obj.data?obj.data:'');
			t.data = d;
			t.name = obj.name;
			series.push(t);
		});

		$('#attack_container').highcharts({
			chart: {
				type: 'bar'
			},
			title: {
				text: ''
			},
			subtitle: {
				text: ''
			},
			exporting: {
				enabled : false
			},
			xAxis: {
				categories: [],
				labels: {
					enabled: false
				},
				lineWidth: 1,
				tickWidth: 0
			},
			yAxis: {
				title: {
					enabled: false 
				},
				min: 0,
				lineWidth: 1,
				tickWidth: 1
			},
			tooltip: {
				shared: false,
				formatter: function(){
					return '<b>' + this.series.name + ': ' + this.y + '</b>';
				}
			},
			plotOptions: {
				bar: {
					dataLabels: {
						enabled: true,
						allowOverlap: true
					}
				}
			},
			credits: {
				enabled: false
			},
			series: series
		});
	}

	function display_file_upload_chart(result, textStatus){
		var data = result.datas;
		var series = [];
		$.each(data, function(index, obj){
			var d = [];
			var t = {};
			d.push(obj.data?obj.data:'');
			t.data = d;
			t.name = obj.name;
			series.push(t);
		});

		$('#attack_container').highcharts({
			chart: {
				type: 'bar'
			},
			title: {
				text: ''
			},
			subtitle: {
				text: ''
			},
			exporting: {
				enabled : false
			},
			xAxis: {
				categories: [],
				labels: {
					enabled: false
				},
				lineWidth: 1,
				tickWidth: 0
			},
			yAxis: {
				title: {
					enabled: false 
				},
				min: 0,
				lineWidth: 1,
				tickWidth: 1
			},
			tooltip: {
				shared: false,
				formatter: function(){
					return '<b>' + this.series.name + ': ' + this.y + '</b>';
				}
			},
			plotOptions: {
				bar: {
					dataLabels: {
						enabled: true,
						allowOverlap: true
					}
				}
			},
			credits: {
				enabled: false
			},
			series: series
		});
	}

	function init_drilldown_info() {
		drilldown_info.by = '';
		drilldown_info.level = 0;
		drilldown_info.filters = [];
		drilldown_info.current_items = drilldown_info.available_items;
	}

	function get_table_data() {
		// var params = get_params();
		var params_str = get_params_str();
		$.ajax({
			// url: '/system/status/table_attack',
			// data: params,
			url: rest_url+encodeURIComponent([
					'api/v1.0/Fortiview/AttackStat/TableJson',
					params_str
				].join('?')),
			dataType: 'json',
			timeout: FORTIVIEW_DATA_TIMEOUT,
			cache: false
		}).always(function(dataOrJqXHR, textStatus, jqXHROrErrorThrown){
			display_table(dataOrJqXHR.datas);
			// hide_loading('#attack_container1');
			decrease_count();
			if (textStatus == 'timeout') {
				send_abort_request();
			}
		});
	}

	function get_params() {
		var params = {};
		var time_range = $('[name=time]').val();
		params.time = time_range;
		params.start_time = start_time;
		var alerts_by = $('[name=tableType]').val();
		if (!drilldown_info.by) {
			params.report_by = alerts_by;
			// params.sub_type = FTVW_MSG_STAT_SUB_ATTACK;
			params.count = 200;
		} else if (drilldown_info.by == 'policy' || drilldown_info.by == 'src') {
			params.report_by = drilldown_info.by;
			// params.sub_type = FTVW_MSG_STAT_SUB_ATTACK;
			params.count = 10;
		} else if (drilldown_info.by == 'time') {
			// var last_filter = _.last(drilldown_info.filters);
			// params.report_by = last_filter.field;
			// params.sub_type = FTVW_MSG_STAT_SUB_FABRIC_A;
			params.report_by = drilldown_info.by;
		}

		var filter = _.reduce(drilldown_info.filters, function(filter, item, index){
			filter[item.field] = item.value;
			return filter;
		}, {});
		params.filter = encodeURIComponent(JSON.stringify(filter));

		return params;
	}

	function get_params_str() {
		var params_arr = [];

		var time_range = $('[name=time]').val();
		params_arr.push(['time', time_range].join('='));

		params_arr.push(['start_time', start_time].join('='));

		var alerts_by = $('[name=tableType]').val();
		if (!drilldown_info.by) {
			params_arr.push(['report_by', alerts_by].join('='));
			// params_arr.push(['sub_type', FTVW_MSG_STAT_SUB_ATTACK].join('='));
			params_arr.push(['count', 200].join('='));
		} else if (drilldown_info.by == 'policy' || drilldown_info.by == 'src' || drilldown_info.by == 'signature_cve_id') {
			params_arr.push(['report_by', drilldown_info.by].join('='));
			// params_arr.push(['sub_type', FTVW_MSG_STAT_SUB_ATTACK].join('='));
			params_arr.push(['count', 10].join('='));
		} else if (drilldown_info.by == 'time') {
			// var last_filter = _.last(drilldown_info.filters);
			// params_arr.push(['report_by', last_filter.field].join('='));
			// params_arr.push(['sub_type', FTVW_MSG_STAT_SUB_FABRIC_A].join('='));
			params_arr.push(['report_by', drilldown_info.by].join('='));
		}

		var filter = _.reduce(drilldown_info.filters, function(filter, item, index){
			filter[item.field] = item.value;
			return filter;
		}, {});
		params_arr.push(['filter', encodeURIComponent(JSON.stringify(filter))].join('='));

		return params_arr.join('&');
	}

	function display_table(records) {
		records = records || [];

		var alerts_by = $('[name=tableType]').val();
		var columns = [];
		if (!drilldown_info.by) {
			columns.push(alerts_by);
		} else {
			columns.push(drilldown_info.by);
		}
		columns.push('TNumber');
		if (drilldown_info.current_items.length > 0) {
			columns.push('drilldown');
		}

		var $table_container = $('#attack_container1').children('#table_container');
		if ($table_container.length == 0) {
			$table_container = $('<div id="table_container">');
			$('#attack_container1').append($table_container);
		}
		$table_container.empty().addClass('container-fluid');

		var $top_bar = $('<div id="top_bar">');
		$table_container.append($top_bar);
		var $info_container = $('<div id="info_container">');
		$top_bar.append($info_container);
		var $attacks_by = $('<span id="attacks_by">');
		$info_container.append($attacks_by);
		$attacks_by.text($.getInfo('attacks_by', flt_lang));

		var $by_field = $('<span id="by_field">');
		$info_container.append($by_field);
		var lang_key = ['column', columns[0]].join('_');
		$by_field.text($.getInfo(lang_key, flt_lang));

		if (drilldown_info.filters.length > 0) {
			var $filters = $('<span id="filters">');
			$info_container.append($filters);
			var filter_str = _.reduce(drilldown_info.filters, function(result, item, index){
				var arr = [];
				var lang_key = ['column', item.field].join('_');
				arr.push($.getInfo(lang_key, flt_lang));
				if (item.display_value) {
					arr.push(item.display_value);
				} else {
					arr.push(item.value);
				}
				var str = arr.join(': ');
				if (result == '') {
					result = str;
				} else {
					result = [result, str].join(', ');
				}
				return result;
			}, '');
			$filters.text(['( ', filter_str, ' )'].join(''));
		}

		if (drilldown_info.level > 0) {
			var $btn_container = $('<div id="btn_container">');
			$top_bar.append($btn_container);
			var $back_btn = $('<button type="button" id="btn_back" class="btn btn-xs btn-link">');
			$btn_container.append($back_btn);
			$back_btn.text($.getInfo('back', flt_lang));
			$back_btn.one('click', function(){
				// show_loading('#attack_container1');
				increase_count();

				drilldown_info.level--;
				if (drilldown_info.level < 0) drilldown_info.level = 0;

				if (drilldown_info.level == 0) {
					init_drilldown_info();
				} else {
					var last_filter = drilldown_info.filters.pop();
					drilldown_info.by = last_filter.field;
					drilldown_info.current_items = _.without(drilldown_info.available_items, drilldown_info.by);
					if(drilldown_info.level == 1 && last_filter.field == 'policy')
						drilldown_info.current_items.push('signature_cve_id');
				}
				get_table_data();
			});
		}

		var $table = $('<table id="attack_table" class="table table-striped table-fixed">');
		$table_container.append($table);
		var $thead = $('<thead>');
		$table.append($thead);
		var $headRow = $('<tr>');
		$thead.append($headRow);

		var column_count = columns.length;
		var $th;
		$.each(columns, function(index, column){
			$th = $('<th>');
			$headRow.append($th);
			$th.attr('id', ['th', column].join('_'));

			if (column_count == 2) {
				$th.addClass('col-xs-6');
			} else if (column_count == 3) {
				if (index == 0) {
					$th.addClass('col-xs-6');
				} else if (index == 1) {
					$th.addClass('col-xs-4')
				} else {
					$th.addClass('col-xs-2')
				}
			}
			
			lang_key = ['column', column].join('_');
			$th.html($.getInfo(lang_key, flt_lang));

			if (column == 'drilldown') {
				$th.addClass('text-center');
			}
		});

		var $tbody = $('<tbody>');
		$table.append($tbody);

		var first_filter, color_key, color;
		if (drilldown_info.level > 0) {
			first_filter = _.first(drilldown_info.filters);
			color_key = first_filter.value;
			color = color_mapping[color_key];
		}

		var total_attacks = 0, max_total_number = 0;
		var $tr, $td, tr_num = 0;
		$.each(records, function(rowNo, record){
			if (record['TNumber'] == 0) return;

			$tr = $('<tr>');
			$tbody.append($tr);
			tr_num++;
			if (tr_num % 2 == 0) {
				$tr.addClass('even-row');
			}

			$.each(columns, function(index, column){
				$td = $('<td>');
				$tr.append($td);
				$td.attr('field', column);

				if (column_count == 2) {
					$td.addClass('col-xs-6');
				} else if (column_count == 3) {
					if (index == 0) {
						$td.addClass('col-xs-6');
					} else if (index == 1) {
						$td.addClass('col-xs-4')
					} else {
						$td.addClass('col-xs-2')
					}
				}

				if (index == 0) {
					$tr.data('primary-field', column);
					$tr.data('primary-value', record[column]);
					if (drilldown_info.level == 0) {
						color = color_mapping[record[column]] || 'gray';
					}
				}
				
				if (column == 'drilldown') {
					$td.addClass('text-center');

					var $a = $([
						'<a role="button" class="btn btn-xs" tabindex="', tr_num, '" data-toggle="popover">'
						].join(''));
					$td.append($a);
					var $icon = $('<f-icon class="fa-plus-circle drilldown-trigger">');
					$a.append($icon);
					$a.popover({
						container: 'body',
						content: function(){
							var $div = $('<div>');
							var $ul = $('<ul class="list-unstyled">');
							$div.append($ul);
							var $li, $anchor, lang_key;
							$.each(drilldown_info.current_items, function(index, item){
								$li = $('<li>');
								$ul.append($li);
								$anchor = $('<a class="drilldown-item">');
								$li.append($anchor);
								lang_key = ['drilldown', item].join('_');
								$anchor.html($.getInfo(lang_key, flt_lang));
								$anchor.attr('data-item', item);
							});
							return $div.html();
						},
						html: true,
						placement: 'bottom',
						trigger: 'focus'
					});
					$a.on('shown.bs.popover', function(){
						var $anchor = $(this);
						$('.popover a.drilldown-item').one('click', function(event){
							event.preventDefault();

							// show_loading('#attack_container1');
							increase_count();

							var drilldown_by = $(this).data('item');
							var $tr = $anchor.parents('tr');
							var field = $tr.data('primary-field');
							var value = $tr.data('primary-value');
							var display_value = $tr.data('display-value');
							
							drilldown_info.by = drilldown_by;

							drilldown_info.level++;
							if (drilldown_info.level > 2) drilldown_info.level = 2;

							if (drilldown_info.level == 2) {
								drilldown_info.current_items = [];
							} else {
								drilldown_info.current_items = _.without(drilldown_info.current_items, drilldown_by);
								if(drilldown_info.level == 1 && drilldown_info.by == 'policy')
									drilldown_info.current_items.push('signature_cve_id');
							}
							
							drilldown_info.filters.push({
								field: field,
								value: value,
								display_value: display_value
							});

							get_table_data();
						});
					});
				} else if (column == 'time') {
					var time_str = record['time_str'];
					$td.html(time_str);
					$tr.data('display-value', time_str);
				} else if (column == 'TNumber') {
					$td.data('total-number', record[column]);
					var total_number = parseInt(record[column]);
					total_attacks += total_number;
					if (total_number > max_total_number) {
						max_total_number = total_number;
					}

					var $div = $([
						'<div class="row">',
							'<div class="col-xs-3 text-part">', record[column], '</div>',
							'<div class="col-xs-9 outer-bar">',
								'<div class="inner-bar" style="background-color:', color, '">&nbsp;</div>',
							'</div>',
						'</div>'
						].join(''));
					$td.append($div);
				} else {
					$td.html(record[column]);

					if (drilldown_info.level == 0 && index == 0) {
						var $color_lump = $('<f-icon class="fa-square color-lump">');
						$td.prepend($color_lump);
						$color_lump.css('color', color);
					}
				}
			});
		});

		var $tfoot = $('<tfoot>');
		$table.append($tfoot);
		$tr = $('<tr>');
		$tfoot.append($tr);
		$td = $('<td class="col-xs-6">');
		$tr.append($td);
		$td.html($.getInfo('total_attacks', flt_lang));
		$td = $('<td class="col-xs-6">');
		$tr.append($td);
		$td.html(total_attacks);

		$tbody.find('td[field=TNumber]').each(function(){
			var $td = $(this);
			var total_number = $td.data('total-number');
			// var percent = total_number / total_attacks * 100;
			var percent = max_total_number ? (total_number / max_total_number * 100) : 0;
			var $inner_bar = $td.find('.inner-bar');
			$inner_bar.css('width', percent+'%');
		});
	}

	function show_loading(container) {
		var $container = $(container);

		var $mask_div = $container.children('.mask-layer');
		if ($mask_div.length == 0) {
			$mask_div = $('<div class="mask-layer">');
			$mask_div.appendTo($container);
			$mask_div.css({
				'background-color': 'black',
				'position': 'absolute',
				'left': '0',
				'top': '0',
				'z-index': '10000',
				'height': '100%',
				'width': '100%',
				'-moz-opacity': '0.5',
				'opacity': '0.5',
				'filter': 'alpha(opacity=50)'
			});
		}
		$mask_div.css('display', '');
		
		var $div_modal = $container.children('.loading-layer');
		if ($div_modal.length == 0) {
			$div_modal = $('<div class="loading-layer">');
			$div_modal.appendTo($container);
			$div_modal.css({
				'position': 'absolute',
				'z-index': '10001'
			});
		}
		$div_modal.html('<f-icon class="fa-loading"></f-icon>');

		var left = ($container.width() - $div_modal.width()) / 2;
		var top = ($container.height() - $div_modal.height()) / 2;
		$div_modal.css({
			'left': left,
			'top': top
		});
	}

	function hide_loading(container) {
		var $container = $(container);
		$container.children('.loading-layer').empty();
		$container.children('.mask-layer').css('display', 'none');
	}

	function menu_selection_handler(url,  func, time/*, policy*/){

		// show_loading('#attack_container');
		increase_count();

		if (!time) time = '1';

		start_time = Math.floor(Date.now() / 1000) + time_offset;
		// if(policy == undefined || policy == ''  || policy == null)  policy =  encodeURIComponent("Total Attack Event History");
		var table = document.getElementsByName("tableType")[0].value;

		$.ajax({
			// "url" : url,
			// "data" : {
			// 	"time": time,
			// 	"start_time": start_time,
			// 	// "policy": policy,
			// 	"report_by": table
			// },
			"url": rest_url+encodeURIComponent([
					'api/v1.0/Fortiview/AttackStat/PolicyJson',
					[
						['time', time].join('='),
						['start_time', start_time].join('='),
						['report_by', table].join('=')
					].join('&')
				].join('?')),
			"dataType" : "json",
			"timeout": FORTIVIEW_DATA_TIMEOUT,
			"cache" : false
		}).always(function(dataOrJqXHR, textStatus, jqXHROrErrorThrown){
			func(dataOrJqXHR, textStatus);
			// hide_loading('#attack_container');
			decrease_count();
			if (textStatus == 'timeout') {
				send_abort_request();
			}
		});

		// show_loading('#attack_container1');
		increase_count();
		if (table == 'threat_level') {
			color_mapping = threat_level_color_mapping;
		} else {
			color_mapping = {};
		}
		init_drilldown_info();
		get_table_data();
	}

	$.ajax({
		// url: '/fortiview/info/fortiview_json',
		// data: {
		// 	time: Math.floor(Date.now() / 1000) // the seconds elapsed since the UNIX epoch
		// },
		url: rest_url+encodeURIComponent([
				'api/v1.0/Fortiview/Info/FortiviewJson',
				[
					'time',
					Math.floor(Date.now() / 1000) // the seconds elapsed since the UNIX epoch
				].join('=')
			].join('?')),
		dataType: 'json',
		cache: false
	}).done(function(data, textStatus, jqXHR){
		var now_time = Math.floor(Date.now() / 1000);
		var origin_time = data.timeinfo.client_epoch;
		var delay = Math.floor((now_time - origin_time) / 2);
		var origin_offset = data.timeinfo.origin_offset;
		var offset = (origin_offset > 0) ? (origin_offset - delay) : (origin_offset + delay);
		time_offset = (Math.abs(offset) > data.timeinfo.min_offset) ? offset : 0;

		menu_selection_handler("/system/status/policy_attack",  display_signature_chart);
	});
	
})(jQuery, _);
