var timeout = null;

function InitChart()
{
	$('#container').highcharts({
		chart: {
			animation: false
		},
	title: {
		text: '' 
	},
	subtitle: {
		text: ''
	},
	xAxis: {
		type: 'linear',
		tickInterval: 1,
		labels: {
			rotation: 315,
			style: {'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 'fontSize': '12px'},
			align: 'right',
			formatter: function()
			{
				var val = parseInt(this.value);
				if((val+4)%10 != 0)
					return '';
				else
				{
					var ret = 60 - val + 6;
					return "Last " + String(ret) + " seconds";
				}
			}
		}
	},
	yAxis: {
		min: 0,
		title: {
			text: ''
		},
		labels: {
			style: {'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 'fontSize': '12px'},
			formatter: function() {
				var v = this.value;
				if(v > 1024)
					return (Number(v/1024)).toFixed(2) + 'Mb';
				else
					return (Number(v)).toFixed(2) + 'Kb';
			}
		}
	},
	credits: {
		enabled: false
	},
	legend: {
		enabled: false
	},
	tooltip: {
		headerFormat: '',
		style: {'fontFamily': 'Lato,Helvetica,Arial,sans-serif', 'fontSize': '15px'},
		formatter: function()
		{
			var v = this.y;
			if(v > 1024)
				return (Number(v/1024)).toFixed(3) + ' Mb/s';
			else
				return (Number(v)).toFixed(3) + ' Kb/s';
		}
	},
	plotOptions: {
		areaspline: {
			fillColor: {
				linearGradient: {
					x1: 0,
					y1: 0,
					x2: 0,
					y2: 1
				},
				stops: [
					[0, Highcharts.getOptions().colors[0]],
					[1, Highcharts.Color(Highcharts.getOptions().colors[0]).setOpacity(0).get('rgba')]
				]
			},
			marker: {
				enabled: false,
				symbol: 'circle',
				radius: 2,
				states: {
					hover: {
						enabled: true
					}
				}
			},
			threshold: null
		}
	},

	series: [{
		type: 'areaspline',
		name: '',
		data: []
	}]
	});

	var policy = $('#policy_combo')[0].value;
	getTraData(policy);
}

function getTraData(policy)
{
	if(policy == undefined)
		return;
	if(timeout)
		clearTimeout(timeout);
	
	$.ajax({
		url: "/system/status/policy-stats?policy=" + policy,
		dataType: 'json',
		success: function(response)
		{
			if(response.status == 1)
			{
				var data = response.data;
				var policy = $('#policy_combo')[0].value;
				feedDataAndPoolNext(data, policy);
			}
			else if(response.status == 0)
			{
				var msg_id = response.msg_id;
				switch(msg_id)
				{
					case 0:
						document.location.href = "/system/traffic_chart/list";
						break;
					case -30:
						top.top.location.href = "/login";
						break;
					case -37:
						document.location.href = "/noaccess?redir=/system/traffic_chart/list";
						break;
					default:
						document.location.href = "/error?msg=" + msg_id;
						break;
				}
			}
		},
		cache: false
	});
}

function feedDataAndPoolNext(data, policy)
{
	if(data)
	{
		var chart = $('#container').highcharts();
		var real_data = data.map(function(value) {
			var val = parseInt(value.count);
			val *= 8;
			val /= 1024;
			return val;
		});
		if(chart)
			chart.series[0].setData(real_data);
	}

	timeout = setTimeout(function() {
		var policy = $('#policy_combo')[0].value;
		getTraData(policy);
	}, 1000);
}
