var DetailsWindow = (function($) {
    var config = {
        "containerSelector" : "#logview-container",
        "mainPanelSelector" : "#logview-main",
        "detailsPanelSelector" : "#logview-details",
        "contentBodySelector" : "#contentBody",
        "contentHeadSelector" : "#qlist_hdrrow",
        "detailsLocation" : "south",
        "initialHidden" : "false",
        "sizeSouth" : getCookie("sizeSouth") || 180,
        "sizeEast" : getCookie("sizeEast") || 220,
        "formatCallbacks" : {},
        "rowData" : [],
        "getRowCallback" : function(row_id) { return config['rowData'][row_id]; },
        "getRowLengthCallback" : function() { return config['rowData'].length; },
        "langOverride" : {}
    };
    var busy;
    var layout;
    var detailsPanel;
    var mainPanel;
    var selectedRowEntry;
    var selectedRowEntryIndex;
    var rows = [];
    var first_row;
    var msg_menu;
    var msg_menu_actions = [];
    var msg_menu_count = 0;

    function initialize(params) {
        var layout_params = [];
        var detail_loc;
        var p_size;
        var id_tmp;

        config = $.extend({}, config, params);

        mainPanel = $(config["mainPanelSelector"]);
        detailsPanel = $(config["detailsPanelSelector"]);

        if (detailsPanel.length < 1) {
            id_tmp = config["mainPanelSelector"].substr(1);
            mainPanel = appendMainPanel(id_tmp);
        }

        if (detailsPanel.length < 1) {
            id_tmp = config["detailPanelSelector"].substr(1);
            detailsPanel = appendDetailPanel(id_tmp);
        }

        mainPanel.scroll(fixHeaderScrollPosition);
        detail_loc = getDetailPaneLocation();

        layout_params["center"] = {
                paneSelector: config["mainPanelSelector"],
                onresize_end: refreshDisplay,
		minWidth: 400
            };

        layout_params[detail_loc] = {
                paneSelector: config["detailsPanelSelector"],
                initHidden: config["initialHidden"],
                resizable: true,
                togglerLength_open: 0,
                togglerLength_closed: 0,
                onresize_end: function(local) {
                    // some events such as changing the panel location will trigger this, skip
                    if (busy || !layout) {
                        return;
                    }

                    var propName = "size" + local.charAt(0).toUpperCase() + local.slice(1);
                    var size = layout.state[local].size;

		    if(size < 470) 
			config[propName] = 470;
		    else
                        config[propName] = size;
                    setCookie(propName, size);
                    sizeDetailPane();
                }
            };

        layout = $(config["containerSelector"]).layout(layout_params);
        setMenuButton("hidden");
        rows = $("tr", config['contentBodySelector']).get();
        first_row = rows[0];
        msg_menu = new YAHOO.widget.Menu('msg_menu');
        msg_menu.hideEvent.subscribe(function(){
            $(".msg_menu_button").each(function(){
                $(this).removeClass("msg_menu_button_active");
            });
        });

        while ($(first_row).hasClass("heading")) {
            rows.shift();
            first_row = rows[0];
        }

        if (!config["initialHidden"]) {
            setMenuButton(config[detail_loc]);

            if (rows.length > 0) {
                if(params.rowData[1] && params.rowData[1].aggregate)
                {
                    selectRow(rows[1]);
                }else{
                    selectRow(first_row);
                }

            }

            showRowDetailsMenu(true);
        }

        busy = false;
    }

    function appendMainPanel(panel_id) {
        var html = "<div id=\"" + panel_id + "\"></div>";
        var b = $("body.main");
        
        b.wrapInner(html);

        return $(panel_id);
    }

    function appendDetailPanel(panel_id) {
        var html = $("<div id=\"" + panel_id + "\"></div>");

        return html.appendTo("body");
    }

    function sizeDetailPane() {
        var local = getDetailPaneLocation();
        var size = {
            "south" : parseInt(config["sizeSouth"]),
            "east" : parseInt(config["sizeEast"])
        }

        layout.sizePane(local, size[local]);
    }

    function refreshDisplay() {
        var bodyTable = $(config['contentBodySelector']).closest("table").get(0);
        var headerTable = $(config['contentHeadSelector']).get(0);
        var right_qlist = $("#qlist_right_menubar_container");
        var i;

        if ("east" == getDetailPaneLocation() && !layout.state["east"].isHidden) {
            right_qlist.css("marginRight", config["sizeEast"] + "px");
        } else {
            right_qlist.css("marginRight", "");
        }

        qlist_realign_floating_header();
        qlist_realign_floating_footer();

        var bottom = $(window).height() - $("#main_window")[0].clientHeight;
        $("#qlist_ftrbar").css("bottom", bottom + "px");

        tbl_realign_columns(headerTable, bodyTable);
    }

    function fixHeaderScrollPosition() {
        var header = $("#hrdtc")[0];
        var container = $("#main_window")[0];

        $(header).css("marginLeft", "-" + container.scrollLeft + "px");
    }

    function setMenuButton(local) {
        var itemClass = "qlist_marked_menu_item";

        $("#mi_detail_right").toggleClass(itemClass, local == "east");
        $("#mi_detail_bottom").toggleClass(itemClass, local == "south");
        $("#mi_detail_close").toggleClass(itemClass, local == "hidden");
    }

    function toggleDetailsPanelLocation(local) {
        var curr = getDetailPaneLocation();

        busy = true;

        if (typeof(local) == "undefined" || curr !== local) {
            layout.swapPanes("east", "south");

            if (selectedRowEntry) {
                showRowDetailsPos(getDetailPaneLocation() == "south" ? "east" : "south");
            }

            sizeDetailPane();
            refreshDisplay();
        }

        setMenuButton(local);

        busy = false;
    }
   
    function selectRow(row) {
        if (typeof row == "undefined") {
            return;
        }

        if (typeof(selectedRowEntry) != "undefined") {
            $(selectedRowEntry).toggleClass("log_entry_selected", false);
            selectedRowEntry = null;
            selectedRowEntryIndex = 0;
        }
    	if(row.id != "tr_merge")
    	{
                // set selected entry
                selectedRowEntry = row;
                selectedRowEntryIndex = row.rowIndex - first_row.rowIndex;
                $(selectedRowEntry).addClass("log_entry_selected");
    	}
    }

    function handleRowDetailKeyPress(e) {
        var local = getDetailPaneLocation();
        var idx = selectedRowEntryIndex;
        var tr;

        if (e.keyCode != 38 && e.keyCode != 40)
            return;

        if (e.keyCode == 38)
            idx--;

        if (e.keyCode == 40)
            idx++;

        if (idx >= 0 && (tr = rows[idx])) {
            selectRow(tr);

            if (!layout.state[local].isHidden) {
                showRowDetails(tr);
            }

            return false;
        }
    }

    function showRowDetailsMenu(noFx) {
        if (selectedRowEntry == null) {
            selectRow(first_row);
        }

        if (noFx) {
            $.fx.off = true;
        }

        sizeDetailPane();
        showRowDetails();
        //updateSystemPosition(config['detailsLocation']);

        $.fx.off = false;
    }

    function showRowDetailsClick(e) {
        var target = e.target.parentNode;

        while (target) {
            if (target.tagName === "TR") {
                selectRow(target);
                sizeDetailPane();
                //if(document.forms[0].logType.value != 1)
                showRowDetails(target, e);

                break;
            }

            if (target.parentNode) {
                target = target.parentNode;
            } else {
                return false;
            }
        }

        return true;
    }

    function getDetailPaneLocation() {
        if (layout && layout.panes["east"] !== false) {
            config["detailsLocation"] = "east";
        }

        if (layout && layout.panes["south"] !== false) {
            config["detailsLocation"] = "south";
        }

        return config["detailsLocation"];
    }

    function setDetailPaneLocation(local) {
        if (local == "east" || local == "south") {
            config["detailsLocation"] = local;
        }

        return config["detailsLocation"];
    }

    function updateViewPos() {
        var icon = $("#view_pos");
        var pos = getDetailPaneLocation();
    }

    function showRowDetailsPos(pos) {
        var tr = selectedRowEntry;

        if (typeof(pos) !== "undefined") {
            setDetailPaneLocation(pos);
        }

        showRowDetails(tr);
    }

    function updateSystemPosition(pos) {
        var key = "set_detail";
        var data = {};
        var params = {
            'url': '/log/display'
        }

        if (pos == "east") {
            data[key] = "2";
        } else if (pos == "hidden") {
            data[key] = "0";
        } else {
            data[key] = "1";
        }

        params['data'] = data;

        $.ajax(params);
    }

    function msgMenuClick (elem, menuCount) {
        var $label = $j(elem), 
            msg_menu_holder = $label.closest('div').find('.msg_menu_holder')[0];

        $label.addClass("msg_menu_button_active");
        msg_menu.clearContent();
        msg_menu.addItems(msg_menu_actions[menuCount]);

        msg_menu.cfg.setProperty('context', [$label[0], 'tl', 'bl']);
        msg_menu.cfg.setProperty('width', $label.outerWidth() + 'px');
        msg_menu.render(msg_menu_holder);
        msg_menu.show(); 
    }

    function showRowDetails(tr, e) {
        var row_entry;
        var header;
        var table;
        var html_buffer;
        var local = getDetailPaneLocation();

        if (typeof(tr) == "undefined") {
            tr = selectedRowEntry;

            if (!tr) {
                return;
            }
        }

        if (tr.rowIndex < 1) {
            return;
        }

        // decrease header row & filter row
        row_entry = config['getRowCallback'](tr.rowIndex - first_row.rowIndex);
        table = buildTable_new(row_entry,local == "south" ? 2 : 1,"disk_table"); 

        detailsPanel.empty().append(table);

        layout.show(config["detailsLocation"], true, true);
        setMenuButton(config["detailsLocation"]);
        //if(document.forms[0].aggregate.value == 0 && (document.forms[0].logType.value == 3 || document.forms[0].logType.value == 2)){
        //    updateDetailStyle('expand');
        //}                    
    }

     function updateDetailStyle(action)
     {
        if(action == 'expand')
        {
            document.getElementById("detail_collapse").style.display = 'none';
            document.getElementById("detail_expanded").style.display = '';
        }else{
            document.getElementById("detail_collapse").style.display = '';
            document.getElementById("detail_expanded").style.display = 'none';
        }
     }

    function buildTable(cols) {
        var lang_override;
        var elems = [];
        var rows = [];
        var html;
        var label;
        var row_class, label_class;
        var text_level = "pri";//get the text of level in different languages
        var text_data = "data"; //package log data
        var text_except = "except";//attack log protection exception 
        var text_except_url = "except_url";//attack log protection exception 
        var alert_only_url = "";//attack log protection exception 
        var except = "";
        var except_url = "";
        var hpc_except_url = "";
        var text_pattern = "pattern";//attack log pattern 
	    var text_msg = "msg";
	    var text_sub_type = "subtype";
        var width = 100/cols;
        var n = 0;
        var obj = row_entry;
        var row_num = 0;
        var val;
        var pattern=null;
	    var need_link = false;
	    var hpc_link = false;
	    var text_sig = "Signature ID";
	    var text_global_status = "global_status";
	    var text_alert_only = "alert_only";
	    var text_alert_only_url = "alert_only_url";
        var text_srccountry = "srccountry";


        lang_override = config["langOverride"];

        if (fgt_lang && fgt_lang.display) {
            text_level = fgt_lang.display["pri"]; 
            text_srccountry = fgt_lang.display["srccountry"];
        }

        tb = document.createElement("div");
        tb.id = "log_details_table";
        $(tb).width("100%");

        elems.push("<table cellspace=\"1\" cellpadding=\"0\" class=\"list log_details pre\" style=\"table-layout:fixed\">");

        if(row_entry == "")
        {
            elems.push("</table>");

            return $(elems.join(""));
        }
        for (var i in obj) {
            label = (lang_override && lang_override[i]) ? lang_override[i] : $.getInfo(i);
    		if(i == text_except)
    		{
                        except = obj[i];
                        //var data_html = "";
                        //data_html = "<tr class=\"even\">"+
    		    //    "<td class=\"value\"  colspan=\""+(2*cols)+"\"><div align=\"center\"><input class=\"button_l\" type=\"button\""+
    		    //    "value=\""+ obj[i] +"\" ";
                        //elems.push(data_html);   
    		}
    		if(i == text_except_url)
    		{
                        except_url = obj[i]+"&&step=1";
                        hpc_except_url = obj[i];
                        //var data_html = "onclick=\"logdisplay_except('"+obj[i]+"&&step=1')\"></div></td></tr>";
                        //elems.push(data_html);   
    		}
    		if(i == text_alert_only_url)
    		{
                        alert_only_url = obj[i]+"&&step=1";
    		}
        }
        for (var i in obj) {
            label = (lang_override && lang_override[i]) ? lang_override[i] : $.getInfo(i);
    		if(i == text_pattern)
    		{
                        pattern = obj[i];
                        var data_html = "";		    
                        data_html = "<tr class=\"" + ((row_num ) % 2 ? "even" : "odd") + "\">"+
    		        "<td class=\"label\" nowrap><b>Pattern</b></td>" +
    		        "<td class=\"value\" colspan=\""+(2*cols-1)+"\" id = \"pattern\">" + obj[i] + "&nbsp;</td></tr>";
                        elems.push(data_html);   
                        row_num++;
    		}

    		if(i == text_sub_type)
    		{
    			if(obj[i] == "waf_signature_detection" || obj[i] == "waf_ip_reputation")
    				need_link = true;
    			if(obj[i] == "http_protocol_error" || obj[i] == "waf_header_overflow" 
    					|| obj[i] == "waf_headline_overflow" || obj[i] == "waf_body_overflow" 
    					|| obj[i] == "waf_content_overflow" || obj[i] == "waf_parameter_overflow" 
    					|| obj[i] == "waf_request_overflow" || obj[i] == "waf_url_parameter_overflow" 
    					|| obj[i] == "waf_illegal_http_version" || obj[i] == "waf_cookiecount_overflow" 
    					|| obj[i] == "waf_req_headline_overflow" || obj[i] == "waf_url_parameter_count_overflow" 
    					|| obj[i] == "waf_illegal_hostname" || obj[i] == "waf_illegal_http_method" 
    					|| obj[i] == "waf_max_num_ranges_in_Range_header"
    					)
    				hpc_link = true;
    		}
        }

        for (var i in obj) {
            // Per-logtype overrides are supported. First the override table is referenced,
            // and if no entry is found, the standard language file is used.
            label = (lang_override && lang_override[i]) ? lang_override[i] : $.getInfo(i);
            html = "";

            if (i && i != text_data && i != text_except && i != text_except_url && i != text_pattern && i != text_global_status && i != text_alert_only
		         && i != text_alert_only_url) {
                row_class = (row_num % 2 ? "even" : "odd");
                if (i == text_level) {
                    label_class = "details_label";
                } else {
                    label_class = "label";
                }
                if(i == text_srccountry){
                    label_class = "details_label";
                }else{
                    label_class = "label";
                }

                if(i == "country_flag") continue; 

                if (n++ % cols == 0) {
                    html += "<tr class=\"" + row_class + "\">";
                }

                if (typeof config['formatCallbacks'][i] == "function") {
                    val = config['formatCallbacks'][i](i, obj[i]);
                } else {
                    val = obj[i];
                }

                html += "<td width=\"" + (width*0.3) + "%\" class=\"" + label_class + "\" nowrap><b>" + label + "</b></td>" + 
	              "<td width=\"" + (width*0.7) + "%\" class=\"value\" style=\"word-break:break-all; overflow:hidden;\">";
                if(pattern != null && pattern.length > 0 && val != "" && val.indexOf(pattern) != -1 && i != text_msg && i != "pri" && i != "srccountry")
                {
              	     html += "" + val.replace(pattern,"<span style=\"background-color:#ffff00\">"+pattern+"</span>") + "</td>";
                }else{
		             if(i == text_msg && need_link){
        				var sig = "";
        				var start = val.lastIndexOf(text_sig);
        				if(start != -1)
        				{
        					sig = val.substring(start+1+text_sig.length);
        					var url = "/signature/signature_detail.html";
        					url = qlist_url_append_arg(url, "sig_id", sig);
        					html += "<a onclick=\"wij_display_modal_dlg('" + url +"', {'width': 800, 'height': 520});\">" + val + "</a>";
        				}else{
        					html += val;
        				}
        				if(except != "")
        					html += " (<a  onclick=\"wij_display_modal_dlg('" + except_url +"', {'width': 400, 'height': 150});\">"+ except +"</a>)";
        				if(obj[text_alert_only] != "" && sig != "")
        					html += " (<a  onclick=\"wij_display_modal_dlg('"+alert_only_url+"', {'width': 400, 'height': 150});\">"+ obj[text_alert_only] +"</a>)";
        				if(obj[text_global_status] != "")				
        					html += " (<a  onclick=\"wij_display_modal_dlg('/waf/base_signature_disable/add?signature_id="+sig+"&session_id="+session_id+"', {'width': 400, 'height': 150});\">"+ obj[text_global_status] +"</a>)</td>";				
        				else
        					html += "</td>";
    	              }else if (i == text_msg && hpc_link ){
        				html += val;
        				if(except != "" && hpc_except_url != "")
        					html += " (<a  onclick=\"wij_display_modal_dlg('" + hpc_except_url +"', {'width': 430, 'height': 150});\">"+ except +"</a>)";
        				html += "</td>";
        			 }
                     else
        	            html += val + "</td>";
                }
                if (n % cols == 0) {
                    width = "";
                    row_num++;
                    html += "</tr>";
                }

                rows.push(html);
            }
        }
        elems.push(rows.join(""));

        if (n % cols != 0) {
            while (n++ % cols != 0) {
	    row_num++;
                elems.push("<td class=\"label\"></td><td class=\"value\"></td>");
            }                
        }
        elems.push("</tr>");

        for (var i in obj) {
            label = (lang_override && lang_override[i]) ? lang_override[i] : $.getInfo(i);
        	if(i == text_data)
        	{
                        var data_html = "";		    
                        data_html = "<tr class=\"" + ((row_num ) % 2 ? "even" : "odd") + "\">"+
        	        "<td class=\"label\" nowrap><b>Data</b></td>" +
        	        "<td class=\"value\" colspan=\""+(2*cols-1)+"\" style=\"word-break:break-all; overflow:hidden;\">";
                        val = obj[i];
                        if(pattern != null && pattern.length > 0 && val != "" && val.indexOf(pattern) != -1)
                        {
                      	data_html += val.replace(pattern,"<span style=\"background-color:#ffff00\">"+pattern+"</span>") + "</td>";
                        }else{
                      	data_html += val + "&nbsp;</td></tr>"; 
                        }
                        
                        elems.push(data_html);   
        	}
        }	
        elems.push("</table>");

        return $(elems.join(""));
    }

    function showRowDetailsNext() {
        var tr = ie4 ? selectedRowEntry.nextSibling : selectedRowEntry.nextSibling.nextSibling;

        if (selectedRowEntry.rowIndex >= config['getRowLengthCallback']()) {
            return;
        }

        showRowDetails(tr);
        showRowDetailsScroll(tr);
    }

    function showRowDetailsPrev() {
        var tr = ie4 ? selectedRowEntry.previousSibling : selectedRowEntry.previousSibling.previousSibling;

        if (!tr) {
            return;
        }

        showRowDetails(tr);
        showRowDetailsScroll(tr);
    }

    function showRowDetailsScroll(tr) {
        var container = $("#tableContainer");

        if ((tr.offsetTop + tr.clientHeight) > (container.scrollTop + container.clientHeight)) {
            tr.scrollIntoView(false);
        }
        else if (tr.offsetTop < container.scrollTop) {
            tr.scrollIntoView(true);
        }

        $("#log_details").style.right = "0px";
    }

    function hideRowDetails() {
        var local = getDetailPaneLocation();

        setMenuButton("hidden");
        //updateSystemPosition("hidden");

        layout.hide(local, true);
    }
    function trimSpace(val)
    {
        return val.replace(/^\s+|\s+$/g,'');
    }
    function buildTable_new(row_entry,cols,id){
        var lang_override;
        var elems = [];
        var rows = [];
        var html;
        var label;
        var row_class, label_class;
        var width = 100/cols;
        var n = 0;
        //disk log context
        var obj = row_entry.disk;
        var row_num = 0;
        var val;
        //pattern context
        var pattern = row_entry.pattern;
        //packet log context
        var packet = row_entry.packet;
        var raw_packet = row_entry.raw_packet;
        //match info: 1: head, 2: cookie, 3: args, 4: packet, 5: file
        var match_info = row_entry.match_info || "0";
        //parameters
        var args = row_entry.args;
        //cookies
        var cookies = row_entry.cookies;
        //files
        var files = row_entry.files;
        //head
        var head = row_entry.head;
        //aggregate
        var aggregate = row_entry.aggregate;      
        //msgID_detail
        var msgID_detail = row_entry.msg_id;  
        var is_cookie_poison = false; 
        var is_score_sum = 0;

        if(pattern) pattern= pattern.replace(/(^[ ]*)|([ ]*$)/g, "");          

        if(msgID_detail)
        {
            //from msgid get detail table
            //elems.push("<div style=\"background-color: #e8e7f1\" id=\"detail_"+msgID_detail+"\" ></div>");
            //get_log_by_msgID(msgID_detail);
            //return $(elems.join(""));
        }

        var need_link = false;
        var hpc_link = false;
        var need_msg_menu = false;

        var alert_only_url = "";//attack log protection exception 
        var except = "";
        var except_url = "";
        var hpc_except_url = "";
        var fpm = "";
        var fpm_url = "";

        var text_level = "pri";
        var text_srccountry = "srccountry";

        lang_override = config["langOverride"];

        if(fgt_lang && fgt_lang.display)
        {
            text_level = fgt_lang.display["pri"];
            text_srccountry = fgt_lang.display["srccountry"];
        }

        var tb = document.createElement("div");
        tb.id = "log_details_table";
        $(tb).width("100%");

        elems.push("<table id=\""+id+"\" cellspace=\"1\" cellpadding=\"0\" class=\"list log_details pre\" style=\"table-layout:fixed\">");
        /*
        if(document.forms[0].aggregate.value == 0 && (document.forms[0].logType.value == 3 || document.forms[0].logType.value == 2) )
        {

            elems.push("<tr class='head'><td colspan=2>");
            elems.push("<div title='Click to collapse this pane.' id='detail_expanded' onclick='detail_show_hide()' style='"
                       +"cursor: pointer;   height: 13px;   position: absolute;   left: 5px;   top: 5px;  width: 17px;   font-size: 0;"
                       +"background: transparent url(/build/assets/skins/sam/layout_sprite.png) no-repeat -20px -200px;   border: 1px solid #808080;'></div>");
            elems.push("</td></tr>\n");

        }
        */
        //no log detail data, just return a null table
        if(row_entry == "")
        {
            elems.push("</table>");

            return $(elems.join(""));
        }

        //begin build disk log table
        //pre handle for urls
        for(var i in obj)
        {
            label = (lang_override && lang_override[i]) ? lang_override[i] : $.getInfo(i);

            if(i == "except")
            {
                except = obj[i];
            }

            if(i == "except_url")
            {
                except_url = obj[i] + "&&step=1";
                hpc_except_url = obj[i];
            }

            if(i == "fpm")
            {
                fpm = obj[i];
            }

            if(i == "fpm_url")
            {
                fpm_url = obj[i];
            }

            if(i == "alert_only_url")
            {
                alert_only_url = obj[i] + "&&step=1";
            }

            if(i == "subtype")
            {
                if(obj[i] == "waf_signature_detection" || obj[i] == "waf_ip_reputation")
                    need_link = true;

                if(obj[i] == "http_protocol_error" ||
                        obj[i] == "waf_header_overflow" ||
                        obj[i] == "waf_headline_overflow" ||
                        obj[i] == "waf_body_overflow" ||
                        obj[i] == "waf_content_overflow" ||
                        obj[i] == "waf_parameter_overflow" ||
                        obj[i] == "waf_request_overflow" ||
                        obj[i] == "waf_url_parameter_overflow" ||
                        //obj[i] == "waf_illegal_http_version" ||
                        obj[i] == "waf_cookiecount_overflow" ||
                        obj[i] == "waf_req_headline_overflow" ||
                        obj[i] == "waf_url_parameter_count_overflow" ||
                        obj[i] == "waf_illegal_hostname" ||
                        obj[i] == "waf_illegal_http_method" ||
                        obj[i] == "waf_max_num_ranges_in_Range_header" ||
                        obj[i] == "waf_illegal_content_length" ||
                        obj[i] == "waf_illegal_content_type" ||
                        obj[i] == "waf_illegal_response_code" ||
                        obj[i] == "waf_missing_post_ctype" ||
                        obj[i] == "waf_body_parameter_overflow" ||
                        obj[i] == "waf_header_name_overflow" ||
                        obj[i] == "waf_header_value_overflow" ||
                        obj[i] == "waf_illegal_param_name" ||
                        obj[i] == "waf_illegal_param_value" ||
                        obj[i] == "waf_illegal_header_name" ||
                        obj[i] == "waf_illegal_header_value")
                    hpc_link = true;

                if(obj[i] == "waf_cookie_poison") is_cookie_poison = true;
            }
            if(i == "log_type")
            {
                if(obj[i] == "LOG_TYPE_SCORE_SUM")  is_score_sum = 1;
                if(obj[i] == "LOG_TYPE_NONE")  is_score_sum = 2;
            }
        }

        for(var i in obj)
        {
            // Per-logtype overrides are supported. First the override table is referenced,
            // and if no entry is found, the standard language file is used.
            label = (lang_override && lang_override[i]) ? lang_override[i] : $.getInfo(i);
            html = "";

            //these fields don't display in table
            if(i && i != "data" && i != "except" && i != "except_url" && i != "pattern" && i != "global_status" && 
                    i != "alert_only" && i != "alert_only_url" && i != "pcap_id" && i != "logfile" && i != "fpm" && i != "fpm_url"
                    //connection info display in other place
                    && i != "src" && i != "src_port" && i != "dst" && i != "dst_port" && i != "score_message" && i != "entry_sequence"
                    && ((is_score_sum == 1 && i!="log_type" && i!="score_scope" && i!="score_type" && i!="score_threshold"  && i!="score_sum")
                        || (is_score_sum == 2 && i!="log_type" && i!="event_score") 
                        || (is_score_sum == 0 && i!="log_type")) && i!="signature")
            {
                row_class = (row_num % 2) ? "even" : "odd";

                if(i == "pri")
                {
                    label_class = "details_class";
                }
                else
                {
                    label_class = "label";
                }

                if(i=="country_flag" || 
                    (i=="false_positive_mitigation" && obj[i]!="yes" && obj[i]!="no"))
                {
                    continue;
                }

                if(n++ % cols == 0)
                {
                    html += "<tr class=\"" + row_class + "\">";
                }

                if(typeof config["formatCallbacks"][i] == "function")
                {
                    val = config["formatCallbacks"][i](i, obj[i]);
                }
                else
                {
                    val = obj[i];
                }
                html += "<td width=\"" + (width*0.3) + "%\" class=\"" + label_class + "\" ><b>" + label + "</b></td>" +
                    "<td width=\"" + (width*0.7) + "%\" class=\"value\" style=\"word-break:break-all; overflow:hidden;\"";
                {
                    //display message field, add link for user to edit
                    if(i == "msg" && need_link)
                    {
                        var main_actions = [];
                        html += " colspan = \""+(2*cols-1)+"\">";
                        n = n + 1;
                        var sig = "";
                        var start = val.indexOf("Signature ID");
                        var view_sig_action = null;

                        if(start != -1)
                        {
                            sig = val.substring(start+1+"Signature ID".length);
                            var url = "/signature/signature_detail.html";
                            url = qlist_url_append_arg(url, "sig_id", sig);
                            view_sig_action ={
                                text: '<span class="msg_menu_action_text action_view">' + $.getInfo("view_signature") + '</span>',
                                id: 'menu_action_sig_detail',
                                classname: 'menu_act_item',
                                value: 'sig_detail',
                                onclick: {
                                    fn: function(){
                                        wij_display_modal_dlg( url , {'width': 805, 'height': 565});
                                    }
                                }
                            };
                            if(obj["sub_type"] == "Illegal Character in URL" || obj["sub_type"] == "NULL Character in URL" || obj["sub_type"] == "Odd and Even Space Attack"){
                                html += '<label><span>' +val+ '</span></label>';
                            }else{
                                html += '<label class="msg_menu_button" onclick="DetailsWindow.msgMenuClick(this, ' +msg_menu_count+ ');"><span class="msg_menu_button_text">' +val+ '</span></label>';
                                //html += "<a onclick=\"wij_display_modal_dlg('" + url +"', {'width': 800, 'height': 530});\">" + val + "</a>";
                            }
                        }
                        else
                        {
                            html += val;
                        }

                        if(except != "")
                        {
                            main_actions.push({
                                text: '<span class="msg_menu_action_text action_block">' + except + '</span>',
                                id: 'menu_action_except',
                                classname: 'menu_act_item',
                                value: 'except',
                                onclick: {
                                    fn: function() {
                                        wij_display_modal_dlg( except_url , {'width': 400, 'height': 213});
                                    }
                                }
                            });
                            //html += " (<a  onclick=\"wij_display_modal_dlg('" + except_url +"', {'width': 400, 'height': 155});\">"+ except +"</a>)";
                        }

                        if(obj["alert_only"] != "" && sig != "")
                        {
                            main_actions.push({
                                text: '<span class="msg_menu_action_text action_block">' + obj["alert_only"] + '</span>',
                                id: 'menu_action_alert_only',
                                classname: 'menu_act_item',
                                value: 'alert_only',
                                onclick: {
                                    fn: function() {
                                        wij_display_modal_dlg( alert_only_url , {'width': 400, 'height': 205});
                                    }
                                }
                            });
                            //html += " (<a  onclick=\"wij_display_modal_dlg('"+alert_only_url+"', {'width': 400, 'height': 150});\">"+ obj["alert_only"] +"</a>)";
                        }

                        /*if(fpm != "" && fpm_url != "")
                        {
                            main_actions.push({
                                text: '<span class="msg_menu_action_text action_disable">' + fpm + '</span>',
                                id: 'menu_action_fpm',
                                classname: 'menu_act_item',
                                value: 'fpm',
                                onclick: {
                                    fn: function() {
                                        wij_display_modal_dlg( fpm_url , {'width': 420, 'height': 205});
                                    }
                                }
                            });
                            //html += " (<a  onclick=\"wij_display_modal_dlg('"+ obj["fpm_url"]+"', {'width': 400, 'height': 150});\">"+ obj["fpm"] +"</a>)";
                        }*/

                        if(obj["global_status"] != "")
                        {
                            main_actions.push({
                                text: '<span class="msg_menu_action_text action_disable">' + obj["global_status"] + '</span>',
                                id: 'menu_action_sig_disable',
                                classname: 'menu_act_item',
                                value: 'sig_disable',
                                onclick: {
                                    fn: function() {
                                        wij_display_modal_dlg( "/waf/base_signature_disable/add?signature_id="+sig+"&session_id="+session_id , {'width': 400, 'height': 205});
                                    }
                                }
                            });
                            //html += " (<a  onclick=\"wij_display_modal_dlg('/waf/base_signature_disable/add?signature_id="+sig+"&session_id="+session_id+"', {'width': 400, 'height': 150});\">"+ obj["global_status"] +"</a>)</td>";
                        }
                        else
                        {
                            html += "</td>";
                        }
                        var menu_actions = [main_actions];
                        if(view_sig_action){
                            menu_actions.push([view_sig_action]);
                        }
                        msg_menu_actions[msg_menu_count] = menu_actions;
                        msg_menu_count++;
                        need_msg_menu = true;
                    }
                    else if(i == "msg" && hpc_link)
                    {
                        var main_actions = [];
                        n = n + 1;
                        html += " colspan = \""+(2*cols-1)+"\">";
                        if(except != "" && hpc_except_url != ""){
                             if(obj["sub_type"] == "Illegal Character in URL"|| obj["sub_type"] == "NULL Character in URL" || obj["sub_type"] == "Odd and Even Space Attack"){
                                html += '<label><span>' +val+ '</span></label>';
                            }else{
                                html += '<label class="msg_menu_button" onclick="DetailsWindow.msgMenuClick(this, ' +msg_menu_count+ ');"><span class="msg_menu_button_text">' +val+ '</span></label>';
                            }
                            main_actions.push({
                                text: '<span class="msg_menu_action_text action_block">' + except + '</span>',
                                id: 'menu_action_hpc_except',
                                classname: 'menu_act_item view_sig',
                                value: 'hpc_except',
                                onclick: {
                                    fn: function() {
                                        wij_display_modal_dlg( hpc_except_url, {'width': 400, 'height': 205});
                                    }
                                }
                            });
                            //html += " (<a  onclick=\"wij_display_modal_dlg('" + hpc_except_url +"', {'width': 430, 'height': 150});\">"+ except +"</a>)";
                        } else {
                            html += val;
                        }
                        html += "</td>";
                        msg_menu_actions[msg_menu_count] = [main_actions];
                        msg_menu_count++;
                        need_msg_menu = true;
                    }
                    else if(i == "msg" && is_cookie_poison)
                    {
                        var end = val.indexOf('];');
                        if(end == -1) end = val.length;
                        var cookie_name = val.substring(val.indexOf('(')+1,val.indexOf(')'));
                        var old_value = trimSpace(val.substring(val.indexOf('[')+1,val.indexOf('-&gt;')));

                        var corrupted_value = trimSpace(val.substring(val.indexOf('-&gt;')+5,end));

                        var domain_begin = val.indexOf('Domain:');
                        var path_begin = val.indexOf('; Path:');
                        var poison_domain = '';
                        if(domain_begin != -1) 
                            poison_domain = trimSpace(val.substring(domain_begin+7,path_begin));

                        var poison_path = '';
                        if(path_begin != -1)
                            poison_path = trimSpace(val.substring(path_begin+7,val.length));

                        n = n + 1;
                        html += " colspan = \""+(2*cols-1)+"\">";
                        html += "<table width=\"100%\">";
                        html += "<tr><td colspan=\"2\" style=\" border-right-style: hidden;\">"+$.getInfo("cookie_poison")+"</td></tr>";
                        html += "<tr><td width=\"110px\">"+$.getInfo("cookie_name")+"</td><td style=\" border-right-style: hidden;\">"+cookie_name+"</td></tr>";
                        html += "<tr><td>"+$.getInfo("domain")+"</td><td style=\" border-right-style: hidden;\">"+poison_domain+"</td></tr>";
                        html += "<tr><td>"+$.getInfo("path")+"</td><td style=\" border-right-style: hidden;\">"+poison_path+"</td></tr>";
                        html += "<tr><td>"+$.getInfo("old_value")+"</td><td style=\" border-right-style: hidden;\">"+old_value+"</td></tr>";
                        html += "<tr><td>"+$.getInfo("corrupted_value")+"</td><td style=\" border-right-style: hidden;\">"+corrupted_value+"</td></tr>";
                        html += "</table>";
                        html += "</td>";
                    }                    
                    //common fields, just display
                    else if(i == "http_agent" || i == "msg")
                    {
                        n = n + 1;
                        html += " colspan = \""+(2*cols-1)+"\">" + val + "</td>";
                    }
                    else if(i == "http_retcode")
                    {
                        html += ">" + (val==0 ? "":val) + "</td>";
                    }
                    else if(i == "false_positive_mitigation")
                    {
                        if(val == "yes")
                        {
                            n = n + 1;
                            html += " colspan = \""+(2*cols-1)+"\"><span style=\"vertical-align: bottom;\"><img src=\"/images/status_enabled.png\" /></span>&nbsp;Enabled</td>";
                        }
                        else if (val == "no")
                        {
                            n = n + 1;
                            html += " colspan = \""+(2*cols-1)+"\"><span style=\"vertical-align: bottom;\"><img src=\"/images/status_disabled.png\" /></span>&nbsp;Disabled</td>";
                        }
                    }
                    else
                    {
                        html += ">" + val + "</td>";
                    }                    
                }

                if (n % cols == 0) {
                    width = "";
                    row_num++;
                    html += "</tr>";
                }

                rows.push(html);
            }
        }
        elems.push(rows.join(""));

        if (n % cols != 0) {
            while (n++ % cols != 0) {
                row_num++;
                elems.push("<td class=\"label\"></td><td class=\"value\"></td>");
            }
        }
        elems.push("</tr>");

        elems.push("</table>");

        if(need_msg_menu)
        {
            elems.push('<div class="msg_menu_holder"></div>');
        }

        if(obj && (obj["src"] || obj["src_port"]))
        {
            //connection info
            elems.push("<div style=\"height: 5px;\"></div>");
            elems.push("<table cellspace=\"1\" cellpadding=\"0\" class=\"list log_details pre\" style=\"table-layout:fixed\">");
            elems.push("<tr class=\"head\"><td width=\"100%\"><b>"+$.getInfo("connection")+"</b></td></tr>");
            elems.push("<tr class=\"even\"><td width=\"100%\" class=\"value\">" + 
                    "<span class=\"country_flag country_"+ obj["country_flag"]+"\"></span>&nbsp;"+ obj["src"] + ":" + obj["src_port"] + "  ->  " +
                    obj["dst"] + ":" + obj["dst_port"] +
                        "</td></tr>");
            elems.push("</table>");
            //end for build disk log table
        }   
        if(pattern)
        {
            elems.push("<div style=\"height: 5px;\"></div>");
            elems.push("<table cellspace=\"1\" cellpadding=\"0\" class=\"list log_details pre\" style=\"table-layout:fixed\">");
            elems.push("<tr class=\"head\"><td width=\"100%\"><b>"+$.getInfo("pattern")+"</b></td></tr>");
            elems.push("<tr class=\"even\"><td width=\"100%\" class=\"value\">" + pattern +"</td></tr>");
            elems.push("</table>");
        }             

        if(obj && obj["pcap_id"])
        {
            //from pcap_id get pactet log table
            elems.push("<div id=\"packet_"+obj["pcap_id"]+"\" ></div>");
            function aggCallback(result){ 
                     var head_table = $j("#head_insert_"+ obj["pcap_id"]);
                     if(head_table.length > 0) return; 
                     var table = DetailsWindow.buildtable(result,1,"insert_"+obj["pcap_id"]); 
                      $j("#packet_"+obj["pcap_id"]).append(table) ;
                    }
	    	    var logfile = obj["logfile"] ? obj["logfile"] : document.forms[0].log.value;
                    var agg_url = "/log_aggregate/getLogByID";
                    var agg_data = {msgID:obj["pcap_id"],logType:document.forms[0].logType.value,is_aggregate:0, logfile: logfile};
                    $j.post(agg_url,agg_data,function(data){
                        if(data)aggCallback(data);
                    },"json");
            return $(elems.join(""));
        }           
        if(head != null){
            //packet header
            elems.push("<div style=\"height: 5px;\"></div>");
            elems.push("<table id=\"head_"+id+"\" cellspace=\"0\" cellpadding=\"0\" class=\"log_details\" style=\"table-layout:fixed\">");
            elems.push("<tr class=\"head\"><td width=\"100%\"><b>"+$.getInfo("packetheader")+":</b></td></tr>");           
            var items = 0; 
            for(var i in head)
            { 
                var key = i;
                /*for mutiple same key*/
                var len = i.lastIndexOf(":");
                if(len != -1) key = key.substr(0,len);
                elems.push("<tr class=\"even\"><td class=\"value\" width=\"100%\" style=\"border-bottom: 0px;\" padding=\"0px\">");

		var patternCon = '';
		if((match_info == "1") && (pattern.indexOf(i) == 0))
		{
			patternCon = trimSpace(pattern.substr(i.length,pattern.length));
		}
                var whole_highlight = (match_info == "1") && (pattern.indexOf(i) == 0) && (head[i].indexOf(patternCon) == 0);
                //key
                if(items == 0)
                    elems.push("<span style=\"color:blue\"><b>" + key + "</b></span>");
                else if(pattern != null && pattern.length > 0 && key != "" && key.indexOf(pattern) != -1 && match_info == "1"){
                    key = key.replace(pattern, "<span style=\"background-color: #ffff00\">" + pattern +"</span>");
                    elems.push("<span style=\"color:blue\">" + key + "</span>:");
                }else if(whole_highlight)
                    elems.push("<span style=\"background-color: #ffff00\">" + i + "</span>");
                else
                    elems.push("<span style=\"color:blue\">" + key + "</span>:");

                //value
                //highlight context only in head
                var context = "";
                if(pattern != null && pattern.length > 0 && head[i] != "" && head[i].indexOf(pattern) != -1 && match_info == "1")
                {
                    context = head[i].replace(pattern, "<span style=\"background-color: #ffff00\">" + pattern +"</span>");
                }else if(whole_highlight)
                    context = head[i].replace(patternCon, "<span style=\"background-color: #ffff00\">" + patternCon +"</span>");
                else
                {
                    context = head[i];
                }

                elems.push(" <span>" + context +"</span></tr>");

                items++;       
            } 
            elems.push("</table>");
            //end packet header     
        }

        if(packet != null && packet.length > 0)
        {
            //packet data
            var pid = 0;
            if(obj && obj.msg_id) pid = obj.msg_id;
            elems.push("<div style=\"height: 5px;\"></div>");
            elems.push("<table cellspace=\"1\" cellpadding=\"0\" class=\"list log_details pre\" style=\"table-layout:fixed\">");
    	    elems.push("<tr class=\"head\" onclick=\"DetailsWindow.trigger_div('packet"+pid+"')\"><td width=\"100%\">");
    	    elems.push("<img id=\"imgs_packet"+pid+"\" src=\"/theme/images/twistie_expanded.gif\" style=\"display: '';\">");
    	    elems.push("<img id=\"imgh_packet"+pid+"\" src=\"/theme/images/twistie_collapsed.gif\" style=\"display: none;\">");
    	    elems.push("<b>" + $.getInfo("packet") + ":</b></td></tr>");
    	    elems.push("<tr><td width=\"100%\"><div id=\"div_packet"+pid+"\" width=\"100%\"><table class=\"log_details\" style=\"width: 100%; border-right: 0px;\">");

            var context = "";
            if(pattern != null && pattern.length > 0 && packet.indexOf(pattern) != -1 && match_info == "4")
            {
                pattern = pattern.replace(/[ ]/g,"&nbsp;");
                packet = packet.replace(/[ ]/g,"&nbsp;");
                context = packet.replace(pattern, "<span style=\"background-color:#ffff00\">"+pattern+"</span>");
            }
            else
            {
                context = packet;
                context = context.replace(/[ ]/g,"&nbsp;");
            }
            context = context.replace(/\r\n/g,"<br/>");            
            elems.push("<tr class=\"even\"><td class=\"value\">" + context + "</td></tr>");
            
            //else
            //{
            //  elems.push("<tr class=\"odd\"><td class=\"value\">No data found</td></tr>");
            //}
    	    elems.push("</table></div></td></tr>");
    	    elems.push("</table>");
        }

	//hex format for raw body
	if(raw_packet != null && raw_packet.length > 0)
	{
        var pid = 0;
        if(obj && obj.msg_id) pid = obj.msg_id;
		elems.push("<div style=\"height: 5px;\"></div>");
        if(raw_packet.length > 32)
        {
            elems.push("<div style=\"max-height: 650px;min-height: 60px;overflow-y:auto;\">");
        }else{
            elems.push("<div>");
        }        
		elems.push("<table cellspace=\"1\" cellpadding=\"0\" class=\"log_details\" stype=\"table-layout:fixed\">");
		elems.push("<tr class=\"head\" onclick=\"DetailsWindow.trigger_div('hexpacket"+pid+"')\"><td width=\"100%\">");
		elems.push("<img id=\"imgs_hexpacket"+pid+"\" src=\"/theme/images/twistie_expanded.gif\" style=\"display: '';\">");
		elems.push("<img id=\"imgh_hexpacket"+pid+"\" src=\"/theme/images/twistie_collapsed.gif\" style=\"display: none;\">");
		elems.push("<b>" + $.getInfo("hex_packet") + ":</b></td></tr>");

		//head
		elems.push("<tr><td width=\"100%\"><div id=\"div_hexpacket"+pid+"\" width=\"100%\"><table class=\"log_details\" style=\"width: 100%; border-right: 0px\">");
		elems.push("<tr class=\"head\"><td width=\"8%\" style=\"border-right: 0px;\">" + $.getInfo("address") +"</td>");

		for(var i = 0; i < 16; i++)
		{
			elems.push("<td width=\"3%\" style=\"border-right: 0px;\">"+parseInt(i, 10).toString(16).toUpperCase()+"</td>");
		}

		elems.push("<td width=\"2%\" style=\"border-right:0px\"></td>");
		elems.push("<td width=\"42%\">" + $.getInfo("dump") +"</td>");
		elems.push("</tr>");

        for(var i = 0; i < raw_packet.length;i++)
        {
            elems.push("<tr>");
            elems.push("<td style=\"border-right: 0px;\">" + raw_packet[i].addr.toUpperCase() + "</td>");
            for(var j = 0;j < raw_packet[i].content.length;j++)
            {                
                elems.push("<td style=\"border-right: 0px;\">"+ raw_packet[i].content[j].toUpperCase() +"</td>");
            }
            elems.push("<td style=\"border-right: 0px;\"></td>");
            elems.push("<td style=\"border-right: 0px;\">" + raw_packet[i].dump.replace(/[ ]/g,"&nbsp;") + "</td>");
            elems.push("</tr>");
        }
/*
		function hex_format(num, length)
		{
			if(typeof num !== "string")
				return "NaN";

			var len = num.length;

			var ret = "";
			for(var i = 0; i < length-len; i++)
			{
				ret += "0";
			}

			ret += num;

			return ret;
		}

		var lines = parseInt(raw_packet.length / 16);
		if(raw_packet.length % 16 != 0)
			lines++;
		//content
		for(var i = 0; i < lines; i++)
		{
			elems.push("<tr>");
			var addr = i*16;
			addr = parseInt(addr, 10).toString(16);
			elems.push("<td style=\"border-right: 0px;\">" + hex_format(addr, 8) + "</td>");

			for(var j = 0; j < 16; j++)
			{
				var c, ch;
				if(((i*16)+j) < raw_packet.length)
				{
				        c = raw_packet.charCodeAt((i*16)+j);
					ch = c.toString(16);
					ch = hex_format(ch, 2);
				}
				else
					ch = "";
				elems.push("<td style=\"border-right: 0px;\">"+ ch +"</td>");
			}

			elems.push("<td style=\"border-right: 0px;\"></td>");
			var context;
			if(i != lines-1)
				context = raw_packet.substring(i*16, (i+1)*16);
			else
				context = raw_packet.substring(i*16, raw_packet.length);

			var fin_context = "";
			for(var j = 0; j < context.length; j++)
			{
				fin_context += context[j];
				if(j != context.length-1)
					fin_context += " ";
			}

			elems.push("<td>" + fin_context + "</td>");

			elems.push("</tr>");
		}
*/
		elems.push("</table></div></td></tr>");
		elems.push("</table></div>");
	}

        if(args && args.length > 0)
        {
            //parameters table
            elems.push("<div style=\"height: 5px;\"></div>");
            elems.push("&nbsp;<b style=\"font-size: 10px;\">"+$.getInfo('parameters')+"</b>");
            elems.push("<table cellspace=\"1\" cellpadding=\"0\" class=\"list log_details pre\" style=\"table-layout:fixed\">");
            elems.push("<tr class=\"head\"><td width=\"30%\"><b>"+$.getInfo("name")+"</b></td><td width=\"70%\"><b>"+$.getInfo("value",flt_lang)+"</b></td></tr>");

            for(var i = 0; i < args.length; i++)
            {
                //highlight context in only parameters
                var key_str = "";
                var context = "";
                if(pattern != null && pattern.length > 0 && match_info == "3")                    
                {
                    if(args[i].key != "" && args[i].key.indexOf(pattern) != -1 )
                    {
                        key_str = args[i].key.replace(pattern,"<span style=\"background-color:#ffff00\">"+pattern+"</span>");
                    }else{
                        key_str = args[i].key;
                    }
                    if(args[i].val != "" && args[i].val.indexOf(pattern) != -1 )
                    {
                        context = args[i].val.replace(pattern,"<span style=\"background-color:#ffff00\">"+pattern+"</span>");    
                    }else{
                        context = args[i].val;
                    }     
                }
                else
                {
                    key_str = args[i].key;
                    context = args[i].val;
                }
                elems.push("<tr class=\"even\"><td class=\"value\">" + 
                        key_str + 
                        "</td><td class=\"value\">" + 
                        context +
                        "</td></tr>");
            }

          elems.push("</table>");
        }
        if(cookies && cookies.length > 0)
        {        
            //cookies table
            elems.push("<div style=\"height: 5px;\"></div>");
            elems.push("&nbsp;<b style=\"font-size: 10px;\">Cookies:</b>");
            elems.push("<table cellspace=\"1\" cellpadding=\"0\" class=\"list log_details pre\" style=\"table-layout:fixed\">");
            elems.push("<tr class=\"head\"><td width=\"30%\"><b>"+$.getInfo("name")+"</b></td><td width=\"70%\"><b>"+$.getInfo("value",flt_lang)+"</b></td></tr>");

            for(var i = 0; i < cookies.length; i++)
            {
                //highlight context only in cookies
                var key_str = "";
                var context = "";
                if(pattern != null && pattern.length > 0 && match_info == "2")
                {
                    if(cookies[i].key != "" && cookies[i].key.indexOf(pattern) != -1 )
                    {
                        key_str = cookies[i].key.replace(pattern,"<span style=\"background-color:#ffff00\">"+pattern+"</span>");
                    }else{
                        key_str = cookies[i].key;
                    }
                    if(cookies[i].val != "" && cookies[i].val.indexOf(pattern) != -1 )
                    {
                        context = cookies[i].val.replace(pattern,"<span style=\"background-color:#ffff00\">"+pattern+"</span>");    
                    }else{
                        context = cookies[i].val;
                    }
                }
                else
                {
                    key_str = cookies[i].key;
                    context = cookies[i].val;
                }

                elems.push("<tr class=\"even\"><td class=\"value\">" +
                        key_str +
                        "</td><td class=\"value\">" +
                        context +
                        "</td></tr>");
            }
        
          elems.push("</table>");
        }
        if(files && files.length > 0)
        {        
            //files table
            elems.push("<div style=\"height: 5px;\"></div>");
            elems.push("&nbsp;<b style=\"font-size: 10px;\">"+$.getInfo('files')+"</b>");
            elems.push("<table cellspace=\"1\" cellpadding=\"0\" class=\"list log_details pre\" style=\"table-layout:fixed\">");
            elems.push("<tr class=\"head\"><td width=\"100%\"><b>"+$.getInfo("name")+"</b></td></tr>");
            var match = match_info.substr(match_info.lastIndexOf("<")+1,match_info.lastIndexOf(">")-2);
            
            for(var i = 0; i < files.length; i++)
            {
                //highlight context only in cookies
                var context = "";
                if(files[i].key != "" && files[i].key.indexOf(match) != -1 && match_info && match_info[0] == 5)
                {
                    context = files[i].key.replace(match,"<span style=\"background-color:#ffff00\">"+match+"</span>");
                }
                else
                {
                    context = files[i].key;
                }

                elems.push("<tr class=\"even\"><td class=\"value\">" +
                        context +
                        "</td></tr>");
            }
        
          elems.push("</table>");
        }
        if(aggregate)
        {
            var date = new Date();
            var new_table_id = date.getTime();
            //aggregate table
            elems.push("<div style=\"height: 5px;\"></div>");
            //elems.push("<div style=\"height: 20px;padding:5px\" align=\"left\"><b>Log Aggregation:</b></div>");
            if(aggregate.count > 1){                
                elems.push("<table cellspace=\"1\" cellpadding=\"0\" class=\"list log_details pre\" style=\"table-layout:fixed\">");
                elems.push("<tr class=\"odd\"><td width=\"30%\"><b>"+$.getInfo('date')+"</b></td><td width=\"70%\"><b>"+aggregate.date+"</b></td></tr>"); 
                elems.push("<tr class=\"odd\"><td width=\"30%\"><b>"+$.getInfo('type')+"</b></td><td width=\"70%\"><b>"+aggregate.aggre_name+"</b></td></tr>"); 
                elems.push("<tr><td colspan = 2><table id=\"log_aggregate"+new_table_id+"\" width=\"100%%\" style=\"background-color: #fff;border-width:1px 1px;\" class=\"yui-skin-sam yui-panel\">");
                elems.push("<tr class=\"head\"><td width=\"10%\"><b>"+$.getInfo('msg_id')+"</b></td>"
                    +"<td width=\"25%\"><b>"+$.getInfo('src')+"</b></td>"
                    +"<td width=\"25%\"><b>"+$.getInfo('dst')+"</b></td>"
                    +"<td width=\"40%\"><b>"+$.getInfo('http_url')+"</b></td></tr>");
            }else{
                elems.push("<div id=\"log_aggregate"+new_table_id+"\"></div>");
            }
            buildTable_aggregate(aggregate.date,aggregate.type,aggregate.signature,aggregate.viewline,aggregate.msg_id,aggregate.count,new_table_id);
            if(aggregate.count > 1) {
                elems.push("</table></td></tr></table>");
            }
        }
        return $(elems.join(""));
    }

    function trigger_div(id)
    {
	    var div = document.getElementById("div_"+id);
	    var imgs = document.getElementById("imgs_"+id);
	    var imgh = document.getElementById("imgh_"+id);

	    if(!div || !imgs || !imgh)
		    return;

	    if(div.style.display == 'none')
	    {
		    div.style.display = '';
		    imgs.style.display = '';
		    imgh.style.display = 'none';
	    }
	    else
	    {
		    div.style.display = 'none';
		    imgs.style.display = 'none';
		    imgh.style.display = '';
	    }
    }

    function buildTable_aggregate(date,type,signature,viewline,msg_id,count,new_table_id)
    {
        function aggCallback(result){
            var agg_html = "";
            var last_msgid = 0;
            for(var i = 0 ; i <result.length ;i++)
            {
                var msgID = result[i].msg_id;
                var logfile = result[i].logfile;
                var index = msgID;
                if(index<10000) index = index*1000;
                if(count > 1){
                    if(i%2 == 0) 
                        agg_html += "<tr class=\"grey\"";
                    else
                        agg_html += "<tr";

                    agg_html += " onclick='javascript:update_rows("+index+", "+index+", "+index+");get_log_by_msgID("+msgID+", \""+logfile+"\");'><td width=\"20%\"> ";
                    
                    agg_html += "<img id=\"imgs_"+(index)+"\" src='/theme/images/twistie_expanded.gif' style=\"display:none\" >"
                        +"<img id=\"imgh_"+(index)+"\" src='/theme/images/twistie_collapsed.gif' style=\"display:''\" >"
                        +"<b>"+msgID+"</b></td>"
                        +"<td width=\"25%\"><b>"+result[i].src+"</b></td>"
                        +"<td width=\"25%\"><b>"+result[i].dst+"</b></td>"
                        +"<td width=\"30%\"><b>"+result[i].url+"</b></td></tr>"
                        +"<tr id=\"tr_"+index+"\" style=\"display:none\"><td colspan=4><div style=\"background-color: #e8e7f1\" id=\"detail_"+msgID+"\" ></div></td></tr>";                     
                }else{
                    $("#log_aggregate"+new_table_id).append("<div style=\"background-color: #e8e7f1\" id=\"detail_"+msgID+"\" ></div>");
                    get_log_by_msgID(msgID, logfile);
                    break;
                }
                last_msgid = msgID; 
            }
            if(count > 1) $("#log_aggregate"+new_table_id).append(agg_html);
            if(viewline > result.length) $("#aggregate_more").remove();
            if(last_msgid && viewline == result.length)
            {
                $("#aggregate_more").remove();
                $("#log_aggregate"+new_table_id).append("<tr class=\"head\" id=\"aggregate_more\"><td  colspan = 4><a href='javascript:;' onclick=\"DetailsWindow.aggregatetable('"+date+"','"+type+"','"+signature+"','"+viewline+"','"+last_msgid+"','"+count+"','"+new_table_id+"')\">More>></a></td></tr>");
            }
        };
        var agg_url = "/log_aggregate";
        var agg_data = {date:date,type:type,signature:signature,viewline:viewline,msg_id:msg_id};
        $.post(agg_url,agg_data,function(data){
            if(data)aggCallback(data.result);
        },"json");        
    }
    return {
        "initialize" : initialize,
        "show" : showRowDetailsMenu,
        "hide" : hideRowDetails,
        "move" : toggleDetailsPanelLocation,
        "click" : showRowDetailsClick,
        "keypress" : handleRowDetailKeyPress,
        "buildtable":buildTable_new,
        "aggregatetable":buildTable_aggregate,
        "trigger_div":trigger_div,
        "msgMenuClick":msgMenuClick
    };
})(jQuery);
