/*global escapeHTML, setQueryValue, fweb*/
/* exported DetailsWindow, FlexLayout */


var FlexLayout = (function($) {
    'use strict';
    var directions = {
        south: {
            size: 'height',
            scale: 1,
            coord: 'y'
        },
        east: {
            size: 'width',
            scale: 1,
            coord: 'x'
        },
        west: {
            size: 'width',
            scale: -1,
            coord: 'x'
        },
        north: {
            size: 'height',
            coord: 'y',
            scale: -1
        },
        center: {
            size: 'height',
            coord: 'y',
            scale: 0
        }
    };
    var clsHidden = 'layout-pane-hidden';
    /**
    * Implements the api for a jquery.layout but uses flexbox instead
    * if flexbox is not available, fallback on jquery.layout.
    * @TODO: move to a new file
    * @param {jQuery()} $target Target query selector that contains panes.
    * @param {Object} params {
    *   [pane]:{paneSelector:{String},
    *   [resizable: {Boolean}],
    *   [onresize_end: function(pane) {}],
    *   [onclose_end: function(pane) {}],
    *   [onopen_end: function(pane) {}],
    *   [initClosed: {Boolean}]}
    * } where [pane] is one of 'north','south','east','west','center'
    */
    function FlexLayout($target, params) {
        //{'center':{'paneSelector':'#main_window'},
        //'south':{'paneSelector':'#logview-details','resizable':true,
        //'togglerLength_open':0,'togglerLength_closed':0,
        //'onresize_end': function(){}}
        this.params = params;
        this.$target = $target;
        this.state = {};
        this.panes = Object.keys(params).reduce(get_panes.bind(this), {});
        //TODO: generalize this

        function get_panes(panes, name) {
            /* jshint validthis: true */
            var pane = this._initPane(name);
            if (pane) {
                panes[name] = pane;
            }
            return panes;
        }
    }
    FlexLayout.prototype = {
        $target: null,
        state: null,
        _initPane: function(name) {

            if (!(name in directions)) {
                return null;
            }
            var params = this.params[name],
                ps = params && params.paneSelector,
                $pane = ps && this.$target.find(ps);
            $pane.addClass('flex-layout');
            if (params.resizable) {

                params.resizer = this.$target.find('.flex-layout.ui-layout-resizer');
                if (!params.resizer.length) {
                    params.resizer = $('<div>', makeResizer(this));
                }
		if(log_type != 1){
			params.resizer.css("cursor", params.resizerCursor);
			params.resizer.css("width", "4px");
		
		
                	if (params.togglerContent_open) {
                    		params.resizer.append(makeToggler(this, params.togglerContent_open, 'open'));
                	}
                	if (params.togglerContent_closed) {
                    		params.resizer
                        		.append(makeToggler(this, params.togglerContent_closed, 'closed'));
                	}
		}
                $pane.before(params.resizer);
                if ($.support.transitionEvent) {
                    var animationEvent = 'transitionend.FlexLayout';
                    $pane.off(animationEvent).on(animationEvent, function() {
                        if (params.resizer) {
                            params.resizer.toggleClass('animating', false);
                        }
                    });
                }
                if (this.params.initClosed) {
                    this.hide(name);
                }
                this._resizeEnd(name, null, null, true);
            }
            return $pane.length ? $pane : null;
            function cancelDrag() { return false }
            function makeToggler(fl, content, state) {
                return $('<div>', {
                    addClass: 'ui-layout-toggler ui-layout-toggler-' + name +
                        ' ui-layout-toggler-' + state +
                        ' ui-layout-toggler-' + name + '-' + state,
                    title: $.getInfo(state === 'open' ? 'close' : 'open'),
                    append: $('<span>', {
                        addClass: 'content content-' + state,
                        append: content
                    }),
                    mousedown: function(event) {
                        event.stopPropagation();
                    },
                    click: function() {
                        fl.toggle(name);
                        fl._resizeEnd(name);
                    }
                }).on('dragstart', cancelDrag);
            }
            function makeResizer(fl) {
                var LMB = 1, DRAG_THRESHHOLD = 2, HIDE_THRESHHOLD = 50;
                return {
                    addClass: 'flex-layout ui-layout-resizer ui-layout-resizer-' + name,
                    mousedown: function(evt) {
                        if (evt.which === LMB) {
                            var hidden = $pane.hasClass(clsHidden),
                                distance = 0,
                                pos, size, end, showSize,
                                d = directions[name],
                                resizeLast = null;
                            resizeLast = {x: evt.pageX, y: evt.pageY};
                            immediate(true);
                            var $resizeCapture = $('<div>', {
                                    addClass: 'layout-resize-capture ' +
                                        'no-select flex-layout-resizing-' + name
                                })
                                .appendTo('body');
                            $resizeCapture.bind('mousemove',  function(evt) {
                                if (evt.which === LMB && resizeLast) {
                                    pos = {x: evt.pageX, y: evt.pageY};
                                    size = $pane[d.size]();
                                    if (size < HIDE_THRESHHOLD && !end) {
                                        $pane[d.size](null);
                                        $pane.toggleClass(clsHidden, true);
                                        end = pos[d.coord];
                                        hidden = true;
                                    } else {
                                        $pane[d.size](size + resizeLast[d.coord] - pos[d.coord]);
                                    }
                                    distance += d.scale *
                                        Math.abs(pos[d.coord] - resizeLast[d.coord]);
                                    resizeLast = pos;
                                    //calculate size based on pointer location hide (end)
                                    showSize = end && (end - pos[d.coord]) * d.scale;
                                    if (showSize > HIDE_THRESHHOLD &&
                                            showSize > 0) {
                                        $pane.toggleClass(clsHidden, false);
                                        $pane[d.size](showSize);
                                        end = null;
                                        hidden = false;
                                    }
                                } else {
                                    cancel();
                                }
                            }.bind(this));
                            $resizeCapture.bind('mouseup', cancel);
                        }
                        function cancel(evt) {
                            if (!evt || evt.which === LMB) {
                                $resizeCapture.remove();
                                resizeLast = null;

                                //handle click

                                if (evt && evt.which === LMB && distance < DRAG_THRESHHOLD) {
                                    fl.toggle(name);
                                    size = fl.state[name].size;
                                    hidden = null;
                                    immediate(false);
                                }

                                fl._resizeEnd(name, size, hidden);
                                immediate(false);
                            }
                        }
                        function immediate(value) {
                            $pane.toggleClass('immediate', value);
                            params.resizer.toggleClass('dragging', value);
                        }
                    }
                };
            }
        },
        _resizeEnd: function(name, size, hidden, silent) {
            var params = this.params[name],
                ps = params && params.paneSelector,
                $pane = ps && this.$target.find(ps),
                oldSize = this.state[name] && this.state[name].size;
            size = Math.round(size == null ? $pane[directions[name].size]() : size);
            hidden = hidden == null ? $pane.hasClass(clsHidden) : hidden;
            var wasClosed = this.state[name] && this.state[name].closed;
            if (hidden && this.state[name] && this.state[name].size) {
                size = this.state[name].size;
            }
            this.state[name] = {
                size: size,
                closed: hidden ? 1 : 0
            };
            if (params.resizer) {
                if ($.support.transitionEvent && !$pane.hasClass('immediate') &&
                        (oldSize !== undefined && oldSize !== size ||
                        wasClosed !== undefined && wasClosed !== hidden)) {
                    params.resizer.toggleClass('animating');
                }
                params.resizer.toggleClass('ui-layout-resizer-open ui-layout-resizer-' +
                    name + '-open', !hidden);
                params.resizer.toggleClass('ui-layout-resizer-closed ui-layout-resizer-' +
                    name + '-closed', hidden);
            }
            if (!silent) {
                if (wasClosed && !hidden && typeof params.onopen_end === 'function') {
                    params.onopen_end.call(null, name);
                } else if (!wasClosed && hidden && typeof params.onclose_end === 'function') {
                    params.onclose_end.call(null, name);
                } else if (typeof params.onresize_end === 'function') {
                    params.onresize_end.call(null, name);
                }
                //ensure center resize is called
                if (name !== 'center') {
                    this._resizeEnd('center');
                }
            }

        },
        sizePane: function(pane, size) {
            var $pane = this.getPane(pane);
            $pane[directions[pane].size](size);
        },
        show: function(pane) {
            this.toggle(pane, true);
        },
        open: function(pane) {
            this.show(pane);
        },
        hide: function(pane) {
            if (pane) {
                this.toggle(pane, false);
            } else {
                ['north', 'west', 'south', 'east'].forEach(this.hide.bind(this));
            }
        },
        toggle: function(pane, show) {
            var $pane = this.getPane(pane);
            if (show === undefined) {
                show = $pane.hasClass(clsHidden);
            }
            $pane.toggleClass(clsHidden, !show);
        },
        getPane: function(pane) {
            return this.$target.find(this.params[pane].paneSelector);
        }
    };
    return FlexLayout;
})(jQuery);

var DetailsWindow = (function($) {
    'use strict';
    var PERSIST_KEY = 'LogViewerSearchDetailWindowLayout';
    var DEFAULT_DETAIL_SIZE = 500;
    var state = {east: {size: DEFAULT_DETAIL_SIZE}};//fweb.util.persist.get(PERSIST_KEY) || 
    var OWASP_LINK = {
        "A1:2017-Injection":"https://www.owasp.org/index.php/Top_10-2017_A1-Injection",
        "A2:2017-Broken Authentication":"https://www.owasp.org/index.php/Top_10-2017_A2-Broken_Authentication",
        "A3:2017-Sensitive Data Exposure":"https://www.owasp.org/index.php/Top_10-2017_A3-Sensitive_Data_Exposure",
        "A4:2017-XML External Entities (XXE)":"https://www.owasp.org/index.php/Top_10-2017_A4-XML_External_Entities_(XXE)",
        "A5:2017-Broken Access Control":"https://www.owasp.org/index.php/Top_10-2017_A5-Broken_Access_Control",
        "A6:2017-Security Misconfiguration":"https://www.owasp.org/index.php/Top_10-2017_A6-Security_Misconfiguration",
        "A7:2017-Cross-Site Scripting (XSS)":"https://www.owasp.org/index.php/Top_10-2017_A7-Cross-Site_Scripting_(XSS)",
        "A8:2017-Insecure Deserialization":"https://www.owasp.org/index.php/Top_10-2017_A8-Insecure_Deserialization",
        "A9:2017-Using Components with Known Vulnerabilities":"https://www.owasp.org/index.php/Top_10-2017_A9-Using_Components_with_Known_Vulnerabilities"
    }
    var config = {
        'containerSelector': 'body',
        'mainPanelSelector': '#main_window',
        'detailsPanelSelector': '#logview-details',
        'contentBodySelector': '#contentBody',
        'detailsLocation': 'east',
        'size': {
            east: state.east.size
        },
        'resizerCursor': 'col-resize',
        'formatCallbacks': {},
        'rowData': [],
        'getRowCallback': function(row_id) { return config.rowData[row_id]; },
        'getRowLengthCallback': function() { return config.rowData.length; },
        'archiveData': [],
        'getArchiveCallback': null,
        'isShowThreatDetails': false,
        'langOverride': {},
        'validRowClasses': '.qlist_row,.odd,.even',
        // an array of column names (selectors) that should be hidden in the
        // details window. can contain strings or regexes, in which case the
        // column will be ignored if it matches the regex
        'hiddenColumns': [],
        // skip creating panels, layout and tabs
        // basicly for using the data from 'rowData'
        // and data of selected row from 'getRowCallback'
        // currently show popup detail dialog in the click event
        // TODO: define callback function to show popup detail dialog
        'dataOnly': false
    };
    var layout;
    var detailsPanel;
    var mainPanel;
    var selectedRowEntry;
    var selectedRowEntryIndex;
    var rows = [];
    var first_row;
    var msg_menu;
    var msg_menu_actions = [];
    var msg_menu_count = 0;
    var scores_info = ['level_info', 'level_low', 'level_medium', 'level_high', 'level_critical'];
    var threshold_info = ['threshold_critical', 'threshold_high', 'threshold_medium', 'threshold_low', 'threshold_info'];
    var threshold_turn = [2, 4, 5, 7, 10];
    var default_attack_column = ["date", "time", "policy", "service", "http_version", "http_host",  "http_method", "http_url", "monitor_status", "action", "threat_level", "srccountry", "signature_cve_id", "owasp_top10", "main_type", "sub_type", "signature_subclass", "signature_id", "msg"];
    var default_traffic_column = ["date", "time", "policy", "content_switch_name","server_pool_name", "status", "http_request_bytes", "http_response_bytes", "srccountry", "original_src", "original_srccountry", "service", "http_version", "http_method", "http_host", "http_url", "http_retcode"];

    function initialize(params) {
        var layout_params = {
            'initClosed': state.closed
        };
        var detail_loc;

        config = $.extend({}, config, params);

        rows = $(config.contentBodySelector)[0].rows;
        first_row = rows[0];
        /*msg_menu = new YAHOO.widget.Menu('msg_menu');
        msg_menu.hideEvent.subscribe(function(){
            $(".msg_menu_button").each(function(){
                $(this).removeClass("msg_menu_button_active");
            });
        });*/

        var jfirst = $(first_row);
        var i = 0;
        while (rows.length > i && !jfirst.is(config.validRowClasses)) {
            i++;
            first_row = rows[i];
            jfirst = $(first_row);
        }

        if (!config.dataOnly) {

            mainPanel = $(config.mainPanelSelector);
            detailsPanel = $(config.detailsPanelSelector);

            detail_loc = getDetailPaneLocation();

            // override layout settings for customized toggler display
            $.layout.config.resizers.cssReq = {};
            $.layout.config.togglers.cssReq = {};

            layout_params.center = {
                paneSelector: config.mainPanelSelector,
                onresize_end: refreshDisplay,
		        minWidth: 400
            };

            layout_params[detail_loc] = {
                paneSelector: config.detailsPanelSelector,
                resizable: true,
                resizerCursor: config.resizerCursor,
                togglerLength_open: 41,
                togglerLength_closed: 41,
                togglerAlign_open: 'right',
                togglerAlign_closed: 'right',
                togglerContent_open: '<a class="a_sprite db_show"/>',
                togglerContent_closed: '<a class="a_sprite db_all"/>',
                onopen_end: function() {
                    delete state.closed;
                    fweb.util.persist.put(PERSIST_KEY, state);
                },
                onclose_end: function() {
                    state.closed = 1;
                    fweb.util.persist.put(PERSIST_KEY, state);
                },
                onresize_end: function(local) {
                    var size = layout.state[local].size;
                    config.size[local] = size;
                    state[local].size = size;
                    fweb.util.persist.put(PERSIST_KEY, state);
                }
            };

            layout = new FlexLayout($(config.containerSelector), layout_params);
            if (rows.length > i) {
                //selectRow(first_row);
		      if(params.rowData[1] && params.rowData[1].aggregate)
                {
                    selectRow(rows[1]);
                }else{
                    selectRow(first_row);
                }
            }

            showRowDetailsMenu(true);            
        }
    }

    function sizeDetailPane() {
        var local = getDetailPaneLocation();
        if (local !== 'hidden') {
            layout.sizePane(local, config.size[local]);
            if($j.find('.ui-layout-resizer-closed').length > 0)
		layout._resizeEnd(local);
        }
	   if(log_type == 1) hideRowDetails();       
    }

    function refreshDisplay() {
        //var fixed_header = $(".qlist_fixed_column_header");
	    var body_header = $(".ql-body-table");
        //fixed_header.width(body_header.width());
        body_header.resize(function() { $j('#contentHead').qlist('refresh');})

    }
    function selectRow(row) {
        if (typeof row === 'undefined' || !$(row).is(config.validRowClasses)) {
            return;
        }

        if (typeof(selectedRowEntry) !== 'undefined') {
            $(selectedRowEntry).toggleClass('selected', false);
            selectedRowEntry = null;
            selectedRowEntryIndex = 0;
        }

        // set selected entry
        selectedRowEntry = row;
        selectedRowEntryIndex = row.rowIndex - 1;//(first_row != null ? first_row.rowIndex : 0);
        $(selectedRowEntry).addClass('selected');
    }

    function handleRowDetailKeyPress(e) {
        if (typeof(selectedRowEntryIndex) === 'undefined') {
            return;
        }

        var local = getDetailPaneLocation();
        var idx = selectedRowEntryIndex;
        var tr;

        if (e.keyCode !== $.ui.keyCode.END &&
            e.keyCode !== $.ui.keyCode.HOME &&
            e.keyCode !== $.ui.keyCode.UP &&
            e.keyCode !== $.ui.keyCode.DOWN) {
            return true;
        }

        if ($(e.target).is('html,body,td') === false) {
            return true;
        }

        if (e.keyCode === $.ui.keyCode.END) {
            idx = rows.length - 1;
        }
        if (e.keyCode === $.ui.keyCode.HOME) {
            idx = 0;
        }
        if (e.keyCode === $.ui.keyCode.UP) {
            idx--;
        }
        if (e.keyCode === $.ui.keyCode.DOWN) {
            idx++;
        }
        if (idx >= 0 && (tr = rows[idx])) {
            selectRow(tr);

            if (!layout.state[local].isHidden) {
                showRowDetails(tr);
            }

            // make sure that the selected row is visible
            scrollIntoViewAfterKeypress(tr, e.keyCode);

            return e.keyCode === $.ui.keyCode.END || e.keyCode === $.ui.keyCode.HOME;
        }
    }

    function msgMenuClick (elem, menuCount) {
        if(msg_menu && msg_menu.destroy)
        	msg_menu.destroy();

        msg_menu = new YAHOO.widget.Menu('msg_menu');
        msg_menu.hideEvent.subscribe(function(){
            $(".msg_menu_button").each(function(){
                $(this).removeClass("msg_menu_button_active");
            });
        });

        var $label = $j(elem), 
            msg_menu_holder = $label.closest('div').find('.msg_menu_holder')[0];

        $label.addClass("msg_menu_button_active");
        msg_menu.clearContent();
        msg_menu.addItems(msg_menu_actions[menuCount]);

        msg_menu.cfg.setProperty('context', [$label[0], 'tl', 'bl']);
        msg_menu.cfg.setProperty('width', $label.outerWidth() + 'px');
        msg_menu.render(msg_menu_holder);
        msg_menu.show(); 
    }

    function showRowDetailsMenu(noFx) {
        if (selectedRowEntry == null) {
            selectRow(first_row);
        }

        if (noFx) {
            $.fx.off = true;
        }

        sizeDetailPane();
        showRowDetails();
        $.fx.off = false;
    }

    // TODO: move to callback function
    function showRowDetailsDialog() {
        // function selectRow already set
        // the global varible selectedRowEntryIndex
        var html = buildDetailTable(1,
            config.getRowCallback(selectedRowEntryIndex));
        fweb.dialog(html, {
            resizable: true,
            title: $.getInfo('log_details'),
            width: 'auto',
            height: 'auto',
            maxWidth: 650,
            minWidth: 500,
            maxHeight: 700,
            minHeight: 200
        });
    }

    function showRowDetailsClick(e) {
        var target = e.target.parentNode;
        var type = e.type;
        while (target) {
            if (target.tagName === 'TR') {
                selectRow(target);
                if (type === 'click') {
                    if (!config.dataOnly && log_type != 1) {
                        var local = getDetailPaneLocation();
                        layout.open(local);
                        showRowDetails(target, e);
                    }
                } else if (type === 'dblclick') {
                    if (config.dataOnly) {
                        showRowDetailsDialog();
                    }
                }
                break;
            }

            if (target.parentNode) {
                target = target.parentNode;
            } else {
                return false;
            }
        }
	// add this for east
	sizeDetailPane();
        return true;
    }

    function getDetailPaneLocation() {
        return config.detailsLocation;
    }
    function thres_to_val(thres)
    {
        var i = 0;
        for(i = 0; i < threshold_turn.length; i++)
        {
            if(thres == threshold_turn[i])
                return i;
        }

        return -1;
    }
    function buildpackettable(row_entry, cols, id) {
        var lang_override;
        var elems = [];
        var rows = [];
        var html;
        var label;
        var row_class, label_class;
        var width = 100/cols;
        var n = 0;
        //disk log context
        var obj = row_entry.disk;
        var row_num = 0;
        var val;
        //pattern context
        var pattern = row_entry.pattern;
        //packet log context
        var packet = row_entry.packet;
        var raw_packet = row_entry.raw_packet;
        //match info: 1: head, 2: cookie, 3: args, 4: packet, 5: file
        var match_info = row_entry.match_info || "0";
        //parameters
        var args = row_entry.args;
        //cookies
        var cookies = row_entry.cookies;
        //files
        var files = row_entry.files;
        //head
        var head = row_entry.head;
        //aggregate
        var aggregate = row_entry.aggregate;      
        //msgID_detail
        var msgID_detail = row_entry.msg_id;  

        if(pattern) pattern= pattern.replace(/(^[ ]*)|([ ]*$)/g, "");    
        /* add this for ha topology*/      
        if(typeof(is_ha_log) !== 'undefined' && is_ha_log) {
            pattern = escapeHTML(pattern);
            packet = escapeHTML(packet);
            for(var i in args){
                args[i].key = escapeHTML(args[i].key);
                args[i].value = escapeHTML(args[i].value);
            } 
            for(var i in cookies){
                cookies[i].key = escapeHTML(cookies[i].key);
                cookies[i].value = escapeHTML(cookies[i].value);
            } 
            for(var i in files){
                files[i].key = escapeHTML(files[i].key);
                files[i].value = escapeHTML(files[i].value);
            } 
            for(var i in head){
                head[i] = escapeHTML(head[i]);
            } 
        }

        var need_msg_menu = false;

        var alert_only_url = "";//attack log protection exception 
        var except = "";
        var except_url = "";
        var hpc_except_url = "";
        var fpm = "";
        var fpm_url = "";

        lang_override = config["langOverride"];

        var tb = document.createElement("div");
        tb.id = "log_details_table";
        $(tb).width("100%");

        elems.push("<table id=\""+id+"\" cellspace=\"1\" cellpadding=\"0\" class=\"list log_details pre\" style=\"table-layout:fixed\">");

        //no log detail data, just return a null table
        if(row_entry == "")
        {
            elems.push("</table>");

            return $(elems.join(""));
        }

        //begin build disk log table
        //pre handle for urls
        for(var i in obj)
        {
            label = (lang_override && lang_override[i]) ? lang_override[i] : $.getInfo(i);
        }


        if (n % cols != 0) {
            while (n++ % cols != 0) {
                row_num++;
                elems.push("<td class=\"label\"></td><td class=\"value\"></td>");
            }
        }
        elems.push("</tr>");

        elems.push("</table>");

        if(need_msg_menu)
        {
            elems.push('<div class="msg_menu_holder"></div>');
        }
 
        if(pattern)
        {
            elems.push("<div style=\"height: 5px;\"></div>");
            elems.push("<table cellspace=\"1\" cellpadding=\"0\" class=\"list log_details pre\" style=\"table-layout:fixed\">");
            elems.push("<tr class=\"head\"><td width=\"100%\"><b>"+$.getInfo("pattern")+"</b></td></tr>");
            elems.push("<tr class=\"even\"><td width=\"100%\" class=\"value\">" + pattern +"</td></tr>");
            elems.push("</table>");
        }             
         
        if(head != null){
            //packet header
            elems.push("<div style=\"height: 5px;\"></div>");
            elems.push("<table id=\"head_"+id+"\" cellspace=\"0\" cellpadding=\"0\" class=\"list log_details\" style=\"table-layout:fixed\">");
            //elems.push("<tr class=\"head\"><td width=\"100%\"><b>"+$.getInfo("packetheader")+"</b></td></tr>"); 
            elems.push("<tr class=\"head\" onclick=\"DetailsWindow.trigger_div('packetheader"+id+"')\"><td width=\"100%\">");
            elems.push("<f-icon id=\"imgs_packetheader"+id+"\" class=\"fa-minus-square\" style=\"display: '';color: #646464;\"></f-icon>");
            elems.push("<f-icon id=\"imgh_packetheader"+id+"\" class=\"fa-plus-square\" style=\"display: none;color: #646464;\"></f-icon>");
            elems.push("<b>" + $.getInfo("packetheader") + ":</b></td></tr>");
            elems.push("<tr><td width=\"100%\"><div id=\"div_packetheader"+id+"\" width=\"100%\"><table class=\"list log_details\" style=\"width: 100%; border-right: 0px;\">");

            var items = 0; 
            for(var i in head)
            { 
                var key = i;
                /*for mutiple same key*/
                var len = i.lastIndexOf(":");
                if(len != -1) key = key.substr(0,len);
                elems.push("<tr class=\"even\"><td class=\"value\" width=\"100%\" style=\"border-bottom: 0px;\" padding=\"0px\">");

                var patternCon = '';
                if(pattern != null && pattern.length > 0 && (match_info == "1") && (pattern.indexOf(i) == 0))
                {
                    patternCon = trimSpace(pattern.substr(i.length,pattern.length));
                }
                var whole_highlight = (match_info == "1") && (pattern.indexOf(i) == 0) && (trimSpace(head[i]).indexOf(patternCon) == 0);

                //key
                if(items == 0 && !whole_highlight){

        		    if(pattern != null && pattern.length > 0 && key != "" && key.indexOf(pattern) != -1 && match_info == "1")
        			key = key.replace(pattern, "<label style=\"background-color: #ffff00\">" + pattern +"</label>");

                    if(key[0] == ':')
                        elems.push("<label><b>" + key + "</b></label>:");
                    else if(parseInt(key).toString() !== 'NaN')
                        elems.push("<label style=\"color:blue\">" + key + "</label>:");
                    else
                        elems.push("<label style=\"color:blue\"><b>" + key + "</b></label>");
                }
                else if(pattern != null && pattern.length > 0 && key != "" && key.indexOf(pattern) != -1 && match_info == "1"){
                    key = key.replace(pattern, "<label style=\"background-color: #ffff00\">" + pattern +"</label>");
                    elems.push("<label style=\"color:blue\">" + key + "</label>:");
                }else if(whole_highlight)
                    elems.push("<label style=\"background-color: #ffff00\">" + i + "</label>");
                else
                    elems.push("<label style=\"color:blue\">" + key + "</label>:");

                //value
                //highlight context only in head
                var context = "";
                if(pattern != null && pattern.length > 0 && head[i] != "" && head[i].indexOf(pattern) != -1 && match_info == "1")
                {
                    context = head[i].replace(pattern, "<label style=\"background-color: #ffff00\">" + pattern +"</label>");
                }else if(whole_highlight)
                    context = head[i].replace(patternCon, "<label style=\"background-color: #ffff00\">" + patternCon +"</label>");
                else
                {
                    context = head[i];
                }

                elems.push(" <label>" + context.trim() +"</label></tr>");

                items++;       
            } 
            //elems.push("</table>");
            elems.push("</table></div></td></tr>");
            elems.push("</table>");            
            //end packet header     
        }

        if(packet != null && packet.length > 0)
        {
            //packet data
            var pid = 0;
            if(obj && obj.msg_id) pid = obj.msg_id;
            elems.push("<div style=\"height: 5px;\"></div>");
            elems.push("<table cellspace=\"1\" cellpadding=\"0\" class=\"list log_details pre\" style=\"table-layout:fixed\">");
            elems.push("<tr class=\"head\" onclick=\"DetailsWindow.trigger_div('packet"+pid+"')\"><td width=\"100%\">");
            elems.push("<f-icon id=\"imgs_packet"+pid+"\" class=\"fa-minus-square\" style=\"display: '';color: #646464;\"></f-icon>");
            elems.push("<f-icon id=\"imgh_packet"+pid+"\" class=\"fa-plus-square\" style=\"display: none;color: #646464;\"></f-icon>");
            elems.push("<b>" + $.getInfo("packet") + ":</b></td></tr>");
            elems.push("<tr><td width=\"100%\"><div id=\"div_packet"+pid+"\" width=\"100%\"><table class=\"list log_details\" style=\"width: 100%; border-right: 0px;\">");

            var context = "";
            if(pattern != null && pattern.length > 0 && packet.indexOf(pattern) != -1 && match_info == "4")
            {
                pattern = pattern.replace(/[ ]/g,"&nbsp;");
                packet = packet.replace(/[ ]/g,"&nbsp;");
                context = packet.replace(pattern, "<span style=\"background-color:#ffff00\">"+pattern+"</span>");
            }
            else
            {
                context = packet;
                context = context.replace(/[ ]/g,"&nbsp;");
            }
            context = context.replace(/\r\n/g,"<br/>");            
            elems.push("<tr class=\"even\"><td class=\"value\">" + context + "</td></tr>");
            
            //else
            //{
            //  elems.push("<tr class=\"odd\"><td class=\"value\">No data found</td></tr>");
            //}
            elems.push("</table></div></td></tr>");
            elems.push("</table>");
        }

        //hex format for raw body
        if(raw_packet != null && raw_packet.length > 0)
        {
            var pid = 0;
            if(obj && obj.msg_id) pid = obj.msg_id;
            elems.push("<div style=\"height: 5px;\"></div>");
            if(raw_packet.length > 32)
            {
                elems.push("<div style=\"max-height: 650px;min-height: 60px;overflow-y:auto;\">");
            }else{
                elems.push("<div>");
            }        
            elems.push("<table cellspace=\"1\" cellpadding=\"0\" class=\"list log_details\" stype=\"table-layout:fixed\">");
            elems.push("<tr class=\"head\" onclick=\"DetailsWindow.trigger_div('hexpacket"+pid+"')\"><td width=\"100%\">");
            elems.push("<f-icon id=\"imgs_hexpacket"+pid+"\" class=\"fa-minus-square\" style=\"display: '';color: #646464;\"></f-icon>");
            elems.push("<f-icon id=\"imgh_hexpacket"+pid+"\" class=\"fa-plus-square\" style=\"display: none;color: #646464;\"></f-icon>");
            elems.push("<b>" + $.getInfo("hex_packet") + ":</b></td></tr>");

            //head
            elems.push("<tr><td width=\"100%\"><div id=\"div_hexpacket"+pid+"\" width=\"100%\"><table class=\"list log_details\" style=\"width: 100%; border-right: 0px\">");
            elems.push("<tr class=\"head\"><td width=\"8%\" style=\"border-right: 0px;\">" + $.getInfo("address") +"</td>");

            for(var i = 0; i < 16; i++)
            {
                elems.push("<td width=\"3%\" style=\"border-right: 0px;\">"+parseInt(i, 10).toString(16).toUpperCase()+"</td>");
            }

            elems.push("<td width=\"2%\" style=\"border-right:0px\"></td>");
            elems.push("<td width=\"42%\">" + $.getInfo("dump") +"</td>");
            elems.push("</tr>");

            for(var i = 0; i < raw_packet.length;i++)
            {
                elems.push("<tr>");
                elems.push("<td style=\"border-right: 0px;\">" + raw_packet[i].addr.toUpperCase() + "</td>");
                for(var j = 0;j < raw_packet[i].content.length;j++)
                {                
                    elems.push("<td style=\"border-right: 0px;\">"+ raw_packet[i].content[j].toUpperCase() +"</td>");
                }
                elems.push("<td style=\"border-right: 0px;\"></td>");
                elems.push("<td style=\"border-right: 0px;\">" + raw_packet[i].dump.replace(/[ ]/g,"&nbsp;") + "</td>");
                elems.push("</tr>");
            }

            elems.push("</table></div></td></tr>");
            elems.push("</table></div>");
        }

        if(args && args.length > 0)
        {
            //parameters table
            elems.push("<div style=\"height: 5px;\"></div>");
            elems.push("&nbsp;<b style=\"font-size: 15px;\">"+$.getInfo('parameters')+"</b>");
            elems.push("<table cellspace=\"1\" cellpadding=\"0\" class=\"list log_details pre\" style=\"table-layout:fixed\">");
            elems.push("<tr class=\"head\"><td width=\"30%\"><b>"+$.getInfo("name")+"</b></td><td width=\"70%\"><b>"+$.getInfo("value")+"</b></td></tr>");

            for(var i = 0; i < args.length; i++)
            {
                 /* for ml except */
                  if(!row_entry.disk && args[i].key ==  escapeHTML(row_entry.ml_arg_name) && row_entry.ml_except != -1)
                  {
                    var ml_except_id = id;
                    ml_except_id = ml_except_id.replace(/[^0-9]/ig,""); 
                    drawMLExcept(row_entry.ml_except, ml_except_id, args[i].key, args[i].value);
                  }
                //highlight context in only parameters
                var key_str = "";
                var context = "";
                if(pattern != null && pattern.length > 0 && match_info == "3")                    
                {
                    if(args[i].key != "" && args[i].key.indexOf(pattern) != -1 )
                    {
                        key_str = args[i].key.replace(pattern,"<span style=\"background-color:#ffff00\">"+pattern+"</span>");
                    }else{
                        key_str = args[i].key;
                    }
                    if(args[i].value != "" && args[i].value.indexOf(pattern) != -1 )
                    {
                        context = args[i].value.replace(pattern,"<span style=\"background-color:#ffff00\">"+pattern+"</span>");    
                    }else{
                        context = args[i].value;
                    }     
                }
                else
                {
                    key_str = args[i].key;
                    context = args[i].value;
                }


                elems.push("<tr class=\"even\"><td class=\"value\">" + 
                        key_str + 
                        "</td><td class=\"value\">" + 
                        context +
                        "</td></tr>");
            }

          elems.push("</table>");         
        }
        if(cookies && cookies.length > 0)
        {        
            //cookies table
            elems.push("<div style=\"height: 5px;\"></div>");
            elems.push("&nbsp;<b style=\"font-size: 15px;\">Cookies:</b>");
            elems.push("<table cellspace=\"1\" cellpadding=\"0\" class=\"list log_details pre\" style=\"table-layout:fixed\">");
            elems.push("<tr class=\"head\"><td width=\"30%\"><b>"+$.getInfo("name")+"</b></td><td width=\"70%\"><b>"+$.getInfo("value")+"</b></td></tr>");

            for(var i = 0; i < cookies.length; i++)
            {
                //highlight context only in cookies
                var key_str = "";
                var context = "";
                if(pattern != null && pattern.length > 0 && match_info == "2")
                {
                    if(cookies[i].key != "" && cookies[i].key.indexOf(pattern) != -1 )
                    {
                        key_str = cookies[i].key.replace(pattern,"<span style=\"background-color:#ffff00\">"+pattern+"</span>");
                    }else{
                        key_str = cookies[i].key;
                    }
                    if(cookies[i].value != "" && cookies[i].value.indexOf(pattern) != -1 )
                    {
                        context = cookies[i].value.replace(pattern,"<span style=\"background-color:#ffff00\">"+pattern+"</span>");    
                    }else{
                        context = cookies[i].value;
                    }
                }
                else
                {
                    key_str = cookies[i].key;
                    context = cookies[i].value;
                }

                elems.push("<tr class=\"even\"><td class=\"value\">" +
                        key_str +
                        "</td><td class=\"value\">" +
                        context +
                        "</td></tr>");
            }
        
          elems.push("</table>");
        }
        if(files && files.length > 0)
        {        
            //files table
            elems.push("<div style=\"height: 5px;\"></div>");
            elems.push("&nbsp;<b style=\"font-size: 15px;\">"+$.getInfo('files')+"</b>");
            elems.push("<table cellspace=\"1\" cellpadding=\"0\" class=\"list log_details pre\" style=\"table-layout:fixed\">");
            elems.push("<tr class=\"head\"><td width=\"100%\"><b>"+$.getInfo("name")+"</b></td></tr>");
            var match = match_info.substr(match_info.lastIndexOf("<")+1,match_info.lastIndexOf(">")-2);
            
            for(var i = 0; i < files.length; i++)
            {
                //highlight context only in cookies
                var context = "";
                if(files[i].key != "" && files[i].key.indexOf(match) != -1 && match_info && match_info[0] == 5)
                {
                    context = files[i].key.replace(match,"<span style=\"background-color:#ffff00\">"+match+"</span>");
                }
                else
                {
                    context = files[i].key;
                }

                elems.push("<tr class=\"even\"><td class=\"value\">" +
                        context +
                        "</td></tr>");
            }
        
          elems.push("</table>");
        }

        return elems;
    }
    function aggCallback(result,pcap_id){ 
             var head_table = $j("#head_insert_"+ pcap_id);
             if(head_table.length > 0) return; 
             var table = buildpackettable(result,1,"insert_"+pcap_id); 
              $j("#packet_"+pcap_id).append($(table.join(''))) ;
    }


    function commentCallback(result,msg_id,logfile){
        var elems = [];

        elems.push('<div style="height: 5px;"></div>');
        elems.push('<table cellspace="1" cellpadding="0" class="list log_details pre">');
        elems.push('<tr class="head"><td width="100%"><b>'+$.getInfo("comment")+'</b></td></tr>');
        elems.push('<tr class="even"><td width="100%" class="value">');
        elems.push('<div>');

        if(result.create_time != "")
        {
            elems.push('<div class="log_comment_avatar">');
            elems.push('<img width="50" height="50" src="/images/face.png">');
            elems.push('<br>');
            elems.push(result.creator);
            elems.push('</div>');
            elems.push('<div class="log_comment_detail">');
            elems.push('<span>');

            elems.push($.getInfo("comment_created_by").replace('%AUTHOR%', result.creator).replace('%TIME%', result.create_time));
            elems.push('</span>');

            if(result.edit_time != "")
            {
                elems.push('<span>');
                elems.push($.getInfo("comment_edit_by").replace('%AUTHOR%', result.editor).replace('%TIME%', result.edit_time));
                elems.push('</span>');
            }
            elems.push('<textarea disabled maxlength="1023" id="comment_value_'+msg_id+'">'+escapeHTML(result.comment)+'</textarea>');
            if(is_rw_admin)
            {
                elems.push('<button class="primary" onclick="DetailsWindow.editCommentClick(this , \''+msg_id+'\', \''+logfile+'\')">'+$.getInfo("edit")+'</button>');
            }
            elems.push('</div>');
        } else {
            elems.push('<div class="log_comment_detail">');
            elems.push('<textarea '+(is_rw_admin?'':'disabled')+' maxlength="1023" id="comment_value_'+msg_id+'">'+escapeHTML(result.comment)+'</textarea>');
            if(is_rw_admin)
            {
                elems.push('<button class="primary" onclick="DetailsWindow.saveCommentClick(\''+msg_id+'\', \''+logfile+'\')">'+$.getInfo("save_comment")+'</button>');
            }

            elems.push('</div>');
        }

        elems.push('</div>');
        elems.push('</td></tr>');
        elems.push('</table>');

        $("#comment_"+msg_id).html($(elems.join('')));
        $("#comment_value_"+msg_id).textarea();

    }

    function is_default_cloumn(key, type)
    {
        if(type === "attack")
        {
            for(var i=0;i<default_attack_column.length;i++){
                if(default_attack_column[i] === key)
                {
                    return true;
                }
            }
        }else{
            for(var i=0;i<default_traffic_column.length;i++){
                if(default_traffic_column[i] === key)
                {
                    return true;
                }
            }      
        }

        return false;
    }

    // TODO: move to callback function
    function buildDetailTable(cols, row_data, id) {
        var lang_override;
        var elems = [];
        var rows = [];
        var html;
        var label;
        var fields = [];
        var row_class, label_class, defalut_class;
        var text_level = 'level';//get the text of level in different languages
        var width = 100 / cols;
        var n = 0;
        var row_entry_ = (id === 'disk_table')?row_data:row_data.disk;
	if(id != 'disk_table')
		row_entry_['flag'] = row_data.flag;
        var row_num = 0;
        var val;
        var need_link = false;
        var hpc_link = false;
        var need_msg_menu = false;

        var alert_only_url = "";//attack log protection exception 
        var except = "";
        var except_url = "";
        var hpc_except_url = "";
        var fpm = "";
        var fpm_url = "";
        //aggregate
        var aggregate;
        var is_score_sum = 0;
        var is_cookie_security = false; 
        var disk_hide = true;
	//var is_ftp = false;

	if(row_entry_ && typeof(row_entry_.aggregate) !== 'undefined')
		aggregate = row_entry_.aggregate

        lang_override = config.langOverride;

        text_level = $.getInfo('pri');

        var tb = document.createElement('div');
        tb.id = 'log_details_table';
        $(tb).width('100%');

	if(aggregate && aggregate.has_score == 1){
            elems.push("<table id='detail_top' cellspace=\"1\" cellpadding=\"0\" width=\"100%\" style=\"background-color: #fff;border-width:1px 1px;table-layout:fixed\" class=\"list log_details yui-skin-sam yui-panel\">");
/*            elems.push("<tr class='head'><td colspan=5>");
            elems.push("<div title='Click to collapse this pane.' id='detail_expanded' onclick='DetailsWindow.hide()' style='"
		   +"cursor: pointer;   height: 13px;   left: 5px;   top: 5px;  width: 17px;   font-size: 0;"
		   +"background: transparent url(/build/assets/skins/sam/layout_sprite.png) no-repeat -20px -200px;   border: 1px solid #808080;'></div>");
            elems.push("</td></tr>\n");
*/
            elems.push("<tr class=\"head\"><td style='padding-left: 10px;'><b>"+$.getInfo('time')+"</b></td>"
                +"<td><b>"+$.getInfo('policy')+"</b></td>"
                +"<td><b>"+$.getInfo('score_sum')+"</b></td>"
                +"<td><b>"+$.getInfo('score_threshold')+"</b></td>"                
                +"<td><b>"+$.getInfo('score_scope')+"</b></td></tr>");            

            score_top = [];
            score_top_curpage = 0;
            buildTable_score(aggregate.date,aggregate.viewline,0,aggregate.count);
            elems.push("</table>");
            elems.push("<div id='page_top'>");
            elems.push('<button id="page_top_first"><f-icon class="fa-angle-double-left" title="'+$.getInfo('page_first')+'"></f-icon></button>');
            elems.push('<button id="page_top_prev" ><f-icon class="fa-angle-left"  title="'+$.getInfo('page_prev')+'"></f-icon></button>');
            elems.push('<span id="page_top_current"> 1 </span>');
            elems.push('<button id="page_top_next"><f-icon class="fa-angle-right"  title="'+$.getInfo('page_next')+'"></f-icon></button>');
            elems.push('<span id="page_top_count"> ['+$.getInfo('total_num')+':'+aggregate.count+' ] </span>');
            elems.push("</div>");

            elems.push('<div id="log_details_top-resizer" class="ui-layout-resizer ui-layout-resizer-south ui-layout-resizer-open ui-layout-resizer-south-open" '
                +'style="padding: 0px; margin: 0px; font-size: 1px; text-align: left;   z-index: 2;  height: 4px;">'
                +'</div>');
            elems.push("<table id=\""+id+"\" cellspace=\"1\" cellpadding=\"0\" class=\"list log_details pre\">");
	    return $(elems.join(''));
        }
	else if(aggregate && aggregate.has_score === 0)
        {
            var aggregate_html = aggregate_detail(aggregate.date,aggregate.type,aggregate.signature,aggregate.viewline,aggregate.msg_id,aggregate.count,aggregate.aggre_name);
            elems.push(aggregate_html);
            disk_hide = false;
        }else{
		if(id === 'disk_table')
		{
			elems.push('<table id=\'disk_table\' cellspacing=\'1\' cellpadding=\'0\' class=\'list log_details\'>');
/*			elems.push("<tr class='head'><td colspan=4>");
			elems.push("<div title='Click to collapse this pane.' id='detail_expanded' onclick='DetailsWindow.hide()' style='"
				   +"cursor: pointer;   height: 13px;   left: 5px;   top: 5px;  width: 17px;   font-size: 0;"
				   +"background: transparent url(/build/assets/skins/sam/layout_sprite.png) no-repeat -20px -200px;   border: 1px solid #808080;'></div>");
			elems.push("</td></tr>\n");
*/
		}
		else
			elems.push('<table id=\''+id+'\' cellspacing=\'1\' cellpadding=\'0\' class=\'list log_details\'>');		
	}
    if(disk_hide && row_entry_){
        elems.push('<tr class="head"><td width="100%" colspan='+2*cols+' onclick=\"DetailsWindow.trigger_table(\''+id+'\')\">');
        elems.push("<f-icon id=\"imgs_"+id+"\" class=\"fa-minus-square\" style=\"display: '';color: #646464;\"></f-icon>");
        elems.push("<f-icon id=\"imgh_"+id+"\" class=\"fa-plus-square\" style=\"display: none;color: #646464;\"></f-icon>");
        elems.push('<b>'+ $.getInfo("detail") + '</b></td></tr>');    
        elems.push('<tr class="even"><td width="100%" colspan='+2*cols+' onclick=\"DetailsWindow.more_details(\''+id+'\',\''+row_entry_['type']+'\')\" id=\'more_details_label\'><a href="javascript:;">'+$.getInfo('more_details')+'</a></td></tr>'); 
    }
	/*svn s
        if(row_entry_ && row_entry_.log_type && row_entry_.log_type == "LOG_TYPE_SCORE_SUM" && id === 'disk_table')
        {
            var aggregate_html = aggregate_score_detail(row_entry_.date, row_entry_.time, row_entry_.score_threshold, row_entry_.score_sum, row_entry_.score_scope, row_entry_.msg_id, row_entry_.entry_sequence, row_entry_.logfile);
            //$(id).children().remove(); 
            elems.push(aggregate_html);  
            
            return $(elems.join(""));
        }
	*/

        function matches_column(row_key) {
            return function(column) {
                return row_key === column || $.type(column) === 'regexp' && column.test(row_key);
            };
        }
        for (var row_key in row_entry_) {
            if (config.hiddenColumns.some(matches_column(row_key))) {
                continue;
            }

            label = null;

            // Per-logtype overrides are supported. First the override table is referenced,
            // and if no entry is found, the standard language file is used.
            // Need to search display lang section first,
            // since $.getInfo just uses loop to search the lang key.
            // Other sections like 'com_info' section may be searched
            // before 'display' section
            if (lang_override && lang_override[row_key]) {
                label = lang_override[row_key];
            } else {
                label = $.getInfo(row_key);
            }

            if (label) {
                fields.push({
                    'key': row_key,
                    'label': label
                });
            }
            if(row_key == "except")
            {
                except = row_entry_[row_key];
            }

            if(row_key == "except_url")
            {
                except_url = row_entry_[row_key] + "&&step=1";
                hpc_except_url = row_entry_[row_key];
            }

            if(row_key == "fpm")
            {
                fpm = row_entry_[row_key];
            }

            if(row_key == "fpm_url")
            {
                fpm_url = row_entry_[row_key];
            }

            if(row_key == "alert_only_url")
            {
                alert_only_url = row_entry_[row_key] + "&&step=1";
            }
		
	    /*
	    if(row_key == "service")
	    {
		    if(row_entry_[row_key] === "ftp" || row_entry_[row_key] === "ftps")
			    is_ftp = true;
	    }*/

	    // for old version handle message link
            if(row_key == "subtype")
            {
                if(row_entry_[row_key] == "waf_signature_detection" || row_entry_[row_key] == "waf_ip_reputation")
                    need_link = true;

                if(row_entry_[row_key] == "http_protocol_error" ||
                        row_entry_[row_key] == "waf_header_overflow" ||
                        row_entry_[row_key] == "waf_headline_overflow" ||
                        row_entry_[row_key] == "waf_body_overflow" ||
                        row_entry_[row_key] == "waf_content_overflow" ||
                        row_entry_[row_key] == "waf_parameter_overflow" ||
                        row_entry_[row_key] == "waf_request_overflow" ||
                        row_entry_[row_key] == "waf_url_parameter_overflow" ||
                        //row_entry_[row_key] == "waf_illegal_http_version" ||
                        row_entry_[row_key] == "waf_cookiecount_overflow" ||
                        row_entry_[row_key] == "waf_req_headline_overflow" ||
                        row_entry_[row_key] == "waf_url_parameter_count_overflow" ||
                        row_entry_[row_key] == "waf_illegal_hostname" ||
                        row_entry_[row_key] == "waf_illegal_http_method" ||
                        row_entry_[row_key] == "waf_max_num_ranges_in_Range_header" ||
                        row_entry_[row_key] == "waf_illegal_content_length" ||
                        row_entry_[row_key] == "waf_illegal_content_type" ||
                        row_entry_[row_key] == "waf_illegal_response_code" ||
                        row_entry_[row_key] == "waf_missing_post_ctype" ||
                        row_entry_[row_key] == "waf_body_parameter_overflow" ||
                        row_entry_[row_key] == "waf_header_name_overflow" ||
                        row_entry_[row_key] == "waf_header_value_overflow" ||
                        row_entry_[row_key] == "waf_illegal_param_name" ||
                        row_entry_[row_key] == "waf_illegal_param_value" ||
                        row_entry_[row_key] == "waf_illegal_header_name" ||
                        row_entry_[row_key] == "waf_illegal_header_value"||
                        row_entry_[row_key] == "waf_http_request_filename_overflow" ||
			row_entry_[row_key] == "waf_redundant_http_header" ||
			row_entry_[row_key] == "waf_url_parameter_value_overflow" ||
			row_entry_[row_key] == "waf_url_parameter_name_overflow" ||
			row_entry_[row_key] == "waf_illegal_url_parameter_value" ||
			row_entry_[row_key] == "waf_illegal_url_parameter_name" ||
			row_entry_[row_key] == "waf_duplicate_param_name")
                    hpc_link = true;

                if(row_entry_[row_key] == "waf_cookie_security") is_cookie_security = true;
		/*add for ha_log view */
		if(typeof(is_ha_log) !== 'undefined' && is_ha_log) 
		{
			hpc_link = false;
			need_link = false;
		}

            }
	    // for new version handle message link
	    if(row_key == 'main_type')
	    {
		    if(row_entry_[row_key] == 'Signature Detection')
			    need_link = true;

		    var hpc_sub_type = row_entry_['sub_type'] || '';
		    if(row_entry_[row_key] == 'HTTP Protocol Constraints' && hpc_sub_type != 'Illegal Response Code')
			    hpc_link = true;

		    // here maybe has cookie security type need to handler, added by lk
		    
		    if(typeof(is_ha_log) != 'undefined' && is_ha_log)
		    {
			    hpc_link = false;
			    need_link = false;
		    }
	    }

        if(!is_rw_admin || acc_waf_perm == 2) //no log group access and no waf group access, disable the link
        {
            need_link = false;
        }
	if(!is_rw_admin || acc_waf_perm)
	{
            hpc_link = false;
	}
	    /*
            if(row_key == "log_type")
            {
                if(row_entry_[row_key] == "LOG_TYPE_SCORE_SUM")  is_score_sum = 1;
                if(row_entry_[row_key] == "LOG_TYPE_NONE")  is_score_sum = 2;
            }
	    */
        }
/*
        // Sort details panel fields alphabetically.
        fields.sort(function(a, b) {
            if (a.label < b.label) {
                return -1;
            }
            if (a.label > b.label) {
                return 1;
            }
            return 0;
        });
*/

	    // first add flag td
	    if(typeof(aggregate) == 'undefined' && log_type == 3 && row_entry_)
	    {
		    html = '';
		    var f_key = 'flag';
		    var f_label = lang_override['flag'] || $.getInfo('flag');
		    var f_val = '';
		    if(typeof config.formatCallbacks[f_key] === 'function')
			    f_val = config.formatCallbacks[f_key](f_key, row_entry_, $('<td/>'));
		    else
			    f_val = escapeHTML(row_entry_[f_key]);
		    row_class = (row_num % 2 ? 'even' : 'odd');
		    if (n++ % cols === 0) {
			    html += '<tr class=\'' + row_class + '\'>';
		    }

		    html += '<td width=\'' + (width * 0.3) + '%\' class=\'' + 'label' +
			    '\'><b>' + f_label + '</b></td>' +
			    '<td width=\'' + (width * 0.7) + '%\' class=\'value\'';

		    html += ">" + f_val + "</td>";
		    rows.push(html);
		    if (n % cols === 0)
			    row_num++;
	    }

        for (var i = 0, len = fields.length; i < len; i++) {
            var key = fields[i].key;
            label = fields[i].label;
            html = '';

            if (typeof config.formatCallbacks[key] === 'function') {
                val = config.formatCallbacks[key](key, row_entry_, $('<td/>'));
            } else {
                val = escapeHTML(row_entry_[key]);
            }
            if (!val) {
                continue;
            }

            if(key === 'detail' || key == 'logfile' || key === 'pcap_id' || key == 'msg' || key === '#'
             || key ==='rel_time' || key ==='logType' || key === 'alert_only_url' || key == 'country_flag'
              || key == 'except' || key == 'except_url' || key == 'global_status' || key == 'fpm'
               || key == 'fpm_url'|| key == 'disk'|| key == 'aggregate' || key === "data" 
              || key === "alert_only" || key === "src" || key === "src_port" || key === "dst" 
		|| key === "dst_port" || key === "score_message" || key === "entry_sequence"
                || key === "log_type" || key === "score_scope" || key === "score_type" || key === "score_threshold" || key === "score_sum" || key === "event_score"
		/*((is_score_sum == 1 && (key==="log_type" || key==="score_scope" || key=="score_type" || key=="score_threshold"  || key=="score_sum"))
                        || (is_score_sum == 2 && key==="event_score") || key==="log_type")*/
		|| key ==="country_flag" || (key ==="false_positive_mitigation" && row_entry_[key]!="yes" && row_entry_[key]!="no")
		|| key ==="signature" || key === "length" || key === "fpos" || key === "http_policy" || key === 'msg_src'
		|| key ==="_cache_id" || key ==="_id" || key ==="id" || key ==="hpc" || (key == 'pri' && log_type == 3)
        || key ==="ml_log_hmm_probability" || key ==="ml_log_sample_prob_mean" || key ==="ml_log_sample_arglen_mean" 
        || key ==="ml_log_arglen" || key ==="ml_svm_log_main_types" || key ==="ml_svm_log_match_types" || key ==="ml_svm_accuracy"
        || key === "ml_allow_method" || key === "ml_except_id" || key === "flag_val" || key === "flag" || key === "has_comment"/*|| key ==="ml_domain_index" || key ==="ml_url_dbid" || key ==="ml_arg_dbid"*/
	|| key === "ori_country_flag" || key === 'type') 
                continue;

	    /*When the service is ftp filter params about http*/
	    /*if(is_ftp === true)
	    {
		    if(key === "http_version" || key === "http_method" || key === "http_url" || key === "http_host" 
				    || key === "content_switch_name" || key === "http_refer" || key === "http_agent")
			    continue;
	    }
	    else 
	    {
		    if(key === "ftp_cmd" || key == "ftp_mode")
			    continue;
	    }*/

            row_class = (row_num % 2 ? 'even' : 'odd');

            if (key === 'pri') {
                label_class = 'details_label';
            } else {
                label_class = 'label';
            }
            if(is_default_cloumn(key, row_entry_['type'])){
                defalut_class = ' ';
            }else{                
                defalut_class = ' hidden';
            }

            if (n++ % cols === 0) {
                html += '<tr class=\'' + row_class + defalut_class +'\' id=\''+key+'\'>';
            }

            html += '<td width=\'' + (width * 0.3) + '%\' class=\'' + label_class +
                '\'><b>' + label + '</b></td>' +
                '<td width=\'' + (width * 0.7) + '%\' class=\'value\'';
                
            //common fields, just display
            if(key == "http_retcode")
            {
                html += ">" + (val==0 ? "":val) + "</td>";
            }
            else if(key == "false_positive_mitigation")
            {
            	if(n % cols != 0){
            		n = n + 1;
            		html += " colspan = \""+(2*cols-1)+"\"";
            	}
                html += ">" + val + "</td>";
            }
            else if(key == "event_score")
            {
                var point_tip = $j.getInfo("points");
                if(val == 1) point_tip = $j.getInfo("point");
                html += ">" + $j.getInfo(scores_info[val-1]) + "(" + val + " "+point_tip + ")</td>";
            }
            else if(key == "owasp_top10")
            {
                var link = val;
                if(val && val in OWASP_LINK)
                    link = '<a target="_blank" href="'+OWASP_LINK[val]+'">'+val+'</a>';
                html += ">" + link + "</td>";
            }else{
                html += ">" + val + "</td>";                
            }  

            if (n % cols === 0) {
                width = '';
                row_num++;
                html += '</tr>';
            }
            rows.push(html);
        }
	if(n % cols !== 0)  
	{
		//rows.push("<td colspan=\""+cols+"\"></td></tr>");
        /** for bug 0406953 */
        var src_row = rows[rows.length-1];
        var dst_row =src_row.substring(0,src_row.lastIndexOf('<td')) + "<td colspan="+(cols+1)+src_row.substring(src_row.lastIndexOf('<td')+3,src_row.length)+"</tr>";
        rows[rows.length-1]=dst_row;
		row_num++;
	}
        /* this for message format */
        for (var i = 0, len = fields.length; i < len; i++) {
            var key = fields[i].key;
            label = fields[i].label;
            html = '';

            if (typeof config.formatCallbacks[key] === 'function') {
                val = config.formatCallbacks[key](key, row_entry_, $('<td/>'));
            } else {
                val = escapeHTML(row_entry_[key]);
            }
            if (!val) {
                continue;
            }
            if(key !== 'msg') continue;

            row_class = (row_num % 2 ? 'even' : 'odd');
            if(is_default_cloumn(key, row_entry_['type'])){
                defalut_class = ' ';
            }else{                
                defalut_class = ' hidden';
            }
            
            if(n % cols !== 0) n++;     
            if (n++ % cols === 0) {
                html += '<tr class=\'' + row_class + defalut_class + '\' id=\''+key+'\'>';
            }

            html += '<td width=\'' + (width * 0.3) + '%\' class=\'' + label_class +
                '\'><b>' + label + '</b></td>' +
                '<td width=\'' + (width * 0.7) + '%\' class=\'value\' style=\'word-break:break-all; overflow:hidden;\'';

            if(key == "msg" && need_link)
            {
                var main_actions = [];
                html += " colspan = \""+(2*cols-1)+"\">";
                n = n + 1;
		var subtype = row_entry_["subtype"];
                var sig = "";
                var start = 0;

		// get signature id method, diff with old version and new version
		// old version subtype can't be null
		if(subtype != '')
		{
			start = val.indexOf("Signature ID");
			if(start != -1)
			{
				sig = val.substring(start+1+"Signature ID".length);
			}
		}
		// new version, get from signature_id field
		else
			sig = row_entry_["signature_id"];
                var view_sig_action = null;
                var sig_key = row_entry_["signature"];

//                if(start != -1)
		if(sig != "")
                {
//                    sig = val.substring(start+1+"Signature ID".length);
                    var url = "/signature/signature_detail.html";
                    url = qlist_url_append_arg(url, "sig_id", sig);
                    url = qlist_url_append_arg(url, "log_type", row_entry_.log_type);

                    if(sig_key && sig_key!=="")
                        url = qlist_url_append_arg(url, "mkey", sig_key);
                    view_sig_action ={
                        text: '<span class="msg_menu_action_text action_view">' + $.getInfo("view_signature") + '</span>',
                        id: 'menu_action_sig_detail',
                        classname: 'menu_act_item',
                        value: 'sig_detail',
                        onclick: {
                            fn: function(){
                                wij_display_modal_dlg( url , {'width': 805, 'height': 720});
                            }
                        }
                    };
                    if(row_entry_["sub_type"] == "Illegal Character in URL"|| row_entry_["sub_type"] == "NULL Character in URL" || row_entry_["sub_type"] == "Odd and Even Space Attack"){
                        html += '<label><span>' +val+ '</span></label>';
                    }else{
                        html += '<label class="msg_menu_button" onclick="DetailsWindow.msgMenuClick(this, ' +msg_menu_count+ ');"><span class="msg_menu_button_text">' +val+ '</span></label>';
                    //html += "<a onclick=\"wij_display_modal_dlg('" + url +"', {'width': 800, 'height': 530});\">" + val + "</a>";
                    }
                }

                if(except != "" && !acc_waf_perm)
                {
                    main_actions.push({
                        text: '<span class="msg_menu_action_text action_block">' + except + '</span>',
                        id: 'menu_action_except',
                        classname: 'menu_act_item',
                        value: 'except',
                        onclick: {
                            fn: function() {
                                wij_display_modal_dlg( except_url , {'width': 550, 'height': 250});
                            }
                        }
                    });

		    if(start == -1){
			if(row_entry_["sub_type"] == "Illegal Character in URL"|| row_entry_["sub_type"] == "NULL Character in URL" || row_entry_["sub_type"] == "Odd and Even Space Attack"){
				html += '<label><span>' +val+ '</span></label>';
			}else{
				html += '<label class="msg_menu_button" onclick="DetailsWindow.msgMenuClick(this, ' +msg_menu_count+ ');"><span class="msg_menu_button_text">' +val+ '</span></label>';
			}
		    }
                    //html += " (<a  onclick=\"wij_display_modal_dlg('" + except_url +"', {'width': 400, 'height': 155});\">"+ except +"</a>)";
                }

                if(row_entry_["alert_only"] != "" && sig != "" && !acc_waf_perm)
                {
                    main_actions.push({
                        text: '<span class="msg_menu_action_text action_block">' + row_entry_["alert_only"] + '</span>',
                        id: 'menu_action_alert_only',
                        classname: 'menu_act_item',
                        value: 'alert_only',
                        onclick: {
                            fn: function() {
                                wij_display_modal_dlg( alert_only_url , {'width': 550, 'height': 200});
                            }
                        }
                    });
                }


                if(row_entry_["global_status"] != "" && !acc_waf_perm)
                {
                    var dis_url = '/waf/base_signature_disable/add?signature_id='+sig+'&session_id='+session_id;
                    main_actions.push({
                        text: '<span class="msg_menu_action_text action_disable">' + row_entry_["global_status"] + '</span>',
                        id: 'menu_action_sig_disable',
                        classname: 'menu_act_item',
                        value: 'sig_disable',
                        onclick: {
                            fn: function() {
                                wij_display_modal_dlg(dis_url, {'width': 400, 'height': 200});
                            }
                        }
                    });
                    //html += " (<a  onclick=\"wij_display_modal_dlg('/waf/base_signature_disable/add?signature_id="+sig+"&session_id="+session_id+"', {'width': 400, 'height': 150});\">"+ row_entry_["global_status"] +"</a>)</td>";
                }
                else
                {
                    html += "</td>";
                }
                var menu_actions = [main_actions];
                if(view_sig_action){
                    menu_actions.push([view_sig_action]);
                }
                msg_menu_actions[msg_menu_count] = menu_actions;
                msg_menu_count++;
                need_msg_menu = true;
            }
            else if(key == "msg" && hpc_link)
            {
                var main_actions = [];
                n = n + 1;
                html += " colspan = \""+(2*cols-1)+"\">";
                if(except != "" && hpc_except_url != ""){
                    if(row_entry_["sub_type"] == "Illegal Character in URL"|| row_entry_["sub_type"] == "NULL Character in URL" || row_entry_["sub_type"] == "Odd and Even Space Attack" || row_entry_["sub_type"] == "Exceeding Internal Parsing Limits" || row_entry_["sub_type"] == "Illegal HTTP Version" || row_entry_["sub_type"] == "Malformed URL" || row_entry_["sub_type"] == "Header Compression Table Size" || row_entry_["sub_type"] == "Number of Concurrent Streams" || row_entry_["sub_type"] == "Initial Window Size" || row_entry_["sub_type"] == "Frame Size" || row_entry_["sub_type"] == "Header List Size"){
                        html += '<label><span>' +val+ '</span></label>';
                    }else{
                        html += '<label class="msg_menu_button" onclick="DetailsWindow.msgMenuClick(this, ' +msg_menu_count+ ');"><span class="msg_menu_button_text">' +val+ '</span></label>';
                    }
                   main_actions.push({
                        text: '<span class="msg_menu_action_text action_block">' + except + '</span>',
                        id: 'menu_action_hpc_except',
                        classname: 'menu_act_item view_sig',
                        value: 'hpc_except',
                        onclick: {
                            fn: function() {
                                wij_display_modal_dlg( hpc_except_url, {'width': 550, 'height': 200});
                            }
                        }
                    });
                    //html += " (<a  onclick=\"wij_display_modal_dlg('" + hpc_except_url +"', {'width': 430, 'height': 150});\">"+ except +"</a>)";
                } else {
                    html += val;
                }
                html += "</td>";
                msg_menu_actions[msg_menu_count] = [main_actions];
                msg_menu_count++;
                need_msg_menu = true;
            }
            else if(key == "msg" && is_cookie_security)
            {
                var end = val.indexOf('];');
                if(end == -1) end = val.length;
                var cookie_name = val.substring(val.indexOf('(')+1,val.indexOf(')'));
		var old_value_begin = val.indexOf('[');
                var old_value = '';
		old_value = trimSpace(val.substring(old_value_begin+1,val.indexOf('-&gt;')));

                var corrupted_value = '';
		corrupted_value = trimSpace(val.substring(val.indexOf('-&gt;')+5,end));

		if(val.indexOf('[') == -1 || val.indexOf('-&gt;') == -1)
		{
			old_value = '';
			corrupted_value = '';
		}

                var domain_begin = val.indexOf('Domain:');
                var path_begin = val.indexOf('; Path:');
                var security_domain = '';
                if(domain_begin != -1) 
                    security_domain = trimSpace(val.substring(domain_begin+7,path_begin));

                var security_path = '';
                if(path_begin != -1)
                    security_path = trimSpace(val.substring(path_begin+7,val.length));

		var cookie_security = '';
		var cookie_security_begin = val.indexOf('Cookie Security :');
		if(old_value == '' && corrupted_value == '' && cookie_security_begin != -1 && domain_begin != -1)
			cookie_security = ' : '+trimSpace(val.substring(cookie_security_begin+17,domain_begin-2));
		else if(old_value != '' && corrupted_value != '' && cookie_security_begin != -1 && domain_begin != -1)
			cookie_security = ' : '+trimSpace(val.substring(cookie_security_begin+17,old_value_begin-2));
                n = n + 1;
                html += " colspan = \""+(2*cols-1)+"\">";
		if(cookie_name != '')
		{
		        html += "<table width=\"100%\">";
		        html += "<tr><td colspan=\"2\" style=\" border-right-style: hidden;\">"+$.getInfo("cookie_security")+ cookie_security +"</td></tr>";
		        html += "<tr><td width=\"110px\">"+$.getInfo("cookie_name")+"</td><td style=\" border-right-style: hidden;\">"+cookie_name+"</td></tr>";
		        html += "<tr><td>"+$.getInfo("domain")+"</td><td style=\" border-right-style: hidden;\">"+security_domain+"</td></tr>";
		        html += "<tr><td>"+$.getInfo("path")+"</td><td style=\" border-right-style: hidden;\">"+security_path+"</td></tr>";
			if(old_value != '')
		        	html += "<tr><td>"+$.getInfo("old_value")+"</td><td style=\" border-right-style: hidden;\">"+old_value+"</td></tr>";
			if(corrupted_value != '')
		        	html += "<tr><td>"+$.getInfo("corrupted_value")+"</td><td style=\" border-right-style: hidden;\">"+corrupted_value+"</td></tr>";
		        html += "</table>";
		}else{
			html += val
		}
                html += "</td>";
            }else{
                n = n + 1;
                html += " colspan = \""+(2*cols-1)+"\">";
                html += val + "</td>";                
            }            

            if (n % cols === 0) {
                width = '';
                row_num++;
                html += '</tr>';
            }

            rows.push(html);
        }
        elems.push(rows.join(''));

        if (n % cols !== 0) {
            while (n++ % cols !== 0) {
                elems.push('<td></td><td></td>');
            }

            elems.push('</tr>');
        }

        elems.push('</table>');

        if(row_entry_ && (row_entry_["src"] || row_entry_["src_port"]))
        {
            //connection info
            elems.push("<div style=\"height: 5px;\"></div>");
            elems.push("<table cellspace=\"1\" cellpadding=\"0\" class=\"list log_details pre\" style=\"table-layout:fixed\">");
            elems.push("<tr class=\"head\"><td width=\"100%\"><b>"+$.getInfo("connection")+"</b></td></tr>");
            elems.push("<tr class=\"even\"><td width=\"100%\" class=\"value\">" + 
                    "<span class=\"country_flag country_"+ row_entry_["country_flag"]+"\"></span>&nbsp;"+ row_entry_["src"] + ":" + row_entry_["src_port"] + "  ->  " +row_entry_["dst"] + ":" + row_entry_["dst_port"] +
                        "</td></tr>");
            elems.push("</table>");
            //end for build disk log table
        }   

        if(row_entry_ && row_entry_["main_type"] === "Machine Learning")
        {
            if(row_entry_ &&(row_entry_["sub_type"] === "Definite Anomaly in http argument" 
                || row_entry_["sub_type"] === "Potential Anomaly in http argument"
                || row_entry_["sub_type"] === "Anomaly in http argument")){ //new version is only this sub type

                var tableid = row_entry_["msg_id"];

                elems.push("<div style=\"height: 5px;\"></div>");
                elems.push("<table cellspace=\"1\" cellpadding=\"0\" class=\"list log_details pre\" style=\"table-layout:fixed\">");
                elems.push("<tr class=\"head\"><td width=\"50%\" onclick=\"DetailsWindow.trigger_div('ml_"+tableid+"')\">");
                elems.push("<f-icon id=\"imgs_ml_"+tableid+"\" class=\"fa-minus-square\" style=\"display: '';color: #646464;\"></f-icon>");
                elems.push("<f-icon id=\"imgh_ml_"+tableid+"\" class=\"fa-plus-square\" style=\"display: none;color: #646464;\"></f-icon>");
                elems.push("<b>" + $.getInfo("machine_learning") + "</b></td>");
                var arg_opt = "";
                if(is_rw_admin && !acc_ml_perm)
                {
                     arg_opt = "<td onclick=\"DetailsWindow.msgMenuClick(this, " +msg_menu_count+ ");\">"
                        +"                    <f-icon class=\"fa-cog\"></f-icon>"+$.getInfo("operation")
                        +"                    <f-icon class=\"fa-caret-down\"></f-icon>"
                        +"</td></tr>";                   
                }else{
                    arg_opt =  "<td></td></tr>";     
                }

                elems.push(arg_opt);
                elems.push("<tr><td colspan=2 width=\"100%\"><div id=\"div_ml_"+tableid+"\" width=\"100%\">");
                
                elems.push("<div style=\"margin-left: 15px;\"><b>"+$.getInfo("ml_anomaly")+"</b><hr style=\"height: 0;\"></div>");
                elems.push("<div style=\"display: inline-flex;width:100%\">");
                elems.push("    <div style=\"width:250px\" id=\"ml_log_hmm_probability_"+tableid+"\"></div>");
                elems.push("    <div style=\"width:250px\" id=\"ml_arg_"+tableid+"\"></div>");
                elems.push("</div>");

                elems.push("<div style=\"text-align: center;height: 30px;width:500px;\">");
                elems.push("<span class=\"ml-mean-circle\"></span><span>"+$.getInfo("ml_mean")+"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>");
                elems.push("<span class=\"ml-arg-act-circle\"></span><span>"+$.getInfo("ml_arg_act")+"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>");
                elems.push("</div>");

        		var ml_svm_main_type = row_entry_["ml_svm_log_main_types"];
        		var ml_svm_display = (ml_svm_main_type != 0) ? "display:'';" : "display:none;";
        		elems.push("<div style=\"margin-left: 15px;"+ml_svm_display+"\"><b>"+$.getInfo("ml_attack")+"</b><hr style=\"height: 0;\"></div>");
        		if(ml_svm_main_type != 0)
        		{
        		 	elems.push("<div style=\"margin-left: 15px;"+ml_svm_display+"\"><b>"+
        			    $.getInfo("ml_result_detection")+"&nbsp;"+
        			    ml_svm_attacktypes[ml_svm_main_type.toString()]+"</b></div>");
        		}
                elems.push("<div width=\"500px\" id=\"ml_svm_"+tableid+"\" style=\""+ml_svm_display+"\"></div>");
                elems.push("<div style=\"text-align: center;height: 30px;"+ml_svm_display+"\">");
                elems.push("<span class=\"svm-high-circle\"></span><span>"+$.getInfo("ml_high")+"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>");
                elems.push("<span class=\"svm-sus-circle\"></span><span>"+$.getInfo("ml_sus")+"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>");
                elems.push("<span class=\"svm-safe-circle\"></span><span>"+$.getInfo("ml_safe")+"</span>");
                elems.push("</div>");
                elems.push("</div></td></tr>");

                /* ml_except */
                var ml_except_id = row_entry_["pcap_id"] ? row_entry_["pcap_id"] : row_entry_["ml_except_id"]
                elems.push("<tr><td colspan=2 width=\"100%\" text-align= \"center\">");
                elems.push("<div id=\"ml_except_"+ml_except_id+"\" style=\""+ml_svm_display+"\" ml_domain_index=\""+row_entry_["ml_domain_index"]+"\" ml_arg_dbid=\""+row_entry_["ml_arg_dbid"]+"\" ml_url_dbid=\""+row_entry_["ml_url_dbid"]+"\">");
                elems.push("</div></td></tr>");
                elems.push("<tr><td colspan=2 width=\"100%\" text-align= \"center\">");
                elems.push("<div id=\"ml_add_except_"+ml_except_id+"\" style=\"display:none;text-align: center;height: 30px;\" ml_domain_index=\""+row_entry_["ml_domain_index"]+"\" ml_arg_dbid=\""+row_entry_["ml_arg_dbid"]+"\" ml_url_dbid=\""+row_entry_["ml_url_dbid"]+"\">");
                
                elems.push("</div></td></tr>");                
                elems.push("</table>");

                var ml_actions = [];                
                var ml_url = '&policy='+row_entry_["policy"]+'&arg_id='+row_entry_["ml_arg_dbid"]+'&url_id='+row_entry_["ml_url_dbid"]+'&domain_index='+row_entry_["ml_domain_index"];

                var ml_rebuild_url = '/waf/ml_policy/refresh_model?session_id='+session_id+'&relearn_type=0'+ml_url;
                var ml_relearn_url = '/waf/ml_policy/refresh_model?session_id='+session_id+'&relearn_type=3'+ml_url;
                var ml_arg_url = '/waf/ml_policy/log_arg_setting?session_id='+session_id+ml_url;
                
                ml_actions.push({
                    text: '<span><f-icon class="fa-undo"></f-icon>' + $.getInfo("rebuild_model") + '</span>',
                    id: 'menu_action_ml_rebuild',
                    classname: 'menu_act_item',
                    value: 'ml_rebuild',
                    onclick: {
                        fn: function() {
                            wij_display_modal_dlg( ml_rebuild_url , {'width': 400, 'height': 200});
                        }
                    }
                });
                ml_actions.push({
                    text: '<span><f-icon class="fa-repeat"></f-icon>' + $.getInfo("relearn_model") + '</span>',
                    id: 'menu_action_ml_relearn',
                    classname: 'menu_act_item',
                    value: 'ml_relearn',
                    onclick: {
                        fn: function() {
                            wij_display_modal_dlg( ml_relearn_url , {'width': 400, 'height': 200});
                        }
                    }
                });                
                ml_actions.push({
                    text: '<span><f-icon class="ftnt-tools"></f-icon>' + $.getInfo("goto_arg") + '</span>',
                    id: 'menu_action_ml_arg_setting',
                    classname: 'menu_act_item',
                    value: 'ml_arg_setting',
                    onclick: {
                        fn: function() {
                            wij_display_modal_dlg( ml_arg_url , {'width': 850, 'height': 500});
                        }
                    }
                });
                var menu_actions = [ml_actions];
                msg_menu_actions[msg_menu_count] = ml_actions;
                msg_menu_count++;
                need_msg_menu = true;

            }else if(row_entry_ && row_entry_["sub_type"] === "HTTP Method violation"){
		    var tableid = "am_table_"+row_entry_["msg_id"];
		    var ml_allow_method = row_entry_["ml_allow_method"];
		    var am_data = ml_allow_method.split(';');
		    var am_obj = {};
		    var all_methods = ["GET", "POST", "HEAD", "OPTIONS", "TRACE", "CONNECT", "DELETE", "PUT", "PATCH", "WEBDAV", "RPC", "Others"];
		    for(var j=0; j<am_data.length; j++)
		    {	
			    var key = am_data[j].split(':')[0];
			    var val = am_data[j].split(':')[1];
			    am_obj[key] = val;
		    }
		    var am_html = "<div style=\"padding-bottom: 10px;\">";
		    var i = 0;
		    while(i<all_methods.length)
		    {
			    var mtd = all_methods[i];
			    var br; 
			    var icon;
			    var enabled = false;
			    i++;
			    if(am_obj[mtd] !== undefined)
			    {
				    enabled = true;
			    }
			    br = (i%3==0)?"</div><div style=\"padding-bottom: 10px;\">":"";
			    icon = enabled?"<f-icon class=\"ftnt-yes\"></f-icon>":"&nbsp;";
			    am_html += "<span style=\"padding-right: 10px;width: 65px;\">" + mtd + "</span>" + 
				    "<span style=\"padding-right: 20px;width: 30px;\">"+ icon + 
				    "</span>" + br;
		    }
		    am_html+="</div>";
		    elems.push("<div style=\"height: 5px;\"></div>");
		    elems.push("<table cellspace=\"1\" cellpadding=\"0\" class=\"list log_details pre\" style=\"table-layout:fixed\">");
		    elems.push("<tr class=\"head\"><td width=\"50%\" colspan=\"6\" onclick=\"DetailsWindow.trigger_div('ml"+tableid+"')\">");
		    elems.push("<f-icon id=\"imgs_ml"+tableid+"\" class=\"fa-minus-square\" style=\"display: '';color: #646464;\"></f-icon>");
		    elems.push("<f-icon id=\"imgh_ml"+tableid+"\" class=\"fa-plus-square\" style=\"display: none;color: #646464;\"></f-icon>");
		    elems.push("<b>" + $.getInfo("machine_learning") + "</b></td>");
		    elems.push("</tr>");
		    elems.push("<tr><td colspan=\"6\">");
		    elems.push("<div id=\"div_ml"+tableid+"\" style=\"margin-left: 15px;\"><b>"+$.getInfo("ml_allow_methods")+"</b><hr style=\"height: 0;\">"+am_html+"</div>");
		    elems.push("<div  style=\"margin-left: 15px;display: flex; flex-direction: column;\">");
		    elems.push("</div>");
		    elems.push("</td></tr>");
		    elems.push("</table>");
		
            }
        }

        // Bot Detection
        if (row_entry_ && row_entry_["main_type"] === "Bot Detection") {
            if(row_entry_.detail){
                var botInfoStr = row_entry_.detail.split('bot_info="')[1].split('" ')[0];
                if (botInfoStr != "none") {
                    var tableid = row_entry_["msg_id"];

                    elems.push("<div style=\"height: 5px;\"></div>");
                    elems.push("<table cellspace=\"1\" cellpadding=\"0\" class=\"list log_details pre\" style=\"table-layout:fixed\">");
                    elems.push("<tr class=\"head\"><td width=\"50%\" onclick=\"DetailsWindow.trigger_div('bot_"+tableid+"')\">");
                    elems.push("<f-icon id=\"imgs_bot_"+tableid+"\" class=\"fa-minus-square\" style=\"display: '';color: #646464;\"></f-icon>");
                    elems.push("<f-icon id=\"imgh_bot_"+tableid+"\" class=\"fa-plus-square\" style=\"display: none;color: #646464;\"></f-icon>");
                    elems.push("<b>" + $.getInfo("bot_detection") + "</b></td>");
                    elems.push("<td></td></tr>");

                    elems.push("<tr><td colspan=2 width=\"100%\"><div id=\"div_bot_"+tableid+"\" width=\"100%\">");
                    elems.push("<div width=\"500px\" id=\"bot_spider_"+tableid+"\"></div>");



                    elems.push("</div></td></tr>");
                    elems.push("</table>");
                }
            }
        }

        /* this for msg menu */
        if(need_msg_menu)
        {
            elems.push('<div class="msg_menu_holder"></div>');
        }

        /* this for packet log */
        if(row_entry_ && row_entry_.pcap_id)
        {
            var pcap_id = row_entry_.pcap_id;
            //from pcap_id get pactet log table
            elems.push("<div id=\"packet_"+pcap_id+"\" ></div>");
            elems.push("<div id=\"comment_"+pcap_id+"\" ></div>");
            
            var logfile = row_entry_.logfile;
            var logType = log_type;
            var agg_url = "/log_aggregate/getLogByID";
            var agg_data = {msgID:pcap_id,logType:logType,is_aggregate:0, logfile: logfile, ml_domain_index:row_entry_.ml_domain_index, ml_arg_dbid:row_entry_.ml_arg_dbid, ml_url_dbid:row_entry_.ml_url_dbid};
            /*add for ha_log view */
            if(typeof(is_ha_log) !== 'undefined' && is_ha_log) {
                var json_path = (dev_id != 0)?'/ha_redir':"/manager_redir";
                var path_uri = "api/v1.0/LogReport/LogAccess/LogAccessAttackDetail"
                path_uri = setQueryValue(path_uri, 'msgID', pcap_id);
                path_uri = setQueryValue(path_uri, 'logType', log_type);
                path_uri = setQueryValue(path_uri, 'is_aggregate', 0);
                path_uri = setQueryValue(path_uri, 'logfile', logfile);
                json_path = setQueryValue(json_path, 'uri', path_uri);
                json_path = setQueryValue(json_path, 'dev_id', dev_id);
                json_path = setQueryValue(json_path, 'ip', ip);
                $j.getJSON(json_path,function(data){
                    if(data){
                        aggCallback(data,pcap_id);
                        if(data.comment) commentCallback(data.comment, pcap_id, logfile);
                    }
                },"json");
            } else {
                $j.post(agg_url,agg_data,function(data){
                    if(data){
                        aggCallback(data,pcap_id);
                        if(data.comment) commentCallback(data.comment, pcap_id, logfile);
                    }
                },"json");
            }
        }else if(row_data && row_data.disk.msg_id && (row_data.args || row_data.cookies || row_data.files || row_data.head || row_data.pattern)){
            //this for aggregate display packet log
            var packettable = buildpackettable(row_data,1,"insert_"+row_data.disk.msg_id); 
            elems.push("<div id=\"packet_"+row_data.disk.msg_id+"\" >"+packettable.join('')+"</div>");
        }

        return $(elems.join(''));
    }


    function showRowDetails(tr) {	
        var row_entry;
        var table;
        var local = getDetailPaneLocation();

        if (typeof(tr) === 'undefined') {
            tr = selectedRowEntry;

            if (!tr) {
                return;
            }
        }

        if (tr.rowIndex < 1) {
            return;
        }

        // decrease header row & filter row
        var index = tr.rowIndex - 1;//(first_row != null ? first_row.rowIndex : 0);
	    if(!$(tr).is(config.validRowClasses)) return
        row_entry = config.getRowCallback(index);
        table = buildDetailTable(local === 'east' ? 1 : 2, row_entry,'disk_table');

        var tabs_exist = $('#details-tab').length || $('#archive-tab').length;
        if (tabs_exist) {
            detailsPanel.tabs('destroy');
        }

        detailsPanel.empty();
        if(layout.panes.east.hasClass('layout-pane-hidden')) layout.open(local);
        if (row_entry) {
            	
            var has_threat_detail_tabs = config.isShowThreatDetails &&
                    row_entry.threat && row_entry.threat.length > 0;

            var has_archive_tab = row_entry._is_archived &&
                    $.isFunction(config.getArchiveCallback);

            if (!has_archive_tab && !has_threat_detail_tabs) {
                // no tabs
                detailsPanel.append(table);
            } else {
                // with tabs
                // markup details tab first
                var details_tab = $('<div id="details-tab"></div>').append(table);
                var details_menu = $('<ul><li><a href="#details-tab">' +
                             $.getInfo('log_details') + '</a></li></ul>');
                detailsPanel.append(details_menu).append(details_tab);

                var tab = '';
                var menu = '';
                // markup archive tab
                if (has_archive_tab) {
                    tab = '<div id="archive-tab" style="height: 100%"></div>';
                    menu = '<li><a href="#archive-tab">' +
                           $.getInfo('archive') + '</a></li>';
                }
                // markup threat detail tabs
                if (has_threat_detail_tabs) {
                    var threat_detail_tabs = buildThreatDetailTabHelper();
                    tab += threat_detail_tabs.tab;
                    menu += threat_detail_tabs.menu;
                }
                $(menu).appendTo(detailsPanel.find('ul'));
                $(tab).insertAfter(detailsPanel.find('#details-tab'));
                // build tabs
                detailsPanel.tabs({
                    activate: function(event, ui) {
                        var $tab = $(ui.newPanel.selector);
                        if (ui.newPanel.selector === '#archive-tab') {
                            var entry = config.archiveData[index];
                            var content = config.getArchiveCallback(entry);
                            $tab = $('#archive-tab');
                            $('#archive-tab').html(content);
                        } else if (ui.newPanel.selector !== '#details-tab') {
                            var $iframe = $tab.find('.threat_detail_frame');
                            var iframe_src = $(ui.newTab).find('a').data('iframe-src');
                            if (!$iframe.attr('src')) {
                                $iframe.attr('src', iframe_src);
                            }
                        }
                        //prevent overriding display:flex
                        $tab.css('display', '');
                    }
                });
            }
            if(row_entry.aggregate && row_entry.aggregate.has_score == 1)
            {
                detail_top_paging(row_entry.aggregate);
            }  
        }else{
    		detailsPanel.append(table);
    	}

        if ($.isFunction(config.selectionChangedCallback)) {
            config.selectionChangedCallback(row_entry);
        }

        function buildThreatDetailTabHelper() {
            var incident_map = {
                    'countav': {
                        'path': 'av',
                        'label': 'utm_av'
                    },
                    'countweb': {
                        'path': 'web',
                        'label': 'utm_webfilter'
                    },
                    'countapp': {
                        'path': 'app',
                        'label': 'utm_app'
                    },
                    'countips': {
                        'path': 'ips',
                        'label': 'tab_utm_ips'
                    },
                    'countdlp': {
                        'path': 'dlp',
                        'label': 'utm_dlp'
                    },
                    'countemail': {
                        'path': 'email',
                        'label': 'utm_emailfilter'
                    }
                },
                menu = '',
                divtab = '',
                incidents = row_entry.threat;

            for (var i = 0, len = incidents.length; i < len; i++) {
                var name = incidents[i].key;
                var filter = [{'logic': {}, 'id': 'utmref',
                               'value': [row_entry.utmref]}];
                var incident_count = row_entry[name];
                var src = '/p/logs/' + incident_map[name].path + '/?filter=' +
                          encodeURIComponent(JSON.stringify(filter)) +
                          '&is_embedded=1&keep_filter=1&forward_threat_detail=1';
                var id = name + '-tab';
                // Backend does not support server paging on logs drilldown by
                // utmref
                // To show logs more than two pages, either use client paging
                // or disable paging; for now disable paging so that no paging
                // button is shown, since most cases are less than one page.
                // TODO:
                // 1) could add back client paging back after sync with trunk
                // to get the gui lines per page in config
                // 2) Add limitation on rows to fetch
                src = setQueryValue(src, 'rows', incident_count);

                menu += '<li><a href="#' + id + '"' +
                        ' data-utmref="' + row_entry.utmref + '"' +
                        ' data-iframe-src="' + src + '">' +
                        $.getInfo(incident_map[name].label) +
                        ' (' + incident_count + ')</a></li>';
                divtab += '<div id="' + id + '" class="threat_detail_div">' +
                          '<iframe class="threat_detail_frame"></iframe></div>';
            }
            return {
                'menu': menu,
                'tab': divtab
            };
        }
	    set_highcharts(row_entry);
    }

    function scrollIntoViewAfterKeypress(tr, keyCode) {
        if (keyCode !== $.ui.keyCode.UP && keyCode !== $.ui.keyCode.DOWN) { return; }
            // find scrolling parent
        var container;
        while ((container = tr.parentNode) != null) {
            if (container.offsetHeight !== container.scrollHeight) { break; }
            tr = container;
        }
        if (!container) { return; }
        if (keyCode === $.ui.keyCode.DOWN &&
                (tr.offsetTop > container.scrollTop + container.offsetHeight)) {
            tr.scrollIntoView(false);
        }
        if (keyCode === $.ui.keyCode.UP &&
                (tr.offsetTop - tr.offsetHeight < container.scrollTop)) {
            tr.scrollIntoView(true);
        }
    }

    function hideRowDetails() {
        var local = getDetailPaneLocation();

        layout.hide(local, true);
	layout.sizePane(local, 0);
	refreshDisplay();
    }
    function trimSpace(val)
    {
        return val.replace(/^\s+|\s+$/g,'');
    }
    function resize_score(entry)
    {
        $("#log_details_top-resizer").mousedown(function(e){
            var offset = $(this).offset();//DIV在页面的位置   
            var y = e.pageY - offset.top;//获得鼠标指针离DIV元素上边界的距离  
            $(document).bind("mousemove",function(ev)//绑定鼠标的移动事件，因为光标在DIV元素外面也要有效果，所以要用doucment的事件，而不用DIV元素的事件  
            {  
                $("#log_details_top-resizer").stop();//加上这个之后  
                  
                var _y = ev.pageY - y;//获得Y轴方向移动的值  
                if(_y < 90) return;
                $("#log_details_top-resizer").animate({top:_y+"px"},1);  
                $("#disk_table").animate({top:(_y+5)+"px"},1); 
            });  
            $(document).mouseup(function(){  
                $(this).unbind("mousemove");  
            })     
        }); 
    }

    function detail_top_paging(entry)
    {
        $j('#page_top_first').bind('click', function(){
            if(score_top_curpage == 0) return false;
            score_top_curpage = 0;
            buildTable_score_top(entry.date,score_top,entry.count);
        });
        $j('#page_top_prev').bind('click', function(){
            if(score_top_curpage == 0) return false;
            if(score_top_curpage > 0) score_top_curpage -= 1;
            buildTable_score_top(entry.date,score_top,entry.count);
        });
        $j('#page_top_next').bind('click', function(){
            var max_page = parseInt(entry.count/10) + 1;
            if(score_top_curpage + 1 < max_page)
            {
                score_top_curpage += 1;
            }
            var last_msgid = score_top[score_top.length -1 ].msg_id;
            buildTable_score(entry.date,entry.viewline,last_msgid,entry.count);
        });
     }
    function aggregate_detail(date, type, signature, viewline, msg_id, count, aggre_name)
    {
        var html='';
        var date_in = new Date();
        var new_table_id = date_in.getTime();
        //aggregate table
        html += "<table class='list log_details' style='border:0'>"//<tr class='head'><td><div title='Click to collapse this pane.' id='detail_expanded' onclick='DetailsWindow.hide()' style='"
		//+"cursor: pointer;   height: 13px;   left: 5px;   top: 5px;  width: 17px;   font-size: 0;"
		//+"background: transparent url(/build/assets/skins/sam/layout_sprite.png) no-repeat -20px -200px;   border: 1px solid #808080;'></div>"
		//+"</td></tr></table>";
		+"</table>";
        //elems.push("<div style=\"height: 20px;padding:5px\" align=\"left\"><b>Log Aggregation:</b></div>");
        if(count > 1){                
            html += "<table cellspace=\"1\" cellpadding=\"0\" class=\"list log_details pre\" style=\"table-layout:fixed\">";
            html += "<tr class=\"odd\"><td width=\"30%\" class=\"label\"><b>"+$.getInfo('date')+"</b></td><td width=\"70%\" class=\"value\"><b>"+date+"</b></td></tr>"; 
            html += "<tr class=\"odd\"><td width=\"30%\" class=\"label\"><b>"+$.getInfo('type')+"</b></td><td width=\"70%\" class=\"value\"><b>"+aggre_name+"</b></td></tr>"; 
            html += "<tr><td style=\"background-color: #fff;\" colspan = 2><table id=\"log_aggregate"+new_table_id+"\" width=\"100%%\" style=\"background-color: #fff;border-width:1px 1px;table-layout:fixed\" class=\"yui-skin-sam yui-panel log-detail\">";
            html += "<tr class=\"head\"><td width=\"20%\"><b>"+$.getInfo('msg_id')+"</b></td>"
                +"<td width=\"20%\"><b>"+$.getInfo('src')+"</b></td>"
                +"<td width=\"20%\"><b>"+$.getInfo('dst')+"</b></td>"
                +"<td width=\"40%\"><b>"+$.getInfo('http_url')+"</b></td></tr>";
        }else{
            html += "<div id=\"log_aggregate"+new_table_id+"\"></div>";
        }
        buildTable_aggregate(date,type,signature,viewline,msg_id,count,new_table_id);
        if(count > 1) {
            html += "</table></td></tr></table>";
        }    
        return html;    
    }

    function trigger_div(id)
    {
        var div = document.getElementById("div_"+id);
        var imgs = document.getElementById("imgs_"+id);
        var imgh = document.getElementById("imgh_"+id);

        if(!div || !imgs || !imgh)
            return;

        if(div.style.display == 'none')
        {
            div.style.display = '';
            imgs.style.display = '';
            imgh.style.display = 'none';
        }
        else
        {
            div.style.display = 'none';
            imgs.style.display = 'none';
            imgh.style.display = '';
        }
    }
    function trigger_table(id)
    {
        var table = $j('#'+id+' tr:not(:first)');//document.getElementById(id);
        var imgs = document.getElementById("imgs_"+id);
        var imgh = document.getElementById("imgh_"+id);

        if(!table || !imgs || !imgh)
            return;

        if(imgh.style.display == '')
        {
            table.each(function(i,e){e.style.display = '';});
            imgs.style.display = '';
            imgh.style.display = 'none';
        }
        else
        {
            table.each(function(i,e){e.style.display = 'none';});
            imgs.style.display = 'none';
            imgh.style.display = '';
        }
    }
    function more_details(id, type)
    {
        var table = $j('#'+id+' tr:not(:first)');
        var label = $j('#more_details_label');
        var hide = true;

        table.each(function(i,e){
            if(e.id === '') return;
            var is_default = is_default_cloumn(e.id, type);
            if(!is_default){
                hide = $j(e).hasClass('hidden');
                $j(e).toggleClass('hidden', !hide);
            } 
        });
        if(hide){
            label.html('<a href="javascript:;">'+$.getInfo('hide_details')+'</a>');
        }else{
            label.html('<a href="javascript:;">'+$.getInfo('more_details')+'</a>');
        }

    }
    function buildTable_aggregate(date,type,signature,viewline,msg_id,count,new_table_id)
    {
        function aggCallback(result){
            var agg_html = "";
            var last_msgid = 0;
            for(var i = 0 ; i <result.length ;i++)
            {
                var msgID = result[i].msg_id;
                var logfile = result[i].logfile;
                var index = msgID;
                if(index<10000) index = index*1000;
                if(count > 1){
                    if(i%2 == 0) 
                        agg_html += "<tr class=\"grey\"";
                    else
                        agg_html += "<tr";

                    agg_html += " onclick='javascript:update_rows("+index+", "+index+", "+index+");get_log_by_msgID("+msgID+", \""+logfile+"\");'><td width=\"20%\" style=\"white-space: nowrap;\"> ";
                    
                    agg_html += "<f-icon id=\"imgs_"+(index)+"\" class='fa-minus-square' style=\"display:none;color: #646464;\" ></f-icon>"
                    +"<f-icon id=\"imgh_"+(index)+"\" class='fa-plus-square' style=\"display:'';color: #646464;\" ></f-icon>"
                        +msgID+"</td>"
                        +"<td width=\"25%\">"+result[i].src+"</td>"
                        +"<td width=\"25%\">"+result[i].dst+"</td>"
                        +"<td width=\"30%\">"+result[i].url+"</td></tr>"
                        +"<tr id=\"tr_"+index+"\" style=\"display:none;\"><td style=\"background-color: #fff;\" colspan=4><div style=\"background-color: #e8e7f1\" id=\"detail_"+msgID+"\" ></div></td></tr>";                     
                }else{
                    $("#log_aggregate"+new_table_id).append("<div style=\"background-color: #e8e7f1\" id=\"detail_"+msgID+"\" ></div>");
                    get_log_by_msgID(msgID, logfile);
                    break;
                }
                last_msgid = msgID; 
            }
            if(count > 1) $("#log_aggregate"+new_table_id).append(agg_html);
            if(viewline > result.length) $("#aggregate_more").remove();
            if(last_msgid && viewline == result.length)
            {
                $("#aggregate_more").remove();
                $("#log_aggregate"+new_table_id).append("<tr class=\"head\" id=\"aggregate_more\"><td  colspan = 4><a href='javascript:;' onclick=\"DetailsWindow.aggregatetable('"+date+"','"+type+"','"+signature+"','"+viewline+"','"+last_msgid+"','"+count+"','"+new_table_id+"')\">More>></a></td></tr>");
            }
        };
	    /*add for ha_log view */
	    if(typeof(is_ha_log) !== 'undefined' && is_ha_log) {
    		var json_path = (dev_id != 0)?'/ha_redir':"/manager_redir";
    		var path_uri = "api/v1.0/LogReport/LogAccess/LogAccessAggregatedAttackSum"
    		path_uri = setQueryValue(path_uri, 'date', date);
    		path_uri = setQueryValue(path_uri, 'type', type);
    		path_uri = setQueryValue(path_uri, 'msg_id', msg_id);
    		path_uri = setQueryValue(path_uri, 'viewline', viewline);
    		path_uri = setQueryValue(path_uri, 'signature', signature);
    		json_path = setQueryValue(json_path, 'uri', path_uri);
        	json_path = setQueryValue(json_path, 'dev_id', dev_id);
            json_path = setQueryValue(json_path, 'ip', ip);
        	$j.getJSON(json_path,function(data){
               	 if(data)aggCallback(data.result);
        	},"json");
	    }else{
		var agg_url = "/log_aggregate";
		var agg_data = {date:date,type:type,signature:signature,viewline:viewline,msg_id:msg_id};
		$.post(agg_url,agg_data,function(data){
		    if(data)aggCallback(data.result);
		},"json");  
	    }      
    }
    function aggregate_score_detail(date, time, score_threshold, score_sum, score_scope, msg_id, entry_sequence, log_file_name)
    {
        var html='';
        var date_in = new Date();
        var new_table_id = date_in.getTime();
        //aggregate table
        //html += "<div style=\"height: 5px;\"></div>";
        //elems.push("<div style=\"height: 20px;padding:5px\" align=\"left\"><b>Log Aggregation:</b></div>");
        //if(count > 1){                
            html += "<table cellspace=\"1\" cellpadding=\"0\" class=\"list log_details pre\" style=\"table-layout:fixed\">";
            //html += "<tr class=\"odd\"><td width=\"30%\"><b>"+$.getInfo('date')+"</b></td><td width=\"70%\">"+date+"</td></tr>"; 
            html += "<tr class=\"odd\"><td width=\"30%\" class=\"label\"><b>"+$.getInfo('time_period')+"</b></td><td width=\"70%\" class=\"value\" id=\"td_time_period\"></td></tr>"; 
            html += "<tr class=\"odd\"><td width=\"30%\" class=\"label\"><b>"+$.getInfo('score_sum')+"</b></td><td width=\"70%\" class=\"value\">"+score_sum+" "+$j.getInfo("points")+"</td></tr>"; 
            html += "<tr class=\"odd\"><td width=\"30%\" class=\"label\"><b>"+$.getInfo('score_threshold')+"</b></td><td width=\"70%\" class=\"value\">"+$j.getInfo(threshold_info[thres_to_val(score_threshold)])+ "(" + score_threshold + " "+$j.getInfo("points") + ")</td></tr>"; 
            html += "<tr class=\"odd\"><td width=\"30%\" class=\"label\"><b>"+$.getInfo('score_scope')+"</b></td><td width=\"70%\" class=\"value\">"+score_scope+"</td></tr>";
            html += "<tr class=\"odd\"><td width=\"30%\" class=\"label\"><b>"+$.getInfo('score_count')+"</b></td><td width=\"70%\" class=\"value\" id=\"td_score_count\"></td></tr>";                         
            html += "<tr><td style=\"background-color: #fff;\" colspan = 2><table id=\"log_aggregate"+new_table_id+"\" width=\"100%%\" style=\"background-color: #fff;border-width:1px 1px;table-layout:fixed\" class=\"yui-skin-sam yui-panel\">";
            html += "<tr class=\"head\"><td><b>"+$.getInfo('msg_id')+"</b></td>"
                +"<td><b>"+$.getInfo('http_url')+"</b></td>"
                +"<td><b>"+$.getInfo('sig_type')+"</b></td>"
                +"<td><b>"+$.getInfo('event_score')+"</b></td></tr>";
        //}else{
        //    html += "<div id=\"log_aggregate"+new_table_id+"\"></div>";
        //}
        buildTable_aggregate_score(date,msg_id,new_table_id, entry_sequence, log_file_name);
        //if(count > 1) {
            html += "</table></td></tr></table>";
       // }    
        return html;    
    }

    function buildTable_aggregate_score(date,msg_id,new_table_id, entry_sequence, log_file_name)
    {
        function aggCallback(result){
            var agg_html = "";
            var last_msgid = 0;
            if(result && result.length > 0)
            {
                var timePeriodStr = "";
                timePeriodStr = result[0].score_time + " ~ " + result[result.length-1].score_time;
                $("#td_score_count").html(result.length);
                $("#td_time_period").html(timePeriodStr);
                for(var i = 0 ; i <result.length ;i++)
                {
                    var msgID = result[i].msg_id;
                    var logfile = result[i].file;
                    var index = msgID;
                    var scores_message = "";
                    if(index<10000) index = index*1000;
                    //if(result.length > 1){

                        var point_tip = $j.getInfo("points");
                        if(result[i].score == 1) point_tip = $j.getInfo("point");

                        if(result[i].url == "N/A" && result[i].sub_category == "N/A" && result[i].score == 0)
                        {
                            scores_message = "N/A";
                            agg_html += "<tr class=\"null\">";
                        } else {
                            scores_message = $j.getInfo(scores_info[result[i].score-1])+ "(" + result[i].score + " "+point_tip + ")";
                            if(i%2 == 0) 
                                agg_html += "<tr class=\"grey\"";
                            else
                                agg_html += "<tr";

                            agg_html += " onclick='javascript:update_rows("+index+", "+index+", "+index+");get_log_by_msgID("+msgID+", \""+logfile+"\");'> ";
                        }

                        agg_html += "<td style=\"white-space: nowrap;\">"
                        +"<f-icon id=\"imgs_"+(index)+"\" class='fa-minus-square' style=\"display:none;color: #646464;\" ></f-icon>"
                        +"<f-icon id=\"imgh_"+(index)+"\" class='fa-plus-square' style=\"display:'';color: #646464;\" ></f-icon>"
                            +msgID+"</td>"
                            +"<td style=\"word-break: break-all;\">"+result[i].url+"</td>"
                            +"<td>"+result[i].sub_category+"</td>"
                            +"<td>"+scores_message+"</td></tr>"
                            +"<tr id=\"tr_"+index+"\" style=\"display:none\"><td style=\"background-color: #fff;\" colspan=4><div style=\"background-color: #e8e7f1\" id=\"detail_"+msgID+"\" ></div></td></tr>";                     
                   // }else{
                   //     $("#log_aggregate"+new_table_id).append("<div style=\"background-color: #e8e7f1\" id=\"detail_"+msgID+"\" ></div>");
                   //     get_log_by_msgID(msgID, logfile);
                    //    break;
                   // }
                    last_msgid = msgID; 
                }
                //if(count > 1) 
                $("#log_aggregate"+new_table_id).append(agg_html);
                if(100 > result.length) $("#aggregate_more").remove();
                if(last_msgid && 100 == result.length)
                {
                    $("#aggregate_more").remove();
                    $("#log_aggregate"+new_table_id).append("<tr class=\"head\" id=\"aggregate_more\"><td  colspan = 4><a href='javascript:;' onclick=\"DetailsWindow.aggregatetablescore('"+date+"','"+last_msgid+"','"+new_table_id+"','"+log_file_name+"')\">More>></a></td></tr>");
                }
            }
        };
	    /*add for ha_log view */
	    if(typeof(is_ha_log) !== 'undefined' && is_ha_log) {
    		var json_path = (dev_id != 0)?'/ha_redir':"/manager_redir";
    		var path_uri = "api/v1.0/LogReport/LogAccess/LogAccessAggregatedAttackSum"
    		path_uri = setQueryValue(path_uri, 'date', date);
    		path_uri = setQueryValue(path_uri, 'entry_sequence', entry_sequence);
    		path_uri = setQueryValue(path_uri, 'msg_id', msg_id);
    		path_uri = setQueryValue(path_uri, 'log_file_name', log_file_name);
    		json_path = setQueryValue(json_path, 'uri', path_uri);
        	json_path = setQueryValue(json_path, 'dev_id', dev_id);
            json_path = setQueryValue(json_path, 'ip', ip);
        	$j.getJSON(json_path,function(data){
               	 if(data)aggCallback(data.result);
        	},"json");
	    }else{
		var agg_url = "/log/display/getsum";
		var agg_data = {date:date,msg_id:msg_id,entry_sequence:entry_sequence,log_file_name:log_file_name};
		$.post(agg_url,agg_data,function(data){
		    if(data)aggCallback(data.result);
		},"json");   
	    }     
    }    
    function buildTable_score(date,viewline,msg_id,count)
    {
        if(score_top.length / 10 > score_top_curpage)
        {
            buildTable_score_top(date,score_top,count);
            return ;
        }
        if(score_top.length % 100 != 0){
            /* we get 100 from database one time*/
            return ;
        }

        function aggCallback(result){
            for(var i = 0 ; i <result.length ;i++)
            {
                /* add new array for paging */
                score_top.push(result[i]);
            }
            buildTable_score_top(date,score_top,count);
        };
	    /*add for ha_log view */
	    if(typeof(is_ha_log) !== 'undefined' && is_ha_log) {
    		var json_path = (dev_id != 0)?'/ha_redir':"/manager_redir";
    		var path_uri = "api/v1.0/LogReport/LogAccess/LogAccessAttackDetail"
    		path_uri = setQueryValue(path_uri, 'date', date);
    		path_uri = setQueryValue(path_uri, 'viewline', viewline);
    		path_uri = setQueryValue(path_uri, 'msg_id', msg_id);
    		json_path = setQueryValue(json_path, 'uri', path_uri);
        	json_path = setQueryValue(json_path, 'dev_id', dev_id);
            json_path = setQueryValue(json_path, 'ip', ip);
        	$j.getJSON(json_path,function(data){
               	 if(data)aggCallback(data.result);
        	},"json");
	    }else{
		var agg_url = "/log_aggregate/score";
		var agg_data = {date:date,viewline:viewline,msg_id:msg_id};
		$.post(agg_url,agg_data,function(data){
		    if(data)aggCallback(data.result);
		},"json");  
	    }
      
    }        
    
    function buildTable_score_top(date,result,count)
    {
        var agg_html = "";
        var start = score_top_curpage * score_top_pagesize;
        var end = (score_top_curpage + 1) * score_top_pagesize;
        if(start == 0)
        {
            $j('#page_top_first').attr('disabled','disabled');
            $j('#page_top_prev').attr('disabled','disabled');
        }else{
            $j('#page_top_first').removeAttr('disabled');
            $j('#page_top_prev').removeAttr('disabled');      
        }

        if(result.length%100 == 0 || result.length > end)
        {
            $j('#page_top_next').removeAttr('disabled');            
        }else{
            $j('#page_top_next').attr('disabled','disabled');
        }

        if(parseInt(count%10) == 0)
            $j('#page_top_current').text(" "+(score_top_curpage+1)+"/"+(parseInt(count/10))+" ");
        else
            $j('#page_top_current').text(" "+(score_top_curpage+1)+"/"+(parseInt(count/10)+1)+" ");

        var data = result.slice(start,end);
        for(var i = 0 ; i <data.length ;i++)
        {
            var msgID = data[i].msg_id;
            var logfile = data[i].logfile;
            var time = data[i].time;
            var score_sum = data[i].score_sum;
            var score_scope = data[i].score_scope;
            var score_threshold = data[i].score_threshold;
            var entry_sequence = data[i].entry_sequence;
            var log_file_name = data[i].log_file_name;
            if(data.length > 0){
                if(i%2 == 0) 
                    agg_html += "<tr class=\"even";
                else
                    agg_html += "<tr class=\"odd";

                if(i == 0) agg_html += " log_entry_selected";

                agg_html += "\" msg_id=\""+msgID+"\" time=\""+time+"\" score_threshold=\""+score_threshold+"\" score_sum=\""+score_sum+"\" score_scope=\""+score_scope+"\" entry_sequence=\""+entry_sequence+"\" log_file_name=\""+log_file_name+"\"> ";
                
                agg_html += "<td style='padding-left: 10px;'>"+time+"</td>"
                    +"<td>"+data[i].policy+"</td>"
                    +"<td>"+score_sum+" "+$j.getInfo("points")+"</td>"
                    +"<td>"+$j.getInfo(threshold_info[thres_to_val(data[i].score_threshold)])+ "(" + data[i].score_threshold + " "+$j.getInfo("points") + ")</td>"
                    +"<td>"+score_scope+"</td></tr>";
            }else{
                $("#detail_top").append("<div style=\"background-color: #e8e7f1\" id=\"detail_"+msgID+"\" ></div>");
                //get_log_by_msgID(msgID, logfile);
                break;
            }
        }
        $("#detail_top").children().find('.even,.odd').remove(); 
        $("#detail_top").append(agg_html);
        
        $("#detail_top").find("tr").each(function(){ 
            var selected  = $(this).hasClass("log_entry_selected");
            if(selected){
                var msg_id = $(this).attr('msg_id');
                var time = $(this).attr('time');
                var score_threshold = $(this).attr('score_threshold');
                var score_sum = $(this).attr('score_sum');
                var score_scope = $(this).attr('score_scope');
                var entry_sequence = $(this).attr('entry_sequence');
                var log_file_name = $(this).attr('log_file_name');

                var aggregate_html = aggregate_score_detail(date, time, score_threshold, score_sum, score_scope, msg_id, entry_sequence, log_file_name);   
                $("#disk_table").children().remove(); 
                $("#disk_table").append(aggregate_html);  
            }
            $(this).bind("click" , function(){
                $(this).parent().find('tr').toggleClass("log_entry_selected",false);
                $(this).toggleClass("log_entry_selected",true);   

                var msg_id = $(this).attr('msg_id');
                var time = $(this).attr('time');
                var score_threshold = $(this).attr('score_threshold');
                var score_sum = $(this).attr('score_sum');
                var score_scope = $(this).attr('score_scope');
		var entry_sequence = $(this).attr('entry_sequence');
		var log_file_name = $(this).attr('log_file_name');

                var aggregate_html = aggregate_score_detail(date, time, score_threshold, score_sum, score_scope, msg_id, entry_sequence, log_file_name); 
                $("#disk_table").children().remove(); 
                $("#disk_table").append(aggregate_html);        
            })
         });   
    }

    function editCommentClick(button, msg_id, logfile) {
        $(button).text($.getInfo('save_comment'));
        $(button).attr('onclick', 'DetailsWindow.saveCommentClick("'+msg_id+'", "'+logfile+'")');
        $('#comment_value_'+msg_id).prop('disabled', false);
        $('#comment_value_'+msg_id).focus();
    }

    function saveCommentClick(msg_id, logfile) {
        var comment = $("#comment_value_"+msg_id).val();
        var data = {msg_id:msg_id,comment:comment,logfile:logfile};

        if(!comment.trim()) {
            alert($.getInfo('comment_not_null'));
            return;
        }
        
        if(typeof(is_ha_log) !== 'undefined' && is_ha_log) {
            var json_path = '/ha_redir';
            var path_uri = "api/v1.0/LogReport/LogAccess/LogAccessComment";
            json_path = setQueryValue(json_path, 'uri', path_uri);
            json_path = setQueryValue(json_path, 'dev_id', dev_id);
            $.ajax({
                url: json_path,
                type: "POST",
                contentType : 'application/json',
                data: JSON.stringify(data),
                success: function(resonse){
                    if(resonse) commentCallback(resonse, msg_id, logfile);
                },
                error: function(resonse){
                    alert($j.getInfo('save_comment_fail'));
                }
            });
        } else {
            var url = "/log/display/savecomment";
            
            $.post(url, data, function(resonse){
                if(resonse.status === 0){
                    alert($j.getInfo('save_comment_fail'));
                    return;
                }
                if(resonse) commentCallback(resonse, msg_id, logfile);
            },"json");
        }
    }

    return {
        'initialize': initialize,
        'show': showRowDetailsMenu,
        'hide': hideRowDetails,
        'click': showRowDetailsClick,
        'keypress': handleRowDetailKeyPress,
        'dblclick': showRowDetailsClick,
        "msgMenuClick":msgMenuClick,
        "buildtable":buildDetailTable,
        "trigger_div":trigger_div,
        "trigger_table":trigger_table,
        "more_details":more_details,
        "aggregatetable":buildTable_aggregate,
        'commentCallback': commentCallback,
        'editCommentClick': editCommentClick,
        'saveCommentClick': saveCommentClick
    };
})(jQuery);
function update_rows( start, end, index)
{
         for(var i = start; i <= end; i++)         {
                 var obj = document.getElementById('tr_'+i);
                 if(obj && obj.style.display == '')
                         obj.style.display = 'none';
                 else if(obj && obj.style.display == 'none')
                         obj.style.display = '';
         }
         var o = document.getElementById('imgs_'+index);
         if(o)
         {
                 if(o.style.display == 'none')
                         o.style.display = '';
                 else if(o.style.display == '')
                         o.style.display = 'none';
         }
         o = document.getElementById('imgh_'+index);
         if(o)
         {
                 if(o.style.display == 'none')
                         o.style.display = '';
                 else if(o.style.display == '')
                         o.style.display = 'none';
         }
}
function get_log_by_msgID(msgID, logfile){
    var insert = $j("#insert_"+msgID);
    if(insert.length >0) return;
    if(!logfile)   logfile = document.forms[0].log.value;
    function aggCallback(result){ 
        var table = DetailsWindow.buildtable(2,result,"insert_"+msgID); 
        $j("#detail_"+msgID).append(table) ;
        $j("#detail_"+msgID).append("<div id=\"comment_"+msgID+"\" ></div>");
        if(result.disk)set_highcharts(result.disk);
    }
    var agg_url = "/log_aggregate/getLogByID";
    var agg_data = {msgID:msgID,logType:document.forms[0].logType.value,is_aggregate:1,logfile:logfile};
    $j.post(agg_url,agg_data,function(data){
        if(data){
            aggCallback(data);
            if(data.comment) DetailsWindow.commentCallback(data.comment, msgID, logfile);
        }
        var ml_except_id = data.disk.ml_except_id;
        if(data.ml_except != -1 && data.args){
            for(var i in data.args){
                if(data.args[i].key === escapeHTML(data.ml_arg_name))
                    drawMLExcept(data.ml_except, ml_except_id, data.args[i].key, data.args[i].value);
            }
        }
    },"json");
}

function draw3D(id,info,series)
{
    var options = {
        chart: {
            type: 'column',
            options3d: {
                enabled: true,
                alpha: 15,
                beta: 15,
                viewDistance: 25,
                depth: 20
            },
            marginTop: 20,
            marginRight: 20
        },
        colors: ['#77D464', '#F7A35C'],
        title: {
            text: ''
        },
        credits:{
            enabled: false
        },
        xAxis: {
            categories: [$j.getInfo(info)]
        },
        yAxis: {
            allowDecimals: true,
            min: 0,
            title: {
                text: ''
            }
        },
        tooltip: {
            headerFormat: '',
            pointFormat: '<span style="color:{series.color}">\u25CF</span> {series.name}: {point.y}'
        },
        plotOptions: {
            column: {
                //stacking: 'normal',
                depth: 40,
                pointWidth: 25
            }
        },
        legend: {
            enabled:false
        },
        series: series
    };
    //$j(id).highcharts(options);
    var chart3d = Highcharts.chart(id,options);
    chart3d.reflow();

    $j('#logview-details').resize(function(){
        chart3d.reflow();
    });
}

function drawPolar(id,series,svm_attacktypes)
{
    var options = {
        chart: {
            polar: true,
            type: 'line'
        },
        credits:false,
        title: {
            text: ''
        },
        pane: {
            size: '80%'
        },
        xAxis: {
            categories: svm_attacktypes,
            tickmarkPlacement: 'on',
            lineWidth: 0
        },
        yAxis: {
            gridLineInterpolation: 'polygon',
            lineWidth: 0,
            gridLineWidth: 0,
            tickAmount:0,
            min: 0,
            max: 12,
            plotBands: [{
                from: 0,
                to: 4,
                color: '#3A94B1'
            }, {
                from: 4,
                to: 8,
                color: '#F2BF7A'
            }, {
                from: 8,
                to: 12,
                color: '#F3A484'
            }]
        },
        tooltip: {
            shared: true,
            enabled: false,
            //pointFormat: '<span style="color:{series.color}">{series.name}: <b>{point.y-3:,.0f}</b><br/>'
            pointFormatter: function() {
                var html = '<span style="color:'+series.color+'">'+this.series.name+': <b>';
                if(this.y>4)
                    html += this.y -3;
                else
                    html += this.y;
                html += '</b><br/>';
                return html;
            }
        },
        legend: {
            enabled:false
        },
        series: series        
    };    

    //$j(id).highcharts(options);
    var chartPolar = Highcharts.chart(id,options);
    chartPolar.reflow();
    $j('#logview-details').resize(function(){
        chartPolar.reflow();
    });
}

function drawPolarBot(id, options)
{
    var chartOptions = {
        chart: {
            polar: true,
            type: 'line'
        },
        credits:false,
        title: {
            text: ''
        },
        pane: {
            size: '80%'
        },
        xAxis: {
            categories: options.categories,
            tickmarkPlacement: 'on',
            lineWidth: 0
        },
        yAxis: {
            gridLineInterpolation: 'polygon',
            lineWidth: 0,
            gridLineWidth: 0,
            min: -0.1,
            max: 1.2,
            labels: {
                enabled: false
            }
        },
        tooltip: {
            shared: true,
            enabled: true,
            pointFormatter: function() {
                var html = '<span style="color:' + this.series.color + '">' +
                    this.series.name +': <b>' + this.series.options.dataOrigin[this.x] +
                    '</b><br/>';
                return html;
            }
        },
        series: options.series        
    };

    var chartPolar = Highcharts.chart(id, chartOptions);
    chartPolar.reflow();
    $j('#logview-details').resize(function(){
        chartPolar.reflow();
    });
}

function set_highcharts(row_entry)
{
    if(row_entry && row_entry["main_type"] === "Machine Learning" && 
	    (row_entry["sub_type"] === "Definite Anomaly in http argument" || 
	     row_entry["sub_type"] === "Potential Anomaly in http argument" || 
         row_entry["sub_type"] === "Anomaly in http argument")) //new version is only this sub type)
    {
        var id;
        var series = [{
                name:$j.getInfo("ml_mean"),
                data:[parseFloat(row_entry["ml_log_sample_prob_mean"])]
            },{
                name:$j.getInfo("ml_arg_act"),
                data:[parseFloat(row_entry["ml_log_hmm_probability"])]
            }];     
        id = 'ml_log_hmm_probability_'+row_entry["msg_id"];
        draw3D(id,'ml_log_hmm_probability',series);
        series = [{
                name:$j.getInfo("ml_mean"),
                data:[parseFloat(row_entry["ml_log_sample_arglen_mean"])]
            },{
                name:$j.getInfo("ml_arg_act"),
                data:[parseFloat(row_entry["ml_log_arglen"])]
            }]; 
        id = 'ml_arg_'+row_entry["msg_id"];
        draw3D(id,'ml_arg',series);

        var svm_acc = row_entry["ml_svm_accuracy"].split(',');
        var svm_match = row_entry["ml_svm_log_match_types"].split(',');
        var svm_log_main_types = row_entry["ml_svm_log_main_types"];
        var svm_len = 0;
        for(var svm_item in ml_svm_attacktypes)
        {
            svm_len++;
        }
        var svm_data = new Array(svm_len);
        var svm_attacktypes = new Array(svm_len);

        svm_attacktypes=[];
        for(var i =0 ;i< svm_len;i++)
        {
            if(svm_log_main_types != 0){
                svm_data[i] = 0;
                var svm_acc_sub = svm_acc[i].split(':');
                for(var j=0;j<svm_match.length;j++)
                {
                    if(parseInt(svm_acc_sub[0]) === parseInt(svm_match[j]))
                    {
                        var tmp = parseInt(svm_acc_sub[1]);
                        svm_data[i] = (10-tmp)+3;
                        break;
                    }
                }
                if(svm_data[i] === 0){
                        svm_data[i] = (parseInt(svm_acc_sub[1])-1)/2;
                }
                
            }else{
                svm_data[i] = 3;
            }
            svm_attacktypes.push(ml_svm_attacktypes[i+1]);
        }

        series = [{
            name: 'Accuracy',
            color: '#ff0000',
            data: svm_data,
            pointPlacement: 'on'
        }];
        id = 'ml_svm_'+row_entry["msg_id"];
        drawPolar(id,series,svm_attacktypes);
   } else if(row_entry && row_entry["main_type"] === "Bot Detection") {
        var id, series;
        if(!row_entry.detail)
            return;

        var botInfoStr = row_entry.detail.split('bot_info="')[1].split('" ')[0];
        if (botInfoStr == "none")
            return;

        var botInfo = JSON.parse(botInfoStr);
        var categories = [], 
            minimum = [], q2 = [], maximum = [], vector = [],
            minimumOrigin = [], q2Origin = [], maximumOrigin = [], vectorOrigin = [];
        var minimumValue, q2Value, maximumValue, vectorValue, bottom, top, diff;

        for (var i = 0; i < botInfo.boxplot_info.length; i++) {
            botInfo.boxplot_info[i].value[3] = botInfo.vector[i];

            minimumValue = botInfo.boxplot_info[i].value[0];
            q2Value = botInfo.boxplot_info[i].value[1];
            maximumValue = botInfo.boxplot_info[i].value[2];
            vectorValue = botInfo.boxplot_info[i].value[3];
            bottom = Math.min(minimumValue, q2Value, maximumValue, vectorValue);
            top = Math.max(minimumValue, q2Value, maximumValue, vectorValue);
            diff = top - bottom;
            if (diff != 0) {
                minimum.push(minimumValue / top);
                q2.push(q2Value / top);
                maximum.push(maximumValue / top);
                vector.push(vectorValue / top);
                categories.push(bot_names[i]);
                minimumOrigin.push(minimumValue);
                q2Origin.push(q2Value);
                maximumOrigin.push(maximumValue);
                vectorOrigin.push(vectorValue);
            }
        }

        series = [{
            name: 'Minimum Value',
            data: minimum,
            pointPlacement: 'on',
            color: '#00FF7F',
            dataOrigin: minimumOrigin
        }, {
            name: 'Average Value',
            data: q2,
            pointPlacement: 'on',
            color: '#00CD00',
            dataOrigin: q2Origin
        }, {
            name: 'Maximum Value',
            data: maximum,
            pointPlacement: 'on',
            color: '#4876FF',
            dataOrigin: maximumOrigin
        }, {
            name: 'Sample Value',
            data: vector,
            pointPlacement: 'on',
            color: '#FF4500',
            dataOrigin: vectorOrigin
        }, ];

        var options = {
            categories: categories,
            series: series
        };

        id = 'bot_spider_' + row_entry["msg_id"];
        drawPolarBot(id, options);
    }
}

function set_ml_except_in(id, samples, value)
{
    var renderer;

    renderer = new Highcharts.Renderer(
        $j('#'+id)[0],
        500,
        250
    );

    renderer.circle(180, 150, 50).attr({
        fill: '#5badfb',
        stroke: 'black',
        'stroke-width': 1,
        zIndex: 2
    }).add();


    renderer.circle(200, 130, 100).attr({
        fill: '#5badfb',
        stroke: 'black',
        'stroke-width': 1,
        zIndex: 1
    }).add();

    renderer.text(samples, 150, 80).attr({
        rotation: 0,
        zIndex: 1
    }).css({
        fontSize: '16pt',
        color: 'white'
    }).add();

    renderer.text(value, 155, 160).attr({
        rotation: 0,
        zIndex: 2
    }).css({
        fontSize: '16pt',
        color: 'white'
    }).add();
}

function set_ml_except_out(id, samples, value)
{
    var renderer;

    renderer = new Highcharts.Renderer(
        $j('#'+id)[0],
        500,
        250
    );

    renderer.circle(380, 150, 50).attr({
        fill: '#F7A35C',
        stroke: 'black',
        'stroke-width': 1,
        zIndex: 2
    }).add();


    renderer.circle(200, 130, 100).attr({
        fill: '#5badfb',
        stroke: 'black',
        'stroke-width': 1,
        zIndex: 1
    }).add();

    renderer.text(samples, 160, 130).attr({
        rotation: 0,
        zIndex: 1
    }).css({
        fontSize: '16pt',
        color: 'white'
    }).add();

    renderer.text(value, 355, 160).attr({
        rotation: 0,
        zIndex: 2
    }).css({
        fontSize: '16pt',
        color: 'white'
    }).add();
}

function drawMLExcept(status, id, name, value){ 
    var ml_except_id = 'ml_except_'+id;
    if(status == 1){
        set_ml_except_in(ml_except_id, $j.getInfo('samples'), $j.getInfo('value'));
    }else{
        set_ml_except_out(ml_except_id, $j.getInfo('samples'), $j.getInfo('value'));
        $j('#ml_add_except_'+id)[0].style.display='';
        $j('#ml_add_except_'+id).append("<span><a ml_value=\""+encodeURI(value)+"\" onclick=\"MLExcept('"+ml_except_id+"' , '"+escapeHTML(name)+"');\">"+$j.getInfo("ml_except_label")+"</a></span>");
    }
}

function MLExcept(id, name, value)
{
    var ml_except = $j('#'+id)[0];
    var ml_domain_index = ml_except.getAttribute('ml_domain_index');
    var ml_arg_dbid = ml_except.getAttribute('ml_arg_dbid');
    var ml_url_dbid = ml_except.getAttribute('ml_url_dbid');

    var ml_url = "/log/display/addmlexcept";
    ml_url = qlist_url_append_arg(ml_url, "ml_domain_index", ml_domain_index);
    ml_url = qlist_url_append_arg(ml_url, "ml_arg_dbid", ml_arg_dbid);
    ml_url = qlist_url_append_arg(ml_url, "ml_url_dbid", ml_url_dbid);
    ml_url = qlist_url_append_arg(ml_url, "action", 1);
    ml_url = qlist_url_append_arg(ml_url, "name", name);
    ml_url = qlist_url_append_arg(ml_url, "value", encodeURIComponent($j('#ml_add_except_'+id.replace(/[^0-9]/ig,"")+' a')[0].getAttribute('ml_value')));

    wij_display_modal_dlg( ml_url , {'width': 550, 'height': 250});           
    
}
