(function(fweb) {
    'use strict';

    var BASE_STYLE = 'font-weight: normal; padding: 0 5px; color: #0d0d0d;';
    var LOG_STYLES = {
        info: 'background: #dbf0fe; ' + BASE_STYLE,
        warning: 'background: #fff3b2; ' + BASE_STYLE
    };

    var log = function(type, args, alwaysLog) {
        var formatted, error, fancySupport;
        var console = window.console;
        if (console && (fweb.DEBUG || alwaysLog)) {
            fancySupport = /chrom(e|ium)/.test(navigator.userAgent.toLowerCase());
            if (type === 'error' && typeof console.error === 'function') {
                console.error.apply(console, args);
            } else if (fancySupport && typeof console.groupCollapsed === 'function') {
                formatted = Array.prototype.slice.call(args).join(' ');
                console.groupCollapsed('%c ' + formatted, LOG_STYLES[type]);
                error = new Error();
                if (error.stack) {
                    console.log(error.stack.split('\n').slice(1).join('\n'));
                }
                console.groupEnd();
            } else if (typeof console.log === 'function') {
                console.log.apply(console, args);
            }
        }
    };

    /**
     * Print something to the console. Use for general info/debugging purposes. Only performed on
     * debug builds.
     *
     *
     * @param {...*} - Message arguments. See
     *   {@link https://developer.mozilla.org/en-US/docs/Web/API/Console/log}.
     * @alias fweb.log.info
     *
     */
    fweb.log = function() {
        log('info', arguments);
    };
    fweb.log.info = fweb.log;


    /**
     * Print a warning to the console. Only performed on debug builds.
     *
     * @param {...*} - Message arguments. See
     *   {@link https://developer.mozilla.org/en-US/docs/Web/API/Console/log}.
     */
    fweb.log.warn = function() {
        log('warning', arguments);
    };

    /**
     * Print an error to the console. Performed on all builds.
     *
     * @param {...*} - Message arguments. See
     *   {@link https://developer.mozilla.org/en-US/docs/Web/API/Console/error}.
     */
    fweb.log.error = function() {
        log('error', arguments, true);
    };

}(window.fweb = window.fweb || {}));
