!function(window) {
    "use strict";
    var DEFINITIONS = Object.create(null);
    window.fweb_define = function(name, dependencies, export_path, definition) {
        DEFINITIONS[name] = {dependencies: dependencies,export_path: export_path,definition: definition}
    }, window.fweb_define.DEFINITIONS = DEFINITIONS
}(window), fweb_define("jquery", [], null, function() {
    var define = void 0;
    if (function(global, factory) {
        "object" == typeof module && "object" == typeof module.exports ? module.exports = global.document ? factory(global, !0) : function(w) {
            if (!w.document)
                throw new Error("jQuery requires a window with a document");
            return factory(w)
        } : factory(global)
    }("undefined" != typeof window ? window : this, function(window, noGlobal) {
        function isArraylike(obj) {
            var length = obj.length, type = jQuery.type(obj);
            return "function" === type || jQuery.isWindow(obj) ? !1 : 1 === obj.nodeType && length ? !0 : "array" === type || 0 === length || "number" == typeof length && length > 0 && length - 1 in obj
        }
        function winnow(elements, qualifier, not) {
            if (jQuery.isFunction(qualifier))
                return jQuery.grep(elements, function(elem, i) {
                    return !!qualifier.call(elem, i, elem) !== not
                });
            if (qualifier.nodeType)
                return jQuery.grep(elements, function(elem) {
                    return elem === qualifier !== not
                });
            if ("string" == typeof qualifier) {
                if (risSimple.test(qualifier))
                    return jQuery.filter(qualifier, elements, not);
                qualifier = jQuery.filter(qualifier, elements)
            }
            return jQuery.grep(elements, function(elem) {
                return jQuery.inArray(elem, qualifier) >= 0 !== not
            })
        }
        function sibling(cur, dir) {
            do
                cur = cur[dir];
            while (cur && 1 !== cur.nodeType);
            return cur
        }
        function createOptions(options) {
            var object = optionsCache[options] = {};
            return jQuery.each(options.match(rnotwhite) || [], function(_, flag) {
                object[flag] = !0
            }), object
        }
        function detach() {
            document.addEventListener ? (document.removeEventListener("DOMContentLoaded", completed, !1), window.removeEventListener("load", completed, !1)) : (document.detachEvent("onreadystatechange", completed), window.detachEvent("onload", completed))
        }
        function completed() {
            (document.addEventListener || "load" === event.type || "complete" === document.readyState) && (detach(), jQuery.ready())
        }
        function dataAttr(elem, key, data) {
            if (void 0 === data && 1 === elem.nodeType) {
                var name = "data-" + key.replace(rmultiDash, "-$1").toLowerCase();
                if (data = elem.getAttribute(name), "string" == typeof data) {
                    try {
                        data = "true" === data ? !0 : "false" === data ? !1 : "null" === data ? null : +data + "" === data ? +data : rbrace.test(data) ? jQuery.parseJSON(data) : data
                    } catch (e) {
                    }
                    jQuery.data(elem, key, data)
                } else
                    data = void 0
            }
            return data
        }
        function isEmptyDataObject(obj) {
            var name;
            for (name in obj)
                if (("data" !== name || !jQuery.isEmptyObject(obj[name])) && "toJSON" !== name)
                    return !1;
            return !0
        }
        function internalData(elem, name, data, pvt) {
            if (jQuery.acceptData(elem)) {
                var ret, thisCache, internalKey = jQuery.expando, isNode = elem.nodeType, cache = isNode ? jQuery.cache : elem, id = isNode ? elem[internalKey] : elem[internalKey] && internalKey;
                if (id && cache[id] && (pvt || cache[id].data) || void 0 !== data || "string" != typeof name)
                    return id || (id = isNode ? elem[internalKey] = deletedIds.pop() || jQuery.guid++ : internalKey), cache[id] || (cache[id] = isNode ? {} : {toJSON: jQuery.noop}), ("object" == typeof name || "function" == typeof name) && (pvt ? cache[id] = jQuery.extend(cache[id], name) : cache[id].data = jQuery.extend(cache[id].data, name)), thisCache = cache[id], pvt || (thisCache.data || (thisCache.data = {}), thisCache = thisCache.data), void 0 !== data && (thisCache[jQuery.camelCase(name)] = data), "string" == typeof name ? (ret = thisCache[name], null == ret && (ret = thisCache[jQuery.camelCase(name)])) : ret = thisCache, ret
            }
        }
        function internalRemoveData(elem, name, pvt) {
            if (jQuery.acceptData(elem)) {
                var thisCache, i, isNode = elem.nodeType, cache = isNode ? jQuery.cache : elem, id = isNode ? elem[jQuery.expando] : jQuery.expando;
                if (cache[id]) {
                    if (name && (thisCache = pvt ? cache[id] : cache[id].data)) {
                        jQuery.isArray(name) ? name = name.concat(jQuery.map(name, jQuery.camelCase)) : name in thisCache ? name = [name] : (name = jQuery.camelCase(name), name = name in thisCache ? [name] : name.split(" ")), i = name.length;
                        for (; i--; )
                            delete thisCache[name[i]];
                        if (pvt ? !isEmptyDataObject(thisCache) : !jQuery.isEmptyObject(thisCache))
                            return
                    }
                    (pvt || (delete cache[id].data, isEmptyDataObject(cache[id]))) && (isNode ? jQuery.cleanData([elem], !0) : support.deleteExpando || cache != cache.window ? delete cache[id] : cache[id] = null)
                }
            }
        }
        function returnTrue() {
            return !0
        }
        function returnFalse() {
            return !1
        }
        function safeActiveElement() {
            try {
                return document.activeElement
            } catch (err) {
            }
        }
        function createSafeFragment(document) {
            var list = nodeNames.split("|"), safeFrag = document.createDocumentFragment();
            if (safeFrag.createElement)
                for (; list.length; )
                    safeFrag.createElement(list.pop());
            return safeFrag
        }
        function getAll(context, tag) {
            var elems, elem, i = 0, found = typeof context.getElementsByTagName !== strundefined ? context.getElementsByTagName(tag || "*") : typeof context.querySelectorAll !== strundefined ? context.querySelectorAll(tag || "*") : void 0;
            if (!found)
                for (found = [], elems = context.childNodes || context; null != (elem = elems[i]); i++)
                    !tag || jQuery.nodeName(elem, tag) ? found.push(elem) : jQuery.merge(found, getAll(elem, tag));
            return void 0 === tag || tag && jQuery.nodeName(context, tag) ? jQuery.merge([context], found) : found
        }
        function fixDefaultChecked(elem) {
            rcheckableType.test(elem.type) && (elem.defaultChecked = elem.checked)
        }
        function manipulationTarget(elem, content) {
            return jQuery.nodeName(elem, "table") && jQuery.nodeName(11 !== content.nodeType ? content : content.firstChild, "tr") ? elem.getElementsByTagName("tbody")[0] || elem.appendChild(elem.ownerDocument.createElement("tbody")) : elem
        }
        function disableScript(elem) {
            return elem.type = (null !== jQuery.find.attr(elem, "type")) + "/" + elem.type, elem
        }
        function restoreScript(elem) {
            var match = rscriptTypeMasked.exec(elem.type);
            return match ? elem.type = match[1] : elem.removeAttribute("type"), elem
        }
        function setGlobalEval(elems, refElements) {
            for (var elem, i = 0; null != (elem = elems[i]); i++)
                jQuery._data(elem, "globalEval", !refElements || jQuery._data(refElements[i], "globalEval"))
        }
        function cloneCopyEvent(src, dest) {
            if (1 === dest.nodeType && jQuery.hasData(src)) {
                var type, i, l, oldData = jQuery._data(src), curData = jQuery._data(dest, oldData), events = oldData.events;
                if (events) {
                    delete curData.handle, curData.events = {};
                    for (type in events)
                        for (i = 0, l = events[type].length; l > i; i++)
                            jQuery.event.add(dest, type, events[type][i])
                }
                curData.data && (curData.data = jQuery.extend({}, curData.data))
            }
        }
        function fixCloneNodeIssues(src, dest) {
            var nodeName, e, data;
            if (1 === dest.nodeType) {
                if (nodeName = dest.nodeName.toLowerCase(), !support.noCloneEvent && dest[jQuery.expando]) {
                    data = jQuery._data(dest);
                    for (e in data.events)
                        jQuery.removeEvent(dest, e, data.handle);
                    dest.removeAttribute(jQuery.expando)
                }
                "script" === nodeName && dest.text !== src.text ? (disableScript(dest).text = src.text, restoreScript(dest)) : "object" === nodeName ? (dest.parentNode && (dest.outerHTML = src.outerHTML), support.html5Clone && src.innerHTML && !jQuery.trim(dest.innerHTML) && (dest.innerHTML = src.innerHTML)) : "input" === nodeName && rcheckableType.test(src.type) ? (dest.defaultChecked = dest.checked = src.checked, dest.value !== src.value && (dest.value = src.value)) : "option" === nodeName ? dest.defaultSelected = dest.selected = src.defaultSelected : ("input" === nodeName || "textarea" === nodeName) && (dest.defaultValue = src.defaultValue)
            }
        }
        function actualDisplay(name, doc) {
            var style, elem = jQuery(doc.createElement(name)).appendTo(doc.body), display = window.getDefaultComputedStyle && (style = window.getDefaultComputedStyle(elem[0])) ? style.display : jQuery.css(elem[0], "display");
            return elem.detach(), display
        }
        function defaultDisplay(nodeName) {
            var doc = document, display = elemdisplay[nodeName];
            return display || (display = actualDisplay(nodeName, doc), "none" !== display && display || (iframe = (iframe || jQuery("<iframe frameborder='0' width='0' height='0'/>")).appendTo(doc.documentElement), doc = (iframe[0].contentWindow || iframe[0].contentDocument).document, doc.write(), doc.close(), display = actualDisplay(nodeName, doc), iframe.detach()), elemdisplay[nodeName] = display), display
        }
        function addGetHookIf(conditionFn, hookFn) {
            return {get: function() {
                    var condition = conditionFn();
                    if (null != condition)
                        return condition ? void delete this.get : (this.get = hookFn).apply(this, arguments)
                }}
        }
        function vendorPropName(style, name) {
            if (name in style)
                return name;
            for (var capName = name.charAt(0).toUpperCase() + name.slice(1), origName = name, i = cssPrefixes.length; i--; )
                if (name = cssPrefixes[i] + capName, name in style)
                    return name;
            return origName
        }
        function showHide(elements, show) {
            for (var display, elem, hidden, values = [], index = 0, length = elements.length; length > index; index++)
                elem = elements[index], elem.style && (values[index] = jQuery._data(elem, "olddisplay"), display = elem.style.display, show ? (values[index] || "none" !== display || (elem.style.display = ""), "" === elem.style.display && isHidden(elem) && (values[index] = jQuery._data(elem, "olddisplay", defaultDisplay(elem.nodeName)))) : (hidden = isHidden(elem), (display && "none" !== display || !hidden) && jQuery._data(elem, "olddisplay", hidden ? display : jQuery.css(elem, "display"))));
            for (index = 0; length > index; index++)
                elem = elements[index], elem.style && (show && "none" !== elem.style.display && "" !== elem.style.display || (elem.style.display = show ? values[index] || "" : "none"));
            return elements
        }
        function setPositiveNumber(elem, value, subtract) {
            var matches = rnumsplit.exec(value);
            return matches ? Math.max(0, matches[1] - (subtract || 0)) + (matches[2] || "px") : value
        }
        function augmentWidthOrHeight(elem, name, extra, isBorderBox, styles) {
            for (var i = extra === (isBorderBox ? "border" : "content") ? 4 : "width" === name ? 1 : 0, val = 0; 4 > i; i += 2)
                "margin" === extra && (val += jQuery.css(elem, extra + cssExpand[i], !0, styles)), isBorderBox ? ("content" === extra && (val -= jQuery.css(elem, "padding" + cssExpand[i], !0, styles)), "margin" !== extra && (val -= jQuery.css(elem, "border" + cssExpand[i] + "Width", !0, styles))) : (val += jQuery.css(elem, "padding" + cssExpand[i], !0, styles), "padding" !== extra && (val += jQuery.css(elem, "border" + cssExpand[i] + "Width", !0, styles)));
            return val
        }
        function getWidthOrHeight(elem, name, extra) {
            var valueIsBorderBox = !0, val = "width" === name ? elem.offsetWidth : elem.offsetHeight, styles = getStyles(elem), isBorderBox = support.boxSizing && "border-box" === jQuery.css(elem, "boxSizing", !1, styles);
            if (0 >= val || null == val) {
                if (val = curCSS(elem, name, styles), (0 > val || null == val) && (val = elem.style[name]), rnumnonpx.test(val))
                    return val;
                valueIsBorderBox = isBorderBox && (support.boxSizingReliable() || val === elem.style[name]), val = parseFloat(val) || 0
            }
            return val + augmentWidthOrHeight(elem, name, extra || (isBorderBox ? "border" : "content"), valueIsBorderBox, styles) + "px"
        }
        function Tween(elem, options, prop, end, easing) {
            return new Tween.prototype.init(elem, options, prop, end, easing)
        }
        function createFxNow() {
            return setTimeout(function() {
                fxNow = void 0
            }), fxNow = jQuery.now()
        }
        function genFx(type, includeWidth) {
            var which, attrs = {height: type}, i = 0;
            for (includeWidth = includeWidth ? 1 : 0; 4 > i; i += 2 - includeWidth)
                which = cssExpand[i], attrs["margin" + which] = attrs["padding" + which] = type;
            return includeWidth && (attrs.opacity = attrs.width = type), attrs
        }
        function createTween(value, prop, animation) {
            for (var tween, collection = (tweeners[prop] || []).concat(tweeners["*"]), index = 0, length = collection.length; length > index; index++)
                if (tween = collection[index].call(animation, prop, value))
                    return tween
        }
        function defaultPrefilter(elem, props, opts) {
            var prop, value, toggle, tween, hooks, oldfire, display, checkDisplay, anim = this, orig = {}, style = elem.style, hidden = elem.nodeType && isHidden(elem), dataShow = jQuery._data(elem, "fxshow");
            opts.queue || (hooks = jQuery._queueHooks(elem, "fx"), null == hooks.unqueued && (hooks.unqueued = 0, oldfire = hooks.empty.fire, hooks.empty.fire = function() {
                hooks.unqueued || oldfire()
            }), hooks.unqueued++, anim.always(function() {
                anim.always(function() {
                    hooks.unqueued--, jQuery.queue(elem, "fx").length || hooks.empty.fire()
                })
            })), 1 === elem.nodeType && ("height" in props || "width" in props) && (opts.overflow = [style.overflow, style.overflowX, style.overflowY], display = jQuery.css(elem, "display"), checkDisplay = "none" === display ? jQuery._data(elem, "olddisplay") || defaultDisplay(elem.nodeName) : display, "inline" === checkDisplay && "none" === jQuery.css(elem, "float") && (support.inlineBlockNeedsLayout && "inline" !== defaultDisplay(elem.nodeName) ? style.zoom = 1 : style.display = "inline-block")), opts.overflow && (style.overflow = "hidden", support.shrinkWrapBlocks() || anim.always(function() {
                style.overflow = opts.overflow[0], style.overflowX = opts.overflow[1], style.overflowY = opts.overflow[2]
            }));
            for (prop in props)
                if (value = props[prop], rfxtypes.exec(value)) {
                    if (delete props[prop], toggle = toggle || "toggle" === value, value === (hidden ? "hide" : "show")) {
                        if ("show" !== value || !dataShow || void 0 === dataShow[prop])
                            continue;
                        hidden = !0
                    }
                    orig[prop] = dataShow && dataShow[prop] || jQuery.style(elem, prop)
                } else
                    display = void 0;
            if (jQuery.isEmptyObject(orig))
                "inline" === ("none" === display ? defaultDisplay(elem.nodeName) : display) && (style.display = display);
            else {
                dataShow ? "hidden" in dataShow && (hidden = dataShow.hidden) : dataShow = jQuery._data(elem, "fxshow", {}), toggle && (dataShow.hidden = !hidden), hidden ? jQuery(elem).show() : anim.done(function() {
                    jQuery(elem).hide()
                }), anim.done(function() {
                    var prop;
                    jQuery._removeData(elem, "fxshow");
                    for (prop in orig)
                        jQuery.style(elem, prop, orig[prop])
                });
                for (prop in orig)
                    tween = createTween(hidden ? dataShow[prop] : 0, prop, anim), prop in dataShow || (dataShow[prop] = tween.start, hidden && (tween.end = tween.start, tween.start = "width" === prop || "height" === prop ? 1 : 0))
            }
        }
        function propFilter(props, specialEasing) {
            var index, name, easing, value, hooks;
            for (index in props)
                if (name = jQuery.camelCase(index), easing = specialEasing[name], value = props[index], jQuery.isArray(value) && (easing = value[1], value = props[index] = value[0]), index !== name && (props[name] = value, delete props[index]), hooks = jQuery.cssHooks[name], hooks && "expand" in hooks) {
                    value = hooks.expand(value), delete props[name];
                    for (index in value)
                        index in props || (props[index] = value[index], specialEasing[index] = easing)
                } else
                    specialEasing[name] = easing
        }
        function Animation(elem, properties, options) {
            var result, stopped, index = 0, length = animationPrefilters.length, deferred = jQuery.Deferred().always(function() {
                delete tick.elem
            }), tick = function() {
                if (stopped)
                    return !1;
                for (var currentTime = fxNow || createFxNow(), remaining = Math.max(0, animation.startTime + animation.duration - currentTime), temp = remaining / animation.duration || 0, percent = 1 - temp, index = 0, length = animation.tweens.length; length > index; index++)
                    animation.tweens[index].run(percent);
                return deferred.notifyWith(elem, [animation, percent, remaining]), 1 > percent && length ? remaining : (deferred.resolveWith(elem, [animation]), !1)
            }, animation = deferred.promise({elem: elem,props: jQuery.extend({}, properties),opts: jQuery.extend(!0, {specialEasing: {}}, options),originalProperties: properties,originalOptions: options,startTime: fxNow || createFxNow(),duration: options.duration,tweens: [],createTween: function(prop, end) {
                    var tween = jQuery.Tween(elem, animation.opts, prop, end, animation.opts.specialEasing[prop] || animation.opts.easing);
                    return animation.tweens.push(tween), tween
                },stop: function(gotoEnd) {
                    var index = 0, length = gotoEnd ? animation.tweens.length : 0;
                    if (stopped)
                        return this;
                    for (stopped = !0; length > index; index++)
                        animation.tweens[index].run(1);
                    return gotoEnd ? deferred.resolveWith(elem, [animation, gotoEnd]) : deferred.rejectWith(elem, [animation, gotoEnd]), this
                }}), props = animation.props;
            for (propFilter(props, animation.opts.specialEasing); length > index; index++)
                if (result = animationPrefilters[index].call(animation, elem, props, animation.opts))
                    return result;
            return jQuery.map(props, createTween, animation), jQuery.isFunction(animation.opts.start) && animation.opts.start.call(elem, animation), jQuery.fx.timer(jQuery.extend(tick, {elem: elem,anim: animation,queue: animation.opts.queue})), animation.progress(animation.opts.progress).done(animation.opts.done, animation.opts.complete).fail(animation.opts.fail).always(animation.opts.always)
        }
        function addToPrefiltersOrTransports(structure) {
            return function(dataTypeExpression, func) {
                "string" != typeof dataTypeExpression && (func = dataTypeExpression, dataTypeExpression = "*");
                var dataType, i = 0, dataTypes = dataTypeExpression.toLowerCase().match(rnotwhite) || [];
                if (jQuery.isFunction(func))
                    for (; dataType = dataTypes[i++]; )
                        "+" === dataType.charAt(0) ? (dataType = dataType.slice(1) || "*", (structure[dataType] = structure[dataType] || []).unshift(func)) : (structure[dataType] = structure[dataType] || []).push(func)
            }
        }
        function inspectPrefiltersOrTransports(structure, options, originalOptions, jqXHR) {
            function inspect(dataType) {
                var selected;
                return inspected[dataType] = !0, jQuery.each(structure[dataType] || [], function(_, prefilterOrFactory) {
                    var dataTypeOrTransport = prefilterOrFactory(options, originalOptions, jqXHR);
                    return "string" != typeof dataTypeOrTransport || seekingTransport || inspected[dataTypeOrTransport] ? seekingTransport ? !(selected = dataTypeOrTransport) : void 0 : (options.dataTypes.unshift(dataTypeOrTransport), inspect(dataTypeOrTransport), !1)
                }), selected
            }
            var inspected = {}, seekingTransport = structure === transports;
            return inspect(options.dataTypes[0]) || !inspected["*"] && inspect("*")
        }
        function ajaxExtend(target, src) {
            var deep, key, flatOptions = jQuery.ajaxSettings.flatOptions || {};
            for (key in src)
                void 0 !== src[key] && ((flatOptions[key] ? target : deep || (deep = {}))[key] = src[key]);
            return deep && jQuery.extend(!0, target, deep), target
        }
        function ajaxHandleResponses(s, jqXHR, responses) {
            for (var firstDataType, ct, finalDataType, type, contents = s.contents, dataTypes = s.dataTypes; "*" === dataTypes[0]; )
                dataTypes.shift(), void 0 === ct && (ct = s.mimeType || jqXHR.getResponseHeader("Content-Type"));
            if (ct)
                for (type in contents)
                    if (contents[type] && contents[type].test(ct)) {
                        dataTypes.unshift(type);
                        break
                    }
            if (dataTypes[0] in responses)
                finalDataType = dataTypes[0];
            else {
                for (type in responses) {
                    if (!dataTypes[0] || s.converters[type + " " + dataTypes[0]]) {
                        finalDataType = type;
                        break
                    }
                    firstDataType || (firstDataType = type)
                }
                finalDataType = finalDataType || firstDataType
            }
            return finalDataType ? (finalDataType !== dataTypes[0] && dataTypes.unshift(finalDataType), responses[finalDataType]) : void 0
        }
        function ajaxConvert(s, response, jqXHR, isSuccess) {
            var conv2, current, conv, tmp, prev, converters = {}, dataTypes = s.dataTypes.slice();
            if (dataTypes[1])
                for (conv in s.converters)
                    converters[conv.toLowerCase()] = s.converters[conv];
            for (current = dataTypes.shift(); current; )
                if (s.responseFields[current] && (jqXHR[s.responseFields[current]] = response), !prev && isSuccess && s.dataFilter && (response = s.dataFilter(response, s.dataType)), prev = current, current = dataTypes.shift())
                    if ("*" === current)
                        current = prev;
                    else if ("*" !== prev && prev !== current) {
                        if (conv = converters[prev + " " + current] || converters["* " + current], !conv)
                            for (conv2 in converters)
                                if (tmp = conv2.split(" "), tmp[1] === current && (conv = converters[prev + " " + tmp[0]] || converters["* " + tmp[0]])) {
                                    conv === !0 ? conv = converters[conv2] : converters[conv2] !== !0 && (current = tmp[0], dataTypes.unshift(tmp[1]));
                                    break
                                }
                        if (conv !== !0)
                            if (conv && s["throws"])
                                response = conv(response);
                            else
                                try {
                                    response = conv(response)
                                } catch (e) {
                                    return {state: "parsererror",error: conv ? e : "No conversion from " + prev + " to " + current}
                                }
                    }
            return {state: "success",data: response}
        }
        function buildParams(prefix, obj, traditional, add) {
            var name;
            if (jQuery.isArray(obj))
                jQuery.each(obj, function(i, v) {
                    traditional || rbracket.test(prefix) ? add(prefix, v) : buildParams(prefix + "[" + ("object" == typeof v ? i : "") + "]", v, traditional, add)
                });
            else if (traditional || "object" !== jQuery.type(obj))
                add(prefix, obj);
            else
                for (name in obj)
                    buildParams(prefix + "[" + name + "]", obj[name], traditional, add)
        }
        function createStandardXHR() {
            try {
                return new window.XMLHttpRequest
            } catch (e) {
            }
        }
        function createActiveXHR() {
            try {
                return new window.ActiveXObject("Microsoft.XMLHTTP")
            } catch (e) {
            }
        }
        function getWindow(elem) {
            return jQuery.isWindow(elem) ? elem : 9 === elem.nodeType ? elem.defaultView || elem.parentWindow : !1
        }
        var deletedIds = [], slice = deletedIds.slice, concat = deletedIds.concat, push = deletedIds.push, indexOf = deletedIds.indexOf, class2type = {}, toString = class2type.toString, hasOwn = class2type.hasOwnProperty, support = {}, version = "1.11.1", jQuery = function(selector, context) {
            return new jQuery.fn.init(selector, context)
        }, rtrim = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g, rmsPrefix = /^-ms-/, rdashAlpha = /-([\da-z])/gi, fcamelCase = function(all, letter) {
            return letter.toUpperCase()
        };
        jQuery.fn = jQuery.prototype = {jquery: version,constructor: jQuery,selector: "",length: 0,toArray: function() {
                return slice.call(this)
            },get: function(num) {
                return null != num ? 0 > num ? this[num + this.length] : this[num] : slice.call(this)
            },pushStack: function(elems) {
                var ret = jQuery.merge(this.constructor(), elems);
                return ret.prevObject = this, ret.context = this.context, ret
            },each: function(callback, args) {
                return jQuery.each(this, callback, args)
            },map: function(callback) {
                return this.pushStack(jQuery.map(this, function(elem, i) {
                    return callback.call(elem, i, elem)
                }))
            },slice: function() {
                return this.pushStack(slice.apply(this, arguments))
            },first: function() {
                return this.eq(0)
            },last: function() {
                return this.eq(-1)
            },eq: function(i) {
                var len = this.length, j = +i + (0 > i ? len : 0);
                return this.pushStack(j >= 0 && len > j ? [this[j]] : [])
            },end: function() {
                return this.prevObject || this.constructor(null)
            },push: push,sort: deletedIds.sort,splice: deletedIds.splice}, jQuery.extend = jQuery.fn.extend = function() {
            var src, copyIsArray, copy, name, options, clone, target = arguments[0] || {}, i = 1, length = arguments.length, deep = !1;
            for ("boolean" == typeof target && (deep = target, target = arguments[i] || {}, i++), "object" == typeof target || jQuery.isFunction(target) || (target = {}), i === length && (target = this, i--); length > i; i++)
                if (null != (options = arguments[i]))
                    for (name in options)
                        src = target[name], copy = options[name], target !== copy && (deep && copy && (jQuery.isPlainObject(copy) || (copyIsArray = jQuery.isArray(copy))) ? (copyIsArray ? (copyIsArray = !1, clone = src && jQuery.isArray(src) ? src : []) : clone = src && jQuery.isPlainObject(src) ? src : {}, target[name] = jQuery.extend(deep, clone, copy)) : void 0 !== copy && (target[name] = copy));
            return target
        }, jQuery.extend({expando: "jQuery" + (version + Math.random()).replace(/\D/g, ""),isReady: !0,error: function(msg) {
                throw new Error(msg)
            },noop: function() {
            },isFunction: function(obj) {
                return "function" === jQuery.type(obj)
            },isArray: Array.isArray || function(obj) {
                return "array" === jQuery.type(obj)
            },isWindow: function(obj) {
                return null != obj && obj == obj.window
            },isNumeric: function(obj) {
                return !jQuery.isArray(obj) && obj - parseFloat(obj) >= 0
            },isEmptyObject: function(obj) {
                var name;
                for (name in obj)
                    return !1;
                return !0
            },isPlainObject: function(obj) {
                var key;
                if (!obj || "object" !== jQuery.type(obj) || obj.nodeType || jQuery.isWindow(obj))
                    return !1;
                try {
                    if (obj.constructor && !hasOwn.call(obj, "constructor") && !hasOwn.call(obj.constructor.prototype, "isPrototypeOf"))
                        return !1
                } catch (e) {
                    return !1
                }
                if (support.ownLast)
                    for (key in obj)
                        return hasOwn.call(obj, key);
                for (key in obj)
                    ;
                return void 0 === key || hasOwn.call(obj, key)
            },type: function(obj) {
                return null == obj ? obj + "" : "object" == typeof obj || "function" == typeof obj ? class2type[toString.call(obj)] || "object" : typeof obj
            },globalEval: function(data) {
                data && jQuery.trim(data) && (window.execScript || function(data) {
                    window.eval.call(window, data)
                })(data)
            },camelCase: function(string) {
                return string.replace(rmsPrefix, "ms-").replace(rdashAlpha, fcamelCase)
            },nodeName: function(elem, name) {
                return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase()
            },each: function(obj, callback, args) {
                var value, i = 0, length = obj.length, isArray = isArraylike(obj);
                if (args) {
                    if (isArray)
                        for (; length > i && (value = callback.apply(obj[i], args), value !== !1); i++)
                            ;
                    else
                        for (i in obj)
                            if (value = callback.apply(obj[i], args), value === !1)
                                break
                } else if (isArray)
                    for (; length > i && (value = callback.call(obj[i], i, obj[i]), value !== !1); i++)
                        ;
                else
                    for (i in obj)
                        if (value = callback.call(obj[i], i, obj[i]), value === !1)
                            break;
                return obj
            },trim: function(text) {
                return null == text ? "" : (text + "").replace(rtrim, "")
            },makeArray: function(arr, results) {
                var ret = results || [];
                return null != arr && (isArraylike(Object(arr)) ? jQuery.merge(ret, "string" == typeof arr ? [arr] : arr) : push.call(ret, arr)), ret
            },inArray: function(elem, arr, i) {
                var len;
                if (arr) {
                    if (indexOf)
                        return indexOf.call(arr, elem, i);
                    for (len = arr.length, i = i ? 0 > i ? Math.max(0, len + i) : i : 0; len > i; i++)
                        if (i in arr && arr[i] === elem)
                            return i
                }
                return -1
            },merge: function(first, second) {
                for (var len = +second.length, j = 0, i = first.length; len > j; )
                    first[i++] = second[j++];
                if (len !== len)
                    for (; void 0 !== second[j]; )
                        first[i++] = second[j++];
                return first.length = i, first
            },grep: function(elems, callback, invert) {
                for (var callbackInverse, matches = [], i = 0, length = elems.length, callbackExpect = !invert; length > i; i++)
                    callbackInverse = !callback(elems[i], i), callbackInverse !== callbackExpect && matches.push(elems[i]);
                return matches
            },map: function(elems, callback, arg) {
                var value, i = 0, length = elems.length, isArray = isArraylike(elems), ret = [];
                if (isArray)
                    for (; length > i; i++)
                        value = callback(elems[i], i, arg), null != value && ret.push(value);
                else
                    for (i in elems)
                        value = callback(elems[i], i, arg), null != value && ret.push(value);
                return concat.apply([], ret)
            },guid: 1,proxy: function(fn, context) {
                var args, proxy, tmp;
                return "string" == typeof context && (tmp = fn[context], context = fn, fn = tmp), jQuery.isFunction(fn) ? (args = slice.call(arguments, 2), proxy = function() {
                    return fn.apply(context || this, args.concat(slice.call(arguments)))
                }, proxy.guid = fn.guid = fn.guid || jQuery.guid++, proxy) : void 0
            },now: function() {
                return +new Date
            },support: support}), jQuery.each("Boolean Number String Function Array Date RegExp Object Error".split(" "), function(i, name) {
            class2type["[object " + name + "]"] = name.toLowerCase()
        });
        var Sizzle = function(window) {
            function Sizzle(selector, context, results, seed) {
                var match, elem, m, nodeType, i, groups, old, nid, newContext, newSelector;
                if ((context ? context.ownerDocument || context : preferredDoc) !== document && setDocument(context), context = context || document, results = results || [], !selector || "string" != typeof selector)
                    return results;
                if (1 !== (nodeType = context.nodeType) && 9 !== nodeType)
                    return [];
                if (documentIsHTML && !seed) {
                    if (match = rquickExpr.exec(selector))
                        if (m = match[1]) {
                            if (9 === nodeType) {
                                if (elem = context.getElementById(m), !elem || !elem.parentNode)
                                    return results;
                                if (elem.id === m)
                                    return results.push(elem), results
                            } else if (context.ownerDocument && (elem = context.ownerDocument.getElementById(m)) && contains(context, elem) && elem.id === m)
                                return results.push(elem), results
                        } else {
                            if (match[2])
                                return push.apply(results, context.getElementsByTagName(selector)), results;
                            if ((m = match[3]) && support.getElementsByClassName && context.getElementsByClassName)
                                return push.apply(results, context.getElementsByClassName(m)), results
                        }
                    if (support.qsa && (!rbuggyQSA || !rbuggyQSA.test(selector))) {
                        if (nid = old = expando, newContext = context, newSelector = 9 === nodeType && selector, 1 === nodeType && "object" !== context.nodeName.toLowerCase()) {
                            for (groups = tokenize(selector), (old = context.getAttribute("id")) ? nid = old.replace(rescape, "\\$&") : context.setAttribute("id", nid), nid = "[id='" + nid + "'] ", i = groups.length; i--; )
                                groups[i] = nid + toSelector(groups[i]);
                            newContext = rsibling.test(selector) && testContext(context.parentNode) || context, newSelector = groups.join(",")
                        }
                        if (newSelector)
                            try {
                                return push.apply(results, newContext.querySelectorAll(newSelector)), results
                            } catch (qsaError) {
                            }finally {
                                old || context.removeAttribute("id")
                            }
                    }
                }
                return select(selector.replace(rtrim, "$1"), context, results, seed)
            }
            function createCache() {
                function cache(key, value) {
                    return keys.push(key + " ") > Expr.cacheLength && delete cache[keys.shift()], cache[key + " "] = value
                }
                var keys = [];
                return cache
            }
            function markFunction(fn) {
                return fn[expando] = !0, fn
            }
            function assert(fn) {
                var div = document.createElement("div");
                try {
                    return !!fn(div)
                } catch (e) {
                    return !1
                }finally {
                    div.parentNode && div.parentNode.removeChild(div), div = null
                }
            }
            function addHandle(attrs, handler) {
                for (var arr = attrs.split("|"), i = attrs.length; i--; )
                    Expr.attrHandle[arr[i]] = handler
            }
            function siblingCheck(a, b) {
                var cur = b && a, diff = cur && 1 === a.nodeType && 1 === b.nodeType && (~b.sourceIndex || MAX_NEGATIVE) - (~a.sourceIndex || MAX_NEGATIVE);
                if (diff)
                    return diff;
                if (cur)
                    for (; cur = cur.nextSibling; )
                        if (cur === b)
                            return -1;
                return a ? 1 : -1
            }
            function createInputPseudo(type) {
                return function(elem) {
                    var name = elem.nodeName.toLowerCase();
                    return "input" === name && elem.type === type
                }
            }
            function createButtonPseudo(type) {
                return function(elem) {
                    var name = elem.nodeName.toLowerCase();
                    return ("input" === name || "button" === name) && elem.type === type
                }
            }
            function createPositionalPseudo(fn) {
                return markFunction(function(argument) {
                    return argument = +argument, markFunction(function(seed, matches) {
                        for (var j, matchIndexes = fn([], seed.length, argument), i = matchIndexes.length; i--; )
                            seed[j = matchIndexes[i]] && (seed[j] = !(matches[j] = seed[j]))
                    })
                })
            }
            function testContext(context) {
                return context && typeof context.getElementsByTagName !== strundefined && context
            }
            function setFilters() {
            }
            function toSelector(tokens) {
                for (var i = 0, len = tokens.length, selector = ""; len > i; i++)
                    selector += tokens[i].value;
                return selector
            }
            function addCombinator(matcher, combinator, base) {
                var dir = combinator.dir, checkNonElements = base && "parentNode" === dir, doneName = done++;
                return combinator.first ? function(elem, context, xml) {
                    for (; elem = elem[dir]; )
                        if (1 === elem.nodeType || checkNonElements)
                            return matcher(elem, context, xml)
                } : function(elem, context, xml) {
                    var oldCache, outerCache, newCache = [dirruns, doneName];
                    if (xml) {
                        for (; elem = elem[dir]; )
                            if ((1 === elem.nodeType || checkNonElements) && matcher(elem, context, xml))
                                return !0
                    } else
                        for (; elem = elem[dir]; )
                            if (1 === elem.nodeType || checkNonElements) {
                                if (outerCache = elem[expando] || (elem[expando] = {}), (oldCache = outerCache[dir]) && oldCache[0] === dirruns && oldCache[1] === doneName)
                                    return newCache[2] = oldCache[2];
                                if (outerCache[dir] = newCache, newCache[2] = matcher(elem, context, xml))
                                    return !0
                            }
                }
            }
            function elementMatcher(matchers) {
                return matchers.length > 1 ? function(elem, context, xml) {
                    for (var i = matchers.length; i--; )
                        if (!matchers[i](elem, context, xml))
                            return !1;
                    return !0
                } : matchers[0]
            }
            function multipleContexts(selector, contexts, results) {
                for (var i = 0, len = contexts.length; len > i; i++)
                    Sizzle(selector, contexts[i], results);
                return results
            }
            function condense(unmatched, map, filter, context, xml) {
                for (var elem, newUnmatched = [], i = 0, len = unmatched.length, mapped = null != map; len > i; i++)
                    (elem = unmatched[i]) && (!filter || filter(elem, context, xml)) && (newUnmatched.push(elem), mapped && map.push(i));
                return newUnmatched
            }
            function setMatcher(preFilter, selector, matcher, postFilter, postFinder, postSelector) {
                return postFilter && !postFilter[expando] && (postFilter = setMatcher(postFilter)), postFinder && !postFinder[expando] && (postFinder = setMatcher(postFinder, postSelector)), markFunction(function(seed, results, context, xml) {
                    var temp, i, elem, preMap = [], postMap = [], preexisting = results.length, elems = seed || multipleContexts(selector || "*", context.nodeType ? [context] : context, []), matcherIn = !preFilter || !seed && selector ? elems : condense(elems, preMap, preFilter, context, xml), matcherOut = matcher ? postFinder || (seed ? preFilter : preexisting || postFilter) ? [] : results : matcherIn;
                    if (matcher && matcher(matcherIn, matcherOut, context, xml), postFilter)
                        for (temp = condense(matcherOut, postMap), postFilter(temp, [], context, xml), i = temp.length; i--; )
                            (elem = temp[i]) && (matcherOut[postMap[i]] = !(matcherIn[postMap[i]] = elem));
                    if (seed) {
                        if (postFinder || preFilter) {
                            if (postFinder) {
                                for (temp = [], i = matcherOut.length; i--; )
                                    (elem = matcherOut[i]) && temp.push(matcherIn[i] = elem);
                                postFinder(null, matcherOut = [], temp, xml)
                            }
                            for (i = matcherOut.length; i--; )
                                (elem = matcherOut[i]) && (temp = postFinder ? indexOf.call(seed, elem) : preMap[i]) > -1 && (seed[temp] = !(results[temp] = elem))
                        }
                    } else
                        matcherOut = condense(matcherOut === results ? matcherOut.splice(preexisting, matcherOut.length) : matcherOut), postFinder ? postFinder(null, results, matcherOut, xml) : push.apply(results, matcherOut)
                })
            }
            function matcherFromTokens(tokens) {
                for (var checkContext, matcher, j, len = tokens.length, leadingRelative = Expr.relative[tokens[0].type], implicitRelative = leadingRelative || Expr.relative[" "], i = leadingRelative ? 1 : 0, matchContext = addCombinator(function(elem) {
                    return elem === checkContext
                }, implicitRelative, !0), matchAnyContext = addCombinator(function(elem) {
                    return indexOf.call(checkContext, elem) > -1
                }, implicitRelative, !0), matchers = [function(elem, context, xml) {
                        return !leadingRelative && (xml || context !== outermostContext) || ((checkContext = context).nodeType ? matchContext(elem, context, xml) : matchAnyContext(elem, context, xml))
                    }]; len > i; i++)
                    if (matcher = Expr.relative[tokens[i].type])
                        matchers = [addCombinator(elementMatcher(matchers), matcher)];
                    else {
                        if (matcher = Expr.filter[tokens[i].type].apply(null, tokens[i].matches), matcher[expando]) {
                            for (j = ++i; len > j && !Expr.relative[tokens[j].type]; j++)
                                ;
                            return setMatcher(i > 1 && elementMatcher(matchers), i > 1 && toSelector(tokens.slice(0, i - 1).concat({value: " " === tokens[i - 2].type ? "*" : ""})).replace(rtrim, "$1"), matcher, j > i && matcherFromTokens(tokens.slice(i, j)), len > j && matcherFromTokens(tokens = tokens.slice(j)), len > j && toSelector(tokens))
                        }
                        matchers.push(matcher)
                    }
                return elementMatcher(matchers)
            }
            function matcherFromGroupMatchers(elementMatchers, setMatchers) {
                var bySet = setMatchers.length > 0, byElement = elementMatchers.length > 0, superMatcher = function(seed, context, xml, results, outermost) {
                    var elem, j, matcher, matchedCount = 0, i = "0", unmatched = seed && [], setMatched = [], contextBackup = outermostContext, elems = seed || byElement && Expr.find.TAG("*", outermost), dirrunsUnique = dirruns += null == contextBackup ? 1 : Math.random() || .1, len = elems.length;
                    for (outermost && (outermostContext = context !== document && context); i !== len && null != (elem = elems[i]); i++) {
                        if (byElement && elem) {
                            for (j = 0; matcher = elementMatchers[j++]; )
                                if (matcher(elem, context, xml)) {
                                    results.push(elem);
                                    break
                                }
                            outermost && (dirruns = dirrunsUnique)
                        }
                        bySet && ((elem = !matcher && elem) && matchedCount--, seed && unmatched.push(elem))
                    }
                    if (matchedCount += i, bySet && i !== matchedCount) {
                        for (j = 0; matcher = setMatchers[j++]; )
                            matcher(unmatched, setMatched, context, xml);
                        if (seed) {
                            if (matchedCount > 0)
                                for (; i--; )
                                    unmatched[i] || setMatched[i] || (setMatched[i] = pop.call(results));
                            setMatched = condense(setMatched)
                        }
                        push.apply(results, setMatched), outermost && !seed && setMatched.length > 0 && matchedCount + setMatchers.length > 1 && Sizzle.uniqueSort(results)
                    }
                    return outermost && (dirruns = dirrunsUnique, outermostContext = contextBackup), unmatched
                };
                return bySet ? markFunction(superMatcher) : superMatcher
            }
            var i, support, Expr, getText, isXML, tokenize, compile, select, outermostContext, sortInput, hasDuplicate, setDocument, document, docElem, documentIsHTML, rbuggyQSA, rbuggyMatches, matches, contains, expando = "sizzle" + -new Date, preferredDoc = window.document, dirruns = 0, done = 0, classCache = createCache(), tokenCache = createCache(), compilerCache = createCache(), sortOrder = function(a, b) {
                return a === b && (hasDuplicate = !0), 0
            }, strundefined = "undefined", MAX_NEGATIVE = 1 << 31, hasOwn = {}.hasOwnProperty, arr = [], pop = arr.pop, push_native = arr.push, push = arr.push, slice = arr.slice, indexOf = arr.indexOf || function(elem) {
                for (var i = 0, len = this.length; len > i; i++)
                    if (this[i] === elem)
                        return i;
                return -1
            }, booleans = "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped", whitespace = "[\\x20\\t\\r\\n\\f]", characterEncoding = "(?:\\\\.|[\\w-]|[^\\x00-\\xa0])+", identifier = characterEncoding.replace("w", "w#"), attributes = "\\[" + whitespace + "*(" + characterEncoding + ")(?:" + whitespace + "*([*^$|!~]?=)" + whitespace + "*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|(" + identifier + "))|)" + whitespace + "*\\]", pseudos = ":(" + characterEncoding + ")(?:\\((('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|((?:\\\\.|[^\\\\()[\\]]|" + attributes + ")*)|.*)\\)|)", rtrim = new RegExp("^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" + whitespace + "+$", "g"), rcomma = new RegExp("^" + whitespace + "*," + whitespace + "*"), rcombinators = new RegExp("^" + whitespace + "*([>+~]|" + whitespace + ")" + whitespace + "*"), rattributeQuotes = new RegExp("=" + whitespace + "*([^\\]'\"]*?)" + whitespace + "*\\]", "g"), rpseudo = new RegExp(pseudos), ridentifier = new RegExp("^" + identifier + "$"), matchExpr = {ID: new RegExp("^#(" + characterEncoding + ")"),CLASS: new RegExp("^\\.(" + characterEncoding + ")"),TAG: new RegExp("^(" + characterEncoding.replace("w", "w*") + ")"),ATTR: new RegExp("^" + attributes),PSEUDO: new RegExp("^" + pseudos),CHILD: new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" + whitespace + "*(even|odd|(([+-]|)(\\d*)n|)" + whitespace + "*(?:([+-]|)" + whitespace + "*(\\d+)|))" + whitespace + "*\\)|)", "i"),bool: new RegExp("^(?:" + booleans + ")$", "i"),needsContext: new RegExp("^" + whitespace + "*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" + whitespace + "*((?:-\\d)?\\d*)" + whitespace + "*\\)|)(?=[^-]|$)", "i")}, rinputs = /^(?:input|select|textarea|button)$/i, rheader = /^h\d$/i, rnative = /^[^{]+\{\s*\[native \w/, rquickExpr = /^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/, rsibling = /[+~]/, rescape = /'|\\/g, runescape = new RegExp("\\\\([\\da-f]{1,6}" + whitespace + "?|(" + whitespace + ")|.)", "ig"), funescape = function(_, escaped, escapedWhitespace) {
                var high = "0x" + escaped - 65536;
                return high !== high || escapedWhitespace ? escaped : 0 > high ? String.fromCharCode(high + 65536) : String.fromCharCode(high >> 10 | 55296, 1023 & high | 56320)
            };
            try {
                push.apply(arr = slice.call(preferredDoc.childNodes), preferredDoc.childNodes), arr[preferredDoc.childNodes.length].nodeType
            } catch (e) {
                push = {apply: arr.length ? function(target, els) {
                        push_native.apply(target, slice.call(els))
                    } : function(target, els) {
                        for (var j = target.length, i = 0; target[j++] = els[i++]; )
                            ;
                        target.length = j - 1
                    }}
            }
            support = Sizzle.support = {}, isXML = Sizzle.isXML = function(elem) {
                var documentElement = elem && (elem.ownerDocument || elem).documentElement;
                return documentElement ? "HTML" !== documentElement.nodeName : !1
            }, setDocument = Sizzle.setDocument = function(node) {
                var hasCompare, doc = node ? node.ownerDocument || node : preferredDoc, parent = doc.defaultView;
                return doc !== document && 9 === doc.nodeType && doc.documentElement ? (document = doc, docElem = doc.documentElement, documentIsHTML = !isXML(doc), parent && parent !== parent.top && (parent.addEventListener ? parent.addEventListener("unload", function() {
                    setDocument()
                }, !1) : parent.attachEvent && parent.attachEvent("onunload", function() {
                    setDocument()
                })), support.attributes = assert(function(div) {
                    return div.className = "i", !div.getAttribute("className")
                }), support.getElementsByTagName = assert(function(div) {
                    return div.appendChild(doc.createComment("")), !div.getElementsByTagName("*").length
                }), support.getElementsByClassName = rnative.test(doc.getElementsByClassName) && assert(function(div) {
                    return div.innerHTML = "<div class='a'></div><div class='a i'></div>", div.firstChild.className = "i", 2 === div.getElementsByClassName("i").length
                }), support.getById = assert(function(div) {
                    return docElem.appendChild(div).id = expando, !doc.getElementsByName || !doc.getElementsByName(expando).length
                }), support.getById ? (Expr.find.ID = function(id, context) {
                    if (typeof context.getElementById !== strundefined && documentIsHTML) {
                        var m = context.getElementById(id);
                        return m && m.parentNode ? [m] : []
                    }
                }, Expr.filter.ID = function(id) {
                    var attrId = id.replace(runescape, funescape);
                    return function(elem) {
                        return elem.getAttribute("id") === attrId
                    }
                }) : (delete Expr.find.ID, Expr.filter.ID = function(id) {
                    var attrId = id.replace(runescape, funescape);
                    return function(elem) {
                        var node = typeof elem.getAttributeNode !== strundefined && elem.getAttributeNode("id");
                        return node && node.value === attrId
                    }
                }), Expr.find.TAG = support.getElementsByTagName ? function(tag, context) {
                    return typeof context.getElementsByTagName !== strundefined ? context.getElementsByTagName(tag) : void 0
                } : function(tag, context) {
                    var elem, tmp = [], i = 0, results = context.getElementsByTagName(tag);
                    if ("*" === tag) {
                        for (; elem = results[i++]; )
                            1 === elem.nodeType && tmp.push(elem);
                        return tmp
                    }
                    return results
                }, Expr.find.CLASS = support.getElementsByClassName && function(className, context) {
                    return typeof context.getElementsByClassName !== strundefined && documentIsHTML ? context.getElementsByClassName(className) : void 0
                }, rbuggyMatches = [], rbuggyQSA = [], (support.qsa = rnative.test(doc.querySelectorAll)) && (assert(function(div) {
                    div.innerHTML = "<select msallowclip=''><option selected=''></option></select>", div.querySelectorAll("[msallowclip^='']").length && rbuggyQSA.push("[*^$]=" + whitespace + "*(?:''|\"\")"), div.querySelectorAll("[selected]").length || rbuggyQSA.push("\\[" + whitespace + "*(?:value|" + booleans + ")"), div.querySelectorAll(":checked").length || rbuggyQSA.push(":checked")
                }), assert(function(div) {
                    var input = doc.createElement("input");
                    input.setAttribute("type", "hidden"), div.appendChild(input).setAttribute("name", "D"), div.querySelectorAll("[name=d]").length && rbuggyQSA.push("name" + whitespace + "*[*^$|!~]?="), div.querySelectorAll(":enabled").length || rbuggyQSA.push(":enabled", ":disabled"), div.querySelectorAll("*,:x"), rbuggyQSA.push(",.*:")
                })), (support.matchesSelector = rnative.test(matches = docElem.matches || docElem.webkitMatchesSelector || docElem.mozMatchesSelector || docElem.oMatchesSelector || docElem.msMatchesSelector)) && assert(function(div) {
                    support.disconnectedMatch = matches.call(div, "div"), matches.call(div, "[s!='']:x"), rbuggyMatches.push("!=", pseudos)
                }), rbuggyQSA = rbuggyQSA.length && new RegExp(rbuggyQSA.join("|")), rbuggyMatches = rbuggyMatches.length && new RegExp(rbuggyMatches.join("|")), hasCompare = rnative.test(docElem.compareDocumentPosition), contains = hasCompare || rnative.test(docElem.contains) ? function(a, b) {
                    var adown = 9 === a.nodeType ? a.documentElement : a, bup = b && b.parentNode;
                    return a === bup || !(!bup || 1 !== bup.nodeType || !(adown.contains ? adown.contains(bup) : a.compareDocumentPosition && 16 & a.compareDocumentPosition(bup)))
                } : function(a, b) {
                    if (b)
                        for (; b = b.parentNode; )
                            if (b === a)
                                return !0;
                    return !1
                }, sortOrder = hasCompare ? function(a, b) {
                    if (a === b)
                        return hasDuplicate = !0, 0;
                    var compare = !a.compareDocumentPosition - !b.compareDocumentPosition;
                    return compare ? compare : (compare = (a.ownerDocument || a) === (b.ownerDocument || b) ? a.compareDocumentPosition(b) : 1, 1 & compare || !support.sortDetached && b.compareDocumentPosition(a) === compare ? a === doc || a.ownerDocument === preferredDoc && contains(preferredDoc, a) ? -1 : b === doc || b.ownerDocument === preferredDoc && contains(preferredDoc, b) ? 1 : sortInput ? indexOf.call(sortInput, a) - indexOf.call(sortInput, b) : 0 : 4 & compare ? -1 : 1)
                } : function(a, b) {
                    if (a === b)
                        return hasDuplicate = !0, 0;
                    var cur, i = 0, aup = a.parentNode, bup = b.parentNode, ap = [a], bp = [b];
                    if (!aup || !bup)
                        return a === doc ? -1 : b === doc ? 1 : aup ? -1 : bup ? 1 : sortInput ? indexOf.call(sortInput, a) - indexOf.call(sortInput, b) : 0;
                    if (aup === bup)
                        return siblingCheck(a, b);
                    for (cur = a; cur = cur.parentNode; )
                        ap.unshift(cur);
                    for (cur = b; cur = cur.parentNode; )
                        bp.unshift(cur);
                    for (; ap[i] === bp[i]; )
                        i++;
                    return i ? siblingCheck(ap[i], bp[i]) : ap[i] === preferredDoc ? -1 : bp[i] === preferredDoc ? 1 : 0
                }, doc) : document
            }, Sizzle.matches = function(expr, elements) {
                return Sizzle(expr, null, null, elements)
            }, Sizzle.matchesSelector = function(elem, expr) {
                if ((elem.ownerDocument || elem) !== document && setDocument(elem), expr = expr.replace(rattributeQuotes, "='$1']"), support.matchesSelector && documentIsHTML && (!rbuggyMatches || !rbuggyMatches.test(expr)) && (!rbuggyQSA || !rbuggyQSA.test(expr)))
                    try {
                        var ret = matches.call(elem, expr);
                        if (ret || support.disconnectedMatch || elem.document && 11 !== elem.document.nodeType)
                            return ret
                    } catch (e) {
                    }
                return Sizzle(expr, document, null, [elem]).length > 0
            }, Sizzle.contains = function(context, elem) {
                return (context.ownerDocument || context) !== document && setDocument(context), contains(context, elem)
            }, Sizzle.attr = function(elem, name) {
                (elem.ownerDocument || elem) !== document && setDocument(elem);
                var fn = Expr.attrHandle[name.toLowerCase()], val = fn && hasOwn.call(Expr.attrHandle, name.toLowerCase()) ? fn(elem, name, !documentIsHTML) : void 0;
                return void 0 !== val ? val : support.attributes || !documentIsHTML ? elem.getAttribute(name) : (val = elem.getAttributeNode(name)) && val.specified ? val.value : null
            }, Sizzle.error = function(msg) {
                throw new Error("Syntax error, unrecognized expression: " + msg)
            }, Sizzle.uniqueSort = function(results) {
                var elem, duplicates = [], j = 0, i = 0;
                if (hasDuplicate = !support.detectDuplicates, sortInput = !support.sortStable && results.slice(0), results.sort(sortOrder), hasDuplicate) {
                    for (; elem = results[i++]; )
                        elem === results[i] && (j = duplicates.push(i));
                    for (; j--; )
                        results.splice(duplicates[j], 1)
                }
                return sortInput = null, results
            }, getText = Sizzle.getText = function(elem) {
                var node, ret = "", i = 0, nodeType = elem.nodeType;
                if (nodeType) {
                    if (1 === nodeType || 9 === nodeType || 11 === nodeType) {
                        if ("string" == typeof elem.textContent)
                            return elem.textContent;
                        for (elem = elem.firstChild; elem; elem = elem.nextSibling)
                            ret += getText(elem)
                    } else if (3 === nodeType || 4 === nodeType)
                        return elem.nodeValue
                } else
                    for (; node = elem[i++]; )
                        ret += getText(node);
                return ret
            }, Expr = Sizzle.selectors = {cacheLength: 50,createPseudo: markFunction,match: matchExpr,attrHandle: {},find: {},relative: {">": {dir: "parentNode",first: !0}," ": {dir: "parentNode"},"+": {dir: "previousSibling",first: !0},"~": {dir: "previousSibling"}},preFilter: {ATTR: function(match) {
                        return match[1] = match[1].replace(runescape, funescape), match[3] = (match[3] || match[4] || match[5] || "").replace(runescape, funescape), "~=" === match[2] && (match[3] = " " + match[3] + " "), match.slice(0, 4)
                    },CHILD: function(match) {
                        return match[1] = match[1].toLowerCase(), "nth" === match[1].slice(0, 3) ? (match[3] || Sizzle.error(match[0]), match[4] = +(match[4] ? match[5] + (match[6] || 1) : 2 * ("even" === match[3] || "odd" === match[3])), match[5] = +(match[7] + match[8] || "odd" === match[3])) : match[3] && Sizzle.error(match[0]), match
                    },PSEUDO: function(match) {
                        var excess, unquoted = !match[6] && match[2];
                        return matchExpr.CHILD.test(match[0]) ? null : (match[3] ? match[2] = match[4] || match[5] || "" : unquoted && rpseudo.test(unquoted) && (excess = tokenize(unquoted, !0)) && (excess = unquoted.indexOf(")", unquoted.length - excess) - unquoted.length) && (match[0] = match[0].slice(0, excess), match[2] = unquoted.slice(0, excess)), match.slice(0, 3))
                    }},filter: {TAG: function(nodeNameSelector) {
                        var nodeName = nodeNameSelector.replace(runescape, funescape).toLowerCase();
                        return "*" === nodeNameSelector ? function() {
                            return !0
                        } : function(elem) {
                            return elem.nodeName && elem.nodeName.toLowerCase() === nodeName
                        }
                    },CLASS: function(className) {
                        var pattern = classCache[className + " "];
                        return pattern || (pattern = new RegExp("(^|" + whitespace + ")" + className + "(" + whitespace + "|$)")) && classCache(className, function(elem) {
                            return pattern.test("string" == typeof elem.className && elem.className || typeof elem.getAttribute !== strundefined && elem.getAttribute("class") || "")
                        })
                    },ATTR: function(name, operator, check) {
                        return function(elem) {
                            var result = Sizzle.attr(elem, name);
                            return null == result ? "!=" === operator : operator ? (result += "", "=" === operator ? result === check : "!=" === operator ? result !== check : "^=" === operator ? check && 0 === result.indexOf(check) : "*=" === operator ? check && result.indexOf(check) > -1 : "$=" === operator ? check && result.slice(-check.length) === check : "~=" === operator ? (" " + result + " ").indexOf(check) > -1 : "|=" === operator ? result === check || result.slice(0, check.length + 1) === check + "-" : !1) : !0
                        }
                    },CHILD: function(type, what, argument, first, last) {
                        var simple = "nth" !== type.slice(0, 3), forward = "last" !== type.slice(-4), ofType = "of-type" === what;
                        return 1 === first && 0 === last ? function(elem) {
                            return !!elem.parentNode
                        } : function(elem, context, xml) {
                            var cache, outerCache, node, diff, nodeIndex, start, dir = simple !== forward ? "nextSibling" : "previousSibling", parent = elem.parentNode, name = ofType && elem.nodeName.toLowerCase(), useCache = !xml && !ofType;
                            if (parent) {
                                if (simple) {
                                    for (; dir; ) {
                                        for (node = elem; node = node[dir]; )
                                            if (ofType ? node.nodeName.toLowerCase() === name : 1 === node.nodeType)
                                                return !1;
                                        start = dir = "only" === type && !start && "nextSibling"
                                    }
                                    return !0
                                }
                                if (start = [forward ? parent.firstChild : parent.lastChild], forward && useCache) {
                                    for (outerCache = parent[expando] || (parent[expando] = {}), cache = outerCache[type] || [], nodeIndex = cache[0] === dirruns && cache[1], diff = cache[0] === dirruns && cache[2], node = nodeIndex && parent.childNodes[nodeIndex]; node = ++nodeIndex && node && node[dir] || (diff = nodeIndex = 0) || start.pop(); )
                                        if (1 === node.nodeType && ++diff && node === elem) {
                                            outerCache[type] = [dirruns, nodeIndex, diff];
                                            break
                                        }
                                } else if (useCache && (cache = (elem[expando] || (elem[expando] = {}))[type]) && cache[0] === dirruns)
                                    diff = cache[1];
                                else
                                    for (; (node = ++nodeIndex && node && node[dir] || (diff = nodeIndex = 0) || start.pop()) && ((ofType ? node.nodeName.toLowerCase() !== name : 1 !== node.nodeType) || !++diff || (useCache && ((node[expando] || (node[expando] = {}))[type] = [dirruns, diff]), node !== elem)); )
                                        ;
                                return diff -= last, diff === first || diff % first === 0 && diff / first >= 0
                            }
                        }
                    },PSEUDO: function(pseudo, argument) {
                        var args, fn = Expr.pseudos[pseudo] || Expr.setFilters[pseudo.toLowerCase()] || Sizzle.error("unsupported pseudo: " + pseudo);
                        return fn[expando] ? fn(argument) : fn.length > 1 ? (args = [pseudo, pseudo, "", argument], Expr.setFilters.hasOwnProperty(pseudo.toLowerCase()) ? markFunction(function(seed, matches) {
                            for (var idx, matched = fn(seed, argument), i = matched.length; i--; )
                                idx = indexOf.call(seed, matched[i]), seed[idx] = !(matches[idx] = matched[i])
                        }) : function(elem) {
                            return fn(elem, 0, args)
                        }) : fn
                    }},pseudos: {not: markFunction(function(selector) {
                        var input = [], results = [], matcher = compile(selector.replace(rtrim, "$1"));
                        return matcher[expando] ? markFunction(function(seed, matches, context, xml) {
                            for (var elem, unmatched = matcher(seed, null, xml, []), i = seed.length; i--; )
                                (elem = unmatched[i]) && (seed[i] = !(matches[i] = elem))
                        }) : function(elem, context, xml) {
                            return input[0] = elem, matcher(input, null, xml, results), !results.pop()
                        }
                    }),has: markFunction(function(selector) {
                        return function(elem) {
                            return Sizzle(selector, elem).length > 0
                        }
                    }),contains: markFunction(function(text) {
                        return function(elem) {
                            return (elem.textContent || elem.innerText || getText(elem)).indexOf(text) > -1
                        }
                    }),lang: markFunction(function(lang) {
                        return ridentifier.test(lang || "") || Sizzle.error("unsupported lang: " + lang), lang = lang.replace(runescape, funescape).toLowerCase(), function(elem) {
                            var elemLang;
                            do
                                if (elemLang = documentIsHTML ? elem.lang : elem.getAttribute("xml:lang") || elem.getAttribute("lang"))
                                    return elemLang = elemLang.toLowerCase(), elemLang === lang || 0 === elemLang.indexOf(lang + "-");
                            while ((elem = elem.parentNode) && 1 === elem.nodeType);
                            return !1
                        }
                    }),target: function(elem) {
                        var hash = window.location && window.location.hash;
                        return hash && hash.slice(1) === elem.id
                    },root: function(elem) {
                        return elem === docElem
                    },focus: function(elem) {
                        return elem === document.activeElement && (!document.hasFocus || document.hasFocus()) && !!(elem.type || elem.href || ~elem.tabIndex)
                    },enabled: function(elem) {
                        return elem.disabled === !1
                    },disabled: function(elem) {
                        return elem.disabled === !0
                    },checked: function(elem) {
                        var nodeName = elem.nodeName.toLowerCase();
                        return "input" === nodeName && !!elem.checked || "option" === nodeName && !!elem.selected
                    },selected: function(elem) {
                        return elem.parentNode && elem.parentNode.selectedIndex, elem.selected === !0
                    },empty: function(elem) {
                        for (elem = elem.firstChild; elem; elem = elem.nextSibling)
                            if (elem.nodeType < 6)
                                return !1;
                        return !0
                    },parent: function(elem) {
                        return !Expr.pseudos.empty(elem)
                    },header: function(elem) {
                        return rheader.test(elem.nodeName)
                    },input: function(elem) {
                        return rinputs.test(elem.nodeName)
                    },button: function(elem) {
                        var name = elem.nodeName.toLowerCase();
                        return "input" === name && "button" === elem.type || "button" === name
                    },text: function(elem) {
                        var attr;
                        return "input" === elem.nodeName.toLowerCase() && "text" === elem.type && (null == (attr = elem.getAttribute("type")) || "text" === attr.toLowerCase())
                    },first: createPositionalPseudo(function() {
                        return [0]
                    }),last: createPositionalPseudo(function(matchIndexes, length) {
                        return [length - 1]
                    }),eq: createPositionalPseudo(function(matchIndexes, length, argument) {
                        return [0 > argument ? argument + length : argument]
                    }),even: createPositionalPseudo(function(matchIndexes, length) {
                        for (var i = 0; length > i; i += 2)
                            matchIndexes.push(i);
                        return matchIndexes
                    }),odd: createPositionalPseudo(function(matchIndexes, length) {
                        for (var i = 1; length > i; i += 2)
                            matchIndexes.push(i);
                        return matchIndexes
                    }),lt: createPositionalPseudo(function(matchIndexes, length, argument) {
                        for (var i = 0 > argument ? argument + length : argument; --i >= 0; )
                            matchIndexes.push(i);
                        return matchIndexes
                    }),gt: createPositionalPseudo(function(matchIndexes, length, argument) {
                        for (var i = 0 > argument ? argument + length : argument; ++i < length; )
                            matchIndexes.push(i);
                        return matchIndexes
                    })}}, Expr.pseudos.nth = Expr.pseudos.eq;
            for (i in {radio: !0,checkbox: !0,file: !0,password: !0,image: !0})
                Expr.pseudos[i] = createInputPseudo(i);
            for (i in {submit: !0,reset: !0})
                Expr.pseudos[i] = createButtonPseudo(i);
            return setFilters.prototype = Expr.filters = Expr.pseudos, Expr.setFilters = new setFilters, tokenize = Sizzle.tokenize = function(selector, parseOnly) {
                var matched, match, tokens, type, soFar, groups, preFilters, cached = tokenCache[selector + " "];
                if (cached)
                    return parseOnly ? 0 : cached.slice(0);
                for (soFar = selector, groups = [], preFilters = Expr.preFilter; soFar; ) {
                    (!matched || (match = rcomma.exec(soFar))) && (match && (soFar = soFar.slice(match[0].length) || soFar), groups.push(tokens = [])), matched = !1, (match = rcombinators.exec(soFar)) && (matched = match.shift(), tokens.push({value: matched,type: match[0].replace(rtrim, " ")}), soFar = soFar.slice(matched.length));
                    for (type in Expr.filter)
                        !(match = matchExpr[type].exec(soFar)) || preFilters[type] && !(match = preFilters[type](match)) || (matched = match.shift(), tokens.push({value: matched,type: type,matches: match}), soFar = soFar.slice(matched.length));
                    if (!matched)
                        break
                }
                return parseOnly ? soFar.length : soFar ? Sizzle.error(selector) : tokenCache(selector, groups).slice(0)
            }, compile = Sizzle.compile = function(selector, match) {
                var i, setMatchers = [], elementMatchers = [], cached = compilerCache[selector + " "];
                if (!cached) {
                    for (match || (match = tokenize(selector)), i = match.length; i--; )
                        cached = matcherFromTokens(match[i]), cached[expando] ? setMatchers.push(cached) : elementMatchers.push(cached);
                    cached = compilerCache(selector, matcherFromGroupMatchers(elementMatchers, setMatchers)), cached.selector = selector
                }
                return cached
            }, select = Sizzle.select = function(selector, context, results, seed) {
                var i, tokens, token, type, find, compiled = "function" == typeof selector && selector, match = !seed && tokenize(selector = compiled.selector || selector);
                if (results = results || [], 1 === match.length) {
                    if (tokens = match[0] = match[0].slice(0), tokens.length > 2 && "ID" === (token = tokens[0]).type && support.getById && 9 === context.nodeType && documentIsHTML && Expr.relative[tokens[1].type]) {
                        if (context = (Expr.find.ID(token.matches[0].replace(runescape, funescape), context) || [])[0], !context)
                            return results;
                        compiled && (context = context.parentNode), selector = selector.slice(tokens.shift().value.length)
                    }
                    for (i = matchExpr.needsContext.test(selector) ? 0 : tokens.length; i-- && (token = tokens[i], !Expr.relative[type = token.type]); )
                        if ((find = Expr.find[type]) && (seed = find(token.matches[0].replace(runescape, funescape), rsibling.test(tokens[0].type) && testContext(context.parentNode) || context))) {
                            if (tokens.splice(i, 1), selector = seed.length && toSelector(tokens), !selector)
                                return push.apply(results, seed), results;
                            break
                        }
                }
                return (compiled || compile(selector, match))(seed, context, !documentIsHTML, results, rsibling.test(selector) && testContext(context.parentNode) || context), results
            }, support.sortStable = expando.split("").sort(sortOrder).join("") === expando, support.detectDuplicates = !!hasDuplicate, setDocument(), support.sortDetached = assert(function(div1) {
                return 1 & div1.compareDocumentPosition(document.createElement("div"))
            }), assert(function(div) {
                return div.innerHTML = "<a href='#'></a>", "#" === div.firstChild.getAttribute("href")
            }) || addHandle("type|href|height|width", function(elem, name, isXML) {
                return isXML ? void 0 : elem.getAttribute(name, "type" === name.toLowerCase() ? 1 : 2)
            }), support.attributes && assert(function(div) {
                return div.innerHTML = "<input/>", div.firstChild.setAttribute("value", ""), "" === div.firstChild.getAttribute("value")
            }) || addHandle("value", function(elem, name, isXML) {
                return isXML || "input" !== elem.nodeName.toLowerCase() ? void 0 : elem.defaultValue
            }), assert(function(div) {
                return null == div.getAttribute("disabled")
            }) || addHandle(booleans, function(elem, name, isXML) {
                var val;
                return isXML ? void 0 : elem[name] === !0 ? name.toLowerCase() : (val = elem.getAttributeNode(name)) && val.specified ? val.value : null
            }), Sizzle
        }(window);
        jQuery.find = Sizzle, jQuery.expr = Sizzle.selectors, jQuery.expr[":"] = jQuery.expr.pseudos, jQuery.unique = Sizzle.uniqueSort, jQuery.text = Sizzle.getText, jQuery.isXMLDoc = Sizzle.isXML, jQuery.contains = Sizzle.contains;
        var rneedsContext = jQuery.expr.match.needsContext, rsingleTag = /^<(\w+)\s*\/?>(?:<\/\1>|)$/, risSimple = /^.[^:#\[\.,]*$/;
        jQuery.filter = function(expr, elems, not) {
            var elem = elems[0];
            return not && (expr = ":not(" + expr + ")"), 1 === elems.length && 1 === elem.nodeType ? jQuery.find.matchesSelector(elem, expr) ? [elem] : [] : jQuery.find.matches(expr, jQuery.grep(elems, function(elem) {
                return 1 === elem.nodeType
            }))
        }, jQuery.fn.extend({find: function(selector) {
                var i, ret = [], self = this, len = self.length;
                if ("string" != typeof selector)
                    return this.pushStack(jQuery(selector).filter(function() {
                        for (i = 0; len > i; i++)
                            if (jQuery.contains(self[i], this))
                                return !0
                    }));
                for (i = 0; len > i; i++)
                    jQuery.find(selector, self[i], ret);
                return ret = this.pushStack(len > 1 ? jQuery.unique(ret) : ret), ret.selector = this.selector ? this.selector + " " + selector : selector, ret
            },filter: function(selector) {
                return this.pushStack(winnow(this, selector || [], !1))
            },not: function(selector) {
                return this.pushStack(winnow(this, selector || [], !0))
            },is: function(selector) {
                return !!winnow(this, "string" == typeof selector && rneedsContext.test(selector) ? jQuery(selector) : selector || [], !1).length
            }});
        var rootjQuery, document = window.document, rquickExpr = /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]*))$/, init = jQuery.fn.init = function(selector, context) {
            var match, elem;
            if (!selector)
                return this;
            if ("string" == typeof selector) {
                if (match = "<" === selector.charAt(0) && ">" === selector.charAt(selector.length - 1) && selector.length >= 3 ? [null, selector, null] : rquickExpr.exec(selector), !match || !match[1] && context)
                    return !context || context.jquery ? (context || rootjQuery).find(selector) : this.constructor(context).find(selector);
                if (match[1]) {
                    if (context = context instanceof jQuery ? context[0] : context, jQuery.merge(this, jQuery.parseHTML(match[1], context && context.nodeType ? context.ownerDocument || context : document, !0)), rsingleTag.test(match[1]) && jQuery.isPlainObject(context))
                        for (match in context)
                            jQuery.isFunction(this[match]) ? this[match](context[match]) : this.attr(match, context[match]);
                    return this
                }
                if (elem = document.getElementById(match[2]), elem && elem.parentNode) {
                    if (elem.id !== match[2])
                        return rootjQuery.find(selector);
                    this.length = 1, this[0] = elem
                }
                return this.context = document, this.selector = selector, this
            }
            return selector.nodeType ? (this.context = this[0] = selector, this.length = 1, this) : jQuery.isFunction(selector) ? "undefined" != typeof rootjQuery.ready ? rootjQuery.ready(selector) : selector(jQuery) : (void 0 !== selector.selector && (this.selector = selector.selector, this.context = selector.context), jQuery.makeArray(selector, this))
        };
        init.prototype = jQuery.fn, rootjQuery = jQuery(document);
        var rparentsprev = /^(?:parents|prev(?:Until|All))/, guaranteedUnique = {children: !0,contents: !0,next: !0,prev: !0};
        jQuery.extend({dir: function(elem, dir, until) {
                for (var matched = [], cur = elem[dir]; cur && 9 !== cur.nodeType && (void 0 === until || 1 !== cur.nodeType || !jQuery(cur).is(until)); )
                    1 === cur.nodeType && matched.push(cur), cur = cur[dir];
                return matched
            },sibling: function(n, elem) {
                for (var r = []; n; n = n.nextSibling)
                    1 === n.nodeType && n !== elem && r.push(n);
                return r
            }}), jQuery.fn.extend({has: function(target) {
                var i, targets = jQuery(target, this), len = targets.length;
                return this.filter(function() {
                    for (i = 0; len > i; i++)
                        if (jQuery.contains(this, targets[i]))
                            return !0
                })
            },closest: function(selectors, context) {
                for (var cur, i = 0, l = this.length, matched = [], pos = rneedsContext.test(selectors) || "string" != typeof selectors ? jQuery(selectors, context || this.context) : 0; l > i; i++)
                    for (cur = this[i]; cur && cur !== context; cur = cur.parentNode)
                        if (cur.nodeType < 11 && (pos ? pos.index(cur) > -1 : 1 === cur.nodeType && jQuery.find.matchesSelector(cur, selectors))) {
                            matched.push(cur);
                            break
                        }
                return this.pushStack(matched.length > 1 ? jQuery.unique(matched) : matched)
            },index: function(elem) {
                return elem ? "string" == typeof elem ? jQuery.inArray(this[0], jQuery(elem)) : jQuery.inArray(elem.jquery ? elem[0] : elem, this) : this[0] && this[0].parentNode ? this.first().prevAll().length : -1
            },add: function(selector, context) {
                return this.pushStack(jQuery.unique(jQuery.merge(this.get(), jQuery(selector, context))))
            },addBack: function(selector) {
                return this.add(null == selector ? this.prevObject : this.prevObject.filter(selector))
            }}), jQuery.each({parent: function(elem) {
                var parent = elem.parentNode;
                return parent && 11 !== parent.nodeType ? parent : null
            },parents: function(elem) {
                return jQuery.dir(elem, "parentNode")
            },parentsUntil: function(elem, i, until) {
                return jQuery.dir(elem, "parentNode", until)
            },next: function(elem) {
                return sibling(elem, "nextSibling")
            },prev: function(elem) {
                return sibling(elem, "previousSibling")
            },nextAll: function(elem) {
                return jQuery.dir(elem, "nextSibling")
            },prevAll: function(elem) {
                return jQuery.dir(elem, "previousSibling")
            },nextUntil: function(elem, i, until) {
                return jQuery.dir(elem, "nextSibling", until)
            },prevUntil: function(elem, i, until) {
                return jQuery.dir(elem, "previousSibling", until)
            },siblings: function(elem) {
                return jQuery.sibling((elem.parentNode || {}).firstChild, elem)
            },children: function(elem) {
                return jQuery.sibling(elem.firstChild)
            },contents: function(elem) {
                return jQuery.nodeName(elem, "iframe") ? elem.contentDocument || elem.contentWindow.document : jQuery.merge([], elem.childNodes)
            }}, function(name, fn) {
            jQuery.fn[name] = function(until, selector) {
                var ret = jQuery.map(this, fn, until);
                return "Until" !== name.slice(-5) && (selector = until), selector && "string" == typeof selector && (ret = jQuery.filter(selector, ret)), this.length > 1 && (guaranteedUnique[name] || (ret = jQuery.unique(ret)), rparentsprev.test(name) && (ret = ret.reverse())), this.pushStack(ret)
            }
        });
        var rnotwhite = /\S+/g, optionsCache = {};
        jQuery.Callbacks = function(options) {
            options = "string" == typeof options ? optionsCache[options] || createOptions(options) : jQuery.extend({}, options);
            var firing, memory, fired, firingLength, firingIndex, firingStart, list = [], stack = !options.once && [], fire = function(data) {
                for (memory = options.memory && data, fired = !0, firingIndex = firingStart || 0, firingStart = 0, firingLength = list.length, firing = !0; list && firingLength > firingIndex; firingIndex++)
                    if (list[firingIndex].apply(data[0], data[1]) === !1 && options.stopOnFalse) {
                        memory = !1;
                        break
                    }
                firing = !1, list && (stack ? stack.length && fire(stack.shift()) : memory ? list = [] : self.disable())
            }, self = {add: function() {
                    if (list) {
                        var start = list.length;
                        !function add(args) {
                            jQuery.each(args, function(_, arg) {
                                var type = jQuery.type(arg);
                                "function" === type ? options.unique && self.has(arg) || list.push(arg) : arg && arg.length && "string" !== type && add(arg)
                            })
                        }(arguments), firing ? firingLength = list.length : memory && (firingStart = start, fire(memory))
                    }
                    return this
                },remove: function() {
                    return list && jQuery.each(arguments, function(_, arg) {
                        for (var index; (index = jQuery.inArray(arg, list, index)) > -1; )
                            list.splice(index, 1), firing && (firingLength >= index && firingLength--, firingIndex >= index && firingIndex--)
                    }), this
                },has: function(fn) {
                    return fn ? jQuery.inArray(fn, list) > -1 : !(!list || !list.length)
                },empty: function() {
                    return list = [], firingLength = 0, this
                },disable: function() {
                    return list = stack = memory = void 0, this
                },disabled: function() {
                    return !list
                },lock: function() {
                    return stack = void 0, memory || self.disable(), this
                },locked: function() {
                    return !stack
                },fireWith: function(context, args) {
                    return !list || fired && !stack || (args = args || [], args = [context, args.slice ? args.slice() : args], firing ? stack.push(args) : fire(args)), this
                },fire: function() {
                    return self.fireWith(this, arguments), this
                },fired: function() {
                    return !!fired
                }};
            return self
        }, jQuery.extend({Deferred: function(func) {
                var tuples = [["resolve", "done", jQuery.Callbacks("once memory"), "resolved"], ["reject", "fail", jQuery.Callbacks("once memory"), "rejected"], ["notify", "progress", jQuery.Callbacks("memory")]], state = "pending", promise = {state: function() {
                        return state
                    },always: function() {
                        return deferred.done(arguments).fail(arguments), this
                    },then: function() {
                        var fns = arguments;
                        return jQuery.Deferred(function(newDefer) {
                            jQuery.each(tuples, function(i, tuple) {
                                var fn = jQuery.isFunction(fns[i]) && fns[i];
                                deferred[tuple[1]](function() {
                                    var returned = fn && fn.apply(this, arguments);
                                    returned && jQuery.isFunction(returned.promise) ? returned.promise().done(newDefer.resolve).fail(newDefer.reject).progress(newDefer.notify) : newDefer[tuple[0] + "With"](this === promise ? newDefer.promise() : this, fn ? [returned] : arguments)
                                })
                            }), fns = null
                        }).promise()
                    },promise: function(obj) {
                        return null != obj ? jQuery.extend(obj, promise) : promise
                    }}, deferred = {};
                return promise.pipe = promise.then, jQuery.each(tuples, function(i, tuple) {
                    var list = tuple[2], stateString = tuple[3];
                    promise[tuple[1]] = list.add, stateString && list.add(function() {
                        state = stateString
                    }, tuples[1 ^ i][2].disable, tuples[2][2].lock), deferred[tuple[0]] = function() {
                        return deferred[tuple[0] + "With"](this === deferred ? promise : this, arguments), this
                    }, deferred[tuple[0] + "With"] = list.fireWith
                }), promise.promise(deferred), func && func.call(deferred, deferred), deferred
            },when: function(subordinate) {
                var progressValues, progressContexts, resolveContexts, i = 0, resolveValues = slice.call(arguments), length = resolveValues.length, remaining = 1 !== length || subordinate && jQuery.isFunction(subordinate.promise) ? length : 0, deferred = 1 === remaining ? subordinate : jQuery.Deferred(), updateFunc = function(i, contexts, values) {
                    return function(value) {
                        contexts[i] = this, values[i] = arguments.length > 1 ? slice.call(arguments) : value, values === progressValues ? deferred.notifyWith(contexts, values) : --remaining || deferred.resolveWith(contexts, values)
                    }
                };
                if (length > 1)
                    for (progressValues = new Array(length), progressContexts = new Array(length), resolveContexts = new Array(length); length > i; i++)
                        resolveValues[i] && jQuery.isFunction(resolveValues[i].promise) ? resolveValues[i].promise().done(updateFunc(i, resolveContexts, resolveValues)).fail(deferred.reject).progress(updateFunc(i, progressContexts, progressValues)) : --remaining;
                return remaining || deferred.resolveWith(resolveContexts, resolveValues), deferred.promise()
            }});
        var readyList;
        jQuery.fn.ready = function(fn) {
            return jQuery.ready.promise().done(fn), this
        }, jQuery.extend({isReady: !1,readyWait: 1,holdReady: function(hold) {
                hold ? jQuery.readyWait++ : jQuery.ready(!0)
            },ready: function(wait) {
                if (wait === !0 ? !--jQuery.readyWait : !jQuery.isReady) {
                    if (!document.body)
                        return setTimeout(jQuery.ready);
                    jQuery.isReady = !0, wait !== !0 && --jQuery.readyWait > 0 || (readyList.resolveWith(document, [jQuery]), jQuery.fn.triggerHandler && (jQuery(document).triggerHandler("ready"), jQuery(document).off("ready")))
                }
            }}), jQuery.ready.promise = function(obj) {
            if (!readyList)
                if (readyList = jQuery.Deferred(), "complete" === document.readyState)
                    setTimeout(jQuery.ready);
                else if (document.addEventListener)
                    document.addEventListener("DOMContentLoaded", completed, !1), 
                    window.addEventListener("load", completed, !1);
                else {
                    document.attachEvent("onreadystatechange", completed), window.attachEvent("onload", completed);
                    var top = !1;
                    try {
                        top = null == window.frameElement && document.documentElement
                    } catch (e) {
                    }
                    top && top.doScroll && !function doScrollCheck() {
                        if (!jQuery.isReady) {
                            try {
                                top.doScroll("left")
                            } catch (e) {
                                return setTimeout(doScrollCheck, 50)
                            }
                            detach(), jQuery.ready()
                        }
                    }()
                }
            return readyList.promise(obj)
        };
        var i, strundefined = "undefined";
        for (i in jQuery(support))
            break;
        support.ownLast = "0" !== i, support.inlineBlockNeedsLayout = !1, jQuery(function() {
            var val, div, body, container;
            body = document.getElementsByTagName("body")[0], body && body.style && (div = document.createElement("div"), container = document.createElement("div"), container.style.cssText = "position:absolute;border:0;width:0;height:0;top:0;left:-9999px", body.appendChild(container).appendChild(div), typeof div.style.zoom !== strundefined && (div.style.cssText = "display:inline;margin:0;border:0;padding:1px;width:1px;zoom:1", support.inlineBlockNeedsLayout = val = 3 === div.offsetWidth, val && (body.style.zoom = 1)), body.removeChild(container))
        }), function() {
            var div = document.createElement("div");
            if (null == support.deleteExpando) {
                support.deleteExpando = !0;
                try {
                    delete div.test
                } catch (e) {
                    support.deleteExpando = !1
                }
            }
            div = null
        }(), jQuery.acceptData = function(elem) {
            var noData = jQuery.noData[(elem.nodeName + " ").toLowerCase()], nodeType = +elem.nodeType || 1;
            return 1 !== nodeType && 9 !== nodeType ? !1 : !noData || noData !== !0 && elem.getAttribute("classid") === noData
        };
        var rbrace = /^(?:\{[\w\W]*\}|\[[\w\W]*\])$/, rmultiDash = /([A-Z])/g;
        jQuery.extend({cache: {},noData: {"applet ": !0,"embed ": !0,"object ": "clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"},hasData: function(elem) {
                return elem = elem.nodeType ? jQuery.cache[elem[jQuery.expando]] : elem[jQuery.expando], !!elem && !isEmptyDataObject(elem)
            },data: function(elem, name, data) {
                return internalData(elem, name, data)
            },removeData: function(elem, name) {
                return internalRemoveData(elem, name)
            },_data: function(elem, name, data) {
                return internalData(elem, name, data, !0)
            },_removeData: function(elem, name) {
                return internalRemoveData(elem, name, !0)
            }}), jQuery.fn.extend({data: function(key, value) {
                var i, name, data, elem = this[0], attrs = elem && elem.attributes;
                if (void 0 === key) {
                    if (this.length && (data = jQuery.data(elem), 1 === elem.nodeType && !jQuery._data(elem, "parsedAttrs"))) {
                        for (i = attrs.length; i--; )
                            attrs[i] && (name = attrs[i].name, 0 === name.indexOf("data-") && (name = jQuery.camelCase(name.slice(5)), dataAttr(elem, name, data[name])));
                        jQuery._data(elem, "parsedAttrs", !0)
                    }
                    return data
                }
                return "object" == typeof key ? this.each(function() {
                    jQuery.data(this, key)
                }) : arguments.length > 1 ? this.each(function() {
                    jQuery.data(this, key, value)
                }) : elem ? dataAttr(elem, key, jQuery.data(elem, key)) : void 0
            },removeData: function(key) {
                return this.each(function() {
                    jQuery.removeData(this, key)
                })
            }}), jQuery.extend({queue: function(elem, type, data) {
                var queue;
                return elem ? (type = (type || "fx") + "queue", queue = jQuery._data(elem, type), data && (!queue || jQuery.isArray(data) ? queue = jQuery._data(elem, type, jQuery.makeArray(data)) : queue.push(data)), queue || []) : void 0
            },dequeue: function(elem, type) {
                type = type || "fx";
                var queue = jQuery.queue(elem, type), startLength = queue.length, fn = queue.shift(), hooks = jQuery._queueHooks(elem, type), next = function() {
                    jQuery.dequeue(elem, type)
                };
                "inprogress" === fn && (fn = queue.shift(), startLength--), fn && ("fx" === type && queue.unshift("inprogress"), delete hooks.stop, fn.call(elem, next, hooks)), !startLength && hooks && hooks.empty.fire()
            },_queueHooks: function(elem, type) {
                var key = type + "queueHooks";
                return jQuery._data(elem, key) || jQuery._data(elem, key, {empty: jQuery.Callbacks("once memory").add(function() {
                        jQuery._removeData(elem, type + "queue"), jQuery._removeData(elem, key)
                    })})
            }}), jQuery.fn.extend({queue: function(type, data) {
                var setter = 2;
                return "string" != typeof type && (data = type, type = "fx", setter--), arguments.length < setter ? jQuery.queue(this[0], type) : void 0 === data ? this : this.each(function() {
                    var queue = jQuery.queue(this, type, data);
                    jQuery._queueHooks(this, type), "fx" === type && "inprogress" !== queue[0] && jQuery.dequeue(this, type)
                })
            },dequeue: function(type) {
                return this.each(function() {
                    jQuery.dequeue(this, type)
                })
            },clearQueue: function(type) {
                return this.queue(type || "fx", [])
            },promise: function(type, obj) {
                var tmp, count = 1, defer = jQuery.Deferred(), elements = this, i = this.length, resolve = function() {
                    --count || defer.resolveWith(elements, [elements])
                };
                for ("string" != typeof type && (obj = type, type = void 0), type = type || "fx"; i--; )
                    tmp = jQuery._data(elements[i], type + "queueHooks"), tmp && tmp.empty && (count++, tmp.empty.add(resolve));
                return resolve(), defer.promise(obj)
            }});
        var pnum = /[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source, cssExpand = ["Top", "Right", "Bottom", "Left"], isHidden = function(elem, el) {
            return elem = el || elem, "none" === jQuery.css(elem, "display") || !jQuery.contains(elem.ownerDocument, elem)
        }, access = jQuery.access = function(elems, fn, key, value, chainable, emptyGet, raw) {
            var i = 0, length = elems.length, bulk = null == key;
            if ("object" === jQuery.type(key)) {
                chainable = !0;
                for (i in key)
                    jQuery.access(elems, fn, i, key[i], !0, emptyGet, raw)
            } else if (void 0 !== value && (chainable = !0, jQuery.isFunction(value) || (raw = !0), bulk && (raw ? (fn.call(elems, value), fn = null) : (bulk = fn, fn = function(elem, key, value) {
                return bulk.call(jQuery(elem), value)
            })), fn))
                for (; length > i; i++)
                    fn(elems[i], key, raw ? value : value.call(elems[i], i, fn(elems[i], key)));
            return chainable ? elems : bulk ? fn.call(elems) : length ? fn(elems[0], key) : emptyGet
        }, rcheckableType = /^(?:checkbox|radio)$/i;
        !function() {
            var input = document.createElement("input"), div = document.createElement("div"), fragment = document.createDocumentFragment();
            if (div.innerHTML = "  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>", support.leadingWhitespace = 3 === div.firstChild.nodeType, support.tbody = !div.getElementsByTagName("tbody").length, support.htmlSerialize = !!div.getElementsByTagName("link").length, support.html5Clone = "<:nav></:nav>" !== document.createElement("nav").cloneNode(!0).outerHTML, input.type = "checkbox", input.checked = !0, fragment.appendChild(input), support.appendChecked = input.checked, div.innerHTML = "<textarea>x</textarea>", support.noCloneChecked = !!div.cloneNode(!0).lastChild.defaultValue, fragment.appendChild(div), div.innerHTML = "<input type='radio' checked='checked' name='t'/>", support.checkClone = div.cloneNode(!0).cloneNode(!0).lastChild.checked, support.noCloneEvent = !0, div.attachEvent && (div.attachEvent("onclick", function() {
                support.noCloneEvent = !1
            }), div.cloneNode(!0).click()), null == support.deleteExpando) {
                support.deleteExpando = !0;
                try {
                    delete div.test
                } catch (e) {
                    support.deleteExpando = !1
                }
            }
        }(), function() {
            var i, eventName, div = document.createElement("div");
            for (i in {submit: !0,change: !0,focusin: !0})
                eventName = "on" + i, (support[i + "Bubbles"] = eventName in window) || (div.setAttribute(eventName, "t"), support[i + "Bubbles"] = div.attributes[eventName].expando === !1);
            div = null
        }();
        var rformElems = /^(?:input|select|textarea)$/i, rkeyEvent = /^key/, rmouseEvent = /^(?:mouse|pointer|contextmenu)|click/, rfocusMorph = /^(?:focusinfocus|focusoutblur)$/, rtypenamespace = /^([^.]*)(?:\.(.+)|)$/;
        jQuery.event = {global: {},add: function(elem, types, handler, data, selector) {
                var tmp, events, t, handleObjIn, special, eventHandle, handleObj, handlers, type, namespaces, origType, elemData = jQuery._data(elem);
                if (elemData) {
                    for (handler.handler && (handleObjIn = handler, handler = handleObjIn.handler, selector = handleObjIn.selector), handler.guid || (handler.guid = jQuery.guid++), (events = elemData.events) || (events = elemData.events = {}), (eventHandle = elemData.handle) || (eventHandle = elemData.handle = function(e) {
                        return typeof jQuery === strundefined || e && jQuery.event.triggered === e.type ? void 0 : jQuery.event.dispatch.apply(eventHandle.elem, arguments)
                    }, eventHandle.elem = elem), types = (types || "").match(rnotwhite) || [""], t = types.length; t--; )
                        tmp = rtypenamespace.exec(types[t]) || [], type = origType = tmp[1], namespaces = (tmp[2] || "").split(".").sort(), type && (special = jQuery.event.special[type] || {}, type = (selector ? special.delegateType : special.bindType) || type, special = jQuery.event.special[type] || {}, handleObj = jQuery.extend({type: type,origType: origType,data: data,handler: handler,guid: handler.guid,selector: selector,needsContext: selector && jQuery.expr.match.needsContext.test(selector),namespace: namespaces.join(".")}, handleObjIn), (handlers = events[type]) || (handlers = events[type] = [], handlers.delegateCount = 0, special.setup && special.setup.call(elem, data, namespaces, eventHandle) !== !1 || (elem.addEventListener ? elem.addEventListener(type, eventHandle, !1) : elem.attachEvent && elem.attachEvent("on" + type, eventHandle))), special.add && (special.add.call(elem, handleObj), handleObj.handler.guid || (handleObj.handler.guid = handler.guid)), selector ? handlers.splice(handlers.delegateCount++, 0, handleObj) : handlers.push(handleObj), jQuery.event.global[type] = !0);
                    elem = null
                }
            },remove: function(elem, types, handler, selector, mappedTypes) {
                var j, handleObj, tmp, origCount, t, events, special, handlers, type, namespaces, origType, elemData = jQuery.hasData(elem) && jQuery._data(elem);
                if (elemData && (events = elemData.events)) {
                    for (types = (types || "").match(rnotwhite) || [""], t = types.length; t--; )
                        if (tmp = rtypenamespace.exec(types[t]) || [], type = origType = tmp[1], namespaces = (tmp[2] || "").split(".").sort(), type) {
                            for (special = jQuery.event.special[type] || {}, type = (selector ? special.delegateType : special.bindType) || type, handlers = events[type] || [], tmp = tmp[2] && new RegExp("(^|\\.)" + namespaces.join("\\.(?:.*\\.|)") + "(\\.|$)"), origCount = j = handlers.length; j--; )
                                handleObj = handlers[j], !mappedTypes && origType !== handleObj.origType || handler && handler.guid !== handleObj.guid || tmp && !tmp.test(handleObj.namespace) || selector && selector !== handleObj.selector && ("**" !== selector || !handleObj.selector) || (handlers.splice(j, 1), handleObj.selector && handlers.delegateCount--, special.remove && special.remove.call(elem, handleObj));
                            origCount && !handlers.length && (special.teardown && special.teardown.call(elem, namespaces, elemData.handle) !== !1 || jQuery.removeEvent(elem, type, elemData.handle), delete events[type])
                        } else
                            for (type in events)
                                jQuery.event.remove(elem, type + types[t], handler, selector, !0);
                    jQuery.isEmptyObject(events) && (delete elemData.handle, jQuery._removeData(elem, "events"))
                }
            },trigger: function(event, data, elem, onlyHandlers) {
                var handle, ontype, cur, bubbleType, special, tmp, i, eventPath = [elem || document], type = hasOwn.call(event, "type") ? event.type : event, namespaces = hasOwn.call(event, "namespace") ? event.namespace.split(".") : [];
                if (cur = tmp = elem = elem || document, 3 !== elem.nodeType && 8 !== elem.nodeType && !rfocusMorph.test(type + jQuery.event.triggered) && (type.indexOf(".") >= 0 && (namespaces = type.split("."), type = namespaces.shift(), namespaces.sort()), ontype = type.indexOf(":") < 0 && "on" + type, event = event[jQuery.expando] ? event : new jQuery.Event(type, "object" == typeof event && event), event.isTrigger = onlyHandlers ? 2 : 3, event.namespace = namespaces.join("."), event.namespace_re = event.namespace ? new RegExp("(^|\\.)" + namespaces.join("\\.(?:.*\\.|)") + "(\\.|$)") : null, event.result = void 0, event.target || (event.target = elem), data = null == data ? [event] : jQuery.makeArray(data, [event]), special = jQuery.event.special[type] || {}, onlyHandlers || !special.trigger || special.trigger.apply(elem, data) !== !1)) {
                    if (!onlyHandlers && !special.noBubble && !jQuery.isWindow(elem)) {
                        for (bubbleType = special.delegateType || type, rfocusMorph.test(bubbleType + type) || (cur = cur.parentNode); cur; cur = cur.parentNode)
                            eventPath.push(cur), tmp = cur;
                        tmp === (elem.ownerDocument || document) && eventPath.push(tmp.defaultView || tmp.parentWindow || window)
                    }
                    for (i = 0; (cur = eventPath[i++]) && !event.isPropagationStopped(); )
                        event.type = i > 1 ? bubbleType : special.bindType || type, handle = (jQuery._data(cur, "events") || {})[event.type] && jQuery._data(cur, "handle"), handle && handle.apply(cur, data), handle = ontype && cur[ontype], handle && handle.apply && jQuery.acceptData(cur) && (event.result = handle.apply(cur, data), event.result === !1 && event.preventDefault());
                    if (event.type = type, !onlyHandlers && !event.isDefaultPrevented() && (!special._default || special._default.apply(eventPath.pop(), data) === !1) && jQuery.acceptData(elem) && ontype && elem[type] && !jQuery.isWindow(elem)) {
                        tmp = elem[ontype], tmp && (elem[ontype] = null), jQuery.event.triggered = type;
                        try {
                            elem[type]()
                        } catch (e) {
                        }
                        jQuery.event.triggered = void 0, tmp && (elem[ontype] = tmp)
                    }
                    return event.result
                }
            },dispatch: function(event) {
                event = jQuery.event.fix(event);
                var i, ret, handleObj, matched, j, handlerQueue = [], args = slice.call(arguments), handlers = (jQuery._data(this, "events") || {})[event.type] || [], special = jQuery.event.special[event.type] || {};
                if (args[0] = event, event.delegateTarget = this, !special.preDispatch || special.preDispatch.call(this, event) !== !1) {
                    for (handlerQueue = jQuery.event.handlers.call(this, event, handlers), i = 0; (matched = handlerQueue[i++]) && !event.isPropagationStopped(); )
                        for (event.currentTarget = matched.elem, j = 0; (handleObj = matched.handlers[j++]) && !event.isImmediatePropagationStopped(); )
                            (!event.namespace_re || event.namespace_re.test(handleObj.namespace)) && (event.handleObj = handleObj, event.data = handleObj.data, ret = ((jQuery.event.special[handleObj.origType] || {}).handle || handleObj.handler).apply(matched.elem, args), void 0 !== ret && (event.result = ret) === !1 && (event.preventDefault(), event.stopPropagation()));
                    return special.postDispatch && special.postDispatch.call(this, event), event.result
                }
            },handlers: function(event, handlers) {
                var sel, handleObj, matches, i, handlerQueue = [], delegateCount = handlers.delegateCount, cur = event.target;
                if (delegateCount && cur.nodeType && (!event.button || "click" !== event.type))
                    for (; cur != this; cur = cur.parentNode || this)
                        if (1 === cur.nodeType && (cur.disabled !== !0 || "click" !== event.type)) {
                            for (matches = [], i = 0; delegateCount > i; i++)
                                handleObj = handlers[i], sel = handleObj.selector + " ", void 0 === matches[sel] && (matches[sel] = handleObj.needsContext ? jQuery(sel, this).index(cur) >= 0 : jQuery.find(sel, this, null, [cur]).length), matches[sel] && matches.push(handleObj);
                            matches.length && handlerQueue.push({elem: cur,handlers: matches})
                        }
                return delegateCount < handlers.length && handlerQueue.push({elem: this,handlers: handlers.slice(delegateCount)}), handlerQueue
            },fix: function(event) {
                if (event[jQuery.expando])
                    return event;
                var i, prop, copy, type = event.type, originalEvent = event, fixHook = this.fixHooks[type];
                for (fixHook || (this.fixHooks[type] = fixHook = rmouseEvent.test(type) ? this.mouseHooks : rkeyEvent.test(type) ? this.keyHooks : {}), copy = fixHook.props ? this.props.concat(fixHook.props) : this.props, event = new jQuery.Event(originalEvent), i = copy.length; i--; )
                    prop = copy[i], event[prop] = originalEvent[prop];
                return event.target || (event.target = originalEvent.srcElement || document), 3 === event.target.nodeType && (event.target = event.target.parentNode), event.metaKey = !!event.metaKey, fixHook.filter ? fixHook.filter(event, originalEvent) : event
            },props: "altKey bubbles cancelable ctrlKey currentTarget eventPhase metaKey relatedTarget shiftKey target timeStamp view which".split(" "),fixHooks: {},keyHooks: {props: "char charCode key keyCode".split(" "),filter: function(event, original) {
                    return null == event.which && (event.which = null != original.charCode ? original.charCode : original.keyCode), event
                }},mouseHooks: {props: "button buttons clientX clientY fromElement offsetX offsetY pageX pageY screenX screenY toElement".split(" "),filter: function(event, original) {
                    var body, eventDoc, doc, button = original.button, fromElement = original.fromElement;
                    return null == event.pageX && null != original.clientX && (eventDoc = event.target.ownerDocument || document, doc = eventDoc.documentElement, body = eventDoc.body, event.pageX = original.clientX + (doc && doc.scrollLeft || body && body.scrollLeft || 0) - (doc && doc.clientLeft || body && body.clientLeft || 0), event.pageY = original.clientY + (doc && doc.scrollTop || body && body.scrollTop || 0) - (doc && doc.clientTop || body && body.clientTop || 0)), !event.relatedTarget && fromElement && (event.relatedTarget = fromElement === event.target ? original.toElement : fromElement), event.which || void 0 === button || (event.which = 1 & button ? 1 : 2 & button ? 3 : 4 & button ? 2 : 0), event
                }},special: {load: {noBubble: !0},focus: {trigger: function() {
                        if (this !== safeActiveElement() && this.focus)
                            try {
                                return this.focus(), !1
                            } catch (e) {
                            }
                    },delegateType: "focusin"},blur: {trigger: function() {
                        return this === safeActiveElement() && this.blur ? (this.blur(), !1) : void 0
                    },delegateType: "focusout"},click: {trigger: function() {
                        return jQuery.nodeName(this, "input") && "checkbox" === this.type && this.click ? (this.click(), !1) : void 0
                    },_default: function(event) {
                        return jQuery.nodeName(event.target, "a")
                    }},beforeunload: {postDispatch: function(event) {
                        void 0 !== event.result && event.originalEvent && (event.originalEvent.returnValue = event.result)
                    }}},simulate: function(type, elem, event, bubble) {
                var e = jQuery.extend(new jQuery.Event, event, {type: type,isSimulated: !0,originalEvent: {}});
                bubble ? jQuery.event.trigger(e, null, elem) : jQuery.event.dispatch.call(elem, e), e.isDefaultPrevented() && event.preventDefault()
            }}, jQuery.removeEvent = document.removeEventListener ? function(elem, type, handle) {
            elem.removeEventListener && elem.removeEventListener(type, handle, !1)
        } : function(elem, type, handle) {
            var name = "on" + type;
            elem.detachEvent && (typeof elem[name] === strundefined && (elem[name] = null), elem.detachEvent(name, handle))
        }, jQuery.Event = function(src, props) {
            return this instanceof jQuery.Event ? (src && src.type ? (this.originalEvent = src, this.type = src.type, this.isDefaultPrevented = src.defaultPrevented || void 0 === src.defaultPrevented && src.returnValue === !1 ? returnTrue : returnFalse) : this.type = src, props && jQuery.extend(this, props), this.timeStamp = src && src.timeStamp || jQuery.now(), void (this[jQuery.expando] = !0)) : new jQuery.Event(src, props)
        }, jQuery.Event.prototype = {isDefaultPrevented: returnFalse,isPropagationStopped: returnFalse,isImmediatePropagationStopped: returnFalse,preventDefault: function() {
                var e = this.originalEvent;
                this.isDefaultPrevented = returnTrue, e && (e.preventDefault ? e.preventDefault() : e.returnValue = !1)
            },stopPropagation: function() {
                var e = this.originalEvent;
                this.isPropagationStopped = returnTrue, e && (e.stopPropagation && e.stopPropagation(), e.cancelBubble = !0)
            },stopImmediatePropagation: function() {
                var e = this.originalEvent;
                this.isImmediatePropagationStopped = returnTrue, e && e.stopImmediatePropagation && e.stopImmediatePropagation(), this.stopPropagation()
            }}, jQuery.each({mouseenter: "mouseover",mouseleave: "mouseout",pointerenter: "pointerover",pointerleave: "pointerout"}, function(orig, fix) {
            jQuery.event.special[orig] = {delegateType: fix,bindType: fix,handle: function(event) {
                    var ret, target = this, related = event.relatedTarget, handleObj = event.handleObj;
                    return (!related || related !== target && !jQuery.contains(target, related)) && (event.type = handleObj.origType, ret = handleObj.handler.apply(this, arguments), event.type = fix), ret
                }}
        }), support.submitBubbles || (jQuery.event.special.submit = {setup: function() {
                return jQuery.nodeName(this, "form") ? !1 : void jQuery.event.add(this, "click._submit keypress._submit", function(e) {
                    var elem = e.target, form = jQuery.nodeName(elem, "input") || jQuery.nodeName(elem, "button") ? elem.form : void 0;
                    form && !jQuery._data(form, "submitBubbles") && (jQuery.event.add(form, "submit._submit", function(event) {
                        event._submit_bubble = !0
                    }), jQuery._data(form, "submitBubbles", !0))
                })
            },postDispatch: function(event) {
                event._submit_bubble && (delete event._submit_bubble, this.parentNode && !event.isTrigger && jQuery.event.simulate("submit", this.parentNode, event, !0))
            },teardown: function() {
                return jQuery.nodeName(this, "form") ? !1 : void jQuery.event.remove(this, "._submit")
            }}), support.changeBubbles || (jQuery.event.special.change = {setup: function() {
                return rformElems.test(this.nodeName) ? (("checkbox" === this.type || "radio" === this.type) && (jQuery.event.add(this, "propertychange._change", function(event) {
                    "checked" === event.originalEvent.propertyName && (this._just_changed = !0)
                }), jQuery.event.add(this, "click._change", function(event) {
                    this._just_changed && !event.isTrigger && (this._just_changed = !1), jQuery.event.simulate("change", this, event, !0)
                })), !1) : void jQuery.event.add(this, "beforeactivate._change", function(e) {
                    var elem = e.target;
                    rformElems.test(elem.nodeName) && !jQuery._data(elem, "changeBubbles") && (jQuery.event.add(elem, "change._change", function(event) {
                        !this.parentNode || event.isSimulated || event.isTrigger || jQuery.event.simulate("change", this.parentNode, event, !0)
                    }), jQuery._data(elem, "changeBubbles", !0))
                })
            },handle: function(event) {
                var elem = event.target;
                return this !== elem || event.isSimulated || event.isTrigger || "radio" !== elem.type && "checkbox" !== elem.type ? event.handleObj.handler.apply(this, arguments) : void 0
            },teardown: function() {
                return jQuery.event.remove(this, "._change"), !rformElems.test(this.nodeName)
            }}), support.focusinBubbles || jQuery.each({focus: "focusin",blur: "focusout"}, function(orig, fix) {
            var handler = function(event) {
                jQuery.event.simulate(fix, event.target, jQuery.event.fix(event), !0)
            };
            jQuery.event.special[fix] = {setup: function() {
                    var doc = this.ownerDocument || this, attaches = jQuery._data(doc, fix);
                    attaches || doc.addEventListener(orig, handler, !0), jQuery._data(doc, fix, (attaches || 0) + 1)
                },teardown: function() {
                    var doc = this.ownerDocument || this, attaches = jQuery._data(doc, fix) - 1;
                    attaches ? jQuery._data(doc, fix, attaches) : (doc.removeEventListener(orig, handler, !0), jQuery._removeData(doc, fix))
                }}
        }), jQuery.fn.extend({on: function(types, selector, data, fn, one) {
                var type, origFn;
                if ("object" == typeof types) {
                    "string" != typeof selector && (data = data || selector, selector = void 0);
                    for (type in types)
                        this.on(type, selector, data, types[type], one);
                    return this
                }
                if (null == data && null == fn ? (fn = selector, data = selector = void 0) : null == fn && ("string" == typeof selector ? (fn = data, data = void 0) : (fn = data, data = selector, selector = void 0)), fn === !1)
                    fn = returnFalse;
                else if (!fn)
                    return this;
                return 1 === one && (origFn = fn, fn = function(event) {
                    return jQuery().off(event), origFn.apply(this, arguments)
                }, fn.guid = origFn.guid || (origFn.guid = jQuery.guid++)), this.each(function() {
                    jQuery.event.add(this, types, fn, data, selector)
                })
            },one: function(types, selector, data, fn) {
                return this.on(types, selector, data, fn, 1)
            },off: function(types, selector, fn) {
                var handleObj, type;
                if (types && types.preventDefault && types.handleObj)
                    return handleObj = types.handleObj, jQuery(types.delegateTarget).off(handleObj.namespace ? handleObj.origType + "." + handleObj.namespace : handleObj.origType, handleObj.selector, handleObj.handler), this;
                if ("object" == typeof types) {
                    for (type in types)
                        this.off(type, selector, types[type]);
                    return this
                }
                return (selector === !1 || "function" == typeof selector) && (fn = selector, selector = void 0), fn === !1 && (fn = returnFalse), this.each(function() {
                    jQuery.event.remove(this, types, fn, selector)
                })
            },trigger: function(type, data) {
                return this.each(function() {
                    jQuery.event.trigger(type, data, this)
                })
            },triggerHandler: function(type, data) {
                var elem = this[0];
                return elem ? jQuery.event.trigger(type, data, elem, !0) : void 0
            }});
        var nodeNames = "abbr|article|aside|audio|bdi|canvas|data|datalist|details|figcaption|figure|footer|header|hgroup|mark|meter|nav|output|progress|section|summary|time|video", rinlinejQuery = / jQuery\d+="(?:null|\d+)"/g, rnoshimcache = new RegExp("<(?:" + nodeNames + ")[\\s/>]", "i"), rleadingWhitespace = /^\s+/, rxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/gi, rtagName = /<([\w:]+)/, rtbody = /<tbody/i, rhtml = /<|&#?\w+;/, rnoInnerhtml = /<(?:script|style|link)/i, rchecked = /checked\s*(?:[^=]|=\s*.checked.)/i, rscriptType = /^$|\/(?:java|ecma)script/i, rscriptTypeMasked = /^true\/(.*)/, rcleanScript = /^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g, wrapMap = {option: [1, "<select multiple='multiple'>", "</select>"],legend: [1, "<fieldset>", "</fieldset>"],area: [1, "<map>", "</map>"],param: [1, "<object>", "</object>"],thead: [1, "<table>", "</table>"],tr: [2, "<table><tbody>", "</tbody></table>"],col: [2, "<table><tbody></tbody><colgroup>", "</colgroup></table>"],td: [3, "<table><tbody><tr>", "</tr></tbody></table>"],_default: support.htmlSerialize ? [0, "", ""] : [1, "X<div>", "</div>"]}, safeFragment = createSafeFragment(document), fragmentDiv = safeFragment.appendChild(document.createElement("div"));
        wrapMap.optgroup = wrapMap.option, wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead, wrapMap.th = wrapMap.td, jQuery.extend({clone: function(elem, dataAndEvents, deepDataAndEvents) {
                var destElements, node, clone, i, srcElements, inPage = jQuery.contains(elem.ownerDocument, elem);
                if (support.html5Clone || jQuery.isXMLDoc(elem) || !rnoshimcache.test("<" + elem.nodeName + ">") ? clone = elem.cloneNode(!0) : (fragmentDiv.innerHTML = elem.outerHTML, fragmentDiv.removeChild(clone = fragmentDiv.firstChild)), !(support.noCloneEvent && support.noCloneChecked || 1 !== elem.nodeType && 11 !== elem.nodeType || jQuery.isXMLDoc(elem)))
                    for (destElements = getAll(clone), srcElements = getAll(elem), i = 0; null != (node = srcElements[i]); ++i)
                        destElements[i] && fixCloneNodeIssues(node, destElements[i]);
                if (dataAndEvents)
                    if (deepDataAndEvents)
                        for (srcElements = srcElements || getAll(elem), destElements = destElements || getAll(clone), i = 0; null != (node = srcElements[i]); i++)
                            cloneCopyEvent(node, destElements[i]);
                    else
                        cloneCopyEvent(elem, clone);
                return destElements = getAll(clone, "script"), destElements.length > 0 && setGlobalEval(destElements, !inPage && getAll(elem, "script")), destElements = srcElements = node = null, clone
            },buildFragment: function(elems, context, scripts, selection) {
                for (var j, elem, contains, tmp, tag, tbody, wrap, l = elems.length, safe = createSafeFragment(context), nodes = [], i = 0; l > i; i++)
                    if (elem = elems[i], elem || 0 === elem)
                        if ("object" === jQuery.type(elem))
                            jQuery.merge(nodes, elem.nodeType ? [elem] : elem);
                        else if (rhtml.test(elem)) {
                            for (tmp = tmp || safe.appendChild(context.createElement("div")), tag = (rtagName.exec(elem) || ["", ""])[1].toLowerCase(), wrap = wrapMap[tag] || wrapMap._default, tmp.innerHTML = wrap[1] + elem.replace(rxhtmlTag, "<$1></$2>") + wrap[2], j = wrap[0]; j--; )
                                tmp = tmp.lastChild;
                            if (!support.leadingWhitespace && rleadingWhitespace.test(elem) && nodes.push(context.createTextNode(rleadingWhitespace.exec(elem)[0])), !support.tbody)
                                for (elem = "table" !== tag || rtbody.test(elem) ? "<table>" !== wrap[1] || rtbody.test(elem) ? 0 : tmp : tmp.firstChild, j = elem && elem.childNodes.length; j--; )
                                    jQuery.nodeName(tbody = elem.childNodes[j], "tbody") && !tbody.childNodes.length && elem.removeChild(tbody);
                            for (jQuery.merge(nodes, tmp.childNodes), tmp.textContent = ""; tmp.firstChild; )
                                tmp.removeChild(tmp.firstChild);
                            tmp = safe.lastChild
                        } else
                            nodes.push(context.createTextNode(elem));
                for (tmp && safe.removeChild(tmp), support.appendChecked || jQuery.grep(getAll(nodes, "input"), fixDefaultChecked), i = 0; elem = nodes[i++]; )
                    if ((!selection || -1 === jQuery.inArray(elem, selection)) && (contains = jQuery.contains(elem.ownerDocument, elem), tmp = getAll(safe.appendChild(elem), "script"), contains && setGlobalEval(tmp), scripts))
                        for (j = 0; elem = tmp[j++]; )
                            rscriptType.test(elem.type || "") && scripts.push(elem);
                return tmp = null, safe
            },cleanData: function(elems, acceptData) {
                for (var elem, type, id, data, i = 0, internalKey = jQuery.expando, cache = jQuery.cache, deleteExpando = support.deleteExpando, special = jQuery.event.special; null != (elem = elems[i]); i++)
                    if ((acceptData || jQuery.acceptData(elem)) && (id = elem[internalKey], data = id && cache[id])) {
                        if (data.events)
                            for (type in data.events)
                                special[type] ? jQuery.event.remove(elem, type) : jQuery.removeEvent(elem, type, data.handle);
                        cache[id] && (delete cache[id], deleteExpando ? delete elem[internalKey] : typeof elem.removeAttribute !== strundefined ? elem.removeAttribute(internalKey) : elem[internalKey] = null, deletedIds.push(id))
                    }
            }}), jQuery.fn.extend({text: function(value) {
                return access(this, function(value) {
                    return void 0 === value ? jQuery.text(this) : this.empty().append((this[0] && this[0].ownerDocument || document).createTextNode(value))
                }, null, value, arguments.length)
            },append: function() {
                return this.domManip(arguments, function(elem) {
                    if (1 === this.nodeType || 11 === this.nodeType || 9 === this.nodeType) {
                        var target = manipulationTarget(this, elem);
                        target.appendChild(elem)
                    }
                })
            },prepend: function() {
                return this.domManip(arguments, function(elem) {
                    if (1 === this.nodeType || 11 === this.nodeType || 9 === this.nodeType) {
                        var target = manipulationTarget(this, elem);
                        target.insertBefore(elem, target.firstChild)
                    }
                })
            },before: function() {
                return this.domManip(arguments, function(elem) {
                    this.parentNode && this.parentNode.insertBefore(elem, this)
                })
            },after: function() {
                return this.domManip(arguments, function(elem) {
                    this.parentNode && this.parentNode.insertBefore(elem, this.nextSibling)
                })
            },remove: function(selector, keepData) {
                for (var elem, elems = selector ? jQuery.filter(selector, this) : this, i = 0; null != (elem = elems[i]); i++)
                    keepData || 1 !== elem.nodeType || jQuery.cleanData(getAll(elem)), elem.parentNode && (keepData && jQuery.contains(elem.ownerDocument, elem) && setGlobalEval(getAll(elem, "script")), elem.parentNode.removeChild(elem));
                return this
            },empty: function() {
                for (var elem, i = 0; null != (elem = this[i]); i++) {
                    for (1 === elem.nodeType && jQuery.cleanData(getAll(elem, !1)); elem.firstChild; )
                        elem.removeChild(elem.firstChild);
                    elem.options && jQuery.nodeName(elem, "select") && (elem.options.length = 0)
                }
                return this
            },clone: function(dataAndEvents, deepDataAndEvents) {
                return dataAndEvents = null == dataAndEvents ? !1 : dataAndEvents, deepDataAndEvents = null == deepDataAndEvents ? dataAndEvents : deepDataAndEvents, this.map(function() {
                    return jQuery.clone(this, dataAndEvents, deepDataAndEvents)
                })
            },html: function(value) {
                return access(this, function(value) {
                    var elem = this[0] || {}, i = 0, l = this.length;
                    if (void 0 === value)
                        return 1 === elem.nodeType ? elem.innerHTML.replace(rinlinejQuery, "") : void 0;
                    if ("string" == typeof value && !rnoInnerhtml.test(value) && (support.htmlSerialize || !rnoshimcache.test(value)) && (support.leadingWhitespace || !rleadingWhitespace.test(value)) && !wrapMap[(rtagName.exec(value) || ["", ""])[1].toLowerCase()]) {
                        value = value.replace(rxhtmlTag, "<$1></$2>");
                        try {
                            for (; l > i; i++)
                                elem = this[i] || {}, 1 === elem.nodeType && (jQuery.cleanData(getAll(elem, !1)), elem.innerHTML = value);
                            elem = 0
                        } catch (e) {
                        }
                    }
                    elem && this.empty().append(value)
                }, null, value, arguments.length)
            },replaceWith: function() {
                var arg = arguments[0];
                return this.domManip(arguments, function(elem) {
                    arg = this.parentNode, jQuery.cleanData(getAll(this)), arg && arg.replaceChild(elem, this)
                }), arg && (arg.length || arg.nodeType) ? this : this.remove()
            },detach: function(selector) {
                return this.remove(selector, !0)
            },domManip: function(args, callback) {
                args = concat.apply([], args);
                var first, node, hasScripts, scripts, doc, fragment, i = 0, l = this.length, set = this, iNoClone = l - 1, value = args[0], isFunction = jQuery.isFunction(value);
                if (isFunction || l > 1 && "string" == typeof value && !support.checkClone && rchecked.test(value))
                    return this.each(function(index) {
                        var self = set.eq(index);
                        isFunction && (args[0] = value.call(this, index, self.html())), self.domManip(args, callback)
                    });
                if (l && (fragment = jQuery.buildFragment(args, this[0].ownerDocument, !1, this), first = fragment.firstChild, 1 === fragment.childNodes.length && (fragment = first), first)) {
                    for (scripts = jQuery.map(getAll(fragment, "script"), disableScript), hasScripts = scripts.length; l > i; i++)
                        node = fragment, i !== iNoClone && (node = jQuery.clone(node, !0, !0), hasScripts && jQuery.merge(scripts, getAll(node, "script"))), callback.call(this[i], node, i);
                    if (hasScripts)
                        for (doc = scripts[scripts.length - 1].ownerDocument, jQuery.map(scripts, restoreScript), i = 0; hasScripts > i; i++)
                            node = scripts[i], rscriptType.test(node.type || "") && !jQuery._data(node, "globalEval") && jQuery.contains(doc, node) && (node.src ? jQuery._evalUrl && jQuery._evalUrl(node.src) : jQuery.globalEval((node.text || node.textContent || node.innerHTML || "").replace(rcleanScript, "")));
                    fragment = first = null
                }
                return this
            }}), jQuery.each({appendTo: "append",prependTo: "prepend",insertBefore: "before",insertAfter: "after",replaceAll: "replaceWith"}, function(name, original) {
            jQuery.fn[name] = function(selector) {
                for (var elems, i = 0, ret = [], insert = jQuery(selector), last = insert.length - 1; last >= i; i++)
                    elems = i === last ? this : this.clone(!0), jQuery(insert[i])[original](elems), push.apply(ret, elems.get());
                return this.pushStack(ret)
            }
        });
        var iframe, elemdisplay = {};
        !function() {
            var shrinkWrapBlocksVal;
            support.shrinkWrapBlocks = function() {
                if (null != shrinkWrapBlocksVal)
                    return shrinkWrapBlocksVal;
                shrinkWrapBlocksVal = !1;
                var div, body, container;
                return body = document.getElementsByTagName("body")[0], body && body.style ? (div = document.createElement("div"), container = document.createElement("div"), container.style.cssText = "position:absolute;border:0;width:0;height:0;top:0;left:-9999px", body.appendChild(container).appendChild(div), typeof div.style.zoom !== strundefined && (div.style.cssText = "-webkit-box-sizing:content-box;-moz-box-sizing:content-box;box-sizing:content-box;display:block;margin:0;border:0;padding:1px;width:1px;zoom:1", div.appendChild(document.createElement("div")).style.width = "5px", shrinkWrapBlocksVal = 3 !== div.offsetWidth), body.removeChild(container), shrinkWrapBlocksVal) : void 0
            }
        }();
        var getStyles, curCSS, rmargin = /^margin/, rnumnonpx = new RegExp("^(" + pnum + ")(?!px)[a-z%]+$", "i"), rposition = /^(top|right|bottom|left)$/;
        window.getComputedStyle ? (getStyles = function(elem) {
            return elem.ownerDocument.defaultView.getComputedStyle(elem, null)
        }, curCSS = function(elem, name, computed) {
            var width, minWidth, maxWidth, ret, style = elem.style;
            return computed = computed || getStyles(elem), ret = computed ? computed.getPropertyValue(name) || computed[name] : void 0, computed && ("" !== ret || jQuery.contains(elem.ownerDocument, elem) || (ret = jQuery.style(elem, name)), rnumnonpx.test(ret) && rmargin.test(name) && (width = style.width, minWidth = style.minWidth, maxWidth = style.maxWidth, style.minWidth = style.maxWidth = style.width = ret, ret = computed.width, style.width = width, style.minWidth = minWidth, style.maxWidth = maxWidth)), void 0 === ret ? ret : ret + ""
        }) : document.documentElement.currentStyle && (getStyles = function(elem) {
            return elem.currentStyle
        }, curCSS = function(elem, name, computed) {
            var left, rs, rsLeft, ret, style = elem.style;
            return computed = computed || getStyles(elem), ret = computed ? computed[name] : void 0, null == ret && style && style[name] && (ret = style[name]), rnumnonpx.test(ret) && !rposition.test(name) && (left = style.left, rs = elem.runtimeStyle, rsLeft = rs && rs.left, rsLeft && (rs.left = elem.currentStyle.left), style.left = "fontSize" === name ? "1em" : ret, ret = style.pixelLeft + "px", style.left = left, rsLeft && (rs.left = rsLeft)), void 0 === ret ? ret : ret + "" || "auto"
        }), function() {
            function computeStyleTests() {
                var div, body, container, contents;
                body = document.getElementsByTagName("body")[0], body && body.style && (div = document.createElement("div"), container = document.createElement("div"), container.style.cssText = "position:absolute;border:0;width:0;height:0;top:0;left:-9999px", body.appendChild(container).appendChild(div), div.style.cssText = "-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;display:block;margin-top:1%;top:1%;border:1px;padding:1px;width:4px;position:absolute", pixelPositionVal = boxSizingReliableVal = !1, reliableMarginRightVal = !0, window.getComputedStyle && (pixelPositionVal = "1%" !== (window.getComputedStyle(div, null) || {}).top, boxSizingReliableVal = "4px" === (window.getComputedStyle(div, null) || {width: "4px"}).width, contents = div.appendChild(document.createElement("div")), contents.style.cssText = div.style.cssText = "-webkit-box-sizing:content-box;-moz-box-sizing:content-box;box-sizing:content-box;display:block;margin:0;border:0;padding:0", contents.style.marginRight = contents.style.width = "0", div.style.width = "1px", reliableMarginRightVal = !parseFloat((window.getComputedStyle(contents, null) || {}).marginRight)), div.innerHTML = "<table><tr><td></td><td>t</td></tr></table>", contents = div.getElementsByTagName("td"), contents[0].style.cssText = "margin:0;border:0;padding:0;display:none", reliableHiddenOffsetsVal = 0 === contents[0].offsetHeight, reliableHiddenOffsetsVal && (contents[0].style.display = "", contents[1].style.display = "none", reliableHiddenOffsetsVal = 0 === contents[0].offsetHeight), body.removeChild(container))
            }
            var div, style, a, pixelPositionVal, boxSizingReliableVal, reliableHiddenOffsetsVal, reliableMarginRightVal;
            div = document.createElement("div"), div.innerHTML = "  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>", a = div.getElementsByTagName("a")[0], style = a && a.style, style && (style.cssText = "float:left;opacity:.5", support.opacity = "0.5" === style.opacity, support.cssFloat = !!style.cssFloat, div.style.backgroundClip = "content-box", div.cloneNode(!0).style.backgroundClip = "", support.clearCloneStyle = "content-box" === div.style.backgroundClip, support.boxSizing = "" === style.boxSizing || "" === style.MozBoxSizing || "" === style.WebkitBoxSizing, jQuery.extend(support, {reliableHiddenOffsets: function() {
                    return null == reliableHiddenOffsetsVal && computeStyleTests(), reliableHiddenOffsetsVal
                },boxSizingReliable: function() {
                    return null == boxSizingReliableVal && computeStyleTests(), boxSizingReliableVal
                },pixelPosition: function() {
                    return null == pixelPositionVal && computeStyleTests(), pixelPositionVal
                },reliableMarginRight: function() {
                    return null == reliableMarginRightVal && computeStyleTests(), reliableMarginRightVal
                }}))
        }(), jQuery.swap = function(elem, options, callback, args) {
            var ret, name, old = {};
            for (name in options)
                old[name] = elem.style[name], elem.style[name] = options[name];
            ret = callback.apply(elem, args || []);
            for (name in options)
                elem.style[name] = old[name];
            return ret
        };
        var ralpha = /alpha\([^)]*\)/i, ropacity = /opacity\s*=\s*([^)]*)/, rdisplayswap = /^(none|table(?!-c[ea]).+)/, rnumsplit = new RegExp("^(" + pnum + ")(.*)$", "i"), rrelNum = new RegExp("^([+-])=(" + pnum + ")", "i"), cssShow = {position: "absolute",visibility: "hidden",display: "block"}, cssNormalTransform = {letterSpacing: "0",fontWeight: "400"}, cssPrefixes = ["Webkit", "O", "Moz", "ms"];
        jQuery.extend({cssHooks: {opacity: {get: function(elem, computed) {
                        if (computed) {
                            var ret = curCSS(elem, "opacity");
                            return "" === ret ? "1" : ret
                        }
                    }}},cssNumber: {columnCount: !0,fillOpacity: !0,flexGrow: !0,flexShrink: !0,fontWeight: !0,lineHeight: !0,opacity: !0,order: !0,orphans: !0,widows: !0,zIndex: !0,zoom: !0},cssProps: {"float": support.cssFloat ? "cssFloat" : "styleFloat"},style: function(elem, name, value, extra) {
                if (elem && 3 !== elem.nodeType && 8 !== elem.nodeType && elem.style) {
                    var ret, type, hooks, origName = jQuery.camelCase(name), style = elem.style;
                    if (name = jQuery.cssProps[origName] || (jQuery.cssProps[origName] = vendorPropName(style, origName)), hooks = jQuery.cssHooks[name] || jQuery.cssHooks[origName], void 0 === value)
                        return hooks && "get" in hooks && void 0 !== (ret = hooks.get(elem, !1, extra)) ? ret : style[name];
                    if (type = typeof value, "string" === type && (ret = rrelNum.exec(value)) && (value = (ret[1] + 1) * ret[2] + parseFloat(jQuery.css(elem, name)), type = "number"), null != value && value === value && ("number" !== type || jQuery.cssNumber[origName] || (value += "px"), support.clearCloneStyle || "" !== value || 0 !== name.indexOf("background") || (style[name] = "inherit"), !(hooks && "set" in hooks && void 0 === (value = hooks.set(elem, value, extra)))))
                        try {
                            style[name] = value
                        } catch (e) {
                        }
                }
            },css: function(elem, name, extra, styles) {
                var num, val, hooks, origName = jQuery.camelCase(name);
                return name = jQuery.cssProps[origName] || (jQuery.cssProps[origName] = vendorPropName(elem.style, origName)), hooks = jQuery.cssHooks[name] || jQuery.cssHooks[origName], hooks && "get" in hooks && (val = hooks.get(elem, !0, extra)), void 0 === val && (val = curCSS(elem, name, styles)), "normal" === val && name in cssNormalTransform && (val = cssNormalTransform[name]), "" === extra || extra ? (num = parseFloat(val), extra === !0 || jQuery.isNumeric(num) ? num || 0 : val) : val
            }}), jQuery.each(["height", "width"], function(i, name) {
            jQuery.cssHooks[name] = {get: function(elem, computed, extra) {
                    return computed ? rdisplayswap.test(jQuery.css(elem, "display")) && 0 === elem.offsetWidth ? jQuery.swap(elem, cssShow, function() {
                        return getWidthOrHeight(elem, name, extra)
                    }) : getWidthOrHeight(elem, name, extra) : void 0
                },set: function(elem, value, extra) {
                    var styles = extra && getStyles(elem);
                    return setPositiveNumber(elem, value, extra ? augmentWidthOrHeight(elem, name, extra, support.boxSizing && "border-box" === jQuery.css(elem, "boxSizing", !1, styles), styles) : 0)
                }}
        }), support.opacity || (jQuery.cssHooks.opacity = {get: function(elem, computed) {
                return ropacity.test((computed && elem.currentStyle ? elem.currentStyle.filter : elem.style.filter) || "") ? .01 * parseFloat(RegExp.$1) + "" : computed ? "1" : ""
            },set: function(elem, value) {
                var style = elem.style, currentStyle = elem.currentStyle, opacity = jQuery.isNumeric(value) ? "alpha(opacity=" + 100 * value + ")" : "", filter = currentStyle && currentStyle.filter || style.filter || "";
                style.zoom = 1, (value >= 1 || "" === value) && "" === jQuery.trim(filter.replace(ralpha, "")) && style.removeAttribute && (style.removeAttribute("filter"), "" === value || currentStyle && !currentStyle.filter) || (style.filter = ralpha.test(filter) ? filter.replace(ralpha, opacity) : filter + " " + opacity)
            }}), jQuery.cssHooks.marginRight = addGetHookIf(support.reliableMarginRight, function(elem, computed) {
            return computed ? jQuery.swap(elem, {display: "inline-block"}, curCSS, [elem, "marginRight"]) : void 0
        }), jQuery.each({margin: "",padding: "",border: "Width"}, function(prefix, suffix) {
            jQuery.cssHooks[prefix + suffix] = {expand: function(value) {
                    for (var i = 0, expanded = {}, parts = "string" == typeof value ? value.split(" ") : [value]; 4 > i; i++)
                        expanded[prefix + cssExpand[i] + suffix] = parts[i] || parts[i - 2] || parts[0];
                    return expanded
                }}, rmargin.test(prefix) || (jQuery.cssHooks[prefix + suffix].set = setPositiveNumber)
        }), jQuery.fn.extend({css: function(name, value) {
                return access(this, function(elem, name, value) {
                    var styles, len, map = {}, i = 0;
                    if (jQuery.isArray(name)) {
                        for (styles = getStyles(elem), len = name.length; len > i; i++)
                            map[name[i]] = jQuery.css(elem, name[i], !1, styles);
                        return map
                    }
                    return void 0 !== value ? jQuery.style(elem, name, value) : jQuery.css(elem, name)
                }, name, value, arguments.length > 1)
            },show: function() {
                return showHide(this, !0)
            },hide: function() {
                return showHide(this)
            },toggle: function(state) {
                return "boolean" == typeof state ? state ? this.show() : this.hide() : this.each(function() {
                    isHidden(this) ? jQuery(this).show() : jQuery(this).hide()
                })
            }}), jQuery.Tween = Tween, Tween.prototype = {constructor: Tween,init: function(elem, options, prop, end, easing, unit) {
                this.elem = elem, this.prop = prop, this.easing = easing || "swing", this.options = options, this.start = this.now = this.cur(), this.end = end, this.unit = unit || (jQuery.cssNumber[prop] ? "" : "px")
            },cur: function() {
                var hooks = Tween.propHooks[this.prop];
                return hooks && hooks.get ? hooks.get(this) : Tween.propHooks._default.get(this)
            },run: function(percent) {
                var eased, hooks = Tween.propHooks[this.prop];
                return this.options.duration ? this.pos = eased = jQuery.easing[this.easing](percent, this.options.duration * percent, 0, 1, this.options.duration) : this.pos = eased = percent, this.now = (this.end - this.start) * eased + this.start, this.options.step && this.options.step.call(this.elem, this.now, this), hooks && hooks.set ? hooks.set(this) : Tween.propHooks._default.set(this), this
            }}, Tween.prototype.init.prototype = Tween.prototype, Tween.propHooks = {_default: {get: function(tween) {
                    var result;
                    return null == tween.elem[tween.prop] || tween.elem.style && null != tween.elem.style[tween.prop] ? (result = jQuery.css(tween.elem, tween.prop, ""), result && "auto" !== result ? result : 0) : tween.elem[tween.prop]
                },set: function(tween) {
                    jQuery.fx.step[tween.prop] ? jQuery.fx.step[tween.prop](tween) : tween.elem.style && (null != tween.elem.style[jQuery.cssProps[tween.prop]] || jQuery.cssHooks[tween.prop]) ? jQuery.style(tween.elem, tween.prop, tween.now + tween.unit) : tween.elem[tween.prop] = tween.now
                }}}, Tween.propHooks.scrollTop = Tween.propHooks.scrollLeft = {set: function(tween) {
                tween.elem.nodeType && tween.elem.parentNode && (tween.elem[tween.prop] = tween.now)
            }}, jQuery.easing = {linear: function(p) {
                return p
            },swing: function(p) {
                return .5 - Math.cos(p * Math.PI) / 2
            }}, jQuery.fx = Tween.prototype.init, jQuery.fx.step = {};
        var fxNow, timerId, rfxtypes = /^(?:toggle|show|hide)$/, rfxnum = new RegExp("^(?:([+-])=|)(" + pnum + ")([a-z%]*)$", "i"), rrun = /queueHooks$/, animationPrefilters = [defaultPrefilter], tweeners = {"*": [function(prop, value) {
                    var tween = this.createTween(prop, value), target = tween.cur(), parts = rfxnum.exec(value), unit = parts && parts[3] || (jQuery.cssNumber[prop] ? "" : "px"), start = (jQuery.cssNumber[prop] || "px" !== unit && +target) && rfxnum.exec(jQuery.css(tween.elem, prop)), scale = 1, maxIterations = 20;
                    if (start && start[3] !== unit) {
                        unit = unit || start[3], parts = parts || [], start = +target || 1;
                        do
                            scale = scale || ".5", start /= scale, jQuery.style(tween.elem, prop, start + unit);
                        while (scale !== (scale = tween.cur() / target) && 1 !== scale && --maxIterations)
                    }
                    return parts && (start = tween.start = +start || +target || 0, tween.unit = unit, tween.end = parts[1] ? start + (parts[1] + 1) * parts[2] : +parts[2]), tween
                }]};
        jQuery.Animation = jQuery.extend(Animation, {tweener: function(props, callback) {
                jQuery.isFunction(props) ? (callback = props, props = ["*"]) : props = props.split(" ");
                for (var prop, index = 0, length = props.length; length > index; index++)
                    prop = props[index], tweeners[prop] = tweeners[prop] || [], tweeners[prop].unshift(callback)
            },prefilter: function(callback, prepend) {
                prepend ? animationPrefilters.unshift(callback) : animationPrefilters.push(callback)
            }}), jQuery.speed = function(speed, easing, fn) {
            var opt = speed && "object" == typeof speed ? jQuery.extend({}, speed) : {complete: fn || !fn && easing || jQuery.isFunction(speed) && speed,duration: speed,easing: fn && easing || easing && !jQuery.isFunction(easing) && easing};
            return opt.duration = jQuery.fx.off ? 0 : "number" == typeof opt.duration ? opt.duration : opt.duration in jQuery.fx.speeds ? jQuery.fx.speeds[opt.duration] : jQuery.fx.speeds._default, (null == opt.queue || opt.queue === !0) && (opt.queue = "fx"), opt.old = opt.complete, opt.complete = function() {
                jQuery.isFunction(opt.old) && opt.old.call(this), opt.queue && jQuery.dequeue(this, opt.queue)
            }, opt
        }, jQuery.fn.extend({fadeTo: function(speed, to, easing, callback) {
                return this.filter(isHidden).css("opacity", 0).show().end().animate({opacity: to}, speed, easing, callback)
            },animate: function(prop, speed, easing, callback) {
                var empty = jQuery.isEmptyObject(prop), optall = jQuery.speed(speed, easing, callback), doAnimation = function() {
                    var anim = Animation(this, jQuery.extend({}, prop), optall);
                    (empty || jQuery._data(this, "finish")) && anim.stop(!0)
                };
                return doAnimation.finish = doAnimation, empty || optall.queue === !1 ? this.each(doAnimation) : this.queue(optall.queue, doAnimation)
            },stop: function(type, clearQueue, gotoEnd) {
                var stopQueue = function(hooks) {
                    var stop = hooks.stop;
                    delete hooks.stop, stop(gotoEnd)
                };
                return "string" != typeof type && (gotoEnd = clearQueue, clearQueue = type, type = void 0), clearQueue && type !== !1 && this.queue(type || "fx", []), this.each(function() {
                    var dequeue = !0, index = null != type && type + "queueHooks", timers = jQuery.timers, data = jQuery._data(this);
                    if (index)
                        data[index] && data[index].stop && stopQueue(data[index]);
                    else
                        for (index in data)
                            data[index] && data[index].stop && rrun.test(index) && stopQueue(data[index]);
                    for (index = timers.length; index--; )
                        timers[index].elem !== this || null != type && timers[index].queue !== type || (timers[index].anim.stop(gotoEnd), dequeue = !1, timers.splice(index, 1));
                    (dequeue || !gotoEnd) && jQuery.dequeue(this, type)
                })
            },finish: function(type) {
                return type !== !1 && (type = type || "fx"), this.each(function() {
                    var index, data = jQuery._data(this), queue = data[type + "queue"], hooks = data[type + "queueHooks"], timers = jQuery.timers, length = queue ? queue.length : 0;
                    for (data.finish = !0, jQuery.queue(this, type, []), hooks && hooks.stop && hooks.stop.call(this, !0), index = timers.length; index--; )
                        timers[index].elem === this && timers[index].queue === type && (timers[index].anim.stop(!0), timers.splice(index, 1));
                    for (index = 0; length > index; index++)
                        queue[index] && queue[index].finish && queue[index].finish.call(this);
                    delete data.finish
                })
            }}), jQuery.each(["toggle", "show", "hide"], function(i, name) {
            var cssFn = jQuery.fn[name];
            jQuery.fn[name] = function(speed, easing, callback) {
                return null == speed || "boolean" == typeof speed ? cssFn.apply(this, arguments) : this.animate(genFx(name, !0), speed, easing, callback)
            }
        }), jQuery.each({slideDown: genFx("show"),slideUp: genFx("hide"),slideToggle: genFx("toggle"),fadeIn: {opacity: "show"},fadeOut: {opacity: "hide"},fadeToggle: {opacity: "toggle"}}, function(name, props) {
            jQuery.fn[name] = function(speed, easing, callback) {
                return this.animate(props, speed, easing, callback)
            }
        }), jQuery.timers = [], jQuery.fx.tick = function() {
            var timer, timers = jQuery.timers, i = 0;
            for (fxNow = jQuery.now(); i < timers.length; i++)
                timer = timers[i], timer() || timers[i] !== timer || timers.splice(i--, 1);
            timers.length || jQuery.fx.stop(), fxNow = void 0
        }, jQuery.fx.timer = function(timer) {
            jQuery.timers.push(timer), timer() ? jQuery.fx.start() : jQuery.timers.pop()
        }, jQuery.fx.interval = 13, jQuery.fx.start = function() {
            timerId || (timerId = setInterval(jQuery.fx.tick, jQuery.fx.interval))
        }, jQuery.fx.stop = function() {
            clearInterval(timerId), timerId = null
        }, jQuery.fx.speeds = {slow: 600,fast: 200,_default: 400}, jQuery.fn.delay = function(time, type) {
            return time = jQuery.fx ? jQuery.fx.speeds[time] || time : time, type = type || "fx", this.queue(type, function(next, hooks) {
                var timeout = setTimeout(next, time);
                hooks.stop = function() {
                    clearTimeout(timeout)
                }
            })
        }, function() {
            var input, div, select, a, opt;
            div = document.createElement("div"), div.setAttribute("className", "t"), div.innerHTML = "  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>", a = div.getElementsByTagName("a")[0], select = document.createElement("select"), opt = select.appendChild(document.createElement("option")), input = div.getElementsByTagName("input")[0], a.style.cssText = "top:1px", support.getSetAttribute = "t" !== div.className, support.style = /top/.test(a.getAttribute("style")), support.hrefNormalized = "/a" === a.getAttribute("href"), support.checkOn = !!input.value, support.optSelected = opt.selected, support.enctype = !!document.createElement("form").enctype, select.disabled = !0, support.optDisabled = !opt.disabled, input = document.createElement("input"), input.setAttribute("value", ""), support.input = "" === input.getAttribute("value"), input.value = "t", input.setAttribute("type", "radio"), support.radioValue = "t" === input.value
        }();
        var rreturn = /\r/g;
        jQuery.fn.extend({val: function(value) {
                var hooks, ret, isFunction, elem = this[0];
                {
                    if (arguments.length)
                        return isFunction = jQuery.isFunction(value), this.each(function(i) {
                            var val;
                            1 === this.nodeType && (val = isFunction ? value.call(this, i, jQuery(this).val()) : value, null == val ? val = "" : "number" == typeof val ? val += "" : jQuery.isArray(val) && (val = jQuery.map(val, function(value) {
                                return null == value ? "" : value + ""
                            })), hooks = jQuery.valHooks[this.type] || jQuery.valHooks[this.nodeName.toLowerCase()], hooks && "set" in hooks && void 0 !== hooks.set(this, val, "value") || (this.value = val))
                        });
                    if (elem)
                        return hooks = jQuery.valHooks[elem.type] || jQuery.valHooks[elem.nodeName.toLowerCase()], hooks && "get" in hooks && void 0 !== (ret = hooks.get(elem, "value")) ? ret : (ret = elem.value, "string" == typeof ret ? ret.replace(rreturn, "") : null == ret ? "" : ret)
                }
            }}), jQuery.extend({valHooks: {option: {get: function(elem) {
                        var val = jQuery.find.attr(elem, "value");
                        return null != val ? val : jQuery.trim(jQuery.text(elem))
                    }},select: {get: function(elem) {
                        for (var value, option, options = elem.options, index = elem.selectedIndex, one = "select-one" === elem.type || 0 > index, values = one ? null : [], max = one ? index + 1 : options.length, i = 0 > index ? max : one ? index : 0; max > i; i++)
                            if (option = options[i], (option.selected || i === index) && (support.optDisabled ? !option.disabled : null === option.getAttribute("disabled")) && (!option.parentNode.disabled || !jQuery.nodeName(option.parentNode, "optgroup"))) {
                                if (value = jQuery(option).val(), one)
                                    return value;
                                values.push(value)
                            }
                        return values
                    },set: function(elem, value) {
                        for (var optionSet, option, options = elem.options, values = jQuery.makeArray(value), i = options.length; i--; )
                            if (option = options[i], jQuery.inArray(jQuery.valHooks.option.get(option), values) >= 0)
                                try {
                                    option.selected = optionSet = !0
                                } catch (_) {
                                    option.scrollHeight
                                }
                            else
                                option.selected = !1;
                        return optionSet || (elem.selectedIndex = -1), options
                    }}}}), jQuery.each(["radio", "checkbox"], function() {
            jQuery.valHooks[this] = {set: function(elem, value) {
                    return jQuery.isArray(value) ? elem.checked = jQuery.inArray(jQuery(elem).val(), value) >= 0 : void 0
                }}, support.checkOn || (jQuery.valHooks[this].get = function(elem) {
                return null === elem.getAttribute("value") ? "on" : elem.value
            })
        });
        var nodeHook, boolHook, attrHandle = jQuery.expr.attrHandle, ruseDefault = /^(?:checked|selected)$/i, getSetAttribute = support.getSetAttribute, getSetInput = support.input;
        jQuery.fn.extend({attr: function(name, value) {
                return access(this, jQuery.attr, name, value, arguments.length > 1)
            },removeAttr: function(name) {
                return this.each(function() {
                    jQuery.removeAttr(this, name)
                })
            }}), jQuery.extend({attr: function(elem, name, value) {
                var hooks, ret, nType = elem.nodeType;
                if (elem && 3 !== nType && 8 !== nType && 2 !== nType)
                    return typeof elem.getAttribute === strundefined ? jQuery.prop(elem, name, value) : (1 === nType && jQuery.isXMLDoc(elem) || (name = name.toLowerCase(), hooks = jQuery.attrHooks[name] || (jQuery.expr.match.bool.test(name) ? boolHook : nodeHook)), void 0 === value ? hooks && "get" in hooks && null !== (ret = hooks.get(elem, name)) ? ret : (ret = jQuery.find.attr(elem, name), null == ret ? void 0 : ret) : null !== value ? hooks && "set" in hooks && void 0 !== (ret = hooks.set(elem, value, name)) ? ret : (elem.setAttribute(name, value + ""), value) : void jQuery.removeAttr(elem, name))
            },removeAttr: function(elem, value) {
                var name, propName, i = 0, attrNames = value && value.match(rnotwhite);
                if (attrNames && 1 === elem.nodeType)
                    for (; name = attrNames[i++]; )
                        propName = jQuery.propFix[name] || name, jQuery.expr.match.bool.test(name) ? getSetInput && getSetAttribute || !ruseDefault.test(name) ? elem[propName] = !1 : elem[jQuery.camelCase("default-" + name)] = elem[propName] = !1 : jQuery.attr(elem, name, ""), elem.removeAttribute(getSetAttribute ? name : propName)
            },attrHooks: {type: {set: function(elem, value) {
                        if (!support.radioValue && "radio" === value && jQuery.nodeName(elem, "input")) {
                            var val = elem.value;
                            return elem.setAttribute("type", value), val && (elem.value = val), value
                        }
                    }}}}), boolHook = {set: function(elem, value, name) {
                return value === !1 ? jQuery.removeAttr(elem, name) : getSetInput && getSetAttribute || !ruseDefault.test(name) ? elem.setAttribute(!getSetAttribute && jQuery.propFix[name] || name, name) : elem[jQuery.camelCase("default-" + name)] = elem[name] = !0, name
            }}, jQuery.each(jQuery.expr.match.bool.source.match(/\w+/g), function(i, name) {
            var getter = attrHandle[name] || jQuery.find.attr;
            attrHandle[name] = getSetInput && getSetAttribute || !ruseDefault.test(name) ? function(elem, name, isXML) {
                var ret, handle;
                return isXML || (handle = attrHandle[name], attrHandle[name] = ret, ret = null != getter(elem, name, isXML) ? name.toLowerCase() : null, attrHandle[name] = handle), ret
            } : function(elem, name, isXML) {
                return isXML ? void 0 : elem[jQuery.camelCase("default-" + name)] ? name.toLowerCase() : null
            }
        }), getSetInput && getSetAttribute || (jQuery.attrHooks.value = {set: function(elem, value, name) {
                return jQuery.nodeName(elem, "input") ? void (elem.defaultValue = value) : nodeHook && nodeHook.set(elem, value, name)
            }}), getSetAttribute || (nodeHook = {set: function(elem, value, name) {
                var ret = elem.getAttributeNode(name);
                return ret || elem.setAttributeNode(ret = elem.ownerDocument.createAttribute(name)), ret.value = value += "", "value" === name || value === elem.getAttribute(name) ? value : void 0
            }}, attrHandle.id = attrHandle.name = attrHandle.coords = function(elem, name, isXML) {
            var ret;
            return isXML ? void 0 : (ret = elem.getAttributeNode(name)) && "" !== ret.value ? ret.value : null
        }, jQuery.valHooks.button = {get: function(elem, name) {
                var ret = elem.getAttributeNode(name);
                return ret && ret.specified ? ret.value : void 0
            },set: nodeHook.set}, jQuery.attrHooks.contenteditable = {set: function(elem, value, name) {
                nodeHook.set(elem, "" === value ? !1 : value, name)
            }}, jQuery.each(["width", "height"], function(i, name) {
            jQuery.attrHooks[name] = {set: function(elem, value) {
                    return "" === value ? (elem.setAttribute(name, "auto"), value) : void 0
                }}
        })), support.style || (jQuery.attrHooks.style = {get: function(elem) {
                return elem.style.cssText || void 0
            },set: function(elem, value) {
                return elem.style.cssText = value + ""
            }});
        var rfocusable = /^(?:input|select|textarea|button|object)$/i, rclickable = /^(?:a|area)$/i;
        jQuery.fn.extend({prop: function(name, value) {
                return access(this, jQuery.prop, name, value, arguments.length > 1)
            },removeProp: function(name) {
                return name = jQuery.propFix[name] || name, this.each(function() {
                    try {
                        this[name] = void 0, delete this[name]
                    } catch (e) {
                    }
                })
            }}), jQuery.extend({propFix: {"for": "htmlFor","class": "className"},prop: function(elem, name, value) {
                var ret, hooks, notxml, nType = elem.nodeType;
                if (elem && 3 !== nType && 8 !== nType && 2 !== nType)
                    return notxml = 1 !== nType || !jQuery.isXMLDoc(elem), notxml && (name = jQuery.propFix[name] || name, hooks = jQuery.propHooks[name]), void 0 !== value ? hooks && "set" in hooks && void 0 !== (ret = hooks.set(elem, value, name)) ? ret : elem[name] = value : hooks && "get" in hooks && null !== (ret = hooks.get(elem, name)) ? ret : elem[name]
            },propHooks: {tabIndex: {get: function(elem) {
                        var tabindex = jQuery.find.attr(elem, "tabindex");
                        return tabindex ? parseInt(tabindex, 10) : rfocusable.test(elem.nodeName) || rclickable.test(elem.nodeName) && elem.href ? 0 : -1
                    }}}}), support.hrefNormalized || jQuery.each(["href", "src"], function(i, name) {
            jQuery.propHooks[name] = {get: function(elem) {
                    return elem.getAttribute(name, 4)
                }}
        }), support.optSelected || (jQuery.propHooks.selected = {get: function(elem) {
                var parent = elem.parentNode;
                return parent && (parent.selectedIndex, parent.parentNode && parent.parentNode.selectedIndex), null
            }}), jQuery.each(["tabIndex", "readOnly", "maxLength", "cellSpacing", "cellPadding", "rowSpan", "colSpan", "useMap", "frameBorder", "contentEditable"], function() {
            jQuery.propFix[this.toLowerCase()] = this
        }), support.enctype || (jQuery.propFix.enctype = "encoding");
        var rclass = /[\t\r\n\f]/g;
        jQuery.fn.extend({addClass: function(value) {
                var classes, elem, cur, clazz, j, finalValue, i = 0, len = this.length, proceed = "string" == typeof value && value;
                if (jQuery.isFunction(value))
                    return this.each(function(j) {
                        jQuery(this).addClass(value.call(this, j, this.className))
                    });
                if (proceed)
                    for (classes = (value || "").match(rnotwhite) || []; len > i; i++)
                        if (elem = this[i], cur = 1 === elem.nodeType && (elem.className ? (" " + elem.className + " ").replace(rclass, " ") : " ")) {
                            for (j = 0; clazz = classes[j++]; )
                                cur.indexOf(" " + clazz + " ") < 0 && (cur += clazz + " ");
                            finalValue = jQuery.trim(cur), elem.className !== finalValue && (elem.className = finalValue)
                        }
                return this
            },removeClass: function(value) {
                var classes, elem, cur, clazz, j, finalValue, i = 0, len = this.length, proceed = 0 === arguments.length || "string" == typeof value && value;
                if (jQuery.isFunction(value))
                    return this.each(function(j) {
                        jQuery(this).removeClass(value.call(this, j, this.className))
                    });
                if (proceed)
                    for (classes = (value || "").match(rnotwhite) || []; len > i; i++)
                        if (elem = this[i], cur = 1 === elem.nodeType && (elem.className ? (" " + elem.className + " ").replace(rclass, " ") : "")) {
                            for (j = 0; clazz = classes[j++]; )
                                for (; cur.indexOf(" " + clazz + " ") >= 0; )
                                    cur = cur.replace(" " + clazz + " ", " ");
                            finalValue = value ? jQuery.trim(cur) : "", elem.className !== finalValue && (elem.className = finalValue)
                        }
                return this
            },toggleClass: function(value, stateVal) {
                var type = typeof value;
                return "boolean" == typeof stateVal && "string" === type ? stateVal ? this.addClass(value) : this.removeClass(value) : jQuery.isFunction(value) ? this.each(function(i) {
                    jQuery(this).toggleClass(value.call(this, i, this.className, stateVal), stateVal)
                }) : this.each(function() {
                    if ("string" === type)
                        for (var className, i = 0, self = jQuery(this), classNames = value.match(rnotwhite) || []; className = classNames[i++]; )
                            self.hasClass(className) ? self.removeClass(className) : self.addClass(className);
                    else
                        (type === strundefined || "boolean" === type) && (this.className && jQuery._data(this, "__className__", this.className), this.className = this.className || value === !1 ? "" : jQuery._data(this, "__className__") || "")
                })
            },hasClass: function(selector) {
                for (var className = " " + selector + " ", i = 0, l = this.length; l > i; i++)
                    if (1 === this[i].nodeType && (" " + this[i].className + " ").replace(rclass, " ").indexOf(className) >= 0)
                        return !0;
                return !1
            }}), jQuery.each("blur focus focusin focusout load resize scroll unload click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup error contextmenu".split(" "), function(i, name) {
            jQuery.fn[name] = function(data, fn) {
                return arguments.length > 0 ? this.on(name, null, data, fn) : this.trigger(name)
            }
        }), jQuery.fn.extend({hover: function(fnOver, fnOut) {
                return this.mouseenter(fnOver).mouseleave(fnOut || fnOver)
            },bind: function(types, data, fn) {
                return this.on(types, null, data, fn)
            },unbind: function(types, fn) {
                return this.off(types, null, fn)
            },delegate: function(selector, types, data, fn) {
                return this.on(types, selector, data, fn)
            },undelegate: function(selector, types, fn) {
                return 1 === arguments.length ? this.off(selector, "**") : this.off(types, selector || "**", fn)
            }});
        var nonce = jQuery.now(), rquery = /\?/, rvalidtokens = /(,)|(\[|{)|(}|])|"(?:[^"\\\r\n]|\\["\\\/bfnrt]|\\u[\da-fA-F]{4})*"\s*:?|true|false|null|-?(?!0\d)\d+(?:\.\d+|)(?:[eE][+-]?\d+|)/g;
        jQuery.parseJSON = function(data) {
            if (window.JSON && window.JSON.parse)
                return window.JSON.parse(data + "");
            var requireNonComma, depth = null, str = jQuery.trim(data + "");
            return str && !jQuery.trim(str.replace(rvalidtokens, function(token, comma, open, close) {
                return requireNonComma && comma && (depth = 0), 0 === depth ? token : (requireNonComma = open || comma, depth += !close - !open, "")
            })) ? Function("return " + str)() : jQuery.error("Invalid JSON: " + data)
        }, jQuery.parseXML = function(data) {
            var xml, tmp;
            if (!data || "string" != typeof data)
                return null;
            try {
                window.DOMParser ? (tmp = new DOMParser, xml = tmp.parseFromString(data, "text/xml")) : (xml = new ActiveXObject("Microsoft.XMLDOM"), xml.async = "false", xml.loadXML(data))
            } catch (e) {
                xml = void 0
            }
            return xml && xml.documentElement && !xml.getElementsByTagName("parsererror").length || jQuery.error("Invalid XML: " + data), xml
        };
        var ajaxLocParts, ajaxLocation, rhash = /#.*$/, rts = /([?&])_=[^&]*/, rheaders = /^(.*?):[ \t]*([^\r\n]*)\r?$/gm, rlocalProtocol = /^(?:about|app|app-storage|.+-extension|file|res|widget):$/, rnoContent = /^(?:GET|HEAD)$/, rprotocol = /^\/\//, rurl = /^([\w.+-]+:)(?:\/\/(?:[^\/?#]*@|)([^\/?#:]*)(?::(\d+)|)|)/, prefilters = {}, transports = {}, allTypes = "*/".concat("*");
        try {
            ajaxLocation = location.href
        } catch (e) {
            ajaxLocation = document.createElement("a"), ajaxLocation.href = "", ajaxLocation = ajaxLocation.href
        }
        ajaxLocParts = rurl.exec(ajaxLocation.toLowerCase()) || [], jQuery.extend({active: 0,lastModified: {},etag: {},ajaxSettings: {url: ajaxLocation,type: "GET",isLocal: rlocalProtocol.test(ajaxLocParts[1]),global: !0,processData: !0,async: !0,contentType: "application/x-www-form-urlencoded; charset=UTF-8",accepts: {"*": allTypes,text: "text/plain",html: "text/html",xml: "application/xml, text/xml",json: "application/json, text/javascript"},contents: {xml: /xml/,html: /html/,json: /json/},responseFields: {xml: "responseXML",text: "responseText",json: "responseJSON"},converters: {"* text": String,"text html": !0,"text json": jQuery.parseJSON,"text xml": jQuery.parseXML},flatOptions: {url: !0,context: !0}},ajaxSetup: function(target, settings) {
                return settings ? ajaxExtend(ajaxExtend(target, jQuery.ajaxSettings), settings) : ajaxExtend(jQuery.ajaxSettings, target)
            },ajaxPrefilter: addToPrefiltersOrTransports(prefilters),ajaxTransport: addToPrefiltersOrTransports(transports),ajax: function(url, options) {
                function done(status, nativeStatusText, responses, headers) {
                    var isSuccess, success, error, response, modified, statusText = nativeStatusText;
                    2 !== state && (state = 2, timeoutTimer && clearTimeout(timeoutTimer), transport = void 0, responseHeadersString = headers || "", jqXHR.readyState = status > 0 ? 4 : 0, isSuccess = status >= 200 && 300 > status || 304 === status, responses && (response = ajaxHandleResponses(s, jqXHR, responses)), response = ajaxConvert(s, response, jqXHR, isSuccess), isSuccess ? (s.ifModified && (modified = jqXHR.getResponseHeader("Last-Modified"), modified && (jQuery.lastModified[cacheURL] = modified), modified = jqXHR.getResponseHeader("etag"), modified && (jQuery.etag[cacheURL] = modified)), 204 === status || "HEAD" === s.type ? statusText = "nocontent" : 304 === status ? statusText = "notmodified" : (statusText = response.state, success = response.data, error = response.error, isSuccess = !error)) : (error = statusText, (status || !statusText) && (statusText = "error", 0 > status && (status = 0))), jqXHR.status = status, jqXHR.statusText = (nativeStatusText || statusText) + "", isSuccess ? deferred.resolveWith(callbackContext, [success, statusText, jqXHR]) : deferred.rejectWith(callbackContext, [jqXHR, statusText, error]), jqXHR.statusCode(statusCode), statusCode = void 0, fireGlobals && globalEventContext.trigger(isSuccess ? "ajaxSuccess" : "ajaxError", [jqXHR, s, isSuccess ? success : error]), completeDeferred.fireWith(callbackContext, [jqXHR, statusText]), fireGlobals && (globalEventContext.trigger("ajaxComplete", [jqXHR, s]), --jQuery.active || jQuery.event.trigger("ajaxStop")))
                }
                "object" == typeof url && (options = url, url = void 0), options = options || {};
                var parts, i, cacheURL, responseHeadersString, timeoutTimer, fireGlobals, transport, responseHeaders, s = jQuery.ajaxSetup({}, options), callbackContext = s.context || s, globalEventContext = s.context && (callbackContext.nodeType || callbackContext.jquery) ? jQuery(callbackContext) : jQuery.event, deferred = jQuery.Deferred(), completeDeferred = jQuery.Callbacks("once memory"), statusCode = s.statusCode || {}, requestHeaders = {}, requestHeadersNames = {}, state = 0, strAbort = "canceled", jqXHR = {readyState: 0,getResponseHeader: function(key) {
                        var match;
                        if (2 === state) {
                            if (!responseHeaders)
                                for (responseHeaders = {}; match = rheaders.exec(responseHeadersString); )
                                    responseHeaders[match[1].toLowerCase()] = match[2];
                            match = responseHeaders[key.toLowerCase()]
                        }
                        return null == match ? null : match
                    },getAllResponseHeaders: function() {
                        return 2 === state ? responseHeadersString : null
                    },setRequestHeader: function(name, value) {
                        var lname = name.toLowerCase();
                        return state || (name = requestHeadersNames[lname] = requestHeadersNames[lname] || name, requestHeaders[name] = value), this
                    },overrideMimeType: function(type) {
                        return state || (s.mimeType = type), this
                    },statusCode: function(map) {
                        var code;
                        if (map)
                            if (2 > state)
                                for (code in map)
                                    statusCode[code] = [statusCode[code], map[code]];
                            else
                                jqXHR.always(map[jqXHR.status]);
                        return this
                    },abort: function(statusText) {
                        var finalText = statusText || strAbort;
                        return transport && transport.abort(finalText), done(0, finalText), this
                    }};
                if (deferred.promise(jqXHR).complete = completeDeferred.add, jqXHR.success = jqXHR.done, jqXHR.error = jqXHR.fail, s.url = ((url || s.url || ajaxLocation) + "").replace(rhash, "").replace(rprotocol, ajaxLocParts[1] + "//"), s.type = options.method || options.type || s.method || s.type, s.dataTypes = jQuery.trim(s.dataType || "*").toLowerCase().match(rnotwhite) || [""], null == s.crossDomain && (parts = rurl.exec(s.url.toLowerCase()), s.crossDomain = !(!parts || parts[1] === ajaxLocParts[1] && parts[2] === ajaxLocParts[2] && (parts[3] || ("http:" === parts[1] ? "80" : "443")) === (ajaxLocParts[3] || ("http:" === ajaxLocParts[1] ? "80" : "443")))), 
                s.data && s.processData && "string" != typeof s.data && (s.data = jQuery.param(s.data, s.traditional)), inspectPrefiltersOrTransports(prefilters, s, options, jqXHR), 2 === state)
                    return jqXHR;
                fireGlobals = s.global, fireGlobals && 0 === jQuery.active++ && jQuery.event.trigger("ajaxStart"), s.type = s.type.toUpperCase(), s.hasContent = !rnoContent.test(s.type), cacheURL = s.url, s.hasContent || (s.data && (cacheURL = s.url += (rquery.test(cacheURL) ? "&" : "?") + s.data, delete s.data), s.cache === !1 && (s.url = rts.test(cacheURL) ? cacheURL.replace(rts, "$1_=" + nonce++) : cacheURL + (rquery.test(cacheURL) ? "&" : "?") + "_=" + nonce++)), s.ifModified && (jQuery.lastModified[cacheURL] && jqXHR.setRequestHeader("If-Modified-Since", jQuery.lastModified[cacheURL]), jQuery.etag[cacheURL] && jqXHR.setRequestHeader("If-None-Match", jQuery.etag[cacheURL])), (s.data && s.hasContent && s.contentType !== !1 || options.contentType) && jqXHR.setRequestHeader("Content-Type", s.contentType), jqXHR.setRequestHeader("Accept", s.dataTypes[0] && s.accepts[s.dataTypes[0]] ? s.accepts[s.dataTypes[0]] + ("*" !== s.dataTypes[0] ? ", " + allTypes + "; q=0.01" : "") : s.accepts["*"]);
                for (i in s.headers)
                    jqXHR.setRequestHeader(i, s.headers[i]);
                if (s.beforeSend && (s.beforeSend.call(callbackContext, jqXHR, s) === !1 || 2 === state))
                    return jqXHR.abort();
                strAbort = "abort";
                for (i in {success: 1,error: 1,complete: 1})
                    jqXHR[i](s[i]);
                if (transport = inspectPrefiltersOrTransports(transports, s, options, jqXHR)) {
                    jqXHR.readyState = 1, fireGlobals && globalEventContext.trigger("ajaxSend", [jqXHR, s]), s.async && s.timeout > 0 && (timeoutTimer = setTimeout(function() {
                        jqXHR.abort("timeout")
                    }, s.timeout));
                    try {
                        state = 1, transport.send(requestHeaders, done)
                    } catch (e) {
                        if (!(2 > state))
                            throw e;
                        done(-1, e)
                    }
                } else
                    done(-1, "No Transport");
                return jqXHR
            },getJSON: function(url, data, callback) {
                return jQuery.get(url, data, callback, "json")
            },getScript: function(url, callback) {
                return jQuery.get(url, void 0, callback, "script")
            }}), jQuery.each(["get", "post"], function(i, method) {
            jQuery[method] = function(url, data, callback, type) {
                return jQuery.isFunction(data) && (type = type || callback, callback = data, data = void 0), jQuery.ajax({url: url,type: method,dataType: type,data: data,success: callback})
            }
        }), jQuery.each(["ajaxStart", "ajaxStop", "ajaxComplete", "ajaxError", "ajaxSuccess", "ajaxSend"], function(i, type) {
            jQuery.fn[type] = function(fn) {
                return this.on(type, fn)
            }
        }), jQuery._evalUrl = function(url) {
            return jQuery.ajax({url: url,type: "GET",dataType: "script",async: !1,global: !1,"throws": !0})
        }, jQuery.fn.extend({wrapAll: function(html) {
                if (jQuery.isFunction(html))
                    return this.each(function(i) {
                        jQuery(this).wrapAll(html.call(this, i))
                    });
                if (this[0]) {
                    var wrap = jQuery(html, this[0].ownerDocument).eq(0).clone(!0);
                    this[0].parentNode && wrap.insertBefore(this[0]), wrap.map(function() {
                        for (var elem = this; elem.firstChild && 1 === elem.firstChild.nodeType; )
                            elem = elem.firstChild;
                        return elem
                    }).append(this)
                }
                return this
            },wrapInner: function(html) {
                return jQuery.isFunction(html) ? this.each(function(i) {
                    jQuery(this).wrapInner(html.call(this, i))
                }) : this.each(function() {
                    var self = jQuery(this), contents = self.contents();
                    contents.length ? contents.wrapAll(html) : self.append(html)
                })
            },wrap: function(html) {
                var isFunction = jQuery.isFunction(html);
                return this.each(function(i) {
                    jQuery(this).wrapAll(isFunction ? html.call(this, i) : html)
                })
            },unwrap: function() {
                return this.parent().each(function() {
                    jQuery.nodeName(this, "body") || jQuery(this).replaceWith(this.childNodes)
                }).end()
            }}), jQuery.expr.filters.hidden = function(elem) {
            return elem.offsetWidth <= 0 && elem.offsetHeight <= 0 || !support.reliableHiddenOffsets() && "none" === (elem.style && elem.style.display || jQuery.css(elem, "display"))
        }, jQuery.expr.filters.visible = function(elem) {
            return !jQuery.expr.filters.hidden(elem)
        };
        var r20 = /%20/g, rbracket = /\[\]$/, rCRLF = /\r?\n/g, rsubmitterTypes = /^(?:submit|button|image|reset|file)$/i, rsubmittable = /^(?:input|select|textarea|keygen)/i;
        jQuery.param = function(a, traditional) {
            var prefix, s = [], add = function(key, value) {
                value = jQuery.isFunction(value) ? value() : null == value ? "" : value, s[s.length] = encodeURIComponent(key) + "=" + encodeURIComponent(value)
            };
            if (void 0 === traditional && (traditional = jQuery.ajaxSettings && jQuery.ajaxSettings.traditional), jQuery.isArray(a) || a.jquery && !jQuery.isPlainObject(a))
                jQuery.each(a, function() {
                    add(this.name, this.value)
                });
            else
                for (prefix in a)
                    buildParams(prefix, a[prefix], traditional, add);
            return s.join("&").replace(r20, "+")
        }, jQuery.fn.extend({serialize: function() {
                return jQuery.param(this.serializeArray())
            },serializeArray: function() {
                return this.map(function() {
                    var elements = jQuery.prop(this, "elements");
                    return elements ? jQuery.makeArray(elements) : this
                }).filter(function() {
                    var type = this.type;
                    return this.name && !jQuery(this).is(":disabled") && rsubmittable.test(this.nodeName) && !rsubmitterTypes.test(type) && (this.checked || !rcheckableType.test(type))
                }).map(function(i, elem) {
                    var val = jQuery(this).val();
                    return null == val ? null : jQuery.isArray(val) ? jQuery.map(val, function(val) {
                        return {name: elem.name,value: val.replace(rCRLF, "\r\n")}
                    }) : {name: elem.name,value: val.replace(rCRLF, "\r\n")}
                }).get()
            }}), jQuery.ajaxSettings.xhr = void 0 !== window.ActiveXObject ? function() {
            return !this.isLocal && /^(get|post|head|put|delete|options)$/i.test(this.type) && createStandardXHR() || createActiveXHR()
        } : createStandardXHR;
        var xhrId = 0, xhrCallbacks = {}, xhrSupported = jQuery.ajaxSettings.xhr();
        window.ActiveXObject && jQuery(window).on("unload", function() {
            for (var key in xhrCallbacks)
                xhrCallbacks[key](void 0, !0)
        }), support.cors = !!xhrSupported && "withCredentials" in xhrSupported, xhrSupported = support.ajax = !!xhrSupported, xhrSupported && jQuery.ajaxTransport(function(options) {
            if (!options.crossDomain || support.cors) {
                var callback;
                return {send: function(headers, complete) {
                        var i, xhr = options.xhr(), id = ++xhrId;
                        if (xhr.open(options.type, options.url, options.async, options.username, options.password), options.xhrFields)
                            for (i in options.xhrFields)
                                xhr[i] = options.xhrFields[i];
                        options.mimeType && xhr.overrideMimeType && xhr.overrideMimeType(options.mimeType), options.crossDomain || headers["X-Requested-With"] || (headers["X-Requested-With"] = "XMLHttpRequest");
                        for (i in headers)
                            void 0 !== headers[i] && xhr.setRequestHeader(i, headers[i] + "");
                        xhr.send(options.hasContent && options.data || null), callback = function(_, isAbort) {
                            var status, statusText, responses;
                            if (callback && (isAbort || 4 === xhr.readyState))
                                if (delete xhrCallbacks[id], callback = void 0, xhr.onreadystatechange = jQuery.noop, isAbort)
                                    4 !== xhr.readyState && xhr.abort();
                                else {
                                    responses = {}, status = xhr.status, "string" == typeof xhr.responseText && (responses.text = xhr.responseText);
                                    try {
                                        statusText = xhr.statusText
                                    } catch (e) {
                                        statusText = ""
                                    }
                                    status || !options.isLocal || options.crossDomain ? 1223 === status && (status = 204) : status = responses.text ? 200 : 404
                                }
                            responses && complete(status, statusText, responses, xhr.getAllResponseHeaders())
                        }, options.async ? 4 === xhr.readyState ? setTimeout(callback) : xhr.onreadystatechange = xhrCallbacks[id] = callback : callback()
                    },abort: function() {
                        callback && callback(void 0, !0)
                    }}
            }
        }), jQuery.ajaxSetup({accepts: {script: "text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"},contents: {script: /(?:java|ecma)script/},converters: {"text script": function(text) {
                    return jQuery.globalEval(text), text
                }}}), jQuery.ajaxPrefilter("script", function(s) {
            void 0 === s.cache && (s.cache = !1), s.crossDomain && (s.type = "GET", s.global = !1)
        }), jQuery.ajaxTransport("script", function(s) {
            if (s.crossDomain) {
                var script, head = document.head || jQuery("head")[0] || document.documentElement;
                return {send: function(_, callback) {
                        script = document.createElement("script"), script.async = !0, s.scriptCharset && (script.charset = s.scriptCharset), script.src = s.url, script.onload = script.onreadystatechange = function(_, isAbort) {
                            (isAbort || !script.readyState || /loaded|complete/.test(script.readyState)) && (script.onload = script.onreadystatechange = null, script.parentNode && script.parentNode.removeChild(script), script = null, isAbort || callback(200, "success"))
                        }, head.insertBefore(script, head.firstChild)
                    },abort: function() {
                        script && script.onload(void 0, !0)
                    }}
            }
        });
        var oldCallbacks = [], rjsonp = /(=)\?(?=&|$)|\?\?/;
        jQuery.ajaxSetup({jsonp: "callback",jsonpCallback: function() {
                var callback = oldCallbacks.pop() || jQuery.expando + "_" + nonce++;
                return this[callback] = !0, callback
            }}), jQuery.ajaxPrefilter("json jsonp", function(s, originalSettings, jqXHR) {
            var callbackName, overwritten, responseContainer, jsonProp = s.jsonp !== !1 && (rjsonp.test(s.url) ? "url" : "string" == typeof s.data && !(s.contentType || "").indexOf("application/x-www-form-urlencoded") && rjsonp.test(s.data) && "data");
            return jsonProp || "jsonp" === s.dataTypes[0] ? (callbackName = s.jsonpCallback = jQuery.isFunction(s.jsonpCallback) ? s.jsonpCallback() : s.jsonpCallback, jsonProp ? s[jsonProp] = s[jsonProp].replace(rjsonp, "$1" + callbackName) : s.jsonp !== !1 && (s.url += (rquery.test(s.url) ? "&" : "?") + s.jsonp + "=" + callbackName), s.converters["script json"] = function() {
                return responseContainer || jQuery.error(callbackName + " was not called"), responseContainer[0]
            }, s.dataTypes[0] = "json", overwritten = window[callbackName], window[callbackName] = function() {
                responseContainer = arguments
            }, jqXHR.always(function() {
                window[callbackName] = overwritten, s[callbackName] && (s.jsonpCallback = originalSettings.jsonpCallback, oldCallbacks.push(callbackName)), responseContainer && jQuery.isFunction(overwritten) && overwritten(responseContainer[0]), responseContainer = overwritten = void 0
            }), "script") : void 0
        }), jQuery.parseHTML = function(data, context, keepScripts) {
            if (!data || "string" != typeof data)
                return null;
            "boolean" == typeof context && (keepScripts = context, context = !1), context = context || document;
            var parsed = rsingleTag.exec(data), scripts = !keepScripts && [];
            return parsed ? [context.createElement(parsed[1])] : (parsed = jQuery.buildFragment([data], context, scripts), scripts && scripts.length && jQuery(scripts).remove(), jQuery.merge([], parsed.childNodes))
        };
        var _load = jQuery.fn.load;
        jQuery.fn.load = function(url, params, callback) {
            if ("string" != typeof url && _load)
                return _load.apply(this, arguments);
            var selector, response, type, self = this, off = url.indexOf(" ");
            return off >= 0 && (selector = jQuery.trim(url.slice(off, url.length)), url = url.slice(0, off)), jQuery.isFunction(params) ? (callback = params, params = void 0) : params && "object" == typeof params && (type = "POST"), self.length > 0 && jQuery.ajax({url: url,type: type,dataType: "html",data: params}).done(function(responseText) {
                response = arguments, self.html(selector ? jQuery("<div>").append(jQuery.parseHTML(responseText)).find(selector) : responseText)
            }).complete(callback && function(jqXHR, status) {
                self.each(callback, response || [jqXHR.responseText, status, jqXHR])
            }), this
        }, jQuery.expr.filters.animated = function(elem) {
            return jQuery.grep(jQuery.timers, function(fn) {
                return elem === fn.elem
            }).length
        };
        var docElem = window.document.documentElement;
        jQuery.offset = {setOffset: function(elem, options, i) {
                var curPosition, curLeft, curCSSTop, curTop, curOffset, curCSSLeft, calculatePosition, position = jQuery.css(elem, "position"), curElem = jQuery(elem), props = {};
                "static" === position && (elem.style.position = "relative"), curOffset = curElem.offset(), curCSSTop = jQuery.css(elem, "top"), curCSSLeft = jQuery.css(elem, "left"), calculatePosition = ("absolute" === position || "fixed" === position) && jQuery.inArray("auto", [curCSSTop, curCSSLeft]) > -1, calculatePosition ? (curPosition = curElem.position(), curTop = curPosition.top, curLeft = curPosition.left) : (curTop = parseFloat(curCSSTop) || 0, curLeft = parseFloat(curCSSLeft) || 0), jQuery.isFunction(options) && (options = options.call(elem, i, curOffset)), null != options.top && (props.top = options.top - curOffset.top + curTop), null != options.left && (props.left = options.left - curOffset.left + curLeft), "using" in options ? options.using.call(elem, props) : curElem.css(props)
            }}, jQuery.fn.extend({offset: function(options) {
                if (arguments.length)
                    return void 0 === options ? this : this.each(function(i) {
                        jQuery.offset.setOffset(this, options, i)
                    });
                var docElem, win, box = {top: 0,left: 0}, elem = this[0], doc = elem && elem.ownerDocument;
                if (doc)
                    return docElem = doc.documentElement, jQuery.contains(docElem, elem) ? (typeof elem.getBoundingClientRect !== strundefined && (box = elem.getBoundingClientRect()), win = getWindow(doc), {top: box.top + (win.pageYOffset || docElem.scrollTop) - (docElem.clientTop || 0),left: box.left + (win.pageXOffset || docElem.scrollLeft) - (docElem.clientLeft || 0)}) : box
            },position: function() {
                if (this[0]) {
                    var offsetParent, offset, parentOffset = {top: 0,left: 0}, elem = this[0];
                    return "fixed" === jQuery.css(elem, "position") ? offset = elem.getBoundingClientRect() : (offsetParent = this.offsetParent(), offset = this.offset(), jQuery.nodeName(offsetParent[0], "html") || (parentOffset = offsetParent.offset()), parentOffset.top += jQuery.css(offsetParent[0], "borderTopWidth", !0), parentOffset.left += jQuery.css(offsetParent[0], "borderLeftWidth", !0)), {top: offset.top - parentOffset.top - jQuery.css(elem, "marginTop", !0),left: offset.left - parentOffset.left - jQuery.css(elem, "marginLeft", !0)}
                }
            },offsetParent: function() {
                return this.map(function() {
                    for (var offsetParent = this.offsetParent || docElem; offsetParent && !jQuery.nodeName(offsetParent, "html") && "static" === jQuery.css(offsetParent, "position"); )
                        offsetParent = offsetParent.offsetParent;
                    return offsetParent || docElem
                })
            }}), jQuery.each({scrollLeft: "pageXOffset",scrollTop: "pageYOffset"}, function(method, prop) {
            var top = /Y/.test(prop);
            jQuery.fn[method] = function(val) {
                return access(this, function(elem, method, val) {
                    var win = getWindow(elem);
                    return void 0 === val ? win ? prop in win ? win[prop] : win.document.documentElement[method] : elem[method] : void (win ? win.scrollTo(top ? jQuery(win).scrollLeft() : val, top ? val : jQuery(win).scrollTop()) : elem[method] = val)
                }, method, val, arguments.length, null)
            }
        }), jQuery.each(["top", "left"], function(i, prop) {
            jQuery.cssHooks[prop] = addGetHookIf(support.pixelPosition, function(elem, computed) {
                return computed ? (computed = curCSS(elem, prop), rnumnonpx.test(computed) ? jQuery(elem).position()[prop] + "px" : computed) : void 0
            })
        }), jQuery.each({Height: "height",Width: "width"}, function(name, type) {
            jQuery.each({padding: "inner" + name,content: type,"": "outer" + name}, function(defaultExtra, funcName) {
                jQuery.fn[funcName] = function(margin, value) {
                    var chainable = arguments.length && (defaultExtra || "boolean" != typeof margin), extra = defaultExtra || (margin === !0 || value === !0 ? "margin" : "border");
                    return access(this, function(elem, type, value) {
                        var doc;
                        return jQuery.isWindow(elem) ? elem.document.documentElement["client" + name] : 9 === elem.nodeType ? (doc = elem.documentElement, Math.max(elem.body["scroll" + name], doc["scroll" + name], elem.body["offset" + name], doc["offset" + name], doc["client" + name])) : void 0 === value ? jQuery.css(elem, type, extra) : jQuery.style(elem, type, value, extra)
                    }, type, chainable ? margin : void 0, chainable, null)
                }
            })
        }), jQuery.fn.size = function() {
            return this.length
        }, jQuery.fn.andSelf = jQuery.fn.addBack, "function" == typeof define && define.amd && define("jquery", [], function() {
            return jQuery
        });
        var _jQuery = window.jQuery, _$ = window.$;
        return jQuery.noConflict = function(deep) {
            return window.$ === jQuery && (window.$ = _$), deep && window.jQuery === jQuery && (window.jQuery = _jQuery), jQuery
        }, typeof noGlobal === strundefined && (window.jQuery = window.$ = jQuery), jQuery
    }), null == window.jQuery)
        throw new Error('Grunt Requireize: module does not define "window.jQuery"');
    return window.jQuery
}), fweb_define("jquery.ui", ["jquery"], null, function() {
    var define = void 0;
    if (function(factory) {
        "function" == typeof define && define.amd ? define(["jquery"], factory) : factory(jQuery)
    }(function($) {
        function focusable(element, isTabIndexNotNaN) {
            var map, mapName, img, nodeName = element.nodeName.toLowerCase();
            return "area" === nodeName ? (map = element.parentNode, mapName = map.name, element.href && mapName && "map" === map.nodeName.toLowerCase() ? (img = $("img[usemap='#" + mapName + "']")[0], !!img && visible(img)) : !1) : (/^(input|select|textarea|button|object)$/.test(nodeName) ? !element.disabled : "a" === nodeName ? element.href || isTabIndexNotNaN : isTabIndexNotNaN) && visible(element)
        }
        function visible(element) {
            return $.expr.filters.visible(element) && !$(element).parents().addBack().filter(function() {
                return "hidden" === $.css(this, "visibility")
            }).length
        }
        function datepicker_getZindex(elem) {
            for (var position, value; elem.length && elem[0] !== document; ) {
                if (position = elem.css("position"), ("absolute" === position || "relative" === position || "fixed" === position) && (value = parseInt(elem.css("zIndex"), 10), !isNaN(value) && 0 !== value))
                    return value;
                elem = elem.parent()
            }
            return 0
        }
        function Datepicker() {
            this._curInst = null, this._keyEvent = !1, this._disabledInputs = [], this._datepickerShowing = !1, this._inDialog = !1, this._mainDivId = "ui-datepicker-div", this._inlineClass = "ui-datepicker-inline", this._appendClass = "ui-datepicker-append", this._triggerClass = "ui-datepicker-trigger", this._dialogClass = "ui-datepicker-dialog", this._disableClass = "ui-datepicker-disabled", this._unselectableClass = "ui-datepicker-unselectable", this._currentClass = "ui-datepicker-current-day", this._dayOverClass = "ui-datepicker-days-cell-over", this.regional = [], this.regional[""] = {closeText: "Done",prevText: "Prev",nextText: "Next",currentText: "Today",monthNames: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],monthNamesShort: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],dayNames: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],dayNamesShort: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],dayNamesMin: ["Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"],weekHeader: "Wk",dateFormat: "mm/dd/yy",firstDay: 0,isRTL: !1,showMonthAfterYear: !1,yearSuffix: ""}, this._defaults = {showOn: "focus",showAnim: "fadeIn",showOptions: {},defaultDate: null,appendText: "",buttonText: "...",buttonImage: "",buttonImageOnly: !1,hideIfNoPrevNext: !1,navigationAsDateFormat: !1,gotoCurrent: !1,changeMonth: !1,changeYear: !1,yearRange: "c-10:c+10",showOtherMonths: !1,selectOtherMonths: !1,showWeek: !1,calculateWeek: this.iso8601Week,shortYearCutoff: "+10",minDate: null,maxDate: null,duration: "fast",beforeShowDay: null,beforeShow: null,onSelect: null,onChangeMonthYear: null,onClose: null,numberOfMonths: 1,showCurrentAtPos: 0,stepMonths: 1,stepBigMonths: 12,altField: "",altFormat: "",constrainInput: !0,showButtonPanel: !1,autoSize: !1,disabled: !1}, $.extend(this._defaults, this.regional[""]), this.regional.en = $.extend(!0, {}, this.regional[""]), this.regional["en-US"] = $.extend(!0, {}, this.regional.en), this.dpDiv = datepicker_bindHover($("<div id='" + this._mainDivId + "' class='ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>"))
        }
        function datepicker_bindHover(dpDiv) {
            var selector = "button, .ui-datepicker-prev, .ui-datepicker-next, .ui-datepicker-calendar td a";
            return dpDiv.delegate(selector, "mouseout", function() {
                $(this).removeClass("ui-state-hover"), -1 !== this.className.indexOf("ui-datepicker-prev") && $(this).removeClass("ui-datepicker-prev-hover"), -1 !== this.className.indexOf("ui-datepicker-next") && $(this).removeClass("ui-datepicker-next-hover")
            }).delegate(selector, "mouseover", datepicker_handleMouseover)
        }
        function datepicker_handleMouseover() {
            $.datepicker._isDisabledDatepicker(datepicker_instActive.inline ? datepicker_instActive.dpDiv.parent()[0] : datepicker_instActive.input[0]) || ($(this).parents(".ui-datepicker-calendar").find("a").removeClass("ui-state-hover"), $(this).addClass("ui-state-hover"), -1 !== this.className.indexOf("ui-datepicker-prev") && $(this).addClass("ui-datepicker-prev-hover"), -1 !== this.className.indexOf("ui-datepicker-next") && $(this).addClass("ui-datepicker-next-hover"))
        }
        function datepicker_extendRemove(target, props) {
            $.extend(target, props);
            for (var name in props)
                null == props[name] && (target[name] = props[name]);
            return target
        }
        function spinner_modifier(fn) {
            return function() {
                var previous = this.element.val();
                fn.apply(this, arguments), this._refresh(), previous !== this.element.val() && this._trigger("change")
            }
        }
        $.ui = $.ui || {}, $.extend($.ui, {version: "1.11.4",keyCode: {BACKSPACE: 8,COMMA: 188,DELETE: 46,DOWN: 40,END: 35,ENTER: 13,ESCAPE: 27,HOME: 36,LEFT: 37,PAGE_DOWN: 34,PAGE_UP: 33,PERIOD: 190,RIGHT: 39,SPACE: 32,TAB: 9,UP: 38}}), $.fn.extend({scrollParent: function(includeHidden) {
                var position = this.css("position"), excludeStaticParent = "absolute" === position, overflowRegex = includeHidden ? /(auto|scroll|hidden)/ : /(auto|scroll)/, scrollParent = this.parents().filter(function() {
                    var parent = $(this);
                    return excludeStaticParent && "static" === parent.css("position") ? !1 : overflowRegex.test(parent.css("overflow") + parent.css("overflow-y") + parent.css("overflow-x"))
                }).eq(0);
                return "fixed" !== position && scrollParent.length ? scrollParent : $(this[0].ownerDocument || document)
            },uniqueId: function() {
                var uuid = 0;
                return function() {
                    return this.each(function() {
                        this.id || (this.id = "ui-id-" + ++uuid)
                    })
                }
            }(),removeUniqueId: function() {
                return this.each(function() {
                    /^ui-id-\d+$/.test(this.id) && $(this).removeAttr("id")
                })
            }}), $.extend($.expr[":"], {data: $.expr.createPseudo ? $.expr.createPseudo(function(dataName) {
                return function(elem) {
                    return !!$.data(elem, dataName)
                }
            }) : function(elem, i, match) {
                return !!$.data(elem, match[3])
            },focusable: function(element) {
                return focusable(element, !isNaN($.attr(element, "tabindex")))
            },tabbable: function(element) {
                var tabIndex = $.attr(element, "tabindex"), isTabIndexNaN = isNaN(tabIndex);
                return (isTabIndexNaN || tabIndex >= 0) && focusable(element, !isTabIndexNaN)
            }}), $("<a>").outerWidth(1).jquery || $.each(["Width", "Height"], function(i, name) {
            function reduce(elem, size, border, margin) {
                return $.each(side, function() {
                    size -= parseFloat($.css(elem, "padding" + this)) || 0, border && (size -= parseFloat($.css(elem, "border" + this + "Width")) || 0), margin && (size -= parseFloat($.css(elem, "margin" + this)) || 0)
                }), size
            }
            var side = "Width" === name ? ["Left", "Right"] : ["Top", "Bottom"], type = name.toLowerCase(), orig = {innerWidth: $.fn.innerWidth,innerHeight: $.fn.innerHeight,outerWidth: $.fn.outerWidth,outerHeight: $.fn.outerHeight};
            $.fn["inner" + name] = function(size) {
                return void 0 === size ? orig["inner" + name].call(this) : this.each(function() {
                    $(this).css(type, reduce(this, size) + "px")
                })
            }, $.fn["outer" + name] = function(size, margin) {
                return "number" != typeof size ? orig["outer" + name].call(this, size) : this.each(function() {
                    $(this).css(type, reduce(this, size, !0, margin) + "px")
                })
            }
        }), $.fn.addBack || ($.fn.addBack = function(selector) {
            return this.add(null == selector ? this.prevObject : this.prevObject.filter(selector))
        }), $("<a>").data("a-b", "a").removeData("a-b").data("a-b") && ($.fn.removeData = function(removeData) {
            return function(key) {
                return arguments.length ? removeData.call(this, $.camelCase(key)) : removeData.call(this)
            }
        }($.fn.removeData)), $.ui.ie = !!/msie [\w.]+/.exec(navigator.userAgent.toLowerCase()), $.fn.extend({focus: function(orig) {
                return function(delay, fn) {
                    return "number" == typeof delay ? this.each(function() {
                        var elem = this;
                        setTimeout(function() {
                            $(elem).focus(), fn && fn.call(elem)
                        }, delay)
                    }) : orig.apply(this, arguments)
                }
            }($.fn.focus),disableSelection: function() {
                var eventType = "onselectstart" in document.createElement("div") ? "selectstart" : "mousedown";
                return function() {
                    return this.bind(eventType + ".ui-disableSelection", function(event) {
                        event.preventDefault()
                    })
                }
            }(),enableSelection: function() {
                return this.unbind(".ui-disableSelection")
            },zIndex: function(zIndex) {
                if (void 0 !== zIndex)
                    return this.css("zIndex", zIndex);
                if (this.length)
                    for (var position, value, elem = $(this[0]); elem.length && elem[0] !== document; ) {
                        if (position = elem.css("position"), ("absolute" === position || "relative" === position || "fixed" === position) && (value = parseInt(elem.css("zIndex"), 10), !isNaN(value) && 0 !== value))
                            return value;
                        elem = elem.parent()
                    }
                return 0
            }}), $.ui.plugin = {add: function(module, option, set) {
                var i, proto = $.ui[module].prototype;
                for (i in set)
                    proto.plugins[i] = proto.plugins[i] || [], proto.plugins[i].push([option, set[i]])
            },call: function(instance, name, args, allowDisconnected) {
                var i, set = instance.plugins[name];
                if (set && (allowDisconnected || instance.element[0].parentNode && 11 !== instance.element[0].parentNode.nodeType))
                    for (i = 0; i < set.length; i++)
                        instance.options[set[i][0]] && set[i][1].apply(instance.element, args)
            }};
        var widget_uuid = 0, widget_slice = Array.prototype.slice;
        $.cleanData = function(orig) {
            return function(elems) {
                var events, elem, i;
                for (i = 0; null != (elem = elems[i]); i++)
                    try {
                        events = $._data(elem, "events"), events && events.remove && $(elem).triggerHandler("remove")
                    } catch (e) {
                    }
                orig(elems)
            }
        }($.cleanData), $.widget = function(name, base, prototype) {
            var fullName, existingConstructor, constructor, basePrototype, proxiedPrototype = {}, namespace = name.split(".")[0];
            return name = name.split(".")[1], fullName = namespace + "-" + name, prototype || (prototype = base, base = $.Widget), $.expr[":"][fullName.toLowerCase()] = function(elem) {
                return !!$.data(elem, fullName)
            }, $[namespace] = $[namespace] || {}, existingConstructor = $[namespace][name], constructor = $[namespace][name] = function(options, element) {
                return this._createWidget ? void (arguments.length && this._createWidget(options, element)) : new constructor(options, element)
            }, $.extend(constructor, existingConstructor, {version: prototype.version,_proto: $.extend({}, prototype),_childConstructors: []}), basePrototype = new base, basePrototype.options = $.widget.extend({}, basePrototype.options), $.each(prototype, function(prop, value) {
                return $.isFunction(value) ? void (proxiedPrototype[prop] = function() {
                    var _super = function() {
                        return base.prototype[prop].apply(this, arguments)
                    }, _superApply = function(args) {
                        return base.prototype[prop].apply(this, args)
                    };
                    return function() {
                        var returnValue, __super = this._super, __superApply = this._superApply;
                        return this._super = _super, this._superApply = _superApply, returnValue = value.apply(this, arguments), this._super = __super, this._superApply = __superApply, returnValue
                    }
                }()) : void (proxiedPrototype[prop] = value)
            }), constructor.prototype = $.widget.extend(basePrototype, {widgetEventPrefix: existingConstructor ? basePrototype.widgetEventPrefix || name : name}, proxiedPrototype, {constructor: constructor,namespace: namespace,widgetName: name,widgetFullName: fullName}), existingConstructor ? ($.each(existingConstructor._childConstructors, function(i, child) {
                var childPrototype = child.prototype;
                $.widget(childPrototype.namespace + "." + childPrototype.widgetName, constructor, child._proto)
            }), delete existingConstructor._childConstructors) : base._childConstructors.push(constructor), $.widget.bridge(name, constructor), constructor
        }, $.widget.extend = function(target) {
            for (var key, value, input = widget_slice.call(arguments, 1), inputIndex = 0, inputLength = input.length; inputLength > inputIndex; inputIndex++)
                for (key in input[inputIndex])
                    value = input[inputIndex][key], input[inputIndex].hasOwnProperty(key) && void 0 !== value && ($.isPlainObject(value) ? target[key] = $.isPlainObject(target[key]) ? $.widget.extend({}, target[key], value) : $.widget.extend({}, value) : target[key] = value);
            return target
        }, $.widget.bridge = function(name, object) {
            var fullName = object.prototype.widgetFullName || name;
            $.fn[name] = function(options) {
                var isMethodCall = "string" == typeof options, args = widget_slice.call(arguments, 1), returnValue = this;
                return isMethodCall ? this.each(function() {
                    var methodValue, instance = $.data(this, fullName);
                    return "instance" === options ? (returnValue = instance, !1) : instance ? $.isFunction(instance[options]) && "_" !== options.charAt(0) ? (methodValue = instance[options].apply(instance, args), methodValue !== instance && void 0 !== methodValue ? (returnValue = methodValue && methodValue.jquery ? returnValue.pushStack(methodValue.get()) : methodValue, !1) : void 0) : $.error("no such method '" + options + "' for " + name + " widget instance") : $.error("cannot call methods on " + name + " prior to initialization; attempted to call method '" + options + "'")
                }) : (args.length && (options = $.widget.extend.apply(null, [options].concat(args))), this.each(function() {
                    var instance = $.data(this, fullName);
                    instance ? (instance.option(options || {}), instance._init && instance._init()) : $.data(this, fullName, new object(options, this))
                })), returnValue
            }
        }, $.Widget = function() {
        }, $.Widget._childConstructors = [], $.Widget.prototype = {widgetName: "widget",widgetEventPrefix: "",defaultElement: "<div>",options: {disabled: !1,create: null},_createWidget: function(options, element) {
                element = $(element || this.defaultElement || this)[0], this.element = $(element), this.uuid = widget_uuid++, this.eventNamespace = "." + this.widgetName + this.uuid, this.bindings = $(), this.hoverable = $(), this.focusable = $(), element !== this && ($.data(element, this.widgetFullName, this), this._on(!0, this.element, {remove: function(event) {
                        event.target === element && this.destroy()
                    }}), this.document = $(element.style ? element.ownerDocument : element.document || element), this.window = $(this.document[0].defaultView || this.document[0].parentWindow)), this.options = $.widget.extend({}, this.options, this._getCreateOptions(), options), this._create(), this._trigger("create", null, this._getCreateEventData()), this._init()
            },_getCreateOptions: $.noop,_getCreateEventData: $.noop,_create: $.noop,_init: $.noop,destroy: function() {
                this._destroy(), this.element.unbind(this.eventNamespace).removeData(this.widgetFullName).removeData($.camelCase(this.widgetFullName)), this.widget().unbind(this.eventNamespace).removeAttr("aria-disabled").removeClass(this.widgetFullName + "-disabled ui-state-disabled"), this.bindings.unbind(this.eventNamespace), this.hoverable.removeClass("ui-state-hover"), this.focusable.removeClass("ui-state-focus")
            },_destroy: $.noop,widget: function() {
                return this.element
            },option: function(key, value) {
                var parts, curOption, i, options = key;
                if (0 === arguments.length)
                    return $.widget.extend({}, this.options);
                if ("string" == typeof key)
                    if (options = {}, parts = key.split("."), key = parts.shift(), parts.length) {
                        for (curOption = options[key] = $.widget.extend({}, this.options[key]), i = 0; i < parts.length - 1; i++)
                            curOption[parts[i]] = curOption[parts[i]] || {}, curOption = curOption[parts[i]];
                        if (key = parts.pop(), 1 === arguments.length)
                            return void 0 === curOption[key] ? null : curOption[key];
                        curOption[key] = value
                    } else {
                        if (1 === arguments.length)
                            return void 0 === this.options[key] ? null : this.options[key];
                        options[key] = value
                    }
                return this._setOptions(options), this
            },_setOptions: function(options) {
                var key;
                for (key in options)
                    this._setOption(key, options[key]);
                return this
            },_setOption: function(key, value) {
                return this.options[key] = value, "disabled" === key && (this.widget().toggleClass(this.widgetFullName + "-disabled", !!value), value && (this.hoverable.removeClass("ui-state-hover"), this.focusable.removeClass("ui-state-focus"))), this
            },enable: function() {
                return this._setOptions({disabled: !1})
            },disable: function() {
                return this._setOptions({disabled: !0})
            },_on: function(suppressDisabledCheck, element, handlers) {
                var delegateElement, instance = this;
                "boolean" != typeof suppressDisabledCheck && (handlers = element, element = suppressDisabledCheck, suppressDisabledCheck = !1), handlers ? (element = delegateElement = $(element), this.bindings = this.bindings.add(element)) : (handlers = element, element = this.element, delegateElement = this.widget()), $.each(handlers, function(event, handler) {
                    function handlerProxy() {
                        return suppressDisabledCheck || instance.options.disabled !== !0 && !$(this).hasClass("ui-state-disabled") ? ("string" == typeof handler ? instance[handler] : handler).apply(instance, arguments) : void 0
                    }
                    "string" != typeof handler && (handlerProxy.guid = handler.guid = handler.guid || handlerProxy.guid || $.guid++);
                    var match = event.match(/^([\w:-]*)\s*(.*)$/), eventName = match[1] + instance.eventNamespace, selector = match[2];
                    selector ? delegateElement.delegate(selector, eventName, handlerProxy) : element.bind(eventName, handlerProxy)
                })
            },_off: function(element, eventName) {
                eventName = (eventName || "").split(" ").join(this.eventNamespace + " ") + this.eventNamespace, element.unbind(eventName).undelegate(eventName), this.bindings = $(this.bindings.not(element).get()), this.focusable = $(this.focusable.not(element).get()), this.hoverable = $(this.hoverable.not(element).get())
            },_delay: function(handler, delay) {
                function handlerProxy() {
                    return ("string" == typeof handler ? instance[handler] : handler).apply(instance, arguments)
                }
                var instance = this;
                return setTimeout(handlerProxy, delay || 0)
            },_hoverable: function(element) {
                this.hoverable = this.hoverable.add(element), this._on(element, {mouseenter: function(event) {
                        $(event.currentTarget).addClass("ui-state-hover")
                    },mouseleave: function(event) {
                        $(event.currentTarget).removeClass("ui-state-hover")
                    }})
            },_focusable: function(element) {
                this.focusable = this.focusable.add(element), this._on(element, {focusin: function(event) {
                        $(event.currentTarget).addClass("ui-state-focus")
                    },focusout: function(event) {
                        $(event.currentTarget).removeClass("ui-state-focus")
                    }})
            },_trigger: function(type, event, data) {
                var prop, orig, callback = this.options[type];
                if (data = data || {}, event = $.Event(event), event.type = (type === this.widgetEventPrefix ? type : this.widgetEventPrefix + type).toLowerCase(), event.target = this.element[0], orig = event.originalEvent)
                    for (prop in orig)
                        prop in event || (event[prop] = orig[prop]);
                return this.element.trigger(event, data), !($.isFunction(callback) && callback.apply(this.element[0], [event].concat(data)) === !1 || event.isDefaultPrevented())
            }}, $.each({show: "fadeIn",hide: "fadeOut"}, function(method, defaultEffect) {
            $.Widget.prototype["_" + method] = function(element, options, callback) {
                "string" == typeof options && (options = {effect: options});
                var hasOptions, effectName = options ? options === !0 || "number" == typeof options ? defaultEffect : options.effect || defaultEffect : method;
                options = options || {}, "number" == typeof options && (options = {duration: options}), hasOptions = !$.isEmptyObject(options), options.complete = callback, options.delay && element.delay(options.delay), hasOptions && $.effects && $.effects.effect[effectName] ? element[method](options) : effectName !== method && element[effectName] ? element[effectName](options.duration, options.easing, callback) : element.queue(function(next) {
                    $(this)[method](), callback && callback.call(element[0]), next()
                })
            }
        });
        var mouseHandled = ($.widget, !1);
        $(document).mouseup(function() {
            mouseHandled = !1
        });
        $.widget("ui.mouse", {version: "1.11.4",options: {cancel: "input,textarea,button,select,option",distance: 1,delay: 0},_mouseInit: function() {
                var that = this;
                this.element.bind("mousedown." + this.widgetName, function(event) {
                    return that._mouseDown(event)
                }).bind("click." + this.widgetName, function(event) {
                    return !0 === $.data(event.target, that.widgetName + ".preventClickEvent") ? ($.removeData(event.target, that.widgetName + ".preventClickEvent"), event.stopImmediatePropagation(), !1) : void 0
                }), this.started = !1
            },_mouseDestroy: function() {
                this.element.unbind("." + this.widgetName), this._mouseMoveDelegate && this.document.unbind("mousemove." + this.widgetName, this._mouseMoveDelegate).unbind("mouseup." + this.widgetName, this._mouseUpDelegate)
            },_mouseDown: function(event) {
                if (!mouseHandled) {
                    this._mouseMoved = !1, this._mouseStarted && this._mouseUp(event), this._mouseDownEvent = event;
                    var that = this, btnIsLeft = 1 === event.which, elIsCancel = "string" == typeof this.options.cancel && event.target.nodeName ? $(event.target).closest(this.options.cancel).length : !1;
                    return btnIsLeft && !elIsCancel && this._mouseCapture(event) ? (this.mouseDelayMet = !this.options.delay, this.mouseDelayMet || (this._mouseDelayTimer = setTimeout(function() {
                        that.mouseDelayMet = !0
                    }, this.options.delay)), this._mouseDistanceMet(event) && this._mouseDelayMet(event) && (this._mouseStarted = this._mouseStart(event) !== !1, !this._mouseStarted) ? (event.preventDefault(), !0) : (!0 === $.data(event.target, this.widgetName + ".preventClickEvent") && $.removeData(event.target, this.widgetName + ".preventClickEvent"), this._mouseMoveDelegate = function(event) {
                        return that._mouseMove(event)
                    }, this._mouseUpDelegate = function(event) {
                        return that._mouseUp(event)
                    }, this.document.bind("mousemove." + this.widgetName, this._mouseMoveDelegate).bind("mouseup." + this.widgetName, this._mouseUpDelegate), event.preventDefault(), mouseHandled = !0, !0)) : !0
                }
            },_mouseMove: function(event) {
                if (this._mouseMoved) {
                    if ($.ui.ie && (!document.documentMode || document.documentMode < 9) && !event.button)
                        return this._mouseUp(event);
                    if (!event.which)
                        return this._mouseUp(event)
                }
                return (event.which || event.button) && (this._mouseMoved = !0), this._mouseStarted ? (this._mouseDrag(event), event.preventDefault()) : (this._mouseDistanceMet(event) && this._mouseDelayMet(event) && (this._mouseStarted = this._mouseStart(this._mouseDownEvent, event) !== !1, this._mouseStarted ? this._mouseDrag(event) : this._mouseUp(event)), !this._mouseStarted)
            },_mouseUp: function(event) {
                return this.document.unbind("mousemove." + this.widgetName, this._mouseMoveDelegate).unbind("mouseup." + this.widgetName, this._mouseUpDelegate), this._mouseStarted && (this._mouseStarted = !1, event.target === this._mouseDownEvent.target && $.data(event.target, this.widgetName + ".preventClickEvent", !0), this._mouseStop(event)), mouseHandled = !1, !1
            },_mouseDistanceMet: function(event) {
                return Math.max(Math.abs(this._mouseDownEvent.pageX - event.pageX), Math.abs(this._mouseDownEvent.pageY - event.pageY)) >= this.options.distance
            },_mouseDelayMet: function() {
                return this.mouseDelayMet
            },_mouseStart: function() {
            },_mouseDrag: function() {
            },_mouseStop: function() {
            },_mouseCapture: function() {
                return !0
            }});
        !function() {
            function getOffsets(offsets, width, height) {
                return [parseFloat(offsets[0]) * (rpercent.test(offsets[0]) ? width / 100 : 1), parseFloat(offsets[1]) * (rpercent.test(offsets[1]) ? height / 100 : 1)]
            }
            function parseCss(element, property) {
                return parseInt($.css(element, property), 10) || 0
            }
            function getDimensions(elem) {
                var raw = elem[0];
                return 9 === raw.nodeType ? {width: elem.width(),height: elem.height(),offset: {top: 0,left: 0}} : $.isWindow(raw) ? {width: elem.width(),height: elem.height(),offset: {top: elem.scrollTop(),left: elem.scrollLeft()}} : raw.preventDefault ? {width: 0,height: 0,offset: {top: raw.pageY,left: raw.pageX}} : {width: elem.outerWidth(),height: elem.outerHeight(),offset: elem.offset()}
            }
            $.ui = $.ui || {};
            var cachedScrollbarWidth, supportsOffsetFractions, max = Math.max, abs = Math.abs, round = Math.round, rhorizontal = /left|center|right/, rvertical = /top|center|bottom/, roffset = /[\+\-]\d+(\.[\d]+)?%?/, rposition = /^\w+/, rpercent = /%$/, _position = $.fn.position;
            $.position = {scrollbarWidth: function() {
                    if (void 0 !== cachedScrollbarWidth)
                        return cachedScrollbarWidth;
                    var w1, w2, div = $("<div style='display:block;position:absolute;width:50px;height:50px;overflow:hidden;'><div style='height:100px;width:auto;'></div></div>"), innerDiv = div.children()[0];
                    return $("body").append(div), w1 = innerDiv.offsetWidth, div.css("overflow", "scroll"), w2 = innerDiv.offsetWidth, w1 === w2 && (w2 = div[0].clientWidth), div.remove(), cachedScrollbarWidth = w1 - w2
                },getScrollInfo: function(within) {
                    var overflowX = within.isWindow || within.isDocument ? "" : within.element.css("overflow-x"), overflowY = within.isWindow || within.isDocument ? "" : within.element.css("overflow-y"), hasOverflowX = "scroll" === overflowX || "auto" === overflowX && within.width < within.element[0].scrollWidth, hasOverflowY = "scroll" === overflowY || "auto" === overflowY && within.height < within.element[0].scrollHeight;
                    return {width: hasOverflowY ? $.position.scrollbarWidth() : 0,height: hasOverflowX ? $.position.scrollbarWidth() : 0}
                },getWithinInfo: function(element) {
                    var withinElement = $(element || window), isWindow = $.isWindow(withinElement[0]), isDocument = !!withinElement[0] && 9 === withinElement[0].nodeType;
                    return {element: withinElement,isWindow: isWindow,isDocument: isDocument,offset: withinElement.offset() || {left: 0,top: 0},scrollLeft: withinElement.scrollLeft(),scrollTop: withinElement.scrollTop(),width: isWindow || isDocument ? withinElement.width() : withinElement.outerWidth(),height: isWindow || isDocument ? withinElement.height() : withinElement.outerHeight()}
                }}, $.fn.position = function(options) {
                if (!options || !options.of)
                    return _position.apply(this, arguments);
                options = $.extend({}, options);
                var atOffset, targetWidth, targetHeight, targetOffset, basePosition, dimensions, target = $(options.of), within = $.position.getWithinInfo(options.within), scrollInfo = $.position.getScrollInfo(within), collision = (options.collision || "flip").split(" "), offsets = {};
                return dimensions = getDimensions(target), target[0].preventDefault && (options.at = "left top"), targetWidth = dimensions.width, targetHeight = dimensions.height, targetOffset = dimensions.offset, basePosition = $.extend({}, targetOffset), $.each(["my", "at"], function() {
                    var horizontalOffset, verticalOffset, pos = (options[this] || "").split(" ");
                    1 === pos.length && (pos = rhorizontal.test(pos[0]) ? pos.concat(["center"]) : rvertical.test(pos[0]) ? ["center"].concat(pos) : ["center", "center"]), pos[0] = rhorizontal.test(pos[0]) ? pos[0] : "center", pos[1] = rvertical.test(pos[1]) ? pos[1] : "center", horizontalOffset = roffset.exec(pos[0]), verticalOffset = roffset.exec(pos[1]), offsets[this] = [horizontalOffset ? horizontalOffset[0] : 0, verticalOffset ? verticalOffset[0] : 0], options[this] = [rposition.exec(pos[0])[0], rposition.exec(pos[1])[0]]
                }), 1 === collision.length && (collision[1] = collision[0]), "right" === options.at[0] ? basePosition.left += targetWidth : "center" === options.at[0] && (basePosition.left += targetWidth / 2), "bottom" === options.at[1] ? basePosition.top += targetHeight : "center" === options.at[1] && (basePosition.top += targetHeight / 2), atOffset = getOffsets(offsets.at, targetWidth, targetHeight), basePosition.left += atOffset[0], basePosition.top += atOffset[1], this.each(function() {
                    var collisionPosition, using, elem = $(this), elemWidth = elem.outerWidth(), elemHeight = elem.outerHeight(), marginLeft = parseCss(this, "marginLeft"), marginTop = parseCss(this, "marginTop"), collisionWidth = elemWidth + marginLeft + parseCss(this, "marginRight") + scrollInfo.width, collisionHeight = elemHeight + marginTop + parseCss(this, "marginBottom") + scrollInfo.height, position = $.extend({}, basePosition), myOffset = getOffsets(offsets.my, elem.outerWidth(), elem.outerHeight());
                    "right" === options.my[0] ? position.left -= elemWidth : "center" === options.my[0] && (position.left -= elemWidth / 2), "bottom" === options.my[1] ? position.top -= elemHeight : "center" === options.my[1] && (position.top -= elemHeight / 2), position.left += myOffset[0], position.top += myOffset[1], supportsOffsetFractions || (position.left = round(position.left), position.top = round(position.top)), collisionPosition = {marginLeft: marginLeft,marginTop: marginTop}, $.each(["left", "top"], function(i, dir) {
                        $.ui.position[collision[i]] && $.ui.position[collision[i]][dir](position, {targetWidth: targetWidth,targetHeight: targetHeight,elemWidth: elemWidth,elemHeight: elemHeight,collisionPosition: collisionPosition,collisionWidth: collisionWidth,collisionHeight: collisionHeight,offset: [atOffset[0] + myOffset[0], atOffset[1] + myOffset[1]],my: options.my,at: options.at,within: within,elem: elem})
                    }), options.using && (using = function(props) {
                        var left = targetOffset.left - position.left, right = left + targetWidth - elemWidth, top = targetOffset.top - position.top, bottom = top + targetHeight - elemHeight, feedback = {target: {element: target,left: targetOffset.left,top: targetOffset.top,width: targetWidth,height: targetHeight},element: {element: elem,left: position.left,top: position.top,width: elemWidth,height: elemHeight},horizontal: 0 > right ? "left" : left > 0 ? "right" : "center",vertical: 0 > bottom ? "top" : top > 0 ? "bottom" : "middle"};
                        elemWidth > targetWidth && abs(left + right) < targetWidth && (feedback.horizontal = "center"), elemHeight > targetHeight && abs(top + bottom) < targetHeight && (feedback.vertical = "middle"), max(abs(left), abs(right)) > max(abs(top), abs(bottom)) ? feedback.important = "horizontal" : feedback.important = "vertical", options.using.call(this, props, feedback)
                    }), elem.offset($.extend(position, {using: using}))
                })
            }, $.ui.position = {fit: {left: function(position, data) {
                        var newOverRight, within = data.within, withinOffset = within.isWindow ? within.scrollLeft : within.offset.left, outerWidth = within.width, collisionPosLeft = position.left - data.collisionPosition.marginLeft, overLeft = withinOffset - collisionPosLeft, overRight = collisionPosLeft + data.collisionWidth - outerWidth - withinOffset;
                        data.collisionWidth > outerWidth ? overLeft > 0 && 0 >= overRight ? (newOverRight = position.left + overLeft + data.collisionWidth - outerWidth - withinOffset, position.left += overLeft - newOverRight) : overRight > 0 && 0 >= overLeft ? position.left = withinOffset : overLeft > overRight ? position.left = withinOffset + outerWidth - data.collisionWidth : position.left = withinOffset : overLeft > 0 ? position.left += overLeft : overRight > 0 ? position.left -= overRight : position.left = max(position.left - collisionPosLeft, position.left)
                    },top: function(position, data) {
                        var newOverBottom, within = data.within, withinOffset = within.isWindow ? within.scrollTop : within.offset.top, outerHeight = data.within.height, collisionPosTop = position.top - data.collisionPosition.marginTop, overTop = withinOffset - collisionPosTop, overBottom = collisionPosTop + data.collisionHeight - outerHeight - withinOffset;
                        data.collisionHeight > outerHeight ? overTop > 0 && 0 >= overBottom ? (newOverBottom = position.top + overTop + data.collisionHeight - outerHeight - withinOffset, position.top += overTop - newOverBottom) : overBottom > 0 && 0 >= overTop ? position.top = withinOffset : overTop > overBottom ? position.top = withinOffset + outerHeight - data.collisionHeight : position.top = withinOffset : overTop > 0 ? position.top += overTop : overBottom > 0 ? position.top -= overBottom : position.top = max(position.top - collisionPosTop, position.top)
                    }},flip: {left: function(position, data) {
                        var newOverRight, newOverLeft, within = data.within, withinOffset = within.offset.left + within.scrollLeft, outerWidth = within.width, offsetLeft = within.isWindow ? within.scrollLeft : within.offset.left, collisionPosLeft = position.left - data.collisionPosition.marginLeft, overLeft = collisionPosLeft - offsetLeft, overRight = collisionPosLeft + data.collisionWidth - outerWidth - offsetLeft, myOffset = "left" === data.my[0] ? -data.elemWidth : "right" === data.my[0] ? data.elemWidth : 0, atOffset = "left" === data.at[0] ? data.targetWidth : "right" === data.at[0] ? -data.targetWidth : 0, offset = -2 * data.offset[0];
                        0 > overLeft ? (newOverRight = position.left + myOffset + atOffset + offset + data.collisionWidth - outerWidth - withinOffset, (0 > newOverRight || newOverRight < abs(overLeft)) && (position.left += myOffset + atOffset + offset)) : overRight > 0 && (newOverLeft = position.left - data.collisionPosition.marginLeft + myOffset + atOffset + offset - offsetLeft, (newOverLeft > 0 || abs(newOverLeft) < overRight) && (position.left += myOffset + atOffset + offset))
                    },top: function(position, data) {
                        var newOverTop, newOverBottom, within = data.within, withinOffset = within.offset.top + within.scrollTop, outerHeight = within.height, offsetTop = within.isWindow ? within.scrollTop : within.offset.top, collisionPosTop = position.top - data.collisionPosition.marginTop, overTop = collisionPosTop - offsetTop, overBottom = collisionPosTop + data.collisionHeight - outerHeight - offsetTop, top = "top" === data.my[1], myOffset = top ? -data.elemHeight : "bottom" === data.my[1] ? data.elemHeight : 0, atOffset = "top" === data.at[1] ? data.targetHeight : "bottom" === data.at[1] ? -data.targetHeight : 0, offset = -2 * data.offset[1];
                        0 > overTop ? (newOverBottom = position.top + myOffset + atOffset + offset + data.collisionHeight - outerHeight - withinOffset, (0 > newOverBottom || newOverBottom < abs(overTop)) && (position.top += myOffset + atOffset + offset)) : overBottom > 0 && (newOverTop = position.top - data.collisionPosition.marginTop + myOffset + atOffset + offset - offsetTop, (newOverTop > 0 || abs(newOverTop) < overBottom) && (position.top += myOffset + atOffset + offset))
                    }},flipfit: {left: function() {
                        $.ui.position.flip.left.apply(this, arguments), $.ui.position.fit.left.apply(this, arguments)
                    },top: function() {
                        $.ui.position.flip.top.apply(this, arguments), $.ui.position.fit.top.apply(this, arguments)
                    }}}, function() {
                var testElement, testElementParent, testElementStyle, offsetLeft, i, body = document.getElementsByTagName("body")[0], div = document.createElement("div");
                testElement = document.createElement(body ? "div" : "body"), testElementStyle = {visibility: "hidden",width: 0,height: 0,border: 0,margin: 0,background: "none"}, body && $.extend(testElementStyle, {position: "absolute",left: "-1000px",top: "-1000px"});
                for (i in testElementStyle)
                    testElement.style[i] = testElementStyle[i];
                testElement.appendChild(div), testElementParent = body || document.documentElement, testElementParent.insertBefore(testElement, testElementParent.firstChild), div.style.cssText = "position: absolute; left: 10.7432222px;", offsetLeft = $(div).offset().left, supportsOffsetFractions = offsetLeft > 10 && 11 > offsetLeft, testElement.innerHTML = "", testElementParent.removeChild(testElement)
            }()
        }();
        $.ui.position, $.widget("ui.accordion", {version: "1.11.4",options: {active: 0,animate: {},collapsible: !1,event: "click",header: "> li > :first-child,> :not(li):even",heightStyle: "auto",icons: {activeHeader: "ui-icon-triangle-1-s",header: "ui-icon-triangle-1-e"},activate: null,beforeActivate: null},hideProps: {borderTopWidth: "hide",borderBottomWidth: "hide",paddingTop: "hide",paddingBottom: "hide",height: "hide"},showProps: {borderTopWidth: "show",borderBottomWidth: "show",paddingTop: "show",paddingBottom: "show",height: "show"},_create: function() {
                var options = this.options;
                this.prevShow = this.prevHide = $(), this.element.addClass("ui-accordion ui-widget ui-helper-reset").attr("role", "tablist"), options.collapsible || options.active !== !1 && null != options.active || (options.active = 0), this._processPanels(), options.active < 0 && (options.active += this.headers.length), this._refresh()
            },_getCreateEventData: function() {
                return {header: this.active,panel: this.active.length ? this.active.next() : $()}
            },_createIcons: function() {
                var icons = this.options.icons;
                icons && ($("<span>").addClass("ui-accordion-header-icon ui-icon " + icons.header).prependTo(this.headers), this.active.children(".ui-accordion-header-icon").removeClass(icons.header).addClass(icons.activeHeader), this.headers.addClass("ui-accordion-icons"))
            },_destroyIcons: function() {
                this.headers.removeClass("ui-accordion-icons").children(".ui-accordion-header-icon").remove()
            },_destroy: function() {
                var contents;
                this.element.removeClass("ui-accordion ui-widget ui-helper-reset").removeAttr("role"), this.headers.removeClass("ui-accordion-header ui-accordion-header-active ui-state-default ui-corner-all ui-state-active ui-state-disabled ui-corner-top").removeAttr("role").removeAttr("aria-expanded").removeAttr("aria-selected").removeAttr("aria-controls").removeAttr("tabIndex").removeUniqueId(), this._destroyIcons(), contents = this.headers.next().removeClass("ui-helper-reset ui-widget-content ui-corner-bottom ui-accordion-content ui-accordion-content-active ui-state-disabled").css("display", "").removeAttr("role").removeAttr("aria-hidden").removeAttr("aria-labelledby").removeUniqueId(), "content" !== this.options.heightStyle && contents.css("height", "")
            },_setOption: function(key, value) {
                return "active" === key ? void this._activate(value) : ("event" === key && (this.options.event && this._off(this.headers, this.options.event), this._setupEvents(value)), this._super(key, value), "collapsible" !== key || value || this.options.active !== !1 || this._activate(0), "icons" === key && (this._destroyIcons(), value && this._createIcons()), void ("disabled" === key && (this.element.toggleClass("ui-state-disabled", !!value).attr("aria-disabled", value), this.headers.add(this.headers.next()).toggleClass("ui-state-disabled", !!value))))
            },_keydown: function(event) {
                if (!event.altKey && !event.ctrlKey) {
                    var keyCode = $.ui.keyCode, length = this.headers.length, currentIndex = this.headers.index(event.target), toFocus = !1;
                    switch (event.keyCode) {
                        case keyCode.RIGHT:
                        case keyCode.DOWN:
                            toFocus = this.headers[(currentIndex + 1) % length];
                            break;
                        case keyCode.LEFT:
                        case keyCode.UP:
                            toFocus = this.headers[(currentIndex - 1 + length) % length];
                            break;
                        case keyCode.SPACE:
                        case keyCode.ENTER:
                            this._eventHandler(event);
                            break;
                        case keyCode.HOME:
                            toFocus = this.headers[0];
                            break;
                        case keyCode.END:
                            toFocus = this.headers[length - 1]
                    }
                    toFocus && ($(event.target).attr("tabIndex", -1), $(toFocus).attr("tabIndex", 0), toFocus.focus(), event.preventDefault())
                }
            },_panelKeyDown: function(event) {
                event.keyCode === $.ui.keyCode.UP && event.ctrlKey && $(event.currentTarget).prev().focus()
            },refresh: function() {
                var options = this.options;
                this._processPanels(), options.active === !1 && options.collapsible === !0 || !this.headers.length ? (options.active = !1, this.active = $()) : options.active === !1 ? this._activate(0) : this.active.length && !$.contains(this.element[0], this.active[0]) ? this.headers.length === this.headers.find(".ui-state-disabled").length ? (options.active = !1, this.active = $()) : this._activate(Math.max(0, options.active - 1)) : options.active = this.headers.index(this.active), this._destroyIcons(), this._refresh()
            },_processPanels: function() {
                var prevHeaders = this.headers, prevPanels = this.panels;
                this.headers = this.element.find(this.options.header).addClass("ui-accordion-header ui-state-default ui-corner-all"), this.panels = this.headers.next().addClass("ui-accordion-content ui-helper-reset ui-widget-content ui-corner-bottom").filter(":not(.ui-accordion-content-active)").hide(), prevPanels && (this._off(prevHeaders.not(this.headers)), this._off(prevPanels.not(this.panels)))
            },_refresh: function() {
                var maxHeight, options = this.options, heightStyle = options.heightStyle, parent = this.element.parent();
                this.active = this._findActive(options.active).addClass("ui-accordion-header-active ui-state-active ui-corner-top").removeClass("ui-corner-all"), this.active.next().addClass("ui-accordion-content-active").show(), this.headers.attr("role", "tab").each(function() {
                    var header = $(this), headerId = header.uniqueId().attr("id"), panel = header.next(), panelId = panel.uniqueId().attr("id");
                    header.attr("aria-controls", panelId), panel.attr("aria-labelledby", headerId)
                }).next().attr("role", "tabpanel"), this.headers.not(this.active).attr({"aria-selected": "false","aria-expanded": "false",tabIndex: -1}).next().attr({"aria-hidden": "true"}).hide(), this.active.length ? this.active.attr({"aria-selected": "true","aria-expanded": "true",tabIndex: 0}).next().attr({"aria-hidden": "false"}) : this.headers.eq(0).attr("tabIndex", 0), this._createIcons(), this._setupEvents(options.event), "fill" === heightStyle ? (maxHeight = parent.height(), this.element.siblings(":visible").each(function() {
                    var elem = $(this), position = elem.css("position");
                    "absolute" !== position && "fixed" !== position && (maxHeight -= elem.outerHeight(!0))
                }), this.headers.each(function() {
                    maxHeight -= $(this).outerHeight(!0)
                }), this.headers.next().each(function() {
                    $(this).height(Math.max(0, maxHeight - $(this).innerHeight() + $(this).height()))
                }).css("overflow", "auto")) : "auto" === heightStyle && (maxHeight = 0, this.headers.next().each(function() {
                    maxHeight = Math.max(maxHeight, $(this).css("height", "").height())
                }).height(maxHeight))
            },_activate: function(index) {
                var active = this._findActive(index)[0];
                active !== this.active[0] && (active = active || this.active[0], this._eventHandler({target: active,currentTarget: active,preventDefault: $.noop}))
            },_findActive: function(selector) {
                return "number" == typeof selector ? this.headers.eq(selector) : $()
            },_setupEvents: function(event) {
                var events = {keydown: "_keydown"};
                event && $.each(event.split(" "), function(index, eventName) {
                    events[eventName] = "_eventHandler"
                }), this._off(this.headers.add(this.headers.next())), this._on(this.headers, events), this._on(this.headers.next(), {keydown: "_panelKeyDown"}), this._hoverable(this.headers), this._focusable(this.headers)
            },_eventHandler: function(event) {
                var options = this.options, active = this.active, clicked = $(event.currentTarget), clickedIsActive = clicked[0] === active[0], collapsing = clickedIsActive && options.collapsible, toShow = collapsing ? $() : clicked.next(), toHide = active.next(), eventData = {oldHeader: active,oldPanel: toHide,newHeader: collapsing ? $() : clicked,newPanel: toShow};
                event.preventDefault(), clickedIsActive && !options.collapsible || this._trigger("beforeActivate", event, eventData) === !1 || (options.active = collapsing ? !1 : this.headers.index(clicked), this.active = clickedIsActive ? $() : clicked, this._toggle(eventData), active.removeClass("ui-accordion-header-active ui-state-active"), options.icons && active.children(".ui-accordion-header-icon").removeClass(options.icons.activeHeader).addClass(options.icons.header), clickedIsActive || (clicked.removeClass("ui-corner-all").addClass("ui-accordion-header-active ui-state-active ui-corner-top"), options.icons && clicked.children(".ui-accordion-header-icon").removeClass(options.icons.header).addClass(options.icons.activeHeader), clicked.next().addClass("ui-accordion-content-active")))
            },_toggle: function(data) {
                var toShow = data.newPanel, toHide = this.prevShow.length ? this.prevShow : data.oldPanel;
                this.prevShow.add(this.prevHide).stop(!0, !0), this.prevShow = toShow, this.prevHide = toHide, this.options.animate ? this._animate(toShow, toHide, data) : (toHide.hide(), toShow.show(), this._toggleComplete(data)), toHide.attr({"aria-hidden": "true"}), toHide.prev().attr({"aria-selected": "false","aria-expanded": "false"}), toShow.length && toHide.length ? toHide.prev().attr({tabIndex: -1,"aria-expanded": "false"}) : toShow.length && this.headers.filter(function() {
                    return 0 === parseInt($(this).attr("tabIndex"), 10)
                }).attr("tabIndex", -1), toShow.attr("aria-hidden", "false").prev().attr({"aria-selected": "true","aria-expanded": "true",tabIndex: 0})
            },_animate: function(toShow, toHide, data) {
                var total, easing, duration, that = this, adjust = 0, boxSizing = toShow.css("box-sizing"), down = toShow.length && (!toHide.length || toShow.index() < toHide.index()), animate = this.options.animate || {}, options = down && animate.down || animate, complete = function() {
                    that._toggleComplete(data)
                };
                return "number" == typeof options && (duration = options), "string" == typeof options && (easing = options), easing = easing || options.easing || animate.easing, duration = duration || options.duration || animate.duration, toHide.length ? toShow.length ? (total = toShow.show().outerHeight(), toHide.animate(this.hideProps, {duration: duration,easing: easing,step: function(now, fx) {
                        fx.now = Math.round(now)
                    }}), void toShow.hide().animate(this.showProps, {duration: duration,easing: easing,complete: complete,step: function(now, fx) {
                        fx.now = Math.round(now), "height" !== fx.prop ? "content-box" === boxSizing && (adjust += fx.now) : "content" !== that.options.heightStyle && (fx.now = Math.round(total - toHide.outerHeight() - adjust), adjust = 0)
                    }})) : toHide.animate(this.hideProps, duration, easing, complete) : toShow.animate(this.showProps, duration, easing, complete)
            },_toggleComplete: function(data) {
                var toHide = data.oldPanel;
                toHide.removeClass("ui-accordion-content-active").prev().removeClass("ui-corner-top").addClass("ui-corner-all"), toHide.length && (toHide.parent()[0].className = toHide.parent()[0].className), this._trigger("activate", null, data)
            }}), $.widget("ui.menu", {version: "1.11.4",defaultElement: "<ul>",delay: 300,options: {icons: {submenu: "ui-icon-carat-1-e"},items: "> *",menus: "ul",position: {my: "left-1 top",at: "right top"},role: "menu",blur: null,focus: null,select: null},_create: function() {
                this.activeMenu = this.element, this.mouseHandled = !1, this.element.uniqueId().addClass("ui-menu ui-widget ui-widget-content").toggleClass("ui-menu-icons", !!this.element.find(".ui-icon").length).attr({role: this.options.role,tabIndex: 0}), this.options.disabled && this.element.addClass("ui-state-disabled").attr("aria-disabled", "true"), this._on({"mousedown .ui-menu-item": function(event) {
                        event.preventDefault()
                    },"click .ui-menu-item": function(event) {
                        var target = $(event.target);
                        !this.mouseHandled && target.not(".ui-state-disabled").length && (this.select(event), event.isPropagationStopped() || (this.mouseHandled = !0), target.has(".ui-menu").length ? this.expand(event) : !this.element.is(":focus") && $(this.document[0].activeElement).closest(".ui-menu").length && (this.element.trigger("focus", [!0]), this.active && 1 === this.active.parents(".ui-menu").length && clearTimeout(this.timer)))
                    },"mouseenter .ui-menu-item": function(event) {
                        if (!this.previousFilter) {
                            var target = $(event.currentTarget);
                            target.siblings(".ui-state-active").removeClass("ui-state-active"), this.focus(event, target)
                        }
                    },mouseleave: "collapseAll","mouseleave .ui-menu": "collapseAll",focus: function(event, keepActiveItem) {
                        var item = this.active || this.element.find(this.options.items).eq(0);
                        keepActiveItem || this.focus(event, item)
                    },blur: function(event) {
                        this._delay(function() {
                            $.contains(this.element[0], this.document[0].activeElement) || this.collapseAll(event)
                        })
                    },keydown: "_keydown"}), this.refresh(), this._on(this.document, {click: function(event) {
                        this._closeOnDocumentClick(event) && this.collapseAll(event), this.mouseHandled = !1
                    }})
            },_destroy: function() {
                this.element.removeAttr("aria-activedescendant").find(".ui-menu").addBack().removeClass("ui-menu ui-widget ui-widget-content ui-menu-icons ui-front").removeAttr("role").removeAttr("tabIndex").removeAttr("aria-labelledby").removeAttr("aria-expanded").removeAttr("aria-hidden").removeAttr("aria-disabled").removeUniqueId().show(), this.element.find(".ui-menu-item").removeClass("ui-menu-item").removeAttr("role").removeAttr("aria-disabled").removeUniqueId().removeClass("ui-state-hover").removeAttr("tabIndex").removeAttr("role").removeAttr("aria-haspopup").children().each(function() {
                    var elem = $(this);
                    elem.data("ui-menu-submenu-carat") && elem.remove()
                }), this.element.find(".ui-menu-divider").removeClass("ui-menu-divider ui-widget-content")
            },_keydown: function(event) {
                var match, prev, character, skip, preventDefault = !0;
                switch (event.keyCode) {
                    case $.ui.keyCode.PAGE_UP:
                        this.previousPage(event);
                        break;
                    case $.ui.keyCode.PAGE_DOWN:
                        this.nextPage(event);
                        break;
                    case $.ui.keyCode.HOME:
                        this._move("first", "first", event);
                        break;
                    case $.ui.keyCode.END:
                        this._move("last", "last", event);
                        break;
                    case $.ui.keyCode.UP:
                        this.previous(event);
                        break;
                    case $.ui.keyCode.DOWN:
                        this.next(event);
                        break;
                    case $.ui.keyCode.LEFT:
                        this.collapse(event);
                        break;
                    case $.ui.keyCode.RIGHT:
                        this.active && !this.active.is(".ui-state-disabled") && this.expand(event);
                        break;
                    case $.ui.keyCode.ENTER:
                    case $.ui.keyCode.SPACE:
                        this._activate(event);
                        break;
                    case $.ui.keyCode.ESCAPE:
                        this.collapse(event);
                        break;
                    default:
                        preventDefault = !1, prev = this.previousFilter || "", character = String.fromCharCode(event.keyCode), skip = !1, clearTimeout(this.filterTimer), character === prev ? skip = !0 : character = prev + character, match = this._filterMenuItems(character), match = skip && -1 !== match.index(this.active.next()) ? this.active.nextAll(".ui-menu-item") : match, match.length || (character = String.fromCharCode(event.keyCode), match = this._filterMenuItems(character)), match.length ? (this.focus(event, match), this.previousFilter = character, this.filterTimer = this._delay(function() {
                            delete this.previousFilter
                        }, 1e3)) : delete this.previousFilter
                }
                preventDefault && event.preventDefault()
            },_activate: function(event) {
                this.active.is(".ui-state-disabled") || (this.active.is("[aria-haspopup='true']") ? this.expand(event) : this.select(event))
            },refresh: function() {
                var menus, items, that = this, icon = this.options.icons.submenu, submenus = this.element.find(this.options.menus);
                this.element.toggleClass("ui-menu-icons", !!this.element.find(".ui-icon").length), submenus.filter(":not(.ui-menu)").addClass("ui-menu ui-widget ui-widget-content ui-front").hide().attr({role: this.options.role,"aria-hidden": "true","aria-expanded": "false"}).each(function() {
                    var menu = $(this), item = menu.parent(), submenuCarat = $("<span>").addClass("ui-menu-icon ui-icon " + icon).data("ui-menu-submenu-carat", !0);
                    item.attr("aria-haspopup", "true").prepend(submenuCarat), menu.attr("aria-labelledby", item.attr("id"))
                }), menus = submenus.add(this.element), items = menus.find(this.options.items), items.not(".ui-menu-item").each(function() {
                    var item = $(this);
                    that._isDivider(item) && item.addClass("ui-widget-content ui-menu-divider")
                }), items.not(".ui-menu-item, .ui-menu-divider").addClass("ui-menu-item").uniqueId().attr({tabIndex: -1,role: this._itemRole()}), items.filter(".ui-state-disabled").attr("aria-disabled", "true"), this.active && !$.contains(this.element[0], this.active[0]) && this.blur()
            },_itemRole: function() {
                return {menu: "menuitem",listbox: "option"}[this.options.role]
            },_setOption: function(key, value) {
                "icons" === key && this.element.find(".ui-menu-icon").removeClass(this.options.icons.submenu).addClass(value.submenu), "disabled" === key && this.element.toggleClass("ui-state-disabled", !!value).attr("aria-disabled", value), this._super(key, value)
            },focus: function(event, item) {
                var nested, focused;
                this.blur(event, event && "focus" === event.type), this._scrollIntoView(item), this.active = item.first(), focused = this.active.addClass("ui-state-focus").removeClass("ui-state-active"), this.options.role && this.element.attr("aria-activedescendant", focused.attr("id")), this.active.parent().closest(".ui-menu-item").addClass("ui-state-active"), event && "keydown" === event.type ? this._close() : this.timer = this._delay(function() {
                    this._close()
                }, this.delay), nested = item.children(".ui-menu"), nested.length && event && /^mouse/.test(event.type) && this._startOpening(nested), this.activeMenu = item.parent(), this._trigger("focus", event, {item: item})
            },_scrollIntoView: function(item) {
                var borderTop, paddingTop, offset, scroll, elementHeight, itemHeight;
                this._hasScroll() && (borderTop = parseFloat($.css(this.activeMenu[0], "borderTopWidth")) || 0, paddingTop = parseFloat($.css(this.activeMenu[0], "paddingTop")) || 0, offset = item.offset().top - this.activeMenu.offset().top - borderTop - paddingTop, scroll = this.activeMenu.scrollTop(), elementHeight = this.activeMenu.height(), itemHeight = item.outerHeight(), 0 > offset ? this.activeMenu.scrollTop(scroll + offset) : offset + itemHeight > elementHeight && this.activeMenu.scrollTop(scroll + offset - elementHeight + itemHeight))
            },blur: function(event, fromFocus) {
                fromFocus || clearTimeout(this.timer), this.active && (this.active.removeClass("ui-state-focus"), this.active = null, this._trigger("blur", event, {item: this.active}))
            },_startOpening: function(submenu) {
                clearTimeout(this.timer), "true" === submenu.attr("aria-hidden") && (this.timer = this._delay(function() {
                    this._close(), this._open(submenu)
                }, this.delay))
            },_open: function(submenu) {
                var position = $.extend({of: this.active}, this.options.position);
                clearTimeout(this.timer), this.element.find(".ui-menu").not(submenu.parents(".ui-menu")).hide().attr("aria-hidden", "true"), submenu.show().removeAttr("aria-hidden").attr("aria-expanded", "true").position(position)
            },collapseAll: function(event, all) {
                clearTimeout(this.timer), this.timer = this._delay(function() {
                    var currentMenu = all ? this.element : $(event && event.target).closest(this.element.find(".ui-menu"));
                    currentMenu.length || (currentMenu = this.element), this._close(currentMenu), 
                    this.blur(event), this.activeMenu = currentMenu
                }, this.delay)
            },_close: function(startMenu) {
                startMenu || (startMenu = this.active ? this.active.parent() : this.element), startMenu.find(".ui-menu").hide().attr("aria-hidden", "true").attr("aria-expanded", "false").end().find(".ui-state-active").not(".ui-state-focus").removeClass("ui-state-active")
            },_closeOnDocumentClick: function(event) {
                return !$(event.target).closest(".ui-menu").length
            },_isDivider: function(item) {
                return !/[^\-\u2014\u2013\s]/.test(item.text())
            },collapse: function(event) {
                var newItem = this.active && this.active.parent().closest(".ui-menu-item", this.element);
                newItem && newItem.length && (this._close(), this.focus(event, newItem))
            },expand: function(event) {
                var newItem = this.active && this.active.children(".ui-menu ").find(this.options.items).first();
                newItem && newItem.length && (this._open(newItem.parent()), this._delay(function() {
                    this.focus(event, newItem)
                }))
            },next: function(event) {
                this._move("next", "first", event)
            },previous: function(event) {
                this._move("prev", "last", event)
            },isFirstItem: function() {
                return this.active && !this.active.prevAll(".ui-menu-item").length
            },isLastItem: function() {
                return this.active && !this.active.nextAll(".ui-menu-item").length
            },_move: function(direction, filter, event) {
                var next;
                this.active && (next = "first" === direction || "last" === direction ? this.active["first" === direction ? "prevAll" : "nextAll"](".ui-menu-item").eq(-1) : this.active[direction + "All"](".ui-menu-item").eq(0)), next && next.length && this.active || (next = this.activeMenu.find(this.options.items)[filter]()), this.focus(event, next)
            },nextPage: function(event) {
                var item, base, height;
                return this.active ? void (this.isLastItem() || (this._hasScroll() ? (base = this.active.offset().top, height = this.element.height(), this.active.nextAll(".ui-menu-item").each(function() {
                    return item = $(this), item.offset().top - base - height < 0
                }), this.focus(event, item)) : this.focus(event, this.activeMenu.find(this.options.items)[this.active ? "last" : "first"]()))) : void this.next(event)
            },previousPage: function(event) {
                var item, base, height;
                return this.active ? void (this.isFirstItem() || (this._hasScroll() ? (base = this.active.offset().top, height = this.element.height(), this.active.prevAll(".ui-menu-item").each(function() {
                    return item = $(this), item.offset().top - base + height > 0
                }), this.focus(event, item)) : this.focus(event, this.activeMenu.find(this.options.items).first()))) : void this.next(event)
            },_hasScroll: function() {
                return this.element.outerHeight() < this.element.prop("scrollHeight")
            },select: function(event) {
                this.active = this.active || $(event.target).closest(".ui-menu-item");
                var ui = {item: this.active};
                this.active.has(".ui-menu").length || this.collapseAll(event, !0), this._trigger("select", event, ui)
            },_filterMenuItems: function(character) {
                var escapedCharacter = character.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g, "\\$&"), regex = new RegExp("^" + escapedCharacter, "i");
                return this.activeMenu.find(this.options.items).filter(".ui-menu-item").filter(function() {
                    return regex.test($.trim($(this).text()))
                })
            }});
        $.widget("ui.autocomplete", {version: "1.11.4",defaultElement: "<input>",options: {appendTo: null,autoFocus: !1,delay: 300,minLength: 1,position: {my: "left top",at: "left bottom",collision: "none"},source: null,change: null,close: null,focus: null,open: null,response: null,search: null,select: null},requestIndex: 0,pending: 0,_create: function() {
                var suppressKeyPress, suppressKeyPressRepeat, suppressInput, nodeName = this.element[0].nodeName.toLowerCase(), isTextarea = "textarea" === nodeName, isInput = "input" === nodeName;
                this.isMultiLine = isTextarea ? !0 : isInput ? !1 : this.element.prop("isContentEditable"), this.valueMethod = this.element[isTextarea || isInput ? "val" : "text"], this.isNewMenu = !0, this.element.addClass("ui-autocomplete-input").attr("autocomplete", "off"), this._on(this.element, {keydown: function(event) {
                        if (this.element.prop("readOnly"))
                            return suppressKeyPress = !0, suppressInput = !0, void (suppressKeyPressRepeat = !0);
                        suppressKeyPress = !1, suppressInput = !1, suppressKeyPressRepeat = !1;
                        var keyCode = $.ui.keyCode;
                        switch (event.keyCode) {
                            case keyCode.PAGE_UP:
                                suppressKeyPress = !0, this._move("previousPage", event);
                                break;
                            case keyCode.PAGE_DOWN:
                                suppressKeyPress = !0, this._move("nextPage", event);
                                break;
                            case keyCode.UP:
                                suppressKeyPress = !0, this._keyEvent("previous", event);
                                break;
                            case keyCode.DOWN:
                                suppressKeyPress = !0, this._keyEvent("next", event);
                                break;
                            case keyCode.ENTER:
                                this.menu.active && (suppressKeyPress = !0, event.preventDefault(), this.menu.select(event));
                                break;
                            case keyCode.TAB:
                                this.menu.active && this.menu.select(event);
                                break;
                            case keyCode.ESCAPE:
                                this.menu.element.is(":visible") && (this.isMultiLine || this._value(this.term), this.close(event), event.preventDefault());
                                break;
                            default:
                                suppressKeyPressRepeat = !0, this._searchTimeout(event)
                        }
                    },keypress: function(event) {
                        if (suppressKeyPress)
                            return suppressKeyPress = !1, void ((!this.isMultiLine || this.menu.element.is(":visible")) && event.preventDefault());
                        if (!suppressKeyPressRepeat) {
                            var keyCode = $.ui.keyCode;
                            switch (event.keyCode) {
                                case keyCode.PAGE_UP:
                                    this._move("previousPage", event);
                                    break;
                                case keyCode.PAGE_DOWN:
                                    this._move("nextPage", event);
                                    break;
                                case keyCode.UP:
                                    this._keyEvent("previous", event);
                                    break;
                                case keyCode.DOWN:
                                    this._keyEvent("next", event)
                            }
                        }
                    },input: function(event) {
                        return suppressInput ? (suppressInput = !1, void event.preventDefault()) : void this._searchTimeout(event)
                    },focus: function() {
                        this.selectedItem = null, this.previous = this._value()
                    },blur: function(event) {
                        return this.cancelBlur ? void delete this.cancelBlur : (clearTimeout(this.searching), this.close(event), void this._change(event))
                    }}), this._initSource(), this.menu = $("<ul>").addClass("ui-autocomplete ui-front").appendTo(this._appendTo()).menu({role: null}).hide().menu("instance"), this._on(this.menu.element, {mousedown: function(event) {
                        event.preventDefault(), this.cancelBlur = !0, this._delay(function() {
                            delete this.cancelBlur
                        });
                        var menuElement = this.menu.element[0];
                        $(event.target).closest(".ui-menu-item").length || this._delay(function() {
                            var that = this;
                            this.document.one("mousedown", function(event) {
                                event.target === that.element[0] || event.target === menuElement || $.contains(menuElement, event.target) || that.close()
                            })
                        })
                    },menufocus: function(event, ui) {
                        var label, item;
                        return this.isNewMenu && (this.isNewMenu = !1, event.originalEvent && /^mouse/.test(event.originalEvent.type)) ? (this.menu.blur(), void this.document.one("mousemove", function() {
                            $(event.target).trigger(event.originalEvent)
                        })) : (item = ui.item.data("ui-autocomplete-item"), !1 !== this._trigger("focus", event, {item: item}) && event.originalEvent && /^key/.test(event.originalEvent.type) && this._value(item.value), label = ui.item.attr("aria-label") || item.value, void (label && $.trim(label).length && (this.liveRegion.children().hide(), $("<div>").text(label).appendTo(this.liveRegion))))
                    },menuselect: function(event, ui) {
                        var item = ui.item.data("ui-autocomplete-item"), previous = this.previous;
                        this.element[0] !== this.document[0].activeElement && (this.element.focus(), this.previous = previous, this._delay(function() {
                            this.previous = previous, this.selectedItem = item
                        })), !1 !== this._trigger("select", event, {item: item}) && this._value(item.value), this.term = this._value(), this.close(event), this.selectedItem = item
                    }}), this.liveRegion = $("<span>", {role: "status","aria-live": "assertive","aria-relevant": "additions"}).addClass("ui-helper-hidden-accessible").appendTo(this.document[0].body), this._on(this.window, {beforeunload: function() {
                        this.element.removeAttr("autocomplete")
                    }})
            },_destroy: function() {
                clearTimeout(this.searching), this.element.removeClass("ui-autocomplete-input").removeAttr("autocomplete"), this.menu.element.remove(), this.liveRegion.remove()
            },_setOption: function(key, value) {
                this._super(key, value), "source" === key && this._initSource(), "appendTo" === key && this.menu.element.appendTo(this._appendTo()), "disabled" === key && value && this.xhr && this.xhr.abort()
            },_appendTo: function() {
                var element = this.options.appendTo;
                return element && (element = element.jquery || element.nodeType ? $(element) : this.document.find(element).eq(0)), element && element[0] || (element = this.element.closest(".ui-front")), element.length || (element = this.document[0].body), element
            },_initSource: function() {
                var array, url, that = this;
                $.isArray(this.options.source) ? (array = this.options.source, this.source = function(request, response) {
                    response($.ui.autocomplete.filter(array, request.term))
                }) : "string" == typeof this.options.source ? (url = this.options.source, this.source = function(request, response) {
                    that.xhr && that.xhr.abort(), that.xhr = $.ajax({url: url,data: request,dataType: "json",success: function(data) {
                            response(data)
                        },error: function() {
                            response([])
                        }})
                }) : this.source = this.options.source
            },_searchTimeout: function(event) {
                clearTimeout(this.searching), this.searching = this._delay(function() {
                    var equalValues = this.term === this._value(), menuVisible = this.menu.element.is(":visible"), modifierKey = event.altKey || event.ctrlKey || event.metaKey || event.shiftKey;
                    (!equalValues || equalValues && !menuVisible && !modifierKey) && (this.selectedItem = null, this.search(null, event))
                }, this.options.delay)
            },search: function(value, event) {
                return value = null != value ? value : this._value(), this.term = this._value(), value.length < this.options.minLength ? this.close(event) : this._trigger("search", event) !== !1 ? this._search(value) : void 0
            },_search: function(value) {
                this.pending++, this.element.addClass("ui-autocomplete-loading"), this.cancelSearch = !1, this.source({term: value}, this._response())
            },_response: function() {
                var index = ++this.requestIndex;
                return $.proxy(function(content) {
                    index === this.requestIndex && this.__response(content), this.pending--, this.pending || this.element.removeClass("ui-autocomplete-loading")
                }, this)
            },__response: function(content) {
                content && (content = this._normalize(content)), this._trigger("response", null, {content: content}), !this.options.disabled && content && content.length && !this.cancelSearch ? (this._suggest(content), this._trigger("open")) : this._close()
            },close: function(event) {
                this.cancelSearch = !0, this._close(event)
            },_close: function(event) {
                this.menu.element.is(":visible") && (this.menu.element.hide(), this.menu.blur(), this.isNewMenu = !0, this._trigger("close", event))
            },_change: function(event) {
                this.previous !== this._value() && this._trigger("change", event, {item: this.selectedItem})
            },_normalize: function(items) {
                return items.length && items[0].label && items[0].value ? items : $.map(items, function(item) {
                    return "string" == typeof item ? {label: item,value: item} : $.extend({}, item, {label: item.label || item.value,value: item.value || item.label})
                })
            },_suggest: function(items) {
                var ul = this.menu.element.empty();
                this._renderMenu(ul, items), this.isNewMenu = !0, this.menu.refresh(), ul.show(), this._resizeMenu(), ul.position($.extend({of: this.element}, this.options.position)), this.options.autoFocus && this.menu.next()
            },_resizeMenu: function() {
                var ul = this.menu.element;
                ul.outerWidth(Math.max(ul.width("").outerWidth() + 1, this.element.outerWidth()))
            },_renderMenu: function(ul, items) {
                var that = this;
                $.each(items, function(index, item) {
                    that._renderItemData(ul, item)
                })
            },_renderItemData: function(ul, item) {
                return this._renderItem(ul, item).data("ui-autocomplete-item", item)
            },_renderItem: function(ul, item) {
                return $("<li>").text(item.label).appendTo(ul)
            },_move: function(direction, event) {
                return this.menu.element.is(":visible") ? this.menu.isFirstItem() && /^previous/.test(direction) || this.menu.isLastItem() && /^next/.test(direction) ? (this.isMultiLine || this._value(this.term), void this.menu.blur()) : void this.menu[direction](event) : void this.search(null, event)
            },widget: function() {
                return this.menu.element
            },_value: function() {
                return this.valueMethod.apply(this.element, arguments)
            },_keyEvent: function(keyEvent, event) {
                (!this.isMultiLine || this.menu.element.is(":visible")) && (this._move(keyEvent, event), event.preventDefault())
            }}), $.extend($.ui.autocomplete, {escapeRegex: function(value) {
                return value.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g, "\\$&")
            },filter: function(array, term) {
                var matcher = new RegExp($.ui.autocomplete.escapeRegex(term), "i");
                return $.grep(array, function(value) {
                    return matcher.test(value.label || value.value || value)
                })
            }}), $.widget("ui.autocomplete", $.ui.autocomplete, {options: {messages: {noResults: "No search results.",results: function(amount) {
                        return amount + (amount > 1 ? " results are" : " result is") + " available, use up and down arrow keys to navigate."
                    }}},__response: function(content) {
                var message;
                this._superApply(arguments), this.options.disabled || this.cancelSearch || (message = content && content.length ? this.options.messages.results(content.length) : this.options.messages.noResults, this.liveRegion.children().hide(), $("<div>").text(message).appendTo(this.liveRegion))
            }});
        var lastActive, baseClasses = ($.ui.autocomplete, "ui-button ui-widget ui-state-default ui-corner-all"), typeClasses = "ui-button-icons-only ui-button-icon-only ui-button-text-icons ui-button-text-icon-primary ui-button-text-icon-secondary ui-button-text-only", formResetHandler = function() {
            var form = $(this);
            setTimeout(function() {
                form.find(":ui-button").button("refresh")
            }, 1)
        }, radioGroup = function(radio) {
            var name = radio.name, form = radio.form, radios = $([]);
            return name && (name = name.replace(/'/g, "\\'"), radios = form ? $(form).find("[name='" + name + "'][type=radio]") : $("[name='" + name + "'][type=radio]", radio.ownerDocument).filter(function() {
                return !this.form
            })), radios
        };
        $.widget("ui.button", {version: "1.11.4",defaultElement: "<button>",options: {disabled: null,text: !0,label: null,icons: {primary: null,secondary: null}},_create: function() {
                this.element.closest("form").unbind("reset" + this.eventNamespace).bind("reset" + this.eventNamespace, formResetHandler), "boolean" != typeof this.options.disabled ? this.options.disabled = !!this.element.prop("disabled") : this.element.prop("disabled", this.options.disabled), this._determineButtonType(), this.hasTitle = !!this.buttonElement.attr("title");
                var that = this, options = this.options, toggleButton = "checkbox" === this.type || "radio" === this.type, activeClass = toggleButton ? "" : "ui-state-active";
                null === options.label && (options.label = "input" === this.type ? this.buttonElement.val() : this.buttonElement.html()), this._hoverable(this.buttonElement), this.buttonElement.addClass(baseClasses).attr("role", "button").bind("mouseenter" + this.eventNamespace, function() {
                    options.disabled || this === lastActive && $(this).addClass("ui-state-active")
                }).bind("mouseleave" + this.eventNamespace, function() {
                    options.disabled || $(this).removeClass(activeClass)
                }).bind("click" + this.eventNamespace, function(event) {
                    options.disabled && (event.preventDefault(), event.stopImmediatePropagation())
                }), this._on({focus: function() {
                        this.buttonElement.addClass("ui-state-focus")
                    },blur: function() {
                        this.buttonElement.removeClass("ui-state-focus")
                    }}), toggleButton && this.element.bind("change" + this.eventNamespace, function() {
                    that.refresh()
                }), "checkbox" === this.type ? this.buttonElement.bind("click" + this.eventNamespace, function() {
                    return options.disabled ? !1 : void 0
                }) : "radio" === this.type ? this.buttonElement.bind("click" + this.eventNamespace, function() {
                    if (options.disabled)
                        return !1;
                    $(this).addClass("ui-state-active"), that.buttonElement.attr("aria-pressed", "true");
                    var radio = that.element[0];
                    radioGroup(radio).not(radio).map(function() {
                        return $(this).button("widget")[0]
                    }).removeClass("ui-state-active").attr("aria-pressed", "false")
                }) : (this.buttonElement.bind("mousedown" + this.eventNamespace, function() {
                    return options.disabled ? !1 : ($(this).addClass("ui-state-active"), lastActive = this, void that.document.one("mouseup", function() {
                        lastActive = null
                    }))
                }).bind("mouseup" + this.eventNamespace, function() {
                    return options.disabled ? !1 : void $(this).removeClass("ui-state-active")
                }).bind("keydown" + this.eventNamespace, function(event) {
                    return options.disabled ? !1 : void ((event.keyCode === $.ui.keyCode.SPACE || event.keyCode === $.ui.keyCode.ENTER) && $(this).addClass("ui-state-active"))
                }).bind("keyup" + this.eventNamespace + " blur" + this.eventNamespace, function() {
                    $(this).removeClass("ui-state-active")
                }), this.buttonElement.is("a") && this.buttonElement.keyup(function(event) {
                    event.keyCode === $.ui.keyCode.SPACE && $(this).click()
                })), this._setOption("disabled", options.disabled), this._resetButton()
            },_determineButtonType: function() {
                var ancestor, labelSelector, checked;
                this.element.is("[type=checkbox]") ? this.type = "checkbox" : this.element.is("[type=radio]") ? this.type = "radio" : this.element.is("input") ? this.type = "input" : this.type = "button", "checkbox" === this.type || "radio" === this.type ? (ancestor = this.element.parents().last(), labelSelector = "label[for='" + this.element.attr("id") + "']", this.buttonElement = ancestor.find(labelSelector), this.buttonElement.length || (ancestor = ancestor.length ? ancestor.siblings() : this.element.siblings(), this.buttonElement = ancestor.filter(labelSelector), this.buttonElement.length || (this.buttonElement = ancestor.find(labelSelector))), this.element.addClass("ui-helper-hidden-accessible"), checked = this.element.is(":checked"), checked && this.buttonElement.addClass("ui-state-active"), this.buttonElement.prop("aria-pressed", checked)) : this.buttonElement = this.element
            },widget: function() {
                return this.buttonElement
            },_destroy: function() {
                this.element.removeClass("ui-helper-hidden-accessible"), this.buttonElement.removeClass(baseClasses + " ui-state-active " + typeClasses).removeAttr("role").removeAttr("aria-pressed").html(this.buttonElement.find(".ui-button-text").html()), this.hasTitle || this.buttonElement.removeAttr("title")
            },_setOption: function(key, value) {
                return this._super(key, value), "disabled" === key ? (this.widget().toggleClass("ui-state-disabled", !!value), this.element.prop("disabled", !!value), void (value && ("checkbox" === this.type || "radio" === this.type ? this.buttonElement.removeClass("ui-state-focus") : this.buttonElement.removeClass("ui-state-focus ui-state-active")))) : void this._resetButton()
            },refresh: function() {
                var isDisabled = this.element.is("input, button") ? this.element.is(":disabled") : this.element.hasClass("ui-button-disabled");
                isDisabled !== this.options.disabled && this._setOption("disabled", isDisabled), "radio" === this.type ? radioGroup(this.element[0]).each(function() {
                    $(this).is(":checked") ? $(this).button("widget").addClass("ui-state-active").attr("aria-pressed", "true") : $(this).button("widget").removeClass("ui-state-active").attr("aria-pressed", "false")
                }) : "checkbox" === this.type && (this.element.is(":checked") ? this.buttonElement.addClass("ui-state-active").attr("aria-pressed", "true") : this.buttonElement.removeClass("ui-state-active").attr("aria-pressed", "false"))
            },_resetButton: function() {
                if ("input" === this.type)
                    return void (this.options.label && this.element.val(this.options.label));
                var buttonElement = this.buttonElement.removeClass(typeClasses), buttonText = $("<span></span>", this.document[0]).addClass("ui-button-text").html(this.options.label).appendTo(buttonElement.empty()).text(), icons = this.options.icons, multipleIcons = icons.primary && icons.secondary, buttonClasses = [];
                icons.primary || icons.secondary ? (this.options.text && buttonClasses.push("ui-button-text-icon" + (multipleIcons ? "s" : icons.primary ? "-primary" : "-secondary")), icons.primary && buttonElement.prepend("<span class='ui-button-icon-primary ui-icon " + icons.primary + "'></span>"), icons.secondary && buttonElement.append("<span class='ui-button-icon-secondary ui-icon " + icons.secondary + "'></span>"), this.options.text || (buttonClasses.push(multipleIcons ? "ui-button-icons-only" : "ui-button-icon-only"), this.hasTitle || buttonElement.attr("title", $.trim(buttonText)))) : buttonClasses.push("ui-button-text-only"), buttonElement.addClass(buttonClasses.join(" "))
            }}), $.widget("ui.buttonset", {version: "1.11.4",options: {items: "button, input[type=button], input[type=submit], input[type=reset], input[type=checkbox], input[type=radio], a, :data(ui-button)"},_create: function() {
                this.element.addClass("ui-buttonset")
            },_init: function() {
                this.refresh()
            },_setOption: function(key, value) {
                "disabled" === key && this.buttons.button("option", key, value), this._super(key, value)
            },refresh: function() {
                var rtl = "rtl" === this.element.css("direction"), allButtons = this.element.find(this.options.items), existingButtons = allButtons.filter(":ui-button");
                allButtons.not(":ui-button").button(), existingButtons.button("refresh"), this.buttons = allButtons.map(function() {
                    return $(this).button("widget")[0]
                }).removeClass("ui-corner-all ui-corner-left ui-corner-right").filter(":first").addClass(rtl ? "ui-corner-right" : "ui-corner-left").end().filter(":last").addClass(rtl ? "ui-corner-left" : "ui-corner-right").end().end()
            },_destroy: function() {
                this.element.removeClass("ui-buttonset"), this.buttons.map(function() {
                    return $(this).button("widget")[0]
                }).removeClass("ui-corner-left ui-corner-right").end().button("destroy")
            }});
        $.ui.button;
        $.extend($.ui, {datepicker: {version: "1.11.4"}});
        var datepicker_instActive;
        $.extend(Datepicker.prototype, {markerClassName: "hasDatepicker",maxRows: 4,_widgetDatepicker: function() {
                return this.dpDiv
            },setDefaults: function(settings) {
                return datepicker_extendRemove(this._defaults, settings || {}), this
            },_attachDatepicker: function(target, settings) {
                var nodeName, inline, inst;
                nodeName = target.nodeName.toLowerCase(), inline = "div" === nodeName || "span" === nodeName, target.id || (this.uuid += 1, target.id = "dp" + this.uuid), inst = this._newInst($(target), inline), inst.settings = $.extend({}, settings || {}), "input" === nodeName ? this._connectDatepicker(target, inst) : inline && this._inlineDatepicker(target, inst)
            },_newInst: function(target, inline) {
                var id = target[0].id.replace(/([^A-Za-z0-9_\-])/g, "\\\\$1");
                return {id: id,input: target,selectedDay: 0,selectedMonth: 0,selectedYear: 0,drawMonth: 0,drawYear: 0,inline: inline,dpDiv: inline ? datepicker_bindHover($("<div class='" + this._inlineClass + " ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>")) : this.dpDiv}
            },_connectDatepicker: function(target, inst) {
                var input = $(target);
                inst.append = $([]), inst.trigger = $([]), input.hasClass(this.markerClassName) || (this._attachments(input, inst), input.addClass(this.markerClassName).keydown(this._doKeyDown).keypress(this._doKeyPress).keyup(this._doKeyUp), this._autoSize(inst), $.data(target, "datepicker", inst), inst.settings.disabled && this._disableDatepicker(target))
            },_attachments: function(input, inst) {
                var showOn, buttonText, buttonImage, appendText = this._get(inst, "appendText"), isRTL = this._get(inst, "isRTL");
                inst.append && inst.append.remove(), appendText && (inst.append = $("<span class='" + this._appendClass + "'>" + appendText + "</span>"), input[isRTL ? "before" : "after"](inst.append)), input.unbind("focus", this._showDatepicker), inst.trigger && inst.trigger.remove(), showOn = this._get(inst, "showOn"), ("focus" === showOn || "both" === showOn) && input.focus(this._showDatepicker), ("button" === showOn || "both" === showOn) && (buttonText = this._get(inst, "buttonText"), buttonImage = this._get(inst, "buttonImage"), inst.trigger = $(this._get(inst, "buttonImageOnly") ? $("<img/>").addClass(this._triggerClass).attr({src: buttonImage,alt: buttonText,title: buttonText}) : $("<button type='button'></button>").addClass(this._triggerClass).html(buttonImage ? $("<img/>").attr({src: buttonImage,alt: buttonText,title: buttonText}) : buttonText)), input[isRTL ? "before" : "after"](inst.trigger), inst.trigger.click(function() {
                    return $.datepicker._datepickerShowing && $.datepicker._lastInput === input[0] ? $.datepicker._hideDatepicker() : $.datepicker._datepickerShowing && $.datepicker._lastInput !== input[0] ? ($.datepicker._hideDatepicker(), $.datepicker._showDatepicker(input[0])) : $.datepicker._showDatepicker(input[0]), !1
                }))
            },_autoSize: function(inst) {
                if (this._get(inst, "autoSize") && !inst.inline) {
                    var findMax, max, maxI, i, date = new Date(2009, 11, 20), dateFormat = this._get(inst, "dateFormat");
                    dateFormat.match(/[DM]/) && (findMax = function(names) {
                        for (max = 0, maxI = 0, i = 0; i < names.length; i++)
                            names[i].length > max && (max = names[i].length, maxI = i);
                        return maxI
                    }, date.setMonth(findMax(this._get(inst, dateFormat.match(/MM/) ? "monthNames" : "monthNamesShort"))), date.setDate(findMax(this._get(inst, dateFormat.match(/DD/) ? "dayNames" : "dayNamesShort")) + 20 - date.getDay())), inst.input.attr("size", this._formatDate(inst, date).length)
                }
            },_inlineDatepicker: function(target, inst) {
                var divSpan = $(target);
                divSpan.hasClass(this.markerClassName) || (divSpan.addClass(this.markerClassName).append(inst.dpDiv), $.data(target, "datepicker", inst), this._setDate(inst, this._getDefaultDate(inst), !0), this._updateDatepicker(inst), this._updateAlternate(inst), inst.settings.disabled && this._disableDatepicker(target), inst.dpDiv.css("display", "block"))
            },_dialogDatepicker: function(input, date, onSelect, settings, pos) {
                var id, browserWidth, browserHeight, scrollX, scrollY, inst = this._dialogInst;
                return inst || (this.uuid += 1, id = "dp" + this.uuid, this._dialogInput = $("<input type='text' id='" + id + "' style='position: absolute; top: -100px; width: 0px;'/>"), this._dialogInput.keydown(this._doKeyDown), $("body").append(this._dialogInput), inst = this._dialogInst = this._newInst(this._dialogInput, !1), inst.settings = {}, $.data(this._dialogInput[0], "datepicker", inst)), datepicker_extendRemove(inst.settings, settings || {}), date = date && date.constructor === Date ? this._formatDate(inst, date) : date, this._dialogInput.val(date), this._pos = pos ? pos.length ? pos : [pos.pageX, pos.pageY] : null, this._pos || (browserWidth = document.documentElement.clientWidth, browserHeight = document.documentElement.clientHeight, scrollX = document.documentElement.scrollLeft || document.body.scrollLeft, scrollY = document.documentElement.scrollTop || document.body.scrollTop, this._pos = [browserWidth / 2 - 100 + scrollX, browserHeight / 2 - 150 + scrollY]), this._dialogInput.css("left", this._pos[0] + 20 + "px").css("top", this._pos[1] + "px"), inst.settings.onSelect = onSelect, this._inDialog = !0, this.dpDiv.addClass(this._dialogClass), this._showDatepicker(this._dialogInput[0]), $.blockUI && $.blockUI(this.dpDiv), $.data(this._dialogInput[0], "datepicker", inst), this
            },_destroyDatepicker: function(target) {
                var nodeName, $target = $(target), inst = $.data(target, "datepicker");
                $target.hasClass(this.markerClassName) && (nodeName = target.nodeName.toLowerCase(), $.removeData(target, "datepicker"), "input" === nodeName ? (inst.append.remove(), inst.trigger.remove(), $target.removeClass(this.markerClassName).unbind("focus", this._showDatepicker).unbind("keydown", this._doKeyDown).unbind("keypress", this._doKeyPress).unbind("keyup", this._doKeyUp)) : ("div" === nodeName || "span" === nodeName) && $target.removeClass(this.markerClassName).empty(), datepicker_instActive === inst && (datepicker_instActive = null))
            },_enableDatepicker: function(target) {
                var nodeName, inline, $target = $(target), inst = $.data(target, "datepicker");
                $target.hasClass(this.markerClassName) && (nodeName = target.nodeName.toLowerCase(), "input" === nodeName ? (target.disabled = !1, inst.trigger.filter("button").each(function() {
                    this.disabled = !1
                }).end().filter("img").css({opacity: "1.0",cursor: ""})) : ("div" === nodeName || "span" === nodeName) && (inline = $target.children("." + this._inlineClass), inline.children().removeClass("ui-state-disabled"), inline.find("select.ui-datepicker-month, select.ui-datepicker-year").prop("disabled", !1)), this._disabledInputs = $.map(this._disabledInputs, function(value) {
                    return value === target ? null : value
                }))
            },_disableDatepicker: function(target) {
                var nodeName, inline, $target = $(target), inst = $.data(target, "datepicker");
                $target.hasClass(this.markerClassName) && (nodeName = target.nodeName.toLowerCase(), "input" === nodeName ? (target.disabled = !0, inst.trigger.filter("button").each(function() {
                    this.disabled = !0
                }).end().filter("img").css({opacity: "0.5",cursor: "default"})) : ("div" === nodeName || "span" === nodeName) && (inline = $target.children("." + this._inlineClass), inline.children().addClass("ui-state-disabled"), inline.find("select.ui-datepicker-month, select.ui-datepicker-year").prop("disabled", !0)), this._disabledInputs = $.map(this._disabledInputs, function(value) {
                    return value === target ? null : value
                }), this._disabledInputs[this._disabledInputs.length] = target)
            },_isDisabledDatepicker: function(target) {
                if (!target)
                    return !1;
                for (var i = 0; i < this._disabledInputs.length; i++)
                    if (this._disabledInputs[i] === target)
                        return !0;
                return !1
            },_getInst: function(target) {
                try {
                    return $.data(target, "datepicker")
                } catch (err) {
                    throw "Missing instance data for this datepicker"
                }
            },_optionDatepicker: function(target, name, value) {
                var settings, date, minDate, maxDate, inst = this._getInst(target);
                return 2 === arguments.length && "string" == typeof name ? "defaults" === name ? $.extend({}, $.datepicker._defaults) : inst ? "all" === name ? $.extend({}, inst.settings) : this._get(inst, name) : null : (settings = name || {}, "string" == typeof name && (settings = {}, settings[name] = value), void (inst && (this._curInst === inst && this._hideDatepicker(), date = this._getDateDatepicker(target, !0), minDate = this._getMinMaxDate(inst, "min"), maxDate = this._getMinMaxDate(inst, "max"), datepicker_extendRemove(inst.settings, settings), null !== minDate && void 0 !== settings.dateFormat && void 0 === settings.minDate && (inst.settings.minDate = this._formatDate(inst, minDate)), null !== maxDate && void 0 !== settings.dateFormat && void 0 === settings.maxDate && (inst.settings.maxDate = this._formatDate(inst, maxDate)), "disabled" in settings && (settings.disabled ? this._disableDatepicker(target) : this._enableDatepicker(target)), this._attachments($(target), inst), this._autoSize(inst), this._setDate(inst, date), this._updateAlternate(inst), this._updateDatepicker(inst))))
            },_changeDatepicker: function(target, name, value) {
                this._optionDatepicker(target, name, value)
            },_refreshDatepicker: function(target) {
                var inst = this._getInst(target);
                inst && this._updateDatepicker(inst)
            },_setDateDatepicker: function(target, date) {
                var inst = this._getInst(target);
                inst && (this._setDate(inst, date), this._updateDatepicker(inst), this._updateAlternate(inst))
            },_getDateDatepicker: function(target, noDefault) {
                var inst = this._getInst(target);
                return inst && !inst.inline && this._setDateFromField(inst, noDefault), inst ? this._getDate(inst) : null
            },_doKeyDown: function(event) {
                var onSelect, dateStr, sel, inst = $.datepicker._getInst(event.target), handled = !0, isRTL = inst.dpDiv.is(".ui-datepicker-rtl");
                if (inst._keyEvent = !0, $.datepicker._datepickerShowing)
                    switch (event.keyCode) {
                        case 9:
                            $.datepicker._hideDatepicker(), handled = !1;
                            break;
                        case 13:
                            return sel = $("td." + $.datepicker._dayOverClass + ":not(." + $.datepicker._currentClass + ")", inst.dpDiv), sel[0] && $.datepicker._selectDay(event.target, inst.selectedMonth, inst.selectedYear, sel[0]), onSelect = $.datepicker._get(inst, "onSelect"), onSelect ? (dateStr = $.datepicker._formatDate(inst), onSelect.apply(inst.input ? inst.input[0] : null, [dateStr, inst])) : $.datepicker._hideDatepicker(), !1;
                        case 27:
                            $.datepicker._hideDatepicker();
                            break;
                        case 33:
                            $.datepicker._adjustDate(event.target, event.ctrlKey ? -$.datepicker._get(inst, "stepBigMonths") : -$.datepicker._get(inst, "stepMonths"), "M");
                            break;
                        case 34:
                            $.datepicker._adjustDate(event.target, event.ctrlKey ? +$.datepicker._get(inst, "stepBigMonths") : +$.datepicker._get(inst, "stepMonths"), "M");
                            break;
                        case 35:
                            (event.ctrlKey || event.metaKey) && $.datepicker._clearDate(event.target), handled = event.ctrlKey || event.metaKey;
                            break;
                        case 36:
                            (event.ctrlKey || event.metaKey) && $.datepicker._gotoToday(event.target), handled = event.ctrlKey || event.metaKey;
                            break;
                        case 37:
                            (event.ctrlKey || event.metaKey) && $.datepicker._adjustDate(event.target, isRTL ? 1 : -1, "D"), handled = event.ctrlKey || event.metaKey, event.originalEvent.altKey && $.datepicker._adjustDate(event.target, event.ctrlKey ? -$.datepicker._get(inst, "stepBigMonths") : -$.datepicker._get(inst, "stepMonths"), "M");
                            break;
                        case 38:
                            (event.ctrlKey || event.metaKey) && $.datepicker._adjustDate(event.target, -7, "D"), handled = event.ctrlKey || event.metaKey;
                            break;
                        case 39:
                            (event.ctrlKey || event.metaKey) && $.datepicker._adjustDate(event.target, isRTL ? -1 : 1, "D"), handled = event.ctrlKey || event.metaKey, event.originalEvent.altKey && $.datepicker._adjustDate(event.target, event.ctrlKey ? +$.datepicker._get(inst, "stepBigMonths") : +$.datepicker._get(inst, "stepMonths"), "M");
                            break;
                        case 40:
                            (event.ctrlKey || event.metaKey) && $.datepicker._adjustDate(event.target, 7, "D"), handled = event.ctrlKey || event.metaKey;
                            break;
                        default:
                            handled = !1
                    }
                else
                    36 === event.keyCode && event.ctrlKey ? $.datepicker._showDatepicker(this) : handled = !1;
                handled && (event.preventDefault(), event.stopPropagation())
            },_doKeyPress: function(event) {
                var chars, chr, inst = $.datepicker._getInst(event.target);
                return $.datepicker._get(inst, "constrainInput") ? (chars = $.datepicker._possibleChars($.datepicker._get(inst, "dateFormat")), chr = String.fromCharCode(null == event.charCode ? event.keyCode : event.charCode), event.ctrlKey || event.metaKey || " " > chr || !chars || chars.indexOf(chr) > -1) : void 0
            },_doKeyUp: function(event) {
                var date, inst = $.datepicker._getInst(event.target);
                if (inst.input.val() !== inst.lastVal)
                    try {
                        date = $.datepicker.parseDate($.datepicker._get(inst, "dateFormat"), inst.input ? inst.input.val() : null, $.datepicker._getFormatConfig(inst)), date && ($.datepicker._setDateFromField(inst), $.datepicker._updateAlternate(inst), $.datepicker._updateDatepicker(inst));
                    } catch (err) {
                    }
                return !0
            },_showDatepicker: function(input) {
                if (input = input.target || input, "input" !== input.nodeName.toLowerCase() && (input = $("input", input.parentNode)[0]), !$.datepicker._isDisabledDatepicker(input) && $.datepicker._lastInput !== input) {
                    var inst, beforeShow, beforeShowSettings, isFixed, offset, showAnim, duration;
                    inst = $.datepicker._getInst(input), $.datepicker._curInst && $.datepicker._curInst !== inst && ($.datepicker._curInst.dpDiv.stop(!0, !0), inst && $.datepicker._datepickerShowing && $.datepicker._hideDatepicker($.datepicker._curInst.input[0])), beforeShow = $.datepicker._get(inst, "beforeShow"), beforeShowSettings = beforeShow ? beforeShow.apply(input, [input, inst]) : {}, beforeShowSettings !== !1 && (datepicker_extendRemove(inst.settings, beforeShowSettings), inst.lastVal = null, $.datepicker._lastInput = input, $.datepicker._setDateFromField(inst), $.datepicker._inDialog && (input.value = ""), $.datepicker._pos || ($.datepicker._pos = $.datepicker._findPos(input), $.datepicker._pos[1] += input.offsetHeight), isFixed = !1, $(input).parents().each(function() {
                        return isFixed |= "fixed" === $(this).css("position"), !isFixed
                    }), offset = {left: $.datepicker._pos[0],top: $.datepicker._pos[1]}, $.datepicker._pos = null, inst.dpDiv.empty(), inst.dpDiv.css({position: "absolute",display: "block",top: "-1000px"}), $.datepicker._updateDatepicker(inst), offset = $.datepicker._checkOffset(inst, offset, isFixed), inst.dpDiv.css({position: $.datepicker._inDialog && $.blockUI ? "static" : isFixed ? "fixed" : "absolute",display: "none",left: offset.left + "px",top: offset.top + "px"}), inst.inline || (showAnim = $.datepicker._get(inst, "showAnim"), duration = $.datepicker._get(inst, "duration"), inst.dpDiv.css("z-index", datepicker_getZindex($(input)) + 1), $.datepicker._datepickerShowing = !0, $.effects && $.effects.effect[showAnim] ? inst.dpDiv.show(showAnim, $.datepicker._get(inst, "showOptions"), duration) : inst.dpDiv[showAnim || "show"](showAnim ? duration : null), $.datepicker._shouldFocusInput(inst) && inst.input.focus(), $.datepicker._curInst = inst))
                }
            },_updateDatepicker: function(inst) {
                this.maxRows = 4, datepicker_instActive = inst, inst.dpDiv.empty().append(this._generateHTML(inst)), this._attachHandlers(inst);
                var origyearshtml, numMonths = this._getNumberOfMonths(inst), cols = numMonths[1], width = 17, activeCell = inst.dpDiv.find("." + this._dayOverClass + " a");
                activeCell.length > 0 && datepicker_handleMouseover.apply(activeCell.get(0)), inst.dpDiv.removeClass("ui-datepicker-multi-2 ui-datepicker-multi-3 ui-datepicker-multi-4").width(""), cols > 1 && inst.dpDiv.addClass("ui-datepicker-multi-" + cols).css("width", width * cols + "em"), inst.dpDiv[(1 !== numMonths[0] || 1 !== numMonths[1] ? "add" : "remove") + "Class"]("ui-datepicker-multi"), inst.dpDiv[(this._get(inst, "isRTL") ? "add" : "remove") + "Class"]("ui-datepicker-rtl"), inst === $.datepicker._curInst && $.datepicker._datepickerShowing && $.datepicker._shouldFocusInput(inst) && inst.input.focus(), inst.yearshtml && (origyearshtml = inst.yearshtml, setTimeout(function() {
                    origyearshtml === inst.yearshtml && inst.yearshtml && inst.dpDiv.find("select.ui-datepicker-year:first").replaceWith(inst.yearshtml), origyearshtml = inst.yearshtml = null
                }, 0))
            },_shouldFocusInput: function(inst) {
                return inst.input && inst.input.is(":visible") && !inst.input.is(":disabled") && !inst.input.is(":focus")
            },_checkOffset: function(inst, offset, isFixed) {
                var dpWidth = inst.dpDiv.outerWidth(), dpHeight = inst.dpDiv.outerHeight(), inputWidth = inst.input ? inst.input.outerWidth() : 0, inputHeight = inst.input ? inst.input.outerHeight() : 0, viewWidth = document.documentElement.clientWidth + (isFixed ? 0 : $(document).scrollLeft()), viewHeight = document.documentElement.clientHeight + (isFixed ? 0 : $(document).scrollTop());
                return offset.left -= this._get(inst, "isRTL") ? dpWidth - inputWidth : 0, offset.left -= isFixed && offset.left === inst.input.offset().left ? $(document).scrollLeft() : 0, offset.top -= isFixed && offset.top === inst.input.offset().top + inputHeight ? $(document).scrollTop() : 0, offset.left -= Math.min(offset.left, offset.left + dpWidth > viewWidth && viewWidth > dpWidth ? Math.abs(offset.left + dpWidth - viewWidth) : 0), offset.top -= Math.min(offset.top, offset.top + dpHeight > viewHeight && viewHeight > dpHeight ? Math.abs(dpHeight + inputHeight) : 0), offset
            },_findPos: function(obj) {
                for (var position, inst = this._getInst(obj), isRTL = this._get(inst, "isRTL"); obj && ("hidden" === obj.type || 1 !== obj.nodeType || $.expr.filters.hidden(obj)); )
                    obj = obj[isRTL ? "previousSibling" : "nextSibling"];
                return position = $(obj).offset(), [position.left, position.top]
            },_hideDatepicker: function(input) {
                var showAnim, duration, postProcess, onClose, inst = this._curInst;
                !inst || input && inst !== $.data(input, "datepicker") || this._datepickerShowing && (showAnim = this._get(inst, "showAnim"), duration = this._get(inst, "duration"), postProcess = function() {
                    $.datepicker._tidyDialog(inst)
                }, $.effects && ($.effects.effect[showAnim] || $.effects[showAnim]) ? inst.dpDiv.hide(showAnim, $.datepicker._get(inst, "showOptions"), duration, postProcess) : inst.dpDiv["slideDown" === showAnim ? "slideUp" : "fadeIn" === showAnim ? "fadeOut" : "hide"](showAnim ? duration : null, postProcess), showAnim || postProcess(), this._datepickerShowing = !1, onClose = this._get(inst, "onClose"), onClose && onClose.apply(inst.input ? inst.input[0] : null, [inst.input ? inst.input.val() : "", inst]), this._lastInput = null, this._inDialog && (this._dialogInput.css({position: "absolute",left: "0",top: "-100px"}), $.blockUI && ($.unblockUI(), $("body").append(this.dpDiv))), this._inDialog = !1)
            },_tidyDialog: function(inst) {
                inst.dpDiv.removeClass(this._dialogClass).unbind(".ui-datepicker-calendar")
            },_checkExternalClick: function(event) {
                if ($.datepicker._curInst) {
                    var $target = $(event.target), inst = $.datepicker._getInst($target[0]);
                    ($target[0].id !== $.datepicker._mainDivId && 0 === $target.parents("#" + $.datepicker._mainDivId).length && !$target.hasClass($.datepicker.markerClassName) && !$target.closest("." + $.datepicker._triggerClass).length && $.datepicker._datepickerShowing && (!$.datepicker._inDialog || !$.blockUI) || $target.hasClass($.datepicker.markerClassName) && $.datepicker._curInst !== inst) && $.datepicker._hideDatepicker()
                }
            },_adjustDate: function(id, offset, period) {
                var target = $(id), inst = this._getInst(target[0]);
                this._isDisabledDatepicker(target[0]) || (this._adjustInstDate(inst, offset + ("M" === period ? this._get(inst, "showCurrentAtPos") : 0), period), this._updateDatepicker(inst))
            },_gotoToday: function(id) {
                var date, target = $(id), inst = this._getInst(target[0]);
                this._get(inst, "gotoCurrent") && inst.currentDay ? (inst.selectedDay = inst.currentDay, inst.drawMonth = inst.selectedMonth = inst.currentMonth, inst.drawYear = inst.selectedYear = inst.currentYear) : (date = new Date, inst.selectedDay = date.getDate(), inst.drawMonth = inst.selectedMonth = date.getMonth(), inst.drawYear = inst.selectedYear = date.getFullYear()), this._notifyChange(inst), this._adjustDate(target)
            },_selectMonthYear: function(id, select, period) {
                var target = $(id), inst = this._getInst(target[0]);
                inst["selected" + ("M" === period ? "Month" : "Year")] = inst["draw" + ("M" === period ? "Month" : "Year")] = parseInt(select.options[select.selectedIndex].value, 10), this._notifyChange(inst), this._adjustDate(target)
            },_selectDay: function(id, month, year, td) {
                var inst, target = $(id);
                $(td).hasClass(this._unselectableClass) || this._isDisabledDatepicker(target[0]) || (inst = this._getInst(target[0]), inst.selectedDay = inst.currentDay = $("a", td).html(), inst.selectedMonth = inst.currentMonth = month, inst.selectedYear = inst.currentYear = year, this._selectDate(id, this._formatDate(inst, inst.currentDay, inst.currentMonth, inst.currentYear)))
            },_clearDate: function(id) {
                var target = $(id);
                this._selectDate(target, "")
            },_selectDate: function(id, dateStr) {
                var onSelect, target = $(id), inst = this._getInst(target[0]);
                dateStr = null != dateStr ? dateStr : this._formatDate(inst), inst.input && inst.input.val(dateStr), this._updateAlternate(inst), onSelect = this._get(inst, "onSelect"), onSelect ? onSelect.apply(inst.input ? inst.input[0] : null, [dateStr, inst]) : inst.input && inst.input.trigger("change"), inst.inline ? this._updateDatepicker(inst) : (this._hideDatepicker(), this._lastInput = inst.input[0], "object" != typeof inst.input[0] && inst.input.focus(), this._lastInput = null)
            },_updateAlternate: function(inst) {
                var altFormat, date, dateStr, altField = this._get(inst, "altField");
                altField && (altFormat = this._get(inst, "altFormat") || this._get(inst, "dateFormat"), date = this._getDate(inst), dateStr = this.formatDate(altFormat, date, this._getFormatConfig(inst)), $(altField).each(function() {
                    $(this).val(dateStr)
                }))
            },noWeekends: function(date) {
                var day = date.getDay();
                return [day > 0 && 6 > day, ""]
            },iso8601Week: function(date) {
                var time, checkDate = new Date(date.getTime());
                return checkDate.setDate(checkDate.getDate() + 4 - (checkDate.getDay() || 7)), time = checkDate.getTime(), checkDate.setMonth(0), checkDate.setDate(1), Math.floor(Math.round((time - checkDate) / 864e5) / 7) + 1
            },parseDate: function(format, value, settings) {
                if (null == format || null == value)
                    throw "Invalid arguments";
                if (value = "object" == typeof value ? value.toString() : value + "", "" === value)
                    return null;
                var iFormat, dim, extra, date, iValue = 0, shortYearCutoffTemp = (settings ? settings.shortYearCutoff : null) || this._defaults.shortYearCutoff, shortYearCutoff = "string" != typeof shortYearCutoffTemp ? shortYearCutoffTemp : (new Date).getFullYear() % 100 + parseInt(shortYearCutoffTemp, 10), dayNamesShort = (settings ? settings.dayNamesShort : null) || this._defaults.dayNamesShort, dayNames = (settings ? settings.dayNames : null) || this._defaults.dayNames, monthNamesShort = (settings ? settings.monthNamesShort : null) || this._defaults.monthNamesShort, monthNames = (settings ? settings.monthNames : null) || this._defaults.monthNames, year = -1, month = -1, day = -1, doy = -1, literal = !1, lookAhead = function(match) {
                    var matches = iFormat + 1 < format.length && format.charAt(iFormat + 1) === match;
                    return matches && iFormat++, matches
                }, getNumber = function(match) {
                    var isDoubled = lookAhead(match), size = "@" === match ? 14 : "!" === match ? 20 : "y" === match && isDoubled ? 4 : "o" === match ? 3 : 2, minSize = "y" === match ? size : 1, digits = new RegExp("^\\d{" + minSize + "," + size + "}"), num = value.substring(iValue).match(digits);
                    if (!num)
                        throw "Missing number at position " + iValue;
                    return iValue += num[0].length, parseInt(num[0], 10)
                }, getName = function(match, shortNames, longNames) {
                    var index = -1, names = $.map(lookAhead(match) ? longNames : shortNames, function(v, k) {
                        return [[k, v]]
                    }).sort(function(a, b) {
                        return -(a[1].length - b[1].length)
                    });
                    if ($.each(names, function(i, pair) {
                        var name = pair[1];
                        return value.substr(iValue, name.length).toLowerCase() === name.toLowerCase() ? (index = pair[0], iValue += name.length, !1) : void 0
                    }), -1 !== index)
                        return index + 1;
                    throw "Unknown name at position " + iValue
                }, checkLiteral = function() {
                    if (value.charAt(iValue) !== format.charAt(iFormat))
                        throw "Unexpected literal at position " + iValue;
                    iValue++
                };
                for (iFormat = 0; iFormat < format.length; iFormat++)
                    if (literal)
                        "'" !== format.charAt(iFormat) || lookAhead("'") ? checkLiteral() : literal = !1;
                    else
                        switch (format.charAt(iFormat)) {
                            case "d":
                                day = getNumber("d");
                                break;
                            case "D":
                                getName("D", dayNamesShort, dayNames);
                                break;
                            case "o":
                                doy = getNumber("o");
                                break;
                            case "m":
                                month = getNumber("m");
                                break;
                            case "M":
                                month = getName("M", monthNamesShort, monthNames);
                                break;
                            case "y":
                                year = getNumber("y");
                                break;
                            case "@":
                                date = new Date(getNumber("@")), year = date.getFullYear(), month = date.getMonth() + 1, day = date.getDate();
                                break;
                            case "!":
                                date = new Date((getNumber("!") - this._ticksTo1970) / 1e4), year = date.getFullYear(), month = date.getMonth() + 1, day = date.getDate();
                                break;
                            case "'":
                                lookAhead("'") ? checkLiteral() : literal = !0;
                                break;
                            default:
                                checkLiteral()
                        }
                if (iValue < value.length && (extra = value.substr(iValue), !/^\s+/.test(extra)))
                    throw "Extra/unparsed characters found in date: " + extra;
                if (-1 === year ? year = (new Date).getFullYear() : 100 > year && (year += (new Date).getFullYear() - (new Date).getFullYear() % 100 + (shortYearCutoff >= year ? 0 : -100)), doy > -1)
                    for (month = 1, day = doy; ; ) {
                        if (dim = this._getDaysInMonth(year, month - 1), dim >= day)
                            break;
                        month++, day -= dim
                    }
                if (date = this._daylightSavingAdjust(new Date(year, month - 1, day)), date.getFullYear() !== year || date.getMonth() + 1 !== month || date.getDate() !== day)
                    throw "Invalid date";
                return date
            },ATOM: "yy-mm-dd",COOKIE: "D, dd M yy",ISO_8601: "yy-mm-dd",RFC_822: "D, d M y",RFC_850: "DD, dd-M-y",RFC_1036: "D, d M y",RFC_1123: "D, d M yy",RFC_2822: "D, d M yy",RSS: "D, d M y",TICKS: "!",TIMESTAMP: "@",W3C: "yy-mm-dd",_ticksTo1970: 24 * (718685 + Math.floor(492.5) - Math.floor(19.7) + Math.floor(4.925)) * 60 * 60 * 1e7,formatDate: function(format, date, settings) {
                if (!date)
                    return "";
                var iFormat, dayNamesShort = (settings ? settings.dayNamesShort : null) || this._defaults.dayNamesShort, dayNames = (settings ? settings.dayNames : null) || this._defaults.dayNames, monthNamesShort = (settings ? settings.monthNamesShort : null) || this._defaults.monthNamesShort, monthNames = (settings ? settings.monthNames : null) || this._defaults.monthNames, lookAhead = function(match) {
                    var matches = iFormat + 1 < format.length && format.charAt(iFormat + 1) === match;
                    return matches && iFormat++, matches
                }, formatNumber = function(match, value, len) {
                    var num = "" + value;
                    if (lookAhead(match))
                        for (; num.length < len; )
                            num = "0" + num;
                    return num
                }, formatName = function(match, value, shortNames, longNames) {
                    return lookAhead(match) ? longNames[value] : shortNames[value]
                }, output = "", literal = !1;
                if (date)
                    for (iFormat = 0; iFormat < format.length; iFormat++)
                        if (literal)
                            "'" !== format.charAt(iFormat) || lookAhead("'") ? output += format.charAt(iFormat) : literal = !1;
                        else
                            switch (format.charAt(iFormat)) {
                                case "d":
                                    output += formatNumber("d", date.getDate(), 2);
                                    break;
                                case "D":
                                    output += formatName("D", date.getDay(), dayNamesShort, dayNames);
                                    break;
                                case "o":
                                    output += formatNumber("o", Math.round((new Date(date.getFullYear(), date.getMonth(), date.getDate()).getTime() - new Date(date.getFullYear(), 0, 0).getTime()) / 864e5), 3);
                                    break;
                                case "m":
                                    output += formatNumber("m", date.getMonth() + 1, 2);
                                    break;
                                case "M":
                                    output += formatName("M", date.getMonth(), monthNamesShort, monthNames);
                                    break;
                                case "y":
                                    output += lookAhead("y") ? date.getFullYear() : (date.getYear() % 100 < 10 ? "0" : "") + date.getYear() % 100;
                                    break;
                                case "@":
                                    output += date.getTime();
                                    break;
                                case "!":
                                    output += 1e4 * date.getTime() + this._ticksTo1970;
                                    break;
                                case "'":
                                    lookAhead("'") ? output += "'" : literal = !0;
                                    break;
                                default:
                                    output += format.charAt(iFormat)
                            }
                return output
            },_possibleChars: function(format) {
                var iFormat, chars = "", literal = !1, lookAhead = function(match) {
                    var matches = iFormat + 1 < format.length && format.charAt(iFormat + 1) === match;
                    return matches && iFormat++, matches
                };
                for (iFormat = 0; iFormat < format.length; iFormat++)
                    if (literal)
                        "'" !== format.charAt(iFormat) || lookAhead("'") ? chars += format.charAt(iFormat) : literal = !1;
                    else
                        switch (format.charAt(iFormat)) {
                            case "d":
                            case "m":
                            case "y":
                            case "@":
                                chars += "0123456789";
                                break;
                            case "D":
                            case "M":
                                return null;
                            case "'":
                                lookAhead("'") ? chars += "'" : literal = !0;
                                break;
                            default:
                                chars += format.charAt(iFormat)
                        }
                return chars
            },_get: function(inst, name) {
                return void 0 !== inst.settings[name] ? inst.settings[name] : this._defaults[name]
            },_setDateFromField: function(inst, noDefault) {
                if (inst.input.val() !== inst.lastVal) {
                    var dateFormat = this._get(inst, "dateFormat"), dates = inst.lastVal = inst.input ? inst.input.val() : null, defaultDate = this._getDefaultDate(inst), date = defaultDate, settings = this._getFormatConfig(inst);
                    try {
                        date = this.parseDate(dateFormat, dates, settings) || defaultDate
                    } catch (event) {
                        dates = noDefault ? "" : dates
                    }
                    inst.selectedDay = date.getDate(), inst.drawMonth = inst.selectedMonth = date.getMonth(), inst.drawYear = inst.selectedYear = date.getFullYear(), inst.currentDay = dates ? date.getDate() : 0, inst.currentMonth = dates ? date.getMonth() : 0, inst.currentYear = dates ? date.getFullYear() : 0, this._adjustInstDate(inst)
                }
            },_getDefaultDate: function(inst) {
                return this._restrictMinMax(inst, this._determineDate(inst, this._get(inst, "defaultDate"), new Date))
            },_determineDate: function(inst, date, defaultDate) {
                var offsetNumeric = function(offset) {
                    var date = new Date;
                    return date.setDate(date.getDate() + offset), date
                }, offsetString = function(offset) {
                    try {
                        return $.datepicker.parseDate($.datepicker._get(inst, "dateFormat"), offset, $.datepicker._getFormatConfig(inst))
                    } catch (e) {
                    }
                    for (var date = (offset.toLowerCase().match(/^c/) ? $.datepicker._getDate(inst) : null) || new Date, year = date.getFullYear(), month = date.getMonth(), day = date.getDate(), pattern = /([+\-]?[0-9]+)\s*(d|D|w|W|m|M|y|Y)?/g, matches = pattern.exec(offset); matches; ) {
                        switch (matches[2] || "d") {
                            case "d":
                            case "D":
                                day += parseInt(matches[1], 10);
                                break;
                            case "w":
                            case "W":
                                day += 7 * parseInt(matches[1], 10);
                                break;
                            case "m":
                            case "M":
                                month += parseInt(matches[1], 10), day = Math.min(day, $.datepicker._getDaysInMonth(year, month));
                                break;
                            case "y":
                            case "Y":
                                year += parseInt(matches[1], 10), day = Math.min(day, $.datepicker._getDaysInMonth(year, month))
                        }
                        matches = pattern.exec(offset)
                    }
                    return new Date(year, month, day)
                }, newDate = null == date || "" === date ? defaultDate : "string" == typeof date ? offsetString(date) : "number" == typeof date ? isNaN(date) ? defaultDate : offsetNumeric(date) : new Date(date.getTime());
                return newDate = newDate && "Invalid Date" === newDate.toString() ? defaultDate : newDate, newDate && (newDate.setHours(0), newDate.setMinutes(0), newDate.setSeconds(0), newDate.setMilliseconds(0)), this._daylightSavingAdjust(newDate)
            },_daylightSavingAdjust: function(date) {
                return date ? (date.setHours(date.getHours() > 12 ? date.getHours() + 2 : 0), date) : null
            },_setDate: function(inst, date, noChange) {
                var clear = !date, origMonth = inst.selectedMonth, origYear = inst.selectedYear, newDate = this._restrictMinMax(inst, this._determineDate(inst, date, new Date));
                inst.selectedDay = inst.currentDay = newDate.getDate(), inst.drawMonth = inst.selectedMonth = inst.currentMonth = newDate.getMonth(), inst.drawYear = inst.selectedYear = inst.currentYear = newDate.getFullYear(), origMonth === inst.selectedMonth && origYear === inst.selectedYear || noChange || this._notifyChange(inst), this._adjustInstDate(inst), inst.input && inst.input.val(clear ? "" : this._formatDate(inst))
            },_getDate: function(inst) {
                var startDate = !inst.currentYear || inst.input && "" === inst.input.val() ? null : this._daylightSavingAdjust(new Date(inst.currentYear, inst.currentMonth, inst.currentDay));
                return startDate
            },_attachHandlers: function(inst) {
                var stepMonths = this._get(inst, "stepMonths"), id = "#" + inst.id.replace(/\\\\/g, "\\");
                inst.dpDiv.find("[data-handler]").map(function() {
                    var handler = {prev: function() {
                            $.datepicker._adjustDate(id, -stepMonths, "M")
                        },next: function() {
                            $.datepicker._adjustDate(id, +stepMonths, "M")
                        },hide: function() {
                            $.datepicker._hideDatepicker()
                        },today: function() {
                            $.datepicker._gotoToday(id)
                        },selectDay: function() {
                            return $.datepicker._selectDay(id, +this.getAttribute("data-month"), +this.getAttribute("data-year"), this), !1
                        },selectMonth: function() {
                            return $.datepicker._selectMonthYear(id, this, "M"), !1
                        },selectYear: function() {
                            return $.datepicker._selectMonthYear(id, this, "Y"), !1
                        }};
                    $(this).bind(this.getAttribute("data-event"), handler[this.getAttribute("data-handler")])
                })
            },_generateHTML: function(inst) {
                var maxDraw, prevText, prev, nextText, next, currentText, gotoDate, controls, buttonPanel, firstDay, showWeek, dayNames, dayNamesMin, monthNames, monthNamesShort, beforeShowDay, showOtherMonths, selectOtherMonths, defaultDate, html, dow, row, group, col, selectedDate, cornerClass, calender, thead, day, daysInMonth, leadDays, curRows, numRows, printDate, dRow, tbody, daySettings, otherMonth, unselectable, tempDate = new Date, today = this._daylightSavingAdjust(new Date(tempDate.getFullYear(), tempDate.getMonth(), tempDate.getDate())), isRTL = this._get(inst, "isRTL"), showButtonPanel = this._get(inst, "showButtonPanel"), hideIfNoPrevNext = this._get(inst, "hideIfNoPrevNext"), navigationAsDateFormat = this._get(inst, "navigationAsDateFormat"), numMonths = this._getNumberOfMonths(inst), showCurrentAtPos = this._get(inst, "showCurrentAtPos"), stepMonths = this._get(inst, "stepMonths"), isMultiMonth = 1 !== numMonths[0] || 1 !== numMonths[1], currentDate = this._daylightSavingAdjust(inst.currentDay ? new Date(inst.currentYear, inst.currentMonth, inst.currentDay) : new Date(9999, 9, 9)), minDate = this._getMinMaxDate(inst, "min"), maxDate = this._getMinMaxDate(inst, "max"), drawMonth = inst.drawMonth - showCurrentAtPos, drawYear = inst.drawYear;
                if (0 > drawMonth && (drawMonth += 12, drawYear--), maxDate)
                    for (maxDraw = this._daylightSavingAdjust(new Date(maxDate.getFullYear(), maxDate.getMonth() - numMonths[0] * numMonths[1] + 1, maxDate.getDate())), maxDraw = minDate && minDate > maxDraw ? minDate : maxDraw; this._daylightSavingAdjust(new Date(drawYear, drawMonth, 1)) > maxDraw; )
                        drawMonth--, 0 > drawMonth && (drawMonth = 11, drawYear--);
                for (inst.drawMonth = drawMonth, inst.drawYear = drawYear, prevText = this._get(inst, "prevText"), prevText = navigationAsDateFormat ? this.formatDate(prevText, this._daylightSavingAdjust(new Date(drawYear, drawMonth - stepMonths, 1)), this._getFormatConfig(inst)) : prevText, prev = this._canAdjustMonth(inst, -1, drawYear, drawMonth) ? "<a class='ui-datepicker-prev ui-corner-all' data-handler='prev' data-event='click' title='" + prevText + "'><span class='ui-icon ui-icon-circle-triangle-" + (isRTL ? "e" : "w") + "'>" + prevText + "</span></a>" : hideIfNoPrevNext ? "" : "<a class='ui-datepicker-prev ui-corner-all ui-state-disabled' title='" + prevText + "'><span class='ui-icon ui-icon-circle-triangle-" + (isRTL ? "e" : "w") + "'>" + prevText + "</span></a>", nextText = this._get(inst, "nextText"), nextText = navigationAsDateFormat ? this.formatDate(nextText, this._daylightSavingAdjust(new Date(drawYear, drawMonth + stepMonths, 1)), this._getFormatConfig(inst)) : nextText, next = this._canAdjustMonth(inst, 1, drawYear, drawMonth) ? "<a class='ui-datepicker-next ui-corner-all' data-handler='next' data-event='click' title='" + nextText + "'><span class='ui-icon ui-icon-circle-triangle-" + (isRTL ? "w" : "e") + "'>" + nextText + "</span></a>" : hideIfNoPrevNext ? "" : "<a class='ui-datepicker-next ui-corner-all ui-state-disabled' title='" + nextText + "'><span class='ui-icon ui-icon-circle-triangle-" + (isRTL ? "w" : "e") + "'>" + nextText + "</span></a>", currentText = this._get(inst, "currentText"), gotoDate = this._get(inst, "gotoCurrent") && inst.currentDay ? currentDate : today, currentText = navigationAsDateFormat ? this.formatDate(currentText, gotoDate, this._getFormatConfig(inst)) : currentText, controls = inst.inline ? "" : "<button type='button' class='ui-datepicker-close ui-state-default ui-priority-primary ui-corner-all' data-handler='hide' data-event='click'>" + this._get(inst, "closeText") + "</button>", buttonPanel = showButtonPanel ? "<div class='ui-datepicker-buttonpane ui-widget-content'>" + (isRTL ? controls : "") + (this._isInRange(inst, gotoDate) ? "<button type='button' class='ui-datepicker-current ui-state-default ui-priority-secondary ui-corner-all' data-handler='today' data-event='click'>" + currentText + "</button>" : "") + (isRTL ? "" : controls) + "</div>" : "", firstDay = parseInt(this._get(inst, "firstDay"), 10), firstDay = isNaN(firstDay) ? 0 : firstDay, showWeek = this._get(inst, "showWeek"), dayNames = this._get(inst, "dayNames"), dayNamesMin = this._get(inst, "dayNamesMin"), monthNames = this._get(inst, "monthNames"), monthNamesShort = this._get(inst, "monthNamesShort"), beforeShowDay = this._get(inst, "beforeShowDay"), showOtherMonths = this._get(inst, "showOtherMonths"), selectOtherMonths = this._get(inst, "selectOtherMonths"), defaultDate = this._getDefaultDate(inst), html = "", row = 0; row < numMonths[0]; row++) {
                    for (group = "", this.maxRows = 4, col = 0; col < numMonths[1]; col++) {
                        if (selectedDate = this._daylightSavingAdjust(new Date(drawYear, drawMonth, inst.selectedDay)), cornerClass = " ui-corner-all", calender = "", isMultiMonth) {
                            if (calender += "<div class='ui-datepicker-group", numMonths[1] > 1)
                                switch (col) {
                                    case 0:
                                        calender += " ui-datepicker-group-first", cornerClass = " ui-corner-" + (isRTL ? "right" : "left");
                                        break;
                                    case numMonths[1] - 1:
                                        calender += " ui-datepicker-group-last", cornerClass = " ui-corner-" + (isRTL ? "left" : "right");
                                        break;
                                    default:
                                        calender += " ui-datepicker-group-middle", cornerClass = ""
                                }
                            calender += "'>"
                        }
                        for (calender += "<div class='ui-datepicker-header ui-widget-header ui-helper-clearfix" + cornerClass + "'>" + (/all|left/.test(cornerClass) && 0 === row ? isRTL ? next : prev : "") + (/all|right/.test(cornerClass) && 0 === row ? isRTL ? prev : next : "") + this._generateMonthYearHeader(inst, drawMonth, drawYear, minDate, maxDate, row > 0 || col > 0, monthNames, monthNamesShort) + "</div><table class='ui-datepicker-calendar'><thead><tr>", thead = showWeek ? "<th class='ui-datepicker-week-col'>" + this._get(inst, "weekHeader") + "</th>" : "", dow = 0; 7 > dow; dow++)
                            day = (dow + firstDay) % 7, thead += "<th scope='col'" + ((dow + firstDay + 6) % 7 >= 5 ? " class='ui-datepicker-week-end'" : "") + "><span title='" + dayNames[day] + "'>" + dayNamesMin[day] + "</span></th>";
                        for (calender += thead + "</tr></thead><tbody>", daysInMonth = this._getDaysInMonth(drawYear, drawMonth), drawYear === inst.selectedYear && drawMonth === inst.selectedMonth && (inst.selectedDay = Math.min(inst.selectedDay, daysInMonth)), leadDays = (this._getFirstDayOfMonth(drawYear, drawMonth) - firstDay + 7) % 7, curRows = Math.ceil((leadDays + daysInMonth) / 7), numRows = isMultiMonth && this.maxRows > curRows ? this.maxRows : curRows, this.maxRows = numRows, printDate = this._daylightSavingAdjust(new Date(drawYear, drawMonth, 1 - leadDays)), dRow = 0; numRows > dRow; dRow++) {
                            for (calender += "<tr>", tbody = showWeek ? "<td class='ui-datepicker-week-col'>" + this._get(inst, "calculateWeek")(printDate) + "</td>" : "", dow = 0; 7 > dow; dow++)
                                daySettings = beforeShowDay ? beforeShowDay.apply(inst.input ? inst.input[0] : null, [printDate]) : [!0, ""], otherMonth = printDate.getMonth() !== drawMonth, unselectable = otherMonth && !selectOtherMonths || !daySettings[0] || minDate && minDate > printDate || maxDate && printDate > maxDate, tbody += "<td class='" + ((dow + firstDay + 6) % 7 >= 5 ? " ui-datepicker-week-end" : "") + (otherMonth ? " ui-datepicker-other-month" : "") + (printDate.getTime() === selectedDate.getTime() && drawMonth === inst.selectedMonth && inst._keyEvent || defaultDate.getTime() === printDate.getTime() && defaultDate.getTime() === selectedDate.getTime() ? " " + this._dayOverClass : "") + (unselectable ? " " + this._unselectableClass + " ui-state-disabled" : "") + (otherMonth && !showOtherMonths ? "" : " " + daySettings[1] + (printDate.getTime() === currentDate.getTime() ? " " + this._currentClass : "") + (printDate.getTime() === today.getTime() ? " ui-datepicker-today" : "")) + "'" + (otherMonth && !showOtherMonths || !daySettings[2] ? "" : " title='" + daySettings[2].replace(/'/g, "&#39;") + "'") + (unselectable ? "" : " data-handler='selectDay' data-event='click' data-month='" + printDate.getMonth() + "' data-year='" + printDate.getFullYear() + "'") + ">" + (otherMonth && !showOtherMonths ? "&#xa0;" : unselectable ? "<span class='ui-state-default'>" + printDate.getDate() + "</span>" : "<a class='ui-state-default" + (printDate.getTime() === today.getTime() ? " ui-state-highlight" : "") + (printDate.getTime() === currentDate.getTime() ? " ui-state-active" : "") + (otherMonth ? " ui-priority-secondary" : "") + "' href='#'>" + printDate.getDate() + "</a>") + "</td>", printDate.setDate(printDate.getDate() + 1), printDate = this._daylightSavingAdjust(printDate);
                            calender += tbody + "</tr>"
                        }
                        drawMonth++, drawMonth > 11 && (drawMonth = 0, drawYear++), calender += "</tbody></table>" + (isMultiMonth ? "</div>" + (numMonths[0] > 0 && col === numMonths[1] - 1 ? "<div class='ui-datepicker-row-break'></div>" : "") : ""), group += calender
                    }
                    html += group
                }
                return html += buttonPanel, inst._keyEvent = !1, html
            },_generateMonthYearHeader: function(inst, drawMonth, drawYear, minDate, maxDate, secondary, monthNames, monthNamesShort) {
                var inMinYear, inMaxYear, month, years, thisYear, determineYear, year, endYear, changeMonth = this._get(inst, "changeMonth"), changeYear = this._get(inst, "changeYear"), showMonthAfterYear = this._get(inst, "showMonthAfterYear"), html = "<div class='ui-datepicker-title'>", monthHtml = "";
                if (secondary || !changeMonth)
                    monthHtml += "<span class='ui-datepicker-month'>" + monthNames[drawMonth] + "</span>";
                else {
                    for (inMinYear = minDate && minDate.getFullYear() === drawYear, inMaxYear = maxDate && maxDate.getFullYear() === drawYear, monthHtml += "<select class='ui-datepicker-month' data-handler='selectMonth' data-event='change'>", month = 0; 12 > month; month++)
                        (!inMinYear || month >= minDate.getMonth()) && (!inMaxYear || month <= maxDate.getMonth()) && (monthHtml += "<option value='" + month + "'" + (month === drawMonth ? " selected='selected'" : "") + ">" + monthNamesShort[month] + "</option>");
                    monthHtml += "</select>"
                }
                if (showMonthAfterYear || (html += monthHtml + (!secondary && changeMonth && changeYear ? "" : "&#xa0;")), !inst.yearshtml)
                    if (inst.yearshtml = "", secondary || !changeYear)
                        html += "<span class='ui-datepicker-year'>" + drawYear + "</span>";
                    else {
                        for (years = this._get(inst, "yearRange").split(":"), thisYear = (new Date).getFullYear(), determineYear = function(value) {
                            var year = value.match(/c[+\-].*/) ? drawYear + parseInt(value.substring(1), 10) : value.match(/[+\-].*/) ? thisYear + parseInt(value, 10) : parseInt(value, 10);
                            return isNaN(year) ? thisYear : year
                        }, year = determineYear(years[0]), endYear = Math.max(year, determineYear(years[1] || "")), year = minDate ? Math.max(year, minDate.getFullYear()) : year, endYear = maxDate ? Math.min(endYear, maxDate.getFullYear()) : endYear, inst.yearshtml += "<select class='ui-datepicker-year' data-handler='selectYear' data-event='change'>"; endYear >= year; year++)
                            inst.yearshtml += "<option value='" + year + "'" + (year === drawYear ? " selected='selected'" : "") + ">" + year + "</option>";
                        inst.yearshtml += "</select>", html += inst.yearshtml, inst.yearshtml = null
                    }
                return html += this._get(inst, "yearSuffix"), showMonthAfterYear && (html += (!secondary && changeMonth && changeYear ? "" : "&#xa0;") + monthHtml), html += "</div>"
            },_adjustInstDate: function(inst, offset, period) {
                var year = inst.drawYear + ("Y" === period ? offset : 0), month = inst.drawMonth + ("M" === period ? offset : 0), day = Math.min(inst.selectedDay, this._getDaysInMonth(year, month)) + ("D" === period ? offset : 0), date = this._restrictMinMax(inst, this._daylightSavingAdjust(new Date(year, month, day)));
                inst.selectedDay = date.getDate(), inst.drawMonth = inst.selectedMonth = date.getMonth(), inst.drawYear = inst.selectedYear = date.getFullYear(), ("M" === period || "Y" === period) && this._notifyChange(inst)
            },_restrictMinMax: function(inst, date) {
                var minDate = this._getMinMaxDate(inst, "min"), maxDate = this._getMinMaxDate(inst, "max"), newDate = minDate && minDate > date ? minDate : date;
                return maxDate && newDate > maxDate ? maxDate : newDate
            },_notifyChange: function(inst) {
                var onChange = this._get(inst, "onChangeMonthYear");
                onChange && onChange.apply(inst.input ? inst.input[0] : null, [inst.selectedYear, inst.selectedMonth + 1, inst])
            },_getNumberOfMonths: function(inst) {
                var numMonths = this._get(inst, "numberOfMonths");
                return null == numMonths ? [1, 1] : "number" == typeof numMonths ? [1, numMonths] : numMonths
            },_getMinMaxDate: function(inst, minMax) {
                return this._determineDate(inst, this._get(inst, minMax + "Date"), null)
            },_getDaysInMonth: function(year, month) {
                return 32 - this._daylightSavingAdjust(new Date(year, month, 32)).getDate()
            },_getFirstDayOfMonth: function(year, month) {
                return new Date(year, month, 1).getDay()
            },_canAdjustMonth: function(inst, offset, curYear, curMonth) {
                var numMonths = this._getNumberOfMonths(inst), date = this._daylightSavingAdjust(new Date(curYear, curMonth + (0 > offset ? offset : numMonths[0] * numMonths[1]), 1));
                return 0 > offset && date.setDate(this._getDaysInMonth(date.getFullYear(), date.getMonth())), this._isInRange(inst, date)
            },_isInRange: function(inst, date) {
                var yearSplit, currentYear, minDate = this._getMinMaxDate(inst, "min"), maxDate = this._getMinMaxDate(inst, "max"), minYear = null, maxYear = null, years = this._get(inst, "yearRange");
                return years && (yearSplit = years.split(":"), currentYear = (new Date).getFullYear(), minYear = parseInt(yearSplit[0], 10), maxYear = parseInt(yearSplit[1], 10), yearSplit[0].match(/[+\-].*/) && (minYear += currentYear), yearSplit[1].match(/[+\-].*/) && (maxYear += currentYear)), (!minDate || date.getTime() >= minDate.getTime()) && (!maxDate || date.getTime() <= maxDate.getTime()) && (!minYear || date.getFullYear() >= minYear) && (!maxYear || date.getFullYear() <= maxYear)
            },_getFormatConfig: function(inst) {
                var shortYearCutoff = this._get(inst, "shortYearCutoff");
                return shortYearCutoff = "string" != typeof shortYearCutoff ? shortYearCutoff : (new Date).getFullYear() % 100 + parseInt(shortYearCutoff, 10), {shortYearCutoff: shortYearCutoff,dayNamesShort: this._get(inst, "dayNamesShort"),dayNames: this._get(inst, "dayNames"),monthNamesShort: this._get(inst, "monthNamesShort"),monthNames: this._get(inst, "monthNames")}
            },_formatDate: function(inst, day, month, year) {
                day || (inst.currentDay = inst.selectedDay, inst.currentMonth = inst.selectedMonth, inst.currentYear = inst.selectedYear);
                var date = day ? "object" == typeof day ? day : this._daylightSavingAdjust(new Date(year, month, day)) : this._daylightSavingAdjust(new Date(inst.currentYear, inst.currentMonth, inst.currentDay));
                return this.formatDate(this._get(inst, "dateFormat"), date, this._getFormatConfig(inst))
            }}), $.fn.datepicker = function(options) {
            if (!this.length)
                return this;
            $.datepicker.initialized || ($(document).mousedown($.datepicker._checkExternalClick), $.datepicker.initialized = !0), 0 === $("#" + $.datepicker._mainDivId).length && $("body").append($.datepicker.dpDiv);
            var otherArgs = Array.prototype.slice.call(arguments, 1);
            return "string" != typeof options || "isDisabled" !== options && "getDate" !== options && "widget" !== options ? "option" === options && 2 === arguments.length && "string" == typeof arguments[1] ? $.datepicker["_" + options + "Datepicker"].apply($.datepicker, [this[0]].concat(otherArgs)) : this.each(function() {
                "string" == typeof options ? $.datepicker["_" + options + "Datepicker"].apply($.datepicker, [this].concat(otherArgs)) : $.datepicker._attachDatepicker(this, options);
            }) : $.datepicker["_" + options + "Datepicker"].apply($.datepicker, [this[0]].concat(otherArgs))
        }, $.datepicker = new Datepicker, $.datepicker.initialized = !1, $.datepicker.uuid = (new Date).getTime(), $.datepicker.version = "1.11.4";
        $.datepicker;
        $.widget("ui.draggable", $.ui.mouse, {version: "1.11.4",widgetEventPrefix: "drag",options: {addClasses: !0,appendTo: "parent",axis: !1,connectToSortable: !1,containment: !1,cursor: "auto",cursorAt: !1,grid: !1,handle: !1,helper: "original",iframeFix: !1,opacity: !1,refreshPositions: !1,revert: !1,revertDuration: 500,scope: "default",scroll: !0,scrollSensitivity: 20,scrollSpeed: 20,snap: !1,snapMode: "both",snapTolerance: 20,stack: !1,zIndex: !1,drag: null,start: null,stop: null},_create: function() {
                "original" === this.options.helper && this._setPositionRelative(), this.options.addClasses && this.element.addClass("ui-draggable"), this.options.disabled && this.element.addClass("ui-draggable-disabled"), this._setHandleClassName(), this._mouseInit()
            },_setOption: function(key, value) {
                this._super(key, value), "handle" === key && (this._removeHandleClassName(), this._setHandleClassName())
            },_destroy: function() {
                return (this.helper || this.element).is(".ui-draggable-dragging") ? void (this.destroyOnClear = !0) : (this.element.removeClass("ui-draggable ui-draggable-dragging ui-draggable-disabled"), this._removeHandleClassName(), void this._mouseDestroy())
            },_mouseCapture: function(event) {
                var o = this.options;
                return this._blurActiveElement(event), this.helper || o.disabled || $(event.target).closest(".ui-resizable-handle").length > 0 ? !1 : (this.handle = this._getHandle(event), this.handle ? (this._blockFrames(o.iframeFix === !0 ? "iframe" : o.iframeFix), !0) : !1)
            },_blockFrames: function(selector) {
                this.iframeBlocks = this.document.find(selector).map(function() {
                    var iframe = $(this);
                    return $("<div>").css("position", "absolute").appendTo(iframe.parent()).outerWidth(iframe.outerWidth()).outerHeight(iframe.outerHeight()).offset(iframe.offset())[0]
                })
            },_unblockFrames: function() {
                this.iframeBlocks && (this.iframeBlocks.remove(), delete this.iframeBlocks)
            },_blurActiveElement: function(event) {
                var document = this.document[0];
                if (this.handleElement.is(event.target))
                    try {
                        document.activeElement && "body" !== document.activeElement.nodeName.toLowerCase() && $(document.activeElement).blur()
                    } catch (error) {
                    }
            },_mouseStart: function(event) {
                var o = this.options;
                return this.helper = this._createHelper(event), this.helper.addClass("ui-draggable-dragging"), this._cacheHelperProportions(), $.ui.ddmanager && ($.ui.ddmanager.current = this), this._cacheMargins(), this.cssPosition = this.helper.css("position"), this.scrollParent = this.helper.scrollParent(!0), this.offsetParent = this.helper.offsetParent(), this.hasFixedAncestor = this.helper.parents().filter(function() {
                    return "fixed" === $(this).css("position")
                }).length > 0, this.positionAbs = this.element.offset(), this._refreshOffsets(event), this.originalPosition = this.position = this._generatePosition(event, !1), this.originalPageX = event.pageX, this.originalPageY = event.pageY, o.cursorAt && this._adjustOffsetFromHelper(o.cursorAt), this._setContainment(), this._trigger("start", event) === !1 ? (this._clear(), !1) : (this._cacheHelperProportions(), $.ui.ddmanager && !o.dropBehaviour && $.ui.ddmanager.prepareOffsets(this, event), this._normalizeRightBottom(), this._mouseDrag(event, !0), $.ui.ddmanager && $.ui.ddmanager.dragStart(this, event), !0)
            },_refreshOffsets: function(event) {
                this.offset = {top: this.positionAbs.top - this.margins.top,left: this.positionAbs.left - this.margins.left,scroll: !1,parent: this._getParentOffset(),relative: this._getRelativeOffset()}, this.offset.click = {left: event.pageX - this.offset.left,top: event.pageY - this.offset.top}
            },_mouseDrag: function(event, noPropagation) {
                if (this.hasFixedAncestor && (this.offset.parent = this._getParentOffset()), this.position = this._generatePosition(event, !0), this.positionAbs = this._convertPositionTo("absolute"), !noPropagation) {
                    var ui = this._uiHash();
                    if (this._trigger("drag", event, ui) === !1)
                        return this._mouseUp({}), !1;
                    this.position = ui.position
                }
                return this.helper[0].style.left = this.position.left + "px", this.helper[0].style.top = this.position.top + "px", $.ui.ddmanager && $.ui.ddmanager.drag(this, event), !1
            },_mouseStop: function(event) {
                var that = this, dropped = !1;
                return $.ui.ddmanager && !this.options.dropBehaviour && (dropped = $.ui.ddmanager.drop(this, event)), this.dropped && (dropped = this.dropped, this.dropped = !1), "invalid" === this.options.revert && !dropped || "valid" === this.options.revert && dropped || this.options.revert === !0 || $.isFunction(this.options.revert) && this.options.revert.call(this.element, dropped) ? $(this.helper).animate(this.originalPosition, parseInt(this.options.revertDuration, 10), function() {
                    that._trigger("stop", event) !== !1 && that._clear()
                }) : this._trigger("stop", event) !== !1 && this._clear(), !1
            },_mouseUp: function(event) {
                return this._unblockFrames(), $.ui.ddmanager && $.ui.ddmanager.dragStop(this, event), this.handleElement.is(event.target) && this.element.focus(), $.ui.mouse.prototype._mouseUp.call(this, event)
            },cancel: function() {
                return this.helper.is(".ui-draggable-dragging") ? this._mouseUp({}) : this._clear(), this
            },_getHandle: function(event) {
                return this.options.handle ? !!$(event.target).closest(this.element.find(this.options.handle)).length : !0
            },_setHandleClassName: function() {
                this.handleElement = this.options.handle ? this.element.find(this.options.handle) : this.element, this.handleElement.addClass("ui-draggable-handle")
            },_removeHandleClassName: function() {
                this.handleElement.removeClass("ui-draggable-handle")
            },_createHelper: function(event) {
                var o = this.options, helperIsFunction = $.isFunction(o.helper), helper = helperIsFunction ? $(o.helper.apply(this.element[0], [event])) : "clone" === o.helper ? this.element.clone().removeAttr("id") : this.element;
                return helper.parents("body").length || helper.appendTo("parent" === o.appendTo ? this.element[0].parentNode : o.appendTo), helperIsFunction && helper[0] === this.element[0] && this._setPositionRelative(), helper[0] === this.element[0] || /(fixed|absolute)/.test(helper.css("position")) || helper.css("position", "absolute"), helper
            },_setPositionRelative: function() {
                /^(?:r|a|f)/.test(this.element.css("position")) || (this.element[0].style.position = "relative")
            },_adjustOffsetFromHelper: function(obj) {
                "string" == typeof obj && (obj = obj.split(" ")), $.isArray(obj) && (obj = {left: +obj[0],top: +obj[1] || 0}), "left" in obj && (this.offset.click.left = obj.left + this.margins.left), "right" in obj && (this.offset.click.left = this.helperProportions.width - obj.right + this.margins.left), "top" in obj && (this.offset.click.top = obj.top + this.margins.top), "bottom" in obj && (this.offset.click.top = this.helperProportions.height - obj.bottom + this.margins.top)
            },_isRootNode: function(element) {
                return /(html|body)/i.test(element.tagName) || element === this.document[0]
            },_getParentOffset: function() {
                var po = this.offsetParent.offset(), document = this.document[0];
                return "absolute" === this.cssPosition && this.scrollParent[0] !== document && $.contains(this.scrollParent[0], this.offsetParent[0]) && (po.left += this.scrollParent.scrollLeft(), po.top += this.scrollParent.scrollTop()), this._isRootNode(this.offsetParent[0]) && (po = {top: 0,left: 0}), {top: po.top + (parseInt(this.offsetParent.css("borderTopWidth"), 10) || 0),left: po.left + (parseInt(this.offsetParent.css("borderLeftWidth"), 10) || 0)}
            },_getRelativeOffset: function() {
                if ("relative" !== this.cssPosition)
                    return {top: 0,left: 0};
                var p = this.element.position(), scrollIsRootNode = this._isRootNode(this.scrollParent[0]);
                return {top: p.top - (parseInt(this.helper.css("top"), 10) || 0) + (scrollIsRootNode ? 0 : this.scrollParent.scrollTop()),left: p.left - (parseInt(this.helper.css("left"), 10) || 0) + (scrollIsRootNode ? 0 : this.scrollParent.scrollLeft())}
            },_cacheMargins: function() {
                this.margins = {left: parseInt(this.element.css("marginLeft"), 10) || 0,top: parseInt(this.element.css("marginTop"), 10) || 0,right: parseInt(this.element.css("marginRight"), 10) || 0,bottom: parseInt(this.element.css("marginBottom"), 10) || 0}
            },_cacheHelperProportions: function() {
                this.helperProportions = {width: this.helper.outerWidth(),height: this.helper.outerHeight()}
            },_setContainment: function() {
                var isUserScrollable, c, ce, o = this.options, document = this.document[0];
                return this.relativeContainer = null, o.containment ? "window" === o.containment ? void (this.containment = [$(window).scrollLeft() - this.offset.relative.left - this.offset.parent.left, $(window).scrollTop() - this.offset.relative.top - this.offset.parent.top, $(window).scrollLeft() + $(window).width() - this.helperProportions.width - this.margins.left, $(window).scrollTop() + ($(window).height() || document.body.parentNode.scrollHeight) - this.helperProportions.height - this.margins.top]) : "document" === o.containment ? void (this.containment = [0, 0, $(document).width() - this.helperProportions.width - this.margins.left, ($(document).height() || document.body.parentNode.scrollHeight) - this.helperProportions.height - this.margins.top]) : o.containment.constructor === Array ? void (this.containment = o.containment) : ("parent" === o.containment && (o.containment = this.helper[0].parentNode), c = $(o.containment), ce = c[0], void (ce && (isUserScrollable = /(scroll|auto)/.test(c.css("overflow")), this.containment = [(parseInt(c.css("borderLeftWidth"), 10) || 0) + (parseInt(c.css("paddingLeft"), 10) || 0), (parseInt(c.css("borderTopWidth"), 10) || 0) + (parseInt(c.css("paddingTop"), 10) || 0), (isUserScrollable ? Math.max(ce.scrollWidth, ce.offsetWidth) : ce.offsetWidth) - (parseInt(c.css("borderRightWidth"), 10) || 0) - (parseInt(c.css("paddingRight"), 10) || 0) - this.helperProportions.width - this.margins.left - this.margins.right, (isUserScrollable ? Math.max(ce.scrollHeight, ce.offsetHeight) : ce.offsetHeight) - (parseInt(c.css("borderBottomWidth"), 10) || 0) - (parseInt(c.css("paddingBottom"), 10) || 0) - this.helperProportions.height - this.margins.top - this.margins.bottom], this.relativeContainer = c))) : void (this.containment = null)
            },_convertPositionTo: function(d, pos) {
                pos || (pos = this.position);
                var mod = "absolute" === d ? 1 : -1, scrollIsRootNode = this._isRootNode(this.scrollParent[0]);
                return {top: pos.top + this.offset.relative.top * mod + this.offset.parent.top * mod - ("fixed" === this.cssPosition ? -this.offset.scroll.top : scrollIsRootNode ? 0 : this.offset.scroll.top) * mod,left: pos.left + this.offset.relative.left * mod + this.offset.parent.left * mod - ("fixed" === this.cssPosition ? -this.offset.scroll.left : scrollIsRootNode ? 0 : this.offset.scroll.left) * mod}
            },_generatePosition: function(event, constrainPosition) {
                var containment, co, top, left, o = this.options, scrollIsRootNode = this._isRootNode(this.scrollParent[0]), pageX = event.pageX, pageY = event.pageY;
                return scrollIsRootNode && this.offset.scroll || (this.offset.scroll = {top: this.scrollParent.scrollTop(),left: this.scrollParent.scrollLeft()}), constrainPosition && (this.containment && (this.relativeContainer ? (co = this.relativeContainer.offset(), containment = [this.containment[0] + co.left, this.containment[1] + co.top, this.containment[2] + co.left, this.containment[3] + co.top]) : containment = this.containment, event.pageX - this.offset.click.left < containment[0] && (pageX = containment[0] + this.offset.click.left), event.pageY - this.offset.click.top < containment[1] && (pageY = containment[1] + this.offset.click.top), event.pageX - this.offset.click.left > containment[2] && (pageX = containment[2] + this.offset.click.left), event.pageY - this.offset.click.top > containment[3] && (pageY = containment[3] + this.offset.click.top)), o.grid && (top = o.grid[1] ? this.originalPageY + Math.round((pageY - this.originalPageY) / o.grid[1]) * o.grid[1] : this.originalPageY, pageY = containment ? top - this.offset.click.top >= containment[1] || top - this.offset.click.top > containment[3] ? top : top - this.offset.click.top >= containment[1] ? top - o.grid[1] : top + o.grid[1] : top, left = o.grid[0] ? this.originalPageX + Math.round((pageX - this.originalPageX) / o.grid[0]) * o.grid[0] : this.originalPageX, pageX = containment ? left - this.offset.click.left >= containment[0] || left - this.offset.click.left > containment[2] ? left : left - this.offset.click.left >= containment[0] ? left - o.grid[0] : left + o.grid[0] : left), "y" === o.axis && (pageX = this.originalPageX), "x" === o.axis && (pageY = this.originalPageY)), {top: pageY - this.offset.click.top - this.offset.relative.top - this.offset.parent.top + ("fixed" === this.cssPosition ? -this.offset.scroll.top : scrollIsRootNode ? 0 : this.offset.scroll.top),left: pageX - this.offset.click.left - this.offset.relative.left - this.offset.parent.left + ("fixed" === this.cssPosition ? -this.offset.scroll.left : scrollIsRootNode ? 0 : this.offset.scroll.left)}
            },_clear: function() {
                this.helper.removeClass("ui-draggable-dragging"), this.helper[0] === this.element[0] || this.cancelHelperRemoval || this.helper.remove(), this.helper = null, this.cancelHelperRemoval = !1, this.destroyOnClear && this.destroy()
            },_normalizeRightBottom: function() {
                "y" !== this.options.axis && "auto" !== this.helper.css("right") && (this.helper.width(this.helper.width()), this.helper.css("right", "auto")), "x" !== this.options.axis && "auto" !== this.helper.css("bottom") && (this.helper.height(this.helper.height()), this.helper.css("bottom", "auto"))
            },_trigger: function(type, event, ui) {
                return ui = ui || this._uiHash(), $.ui.plugin.call(this, type, [event, ui, this], !0), /^(drag|start|stop)/.test(type) && (this.positionAbs = this._convertPositionTo("absolute"), ui.offset = this.positionAbs), $.Widget.prototype._trigger.call(this, type, event, ui)
            },plugins: {},_uiHash: function() {
                return {helper: this.helper,position: this.position,originalPosition: this.originalPosition,offset: this.positionAbs}
            }}), $.ui.plugin.add("draggable", "connectToSortable", {start: function(event, ui, draggable) {
                var uiSortable = $.extend({}, ui, {item: draggable.element});
                draggable.sortables = [], $(draggable.options.connectToSortable).each(function() {
                    var sortable = $(this).sortable("instance");
                    sortable && !sortable.options.disabled && (draggable.sortables.push(sortable), sortable.refreshPositions(), sortable._trigger("activate", event, uiSortable))
                })
            },stop: function(event, ui, draggable) {
                var uiSortable = $.extend({}, ui, {item: draggable.element});
                draggable.cancelHelperRemoval = !1, $.each(draggable.sortables, function() {
                    var sortable = this;
                    sortable.isOver ? (sortable.isOver = 0, draggable.cancelHelperRemoval = !0, sortable.cancelHelperRemoval = !1, sortable._storedCSS = {position: sortable.placeholder.css("position"),top: sortable.placeholder.css("top"),left: sortable.placeholder.css("left")}, sortable._mouseStop(event), sortable.options.helper = sortable.options._helper) : (sortable.cancelHelperRemoval = !0, sortable._trigger("deactivate", event, uiSortable))
                })
            },drag: function(event, ui, draggable) {
                $.each(draggable.sortables, function() {
                    var innermostIntersecting = !1, sortable = this;
                    sortable.positionAbs = draggable.positionAbs, sortable.helperProportions = draggable.helperProportions, sortable.offset.click = draggable.offset.click, sortable._intersectsWith(sortable.containerCache) && (innermostIntersecting = !0, $.each(draggable.sortables, function() {
                        return this.positionAbs = draggable.positionAbs, this.helperProportions = draggable.helperProportions, this.offset.click = draggable.offset.click, this !== sortable && this._intersectsWith(this.containerCache) && $.contains(sortable.element[0], this.element[0]) && (innermostIntersecting = !1), innermostIntersecting
                    })), innermostIntersecting ? (sortable.isOver || (sortable.isOver = 1, draggable._parent = ui.helper.parent(), sortable.currentItem = ui.helper.appendTo(sortable.element).data("ui-sortable-item", !0), sortable.options._helper = sortable.options.helper, sortable.options.helper = function() {
                        return ui.helper[0]
                    }, event.target = sortable.currentItem[0], sortable._mouseCapture(event, !0), sortable._mouseStart(event, !0, !0), sortable.offset.click.top = draggable.offset.click.top, sortable.offset.click.left = draggable.offset.click.left, sortable.offset.parent.left -= draggable.offset.parent.left - sortable.offset.parent.left, sortable.offset.parent.top -= draggable.offset.parent.top - sortable.offset.parent.top, draggable._trigger("toSortable", event), draggable.dropped = sortable.element, $.each(draggable.sortables, function() {
                        this.refreshPositions()
                    }), draggable.currentItem = draggable.element, sortable.fromOutside = draggable), sortable.currentItem && (sortable._mouseDrag(event), ui.position = sortable.position)) : sortable.isOver && (sortable.isOver = 0, sortable.cancelHelperRemoval = !0, sortable.options._revert = sortable.options.revert, sortable.options.revert = !1, sortable._trigger("out", event, sortable._uiHash(sortable)), sortable._mouseStop(event, !0), sortable.options.revert = sortable.options._revert, sortable.options.helper = sortable.options._helper, sortable.placeholder && sortable.placeholder.remove(), ui.helper.appendTo(draggable._parent), draggable._refreshOffsets(event), ui.position = draggable._generatePosition(event, !0), draggable._trigger("fromSortable", event), draggable.dropped = !1, $.each(draggable.sortables, function() {
                        this.refreshPositions()
                    }))
                })
            }}), $.ui.plugin.add("draggable", "cursor", {start: function(event, ui, instance) {
                var t = $("body"), o = instance.options;
                t.css("cursor") && (o._cursor = t.css("cursor")), t.css("cursor", o.cursor)
            },stop: function(event, ui, instance) {
                var o = instance.options;
                o._cursor && $("body").css("cursor", o._cursor)
            }}), $.ui.plugin.add("draggable", "opacity", {start: function(event, ui, instance) {
                var t = $(ui.helper), o = instance.options;
                t.css("opacity") && (o._opacity = t.css("opacity")), t.css("opacity", o.opacity)
            },stop: function(event, ui, instance) {
                var o = instance.options;
                o._opacity && $(ui.helper).css("opacity", o._opacity)
            }}), $.ui.plugin.add("draggable", "scroll", {start: function(event, ui, i) {
                i.scrollParentNotHidden || (i.scrollParentNotHidden = i.helper.scrollParent(!1)), i.scrollParentNotHidden[0] !== i.document[0] && "HTML" !== i.scrollParentNotHidden[0].tagName && (i.overflowOffset = i.scrollParentNotHidden.offset())
            },drag: function(event, ui, i) {
                var o = i.options, scrolled = !1, scrollParent = i.scrollParentNotHidden[0], document = i.document[0];
                scrollParent !== document && "HTML" !== scrollParent.tagName ? (o.axis && "x" === o.axis || (i.overflowOffset.top + scrollParent.offsetHeight - event.pageY < o.scrollSensitivity ? scrollParent.scrollTop = scrolled = scrollParent.scrollTop + o.scrollSpeed : event.pageY - i.overflowOffset.top < o.scrollSensitivity && (scrollParent.scrollTop = scrolled = scrollParent.scrollTop - o.scrollSpeed)), o.axis && "y" === o.axis || (i.overflowOffset.left + scrollParent.offsetWidth - event.pageX < o.scrollSensitivity ? scrollParent.scrollLeft = scrolled = scrollParent.scrollLeft + o.scrollSpeed : event.pageX - i.overflowOffset.left < o.scrollSensitivity && (scrollParent.scrollLeft = scrolled = scrollParent.scrollLeft - o.scrollSpeed))) : (o.axis && "x" === o.axis || (event.pageY - $(document).scrollTop() < o.scrollSensitivity ? scrolled = $(document).scrollTop($(document).scrollTop() - o.scrollSpeed) : $(window).height() - (event.pageY - $(document).scrollTop()) < o.scrollSensitivity && (scrolled = $(document).scrollTop($(document).scrollTop() + o.scrollSpeed))), o.axis && "y" === o.axis || (event.pageX - $(document).scrollLeft() < o.scrollSensitivity ? scrolled = $(document).scrollLeft($(document).scrollLeft() - o.scrollSpeed) : $(window).width() - (event.pageX - $(document).scrollLeft()) < o.scrollSensitivity && (scrolled = $(document).scrollLeft($(document).scrollLeft() + o.scrollSpeed)))), scrolled !== !1 && $.ui.ddmanager && !o.dropBehaviour && $.ui.ddmanager.prepareOffsets(i, event)
            }}), $.ui.plugin.add("draggable", "snap", {start: function(event, ui, i) {
                var o = i.options;
                i.snapElements = [], $(o.snap.constructor !== String ? o.snap.items || ":data(ui-draggable)" : o.snap).each(function() {
                    var $t = $(this), $o = $t.offset();
                    this !== i.element[0] && i.snapElements.push({item: this,width: $t.outerWidth(),height: $t.outerHeight(),top: $o.top,left: $o.left})
                })
            },drag: function(event, ui, inst) {
                var ts, bs, ls, rs, l, r, t, b, i, first, o = inst.options, d = o.snapTolerance, x1 = ui.offset.left, x2 = x1 + inst.helperProportions.width, y1 = ui.offset.top, y2 = y1 + inst.helperProportions.height;
                for (i = inst.snapElements.length - 1; i >= 0; i--)
                    l = inst.snapElements[i].left - inst.margins.left, r = l + inst.snapElements[i].width, t = inst.snapElements[i].top - inst.margins.top, b = t + inst.snapElements[i].height, l - d > x2 || x1 > r + d || t - d > y2 || y1 > b + d || !$.contains(inst.snapElements[i].item.ownerDocument, inst.snapElements[i].item) ? (inst.snapElements[i].snapping && inst.options.snap.release && inst.options.snap.release.call(inst.element, event, $.extend(inst._uiHash(), {snapItem: inst.snapElements[i].item})), inst.snapElements[i].snapping = !1) : ("inner" !== o.snapMode && (ts = Math.abs(t - y2) <= d, bs = Math.abs(b - y1) <= d, ls = Math.abs(l - x2) <= d, rs = Math.abs(r - x1) <= d, ts && (ui.position.top = inst._convertPositionTo("relative", {top: t - inst.helperProportions.height,left: 0}).top), bs && (ui.position.top = inst._convertPositionTo("relative", {top: b,left: 0}).top), ls && (ui.position.left = inst._convertPositionTo("relative", {top: 0,left: l - inst.helperProportions.width}).left), rs && (ui.position.left = inst._convertPositionTo("relative", {top: 0,left: r}).left)), first = ts || bs || ls || rs, "outer" !== o.snapMode && (ts = Math.abs(t - y1) <= d, bs = Math.abs(b - y2) <= d, ls = Math.abs(l - x1) <= d, rs = Math.abs(r - x2) <= d, ts && (ui.position.top = inst._convertPositionTo("relative", {top: t,left: 0}).top), bs && (ui.position.top = inst._convertPositionTo("relative", {top: b - inst.helperProportions.height,left: 0}).top), ls && (ui.position.left = inst._convertPositionTo("relative", {top: 0,left: l}).left), rs && (ui.position.left = inst._convertPositionTo("relative", {top: 0,left: r - inst.helperProportions.width}).left)), !inst.snapElements[i].snapping && (ts || bs || ls || rs || first) && inst.options.snap.snap && inst.options.snap.snap.call(inst.element, event, $.extend(inst._uiHash(), {snapItem: inst.snapElements[i].item})), inst.snapElements[i].snapping = ts || bs || ls || rs || first)
            }}), $.ui.plugin.add("draggable", "stack", {start: function(event, ui, instance) {
                var min, o = instance.options, group = $.makeArray($(o.stack)).sort(function(a, b) {
                    return (parseInt($(a).css("zIndex"), 10) || 0) - (parseInt($(b).css("zIndex"), 10) || 0)
                });
                group.length && (min = parseInt($(group[0]).css("zIndex"), 10) || 0, $(group).each(function(i) {
                    $(this).css("zIndex", min + i)
                }), this.css("zIndex", min + group.length))
            }}), $.ui.plugin.add("draggable", "zIndex", {start: function(event, ui, instance) {
                var t = $(ui.helper), o = instance.options;
                t.css("zIndex") && (o._zIndex = t.css("zIndex")), t.css("zIndex", o.zIndex)
            },stop: function(event, ui, instance) {
                var o = instance.options;
                o._zIndex && $(ui.helper).css("zIndex", o._zIndex)
            }});
        $.ui.draggable;
        $.widget("ui.resizable", $.ui.mouse, {version: "1.11.4",widgetEventPrefix: "resize",options: {alsoResize: !1,animate: !1,animateDuration: "slow",animateEasing: "swing",aspectRatio: !1,autoHide: !1,containment: !1,ghost: !1,grid: !1,handles: "e,s,se",helper: !1,maxHeight: null,maxWidth: null,minHeight: 10,minWidth: 10,zIndex: 90,resize: null,start: null,stop: null},_num: function(value) {
                return parseInt(value, 10) || 0
            },_isNumber: function(value) {
                return !isNaN(parseInt(value, 10))
            },_hasScroll: function(el, a) {
                if ("hidden" === $(el).css("overflow"))
                    return !1;
                var scroll = a && "left" === a ? "scrollLeft" : "scrollTop", has = !1;
                return el[scroll] > 0 ? !0 : (el[scroll] = 1, has = el[scroll] > 0, el[scroll] = 0, has)
            },_create: function() {
                var n, i, handle, axis, hname, that = this, o = this.options;
                if (this.element.addClass("ui-resizable"), $.extend(this, {_aspectRatio: !!o.aspectRatio,aspectRatio: o.aspectRatio,originalElement: this.element,_proportionallyResizeElements: [],_helper: o.helper || o.ghost || o.animate ? o.helper || "ui-resizable-helper" : null}), this.element[0].nodeName.match(/^(canvas|textarea|input|select|button|img)$/i) && (this.element.wrap($("<div class='ui-wrapper' style='overflow: hidden;'></div>").css({position: this.element.css("position"),width: this.element.outerWidth(),height: this.element.outerHeight(),top: this.element.css("top"),left: this.element.css("left")})), this.element = this.element.parent().data("ui-resizable", this.element.resizable("instance")), this.elementIsWrapper = !0, this.element.css({marginLeft: this.originalElement.css("marginLeft"),marginTop: this.originalElement.css("marginTop"),marginRight: this.originalElement.css("marginRight"),marginBottom: this.originalElement.css("marginBottom")}), this.originalElement.css({marginLeft: 0,marginTop: 0,marginRight: 0,marginBottom: 0}), this.originalResizeStyle = this.originalElement.css("resize"), this.originalElement.css("resize", "none"), this._proportionallyResizeElements.push(this.originalElement.css({position: "static",zoom: 1,display: "block"})), this.originalElement.css({margin: this.originalElement.css("margin")}), this._proportionallyResize()), this.handles = o.handles || ($(".ui-resizable-handle", this.element).length ? {n: ".ui-resizable-n",e: ".ui-resizable-e",s: ".ui-resizable-s",w: ".ui-resizable-w",se: ".ui-resizable-se",sw: ".ui-resizable-sw",ne: ".ui-resizable-ne",nw: ".ui-resizable-nw"} : "e,s,se"), this._handles = $(), this.handles.constructor === String)
                    for ("all" === this.handles && (this.handles = "n,e,s,w,se,sw,ne,nw"), n = this.handles.split(","), this.handles = {}, i = 0; i < n.length; i++)
                        handle = $.trim(n[i]), hname = "ui-resizable-" + handle, axis = $("<div class='ui-resizable-handle " + hname + "'></div>"), axis.css({zIndex: o.zIndex}), "se" === handle && axis.addClass("ui-icon ui-icon-gripsmall-diagonal-se"), this.handles[handle] = ".ui-resizable-" + handle, this.element.append(axis);
                this._renderAxis = function(target) {
                    var i, axis, padPos, padWrapper;
                    target = target || this.element;
                    for (i in this.handles)
                        this.handles[i].constructor === String ? this.handles[i] = this.element.children(this.handles[i]).first().show() : (this.handles[i].jquery || this.handles[i].nodeType) && (this.handles[i] = $(this.handles[i]), this._on(this.handles[i], {mousedown: that._mouseDown})), this.elementIsWrapper && this.originalElement[0].nodeName.match(/^(textarea|input|select|button)$/i) && (axis = $(this.handles[i], this.element), padWrapper = /sw|ne|nw|se|n|s/.test(i) ? axis.outerHeight() : axis.outerWidth(), padPos = ["padding", /ne|nw|n/.test(i) ? "Top" : /se|sw|s/.test(i) ? "Bottom" : /^e$/.test(i) ? "Right" : "Left"].join(""), target.css(padPos, padWrapper), this._proportionallyResize()), this._handles = this._handles.add(this.handles[i])
                }, this._renderAxis(this.element), this._handles = this._handles.add(this.element.find(".ui-resizable-handle")), this._handles.disableSelection(), this._handles.mouseover(function() {
                    that.resizing || (this.className && (axis = this.className.match(/ui-resizable-(se|sw|ne|nw|n|e|s|w)/i)), that.axis = axis && axis[1] ? axis[1] : "se")
                }), o.autoHide && (this._handles.hide(), $(this.element).addClass("ui-resizable-autohide").mouseenter(function() {
                    o.disabled || ($(this).removeClass("ui-resizable-autohide"), that._handles.show())
                }).mouseleave(function() {
                    o.disabled || that.resizing || ($(this).addClass("ui-resizable-autohide"), that._handles.hide())
                })), this._mouseInit()
            },_destroy: function() {
                this._mouseDestroy();
                var wrapper, _destroy = function(exp) {
                    $(exp).removeClass("ui-resizable ui-resizable-disabled ui-resizable-resizing").removeData("resizable").removeData("ui-resizable").unbind(".resizable").find(".ui-resizable-handle").remove()
                };
                return this.elementIsWrapper && (_destroy(this.element), wrapper = this.element, this.originalElement.css({position: wrapper.css("position"),width: wrapper.outerWidth(),height: wrapper.outerHeight(),top: wrapper.css("top"),left: wrapper.css("left")}).insertAfter(wrapper), wrapper.remove()), this.originalElement.css("resize", this.originalResizeStyle), _destroy(this.originalElement), this
            },_mouseCapture: function(event) {
                var i, handle, capture = !1;
                for (i in this.handles)
                    handle = $(this.handles[i])[0], (handle === event.target || $.contains(handle, event.target)) && (capture = !0);
                return !this.options.disabled && capture
            },_mouseStart: function(event) {
                var curleft, curtop, cursor, o = this.options, el = this.element;
                return this.resizing = !0, this._renderProxy(), curleft = this._num(this.helper.css("left")), curtop = this._num(this.helper.css("top")), o.containment && (curleft += $(o.containment).scrollLeft() || 0, curtop += $(o.containment).scrollTop() || 0), this.offset = this.helper.offset(), this.position = {left: curleft,top: curtop}, this.size = this._helper ? {width: this.helper.width(),height: this.helper.height()} : {width: el.width(),height: el.height()}, this.originalSize = this._helper ? {width: el.outerWidth(),height: el.outerHeight()} : {width: el.width(),height: el.height()}, this.sizeDiff = {width: el.outerWidth() - el.width(),height: el.outerHeight() - el.height()}, this.originalPosition = {left: curleft,top: curtop}, this.originalMousePosition = {left: event.pageX,top: event.pageY}, this.aspectRatio = "number" == typeof o.aspectRatio ? o.aspectRatio : this.originalSize.width / this.originalSize.height || 1, cursor = $(".ui-resizable-" + this.axis).css("cursor"), $("body").css("cursor", "auto" === cursor ? this.axis + "-resize" : cursor), el.addClass("ui-resizable-resizing"), this._propagate("start", event), !0
            },_mouseDrag: function(event) {
                var data, props, smp = this.originalMousePosition, a = this.axis, dx = event.pageX - smp.left || 0, dy = event.pageY - smp.top || 0, trigger = this._change[a];
                return this._updatePrevProperties(), trigger ? (data = trigger.apply(this, [event, dx, dy]), this._updateVirtualBoundaries(event.shiftKey), (this._aspectRatio || event.shiftKey) && (data = this._updateRatio(data, event)), data = this._respectSize(data, event), this._updateCache(data), this._propagate("resize", event), props = this._applyChanges(), !this._helper && this._proportionallyResizeElements.length && this._proportionallyResize(), $.isEmptyObject(props) || (this._updatePrevProperties(), this._trigger("resize", event, this.ui()), this._applyChanges()), !1) : !1
            },_mouseStop: function(event) {
                this.resizing = !1;
                var pr, ista, soffseth, soffsetw, s, left, top, o = this.options, that = this;
                return this._helper && (pr = this._proportionallyResizeElements, ista = pr.length && /textarea/i.test(pr[0].nodeName), soffseth = ista && this._hasScroll(pr[0], "left") ? 0 : that.sizeDiff.height, soffsetw = ista ? 0 : that.sizeDiff.width, s = {width: that.helper.width() - soffsetw,height: that.helper.height() - soffseth}, left = parseInt(that.element.css("left"), 10) + (that.position.left - that.originalPosition.left) || null, top = parseInt(that.element.css("top"), 10) + (that.position.top - that.originalPosition.top) || null, o.animate || this.element.css($.extend(s, {top: top,left: left})), that.helper.height(that.size.height), that.helper.width(that.size.width), this._helper && !o.animate && this._proportionallyResize()), $("body").css("cursor", "auto"), this.element.removeClass("ui-resizable-resizing"), this._propagate("stop", event), this._helper && this.helper.remove(), !1
            },_updatePrevProperties: function() {
                this.prevPosition = {top: this.position.top,left: this.position.left}, this.prevSize = {width: this.size.width,height: this.size.height}
            },_applyChanges: function() {
                var props = {};
                return this.position.top !== this.prevPosition.top && (props.top = this.position.top + "px"), this.position.left !== this.prevPosition.left && (props.left = this.position.left + "px"), this.size.width !== this.prevSize.width && (props.width = this.size.width + "px"), this.size.height !== this.prevSize.height && (props.height = this.size.height + "px"), this.helper.css(props), props
            },_updateVirtualBoundaries: function(forceAspectRatio) {
                var pMinWidth, pMaxWidth, pMinHeight, pMaxHeight, b, o = this.options;
                b = {minWidth: this._isNumber(o.minWidth) ? o.minWidth : 0,maxWidth: this._isNumber(o.maxWidth) ? o.maxWidth : 1 / 0,minHeight: this._isNumber(o.minHeight) ? o.minHeight : 0,maxHeight: this._isNumber(o.maxHeight) ? o.maxHeight : 1 / 0}, (this._aspectRatio || forceAspectRatio) && (pMinWidth = b.minHeight * this.aspectRatio, pMinHeight = b.minWidth / this.aspectRatio, pMaxWidth = b.maxHeight * this.aspectRatio, pMaxHeight = b.maxWidth / this.aspectRatio, pMinWidth > b.minWidth && (b.minWidth = pMinWidth), pMinHeight > b.minHeight && (b.minHeight = pMinHeight), pMaxWidth < b.maxWidth && (b.maxWidth = pMaxWidth), pMaxHeight < b.maxHeight && (b.maxHeight = pMaxHeight)), this._vBoundaries = b
            },_updateCache: function(data) {
                this.offset = this.helper.offset(), this._isNumber(data.left) && (this.position.left = data.left), this._isNumber(data.top) && (this.position.top = data.top), this._isNumber(data.height) && (this.size.height = data.height), this._isNumber(data.width) && (this.size.width = data.width)
            },_updateRatio: function(data) {
                var cpos = this.position, csize = this.size, a = this.axis;
                return this._isNumber(data.height) ? data.width = data.height * this.aspectRatio : this._isNumber(data.width) && (data.height = data.width / this.aspectRatio), "sw" === a && (data.left = cpos.left + (csize.width - data.width), data.top = null), "nw" === a && (data.top = cpos.top + (csize.height - data.height), data.left = cpos.left + (csize.width - data.width)), data
            },_respectSize: function(data) {
                var o = this._vBoundaries, a = this.axis, ismaxw = this._isNumber(data.width) && o.maxWidth && o.maxWidth < data.width, ismaxh = this._isNumber(data.height) && o.maxHeight && o.maxHeight < data.height, isminw = this._isNumber(data.width) && o.minWidth && o.minWidth > data.width, isminh = this._isNumber(data.height) && o.minHeight && o.minHeight > data.height, dw = this.originalPosition.left + this.originalSize.width, dh = this.position.top + this.size.height, cw = /sw|nw|w/.test(a), ch = /nw|ne|n/.test(a);
                return isminw && (data.width = o.minWidth), isminh && (data.height = o.minHeight), ismaxw && (data.width = o.maxWidth), ismaxh && (data.height = o.maxHeight), isminw && cw && (data.left = dw - o.minWidth), ismaxw && cw && (data.left = dw - o.maxWidth), 
                isminh && ch && (data.top = dh - o.minHeight), ismaxh && ch && (data.top = dh - o.maxHeight), data.width || data.height || data.left || !data.top ? data.width || data.height || data.top || !data.left || (data.left = null) : data.top = null, data
            },_getPaddingPlusBorderDimensions: function(element) {
                for (var i = 0, widths = [], borders = [element.css("borderTopWidth"), element.css("borderRightWidth"), element.css("borderBottomWidth"), element.css("borderLeftWidth")], paddings = [element.css("paddingTop"), element.css("paddingRight"), element.css("paddingBottom"), element.css("paddingLeft")]; 4 > i; i++)
                    widths[i] = parseInt(borders[i], 10) || 0, widths[i] += parseInt(paddings[i], 10) || 0;
                return {height: widths[0] + widths[2],width: widths[1] + widths[3]}
            },_proportionallyResize: function() {
                if (this._proportionallyResizeElements.length)
                    for (var prel, i = 0, element = this.helper || this.element; i < this._proportionallyResizeElements.length; i++)
                        prel = this._proportionallyResizeElements[i], this.outerDimensions || (this.outerDimensions = this._getPaddingPlusBorderDimensions(prel)), prel.css({height: element.height() - this.outerDimensions.height || 0,width: element.width() - this.outerDimensions.width || 0})
            },_renderProxy: function() {
                var el = this.element, o = this.options;
                this.elementOffset = el.offset(), this._helper ? (this.helper = this.helper || $("<div style='overflow:hidden;'></div>"), this.helper.addClass(this._helper).css({width: this.element.outerWidth() - 1,height: this.element.outerHeight() - 1,position: "absolute",left: this.elementOffset.left + "px",top: this.elementOffset.top + "px",zIndex: ++o.zIndex}), this.helper.appendTo("body").disableSelection()) : this.helper = this.element
            },_change: {e: function(event, dx) {
                    return {width: this.originalSize.width + dx}
                },w: function(event, dx) {
                    var cs = this.originalSize, sp = this.originalPosition;
                    return {left: sp.left + dx,width: cs.width - dx}
                },n: function(event, dx, dy) {
                    var cs = this.originalSize, sp = this.originalPosition;
                    return {top: sp.top + dy,height: cs.height - dy}
                },s: function(event, dx, dy) {
                    return {height: this.originalSize.height + dy}
                },se: function(event, dx, dy) {
                    return $.extend(this._change.s.apply(this, arguments), this._change.e.apply(this, [event, dx, dy]))
                },sw: function(event, dx, dy) {
                    return $.extend(this._change.s.apply(this, arguments), this._change.w.apply(this, [event, dx, dy]))
                },ne: function(event, dx, dy) {
                    return $.extend(this._change.n.apply(this, arguments), this._change.e.apply(this, [event, dx, dy]))
                },nw: function(event, dx, dy) {
                    return $.extend(this._change.n.apply(this, arguments), this._change.w.apply(this, [event, dx, dy]))
                }},_propagate: function(n, event) {
                $.ui.plugin.call(this, n, [event, this.ui()]), "resize" !== n && this._trigger(n, event, this.ui())
            },plugins: {},ui: function() {
                return {originalElement: this.originalElement,element: this.element,helper: this.helper,position: this.position,size: this.size,originalSize: this.originalSize,originalPosition: this.originalPosition}
            }}), $.ui.plugin.add("resizable", "animate", {stop: function(event) {
                var that = $(this).resizable("instance"), o = that.options, pr = that._proportionallyResizeElements, ista = pr.length && /textarea/i.test(pr[0].nodeName), soffseth = ista && that._hasScroll(pr[0], "left") ? 0 : that.sizeDiff.height, soffsetw = ista ? 0 : that.sizeDiff.width, style = {width: that.size.width - soffsetw,height: that.size.height - soffseth}, left = parseInt(that.element.css("left"), 10) + (that.position.left - that.originalPosition.left) || null, top = parseInt(that.element.css("top"), 10) + (that.position.top - that.originalPosition.top) || null;
                that.element.animate($.extend(style, top && left ? {top: top,left: left} : {}), {duration: o.animateDuration,easing: o.animateEasing,step: function() {
                        var data = {width: parseInt(that.element.css("width"), 10),height: parseInt(that.element.css("height"), 10),top: parseInt(that.element.css("top"), 10),left: parseInt(that.element.css("left"), 10)};
                        pr && pr.length && $(pr[0]).css({width: data.width,height: data.height}), that._updateCache(data), that._propagate("resize", event)
                    }})
            }}), $.ui.plugin.add("resizable", "containment", {start: function() {
                var element, p, co, ch, cw, width, height, that = $(this).resizable("instance"), o = that.options, el = that.element, oc = o.containment, ce = oc instanceof $ ? oc.get(0) : /parent/.test(oc) ? el.parent().get(0) : oc;
                ce && (that.containerElement = $(ce), /document/.test(oc) || oc === document ? (that.containerOffset = {left: 0,top: 0}, that.containerPosition = {left: 0,top: 0}, that.parentData = {element: $(document),left: 0,top: 0,width: $(document).width(),height: $(document).height() || document.body.parentNode.scrollHeight}) : (element = $(ce), p = [], $(["Top", "Right", "Left", "Bottom"]).each(function(i, name) {
                    p[i] = that._num(element.css("padding" + name))
                }), that.containerOffset = element.offset(), that.containerPosition = element.position(), that.containerSize = {height: element.innerHeight() - p[3],width: element.innerWidth() - p[1]}, co = that.containerOffset, ch = that.containerSize.height, cw = that.containerSize.width, width = that._hasScroll(ce, "left") ? ce.scrollWidth : cw, height = that._hasScroll(ce) ? ce.scrollHeight : ch, that.parentData = {element: ce,left: co.left,top: co.top,width: width,height: height}))
            },resize: function(event) {
                var woset, hoset, isParent, isOffsetRelative, that = $(this).resizable("instance"), o = that.options, co = that.containerOffset, cp = that.position, pRatio = that._aspectRatio || event.shiftKey, cop = {top: 0,left: 0}, ce = that.containerElement, continueResize = !0;
                ce[0] !== document && /static/.test(ce.css("position")) && (cop = co), cp.left < (that._helper ? co.left : 0) && (that.size.width = that.size.width + (that._helper ? that.position.left - co.left : that.position.left - cop.left), pRatio && (that.size.height = that.size.width / that.aspectRatio, continueResize = !1), that.position.left = o.helper ? co.left : 0), cp.top < (that._helper ? co.top : 0) && (that.size.height = that.size.height + (that._helper ? that.position.top - co.top : that.position.top), pRatio && (that.size.width = that.size.height * that.aspectRatio, continueResize = !1), that.position.top = that._helper ? co.top : 0), isParent = that.containerElement.get(0) === that.element.parent().get(0), isOffsetRelative = /relative|absolute/.test(that.containerElement.css("position")), isParent && isOffsetRelative ? (that.offset.left = that.parentData.left + that.position.left, that.offset.top = that.parentData.top + that.position.top) : (that.offset.left = that.element.offset().left, that.offset.top = that.element.offset().top), woset = Math.abs(that.sizeDiff.width + (that._helper ? that.offset.left - cop.left : that.offset.left - co.left)), hoset = Math.abs(that.sizeDiff.height + (that._helper ? that.offset.top - cop.top : that.offset.top - co.top)), woset + that.size.width >= that.parentData.width && (that.size.width = that.parentData.width - woset, pRatio && (that.size.height = that.size.width / that.aspectRatio, continueResize = !1)), hoset + that.size.height >= that.parentData.height && (that.size.height = that.parentData.height - hoset, pRatio && (that.size.width = that.size.height * that.aspectRatio, continueResize = !1)), continueResize || (that.position.left = that.prevPosition.left, that.position.top = that.prevPosition.top, that.size.width = that.prevSize.width, that.size.height = that.prevSize.height)
            },stop: function() {
                var that = $(this).resizable("instance"), o = that.options, co = that.containerOffset, cop = that.containerPosition, ce = that.containerElement, helper = $(that.helper), ho = helper.offset(), w = helper.outerWidth() - that.sizeDiff.width, h = helper.outerHeight() - that.sizeDiff.height;
                that._helper && !o.animate && /relative/.test(ce.css("position")) && $(this).css({left: ho.left - cop.left - co.left,width: w,height: h}), that._helper && !o.animate && /static/.test(ce.css("position")) && $(this).css({left: ho.left - cop.left - co.left,width: w,height: h})
            }}), $.ui.plugin.add("resizable", "alsoResize", {start: function() {
                var that = $(this).resizable("instance"), o = that.options;
                $(o.alsoResize).each(function() {
                    var el = $(this);
                    el.data("ui-resizable-alsoresize", {width: parseInt(el.width(), 10),height: parseInt(el.height(), 10),left: parseInt(el.css("left"), 10),top: parseInt(el.css("top"), 10)})
                })
            },resize: function(event, ui) {
                var that = $(this).resizable("instance"), o = that.options, os = that.originalSize, op = that.originalPosition, delta = {height: that.size.height - os.height || 0,width: that.size.width - os.width || 0,top: that.position.top - op.top || 0,left: that.position.left - op.left || 0};
                $(o.alsoResize).each(function() {
                    var el = $(this), start = $(this).data("ui-resizable-alsoresize"), style = {}, css = el.parents(ui.originalElement[0]).length ? ["width", "height"] : ["width", "height", "top", "left"];
                    $.each(css, function(i, prop) {
                        var sum = (start[prop] || 0) + (delta[prop] || 0);
                        sum && sum >= 0 && (style[prop] = sum || null)
                    }), el.css(style)
                })
            },stop: function() {
                $(this).removeData("resizable-alsoresize")
            }}), $.ui.plugin.add("resizable", "ghost", {start: function() {
                var that = $(this).resizable("instance"), o = that.options, cs = that.size;
                that.ghost = that.originalElement.clone(), that.ghost.css({opacity: .25,display: "block",position: "relative",height: cs.height,width: cs.width,margin: 0,left: 0,top: 0}).addClass("ui-resizable-ghost").addClass("string" == typeof o.ghost ? o.ghost : ""), that.ghost.appendTo(that.helper)
            },resize: function() {
                var that = $(this).resizable("instance");
                that.ghost && that.ghost.css({position: "relative",height: that.size.height,width: that.size.width})
            },stop: function() {
                var that = $(this).resizable("instance");
                that.ghost && that.helper && that.helper.get(0).removeChild(that.ghost.get(0))
            }}), $.ui.plugin.add("resizable", "grid", {resize: function() {
                var outerDimensions, that = $(this).resizable("instance"), o = that.options, cs = that.size, os = that.originalSize, op = that.originalPosition, a = that.axis, grid = "number" == typeof o.grid ? [o.grid, o.grid] : o.grid, gridX = grid[0] || 1, gridY = grid[1] || 1, ox = Math.round((cs.width - os.width) / gridX) * gridX, oy = Math.round((cs.height - os.height) / gridY) * gridY, newWidth = os.width + ox, newHeight = os.height + oy, isMaxWidth = o.maxWidth && o.maxWidth < newWidth, isMaxHeight = o.maxHeight && o.maxHeight < newHeight, isMinWidth = o.minWidth && o.minWidth > newWidth, isMinHeight = o.minHeight && o.minHeight > newHeight;
                o.grid = grid, isMinWidth && (newWidth += gridX), isMinHeight && (newHeight += gridY), isMaxWidth && (newWidth -= gridX), isMaxHeight && (newHeight -= gridY), /^(se|s|e)$/.test(a) ? (that.size.width = newWidth, that.size.height = newHeight) : /^(ne)$/.test(a) ? (that.size.width = newWidth, that.size.height = newHeight, that.position.top = op.top - oy) : /^(sw)$/.test(a) ? (that.size.width = newWidth, that.size.height = newHeight, that.position.left = op.left - ox) : ((0 >= newHeight - gridY || 0 >= newWidth - gridX) && (outerDimensions = that._getPaddingPlusBorderDimensions(this)), newHeight - gridY > 0 ? (that.size.height = newHeight, that.position.top = op.top - oy) : (newHeight = gridY - outerDimensions.height, that.size.height = newHeight, that.position.top = op.top + os.height - newHeight), newWidth - gridX > 0 ? (that.size.width = newWidth, that.position.left = op.left - ox) : (newWidth = gridX - outerDimensions.width, that.size.width = newWidth, that.position.left = op.left + os.width - newWidth))
            }});
        $.ui.resizable, $.widget("ui.dialog", {version: "1.11.4",options: {appendTo: "body",autoOpen: !0,buttons: [],closeOnEscape: !0,closeText: "Close",dialogClass: "",draggable: !0,hide: null,height: "auto",maxHeight: null,maxWidth: null,minHeight: 150,minWidth: 150,modal: !1,position: {my: "center",at: "center",of: window,collision: "fit",using: function(pos) {
                        var topOffset = $(this).css(pos).offset().top;
                        0 > topOffset && $(this).css("top", pos.top - topOffset)
                    }},resizable: !0,show: null,title: null,width: 300,beforeClose: null,close: null,drag: null,dragStart: null,dragStop: null,focus: null,open: null,resize: null,resizeStart: null,resizeStop: null},sizeRelatedOptions: {buttons: !0,height: !0,maxHeight: !0,maxWidth: !0,minHeight: !0,minWidth: !0,width: !0},resizableRelatedOptions: {maxHeight: !0,maxWidth: !0,minHeight: !0,minWidth: !0},_create: function() {
                this.originalCss = {display: this.element[0].style.display,width: this.element[0].style.width,minHeight: this.element[0].style.minHeight,maxHeight: this.element[0].style.maxHeight,height: this.element[0].style.height}, this.originalPosition = {parent: this.element.parent(),index: this.element.parent().children().index(this.element)}, this.originalTitle = this.element.attr("title"), this.options.title = this.options.title || this.originalTitle, this._createWrapper(), this.element.show().removeAttr("title").addClass("ui-dialog-content ui-widget-content").appendTo(this.uiDialog), this._createTitlebar(), this._createButtonPane(), this.options.draggable && $.fn.draggable && this._makeDraggable(), this.options.resizable && $.fn.resizable && this._makeResizable(), this._isOpen = !1, this._trackFocus()
            },_init: function() {
                this.options.autoOpen && this.open()
            },_appendTo: function() {
                var element = this.options.appendTo;
                return element && (element.jquery || element.nodeType) ? $(element) : this.document.find(element || "body").eq(0)
            },_destroy: function() {
                var next, originalPosition = this.originalPosition;
                this._untrackInstance(), this._destroyOverlay(), this.element.removeUniqueId().removeClass("ui-dialog-content ui-widget-content").css(this.originalCss).detach(), this.uiDialog.stop(!0, !0).remove(), this.originalTitle && this.element.attr("title", this.originalTitle), next = originalPosition.parent.children().eq(originalPosition.index), next.length && next[0] !== this.element[0] ? next.before(this.element) : originalPosition.parent.append(this.element)
            },widget: function() {
                return this.uiDialog
            },disable: $.noop,enable: $.noop,close: function(event) {
                var activeElement, that = this;
                if (this._isOpen && this._trigger("beforeClose", event) !== !1) {
                    if (this._isOpen = !1, this._focusedElement = null, this._destroyOverlay(), this._untrackInstance(), !this.opener.filter(":focusable").focus().length)
                        try {
                            activeElement = this.document[0].activeElement, activeElement && "body" !== activeElement.nodeName.toLowerCase() && $(activeElement).blur()
                        } catch (error) {
                        }
                    this._hide(this.uiDialog, this.options.hide, function() {
                        that._trigger("close", event)
                    })
                }
            },isOpen: function() {
                return this._isOpen
            },moveToTop: function() {
                this._moveToTop()
            },_moveToTop: function(event, silent) {
                var moved = !1, zIndices = this.uiDialog.siblings(".ui-front:visible").map(function() {
                    return +$(this).css("z-index")
                }).get(), zIndexMax = Math.max.apply(null, zIndices);
                return zIndexMax >= +this.uiDialog.css("z-index") && (this.uiDialog.css("z-index", zIndexMax + 1), moved = !0), moved && !silent && this._trigger("focus", event), moved
            },open: function() {
                var that = this;
                return this._isOpen ? void (this._moveToTop() && this._focusTabbable()) : (this._isOpen = !0, this.opener = $(this.document[0].activeElement), this._size(), this._position(), this._createOverlay(), this._moveToTop(null, !0), this.overlay && this.overlay.css("z-index", this.uiDialog.css("z-index") - 1), this._show(this.uiDialog, this.options.show, function() {
                    that._focusTabbable(), that._trigger("focus")
                }), this._makeFocusTarget(), void this._trigger("open"))
            },_focusTabbable: function() {
                var hasFocus = this._focusedElement;
                hasFocus || (hasFocus = this.element.find("[autofocus]")), hasFocus.length || (hasFocus = this.element.find(":tabbable")), hasFocus.length || (hasFocus = this.uiDialogButtonPane.find(":tabbable")), hasFocus.length || (hasFocus = this.uiDialogTitlebarClose.filter(":tabbable")), hasFocus.length || (hasFocus = this.uiDialog), hasFocus.eq(0).focus()
            },_keepFocus: function(event) {
                function checkFocus() {
                    var activeElement = this.document[0].activeElement, isActive = this.uiDialog[0] === activeElement || $.contains(this.uiDialog[0], activeElement);
                    isActive || this._focusTabbable()
                }
                event.preventDefault(), checkFocus.call(this), this._delay(checkFocus)
            },_createWrapper: function() {
                this.uiDialog = $("<div>").addClass("ui-dialog ui-widget ui-widget-content ui-corner-all ui-front " + this.options.dialogClass).hide().attr({tabIndex: -1,role: "dialog"}).appendTo(this._appendTo()), this._on(this.uiDialog, {keydown: function(event) {
                        if (this.options.closeOnEscape && !event.isDefaultPrevented() && event.keyCode && event.keyCode === $.ui.keyCode.ESCAPE)
                            return event.preventDefault(), void this.close(event);
                        if (event.keyCode === $.ui.keyCode.TAB && !event.isDefaultPrevented()) {
                            var tabbables = this.uiDialog.find(":tabbable"), first = tabbables.filter(":first"), last = tabbables.filter(":last");
                            event.target !== last[0] && event.target !== this.uiDialog[0] || event.shiftKey ? event.target !== first[0] && event.target !== this.uiDialog[0] || !event.shiftKey || (this._delay(function() {
                                last.focus()
                            }), event.preventDefault()) : (this._delay(function() {
                                first.focus()
                            }), event.preventDefault())
                        }
                    },mousedown: function(event) {
                        this._moveToTop(event) && this._focusTabbable()
                    }}), this.element.find("[aria-describedby]").length || this.uiDialog.attr({"aria-describedby": this.element.uniqueId().attr("id")})
            },_createTitlebar: function() {
                var uiDialogTitle;
                this.uiDialogTitlebar = $("<div>").addClass("ui-dialog-titlebar ui-widget-header ui-corner-all ui-helper-clearfix").prependTo(this.uiDialog), this._on(this.uiDialogTitlebar, {mousedown: function(event) {
                        $(event.target).closest(".ui-dialog-titlebar-close") || this.uiDialog.focus()
                    }}), this.uiDialogTitlebarClose = $("<button type='button'></button>").button({label: this.options.closeText,icons: {primary: "ui-icon-closethick"},text: !1}).addClass("ui-dialog-titlebar-close").appendTo(this.uiDialogTitlebar), this._on(this.uiDialogTitlebarClose, {click: function(event) {
                        event.preventDefault(), this.close(event)
                    }}), uiDialogTitle = $("<span>").uniqueId().addClass("ui-dialog-title").prependTo(this.uiDialogTitlebar), this._title(uiDialogTitle), this.uiDialog.attr({"aria-labelledby": uiDialogTitle.attr("id")})
            },_title: function(title) {
                this.options.title || title.html("&#160;"), title.text(this.options.title)
            },_createButtonPane: function() {
                this.uiDialogButtonPane = $("<div>").addClass("ui-dialog-buttonpane ui-widget-content ui-helper-clearfix"), this.uiButtonSet = $("<div>").addClass("ui-dialog-buttonset").appendTo(this.uiDialogButtonPane), this._createButtons()
            },_createButtons: function() {
                var that = this, buttons = this.options.buttons;
                return this.uiDialogButtonPane.remove(), this.uiButtonSet.empty(), $.isEmptyObject(buttons) || $.isArray(buttons) && !buttons.length ? void this.uiDialog.removeClass("ui-dialog-buttons") : ($.each(buttons, function(name, props) {
                    var click, buttonOptions;
                    props = $.isFunction(props) ? {click: props,text: name} : props, props = $.extend({type: "button"}, props), click = props.click, props.click = function() {
                        click.apply(that.element[0], arguments)
                    }, buttonOptions = {icons: props.icons,text: props.showText}, delete props.icons, delete props.showText, $("<button></button>", props).button(buttonOptions).appendTo(that.uiButtonSet)
                }), this.uiDialog.addClass("ui-dialog-buttons"), void this.uiDialogButtonPane.appendTo(this.uiDialog))
            },_makeDraggable: function() {
                function filteredUi(ui) {
                    return {position: ui.position,offset: ui.offset}
                }
                var that = this, options = this.options;
                this.uiDialog.draggable({cancel: ".ui-dialog-content, .ui-dialog-titlebar-close",handle: ".ui-dialog-titlebar",containment: "document",start: function(event, ui) {
                        $(this).addClass("ui-dialog-dragging"), that._blockFrames(), that._trigger("dragStart", event, filteredUi(ui))
                    },drag: function(event, ui) {
                        that._trigger("drag", event, filteredUi(ui))
                    },stop: function(event, ui) {
                        var left = ui.offset.left - that.document.scrollLeft(), top = ui.offset.top - that.document.scrollTop();
                        options.position = {my: "left top",at: "left" + (left >= 0 ? "+" : "") + left + " top" + (top >= 0 ? "+" : "") + top,of: that.window}, $(this).removeClass("ui-dialog-dragging"), that._unblockFrames(), that._trigger("dragStop", event, filteredUi(ui))
                    }})
            },_makeResizable: function() {
                function filteredUi(ui) {
                    return {originalPosition: ui.originalPosition,originalSize: ui.originalSize,position: ui.position,size: ui.size}
                }
                var that = this, options = this.options, handles = options.resizable, position = this.uiDialog.css("position"), resizeHandles = "string" == typeof handles ? handles : "n,e,s,w,se,sw,ne,nw";
                this.uiDialog.resizable({cancel: ".ui-dialog-content",containment: "document",alsoResize: this.element,maxWidth: options.maxWidth,maxHeight: options.maxHeight,minWidth: options.minWidth,minHeight: this._minHeight(),handles: resizeHandles,start: function(event, ui) {
                        $(this).addClass("ui-dialog-resizing"), that._blockFrames(), that._trigger("resizeStart", event, filteredUi(ui))
                    },resize: function(event, ui) {
                        that._trigger("resize", event, filteredUi(ui))
                    },stop: function(event, ui) {
                        var offset = that.uiDialog.offset(), left = offset.left - that.document.scrollLeft(), top = offset.top - that.document.scrollTop();
                        options.height = that.uiDialog.height(), options.width = that.uiDialog.width(), options.position = {my: "left top",at: "left" + (left >= 0 ? "+" : "") + left + " top" + (top >= 0 ? "+" : "") + top,of: that.window}, $(this).removeClass("ui-dialog-resizing"), that._unblockFrames(), that._trigger("resizeStop", event, filteredUi(ui))
                    }}).css("position", position)
            },_trackFocus: function() {
                this._on(this.widget(), {focusin: function(event) {
                        this._makeFocusTarget(), this._focusedElement = $(event.target)
                    }})
            },_makeFocusTarget: function() {
                this._untrackInstance(), this._trackingInstances().unshift(this)
            },_untrackInstance: function() {
                var instances = this._trackingInstances(), exists = $.inArray(this, instances);
                -1 !== exists && instances.splice(exists, 1)
            },_trackingInstances: function() {
                var instances = this.document.data("ui-dialog-instances");
                return instances || (instances = [], this.document.data("ui-dialog-instances", instances)), instances
            },_minHeight: function() {
                var options = this.options;
                return "auto" === options.height ? options.minHeight : Math.min(options.minHeight, options.height)
            },_position: function() {
                var isVisible = this.uiDialog.is(":visible");
                isVisible || this.uiDialog.show(), this.uiDialog.position(this.options.position), isVisible || this.uiDialog.hide()
            },_setOptions: function(options) {
                var that = this, resize = !1, resizableOptions = {};
                $.each(options, function(key, value) {
                    that._setOption(key, value), key in that.sizeRelatedOptions && (resize = !0), key in that.resizableRelatedOptions && (resizableOptions[key] = value)
                }), resize && (this._size(), this._position()), this.uiDialog.is(":data(ui-resizable)") && this.uiDialog.resizable("option", resizableOptions)
            },_setOption: function(key, value) {
                var isDraggable, isResizable, uiDialog = this.uiDialog;
                "dialogClass" === key && uiDialog.removeClass(this.options.dialogClass).addClass(value), "disabled" !== key && (this._super(key, value), "appendTo" === key && this.uiDialog.appendTo(this._appendTo()), "buttons" === key && this._createButtons(), "closeText" === key && this.uiDialogTitlebarClose.button({label: "" + value}), "draggable" === key && (isDraggable = uiDialog.is(":data(ui-draggable)"), isDraggable && !value && uiDialog.draggable("destroy"), !isDraggable && value && this._makeDraggable()), "position" === key && this._position(), "resizable" === key && (isResizable = uiDialog.is(":data(ui-resizable)"), isResizable && !value && uiDialog.resizable("destroy"), isResizable && "string" == typeof value && uiDialog.resizable("option", "handles", value), isResizable || value === !1 || this._makeResizable()), "title" === key && this._title(this.uiDialogTitlebar.find(".ui-dialog-title")))
            },_size: function() {
                var nonContentHeight, minContentHeight, maxContentHeight, options = this.options;
                this.element.show().css({width: "auto",minHeight: 0,maxHeight: "none",height: 0}), options.minWidth > options.width && (options.width = options.minWidth), nonContentHeight = this.uiDialog.css({height: "auto",width: options.width}).outerHeight(), minContentHeight = Math.max(0, options.minHeight - nonContentHeight), maxContentHeight = "number" == typeof options.maxHeight ? Math.max(0, options.maxHeight - nonContentHeight) : "none", "auto" === options.height ? this.element.css({minHeight: minContentHeight,maxHeight: maxContentHeight,height: "auto"}) : this.element.height(Math.max(0, options.height - nonContentHeight)), this.uiDialog.is(":data(ui-resizable)") && this.uiDialog.resizable("option", "minHeight", this._minHeight())
            },_blockFrames: function() {
                this.iframeBlocks = this.document.find("iframe").map(function() {
                    var iframe = $(this);
                    return $("<div>").css({position: "absolute",width: iframe.outerWidth(),height: iframe.outerHeight()}).appendTo(iframe.parent()).offset(iframe.offset())[0]
                })
            },_unblockFrames: function() {
                this.iframeBlocks && (this.iframeBlocks.remove(), delete this.iframeBlocks)
            },_allowInteraction: function(event) {
                return $(event.target).closest(".ui-dialog").length ? !0 : !!$(event.target).closest(".ui-datepicker").length
            },_createOverlay: function() {
                if (this.options.modal) {
                    var isOpening = !0;
                    this._delay(function() {
                        isOpening = !1
                    }), this.document.data("ui-dialog-overlays") || this._on(this.document, {focusin: function(event) {
                            isOpening || this._allowInteraction(event) || (event.preventDefault(), this._trackingInstances()[0]._focusTabbable())
                        }}), this.overlay = $("<div>").addClass("ui-widget-overlay ui-front").appendTo(this._appendTo()), this._on(this.overlay, {mousedown: "_keepFocus"}), this.document.data("ui-dialog-overlays", (this.document.data("ui-dialog-overlays") || 0) + 1)
                }
            },_destroyOverlay: function() {
                if (this.options.modal && this.overlay) {
                    var overlays = this.document.data("ui-dialog-overlays") - 1;
                    overlays ? this.document.data("ui-dialog-overlays", overlays) : this.document.unbind("focusin").removeData("ui-dialog-overlays"), this.overlay.remove(), this.overlay = null
                }
            }});
        $.widget("ui.droppable", {version: "1.11.4",widgetEventPrefix: "drop",options: {accept: "*",activeClass: !1,addClasses: !0,greedy: !1,hoverClass: !1,scope: "default",tolerance: "intersect",activate: null,deactivate: null,drop: null,out: null,over: null},_create: function() {
                var proportions, o = this.options, accept = o.accept;
                this.isover = !1, this.isout = !0, this.accept = $.isFunction(accept) ? accept : function(d) {
                    return d.is(accept)
                }, this.proportions = function() {
                    return arguments.length ? void (proportions = arguments[0]) : proportions ? proportions : proportions = {width: this.element[0].offsetWidth,height: this.element[0].offsetHeight}
                }, this._addToManager(o.scope), o.addClasses && this.element.addClass("ui-droppable")
            },_addToManager: function(scope) {
                $.ui.ddmanager.droppables[scope] = $.ui.ddmanager.droppables[scope] || [], $.ui.ddmanager.droppables[scope].push(this)
            },_splice: function(drop) {
                for (var i = 0; i < drop.length; i++)
                    drop[i] === this && drop.splice(i, 1)
            },_destroy: function() {
                var drop = $.ui.ddmanager.droppables[this.options.scope];
                this._splice(drop), this.element.removeClass("ui-droppable ui-droppable-disabled")
            },_setOption: function(key, value) {
                if ("accept" === key)
                    this.accept = $.isFunction(value) ? value : function(d) {
                        return d.is(value)
                    };
                else if ("scope" === key) {
                    var drop = $.ui.ddmanager.droppables[this.options.scope];
                    this._splice(drop), this._addToManager(value)
                }
                this._super(key, value)
            },_activate: function(event) {
                var draggable = $.ui.ddmanager.current;
                this.options.activeClass && this.element.addClass(this.options.activeClass), draggable && this._trigger("activate", event, this.ui(draggable))
            },_deactivate: function(event) {
                var draggable = $.ui.ddmanager.current;
                this.options.activeClass && this.element.removeClass(this.options.activeClass), draggable && this._trigger("deactivate", event, this.ui(draggable))
            },_over: function(event) {
                var draggable = $.ui.ddmanager.current;
                draggable && (draggable.currentItem || draggable.element)[0] !== this.element[0] && this.accept.call(this.element[0], draggable.currentItem || draggable.element) && (this.options.hoverClass && this.element.addClass(this.options.hoverClass), this._trigger("over", event, this.ui(draggable)))
            },_out: function(event) {
                var draggable = $.ui.ddmanager.current;
                draggable && (draggable.currentItem || draggable.element)[0] !== this.element[0] && this.accept.call(this.element[0], draggable.currentItem || draggable.element) && (this.options.hoverClass && this.element.removeClass(this.options.hoverClass), this._trigger("out", event, this.ui(draggable)))
            },_drop: function(event, custom) {
                var draggable = custom || $.ui.ddmanager.current, childrenIntersection = !1;
                return draggable && (draggable.currentItem || draggable.element)[0] !== this.element[0] ? (this.element.find(":data(ui-droppable)").not(".ui-draggable-dragging").each(function() {
                    var inst = $(this).droppable("instance");
                    return inst.options.greedy && !inst.options.disabled && inst.options.scope === draggable.options.scope && inst.accept.call(inst.element[0], draggable.currentItem || draggable.element) && $.ui.intersect(draggable, $.extend(inst, {offset: inst.element.offset()}), inst.options.tolerance, event) ? (childrenIntersection = !0, !1) : void 0
                }), childrenIntersection ? !1 : this.accept.call(this.element[0], draggable.currentItem || draggable.element) ? (this.options.activeClass && this.element.removeClass(this.options.activeClass), this.options.hoverClass && this.element.removeClass(this.options.hoverClass), this._trigger("drop", event, this.ui(draggable)), this.element) : !1) : !1
            },ui: function(c) {
                return {draggable: c.currentItem || c.element,helper: c.helper,position: c.position,offset: c.positionAbs}
            }}), $.ui.intersect = function() {
            function isOverAxis(x, reference, size) {
                return x >= reference && reference + size > x
            }
            return function(draggable, droppable, toleranceMode, event) {
                if (!droppable.offset)
                    return !1;
                var x1 = (draggable.positionAbs || draggable.position.absolute).left + draggable.margins.left, y1 = (draggable.positionAbs || draggable.position.absolute).top + draggable.margins.top, x2 = x1 + draggable.helperProportions.width, y2 = y1 + draggable.helperProportions.height, l = droppable.offset.left, t = droppable.offset.top, r = l + droppable.proportions().width, b = t + droppable.proportions().height;
                switch (toleranceMode) {
                    case "fit":
                        return x1 >= l && r >= x2 && y1 >= t && b >= y2;
                    case "intersect":
                        return l < x1 + draggable.helperProportions.width / 2 && x2 - draggable.helperProportions.width / 2 < r && t < y1 + draggable.helperProportions.height / 2 && y2 - draggable.helperProportions.height / 2 < b;
                    case "pointer":
                        return isOverAxis(event.pageY, t, droppable.proportions().height) && isOverAxis(event.pageX, l, droppable.proportions().width);
                    case "touch":
                        return (y1 >= t && b >= y1 || y2 >= t && b >= y2 || t > y1 && y2 > b) && (x1 >= l && r >= x1 || x2 >= l && r >= x2 || l > x1 && x2 > r);
                    default:
                        return !1
                }
            }
        }(), $.ui.ddmanager = {current: null,droppables: {"default": []},prepareOffsets: function(t, event) {
                var i, j, m = $.ui.ddmanager.droppables[t.options.scope] || [], type = event ? event.type : null, list = (t.currentItem || t.element).find(":data(ui-droppable)").addBack();
                droppablesLoop: for (i = 0; i < m.length; i++)
                    if (!(m[i].options.disabled || t && !m[i].accept.call(m[i].element[0], t.currentItem || t.element))) {
                        for (j = 0; j < list.length; j++)
                            if (list[j] === m[i].element[0]) {
                                m[i].proportions().height = 0;
                                continue droppablesLoop
                            }
                        m[i].visible = "none" !== m[i].element.css("display"), m[i].visible && ("mousedown" === type && m[i]._activate.call(m[i], event), m[i].offset = m[i].element.offset(), m[i].proportions({width: m[i].element[0].offsetWidth,height: m[i].element[0].offsetHeight}))
                    }
            },drop: function(draggable, event) {
                var dropped = !1;
                return $.each(($.ui.ddmanager.droppables[draggable.options.scope] || []).slice(), function() {
                    this.options && (!this.options.disabled && this.visible && $.ui.intersect(draggable, this, this.options.tolerance, event) && (dropped = this._drop.call(this, event) || dropped), !this.options.disabled && this.visible && this.accept.call(this.element[0], draggable.currentItem || draggable.element) && (this.isout = !0, this.isover = !1, this._deactivate.call(this, event)))
                }), dropped
            },dragStart: function(draggable, event) {
                draggable.element.parentsUntil("body").bind("scroll.droppable", function() {
                    draggable.options.refreshPositions || $.ui.ddmanager.prepareOffsets(draggable, event)
                })
            },drag: function(draggable, event) {
                draggable.options.refreshPositions && $.ui.ddmanager.prepareOffsets(draggable, event), $.each($.ui.ddmanager.droppables[draggable.options.scope] || [], function() {
                    if (!this.options.disabled && !this.greedyChild && this.visible) {
                        var parentInstance, scope, parent, intersects = $.ui.intersect(draggable, this, this.options.tolerance, event), c = !intersects && this.isover ? "isout" : intersects && !this.isover ? "isover" : null;
                        c && (this.options.greedy && (scope = this.options.scope, parent = this.element.parents(":data(ui-droppable)").filter(function() {
                            return $(this).droppable("instance").options.scope === scope
                        }), parent.length && (parentInstance = $(parent[0]).droppable("instance"), parentInstance.greedyChild = "isover" === c)), parentInstance && "isover" === c && (parentInstance.isover = !1, parentInstance.isout = !0, parentInstance._out.call(parentInstance, event)), this[c] = !0, this["isout" === c ? "isover" : "isout"] = !1, this["isover" === c ? "_over" : "_out"].call(this, event), parentInstance && "isout" === c && (parentInstance.isout = !1, parentInstance.isover = !0, parentInstance._over.call(parentInstance, event)))
                    }
                })
            },dragStop: function(draggable, event) {
                draggable.element.parentsUntil("body").unbind("scroll.droppable"), draggable.options.refreshPositions || $.ui.ddmanager.prepareOffsets(draggable, event)
            }};
        var dataSpace = ($.ui.droppable, "ui-effects-"), jQuery = $;
        $.effects = {effect: {}}, function(jQuery, undefined) {
            function clamp(value, prop, allowEmpty) {
                var type = propTypes[prop.type] || {};
                return null == value ? allowEmpty || !prop.def ? null : prop.def : (value = type.floor ? ~~value : parseFloat(value), isNaN(value) ? prop.def : type.mod ? (value + type.mod) % type.mod : 0 > value ? 0 : type.max < value ? type.max : value)
            }
            function stringParse(string) {
                var inst = color(), rgba = inst._rgba = [];
                return string = string.toLowerCase(), each(stringParsers, function(i, parser) {
                    var parsed, match = parser.re.exec(string), values = match && parser.parse(match), spaceName = parser.space || "rgba";
                    return values ? (parsed = inst[spaceName](values), inst[spaces[spaceName].cache] = parsed[spaces[spaceName].cache], rgba = inst._rgba = parsed._rgba, !1) : void 0
                }), rgba.length ? ("0,0,0,0" === rgba.join() && jQuery.extend(rgba, colors.transparent), inst) : colors[string]
            }
            function hue2rgb(p, q, h) {
                return h = (h + 1) % 1, 1 > 6 * h ? p + (q - p) * h * 6 : 1 > 2 * h ? q : 2 > 3 * h ? p + (q - p) * (2 / 3 - h) * 6 : p
            }
            var colors, stepHooks = "backgroundColor borderBottomColor borderLeftColor borderRightColor borderTopColor color columnRuleColor outlineColor textDecorationColor textEmphasisColor", rplusequals = /^([\-+])=\s*(\d+\.?\d*)/, stringParsers = [{re: /rgba?\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*(?:,\s*(\d?(?:\.\d+)?)\s*)?\)/,parse: function(execResult) {
                        return [execResult[1], execResult[2], execResult[3], execResult[4]]
                    }}, {re: /rgba?\(\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d?(?:\.\d+)?)\s*)?\)/,parse: function(execResult) {
                        return [2.55 * execResult[1], 2.55 * execResult[2], 2.55 * execResult[3], execResult[4]]
                    }}, {re: /#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})/,parse: function(execResult) {
                        return [parseInt(execResult[1], 16), parseInt(execResult[2], 16), parseInt(execResult[3], 16)]
                    }}, {re: /#([a-f0-9])([a-f0-9])([a-f0-9])/,parse: function(execResult) {
                        return [parseInt(execResult[1] + execResult[1], 16), parseInt(execResult[2] + execResult[2], 16), parseInt(execResult[3] + execResult[3], 16)]
                    }}, {re: /hsla?\(\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d?(?:\.\d+)?)\s*)?\)/,space: "hsla",parse: function(execResult) {
                        return [execResult[1], execResult[2] / 100, execResult[3] / 100, execResult[4]]
                    }}], color = jQuery.Color = function(color, green, blue, alpha) {
                return new jQuery.Color.fn.parse(color, green, blue, alpha)
            }, spaces = {rgba: {props: {red: {idx: 0,type: "byte"},green: {idx: 1,type: "byte"},blue: {idx: 2,type: "byte"}}},hsla: {props: {hue: {idx: 0,type: "degrees"},saturation: {idx: 1,type: "percent"},lightness: {idx: 2,type: "percent"}}}}, propTypes = {"byte": {floor: !0,max: 255},percent: {max: 1},degrees: {mod: 360,floor: !0}}, support = color.support = {}, supportElem = jQuery("<p>")[0], each = jQuery.each;
            supportElem.style.cssText = "background-color:rgba(1,1,1,.5)", support.rgba = supportElem.style.backgroundColor.indexOf("rgba") > -1, each(spaces, function(spaceName, space) {
                space.cache = "_" + spaceName, space.props.alpha = {idx: 3,type: "percent",def: 1}
            }), color.fn = jQuery.extend(color.prototype, {parse: function(red, green, blue, alpha) {
                    if (red === undefined)
                        return this._rgba = [null, null, null, null], this;
                    (red.jquery || red.nodeType) && (red = jQuery(red).css(green), green = undefined);
                    var inst = this, type = jQuery.type(red), rgba = this._rgba = [];
                    return green !== undefined && (red = [red, green, blue, alpha], type = "array"), "string" === type ? this.parse(stringParse(red) || colors._default) : "array" === type ? (each(spaces.rgba.props, function(key, prop) {
                        rgba[prop.idx] = clamp(red[prop.idx], prop)
                    }), this) : "object" === type ? (red instanceof color ? each(spaces, function(spaceName, space) {
                        red[space.cache] && (inst[space.cache] = red[space.cache].slice())
                    }) : each(spaces, function(spaceName, space) {
                        var cache = space.cache;
                        each(space.props, function(key, prop) {
                            if (!inst[cache] && space.to) {
                                if ("alpha" === key || null == red[key])
                                    return;
                                inst[cache] = space.to(inst._rgba)
                            }
                            inst[cache][prop.idx] = clamp(red[key], prop, !0)
                        }), inst[cache] && jQuery.inArray(null, inst[cache].slice(0, 3)) < 0 && (inst[cache][3] = 1, space.from && (inst._rgba = space.from(inst[cache])))
                    }), this) : void 0
                },is: function(compare) {
                    var is = color(compare), same = !0, inst = this;
                    return each(spaces, function(_, space) {
                        var localCache, isCache = is[space.cache];
                        return isCache && (localCache = inst[space.cache] || space.to && space.to(inst._rgba) || [], each(space.props, function(_, prop) {
                            return null != isCache[prop.idx] ? same = isCache[prop.idx] === localCache[prop.idx] : void 0
                        })), same
                    }), same
                },_space: function() {
                    var used = [], inst = this;
                    return each(spaces, function(spaceName, space) {
                        inst[space.cache] && used.push(spaceName)
                    }), used.pop()
                },transition: function(other, distance) {
                    var end = color(other), spaceName = end._space(), space = spaces[spaceName], startColor = 0 === this.alpha() ? color("transparent") : this, start = startColor[space.cache] || space.to(startColor._rgba), result = start.slice();
                    return end = end[space.cache], each(space.props, function(key, prop) {
                        var index = prop.idx, startValue = start[index], endValue = end[index], type = propTypes[prop.type] || {};
                        null !== endValue && (null === startValue ? result[index] = endValue : (type.mod && (endValue - startValue > type.mod / 2 ? startValue += type.mod : startValue - endValue > type.mod / 2 && (startValue -= type.mod)), result[index] = clamp((endValue - startValue) * distance + startValue, prop)))
                    }), this[spaceName](result)
                },blend: function(opaque) {
                    if (1 === this._rgba[3])
                        return this;
                    var rgb = this._rgba.slice(), a = rgb.pop(), blend = color(opaque)._rgba;
                    return color(jQuery.map(rgb, function(v, i) {
                        return (1 - a) * blend[i] + a * v
                    }))
                },toRgbaString: function() {
                    var prefix = "rgba(", rgba = jQuery.map(this._rgba, function(v, i) {
                        return null == v ? i > 2 ? 1 : 0 : v
                    });
                    return 1 === rgba[3] && (rgba.pop(), prefix = "rgb("), prefix + rgba.join() + ")"
                },toHslaString: function() {
                    var prefix = "hsla(", hsla = jQuery.map(this.hsla(), function(v, i) {
                        return null == v && (v = i > 2 ? 1 : 0), i && 3 > i && (v = Math.round(100 * v) + "%"), v
                    });
                    return 1 === hsla[3] && (hsla.pop(), prefix = "hsl("), prefix + hsla.join() + ")"
                },toHexString: function(includeAlpha) {
                    var rgba = this._rgba.slice(), alpha = rgba.pop();
                    return includeAlpha && rgba.push(~~(255 * alpha)), "#" + jQuery.map(rgba, function(v) {
                        return v = (v || 0).toString(16), 1 === v.length ? "0" + v : v
                    }).join("")
                },toString: function() {
                    return 0 === this._rgba[3] ? "transparent" : this.toRgbaString()
                }}), color.fn.parse.prototype = color.fn, spaces.hsla.to = function(rgba) {
                if (null == rgba[0] || null == rgba[1] || null == rgba[2])
                    return [null, null, null, rgba[3]];
                var h, s, r = rgba[0] / 255, g = rgba[1] / 255, b = rgba[2] / 255, a = rgba[3], max = Math.max(r, g, b), min = Math.min(r, g, b), diff = max - min, add = max + min, l = .5 * add;
                return h = min === max ? 0 : r === max ? 60 * (g - b) / diff + 360 : g === max ? 60 * (b - r) / diff + 120 : 60 * (r - g) / diff + 240, s = 0 === diff ? 0 : .5 >= l ? diff / add : diff / (2 - add), [Math.round(h) % 360, s, l, null == a ? 1 : a]
            }, spaces.hsla.from = function(hsla) {
                if (null == hsla[0] || null == hsla[1] || null == hsla[2])
                    return [null, null, null, hsla[3]];
                var h = hsla[0] / 360, s = hsla[1], l = hsla[2], a = hsla[3], q = .5 >= l ? l * (1 + s) : l + s - l * s, p = 2 * l - q;
                return [Math.round(255 * hue2rgb(p, q, h + 1 / 3)), Math.round(255 * hue2rgb(p, q, h)), Math.round(255 * hue2rgb(p, q, h - 1 / 3)), a]
            }, each(spaces, function(spaceName, space) {
                var props = space.props, cache = space.cache, to = space.to, from = space.from;
                color.fn[spaceName] = function(value) {
                    if (to && !this[cache] && (this[cache] = to(this._rgba)), value === undefined)
                        return this[cache].slice();
                    var ret, type = jQuery.type(value), arr = "array" === type || "object" === type ? value : arguments, local = this[cache].slice();
                    return each(props, function(key, prop) {
                        var val = arr["object" === type ? key : prop.idx];
                        null == val && (val = local[prop.idx]), local[prop.idx] = clamp(val, prop)
                    }), from ? (ret = color(from(local)), ret[cache] = local, ret) : color(local)
                }, each(props, function(key, prop) {
                    color.fn[key] || (color.fn[key] = function(value) {
                        var match, vtype = jQuery.type(value), fn = "alpha" === key ? this._hsla ? "hsla" : "rgba" : spaceName, local = this[fn](), cur = local[prop.idx];
                        return "undefined" === vtype ? cur : ("function" === vtype && (value = value.call(this, cur), vtype = jQuery.type(value)), null == value && prop.empty ? this : ("string" === vtype && (match = rplusequals.exec(value), match && (value = cur + parseFloat(match[2]) * ("+" === match[1] ? 1 : -1))), local[prop.idx] = value, this[fn](local)))
                    })
                })
            }), color.hook = function(hook) {
                var hooks = hook.split(" ");
                each(hooks, function(i, hook) {
                    jQuery.cssHooks[hook] = {set: function(elem, value) {
                            var parsed, curElem, backgroundColor = "";
                            if ("transparent" !== value && ("string" !== jQuery.type(value) || (parsed = stringParse(value)))) {
                                if (value = color(parsed || value), !support.rgba && 1 !== value._rgba[3]) {
                                    for (curElem = "backgroundColor" === hook ? elem.parentNode : elem; ("" === backgroundColor || "transparent" === backgroundColor) && curElem && curElem.style; )
                                        try {
                                            backgroundColor = jQuery.css(curElem, "backgroundColor"), curElem = curElem.parentNode
                                        } catch (e) {
                                        }
                                    value = value.blend(backgroundColor && "transparent" !== backgroundColor ? backgroundColor : "_default")
                                }
                                value = value.toRgbaString()
                            }
                            try {
                                elem.style[hook] = value
                            } catch (e) {
                            }
                        }}, jQuery.fx.step[hook] = function(fx) {
                        fx.colorInit || (fx.start = color(fx.elem, hook), fx.end = color(fx.end), fx.colorInit = !0), jQuery.cssHooks[hook].set(fx.elem, fx.start.transition(fx.end, fx.pos))
                    }
                })
            }, color.hook(stepHooks), jQuery.cssHooks.borderColor = {expand: function(value) {
                    var expanded = {};
                    return each(["Top", "Right", "Bottom", "Left"], function(i, part) {
                        expanded["border" + part + "Color"] = value
                    }), expanded
                }}, colors = jQuery.Color.names = {aqua: "#00ffff",black: "#000000",blue: "#0000ff",fuchsia: "#ff00ff",gray: "#808080",green: "#008000",lime: "#00ff00",maroon: "#800000",navy: "#000080",olive: "#808000",purple: "#800080",red: "#ff0000",silver: "#c0c0c0",teal: "#008080",white: "#ffffff",yellow: "#ffff00",transparent: [null, null, null, 0],_default: "#ffffff"}
        }(jQuery), function() {
            function getElementStyles(elem) {
                var key, len, style = elem.ownerDocument.defaultView ? elem.ownerDocument.defaultView.getComputedStyle(elem, null) : elem.currentStyle, styles = {};
                if (style && style.length && style[0] && style[style[0]])
                    for (len = style.length; len--; )
                        key = style[len], "string" == typeof style[key] && (styles[$.camelCase(key)] = style[key]);
                else
                    for (key in style)
                        "string" == typeof style[key] && (styles[key] = style[key]);
                return styles
            }
            function styleDifference(oldStyle, newStyle) {
                var name, value, diff = {};
                for (name in newStyle)
                    value = newStyle[name], oldStyle[name] !== value && (shorthandStyles[name] || ($.fx.step[name] || !isNaN(parseFloat(value))) && (diff[name] = value));
                return diff
            }
            var classAnimationActions = ["add", "remove", "toggle"], shorthandStyles = {border: 1,borderBottom: 1,borderColor: 1,borderLeft: 1,borderRight: 1,borderTop: 1,borderWidth: 1,margin: 1,padding: 1};
            $.each(["borderLeftStyle", "borderRightStyle", "borderBottomStyle", "borderTopStyle"], function(_, prop) {
                $.fx.step[prop] = function(fx) {
                    ("none" !== fx.end && !fx.setAttr || 1 === fx.pos && !fx.setAttr) && (jQuery.style(fx.elem, prop, fx.end), fx.setAttr = !0)
                }
            }), $.fn.addBack || ($.fn.addBack = function(selector) {
                return this.add(null == selector ? this.prevObject : this.prevObject.filter(selector))
            }), $.effects.animateClass = function(value, duration, easing, callback) {
                var o = $.speed(duration, easing, callback);
                return this.queue(function() {
                    var applyClassChange, animated = $(this), baseClass = animated.attr("class") || "", allAnimations = o.children ? animated.find("*").addBack() : animated;
                    allAnimations = allAnimations.map(function() {
                        var el = $(this);
                        return {el: el,start: getElementStyles(this)}
                    }), applyClassChange = function() {
                        $.each(classAnimationActions, function(i, action) {
                            value[action] && animated[action + "Class"](value[action])
                        })
                    }, applyClassChange(), allAnimations = allAnimations.map(function() {
                        return this.end = getElementStyles(this.el[0]), this.diff = styleDifference(this.start, this.end), this
                    }), animated.attr("class", baseClass), allAnimations = allAnimations.map(function() {
                        var styleInfo = this, dfd = $.Deferred(), opts = $.extend({}, o, {queue: !1,complete: function() {
                                dfd.resolve(styleInfo)
                            }});
                        return this.el.animate(this.diff, opts), dfd.promise()
                    }), $.when.apply($, allAnimations.get()).done(function() {
                        applyClassChange(), $.each(arguments, function() {
                            var el = this.el;
                            $.each(this.diff, function(key) {
                                el.css(key, "")
                            })
                        }), o.complete.call(animated[0])
                    })
                })
            }, $.fn.extend({addClass: function(orig) {
                    return function(classNames, speed, easing, callback) {
                        return speed ? $.effects.animateClass.call(this, {add: classNames}, speed, easing, callback) : orig.apply(this, arguments)
                    }
                }($.fn.addClass),removeClass: function(orig) {
                    return function(classNames, speed, easing, callback) {
                        return arguments.length > 1 ? $.effects.animateClass.call(this, {remove: classNames}, speed, easing, callback) : orig.apply(this, arguments)
                    }
                }($.fn.removeClass),toggleClass: function(orig) {
                    return function(classNames, force, speed, easing, callback) {
                        return "boolean" == typeof force || void 0 === force ? speed ? $.effects.animateClass.call(this, force ? {add: classNames} : {remove: classNames}, speed, easing, callback) : orig.apply(this, arguments) : $.effects.animateClass.call(this, {toggle: classNames}, force, speed, easing)
                    }
                }($.fn.toggleClass),switchClass: function(remove, add, speed, easing, callback) {
                    return $.effects.animateClass.call(this, {add: add,remove: remove}, speed, easing, callback)
                }})
        }(), function() {
            function _normalizeArguments(effect, options, speed, callback) {
                return $.isPlainObject(effect) && (options = effect, effect = effect.effect), effect = {effect: effect}, null == options && (options = {}), $.isFunction(options) && (callback = options, speed = null, options = {}), ("number" == typeof options || $.fx.speeds[options]) && (callback = speed, speed = options, options = {}), $.isFunction(speed) && (callback = speed, speed = null), options && $.extend(effect, options), speed = speed || options.duration, effect.duration = $.fx.off ? 0 : "number" == typeof speed ? speed : speed in $.fx.speeds ? $.fx.speeds[speed] : $.fx.speeds._default, effect.complete = callback || options.complete, effect
            }
            function standardAnimationOption(option) {
                return !option || "number" == typeof option || $.fx.speeds[option] ? !0 : "string" != typeof option || $.effects.effect[option] ? $.isFunction(option) ? !0 : "object" != typeof option || option.effect ? !1 : !0 : !0
            }
            $.extend($.effects, {version: "1.11.4",save: function(element, set) {
                    for (var i = 0; i < set.length; i++)
                        null !== set[i] && element.data(dataSpace + set[i], element[0].style[set[i]])
                },restore: function(element, set) {
                    var val, i;
                    for (i = 0; i < set.length; i++)
                        null !== set[i] && (val = element.data(dataSpace + set[i]), void 0 === val && (val = ""), element.css(set[i], val))
                },setMode: function(el, mode) {
                    return "toggle" === mode && (mode = el.is(":hidden") ? "show" : "hide"), mode
                },getBaseline: function(origin, original) {
                    var y, x;
                    switch (origin[0]) {
                        case "top":
                            y = 0;
                            break;
                        case "middle":
                            y = .5;
                            break;
                        case "bottom":
                            y = 1;
                            break;
                        default:
                            y = origin[0] / original.height
                    }
                    switch (origin[1]) {
                        case "left":
                            x = 0;
                            break;
                        case "center":
                            x = .5;
                            break;
                        case "right":
                            x = 1;
                            break;
                        default:
                            x = origin[1] / original.width
                    }
                    return {x: x,y: y}
                },createWrapper: function(element) {
                    if (element.parent().is(".ui-effects-wrapper"))
                        return element.parent();
                    var props = {width: element.outerWidth(!0),height: element.outerHeight(!0),"float": element.css("float")}, wrapper = $("<div></div>").addClass("ui-effects-wrapper").css({fontSize: "100%",background: "transparent",border: "none",margin: 0,padding: 0}), size = {width: element.width(),height: element.height()}, active = document.activeElement;
                    try {
                        active.id
                    } catch (e) {
                        active = document.body
                    }
                    return element.wrap(wrapper), (element[0] === active || $.contains(element[0], active)) && $(active).focus(), wrapper = element.parent(), "static" === element.css("position") ? (wrapper.css({position: "relative"}), element.css({position: "relative"})) : ($.extend(props, {position: element.css("position"),zIndex: element.css("z-index")}), $.each(["top", "left", "bottom", "right"], function(i, pos) {
                        props[pos] = element.css(pos), isNaN(parseInt(props[pos], 10)) && (props[pos] = "auto")
                    }), element.css({position: "relative",top: 0,left: 0,right: "auto",bottom: "auto"})), element.css(size), wrapper.css(props).show()
                },removeWrapper: function(element) {
                    var active = document.activeElement;
                    return element.parent().is(".ui-effects-wrapper") && (element.parent().replaceWith(element), (element[0] === active || $.contains(element[0], active)) && $(active).focus()), element
                },setTransition: function(element, list, factor, value) {
                    return value = value || {}, $.each(list, function(i, x) {
                        var unit = element.cssUnit(x);
                        unit[0] > 0 && (value[x] = unit[0] * factor + unit[1])
                    }), value
                }}), $.fn.extend({effect: function() {
                    function run(next) {
                        function done() {
                            $.isFunction(complete) && complete.call(elem[0]), $.isFunction(next) && next()
                        }
                        var elem = $(this), complete = args.complete, mode = args.mode;
                        (elem.is(":hidden") ? "hide" === mode : "show" === mode) ? (elem[mode](), done()) : effectMethod.call(elem[0], args, done)
                    }
                    var args = _normalizeArguments.apply(this, arguments), mode = args.mode, queue = args.queue, effectMethod = $.effects.effect[args.effect];
                    return $.fx.off || !effectMethod ? mode ? this[mode](args.duration, args.complete) : this.each(function() {
                        args.complete && args.complete.call(this)
                    }) : queue === !1 ? this.each(run) : this.queue(queue || "fx", run)
                },show: function(orig) {
                    return function(option) {
                        if (standardAnimationOption(option))
                            return orig.apply(this, arguments);
                        var args = _normalizeArguments.apply(this, arguments);
                        return args.mode = "show", this.effect.call(this, args)
                    }
                }($.fn.show),hide: function(orig) {
                    return function(option) {
                        if (standardAnimationOption(option))
                            return orig.apply(this, arguments);
                        var args = _normalizeArguments.apply(this, arguments);
                        return args.mode = "hide", this.effect.call(this, args)
                    }
                }($.fn.hide),toggle: function(orig) {
                    return function(option) {
                        if (standardAnimationOption(option) || "boolean" == typeof option)
                            return orig.apply(this, arguments);
                        var args = _normalizeArguments.apply(this, arguments);
                        return args.mode = "toggle", this.effect.call(this, args)
                    }
                }($.fn.toggle),cssUnit: function(key) {
                    var style = this.css(key), val = [];
                    return $.each(["em", "px", "%", "pt"], function(i, unit) {
                        style.indexOf(unit) > 0 && (val = [parseFloat(style), unit])
                    }), val
                }})
        }(), function() {
            var baseEasings = {};
            $.each(["Quad", "Cubic", "Quart", "Quint", "Expo"], function(i, name) {
                baseEasings[name] = function(p) {
                    return Math.pow(p, i + 2)
                }
            }), $.extend(baseEasings, {Sine: function(p) {
                    return 1 - Math.cos(p * Math.PI / 2)
                },Circ: function(p) {
                    return 1 - Math.sqrt(1 - p * p)
                },Elastic: function(p) {
                    return 0 === p || 1 === p ? p : -Math.pow(2, 8 * (p - 1)) * Math.sin((80 * (p - 1) - 7.5) * Math.PI / 15)
                },Back: function(p) {
                    return p * p * (3 * p - 2)
                },Bounce: function(p) {
                    for (var pow2, bounce = 4; p < ((pow2 = Math.pow(2, --bounce)) - 1) / 11; )
                        ;
                    return 1 / Math.pow(4, 3 - bounce) - 7.5625 * Math.pow((3 * pow2 - 2) / 22 - p, 2)
                }}), $.each(baseEasings, function(name, easeIn) {
                $.easing["easeIn" + name] = easeIn, $.easing["easeOut" + name] = function(p) {
                    return 1 - easeIn(1 - p)
                }, $.easing["easeInOut" + name] = function(p) {
                    return .5 > p ? easeIn(2 * p) / 2 : 1 - easeIn(-2 * p + 2) / 2
                }
            })
        }();
        $.effects, $.effects.effect.blind = function(o, done) {
            var wrapper, distance, margin, el = $(this), rvertical = /up|down|vertical/, rpositivemotion = /up|left|vertical|horizontal/, props = ["position", "top", "bottom", "left", "right", "height", "width"], mode = $.effects.setMode(el, o.mode || "hide"), direction = o.direction || "up", vertical = rvertical.test(direction), ref = vertical ? "height" : "width", ref2 = vertical ? "top" : "left", motion = rpositivemotion.test(direction), animation = {}, show = "show" === mode;
            el.parent().is(".ui-effects-wrapper") ? $.effects.save(el.parent(), props) : $.effects.save(el, props), el.show(), wrapper = $.effects.createWrapper(el).css({overflow: "hidden"}), distance = wrapper[ref](), margin = parseFloat(wrapper.css(ref2)) || 0, animation[ref] = show ? distance : 0, motion || (el.css(vertical ? "bottom" : "right", 0).css(vertical ? "top" : "left", "auto").css({position: "absolute"}), animation[ref2] = show ? margin : distance + margin), show && (wrapper.css(ref, 0), motion || wrapper.css(ref2, margin + distance)), wrapper.animate(animation, {duration: o.duration,easing: o.easing,queue: !1,complete: function() {
                    "hide" === mode && el.hide(), $.effects.restore(el, props), $.effects.removeWrapper(el), done()
                }})
        }, $.effects.effect.bounce = function(o, done) {
            var i, upAnim, downAnim, el = $(this), props = ["position", "top", "bottom", "left", "right", "height", "width"], mode = $.effects.setMode(el, o.mode || "effect"), hide = "hide" === mode, show = "show" === mode, direction = o.direction || "up", distance = o.distance, times = o.times || 5, anims = 2 * times + (show || hide ? 1 : 0), speed = o.duration / anims, easing = o.easing, ref = "up" === direction || "down" === direction ? "top" : "left", motion = "up" === direction || "left" === direction, queue = el.queue(), queuelen = queue.length;
            for ((show || hide) && props.push("opacity"), $.effects.save(el, props), el.show(), $.effects.createWrapper(el), distance || (distance = el["top" === ref ? "outerHeight" : "outerWidth"]() / 3), show && (downAnim = {opacity: 1}, downAnim[ref] = 0, el.css("opacity", 0).css(ref, motion ? 2 * -distance : 2 * distance).animate(downAnim, speed, easing)), hide && (distance /= Math.pow(2, times - 1)), downAnim = {}, downAnim[ref] = 0, i = 0; times > i; i++)
                upAnim = {}, upAnim[ref] = (motion ? "-=" : "+=") + distance, el.animate(upAnim, speed, easing).animate(downAnim, speed, easing), distance = hide ? 2 * distance : distance / 2;
            hide && (upAnim = {opacity: 0}, upAnim[ref] = (motion ? "-=" : "+=") + distance, el.animate(upAnim, speed, easing)), el.queue(function() {
                hide && el.hide(), $.effects.restore(el, props), $.effects.removeWrapper(el), done()
            }), queuelen > 1 && queue.splice.apply(queue, [1, 0].concat(queue.splice(queuelen, anims + 1))), el.dequeue()
        }, $.effects.effect.clip = function(o, done) {
            var wrapper, animate, distance, el = $(this), props = ["position", "top", "bottom", "left", "right", "height", "width"], mode = $.effects.setMode(el, o.mode || "hide"), show = "show" === mode, direction = o.direction || "vertical", vert = "vertical" === direction, size = vert ? "height" : "width", position = vert ? "top" : "left", animation = {};
            $.effects.save(el, props), el.show(), wrapper = $.effects.createWrapper(el).css({overflow: "hidden"}), animate = "IMG" === el[0].tagName ? wrapper : el, distance = animate[size](), show && (animate.css(size, 0), animate.css(position, distance / 2)), animation[size] = show ? distance : 0, animation[position] = show ? 0 : distance / 2, animate.animate(animation, {queue: !1,duration: o.duration,easing: o.easing,complete: function() {
                    show || el.hide(), $.effects.restore(el, props), $.effects.removeWrapper(el), done()
                }})
        }, $.effects.effect.drop = function(o, done) {
            var distance, el = $(this), props = ["position", "top", "bottom", "left", "right", "opacity", "height", "width"], mode = $.effects.setMode(el, o.mode || "hide"), show = "show" === mode, direction = o.direction || "left", ref = "up" === direction || "down" === direction ? "top" : "left", motion = "up" === direction || "left" === direction ? "pos" : "neg", animation = {opacity: show ? 1 : 0};
            $.effects.save(el, props), el.show(), $.effects.createWrapper(el), distance = o.distance || el["top" === ref ? "outerHeight" : "outerWidth"](!0) / 2, show && el.css("opacity", 0).css(ref, "pos" === motion ? -distance : distance), animation[ref] = (show ? "pos" === motion ? "+=" : "-=" : "pos" === motion ? "-=" : "+=") + distance, el.animate(animation, {queue: !1,duration: o.duration,easing: o.easing,complete: function() {
                    "hide" === mode && el.hide(), $.effects.restore(el, props), $.effects.removeWrapper(el), done()
                }})
        }, $.effects.effect.explode = function(o, done) {
            function childComplete() {
                pieces.push(this), pieces.length === rows * cells && animComplete()
            }
            function animComplete() {
                el.css({visibility: "visible"}), $(pieces).remove(), show || el.hide(), done()
            }
            var i, j, left, top, mx, my, rows = o.pieces ? Math.round(Math.sqrt(o.pieces)) : 3, cells = rows, el = $(this), mode = $.effects.setMode(el, o.mode || "hide"), show = "show" === mode, offset = el.show().css("visibility", "hidden").offset(), width = Math.ceil(el.outerWidth() / cells), height = Math.ceil(el.outerHeight() / rows), pieces = [];
            for (i = 0; rows > i; i++)
                for (top = offset.top + i * height, my = i - (rows - 1) / 2, j = 0; cells > j; j++)
                    left = offset.left + j * width, mx = j - (cells - 1) / 2, el.clone().appendTo("body").wrap("<div></div>").css({position: "absolute",visibility: "visible",left: -j * width,top: -i * height}).parent().addClass("ui-effects-explode").css({position: "absolute",overflow: "hidden",width: width,height: height,left: left + (show ? mx * width : 0),top: top + (show ? my * height : 0),opacity: show ? 0 : 1}).animate({left: left + (show ? 0 : mx * width),top: top + (show ? 0 : my * height),opacity: show ? 1 : 0}, o.duration || 500, o.easing, childComplete)
        }, $.effects.effect.fade = function(o, done) {
            var el = $(this), mode = $.effects.setMode(el, o.mode || "toggle");
            el.animate({opacity: mode}, {queue: !1,duration: o.duration,easing: o.easing,complete: done})
        }, $.effects.effect.fold = function(o, done) {
            var wrapper, distance, el = $(this), props = ["position", "top", "bottom", "left", "right", "height", "width"], mode = $.effects.setMode(el, o.mode || "hide"), show = "show" === mode, hide = "hide" === mode, size = o.size || 15, percent = /([0-9]+)%/.exec(size), horizFirst = !!o.horizFirst, widthFirst = show !== horizFirst, ref = widthFirst ? ["width", "height"] : ["height", "width"], duration = o.duration / 2, animation1 = {}, animation2 = {};
            $.effects.save(el, props), el.show(), wrapper = $.effects.createWrapper(el).css({overflow: "hidden"}), distance = widthFirst ? [wrapper.width(), wrapper.height()] : [wrapper.height(), wrapper.width()], percent && (size = parseInt(percent[1], 10) / 100 * distance[hide ? 0 : 1]), show && wrapper.css(horizFirst ? {height: 0,width: size} : {height: size,width: 0}), animation1[ref[0]] = show ? distance[0] : size, animation2[ref[1]] = show ? distance[1] : 0, wrapper.animate(animation1, duration, o.easing).animate(animation2, duration, o.easing, function() {
                hide && el.hide(), $.effects.restore(el, props), $.effects.removeWrapper(el), done()
            })
        }, $.effects.effect.highlight = function(o, done) {
            var elem = $(this), props = ["backgroundImage", "backgroundColor", "opacity"], mode = $.effects.setMode(elem, o.mode || "show"), animation = {backgroundColor: elem.css("backgroundColor")};
            "hide" === mode && (animation.opacity = 0), $.effects.save(elem, props), elem.show().css({backgroundImage: "none",backgroundColor: o.color || "#ffff99"}).animate(animation, {queue: !1,duration: o.duration,easing: o.easing,complete: function() {
                    "hide" === mode && elem.hide(), $.effects.restore(elem, props), done()
                }})
        }, $.effects.effect.size = function(o, done) {
            var original, baseline, factor, el = $(this), props0 = ["position", "top", "bottom", "left", "right", "width", "height", "overflow", "opacity"], props1 = ["position", "top", "bottom", "left", "right", "overflow", "opacity"], props2 = ["width", "height", "overflow"], cProps = ["fontSize"], vProps = ["borderTopWidth", "borderBottomWidth", "paddingTop", "paddingBottom"], hProps = ["borderLeftWidth", "borderRightWidth", "paddingLeft", "paddingRight"], mode = $.effects.setMode(el, o.mode || "effect"), restore = o.restore || "effect" !== mode, scale = o.scale || "both", origin = o.origin || ["middle", "center"], position = el.css("position"), props = restore ? props0 : props1, zero = {height: 0,width: 0,outerHeight: 0,outerWidth: 0};
            "show" === mode && el.show(), original = {height: el.height(),width: el.width(),outerHeight: el.outerHeight(),outerWidth: el.outerWidth()}, "toggle" === o.mode && "show" === mode ? (el.from = o.to || zero, el.to = o.from || original) : (el.from = o.from || ("show" === mode ? zero : original), el.to = o.to || ("hide" === mode ? zero : original)), factor = {from: {y: el.from.height / original.height,x: el.from.width / original.width},to: {y: el.to.height / original.height,x: el.to.width / original.width}}, ("box" === scale || "both" === scale) && (factor.from.y !== factor.to.y && (props = props.concat(vProps), el.from = $.effects.setTransition(el, vProps, factor.from.y, el.from), el.to = $.effects.setTransition(el, vProps, factor.to.y, el.to)), factor.from.x !== factor.to.x && (props = props.concat(hProps), el.from = $.effects.setTransition(el, hProps, factor.from.x, el.from), el.to = $.effects.setTransition(el, hProps, factor.to.x, el.to))), ("content" === scale || "both" === scale) && factor.from.y !== factor.to.y && (props = props.concat(cProps).concat(props2), el.from = $.effects.setTransition(el, cProps, factor.from.y, el.from), el.to = $.effects.setTransition(el, cProps, factor.to.y, el.to)), $.effects.save(el, props), el.show(), $.effects.createWrapper(el), el.css("overflow", "hidden").css(el.from), origin && (baseline = $.effects.getBaseline(origin, original), el.from.top = (original.outerHeight - el.outerHeight()) * baseline.y, el.from.left = (original.outerWidth - el.outerWidth()) * baseline.x, el.to.top = (original.outerHeight - el.to.outerHeight) * baseline.y, el.to.left = (original.outerWidth - el.to.outerWidth) * baseline.x), el.css(el.from), ("content" === scale || "both" === scale) && (vProps = vProps.concat(["marginTop", "marginBottom"]).concat(cProps), hProps = hProps.concat(["marginLeft", "marginRight"]), props2 = props0.concat(vProps).concat(hProps), el.find("*[width]").each(function() {
                var child = $(this), c_original = {height: child.height(),width: child.width(),outerHeight: child.outerHeight(),outerWidth: child.outerWidth()};
                restore && $.effects.save(child, props2), child.from = {height: c_original.height * factor.from.y,width: c_original.width * factor.from.x,outerHeight: c_original.outerHeight * factor.from.y,outerWidth: c_original.outerWidth * factor.from.x}, child.to = {height: c_original.height * factor.to.y,width: c_original.width * factor.to.x,outerHeight: c_original.height * factor.to.y,outerWidth: c_original.width * factor.to.x}, factor.from.y !== factor.to.y && (child.from = $.effects.setTransition(child, vProps, factor.from.y, child.from), child.to = $.effects.setTransition(child, vProps, factor.to.y, child.to)), factor.from.x !== factor.to.x && (child.from = $.effects.setTransition(child, hProps, factor.from.x, child.from), child.to = $.effects.setTransition(child, hProps, factor.to.x, child.to)), child.css(child.from), child.animate(child.to, o.duration, o.easing, function() {
                    restore && $.effects.restore(child, props2)
                })
            })), el.animate(el.to, {queue: !1,duration: o.duration,easing: o.easing,complete: function() {
                    0 === el.to.opacity && el.css("opacity", el.from.opacity), "hide" === mode && el.hide(), $.effects.restore(el, props), restore || ("static" === position ? el.css({position: "relative",top: el.to.top,left: el.to.left}) : $.each(["top", "left"], function(idx, pos) {
                        el.css(pos, function(_, str) {
                            var val = parseInt(str, 10), toRef = idx ? el.to.left : el.to.top;
                            return "auto" === str ? toRef + "px" : val + toRef + "px"
                        })
                    })), $.effects.removeWrapper(el), done()
                }})
        }, $.effects.effect.scale = function(o, done) {
            var el = $(this), options = $.extend(!0, {}, o), mode = $.effects.setMode(el, o.mode || "effect"), percent = parseInt(o.percent, 10) || (0 === parseInt(o.percent, 10) ? 0 : "hide" === mode ? 0 : 100), direction = o.direction || "both", origin = o.origin, original = {height: el.height(),width: el.width(),outerHeight: el.outerHeight(),outerWidth: el.outerWidth()}, factor = {y: "horizontal" !== direction ? percent / 100 : 1,x: "vertical" !== direction ? percent / 100 : 1};
            options.effect = "size", options.queue = !1, options.complete = done, "effect" !== mode && (options.origin = origin || ["middle", "center"], options.restore = !0), options.from = o.from || ("show" === mode ? {height: 0,width: 0,outerHeight: 0,outerWidth: 0} : original), options.to = {height: original.height * factor.y,width: original.width * factor.x,outerHeight: original.outerHeight * factor.y,outerWidth: original.outerWidth * factor.x}, options.fade && ("show" === mode && (options.from.opacity = 0, options.to.opacity = 1), "hide" === mode && (options.from.opacity = 1, options.to.opacity = 0)), el.effect(options)
        }, $.effects.effect.puff = function(o, done) {
            var elem = $(this), mode = $.effects.setMode(elem, o.mode || "hide"), hide = "hide" === mode, percent = parseInt(o.percent, 10) || 150, factor = percent / 100, original = {height: elem.height(),width: elem.width(),outerHeight: elem.outerHeight(),outerWidth: elem.outerWidth()};
            $.extend(o, {effect: "scale",queue: !1,fade: !0,mode: mode,complete: done,percent: hide ? percent : 100,from: hide ? original : {height: original.height * factor,width: original.width * factor,outerHeight: original.outerHeight * factor,outerWidth: original.outerWidth * factor}}), elem.effect(o)
        }, $.effects.effect.pulsate = function(o, done) {
            var i, elem = $(this), mode = $.effects.setMode(elem, o.mode || "show"), show = "show" === mode, hide = "hide" === mode, showhide = show || "hide" === mode, anims = 2 * (o.times || 5) + (showhide ? 1 : 0), duration = o.duration / anims, animateTo = 0, queue = elem.queue(), queuelen = queue.length;
            for ((show || !elem.is(":visible")) && (elem.css("opacity", 0).show(), animateTo = 1), i = 1; anims > i; i++)
                elem.animate({opacity: animateTo}, duration, o.easing), animateTo = 1 - animateTo;
            elem.animate({opacity: animateTo}, duration, o.easing), elem.queue(function() {
                hide && elem.hide(), done()
            }), queuelen > 1 && queue.splice.apply(queue, [1, 0].concat(queue.splice(queuelen, anims + 1))), elem.dequeue()
        }, $.effects.effect.shake = function(o, done) {
            var i, el = $(this), props = ["position", "top", "bottom", "left", "right", "height", "width"], mode = $.effects.setMode(el, o.mode || "effect"), direction = o.direction || "left", distance = o.distance || 20, times = o.times || 3, anims = 2 * times + 1, speed = Math.round(o.duration / anims), ref = "up" === direction || "down" === direction ? "top" : "left", positiveMotion = "up" === direction || "left" === direction, animation = {}, animation1 = {}, animation2 = {}, queue = el.queue(), queuelen = queue.length;
            for ($.effects.save(el, props), el.show(), $.effects.createWrapper(el), animation[ref] = (positiveMotion ? "-=" : "+=") + distance, animation1[ref] = (positiveMotion ? "+=" : "-=") + 2 * distance, animation2[ref] = (positiveMotion ? "-=" : "+=") + 2 * distance, el.animate(animation, speed, o.easing), i = 1; times > i; i++)
                el.animate(animation1, speed, o.easing).animate(animation2, speed, o.easing);
            el.animate(animation1, speed, o.easing).animate(animation, speed / 2, o.easing).queue(function() {
                "hide" === mode && el.hide(), $.effects.restore(el, props), $.effects.removeWrapper(el), done()
            }), queuelen > 1 && queue.splice.apply(queue, [1, 0].concat(queue.splice(queuelen, anims + 1))), el.dequeue()
        }, $.effects.effect.slide = function(o, done) {
            var distance, el = $(this), props = ["position", "top", "bottom", "left", "right", "width", "height"], mode = $.effects.setMode(el, o.mode || "show"), show = "show" === mode, direction = o.direction || "left", ref = "up" === direction || "down" === direction ? "top" : "left", positiveMotion = "up" === direction || "left" === direction, animation = {};
            $.effects.save(el, props), el.show(), distance = o.distance || el["top" === ref ? "outerHeight" : "outerWidth"](!0), $.effects.createWrapper(el).css({overflow: "hidden"}), show && el.css(ref, positiveMotion ? isNaN(distance) ? "-" + distance : -distance : distance), animation[ref] = (show ? positiveMotion ? "+=" : "-=" : positiveMotion ? "-=" : "+=") + distance, el.animate(animation, {queue: !1,duration: o.duration,easing: o.easing,
                complete: function() {
                    "hide" === mode && el.hide(), $.effects.restore(el, props), $.effects.removeWrapper(el), done()
                }})
        }, $.effects.effect.transfer = function(o, done) {
            var elem = $(this), target = $(o.to), targetFixed = "fixed" === target.css("position"), body = $("body"), fixTop = targetFixed ? body.scrollTop() : 0, fixLeft = targetFixed ? body.scrollLeft() : 0, endPosition = target.offset(), animation = {top: endPosition.top - fixTop,left: endPosition.left - fixLeft,height: target.innerHeight(),width: target.innerWidth()}, startPosition = elem.offset(), transfer = $("<div class='ui-effects-transfer'></div>").appendTo(document.body).addClass(o.className).css({top: startPosition.top - fixTop,left: startPosition.left - fixLeft,height: elem.innerHeight(),width: elem.innerWidth(),position: targetFixed ? "fixed" : "absolute"}).animate(animation, o.duration, o.easing, function() {
                transfer.remove(), done()
            })
        }, $.widget("ui.progressbar", {version: "1.11.4",options: {max: 100,value: 0,change: null,complete: null},min: 0,_create: function() {
                this.oldValue = this.options.value = this._constrainedValue(), this.element.addClass("ui-progressbar ui-widget ui-widget-content ui-corner-all").attr({role: "progressbar","aria-valuemin": this.min}), this.valueDiv = $("<div class='ui-progressbar-value ui-widget-header ui-corner-left'></div>").appendTo(this.element), this._refreshValue()
            },_destroy: function() {
                this.element.removeClass("ui-progressbar ui-widget ui-widget-content ui-corner-all").removeAttr("role").removeAttr("aria-valuemin").removeAttr("aria-valuemax").removeAttr("aria-valuenow"), this.valueDiv.remove()
            },value: function(newValue) {
                return void 0 === newValue ? this.options.value : (this.options.value = this._constrainedValue(newValue), void this._refreshValue())
            },_constrainedValue: function(newValue) {
                return void 0 === newValue && (newValue = this.options.value), this.indeterminate = newValue === !1, "number" != typeof newValue && (newValue = 0), this.indeterminate ? !1 : Math.min(this.options.max, Math.max(this.min, newValue))
            },_setOptions: function(options) {
                var value = options.value;
                delete options.value, this._super(options), this.options.value = this._constrainedValue(value), this._refreshValue()
            },_setOption: function(key, value) {
                "max" === key && (value = Math.max(this.min, value)), "disabled" === key && this.element.toggleClass("ui-state-disabled", !!value).attr("aria-disabled", value), this._super(key, value)
            },_percentage: function() {
                return this.indeterminate ? 100 : 100 * (this.options.value - this.min) / (this.options.max - this.min)
            },_refreshValue: function() {
                var value = this.options.value, percentage = this._percentage();
                this.valueDiv.toggle(this.indeterminate || value > this.min).toggleClass("ui-corner-right", value === this.options.max).width(percentage.toFixed(0) + "%"), this.element.toggleClass("ui-progressbar-indeterminate", this.indeterminate), this.indeterminate ? (this.element.removeAttr("aria-valuenow"), this.overlayDiv || (this.overlayDiv = $("<div class='ui-progressbar-overlay'></div>").appendTo(this.valueDiv))) : (this.element.attr({"aria-valuemax": this.options.max,"aria-valuenow": value}), this.overlayDiv && (this.overlayDiv.remove(), this.overlayDiv = null)), this.oldValue !== value && (this.oldValue = value, this._trigger("change")), value === this.options.max && this._trigger("complete")
            }}), $.widget("ui.selectable", $.ui.mouse, {version: "1.11.4",options: {appendTo: "body",autoRefresh: !0,distance: 0,filter: "*",tolerance: "touch",selected: null,selecting: null,start: null,stop: null,unselected: null,unselecting: null},_create: function() {
                var selectees, that = this;
                this.element.addClass("ui-selectable"), this.dragged = !1, this.refresh = function() {
                    selectees = $(that.options.filter, that.element[0]), selectees.addClass("ui-selectee"), selectees.each(function() {
                        var $this = $(this), pos = $this.offset();
                        $.data(this, "selectable-item", {element: this,$element: $this,left: pos.left,top: pos.top,right: pos.left + $this.outerWidth(),bottom: pos.top + $this.outerHeight(),startselected: !1,selected: $this.hasClass("ui-selected"),selecting: $this.hasClass("ui-selecting"),unselecting: $this.hasClass("ui-unselecting")})
                    })
                }, this.refresh(), this.selectees = selectees.addClass("ui-selectee"), this._mouseInit(), this.helper = $("<div class='ui-selectable-helper'></div>")
            },_destroy: function() {
                this.selectees.removeClass("ui-selectee").removeData("selectable-item"), this.element.removeClass("ui-selectable ui-selectable-disabled"), this._mouseDestroy()
            },_mouseStart: function(event) {
                var that = this, options = this.options;
                this.opos = [event.pageX, event.pageY], this.options.disabled || (this.selectees = $(options.filter, this.element[0]), this._trigger("start", event), $(options.appendTo).append(this.helper), this.helper.css({left: event.pageX,top: event.pageY,width: 0,height: 0}), options.autoRefresh && this.refresh(), this.selectees.filter(".ui-selected").each(function() {
                    var selectee = $.data(this, "selectable-item");
                    selectee.startselected = !0, event.metaKey || event.ctrlKey || (selectee.$element.removeClass("ui-selected"), selectee.selected = !1, selectee.$element.addClass("ui-unselecting"), selectee.unselecting = !0, that._trigger("unselecting", event, {unselecting: selectee.element}))
                }), $(event.target).parents().addBack().each(function() {
                    var doSelect, selectee = $.data(this, "selectable-item");
                    return selectee ? (doSelect = !event.metaKey && !event.ctrlKey || !selectee.$element.hasClass("ui-selected"), selectee.$element.removeClass(doSelect ? "ui-unselecting" : "ui-selected").addClass(doSelect ? "ui-selecting" : "ui-unselecting"), selectee.unselecting = !doSelect, selectee.selecting = doSelect, selectee.selected = doSelect, doSelect ? that._trigger("selecting", event, {selecting: selectee.element}) : that._trigger("unselecting", event, {unselecting: selectee.element}), !1) : void 0
                }))
            },_mouseDrag: function(event) {
                if (this.dragged = !0, !this.options.disabled) {
                    var tmp, that = this, options = this.options, x1 = this.opos[0], y1 = this.opos[1], x2 = event.pageX, y2 = event.pageY;
                    return x1 > x2 && (tmp = x2, x2 = x1, x1 = tmp), y1 > y2 && (tmp = y2, y2 = y1, y1 = tmp), this.helper.css({left: x1,top: y1,width: x2 - x1,height: y2 - y1}), this.selectees.each(function() {
                        var selectee = $.data(this, "selectable-item"), hit = !1;
                        selectee && selectee.element !== that.element[0] && ("touch" === options.tolerance ? hit = !(selectee.left > x2 || selectee.right < x1 || selectee.top > y2 || selectee.bottom < y1) : "fit" === options.tolerance && (hit = selectee.left > x1 && selectee.right < x2 && selectee.top > y1 && selectee.bottom < y2), hit ? (selectee.selected && (selectee.$element.removeClass("ui-selected"), selectee.selected = !1), selectee.unselecting && (selectee.$element.removeClass("ui-unselecting"), selectee.unselecting = !1), selectee.selecting || (selectee.$element.addClass("ui-selecting"), selectee.selecting = !0, that._trigger("selecting", event, {selecting: selectee.element}))) : (selectee.selecting && ((event.metaKey || event.ctrlKey) && selectee.startselected ? (selectee.$element.removeClass("ui-selecting"), selectee.selecting = !1, selectee.$element.addClass("ui-selected"), selectee.selected = !0) : (selectee.$element.removeClass("ui-selecting"), selectee.selecting = !1, selectee.startselected && (selectee.$element.addClass("ui-unselecting"), selectee.unselecting = !0), that._trigger("unselecting", event, {unselecting: selectee.element}))), selectee.selected && (event.metaKey || event.ctrlKey || selectee.startselected || (selectee.$element.removeClass("ui-selected"), selectee.selected = !1, selectee.$element.addClass("ui-unselecting"), selectee.unselecting = !0, that._trigger("unselecting", event, {unselecting: selectee.element})))))
                    }), !1
                }
            },_mouseStop: function(event) {
                var that = this;
                return this.dragged = !1, $(".ui-unselecting", this.element[0]).each(function() {
                    var selectee = $.data(this, "selectable-item");
                    selectee.$element.removeClass("ui-unselecting"), selectee.unselecting = !1, selectee.startselected = !1, that._trigger("unselected", event, {unselected: selectee.element})
                }), $(".ui-selecting", this.element[0]).each(function() {
                    var selectee = $.data(this, "selectable-item");
                    selectee.$element.removeClass("ui-selecting").addClass("ui-selected"), selectee.selecting = !1, selectee.selected = !0, selectee.startselected = !0, that._trigger("selected", event, {selected: selectee.element})
                }), this._trigger("stop", event), this.helper.remove(), !1
            }}), $.widget("ui.selectmenu", {version: "1.11.4",defaultElement: "<select>",options: {appendTo: null,disabled: null,icons: {button: "ui-icon-triangle-1-s"},position: {my: "left top",at: "left bottom",collision: "none"},width: null,change: null,close: null,focus: null,open: null,select: null},_create: function() {
                var selectmenuId = this.element.uniqueId().attr("id");
                this.ids = {element: selectmenuId,button: selectmenuId + "-button",menu: selectmenuId + "-menu"}, this._drawButton(), this._drawMenu(), this.options.disabled && this.disable()
            },_drawButton: function() {
                var that = this;
                this.label = $("label[for='" + this.ids.element + "']").attr("for", this.ids.button), this._on(this.label, {click: function(event) {
                        this.button.focus(), event.preventDefault()
                    }}), this.element.hide(), this.button = $("<span>", {"class": "ui-selectmenu-button ui-widget ui-state-default ui-corner-all",tabindex: this.options.disabled ? -1 : 0,id: this.ids.button,role: "combobox","aria-expanded": "false","aria-autocomplete": "list","aria-owns": this.ids.menu,"aria-haspopup": "true"}).insertAfter(this.element), $("<span>", {"class": "ui-icon " + this.options.icons.button}).prependTo(this.button), this.buttonText = $("<span>", {"class": "ui-selectmenu-text"}).appendTo(this.button), this._setText(this.buttonText, this.element.find("option:selected").text()), this._resizeButton(), this._on(this.button, this._buttonEvents), this.button.one("focusin", function() {
                    that.menuItems || that._refreshMenu()
                }), this._hoverable(this.button), this._focusable(this.button)
            },_drawMenu: function() {
                var that = this;
                this.menu = $("<ul>", {"aria-hidden": "true","aria-labelledby": this.ids.button,id: this.ids.menu}), this.menuWrap = $("<div>", {"class": "ui-selectmenu-menu ui-front"}).append(this.menu).appendTo(this._appendTo()), this.menuInstance = this.menu.menu({role: "listbox",select: function(event, ui) {
                        event.preventDefault(), that._setSelection(), that._select(ui.item.data("ui-selectmenu-item"), event)
                    },focus: function(event, ui) {
                        var item = ui.item.data("ui-selectmenu-item");
                        null != that.focusIndex && item.index !== that.focusIndex && (that._trigger("focus", event, {item: item}), that.isOpen || that._select(item, event)), that.focusIndex = item.index, that.button.attr("aria-activedescendant", that.menuItems.eq(item.index).attr("id"))
                    }}).menu("instance"), this.menu.addClass("ui-corner-bottom").removeClass("ui-corner-all"), this.menuInstance._off(this.menu, "mouseleave"), this.menuInstance._closeOnDocumentClick = function() {
                    return !1
                }, this.menuInstance._isDivider = function() {
                    return !1
                }
            },refresh: function() {
                this._refreshMenu(), this._setText(this.buttonText, this._getSelectedItem().text()), this.options.width || this._resizeButton()
            },_refreshMenu: function() {
                this.menu.empty();
                var item, options = this.element.find("option");
                options.length && (this._parseOptions(options), this._renderMenu(this.menu, this.items), this.menuInstance.refresh(), this.menuItems = this.menu.find("li").not(".ui-selectmenu-optgroup"), item = this._getSelectedItem(), this.menuInstance.focus(null, item), this._setAria(item.data("ui-selectmenu-item")), this._setOption("disabled", this.element.prop("disabled")))
            },open: function(event) {
                this.options.disabled || (this.menuItems ? (this.menu.find(".ui-state-focus").removeClass("ui-state-focus"), this.menuInstance.focus(null, this._getSelectedItem())) : this._refreshMenu(), this.isOpen = !0, this._toggleAttr(), this._resizeMenu(), this._position(), this._on(this.document, this._documentClick), this._trigger("open", event))
            },_position: function() {
                this.menuWrap.position($.extend({of: this.button}, this.options.position))
            },close: function(event) {
                this.isOpen && (this.isOpen = !1, this._toggleAttr(), this.range = null, this._off(this.document), this._trigger("close", event))
            },widget: function() {
                return this.button
            },menuWidget: function() {
                return this.menu
            },_renderMenu: function(ul, items) {
                var that = this, currentOptgroup = "";
                $.each(items, function(index, item) {
                    item.optgroup !== currentOptgroup && ($("<li>", {"class": "ui-selectmenu-optgroup ui-menu-divider" + (item.element.parent("optgroup").prop("disabled") ? " ui-state-disabled" : ""),text: item.optgroup}).appendTo(ul), currentOptgroup = item.optgroup), that._renderItemData(ul, item)
                })
            },_renderItemData: function(ul, item) {
                return this._renderItem(ul, item).data("ui-selectmenu-item", item)
            },_renderItem: function(ul, item) {
                var li = $("<li>");
                return item.disabled && li.addClass("ui-state-disabled"), this._setText(li, item.label), li.appendTo(ul)
            },_setText: function(element, value) {
                value ? element.text(value) : element.html("&#160;")
            },_move: function(direction, event) {
                var item, next, filter = ".ui-menu-item";
                this.isOpen ? item = this.menuItems.eq(this.focusIndex) : (item = this.menuItems.eq(this.element[0].selectedIndex), filter += ":not(.ui-state-disabled)"), next = "first" === direction || "last" === direction ? item["first" === direction ? "prevAll" : "nextAll"](filter).eq(-1) : item[direction + "All"](filter).eq(0), next.length && this.menuInstance.focus(event, next)
            },_getSelectedItem: function() {
                return this.menuItems.eq(this.element[0].selectedIndex)
            },_toggle: function(event) {
                this[this.isOpen ? "close" : "open"](event)
            },_setSelection: function() {
                var selection;
                this.range && (window.getSelection ? (selection = window.getSelection(), selection.removeAllRanges(), selection.addRange(this.range)) : this.range.select(), this.button.focus())
            },_documentClick: {mousedown: function(event) {
                    this.isOpen && ($(event.target).closest(".ui-selectmenu-menu, #" + this.ids.button).length || this.close(event))
                }},_buttonEvents: {mousedown: function() {
                    var selection;
                    window.getSelection ? (selection = window.getSelection(), selection.rangeCount && (this.range = selection.getRangeAt(0))) : this.range = document.selection.createRange()
                },click: function(event) {
                    this._setSelection(), this._toggle(event)
                },keydown: function(event) {
                    var preventDefault = !0;
                    switch (event.keyCode) {
                        case $.ui.keyCode.TAB:
                        case $.ui.keyCode.ESCAPE:
                            this.close(event), preventDefault = !1;
                            break;
                        case $.ui.keyCode.ENTER:
                            this.isOpen && this._selectFocusedItem(event);
                            break;
                        case $.ui.keyCode.UP:
                            event.altKey ? this._toggle(event) : this._move("prev", event);
                            break;
                        case $.ui.keyCode.DOWN:
                            event.altKey ? this._toggle(event) : this._move("next", event);
                            break;
                        case $.ui.keyCode.SPACE:
                            this.isOpen ? this._selectFocusedItem(event) : this._toggle(event);
                            break;
                        case $.ui.keyCode.LEFT:
                            this._move("prev", event);
                            break;
                        case $.ui.keyCode.RIGHT:
                            this._move("next", event);
                            break;
                        case $.ui.keyCode.HOME:
                        case $.ui.keyCode.PAGE_UP:
                            this._move("first", event);
                            break;
                        case $.ui.keyCode.END:
                        case $.ui.keyCode.PAGE_DOWN:
                            this._move("last", event);
                            break;
                        default:
                            this.menu.trigger(event), preventDefault = !1
                    }
                    preventDefault && event.preventDefault()
                }},_selectFocusedItem: function(event) {
                var item = this.menuItems.eq(this.focusIndex);
                item.hasClass("ui-state-disabled") || this._select(item.data("ui-selectmenu-item"), event)
            },_select: function(item, event) {
                var oldIndex = this.element[0].selectedIndex;
                this.element[0].selectedIndex = item.index, this._setText(this.buttonText, item.label), this._setAria(item), this._trigger("select", event, {item: item}), item.index !== oldIndex && this._trigger("change", event, {item: item}), this.close(event)
            },_setAria: function(item) {
                var id = this.menuItems.eq(item.index).attr("id");
                this.button.attr({"aria-labelledby": id,"aria-activedescendant": id}), this.menu.attr("aria-activedescendant", id)
            },_setOption: function(key, value) {
                "icons" === key && this.button.find("span.ui-icon").removeClass(this.options.icons.button).addClass(value.button), this._super(key, value), "appendTo" === key && this.menuWrap.appendTo(this._appendTo()), "disabled" === key && (this.menuInstance.option("disabled", value), this.button.toggleClass("ui-state-disabled", value).attr("aria-disabled", value), this.element.prop("disabled", value), value ? (this.button.attr("tabindex", -1), this.close()) : this.button.attr("tabindex", 0)), "width" === key && this._resizeButton()
            },_appendTo: function() {
                var element = this.options.appendTo;
                return element && (element = element.jquery || element.nodeType ? $(element) : this.document.find(element).eq(0)), element && element[0] || (element = this.element.closest(".ui-front")), element.length || (element = this.document[0].body), element
            },_toggleAttr: function() {
                this.button.toggleClass("ui-corner-top", this.isOpen).toggleClass("ui-corner-all", !this.isOpen).attr("aria-expanded", this.isOpen), this.menuWrap.toggleClass("ui-selectmenu-open", this.isOpen), this.menu.attr("aria-hidden", !this.isOpen)
            },_resizeButton: function() {
                var width = this.options.width;
                width || (width = this.element.show().outerWidth(), this.element.hide()), this.button.outerWidth(width)
            },_resizeMenu: function() {
                this.menu.outerWidth(Math.max(this.button.outerWidth(), this.menu.width("").outerWidth() + 1))
            },_getCreateOptions: function() {
                return {disabled: this.element.prop("disabled")}
            },_parseOptions: function(options) {
                var data = [];
                options.each(function(index, item) {
                    var option = $(item), optgroup = option.parent("optgroup");
                    data.push({element: option,index: index,value: option.val(),label: option.text(),optgroup: optgroup.attr("label") || "",disabled: optgroup.prop("disabled") || option.prop("disabled")})
                }), this.items = data
            },_destroy: function() {
                this.menuWrap.remove(), this.button.remove(), this.element.show(), this.element.removeUniqueId(), this.label.attr("for", this.ids.element)
            }}), $.widget("ui.slider", $.ui.mouse, {version: "1.11.4",widgetEventPrefix: "slide",options: {animate: !1,distance: 0,max: 100,min: 0,orientation: "horizontal",range: !1,step: 1,value: 0,values: null,change: null,slide: null,start: null,stop: null},numPages: 5,_create: function() {
                this._keySliding = !1, this._mouseSliding = !1, this._animateOff = !0, this._handleIndex = null, this._detectOrientation(), this._mouseInit(), this._calculateNewMax(), this.element.addClass("ui-slider ui-slider-" + this.orientation + " ui-widget ui-widget-content ui-corner-all"), this._refresh(), this._setOption("disabled", this.options.disabled), this._animateOff = !1
            },_refresh: function() {
                this._createRange(), this._createHandles(), this._setupEvents(), this._refreshValue()
            },_createHandles: function() {
                var i, handleCount, options = this.options, existingHandles = this.element.find(".ui-slider-handle").addClass("ui-state-default ui-corner-all"), handle = "<span class='ui-slider-handle ui-state-default ui-corner-all' tabindex='0'></span>", handles = [];
                for (handleCount = options.values && options.values.length || 1, existingHandles.length > handleCount && (existingHandles.slice(handleCount).remove(), existingHandles = existingHandles.slice(0, handleCount)), i = existingHandles.length; handleCount > i; i++)
                    handles.push(handle);
                this.handles = existingHandles.add($(handles.join("")).appendTo(this.element)), this.handle = this.handles.eq(0), this.handles.each(function(i) {
                    $(this).data("ui-slider-handle-index", i)
                })
            },_createRange: function() {
                var options = this.options, classes = "";
                options.range ? (options.range === !0 && (options.values ? options.values.length && 2 !== options.values.length ? options.values = [options.values[0], options.values[0]] : $.isArray(options.values) && (options.values = options.values.slice(0)) : options.values = [this._valueMin(), this._valueMin()]), this.range && this.range.length ? this.range.removeClass("ui-slider-range-min ui-slider-range-max").css({left: "",bottom: ""}) : (this.range = $("<div></div>").appendTo(this.element), classes = "ui-slider-range ui-widget-header ui-corner-all"), this.range.addClass(classes + ("min" === options.range || "max" === options.range ? " ui-slider-range-" + options.range : ""))) : (this.range && this.range.remove(), this.range = null)
            },_setupEvents: function() {
                this._off(this.handles), this._on(this.handles, this._handleEvents), this._hoverable(this.handles), this._focusable(this.handles)
            },_destroy: function() {
                this.handles.remove(), this.range && this.range.remove(), this.element.removeClass("ui-slider ui-slider-horizontal ui-slider-vertical ui-widget ui-widget-content ui-corner-all"), this._mouseDestroy()
            },_mouseCapture: function(event) {
                var position, normValue, distance, closestHandle, index, allowed, offset, mouseOverHandle, that = this, o = this.options;
                return o.disabled ? !1 : (this.elementSize = {width: this.element.outerWidth(),height: this.element.outerHeight()}, this.elementOffset = this.element.offset(), position = {x: event.pageX,y: event.pageY}, normValue = this._normValueFromMouse(position), distance = this._valueMax() - this._valueMin() + 1, this.handles.each(function(i) {
                    var thisDistance = Math.abs(normValue - that.values(i));
                    (distance > thisDistance || distance === thisDistance && (i === that._lastChangedValue || that.values(i) === o.min)) && (distance = thisDistance, closestHandle = $(this), index = i)
                }), allowed = this._start(event, index), allowed === !1 ? !1 : (this._mouseSliding = !0, this._handleIndex = index, closestHandle.addClass("ui-state-active").focus(), offset = closestHandle.offset(), mouseOverHandle = !$(event.target).parents().addBack().is(".ui-slider-handle"), this._clickOffset = mouseOverHandle ? {left: 0,top: 0} : {left: event.pageX - offset.left - closestHandle.width() / 2,top: event.pageY - offset.top - closestHandle.height() / 2 - (parseInt(closestHandle.css("borderTopWidth"), 10) || 0) - (parseInt(closestHandle.css("borderBottomWidth"), 10) || 0) + (parseInt(closestHandle.css("marginTop"), 10) || 0)}, this.handles.hasClass("ui-state-hover") || this._slide(event, index, normValue), this._animateOff = !0, !0))
            },_mouseStart: function() {
                return !0
            },_mouseDrag: function(event) {
                var position = {x: event.pageX,y: event.pageY}, normValue = this._normValueFromMouse(position);
                return this._slide(event, this._handleIndex, normValue), !1
            },_mouseStop: function(event) {
                return this.handles.removeClass("ui-state-active"), this._mouseSliding = !1, this._stop(event, this._handleIndex), this._change(event, this._handleIndex), this._handleIndex = null, this._clickOffset = null, this._animateOff = !1, !1
            },_detectOrientation: function() {
                this.orientation = "vertical" === this.options.orientation ? "vertical" : "horizontal"
            },_normValueFromMouse: function(position) {
                var pixelTotal, pixelMouse, percentMouse, valueTotal, valueMouse;
                return "horizontal" === this.orientation ? (pixelTotal = this.elementSize.width, pixelMouse = position.x - this.elementOffset.left - (this._clickOffset ? this._clickOffset.left : 0)) : (pixelTotal = this.elementSize.height, pixelMouse = position.y - this.elementOffset.top - (this._clickOffset ? this._clickOffset.top : 0)), percentMouse = pixelMouse / pixelTotal, percentMouse > 1 && (percentMouse = 1), 0 > percentMouse && (percentMouse = 0), "vertical" === this.orientation && (percentMouse = 1 - percentMouse), valueTotal = this._valueMax() - this._valueMin(), valueMouse = this._valueMin() + percentMouse * valueTotal, this._trimAlignValue(valueMouse)
            },_start: function(event, index) {
                var uiHash = {handle: this.handles[index],value: this.value()};
                return this.options.values && this.options.values.length && (uiHash.value = this.values(index), uiHash.values = this.values()), this._trigger("start", event, uiHash)
            },_slide: function(event, index, newVal) {
                var otherVal, newValues, allowed;
                this.options.values && this.options.values.length ? (otherVal = this.values(index ? 0 : 1), 2 === this.options.values.length && this.options.range === !0 && (0 === index && newVal > otherVal || 1 === index && otherVal > newVal) && (newVal = otherVal), newVal !== this.values(index) && (newValues = this.values(), newValues[index] = newVal, allowed = this._trigger("slide", event, {handle: this.handles[index],value: newVal,values: newValues}), otherVal = this.values(index ? 0 : 1), allowed !== !1 && this.values(index, newVal))) : newVal !== this.value() && (allowed = this._trigger("slide", event, {handle: this.handles[index],value: newVal}), allowed !== !1 && this.value(newVal))
            },_stop: function(event, index) {
                var uiHash = {handle: this.handles[index],value: this.value()};
                this.options.values && this.options.values.length && (uiHash.value = this.values(index), uiHash.values = this.values()), this._trigger("stop", event, uiHash)
            },_change: function(event, index) {
                if (!this._keySliding && !this._mouseSliding) {
                    var uiHash = {handle: this.handles[index],value: this.value()};
                    this.options.values && this.options.values.length && (uiHash.value = this.values(index), uiHash.values = this.values()), this._lastChangedValue = index, this._trigger("change", event, uiHash)
                }
            },value: function(newValue) {
                return arguments.length ? (this.options.value = this._trimAlignValue(newValue), this._refreshValue(), void this._change(null, 0)) : this._value()
            },values: function(index, newValue) {
                var vals, newValues, i;
                if (arguments.length > 1)
                    return this.options.values[index] = this._trimAlignValue(newValue), this._refreshValue(), void this._change(null, index);
                if (!arguments.length)
                    return this._values();
                if (!$.isArray(arguments[0]))
                    return this.options.values && this.options.values.length ? this._values(index) : this.value();
                for (vals = this.options.values, newValues = arguments[0], i = 0; i < vals.length; i += 1)
                    vals[i] = this._trimAlignValue(newValues[i]), this._change(null, i);
                this._refreshValue()
            },_setOption: function(key, value) {
                var i, valsLength = 0;
                switch ("range" === key && this.options.range === !0 && ("min" === value ? (this.options.value = this._values(0), this.options.values = null) : "max" === value && (this.options.value = this._values(this.options.values.length - 1), this.options.values = null)), $.isArray(this.options.values) && (valsLength = this.options.values.length), "disabled" === key && this.element.toggleClass("ui-state-disabled", !!value), this._super(key, value), key) {
                    case "orientation":
                        this._detectOrientation(), this.element.removeClass("ui-slider-horizontal ui-slider-vertical").addClass("ui-slider-" + this.orientation), this._refreshValue(), this.handles.css("horizontal" === value ? "bottom" : "left", "");
                        break;
                    case "value":
                        this._animateOff = !0, this._refreshValue(), this._change(null, 0), this._animateOff = !1;
                        break;
                    case "values":
                        for (this._animateOff = !0, this._refreshValue(), i = 0; valsLength > i; i += 1)
                            this._change(null, i);
                        this._animateOff = !1;
                        break;
                    case "step":
                    case "min":
                    case "max":
                        this._animateOff = !0, this._calculateNewMax(), this._refreshValue(), this._animateOff = !1;
                        break;
                    case "range":
                        this._animateOff = !0, this._refresh(), this._animateOff = !1
                }
            },_value: function() {
                var val = this.options.value;
                return val = this._trimAlignValue(val)
            },_values: function(index) {
                var val, vals, i;
                if (arguments.length)
                    return val = this.options.values[index], val = this._trimAlignValue(val);
                if (this.options.values && this.options.values.length) {
                    for (vals = this.options.values.slice(), i = 0; i < vals.length; i += 1)
                        vals[i] = this._trimAlignValue(vals[i]);
                    return vals
                }
                return []
            },_trimAlignValue: function(val) {
                if (val <= this._valueMin())
                    return this._valueMin();
                if (val >= this._valueMax())
                    return this._valueMax();
                var step = this.options.step > 0 ? this.options.step : 1, valModStep = (val - this._valueMin()) % step, alignValue = val - valModStep;
                return 2 * Math.abs(valModStep) >= step && (alignValue += valModStep > 0 ? step : -step), parseFloat(alignValue.toFixed(5))
            },_calculateNewMax: function() {
                var max = this.options.max, min = this._valueMin(), step = this.options.step, aboveMin = Math.floor(+(max - min).toFixed(this._precision()) / step) * step;
                max = aboveMin + min, this.max = parseFloat(max.toFixed(this._precision()))
            },_precision: function() {
                var precision = this._precisionOf(this.options.step);
                return null !== this.options.min && (precision = Math.max(precision, this._precisionOf(this.options.min))), precision
            },_precisionOf: function(num) {
                var str = num.toString(), decimal = str.indexOf(".");
                return -1 === decimal ? 0 : str.length - decimal - 1
            },_valueMin: function() {
                return this.options.min
            },_valueMax: function() {
                return this.max
            },_refreshValue: function() {
                var lastValPercent, valPercent, value, valueMin, valueMax, oRange = this.options.range, o = this.options, that = this, animate = this._animateOff ? !1 : o.animate, _set = {};
                this.options.values && this.options.values.length ? this.handles.each(function(i) {
                    valPercent = (that.values(i) - that._valueMin()) / (that._valueMax() - that._valueMin()) * 100, _set["horizontal" === that.orientation ? "left" : "bottom"] = valPercent + "%", $(this).stop(1, 1)[animate ? "animate" : "css"](_set, o.animate), that.options.range === !0 && ("horizontal" === that.orientation ? (0 === i && that.range.stop(1, 1)[animate ? "animate" : "css"]({left: valPercent + "%"}, o.animate), 1 === i && that.range[animate ? "animate" : "css"]({width: valPercent - lastValPercent + "%"}, {queue: !1,duration: o.animate})) : (0 === i && that.range.stop(1, 1)[animate ? "animate" : "css"]({bottom: valPercent + "%"}, o.animate), 1 === i && that.range[animate ? "animate" : "css"]({height: valPercent - lastValPercent + "%"}, {queue: !1,duration: o.animate}))), lastValPercent = valPercent
                }) : (value = this.value(), valueMin = this._valueMin(), valueMax = this._valueMax(), valPercent = valueMax !== valueMin ? (value - valueMin) / (valueMax - valueMin) * 100 : 0, _set["horizontal" === this.orientation ? "left" : "bottom"] = valPercent + "%", this.handle.stop(1, 1)[animate ? "animate" : "css"](_set, o.animate), "min" === oRange && "horizontal" === this.orientation && this.range.stop(1, 1)[animate ? "animate" : "css"]({width: valPercent + "%"}, o.animate), "max" === oRange && "horizontal" === this.orientation && this.range[animate ? "animate" : "css"]({width: 100 - valPercent + "%"}, {queue: !1,duration: o.animate}), "min" === oRange && "vertical" === this.orientation && this.range.stop(1, 1)[animate ? "animate" : "css"]({height: valPercent + "%"}, o.animate), "max" === oRange && "vertical" === this.orientation && this.range[animate ? "animate" : "css"]({height: 100 - valPercent + "%"}, {queue: !1,duration: o.animate}))
            },_handleEvents: {keydown: function(event) {
                    var allowed, curVal, newVal, step, index = $(event.target).data("ui-slider-handle-index");
                    switch (event.keyCode) {
                        case $.ui.keyCode.HOME:
                        case $.ui.keyCode.END:
                        case $.ui.keyCode.PAGE_UP:
                        case $.ui.keyCode.PAGE_DOWN:
                        case $.ui.keyCode.UP:
                        case $.ui.keyCode.RIGHT:
                        case $.ui.keyCode.DOWN:
                        case $.ui.keyCode.LEFT:
                            if (event.preventDefault(), !this._keySliding && (this._keySliding = !0, $(event.target).addClass("ui-state-active"), allowed = this._start(event, index), allowed === !1))
                                return
                    }
                    switch (step = this.options.step, curVal = newVal = this.options.values && this.options.values.length ? this.values(index) : this.value(), event.keyCode) {
                        case $.ui.keyCode.HOME:
                            newVal = this._valueMin();
                            break;
                        case $.ui.keyCode.END:
                            newVal = this._valueMax();
                            break;
                        case $.ui.keyCode.PAGE_UP:
                            newVal = this._trimAlignValue(curVal + (this._valueMax() - this._valueMin()) / this.numPages);
                            break;
                        case $.ui.keyCode.PAGE_DOWN:
                            newVal = this._trimAlignValue(curVal - (this._valueMax() - this._valueMin()) / this.numPages);
                            break;
                        case $.ui.keyCode.UP:
                        case $.ui.keyCode.RIGHT:
                            if (curVal === this._valueMax())
                                return;
                            newVal = this._trimAlignValue(curVal + step);
                            break;
                        case $.ui.keyCode.DOWN:
                        case $.ui.keyCode.LEFT:
                            if (curVal === this._valueMin())
                                return;
                            newVal = this._trimAlignValue(curVal - step)
                    }
                    this._slide(event, index, newVal)
                },keyup: function(event) {
                    var index = $(event.target).data("ui-slider-handle-index");
                    this._keySliding && (this._keySliding = !1, this._stop(event, index), this._change(event, index), $(event.target).removeClass("ui-state-active"))
                }}}), $.widget("ui.sortable", $.ui.mouse, {version: "1.11.4",widgetEventPrefix: "sort",ready: !1,options: {appendTo: "parent",axis: !1,connectWith: !1,containment: !1,cursor: "auto",cursorAt: !1,dropOnEmpty: !0,forcePlaceholderSize: !1,forceHelperSize: !1,grid: !1,handle: !1,helper: "original",items: "> *",opacity: !1,placeholder: !1,revert: !1,scroll: !0,scrollSensitivity: 20,scrollSpeed: 20,scope: "default",tolerance: "intersect",zIndex: 1e3,activate: null,beforeStop: null,change: null,deactivate: null,out: null,over: null,receive: null,remove: null,sort: null,start: null,stop: null,update: null},_isOverAxis: function(x, reference, size) {
                return x >= reference && reference + size > x
            },_isFloating: function(item) {
                return /left|right/.test(item.css("float")) || /inline|table-cell/.test(item.css("display"))
            },_create: function() {
                this.containerCache = {}, this.element.addClass("ui-sortable"), this.refresh(), this.offset = this.element.offset(), this._mouseInit(), this._setHandleClassName(), this.ready = !0
            },_setOption: function(key, value) {
                this._super(key, value), "handle" === key && this._setHandleClassName()
            },_setHandleClassName: function() {
                this.element.find(".ui-sortable-handle").removeClass("ui-sortable-handle"), $.each(this.items, function() {
                    (this.instance.options.handle ? this.item.find(this.instance.options.handle) : this.item).addClass("ui-sortable-handle")
                })
            },_destroy: function() {
                this.element.removeClass("ui-sortable ui-sortable-disabled").find(".ui-sortable-handle").removeClass("ui-sortable-handle"), this._mouseDestroy();
                for (var i = this.items.length - 1; i >= 0; i--)
                    this.items[i].item.removeData(this.widgetName + "-item");
                return this
            },_mouseCapture: function(event, overrideHandle) {
                var currentItem = null, validHandle = !1, that = this;
                return this.reverting ? !1 : this.options.disabled || "static" === this.options.type ? !1 : (this._refreshItems(event), $(event.target).parents().each(function() {
                    return $.data(this, that.widgetName + "-item") === that ? (currentItem = $(this), !1) : void 0
                }), $.data(event.target, that.widgetName + "-item") === that && (currentItem = $(event.target)), currentItem && (!this.options.handle || overrideHandle || ($(this.options.handle, currentItem).find("*").addBack().each(function() {
                    this === event.target && (validHandle = !0)
                }), validHandle)) ? (this.currentItem = currentItem, this._removeCurrentsFromItems(), 
                !0) : !1)
            },_mouseStart: function(event, overrideHandle, noActivation) {
                var i, body, o = this.options;
                if (this.currentContainer = this, this.refreshPositions(), this.helper = this._createHelper(event), this._cacheHelperProportions(), this._cacheMargins(), this.scrollParent = this.helper.scrollParent(), this.offset = this.currentItem.offset(), this.offset = {top: this.offset.top - this.margins.top,left: this.offset.left - this.margins.left}, $.extend(this.offset, {click: {left: event.pageX - this.offset.left,top: event.pageY - this.offset.top},parent: this._getParentOffset(),relative: this._getRelativeOffset()}), this.helper.css("position", "absolute"), this.cssPosition = this.helper.css("position"), this.originalPosition = this._generatePosition(event), this.originalPageX = event.pageX, this.originalPageY = event.pageY, o.cursorAt && this._adjustOffsetFromHelper(o.cursorAt), this.domPosition = {prev: this.currentItem.prev()[0],parent: this.currentItem.parent()[0]}, this.helper[0] !== this.currentItem[0] && this.currentItem.hide(), this._createPlaceholder(), o.containment && this._setContainment(), o.cursor && "auto" !== o.cursor && (body = this.document.find("body"), this.storedCursor = body.css("cursor"), body.css("cursor", o.cursor), this.storedStylesheet = $("<style>*{ cursor: " + o.cursor + " !important; }</style>").appendTo(body)), o.opacity && (this.helper.css("opacity") && (this._storedOpacity = this.helper.css("opacity")), this.helper.css("opacity", o.opacity)), o.zIndex && (this.helper.css("zIndex") && (this._storedZIndex = this.helper.css("zIndex")), this.helper.css("zIndex", o.zIndex)), this.scrollParent[0] !== this.document[0] && "HTML" !== this.scrollParent[0].tagName && (this.overflowOffset = this.scrollParent.offset()), this._trigger("start", event, this._uiHash()), this._preserveHelperProportions || this._cacheHelperProportions(), !noActivation)
                    for (i = this.containers.length - 1; i >= 0; i--)
                        this.containers[i]._trigger("activate", event, this._uiHash(this));
                return $.ui.ddmanager && ($.ui.ddmanager.current = this), $.ui.ddmanager && !o.dropBehaviour && $.ui.ddmanager.prepareOffsets(this, event), this.dragging = !0, this.helper.addClass("ui-sortable-helper"), this._mouseDrag(event), !0
            },_mouseDrag: function(event) {
                var i, item, itemElement, intersection, o = this.options, scrolled = !1;
                for (this.position = this._generatePosition(event), this.positionAbs = this._convertPositionTo("absolute"), this.lastPositionAbs || (this.lastPositionAbs = this.positionAbs), this.options.scroll && (this.scrollParent[0] !== this.document[0] && "HTML" !== this.scrollParent[0].tagName ? (this.overflowOffset.top + this.scrollParent[0].offsetHeight - event.pageY < o.scrollSensitivity ? this.scrollParent[0].scrollTop = scrolled = this.scrollParent[0].scrollTop + o.scrollSpeed : event.pageY - this.overflowOffset.top < o.scrollSensitivity && (this.scrollParent[0].scrollTop = scrolled = this.scrollParent[0].scrollTop - o.scrollSpeed), this.overflowOffset.left + this.scrollParent[0].offsetWidth - event.pageX < o.scrollSensitivity ? this.scrollParent[0].scrollLeft = scrolled = this.scrollParent[0].scrollLeft + o.scrollSpeed : event.pageX - this.overflowOffset.left < o.scrollSensitivity && (this.scrollParent[0].scrollLeft = scrolled = this.scrollParent[0].scrollLeft - o.scrollSpeed)) : (event.pageY - this.document.scrollTop() < o.scrollSensitivity ? scrolled = this.document.scrollTop(this.document.scrollTop() - o.scrollSpeed) : this.window.height() - (event.pageY - this.document.scrollTop()) < o.scrollSensitivity && (scrolled = this.document.scrollTop(this.document.scrollTop() + o.scrollSpeed)), event.pageX - this.document.scrollLeft() < o.scrollSensitivity ? scrolled = this.document.scrollLeft(this.document.scrollLeft() - o.scrollSpeed) : this.window.width() - (event.pageX - this.document.scrollLeft()) < o.scrollSensitivity && (scrolled = this.document.scrollLeft(this.document.scrollLeft() + o.scrollSpeed))), scrolled !== !1 && $.ui.ddmanager && !o.dropBehaviour && $.ui.ddmanager.prepareOffsets(this, event)), this.positionAbs = this._convertPositionTo("absolute"), this.options.axis && "y" === this.options.axis || (this.helper[0].style.left = this.position.left + "px"), this.options.axis && "x" === this.options.axis || (this.helper[0].style.top = this.position.top + "px"), i = this.items.length - 1; i >= 0; i--)
                    if (item = this.items[i], itemElement = item.item[0], intersection = this._intersectsWithPointer(item), intersection && item.instance === this.currentContainer && itemElement !== this.currentItem[0] && this.placeholder[1 === intersection ? "next" : "prev"]()[0] !== itemElement && !$.contains(this.placeholder[0], itemElement) && ("semi-dynamic" === this.options.type ? !$.contains(this.element[0], itemElement) : !0)) {
                        if (this.direction = 1 === intersection ? "down" : "up", "pointer" !== this.options.tolerance && !this._intersectsWithSides(item))
                            break;
                        this._rearrange(event, item), this._trigger("change", event, this._uiHash());
                        break
                    }
                return this._contactContainers(event), $.ui.ddmanager && $.ui.ddmanager.drag(this, event), this._trigger("sort", event, this._uiHash()), this.lastPositionAbs = this.positionAbs, !1
            },_mouseStop: function(event, noPropagation) {
                if (event) {
                    if ($.ui.ddmanager && !this.options.dropBehaviour && $.ui.ddmanager.drop(this, event), this.options.revert) {
                        var that = this, cur = this.placeholder.offset(), axis = this.options.axis, animation = {};
                        axis && "x" !== axis || (animation.left = cur.left - this.offset.parent.left - this.margins.left + (this.offsetParent[0] === this.document[0].body ? 0 : this.offsetParent[0].scrollLeft)), axis && "y" !== axis || (animation.top = cur.top - this.offset.parent.top - this.margins.top + (this.offsetParent[0] === this.document[0].body ? 0 : this.offsetParent[0].scrollTop)), this.reverting = !0, $(this.helper).animate(animation, parseInt(this.options.revert, 10) || 500, function() {
                            that._clear(event)
                        })
                    } else
                        this._clear(event, noPropagation);
                    return !1
                }
            },cancel: function() {
                if (this.dragging) {
                    this._mouseUp({target: null}), "original" === this.options.helper ? this.currentItem.css(this._storedCSS).removeClass("ui-sortable-helper") : this.currentItem.show();
                    for (var i = this.containers.length - 1; i >= 0; i--)
                        this.containers[i]._trigger("deactivate", null, this._uiHash(this)), this.containers[i].containerCache.over && (this.containers[i]._trigger("out", null, this._uiHash(this)), this.containers[i].containerCache.over = 0)
                }
                return this.placeholder && (this.placeholder[0].parentNode && this.placeholder[0].parentNode.removeChild(this.placeholder[0]), "original" !== this.options.helper && this.helper && this.helper[0].parentNode && this.helper.remove(), $.extend(this, {helper: null,dragging: !1,reverting: !1,_noFinalSort: null}), this.domPosition.prev ? $(this.domPosition.prev).after(this.currentItem) : $(this.domPosition.parent).prepend(this.currentItem)), this
            },serialize: function(o) {
                var items = this._getItemsAsjQuery(o && o.connected), str = [];
                return o = o || {}, $(items).each(function() {
                    var res = ($(o.item || this).attr(o.attribute || "id") || "").match(o.expression || /(.+)[\-=_](.+)/);
                    res && str.push((o.key || res[1] + "[]") + "=" + (o.key && o.expression ? res[1] : res[2]))
                }), !str.length && o.key && str.push(o.key + "="), str.join("&")
            },toArray: function(o) {
                var items = this._getItemsAsjQuery(o && o.connected), ret = [];
                return o = o || {}, items.each(function() {
                    ret.push($(o.item || this).attr(o.attribute || "id") || "")
                }), ret
            },_intersectsWith: function(item) {
                var x1 = this.positionAbs.left, x2 = x1 + this.helperProportions.width, y1 = this.positionAbs.top, y2 = y1 + this.helperProportions.height, l = item.left, r = l + item.width, t = item.top, b = t + item.height, dyClick = this.offset.click.top, dxClick = this.offset.click.left, isOverElementHeight = "x" === this.options.axis || y1 + dyClick > t && b > y1 + dyClick, isOverElementWidth = "y" === this.options.axis || x1 + dxClick > l && r > x1 + dxClick, isOverElement = isOverElementHeight && isOverElementWidth;
                return "pointer" === this.options.tolerance || this.options.forcePointerForContainers || "pointer" !== this.options.tolerance && this.helperProportions[this.floating ? "width" : "height"] > item[this.floating ? "width" : "height"] ? isOverElement : l < x1 + this.helperProportions.width / 2 && x2 - this.helperProportions.width / 2 < r && t < y1 + this.helperProportions.height / 2 && y2 - this.helperProportions.height / 2 < b
            },_intersectsWithPointer: function(item) {
                var isOverElementHeight = "x" === this.options.axis || this._isOverAxis(this.positionAbs.top + this.offset.click.top, item.top, item.height), isOverElementWidth = "y" === this.options.axis || this._isOverAxis(this.positionAbs.left + this.offset.click.left, item.left, item.width), isOverElement = isOverElementHeight && isOverElementWidth, verticalDirection = this._getDragVerticalDirection(), horizontalDirection = this._getDragHorizontalDirection();
                return isOverElement ? this.floating ? horizontalDirection && "right" === horizontalDirection || "down" === verticalDirection ? 2 : 1 : verticalDirection && ("down" === verticalDirection ? 2 : 1) : !1
            },_intersectsWithSides: function(item) {
                var isOverBottomHalf = this._isOverAxis(this.positionAbs.top + this.offset.click.top, item.top + item.height / 2, item.height), isOverRightHalf = this._isOverAxis(this.positionAbs.left + this.offset.click.left, item.left + item.width / 2, item.width), verticalDirection = this._getDragVerticalDirection(), horizontalDirection = this._getDragHorizontalDirection();
                return this.floating && horizontalDirection ? "right" === horizontalDirection && isOverRightHalf || "left" === horizontalDirection && !isOverRightHalf : verticalDirection && ("down" === verticalDirection && isOverBottomHalf || "up" === verticalDirection && !isOverBottomHalf)
            },_getDragVerticalDirection: function() {
                var delta = this.positionAbs.top - this.lastPositionAbs.top;
                return 0 !== delta && (delta > 0 ? "down" : "up")
            },_getDragHorizontalDirection: function() {
                var delta = this.positionAbs.left - this.lastPositionAbs.left;
                return 0 !== delta && (delta > 0 ? "right" : "left")
            },refresh: function(event) {
                return this._refreshItems(event), this._setHandleClassName(), this.refreshPositions(), this
            },_connectWith: function() {
                var options = this.options;
                return options.connectWith.constructor === String ? [options.connectWith] : options.connectWith
            },_getItemsAsjQuery: function(connected) {
                function addItems() {
                    items.push(this)
                }
                var i, j, cur, inst, items = [], queries = [], connectWith = this._connectWith();
                if (connectWith && connected)
                    for (i = connectWith.length - 1; i >= 0; i--)
                        for (cur = $(connectWith[i], this.document[0]), j = cur.length - 1; j >= 0; j--)
                            inst = $.data(cur[j], this.widgetFullName), inst && inst !== this && !inst.options.disabled && queries.push([$.isFunction(inst.options.items) ? inst.options.items.call(inst.element) : $(inst.options.items, inst.element).not(".ui-sortable-helper").not(".ui-sortable-placeholder"), inst]);
                for (queries.push([$.isFunction(this.options.items) ? this.options.items.call(this.element, null, {options: this.options,item: this.currentItem}) : $(this.options.items, this.element).not(".ui-sortable-helper").not(".ui-sortable-placeholder"), this]), i = queries.length - 1; i >= 0; i--)
                    queries[i][0].each(addItems);
                return $(items)
            },_removeCurrentsFromItems: function() {
                var list = this.currentItem.find(":data(" + this.widgetName + "-item)");
                this.items = $.grep(this.items, function(item) {
                    for (var j = 0; j < list.length; j++)
                        if (list[j] === item.item[0])
                            return !1;
                    return !0
                })
            },_refreshItems: function(event) {
                this.items = [], this.containers = [this];
                var i, j, cur, inst, targetData, _queries, item, queriesLength, items = this.items, queries = [[$.isFunction(this.options.items) ? this.options.items.call(this.element[0], event, {item: this.currentItem}) : $(this.options.items, this.element), this]], connectWith = this._connectWith();
                if (connectWith && this.ready)
                    for (i = connectWith.length - 1; i >= 0; i--)
                        for (cur = $(connectWith[i], this.document[0]), j = cur.length - 1; j >= 0; j--)
                            inst = $.data(cur[j], this.widgetFullName), inst && inst !== this && !inst.options.disabled && (queries.push([$.isFunction(inst.options.items) ? inst.options.items.call(inst.element[0], event, {item: this.currentItem}) : $(inst.options.items, inst.element), inst]), this.containers.push(inst));
                for (i = queries.length - 1; i >= 0; i--)
                    for (targetData = queries[i][1], _queries = queries[i][0], j = 0, queriesLength = _queries.length; queriesLength > j; j++)
                        item = $(_queries[j]), item.data(this.widgetName + "-item", targetData), items.push({item: item,instance: targetData,width: 0,height: 0,left: 0,top: 0})
            },refreshPositions: function(fast) {
                this.floating = this.items.length ? "x" === this.options.axis || this._isFloating(this.items[0].item) : !1, this.offsetParent && this.helper && (this.offset.parent = this._getParentOffset());
                var i, item, t, p;
                for (i = this.items.length - 1; i >= 0; i--)
                    item = this.items[i], item.instance !== this.currentContainer && this.currentContainer && item.item[0] !== this.currentItem[0] || (t = this.options.toleranceElement ? $(this.options.toleranceElement, item.item) : item.item, fast || (item.width = t.outerWidth(), item.height = t.outerHeight()), p = t.offset(), item.left = p.left, item.top = p.top);
                if (this.options.custom && this.options.custom.refreshContainers)
                    this.options.custom.refreshContainers.call(this);
                else
                    for (i = this.containers.length - 1; i >= 0; i--)
                        p = this.containers[i].element.offset(), this.containers[i].containerCache.left = p.left, this.containers[i].containerCache.top = p.top, this.containers[i].containerCache.width = this.containers[i].element.outerWidth(), this.containers[i].containerCache.height = this.containers[i].element.outerHeight();
                return this
            },_createPlaceholder: function(that) {
                that = that || this;
                var className, o = that.options;
                o.placeholder && o.placeholder.constructor !== String || (className = o.placeholder, o.placeholder = {element: function() {
                        var nodeName = that.currentItem[0].nodeName.toLowerCase(), element = $("<" + nodeName + ">", that.document[0]).addClass(className || that.currentItem[0].className + " ui-sortable-placeholder").removeClass("ui-sortable-helper");
                        return "tbody" === nodeName ? that._createTrPlaceholder(that.currentItem.find("tr").eq(0), $("<tr>", that.document[0]).appendTo(element)) : "tr" === nodeName ? that._createTrPlaceholder(that.currentItem, element) : "img" === nodeName && element.attr("src", that.currentItem.attr("src")), className || element.css("visibility", "hidden"), element
                    },update: function(container, p) {
                        (!className || o.forcePlaceholderSize) && (p.height() || p.height(that.currentItem.innerHeight() - parseInt(that.currentItem.css("paddingTop") || 0, 10) - parseInt(that.currentItem.css("paddingBottom") || 0, 10)), p.width() || p.width(that.currentItem.innerWidth() - parseInt(that.currentItem.css("paddingLeft") || 0, 10) - parseInt(that.currentItem.css("paddingRight") || 0, 10)))
                    }}), that.placeholder = $(o.placeholder.element.call(that.element, that.currentItem)), that.currentItem.after(that.placeholder), o.placeholder.update(that, that.placeholder)
            },_createTrPlaceholder: function(sourceTr, targetTr) {
                var that = this;
                sourceTr.children().each(function() {
                    $("<td>&#160;</td>", that.document[0]).attr("colspan", $(this).attr("colspan") || 1).appendTo(targetTr)
                })
            },_contactContainers: function(event) {
                var i, j, dist, itemWithLeastDistance, posProperty, sizeProperty, cur, nearBottom, floating, axis, innermostContainer = null, innermostIndex = null;
                for (i = this.containers.length - 1; i >= 0; i--)
                    if (!$.contains(this.currentItem[0], this.containers[i].element[0]))
                        if (this._intersectsWith(this.containers[i].containerCache)) {
                            if (innermostContainer && $.contains(this.containers[i].element[0], innermostContainer.element[0]))
                                continue;
                            innermostContainer = this.containers[i], innermostIndex = i
                        } else
                            this.containers[i].containerCache.over && (this.containers[i]._trigger("out", event, this._uiHash(this)), this.containers[i].containerCache.over = 0);
                if (innermostContainer)
                    if (1 === this.containers.length)
                        this.containers[innermostIndex].containerCache.over || (this.containers[innermostIndex]._trigger("over", event, this._uiHash(this)), this.containers[innermostIndex].containerCache.over = 1);
                    else {
                        for (dist = 1e4, itemWithLeastDistance = null, floating = innermostContainer.floating || this._isFloating(this.currentItem), posProperty = floating ? "left" : "top", sizeProperty = floating ? "width" : "height", axis = floating ? "clientX" : "clientY", j = this.items.length - 1; j >= 0; j--)
                            $.contains(this.containers[innermostIndex].element[0], this.items[j].item[0]) && this.items[j].item[0] !== this.currentItem[0] && (cur = this.items[j].item.offset()[posProperty], nearBottom = !1, event[axis] - cur > this.items[j][sizeProperty] / 2 && (nearBottom = !0), Math.abs(event[axis] - cur) < dist && (dist = Math.abs(event[axis] - cur), itemWithLeastDistance = this.items[j], this.direction = nearBottom ? "up" : "down"));
                        if (!itemWithLeastDistance && !this.options.dropOnEmpty)
                            return;
                        if (this.currentContainer === this.containers[innermostIndex])
                            return void (this.currentContainer.containerCache.over || (this.containers[innermostIndex]._trigger("over", event, this._uiHash()), this.currentContainer.containerCache.over = 1));
                        itemWithLeastDistance ? this._rearrange(event, itemWithLeastDistance, null, !0) : this._rearrange(event, null, this.containers[innermostIndex].element, !0), this._trigger("change", event, this._uiHash()), this.containers[innermostIndex]._trigger("change", event, this._uiHash(this)), this.currentContainer = this.containers[innermostIndex], this.options.placeholder.update(this.currentContainer, this.placeholder), this.containers[innermostIndex]._trigger("over", event, this._uiHash(this)), this.containers[innermostIndex].containerCache.over = 1
                    }
            },_createHelper: function(event) {
                var o = this.options, helper = $.isFunction(o.helper) ? $(o.helper.apply(this.element[0], [event, this.currentItem])) : "clone" === o.helper ? this.currentItem.clone() : this.currentItem;
                return helper.parents("body").length || $("parent" !== o.appendTo ? o.appendTo : this.currentItem[0].parentNode)[0].appendChild(helper[0]), helper[0] === this.currentItem[0] && (this._storedCSS = {width: this.currentItem[0].style.width,height: this.currentItem[0].style.height,position: this.currentItem.css("position"),top: this.currentItem.css("top"),left: this.currentItem.css("left")}), (!helper[0].style.width || o.forceHelperSize) && helper.width(this.currentItem.width()), (!helper[0].style.height || o.forceHelperSize) && helper.height(this.currentItem.height()), helper
            },_adjustOffsetFromHelper: function(obj) {
                "string" == typeof obj && (obj = obj.split(" ")), $.isArray(obj) && (obj = {left: +obj[0],top: +obj[1] || 0}), "left" in obj && (this.offset.click.left = obj.left + this.margins.left), "right" in obj && (this.offset.click.left = this.helperProportions.width - obj.right + this.margins.left), "top" in obj && (this.offset.click.top = obj.top + this.margins.top), "bottom" in obj && (this.offset.click.top = this.helperProportions.height - obj.bottom + this.margins.top)
            },_getParentOffset: function() {
                this.offsetParent = this.helper.offsetParent();
                var po = this.offsetParent.offset();
                return "absolute" === this.cssPosition && this.scrollParent[0] !== this.document[0] && $.contains(this.scrollParent[0], this.offsetParent[0]) && (po.left += this.scrollParent.scrollLeft(), po.top += this.scrollParent.scrollTop()), (this.offsetParent[0] === this.document[0].body || this.offsetParent[0].tagName && "html" === this.offsetParent[0].tagName.toLowerCase() && $.ui.ie) && (po = {top: 0,left: 0}), {top: po.top + (parseInt(this.offsetParent.css("borderTopWidth"), 10) || 0),left: po.left + (parseInt(this.offsetParent.css("borderLeftWidth"), 10) || 0)}
            },_getRelativeOffset: function() {
                if ("relative" === this.cssPosition) {
                    var p = this.currentItem.position();
                    return {top: p.top - (parseInt(this.helper.css("top"), 10) || 0) + this.scrollParent.scrollTop(),left: p.left - (parseInt(this.helper.css("left"), 10) || 0) + this.scrollParent.scrollLeft()}
                }
                return {top: 0,left: 0}
            },_cacheMargins: function() {
                this.margins = {left: parseInt(this.currentItem.css("marginLeft"), 10) || 0,top: parseInt(this.currentItem.css("marginTop"), 10) || 0}
            },_cacheHelperProportions: function() {
                this.helperProportions = {width: this.helper.outerWidth(),height: this.helper.outerHeight()}
            },_setContainment: function() {
                var ce, co, over, o = this.options;
                "parent" === o.containment && (o.containment = this.helper[0].parentNode), ("document" === o.containment || "window" === o.containment) && (this.containment = [0 - this.offset.relative.left - this.offset.parent.left, 0 - this.offset.relative.top - this.offset.parent.top, "document" === o.containment ? this.document.width() : this.window.width() - this.helperProportions.width - this.margins.left, ("document" === o.containment ? this.document.width() : this.window.height() || this.document[0].body.parentNode.scrollHeight) - this.helperProportions.height - this.margins.top]), /^(document|window|parent)$/.test(o.containment) || (ce = $(o.containment)[0], co = $(o.containment).offset(), over = "hidden" !== $(ce).css("overflow"), this.containment = [co.left + (parseInt($(ce).css("borderLeftWidth"), 10) || 0) + (parseInt($(ce).css("paddingLeft"), 10) || 0) - this.margins.left, co.top + (parseInt($(ce).css("borderTopWidth"), 10) || 0) + (parseInt($(ce).css("paddingTop"), 10) || 0) - this.margins.top, co.left + (over ? Math.max(ce.scrollWidth, ce.offsetWidth) : ce.offsetWidth) - (parseInt($(ce).css("borderLeftWidth"), 10) || 0) - (parseInt($(ce).css("paddingRight"), 10) || 0) - this.helperProportions.width - this.margins.left, co.top + (over ? Math.max(ce.scrollHeight, ce.offsetHeight) : ce.offsetHeight) - (parseInt($(ce).css("borderTopWidth"), 10) || 0) - (parseInt($(ce).css("paddingBottom"), 10) || 0) - this.helperProportions.height - this.margins.top])
            },_convertPositionTo: function(d, pos) {
                pos || (pos = this.position);
                var mod = "absolute" === d ? 1 : -1, scroll = "absolute" !== this.cssPosition || this.scrollParent[0] !== this.document[0] && $.contains(this.scrollParent[0], this.offsetParent[0]) ? this.scrollParent : this.offsetParent, scrollIsRootNode = /(html|body)/i.test(scroll[0].tagName);
                return {top: pos.top + this.offset.relative.top * mod + this.offset.parent.top * mod - ("fixed" === this.cssPosition ? -this.scrollParent.scrollTop() : scrollIsRootNode ? 0 : scroll.scrollTop()) * mod,left: pos.left + this.offset.relative.left * mod + this.offset.parent.left * mod - ("fixed" === this.cssPosition ? -this.scrollParent.scrollLeft() : scrollIsRootNode ? 0 : scroll.scrollLeft()) * mod}
            },_generatePosition: function(event) {
                var top, left, o = this.options, pageX = event.pageX, pageY = event.pageY, scroll = "absolute" !== this.cssPosition || this.scrollParent[0] !== this.document[0] && $.contains(this.scrollParent[0], this.offsetParent[0]) ? this.scrollParent : this.offsetParent, scrollIsRootNode = /(html|body)/i.test(scroll[0].tagName);
                return "relative" !== this.cssPosition || this.scrollParent[0] !== this.document[0] && this.scrollParent[0] !== this.offsetParent[0] || (this.offset.relative = this._getRelativeOffset()), this.originalPosition && (this.containment && (event.pageX - this.offset.click.left < this.containment[0] && (pageX = this.containment[0] + this.offset.click.left), event.pageY - this.offset.click.top < this.containment[1] && (pageY = this.containment[1] + this.offset.click.top), event.pageX - this.offset.click.left > this.containment[2] && (pageX = this.containment[2] + this.offset.click.left), event.pageY - this.offset.click.top > this.containment[3] && (pageY = this.containment[3] + this.offset.click.top)), o.grid && (top = this.originalPageY + Math.round((pageY - this.originalPageY) / o.grid[1]) * o.grid[1], pageY = this.containment ? top - this.offset.click.top >= this.containment[1] && top - this.offset.click.top <= this.containment[3] ? top : top - this.offset.click.top >= this.containment[1] ? top - o.grid[1] : top + o.grid[1] : top, left = this.originalPageX + Math.round((pageX - this.originalPageX) / o.grid[0]) * o.grid[0], pageX = this.containment ? left - this.offset.click.left >= this.containment[0] && left - this.offset.click.left <= this.containment[2] ? left : left - this.offset.click.left >= this.containment[0] ? left - o.grid[0] : left + o.grid[0] : left)), {top: pageY - this.offset.click.top - this.offset.relative.top - this.offset.parent.top + ("fixed" === this.cssPosition ? -this.scrollParent.scrollTop() : scrollIsRootNode ? 0 : scroll.scrollTop()),left: pageX - this.offset.click.left - this.offset.relative.left - this.offset.parent.left + ("fixed" === this.cssPosition ? -this.scrollParent.scrollLeft() : scrollIsRootNode ? 0 : scroll.scrollLeft())}
            },_rearrange: function(event, i, a, hardRefresh) {
                a ? a[0].appendChild(this.placeholder[0]) : i.item[0].parentNode.insertBefore(this.placeholder[0], "down" === this.direction ? i.item[0] : i.item[0].nextSibling), this.counter = this.counter ? ++this.counter : 1;
                var counter = this.counter;
                this._delay(function() {
                    counter === this.counter && this.refreshPositions(!hardRefresh)
                })
            },_clear: function(event, noPropagation) {
                function delayEvent(type, instance, container) {
                    return function(event) {
                        container._trigger(type, event, instance._uiHash(instance))
                    }
                }
                this.reverting = !1;
                var i, delayedTriggers = [];
                if (!this._noFinalSort && this.currentItem.parent().length && this.placeholder.before(this.currentItem), this._noFinalSort = null, this.helper[0] === this.currentItem[0]) {
                    for (i in this._storedCSS)
                        ("auto" === this._storedCSS[i] || "static" === this._storedCSS[i]) && (this._storedCSS[i] = "");
                    this.currentItem.css(this._storedCSS).removeClass("ui-sortable-helper")
                } else
                    this.currentItem.show();
                for (this.fromOutside && !noPropagation && delayedTriggers.push(function(event) {
                    this._trigger("receive", event, this._uiHash(this.fromOutside))
                }), !this.fromOutside && this.domPosition.prev === this.currentItem.prev().not(".ui-sortable-helper")[0] && this.domPosition.parent === this.currentItem.parent()[0] || noPropagation || delayedTriggers.push(function(event) {
                    this._trigger("update", event, this._uiHash())
                }), this !== this.currentContainer && (noPropagation || (delayedTriggers.push(function(event) {
                    this._trigger("remove", event, this._uiHash())
                }), delayedTriggers.push(function(c) {
                    return function(event) {
                        c._trigger("receive", event, this._uiHash(this))
                    }
                }.call(this, this.currentContainer)), delayedTriggers.push(function(c) {
                    return function(event) {
                        c._trigger("update", event, this._uiHash(this))
                    }
                }.call(this, this.currentContainer)))), i = this.containers.length - 1; i >= 0; i--)
                    noPropagation || delayedTriggers.push(delayEvent("deactivate", this, this.containers[i])), this.containers[i].containerCache.over && (delayedTriggers.push(delayEvent("out", this, this.containers[i])), this.containers[i].containerCache.over = 0);
                if (this.storedCursor && (this.document.find("body").css("cursor", this.storedCursor), this.storedStylesheet.remove()), this._storedOpacity && this.helper.css("opacity", this._storedOpacity), this._storedZIndex && this.helper.css("zIndex", "auto" === this._storedZIndex ? "" : this._storedZIndex), this.dragging = !1, noPropagation || this._trigger("beforeStop", event, this._uiHash()), this.placeholder[0].parentNode.removeChild(this.placeholder[0]), this.cancelHelperRemoval || (this.helper[0] !== this.currentItem[0] && this.helper.remove(), this.helper = null), !noPropagation) {
                    for (i = 0; i < delayedTriggers.length; i++)
                        delayedTriggers[i].call(this, event);
                    this._trigger("stop", event, this._uiHash())
                }
                return this.fromOutside = !1, !this.cancelHelperRemoval
            },_trigger: function() {
                $.Widget.prototype._trigger.apply(this, arguments) === !1 && this.cancel()
            },_uiHash: function(_inst) {
                var inst = _inst || this;
                return {helper: inst.helper,placeholder: inst.placeholder || $([]),position: inst.position,originalPosition: inst.originalPosition,offset: inst.positionAbs,item: inst.currentItem,sender: _inst ? _inst.element : null}
            }}), $.widget("ui.spinner", {version: "1.11.4",defaultElement: "<input>",widgetEventPrefix: "spin",options: {culture: null,icons: {down: "ui-icon-triangle-1-s",up: "ui-icon-triangle-1-n"},incremental: !0,max: null,min: null,numberFormat: null,page: 10,step: 1,change: null,spin: null,start: null,stop: null},_create: function() {
                this._setOption("max", this.options.max), this._setOption("min", this.options.min), this._setOption("step", this.options.step), "" !== this.value() && this._value(this.element.val(), !0), this._draw(), this._on(this._events), this._refresh(), this._on(this.window, {beforeunload: function() {
                        this.element.removeAttr("autocomplete")
                    }})
            },_getCreateOptions: function() {
                var options = {}, element = this.element;
                return $.each(["min", "max", "step"], function(i, option) {
                    var value = element.attr(option);
                    void 0 !== value && value.length && (options[option] = value)
                }), options
            },_events: {keydown: function(event) {
                    this._start(event) && this._keydown(event) && event.preventDefault()
                },keyup: "_stop",focus: function() {
                    this.previous = this.element.val()
                },blur: function(event) {
                    return this.cancelBlur ? void delete this.cancelBlur : (this._stop(), this._refresh(), void (this.previous !== this.element.val() && this._trigger("change", event)))
                },mousewheel: function(event, delta) {
                    if (delta) {
                        if (!this.spinning && !this._start(event))
                            return !1;
                        this._spin((delta > 0 ? 1 : -1) * this.options.step, event), clearTimeout(this.mousewheelTimer), this.mousewheelTimer = this._delay(function() {
                            this.spinning && this._stop(event)
                        }, 100), event.preventDefault()
                    }
                },"mousedown .ui-spinner-button": function(event) {
                    function checkFocus() {
                        var isActive = this.element[0] === this.document[0].activeElement;
                        isActive || (this.element.focus(), this.previous = previous, this._delay(function() {
                            this.previous = previous
                        }))
                    }
                    var previous;
                    previous = this.element[0] === this.document[0].activeElement ? this.previous : this.element.val(), event.preventDefault(), checkFocus.call(this), this.cancelBlur = !0, this._delay(function() {
                        delete this.cancelBlur, checkFocus.call(this)
                    }), this._start(event) !== !1 && this._repeat(null, $(event.currentTarget).hasClass("ui-spinner-up") ? 1 : -1, event)
                },"mouseup .ui-spinner-button": "_stop","mouseenter .ui-spinner-button": function(event) {
                    return $(event.currentTarget).hasClass("ui-state-active") ? this._start(event) === !1 ? !1 : void this._repeat(null, $(event.currentTarget).hasClass("ui-spinner-up") ? 1 : -1, event) : void 0
                },"mouseleave .ui-spinner-button": "_stop"},_draw: function() {
                var uiSpinner = this.uiSpinner = this.element.addClass("ui-spinner-input").attr("autocomplete", "off").wrap(this._uiSpinnerHtml()).parent().append(this._buttonHtml());
                this.element.attr("role", "spinbutton"), this.buttons = uiSpinner.find(".ui-spinner-button").attr("tabIndex", -1).button().removeClass("ui-corner-all"), this.buttons.height() > Math.ceil(.5 * uiSpinner.height()) && uiSpinner.height() > 0 && uiSpinner.height(uiSpinner.height()), this.options.disabled && this.disable()
            },_keydown: function(event) {
                var options = this.options, keyCode = $.ui.keyCode;
                switch (event.keyCode) {
                    case keyCode.UP:
                        return this._repeat(null, 1, event), !0;
                    case keyCode.DOWN:
                        return this._repeat(null, -1, event), !0;
                    case keyCode.PAGE_UP:
                        return this._repeat(null, options.page, event), !0;
                    case keyCode.PAGE_DOWN:
                        return this._repeat(null, -options.page, event), !0
                }
                return !1
            },_uiSpinnerHtml: function() {
                return "<span class='ui-spinner ui-widget ui-widget-content ui-corner-all'></span>"
            },_buttonHtml: function() {
                return "<a class='ui-spinner-button ui-spinner-up ui-corner-tr'><span class='ui-icon " + this.options.icons.up + "'>&#9650;</span></a><a class='ui-spinner-button ui-spinner-down ui-corner-br'><span class='ui-icon " + this.options.icons.down + "'>&#9660;</span></a>"
            },_start: function(event) {
                return this.spinning || this._trigger("start", event) !== !1 ? (this.counter || (this.counter = 1), this.spinning = !0, !0) : !1
            },_repeat: function(i, steps, event) {
                i = i || 500, clearTimeout(this.timer), this.timer = this._delay(function() {
                    this._repeat(40, steps, event)
                }, i), this._spin(steps * this.options.step, event)
            },_spin: function(step, event) {
                var value = this.value() || 0;
                this.counter || (this.counter = 1), value = this._adjustValue(value + step * this._increment(this.counter)), this.spinning && this._trigger("spin", event, {value: value}) === !1 || (this._value(value), this.counter++)
            },_increment: function(i) {
                var incremental = this.options.incremental;
                return incremental ? $.isFunction(incremental) ? incremental(i) : Math.floor(i * i * i / 5e4 - i * i / 500 + 17 * i / 200 + 1) : 1
            },_precision: function() {
                var precision = this._precisionOf(this.options.step);
                return null !== this.options.min && (precision = Math.max(precision, this._precisionOf(this.options.min))), precision
            },_precisionOf: function(num) {
                var str = num.toString(), decimal = str.indexOf(".");
                return -1 === decimal ? 0 : str.length - decimal - 1
            },_adjustValue: function(value) {
                var base, aboveMin, options = this.options;
                return base = null !== options.min ? options.min : 0, aboveMin = value - base, aboveMin = Math.round(aboveMin / options.step) * options.step, value = base + aboveMin, value = parseFloat(value.toFixed(this._precision())), null !== options.max && value > options.max ? options.max : null !== options.min && value < options.min ? options.min : value
            },_stop: function(event) {
                this.spinning && (clearTimeout(this.timer), clearTimeout(this.mousewheelTimer), this.counter = 0, this.spinning = !1, this._trigger("stop", event))
            },_setOption: function(key, value) {
                if ("culture" === key || "numberFormat" === key) {
                    var prevValue = this._parse(this.element.val());
                    return this.options[key] = value, void this.element.val(this._format(prevValue))
                }
                ("max" === key || "min" === key || "step" === key) && "string" == typeof value && (value = this._parse(value)), "icons" === key && (this.buttons.first().find(".ui-icon").removeClass(this.options.icons.up).addClass(value.up), this.buttons.last().find(".ui-icon").removeClass(this.options.icons.down).addClass(value.down)), this._super(key, value), "disabled" === key && (this.widget().toggleClass("ui-state-disabled", !!value), this.element.prop("disabled", !!value), this.buttons.button(value ? "disable" : "enable"))
            },_setOptions: spinner_modifier(function(options) {
                this._super(options)
            }),_parse: function(val) {
                return "string" == typeof val && "" !== val && (val = window.Globalize && this.options.numberFormat ? Globalize.parseFloat(val, 10, this.options.culture) : +val), "" === val || isNaN(val) ? null : val
            },_format: function(value) {
                return "" === value ? "" : window.Globalize && this.options.numberFormat ? Globalize.format(value, this.options.numberFormat, this.options.culture) : value;
            },_refresh: function() {
                this.element.attr({"aria-valuemin": this.options.min,"aria-valuemax": this.options.max,"aria-valuenow": this._parse(this.element.val())})
            },isValid: function() {
                var value = this.value();
                return null === value ? !1 : value === this._adjustValue(value)
            },_value: function(value, allowAny) {
                var parsed;
                "" !== value && (parsed = this._parse(value), null !== parsed && (allowAny || (parsed = this._adjustValue(parsed)), value = this._format(parsed))), this.element.val(value), this._refresh()
            },_destroy: function() {
                this.element.removeClass("ui-spinner-input").prop("disabled", !1).removeAttr("autocomplete").removeAttr("role").removeAttr("aria-valuemin").removeAttr("aria-valuemax").removeAttr("aria-valuenow"), this.uiSpinner.replaceWith(this.element)
            },stepUp: spinner_modifier(function(steps) {
                this._stepUp(steps)
            }),_stepUp: function(steps) {
                this._start() && (this._spin((steps || 1) * this.options.step), this._stop())
            },stepDown: spinner_modifier(function(steps) {
                this._stepDown(steps)
            }),_stepDown: function(steps) {
                this._start() && (this._spin((steps || 1) * -this.options.step), this._stop())
            },pageUp: spinner_modifier(function(pages) {
                this._stepUp((pages || 1) * this.options.page)
            }),pageDown: spinner_modifier(function(pages) {
                this._stepDown((pages || 1) * this.options.page)
            }),value: function(newVal) {
                return arguments.length ? void spinner_modifier(this._value).call(this, newVal) : this._parse(this.element.val())
            },widget: function() {
                return this.uiSpinner
            }}), $.widget("ui.tabs", {version: "1.11.4",delay: 300,options: {active: null,collapsible: !1,event: "click",heightStyle: "content",hide: null,show: null,activate: null,beforeActivate: null,beforeLoad: null,load: null},_isLocal: function() {
                var rhash = /#.*$/;
                return function(anchor) {
                    var anchorUrl, locationUrl;
                    anchor = anchor.cloneNode(!1), anchorUrl = anchor.href.replace(rhash, ""), locationUrl = location.href.replace(rhash, "");
                    try {
                        anchorUrl = decodeURIComponent(anchorUrl)
                    } catch (error) {
                    }
                    try {
                        locationUrl = decodeURIComponent(locationUrl)
                    } catch (error) {
                    }
                    return anchor.hash.length > 1 && anchorUrl === locationUrl
                }
            }(),_create: function() {
                var that = this, options = this.options;
                this.running = !1, this.element.addClass("ui-tabs ui-widget ui-widget-content ui-corner-all").toggleClass("ui-tabs-collapsible", options.collapsible), this._processTabs(), options.active = this._initialActive(), $.isArray(options.disabled) && (options.disabled = $.unique(options.disabled.concat($.map(this.tabs.filter(".ui-state-disabled"), function(li) {
                    return that.tabs.index(li)
                }))).sort()), this.options.active !== !1 && this.anchors.length ? this.active = this._findActive(options.active) : this.active = $(), this._refresh(), this.active.length && this.load(options.active)
            },_initialActive: function() {
                var active = this.options.active, collapsible = this.options.collapsible, locationHash = location.hash.substring(1);
                return null === active && (locationHash && this.tabs.each(function(i, tab) {
                    return $(tab).attr("aria-controls") === locationHash ? (active = i, !1) : void 0
                }), null === active && (active = this.tabs.index(this.tabs.filter(".ui-tabs-active"))), (null === active || -1 === active) && (active = this.tabs.length ? 0 : !1)), active !== !1 && (active = this.tabs.index(this.tabs.eq(active)), -1 === active && (active = collapsible ? !1 : 0)), !collapsible && active === !1 && this.anchors.length && (active = 0), active
            },_getCreateEventData: function() {
                return {tab: this.active,panel: this.active.length ? this._getPanelForTab(this.active) : $()}
            },_tabKeydown: function(event) {
                var focusedTab = $(this.document[0].activeElement).closest("li"), selectedIndex = this.tabs.index(focusedTab), goingForward = !0;
                if (!this._handlePageNav(event)) {
                    switch (event.keyCode) {
                        case $.ui.keyCode.RIGHT:
                        case $.ui.keyCode.DOWN:
                            selectedIndex++;
                            break;
                        case $.ui.keyCode.UP:
                        case $.ui.keyCode.LEFT:
                            goingForward = !1, selectedIndex--;
                            break;
                        case $.ui.keyCode.END:
                            selectedIndex = this.anchors.length - 1;
                            break;
                        case $.ui.keyCode.HOME:
                            selectedIndex = 0;
                            break;
                        case $.ui.keyCode.SPACE:
                            return event.preventDefault(), clearTimeout(this.activating), void this._activate(selectedIndex);
                        case $.ui.keyCode.ENTER:
                            return event.preventDefault(), clearTimeout(this.activating), void this._activate(selectedIndex === this.options.active ? !1 : selectedIndex);
                        default:
                            return
                    }
                    event.preventDefault(), clearTimeout(this.activating), selectedIndex = this._focusNextTab(selectedIndex, goingForward), event.ctrlKey || event.metaKey || (focusedTab.attr("aria-selected", "false"), this.tabs.eq(selectedIndex).attr("aria-selected", "true"), this.activating = this._delay(function() {
                        this.option("active", selectedIndex)
                    }, this.delay))
                }
            },_panelKeydown: function(event) {
                this._handlePageNav(event) || event.ctrlKey && event.keyCode === $.ui.keyCode.UP && (event.preventDefault(), this.active.focus())
            },_handlePageNav: function(event) {
                return event.altKey && event.keyCode === $.ui.keyCode.PAGE_UP ? (this._activate(this._focusNextTab(this.options.active - 1, !1)), !0) : event.altKey && event.keyCode === $.ui.keyCode.PAGE_DOWN ? (this._activate(this._focusNextTab(this.options.active + 1, !0)), !0) : void 0
            },_findNextTab: function(index, goingForward) {
                function constrain() {
                    return index > lastTabIndex && (index = 0), 0 > index && (index = lastTabIndex), index
                }
                for (var lastTabIndex = this.tabs.length - 1; -1 !== $.inArray(constrain(), this.options.disabled); )
                    index = goingForward ? index + 1 : index - 1;
                return index
            },_focusNextTab: function(index, goingForward) {
                return index = this._findNextTab(index, goingForward), this.tabs.eq(index).focus(), index
            },_setOption: function(key, value) {
                return "active" === key ? void this._activate(value) : "disabled" === key ? void this._setupDisabled(value) : (this._super(key, value), "collapsible" === key && (this.element.toggleClass("ui-tabs-collapsible", value), value || this.options.active !== !1 || this._activate(0)), "event" === key && this._setupEvents(value), void ("heightStyle" === key && this._setupHeightStyle(value)))
            },_sanitizeSelector: function(hash) {
                return hash ? hash.replace(/[!"$%&'()*+,.\/:;<=>?@\[\]\^`{|}~]/g, "\\$&") : ""
            },refresh: function() {
                var options = this.options, lis = this.tablist.children(":has(a[href])");
                options.disabled = $.map(lis.filter(".ui-state-disabled"), function(tab) {
                    return lis.index(tab)
                }), this._processTabs(), options.active !== !1 && this.anchors.length ? this.active.length && !$.contains(this.tablist[0], this.active[0]) ? this.tabs.length === options.disabled.length ? (options.active = !1, this.active = $()) : this._activate(this._findNextTab(Math.max(0, options.active - 1), !1)) : options.active = this.tabs.index(this.active) : (options.active = !1, this.active = $()), this._refresh()
            },_refresh: function() {
                this._setupDisabled(this.options.disabled), this._setupEvents(this.options.event), this._setupHeightStyle(this.options.heightStyle), this.tabs.not(this.active).attr({"aria-selected": "false","aria-expanded": "false",tabIndex: -1}), this.panels.not(this._getPanelForTab(this.active)).hide().attr({"aria-hidden": "true"}), this.active.length ? (this.active.addClass("ui-tabs-active ui-state-active").attr({"aria-selected": "true","aria-expanded": "true",tabIndex: 0}), this._getPanelForTab(this.active).show().attr({"aria-hidden": "false"})) : this.tabs.eq(0).attr("tabIndex", 0)
            },_processTabs: function() {
                var that = this, prevTabs = this.tabs, prevAnchors = this.anchors, prevPanels = this.panels;
                this.tablist = this._getList().addClass("ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all").attr("role", "tablist").delegate("> li", "mousedown" + this.eventNamespace, function(event) {
                    $(this).is(".ui-state-disabled") && event.preventDefault()
                }).delegate(".ui-tabs-anchor", "focus" + this.eventNamespace, function() {
                    $(this).closest("li").is(".ui-state-disabled") && this.blur()
                }), this.tabs = this.tablist.find("> li:has(a[href])").addClass("ui-state-default ui-corner-top").attr({role: "tab",tabIndex: -1}), this.anchors = this.tabs.map(function() {
                    return $("a", this)[0]
                }).addClass("ui-tabs-anchor").attr({role: "presentation",tabIndex: -1}), this.panels = $(), this.anchors.each(function(i, anchor) {
                    var selector, panel, panelId, anchorId = $(anchor).uniqueId().attr("id"), tab = $(anchor).closest("li"), originalAriaControls = tab.attr("aria-controls");
                    that._isLocal(anchor) ? (selector = anchor.hash, panelId = selector.substring(1), panel = that.element.find(that._sanitizeSelector(selector))) : (panelId = tab.attr("aria-controls") || $({}).uniqueId()[0].id, selector = "#" + panelId, panel = that.element.find(selector), panel.length || (panel = that._createPanel(panelId), panel.insertAfter(that.panels[i - 1] || that.tablist)), panel.attr("aria-live", "polite")), panel.length && (that.panels = that.panels.add(panel)), originalAriaControls && tab.data("ui-tabs-aria-controls", originalAriaControls), tab.attr({"aria-controls": panelId,"aria-labelledby": anchorId}), panel.attr("aria-labelledby", anchorId)
                }), this.panels.addClass("ui-tabs-panel ui-widget-content ui-corner-bottom").attr("role", "tabpanel"), prevTabs && (this._off(prevTabs.not(this.tabs)), this._off(prevAnchors.not(this.anchors)), this._off(prevPanels.not(this.panels)))
            },_getList: function() {
                return this.tablist || this.element.find("ol,ul").eq(0)
            },_createPanel: function(id) {
                return $("<div>").attr("id", id).addClass("ui-tabs-panel ui-widget-content ui-corner-bottom").data("ui-tabs-destroy", !0)
            },_setupDisabled: function(disabled) {
                $.isArray(disabled) && (disabled.length ? disabled.length === this.anchors.length && (disabled = !0) : disabled = !1);
                for (var li, i = 0; li = this.tabs[i]; i++)
                    disabled === !0 || -1 !== $.inArray(i, disabled) ? $(li).addClass("ui-state-disabled").attr("aria-disabled", "true") : $(li).removeClass("ui-state-disabled").removeAttr("aria-disabled");
                this.options.disabled = disabled
            },_setupEvents: function(event) {
                var events = {};
                event && $.each(event.split(" "), function(index, eventName) {
                    events[eventName] = "_eventHandler"
                }), this._off(this.anchors.add(this.tabs).add(this.panels)), this._on(!0, this.anchors, {click: function(event) {
                        event.preventDefault()
                    }}), this._on(this.anchors, events), this._on(this.tabs, {keydown: "_tabKeydown"}), this._on(this.panels, {keydown: "_panelKeydown"}), this._focusable(this.tabs), this._hoverable(this.tabs)
            },_setupHeightStyle: function(heightStyle) {
                var maxHeight, parent = this.element.parent();
                "fill" === heightStyle ? (maxHeight = parent.height(), maxHeight -= this.element.outerHeight() - this.element.height(), this.element.siblings(":visible").each(function() {
                    var elem = $(this), position = elem.css("position");
                    "absolute" !== position && "fixed" !== position && (maxHeight -= elem.outerHeight(!0))
                }), this.element.children().not(this.panels).each(function() {
                    maxHeight -= $(this).outerHeight(!0)
                }), this.panels.each(function() {
                    $(this).height(Math.max(0, maxHeight - $(this).innerHeight() + $(this).height()))
                }).css("overflow", "auto")) : "auto" === heightStyle && (maxHeight = 0, this.panels.each(function() {
                    maxHeight = Math.max(maxHeight, $(this).height("").height())
                }).height(maxHeight))
            },_eventHandler: function(event) {
                var options = this.options, active = this.active, anchor = $(event.currentTarget), tab = anchor.closest("li"), clickedIsActive = tab[0] === active[0], collapsing = clickedIsActive && options.collapsible, toShow = collapsing ? $() : this._getPanelForTab(tab), toHide = active.length ? this._getPanelForTab(active) : $(), eventData = {oldTab: active,oldPanel: toHide,newTab: collapsing ? $() : tab,newPanel: toShow};
                event.preventDefault(), tab.hasClass("ui-state-disabled") || tab.hasClass("ui-tabs-loading") || this.running || clickedIsActive && !options.collapsible || this._trigger("beforeActivate", event, eventData) === !1 || (options.active = collapsing ? !1 : this.tabs.index(tab), this.active = clickedIsActive ? $() : tab, this.xhr && this.xhr.abort(), toHide.length || toShow.length || $.error("jQuery UI Tabs: Mismatching fragment identifier."), toShow.length && this.load(this.tabs.index(tab), event), this._toggle(event, eventData))
            },_toggle: function(event, eventData) {
                function complete() {
                    that.running = !1, that._trigger("activate", event, eventData)
                }
                function show() {
                    eventData.newTab.closest("li").addClass("ui-tabs-active ui-state-active"), toShow.length && that.options.show ? that._show(toShow, that.options.show, complete) : (toShow.show(), complete())
                }
                var that = this, toShow = eventData.newPanel, toHide = eventData.oldPanel;
                this.running = !0, toHide.length && this.options.hide ? this._hide(toHide, this.options.hide, function() {
                    eventData.oldTab.closest("li").removeClass("ui-tabs-active ui-state-active"), show()
                }) : (eventData.oldTab.closest("li").removeClass("ui-tabs-active ui-state-active"), toHide.hide(), show()), toHide.attr("aria-hidden", "true"), eventData.oldTab.attr({"aria-selected": "false","aria-expanded": "false"}), toShow.length && toHide.length ? eventData.oldTab.attr("tabIndex", -1) : toShow.length && this.tabs.filter(function() {
                    return 0 === $(this).attr("tabIndex")
                }).attr("tabIndex", -1), toShow.attr("aria-hidden", "false"), eventData.newTab.attr({"aria-selected": "true","aria-expanded": "true",tabIndex: 0})
            },_activate: function(index) {
                var anchor, active = this._findActive(index);
                active[0] !== this.active[0] && (active.length || (active = this.active), anchor = active.find(".ui-tabs-anchor")[0], this._eventHandler({target: anchor,currentTarget: anchor,preventDefault: $.noop}))
            },_findActive: function(index) {
                return index === !1 ? $() : this.tabs.eq(index)
            },_getIndex: function(index) {
                return "string" == typeof index && (index = this.anchors.index(this.anchors.filter("[href$='" + index + "']"))), index
            },_destroy: function() {
                this.xhr && this.xhr.abort(), this.element.removeClass("ui-tabs ui-widget ui-widget-content ui-corner-all ui-tabs-collapsible"), this.tablist.removeClass("ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all").removeAttr("role"), this.anchors.removeClass("ui-tabs-anchor").removeAttr("role").removeAttr("tabIndex").removeUniqueId(), this.tablist.unbind(this.eventNamespace), this.tabs.add(this.panels).each(function() {
                    $.data(this, "ui-tabs-destroy") ? $(this).remove() : $(this).removeClass("ui-state-default ui-state-active ui-state-disabled ui-corner-top ui-corner-bottom ui-widget-content ui-tabs-active ui-tabs-panel").removeAttr("tabIndex").removeAttr("aria-live").removeAttr("aria-busy").removeAttr("aria-selected").removeAttr("aria-labelledby").removeAttr("aria-hidden").removeAttr("aria-expanded").removeAttr("role")
                }), this.tabs.each(function() {
                    var li = $(this), prev = li.data("ui-tabs-aria-controls");
                    prev ? li.attr("aria-controls", prev).removeData("ui-tabs-aria-controls") : li.removeAttr("aria-controls")
                }), this.panels.show(), "content" !== this.options.heightStyle && this.panels.css("height", "")
            },enable: function(index) {
                var disabled = this.options.disabled;
                disabled !== !1 && (void 0 === index ? disabled = !1 : (index = this._getIndex(index), disabled = $.isArray(disabled) ? $.map(disabled, function(num) {
                    return num !== index ? num : null
                }) : $.map(this.tabs, function(li, num) {
                    return num !== index ? num : null
                })), this._setupDisabled(disabled))
            },disable: function(index) {
                var disabled = this.options.disabled;
                if (disabled !== !0) {
                    if (void 0 === index)
                        disabled = !0;
                    else {
                        if (index = this._getIndex(index), -1 !== $.inArray(index, disabled))
                            return;
                        disabled = $.isArray(disabled) ? $.merge([index], disabled).sort() : [index]
                    }
                    this._setupDisabled(disabled)
                }
            },load: function(index, event) {
                index = this._getIndex(index);
                var that = this, tab = this.tabs.eq(index), anchor = tab.find(".ui-tabs-anchor"), panel = this._getPanelForTab(tab), eventData = {tab: tab,panel: panel}, complete = function(jqXHR, status) {
                    "abort" === status && that.panels.stop(!1, !0), tab.removeClass("ui-tabs-loading"), panel.removeAttr("aria-busy"), jqXHR === that.xhr && delete that.xhr
                };
                this._isLocal(anchor[0]) || (this.xhr = $.ajax(this._ajaxSettings(anchor, event, eventData)), this.xhr && "canceled" !== this.xhr.statusText && (tab.addClass("ui-tabs-loading"), panel.attr("aria-busy", "true"), this.xhr.done(function(response, status, jqXHR) {
                    setTimeout(function() {
                        panel.html(response), that._trigger("load", event, eventData), complete(jqXHR, status)
                    }, 1)
                }).fail(function(jqXHR, status) {
                    setTimeout(function() {
                        complete(jqXHR, status)
                    }, 1)
                })))
            },_ajaxSettings: function(anchor, event, eventData) {
                var that = this;
                return {url: anchor.attr("href"),beforeSend: function(jqXHR, settings) {
                        return that._trigger("beforeLoad", event, $.extend({jqXHR: jqXHR,ajaxSettings: settings}, eventData))
                    }}
            },_getPanelForTab: function(tab) {
                var id = $(tab).attr("aria-controls");
                return this.element.find(this._sanitizeSelector("#" + id))
            }}), $.widget("ui.tooltip", {version: "1.11.4",options: {content: function() {
                    var title = $(this).attr("title") || "";
                    return $("<a>").text(title).html()
                },hide: !0,items: "[title]:not([disabled])",position: {my: "left top+15",at: "left bottom",collision: "flipfit flip"},show: !0,tooltipClass: null,track: !1,close: null,open: null},_addDescribedBy: function(elem, id) {
                var describedby = (elem.attr("aria-describedby") || "").split(/\s+/);
                describedby.push(id), elem.data("ui-tooltip-id", id).attr("aria-describedby", $.trim(describedby.join(" ")))
            },_removeDescribedBy: function(elem) {
                var id = elem.data("ui-tooltip-id"), describedby = (elem.attr("aria-describedby") || "").split(/\s+/), index = $.inArray(id, describedby);
                -1 !== index && describedby.splice(index, 1), elem.removeData("ui-tooltip-id"), describedby = $.trim(describedby.join(" ")), describedby ? elem.attr("aria-describedby", describedby) : elem.removeAttr("aria-describedby")
            },_create: function() {
                this._on({mouseover: "open",focusin: "open"}), this.tooltips = {}, this.parents = {}, this.options.disabled && this._disable(), this.liveRegion = $("<div>").attr({role: "log","aria-live": "assertive","aria-relevant": "additions"}).addClass("ui-helper-hidden-accessible").appendTo(this.document[0].body)
            },_setOption: function(key, value) {
                var that = this;
                return "disabled" === key ? (this[value ? "_disable" : "_enable"](), void (this.options[key] = value)) : (this._super(key, value), void ("content" === key && $.each(this.tooltips, function(id, tooltipData) {
                    that._updateContent(tooltipData.element)
                })))
            },_disable: function() {
                var that = this;
                $.each(this.tooltips, function(id, tooltipData) {
                    var event = $.Event("blur");
                    event.target = event.currentTarget = tooltipData.element[0], that.close(event, !0)
                }), this.element.find(this.options.items).addBack().each(function() {
                    var element = $(this);
                    element.is("[title]") && element.data("ui-tooltip-title", element.attr("title")).removeAttr("title")
                })
            },_enable: function() {
                this.element.find(this.options.items).addBack().each(function() {
                    var element = $(this);
                    element.data("ui-tooltip-title") && element.attr("title", element.data("ui-tooltip-title"))
                })
            },open: function(event) {
                var that = this, target = $(event ? event.target : this.element).closest(this.options.items);
                target.length && !target.data("ui-tooltip-id") && (target.attr("title") && target.data("ui-tooltip-title", target.attr("title")), target.data("ui-tooltip-open", !0), event && "mouseover" === event.type && target.parents().each(function() {
                    var blurEvent, parent = $(this);
                    parent.data("ui-tooltip-open") && (blurEvent = $.Event("blur"), blurEvent.target = blurEvent.currentTarget = this, that.close(blurEvent, !0)), parent.attr("title") && (parent.uniqueId(), that.parents[this.id] = {element: this,title: parent.attr("title")}, parent.attr("title", ""))
                }), this._registerCloseHandlers(event, target), this._updateContent(target, event))
            },_updateContent: function(target, event) {
                var content, contentOption = this.options.content, that = this, eventType = event ? event.type : null;
                return "string" == typeof contentOption ? this._open(event, target, contentOption) : (content = contentOption.call(target[0], function(response) {
                    that._delay(function() {
                        target.data("ui-tooltip-open") && (event && (event.type = eventType), this._open(event, target, response))
                    })
                }), void (content && this._open(event, target, content)))
            },_open: function(event, target, content) {
                function position(event) {
                    positionOption.of = event, tooltip.is(":hidden") || tooltip.position(positionOption)
                }
                var tooltipData, tooltip, delayedShow, a11yContent, positionOption = $.extend({}, this.options.position);
                if (content) {
                    if (tooltipData = this._find(target))
                        return void tooltipData.tooltip.find(".ui-tooltip-content").html(content);
                    target.is("[title]") && (event && "mouseover" === event.type ? target.attr("title", "") : target.removeAttr("title")), tooltipData = this._tooltip(target), tooltip = tooltipData.tooltip, this._addDescribedBy(target, tooltip.attr("id")), tooltip.find(".ui-tooltip-content").html(content), this.liveRegion.children().hide(), content.clone ? (a11yContent = content.clone(), a11yContent.removeAttr("id").find("[id]").removeAttr("id")) : a11yContent = content, $("<div>").html(a11yContent).appendTo(this.liveRegion), this.options.track && event && /^mouse/.test(event.type) ? (this._on(this.document, {mousemove: position}), position(event)) : tooltip.position($.extend({of: target}, this.options.position)), tooltip.hide(), this._show(tooltip, this.options.show), this.options.show && this.options.show.delay && (delayedShow = this.delayedShow = setInterval(function() {
                        tooltip.is(":visible") && (position(positionOption.of), clearInterval(delayedShow))
                    }, $.fx.interval)), this._trigger("open", event, {tooltip: tooltip})
                }
            },_registerCloseHandlers: function(event, target) {
                var events = {keyup: function(event) {
                        if (event.keyCode === $.ui.keyCode.ESCAPE) {
                            var fakeEvent = $.Event(event);
                            fakeEvent.currentTarget = target[0], this.close(fakeEvent, !0)
                        }
                    }};
                target[0] !== this.element[0] && (events.remove = function() {
                    this._removeTooltip(this._find(target).tooltip)
                }), event && "mouseover" !== event.type || (events.mouseleave = "close"), event && "focusin" !== event.type || (events.focusout = "close"), this._on(!0, target, events)
            },close: function(event) {
                var tooltip, that = this, target = $(event ? event.currentTarget : this.element), tooltipData = this._find(target);
                return tooltipData ? (tooltip = tooltipData.tooltip, void (tooltipData.closing || (clearInterval(this.delayedShow), target.data("ui-tooltip-title") && !target.attr("title") && target.attr("title", target.data("ui-tooltip-title")), this._removeDescribedBy(target), tooltipData.hiding = !0, tooltip.stop(!0), this._hide(tooltip, this.options.hide, function() {
                    that._removeTooltip($(this))
                }), target.removeData("ui-tooltip-open"), this._off(target, "mouseleave focusout keyup"), target[0] !== this.element[0] && this._off(target, "remove"), this._off(this.document, "mousemove"), event && "mouseleave" === event.type && $.each(this.parents, function(id, parent) {
                    $(parent.element).attr("title", parent.title), delete that.parents[id]
                }), tooltipData.closing = !0, this._trigger("close", event, {tooltip: tooltip}), tooltipData.hiding || (tooltipData.closing = !1)))) : void target.removeData("ui-tooltip-open")
            },_tooltip: function(element) {
                var tooltip = $("<div>").attr("role", "tooltip").addClass("ui-tooltip ui-widget ui-corner-all ui-widget-content " + (this.options.tooltipClass || "")), id = tooltip.uniqueId().attr("id");
                return $("<div>").addClass("ui-tooltip-content").appendTo(tooltip), tooltip.appendTo(this.document[0].body), this.tooltips[id] = {element: element,tooltip: tooltip}
            },_find: function(target) {
                var id = target.data("ui-tooltip-id");
                return id ? this.tooltips[id] : null
            },_removeTooltip: function(tooltip) {
                tooltip.remove(), delete this.tooltips[tooltip.attr("id")]
            },_destroy: function() {
                var that = this;
                $.each(this.tooltips, function(id, tooltipData) {
                    var event = $.Event("blur"), element = tooltipData.element;
                    event.target = event.currentTarget = element[0], that.close(event, !0), $("#" + id).remove(), element.data("ui-tooltip-title") && (element.attr("title") || element.attr("title", element.data("ui-tooltip-title")), element.removeData("ui-tooltip-title"))
                }), this.liveRegion.remove()
            }})
    }), null == window.jQuery.ui)
        throw new Error('Grunt Requireize: module does not define "window.jQuery.ui"');
    return window.jQuery.ui
}), fweb_define("jquery.throttle-debounce", ["jquery"], null, function() {
    if (function(window, undefined) {
        "$:nomunge";
        var jq_throttle, $ = window.jQuery || window.Cowboy || (window.Cowboy = {});
        $.throttle = jq_throttle = function(delay, no_trailing, callback, debounce_mode) {
            function wrapper() {
                function exec() {
                    last_exec = +new Date, callback.apply(that, args)
                }
                function clear() {
                    timeout_id = undefined
                }
                var that = this, elapsed = +new Date - last_exec, args = arguments;
                debounce_mode && !timeout_id && exec(), timeout_id && clearTimeout(timeout_id), debounce_mode === undefined && elapsed > delay ? exec() : no_trailing !== !0 && (timeout_id = setTimeout(debounce_mode ? clear : exec, debounce_mode === undefined ? delay - elapsed : delay))
            }
            var timeout_id, last_exec = 0;
            return "boolean" != typeof no_trailing && (debounce_mode = callback, callback = no_trailing, no_trailing = undefined), $.guid && (wrapper.guid = callback.guid = callback.guid || $.guid++), wrapper
        }, $.debounce = function(delay, at_begin, callback) {
            return callback === undefined ? jq_throttle(delay, at_begin, !1) : jq_throttle(delay, callback, at_begin !== !1)
        }
    }(this), null == window.jQuery.debounce)
        throw new Error('Grunt Requireize: module does not define "window.jQuery.debounce"');
    return window.jQuery.debounce
}), fweb_define("closure-ipaddress", [], null, function() {
    if (function() {
        function g(a) {
            throw a
        }
        function n(a) {
            var d = typeof a;
            if ("object" == d) {
                if (!a)
                    return "null";
                if (a instanceof Array)
                    return "array";
                if (a instanceof Object)
                    return d;
                var b = Object.prototype.toString.call(a);
                if ("[object Window]" == b)
                    return "object";
                if ("[object Array]" == b || "number" == typeof a.length && "undefined" != typeof a.splice && "undefined" != typeof a.propertyIsEnumerable && !a.propertyIsEnumerable("splice"))
                    return "array";
                if ("[object Function]" == b || "undefined" != typeof a.call && "undefined" != typeof a.propertyIsEnumerable && !a.propertyIsEnumerable("call"))
                    return "function"
            } else if ("function" == d && "undefined" == typeof a.call)
                return "object";
            return d
        }
        function p(a, d) {
            var b = a.split("."), c = l;
            !(b[0] in c) && c.execScript && c.execScript("var " + b[0]);
            for (var e; b.length && (e = b.shift()); )
                b.length || void 0 === d ? c = c[e] ? c[e] : c[e] = {} : c[e] = d
        }
        function q(a) {
            function b() {
            }
            var d = r;
            b.prototype = d.prototype, a.m = d.prototype, a.prototype = new b
        }
        function s(a, d) {
            this.a = [], this.b = d;
            for (var b = !0, c = a.length - 1; c >= 0; c--) {
                var e = 0 | a[c];
                b && e == d || (this.a[c] = e, b = !1)
            }
        }
        function u(a) {
            if (a >= -128 && 128 > a) {
                var d = t[a];
                if (d)
                    return d
            }
            return d = new s([0 | a], 0 > a ? -1 : 0), a >= -128 && 128 > a && (t[a] = d), d
        }
        function v(a) {
            if (isNaN(a) || !isFinite(a))
                return w;
            if (0 > a)
                return x(v(-a));
            for (var d = [], b = 1, c = 0; a >= b; c++)
                d[c] = a / b | 0, b *= y;
            return new s(d, 0)
        }
        function z(a, d) {
            0 == a.length && g(Error("number format error: empty string"));
            var b = d || 10;
            if ((2 > b || b > 36) && g(Error("radix out of range: " + b)), "-" == a.charAt(0))
                return x(z(a.substring(1), b));
            0 <= a.indexOf("-") && g(Error('number format error: interior "-" character'));
            for (var c = v(Math.pow(b, 8)), e = w, f = 0; f < a.length; f += 8) {
                var h = Math.min(8, a.length - f), m = parseInt(a.substring(f, f + h), b);
                8 > h ? (h = v(Math.pow(b, h)), e = e.multiply(h).add(v(m))) : (e = e.multiply(c), e = e.add(v(m)))
            }
            return e
        }
        function F(a, d) {
            return 0 > d ? 0 : d < a.a.length ? a.a[d] : a.b
        }
        function C(a, d) {
            var b = F(a, d);
            return b >= 0 ? b : y + b
        }
        function D(a) {
            if (0 != a.b)
                return !1;
            for (var d = 0; d < a.a.length; d++)
                if (0 != a.a[d])
                    return !1;
            return !0
        }
        function G(a, d) {
            var b = a.d(d);
            return -1 == b.b ? -1 : D(b) ? 0 : 1
        }
        function x(a) {
            for (var d = a.a.length, b = [], c = 0; d > c; c++)
                b[c] = ~a.a[c];
            return new s(b, ~a.b).add(A)
        }
        function H(a, d) {
            for (; (65535 & a[d]) != a[d]; )
                a[d + 1] += a[d] >>> 16, a[d] &= 65535
        }
        function E(a, d) {
            if (D(d) && g(Error("division by zero")), D(a))
                return w;
            if (-1 == a.b)
                return -1 == d.b ? E(x(a), x(d)) : x(E(x(a), d));
            if (-1 == d.b)
                return x(E(a, x(d)));
            for (var b = w, c = a; c.g(d); ) {
                for (var e = Math.max(1, Math.floor(c.e() / d.e())), f = Math.ceil(Math.log(e) / Math.LN2), f = 48 >= f ? 1 : Math.pow(2, f - 48), h = v(e), m = h.multiply(d); -1 == m.b || 0 < G(m, c); )
                    e -= f, h = v(e), m = h.multiply(d);
                D(h) && (h = A), b = b.add(h), c = c.d(m)
            }
            return b
        }
        function I(a, d) {
            for (var b = Math.max(a.a.length, d.a.length), c = [], e = 0; b > e; e++)
                c[e] = F(a, e) | F(d, e);
            return new s(c, a.b | d.b)
        }
        function J(a) {
            var b, d = {};
            for (b in a)
                d[b] = a[b];
            return d
        }
        function M(a, d) {
            for (var b = 1; b < arguments.length; b++) {
                var e, f, c = arguments[b];
                if ((f = "array" == n(c)) || (e = c, f = n(e), f = (e = "array" == f || "object" == f && "number" == typeof e.length) && Object.prototype.hasOwnProperty.call(c, "callee")), f)
                    a.push.apply(a, c);
                else if (e) {
                    f = a.length;
                    for (var h = c.length, m = 0; h > m; m++)
                        a[f + m] = c[m]
                } else
                    a.push(c)
            }
        }
        function r(a, d) {
            this.f = a, this.l = d, this.c = ""
        }
        function N(a) {
            var d = w;
            if (a instanceof s)
                (0 != a.b || 0 > G(a, w) || 0 < G(a, O)) && g(Error("The address does not look like an IPv4.")), d = J(a);
            else {
                P.test(a) || g(Error(a + " does not look like an IPv4 address."));
                var b = a.split(".");
                4 != b.length && g(Error(a + " does not look like an IPv4 address."));
                for (var c = 0; c < b.length; c++) {
                    var e;
                    e = b[c];
                    var f = Number(e);
                    e = 0 == f && /^[\s\xa0]*$/.test(e) ? NaN : f, (f = isNaN(e)) || (f = 0 > e) || (f = e > 255) || (f = 1 != b[c].length) && (f = 0 == b[c].lastIndexOf("0", 0)), f && g(Error("In " + a + ", octet " + c + " is not valid")), e = v(e), d = I(d.shiftLeft(8), e)
                }
            }
            r.call(this, d, 4)
        }
        function Q(a) {
            var d = w;
            if (a instanceof s)
                (0 != a.b || 0 > G(a, w) || 0 < G(a, R)) && g(Error("The address does not look like a valid IPv6.")), d = J(a);
            else {
                S.test(a) || g(Error(a + " is not a valid IPv6 address."));
                var b = a.split(":");
                if (-1 != b[b.length - 1].indexOf(".")) {
                    a = C(new N(b[b.length - 1]).h(), 0);
                    var c = [];
                    c.push((a >>> 16 & 65535).toString(16)), c.push((65535 & a).toString(16)), K.splice.call(b, b.length - 1, 1), M(b, c), a = b.join(":")
                }
                if (c = a.split("::"), (2 < c.length || 1 == c.length && 8 != b.length) && g(Error(a + " is not a valid IPv6 address.")), 1 < c.length) {
                    b = c[0].split(":"), c = c[1].split(":"), 1 == b.length && "" == b[0] && (b = []), 1 == c.length && "" == c[0] && (c = []);
                    var e = 8 - (b.length + c.length);
                    if (1 > e)
                        b = [];
                    else {
                        for (var f = [], h = 0; e > h; h++)
                            f[h] = "0";
                        M(b, f), M(b, c)
                    }
                }
                for (8 != b.length && g(Error(a + " is not a valid IPv6 address")), c = 0; c < b.length; c++)
                    e = z(b[c], 16), (0 > G(e, w) || 0 < G(e, T)) && g(Error(b[c] + " in " + a + " is not a valid hextet.")), d = I(d.shiftLeft(16), e)
            }
            r.call(this, d, 6)
        }
        var k, l = this, t = {}, y = 4294967296, w = u(0), A = u(1), B = u(16777216);
        k = s.prototype, k.e = function() {
            if (-1 == this.b)
                return -x(this).e();
            for (var a = 0, d = 1, b = 0; b < this.a.length; b++)
                a += C(this, b) * d, d *= y;
            return a
        }, k.toString = function(a) {
            if (a = a || 10, (2 > a || a > 36) && g(Error("radix out of range: " + a)), D(this))
                return "0";
            if (-1 == this.b)
                return "-" + x(this).toString(a);
            for (var d = v(Math.pow(a, 6)), b = this, c = ""; ; ) {
                var e = E(b, d), b = b.d(e.multiply(d)), f = (0 < b.a.length ? b.a[0] : b.b).toString(a), b = e;
                if (D(b))
                    return f + c;
                for (; 6 > f.length; )
                    f = "0" + f;
                c = "" + f + c
            }
        }, k.g = function(a) {
            return 0 <= G(this, a)
        }, k.j = function(a) {
            return 0 >= G(this, a)
        }, k.add = function(a) {
            for (var d = Math.max(this.a.length, a.a.length), b = [], c = 0, e = 0; d >= e; e++) {
                var f = c + (65535 & F(this, e)) + (65535 & F(a, e)), h = (f >>> 16) + (F(this, e) >>> 16) + (F(a, e) >>> 16), c = h >>> 16, f = 65535 & f, h = 65535 & h;
                b[e] = h << 16 | f
            }
            return new s(b, -2147483648 & b[b.length - 1] ? -1 : 0)
        }, k.d = function(a) {
            return this.add(x(a))
        }, k.multiply = function(a) {
            if (D(this) || D(a))
                return w;
            if (-1 == this.b)
                return -1 == a.b ? x(this).multiply(x(a)) : x(x(this).multiply(a));
            if (-1 == a.b)
                return x(this.multiply(x(a)));
            if (0 > G(this, B) && 0 > G(a, B))
                return v(this.e() * a.e());
            for (var d = this.a.length + a.a.length, b = [], c = 0; 2 * d > c; c++)
                b[c] = 0;
            for (c = 0; c < this.a.length; c++)
                for (var e = 0; e < a.a.length; e++) {
                    var f = F(this, c) >>> 16, h = 65535 & F(this, c), m = F(a, e) >>> 16, L = 65535 & F(a, e);
                    b[2 * c + 2 * e] += h * L, H(b, 2 * c + 2 * e), b[2 * c + 2 * e + 1] += f * L, H(b, 2 * c + 2 * e + 1), b[2 * c + 2 * e + 1] += h * m, H(b, 2 * c + 2 * e + 1), b[2 * c + 2 * e + 2] += f * m, H(b, 2 * c + 2 * e + 2)
                }
            for (c = 0; d > c; c++)
                b[c] = b[2 * c + 1] << 16 | b[2 * c];
            for (c = d; 2 * d > c; c++)
                b[c] = 0;
            return new s(b, 0)
        }, k.shiftLeft = function(a) {
            var d = a >> 5;
            a %= 32;
            for (var b = this.a.length + d + (a > 0 ? 1 : 0), c = [], e = 0; b > e; e++)
                c[e] = a > 0 ? F(this, e - d) << a | F(this, e - d - 1) >>> 32 - a : F(this, e - d);
            return new s(c, this.b)
        }, k.k = function(a) {
            var d = a >> 5;
            a %= 32;
            for (var b = this.a.length - d, c = [], e = 0; b > e; e++)
                c[e] = a > 0 ? F(this, e + d) >>> a | F(this, e + d + 1) << 32 - a : F(this, e + d);
            return new s(c, this.b)
        };
        var K = Array.prototype;
        r.prototype.i = function() {
            return this.l
        }, r.prototype.h = function() {
            return J(this.f)
        }, q(N);
        var P = /^[0-9.]*$/, O = A.shiftLeft(32).d(A);
        N.prototype.toString = function() {
            if (this.c)
                return this.c;
            for (var a = C(this.f, 0), d = [], b = 3; b >= 0; b--)
                d[b] = String(255 & a), a >>>= 8;
            return this.c = d.join(".")
        }, q(Q);
        var S = /^([a-fA-F0-9]*:){2}[a-fA-F0-9:.]*$/, T = u(65535), R = A.shiftLeft(128).d(A);
        Q.prototype.toString = function() {
            if (this.c)
                return this.c;
            for (var a = [], d = 3; d >= 0; d--) {
                var b = C(this.f, d), c = 65535 & b;
                a.push((b >>> 16).toString(16)), a.push(c.toString(16))
            }
            for (var b = d = -1, e = c = 0, f = 0; f < a.length; f++)
                "0" == a[f] ? (e++, -1 == b && (b = f), e > c && (c = e, d = b)) : (b = -1, e = 0);
            return c > 0 && (d + c == a.length && a.push(""), a.splice(d, c, ""), 0 == d && (a = [""].concat(a))), this.c = a.join(":")
        }, p("goog.isFunction", function(a) {
            return "function" == n(a)
        }), p("goog.math.Integer", s), s.ONE = A, s.fromNumber = v, s.fromString = z, s.prototype = s.prototype, s.prototype.greaterThanOrEqual = s.prototype.g, s.prototype.lessThanOrEqual = s.prototype.j, s.prototype.shiftRight = s.prototype.k, s.prototype.shiftLeft = s.prototype.shiftLeft, s.prototype.add = s.prototype.add, s.prototype.subtract = s.prototype.d, s.prototype.toNumber = s.prototype.e, s.prototype.toString = s.prototype.toString, p("goog.net.IpAddress", r), p("goog.net.Ipv4Address", N), p("goog.net.Ipv6Address", Q), r.fromString = function(a) {
            try {
                return -1 != a.indexOf(":") ? new Q(a) : new N(a)
            } catch (d) {
                return null
            }
        }, r.prototype = r.prototype, r.prototype.toInteger = r.prototype.h, r.prototype.getVersion = r.prototype.i
    }(), null == window.goog)
        throw new Error('Grunt Requireize: module does not define "window.goog"');
    return window.goog
}), fweb_define("md5", [], null, function() {
    var define = void 0;
    if (function($) {
        "use strict";
        function safe_add(x, y) {
            var lsw = (65535 & x) + (65535 & y), msw = (x >> 16) + (y >> 16) + (lsw >> 16);
            return msw << 16 | 65535 & lsw;
        }
        function bit_rol(num, cnt) {
            return num << cnt | num >>> 32 - cnt
        }
        function md5_cmn(q, a, b, x, s, t) {
            return safe_add(bit_rol(safe_add(safe_add(a, q), safe_add(x, t)), s), b)
        }
        function md5_ff(a, b, c, d, x, s, t) {
            return md5_cmn(b & c | ~b & d, a, b, x, s, t)
        }
        function md5_gg(a, b, c, d, x, s, t) {
            return md5_cmn(b & d | c & ~d, a, b, x, s, t)
        }
        function md5_hh(a, b, c, d, x, s, t) {
            return md5_cmn(b ^ c ^ d, a, b, x, s, t)
        }
        function md5_ii(a, b, c, d, x, s, t) {
            return md5_cmn(c ^ (b | ~d), a, b, x, s, t)
        }
        function binl_md5(x, len) {
            x[len >> 5] |= 128 << len % 32, x[(len + 64 >>> 9 << 4) + 14] = len;
            var i, olda, oldb, oldc, oldd, a = 1732584193, b = -271733879, c = -1732584194, d = 271733878;
            for (i = 0; i < x.length; i += 16)
                olda = a, oldb = b, oldc = c, oldd = d, a = md5_ff(a, b, c, d, x[i], 7, -680876936), d = md5_ff(d, a, b, c, x[i + 1], 12, -389564586), c = md5_ff(c, d, a, b, x[i + 2], 17, 606105819), b = md5_ff(b, c, d, a, x[i + 3], 22, -1044525330), a = md5_ff(a, b, c, d, x[i + 4], 7, -176418897), d = md5_ff(d, a, b, c, x[i + 5], 12, 1200080426), c = md5_ff(c, d, a, b, x[i + 6], 17, -1473231341), b = md5_ff(b, c, d, a, x[i + 7], 22, -45705983), a = md5_ff(a, b, c, d, x[i + 8], 7, 1770035416), d = md5_ff(d, a, b, c, x[i + 9], 12, -1958414417), c = md5_ff(c, d, a, b, x[i + 10], 17, -42063), b = md5_ff(b, c, d, a, x[i + 11], 22, -1990404162), a = md5_ff(a, b, c, d, x[i + 12], 7, 1804603682), d = md5_ff(d, a, b, c, x[i + 13], 12, -40341101), c = md5_ff(c, d, a, b, x[i + 14], 17, -1502002290), b = md5_ff(b, c, d, a, x[i + 15], 22, 1236535329), a = md5_gg(a, b, c, d, x[i + 1], 5, -165796510), d = md5_gg(d, a, b, c, x[i + 6], 9, -1069501632), c = md5_gg(c, d, a, b, x[i + 11], 14, 643717713), b = md5_gg(b, c, d, a, x[i], 20, -373897302), a = md5_gg(a, b, c, d, x[i + 5], 5, -701558691), d = md5_gg(d, a, b, c, x[i + 10], 9, 38016083), c = md5_gg(c, d, a, b, x[i + 15], 14, -660478335), b = md5_gg(b, c, d, a, x[i + 4], 20, -405537848), a = md5_gg(a, b, c, d, x[i + 9], 5, 568446438), d = md5_gg(d, a, b, c, x[i + 14], 9, -1019803690), c = md5_gg(c, d, a, b, x[i + 3], 14, -187363961), b = md5_gg(b, c, d, a, x[i + 8], 20, 1163531501), a = md5_gg(a, b, c, d, x[i + 13], 5, -1444681467), d = md5_gg(d, a, b, c, x[i + 2], 9, -51403784), c = md5_gg(c, d, a, b, x[i + 7], 14, 1735328473), b = md5_gg(b, c, d, a, x[i + 12], 20, -1926607734), a = md5_hh(a, b, c, d, x[i + 5], 4, -378558), d = md5_hh(d, a, b, c, x[i + 8], 11, -2022574463), c = md5_hh(c, d, a, b, x[i + 11], 16, 1839030562), b = md5_hh(b, c, d, a, x[i + 14], 23, -35309556), a = md5_hh(a, b, c, d, x[i + 1], 4, -1530992060), d = md5_hh(d, a, b, c, x[i + 4], 11, 1272893353), c = md5_hh(c, d, a, b, x[i + 7], 16, -155497632), b = md5_hh(b, c, d, a, x[i + 10], 23, -1094730640), a = md5_hh(a, b, c, d, x[i + 13], 4, 681279174), d = md5_hh(d, a, b, c, x[i], 11, -358537222), c = md5_hh(c, d, a, b, x[i + 3], 16, -722521979), b = md5_hh(b, c, d, a, x[i + 6], 23, 76029189), a = md5_hh(a, b, c, d, x[i + 9], 4, -640364487), d = md5_hh(d, a, b, c, x[i + 12], 11, -421815835), c = md5_hh(c, d, a, b, x[i + 15], 16, 530742520), b = md5_hh(b, c, d, a, x[i + 2], 23, -995338651), a = md5_ii(a, b, c, d, x[i], 6, -198630844), d = md5_ii(d, a, b, c, x[i + 7], 10, 1126891415), c = md5_ii(c, d, a, b, x[i + 14], 15, -1416354905), b = md5_ii(b, c, d, a, x[i + 5], 21, -57434055), a = md5_ii(a, b, c, d, x[i + 12], 6, 1700485571), d = md5_ii(d, a, b, c, x[i + 3], 10, -1894986606), c = md5_ii(c, d, a, b, x[i + 10], 15, -1051523), b = md5_ii(b, c, d, a, x[i + 1], 21, -2054922799), a = md5_ii(a, b, c, d, x[i + 8], 6, 1873313359), d = md5_ii(d, a, b, c, x[i + 15], 10, -30611744), c = md5_ii(c, d, a, b, x[i + 6], 15, -1560198380), b = md5_ii(b, c, d, a, x[i + 13], 21, 1309151649), a = md5_ii(a, b, c, d, x[i + 4], 6, -145523070), d = md5_ii(d, a, b, c, x[i + 11], 10, -1120210379), c = md5_ii(c, d, a, b, x[i + 2], 15, 718787259), b = md5_ii(b, c, d, a, x[i + 9], 21, -343485551), a = safe_add(a, olda), b = safe_add(b, oldb), c = safe_add(c, oldc), d = safe_add(d, oldd);
            return [a, b, c, d]
        }
        function binl2rstr(input) {
            var i, output = "";
            for (i = 0; i < 32 * input.length; i += 8)
                output += String.fromCharCode(input[i >> 5] >>> i % 32 & 255);
            return output
        }
        function rstr2binl(input) {
            var i, output = [];
            for (output[(input.length >> 2) - 1] = void 0, i = 0; i < output.length; i += 1)
                output[i] = 0;
            for (i = 0; i < 8 * input.length; i += 8)
                output[i >> 5] |= (255 & input.charCodeAt(i / 8)) << i % 32;
            return output
        }
        function rstr_md5(s) {
            return binl2rstr(binl_md5(rstr2binl(s), 8 * s.length))
        }
        function rstr_hmac_md5(key, data) {
            var i, hash, bkey = rstr2binl(key), ipad = [], opad = [];
            for (ipad[15] = opad[15] = void 0, bkey.length > 16 && (bkey = binl_md5(bkey, 8 * key.length)), i = 0; 16 > i; i += 1)
                ipad[i] = 909522486 ^ bkey[i], opad[i] = 1549556828 ^ bkey[i];
            return hash = binl_md5(ipad.concat(rstr2binl(data)), 512 + 8 * data.length), binl2rstr(binl_md5(opad.concat(hash), 640))
        }
        function rstr2hex(input) {
            var x, i, hex_tab = "0123456789abcdef", output = "";
            for (i = 0; i < input.length; i += 1)
                x = input.charCodeAt(i), output += hex_tab.charAt(x >>> 4 & 15) + hex_tab.charAt(15 & x);
            return output
        }
        function str2rstr_utf8(input) {
            return unescape(encodeURIComponent(input))
        }
        function raw_md5(s) {
            return rstr_md5(str2rstr_utf8(s))
        }
        function hex_md5(s) {
            return rstr2hex(raw_md5(s))
        }
        function raw_hmac_md5(k, d) {
            return rstr_hmac_md5(str2rstr_utf8(k), str2rstr_utf8(d))
        }
        function hex_hmac_md5(k, d) {
            return rstr2hex(raw_hmac_md5(k, d))
        }
        function md5(string, key, raw) {
            return key ? raw ? raw_hmac_md5(key, string) : hex_hmac_md5(key, string) : raw ? raw_md5(string) : hex_md5(string)
        }
        "function" == typeof define && define.amd ? define(function() {
            return md5
        }) : $.md5 = md5
    }(this), null == window.md5)
        throw new Error('Grunt Requireize: module does not define "window.md5"');
    return window.md5
}), fweb_define("join-path", [], null, function() {
    function join(url, join_url) {
        for (var parts = [], i = 0, l = arguments.length; l > i; i++)
            parts = parts.concat(arguments[i].split("/"));
        var newParts = [];
        for (i = 0, l = parts.length; l > i; i++) {
            var part = parts[i];
            part && "." !== part && (".." === part ? newParts.pop() : newParts.push(part))
        }
        return "" === parts[0] && newParts.unshift(""), newParts.join("/") || (newParts.length ? "/" : ".")
    }
    var module = {exports: {}};
    return module.exports = join, module.exports
}), fweb_define("jquery.util_core", ["jquery", "jquery.throttle-debounce"], null, function($) {
    "use strict";
    function lookup_key(id) {
        if ("lang_prefixes" in window)
            for (var i = 0; i < window.lang_prefixes.length; ++i) {
                var prefix = window.lang_prefixes[i];
                "/" !== prefix.charAt(prefix.length - 1) && (prefix += "/");
                var new_id = prefix + id;
                if (new_id in fgt_lang)
                    return new_id
            }
        return null
    }
    function lookup_key_fallback(id) {
        var key = lookup_key(id);
        return null === key && id in fgt_lang && (key = id), key
    }
    function load_custom_lang() {
        $.ajax({url: "/" + fweb.CONFIG_GUI_NO + "/lang/" + guest_lang + ".js",dataFilter: function(resp) {
                return resp.replace("var fgt_lang =", "var custom_dict =")
            },dataType: "script",cache: !0,async: !1})
    }
    var exempt_lang_entry_list = {"#": 1," ": 1,_is_archived: 1,"": 1,"field_ip-based": 1,"field_service-negate": 1,"field_srcaddr-negate": 1,"field_dstaddr-negate": 1,"field_global-label": 1,"field_active-auth-method": 1,"field_sso-auth-method": 1,threat_utm_type: 1,"Web Access": 1,"web Access": 1,"File Access": 1,Email: 1,"Network Services": 1,Authentication: 1,"Remote Access": 1,General: 1,HTTPS: 1,SNMP: 1,SSH: 1,TELNET: 1,HTTP: 1,PING: 1,IPsec: 1,RIP: 1,OSPF: 1,VRRP: 1,IGMP: 1,PIM: 1,"Local.HTTP": 1,"radius-acct": 1,"probe-response": 1,Threattype: 1,risk1: 1,risk2: 1,risk3: 1,risk4: 1,risk5: 1,"General Interest - Personal": 1,"General Interest - Business": 1,"Security Risk": 1,"Bandwidth Consuming": 1,"Adult/Mature Content": 1,"Potentially Liable": 1,"General Interest": 1,"Local Categories": 1,Unrated: 1,"IPv6 Address": 1,Address: 1}, reported_missing = {};
    $.getInfo = function getInfo(id, interpolate_or_strict, silent, no_prefix) {
        function interp(result) {
            return interpolate && (result = $.stringInterpolate(result, interpolate)), result
        }
        /*FWB_CHANGE var interpolate, strict;
        if (Array.isArray(interpolate_or_strict) ? interpolate = interpolate_or_strict : strict = interpolate_or_strict, !("fgt_lang" in window))
            return strict ? null : id;
        if (!no_prefix) {
            var key = lookup_key(id);
            if (key)
                return interp(fgt_lang[key])
        }
        var state = top.state || {};
        return (window.is_guest || state.guest_language_code) && ("custom_dict" in window || load_custom_lang(), "custom_dict" in window && id in window.custom_dict) ? window.custom_dict[id] : id in fgt_lang ? interp(fgt_lang[id]) : (id in exempt_lang_entry_list || id in reported_missing || (reported_missing[id] = !0, getInfo.silent || silent || fweb.log.warn('No language entry found for "' + id + '"')), strict ? null : id)*/
        var interpolate, strict;
        if (Array.isArray(interpolate_or_strict)) {
            interpolate = interpolate_or_strict;
        } else {
            strict = interpolate_or_strict;
        }
        if (!('fgt_lang' in window)) {
            return strict ? null : id;
        }
        if (!no_prefix) {
            var key = lookup_key(id);
            if (key) {
                return interp(fgt_lang[key]);
            }
        }
        var state = top.state || {};
        if (window.is_guest || state.guest_language_code) {
            if (!('custom_dict' in window)) {
                load_custom_lang();
            }
            if ('custom_dict' in window && id in window.custom_dict) {
                return window.custom_dict[id];
            }
        }
        if (id in fgt_lang) {
            return interp(fgt_lang[id]);
        } else if (id in flt_lang){
            return interp(flt_lang[id]);
        }
        if (!(id in exempt_lang_entry_list) && !(id in reported_missing)) {
            reported_missing[id] = true;
            if (!getInfo.silent && !silent) {
                fweb.log.warn('No language entry found for "' + id + '"');
            }
        }
        return strict ? null : id;
    }, $.stringInterpolate = function(format, params) {
        return String(format).replace(/\{(\d+)\}/g, function(m, i) {
            return String(params[i])
        })
    }, $.hasInfo = function(id) {
        return null !== lookup_key_fallback(id)
    }, $.updateInfo = function(id, trans) {
        fgt_lang[id] = trans
    }, $.addScript = function(opt, force) {
        "string" == typeof opt && (opt = {url: opt,async: !1});
        var exists, src = opt.url;
        if ($("script").each(function() {
            return exists = $(this).attr("src") === src, !exists
        }), exists && !force)
            return $.Deferred().resolve().promise();
        var loaded = $.loadedScript || [];
        if ($(loaded).each(function() {
            return this.url === src && (exists = this.ajax), !exists
        }), exists && !force)
            return exists;
        var options = $.extend({dataType: "script",cache: !0,url: src}, opt), ajax = $.ajax(options);
        return loaded.push({url: src,ajax: ajax}), $.loadedScript = loaded, ajax
    }, $.addStyle = function(src, reload) {
        return fweb.util.dom.addStyle(src, reload)
    }, $.addLang = function(objs, langs) {
        "string" == typeof objs && "string" == typeof langs && (objs = [{path: objs,sec: langs}]);
        for (var obj, i = 0; obj = objs[i]; i++) {
            var path = obj.path, section = obj.sec;
            "/" !== path.charAt(path.length - 1) && (path += "/");
            for (var sections = section.split(":"), j = 0, len = sections.length; len > j; j++) {
                var prefix = path + sections[j];
                "lang_prefixes" in window ? window.lang_prefixes.splice(0, 0, prefix) : window.lang_prefixes = [prefix]
            }
        }
    }
}), fweb_define("cmdb", ["jquery"], "CMDB", function($) {
    "use strict";
    function setup_error_handler(error_callback, duplicate_callbacks) {
        $.isFunction(error_callback) && (error_handler.error_callback = error_callback), duplicate_callbacks && (error_handler.duplicate_callbacks = !0)
    }
    function error_filter(response) {
        var result = $.Deferred();
        return enable_promise_failure && "error" in response ? result.rejectWith(this, arguments).promise() : result.resolveWith(this, arguments).promise()
    }
    function set_enable_promise_failure(value) {
        enable_promise_failure = value
    }
    function api_cmdb_fetch(cmdb_path, cmdb_name, preferences, callback, async) {
        var parameters = {action: "select",path: cmdb_path,name: cmdb_name};
        $.extend(parameters, preferences);
        var jqxhr = $.ajax({url: "/api/cmdb",type: "GET",dataType: "json",data: {request: JSON.stringify(parameters)},async: "boolean" == typeof async ? async : !0}), dfd = new $.Deferred;
        return dfd.done(callback), jqxhr.then(error_filter).then(function(data, textStatus, jqXHR) {
            return data && data.results ? void dfd.resolve(data, textStatus) : error_handler.duplicate_callbacks ? dfd.resolve(null, textStatus) : (dfd.reject(data, textStatus, jqXHR, parameters), error_handler.error_callback(jqXHR, textStatus, "Not Found", parameters))
        }), jqxhr.error(function(jqXHR, textStatus, errorThrown) {
            return dfd.reject(errorThrown, textStatus, jqXHR, parameters), error_handler.error_callback(jqXHR, textStatus, errorThrown, parameters)
        }), dfd.promise()
    }
    function api_cmdb_fetch_default(cmdb_path, cmdb_name, callback, async) {
        return api_cmdb_fetch(cmdb_path, cmdb_name, {action: "fetch_default"}, callback, async)
    }
    function api_cmdb_fetch_list(cmdb_path, cmdb_name, cmdb_key, callback) {
        var list_dfd = new $.Deferred;
        list_dfd.done(callback), "undefined" == typeof cmdb_key && (cmdb_key = "name");
        var perfs = {format: {}};
        perfs.format[cmdb_key] = "";
        var dfd = api_cmdb_fetch(cmdb_path, cmdb_name, perfs);
        return dfd.then(function(data) {
            var option_list = $.map(data.results, function(v) {
                return v[cmdb_key]
            });
            list_dfd.resolve(option_list)
        }, list_dfd.reject), list_dfd.promise()
    }
    function __api_cmdb_edit_object(action, cmdb_path, cmdb_name, mkey, cmdb_object, callback, preferences) {
        var parameters = {action: action,path: cmdb_path,name: cmdb_name,mkey: mkey ? mkey : "",json: cmdb_object};
        $.extend(parameters, preferences);
        var jqxhr = $.ajax({url: "/api/cmdb",type: "POST",dataType: "json",data: {request: JSON.stringify(parameters)}}), dfd = new $.Deferred;
        return dfd.done(callback), jqxhr.success(function(data) {
            data && dfd.resolve(data)
        }), jqxhr.error(function(jqXHR, textStatus, errorThrown) {
            return dfd.reject(jqXHR, textStatus, errorThrown, parameters), error_handler.error_callback(jqXHR, textStatus, errorThrown, parameters)
        }), dfd.then(error_filter).promise()
    }
    function api_cmdb_edit_object(cmdb_path, cmdb_name, mkey, cmdb_object, callback, preferences) {
        return __api_cmdb_edit_object("edit", cmdb_path, cmdb_name, mkey, cmdb_object, callback, preferences)
    }
    function api_cmdb_append_object(cmdb_path, cmdb_name, mkey, cmdb_object, callback, preferences) {
        return __api_cmdb_edit_object("append", cmdb_path, cmdb_name, mkey, cmdb_object, callback, preferences)
    }
    function api_cmdb_clone_object(cmdb_path, cmdb_name, mkey, nkey, callback, preferences, cmdb_obj) {
        return preferences && "object" == typeof preferences ? preferences.nkey = nkey : preferences = {nkey: nkey}, __api_cmdb_edit_object("clone", cmdb_path, cmdb_name, mkey, cmdb_obj, callback, preferences)
    }
    function api_cmdb_move_object(cmdb_path, cmdb_name, mkey, callback, preferences) {
        var parameters = {action: "move",path: cmdb_path,name: cmdb_name,mkey: mkey};
        return $.extend(parameters, preferences), $.ajax({url: "/api/cmdb",type: "POST",dataType: "json",data: {request: JSON.stringify(parameters)},success: function(data) {
                data && "function" == typeof callback && callback(data)
            },error: error_handler.error_callback}).then(error_filter)
    }
    function api_cmdb_move_child(cmdb_path, cmdb_name, mkey, child, child_key, callback, preferences) {
        var parameters = {child: child,"child-key": child_key};
        return $.extend(parameters, preferences), api_cmdb_move_object(cmdb_path, cmdb_name, mkey, callback, parameters)
    }
    function api_cmdb_delete(cmdb_path, cmdb_name, mkey, callback, preferences) {
        var parameters = {action: "delete",path: cmdb_path,name: cmdb_name,mkey: mkey};
        return $.extend(parameters, preferences), $.ajax({url: "/api/cmdb",type: "POST",dataType: "json",data: {request: JSON.stringify(parameters)},success: function(data) {
                data && $.isFunction(callback) && callback(data)
            },error: error_handler.error_callback}).then(error_filter)
    }
    function api_cmdb_delete_child(cmdb_path, cmdb_name, mkey, child, child_key, callback, preferences) {
        var parameters = {child: child,"child-key": child_key};
        return $.extend(parameters, preferences), api_cmdb_delete(cmdb_path, cmdb_name, mkey, callback, parameters)
    }
    function api_cmdb_schema(cmdb_path, cmdb_name, preferences, callback, async) {
        var parameters = {action: "schema",path: cmdb_path,name: cmdb_name};
        return $.extend(parameters, preferences), $.ajax({url: "/api/cmdb",dataType: "json",data: {request: JSON.stringify(parameters)},async: "boolean" == typeof async ? async : !0,success: function(data, textStatus, jqXHR) {
                return data && data.results ? void ($.isFunction(callback) && callback(data, textStatus)) : error_handler.duplicate_callbacks && $.isFunction(callback) ? callback(null, textStatus) : error_handler.error_callback(jqXHR, textStatus, "Not Found")
            },error: error_handler.error_callback}).then(error_filter)
    }
    var error_handler = {error_callback: $.noop,duplicate_callbacks: !1}, enable_promise_failure = !1;
    return {fetch: api_cmdb_fetch,fetch_default: api_cmdb_fetch_default,fetch_list: api_cmdb_fetch_list,edit: api_cmdb_edit_object,append: api_cmdb_append_object,clone: api_cmdb_clone_object,move: api_cmdb_move_object,move_child: api_cmdb_move_child,schema: api_cmdb_schema,"delete": api_cmdb_delete,delete_child: api_cmdb_delete_child,setup_error_handler: setup_error_handler,enable_promise_failure: set_enable_promise_failure}
}), fweb_define("fweb.dialog", ["jquery", "ftnt_shared"], null, function($) {
    "use strict";
    var f = window.fweb = window.fweb || {};
    f.extend = $.extend, f.extend({iframe: function(url) {
            return fweb.log.warn('Using deprecated "fweb.iframe"'), {url: url}
        },dialog: function(content) {
            fweb.log.warn('Using deprecated "fweb.dialog"');
            var slide, params;
            return params = "object" == typeof content && content.url ? content : {content: content}, slide = new Sliderin(params), slide.open(), slide
        }}), f.extend({opener: function() {
            return fweb.log.warn('Using deprecated "fweb.opener"'), top["embedded-iframe"] || window.parent
        }})
}), fweb_define("fweb.features", ["jquery"], "fweb.features", function($) {
    "use strict";
    var deferred, URL = "/p/system/features/status/";
    return function() {
        return deferred || (deferred = $.getJSON(URL)), deferred.promise()
    }
}), fweb_define("fweb.interface", ["jquery"], "fweb.interface", function($) {
    "use strict";
    function intfs_info_fixup(intfs_info) {
        function fixup_each(intf_name, intf_info) {
            var setting_key, type_key, status_key, info_settings, icon, settings, CONNECTED = 2, DISCONNECTED = 1, ANY = 0, ZERO_WIDTH_SPACE = "​", ZERO_WIDTH_SPACES = "​​", intf_info_settings = {any: {settings: {sort_val: ANY,category: ZERO_WIDTH_SPACES},icon: "tool_select_all"},none: {settings: {sort_val: ANY,category: ZERO_WIDTH_SPACES},icon: "tool_unselect_all"},"virtual-wan": {settings: {sort_val: CONNECTED},icon: "tool_virtual-wan"},down: {settings: {sort_val: DISCONNECTED,category: ZERO_WIDTH_SPACE}},up: {settings: {sort_val: CONNECTED}}}, intf_icons = {"admin-down": {tunnel: "tool_tunnel_grey",wifi: "tool_wifi_grey","default": "tool_down_grey"},"link-down": {tunnel: "tool_down",wifi: "tool_down","default": "tool_down"},up: {tunnel: "tool_tunnel",wifi: "tool_wifi_4","default": "tool_up"}};
            intf_info.cls_set || (intf_info_settings.hasOwnProperty(intf_info.intf_cls) ? setting_key = intf_info.intf_cls : (intf_info.status === !1 ? (setting_key = "down", status_key = "admin-down") : intf_info.link === !1 ? (setting_key = "down", status_key = "link-down") : (setting_key = "up", status_key = "up"), type_key = "tunnel" === intf_info.intf_cls ? "tunnel" : intf_info.wifi ? "wifi" : "default"), info_settings = intf_info_settings[setting_key], icon = info_settings.icon ? info_settings.icon : intf_icons[status_key][type_key], settings = info_settings.settings, settings.cls = ["tool_sprite", icon].join(" "), settings.cls_set = !0, $.extend(intf_info, settings))
        }
        $.each(intfs_info, fixup_each)
    }
    function intfs_list(intfs_info, intf_cls_not_supported) {
        function intf_filter(intf_info, intf_name) {
            return -1 !== intf_cls_not_supported.indexOf(intf_info.intf_cls) ? null : intf_name
        }
        function intf_compare(intf1, intf2) {
            var info1 = intfs_info[intf1], info2 = intfs_info[intf2];
            return info2.sort_val - info1.sort_val || info1.text.toLowerCase().localeCompare(info2.text.toLowerCase())
        }
        return intf_cls_not_supported = intf_cls_not_supported || [], $.map(intfs_info, intf_filter).sort(intf_compare)
    }
    function get_display_fn(intfs_info) {
        return function(intf_name) {
            var category, cls, disabled, intf_info, text = intf_name ? intf_name : $.getInfo("click_add");
            return $.isPlainObject(intfs_info) && intfs_info.hasOwnProperty(intf_name) && (intf_info = intfs_info[intf_name], cls = intf_info.cls, category = intf_info.category, text = intf_info.text ? intf_info.text : text, category && category.length > 0 && "_" === category[0] && (category = !1), disabled = intf_info.disabled), {label: '<span class="' + cls + '">' + text + "</span>",category: category,disabled: disabled}
        }
    }
    var TYPE_ICON_MAP = {aggregate: "ftnt-aggregate",fortilink: "fa-fortilink","hard-switch": "ftnt-switch","hard-switch-vlan": "ftnt-switch",loopback: "ftnt-loopback",physical: "ftnt-interface",trunk: "ftnt-interface",redundant: "ftnt-aggregate","switch": "ftnt-switch","switch-vlan": "ftnt-vlan",tunnel: "ftnt-vpn-tunnel","vap-switch": "fa-wifi",vdlink: "fa-link","vdom-link": "fa-link","npu-vlink": "ftnt-npu","npu-vlink-pair": "ftnt-npu","virtual-wan": "ftnt-virtual-wan-link",virtual_wire_pair: "ftnt-virtual-wire-pair",vlan: "ftnt-vlan",wireless: "fa-wifi","wl-mesh": "fa-wifi",zone: "fa-square-o"};
    return {TYPE_ICON_MAP: TYPE_ICON_MAP,intfs_info_fixup: intfs_info_fixup,intfs_list: intfs_list,get_display_fn: get_display_fn}
}), fweb_define("fweb.util/core", null, "fweb.util.core", function() {
    "use strict";
    var module = {};
    return module.generate_uuid = function() {
        return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function(c) {
            var r = 16 * Math.random() | 0, v = "x" === c ? r : 3 & r | 8;
            return v.toString(16)
        })
    }, module
}), fweb_define("fweb.util/uri", ["jquery", "fweb.util/persist"], "fweb.util.uri", function($, persist) {
    "use strict";
    function cachePath(path) {
        if (!path || "/" !== path[0])
            throw new Error("Path must be an absolute path");
        return "/" + fweb.CONFIG_GUI_NO + path
    }
    function urlParams(search) {
        function makeParams(result, param) {
            var match = split.exec(param), key = match && decodeURIComponent(match[1]), value = match && decodeURIComponent(match[2]);
            if (match)
                if (key in result) {
                    var old = result[key];
                    Array.isArray(old) || (result[key] = [old]), result[key].push(value)
                } else
                    result[key] = value;
            return result
        }
        search = (search || location.search).replace(/^\?/, "");
        var split = /^([^=]+)=(.*)/;
        return search.split("&").reduce(makeParams, {})
    }
    function formatParams(search) {
        return Object.keys(search).map(function(key) {
            return encodeURIComponent(key) + "=" + encodeURIComponent(search[key])
        }).join("&")
    }
    function makeExpression(uri) {
        var LAST_SLASH_REGEXP = /\/$/, ESCAPE_REGEXP = /[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g;
        return uri = uri.replace(LAST_SLASH_REGEXP, "").replace(ESCAPE_REGEXP, "\\$&"), new RegExp(uri + "(/.*)?")
    }
    function indicateFileDownloadIntention() {
        window[FILE_DOWNLOADING_IFRAME_FLAG] = !0
    }
    function downloadFile(uri) {
        var deferred = $.Deferred(), cookieName = top.state.file_downloading_cookie_name;
        return setTimeout(function checkCookieSet() {
            var cookie = persist.getCookie(cookieName);
            cookie ? (persist.removeCookie(cookieName), deferred.resolve(cookie)) : setTimeout(checkCookieSet, FILE_DOWNLOAD_CHECK_INTERVAL)
        }, FILE_DOWNLOAD_CHECK_INTERVAL), persist.removeCookie(cookieName), indicateFileDownloadIntention(), window.location.assign(uri), deferred.promise()
    }
    var FILE_DOWNLOAD_CHECK_INTERVAL = 1e3, FILE_DOWNLOADING_IFRAME_FLAG = "fileDownloadingInsideIframe";
    return {FILE_DOWNLOADING_IFRAME_FLAG: FILE_DOWNLOADING_IFRAME_FLAG,cachePath: cachePath,urlParams: urlParams,formatParams: formatParams,makeExpression: makeExpression,indicateFileDownloadIntention: indicateFileDownloadIntention,downloadFile: downloadFile}
}), fweb_define("fweb.util/location", ["fweb.util/structure", "jquery", "ftnt_shared"], "fweb.util.location", function(structure, $) {
    "use strict";
    var module = {}, location_cache = {}, PATH_RESOLUTION_MESSAGE = "pathAvailable", lastMessageID = 0;
    return module.get_current = function(window_object) {
        var loc = (window_object || window).location;
        return loc.pathname + loc.search + loc.hash
    }, module.login_redirect = function(redirect) {
        var REDIR_PARAM = "?redir=", uri = "/login";
        redirect ? uri += REDIR_PARAM + encodeURIComponent(redirect) : null == redirect && (uri += REDIR_PARAM + encodeURIComponent(module.get_current())), top.location.href = uri
    }, module.change_ng = function(path, search, embedded) {
        var message = {messageType: "changeNgLocation",path: path,search: search,embedded: embedded};
        structure.topPostMessage(message)
    }, module.get_cache = function(key, initial) {
        var result;
        return key in location_cache ? result = location_cache[key] : null !== initial && (result = module.set_cache(key, initial)), result
    }, module.set_cache = function(key, value) {
        var result = location_cache[key] = value;
        return result
    }, module.clear_cache = function() {
        location_cache = {}
    }, module.go_back = function(url, resolve) {
        var slide_fn = resolve ? Sliderin.resolveAndCloseLast : Sliderin.closeLast;
        slide_fn() || (url ? window.location.href = url : history.back())
    }, module.ifPathAvailable = function(path) {
        var origin = structure.getOrigin(), messageID = lastMessageID++, namespace = ".locationMessage" + messageID, result = $.Deferred(), message = {messageType: PATH_RESOLUTION_MESSAGE,id: messageID,path: path,namespace: namespace};
        return $(window).on("message" + namespace, function(e) {
            var originalEvent = e.originalEvent, data = originalEvent.data, eventOrigin = originalEvent.origin, isTrustedOrigin = eventOrigin === origin;
            data.messageType === PATH_RESOLUTION_MESSAGE && isTrustedOrigin && data.id === messageID && (data.result ? result.resolve() : result.reject()), data.namespace === namespace && $(window).off("message" + namespace)
        }), structure.topPostMessage(message), result.promise()
    }, module
}), fweb_define("fweb.util/datetime", ["jquery", "jquery.ui"], "fweb.util.datetime", function($) {
    "use strict";
    var module = {};
    module.S_TO_MS = 1e3, module.MS_TO_S = 1 / module.S_TO_MS;
    var TZOFFSET_TO_SECONDS = 60;
    module.localSecondsToDate = function(unixseconds) {
        if (unixseconds = Number(unixseconds), !unixseconds)
            return null;
        var tzOffset = (new Date).getTimezoneOffset() * TZOFFSET_TO_SECONDS, result = new Date((unixseconds + tzOffset) * module.S_TO_MS), newTZOffset = result.getTimezoneOffset() * TZOFFSET_TO_SECONDS;
        return newTZOffset !== tzOffset && (result = new Date((unixseconds + newTZOffset) * module.S_TO_MS)), result
    }, module.gmtSecondsToDate = function(unixseconds) {
        return new Date(unixseconds * module.S_TO_MS)
    }, module.dateToLocalSeconds = function(date) {
        var offsetSeconds = (new Date).getTimezoneOffset() * TZOFFSET_TO_SECONDS;
        return Math.round(date.getTime() * module.MS_TO_S - offsetSeconds)
    }, module.getLocalDate = function(ms, date_only) {
        var dt = new Date, pad = function(n) {
            return 10 > n ? "0" + n : n
        };
        dt.setTime(ms);
        var value = dt.getFullYear() + "-" + pad(dt.getMonth() + 1) + "-" + pad(dt.getDate());
        return date_only || (value += " " + pad(dt.getHours()) + ":" + pad(dt.getMinutes()) + ":" + pad(dt.getSeconds())), value
    }, module.humanize_seconds = function(time, short) {
        var days = Math.floor(time / 86400), hours = Math.floor(time / 3600) % 24, mins = Math.floor(time / 60) % 60, secs = Math.floor(time % 60), space = short ? "" : " ";
        return short = short ? "_short" : "", time ? (time = [], days && (time.push(days + space), time.push($.getInfo("days" + short) + " ")), hours && (time.push(hours + space), time.push($.getInfo("hours" + short) + " ")), mins && (time.push(mins + space), time.push($.getInfo("minutes" + short) + " ")), secs && (time.push(secs + space), time.push($.getInfo("seconds" + short) + " ")), time = time.join("")) : time = "", time
    };
    var minute = 60, hour = 60 * minute, timeframes = {realtime: !1,"5min": 5 * minute,hour: hour,day: 24 * hour,week: 24 * hour * 7};
    return module.timeframeRange = function(timeframe) {
        var seconds = timeframes[timeframe];
        if (!seconds)
            return {};
        var now = Math.ceil(Date.now() / 1e3);
        return {end: now,start: now - seconds}
    }, module.ParseDateTimeException = function() {
        if (!(this instanceof module.ParseDateTimeException))
            throw Error("Use new keyword when creating ParseDateTimeException");
        Error.apply(this, arguments)
    }, module.ParseDateTimeException.prototype = new Error, module.ParseDateTimeException.prototype.constructor = module.ParseDateTimeException, module.parseDateTime = function(value) {
        var hours = /([\d]{2}):([\d]{2}):(\d{2})$/.exec(String(value).trim()), date = module.parseDate(value);
        if (hours)
            hours = new Date(0, 0, 0, hours[1], hours[2], hours[3]).getTime() - new Date(0, 0, 0, 0, 0, 0).getTime();
        else if ("" !== value.replace(/^[^\s]+\s*/, "").trim())
            throw new module.ParseDateTimeException("Invalid date");
        return null != date ? new Date((date ? date.getTime() : 0) + (hours || 0)) : null
    }, module.parseDate = function(value) {
        var dateFormat = $.datepicker._defaults.dateFormat;
        try {
            return $.datepicker.parseDate(dateFormat, value)
        } catch (e) {
            throw new Error(e + " while parsing " + value)
        }
    }, module.dateTimeFormat = $.datepicker._defaults.dateFormat + "yy hh:mm:ss", module.formatDateTime = function(date, dateFormat) {
        return module.formatDate(date, dateFormat).toString() + " " + module.formatTime(date)
    }, module.formatDate = function(date, dateFormat) {
        dateFormat = dateFormat || $.datepicker._defaults.dateFormat;
        try {
            return $.datepicker.formatDate(dateFormat, date)
        } catch (e) {
            throw new Error(e)
        }
    }, module.formatTime = function(date) {
        function lpad(value) {
            for (value = String(value); value.length < 2; )
                value = "0" + value;
            return value
        }
        return [date.getHours(), date.getMinutes(), date.getSeconds()].map(lpad).join(":")
    }, module.TimeSpan = function() {
        for (var args = Array.prototype.slice.call(arguments); args.length < 7; )
            args.unshift(0);
        var TSDate = Date.bind.apply(Date, [null].concat(args));
        this.value = new TSDate
    }, module.TimeSpan.zeroDate = new Date(0, 0, 0, 0, 0, 0, 0).getTime(), module.TimeSpan.prototype.getTime = function() {
        return this.value.getTime() - module.TimeSpan.zeroDate
    }, module.MIN_DATE = new Date(0, 0, 0), module.MAX_DATE = new Date(9999, 0, 0), module.S_TO_MS = 1e3, module.MS_TO_S = 1 / module.S_TO_MS, module.dateTimeFormat = $.datepicker._defaults.dateFormat + "yy hh:mm:ss", module.formatDateTime = function(date, dateFormat) {
        return module.formatDate(date, dateFormat).toString() + " " + module.formatTime(date)
    }, module.formatDate = function(date, dateFormat) {
        dateFormat = dateFormat || $.datepicker._defaults.dateFormat;
        try {
            return $.datepicker.formatDate(dateFormat, date)
        } catch (e) {
            throw new Error(e)
        }
    }, module.formatTime = function(date) {
        function lpad(value) {
            for (value = String(value); value.length < 2; )
                value = "0" + value;
            return value
        }
        return [date.getHours(), date.getMinutes(), date.getSeconds()].map(lpad).join(":")
    }, module.timeInputAsDate = function(value) {
        var time = (value || "00:00:00").split(":");
        return new Date(1970, 0, 1, parseInt(time[0], 10), parseInt(time[1], 10), parseInt(time[2], 10))
    }, module.elapsedTime = function() {
        var SECOND = 1e3, MINUTE = 60 * SECOND, HOUR = 60 * MINUTE, DAY = 24 * HOUR, PERIODS = [DAY, HOUR, MINUTE, SECOND], PERIOD_MAX_INDICES = ["day", "hour", "minute", "second"], LANG_KEY_MAP = {};
        return LANG_KEY_MAP[DAY] = "fmt_elapsed_time_days", LANG_KEY_MAP[HOUR] = "fmt_elapsed_time_hours", LANG_KEY_MAP[MINUTE] = "fmt_elapsed_time_minutes", LANG_KEY_MAP[SECOND] = "fmt_elapsed_time_seconds", function(milliseconds, format, max) {
            var result, lang_key, list = [], is_short = "short" === format, value_added = is_short, add_period = function(period) {
                var count = Math.floor(milliseconds / period), value = count;
                is_short && (value = "", 10 > count && (value += "0"), value += count), (count || value_added) && (list.push(value), milliseconds -= period * count, lang_key = lang_key || LANG_KEY_MAP[period], value_added = !0)
            };
            return "number" == typeof milliseconds && isFinite(milliseconds) && (PERIODS.slice(PERIOD_MAX_INDICES.indexOf(max || "day")).forEach(add_period), result = is_short ? list.join(":") : $.getInfo(lang_key, list)), result
        }
    }(), module.formatDateDiff = function(dateOld, dateNow) {
        dateNow || (dateNow = new Date);
        var result = "";
        return result = dateOld.toDateString() === dateNow.toDateString() ? [$.pad(dateOld.getHours()), $.pad(dateOld.getMinutes()), $.pad(dateOld.getSeconds())].join(":") : dateOld.getYear() === dateNow.getYear() ? $.pad(dateOld.getMonth() + 1) + "-" + $.pad(dateOld.getDate()) + " " + $.pad(dateOld.getHours()) + ":" + $.pad(dateOld.getMinutes()) : [dateOld.getYear() + 1900, $.pad(dateOld.getMonth() + 1), $.pad(dateOld.getDate())].join("-")
    }, module
}), fweb_define("fweb.util/patterns", null, "fweb.util.patterns", function() {
    "use strict";
    var module = {};
    module.commonRegExp = function() {
        return {IP_SUBNET: /^((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])([\/ ]{1}((((254|252|248|240|224|192|128|0)\.0\.0\.0)|(255\.(254|252|248|240|224|192|128|0)\.0\.0)|(255\.255\.(254|252|248|240|224|192|128|0)\.0)|(255\.255\.255\.(255|254|252|248|240|224|192|128|0))|(3[0-2]|2[0-9]|1[0-9]|[0-9]))))?$/,SUBNET: /^((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\/((((254|252|248|240|224|192|128|0)\.0\.0\.0)|(255\.(254|252|248|240|224|192|128|0)\.0\.0)|(255\.255\.(254|252|248|240|224|192|128|0)\.0)|(255\.255\.255\.(255|254|252|248|240|224|192|128|0))|(3[0-2]|2[0-9]|1[0-9]|[0-9])))$/,XSS: /^[^<>()#'"]*$/,IP_HOST: /^((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])$/,IP_MASK: /^(((255|254|252|248|240|224|192|128|0)\.0\.0\.0)|(255\.(255|254|252|248|240|224|192|128)\.0\.0)|(255\.255\.(255|254|252|248|240|224|192|128)\.0)|(255\.255\.255\.(255|254|252|248|240|224|192|128|0)))$/,IP_RANGE: /^((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])(-(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])|-((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])|\/(3[0-2]|[1-2][0-9]|[0-9]))?$/,IP_RANGE_SPACES: /^((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])(-(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])|\s+-\s+((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])|\/(3[0-2]|[1-2][0-9]|[0-9]))?$/,IP_RANGE2: /^((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}\[(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])-(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\]/,IP_WILDCARD: /^((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}\*$/,IP6_HOST: /^((([0-9A-Fa-f]{1,4}:){7}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}:[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){5}:([0-9A-Fa-f]{1,4}:)?[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){4}:([0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){3}:([0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){2}:([0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}((\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b)\.){3}(\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b))|(([0-9A-Fa-f]{1,4}:){0,5}:((\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b)\.){3}(\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b))|(::([0-9A-Fa-f]{1,4}:){0,5}((\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b)\.){3}(\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b))|([0-9A-Fa-f]{1,4}::([0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})|(::([0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){1,7}:)|(::))$/,IP6_HOST_NOT0: /^((([0-9A-Fa-f]{1,4}:){7}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}:[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){5}:([0-9A-Fa-f]{1,4}:)?[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){4}:([0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){3}:([0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){2}:([0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}((\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b)\.){3}(\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b))|(([0-9A-Fa-f]{1,4}:){0,5}:((\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b)\.){3}(\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b))|(::([0-9A-Fa-f]{1,4}:){0,5}((\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b)\.){3}(\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b))|([0-9A-Fa-f]{1,4}::([0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})|(::([0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){1,7}:))$/,
            IP6_SUBNET: /^((([0-9A-Fa-f]{1,4}:){7}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}:[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){5}:([0-9A-Fa-f]{1,4}:)?[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){4}:([0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){3}:([0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){2}:([0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}((\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b)\.){3}(\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b))|(([0-9A-Fa-f]{1,4}:){0,5}:((\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b)\.){3}(\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b))|(::([0-9A-Fa-f]{1,4}:){0,5}((\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b)\.){3}(\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b))|([0-9A-Fa-f]{1,4}::([0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})|(::([0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){1,7}:)|(::))([\/]((12[0-8]|1[0-1][0-9]|0?[0-9]?[0-9])))?$/,DOMAIN_NAME: /^([a-z0-9\-]{1,63}\.)+[a-z]{2,63}$/,MAC_ADDRESS: /^[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}$/,MULTICAST_IP_HOST: /^(2(2[4-9]|3[0-9]))\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])$/,MULTICAST_IP_RANGE: /^(2(2[4-9]|3[0-9]))\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])-(2(2[4-9]|3[0-9]))\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])$/,NAME_NODOLLAR: /^[^<>#()"'$][^<>#()"']*$|^$/,FQDN: /^([a-zA-Z0-9\-]{1,63}\.?)+$/}
    }(), module.re_escape = function(str) {
        return str.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, "\\$&")
    };
    var htmlStringOuter = function(self, target, inner) {
        var _ref, current_substr, str_index, texts, targetlen = target.length, attr_re = /(?:title)=(?:"([^"\\]*(\\.[^"\\]*)*)"|\'([^\'\\]*(\\.[^\'\\]*)*)\')/g, tag_re = /<.+?>/g;
        if (self.indexOf("<") >= 0 && target.indexOf("<") < 0) {
            texts = self.split(tag_re);
            for (var i = 0, ii = texts.length; ii > i && (current_substr = texts[i], !0); i++)
                if ((str_index = current_substr.indexOf(target)) >= 0 && inner(current_substr, str_index, targetlen) === !1)
                    return;
            for (; null != (_ref = attr_re.exec(self)); )
                if ((str_index = (current_substr = _ref[1] || _ref[3] || "").indexOf(target)) >= 0 && inner(current_substr, str_index, targetlen) === !1)
                    return
        } else
            str_index = self.indexOf(target), str_index >= 0 && inner(self, str_index, targetlen)
    };
    return module.htmlStringContains = function(self, target) {
        var matched = !1;
        return htmlStringOuter(self, target, function() {
            return matched = !0, !1
        }), matched
    }, module.htmlStringSearch = function(self, target) {
        var results = [];
        return htmlStringOuter(self, target, function(matchsource, index, matchlen) {
            var result = [index, index + matchlen];
            result.source = matchsource, results.push(result)
        }), results
    }, module.phoneNumberInputMask = "999-999-999?999999", module
}), fweb_define("fweb.util/ip", ["fweb.util/patterns", "closure-ipaddress"], "fweb.util.ip", function(patterns, goog) {
    "use strict";
    var module = {};
    return module.IpMask = function() {
        function IpMask(ip, mask) {
            "string" == typeof ip && (ip = IpMask.toDotted(ip)), "string" == typeof mask && (mask = IpMask.toDotted(mask)), this.addr = ip, this.netmask = mask
        }
        return IpMask.prototype = {clone: function() {
                return new IpMask(this.addr.slice(), this.netmask.slice())
            },contains: function(numbered) {
                return numbered >= this.numbered(IpMask.RANGE_LOW) && numbered <= this.numbered(IpMask.RANGE_HIGH)
            },numbered: function(type) {
                var n, m;
                switch (type) {
                    case IpMask.RANGE_LOW:
                        return this.numbered(IpMask.NETWORK) + 1;
                    case IpMask.RANGE_HIGH:
                        return this.numbered(IpMask.BROADCAST) - 1;
                    case IpMask.NETWORK:
                        return n = IpMask.toNumber(this.addr), m = IpMask.toNumber(this.netmask), (n & m) >>> 0;
                    case IpMask.BROADCAST:
                        return n = IpMask.toNumber(this.addr), m = IpMask.toNumber(this.netmask), n &= m, n + ~m >>> 0;
                    default:
                        return IpMask.toNumber(this.addr)
                }
            },prefix_length: function() {
                IpMask._prefix_map || IpMask.build_netmask_prefix_map();
                var netmask_str = this.netmask.join(".");
                return IpMask._prefix_map[netmask_str] || 0
            },full_network: function() {
                var _this = this, network = IpMask.toDotted(_this.numbered(IpMask.NETWORK)).join("."), netmask = _this.prefix_length();
                return network + "/" + netmask
            },overlaps: function(ip) {
                var target_ipmask = IpMask.parse(ip), min_netmask = Math.min(IpMask.toNumber(target_ipmask.netmask), IpMask.toNumber(this.netmask)), target_numbered_addr = target_ipmask.numbered(), my_numbered_addr = this.numbered(), my_min_network_addr = my_numbered_addr & min_netmask, target_min_network_addr = target_numbered_addr & min_netmask;
                return my_min_network_addr && target_min_network_addr && my_min_network_addr === target_min_network_addr ? !0 : !1
            },toString: function(sep) {
                return sep = sep || "/", [this.addr.join("."), this.netmask.join(".")].join(sep)
            }}, IpMask.IP_LEN = 4, IpMask.BROADCAST = 1, IpMask.NETWORK = 2, IpMask.RANGE_HIGH = 3, IpMask.RANGE_LOW = 4, IpMask.parse = function(ip) {
            if (!patterns.commonRegExp.IP_SUBNET.test(ip))
                return null;
            var i, components = ip.split("/"), mask = 0, maskComponents = [];
            if (1 === components.length && (components = ip.split(" ")), 1 === components.length && components.push("32"), /\./.test(components[1]))
                maskComponents = components[1].split(".");
            else
                for (mask = ~((1 << 32 - components[1]) - 1), i = 0; 4 > i; ++i)
                    maskComponents.unshift(255 & mask), mask >>= 8;
            return new IpMask(components[0].split(".").map(Number), maskComponents.map(Number))
        }, IpMask.toDotted = function(ip) {
            if ("string" == typeof ip)
                return ip.split(".").map(Number);
            var i, result = [];
            for (i = 0; i < IpMask.IP_LEN; ++i)
                result.unshift(255 & ip), ip >>= 8;
            return result
        }, IpMask.toNumber = function(ip) {
            for (var result = 0, i = 0; i < IpMask.IP_LEN; ++i)
                result = result << 8 | ip[i];
            return result >>> 0
        }, IpMask.build_netmask_prefix_map = function() {
            var i, result = {}, num = 1 << 31 >>> 0;
            for (i = 0; 32 > i; i++) {
                var dotted = IpMask.toDotted(num).join(".");
                result[dotted] = i + 1, num = (num | num >> 1) >>> 0
            }
            return IpMask._prefix_map = result, IpMask._prefix_map
        }, IpMask.isPublic = function(address) {
            var ipAddress = goog.net.IpAddress.fromString(address), version = ipAddress && ipAddress.getVersion();
            if (4 === version) {
                var octets = IpMask.toDotted(address);
                return 0 === octets[0] ? !1 : 10 === octets[0] ? !1 : 127 === octets[0] ? !1 : 169 === octets[0] && 254 === octets[1] ? !1 : 172 === octets[0] && octets[1] >= 16 && octets[1] <= 32 ? !1 : 192 === octets[0] && 0 === octets[1] && 0 === octets[2] ? !1 : 192 === octets[0] && 0 === octets[1] && 2 === octets[2] ? !1 : 192 === octets[0] && 168 === octets[1] ? !1 : octets[0] >= 224 && octets[0] <= 239 ? !1 : !0
            }
            return !1
        }, IpMask
    }(), module.natType = function(sourceip, destinationip) {
        function getVersion(ip) {
            return ip ? ip.getVersion() : void 0
        }
        var ver = [goog.net.IpAddress.fromString(sourceip), goog.net.IpAddress.fromString(destinationip)].map(getVersion);
        return void 0 === ver[0] || void 0 === ver[1] || ver[0] === ver[1] ? ver[0] && ver[1] : parseInt(ver.join(""), 10)
    }, module
}), fweb_define("fweb.util/formatters", ["jquery", "fweb.util/ip", "fweb.util/icon"], "fweb.util.formatters", function($, fweb_ip, fweb_icon) {
    "use strict";
    var module = {}, METRIC_BASE = 1e3, BINARY_BASE = 1024, BYTE_TO_BITS = 8, BYTE_TO_KBITS = 1 * BYTE_TO_BITS / METRIC_BASE, METRIC_BYTES_UNITS = [{label: "B",decimal_places: 0}, "KB", "MB", "GB", "TB", "PB"], BINARY_BYTES_UNITS = [{label: "B",decimal_places: 0}, "KiB", "MiB", "GiB", "TiB", "PiB"], METRIC_BITS_PER_SECOND_UNITS = [{label: "bps",decimal_places: 0}, "Kbps", "Mbps", "Gbps", "Tbps", "Pbps"], WHOIS_LOOKUP_IP = "https://www.networksolutions.com/whois/results.jsp?ip=", create_number_units_formatter = function(units, base) {
        return function(number, decimal_places) {
            number = Number(number), decimal_places = null == decimal_places ? 2 : decimal_places, isNaN(number) && (number = 0);
            for (var unit, label, suffix, units_length = units.length, i = 0; units_length > i && (unit = units[i], number >= base && i !== units_length - 1); i++)
                number /= base;
            return "object" == typeof unit ? (label = unit.label, decimal_places = unit.decimal_places) : label = unit, suffix = label ? " " + label : "", number.toFixed(decimal_places) + suffix
        }
    };
    return module.metric_bytes = create_number_units_formatter(METRIC_BYTES_UNITS, METRIC_BASE), module.binary_bytes = create_number_units_formatter(BINARY_BYTES_UNITS, BINARY_BASE), module.metric_bits_per_second = create_number_units_formatter(METRIC_BITS_PER_SECOND_UNITS, METRIC_BASE), module.bytes_to_bits = function(number) {
        return BYTE_TO_BITS * number
    }, module.bytes_to_kbits = function(number) {
        return BYTE_TO_KBITS * number
    }, module.number = function(number) {
        return number.toLocaleString()
    }, module.create_whois_lookup_anchor = function(address) {
        return fweb_ip.IpMask.isPublic(address) ? '&nbsp;<a class="whois-lookup-address show-on-hover show-on-select" href="' + WHOIS_LOOKUP_IP + address + '" target="_blank"><f-icon class="fa-external-link icon-sm" title="' + $.getInfo("WHOIS Information for", [address]) + '"></f-icon></a>' : ""
    }, module.vdom_icon_class = function(vdom_name) {
        var state = top.state, icon_key = fweb_icon.genVdomIconKey(vdom_name, state), icon_class = fweb_icon.iconClass(fweb_icon.ICON_TYPE.VDOM, icon_key);
        return state.admin.vdom_info[vdom_name].is_management_vdom && state.admin.super_admin && (icon_class += " ftnt-management-vdom"), icon_class
    }, module.vdom_format_fn = function(td, col, entry) {
        var vdom_name = entry[col.selector], state = top.state, icon_key = fweb_icon.genVdomIconKey(vdom_name, state);
        return icon_key ? fweb_icon.formatIcon(fweb_icon.ICON_TYPE.VDOM, icon_key, {label: vdom_name}) : ""
    }, module.path_name_format = function(path_name) {
        var split = path_name.split("."), last_index = split.length - 1, path = split.slice(0, last_index).join("."), name = split[last_index];
        return {path: path,name: name}
    }, module.truncate_string = function(str, len) {
        var truncate_length = len || 32, end = "…", trunc_str = str;
        return str && str.length > truncate_length && (trunc_str = str.substr(0, truncate_length - end.length) + end), trunc_str
    }, module.truncate_comment = function(comment, len, cls) {
        var f_dom = fweb_require("fweb.util/dom");
        if ("undefined" != typeof comment) {
            var esc_comment = f_dom.escapeHTML(comment), trunc_comment = module.truncate_string(comment, len), cls_comment = cls ? 'class="' + cls + '"' : "";
            return trunc_comment === comment ? esc_comment : '<span title="' + esc_comment + '"' + cls_comment + ">" + f_dom.escapeHTML(trunc_comment) + "</span>"
        }
        return ""
    }, module
}), fweb_define("fweb.util/dom", ["jquery", "fweb.util/formatters", "fweb.util/location", "fweb.util/uri"], "fweb.util.dom", function($, formatters, fweb_location, fweb_uri) {
    "use strict";
    var module = {}, getContainingWindow = module.getContainingWindow = function(el) {
        var _ref, doc = el.ownerDocument;
        return null != doc ? null != (_ref = doc.defaultView) ? _ref : doc.parentWindow : void 0
    };
    module.getCorrectJQuery = function(el) {
        var _ref;
        return null != (_ref = getContainingWindow(el)) ? _ref.jQuery : $
    }, module.$detached = function($el, callback) {
        var anchor, reattach = $.noop;
        return anchor = $el.next(), anchor.length > 0 ? reattach = function() {
            anchor.before($el)
        } : (anchor = $el.parent(), reattach = function() {
            anchor.append($el)
        }), $el.detach(), void 0 === callback ? reattach : (callback($el), void reattach())
    }, module.firstData = function($els, key) {
        var data;
        return $els.each(function(i, el) {
            var elData = jQuery.data(el, key);
            return null != elData ? (data = elData, !1) : void 0
        }), data
    }, module.getURIParamOnce = function(param) {
        var alreadyChecked = fweb_location.get_cache("domURLParamOnce", {});
        return alreadyChecked[param] ? void 0 : (alreadyChecked[param] = !0, fweb_uri.urlParams()[param])
    }, module.try_JSON_parse = function(x) {
        try {
            return JSON.parse(x)
        } catch (e) {
        }
    }, module.serializeForm = function($form) {
        var SINGULAR_VALUE = {enable: !0,disable: !0}, serialized = {};
        return $form.serializeArray().forEach(function(field) {
            var current = serialized[field.name];
            current && !SINGULAR_VALUE[field.value] ? (Array.isArray(current) || (serialized[field.name] = current = [current]), current.push(field.value)) : serialized[field.name] = field.value
        }), serialized
    }, module.showWaitWhile = function(promise) {
        var $div = $('<div class="wait-while-loading"><div class="flexbox_center"><div class="loading_image"></div></div></div>'), $overlay = $('<div class="wait-while-loading-overlay"></div>');
        $div.appendTo("body"), $overlay.appendTo("body");
        var resolve = "function" == typeof promise.always ? "always" : "finally";
        promise[resolve](function() {
            $div.remove(), $overlay.remove()
        })
    }, module.renderTemplate = function(template, context) {
        function sub(match, key) {
            if (!(key in context))
                throw new Error("renderTemplate tried to sub " + match + " but there is no matching member " + key + "in the context");
            return context[key] || ""
        }
        return template.replace(/\{\{\s*([_\$\w]+)\s*\}\}/g, sub)
    };
    var entityMap = {"&": "&amp;","<": "&lt;",">": "&gt;",'"': "&quot;","'": "&apos;","\\": "&bsol;"}, entityRegex = /[&<>"'\\]/g, entityHTML = function(s) {
        return entityMap[s]
    };
    module.escapeHTML = function(string) {
        return entityRegex.test(string) ? string.replace(entityRegex, entityHTML) : string
    };
    var COMPARE_BAR = module.COMPARE_BAR = {COLORS: {BLUE: "#a5c2fe",GREEN: "#97cfb4",RED: "#e6a6a5"}}, compare_bar = module.compare_bar = function(params) {
        var caption, max = params.max, summed = params.values.reduce(function(previous, current) {
            return previous + current
        }), width = (summed / max * 100).toFixed(0), colors = params.colors || [COMPARE_BAR.COLORS.RED, COMPARE_BAR.COLORS.GREEN, COMPARE_BAR.COLORS.BLUE];
        caption = params.format_fn ? params.format_fn.apply(params, [summed, params.values]) : formatters.metric_bytes(summed);
        var inner_style = "width: " + width + "%;";
        summed || (inner_style += " display: none;");
        var html = '<div class="compare-bar-container ' + (params["class"] || "") + '">';
        return html += '<div class="compare-bar-caption">' + caption + "</div>", html += '<div class="compare-bar-outer">', html += '<div class="compare-bar-inner" style="' + inner_style + '">', params.values.forEach(function(value, index) {
            var width, color = colors[index], valueClass = "compare-bar-value", style = "background-color: " + color + ";";
            index === params.values.length - 1 ? valueClass += " grow" : (width = (value / summed * 100).toFixed(0), style += " width: " + width + "%;"), html += '<div class="' + valueClass + '" style="' + style + '"></div>'
        }), html += "</div></div></div>"
    };
    return module.create_compare_bar_qlist_formatter = function(max, format_fn, keys, colors) {
        return function($td, column, row) {
            keys = keys || [void 0], 1 === keys.length && void 0 === keys[0] && (keys[0] = column.selector);
            var values = keys.map(function(key) {
                return row[key]
            });
            return compare_bar({max: "function" == typeof max ? max(column.selector) : max,format_fn: format_fn,values: values,colors: colors,"class": column["class"],row: row})
        }
    }, module.clearTextSelection = function() {
        var selection;
        selection = "function" == typeof window.getSelection ? window.getSelection() : document.selection, selection && ("function" == typeof selection.empty ? selection.empty() : "function" == typeof selection.removeAllRanges && selection.removeAllRanges())
    }, module.mask_content = function($content, enable, mask_html) {
        mask_html = mask_html || '<f-icon class="fa-loading"></f-icon>', enable ? $content.addClass("masked-content").append('<div class="content-mask flex-centered">' + mask_html + "</div>") : $content.removeClass("masked-content").find(".content-mask").remove()
    }, module.addStyle = function(src, reload) {
        var exists;
        if ($('link[type="text/css"]').each(function() {
            var $this = $(this);
            return exists = $this.attr("href") === src, exists ? (reload && $this.remove(), !1) : void 0
        }), !exists || reload) {
            $.ajaxSetup({cache: !0});
            var style = document.createElement("link");
            $(style).attr("type", "text/css"), $(style).attr("rel", "stylesheet"), $(style).attr("href", src), $("head")[0].appendChild(style), $.ajaxSetup({cache: !1})
        }
    }, module
}), fweb_define("fweb.util/events", ["jquery"], "fweb.util.events", function($) {
    "use strict";
    var module = {};
    return module.namespacify = function(namespace, event_str, extra) {
        var namespacify_fn = function(event_str, extra) {
            return $.map(event_str.split(" "), function(event_str) {
                return event_str.indexOf(".") > -1 ? event_str : event_str + "." + namespace + (null != extra ? "." + extra : "")
            }).join(" ")
        };
        return 1 === arguments.length ? namespacify_fn : namespacify_fn(event_str, extra)
    }, module.reportExceptions = function(wrapped) {
        return function() {
            try {
                return wrapped.apply(this, arguments)
            } catch (e) {
                throw (window.console || {error: $.noop}).error(e.stack), "function" == typeof window.onerror && window.onerror(e.stack), module._reportedExceptions.push(e), e
            }
        }
    }, module._reportedExceptions = [], module
}), fweb_define("fweb.util/functional", ["jquery"], "fweb.util.functional", function($) {
    "use strict";
    var module = {};
    return module.lazy = function(fn) {
        var _cache, _args = [].slice.call(arguments, 1), _ref = function() {
            return void 0 !== _cache ? _cache : _cache = fn.apply(this, _args)
        };
        return _ref
    }, module.lazylazy = function(fn, arg) {
        var _cache, _ref = function() {
            return void 0 !== _cache ? _cache : _cache = fn.call(this, arg())
        };
        return _ref
    }, module.asyncEach = function(elems, options, callback) {
        function iterator() {
            for (interrupted && defer.resolve(), chunkEnd = Math.min(i + options.chunk, _len); chunkEnd > i; i++)
                if (callback.call(elems[i], i, elems[i]) === !1)
                    return void defer.resolve();
            _len > chunkEnd ? setTimeout(iterator, 1) : defer.resolve()
        }
        var defer = $.Deferred(), defaults = {chunk: 500,asap: !1};
        $.isFunction(options) ? (callback = options, options = defaults) : options = $.extend(defaults, options);
        var chunkEnd, i = 0, _len = elems.length, interrupted = !1;
        options.asap ? iterator() : setTimeout(iterator, 1);
        var promise = defer.promise();
        return promise.interrupt = function() {
            return interrupted = !0, promise
        }, promise
    }, module.castToJQueryPromise = function(aPromise) {
        var p = {then: aPromise.then,done: function(fn) {
                return aPromise.then(fn), p
            },fail: function(fn) {
                return aPromise.then(null, fn), p
            },progress: function(fn) {
                return aPromise.then(null, null, fn), p
            },promise: function() {
                return p
            }};
        return p
    }, module
}), fweb_define("fweb.util/objects", ["jquery"], "fweb.util.objects", function($) {
    "use strict";
    var module = {};
    module.extend_merge = function(target, options, copy_options) {
        null == copy_options && (copy_options = !1);
        var name, src, copy;
        for (name in options)
            if (options.hasOwnProperty(name)) {
                if (src = target[name], copy = options[name], target === copy || void 0 === copy)
                    continue;
                $.isArray(src) ? $.isArray(copy) ? $.merge(src, copy) : src.push(copy) : void 0 === src ? $.isArray(copy) ? target[name] = copy_options ? $.merge([], copy) : copy : target[name] = [copy] : $.isArray(copy) ? target[name] = $.merge([src], copy) : target[name] = [src, copy]
            }
        return target
    }, module.makeSet = function(array, ensureUniqueness) {
        function toObj(obj, k) {
            return k in obj || (obj[k] = 1), obj
        }
        return ensureUniqueness && (array = Object.keys(array.reduce(toObj, {}))), array.containsSet = function(other, compare) {
            if (this === other)
                return !0;
            if (!other)
                return !1;
            if (other.toArray && (other = other.toArray()), !(this instanceof Array && other instanceof Array))
                return !1;
            if (this.length < other.length || 0 === other.length)
                return !1;
            var i, diff, a = this.slice().sort(compare), b = other.slice().sort(compare), j = 0, aLength = a.length, bLength = b.length;
            if (compare && "function" == typeof compare)
                for (i = 0; aLength > i; ++i) {
                    if (diff = compare(a[i], b[j]), 0 === diff && ++j, j >= bLength)
                        return !0;
                    if (diff > 0)
                        return !1
                }
            else
                for (i = 0; aLength > i; ++i)
                    if (a[i] === b[j] && ++j, j >= bLength)
                        return !0;
            return !1
        }, array.equalToSet = function(other, compare) {
            if (this === other)
                return !0;
            if (!other)
                return !1;
            if (other.toArray && (other = other.toArray()), !(this instanceof Array && other instanceof Array))
                return !1;
            if (this.length !== other.length)
                return !1;
            var i, a = this.slice().sort(compare), b = other.slice().sort(compare), c = a.length;
            if (compare && "function" == typeof compare) {
                for (i = 0; c > i; ++i)
                    if (0 !== compare(a[i], b[i]))
                        return !1
            } else
                for (i = 0; c > i; ++i)
                    if (a[i] !== b[i])
                        return !1;
            return !0
        }, array.intersection = function(other, compare) {
            if (this === other)
                return other;
            if (!other)
                return null;
            if (other.toArray && (other = other.toArray()), !(this instanceof Array && other instanceof Array))
                return null;
            var compareResult, a = this.slice().sort(compare), b = other.slice().sort(compare), ai = 0, bi = 0, aLength = a.length, bLength = b.length, intersection = [];
            if (compare && "function" == typeof compare)
                for (; aLength > ai && bLength > bi; )
                    compareResult = compare(a[ai], b[bi]), 0 > compareResult ? ai++ : compareResult > 0 ? bi++ : (intersection.push(a[ai]), ai++, bi++);
            else
                for (; aLength > ai && bLength > bi; )
                    a[ai] < b[bi] ? ai++ : a[ai] > b[bi] ? bi++ : (intersection.push(a[ai]), ai++, bi++);
            return intersection
        }, array.difference = function(other, compare) {
            if (this === other)
                return other;
            if (!other)
                return null;
            if (other.toArray && (other = other.toArray()), !(this instanceof Array && other instanceof Array))
                return null;
            var compareResult, a = this.slice().sort(compare), b = other.slice().sort(compare), ai = 0, bi = 0, aLength = a.length, bLength = b.length, missing = [];
            if (compare && "function" == typeof compare)
                for (; aLength > ai && bLength > bi; )
                    compareResult = compare(a[ai], b[bi]), 0 > compareResult ? (missing.push(a[ai]), ai++) : compareResult > 0 ? bi++ : (ai++, bi++);
            else
                for (; aLength > ai && bLength > bi; )
                    a[ai] < b[bi] ? (missing.push(a[ai]), ai++) : a[ai] > b[bi] ? bi++ : (ai++, bi++);
            return missing
        }, array
    }, module.is_valid = function(p_selector, selector) {
        var valid = !0;
        return $(p_selector).find(selector).each(function() {
            $("form").validate().element(this) === !1 && (valid = !1)
        }), valid
    }, module.stable_string = function(target) {
        return JSON.stringify(Object.keys(target).sort().map(function(key) {
            return [key, target[key]]
        }))
    };
    var simpleForEach = module.forEach = function(obj, iterator, context) {
        var key;
        for (key in obj)
            obj.hasOwnProperty(key) && iterator.call(context, obj[key], key)
    };
    return module.lockCurrentProperties = function(obj) {
        if (Object.defineProperty)
            try {
                simpleForEach(obj, function(v, k) {
                    Object.defineProperty(obj, k, {value: v,writable: !1,configurable: !1})
                })
            } catch (ex) {
            }
    }, module.pick = function(obj, keys) {
        for (var new_obj = {}, i = 0, len = keys.length; len > i; ++i) {
            var prop = keys[i];
            new_obj[prop] = obj[prop]
        }
        return new_obj
    }, module.values = function(obj) {
        return Object.keys(obj).map(function(key) {
            return obj[key]
        })
    }, module.unique = function(key) {
        var exists = {};
        return function(result, entry) {
            var val = entry[key];
            return val in exists ? !1 : (exists[val] = !0, !0)
        }
    }, module
}), fweb_define("fweb.util/templates", ["jquery", "fweb.util/functional", "fweb.util/dom"], "fweb.util.templates", function($, functional, dom) {
    "use strict";
    var module = {}, lang_regex = /\{% *lang +"([a-zA-Z_\-]+)" *%\}/g, translate = module.j2translate = function(template_str, table) {
        return template_str.replace(lang_regex, function(match, lang_key) {
            return $.getInfo(lang_key, table)
        })
    }, lazy = functional.lazy, lazylazy = functional.lazylazy, getCorrectJQuery = dom.getCorrectJQuery;
    module.dlg_btn = lazy(translate, module._dlg_btn = '<button type="submit" class="button submit-ok-btn">{% lang "ok" %}</button><button type="button" class="button dlg_close submit-cancel-btn">{% lang "cancel" %}</button>'), module.dlg_btn_ui = function(ok, cancel) {
        return $.isFunction(ok) && (ok = {click: ok}), $.isFunction(cancel) && (cancel = {click: cancel}), [$.extend({text: $.getInfo("ok"),click: function() {
                    getCorrectJQuery(this)(this).dialog("close")
                },"class": "submit-ok-btn"}, ok || {}), $.extend({text: $.getInfo("cancel"),click: function() {
                    getCorrectJQuery(this)(this).dialog("close")
                },"class": "submit-cancel-btn"}, cancel || {})]
    };
    var _risk_format = module._risk_format = '<span class="block-centred utm_risk_sprite utm_risk_level{0}" title="{1}"/>';
    return module.risk_format = lazylazy(function(raw_formatter) {
        var num_to_str = {1: "low",2: "elevated",3: "medium",4: "high",5: "critical"}, str_to_num = {low: 1,elevated: 2,medium: 3,high: 4,critical: 5};
        return function(risk) {
            if (!risk)
                return "";
            var is_num = $.isNumeric(risk), risk_num = is_num ? risk : str_to_num[risk], risk_str = is_num ? num_to_str[risk] : risk;
            return risk_num && risk_str ? raw_formatter(risk_num, $.getInfo(risk_str) || risk_str) : ""
        }
    }, lazy(function() {
        return $.validator.format(_risk_format)
    })), module
}), fweb_define("fweb.util/logs", ["fweb.util/datetime"], "fweb.util.logs", function(datetime) {
    "use strict";
    function getFilterString(time_range, widget_id, filter_obj) {
        var filters = [];
        for (var i in filter_obj)
            filter_obj.hasOwnProperty(i) && filters.push({id: i,value: ["'" + filter_obj[i] + "'"],logic: {is: {}}});
        return filters.push({id: "widget",value: [widget_id],logic: {is: {}}}), filters.unshift(timeSpanFilter(time_range)), JSON.stringify(filters)
    }
    function timeSpanFilter(time_range) {
        var start_str, end_str, result;
        //FWB_CHANGE return start_str = datetime.getLocalDate(1e3 * time_range.start), end_str = datetime.getLocalDate(1e3 * time_range.end), result = {id: "rel_time",value: [start_str, end_str],logic: {RANGE: 1,is: {date: 1}}}
        var d = new Date();
        return start_str = datetime.getLocalDate(time_range.start*1000 + (d.getTimezoneOffset() * 60000)), end_str = datetime.getLocalDate(time_range.end*1000 + (d.getTimezoneOffset() * 60000)), result = {id: "rel_time",value: [start_str, end_str],logic: {RANGE: 1,is: {date: 1}}}
    }
    return {getFilterString: getFilterString,timeSpanFilter: timeSpanFilter}
}), fweb_define("fweb.util/shim", null, "fweb.util.shim", function() {
    "use strict";
    var loc = window.location;
    return loc.origin || (loc.origin = loc.protocol + "//" + loc.hostname + (loc.port ? ":" + loc.port : "")), {origin: loc.origin}
}), fweb_define("fweb.util/sort", ["jquery", "ftnt_shared"], "fweb.util.sort", function($, ftnt_shared) {
    "use strict";
    function interfaceNameSort(a, b) {
        function namesMatch(a, b) {
            return a[1] === b[1]
        }
        function compareNums(a, b) {
            return Number(a[2]) - Number(b[2])
        }
        function exists(value) {
            return null != value
        }
        var nameParts = [a, b].map(nameExprExec);
        return nameParts.every(exists) && nameParts.reduce(namesMatch) ? nameParts.reduce(compareNums) : ftnt_shared.util.fastLocaleCompare(a, b)
    }
    function featuresSort(a, b) {
        var featureA = a[1], featureB = b[1];
        return featureA.newState && !featureB.newState ? -1 : !featureA.newState && featureB.newState ? 1 : ftnt_shared.util.fastLocaleCompare($.getInfo(a[0]), $.getInfo(b[0]))
    }
    function vdomSort(valueA, valueB, entryA, entryB) {
        return entryA.is_global ? -1 : entryB.is_global ? 1 : ftnt_shared.util.fastLocaleCompare(valueA.toLowerCase(), valueB.toLowerCase())
    }
    function fileTypeSort(valueA, valueB, entryA, entryB) {
        var formatFn = function(entry) {
            return $.getInfo(entry.lang) + " (" + entry.q_origin_key + ")"
        };
        return ftnt_shared.util.fastLocaleCompare(formatFn(entryA), formatFn(entryB))
    }
    var nameExpr = /^([^0-9]+)([0-9]+)$/, nameExprExec = nameExpr.exec.bind(nameExpr);
    return {interfaceName: interfaceNameSort,features: featuresSort,vdomSort: vdomSort,fileType: fileTypeSort}
}), fweb_define("fweb.util/legacy", ["jquery", "fweb.util/shim"], "fweb.util.legacy", function($) {
    "use strict";
    function qlist_source_message_respond(qlist_selector) {
        function tr_to_entry(i, elem) {
            var entry = {};
            return $(elem).find("td").each(function(i, elem) {
                var $elem = $(elem), data = $elem.data();
                for (var prop in data)
                    Object.hasOwnProperty.call(data, prop) && ("selector" === prop ? entry[data[prop]] = $elem.attr("title") || $elem.text() : entry[prop] = data[prop])
            }), entry
        }
        $(window).off("message.qlistsource").on("message.qlistsource", function(event) {
            event = event.originalEvent || event;
            var data = event.data;
            if (event.origin === window.location.origin && data.get && "qlist.source" === data.get && data.id) {
                var entries = $(qlist_selector).find("tr.qlist_row").map(tr_to_entry).toArray();
                event.source.postMessage({put: data.get,value: entries,id: data.id}, window.location.origin)
            }
        })
    }
    return {qlist_source_message_respond: qlist_source_message_respond}
}), fweb_define("fweb.util/address", ["jquery", "fweb.features", "fweb.util/ip", "fweb.util/dom", "fweb.util/formatters", "cmdb"], "fweb.util.address", function($, features, ip, dom, formatters, CMDB) {
    "use strict";
    function _url_value(address) {
        return formatters.truncate_string(dom.escapeHTML(address.path), TRUNCATE_LENGTH)
    }
    function _ua_value(address) {
        var uas = address.ua.split(" "), results = uas.map(function(v) {
            return $.getInfo("ua_" + v)
        });
        return formatters.truncate_string(results.join("/"), TRUNCATE_LENGTH)
    }
    function _method_value(address) {
        return formatters.truncate_string(address.method.toUpperCase(), TRUNCATE_LENGTH)
    }
    function _category_value(address, url_category_map) {
        var categories = address.category, result = [];
        return $.isArray(categories) ? url_category_map ? (result = categories.map(function(v) {
            var cat = url_category_map[v.id];
            return cat ? cat.name : v.id
        }), formatters.truncate_string(result.join("/"), TRUNCATE_LENGTH)) : formatters.truncate_string(categories.join("/"), TRUNCATE_LENGTH) : categories
    }
    function _header_group_value(address) {
        var header_group = address["header-group"], result = "";
        return $.isArray(header_group) ? (header_group.forEach(function(v) {
            result += v["header-name"] + ": " + dom.escapeHTML(v.header) + " "
        }), formatters.truncate_string(result, TRUNCATE_LENGTH)) : dom.escapeHTML(header_group)
    }
    function _header_value(address) {
        return formatters.truncate_string(address["header-name"] + ": " + dom.escapeHTML(address.header), TRUNCATE_LENGTH)
    }
    var dataDeferred, TRUNCATE_LENGTH = 150, basic_key_value = function(key, escape) {
        return function(address) {
            return escape ? dom.escapeHTML(address[key]) : address[key]
        }
    }, geo_value = function(address, geoip_map) {
        var SKIP = {A1: !0,A2: !0,ZZ: !0}, code = address.country, country = geoip_map[code], value = country.name;
        return SKIP[code] || (value = '<span class="country_flag_label country_' + code + '">' + value + "</span>"), value
    }, range_value = function(address) {
        return [address["start-ip"], address["end-ip"]].join(" - ")
    }, ip_value = function(key) {
        return function(address) {
            var ipmask = ip.IpMask.parse(address[key]);
            return ipmask.full_network()
        }
    }, format_host = function(host) {
        var cls = "icon_fw addr_0";
        return '<span class="' + cls + '">' + host + "</span>"
    }, url_value = function(address) {
        return format_host(address.host) + " (" + _url_value(address) + ")"
    }, ua_value = function(address) {
        return format_host(address.host) + " (" + _ua_value(address) + ")"
    }, method_value = function(address) {
        return format_host(address.host) + " (" + _method_value(address) + ")"
    }, category_value = function(address, geoip_map, url_category_map) {
        return format_host(address.host) + " (" + _category_value(address, url_category_map) + ")"
    }, header_value = function(address) {
        return format_host(address.host) + " (" + _header_value(address) + ")"
    }, advanced_value = function(address, geoip_map, url_category_map) {
        var result = format_host(address.host);
        if (address.path && (result += "<br /> " + $.getInfo("addr_type_url") + ": " + _url_value(address)), address.category) {
            var cat = _category_value(address, url_category_map);
            cat && (result += "<br />" + $.getInfo("addr_type_category") + ": " + _category_value(address, url_category_map))
        }
        return $.isArray(address["header-group"]) && address["header-group"].length > 0 && (result += "<br />" + $.getInfo("Header Group") + ": " + _header_group_value(address)), address.method && (result += "<br />" + $.getInfo("addr_type_method") + ": " + _method_value(address)), address.ua && (result += "<br />" + $.getInfo("addr_type_ua") + ": " + _ua_value(address)), result
    }, nsx_value = function(address) {
        var addrList = address.list || [], len = addrList.length, max = 5, end = "…";
        return addrList = addrList.slice(0, max).map(function(v) {
            return v.ip
        }), len >= max && addrList.push(end), address.can_delete = 0, addrList.join("<br />")
    }, MAPPING = {fqdn: basic_key_value("fqdn"),geography: geo_value,iprange: range_value,multicastrange: range_value,broadcastmask: ip_value("subnet"),ipmask: ip_value("subnet"),wildcard: function(address) {
            return address.wildcard.replace(" ", "/")
        },ipprefix: basic_key_value("ip6"),url: url_value,"wildcard-fqdn": basic_key_value("wildcard-fqdn"),header: header_value,method: method_value,ua: ua_value,category: category_value,"src-advanced": advanced_value,"dst-advanced": advanced_value,"host-regex": basic_key_value("host-regex", !0),nsx: nsx_value}, create_address_details = function(address, geoip_map, url_category_map) {
        return MAPPING[address.type] ? MAPPING[address.type](address, geoip_map, url_category_map) : address.type
    }, getData = function(features_map) {
        if (!dataDeferred) {
            var promises, all_paths, paths = ["address"], group_paths = ["addrgrp"];
            dataDeferred = $.Deferred(), features_map.ipv6 && (paths.push("address6"), group_paths.push("addrgrp6")), features_map["multicast-policy"] && paths.push("multicast-address"), features_map["explicit-proxy"] && (paths.push("explicit-proxy-address"), group_paths.push("explicit-proxy-addrgrp")), all_paths = paths.concat(group_paths), promises = all_paths.map(function(path) {
                return $.getJSON("/api/v2/cmdb/firewall/" + path + "?skip=1&with_meta=1").then(function(data) {
                    return data.results
                })
            }), promises.push($.getJSON("/api/v2/cmdb/system/geoip-country").then(function(data) {
                var map = {};
                return data.results.forEach(function(country) {
                    map[country.id] = country
                }), map
            })), promises.push($.getJSON("/p/firewall/object/fortiguard_categories/json/").then(function(data) {
                return data["url-category"].lookup
            })), $.when.apply($, promises).then(function() {
                var i, j, path, address, addresses, member_path, intf, list = [], map = {}, geoip_map = arguments[all_paths.length], url_category_map = arguments[all_paths.length + 1];
                for (i = 0; i < all_paths.length; i++)
                    for (path = all_paths[i], addresses = arguments[i], j = 0; j < addresses.length; j++)
                        address = addresses[j], address.cmdb_path = path, path.indexOf("grp") >= 0 ? (member_path = path.replace("addrgrp", "address"), address.group = !0, address.type = path, address.details = address.member.map(function(member) {
                            return {name: member.name,cmdb_path: member_path,group_path: path}
                        })) : ("address6" !== path && "explicit-proxy-address" !== path && "explicit-proxy-addrgrp" !== path && (intf = address["associated-interface"], address.intf = intf ? intf : "any"), address.details = create_address_details(address, geoip_map, url_category_map)), list.push(address), map[path] || (map[path] = {}), map[path][address.name] = address;
                dataDeferred.resolve({list: list,map: map})
            })
        }
        return dataDeferred.promise()
    }, get = function() {
        var deferred = $.Deferred();
        return features().then(function(features_map) {
            getData(features_map).then(function(data) {
                deferred.resolve(data)
            })
        }), deferred.promise()
    }, get_addresses = function(cmdb_path, filter_func) {
        var deferred = $.Deferred(), format = {name: "%name",type: "%type"};
        return CMDB.fetch("firewall", cmdb_path, {format: format,with_meta: !0}).done(function(data) {
            var results = $.isFunction(filter_func) ? data.results.filter(filter_func) : data.results, source_map = {}, source = results.map(function(val) {
                return source_map[val.name] = val, val.name
            });
            deferred.resolve({list: source,map: source_map})
        }), deferred.promise()
    };
    return {get: get,format: function(path, name, callback) {
            get().then(function(data) {
                callback(data.map[path][name].details)
            })
        },get_addresses: get_addresses}
}), fweb_define("fweb.util/persist", null, "fweb.util.persist", function() {
    "use strict";
    function get(key) {
        var value = localStorage.getItem(key);
        return JSON.parse(value)
    }
    function put(key, value) {
        value = JSON.stringify(value), localStorage.setItem(key, value)
    }
    function remove(key) {
        localStorage.removeItem(key)
    }
    function setCookie(key, value, expires, pathname, domain, secure) {
        pathname || (pathname = 0 === location.pathname.indexOf("/ng") ? "/ng" : location.pathname.substring(0, location.pathname.lastIndexOf("/")) + "/"), null == expires && (expires = value ? 31536e6 : -1);
        var expireDate = new Date;
        expireDate.setTime(expireDate.getTime() + expires), document.cookie = key + "=" + encodeURIComponent(value) + (expires ? "; expires=" + expireDate.toGMTString() : "") + "; path=" + pathname + (domain ? "; domain=" + domain : "") + (secure ? "; secure=" + secure : "")
    }
    function getCookie(key, removeQuotes) {
        for (var aCookie = document.cookie.split("; "), i = 0; i < aCookie.length; i++) {
            var aCrumb = aCookie[i].split("=");
            if (key === aCrumb[0] && 2 === aCrumb.length)
                return removeQuotes && (aCrumb[1] = aCrumb[1].replace(/"/g, "")), aCrumb[1] ? decodeURIComponent(aCrumb[1]) : aCrumb[1]
        }
        return null
    }
    function hasCookie(key) {
        return null !== getCookie(key)
    }
    function removeCookie(key, pathname) {
        setCookie(key, void 0, -1, pathname)
    }
    function getState() {
        return top.state || window.opener.state || window.opener.top.state
    }
    function getCsrfToken() {
        var state = getState(), cookieName = state.ccsrf_token_cookie_name, cookieStr = getCookie(cookieName) || "";
        return cookieStr = cookieStr.replace(/^"|"$/g, "")
    }
    function getPythonCsrfToken() {
        var state = getState(), cookieName = state.csrf_token_cookie_name, cookieStr = getCookie(cookieName) || "";
        return cookieStr = cookieStr.replace(/^"|"$/g, "")
    }
    return {get: get,put: put,remove: remove,hasCookie: hasCookie,getCookie: getCookie,setCookie: setCookie,removeCookie: removeCookie,getCsrfToken: getCsrfToken,getPythonCsrfToken: getPythonCsrfToken}
}), fweb_define("fweb.util/structure", ["fweb.util/persist"], "fweb.util.structure", function(persist) {
    "use strict";
    function getOrigin() {
        var loc = window.location, origin = loc.origin || loc.protocol + "//" + loc.host;
        return origin
    }
    function topPostMessage(message) {
        top.postMessage(message, getOrigin())
    }
    var module = {};
    return module.getOrigin = getOrigin, module.topPostMessage = topPostMessage, module.refreshState = function() {
        topPostMessage("refreshState")
    }, module.refreshStateNextLoad = function() {
        persist.put("refreshState", !0)
    }, module.enterVdom = function(vdom) {
        var message = {messageType: "enterVDOM",vdom: vdom};
        topPostMessage(message)
    }, module.restartNotificationServiceIf = function(notificationId) {
        var message = {messageType: "restartNotificationIf"};
        notificationId && (message.ifHaving = notificationId), topPostMessage(message)
    }, module
}), fweb_define("fweb.util/certificate", ["jquery", "cmdb"], "fweb.util.certificate", function($, CMDB) {
    "use strict";
    var getLocalCertMap = function() {
        var local_cert_map = {}, format = {name: "%name",range: "%range"}, dataDeferred = $.Deferred(), in_vdom = window.top.state.vdom_mode && "" !== window.top.state.current_vdom, cmdb_path = in_vdom ? "vpn.certificate" : "certificate";
        return CMDB.fetch(cmdb_path, "local", {format: format}).done(function(data) {
            $.map(data.results, function(val) {
                local_cert_map[val.name] = val.range
            }), dataDeferred.resolve({map: local_cert_map})
        }), dataDeferred.promise()
    }, getCertIcon = function(range) {
        var vdomEnabled = window.top.state.vdom_mode;
        if (vdomEnabled) {
            var cls = "global" === range ? "fa-globe" : "";
            return '<f-icon class="' + cls + '"></f-icon>'
        }
        return ""
    };
    return {getLocalCertMap: getLocalCertMap,getCertIcon: getCertIcon}
}), fweb_define("fweb.util/firewallInterfaces", ["jquery", "fweb.util/dom"], "fweb.util.firewallInterfaces", function($, dom) {
    "use strict";
    var module = {}, VIRTUAL_WAN_LINK_NAME = "wan-load-balance", ICON_MAP = {adminDown: {tunnel: "ftnt-vpn-tunnel-disabled","vap-switch": "fa-wifi-disabled",wireless: "fa-wifi-disabled","wl-mesh": "fa-wifi-disabled","virtual-wan": "ftnt-virtual-wan-link-down-disabled",physical: "ftnt-interface-down-disabled",trunk: "ftnt-interface-down-disabled",vlan: "ftnt-vlan-down-disabled",aggregate: "ftnt-aggregate-down-disabled",redundant: "ftnt-aggregate-down-disabled","switch": "ftnt-switch-down-disabled","hard-switch": "ftnt-switch-down-disabled","hard-switch-vlan": "ftnt-switch-down-disabled",loopback: "ftnt-loopback-down-disabled","vdom-link": "fa-link-down-disabled",unknown: "fa-status-down-disabled"},linkDown: {tunnel: "fa-status-down",zone: "fa-zone-down","virtual-wan": "ftnt-virtual-wan-link-down",physical: "ftnt-interface-down",trunk: "ftnt-interface-down",vlan: "ftnt-vlan-down",aggregate: "ftnt-aggregate-down",redundant: "ftnt-aggregate-down","switch": "ftnt-switch-down","hard-switch": "ftnt-switch-down","hard-switch-vlan": "ftnt-switch-down",unknown: "fa-status-down"},up: {tunnel: "ftnt-vpn-tunnel-up","vap-switch": "fa-wifi-up",wireless: "fa-wifi-up","wl-mesh": "fa-wifi-up","virtual-wan": "ftnt-virtual-wan-link-up",zone: "fa-zone-up","switch": "ftnt-switch-up","hard-switch": "ftnt-switch-up","hard-switch-vlan": "ftnt-switch-up",physical: "ftnt-interface-up",trunk: "ftnt-interface-up",vlan: "ftnt-vlan-up",aggregate: "ftnt-aggregate-up",redundant: "ftnt-aggregate-up",loopback: "ftnt-loopback-up","vdom-link": "fa-link-up",unknown: "fa-status-up"}}, SORT_VALUES = {CONNECTED: 0,DISCONNECTED: 1,DISABLED: 2,ANY: 3};
    module.ICON_MAP = ICON_MAP, module.SORT_VALUES = SORT_VALUES;
    var getLabel = function(entry) {
        var text = entry.name, extra = entry.alias;
        return entry.is_sslvpn ? (text = $.getInfo("sslvpn_intf"), extra = entry.name, entry.alias = text) : entry.is_wifi ? (text = dom.escapeHTML(entry.ssid), extra = entry.name) : entry.vlan_id ? extra = entry.vlan_interface : entry.alias ? (text = entry.alias, extra = entry.name) : entry.is_virtual_wan_link && (text = VIRTUAL_WAN_LINK_NAME), extra ? text + " (" + extra + ")" : text
    };
    return module.processInterface = function(entry) {
        var icon, sortValue = SORT_VALUES.CONNECTED, statusKey = "up", type = entry.type || "unknown";
        "any" === entry.name ? (icon = "fa-square-o", sortValue = SORT_VALUES.ANY, entry.editable = !1) : ("down" === entry.status ? (statusKey = "adminDown", sortValue = SORT_VALUES.DISABLED) : "down" === entry.link && (statusKey = "linkDown", sortValue = SORT_VALUES.DISCONNECTED), icon = ICON_MAP[statusKey][type] || ICON_MAP[statusKey].unknown), entry.icon = icon, entry.label = getLabel(entry), entry.sortValue = sortValue
    }, module.get = function(global) {
        return $.get("/api/v2/monitor/system/available-interfaces" + (global ? "?global=1" : "")).then(function(data) {
            var results, map = {};
            return results = global ? data.reduce(function(aggregated, currentData) {
                return currentData.results.forEach(function(result) {
                    result.vdom = currentData.vdom
                }), aggregated.concat(currentData.results)
            }, []) : data.results, results.forEach(function(entry) {
                entry.q_origin_key = entry.name, entry.is_zone ? entry.datasource = "system.zone" : entry.is_virtual_wan_link ? entry.datasource = "system.virtual-wan-link" : entry.datasource = "system.interface", module.processInterface(entry), map[entry.name] = entry
            }), results.mapping = map, results
        })
    }, module
}), fweb_define("fweb.util/interface", ["jquery", "fweb.util/firewallInterfaces", "fweb.util/objects", "fweb.util/sort", "fweb.util/location", "fweb.interface", "jquery.util_core"], "fweb.util.interface", function($, firewallInterfaces, fweb_objects, fweb_sort, fweb_location, fweb_interface) {
    "use strict";
    var POE_ICONS = {POWERED: "fa-status-poe-powered",CONNECTED: "fa-status-poe-up",DISCONNECTED: "fa-status-poe-down",DISABLED: "fa-status-poe-disabled"};
    Object.keys(firewallInterfaces.SORT_VALUES).reduce(function(result, key) {
        return result[firewallInterfaces.SORT_VALUES[key]] = result[key], result
    }, POE_ICONS);
    var module = {processInterface: function(entry, poeCapablePorts) {
            firewallInterfaces.processInterface(entry), poeCapablePorts && poeCapablePorts[entry.name] && (entry.poe_capable = 1, entry.icon = POE_ICONS[entry.sortValue], entry.icon === POE_ICONS.CONNECTED && "enable" === entry.poe && (entry.icon = POE_ICONS.POWERED))
        },formatFunction: function(entry, value) {
            return '<f-icon class="' + entry.icon + '"></f-icon><span>' + value + "</span>"
        },switchMemberSource: function(availableInterfaces, poeCapablePorts) {
            function mergeLinkData(intfs, linkData) {
                var ports = linkData[0].ports, canonicalIntfs = intfs.reduce(function(result, intf) {
                    var instance = result[intf.name];
                    if (instance)
                        mergeTags(instance, intf);
                    else {
                        var intfLookup = intf["interface"] || intf.name;
                        ports.hasOwnProperty(intfLookup) && (intf.link = "disconnected" !== ports[intfLookup].link ? "up" : "down"), result[intf.name] = intf, module.processInterface(intf, poeCapablePorts), intf.datasource = "available-switch-members", intf.q_origin_key = intf.name, mergeTags(intf, null), "hard-switch" === intf.switch_type && (intf["hard-switch"] = [intf["hard-switch"]])
                    }
                    return result
                }, {});
                return intfs = fweb_objects.values(canonicalIntfs)
            }
            function mergeTags(instance, other) {
                Object.keys(instance._tags).forEach(function(key) {
                    var tag = instance._tags[key];
                    "object" != typeof tag && (instance._tags[key] = {}, instance._tags[key][tag] = !0)
                }), other && Object.keys(other._tags).forEach(function(key) {
                    instance._tags[key] = instance._tags[key] || {};
                    var tag = other._tags[key];
                    instance._tags[key][tag] = !0
                })
            }
            function flattenAndTag(obj, tagKey) {
                function flatten(obj) {
                    return function(result, key) {
                        function tag(obj) {
                            return obj._tags = obj._tags || {}, obj._tags[tagKey] = key, obj
                        }
                        var value = obj[key];
                        return Array.isArray(value) || (value = flattenAndTag(value, key)), result.concat(value.map(tag))
                    }
                }
                return Object.keys(obj).reduce(flatten(obj), [])
            }
            var linkData = $.get("/system/widget/sysop?json"), intfs = flattenAndTag(availableInterfaces, "switch_type");
            return {name: $.getInfo("Ports"),data: function() {
                    return $.when(intfs, linkData).then(mergeLinkData)
                },sortFunction: fweb_sort.interfaceName,formatFunction: module.formatFunction,valueFunction: function(intf) {
                    return intf.name
                },preProcessSelected: !0}
        },getInterfacesFormatted: function(availableInterfaces, datasourceName) {
            function mergeLinkData(intfs, linkData) {
                var ports = linkData[0].ports;
                return intfs.forEach(function(intf) {
                    intf.name in ports && (intf.link = "connected" === ports[intf.name].link ? "up" : "down"), module.processInterface(intf), intf.datasource = datasourceName, intf.q_origin_key = intf.name
                }), intfs
            }
            var linkData = $.get("/system/widget/sysop?json");
            return {name: $.getInfo("Ports"),aliasFor: ["system.interface"],data: function() {
                    return $.when(availableInterfaces, linkData).then(mergeLinkData)
                },sortFunction: fweb_sort.interfaceName,formatFunction: module.formatFunction,valueFunction: function(intf) {
                    return intf.name
                },preProcessSelected: !0}
        },getInterfaceMap: function(noCache) {
            function makeMap(previous, current) {
                return previous[current.name] = current, previous
            }
            var promise = fweb_location.get_cache("interface_map_promise", null);
            return (!promise || noCache) && (promise = $.ajax({url: "/api/v2/cmdb/system/interface/",cache: !1,dataType: "json",data: {format: "name|endpoint-compliance|alias|description|type|fortiheartbeat"}}).then(function(r) {
                return r.results.reduce(makeMap, {})
            }, function() {
                return {}
            })), fweb_location.set_cache("interface_map_promise", promise), promise
        },interfaceFormatFn: function(intfName, intf, showType, showEnforceEndpointCompliance, fortilinkInfo, showNoEnforceEndpointCompliance) {
            var icon, title, switchText, portText, value = "", name = intfName;
            return intf ? (showEnforceEndpointCompliance = showEnforceEndpointCompliance && "enable" === intf["endpoint-compliance"], title = intf.description || name, showEnforceEndpointCompliance && (title += " (" + $.getInfo("Enforce FortiTelemetry for all FortiClients") + ")"), intf.alias && (name += " (" + intf.alias + ")"), showType && (icon = fweb_interface.TYPE_ICON_MAP[intf.type] || intf.type, value = '<f-icon class="' + icon + '"></f-icon>'), fortilinkInfo && (switchText = fortilinkInfo.switch_name || fortilinkInfo.switch_id, portText = $.getInfo("Port").toLowerCase() + fortilinkInfo.port_id, name += " (" + switchText + ": " + portText + ")"), value += '<span class="qtip-popup" title="' + title + '">' + name + "</span>", showEnforceEndpointCompliance && (value += '<f-icon class="qtip-popup ftnt-forticlient" title="' + title + '"></f-icon>'), showNoEnforceEndpointCompliance && ("enable" !== intf.fortiheartbeat ? value += " (" + $.getInfo("FortiTelemetry disabled") + ")" : "enable" !== intf["endpoint-compliance"] && (value += " (" + $.getInfo("FortiClient not enforced") + ")")), value) : intfName
        },isFortiLinkMode: function(intf) {
            return intf ? "enable" === intf.fortilink : !1
        }};
    return module
}), fweb_define("fweb.util/policy", ["jquery", "fweb.util/ip", "fweb.util/location", "jquery.util_core"], "fweb.util.policy", function($, f_util_ip, f_util_location) {
    "use strict";
    function getPolicyUrl(isEdit, columnSelector, entry) {
        function getVirtualWirePairCache() {
            function createVirtualWirePairCache(lookupResult) {
                function makeMap(vwpCache, currentPair) {
                    var memberIntfs = currentPair.member.map(function(member) {
                        return member["interface-name"]
                    });
                    return vwpCache[makeVirtualWirePairKey(memberIntfs)] = currentPair.name, vwpCache
                }
                return lookupResult.results.reduce(makeMap, {})
            }
            var VWPCACHE_NAME = "virtual-wire-pairs-promise", promise = f_util_location.get_cache(VWPCACHE_NAME, null);
            return promise || (promise = $.ajax({url: "/api/v2/cmdb/system/virtual-wire-pair/",cache: !1,dataType: "json",data: {format: "name|member"}}).then(createVirtualWirePairCache, function() {
                return {}
            })), f_util_location.set_cache(VWPCACHE_NAME, promise), promise
        }
        function generateUrlInfo(virtualWirePairs) {
            function getVirtualWirePairName(entry, reverseMap) {
                return reverseMap[makeVirtualWirePairKey([entry.dstintf, entry.srcintf])]
            }
            var virtualWirePairName, policyId = entry[columnSelector], policyType = entry.policytype || "policy", type = "standard";
            ["policy", "policy6"].indexOf(policyType) > -1 && (virtualWirePairName = getVirtualWirePairName(entry, virtualWirePairs), type = null != virtualWirePairName ? "virtual-wire" : "standard");
            var path = "/ng/firewall/policy/" + policyType + "/" + type, query = {};
            return isEdit ? path += "/edit/" + (isImplicitDenyPolicy(policyId, entry.policytype) ? IMPLICIT_DENY_POLICY.path : policyId) : query.qlist_find = JSON.stringify({policyid: Number(policyId)}), top.state.current_vdom && (query.vdom = top.state.current_vdom), "virtual-wire" === type && (query.vwpname = virtualWirePairName), {path: path,search: query,url: path + "?" + $.param(query)}
        }
        function makeVirtualWirePairKey(memberArray) {
            return memberArray.sort().join("_")
        }
        return $.when(getVirtualWirePairCache()).then(generateUrlInfo)
    }
    function isRealtimeFortiViewLocalPolicy(policyid, policyType, logSubtype) {
        return !(policyid + "" != "0" && null != policyid || policyType || logSubtype)
    }
    function isImplicitDenyPolicy(policyid, policyType) {
        return policyid + "" == "0" && ["policy", "policy6"].indexOf(policyType) > -1
    }
    var IMPLICIT_DENY_POLICY = {policyid: 0,name: $.getInfo("implicit_deny"),path: "implicit"}, module = {};
    return module.policyMetaLookup = function(policyid, policytype, logSubtype, policyMetaHandler) {
        function getPolicyCache() {
            var policyCache = f_util_location.get_cache("policies", {});
            return $.isEmptyObject(policyCache) && $.extend(policyCache, {"0-policy": $.when({results: [IMPLICIT_DENY_POLICY]}),"0-policy6": $.when({results: [IMPLICIT_DENY_POLICY]})}), policyCache
        }
        function lookupPolicy(policyid, policytype) {
            var policyUrl = "/api/v2/cmdb/firewall/" + policytype + "/" + policyid + "/", params = {format: "policyid|comments|name"};
            return $.ajax({url: policyUrl,cache: !1,dataType: "json",data: params})
        }
        function storeAndFormatPolicyInfo(lookupResult) {
            policyMeta = lookupResult.results[0], policyCache[key].result = policyMeta, policyMetaHandler(policyMeta)
        }
        function formatPolicyInfo() {
            policyMetaHandler(policyMeta)
        }
        var policyCache = getPolicyCache(), policyMeta = {policyid: policyid};
        if (isRealtimeFortiViewLocalPolicy(policyid, policytype, logSubtype) ? (policyMeta.name = $.getInfo("Local In"), policytype = "local-in-policy") : policytype || logSubtype || (policytype = "policy"), -1 === ["policy", "policy6"].indexOf(policytype))
            return policyMetaHandler(policyMeta), policyMeta;
        var key = [policyid, policytype].join("-");
        return policyCache[key] || (policyCache[key] = lookupPolicy(policyid, policytype), policyCache[key].result = policyMeta), policyCache[key].then(storeAndFormatPolicyInfo, formatPolicyInfo), policyCache[key].result
    }, module.disableParsePolicy = function(entry) {
        return !entry || entry.subtype && "forward" !== entry.subtype || "web-proxy" === entry.wanoptapptype || "forward" === entry.subtype && !entry.policytype || ["local-in-policy", "local-in-policy6"].indexOf(entry.policytype) > -1
    }, module.disablePolicyAction = function(entry, columnSelector) {
        var policyid = entry[columnSelector || "policyid"];
        return module.disableParsePolicy(entry) || !entry.subtype || isRealtimeFortiViewLocalPolicy(policyid, entry.policytype, entry.subtype)
    }, module.disablePolicyLink = function(entry, columnSelector) {
        var policyid = entry[columnSelector || "policyid"];
        return module.disableParsePolicy(entry) || isRealtimeFortiViewLocalPolicy(policyid, entry.policytype, entry.subtype) || "sniffer" === entry.policytype
    }, module.getMatchingPolicyEditUrl = function(columnSelector, entry) {
        return getPolicyUrl(!0, columnSelector, entry)
    }, module.getMatchingPolicyListUrl = function(columnSelector, entry) {
        return getPolicyUrl(!1, columnSelector, entry)
    }, module
}), fweb_define("fweb.util/address_search", ["fweb.util/patterns", "closure-ipaddress"], "fweb.util.address_search", function(patterns, goog) {
    "use strict";
    function fudge_v6_partial(str) {
        return patterns.commonRegExp.IP6_HOST.test(str) || patterns.commonRegExp.IP6_SUBNET.test(str) ? str : str.indexOf("::") > -1 ? ":" !== str[str.length - 2] && ":" === str[str.length - 1] ? str.substr(str.length - 1) : str : ":" === str[str.length - 1] ? str + ":" : str + "::"
    }
    function ip_v4_partial_to_range(str) {
        var remaining = 3 - (str.split(".").length - 1), first = str, last = str;
        for (str.length - str.lastIndexOf(".") <= 1 && (first += "0", last += "255"); remaining > 0; remaining -= 1)
            first += ".0", last += ".255";
        return first + "-" + last
    }
    function ip4_range_calculate(str) {
        var _ref, address, mask, mask_str, mask_int;
        return patterns.commonRegExp.IP_SUBNET.test(str) ? (_ref = str.indexOf("/"), 0 > _ref ? (address = goog.net.IpAddress.fromString(str), [address, address]) : (mask_str = str.substring(_ref + 1), patterns.commonRegExp.IP_MASK.test(mask_str) ? (mask_int = goog.net.IpAddress.fromString(mask_str).toInteger(), mask_int.toString = goog.math.Integer.prototype.toString, mask = goog.math.Integer.fromNumber(mask_int.toString(2).lastIndexOf("1") + 1)) : mask = goog.math.Integer.fromString(mask_str), address = goog.net.IpAddress.fromString(str.substring(0, _ref)), [subnet.first(address, mask), subnet.last(address, mask)])) : patterns.commonRegExp.IP_RANGE.test(str) || patterns.commonRegExp.IP_RANGE_SPACES.test(str) ? (_ref = str.split("-"), [goog.net.IpAddress.fromString(_ref[0].trim()), goog.net.IpAddress.fromString(_ref[1].trim())]) : patterns.commonRegExp.IP_RANGE2.test(str) ? (_ref = IP_RANGE2_GROUPS.exec(str), [goog.net.IpAddress.fromString(_ref[1] + _ref[2]), goog.net.IpAddress.fromString(_ref[1] + _ref[3])]) : patterns.commonRegExp.IP_WILDCARD.test(str) ? [goog.net.IpAddress.fromString(str.replace("*", "0")), goog.net.IpAddress.fromString(str.replace("*", "255"))] : void 0
    }
    var subnet = function() {
        function subnet_first(address, mask) {
            var mask_raw = mask.toNumber(), shift_amount = 6 === address.getVersion() ? 128 - mask_raw : 32 - mask_raw;
            return address.toInteger().shiftRight(shift_amount).shiftLeft(shift_amount)
        }
        function subnet_last(address, mask) {
            var mask_raw = mask.toNumber(), shift_amount = 6 === address.getVersion() ? 128 - mask_raw : 32 - mask_raw;
            return address.toInteger().shiftRight(shift_amount).add(goog.math.Integer.ONE).shiftLeft(shift_amount).subtract(goog.math.Integer.ONE)
        }
        function subnet_contains(subnet_address, mask, address) {
            var addr_int = address.toInteger();
            return addr_int.greaterThanOrEqual(subnet_first(subnet_address, mask)) && addr_int.lessThanOrEqual(subnet_last(subnet_address, mask))
        }
        function subnet_intersect(a_address, a_mask, b_address, b_mask) {
            return subnet_contains(a_address, a_mask, subnet_first(b_address, b_mask)) || subnet_contains(a_address, a_mask, subnet_last(b_address, b_mask)) || subnet_contains(b_address, b_mask, subnet_first(a_address, a_mask)) || subnet_contains(b_address, b_mask, subnet_last(a_address, a_mask))
        }
        function between(start, end, value) {
            return value.greaterThanOrEqual(start) && value.lessThanOrEqual(end)
        }
        function range_contains(first, last, value) {
            return goog.isFunction(first.toInteger) && (first = first.toInteger()), goog.isFunction(last.toInteger) && (last = last.toInteger()), goog.isFunction(value.toInteger) && (value = value.toInteger()), between(first, last, value)
        }
        function range_intersect(a_first, a_last, b_first, b_last) {
            return goog.isFunction(a_first.toInteger) && (a_first = a_first.toInteger()), goog.isFunction(a_last.toInteger) && (a_last = a_last.toInteger()), goog.isFunction(b_first.toInteger) && (b_first = b_first.toInteger()), goog.isFunction(b_last.toInteger) && (b_last = b_last.toInteger()), between(a_first, a_last, b_first) || between(a_first, a_last, b_last) || between(b_first, b_last, a_last) || between(b_first, b_last, a_last)
        }
        return {first: subnet_first,last: subnet_last,contains: subnet_contains,intersect: subnet_intersect,range_contains: range_contains,range_intersect: range_intersect}
    }(), ip6_object = {search: function(entry, query) {
            var _ref, matches, address, mask, query_address, query_mask;
            return query = fudge_v6_partial(query), _ref = entry.indexOf("/"), address = goog.net.IpAddress.fromString(entry.substring(0, _ref)), mask = goog.math.Integer.fromString(entry.substring(_ref + 1)), patterns.commonRegExp.IP6_HOST.test(query) ? (matches = subnet.contains(address, mask, goog.net.IpAddress.fromString(query)), matches ? [!0] : []) : patterns.commonRegExp.IP6_SUBNET.test(query) ? (_ref = query.indexOf("/"), query_address = goog.net.IpAddress.fromString(query.substring(0, _ref)), query_mask = goog.math.Integer.fromString(query.substring(_ref + 1)), matches = subnet.intersects(address, mask, query_address, query_mask), matches ? [!0] : []) : []
        }}, ip4_basic_search = function(entry_ranges, query) {
        var _ref, query_address, query_first, query_last, range, first, last, matches;
        if (patterns.commonRegExp.IP_HOST.test(query) ? query_address = goog.net.IpAddress.fromString(query) : IP_HOST_PARTIAL.test(query) && (query = ip_v4_partial_to_range(query)), null == query_address) {
            if (_ref = ip4_range_calculate(query), null == _ref)
                return [];
            query_first = _ref[0], query_last = _ref[1]
        }
        return range = entry_ranges[0], first = range[0], last = range[1], matches = null == query_address ? subnet.range_intersect(first, last, query_first, query_last) : subnet.range_contains(first, last, query_address), matches ? [[!0]] : []
    }, IP_HOST_PARTIAL = /^((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){1,2}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])?\.?$/, IP_RANGE2_GROUPS = /^([^\[]+)\[(\d+)-(\d+)\]/, IP_ALL = "0.0.0.0/0.0.0.0", IP_ALL_QUERY_PARTIAL = /(^(0\.){1,3}(0)?$)|(^0\.0\.0\.0)/, IP_ALL_QUERY = /^0\.0\.0\.0\/(0|0\.0\.0\.0)$/, ip4_object = {}, cmdb = {firewall: {address: function(data, query) {
                var range, range_str, is_address_all;
                switch (data.type) {
                    case "iprange":
                        if (range = [goog.net.IpAddress.fromString(data["start-ip"]), goog.net.IpAddress.fromString(data["end-ip"])], IP_ALL_QUERY.test(query))
                            return [];
                        break;
                    case "ipmask":
                        if (range_str = data.address || (null != data.subnet ? data.subnet.replace(" ", "/") : null), is_address_all = IP_ALL === range_str, is_address_all && !IP_ALL_QUERY_PARTIAL.test(query) || !is_address_all && IP_ALL_QUERY.test(query))
                            return [];
                        null != range_str && (range = ip4_range_calculate(range_str));
                        break;
                    case "wildcard":
                        range_str = data.address || (null != data.subnet ? data.subnet.replace(" ", "/") : null), null != range_str && (range = ip4_range_calculate(range_str));
                        break;
                    default:
                        return []
                }
                return null == range || null == range[0] ? [] : ip4_basic_search([range], query)
            }}};
    return {IP_HOST_PARTIAL: IP_HOST_PARTIAL,IP_RANGE2_GROUPS: IP_RANGE2_GROUPS,IP_ALL: IP_ALL,IP_ALL_QUERY: IP_ALL_QUERY,IP_ALL_QUERY_PARTIAL: IP_ALL_QUERY_PARTIAL,subnet_util: subnet,ip6_partial_fudge: fudge_v6_partial,ip4_partial_to_range: ip_v4_partial_to_range,ip4_range_calculate: ip4_range_calculate,ip4_basic_search: ip4_basic_search,ip6: ip6_object,ip4: ip4_object,cmdb: cmdb}
}), fweb_define("fweb.util/icon", [], "fweb.util.icon", function() {
    "use strict";
    var vdomIconMap = {"nat-flow": "ftnt-vdom-flow","nat-proxy": "ftnt-vdom-proxy","tp-flow": "ftnt-vdom-flow-transparent","tp-proxy": "ftnt-vdom-proxy-transparent"}, logonTypeIconMap = {Firewall: "fa-user-firewall",FSSO: "ftnt-fsso-service",FSSO_CITRIX: "ftnt-fsso-service",NTLM: "fa-user-ntlm",RSSO: "ftnt-guest",SSO_GUEST: "ftnt-fsso-service",WSSO: "fa-wsso-service"}, groupTypeIconMap = {firewall: "ftnt-firewall","fsso-service": "ftnt-fsso-service",guest: "fa-guest",rsso: "ftnt-rsso"}, userTypeIconMap = {auth_user: "fa-user-local",fsso: "ftnt-fsso-service",ldap: "ftnt-ldap",peer: "ftnt-peer",radius: "ftnt-radius",remote: "ftnt-remote",tacacs: "ftnt-tacacs","tacacs+": "ftnt-tacacs"}, twoFactorAuthIconTypeMap = {email: "fa-envelope-o",fortitoken: "ftnt-fortitoken",mobile: "fa-mobile",sms: "fa-mobile"}, ICON_TYPE = {GROUP: "group",LOGON: "logon",TWO_FACTOR_AUTH: "two-factor-auth",USER: "user",VDOM: "vdom"}, ICON_TYPE_MAP = {};
    ICON_TYPE_MAP[ICON_TYPE.GROUP] = groupTypeIconMap, ICON_TYPE_MAP[ICON_TYPE.LOGON] = logonTypeIconMap, ICON_TYPE_MAP[ICON_TYPE.TWO_FACTOR_AUTH] = twoFactorAuthIconTypeMap, ICON_TYPE_MAP[ICON_TYPE.USER] = userTypeIconMap, ICON_TYPE_MAP[ICON_TYPE.VDOM] = vdomIconMap;
    var genIcon = function(iconClass, label) {
        var title = label ? ' title="' + label + '"' : "", str = '<f-icon class="' + iconClass + '"' + title + "></f-icon>";
        return label && (str += "<span" + title + ">" + label + "</span>"), str
    }, formatIcon = function(iconType, iconKey, options) {
        var str, iconMap = ICON_TYPE_MAP[iconType] || {}, iconClass = iconMap[iconKey];
        !iconClass && options && options.fallBackIconClass && (iconClass = options.fallBackIconClass);
        var label = options && options.label;
        return str = genIcon(iconClass, label ? label : null)
    }, iconClass = function(iconType, iconKey) {
        var iconMap = ICON_TYPE_MAP[iconType] || {};
        return iconMap[iconKey]
    }, genVdomIconKey = function(vdomName, state) {
        var opMode, inspMode, iconKey, vdom = state.admin.vdom_info[vdomName];
        return vdomName && vdom ? (opMode = vdom.transparent_mode ? "tp" : "nat", inspMode = vdom.inspection_mode, iconKey = opMode + "-" + inspMode) : null
    };
    return {genVdomIconKey: genVdomIconKey,genIcon: genIcon,iconClass: iconClass,formatIcon: formatIcon,ICON_TYPE: ICON_TYPE}
}), fweb_define("fweb.util/avatars", ["md5", "jquery", "fweb.util/location", "fweb.util/dom", "notify"], "fweb.util.avatars", function(md5, $, fweb_location, dom, notify) {
    "use strict";
    var localMediaStream, $capture_button, $capture_preview, AVATAR_CSS = "/p/sprite/avatar/avatars.css", OBJECT_AVATAR_MAX_SIZE = 4096, MAX_SIZE_PX = 36, module = {};
    return fweb.BUILD && fweb.BUILD.SYMBOLS && (OBJECT_AVATAR_MAX_SIZE = fweb.BUILD.SYMBOLS.OBJECT_AVATAR_MAX_SIZE), module.generateObjectClass = function(path, name, mkey) {
        var vdom = /* top.state ? top.state.getOperatingVDOM() : */"root", hash_key = vdom + "#" + path + "." + name + "#" + mkey;
        return module.loadStyleSheet(), "avatar-" + md5(hash_key)
    }, module.loadStyleSheet = function() {
        fweb_location.get_cache(AVATAR_CSS, null) || (dom.addStyle(AVATAR_CSS, !0), fweb_location.set_cache(AVATAR_CSS, !0))
    }, module.resizeAvatarImage = function(image) {
        var dataURL, canvas = document.createElement("canvas"), width = image.width, height = image.height;
        width > height ? width > MAX_SIZE_PX && (height *= MAX_SIZE_PX / width, width = MAX_SIZE_PX) : height > MAX_SIZE_PX && (width *= MAX_SIZE_PX / height, height = MAX_SIZE_PX), canvas.width = width, canvas.height = height, canvas.getContext("2d").drawImage(image, 0, 0, width, height);
        var quality = 1;
        for (dataURL = canvas.toDataURL("image/jpeg", quality); dataURL.length >= OBJECT_AVATAR_MAX_SIZE && quality >= .5; )
            quality -= .01, dataURL = canvas.toDataURL("image/jpeg", quality);
        return dataURL
    }, module.fileToImage = function(file, callback) {
        if (file && file.type.match(/image.*/)) {
            var reader = new FileReader;
            reader.onload = function(readerEvent) {
                var image = new Image;
                image.onload = function() {
                    callback(this)
                }, image.src = readerEvent.target.result
            }, reader.readAsDataURL(file)
        }
    }, module.supportsCapture = function() {
        return navigator.getUserMedia = navigator.getUserMedia || navigator.webkitGetUserMedia || navigator.mozGetUserMedia || navigator.msGetUserMedia, "https:" === location.protocol && navigator.getUserMedia
    }, module.setupCapture = function(button, preview, callback) {
        if ($capture_button = $(button), $capture_preview = $(preview), !module.supportsCapture())
            return $capture_button.disable(), !1;
        var capture_video = $capture_preview.find("video").get(0);
        return $capture_button.on("click", function(e) {
            e.preventDefault(), module.startCapture()
        }), $capture_preview.on("click", function(e) {
            e.preventDefault();
            var canvas = document.createElement("canvas");
            canvas.height = MAX_SIZE_PX, canvas.width = MAX_SIZE_PX, canvas.getContext("2d").drawImage(capture_video, 0, 0, MAX_SIZE_PX, MAX_SIZE_PX), callback(canvas.toDataURL("image/jpeg")), $capture_preview.addClass("hidden"), localMediaStream.getTracks()[0].stop()
        }), !0
    }, module.startCapture = function() {
        navigator.getUserMedia({video: !0}, function(stream) {
            $capture_preview.removeClass("hidden"), $("video", $capture_preview).prop("src", window.URL.createObjectURL(stream)), localMediaStream = stream
        }, function(e) {
            "PermissionDeniedError" !== e.name && notify.post($.getInfo("No camera found")), $capture_button.disable()
        })
    }, module
}), fweb_define("fweb.util/cmdb", ["fweb.util/persist", "ftnt_shared"], "fweb.util.cmdb", function(persist) {
    "use strict";
    var module = {}, LOCAL_STORAGE_KEY = "cmdb_edit_history", LOCAL_STORAGE_MAX = 100, get_edit_history_cookie_name = function() {
        return top.state.cmdb_edit_history_cookie_name
    }, get_local_history = function() {
        var value;
        try {
            if (value = persist.get(LOCAL_STORAGE_KEY)) {
                if (!Array.isArray(value))
                    throw new Error
            } else
                value = []
        } catch (e) {
            fweb.log.warn("Failed to read local CMDB edit history due to invalid format"), value = []
        }
        return value
    }, update_local_history = function(value) {
        value.length > LOCAL_STORAGE_MAX && (value = value.slice(0, LOCAL_STORAGE_MAX)), persist.put(LOCAL_STORAGE_KEY, value)
    };
    return module.update_history_from_cookie = function() {
        var local_history, cookie_history, cookie_name = get_edit_history_cookie_name(), cookie_value = persist.getCookie(cookie_name, !0);
        if (cookie_value)
            try {
                if (cookie_history = JSON.parse(cookie_value), !Array.isArray(cookie_history))
                    throw new Error;
                local_history = get_local_history(), cookie_history.reverse(), local_history.unshift.apply(local_history, cookie_history), update_local_history(local_history)
            } catch (e) {
                fweb.log.warn("Failed to update CMDB edit history from cookie due to invalid format")
            }
        persist.removeCookie(cookie_name, "/")
    }, module.notify_cmdb_edits = function() {
        var i, entry, local_history = get_local_history(), to_notify = [];
        for (i = 0; i < local_history.length && (entry = local_history[i], !entry._notified); i++)
            to_notify.push(entry.path + "." + entry.name), entry._notified = !0;
        to_notify.length && (Omniselect.notifySourceChanged(to_notify), update_local_history(local_history))
    }, module.get_edit_history = function() {
        return get_local_history()
    }, module.clear_edit_history = function() {
        persist.remove(LOCAL_STORAGE_KEY)
    }, module.record_cmdb_edit = function(path, name, mkey) {
        var local_history = get_local_history();
        local_history.unshift({path: path,name: name,mkey: mkey}), update_local_history(local_history)
    }, module
}), fweb_define("fweb.util/slide", ["jquery", "ftnt_shared"], "fweb.util.slide", function($) {
    "use strict";
    var module = {}, DEFAULT_WIDTH = 500, simple_slide = function(params) {
        var slide = new Sliderin(params);
        return slide.open(), slide.promise
    }, format_message_content = function(message, level) {
        var message_class = level + "-message", icon_class = "fa-" + level;
        return '<div class="' + message_class + '"><f-icon class="' + icon_class + '"></f-icon><div class="message-content">' + message + "</div></div>"
    };
    return module.LEVEL = {SUCCESS: "success",INFO: "info",WARNING: "warning",ERROR: "error"}, module.alert = function(message, level, params) {
        return level = level || module.LEVEL.WARNING, params = $.extend({content: format_message_content(message, level),buttons: !0,okButtonClass: null,cancelButton: !1,width: DEFAULT_WIDTH}, params || {}), simple_slide(params)
    }, module.confirm = function(message, level, params) {
        return level = level || module.LEVEL.WARNING, params = $.extend({content: format_message_content(message, level),title: $.getInfo("confirm_title"),buttons: !0,width: DEFAULT_WIDTH}, params || {}), simple_slide(params)
    }, module.iframe = function(url, params) {
        0 === url.indexOf("/ng/") && (url += (url.indexOf("?") >= 0 ? "&" : "?") + "viewOnly"), url += (url.indexOf("?") >= 0 ? "&" : "?") + "redir=/omni_success";
        var slide = new Sliderin($.extend({url: url}, params || {}));
        return slide.open(), 
        slide.promise
    }, module
}), fweb_define("fweb.util/shortcuts", ["jquery", "fweb.util/structure"], "fweb.util.shortcuts", function($, structure) {
    "use strict";
    var module = {}, create_key = function(key, modifiers, label) {
        var keyCode = "number" == typeof key ? key : key.key;
        return modifiers && (modifiers = Array.isArray(modifiers) ? modifiers : [modifiers]), {key: keyCode,modifiers: modifiers,label: label}
    }, ENTER = create_key(13, null, "Enter"), ESCAPE = create_key(27, null, "Esc"), LEFT = create_key(37, null, "←"), UP = create_key(38, null, "↑"), RIGHT = create_key(39, null, "→"), DOWN = create_key(40, null, "↓"), A = create_key(65, null, "a"), B = create_key(66, null, "b"), J = create_key(74, null, "j"), K = create_key(75, null, "k"), FORWARD_SLASH = create_key(191, null, "/"), OPEN_BRACKET = create_key(219, null, "["), CONTROL = "ctrlKey", SHIFT = "shiftKey", CONTROL_J = create_key(J, CONTROL, "Ctrl+j"), CONTROK_K = create_key(K, CONTROL, "Ctrl+k"), CONTROL_OPEN_BRACKET = create_key(OPEN_BRACKET, CONTROL, "Ctrl+["), QUESTION_MARK = create_key(FORWARD_SLASH, SHIFT, "?"), TYPES = {SIMPLE: "simple",MULTIPLE: "multiple",SEQUENCE: "sequence"}, SHORTCUTS = module.SHORTCUTS = {CLEAR: "clear",CONTRA: "contra",HELP: "help",NEXT: "next",PREVIOUS: "previous",SEARCH: "search",SELECT: "select"}, CONFIGURATION = {};
    CONFIGURATION[SHORTCUTS.CLEAR] = {type: TYPES.MULTIPLE,keys: [ESCAPE, CONTROL_OPEN_BRACKET]}, CONFIGURATION[SHORTCUTS.CONTRA] = {type: TYPES.SEQUENCE,sequence: [UP, UP, DOWN, DOWN, LEFT, RIGHT, LEFT, RIGHT, B, A]}, CONFIGURATION[SHORTCUTS.HELP] = {type: TYPES.SIMPLE,key: QUESTION_MARK}, CONFIGURATION[SHORTCUTS.NEXT] = {type: TYPES.MULTIPLE,keys: [DOWN, CONTROL_J]}, CONFIGURATION[SHORTCUTS.PREVIOUS] = {type: TYPES.MULTIPLE,keys: [UP, CONTROK_K]}, CONFIGURATION[SHORTCUTS.SEARCH] = {type: TYPES.SIMPLE,key: FORWARD_SLASH}, CONFIGURATION[SHORTCUTS.SELECT] = {type: TYPES.SIMPLE,key: ENTER};
    var MATCH_LEVEL = {SEQUENCE: 1,NORMAL: 2,MODIFIED: 3,MULTI_MODIFIED: 4};
    return module.get_labels = function(shortcut) {
        var keys, configuration = CONFIGURATION[shortcut], get_label = function(key) {
            return key.label
        };
        switch (configuration.type) {
            case TYPES.SIMPLE:
                keys = [get_label(configuration.key)];
                break;
            case TYPES.SEQUENCE:
                keys = [configuration.sequence.map(get_label).join(" ")];
                break;
            case TYPES.MULTIPLE:
                keys = configuration.keys.map(get_label)
        }
        return keys
    }, module.create_shortcut_checker = function(shortcuts, callback) {
        var sequenceTrackingIndexes = {}, key_matches = function(event, key) {
            return event.keyCode === key.key && (key.modifiers || []).every(function(modifier) {
                return event[modifier]
            })
        }, get_level_for_key = function(key) {
            var level = MATCH_LEVEL.NORMAL, num_modifiers = (key.modifiers || []).length;
            return num_modifiers > 1 ? level = MATCH_LEVEL.MULTI_MODIFIED : num_modifiers && (level = MATCH_LEVEL.MODIFIED), level
        }, get_match_level = function(event, shortcut) {
            var i, key, nextIndex, match_level = MATCH_LEVEL.NONE, configuration = CONFIGURATION[shortcut];
            switch (configuration.type) {
                case TYPES.SIMPLE:
                    key = configuration.key, key_matches(event, key) && (match_level = get_level_for_key(key));
                    break;
                case TYPES.SEQUENCE:
                    nextIndex = sequenceTrackingIndexes[shortcut], key_matches(event, configuration.sequence[nextIndex]) ? (nextIndex = ++sequenceTrackingIndexes[shortcut], nextIndex >= configuration.sequence.length && (match_level = MATCH_LEVEL.SEQUENCE, sequenceTrackingIndexes[shortcut] = 0)) : nextIndex && (sequenceTrackingIndexes[shortcut] = 0);
                    break;
                case TYPES.MULTIPLE:
                    for (i = 0; i < configuration.keys.length; i++)
                        if (key = configuration.keys[i], key_matches(event, key)) {
                            match_level = get_level_for_key(key);
                            break
                        }
            }
            return match_level
        };
        return shortcuts = shortcuts || Object.keys(SHORTCUTS).map(function(key) {
            return SHORTCUTS[key]
        }), shortcuts.forEach(function(shortcut) {
            CONFIGURATION[shortcut].type === TYPES.SEQUENCE && (sequenceTrackingIndexes[shortcut] = 0)
        }), function(event) {
            var best_match, best_match_level = 0;
            shortcuts.forEach(function(shortcut) {
                var match_level = get_match_level(event, shortcut);
                match_level > best_match_level && (best_match = shortcut, best_match_level = match_level)
            }), best_match && (event.stopPropagation(), callback(best_match, event))
        }
    }, module.listen = function() {
        var checker = module.create_shortcut_checker(null, function(shortcut) {
            structure.topPostMessage({messageType: "shortcutPressed",shortcut: shortcut})
        });
        $("body").on("keyup", function(event) {
            event.target && !$(event.target).is("input,textarea") && checker(event)
        })
    }, module
}), function() {
    "use strict";
    fweb_define("fweb", ["fweb.dialog", "fweb.features", "fweb.interface", "fweb.util/core", "fweb.util/uri", "fweb.util/location", "fweb.util/datetime", "fweb.util/patterns", "fweb.util/ip", "fweb.util/formatters", "fweb.util/dom", "fweb.util/events", "fweb.util/functional", "fweb.util/objects", "fweb.util/templates", "fweb.util/logs", "fweb.util/shim", "fweb.util/sort", "fweb.util/legacy", "fweb.util/address", "fweb.util/persist", "fweb.util/structure", "fweb.util/certificate", "fweb.util/firewallInterfaces", "fweb.util/interface", "fweb.util/policy", "fweb.util/address_search", "fweb.util/icon", "fweb.util/avatars", "fweb.util/cmdb", "fweb.util/slide", "fweb.util/shortcuts"], null, function() {
        return window.fweb
    }), fweb_define("fweb.util", ["fweb"], null, function(fweb) {
        return fweb.util
    })
}(), fweb_define("jquery.multilist", ["jquery", "jquery.ui", "fweb", "fweb.util/events", "fweb.util/dom", "jquery.util_core"], null, function($, $_ui, fweb, f_util_events, f_util_dom) {
    function setOptionsFromSelect(config) {
        var opt, i, val, opts = {}, src = [];
        for (i = 0; opt = this.options[i]; i++)
            val = opt.value, opts[val] = opt, src.push(val);
        return config.source = src, config.option = opts, config
    }
    function getStaticSourceFunction(get_items, config, input) {
        return function(request, response) {
            var term = request.term.toLowerCase(), items = get_items();
            response($.map(config.source, function(v, i) {
                function _search_contains() {
                    return elmt.value.toLowerCase().indexOf(term) >= 0 || $("<div>" + elmt.label + "</div>").text().toLowerCase().indexOf(term) >= 0
                }
                function _search_start_with() {
                    return 0 === elmt.value.toLowerCase().indexOf(term) || 0 === $("<div>" + elmt.label + "</div>").text().toLowerCase().indexOf(term)
                }
                var str = v.toString() || "", in_arr = -1 !== $.inArray(str, items);
                if (!str || in_arr && "multi" === config.selector_type)
                    return null;
                var disp = config.display.call(input[0], v, {});
                "string" == typeof disp && (disp = {label: disp});
                var elmt = $.extend({index: i,value: v}, disp);
                if (!elmt.label)
                    return null;
                if ("single" === config.selector_type && in_arr && (elmt.label = '<span class="selected">' + elmt.label + "</span>"), !term)
                    return elmt;
                var found = !0;
                return "auto" === config.search_method ? found = 1 === term.length ? _search_start_with() : _search_contains() : "contains" === config.search_method ? found = _search_contains() : "start" === config.search_method && (found = _search_start_with()), found ? elmt : null
            }))
        }
    }
    var namespaced = f_util_events.namespacify("fortinetMulticomplete"), namespaced_click = namespaced("click"), _unique_id = 0, get_unique_id = function() {
        return _unique_id++
    };
    $.widget("fortinet.multicomplete", $.ui.autocomplete, {options: {multiselect: !0},_create: function() {
            $.ui.autocomplete.prototype._create.call(this), this._off(this.element, "blur"), this.menu._off(this.menu.element, "click"), this._on(this.menu.element, {"dbclick .ui-menu-item a": function(event) {
                    var target = this._get_ctrl(event);
                    if (target.length)
                        return this._menu_select(event, target)
                },"click .ui-menu-item a": "_on_multicomplete_click"}), this._on({autocompleteclose: function() {
                    this.last_selected_el = $()
                },autocompleteopen: function() {
                    this.last_selected_el = $(), this._refreshMultilistOkButton()
                }}), this.last_selected_el = $()
        },_get_ctrl: function(event) {
            return $(event.target).closest(".ui-menu-item a")
        },_menu_select: function(event, target) {
            return this.menu.focus(event, target.parent(".ui-menu-item")), this.menu.select(event), !1
        },_on_multicomplete_click: function(event) {
            var target = this._get_ctrl(event);
            if (target.length && !target.parent().is(".disabled")) {
                if (!this.options.multiselect)
                    return this._menu_select(event, target);
                var last = this.last_selected_el;
                if (last = last.not(target), !event.shiftKey && !event.ctrlKey)
                    return last.removeClass("selected"), last = $(), target.addClass("selected"), this._menu_select(event, target);
                if (event.ctrlKey)
                    target.toggleClass("selected");
                else {
                    var start = $(last[last.length - 1]);
                    if (0 === start.length)
                        target.toggleClass("selected");
                    else {
                        if (start == target)
                            return;
                        var items = [start.closest("li"), target.closest("li")].sort(function(a, b) {
                            var a_ctrl = a.data("ui-autocomplete-item"), b_ctrl = b.data("ui-autocomplete-item");
                            return a_ctrl && b_ctrl ? a_ctrl.index - b_ctrl.index : !0
                        });
                        items[0].nextUntil(items[1], ".ui-menu-item").each(function() {
                            var elem = $("a:first", this).addClass("selected");
                            last = last.add(elem)
                        }), target.addClass("selected")
                    }
                }
                target.hasClass("selected") && (last = last.add(target)), this.last_selected_el = last, this._refreshMultilistOkButton()
            }
        },_refreshMultilistOkButton: function() {
            var $inputContainer = this.menu.element.parents(".multiList-input-container");
            $inputContainer.length <= 0 && ($inputContainer = this.element.parents(".multiList-input-container")), $inputContainer.find(".multiList-add").css("display", this.last_selected_el.length > 0 ? "inline-block" : "none")
        },_renderItem: function(ul, item) {
            var li = document.createElement("li"), a = document.createElement("a");
            li.appendChild(a), a.innerHTML = item.label, $(li).data("ui-autocomplete-item", item).addClass("ui-menu-item").toggleClass("disabled", !!item.disabled).attr("title", item.tooltip || "").attr("role", "menuitem"), ul[0].appendChild(li)
        },_normalize: function() {
            var normalized = $.ui.autocomplete.prototype._normalize.apply(this, arguments);
            return $.each(normalized, function(index, item) {
                item.index = index
            }), normalized
        },stopRender: function() {
            null != this.renderMenuLoop && this.renderMenuLoop.interrupt()
        },_renderMenuByCategories: function(ul, items) {
            var category, that = this, $no = ul.siblings(".no-options").addClass("ui-autocomplete-loading"), no_oldtext = $no.text();
            $no.text($.getInfo("loading"));
            var reattach = fweb.util.dom.$detached(ul);
            this.renderMenuLoop = fweb.util.functional.asyncEach(items, function(index, item) {
                if (item.category != category && (category = item.category)) {
                    var li = '<li class="ui-autocomplete-category">' + category + "</li>";
                    ul.append(li)
                }
                that._renderItem(ul, item)
            }).done(function() {
                reattach(), $no.removeClass("ui-autocomplete-loading"), $no.text(no_oldtext), that.renderMenuLoop = null, that._trigger("rendercomplete")
            })
        },_renderMenu: function(ul, items) {
            this._renderMenuByCategories(ul, items)
        },complete: function(event) {
            var vals = [];
            $.each($(".selected", this.menu.element), function() {
                var item = $(this).closest("li").data("ui-autocomplete-item");
                vals.push(item.value)
            }), this._trigger("select", event, {item: {value: vals}}), this.close(event)
        }}), $.fn.multiList = function(params) {
        "string" == typeof params && "refreshOptions" === params && $(this).each(function() {
            var get_items, config = this.config, input = $(this);
            "SELECT" == this.tagName && (null == config && $.fn.multiList.error("cannot call refreshOptions on multiList prior to initialization"), get_items = input.prop("multiple") ? function() {
                return input.val()
            } : function() {
                return [input.val()]
            }, config = setOptionsFromSelect.call(this, config), $(this).closest(".multiList-container").find(".multiList-input").multicomplete("option", "source", getStaticSourceFunction(get_items, config, input)))
        }), $.addStyle("/" + fweb.CONFIG_GUI_NO + "/css/jquery.multilist.css"), $.addStyle("/" + fweb.CONFIG_GUI_NO + "/css/jquery.ui.css");
        var defaults = {cls: ".multiList-container","class": "",source: [],max: 0,min: 0,readonly: !1,selector_type: void 0,floating: !0,search_method: "auto",display: function(v) {
                return f_util_dom.escapeHTML(v) || "single" === this.config.selector_type && this.config.lang.select || this.config.lang["default"]
            },create: {enable: !1,callback: null,"class": "multiList-new",label: $.getInfo("create")},inline_edit: !1,inline_input_class: null,validate: !1,separator: ",",lang: {heading: $.getInfo("select"),"default": $.getInfo("click_add"),select: $.getInfo("click_set"),no_options: $.getInfo("no_options")},tooltips: {"new": $.getInfo("create"),add: $.getInfo("add"),ok: $.getInfo("ok"),remove: $.getInfo("remove")}};
        return $(this).each(function() {
            function create_item(event) {
                var updated_value, num_items = get_items().length, create_callback = config.create.callback, value = "";
                event && (_mouseHandled = !0, value = $input_mc.val() || ""), "function" == typeof create_callback ? (updated_value = create_callback.call(input[0], value), updated_value && ($input_mc.val(updated_value), addItem()), closeList()) : (closeList(), 1 === config.max || 0 === num_items ? editInline.call($list.find(".multiList-list-item").first(), value) : config.max === num_items ? editInline.call($list.find(".multiList-list-item").last(), value) : addInline(value))
            }
            function get_items() {
                var val = input.val(), items = [];
                return val && (items = $.isArray(val) ? val : val.split(config.separator)), items
            }
            function set_items(items) {
                var val = input.val(), result = items;
                $.isArray(val) || (result = items.join(config.separator)), input.val(result), input.change();
                var validator = $.fn.validate && input.closest("form").validate();
                validator && validator.element(input[0])
            }
            function addItem() {
                $.each($input_mc.val().split(config.separator), function() {
                    var itemText = this, items = get_items();
                    items.push(itemText), config.max && items.length > config.max && items.shift(), set_items(items), $.isFunction(config.afterInsert) && config.afterInsert.call(input[0], itemText)
                }), $input_mc.val(""), refreshList()
            }
            function addInline(value) {
                var $li = $('<li class="multiList-inline-item"></li>'), $input = $('<input type="text" />').val(value || "");
                $list.append($li.append($input)), _editing_inline = !0, $input.select().on("focusout keypress", function(event) {
                    var items, value = $input.val();
                    return "focusout" === event.type || event.keyCode === $.ui.keyCode.ENTER ? ($input.off(), value && (items = get_items(), items.push(value), set_items(items), refreshList()), $li.remove(), _editing_inline = !1, !1) : void 0
                })
            }
            function editInline(value) {
                var items = get_items(), num_items = items.length, $entry = $(this).closest("li"), index = $entry.data("index"), currentVal = items[index], $li = $('<li class="multiList-inline-item"></li>'), $input = $('<input type="text" />');
                num_items ? $input.val(value || items[index]) : $input.val(value || ""), $li.append($input), $entry.after($li).detach(), _editing_inline = !0, config.inline_input_class && $input.addClass(config.inline_input_class), $input.select().on("focusout keypress", function(event) {
                    var value = $input.val();
                    if ("focusout" === event.type || event.keyCode === $.ui.keyCode.ENTER) {
                        if (config.validate && !$input.valid())
                            return;
                        return $input.off(), !num_items || value && value !== currentVal ? (items.length ? items[index] = value : items = [value], set_items(items), $li.remove(), refreshList(), !1) : ($li.replaceWith($entry), !1)
                    }
                })
            }
            function removeItem() {
                var items = get_items(), idx = $(this).closest("li").data("index");
                if (void 0 !== idx) {
                    var item = items.splice(idx, 1);
                    set_items(items), $.isFunction(config.afterRemove) && config.afterRemove.call(input[0], item)
                }
                refreshList()
            }
            function addIcon($listItem, icon_type) {
                if (!($.inArray(icon_type, ["deletion", "dropdown"]) < 0)) {
                    var cls = "deletion" === icon_type ? "multiList-close" : "multiList-dropdown", item_a = $('<a class="multiList-btn ' + cls + '" />');
                    "deletion" === icon_type && item_a.addClass("flex-centered").html('<f-icon class="fa-times-circle icon-sm"></f-icon>'), $listItem.append(item_a)
                }
            }
            function refreshList() {
                var reattach = fweb.util.dom.$detached($list), items = get_items();
                $list.removeClass("focus"), $("li.multiList-list-item", $list).remove();
                for (var disp, $listItem, $shown_item, len = items.length, show_deletion = !config.readonly && !config.disabled && len > config.min, show_dropdown = !config.readonly && !config.disabled && !config.disabled_dropdown, i = 0; len > i; ++i) {
                    $listItem = $('<li class="multiList-list-item"></li>').data("index", i);
                    var icon_type = show_deletion ? "deletion" : show_dropdown ? "dropdown" : "";
                    addIcon($listItem, icon_type), $shown_item = $('<div class="multiList-item" />'), disp = config.display.call(input[0], items[i], {}), $shown_item.append(disp.label || disp);
                    var tooltip = disp.tooltip;
                    $shown_item.attr("title", tooltip ? tooltip : $shown_item.text()), $listItem.append($shown_item).addClass(config.disabled ? "disabled" : "").addClass(config.disabled_dropdown ? "disabled_dropdown" : ""), $inputContainer.before($listItem)
                }
                if (!len) {
                    disp = config.display.call(input[0], "", {});
                    var lbl = disp.label || disp;
                    $listItem = $('<li class="multiList-list-item"></li>'), addIcon($listItem, show_dropdown ? "dropdown" : ""), $shown_item = $('<div class="multiList-item" />'), $shown_item.append(lbl), $listItem.append($shown_item).addClass(config.disabled ? "disabled" : "").addClass(config.disabled_dropdown ? "disabled_dropdown" : ""), $listItem.prependTo($list)
                }
                $("li.multiList-list-item", $list).off(namespaced_click).on(namespaced_click, function(event) {
                    $(this).hasClass("disabled") || $(this).hasClass("disabled_dropdown") || (config.create.enable && 0 === config.source.length ? create_item() : $input_mc.data("fortinetMulticomplete").menu.element.is(":visible") || (config.inline_edit ? editInline.call(this) : add_button.triggerHandler("click")))
                }), $("a.multiList-close", $list).off(namespaced_click).on(namespaced_click, function() {
                    return _mouseHandled = !0, removeItem.call(this), !1
                });
                var src = config.source, select_cond = config.create.enable || config.inline_edit || "string" == typeof src || len < src.length;
                add_button.toggle(!config.disabled && !!input.val() && (!config.max || len < config.max && config.max > 1) && select_cond), reattach(), "function" == typeof config.post_refresh_callback && config.post_refresh_callback.call($list)
            }
            function closeList() {
                $(document).off(namespaced("click", config.uid)), $inputContainer.hide(), $input_mc.multicomplete("stopRender"), input.val() || _editing_inline || refreshList(), config.dialog && config.dialog.dialog("option", "position", config.dialog.dialog("option", "position")), ensureContainerSize()
            }
            function ensureContainerSize() {
                var $content = $inputContainer.closest(".ui-dialog-content, .dialog .content").first(), h = $inputContainer.filter(":visible").outerHeight(!0) || "";
                activeInputContainer === $inputContainer && (activeInputContainer = null), h && $content[0] && (activeInputContainer = $inputContainer, $inputContainer.css("padding-bottom", ""), $.swap($content[0], {"flex-grow": 1}, function() {
                    h = Math.min(h, $content.height())
                })), activeInputContainer !== $inputContainer && activeInputContainer || $content.css("padding-bottom", h)
            }
            var _mouseHandled = !1, _editing_inline = !1, input = $(this), config = $.extend(!0, {}, defaults, this.config, {readonly: input.prop("readonly"),disabled: input.prop("disabled"),disabled_dropdown: !1,width: this.style.width || void 0,uid: "multilist" + get_unique_id()});
            if ("SELECT" == this.tagName && (this.config || $.extend(config, {selector_type: input.attr("multiple") ? "multi" : "single"}), config = setOptionsFromSelect.call(this, config), this.config && this.config.display || (config.display = function(v) {
                return this.config.option[v] && this.config.option[v].text || v || config.lang.select || config.lang["default"]
            })), config = $.extend(!0, {}, config, params), params && params.source && (config.source = params.source), config.selector_type ? "single" === config.selector_type && (config.max = 1) : config.selector_type = 1 === config.max ? "single" : "multi", input.prop("readonly", config.readonly), input.prop("disabled", config.disabled), this.config = config, "hidden" != input.attr("type")) {
                var wrap = input.closest(config.cls);
                wrap.length > 0 && (wrap.before(input), wrap.remove());
                var container_wrap = $(config.validate ? "<form />" : "<div />"), container_class = config.cls.substr(1);
                container_wrap.addClass(container_class), config.width && container_wrap.width(config.width);
                var container = input.wrap(container_wrap).closest(config.cls), $list = $('<ul class="multiList-list"></ul>');
                $list.addClass(config["class"]), $list.prependTo(container);
                var $inputContainer = $('<li class="multiList-input-container" />').hide().appendTo($list);
                config.floating && $inputContainer.addClass("multiList-input-container-float");
                var opts_html = ($('<div class="multiList-heading" />').append("<span>" + config.lang.heading + "</span>").append('<a class="multiList-btn multiList-close" />').appendTo($inputContainer), '<div class="multiList-options" onselectstart="return false;" />'), $opts_div = $(opts_html).append('<div class="no-options">' + config.lang.no_options + "</div>").appendTo($inputContainer), $tool_div = $('<div class="multiList-footer" />').appendTo($inputContainer), $input_mc = $('<input type="text" class="multiList-input tool_sprite tool_search2 search_box" />').appendTo($tool_div);
                $("a.multiList-close", container).off(namespaced_click).on(namespaced_click, closeList);
                var button_div = $('<div class="right_btn" />').appendTo($tool_div);
                if (config.create.enable) {
                    var _cls = config.create["class"], _label = config.create.label;
                    $('<a class="multiList-btn ' + _cls + '" />').text(_label).attr("title", _label).appendTo(button_div).click(create_item)
                }
                $('<a class="multiList-btn multiList-add" />').text(config.tooltips.ok).attr("title", config.tooltips.ok).appendTo(button_div).click(function() {
                    _mouseHandled = !0, $input_mc.multicomplete("complete")
                }).css("display", "none");
                var add_button = $('<a class="multiList-btn multiList-show" />').attr("title", config.tooltips.add).html('<f-icon class="fa-plus-circle"></f-icon>').click(function() {
                    if (_mouseHandled = !0, config.inline_edit)
                        return void addInline();
                    $(document).off(namespaced("click", config.uid)).on(namespaced("click", config.uid), documentClickHandler), $input_mc.val(""), $inputContainer.css({"min-width": $list.width() - 4}).show(), $input_mc.multicomplete("search"), $input_mc.focus();
                    var $optlist = $opts_div.find(".ui-autocomplete");
                    $optlist.length > 0 && config.max_height && $optlist.css("max-height", config.max_height), ($optlist.length <= 0 || $optlist[0].scrollHeight <= $optlist[0].clientHeight) && ($input_mc.css({position: "absolute","margin-left": "-300%"}), null != $input_mc.data("fortinetMulticomplete").renderMenuLoop && $input_mc.one(namespaced("multicompleterendercomplete"), function() {
                        var optlist = $opts_div.find(".ui-autocomplete")[0];
                        optlist && optlist.scrollHeight > optlist.clientHeight && $input_mc.css({position: "static","margin-left": "0"}), ensureContainerSize()
                    })), input.val() || $(".multiList-list-item", $list).text("​"), ensureContainerSize()
                });
                config.readonly || $list.before(add_button), $.isFunction($.fn.validate) && config.validate && (container.validate(), $input_mc.rules("add", config.validate)), $inputContainer.on("mouseout", $.debounce(50, function() {
                    !$input_mc.is(":focus") && $inputContainer.is(":visible") && $input_mc.focus()
                })), $input_mc.keypress(function(evt) {
                    13 == evt.keyCode && config.create.enable && create_item(!0)
                }).keyup(function(evt) {
                    27 == evt.keyCode && ($input_mc.val() ? $input_mc.val("").multicomplete("search") : closeList())
                }).blur(function() {
                    var loss_focus = $(document.activeElement).closest(config.cls)[0] != container[0];
                    loss_focus && $inputContainer.is(":visible") && setTimeout(closeList, 150)
                });
                var documentClickHandler = function(event) {
                    _mouseHandled || !$inputContainer.is(":visible") || $(event.target).closest(".multiList-input-container").length || closeList(), _mouseHandled = !1
                };
                if (config.source) {
                    var source = $.noop();
                    source = $.isFunction(config.source) ? config.source : getStaticSourceFunction(get_items, config, input), $input_mc.multicomplete({source: source,multiselect: "multi" === config.selector_type,appendTo: $opts_div,select: function(e, ui) {
                            var item_val = ui.item.value, is_array = $.isArray(item_val);
                            $input_mc.val(is_array ? item_val.join(config.separator) : item_val), addItem(), closeList()
                        },close: function(evt) {
                            $(this).is(":focus") || (closeList(), config.dialog && config.dialog.dialog("option", "position", config.dialog.dialog("option", "position")))
                        },open: function(event, ui) {
                            config.dialog && config.dialog.dialog("option", "position", config.dialog.dialog("option", "position"))
                        },minLength: 0})
                }
                input.hide(), this.focus = function() {
                    $list.addClass("focus")
                }, refreshList()
            }
        })
    };
    var activeInputContainer = null;
    $.fn.multiList.error = function(message) {
        throw new $.fn.multiList.Error(message)
    }, $.fn.multiList.Error = function(message) {
        this.name = "multiList.Error", this.message = message, this._is_fweb_multiList_error = !0
    }, $.toArray = function(obj) {
        var arr = [];
        for (var x in obj)
            obj.hasOwnProperty(x) && arr.push(x);
        return arr
    }
}), fweb_define("notify", ["jquery", "fweb.util/persist", "ftnt_shared"], "Notify", function($, persist, ftnt_shared) {
    "use strict";
    function get_django_message_cookie_data(cookie_key) {
        cookie_key = cookie_key || "messages";
        var messages, cookie_data = "", octal_escape_chars = /\\0([0-7]{2})/g, messages_prep = persist.getCookie(cookie_key).replace(octal_escape_chars, function(m, n) {
            return "\\u" + ("0000" + parseInt(n, 8).toString(16)).slice(-4)
        });
        try {
            messages = $.parseJSON(messages_prep), cookie_data = $.parseJSON(messages.substr(messages.indexOf("$") + 1))
        } catch (err) {
            return ""
        }
        return cookie_data
    }
    function get_django_messages() {
        if (persist.hasCookie("messages")) {
            var message_obj = get_django_message_cookie_data();
            if ($.isArray(message_obj))
                for (var i = 0; i < message_obj.length; i++)
                    Notify.post(message_obj[i][2], DJANGO_SEVERITIES[message_obj[i][1]]);
            persist.removeCookie("messages", "/")
        }
    }
    var Notify = /*top.Notify ? top.Notify :*/ ftnt_shared.notify, DJANGO_SEVERITIES = {10: Notify.LEVEL.INFO,20: Notify.LEVEL.INFO,25: Notify.LEVEL.INFO,30: Notify.LEVEL.WARNING,40: Notify.LEVEL.ERROR};
    return $(document).ready(function() {
        get_django_messages()
    }), Notify
}), fweb_define("flot", ["jquery"], null, function() {
    if (function($) {
        $.color = {}, $.color.make = function(r, g, b, a) {
            var o = {};
            return o.r = r || 0, o.g = g || 0, o.b = b || 0, o.a = null != a ? a : 1, o.add = function(c, d) {
                for (var i = 0; i < c.length; ++i)
                    o[c.charAt(i)] += d;
                return o.normalize()
            }, o.scale = function(c, f) {
                for (var i = 0; i < c.length; ++i)
                    o[c.charAt(i)] *= f;
                return o.normalize()
            }, o.toString = function() {
                return o.a >= 1 ? "rgb(" + [o.r, o.g, o.b].join(",") + ")" : "rgba(" + [o.r, o.g, o.b, o.a].join(",") + ")"
            }, o.normalize = function() {
                function clamp(min, value, max) {
                    return min > value ? min : value > max ? max : value
                }
                return o.r = clamp(0, parseInt(o.r), 255), o.g = clamp(0, parseInt(o.g), 255), o.b = clamp(0, parseInt(o.b), 255), o.a = clamp(0, o.a, 1), o
            }, o.clone = function() {
                return $.color.make(o.r, o.b, o.g, o.a)
            }, o.normalize()
        }, $.color.extract = function(elem, css) {
            var c;
            do {
                if (c = elem.css(css).toLowerCase(), "" != c && "transparent" != c)
                    break;
                elem = elem.parent()
            } while (elem.length && !$.nodeName(elem.get(0), "body"));
            return "rgba(0, 0, 0, 0)" == c && (c = "transparent"), $.color.parse(c)
        }, $.color.parse = function(str) {
            var res, m = $.color.make;
            if (res = /rgb\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*\)/.exec(str))
                return m(parseInt(res[1], 10), parseInt(res[2], 10), parseInt(res[3], 10));
            if (res = /rgba\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]+(?:\.[0-9]+)?)\s*\)/.exec(str))
                return m(parseInt(res[1], 10), parseInt(res[2], 10), parseInt(res[3], 10), parseFloat(res[4]));
            if (res = /rgb\(\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*\)/.exec(str))
                return m(2.55 * parseFloat(res[1]), 2.55 * parseFloat(res[2]), 2.55 * parseFloat(res[3]));
            if (res = /rgba\(\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\s*\)/.exec(str))
                return m(2.55 * parseFloat(res[1]), 2.55 * parseFloat(res[2]), 2.55 * parseFloat(res[3]), parseFloat(res[4]));
            if (res = /#([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})/.exec(str))
                return m(parseInt(res[1], 16), parseInt(res[2], 16), parseInt(res[3], 16));
            if (res = /#([a-fA-F0-9])([a-fA-F0-9])([a-fA-F0-9])/.exec(str))
                return m(parseInt(res[1] + res[1], 16), parseInt(res[2] + res[2], 16), parseInt(res[3] + res[3], 16));
            var name = $.trim(str).toLowerCase();
            return "transparent" == name ? m(255, 255, 255, 0) : (res = lookupColors[name] || [0, 0, 0], m(res[0], res[1], res[2]))
        };
        var lookupColors = {aqua: [0, 255, 255],azure: [240, 255, 255],beige: [245, 245, 220],black: [0, 0, 0],blue: [0, 0, 255],brown: [165, 42, 42],cyan: [0, 255, 255],darkblue: [0, 0, 139],darkcyan: [0, 139, 139],darkgrey: [169, 169, 169],darkgreen: [0, 100, 0],darkkhaki: [189, 183, 107],darkmagenta: [139, 0, 139],darkolivegreen: [85, 107, 47],darkorange: [255, 140, 0],darkorchid: [153, 50, 204],darkred: [139, 0, 0],darksalmon: [233, 150, 122],darkviolet: [148, 0, 211],fuchsia: [255, 0, 255],gold: [255, 215, 0],green: [0, 128, 0],indigo: [75, 0, 130],khaki: [240, 230, 140],lightblue: [173, 216, 230],lightcyan: [224, 255, 255],lightgreen: [144, 238, 144],lightgrey: [211, 211, 211],lightpink: [255, 182, 193],lightyellow: [255, 255, 224],lime: [0, 255, 0],magenta: [255, 0, 255],maroon: [128, 0, 0],navy: [0, 0, 128],olive: [128, 128, 0],orange: [255, 165, 0],pink: [255, 192, 203],purple: [128, 0, 128],violet: [128, 0, 128],red: [255, 0, 0],silver: [192, 192, 192],white: [255, 255, 255],yellow: [255, 255, 0]}
    }(jQuery), function($) {
        function Canvas(cls, container) {
            var element = container.children("." + cls)[0];
            if (null == element && (element = document.createElement("canvas"), element.className = cls, $(element).css({direction: "ltr",position: "absolute",left: 0,top: 0}).appendTo(container), !element.getContext)) {
                if (!window.G_vmlCanvasManager)
                    throw new Error("Canvas is not available. If you're using IE with a fall-back such as Excanvas, then there's either a mistake in your conditional include, or the page has no DOCTYPE and is rendering in Quirks Mode.");
                element = window.G_vmlCanvasManager.initElement(element)
            }
            this.element = element;
            var context = this.context = element.getContext("2d"), devicePixelRatio = window.devicePixelRatio || 1, backingStoreRatio = context.webkitBackingStorePixelRatio || context.mozBackingStorePixelRatio || context.msBackingStorePixelRatio || context.oBackingStorePixelRatio || context.backingStorePixelRatio || 1;
            this.pixelRatio = devicePixelRatio / backingStoreRatio, this.resize(container.width(), container.height()), this.textContainer = null, this.text = {}, this._textCache = {}
        }
        function Plot(placeholder, data_, options_, plugins) {
            function executeHooks(hook, args) {
                args = [plot].concat(args);
                for (var i = 0; i < hook.length; ++i)
                    hook[i].apply(this, args)
            }
            function initPlugins() {
                for (var classes = {Canvas: Canvas}, i = 0; i < plugins.length; ++i) {
                    var p = plugins[i];
                    p.init(plot, classes), p.options && $.extend(!0, options, p.options)
                }
            }
            function parseOptions(opts) {
                $.extend(!0, options, opts), opts && opts.colors && (options.colors = opts.colors), null == options.xaxis.color && (options.xaxis.color = $.color.parse(options.grid.color).scale("a", .22).toString()), null == options.yaxis.color && (options.yaxis.color = $.color.parse(options.grid.color).scale("a", .22).toString()), null == options.xaxis.tickColor && (options.xaxis.tickColor = options.grid.tickColor || options.xaxis.color), null == options.yaxis.tickColor && (options.yaxis.tickColor = options.grid.tickColor || options.yaxis.color), null == options.grid.borderColor && (options.grid.borderColor = options.grid.color), null == options.grid.tickColor && (options.grid.tickColor = $.color.parse(options.grid.color).scale("a", .22).toString());
                var i, axisOptions, axisCount, fontSize = placeholder.css("font-size"), fontSizeDefault = fontSize ? +fontSize.replace("px", "") : 13, fontDefaults = {style: placeholder.css("font-style"),size: Math.round(.8 * fontSizeDefault),variant: placeholder.css("font-variant"),weight: placeholder.css("font-weight"),family: placeholder.css("font-family")};
                for (axisCount = options.xaxes.length || 1, i = 0; axisCount > i; ++i)
                    axisOptions = options.xaxes[i], axisOptions && !axisOptions.tickColor && (axisOptions.tickColor = axisOptions.color), axisOptions = $.extend(!0, {}, options.xaxis, axisOptions), options.xaxes[i] = axisOptions, axisOptions.font && (axisOptions.font = $.extend({}, fontDefaults, axisOptions.font), axisOptions.font.color || (axisOptions.font.color = axisOptions.color), axisOptions.font.lineHeight || (axisOptions.font.lineHeight = Math.round(1.15 * axisOptions.font.size)));
                for (axisCount = options.yaxes.length || 1, i = 0; axisCount > i; ++i)
                    axisOptions = options.yaxes[i], axisOptions && !axisOptions.tickColor && (axisOptions.tickColor = axisOptions.color), axisOptions = $.extend(!0, {}, options.yaxis, axisOptions), options.yaxes[i] = axisOptions, axisOptions.font && (axisOptions.font = $.extend({}, fontDefaults, axisOptions.font), axisOptions.font.color || (axisOptions.font.color = axisOptions.color), axisOptions.font.lineHeight || (axisOptions.font.lineHeight = Math.round(1.15 * axisOptions.font.size)));
                for (options.xaxis.noTicks && null == options.xaxis.ticks && (options.xaxis.ticks = options.xaxis.noTicks), options.yaxis.noTicks && null == options.yaxis.ticks && (options.yaxis.ticks = options.yaxis.noTicks), options.x2axis && (options.xaxes[1] = $.extend(!0, {}, options.xaxis, options.x2axis), options.xaxes[1].position = "top", null == options.x2axis.min && (options.xaxes[1].min = null), null == options.x2axis.max && (options.xaxes[1].max = null)), options.y2axis && (options.yaxes[1] = $.extend(!0, {}, options.yaxis, options.y2axis), options.yaxes[1].position = "right", null == options.y2axis.min && (options.yaxes[1].min = null), null == options.y2axis.max && (options.yaxes[1].max = null)), options.grid.coloredAreas && (options.grid.markings = options.grid.coloredAreas), options.grid.coloredAreasColor && (options.grid.markingsColor = options.grid.coloredAreasColor), options.lines && $.extend(!0, options.series.lines, options.lines), options.points && $.extend(!0, options.series.points, options.points), options.bars && $.extend(!0, options.series.bars, options.bars), 
                null != options.shadowSize && (options.series.shadowSize = options.shadowSize), null != options.highlightColor && (options.series.highlightColor = options.highlightColor), i = 0; i < options.xaxes.length; ++i)
                    getOrCreateAxis(xaxes, i + 1).options = options.xaxes[i];
                for (i = 0; i < options.yaxes.length; ++i)
                    getOrCreateAxis(yaxes, i + 1).options = options.yaxes[i];
                for (var n in hooks)
                    options.hooks[n] && options.hooks[n].length && (hooks[n] = hooks[n].concat(options.hooks[n]));
                executeHooks(hooks.processOptions, [options])
            }
            function setData(d) {
                series = parseData(d), fillInSeriesOptions(), processData()
            }
            function parseData(d) {
                for (var res = [], i = 0; i < d.length; ++i) {
                    var s = $.extend(!0, {}, options.series);
                    null != d[i].data ? (s.data = d[i].data, delete d[i].data, $.extend(!0, s, d[i]), d[i].data = s.data) : s.data = d[i], res.push(s)
                }
                return res
            }
            function axisNumber(obj, coord) {
                var a = obj[coord + "axis"];
                return "object" == typeof a && (a = a.n), "number" != typeof a && (a = 1), a
            }
            function allAxes() {
                return $.grep(xaxes.concat(yaxes), function(a) {
                    return a
                })
            }
            function canvasToAxisCoords(pos) {
                var i, axis, res = {};
                for (i = 0; i < xaxes.length; ++i)
                    axis = xaxes[i], axis && axis.used && (res["x" + axis.n] = axis.c2p(pos.left));
                for (i = 0; i < yaxes.length; ++i)
                    axis = yaxes[i], axis && axis.used && (res["y" + axis.n] = axis.c2p(pos.top));
                return void 0 !== res.x1 && (res.x = res.x1), void 0 !== res.y1 && (res.y = res.y1), res
            }
            function axisToCanvasCoords(pos) {
                var i, axis, key, res = {};
                for (i = 0; i < xaxes.length; ++i)
                    if (axis = xaxes[i], axis && axis.used && (key = "x" + axis.n, null == pos[key] && 1 == axis.n && (key = "x"), null != pos[key])) {
                        res.left = axis.p2c(pos[key]);
                        break
                    }
                for (i = 0; i < yaxes.length; ++i)
                    if (axis = yaxes[i], axis && axis.used && (key = "y" + axis.n, null == pos[key] && 1 == axis.n && (key = "y"), null != pos[key])) {
                        res.top = axis.p2c(pos[key]);
                        break
                    }
                return res
            }
            function getOrCreateAxis(axes, number) {
                return axes[number - 1] || (axes[number - 1] = {n: number,direction: axes == xaxes ? "x" : "y",options: $.extend(!0, {}, axes == xaxes ? options.xaxis : options.yaxis)}), axes[number - 1]
            }
            function fillInSeriesOptions() {
                var i, neededColors = series.length, maxIndex = -1;
                for (i = 0; i < series.length; ++i) {
                    var sc = series[i].color;
                    null != sc && (neededColors--, "number" == typeof sc && sc > maxIndex && (maxIndex = sc))
                }
                maxIndex >= neededColors && (neededColors = maxIndex + 1);
                var c, colors = [], colorPool = options.colors, colorPoolSize = colorPool.length, variation = 0;
                for (i = 0; neededColors > i; i++)
                    c = $.color.parse(colorPool[i % colorPoolSize] || "#666"), i % colorPoolSize == 0 && i && (variation = variation >= 0 ? .5 > variation ? -variation - .2 : 0 : -variation), colors[i] = c.scale("rgb", 1 + variation);
                var s, colori = 0;
                for (i = 0; i < series.length; ++i) {
                    if (s = series[i], null == s.color ? (s.color = colors[colori].toString(), ++colori) : "number" == typeof s.color && (s.color = colors[s.color].toString()), null == s.lines.show) {
                        var v, show = !0;
                        for (v in s)
                            if (s[v] && s[v].show) {
                                show = !1;
                                break
                            }
                        show && (s.lines.show = !0)
                    }
                    null == s.lines.zero && (s.lines.zero = !!s.lines.fill), s.xaxis = getOrCreateAxis(xaxes, axisNumber(s, "x")), s.yaxis = getOrCreateAxis(yaxes, axisNumber(s, "y"))
                }
            }
            function processData() {
                function updateAxis(axis, min, max) {
                    min < axis.datamin && min != -fakeInfinity && (axis.datamin = min), max > axis.datamax && max != fakeInfinity && (axis.datamax = max)
                }
                var i, j, k, m, s, points, ps, val, f, p, data, format, topSentry = Number.POSITIVE_INFINITY, bottomSentry = Number.NEGATIVE_INFINITY, fakeInfinity = Number.MAX_VALUE;
                for ($.each(allAxes(), function(_, axis) {
                    axis.datamin = topSentry, axis.datamax = bottomSentry, axis.used = !1
                }), i = 0; i < series.length; ++i)
                    s = series[i], s.datapoints = {points: []}, executeHooks(hooks.processRawData, [s, s.data, s.datapoints]);
                for (i = 0; i < series.length; ++i) {
                    if (s = series[i], data = s.data, format = s.datapoints.format, !format) {
                        if (format = [], format.push({x: !0,number: !0,required: !0}), format.push({y: !0,number: !0,required: !0}), s.bars.show || s.lines.show && s.lines.fill) {
                            var autoscale = !!(s.bars.show && s.bars.zero || s.lines.show && s.lines.zero);
                            format.push({y: !0,number: !0,required: !1,defaultValue: 0,autoscale: autoscale}), s.bars.horizontal && (delete format[format.length - 1].y, format[format.length - 1].x = !0)
                        }
                        s.datapoints.format = format
                    }
                    if (null == s.datapoints.pointsize) {
                        s.datapoints.pointsize = format.length, ps = s.datapoints.pointsize, points = s.datapoints.points;
                        var insertSteps = s.lines.show && s.lines.steps;
                        for (s.xaxis.used = s.yaxis.used = !0, j = k = 0; j < data.length; ++j, k += ps) {
                            p = data[j];
                            var nullify = null == p;
                            if (!nullify)
                                for (m = 0; ps > m; ++m)
                                    val = p[m], f = format[m], f && (f.number && null != val && (val = +val, isNaN(val) ? val = null : val == 1 / 0 ? val = fakeInfinity : val == -(1 / 0) && (val = -fakeInfinity)), null == val && (f.required && (nullify = !0), null != f.defaultValue && (val = f.defaultValue))), points[k + m] = val;
                            if (nullify)
                                for (m = 0; ps > m; ++m)
                                    val = points[k + m], null != val && (f = format[m], f.autoscale !== !1 && (f.x && updateAxis(s.xaxis, val, val), f.y && updateAxis(s.yaxis, val, val))), points[k + m] = null;
                            else if (insertSteps && k > 0 && null != points[k - ps] && points[k - ps] != points[k] && points[k - ps + 1] != points[k + 1]) {
                                for (m = 0; ps > m; ++m)
                                    points[k + ps + m] = points[k + m];
                                points[k + 1] = points[k - ps + 1], k += ps
                            }
                        }
                    }
                }
                for (i = 0; i < series.length; ++i)
                    s = series[i], executeHooks(hooks.processDatapoints, [s, s.datapoints]);
                for (i = 0; i < series.length; ++i) {
                    s = series[i], points = s.datapoints.points, ps = s.datapoints.pointsize, format = s.datapoints.format;
                    var xmin = topSentry, ymin = topSentry, xmax = bottomSentry, ymax = bottomSentry;
                    for (j = 0; j < points.length; j += ps)
                        if (null != points[j])
                            for (m = 0; ps > m; ++m)
                                val = points[j + m], f = format[m], f && f.autoscale !== !1 && val != fakeInfinity && val != -fakeInfinity && (f.x && (xmin > val && (xmin = val), val > xmax && (xmax = val)), f.y && (ymin > val && (ymin = val), val > ymax && (ymax = val)));
                    if (s.bars.show) {
                        var delta;
                        switch (s.bars.align) {
                            case "left":
                                delta = 0;
                                break;
                            case "right":
                                delta = -s.bars.barWidth;
                                break;
                            default:
                                delta = -s.bars.barWidth / 2
                        }
                        s.bars.horizontal ? (ymin += delta, ymax += delta + s.bars.barWidth) : (xmin += delta, xmax += delta + s.bars.barWidth)
                    }
                    updateAxis(s.xaxis, xmin, xmax), updateAxis(s.yaxis, ymin, ymax)
                }
                $.each(allAxes(), function(_, axis) {
                    axis.datamin == topSentry && (axis.datamin = null), axis.datamax == bottomSentry && (axis.datamax = null)
                })
            }
            function setupCanvases() {
                placeholder.css("padding", 0).children().filter(function() {
                    return !$(this).hasClass("flot-overlay") && !$(this).hasClass("flot-base")
                }).remove(), "static" == placeholder.css("position") && placeholder.css("position", "relative"), surface = new Canvas("flot-base", placeholder), overlay = new Canvas("flot-overlay", placeholder), ctx = surface.context, octx = overlay.context, eventHolder = $(overlay.element).unbind();
                var existing = placeholder.data("plot");
                existing && (existing.shutdown(), overlay.clear()), placeholder.data("plot", plot)
            }
            function bindEvents() {
                options.grid.hoverable && (eventHolder.mousemove(onMouseMove), eventHolder.bind("mouseleave", onMouseLeave)), options.grid.clickable && eventHolder.click(onClick), executeHooks(hooks.bindEvents, [eventHolder])
            }
            function shutdown() {
                redrawTimeout && clearTimeout(redrawTimeout), eventHolder.unbind("mousemove", onMouseMove), eventHolder.unbind("mouseleave", onMouseLeave), eventHolder.unbind("click", onClick), executeHooks(hooks.shutdown, [eventHolder])
            }
            function setTransformationHelpers(axis) {
                function identity(x) {
                    return x
                }
                var s, m, t = axis.options.transform || identity, it = axis.options.inverseTransform;
                "x" == axis.direction ? (s = axis.scale = plotWidth / Math.abs(t(axis.max) - t(axis.min)), m = Math.min(t(axis.max), t(axis.min))) : (s = axis.scale = plotHeight / Math.abs(t(axis.max) - t(axis.min)), s = -s, m = Math.max(t(axis.max), t(axis.min))), t == identity ? axis.p2c = function(p) {
                    return (p - m) * s
                } : axis.p2c = function(p) {
                    return (t(p) - m) * s
                }, it ? axis.c2p = function(c) {
                    return it(m + c / s)
                } : axis.c2p = function(c) {
                    return m + c / s
                }
            }
            function measureTickLabels(axis) {
                for (var opts = axis.options, ticks = axis.ticks || [], labelWidth = opts.labelWidth || 0, labelHeight = opts.labelHeight || 0, maxWidth = labelWidth || ("x" == axis.direction ? Math.floor(surface.width / (ticks.length || 1)) : null), legacyStyles = axis.direction + "Axis " + axis.direction + axis.n + "Axis", layer = "flot-" + axis.direction + "-axis flot-" + axis.direction + axis.n + "-axis " + legacyStyles, font = opts.font || "flot-tick-label tickLabel", i = 0; i < ticks.length; ++i) {
                    var t = ticks[i];
                    if (t.label) {
                        var info = surface.getTextInfo(layer, t.label, font, null, maxWidth);
                        labelWidth = Math.max(labelWidth, info.width), labelHeight = Math.max(labelHeight, info.height)
                    }
                }
                axis.labelWidth = opts.labelWidth || labelWidth, axis.labelHeight = opts.labelHeight || labelHeight
            }
            function allocateAxisBoxFirstPhase(axis) {
                var lw = axis.labelWidth, lh = axis.labelHeight, pos = axis.options.position, isXAxis = "x" === axis.direction, tickLength = axis.options.tickLength, axisMargin = options.grid.axisMargin, padding = options.grid.labelMargin, innermost = !0, outermost = !0, first = !0, found = !1;
                $.each(isXAxis ? xaxes : yaxes, function(i, a) {
                    a && (a.show || a.reserveSpace) && (a === axis ? found = !0 : a.options.position === pos && (found ? outermost = !1 : innermost = !1), found || (first = !1))
                }), outermost && (axisMargin = 0), null == tickLength && (tickLength = first ? "full" : 5), isNaN(+tickLength) || (padding += +tickLength), isXAxis ? (lh += padding, "bottom" == pos ? (plotOffset.bottom += lh + axisMargin, axis.box = {top: surface.height - plotOffset.bottom,height: lh}) : (axis.box = {top: plotOffset.top + axisMargin,height: lh}, plotOffset.top += lh + axisMargin)) : (lw += padding, "left" == pos ? (axis.box = {left: plotOffset.left + axisMargin,width: lw}, plotOffset.left += lw + axisMargin) : (plotOffset.right += lw + axisMargin, axis.box = {left: surface.width - plotOffset.right,width: lw})), axis.position = pos, axis.tickLength = tickLength, axis.box.padding = padding, axis.innermost = innermost
            }
            function allocateAxisBoxSecondPhase(axis) {
                "x" == axis.direction ? (axis.box.left = plotOffset.left - axis.labelWidth / 2, axis.box.width = surface.width - plotOffset.left - plotOffset.right + axis.labelWidth) : (axis.box.top = plotOffset.top - axis.labelHeight / 2, axis.box.height = surface.height - plotOffset.bottom - plotOffset.top + axis.labelHeight)
            }
            function adjustLayoutForThingsStickingOut() {
                var i, minMargin = options.grid.minBorderMargin;
                if (null == minMargin)
                    for (minMargin = 0, i = 0; i < series.length; ++i)
                        minMargin = Math.max(minMargin, 2 * (series[i].points.radius + series[i].points.lineWidth / 2));
                var margins = {left: minMargin,right: minMargin,top: minMargin,bottom: minMargin};
                $.each(allAxes(), function(_, axis) {
                    axis.reserveSpace && axis.ticks && axis.ticks.length && ("x" === axis.direction ? (margins.left = Math.max(margins.left, axis.labelWidth / 2), margins.right = Math.max(margins.right, axis.labelWidth / 2)) : (margins.bottom = Math.max(margins.bottom, axis.labelHeight / 2), margins.top = Math.max(margins.top, axis.labelHeight / 2)))
                }), plotOffset.left = Math.ceil(Math.max(margins.left, plotOffset.left)), plotOffset.right = Math.ceil(Math.max(margins.right, plotOffset.right)), plotOffset.top = Math.ceil(Math.max(margins.top, plotOffset.top)), plotOffset.bottom = Math.ceil(Math.max(margins.bottom, plotOffset.bottom))
            }
            function setupGrid() {
                var i, axes = allAxes(), showGrid = options.grid.show;
                for (var a in plotOffset) {
                    var margin = options.grid.margin || 0;
                    plotOffset[a] = "number" == typeof margin ? margin : margin[a] || 0
                }
                executeHooks(hooks.processOffset, [plotOffset]);
                for (var a in plotOffset)
                    "object" == typeof options.grid.borderWidth ? plotOffset[a] += showGrid ? options.grid.borderWidth[a] : 0 : plotOffset[a] += showGrid ? options.grid.borderWidth : 0;
                if ($.each(axes, function(_, axis) {
                    var axisOpts = axis.options;
                    axis.show = null == axisOpts.show ? axis.used : axisOpts.show, axis.reserveSpace = null == axisOpts.reserveSpace ? axis.show : axisOpts.reserveSpace, setRange(axis)
                }), showGrid) {
                    var allocatedAxes = $.grep(axes, function(axis) {
                        return axis.show || axis.reserveSpace
                    });
                    for ($.each(allocatedAxes, function(_, axis) {
                        setupTickGeneration(axis), setTicks(axis), snapRangeToTicks(axis, axis.ticks), measureTickLabels(axis)
                    }), i = allocatedAxes.length - 1; i >= 0; --i)
                        allocateAxisBoxFirstPhase(allocatedAxes[i]);
                    adjustLayoutForThingsStickingOut(), $.each(allocatedAxes, function(_, axis) {
                        allocateAxisBoxSecondPhase(axis)
                    })
                }
                plotWidth = surface.width - plotOffset.left - plotOffset.right, plotHeight = surface.height - plotOffset.bottom - plotOffset.top, $.each(axes, function(_, axis) {
                    setTransformationHelpers(axis)
                }), showGrid && drawAxisLabels(), insertLegend()
            }
            function setRange(axis) {
                var opts = axis.options, min = +(null != opts.min ? opts.min : axis.datamin), max = +(null != opts.max ? opts.max : axis.datamax), delta = max - min;
                if (0 == delta) {
                    var widen = 0 == max ? 1 : .01;
                    null == opts.min && (min -= widen), (null == opts.max || null != opts.min) && (max += widen)
                } else {
                    var margin = opts.autoscaleMargin;
                    null != margin && (null == opts.min && (min -= delta * margin, 0 > min && null != axis.datamin && axis.datamin >= 0 && (min = 0)), null == opts.max && (max += delta * margin, max > 0 && null != axis.datamax && axis.datamax <= 0 && (max = 0)))
                }
                axis.min = min, axis.max = max
            }
            function setupTickGeneration(axis) {
                var noTicks, opts = axis.options;
                noTicks = "number" == typeof opts.ticks && opts.ticks > 0 ? opts.ticks : .3 * Math.sqrt("x" == axis.direction ? surface.width : surface.height);
                var delta = (axis.max - axis.min) / noTicks, dec = -Math.floor(Math.log(delta) / Math.LN10), maxDec = opts.tickDecimals;
                null != maxDec && dec > maxDec && (dec = maxDec);
                var size, magn = Math.pow(10, -dec), norm = delta / magn;
                if (1.5 > norm ? size = 1 : 3 > norm ? (size = 2, norm > 2.25 && (null == maxDec || maxDec >= dec + 1) && (size = 2.5, ++dec)) : size = 7.5 > norm ? 5 : 10, size *= magn, null != opts.minTickSize && size < opts.minTickSize && (size = opts.minTickSize), axis.delta = delta, axis.tickDecimals = Math.max(0, null != maxDec ? maxDec : dec), axis.tickSize = opts.tickSize || size, "time" == opts.mode && !axis.tickGenerator)
                    throw new Error("Time mode requires the flot.time plugin.");
                if (axis.tickGenerator || (axis.tickGenerator = function(axis) {
                    var prev, ticks = [], start = floorInBase(axis.min, axis.tickSize), i = 0, v = Number.NaN;
                    do
                        prev = v, v = start + i * axis.tickSize, ticks.push(v), ++i;
                    while (v < axis.max && v != prev);
                    return ticks
                }, axis.tickFormatter = function(value, axis) {
                    var factor = axis.tickDecimals ? Math.pow(10, axis.tickDecimals) : 1, formatted = "" + Math.round(value * factor) / factor;
                    if (null != axis.tickDecimals) {
                        var decimal = formatted.indexOf("."), precision = -1 == decimal ? 0 : formatted.length - decimal - 1;
                        if (precision < axis.tickDecimals)
                            return (precision ? formatted : formatted + ".") + ("" + factor).substr(1, axis.tickDecimals - precision)
                    }
                    return formatted
                }), $.isFunction(opts.tickFormatter) && (axis.tickFormatter = function(v, axis) {
                    return "" + opts.tickFormatter(v, axis)
                }), null != opts.alignTicksWithAxis) {
                    var otherAxis = ("x" == axis.direction ? xaxes : yaxes)[opts.alignTicksWithAxis - 1];
                    if (otherAxis && otherAxis.used && otherAxis != axis) {
                        var niceTicks = axis.tickGenerator(axis);
                        if (niceTicks.length > 0 && (null == opts.min && (axis.min = Math.min(axis.min, niceTicks[0])), null == opts.max && niceTicks.length > 1 && (axis.max = Math.max(axis.max, niceTicks[niceTicks.length - 1]))), axis.tickGenerator = function(axis) {
                            var v, i, ticks = [];
                            for (i = 0; i < otherAxis.ticks.length; ++i)
                                v = (otherAxis.ticks[i].v - otherAxis.min) / (otherAxis.max - otherAxis.min), v = axis.min + v * (axis.max - axis.min), ticks.push(v);
                            return ticks
                        }, !axis.mode && null == opts.tickDecimals) {
                            var extraDec = Math.max(0, -Math.floor(Math.log(axis.delta) / Math.LN10) + 1), ts = axis.tickGenerator(axis);
                            ts.length > 1 && /\..*0$/.test((ts[1] - ts[0]).toFixed(extraDec)) || (axis.tickDecimals = extraDec)
                        }
                    }
                }
            }
            function setTicks(axis) {
                var oticks = axis.options.ticks, ticks = [];
                null == oticks || "number" == typeof oticks && oticks > 0 ? ticks = axis.tickGenerator(axis) : oticks && (ticks = $.isFunction(oticks) ? oticks(axis) : oticks);
                var i, v;
                for (axis.ticks = [], i = 0; i < ticks.length; ++i) {
                    var label = null, t = ticks[i];
                    "object" == typeof t ? (v = +t[0], t.length > 1 && (label = t[1])) : v = +t, null == label && (label = axis.tickFormatter(v, axis)), isNaN(v) || axis.ticks.push({v: v,label: label})
                }
            }
            function snapRangeToTicks(axis, ticks) {
                axis.options.autoscaleMargin && ticks.length > 0 && (null == axis.options.min && (axis.min = Math.min(axis.min, ticks[0].v)), null == axis.options.max && ticks.length > 1 && (axis.max = Math.max(axis.max, ticks[ticks.length - 1].v)))
            }
            function draw() {
                surface.clear(), executeHooks(hooks.drawBackground, [ctx]);
                var grid = options.grid;
                grid.show && grid.backgroundColor && drawBackground(), grid.show && !grid.aboveData && drawGrid();
                for (var i = 0; i < series.length; ++i)
                    executeHooks(hooks.drawSeries, [ctx, series[i]]), drawSeries(series[i]);
                executeHooks(hooks.draw, [ctx]), grid.show && grid.aboveData && drawGrid(), surface.render(), triggerRedrawOverlay()
            }
            function extractRange(ranges, coord) {
                for (var axis, from, to, key, axes = allAxes(), i = 0; i < axes.length; ++i)
                    if (axis = axes[i], axis.direction == coord && (key = coord + axis.n + "axis", ranges[key] || 1 != axis.n || (key = coord + "axis"), ranges[key])) {
                        from = ranges[key].from, to = ranges[key].to;
                        break
                    }
                if (ranges[key] || (axis = "x" == coord ? xaxes[0] : yaxes[0], from = ranges[coord + "1"], to = ranges[coord + "2"]), null != from && null != to && from > to) {
                    var tmp = from;
                    from = to, to = tmp
                }
                return {from: from,to: to,axis: axis}
            }
            function drawBackground() {
                ctx.save(), ctx.translate(plotOffset.left, plotOffset.top), ctx.fillStyle = getColorOrGradient(options.grid.backgroundColor, plotHeight, 0, "rgba(255, 255, 255, 0)"), ctx.fillRect(0, 0, plotWidth, plotHeight), ctx.restore()
            }
            function drawGrid() {
                var i, axes, bw, bc;
                ctx.save(), ctx.translate(plotOffset.left, plotOffset.top);
                var markings = options.grid.markings;
                if (markings)
                    for ($.isFunction(markings) && (axes = plot.getAxes(), axes.xmin = axes.xaxis.min, axes.xmax = axes.xaxis.max, axes.ymin = axes.yaxis.min, axes.ymax = axes.yaxis.max, markings = markings(axes)), i = 0; i < markings.length; ++i) {
                        var m = markings[i], xrange = extractRange(m, "x"), yrange = extractRange(m, "y");
                        if (null == xrange.from && (xrange.from = xrange.axis.min), null == xrange.to && (xrange.to = xrange.axis.max), null == yrange.from && (yrange.from = yrange.axis.min), null == yrange.to && (yrange.to = yrange.axis.max), !(xrange.to < xrange.axis.min || xrange.from > xrange.axis.max || yrange.to < yrange.axis.min || yrange.from > yrange.axis.max)) {
                            xrange.from = Math.max(xrange.from, xrange.axis.min), xrange.to = Math.min(xrange.to, xrange.axis.max), yrange.from = Math.max(yrange.from, yrange.axis.min), yrange.to = Math.min(yrange.to, yrange.axis.max);
                            var xequal = xrange.from === xrange.to, yequal = yrange.from === yrange.to;
                            if (!xequal || !yequal)
                                if (xrange.from = Math.floor(xrange.axis.p2c(xrange.from)), xrange.to = Math.floor(xrange.axis.p2c(xrange.to)), yrange.from = Math.floor(yrange.axis.p2c(yrange.from)), yrange.to = Math.floor(yrange.axis.p2c(yrange.to)), xequal || yequal) {
                                    var lineWidth = m.lineWidth || options.grid.markingsLineWidth, subPixel = lineWidth % 2 ? .5 : 0;
                                    ctx.beginPath(), ctx.strokeStyle = m.color || options.grid.markingsColor, ctx.lineWidth = lineWidth, xequal ? (ctx.moveTo(xrange.to + subPixel, yrange.from), ctx.lineTo(xrange.to + subPixel, yrange.to)) : (ctx.moveTo(xrange.from, yrange.to + subPixel), ctx.lineTo(xrange.to, yrange.to + subPixel)), ctx.stroke()
                                } else
                                    ctx.fillStyle = m.color || options.grid.markingsColor, ctx.fillRect(xrange.from, yrange.to, xrange.to - xrange.from, yrange.from - yrange.to)
                        }
                    }
                axes = allAxes(), bw = options.grid.borderWidth;
                for (var j = 0; j < axes.length; ++j) {
                    var x, y, xoff, yoff, axis = axes[j], box = axis.box, t = axis.tickLength;
                    if (axis.show && 0 != axis.ticks.length) {
                        for (ctx.lineWidth = 1, "x" == axis.direction ? (x = 0, y = "full" == t ? "top" == axis.position ? 0 : plotHeight : box.top - plotOffset.top + ("top" == axis.position ? box.height : 0)) : (y = 0, x = "full" == t ? "left" == axis.position ? 0 : plotWidth : box.left - plotOffset.left + ("left" == axis.position ? box.width : 0)), axis.innermost || (ctx.strokeStyle = axis.options.color, ctx.beginPath(), xoff = yoff = 0, "x" == axis.direction ? xoff = plotWidth + 1 : yoff = plotHeight + 1, 1 == ctx.lineWidth && ("x" == axis.direction ? y = Math.floor(y) + .5 : x = Math.floor(x) + .5), ctx.moveTo(x, y), ctx.lineTo(x + xoff, y + yoff), ctx.stroke()), ctx.strokeStyle = axis.options.tickColor, ctx.beginPath(), i = 0; i < axis.ticks.length; ++i) {
                            var v = axis.ticks[i].v;
                            xoff = yoff = 0, isNaN(v) || v < axis.min || v > axis.max || "full" == t && ("object" == typeof bw && bw[axis.position] > 0 || bw > 0) && (v == axis.min || v == axis.max) || ("x" == axis.direction ? (x = axis.p2c(v), yoff = "full" == t ? -plotHeight : t, "top" == axis.position && (yoff = -yoff)) : (y = axis.p2c(v), xoff = "full" == t ? -plotWidth : t, "left" == axis.position && (xoff = -xoff)), 1 == ctx.lineWidth && ("x" == axis.direction ? x = Math.floor(x) + .5 : y = Math.floor(y) + .5), ctx.moveTo(x, y), ctx.lineTo(x + xoff, y + yoff))
                        }
                        ctx.stroke()
                    }
                }
                bw && (bc = options.grid.borderColor, "object" == typeof bw || "object" == typeof bc ? ("object" != typeof bw && (bw = {top: bw,right: bw,bottom: bw,left: bw}), "object" != typeof bc && (bc = {top: bc,right: bc,bottom: bc,left: bc}), bw.top > 0 && (ctx.strokeStyle = bc.top, ctx.lineWidth = bw.top, ctx.beginPath(), ctx.moveTo(0 - bw.left, 0 - bw.top / 2), ctx.lineTo(plotWidth, 0 - bw.top / 2), ctx.stroke()), bw.right > 0 && (ctx.strokeStyle = bc.right, ctx.lineWidth = bw.right, ctx.beginPath(), ctx.moveTo(plotWidth + bw.right / 2, 0 - bw.top), ctx.lineTo(plotWidth + bw.right / 2, plotHeight), ctx.stroke()), bw.bottom > 0 && (ctx.strokeStyle = bc.bottom, ctx.lineWidth = bw.bottom, ctx.beginPath(), ctx.moveTo(plotWidth + bw.right, plotHeight + bw.bottom / 2), ctx.lineTo(0, plotHeight + bw.bottom / 2), ctx.stroke()), bw.left > 0 && (ctx.strokeStyle = bc.left, ctx.lineWidth = bw.left, ctx.beginPath(), ctx.moveTo(0 - bw.left / 2, plotHeight + bw.bottom), ctx.lineTo(0 - bw.left / 2, 0), ctx.stroke())) : (ctx.lineWidth = bw, ctx.strokeStyle = options.grid.borderColor, ctx.strokeRect(-bw / 2, -bw / 2, plotWidth + bw, plotHeight + bw))), ctx.restore()
            }
            function drawAxisLabels() {
                $.each(allAxes(), function(_, axis) {
                    var tick, x, y, halign, valign, box = axis.box, legacyStyles = axis.direction + "Axis " + axis.direction + axis.n + "Axis", layer = "flot-" + axis.direction + "-axis flot-" + axis.direction + axis.n + "-axis " + legacyStyles, font = axis.options.font || "flot-tick-label tickLabel";
                    if (surface.removeText(layer), axis.show && 0 != axis.ticks.length)
                        for (var i = 0; i < axis.ticks.length; ++i)
                            tick = axis.ticks[i], !tick.label || tick.v < axis.min || tick.v > axis.max || ("x" == axis.direction ? (halign = "center", x = plotOffset.left + axis.p2c(tick.v), "bottom" == axis.position ? y = box.top + box.padding : (y = box.top + box.height - box.padding, valign = "bottom")) : (valign = "middle", y = plotOffset.top + axis.p2c(tick.v), "left" == axis.position ? (x = box.left + box.width - box.padding, halign = "right") : x = box.left + box.padding), surface.addText(layer, x, y, tick.label, font, null, null, halign, valign))
                })
            }
            function drawSeries(series) {
                series.lines.show && drawSeriesLines(series), series.bars.show && drawSeriesBars(series), series.points.show && drawSeriesPoints(series)
            }
            function drawSeriesLines(series) {
                function plotLine(datapoints, xoffset, yoffset, axisx, axisy) {
                    var points = datapoints.points, ps = datapoints.pointsize, prevx = null, prevy = null;
                    ctx.beginPath();
                    for (var i = ps; i < points.length; i += ps) {
                        var x1 = points[i - ps], y1 = points[i - ps + 1], x2 = points[i], y2 = points[i + 1];
                        if (null != x1 && null != x2) {
                            if (y2 >= y1 && y1 < axisy.min) {
                                if (y2 < axisy.min)
                                    continue;
                                x1 = (axisy.min - y1) / (y2 - y1) * (x2 - x1) + x1, y1 = axisy.min
                            } else if (y1 >= y2 && y2 < axisy.min) {
                                if (y1 < axisy.min)
                                    continue;
                                x2 = (axisy.min - y1) / (y2 - y1) * (x2 - x1) + x1, y2 = axisy.min
                            }
                            if (y1 >= y2 && y1 > axisy.max) {
                                if (y2 > axisy.max)
                                    continue;
                                x1 = (axisy.max - y1) / (y2 - y1) * (x2 - x1) + x1, y1 = axisy.max
                            } else if (y2 >= y1 && y2 > axisy.max) {
                                if (y1 > axisy.max)
                                    continue;
                                x2 = (axisy.max - y1) / (y2 - y1) * (x2 - x1) + x1, y2 = axisy.max
                            }
                            if (x2 >= x1 && x1 < axisx.min) {
                                if (x2 < axisx.min)
                                    continue;
                                y1 = (axisx.min - x1) / (x2 - x1) * (y2 - y1) + y1, x1 = axisx.min
                            } else if (x1 >= x2 && x2 < axisx.min) {
                                if (x1 < axisx.min)
                                    continue;
                                y2 = (axisx.min - x1) / (x2 - x1) * (y2 - y1) + y1, x2 = axisx.min
                            }
                            if (x1 >= x2 && x1 > axisx.max) {
                                if (x2 > axisx.max)
                                    continue;
                                y1 = (axisx.max - x1) / (x2 - x1) * (y2 - y1) + y1, x1 = axisx.max
                            } else if (x2 >= x1 && x2 > axisx.max) {
                                if (x1 > axisx.max)
                                    continue;
                                y2 = (axisx.max - x1) / (x2 - x1) * (y2 - y1) + y1, x2 = axisx.max
                            }
                            (x1 != prevx || y1 != prevy) && ctx.moveTo(axisx.p2c(x1) + xoffset, axisy.p2c(y1) + yoffset), prevx = x2, prevy = y2, ctx.lineTo(axisx.p2c(x2) + xoffset, axisy.p2c(y2) + yoffset)
                        }
                    }
                    ctx.stroke()
                }
                function plotLineArea(datapoints, axisx, axisy) {
                    for (var points = datapoints.points, ps = datapoints.pointsize, bottom = Math.min(Math.max(0, axisy.min), axisy.max), i = 0, areaOpen = !1, ypos = 1, segmentStart = 0, segmentEnd = 0; ; ) {
                        if (ps > 0 && i > points.length + ps)
                            break;
                        i += ps;
                        var x1 = points[i - ps], y1 = points[i - ps + ypos], x2 = points[i], y2 = points[i + ypos];
                        if (areaOpen) {
                            if (ps > 0 && null != x1 && null == x2) {
                                segmentEnd = i, ps = -ps, ypos = 2;
                                continue
                            }
                            if (0 > ps && i == segmentStart + ps) {
                                ctx.fill(), areaOpen = !1, ps = -ps, ypos = 1, i = segmentStart = segmentEnd + ps;
                                continue
                            }
                        }
                        if (null != x1 && null != x2) {
                            if (x2 >= x1 && x1 < axisx.min) {
                                if (x2 < axisx.min)
                                    continue;
                                y1 = (axisx.min - x1) / (x2 - x1) * (y2 - y1) + y1, x1 = axisx.min
                            } else if (x1 >= x2 && x2 < axisx.min) {
                                if (x1 < axisx.min)
                                    continue;
                                y2 = (axisx.min - x1) / (x2 - x1) * (y2 - y1) + y1, x2 = axisx.min
                            }
                            if (x1 >= x2 && x1 > axisx.max) {
                                if (x2 > axisx.max)
                                    continue;
                                y1 = (axisx.max - x1) / (x2 - x1) * (y2 - y1) + y1, x1 = axisx.max
                            } else if (x2 >= x1 && x2 > axisx.max) {
                                if (x1 > axisx.max)
                                    continue;
                                y2 = (axisx.max - x1) / (x2 - x1) * (y2 - y1) + y1, x2 = axisx.max
                            }
                            if (areaOpen || (ctx.beginPath(), ctx.moveTo(axisx.p2c(x1), axisy.p2c(bottom)), areaOpen = !0), y1 >= axisy.max && y2 >= axisy.max)
                                ctx.lineTo(axisx.p2c(x1), axisy.p2c(axisy.max)), ctx.lineTo(axisx.p2c(x2), axisy.p2c(axisy.max));
                            else if (y1 <= axisy.min && y2 <= axisy.min)
                                ctx.lineTo(axisx.p2c(x1), axisy.p2c(axisy.min)), ctx.lineTo(axisx.p2c(x2), axisy.p2c(axisy.min));
                            else {
                                var x1old = x1, x2old = x2;
                                y2 >= y1 && y1 < axisy.min && y2 >= axisy.min ? (x1 = (axisy.min - y1) / (y2 - y1) * (x2 - x1) + x1, y1 = axisy.min) : y1 >= y2 && y2 < axisy.min && y1 >= axisy.min && (x2 = (axisy.min - y1) / (y2 - y1) * (x2 - x1) + x1, y2 = axisy.min), y1 >= y2 && y1 > axisy.max && y2 <= axisy.max ? (x1 = (axisy.max - y1) / (y2 - y1) * (x2 - x1) + x1, y1 = axisy.max) : y2 >= y1 && y2 > axisy.max && y1 <= axisy.max && (x2 = (axisy.max - y1) / (y2 - y1) * (x2 - x1) + x1, y2 = axisy.max), x1 != x1old && ctx.lineTo(axisx.p2c(x1old), axisy.p2c(y1)), ctx.lineTo(axisx.p2c(x1), axisy.p2c(y1)), ctx.lineTo(axisx.p2c(x2), axisy.p2c(y2)), x2 != x2old && (ctx.lineTo(axisx.p2c(x2), axisy.p2c(y2)), ctx.lineTo(axisx.p2c(x2old), axisy.p2c(y2)))
                            }
                        }
                    }
                }
                ctx.save(), ctx.translate(plotOffset.left, plotOffset.top), ctx.lineJoin = "round";
                var lw = series.lines.lineWidth, sw = series.shadowSize;
                if (lw > 0 && sw > 0) {
                    ctx.lineWidth = sw, ctx.strokeStyle = "rgba(0,0,0,0.1)";
                    var angle = Math.PI / 18;
                    plotLine(series.datapoints, Math.sin(angle) * (lw / 2 + sw / 2), Math.cos(angle) * (lw / 2 + sw / 2), series.xaxis, series.yaxis), ctx.lineWidth = sw / 2, plotLine(series.datapoints, Math.sin(angle) * (lw / 2 + sw / 4), Math.cos(angle) * (lw / 2 + sw / 4), series.xaxis, series.yaxis)
                }
                ctx.lineWidth = lw, ctx.strokeStyle = series.color;
                var fillStyle = getFillStyle(series.lines, series.color, 0, plotHeight);
                fillStyle && (ctx.fillStyle = fillStyle, plotLineArea(series.datapoints, series.xaxis, series.yaxis)), lw > 0 && plotLine(series.datapoints, 0, 0, series.xaxis, series.yaxis), ctx.restore()
            }
            function drawSeriesPoints(series) {
                function plotPoints(datapoints, radius, fillStyle, offset, shadow, axisx, axisy, symbol) {
                    for (var points = datapoints.points, ps = datapoints.pointsize, i = 0; i < points.length; i += ps) {
                        var x = points[i], y = points[i + 1];
                        null == x || x < axisx.min || x > axisx.max || y < axisy.min || y > axisy.max || (ctx.beginPath(), x = axisx.p2c(x), y = axisy.p2c(y) + offset, "circle" == symbol ? ctx.arc(x, y, radius, 0, shadow ? Math.PI : 2 * Math.PI, !1) : symbol(ctx, x, y, radius, shadow), ctx.closePath(), fillStyle && (ctx.fillStyle = fillStyle, ctx.fill()), ctx.stroke())
                    }
                }
                ctx.save(), ctx.translate(plotOffset.left, plotOffset.top);
                var lw = series.points.lineWidth, sw = series.shadowSize, radius = series.points.radius, symbol = series.points.symbol;
                if (0 == lw && (lw = 1e-4), lw > 0 && sw > 0) {
                    var w = sw / 2;
                    ctx.lineWidth = w, ctx.strokeStyle = "rgba(0,0,0,0.1)", plotPoints(series.datapoints, radius, null, w + w / 2, !0, series.xaxis, series.yaxis, symbol), ctx.strokeStyle = "rgba(0,0,0,0.2)", plotPoints(series.datapoints, radius, null, w / 2, !0, series.xaxis, series.yaxis, symbol)
                }
                ctx.lineWidth = lw, ctx.strokeStyle = series.color, plotPoints(series.datapoints, radius, getFillStyle(series.points, series.color), 0, !1, series.xaxis, series.yaxis, symbol), ctx.restore()
            }
            function drawBar(x, y, b, barLeft, barRight, fillStyleCallback, axisx, axisy, c, horizontal, lineWidth) {
                var left, right, bottom, top, drawLeft, drawRight, drawTop, drawBottom, tmp;
                horizontal ? (drawBottom = drawRight = drawTop = !0, drawLeft = !1, left = b, right = x, top = y + barLeft, bottom = y + barRight, left > right && (tmp = right, right = left, left = tmp, drawLeft = !0, drawRight = !1)) : (drawLeft = drawRight = drawTop = !0, drawBottom = !1, left = x + barLeft, right = x + barRight, bottom = b, top = y, bottom > top && (tmp = top, top = bottom, bottom = tmp, drawBottom = !0, drawTop = !1)), right < axisx.min || left > axisx.max || top < axisy.min || bottom > axisy.max || (left < axisx.min && (left = axisx.min, drawLeft = !1), right > axisx.max && (right = axisx.max, drawRight = !1), bottom < axisy.min && (bottom = axisy.min, drawBottom = !1), top > axisy.max && (top = axisy.max, drawTop = !1), left = axisx.p2c(left), bottom = axisy.p2c(bottom), right = axisx.p2c(right), top = axisy.p2c(top), fillStyleCallback && (c.fillStyle = fillStyleCallback(bottom, top), c.fillRect(left, top, right - left, bottom - top)), lineWidth > 0 && (drawLeft || drawRight || drawTop || drawBottom) && (c.beginPath(), c.moveTo(left, bottom), drawLeft ? c.lineTo(left, top) : c.moveTo(left, top), drawTop ? c.lineTo(right, top) : c.moveTo(right, top), drawRight ? c.lineTo(right, bottom) : c.moveTo(right, bottom), drawBottom ? c.lineTo(left, bottom) : c.moveTo(left, bottom), c.stroke()))
            }
            function drawSeriesBars(series) {
                function plotBars(datapoints, barLeft, barRight, fillStyleCallback, axisx, axisy) {
                    for (var points = datapoints.points, ps = datapoints.pointsize, i = 0; i < points.length; i += ps)
                        null != points[i] && drawBar(points[i], points[i + 1], points[i + 2], barLeft, barRight, fillStyleCallback, axisx, axisy, ctx, series.bars.horizontal, series.bars.lineWidth)
                }
                ctx.save(), ctx.translate(plotOffset.left, plotOffset.top), ctx.lineWidth = series.bars.lineWidth, ctx.strokeStyle = series.color;
                var barLeft;
                switch (series.bars.align) {
                    case "left":
                        barLeft = 0;
                        break;
                    case "right":
                        barLeft = -series.bars.barWidth;
                        break;
                    default:
                        barLeft = -series.bars.barWidth / 2
                }
                var fillStyleCallback = series.bars.fill ? function(bottom, top) {
                    return getFillStyle(series.bars, series.color, bottom, top)
                } : null;
                plotBars(series.datapoints, barLeft, barLeft + series.bars.barWidth, fillStyleCallback, series.xaxis, series.yaxis), ctx.restore()
            }
            function getFillStyle(filloptions, seriesColor, bottom, top) {
                var fill = filloptions.fill;
                if (!fill)
                    return null;
                if (filloptions.fillColor)
                    return getColorOrGradient(filloptions.fillColor, bottom, top, seriesColor);
                var c = $.color.parse(seriesColor);
                return c.a = "number" == typeof fill ? fill : .4, c.normalize(), c.toString()
            }
            function insertLegend() {
                if (null != options.legend.container ? $(options.legend.container).html("") : placeholder.find(".legend").remove(), options.legend.show) {
                    for (var s, label, fragments = [], entries = [], rowStarted = !1, lf = options.legend.labelFormatter, i = 0; i < series.length; ++i)
                        s = series[i], s.label && (label = lf ? lf(s.label, s) : s.label, label && entries.push({label: label,color: s.color}));
                    if (options.legend.sorted)
                        if ($.isFunction(options.legend.sorted))
                            entries.sort(options.legend.sorted);
                        else if ("reverse" == options.legend.sorted)
                            entries.reverse();
                        else {
                            var ascending = "descending" != options.legend.sorted;
                            entries.sort(function(a, b) {
                                return a.label == b.label ? 0 : a.label < b.label != ascending ? 1 : -1
                            })
                        }
                    for (var i = 0; i < entries.length; ++i) {
                        var entry = entries[i];
                        i % options.legend.noColumns == 0 && (rowStarted && fragments.push("</tr>"), fragments.push("<tr>"), rowStarted = !0), fragments.push('<td class="legendColorBox"><div style="border:1px solid ' + options.legend.labelBoxBorderColor + ';padding:1px"><div style="width:4px;height:0;border:5px solid ' + entry.color + ';overflow:hidden"></div></div></td><td class="legendLabel">' + entry.label + "</td>")
                    }
                    if (rowStarted && fragments.push("</tr>"), 0 != fragments.length) {
                        var table = '<table style="font-size:smaller;color:' + options.grid.color + '">' + fragments.join("") + "</table>";
                        if (null != options.legend.container)
                            $(options.legend.container).html(table);
                        else {
                            var pos = "", p = options.legend.position, m = options.legend.margin;
                            null == m[0] && (m = [m, m]), "n" == p.charAt(0) ? pos += "top:" + (m[1] + plotOffset.top) + "px;" : "s" == p.charAt(0) && (pos += "bottom:" + (m[1] + plotOffset.bottom) + "px;"), "e" == p.charAt(1) ? pos += "right:" + (m[0] + plotOffset.right) + "px;" : "w" == p.charAt(1) && (pos += "left:" + (m[0] + plotOffset.left) + "px;");
                            var legend = $('<div class="legend">' + table.replace('style="', 'style="position:absolute;' + pos + ";") + "</div>").appendTo(placeholder);
                            if (0 != options.legend.backgroundOpacity) {
                                var c = options.legend.backgroundColor;
                                null == c && (c = options.grid.backgroundColor, c = c && "string" == typeof c ? $.color.parse(c) : $.color.extract(legend, "background-color"), c.a = 1, c = c.toString());
                                var div = legend.children();
                                $('<div style="position:absolute;width:' + div.width() + "px;height:" + div.height() + "px;" + pos + "background-color:" + c + ';"> </div>').prependTo(legend).css("opacity", options.legend.backgroundOpacity)
                            }
                        }
                    }
                }
            }
            function findNearbyItem(mouseX, mouseY, seriesFilter) {
                var i, j, ps, maxDistance = options.grid.mouseActiveRadius, smallestDistance = maxDistance * maxDistance + 1, item = null;
                for (i = series.length - 1; i >= 0; --i)
                    if (seriesFilter(series[i])) {
                        var s = series[i], axisx = s.xaxis, axisy = s.yaxis, points = s.datapoints.points, mx = axisx.c2p(mouseX), my = axisy.c2p(mouseY), maxx = maxDistance / axisx.scale, maxy = maxDistance / axisy.scale;
                        if (ps = s.datapoints.pointsize, axisx.options.inverseTransform && (maxx = Number.MAX_VALUE), axisy.options.inverseTransform && (maxy = Number.MAX_VALUE), s.lines.show || s.points.show)
                            for (j = 0; j < points.length; j += ps) {
                                var x = points[j], y = points[j + 1];
                                if (null != x && !(x - mx > maxx || -maxx > x - mx || y - my > maxy || -maxy > y - my)) {
                                    var dx = Math.abs(axisx.p2c(x) - mouseX), dy = Math.abs(axisy.p2c(y) - mouseY), dist = dx * dx + dy * dy;
                                    smallestDistance > dist && (smallestDistance = dist, item = [i, j / ps])
                                }
                            }
                        if (s.bars.show && !item) {
                            var barLeft, barRight;
                            switch (s.bars.align) {
                                case "left":
                                    barLeft = 0;
                                    break;
                                case "right":
                                    barLeft = -s.bars.barWidth;
                                    break;
                                default:
                                    barLeft = -s.bars.barWidth / 2
                            }
                            for (barRight = barLeft + s.bars.barWidth, j = 0; j < points.length; j += ps) {
                                var x = points[j], y = points[j + 1], b = points[j + 2];
                                null != x && (series[i].bars.horizontal ? mx <= Math.max(b, x) && mx >= Math.min(b, x) && my >= y + barLeft && y + barRight >= my : mx >= x + barLeft && x + barRight >= mx && my >= Math.min(b, y) && my <= Math.max(b, y)) && (item = [i, j / ps])
                            }
                        }
                    }
                return item ? (i = item[0], j = item[1], ps = series[i].datapoints.pointsize, {datapoint: series[i].datapoints.points.slice(j * ps, (j + 1) * ps),dataIndex: j,series: series[i],seriesIndex: i}) : null
            }
            function onMouseMove(e) {
                options.grid.hoverable && triggerClickHoverEvent("plothover", e, function(s) {
                    return 0 != s.hoverable
                })
            }
            function onMouseLeave(e) {
                options.grid.hoverable && triggerClickHoverEvent("plothover", e, function(s) {
                    return !1
                })
            }
            function onClick(e) {
                triggerClickHoverEvent("plotclick", e, function(s) {
                    return 0 != s.clickable
                })
            }
            function triggerClickHoverEvent(eventname, event, seriesFilter) {
                var offset = eventHolder.offset(), canvasX = event.pageX - offset.left - plotOffset.left, canvasY = event.pageY - offset.top - plotOffset.top, pos = canvasToAxisCoords({left: canvasX,top: canvasY});
                pos.pageX = event.pageX, pos.pageY = event.pageY;
                var item = findNearbyItem(canvasX, canvasY, seriesFilter);
                if (item && (item.pageX = parseInt(item.series.xaxis.p2c(item.datapoint[0]) + offset.left + plotOffset.left, 10), item.pageY = parseInt(item.series.yaxis.p2c(item.datapoint[1]) + offset.top + plotOffset.top, 10)), options.grid.autoHighlight) {
                    for (var i = 0; i < highlights.length; ++i) {
                        var h = highlights[i];
                        h.auto != eventname || item && h.series == item.series && h.point[0] == item.datapoint[0] && h.point[1] == item.datapoint[1] || unhighlight(h.series, h.point)
                    }
                    item && highlight(item.series, item.datapoint, eventname)
                }
                placeholder.trigger(eventname, [pos, item])
            }
            function triggerRedrawOverlay() {
                var t = options.interaction.redrawOverlayInterval;
                return -1 == t ? void drawOverlay() : void (redrawTimeout || (redrawTimeout = setTimeout(drawOverlay, t)))
            }
            function drawOverlay() {
                redrawTimeout = null, octx.save(), overlay.clear(), octx.translate(plotOffset.left, plotOffset.top);
                var i, hi;
                for (i = 0; i < highlights.length; ++i)
                    hi = highlights[i], hi.series.bars.show ? drawBarHighlight(hi.series, hi.point) : drawPointHighlight(hi.series, hi.point);
                octx.restore(), executeHooks(hooks.drawOverlay, [octx])
            }
            function highlight(s, point, auto) {
                if ("number" == typeof s && (s = series[s]), "number" == typeof point) {
                    var ps = s.datapoints.pointsize;
                    point = s.datapoints.points.slice(ps * point, ps * (point + 1))
                }
                var i = indexOfHighlight(s, point);
                -1 == i ? (highlights.push({series: s,point: point,auto: auto}), triggerRedrawOverlay()) : auto || (highlights[i].auto = !1)
            }
            function unhighlight(s, point) {
                if (null == s && null == point)
                    return highlights = [], void triggerRedrawOverlay();
                if ("number" == typeof s && (s = series[s]), "number" == typeof point) {
                    var ps = s.datapoints.pointsize;
                    point = s.datapoints.points.slice(ps * point, ps * (point + 1))
                }
                var i = indexOfHighlight(s, point);
                -1 != i && (highlights.splice(i, 1), triggerRedrawOverlay())
            }
            function indexOfHighlight(s, p) {
                for (var i = 0; i < highlights.length; ++i) {
                    var h = highlights[i];
                    if (h.series == s && h.point[0] == p[0] && h.point[1] == p[1])
                        return i
                }
                return -1
            }
            function drawPointHighlight(series, point) {
                var x = point[0], y = point[1], axisx = series.xaxis, axisy = series.yaxis, highlightColor = "string" == typeof series.highlightColor ? series.highlightColor : $.color.parse(series.color).scale("a", .5).toString();
                if (!(x < axisx.min || x > axisx.max || y < axisy.min || y > axisy.max)) {
                    var pointRadius = series.points.radius + series.points.lineWidth / 2;
                    octx.lineWidth = pointRadius, octx.strokeStyle = highlightColor;
                    var radius = 1.5 * pointRadius;
                    x = axisx.p2c(x), y = axisy.p2c(y), octx.beginPath(), "circle" == series.points.symbol ? octx.arc(x, y, radius, 0, 2 * Math.PI, !1) : series.points.symbol(octx, x, y, radius, !1), octx.closePath(), octx.stroke()
                }
            }
            function drawBarHighlight(series, point) {
                var barLeft, highlightColor = "string" == typeof series.highlightColor ? series.highlightColor : $.color.parse(series.color).scale("a", .5).toString(), fillStyle = highlightColor;
                switch (series.bars.align) {
                    case "left":
                        barLeft = 0;
                        break;
                    case "right":
                        barLeft = -series.bars.barWidth;
                        break;
                    default:
                        barLeft = -series.bars.barWidth / 2
                }
                octx.lineWidth = series.bars.lineWidth, octx.strokeStyle = highlightColor, drawBar(point[0], point[1], point[2] || 0, barLeft, barLeft + series.bars.barWidth, function() {
                    return fillStyle
                }, series.xaxis, series.yaxis, octx, series.bars.horizontal, series.bars.lineWidth)
            }
            function getColorOrGradient(spec, bottom, top, defaultColor) {
                if ("string" == typeof spec)
                    return spec;
                for (var gradient = ctx.createLinearGradient(0, top, 0, bottom), i = 0, l = spec.colors.length; l > i; ++i) {
                    var c = spec.colors[i];
                    if ("string" != typeof c) {
                        var co = $.color.parse(defaultColor);
                        null != c.brightness && (co = co.scale("rgb", c.brightness)), null != c.opacity && (co.a *= c.opacity), c = co.toString()
                    }
                    gradient.addColorStop(i / (l - 1), c)
                }
                return gradient
            }
            var series = [], options = {colors: ["#edc240", "#afd8f8", "#cb4b4b", "#4da74d", "#9440ed"],legend: {show: !0,noColumns: 1,labelFormatter: null,labelBoxBorderColor: "#ccc",container: null,position: "ne",margin: 5,backgroundColor: null,backgroundOpacity: .85,sorted: null},xaxis: {show: null,position: "bottom",mode: null,font: null,color: null,tickColor: null,transform: null,inverseTransform: null,min: null,max: null,autoscaleMargin: null,ticks: null,tickFormatter: null,labelWidth: null,labelHeight: null,reserveSpace: null,tickLength: null,alignTicksWithAxis: null,tickDecimals: null,tickSize: null,minTickSize: null},yaxis: {autoscaleMargin: .02,position: "left"},xaxes: [],yaxes: [],series: {points: {show: !1,radius: 3,lineWidth: 2,fill: !0,fillColor: "#ffffff",symbol: "circle"},lines: {lineWidth: 2,fill: !1,fillColor: null,steps: !1},bars: {show: !1,lineWidth: 2,barWidth: 1,fill: !0,fillColor: null,align: "left",horizontal: !1,zero: !0},shadowSize: 3,highlightColor: null},grid: {show: !0,aboveData: !1,color: "#545454",backgroundColor: null,borderColor: null,tickColor: null,margin: 0,labelMargin: 5,axisMargin: 8,borderWidth: 2,minBorderMargin: null,markings: null,markingsColor: "#f4f4f4",markingsLineWidth: 2,clickable: !1,hoverable: !1,autoHighlight: !0,mouseActiveRadius: 10},interaction: {redrawOverlayInterval: 1e3 / 60},hooks: {}}, surface = null, overlay = null, eventHolder = null, ctx = null, octx = null, xaxes = [], yaxes = [], plotOffset = {left: 0,right: 0,top: 0,bottom: 0}, plotWidth = 0, plotHeight = 0, hooks = {processOptions: [],processRawData: [],processDatapoints: [],processOffset: [],drawBackground: [],drawSeries: [],draw: [],bindEvents: [],drawOverlay: [],shutdown: []}, plot = this;
            plot.setData = setData, plot.setupGrid = setupGrid, plot.draw = draw, plot.getPlaceholder = function() {
                return placeholder
            }, plot.getCanvas = function() {
                return surface.element
            }, plot.getPlotOffset = function() {
                return plotOffset
            }, plot.width = function() {
                return plotWidth
            }, plot.height = function() {
                return plotHeight
            }, plot.offset = function() {
                var o = eventHolder.offset();
                return o.left += plotOffset.left, o.top += plotOffset.top, o
            }, plot.getData = function() {
                return series
            }, plot.getAxes = function() {
                var res = {};
                return $.each(xaxes.concat(yaxes), function(_, axis) {
                    axis && (res[axis.direction + (1 != axis.n ? axis.n : "") + "axis"] = axis)
                }), res
            }, plot.getXAxes = function() {
                return xaxes
            }, plot.getYAxes = function() {
                return yaxes
            }, plot.c2p = canvasToAxisCoords, plot.p2c = axisToCanvasCoords, plot.getOptions = function() {
                return options
            }, plot.highlight = highlight, plot.unhighlight = unhighlight, plot.triggerRedrawOverlay = triggerRedrawOverlay, plot.pointOffset = function(point) {
                return {left: parseInt(xaxes[axisNumber(point, "x") - 1].p2c(+point.x) + plotOffset.left, 10),top: parseInt(yaxes[axisNumber(point, "y") - 1].p2c(+point.y) + plotOffset.top, 10)}
            }, plot.shutdown = shutdown, plot.destroy = function() {
                shutdown(), placeholder.removeData("plot").empty(), series = [], options = null, surface = null, overlay = null, eventHolder = null, ctx = null, octx = null, xaxes = [], yaxes = [], hooks = null, highlights = [], plot = null
            }, plot.resize = function() {
                var width = placeholder.width(), height = placeholder.height();
                surface.resize(width, height), overlay.resize(width, height)
            }, plot.hooks = hooks, initPlugins(plot), parseOptions(options_), setupCanvases(), setData(data_), setupGrid(), draw(), bindEvents();
            var highlights = [], redrawTimeout = null
        }
        function floorInBase(n, base) {
            return base * Math.floor(n / base)
        }
        var hasOwnProperty = Object.prototype.hasOwnProperty;
        $.fn.detach || ($.fn.detach = function() {
            return this.each(function() {
                this.parentNode && this.parentNode.removeChild(this)
            })
        }), Canvas.prototype.resize = function(width, height) {
            if (0 >= width || 0 >= height)
                throw new Error("Invalid dimensions for plot, width = " + width + ", height = " + height);
            var element = this.element, context = this.context, pixelRatio = this.pixelRatio;
            this.width != width && (element.width = width * pixelRatio, element.style.width = width + "px", this.width = width), this.height != height && (element.height = height * pixelRatio, element.style.height = height + "px", this.height = height), context.restore(), context.save(), context.scale(pixelRatio, pixelRatio)
        }, Canvas.prototype.clear = function() {
            this.context.clearRect(0, 0, this.width, this.height)
        }, Canvas.prototype.render = function() {
            var cache = this._textCache;
            for (var layerKey in cache)
                if (hasOwnProperty.call(cache, layerKey)) {
                    var layer = this.getTextLayer(layerKey), layerCache = cache[layerKey];
                    layer.hide();
                    for (var styleKey in layerCache)
                        if (hasOwnProperty.call(layerCache, styleKey)) {
                            var styleCache = layerCache[styleKey];
                            for (var key in styleCache)
                                if (hasOwnProperty.call(styleCache, key)) {
                                    for (var position, positions = styleCache[key].positions, i = 0; position = positions[i]; i++)
                                        position.active ? position.rendered || (layer.append(position.element), position.rendered = !0) : (positions.splice(i--, 1), position.rendered && position.element.detach());
                                    0 == positions.length && delete styleCache[key]
                                }
                        }
                    layer.show()
                }
        }, Canvas.prototype.getTextLayer = function(classes) {
            var layer = this.text[classes];
            return null == layer && (null == this.textContainer && (this.textContainer = $("<div class='flot-text'></div>").css({position: "absolute",top: 0,left: 0,bottom: 0,right: 0,"font-size": "smaller",color: "#545454"}).insertAfter(this.element)), layer = this.text[classes] = $("<div></div>").addClass(classes).css({position: "absolute",top: 0,left: 0,bottom: 0,right: 0}).appendTo(this.textContainer)), layer
        }, Canvas.prototype.getTextInfo = function(layer, text, font, angle, width) {
            var textStyle, layerCache, styleCache, info;
            if (text = "" + text, textStyle = "object" == typeof font ? font.style + " " + font.variant + " " + font.weight + " " + font.size + "px/" + font.lineHeight + "px " + font.family : font, layerCache = this._textCache[layer], null == layerCache && (layerCache = this._textCache[layer] = {}), styleCache = layerCache[textStyle], null == styleCache && (styleCache = layerCache[textStyle] = {}), info = styleCache[text], null == info) {
                var element = $("<div></div>").html(text).css({position: "absolute","max-width": width,top: -9999}).appendTo(this.getTextLayer(layer));
                "object" == typeof font ? element.css({font: textStyle,color: font.color}) : "string" == typeof font && element.addClass(font), info = styleCache[text] = {width: element.outerWidth(!0),height: element.outerHeight(!0),element: element,positions: []}, element.detach()
            }
            return info
        }, Canvas.prototype.addText = function(layer, x, y, text, font, angle, width, halign, valign) {
            var info = this.getTextInfo(layer, text, font, angle, width), positions = info.positions;
            "center" == halign ? x -= info.width / 2 : "right" == halign && (x -= info.width), "middle" == valign ? y -= info.height / 2 : "bottom" == valign && (y -= info.height);
            for (var position, i = 0; position = positions[i]; i++)
                if (position.x == x && position.y == y)
                    return void (position.active = !0);
            position = {active: !0,rendered: !1,element: positions.length ? info.element.clone() : info.element,x: x,y: y}, positions.push(position), position.element.css({top: Math.round(y),left: Math.round(x),"text-align": halign})
        }, Canvas.prototype.removeText = function(layer, x, y, text, font, angle) {
            if (null == text) {
                var layerCache = this._textCache[layer];
                if (null != layerCache)
                    for (var styleKey in layerCache)
                        if (hasOwnProperty.call(layerCache, styleKey)) {
                            var styleCache = layerCache[styleKey];
                            for (var key in styleCache)
                                if (hasOwnProperty.call(styleCache, key))
                                    for (var position, positions = styleCache[key].positions, i = 0; position = positions[i]; i++)
                                        position.active = !1
                        }
            } else
                for (var position, positions = this.getTextInfo(layer, text, font, angle).positions, i = 0; position = positions[i]; i++)
                    position.x == x && position.y == y && (position.active = !1)
        }, $.plot = function(placeholder, data, options) {
            var plot = new Plot($(placeholder), data, options, $.plot.plugins);
            return plot
        }, $.plot.version = "0.8.3", $.plot.plugins = [], $.fn.plot = function(data, options) {
            return this.each(function() {
                $.plot(this, data, options)
            })
        }
    }(jQuery), function($) {
        function floorInBase(n, base) {
            return base * Math.floor(n / base)
        }
        function formatDate(d, fmt, monthNames, dayNames) {
            if ("function" == typeof d.strftime)
                return d.strftime(fmt);
            var leftPad = function(n, pad) {
                return n = "" + n, pad = "" + (null == pad ? "0" : pad), 1 == n.length ? pad + n : n
            }, r = [], escape = !1, hours = d.getHours(), isAM = 12 > hours;
            null == monthNames && (monthNames = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]), null == dayNames && (dayNames = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]);
            var hours12;
            hours12 = hours > 12 ? hours - 12 : 0 == hours ? 12 : hours;
            for (var i = 0; i < fmt.length; ++i) {
                var c = fmt.charAt(i);
                if (escape) {
                    switch (c) {
                        case "a":
                            c = "" + dayNames[d.getDay()];
                            break;
                        case "b":
                            c = "" + monthNames[d.getMonth()];
                            break;
                        case "d":
                            c = leftPad(d.getDate());
                            break;
                        case "e":
                            c = leftPad(d.getDate(), " ");
                            break;
                        case "h":
                        case "H":
                            c = leftPad(hours);
                            break;
                        case "I":
                            c = leftPad(hours12);
                            break;
                        case "l":
                            c = leftPad(hours12, " ");
                            break;
                        case "m":
                            c = leftPad(d.getMonth() + 1);
                            break;
                        case "M":
                            c = leftPad(d.getMinutes());
                            break;
                        case "q":
                            c = "" + (Math.floor(d.getMonth() / 3) + 1);
                            break;
                        case "S":
                            c = leftPad(d.getSeconds());
                            break;
                        case "y":
                            c = leftPad(d.getFullYear() % 100);
                            break;
                        case "Y":
                            c = "" + d.getFullYear();
                            break;
                        case "p":
                            c = isAM ? "am" : "pm";
                            break;
                        case "P":
                            c = isAM ? "AM" : "PM";
                            break;
                        case "w":
                            c = "" + d.getDay()
                    }
                    r.push(c), escape = !1
                } else
                    "%" == c ? escape = !0 : r.push(c)
            }
            return r.join("")
        }
        function makeUtcWrapper(d) {
            function addProxyMethod(sourceObj, sourceMethod, targetObj, targetMethod) {
                sourceObj[sourceMethod] = function() {
                    return targetObj[targetMethod].apply(targetObj, arguments)
                }
            }
            var utc = {date: d};
            void 0 != d.strftime && addProxyMethod(utc, "strftime", d, "strftime"), addProxyMethod(utc, "getTime", d, "getTime"), addProxyMethod(utc, "setTime", d, "setTime");
            for (var props = ["Date", "Day", "FullYear", "Hours", "Milliseconds", "Minutes", "Month", "Seconds"], p = 0; p < props.length; p++)
                addProxyMethod(utc, "get" + props[p], d, "getUTC" + props[p]), addProxyMethod(utc, "set" + props[p], d, "setUTC" + props[p]);
            return utc
        }
        function dateGenerator(ts, opts) {
            if ("browser" == opts.timezone)
                return new Date(ts);
            if (opts.timezone && "utc" != opts.timezone) {
                if ("undefined" != typeof timezoneJS && "undefined" != typeof timezoneJS.Date) {
                    var d = new timezoneJS.Date;
                    return d.setTimezone(opts.timezone), d.setTime(ts), d
                }
                return makeUtcWrapper(new Date(ts))
            }
            return makeUtcWrapper(new Date(ts))
        }
        function init(plot) {
            plot.hooks.processOptions.push(function(plot, options) {
                $.each(plot.getAxes(), function(axisName, axis) {
                    var opts = axis.options;
                    "time" == opts.mode && (axis.tickGenerator = function(axis) {
                        var ticks = [], d = dateGenerator(axis.min, opts), minSize = 0, spec = opts.tickSize && "quarter" === opts.tickSize[1] || opts.minTickSize && "quarter" === opts.minTickSize[1] ? specQuarters : specMonths;
                        null != opts.minTickSize && (minSize = "number" == typeof opts.tickSize ? opts.tickSize : opts.minTickSize[0] * timeUnitSize[opts.minTickSize[1]]);
                        for (var i = 0; i < spec.length - 1 && !(axis.delta < (spec[i][0] * timeUnitSize[spec[i][1]] + spec[i + 1][0] * timeUnitSize[spec[i + 1][1]]) / 2 && spec[i][0] * timeUnitSize[spec[i][1]] >= minSize); ++i)
                            ;
                        var size = spec[i][0], unit = spec[i][1];
                        if ("year" == unit) {
                            if (null != opts.minTickSize && "year" == opts.minTickSize[1])
                                size = Math.floor(opts.minTickSize[0]);
                            else {
                                var magn = Math.pow(10, Math.floor(Math.log(axis.delta / timeUnitSize.year) / Math.LN10)), norm = axis.delta / timeUnitSize.year / magn;
                                size = 1.5 > norm ? 1 : 3 > norm ? 2 : 7.5 > norm ? 5 : 10, size *= magn
                            }
                            1 > size && (size = 1)
                        }
                        axis.tickSize = opts.tickSize || [size, unit];
                        var tickSize = axis.tickSize[0];
                        unit = axis.tickSize[1];
                        var step = tickSize * timeUnitSize[unit];
                        "second" == unit ? d.setSeconds(floorInBase(d.getSeconds(), tickSize)) : "minute" == unit ? d.setMinutes(floorInBase(d.getMinutes(), tickSize)) : "hour" == unit ? d.setHours(floorInBase(d.getHours(), tickSize)) : "month" == unit ? d.setMonth(floorInBase(d.getMonth(), tickSize)) : "quarter" == unit ? d.setMonth(3 * floorInBase(d.getMonth() / 3, tickSize)) : "year" == unit && d.setFullYear(floorInBase(d.getFullYear(), tickSize)), d.setMilliseconds(0), step >= timeUnitSize.minute && d.setSeconds(0), step >= timeUnitSize.hour && d.setMinutes(0), step >= timeUnitSize.day && d.setHours(0), step >= 4 * timeUnitSize.day && d.setDate(1), step >= 2 * timeUnitSize.month && d.setMonth(floorInBase(d.getMonth(), 3)), step >= 2 * timeUnitSize.quarter && d.setMonth(floorInBase(d.getMonth(), 6)), step >= timeUnitSize.year && d.setMonth(0);
                        var prev, carry = 0, v = Number.NaN;
                        do
                            if (prev = v, v = d.getTime(), ticks.push(v), "month" == unit || "quarter" == unit)
                                if (1 > tickSize) {
                                    d.setDate(1);
                                    var start = d.getTime();
                                    d.setMonth(d.getMonth() + ("quarter" == unit ? 3 : 1));
                                    var end = d.getTime();
                                    d.setTime(v + carry * timeUnitSize.hour + (end - start) * tickSize), carry = d.getHours(), d.setHours(0)
                                } else
                                    d.setMonth(d.getMonth() + tickSize * ("quarter" == unit ? 3 : 1));
                            else
                                "year" == unit ? d.setFullYear(d.getFullYear() + tickSize) : d.setTime(v + step);
                        while (v < axis.max && v != prev);
                        return ticks
                    }, axis.tickFormatter = function(v, axis) {
                        var d = dateGenerator(v, axis.options);
                        if (null != opts.timeformat)
                            return formatDate(d, opts.timeformat, opts.monthNames, opts.dayNames);
                        var fmt, useQuarters = axis.options.tickSize && "quarter" == axis.options.tickSize[1] || axis.options.minTickSize && "quarter" == axis.options.minTickSize[1], t = axis.tickSize[0] * timeUnitSize[axis.tickSize[1]], span = axis.max - axis.min, suffix = opts.twelveHourClock ? " %p" : "", hourCode = opts.twelveHourClock ? "%I" : "%H";
                        fmt = t < timeUnitSize.minute ? hourCode + ":%M:%S" + suffix : t < timeUnitSize.day ? span < 2 * timeUnitSize.day ? hourCode + ":%M" + suffix : "%b %d " + hourCode + ":%M" + suffix : t < timeUnitSize.month ? "%b %d" : useQuarters && t < timeUnitSize.quarter || !useQuarters && t < timeUnitSize.year ? span < timeUnitSize.year ? "%b" : "%b %Y" : useQuarters && t < timeUnitSize.year ? span < timeUnitSize.year ? "Q%q" : "Q%q %Y" : "%Y";
                        var rt = formatDate(d, fmt, opts.monthNames, opts.dayNames);
                        return rt
                    })
                })
            })
        }
        var options = {xaxis: {timezone: null,timeformat: null,twelveHourClock: !1,monthNames: null}}, timeUnitSize = {second: 1e3,minute: 6e4,hour: 36e5,day: 864e5,month: 2592e6,quarter: 7776e6,year: 525949.2 * 60 * 1e3}, baseSpec = [[1, "second"], [2, "second"], [5, "second"], [10, "second"], [30, "second"], [1, "minute"], [2, "minute"], [5, "minute"], [10, "minute"], [30, "minute"], [1, "hour"], [2, "hour"], [4, "hour"], [8, "hour"], [12, "hour"], [1, "day"], [2, "day"], [3, "day"], [.25, "month"], [.5, "month"], [1, "month"], [2, "month"]], specMonths = baseSpec.concat([[3, "month"], [6, "month"], [1, "year"]]), specQuarters = baseSpec.concat([[1, "quarter"], [2, "quarter"], [1, "year"]]);
        $.plot.plugins.push({init: init,options: options,name: "time",version: "1.0"}), $.plot.formatDate = formatDate, $.plot.dateGenerator = dateGenerator
    }(jQuery), function($) {
        function init(plot) {
            function findMatchingSeries(s, allseries) {
                for (var res = null, i = 0; i < allseries.length && s != allseries[i]; ++i)
                    allseries[i].stack == s.stack && (res = allseries[i]);
                return res
            }
            function stackData(plot, s, datapoints) {
                if (null != s.stack && s.stack !== !1) {
                    var other = findMatchingSeries(s, plot.getData());
                    if (other) {
                        for (var px, py, intery, qx, qy, bottom, l, m, ps = datapoints.pointsize, points = datapoints.points, otherps = other.datapoints.pointsize, otherpoints = other.datapoints.points, newpoints = [], withlines = s.lines.show, horizontal = s.bars.horizontal, withbottom = ps > 2 && (horizontal ? datapoints.format[2].x : datapoints.format[2].y), withsteps = withlines && s.lines.steps, fromgap = !0, keyOffset = horizontal ? 1 : 0, accumulateOffset = horizontal ? 0 : 1, i = 0, j = 0; ; ) {
                            if (i >= points.length)
                                break;
                            if (l = newpoints.length, null == points[i]) {
                                for (m = 0; ps > m; ++m)
                                    newpoints.push(points[i + m]);
                                i += ps
                            } else if (j >= otherpoints.length) {
                                if (!withlines)
                                    for (m = 0; ps > m; ++m)
                                        newpoints.push(points[i + m]);
                                i += ps
                            } else if (null == otherpoints[j]) {
                                for (m = 0; ps > m; ++m)
                                    newpoints.push(null);
                                fromgap = !0, j += otherps
                            } else {
                                if (px = points[i + keyOffset], py = points[i + accumulateOffset], qx = otherpoints[j + keyOffset], qy = otherpoints[j + accumulateOffset], bottom = 0, px == qx) {
                                    for (m = 0; ps > m; ++m)
                                        newpoints.push(points[i + m]);
                                    newpoints[l + accumulateOffset] += qy, bottom = qy, i += ps, j += otherps
                                } else if (px > qx) {
                                    if (withlines && i > 0 && null != points[i - ps]) {
                                        for (intery = py + (points[i - ps + accumulateOffset] - py) * (qx - px) / (points[i - ps + keyOffset] - px), newpoints.push(qx), newpoints.push(intery + qy), m = 2; ps > m; ++m)
                                            newpoints.push(points[i + m]);
                                        bottom = qy
                                    }
                                    j += otherps
                                } else {
                                    if (fromgap && withlines) {
                                        i += ps;
                                        continue
                                    }
                                    for (m = 0; ps > m; ++m)
                                        newpoints.push(points[i + m]);
                                    withlines && j > 0 && null != otherpoints[j - otherps] && (bottom = qy + (otherpoints[j - otherps + accumulateOffset] - qy) * (px - qx) / (otherpoints[j - otherps + keyOffset] - qx)), newpoints[l + accumulateOffset] += bottom, i += ps
                                }
                                fromgap = !1, l != newpoints.length && withbottom && (newpoints[l + 2] += bottom)
                            }
                            if (withsteps && l != newpoints.length && l > 0 && null != newpoints[l] && newpoints[l] != newpoints[l - ps] && newpoints[l + 1] != newpoints[l - ps + 1]) {
                                for (m = 0; ps > m; ++m)
                                    newpoints[l + ps + m] = newpoints[l + m];
                                newpoints[l + 1] = newpoints[l - ps + 1]
                            }
                        }
                        datapoints.points = newpoints
                    }
                }
            }
            plot.hooks.processDatapoints.push(stackData)
        }
        var options = {series: {stack: null}};
        $.plot.plugins.push({init: init,options: options,name: "stack",version: "1.2"})
    }(jQuery), function($) {
        function init(plot) {
            function onMouseMove(e) {
                selection.active && (updateSelection(e), plot.getPlaceholder().trigger("plotselecting", [getSelection()]))
            }
            function onMouseDown(e) {
                1 == e.which && (document.body.focus(), void 0 !== document.onselectstart && null == savedhandlers.onselectstart && (savedhandlers.onselectstart = document.onselectstart, document.onselectstart = function() {
                    return !1
                }), void 0 !== document.ondrag && null == savedhandlers.ondrag && (savedhandlers.ondrag = document.ondrag, document.ondrag = function() {
                    return !1
                }), setSelectionPos(selection.first, e), selection.active = !0, mouseUpHandler = function(e) {
                    onMouseUp(e)
                }, $(document).one("mouseup", mouseUpHandler))
            }
            function onMouseUp(e) {
                return mouseUpHandler = null, void 0 !== document.onselectstart && (document.onselectstart = savedhandlers.onselectstart), void 0 !== document.ondrag && (document.ondrag = savedhandlers.ondrag), selection.active = !1, updateSelection(e), selectionIsSane() ? triggerSelectedEvent() : (plot.getPlaceholder().trigger("plotunselected", []), plot.getPlaceholder().trigger("plotselecting", [null])), !1
            }
            function getSelection() {
                if (!selectionIsSane())
                    return null;
                if (!selection.show)
                    return null;
                var r = {}, c1 = selection.first, c2 = selection.second;
                return $.each(plot.getAxes(), function(name, axis) {
                    if (axis.used) {
                        var p1 = axis.c2p(c1[axis.direction]), p2 = axis.c2p(c2[axis.direction]);
                        r[name] = {from: Math.min(p1, p2),to: Math.max(p1, p2)}
                    }
                }), r
            }
            function triggerSelectedEvent() {
                var r = getSelection();
                plot.getPlaceholder().trigger("plotselected", [r]), r.xaxis && r.yaxis && plot.getPlaceholder().trigger("selected", [{x1: r.xaxis.from,y1: r.yaxis.from,x2: r.xaxis.to,y2: r.yaxis.to}])
            }
            function clamp(min, value, max) {
                return min > value ? min : value > max ? max : value
            }
            function setSelectionPos(pos, e) {
                var o = plot.getOptions(), offset = plot.getPlaceholder().offset(), plotOffset = plot.getPlotOffset();
                pos.x = clamp(0, e.pageX - offset.left - plotOffset.left, plot.width()), pos.y = clamp(0, e.pageY - offset.top - plotOffset.top, plot.height()), "y" == o.selection.mode && (pos.x = pos == selection.first ? 0 : plot.width()), "x" == o.selection.mode && (pos.y = pos == selection.first ? 0 : plot.height())
            }
            function updateSelection(pos) {
                null != pos.pageX && (setSelectionPos(selection.second, pos), selectionIsSane() ? (selection.show = !0, plot.triggerRedrawOverlay()) : clearSelection(!0))
            }
            function clearSelection(preventEvent) {
                selection.show && (selection.show = !1, plot.triggerRedrawOverlay(), preventEvent || plot.getPlaceholder().trigger("plotunselected", []))
            }
            function extractRange(ranges, coord) {
                var axis, from, to, key, axes = plot.getAxes();
                for (var k in axes)
                    if (axis = axes[k], axis.direction == coord && (key = coord + axis.n + "axis", ranges[key] || 1 != axis.n || (key = coord + "axis"), ranges[key])) {
                        from = ranges[key].from, to = ranges[key].to;
                        break
                    }
                if (ranges[key] || (axis = "x" == coord ? plot.getXAxes()[0] : plot.getYAxes()[0], from = ranges[coord + "1"], to = ranges[coord + "2"]), null != from && null != to && from > to) {
                    var tmp = from;
                    from = to, to = tmp
                }
                return {from: from,to: to,axis: axis}
            }
            function setSelection(ranges, preventEvent) {
                var range, o = plot.getOptions();
                "y" == o.selection.mode ? (selection.first.x = 0, selection.second.x = plot.width()) : (range = extractRange(ranges, "x"), selection.first.x = range.axis.p2c(range.from), selection.second.x = range.axis.p2c(range.to)), "x" == o.selection.mode ? (selection.first.y = 0, selection.second.y = plot.height()) : (range = extractRange(ranges, "y"), selection.first.y = range.axis.p2c(range.from), selection.second.y = range.axis.p2c(range.to)), selection.show = !0, plot.triggerRedrawOverlay(), !preventEvent && selectionIsSane() && triggerSelectedEvent()
            }
            function selectionIsSane() {
                var minSize = plot.getOptions().selection.minSize;
                return Math.abs(selection.second.x - selection.first.x) >= minSize && Math.abs(selection.second.y - selection.first.y) >= minSize
            }
            var selection = {first: {x: -1,y: -1},second: {x: -1,y: -1},show: !1,active: !1}, savedhandlers = {}, mouseUpHandler = null;
            plot.clearSelection = clearSelection, plot.setSelection = setSelection, plot.getSelection = getSelection, plot.hooks.bindEvents.push(function(plot, eventHolder) {
                var o = plot.getOptions();
                null != o.selection.mode && (eventHolder.mousemove(onMouseMove), eventHolder.mousedown(onMouseDown))
            }), plot.hooks.drawOverlay.push(function(plot, ctx) {
                if (selection.show && selectionIsSane()) {
                    var plotOffset = plot.getPlotOffset(), o = plot.getOptions();
                    ctx.save(), ctx.translate(plotOffset.left, plotOffset.top);
                    var c = $.color.parse(o.selection.color);
                    ctx.strokeStyle = c.scale("a", .8).toString(), ctx.lineWidth = 1, ctx.lineJoin = o.selection.shape, ctx.fillStyle = c.scale("a", .4).toString();
                    var x = Math.min(selection.first.x, selection.second.x) + .5, y = Math.min(selection.first.y, selection.second.y) + .5, w = Math.abs(selection.second.x - selection.first.x) - 1, h = Math.abs(selection.second.y - selection.first.y) - 1;
                    ctx.fillRect(x, y, w, h), ctx.strokeRect(x, y, w, h), ctx.restore()
                }
            }), plot.hooks.shutdown.push(function(plot, eventHolder) {
                eventHolder.unbind("mousemove", onMouseMove), eventHolder.unbind("mousedown", onMouseDown), mouseUpHandler && $(document).unbind("mouseup", mouseUpHandler)
            })
        }
        $.plot.plugins.push({init: init,options: {selection: {mode: null,color: "#e8cfac",shape: "round",minSize: 5}},name: "selection",version: "1.1"})
    }(jQuery), function($) {
        function init(plot) {
            function processDatapoints(plot, series, datapoints) {
                processed || (processed = !0, canvas = plot.getCanvas(), target = $(canvas).parent(), options = plot.getOptions(), plot.setData(combine(plot.getData())))
            }
            function combine(data) {
                for (var total = 0, combined = 0, numCombined = 0, color = options.series.pie.combine.color, newdata = [], i = 0; i < data.length; ++i) {
                    var value = data[i].data;
                    $.isArray(value) && 1 == value.length && (value = value[0]), $.isArray(value) ? !isNaN(parseFloat(value[1])) && isFinite(value[1]) ? value[1] = +value[1] : value[1] = 0 : value = !isNaN(parseFloat(value)) && isFinite(value) ? [1, +value] : [1, 0], data[i].data = [value]
                }
                for (var i = 0; i < data.length; ++i)
                    total += data[i].data[0][1];
                for (var i = 0; i < data.length; ++i) {
                    var value = data[i].data[0][1];
                    value / total <= options.series.pie.combine.threshold && (combined += value, numCombined++, color || (color = data[i].color))
                }
                for (var i = 0; i < data.length; ++i) {
                    var value = data[i].data[0][1];
                    (2 > numCombined || value / total > options.series.pie.combine.threshold) && newdata.push($.extend(data[i], {data: [[1, value]],color: data[i].color,label: data[i].label,angle: value * Math.PI * 2 / total,percent: value / (total / 100)}))
                }
                return numCombined > 1 && newdata.push({data: [[1, combined]],color: color,label: options.series.pie.combine.label,angle: combined * Math.PI * 2 / total,percent: combined / (total / 100)}), newdata
            }
            function draw(plot, newCtx) {
                function clear() {
                    ctx.clearRect(0, 0, canvasWidth, canvasHeight), target.children().filter(".pieLabel, .pieLabelBackground").remove()
                }
                function drawShadow() {
                    var shadowLeft = options.series.pie.shadow.left, shadowTop = options.series.pie.shadow.top, edge = 10, alpha = options.series.pie.shadow.alpha, radius = options.series.pie.radius > 1 ? options.series.pie.radius : maxRadius * options.series.pie.radius;
                    if (!(radius >= canvasWidth / 2 - shadowLeft || radius * options.series.pie.tilt >= canvasHeight / 2 - shadowTop || edge >= radius)) {
                        ctx.save(), ctx.translate(shadowLeft, shadowTop), ctx.globalAlpha = alpha, ctx.fillStyle = "#000", ctx.translate(centerLeft, centerTop), ctx.scale(1, options.series.pie.tilt);
                        for (var i = 1; edge >= i; i++)
                            ctx.beginPath(), ctx.arc(0, 0, radius, 0, 2 * Math.PI, !1), ctx.fill(), radius -= i;
                        ctx.restore()
                    }
                }
                function drawPie() {
                    function drawSlice(angle, color, fill) {
                        0 >= angle || isNaN(angle) || (fill ? ctx.fillStyle = color : (ctx.strokeStyle = color, ctx.lineJoin = "round"), ctx.beginPath(), Math.abs(angle - 2 * Math.PI) > 1e-9 && ctx.moveTo(0, 0), ctx.arc(0, 0, radius, currentAngle, currentAngle + angle / 2, !1), ctx.arc(0, 0, radius, currentAngle + angle / 2, currentAngle + angle, !1), ctx.closePath(), currentAngle += angle, fill ? ctx.fill() : ctx.stroke())
                    }
                    function drawLabels() {
                        function drawLabel(slice, startAngle, index) {
                            if (0 == slice.data[0][1])
                                return !0;
                            var text, lf = options.legend.labelFormatter, plf = options.series.pie.label.formatter;
                            text = lf ? lf(slice.label, slice) : slice.label, plf && (text = plf(text, slice));
                            var halfAngle = (startAngle + slice.angle + startAngle) / 2, x = centerLeft + Math.round(Math.cos(halfAngle) * radius), y = centerTop + Math.round(Math.sin(halfAngle) * radius) * options.series.pie.tilt, html = "<span class='pieLabel' id='pieLabel" + index + "' style='position:absolute;top:" + y + "px;left:" + x + "px;'>" + text + "</span>";
                            target.append(html);
                            var label = target.children("#pieLabel" + index), labelTop = y - label.height() / 2, labelLeft = x - label.width() / 2;
                            if (label.css("top", labelTop), label.css("left", labelLeft), 0 - labelTop > 0 || 0 - labelLeft > 0 || canvasHeight - (labelTop + label.height()) < 0 || canvasWidth - (labelLeft + label.width()) < 0)
                                return !1;
                            if (0 != options.series.pie.label.background.opacity) {
                                var c = options.series.pie.label.background.color;
                                null == c && (c = slice.color);
                                var pos = "top:" + labelTop + "px;left:" + labelLeft + "px;";
                                $("<div class='pieLabelBackground' style='position:absolute;width:" + label.width() + "px;height:" + label.height() + "px;" + pos + "background-color:" + c + ";'></div>").css("opacity", options.series.pie.label.background.opacity).insertBefore(label)
                            }
                            return !0
                        }
                        for (var currentAngle = startAngle, radius = options.series.pie.label.radius > 1 ? options.series.pie.label.radius : maxRadius * options.series.pie.label.radius, i = 0; i < slices.length; ++i) {
                            if (slices[i].percent >= 100 * options.series.pie.label.threshold && !drawLabel(slices[i], currentAngle, i))
                                return !1;
                            currentAngle += slices[i].angle
                        }
                        return !0
                    }
                    var startAngle = Math.PI * options.series.pie.startAngle, radius = options.series.pie.radius > 1 ? options.series.pie.radius : maxRadius * options.series.pie.radius;
                    ctx.save(), ctx.translate(centerLeft, centerTop), ctx.scale(1, options.series.pie.tilt), ctx.save();
                    for (var currentAngle = startAngle, i = 0; i < slices.length; ++i)
                        slices[i].startAngle = currentAngle, drawSlice(slices[i].angle, slices[i].color, !0);
                    if (ctx.restore(), options.series.pie.stroke.width > 0) {
                        ctx.save(), ctx.lineWidth = options.series.pie.stroke.width, currentAngle = startAngle;
                        for (var i = 0; i < slices.length; ++i)
                            drawSlice(slices[i].angle, options.series.pie.stroke.color, !1);
                        ctx.restore()
                    }
                    return drawDonutHole(ctx), ctx.restore(), options.series.pie.label.show ? drawLabels() : !0
                }
                if (target) {
                    var canvasWidth = plot.getPlaceholder().width(), canvasHeight = plot.getPlaceholder().height(), legendWidth = target.children().filter(".legend").children().width() || 0;
                    ctx = newCtx, processed = !1, maxRadius = Math.min(canvasWidth, canvasHeight / options.series.pie.tilt) / 2, centerTop = canvasHeight / 2 + options.series.pie.offset.top, centerLeft = canvasWidth / 2, "auto" == options.series.pie.offset.left ? (options.legend.position.match("w") ? centerLeft += legendWidth / 2 : centerLeft -= legendWidth / 2, maxRadius > centerLeft ? centerLeft = maxRadius : centerLeft > canvasWidth - maxRadius && (centerLeft = canvasWidth - maxRadius)) : centerLeft += options.series.pie.offset.left;
                    var slices = plot.getData(), attempts = 0;
                    do
                        attempts > 0 && (maxRadius *= REDRAW_SHRINK), attempts += 1, clear(), options.series.pie.tilt <= .8 && drawShadow();
                    while (!drawPie() && REDRAW_ATTEMPTS > attempts);
                    attempts >= REDRAW_ATTEMPTS && (clear(), target.prepend("<div class='error'>Could not draw pie with labels contained inside canvas</div>")), plot.setSeries && plot.insertLegend && (plot.setSeries(slices), plot.insertLegend())
                }
            }
            function drawDonutHole(layer) {
                if (options.series.pie.innerRadius > 0) {
                    layer.save();
                    var innerRadius = options.series.pie.innerRadius > 1 ? options.series.pie.innerRadius : maxRadius * options.series.pie.innerRadius;
                    layer.globalCompositeOperation = "destination-out", layer.beginPath(), layer.fillStyle = options.series.pie.stroke.color, layer.arc(0, 0, innerRadius, 0, 2 * Math.PI, !1), layer.fill(), layer.closePath(), layer.restore(), layer.save(), layer.beginPath(), layer.strokeStyle = options.series.pie.stroke.color, layer.arc(0, 0, innerRadius, 0, 2 * Math.PI, !1), layer.stroke(), layer.closePath(), layer.restore()
                }
            }
            function isPointInPoly(poly, pt) {
                for (var c = !1, i = -1, l = poly.length, j = l - 1; ++i < l; j = i)
                    (poly[i][1] <= pt[1] && pt[1] < poly[j][1] || poly[j][1] <= pt[1] && pt[1] < poly[i][1]) && pt[0] < (poly[j][0] - poly[i][0]) * (pt[1] - poly[i][1]) / (poly[j][1] - poly[i][1]) + poly[i][0] && (c = !c);
                return c
            }
            function findNearbySlice(mouseX, mouseY) {
                for (var x, y, slices = plot.getData(), options = plot.getOptions(), radius = options.series.pie.radius > 1 ? options.series.pie.radius : maxRadius * options.series.pie.radius, i = 0; i < slices.length; ++i) {
                    var s = slices[i];
                    if (s.pie.show) {
                        if (ctx.save(), ctx.beginPath(), ctx.moveTo(0, 0), ctx.arc(0, 0, radius, s.startAngle, s.startAngle + s.angle / 2, !1), ctx.arc(0, 0, radius, s.startAngle + s.angle / 2, s.startAngle + s.angle, !1), ctx.closePath(), x = mouseX - centerLeft, y = mouseY - centerTop, ctx.isPointInPath) {
                            if (ctx.isPointInPath(mouseX - centerLeft, mouseY - centerTop))
                                return ctx.restore(), {datapoint: [s.percent, s.data],dataIndex: 0,series: s,seriesIndex: i}
                        } else {
                            var p1X = radius * Math.cos(s.startAngle), p1Y = radius * Math.sin(s.startAngle), p2X = radius * Math.cos(s.startAngle + s.angle / 4), p2Y = radius * Math.sin(s.startAngle + s.angle / 4), p3X = radius * Math.cos(s.startAngle + s.angle / 2), p3Y = radius * Math.sin(s.startAngle + s.angle / 2), p4X = radius * Math.cos(s.startAngle + s.angle / 1.5), p4Y = radius * Math.sin(s.startAngle + s.angle / 1.5), p5X = radius * Math.cos(s.startAngle + s.angle), p5Y = radius * Math.sin(s.startAngle + s.angle), arrPoly = [[0, 0], [p1X, p1Y], [p2X, p2Y], [p3X, p3Y], [p4X, p4Y], [p5X, p5Y]], arrPoint = [x, y];
                            if (isPointInPoly(arrPoly, arrPoint))
                                return ctx.restore(), {datapoint: [s.percent, s.data],dataIndex: 0,series: s,seriesIndex: i}
                        }
                        ctx.restore()
                    }
                }
                return null
            }
            function onMouseMove(e) {
                triggerClickHoverEvent("plothover", e)
            }
            function onClick(e) {
                triggerClickHoverEvent("plotclick", e)
            }
            function triggerClickHoverEvent(eventname, e) {
                var offset = plot.offset(), canvasX = parseInt(e.pageX - offset.left), canvasY = parseInt(e.pageY - offset.top), item = findNearbySlice(canvasX, canvasY);
                if (options.grid.autoHighlight)
                    for (var i = 0; i < highlights.length; ++i) {
                        var h = highlights[i];
                        h.auto != eventname || item && h.series == item.series || unhighlight(h.series)
                    }
                item && highlight(item.series, eventname);
                var pos = {pageX: e.pageX,pageY: e.pageY};
                target.trigger(eventname, [pos, item])
            }
            function highlight(s, auto) {
                var i = indexOfHighlight(s);
                -1 == i ? (highlights.push({series: s,auto: auto}), plot.triggerRedrawOverlay()) : auto || (highlights[i].auto = !1)
            }
            function unhighlight(s) {
                null == s && (highlights = [], plot.triggerRedrawOverlay());
                var i = indexOfHighlight(s);
                -1 != i && (highlights.splice(i, 1), plot.triggerRedrawOverlay())
            }
            function indexOfHighlight(s) {
                for (var i = 0; i < highlights.length; ++i) {
                    var h = highlights[i];
                    if (h.series == s)
                        return i
                }
                return -1
            }
            function drawOverlay(plot, octx) {
                function drawHighlight(series) {
                    series.angle <= 0 || isNaN(series.angle) || (octx.fillStyle = "rgba(255, 255, 255, " + options.series.pie.highlight.opacity + ")", octx.beginPath(), Math.abs(series.angle - 2 * Math.PI) > 1e-9 && octx.moveTo(0, 0), octx.arc(0, 0, radius, series.startAngle, series.startAngle + series.angle / 2, !1), octx.arc(0, 0, radius, series.startAngle + series.angle / 2, series.startAngle + series.angle, !1), octx.closePath(), octx.fill())
                }
                var options = plot.getOptions(), radius = options.series.pie.radius > 1 ? options.series.pie.radius : maxRadius * options.series.pie.radius;
                octx.save(), octx.translate(centerLeft, centerTop), octx.scale(1, options.series.pie.tilt);
                for (var i = 0; i < highlights.length; ++i)
                    drawHighlight(highlights[i].series);
                drawDonutHole(octx), octx.restore()
            }
            var canvas = null, target = null, options = null, maxRadius = null, centerLeft = null, centerTop = null, processed = !1, ctx = null, highlights = [];
            plot.hooks.processOptions.push(function(plot, options) {
                options.series.pie.show && (options.grid.show = !1, "auto" == options.series.pie.label.show && (options.legend.show ? options.series.pie.label.show = !1 : options.series.pie.label.show = !0), "auto" == options.series.pie.radius && (options.series.pie.label.show ? options.series.pie.radius = .75 : options.series.pie.radius = 1), options.series.pie.tilt > 1 ? options.series.pie.tilt = 1 : options.series.pie.tilt < 0 && (options.series.pie.tilt = 0))
            }), plot.hooks.bindEvents.push(function(plot, eventHolder) {
                var options = plot.getOptions();
                options.series.pie.show && (options.grid.hoverable && eventHolder.unbind("mousemove").mousemove(onMouseMove), options.grid.clickable && eventHolder.unbind("click").click(onClick))
            }), plot.hooks.processDatapoints.push(function(plot, series, data, datapoints) {
                var options = plot.getOptions();
                options.series.pie.show && processDatapoints(plot, series, data, datapoints)
            }), plot.hooks.drawOverlay.push(function(plot, octx) {
                var options = plot.getOptions();
                options.series.pie.show && drawOverlay(plot, octx)
            }), plot.hooks.draw.push(function(plot, newCtx) {
                var options = plot.getOptions();
                options.series.pie.show && draw(plot, newCtx)
            })
        }
        var REDRAW_ATTEMPTS = 10, REDRAW_SHRINK = .95, options = {series: {pie: {show: !1,radius: "auto",innerRadius: 0,startAngle: 1.5,tilt: 1,shadow: {left: 5,top: 15,alpha: .02},offset: {top: 0,left: "auto"},stroke: {color: "#fff",width: 1},label: {show: "auto",formatter: function(label, slice) {
                            return "<div style='font-size:x-small;text-align:center;padding:2px;color:" + slice.color + ";'>" + label + "<br/>" + Math.round(slice.percent) + "%</div>"
                        },radius: 1,background: {color: null,opacity: 0},threshold: 0},combine: {threshold: -1,color: null,label: "Other"},highlight: {opacity: .5}}}};
        $.plot.plugins.push({init: init,options: options,name: "pie",version: "1.1"})
    }(jQuery), null == window.jQuery.plot)
        throw new Error('Grunt Requireize: module does not define "window.jQuery.plot"');
    return window.jQuery.plot
}), fweb_define("ftnt_shared", ["jquery", "flot"], null, function() {
    var define = void 0, module = {exports: {}}, exports = {};
    return function(f) {
        if ("object" == typeof exports && "undefined" != typeof module)
            module.exports = f();
        else if ("function" == typeof define && define.amd)
            define([], f);
        else {
            var g;
            g = "undefined" != typeof window ? window : "undefined" != typeof global ? global : "undefined" != typeof self ? self : this, g.ftnt_shared = f()
        }
    }(function() {
        return function e(t, n, r) {
            function s(o, u) {
                if (!n[o]) {
                    if (!t[o]) {
                        var a = "function" == typeof require && require;
                        if (!u && a)
                            return a(o, !0);
                        if (i)
                            return i(o, !0);
                        var f = new Error("Cannot find module '" + o + "'");
                        throw f.code = "MODULE_NOT_FOUND", f
                    }
                    var l = n[o] = {exports: {}};
                    t[o][0].call(l.exports, function(e) {
                        var n = t[o][1][e];
                        return s(n ? n : e)
                    }, l, l.exports, e, t, n, r)
                }
                return n[o].exports
            }
            for (var i = "function" == typeof require && require, o = 0; o < r.length; o++)
                s(r[o]);
            return s
        }({1: [function(require, module, exports) {
                    "use strict";
                    require("./chart"), require("./select"), require("./slide"), require("./add-empty-placeholders"), require("./jquery"), require("./detect-antialiasing-disabled"), module.exports = {util: require("./util"),nonBlockingSort: require("./sort"),notify: require("./notify"),highlighter: require("./highlighter"),enhanceFileInput: require("./enhance-file-input")}
                }, {"./add-empty-placeholders": 2,"./chart": 3,"./detect-antialiasing-disabled": 4,"./enhance-file-input": 5,"./highlighter": 6,"./jquery": 9,"./notify": 15,"./select": 18,"./slide": 25,"./sort": 27,"./util": 29}],2: [function(require, module, exports) {
                    window.fixAllPlaceholders = function() {
                        "use strict";
                        function fixAll() {
                            function fix(elements) {
                                for (var i = 0; i < elements.length; ++i)
                                    elements[i].getAttribute("placeholder") || elements[i].setAttribute("placeholder", " ")
                            }
                            window.removeEventListener("load", fixAll), document.removeEventListener("DOMContentLoaded", fixAll), fix(document.getElementsByTagName("input")), fix(document.getElementsByTagName("textarea"))
                        }
                        return window.addEventListener("load", fixAll), document.addEventListener("DOMContentLoaded", fixAll), fixAll
                    }()
                }, {}],3: [function(require, module, exports) {
                    "use strict";
                    var util = require("./util"), Tooltip = require("./tooltip");
                    window.Chart = function($) {
                        function FlotChart(params) {
                            this.id = id_index++, this.$graph = $('<div class="chart"></div>'), this.$element = params.element.addClass("chart-container chart-loading").empty().append(this.$graph).append('<div class="chart-mask">' + LOADING_ICON + "</div>"), this.debounced_check_redraw = util.debounce(200, this.check_redraw.bind(this)), this.dimensions = {}, this.update(params)
                        }
                        var COLOR_RE = /rgb\(\s*\d+\s*,\s*\d+\s*,\s*\d+\s*\)/, LOADING_ICON = '<f-icon class="fa-loading icon-lg"></f-icon>', MIN_HEIGHT = 25, id_index = 1;
                        return FlotChart.prototype.COLORS = {ORANGE: "rgb(237, 194, 64)",BLUE: "rgb(175, 216, 248)",RED: "rgb(203, 75, 75)",GREEN: "rgb(77, 167, 77)",PURPLE: "rgb(148, 64, 237)",DARK_ORANGE: "rgb(189, 183, 107)",ROYAL_BLUE: "rgb(65, 105, 225)",LIGHT_CORAL: "rgb(240, 128, 128)",LIGHT_GREEN: "rgb(144, 238, 144)",VIOLET: "rgb(238, 130, 238)",BROWN: "rgb(165, 42, 42)",GREY: "rgb(105, 105, 105)"}, FlotChart.prototype.DEFAULT_COLORS = Object.keys(FlotChart.prototype.COLORS).map(function(key) {
                            return FlotChart.prototype.COLORS[key]
                        }), FlotChart.prototype.update = function(params, render) {
                            var OPTIONS = {data: void 0,options: {},tooltips: !1,tooltip_formatter: function(label, x, y) {
                                    return label + ": " + y
                                },events: {},legend_container: void 0};
                            if (Object.keys(OPTIONS).forEach(function(key) {
                                this[key] = null != params[key] ? params[key] : OPTIONS[key]
                            }.bind(this)), params.options && !this.options.colors && (this.options.colors = this.DEFAULT_COLORS), this.plot = $.Deferred(), params.legend_container) {
                                var $legend_container = $(params.legend_container);
                                $legend_container.addClass("flot-legend").empty(), this.options.legend = {show: !1}, $.when(this.plot).then(function(plot) {
                                    plot.getData().forEach(function(series) {
                                        var $seriesColor = $("<span>").addClass("legend-series-color").css("background-color", series.color), $series = $("<div>").addClass("legend-series").text(series.label);
                                        $series.prepend($seriesColor), $legend_container.append($series)
                                    })
                                })
                            }
                            render && this.render()
                        }, FlotChart.prototype.render = function() {
                            var previousRender = this._previousRender || (this._previousRender = {}), plot = previousRender.plot, doFullRender = !plot || previousRender.placeholder !== this.$graph || previousRender.options !== this.options, draw = function(data) {
                                var dimensions = this._get_dimensions(), valid = this._check_dimensions_validity(dimensions);
                                if (valid) {
                                    this.$graph.off(), this.is_loading = !1, this.$element.removeClass("chart-loading"), this.tooltips && !this.events.plothover && this._setup_tooltips(), doFullRender ? (plot = $.plot(this.$graph, data, this.options), previousRender.placeholder = this.$graph, previousRender.options = this.options, previousRender.plot = plot) : ((dimensions.width !== this.dimensions.width || dimensions.height !== this.dimensions.height) && plot.resize(), plot.setData(data), plot.setupGrid(), plot.draw()), this.plot.resolve(plot), Object.keys(this.events).forEach(function(key) {
                                        this.$graph.on(key, this.events[key])
                                    }.bind(this)), this.dimensions = dimensions;
                                    var grid = this.options.grid;
                                    grid && grid.clickable && this.$graph.on("plothover", function(event, pos, item) {
                                        this.$graph.toggleClass("clickable", !!item)
                                    }.bind(this))
                                }
                                return valid
                            }.bind(this);
                            this.data && (this.is_loading = !0, this.$element.addClass("chart-loading"), ("function" == typeof this.data.then ? this.data : $.when(this.data)).then(function(data) {
                                draw(data) || setTimeout(function() {
                                    draw(data) || console.log("Failed to render chart due to invalid dimensions")
                                })
                            }.bind(this)))
                        }, FlotChart.prototype.check_redraw = function() {
                            var dimensions = this._get_dimensions(), valid = this._check_dimensions_validity(dimensions), width_changed = dimensions.width !== this.dimensions.width, height_changed = dimensions.height !== this.dimensions.height;
                            valid && (width_changed || height_changed) && this.render()
                        }, FlotChart.prototype.redraw_on_window_resize = function(enable) {
                            var event = "resize.flot_chart" + this.id;
                            enable ? $(window).on(event, function() {
                                this.debounced_check_redraw()
                            }.bind(this)) : $(window).off(event)
                        }, FlotChart.prototype._get_dimensions = function() {
                            return {width: this.$element.width(),height: this.$element.height(),visible: this.$element.is(":visible")}
                        }, FlotChart.prototype._check_dimensions_validity = function(dimensions) {
                            return dimensions.visible && dimensions.width && dimensions.height > MIN_HEIGHT
                        }, FlotChart.prototype._get_tooltip = function() {
                            return this.tooltip || (this.tooltip = new Tooltip(null, this.$element[0], "chart-tooltip")), this.tooltip
                        }, FlotChart.prototype._setup_tooltips = function() {
                            var tooltip = this._get_tooltip();
                            this.options.grid = this.options.grid || {}, this.options.grid.hoverable = !0, this.$graph.on("plothover", function(event, pos, item) {
                                var text, color, div = $("<div></div>");
                                if (item) {
                                    if (text = this.tooltip_formatter(item.series.label, item.datapoint[0], item.series.data[item.dataIndex][1]), !COLOR_RE.test(item.series.color))
                                        throw new Error("Series colors must be in rgb form");
                                    color = item.series.color.slice(0, -1).replace("rgb", "rgba") + ",0.7)", div.css("background-color", color).html(text), tooltip.show(div[0], pos.pageX, pos.pageY)
                                } else
                                    tooltip.hide()
                            }.bind(this))
                        }, FlotChart
                    }(jQuery)
                }, {"./tooltip": 28,"./util": 29}],4: [function(require, module, exports) {
                    "use strict";
                    function detectTextAntialiasing() {
                        function drawDot(ctxt) {
                            ctxt.textBaseline = "top", ctxt.fillStyle = "white", ctxt.fillRect(0, 0, canvas.width, canvas.height), ctxt.fillStyle = "black", ctxt.font = size + "px Arial, monospace", ctxt.fillText(".", -5.5, Math.round(size * -.65) + .5)
                        }
                        function checkPixels(data) {
                            for (var i = 0; i < data.length; i += 4) {
                                if (data[i] < 255 && data[i] > 0) {
                                    var pixel = {r: data[i],g: data[i + 1],b: data[i + 2]};
                                    return pixel.r !== pixel.g || pixel.r !== pixel.b || pixel.b !== pixel.g ? ANTIALIASING.SUBPIXEL : ANTIALIASING.GRAYSCALE
                                }
                                max = data[i] > max ? data[i] : max
                            }
                            return 0 === max ? null : !1
                        }
                        if (document) {
                            var canvas = document.createElement("canvas"), size = 100;
                            canvas.width = .2 * size, canvas.height = .3 * size;
                            var ctxt = canvas.getContext("2d", {alpha: !1});
                            drawDot(ctxt);
                            var pixels = ctxt.getImageData(0, 0, canvas.width, canvas.height), max = 0;
                            return checkPixels(pixels.data)
                        }
                        return null
                    }
                    function check() {
                        if (!document.body)
                            return void setTimeout(check);
                        var aa = detectTextAntialiasing();
                        aa === !1 && (document.body.className += (document.body.className ? " " : "") + TEXT_ANTIALIASING_DISABLED_CLASSNAME)
                    }
                    var ANTIALIASING = {SUBPIXEL: {toString: function() {
                                return "cleartype"
                            }},GRAYSCALE: {toString: function() {
                                return "greyscale"
                            }}}, TEXT_ANTIALIASING_DISABLED_CLASSNAME = "text-antialiasing-disabled";
                    module.exports = {detectTextAntialiasing: detectTextAntialiasing,ANTIALIASING: ANTIALIASING,TEXT_ANTIALIASING_DISABLED_CLASSNAME: TEXT_ANTIALIASING_DISABLED_CLASSNAME}, /\bWindows\b/.test(navigator.userAgent) && check()
                }, {}],5: [function(require, module, exports) {
                    "use strict";
                    module.exports = function(fileInput, options) {
                        function change(event) {
                            if (fileNameElement) {
                                var files = Array.prototype.slice.call(event.target.files), fileNames = files.map(function(f) {
                                    return f.name
                                });
                                fileNames.length ? fileNameElement.innerHTML = fileNames.join("<br>") : fileNameElement.innerHTML = initialLabelHTML
                            }
                        }
                        function dragHandler(event) {
                            function isNot(elem) {
                                return function(e) {
                                    return e !== elem
                                }
                            }
                            function isFile(dataTransferType) {
                                return "files" === dataTransferType.toLowerCase()
                            }
                            var className = fileInput.className.replace(/ *\bdrop-support\b/g, ""), types = event.dataTransfer && event.dataTransfer.types && Array.prototype.slice.call(event.dataTransfer.types), isFileInput = "input" === event.target.tagName.toLowerCase() && "file" === event.target.type;
                            if ("dragover" === event.type) {
                                if (event.target === label) {
                                    var half = {width: label.offsetWidth / 2,height: label.offsetHeight / 2}, halfScaled = {width: half.width * DROP_AREA_SCALE,height: half.height * DROP_AREA_SCALE};
                                    fileInput.style.top = label.offsetTop + half.height - halfScaled.height + "px", fileInput.style.left = label.offsetLeft + half.width - halfScaled.width + "px", fileInput.style.width = label.offsetWidth * DROP_AREA_SCALE + "px", fileInput.style.height = label.offsetHeight * DROP_AREA_SCALE + "px"
                                }
                                !types.some(isFile) || isFileInput && !isBadIE || event.preventDefault()
                            } else
                                "dragenter" === event.type ? (dragElements.push(event.target), (!types || types.some(isFile) && !isBadIE) && (fileInput.className = className + " drop-support")) : "dragleave" === event.type ? dragElements = dragElements.filter(isNot(event.target)) : (dragElements = [], !types.some(isFile) || isFileInput && !isBadIE || event.preventDefault());
                            0 === dragElements.length && (fileInput.className = className)
                        }
                        function defaults(options, default_options) {
                            var result = {};
                            for (var i in default_options)
                                result[i] = i in options ? options[i] : default_options[i];
                            return result
                        }
                        var initialLabelHTML, DEFAULT_OPTIONS = {fileNameLabelTextSelector: "span"}, DRAG_EVENTS = ["dragenter", "dragleave", "drop", "dragover"], DROP_AREA_SCALE = 1.5, fileNameElement = null, doc = fileInput.ownerDocument, label = doc.querySelectorAll('[for="' + fileInput.id + '"]')[0], dragElements = [], isBadIE = !!/(msie [\w.]+|Trident\/[567]\.|Edge\/1\d\.)/i.exec(navigator.userAgent);
                        if (options = defaults(options || {}, DEFAULT_OPTIONS), "string" == typeof options.fileNameLabelTextSelector) {
                            var selector = '[for="' + fileInput.id + '"] ' + options.fileNameLabelTextSelector;
                            fileNameElement = doc.querySelectorAll(selector)[0], initialLabelHTML = fileNameElement.innerHTML
                        }
                        return DRAG_EVENTS.forEach(function(eventType) {
                            doc.body.addEventListener(eventType, dragHandler)
                        }), fileInput.addEventListener("change", change), function() {
                            DRAG_EVENTS.forEach(function(eventType) {
                                doc.body.removeEventListener(eventType, dragHandler)
                            }), fileInput.removeEventListener("change", change), fileNameElement && (fileNameElement.innerHTML = initialLabelHTML)
                        }
                    }
                }, {}],6: [function(require, module, exports) {
                    "use strict";
                    var util = require("./util"), highlightMatchesInElement = module.exports.highlightMatchesInElement = function(element, searchValue, caseInsensitive) {
                        var regexp = new RegExp(util.preRegexEscape(searchValue), caseInsensitive ? "i" : void 0), highlight = function(node) {
                            for (var currentValue, matchIndex, textNode, mark, text, currentIndex = 0, nodeValue = node.nodeValue, previousMatches = !1; ; ) {
                                if (currentValue = nodeValue.substr(currentIndex), matchIndex = currentValue.search(regexp), 0 > matchIndex) {
                                    if (!previousMatches)
                                        break;
                                    currentValue && (textNode = document.createTextNode(currentValue), node.parentNode.insertBefore(textNode, node)), node.parentNode.removeChild(node);
                                    break
                                }
                                matchIndex > 0 && (text = currentValue.substr(0, matchIndex), textNode = document.createTextNode(text), node.parentNode.insertBefore(textNode, node)), text = currentValue.substr(matchIndex, searchValue.length), mark = document.createElement("mark"), mark.appendChild(document.createTextNode(text)), node.parentNode.insertBefore(mark, node), currentIndex += matchIndex + searchValue.length, previousMatches = !0
                            }
                        }, traverseTextNodes = function(node) {
                            var childNodes;
                            node && (childNodes = Array.prototype.slice.call(node.childNodes), childNodes.forEach(function(childNode) {
                                childNode.nodeType === Node.TEXT_NODE ? highlight(childNode) : childNode.nodeType === Node.ELEMENT_NODE && traverseTextNodes(childNode)
                            }))
                        };
                        traverseTextNodes(element)
                    };
                    module.exports.highlightMatchesInHTML = function(html, searchValue, caseInsensitive) {
                        var element = document.createElement("div");
                        return element.innerHTML = html, highlightMatchesInElement(element, searchValue, caseInsensitive), element.innerHTML
                    }
                }, {"./util": 29}],7: [function(require, module, exports) {
                    "use strict";
                    var $ = jQuery, COMMANDS = {DISPOSE: "dispose"}, enhanceFileInput = require("../enhance-file-input");
                    module.exports = $.fn.fEnhanceFileInput = function(command) {
                        var DISPOSE_KEY = "fEnhanceFileInputDispose";
                        return command === COMMANDS.DISPOSE ? void this.each(function(i, elem) {
                            var dispose = $(elem).data(DISPOSE_KEY);
                            dispose && "function" == typeof dispose && dispose()
                        }) : void this.each(function(i, elem) {
                            if ("input" === elem.tagName.toLowerCase() && "file" === elem.type) {
                                var dispose = enhanceFileInput(elem);
                                $(elem).data(DISPOSE_KEY, dispose)
                            }
                        })
                    }, $.fn.fEnhanceFileInput.COMMANDS = COMMANDS
                }, {"../enhance-file-input": 5}],8: [function(require, module, exports) {
                    "use strict";
                    function memo(arr, section, forget) {
                        var index = arr.indexOf(section), present = index > -1;
                        return present && forget ? arr.splice(index, 1) : present || forget || arr.push(section), present
                    }
                    var $ = jQuery, debounce_retry = [], debouncing_sections = [];
                    module.exports = $.fn.fixDialogLabelWidth = function(debounce) {
                        function swapAll(elements, options, callback) {
                            var ret, old = elements.map(function(e) {
                                var name, result = {};
                                for (name in options)
                                    result[name] = e.style[name], e.style[name] = options[name];
                                return {old: result,element: e}
                            });
                            return ret = callback(), old.forEach(function(pair) {
                                var name;
                                for (name in options)
                                    pair.element.style[name] = pair.old[name]
                            }), ret
                        }
                        var sections = [], fields = {};
                        (void 0 === debounce || debounce === !0) && (debounce = 0), this.each(function(i, elem) {
                            var section = $(this).closest("section")[0], found = sections.indexOf(section);
                            -1 === found && (found = sections.length, sections.push(section)), fields[found] = fields[found] || [], fields[found].push(elem)
                        }), sections.forEach(function(section) {
                            var $section = $(section);
                            if (debounce !== !1) {
                                var debouncing = memo(debouncing_sections, section);
                                if (debouncing)
                                    return void memo(debounce_retry, section);
                                setTimeout(function() {
                                    memo(debouncing_sections, section, !0), memo(debounce_retry, section, !0) && $section.fixDialogLabelWidth(debounce)
                                }, debounce)
                            }
                            var height = $section.outerHeight();
                            $.swap($section[0], {"min-height": height + "px"}, function() {
                                var $labels = $section.addClass("specify-label-width").find(".field").filter(":visible").addClass("specify-label-width").children("label:first-child").filter(":visible"), labels = $labels.toArray(), props = {"min-width": "",position: "absolute"}, maxWidth = swapAll(labels, props, function() {
                                    return labels.reduce(function(max, elem) {
                                        return Math.max(max, elem.offsetWidth)
                                    }, 0)
                                });
                                $labels.css("min-width", maxWidth)
                            })
                        })
                    }
                }, {}],9: [function(require, module, exports) {
                    "use strict";
                    require("./pin-top"), require("./fix-dialog-label-width"), require("./select"), require("./tabs"), require("./enhance-file-input")
                }, {"./enhance-file-input": 7,"./fix-dialog-label-width": 8,"./pin-top": 10,"./select": 11,"./tabs": 12}],10: [function(require, module, exports) {
                    "use strict";
                    function updateHandler(event) {
                        function reMeasureTop(elem) {
                            var $elem = $(elem.elem);
                            measure($elem, function() {
                                elem.top = $elem.offset().top
                            })
                        }
                        function measure($elem, cb) {
                            $elem.removeClass(PINNED_CLASSES).addClass(PIN_MEASURE), $elem.css({width: "",top: ""}), cb(), $elem.removeClass(PIN_MEASURE)
                        }
                        function getOtherHeight(otherPinned) {
                            var otherHeights = {};
                            return otherPinned.forEach(function(other) {
                                otherHeights[other.pinClass] = other.fullHeight
                            }), Object.keys(otherHeights).reduce(function(result, key) {
                                return otherHeights[key] + result
                            }, 0)
                        }
                        function not(fn) {
                            return function(v) {
                                return !fn(v)
                            }
                        }
                        function notMe(elem) {
                            return function(other) {
                                return elem !== other
                            }
                        }
                        function hasPinClass(pinClass) {
                            return function(elem) {
                                return elem.pinClass === pinClass
                            }
                        }
                        function byTop(a, b) {
                            return a.top - b.top
                        }
                        var pinnedTop = [];
                        scrollContainers.forEach(function(sc, i) {
                            "tab-selected" === event.type && pinnedElements[i].forEach(reMeasureTop);
                            var $sc = $(sc), scOffset = $sc.offset(), scTop = scOffset ? scOffset.top : 0, sorted = pinnedElements[i].slice().sort(byTop);
                            sorted.forEach(function(elem) {
                                var $elem = $(elem.elem);
                                if (measure($elem, function() {
                                    elem.top = $elem.offset().top, elem.fullHeight = $elem.outerHeight(!0), elem.height = $elem.outerHeight(), elem.bottom = elem.top + elem.height, elem.width = $elem.width()
                                }), $elem.is(":visible") && !$elem.closest(".tab-hidden").length) {
                                    var pinDistance = elem.top - scTop, classPinned = pinnedTop.filter(hasPinClass(elem.pinClass)).filter(notMe(elem)), otherPinned = pinnedTop.filter(not(hasPinClass(elem.pinClass))), otherHeight = getOtherHeight(otherPinned, elem);
                                    otherHeight > pinDistance ? ($elem.css({width: elem.width,top: $sc.offset().top + otherHeight}), elem.$placeholder = elem.$placeholder || $("<div>", {addClass: PLACEHOLDER_CLASS}), elem.$placeholder.height(elem.fullHeight), $elem.after(elem.$placeholder), $elem.addClass(PINNED_CLASS), pinnedTop.push(elem)) : elem.$placeholder && elem.$placeholder.remove();
                                    var classNeighbour = classPinned[classPinned.length - 1];
                                    if (classNeighbour && pinDistance < classNeighbour.height + otherHeight) {
                                        var top = elem.top - scTop + sc.scrollTop;
                                        classPinned.slice().reverse().forEach(function(other) {
                                            var absTop = sc.scrollTop + other.$absParent.offset().top;
                                            $(other.elem).addClass(PINNED_OUT_CLASS).css("top", top - absTop), top -= other.fullHeight
                                        })
                                    }
                                }
                            })
                        })
                    }
                    function absParent(elem) {
                        return $(elem).parents().filter(function() {
                            return /(relative|absolute|fixed)/.test($.css(this, "position"))
                        }).first()
                    }
                    var pinnedElements, $ = jQuery, PLUGIN_CLASS = "pin-top", PINNED_CLASS = "pinned", PINNED_OUT_CLASS = "pinned-out", PINNED_CLASSES = "pinned-out pinned", PIN_MEASURE = "pin-measure", PLACEHOLDER_CLASS = "pinned-placeholder", ui_shims = require("./ui-shims"), scrollContainers = [];
                    module.exports = $.fn.pinTop = function(pinClass) {
                        return this.each(function(i, elem) {
                            var $elem = $(elem);
                            if ($elem.hasClass(PLUGIN_CLASS))
                                return !0;
                            $elem.addClass(PLUGIN_CLASS), pinnedElements || (pinnedElements = [], $(window).resize(updateHandler));
                            var $scrollContainer = ui_shims.scrollParent($elem), containerIndex = scrollContainers.indexOf($scrollContainer[0]);
                            if (-1 === containerIndex && (containerIndex = scrollContainers.length, pinnedElements[containerIndex] = [], scrollContainers.push($scrollContainer[0]), $scrollContainer.scroll(updateHandler), $scrollContainer.on("pin-top tab-selected", updateHandler)), -1 === pinnedElements[containerIndex].indexOf(elem)) {
                                var overrideClass = elem.getAttribute("data-pin-class");
                                pinnedElements[containerIndex].push({elem: elem,pinClass: overrideClass || pinClass,$absParent: absParent(elem)})
                            }
                        }), this
                    }
                }, {"./ui-shims": 13}],11: [function(require, module, exports) {
                    "use strict";
                    var $ = jQuery, DATA_ATTRIBUTE = "select-instance", SELECT_ATTRIBUTE = "data-select-widget", COMMANDS = {ENABLE: "enable",DISABLE: "disable",RELOAD: "reload",REPROCESS: "reprocess",GET_INSTANCE: "getInstance"};
                    $.fn.omniselect = function(argument) {
                        if ("string" == typeof argument && 0 === this.length)
                            throw new Error("Cannot send omniselect commands to an empty jQuery collection");
                        var result;
                        return this.each(function(i, elem) {
                            var selected, settings, $elem = $(elem), selectedString = $elem.val(), selectInstance = $elem.data(DATA_ATTRIBUTE), validate = function() {
                                var validator = $elem.closest("form").data("validator");
                                validator && validator.element($elem[0])
                            };
                            if (selectInstance && "string" == typeof argument) {
                                if (argument === COMMANDS.ENABLE)
                                    selectInstance.disable(!1);
                                else if (argument === COMMANDS.DISABLE)
                                    selectInstance.disable(!0);
                                else if (argument === COMMANDS.RELOAD)
                                    selectInstance.update({reload: !0});
                                else if (argument === COMMANDS.REPROCESS)
                                    selectInstance.update({reProcess: !0});
                                else if (argument === COMMANDS.GET_INSTANCE) {
                                    if (i > 0)
                                        throw new Error(COMMANDS.GET_INSTANCE + " command is not valid when the jQuery collection contains more than one element");
                                    result = selectInstance
                                }
                            } else
                                settings = argument, selectedString || (selectedString = settings.singleSelect ? "null" : "[]", $elem.val(selectedString)), selected = JSON.parse(selectedString), selectInstance ? selectInstance.update({settings: settings,selected: selected}) : ($elem.removeAttr("maxLength"), selectInstance = new Omniselect({includeInput: !0,settings: settings,selected: selected,changeCallback: function(updated) {
                                        selectedString = JSON.stringify(updated), $elem.val(selectedString).change(), $.fn.validate && validate()
                                    }}), $elem.prop("disabled") && selectInstance.disable(!0), $elem.data(DATA_ATTRIBUTE, selectInstance).attr(SELECT_ATTRIBUTE, "true").addClass("hidden"), selectInstance.$element.insertBefore($elem))
                        }), result || this
                    }
                }, {}],12: [function(require, module, exports) {
                    "use strict";
                    var $ = jQuery;
                    module.exports = $.fn.fTabs = function() {
                        function update() {
                            function getSelectors(e) {
                                return e.getAttribute("data-tab-content")
                            }
                            var offSelectors, $triggerSelected = null;
                            if (this) {
                                var $this = $(this);
                                $triggerSelected = $this, $this.addClass("selected");
                                var $selected = $tabs.not(this).filter(".selected");
                                $selected.removeClass("selected"), offSelectors = $selected.toArray().map(getSelectors).join(",")
                            }
                            var onSelectors = $tabs.filter(".selected").toArray().map(getSelectors).join(",");
                            offSelectors = offSelectors || $tabs.not(".selected").toArray().map(getSelectors).join(",");
                            var evts = "focus.tab-content invalid.tab-content";
                            $(offSelectors).toggleClass("tab-hidden", !0).off(".tab-content").on(evts, "input, select, button", function(event, data) {
                                for (var i = 0; i < $tabs.length; ++i) {
                                    var tab = $tabs[i];
                                    if ($(this).parents(getSelectors(tab)).length) {
                                        if ("invalid" === event.type && ($(tab).toggleClass("error", data !== !1), data === !1))
                                            continue;
                                        update.call(tab);
                                        break
                                    }
                                }
                            }), $(onSelectors).toggleClass("tab-hidden", !1).off(".tab-content"), $triggerSelected && $triggerSelected.trigger("tab-selected")
                        }
                        var $tabs = this.find("[data-tab-content]").click(update), $selected = $tabs.filter(".selected");
                        return $selected.length || $tabs.first().addClass("selected"), update(), {valid: function() {
                                $tabs.removeClass("error")
                            }}
                    }
                }, {}],13: [function(require, module, exports) {
                    "use strict";
                    function scrollParent($elem) {
                        var result, ui_ie = !!/msie [\w.]+/.exec(navigator.userAgent.toLowerCase());
                        return result = ui_ie && /(static|relative)/.test($elem.css("position")) || /absolute/.test($elem.css("position")) ? $elem.parents().filter(function() {
                            return /(relative|absolute|fixed)/.test($.css(this, "position")) && /(auto|scroll)/.test($.css(this, "overflow") + $.css(this, "overflow-y") + $.css(this, "overflow-x"))
                        }).eq(0) : $elem.parents().filter(function() {
                            return /(auto|scroll)/.test($.css(this, "overflow") + $.css(this, "overflow-y") + $.css(this, "overflow-x"))
                        }).eq(0), /fixed/.test($elem.css("position")) || !result.length ? $(document) : result
                    }
                    module.exports = {scrollParent: scrollParent};
                    var $ = jQuery
                }, {}],14: [function(require, module, exports) {
                    "use strict";
                    function Mask(className, target) {
                        this._className = className, this._visibleFor = {}, this._extraClasses = {}, this.updateTarget(target)
                    }
                    var $ = jQuery, BASE_CLASS = "base-mask", CLICK_EVENTS = ["click", "contextemenu"];
                    Mask.prototype._getMask = function() {
                        return this._$mask || (this._$mask = $("<div></div>").addClass(BASE_CLASS + " " + this._className).on(CLICK_EVENTS.join(" "), function(event) {
                            event.stopPropagation()
                        })), this._$mask
                    }, Mask.prototype._getClickEventString = function(id) {
                        return CLICK_EVENTS.map(function(eventString) {
                            return eventString + "." + id
                        }).join(" ")
                    }, Mask.prototype.updateTarget = function(target) {
                        this._target = target || "body", Object.keys(this._visibleFor).length > 0 && this._$mask.detach().appendTo(this._target)
                    }, Mask.prototype.display = function(id, extraClass) {
                        var $mask = this._getMask();
                        $mask.parent().length || ($mask.appendTo(this._target), extraClass && ($mask.addClass(extraClass), this._extraClasses[extraClass] ? this._extraClasses[extraClass].push(id) : this._extraClasses[extraClass] = [id])), this._visibleFor[id] = extraClass || !0
                    }, Mask.prototype.displayAndListen = function(id, callback, extraClass) {
                        var $mask = this._getMask(), clickEvent = this._getClickEventString(id);
                        this.display(id, extraClass), $mask.off(clickEvent).on(clickEvent, function() {
                            this.hide(id), callback()
                        }.bind(this))
                    }, Mask.prototype.hide = function(id) {
                        var $mask, classVisibleFor, visibleClass = this._visibleFor[id];
                        null != visibleClass && ($mask = this._getMask(), $mask.off(this._getClickEventString(id)), "string" == typeof visibleClass && (classVisibleFor = this._extraClasses[visibleClass], 1 === classVisibleFor.length ? (delete this._extraClasses[visibleClass], $mask.removeClass(visibleClass)) : classVisibleFor.splice(classVisibleFor.indexOf(id), 1)), delete this._visibleFor[id], 0 === Object.keys(this._visibleFor).length && $mask.remove())
                    }, module.exports = Mask
                }, {}],15: [function(require, module, exports) {
                    "use strict";
                    var util = require("./util"), $ = jQuery, LEVEL = module.exports.LEVEL = {INFO: "info",SUCCESS: "success",WARNING: "warning",ERROR: "error"}, DURATIONS = {};
                    DURATIONS[LEVEL.INFO] = 5e3, DURATIONS[LEVEL.SUCCESS] = 3e3, DURATIONS[LEVEL.WARNING] = 0, DURATIONS[LEVEL.ERROR] = 0;
                    var getContainer = function() {
                        var $body, $container;
                        return function() {
                            return $body || ($body = $("body")), $container || ($container = $('<div class="notify-messages"></div>').appendTo($body)), $container
                        }
                    }();
                    module.exports.post = function(message, level, duration) {
                        var $elem, $buttonContainer, remove = function() {
                            $elem.addClass("fade-out").one(util.CROSS_BROWSER_ANIMATION_END, function() {
                                $elem.remove()
                            })
                        };
                        level = level || LEVEL.INFO, duration = "number" == typeof duration ? duration : DURATIONS[level], $elem = $('<div class="' + level + '-notify-message"></div>'), $('<div class="notify-message-container"></div>').append('<f-icon class="fa-' + level + '"></f-icon>').append('<div class="notify-message-content">' + message + "</div>").appendTo($elem), $buttonContainer = $('<div class="notify-button-container"></div>').appendTo($elem), $('<button type="button" class="bare"><f-icon class="fa-dismiss"></f-icon></button').on("click", remove).appendTo($buttonContainer), getContainer().prepend($elem), duration && setTimeout(remove, duration)
                    }
                }, {"./util": 29}],16: [function(require, module, exports) {
                    "use strict";
                    function Drag() {
                        this._$body = $("body")
                    }
                    var $ = jQuery, START_EVENT = "selectEntryDragStart", END_EVENT = "selectEntryDragEnd", DATA_TYPE = "select-entry";
                    Drag.prototype.notifyStart = function(entry) {
                        this._entry = entry, $("body").trigger(START_EVENT)
                    }, Drag.prototype.notifyEnd = function() {
                        $("body").trigger(END_EVENT)
                    }, Drag.prototype.setData = function(dataTransfer, data) {
                        try {
                            dataTransfer.setData(DATA_TYPE, data)
                        } catch (e) {
                            dataTransfer.setData("text", data)
                        }
                    }, Drag.prototype.supportedType = function(dataTransfer) {
                        var supported = !0;
                        try {
                            supported = dataTransfer.types.indexOf(DATA_TYPE) >= 0
                        } catch (e) {
                        }
                        return supported
                    }, Drag.prototype.onDrag = function(id, startFn, endFn) {
                        var $body = $("body");
                        $body.on(START_EVENT + "." + id, function() {
                            startFn(this._entry)
                        }.bind(this)), $body.on(END_EVENT + "." + id, endFn)
                    }, Drag.prototype.off = function(id) {
                        var $body = $("body");
                        $body.off(START_EVENT + "." + id), $body.off(END_EVENT + "." + id)
                    }, module.exports = new Drag
                }, {}],17: [function(require, module, exports) {
                    "use strict";
                    function Dropdown(select, sources, selected) {
                        VirtualResults.call(this, select, sources, selected), this._id = util.uniqueID(), this._searchInput = new SearchInput(select), this._create(), this.isOpen = !1
                    }
                    var $ = jQuery, util = require("../util"), Mask = require("../mask"), VirtualResults = require("./virtual-results"), SearchInput = require("./search-input"), Sliderin = require("../slide/slide"), RESIZE_EVENT = "resize.selectionDropdown", IS_FIREFOX = /firefox/i.test(navigator.userAgent);
                    Dropdown.prototype = Object.create(VirtualResults.prototype), Dropdown.prototype.constructor = Dropdown, Dropdown.prototype.open = function() {
                        var target, mask, slide, $selectElement = this._select.$element, selectElementOffset = $selectElement.offset(), insideSlide = this._select._settings.insideSlide, borderAdjust = IS_FIREFOX ? 2 : 1;
                        if (insideSlide) {
                            if (this.TARGET_WINDOW = Sliderin.TARGET_WINDOW, slide = Sliderin.getLast(), !slide)
                                throw new Error('"insideSlide" specified but no slide could be found');
                            slide.addDestructible(this._select)
                        }
                        target = this.TARGET_WINDOW.document.body, mask = this._getMask(target), this._$element.width($selectElement[0].clientWidth), this._$element.css({top: selectElementOffset.top + $selectElement[0].offsetHeight - borderAdjust,left: selectElementOffset.left}), this._select._toggleFocus(!0), this._$element.appendTo(target), this._sourcesLoaded ? this._entries ? this.renderResults() : this.updateResults() : (this._calculateScrollingDimensions(), this.loadSources(function() {
                            this.updateResults()
                        }.bind(this))), this.isOpen = !0, mask.displayAndListen(this._id, function() {
                            this.close()
                        }.bind(this), insideSlide ? "inside-slide" : null), $(window).on(RESIZE_EVENT + this._id, util.debounce(300, function() {
                            this._sourcesLoaded && this.resizeResults()
                        }.bind(this)))
                    }, Dropdown.prototype.close = function() {
                        var mask = this._getMask();
                        mask && mask.hide(this._id), $(window).off(RESIZE_EVENT + this._id), this._select._toggleFocus(!1), this.isOpen = !1, this._$element.detach()
                    }, Dropdown.prototype.toggleInputs = function(enable) {
                        this._$createNew.attr("disabled", !enable), this._$sourceSelection && this._$sourceSelection.find("input").attr("disabled", !enable), enable ? focus ? this._searchInput.enableAndFocus() : this._searchInput.enable() : this._searchInput.disable()
                    }, Dropdown.prototype.destroy = function() {
                        VirtualResults.prototype.destroy.call(this), this.close(), this._$element.empty().remove()
                    }, Dropdown.prototype._getMask = function(target) {
                        var mask = this._mask;
                        return mask || (this._mask = mask = new Mask("selection-dropdown-mask", target)), mask
                    }, Dropdown.prototype._create = function() {
                        var sourcesGrouping = this._sources.getGrouping(), sourceGroups = Object.keys(sourcesGrouping), $searchContainer = $('<div class="select-widget-search-container"></div>');
                        if (this._$element = $('<div class="selection-dropdown"></div>'), this._select._settings.insideSlide && this._$element.addClass("inside-slide"), this._$createNew = $('<button type="button" class="create-new hidden" title="' + this._select.CREATE_NEW_TEXT + '"><f-icon class="fa-plus"></f-icon></button>'), this.setGroup(sourceGroups[0]), this._$sourceSelection = null, sourceGroups.length > 1) {
                            this._$sourceSelection = $('<div class="radio-group"></div>'), sourceGroups.forEach(function(groupName, index) {
                                var id = groupName + this._id, name = "selectionDropdown" + this._id, $input = $('<input type="radio" id="' + id + '" name="' + name + '" value="' + groupName + '">').attr("disabled", "disabled");
                                0 === index && $input.prop("checked", !0), this._$sourceSelection.append($input), this._$sourceSelection.append('<label for="' + id + '">' + groupName + "</label>")
                            }.bind(this)), this._$sourceSelection.appendTo(this._$element);
                            var that = this;
                            this._$sourceSelection.find("input").on("change", function() {
                                that.setGroup(this.value), that._$createNew.toggleClass("hidden", 0 === sourcesGrouping[this.value].createNewSupported.length), that.updateResults()
                            })
                        }
                        $searchContainer.append(this._searchInput.$element).append(this._$createNew), this._$element.append($searchContainer), sourcesGrouping[sourceGroups[0]].createNewSupported.length && this._$createNew.removeClass("hidden"), this._$createNew.on("click", function() {
                            this.createNew()
                        }.bind(this)), this._searchInput.onChange(function(value) {
                            this.setSearchValue(value), this.updateResults()
                        }.bind(this)), this._$element.append(this.resultsElement)
                    }, Dropdown.prototype._afterAdd = function() {
                        this._tooltip && this._tooltip.hide(), this.close()
                    }, Dropdown.prototype._afterChunkRendered = function(noEntries) {
                        this._$createNew.toggleClass("primary", noEntries)
                    }, module.exports = Dropdown
                }, {"../mask": 14,"../slide/slide": 26,"../util": 29,"./search-input": 19,"./virtual-results": 24}],18: [function(require, module, exports) {
                    "use strict";
                    window.Omniselect = require("./select")
                }, {"./select": 20}],19: [function(require, module, exports) {
                    "use strict";
                    function SearchInput(select) {
                        this._$search = $('<input disabled="disabled" type="text">').attr("placeholder", select.SEARCH_PLACEHOLDER), this._$clearSearch = $('<f-icon class="fa-dismiss clear-search hidden"></f-icon>').attr("title", select.CLEAR_SEARCH_TITLE).on("click", function() {
                            this._$clearSearch.is(".disabled") || (this._$search.val(""), this._changeCallback(""), this._$clearSearch.addClass("hidden"), this._previousValue = "")
                        }.bind(this)), this.$element = $('<div class="select-widget-search"></div>').append(this._$search).append('<f-icon class="fa-search search-indicator"></f-icon>').append(this._$clearSearch), this._previousValue = ""
                    }
                    var $ = jQuery, util = require("../util"), SEARCH_DEBOUNCE = 500;
                    SearchInput.prototype.onChange = function(callback) {
                        this._changeCallback = callback, this._$search[0].oninput = util.debounce(SEARCH_DEBOUNCE, function() {
                            var searchValue = this.getValue();
                            searchValue !== this._previousValue && (this._$clearSearch.toggleClass("hidden", !searchValue), callback(searchValue), this._previousValue = searchValue)
                        }.bind(this))
                    }, SearchInput.prototype.getValue = function() {
                        return this._$search.val()
                    }, SearchInput.prototype.enable = function() {
                        [this._$search, this._$clearSearch].forEach(function($element) {
                            $element.attr("disabled", !1).toggleClass("disabled", !1)
                        })
                    }, SearchInput.prototype.enableAndFocus = function() {
                        this.enable(), this._$search.focus()
                    }, SearchInput.prototype.disable = function() {
                        [this._$search, this._$clearSearch].forEach(function($element) {
                            $element.attr("disabled", !0).toggleClass("disabled", !0)
                        })
                    }, module.exports = SearchInput
                }, {"../util": 29}],20: [function(require, module, exports) {
                    "use strict";
                    function Select(params) {
                        this._id = util.uniqueID(), this._includeInput = params.includeInput, this._onChangeCallback = params.changeCallback, this._includeInput && this._createElement(), this.update(params), this._setupSourceChangeListener()
                    }
                    var $ = jQuery, Sources = require("./sources"), SelectionPane = require("./selection-pane"), Dropdown = require("./dropdown"), util = require("../util"), selectUtil = require("./util"), drag = require("./drag");
                    Select.drag = drag, Select.prototype.ENTRY_ID_KEY = null, Select.prototype.ENTRY_SOURCE_ID_FUNCTION = function(entry) {
                        return String(entry)
                    }, Select.prototype.SOLITARY_KEY = "solitaryEntry", Select.prototype.PANE_TITLE = "Select Entries", Select.prototype.SEARCH_PLACEHOLDER = "Search", Select.prototype.CLEAR_SEARCH_TITLE = "Clear Search", Select.prototype.NO_ENTRIES_TEXT = "No entries", Select.prototype.PROCESSING_TEXT = "Processing", Select.prototype.CLOSE_TEXT = "Close", Select.prototype.OK_TEXT = "OK", Select.prototype.CANCEL_TEXT = "Cancel", Select.prototype.CREATE_NEW_TEXT = "Create New", Select.prototype.RETURN_TITLE = "Return", Select.prototype.MIN_SINGLE_SELECT_RESULTS_HEIGHT = 50, Select.prototype.MAX_SINGLE_SELECT_RESULTS_HEIGHT = 300, Select.prototype.MAX_SYNCHRONOUS_PROCESSING_LENGTH = 1e4, Select.NOTIFY_SOURCE_CHANGED_IFRAMES = !1, Select.NOTIFY_SOURCE_CHANGED_MESSAGE = "selectSourceChanged", Select.prototype.SOLITARY_LEVEL = {SOURCE: "source",GROUP: "group",ALL: "all"}, Select.prototype.DEFAULT_SETTINGS = {allSolitary: !1,compactWidget: !1,createNew: !0,collapsibleCategories: !0,dragAndDrop: !0,extraData: null,filterFunction: null,formatFunction: null,insideSlide: !1,max: null,meta: null,preProcessSelected: null,singleSelect: !1,solitaryLevel: Select.prototype.SOLITARY_LEVEL.GROUP,sortCategories: !1,sortCreateNew: !0,sortFunction: null,sortResults: !0,sortWidget: !0,subcategories: !0,subcategoryValueFunction: null,subcategoryFormatFunction: null,subcategorySortFunction: null,tooltips: !0,validateFunction: null,valueFunction: null}, Select.prototype.DEFAULT_VALUE_FUNCTION = function(entry) {
                        return String(entry)
                    }, Select.prototype.DEFAULT_FORMAT_FUNCTION = function(entry, value) {
                        return value
                    }, Select.prototype.DEFAULT_CATEGORY_FORMAT_FUNCTION = function(name, count) {
                        return name + " (" + count.toLocaleString() + ")"
                    }, Select.prototype.DEFAULT_SOURCE_SORT_FUNCTION = util.fastLocaleCompare, Select.prototype.DEFAULT_SUBCATEGORY_VALUE_FUNCTION = function() {
                        return "Unknown Subcategory"
                    }, Select.prototype.DEFAULT_SUBCATEGORY_FORMAT_FUNCTION = function(subcategoryValue, count) {
                        return subcategoryValue + " (" + count.toLocaleString() + ")"
                    }, Select.prototype.DEFAULT_SUBCATEGORY_SORT_FUNCTION = util.fastLocaleCompare, Select.prototype.DEFAULT_CREATE_NEW_FUNCTION = function() {
                    }, Select.prototype.SOURCES = {}, Select.notifySourceChanged = function(sourceID) {
                        var notify = function(targetWindow) {
                            var i, frames, origin = util.getOrigin(targetWindow);
                            if (targetWindow.postMessage({messageType: Select.NOTIFY_SOURCE_CHANGED_MESSAGE,sourceID: sourceID}, origin), Sources.invalidateCacheForSource(sourceID), Select.NOTIFY_SOURCE_CHANGED_IFRAMES)
                                for (frames = targetWindow.document.getElementsByTagName("iframe"), i = 0; i < frames.length; i++)
                                    try {
                                        notify(frames[i].contentWindow)
                                    } catch (e) {
                                    }
                        }, notifyWindow = window;
                        Select.NOTIFY_SOURCE_CHANGED_IFRAMES && top !== window && (notifyWindow = top), notify(notifyWindow)
                    }, Select._SHARED_INSTANCE_CACHE = {}, Select.invalidateCache = function() {
                        Object.keys(Select._SHARED_INSTANCE_CACHE).forEach(function(sourceID) {
                            Select._SHARED_INSTANCE_CACHE[sourceID].destroy()
                        }), Select._SHARED_INSTANCE_CACHE = {}, Sources.invalidateCache()
                    }, Select.invalidateCacheForSource = function(sourceID) {
                        Select._SHARED_INSTANCE_CACHE[sourceID] && (Select._SHARED_INSTANCE_CACHE[sourceID].destroy(), delete Select._SHARED_INSTANCE_CACHE[sourceID]), Sources.invalidateCacheForSource(sourceID)
                    }, Select._getCachedInstanceForSource = function(sourceID) {
                        var instance, source = Select.prototype.SOURCES[sourceID];
                        if (!source)
                            throw new Error('Source "' + sourceID + '" is not configured');
                        return instance = Select._SHARED_INSTANCE_CACHE[sourceID] ? Select._SHARED_INSTANCE_CACHE[sourceID] : Select._SHARED_INSTANCE_CACHE[sourceID] = new Select({settings: {sources: sourceID},selected: [],sharedInstance: !0})
                    }, Select._getEntryIDAndSourceIDForEntry = function(entry, sourceID) {
                        var entryID = entry[Select.prototype.ENTRY_ID_KEY];
                        if (!entryID)
                            throw new Error("Could not determine entry ID");
                        if (sourceID = sourceID || Select.prototype.ENTRY_SOURCE_ID_FUNCTION(entry), !sourceID)
                            throw new Error("Could not determine source for entry");
                        return {entryID: entryID,sourceID: sourceID}
                    }, Select.getSourceData = function(sourceID) {
                        var instance = Select._getCachedInstanceForSource(sourceID);
                        return instance._sources.load().then(function() {
                            return instance.getSourceResults(sourceID)
                        })
                    }, Select.getSourceDataSync = function(sourceID) {
                        var instance = Select._getCachedInstanceForSource(sourceID);
                        return instance.getSourceResults(sourceID)
                    }, Select.formatEntry = function(entry, sourceID) {
                        var instance, ids = Select._getEntryIDAndSourceIDForEntry(entry, sourceID);
                        return instance = Select._getCachedInstanceForSource(ids.sourceID), instance._sources.formatEntry(entry)
                    }, Select.processedFormatEntry = function(entry, sourceID) {
                        var ids = Select._getEntryIDAndSourceIDForEntry(entry, sourceID), instance = Select._getCachedInstanceForSource(ids.sourceID);
                        return instance._sources.load().then(function() {
                            var resultsMapping = instance.getSourceResults(ids.sourceID).mapping, sourceEntry = resultsMapping[ids.entryID];
                            return instance._sources.formatEntry(sourceEntry)
                        })
                    }, Select.processedFormatEntrySync = function(entry, sourceID) {
                        var ids = Select._getEntryIDAndSourceIDForEntry(entry, sourceID), instance = Select._getCachedInstanceForSource(ids.sourceID), resultsMapping = instance.getSourceResults(ids.sourceID).mapping, sourceEntry = resultsMapping[ids.entryID];
                        return instance._sources.formatEntry(sourceEntry)
                    }, Select.formatEntryTooltip = function(entry, sourceID) {
                        var ids = Select._getEntryIDAndSourceIDForEntry(entry, sourceID), instance = Select._getCachedInstanceForSource(ids.sourceID);
                        return instance._sources.load().then(function() {
                            var resultsMapping = instance.getSourceResults(ids.sourceID).mapping, sourceEntry = resultsMapping[ids.entryID];
                            return instance._sources.formatEntryTooltip(sourceEntry)
                        })
                    }, Select.formatEntryTooltipSync = function(entry, sourceID) {
                        var ids = Select._getEntryIDAndSourceIDForEntry(entry, sourceID), instance = Select._getCachedInstanceForSource(ids.sourceID), resultsMapping = instance.getSourceResults(ids.sourceID).mapping, sourceEntry = resultsMapping[ids.entryID];
                        return instance._sources.formatEntryTooltip(sourceEntry)
                    }, Select.queryMatchesEntrySync = function(searchQuery, entry, sourceID) {
                        var ids = Select._getEntryIDAndSourceIDForEntry(entry, sourceID), instance = Select._getCachedInstanceForSource(ids.sourceID), resultsMapping = instance.getSourceResults(ids.sourceID).mapping, sourceEntry = resultsMapping[ids.entryID], checker = instance._sources.getSearchMatchChecker(ids.sourceID), searchRegex = new RegExp(util.preRegexEscape(searchQuery), "i");
                        return checker(sourceEntry, searchRegex, searchQuery).matchType !== instance._sources.SEARCH_MATCH_TYPE.NONE
                    }, Select.prototype.update = function(params) {
                        params = params || {};
                        var selected, selectedProvided = void 0 !== params.selected, copy = function(items) {
                            return Array.isArray(items) ? items.slice() : items
                        };
                        selected = copy(selectedProvided ? params.selected : this._selected), this.removeAll(), this._selected = Array.isArray(selected) ? [] : null, this._sharedInstance = params.sharedInstance, params.settings ? (this._settings = $.extend({}, this.DEFAULT_SETTINGS, params.settings), this._sources = new Sources(this), this._selectionChooser && this._selectionChooser.destroy(), this._createSelectionChooser(selected), this._includeInput && this.configurationDependentSetup()) : this._selectionChooser && (this._selectionChooser.updateSelected(selected, params.reProcess, params.reload), this._selectionChooser.isOpen && (params.reProcess || params.reload ? this._selectionChooser.updateResults() : this._selectionChooser.renderResults())), this._updateAddPlaceholderVisibility()
                    }, Select.prototype.getSelected = function() {
                        return Array.isArray(this._selected) ? this._selected.slice() : this._selected
                    }, Select.prototype.canAdd = function(entry) {
                        return this._selectionChooser.canAdd(entry)
                    }, Select.prototype.add = function(entry) {
                        this._selectionChooser.add(entry)
                    }, Select.prototype.remove = function(entry) {
                        this._selectionChooser.remove(entry)
                    }, Select.prototype.removeAll = function(notify) {
                        var i;
                        if (this._detachChangeListener(), Array.isArray(this._selected))
                            for (i = this._selected.length - 1; i >= 0; i--)
                                this.remove(this._selected[i]);
                        else
                            this._selected && this.remove(this._selected);
                        this._selectedElements = [], this._updateAddPlaceholderVisibility(), this._attachChangeListener(), notify && this._notifyChange()
                    }, Select.prototype.reRender = function() {
                        if (Array.isArray(this._selected))
                            for (var i = 0, len = this._selected.length; len > i; ++i)
                                this._selectedElements[i].children(".entry-value").html(this._sources.formatEntry(this._selected[i]));
                        else
                            this.selectedElements[0].children(".entry-value").html(this._sources.formatEntry(this._selected))
                    }, Select.prototype.openChooser = function(event) {
                        var deferred = $.Deferred();
                        return event && ((event.originalEvent || event).selectID = this._id), this._selectionChooser.isOpen ? deferred.reject() : this._selectionChooser.open(function(shouldUpdate) {
                            var updated = this._selected, original = this._originallySelected;
                            Array.isArray(updated) || (updated = [updated]), Array.isArray(original) || (original = [original]);
                            var changed = updated.length !== original.length || updated.some(function(entry, index) {
                                return !this._sources.isSameEntry(entry, original[index])
                            }.bind(this));
                            shouldUpdate && changed ? (deferred.resolve(this._selected), this._storeOriginallySelected()) : changed ? (this._selected = original, this.update(), deferred.reject()) : deferred.reject()
                        }.bind(this)), deferred.promise()
                    }, Select.prototype.closeChooser = function() {
                        this._selectionChooser.isOpen && this._selectionChooser.close()
                    }, Select.prototype.getSourceResults = function(sourceID) {
                        var source = this._sources._sourceMap[sourceID];
                        if (!source || !source.results)
                            throw new Error('No source results exist for source ID "' + sourceID + '"');
                        return source.results
                    }, Select.prototype.getSourceMetaData = function(sourceID) {
                        var id = this._sources._sourceMap[sourceID].id, metaData = this._sources.sourceMetaData[id];
                        if (!metaData)
                            throw new Error('No source meta data results exist for source ID "' + sourceID + '"');
                        return metaData
                    }, Select.prototype.disable = function(disable) {
                        this._includeInput && (this._disabled = !!disable, this.$element.toggleClass("disabled", this._disabled), this._disabled ? (this.$element.removeAttr("tabindex"), this._selectionChooser.isOpen && this._selectionChooser.close()) : this.$element.attr("tabindex", "0"))
                    }, Select.prototype.destroy = function() {
                        drag.off(this._id), this._selectionChooser && this._selectionChooser.destroy(), this._removeSourceChangeListener()
                    }, Select.prototype._setupSourceChangeListener = function() {
                        this._sourceChangeEvent = "message.select" + this._id, $(window).on(this._sourceChangeEvent, function(event) {
                            var sourceIDs, oneMatches, originalEvent = event.originalEvent, data = originalEvent.data, isTrustedOrigin = util.isTrustedOrigin(originalEvent.origin);
                            isTrustedOrigin && data.messageType === Select.NOTIFY_SOURCE_CHANGED_MESSAGE && (sourceIDs = data.sourceID, Array.isArray(sourceIDs) || (sourceIDs = [sourceIDs]), oneMatches = sourceIDs.some(function(sourceID) {
                                return this._sources.getSource(sourceID)
                            }.bind(this)), oneMatches && (this._shouldQueueSourceChangeReloads ? this._sourceChangeReloadQueued = !0 : this._triggerSourceChangeReload()))
                        }.bind(this))
                    }, Select.prototype._removeSourceChangeListener = function() {
                        $(window).off(this._sourceChangeEvent)
                    }, Select.prototype._queueSourceChangeReloads = function() {
                        this._shouldQueueSourceChangeReloads = !0
                    }, Select.prototype._dequeueSourceChangeReloads = function() {
                        this._shouldQueueSourceChangeReloads = !1, this._sourceChangeReloadQueued && this._triggerSourceChangeReload()
                    }, Select.prototype._triggerSourceChangeReload = function() {
                        this._sourceChangeReloadQueued = !1, this._selectionChooser.markSourcesForReload(!0), this._selectionChooser.isOpen && this._selectionChooser.loadSources(function() {
                            this._selectionChooser.scrollToNewNextRender(), this._selectionChooser.updateResults()
                        }.bind(this))
                    }, Select.prototype._storeOriginallySelected = function() {
                        this._originallySelected = Array.isArray(this._selected) ? this._selected.slice() : this._selected
                    }, Select.prototype._toggleFocus = function(focus) {
                        this._includeInput && this.$element.toggleClass("focus", !!focus)
                    }, Select.prototype._notifyChange = function() {
                        function matches(selectedItem, itemIdx) {
                            return this._previousNotifySel[itemIdx] === selectedItem
                        }
                        var selectedCopy, isArray, isChanged;
                        "function" == typeof this._onChangeCallback && (isArray = Array.isArray(this._selected), selectedCopy = isArray ? this._selected.slice() : this._selected, isChanged = !this._previousNotifySel || (isArray ? selectedCopy.length !== this._previousNotifySel.length || !selectedCopy.every(matches, this) : this._previousNotifySel !== selectedCopy), isChanged && (this._previousNotifySel = selectedCopy, window.setTimeout(function() {
                            this._onChangeCallback(selectedCopy)
                        }.bind(this))))
                    }, Select.prototype._detachChangeListener = function() {
                        this._detachedOnChangeCallback = this._onChangeCallback, this._onChangeCallback = null
                    }, Select.prototype._attachChangeListener = function() {
                        this._onChangeCallback = this._detachedOnChangeCallback, this._detachedOnChangeCallback = null
                    }, Select.prototype._batchChange = function(fn) {
                        var alreadyDetached = this._detachedOnChangeCallback;
                        alreadyDetached || this._detachChangeListener(), fn(), alreadyDetached || (this._attachChangeListener(), this._notifyChange())
                    }, Select.prototype._addedViaChooser = function(entry) {
                        var insertIndex, comparator, $entry, $insertAfterElement, isArray = Array.isArray(this._selected);
                        isArray ? (this._settings.sortWidget ? (comparator = this._sources.globalSort.bind(this._sources), insertIndex = selectUtil.binaryInsertIndex(this._selected, entry, comparator)) : insertIndex = this._selected.length, this._selected.splice(insertIndex, 0, entry)) : (this._selected = entry, insertIndex = this._selected.length), $insertAfterElement = insertIndex > 0 ? this._selectedElements[insertIndex - 1] : null, this._includeInput && ($entry = this._addEntryElement(entry, $insertAfterElement), this._selectedElements.splice(insertIndex, 0, $entry)), this._updateAddPlaceholderVisibility(), this._notifyChange()
                    }, Select.prototype._removedViaChooser = function(entry) {
                        var index;
                        if (Array.isArray(this._selected) ? (index = this._indexInSelected(entry), this._selected.splice(index, 1)) : (index = 0, this._selected = null), this._includeInput) {
                            var $entries = this._selectedElements.splice(index, 1);
                            $entries[0].remove()
                        }
                        this._updateAddPlaceholderVisibility(), this._notifyChange()
                    }, Select.prototype._indexInSelected = function(entry) {
                        var i, index = -1;
                        for (i = 0; i < this._selected.length; i++)
                            if (this._sources.isSameEntry(entry, this._selected[i])) {
                                index = i;
                                break
                            }
                        return index
                    }, Select.prototype._updateAddPlaceholderVisibility = function() {
                        var visible;
                        this._includeInput && this._settings && this._$addIndicator && (visible = !this._loading && (/*this._settings.singleSelect &&*/ this._includeInput /*|| Array.isArray(this._selected) && 0 === this._selected.length || null == this._selected*/&&(Array.isArray(this._selected) && this._settings.maxSelectLength && this._settings.maxSelectLength > this._selected.length || this._settings.maxSelectLength == undefined)/*fweb add for ha heartbeat limit*/), this._$addIndicator.toggleClass("hidden", !visible))
                    }, Select.prototype._toggleLoading = function(loading) {
                        this._includeInput && (this._loading = loading, loading ? (this.$element.removeAttr("tabindex"), this._$loadingIndicator = $('<div class="loading-container"></div>').append('<f-icon class="fa-loading"></f-icon>').appendTo(this.$element)) : (this._disabled || this.$element.attr("tabindex", "0"), this._$loadingIndicator.remove()), this._updateAddPlaceholderVisibility())
                    }, Select.prototype._addEntryElement = function(entry, $afterElement) {
                        var $closeIcon, formatted = this._sources.formatEntry(entry), $entry = $('<div class="selected-entry"></div>').append('<span class="entry-value">' + formatted + "</span>");
                        return this._settings.singleSelect || ($closeIcon = $('<f-icon class="remove-selected-entry fa-dismiss"></f-icon>'), $closeIcon.on("click", function(event) {
                            event.originalEvent.selectID = this._id, this._disabled || this.remove(entry)
                        }.bind(this)).appendTo($entry)), $afterElement ? $entry.insertAfter($afterElement) : this._$selected.prepend($entry), $entry
                    }, Select.prototype._createElement = function() {
                        this.$element = $('<div class="select-widget" tabindex="0"></div>');
                        var checkCanOpen = function(event) {
                            this._loading || this._disabled || (event && event.originalEvent && (event.originalEvent.selectID = this._id), this._selectionChooser.isOpen || this._selectionChooser.open())
                        }.bind(this);
                        this.$element.on("click", checkCanOpen), this.$element.on("keydown", function(event) {
                            32 === event.which && (event.preventDefault(), checkCanOpen()), this._selectionChooser.isOpen && 9 === event.which && this._selectionChooser.close()
                        }.bind(this)), this._$selected = $('<div class="selected-entries"></div>').appendTo(this.$element)
                    }, Select.prototype.configurationDependentSetup = function() {
                        var addIcon, dragEntry, supportsDrop, singleStyle = this._settings.singleSelect, compactStyle = this._settings.compactWidget;
                        this.$element.toggleClass("single-select", !!singleStyle), this.$element.toggleClass("compact", !!compactStyle), this.$element.find(".add-placeholder").remove(), addIcon = singleStyle ? "fa-caret-down" : "fa-plus icon-sm", this._$addIndicator = $('<div class="add-placeholder"></div>').append('<f-icon class="' + addIcon + '"></f-icon>').appendTo(this.$element), this._settings.dragAndDrop && !this._settings.singleSelect ? (drag.onDrag(this._id, function(entry) {
                            supportsDrop = this._selectionChooser.canAdd(entry), dragEntry = entry, supportsDrop && this.$element.addClass("drop-support")
                        }.bind(this), function() {
                            this.$element.removeClass("drop-support")
                        }.bind(this)), this.$element.on("dragenter", function(event) {
                            var supportedType = drag.supportedType(event.originalEvent.dataTransfer);
                            supportedType && supportsDrop && event.preventDefault()
                        }), this.$element.on("dragover", function(event) {
                            supportsDrop && event.preventDefault()
                        }), this.$element.on("drop", function(event) {
                            this.add(dragEntry), event.preventDefault()
                        }.bind(this))) : (drag.off(this._id), this.$element.off("dragenter dragover drop dragleave"))
                    }, Select.prototype._createSelectionChooser = function(selected) {
                        var ChooserClass;
                        ChooserClass = this._settings.singleSelect && this._includeInput ? Dropdown : SelectionPane, this._selectionChooser = new ChooserClass(this, this._sources, selected)
                    }, module.exports = Select
                }, {"../util": 29,"./drag": 16,"./dropdown": 17,"./selection-pane": 21,"./sources": 22,"./util": 23}],21: [function(require, module, exports) {
                    "use strict";
                    function SelectionPane(select, sources, selected) {
                        VirtualResults.call(this, select, sources, selected), this._id = util.uniqueID(), this._searchInput = new SearchInput(select), this._create(), this.isOpen = !1
                    }
                    var $ = jQuery, util = require("../util"), selectUtil = require("./util"), VirtualResults = require("./virtual-results"), SearchInput = require("./search-input"), Sliderin = require("../slide/slide"), SLIDE_OUT_CLASS = "slide-out", CLICK_EVENT = "click.selectionPane", RESIZE_EVENT = "resize.selectionPane";
                    SelectionPane.prototype = Object.create(VirtualResults.prototype), SelectionPane.prototype.constructor = SelectionPane, SelectionPane.prototype.open = function(closeCallback) {
                        var $attachTarget, slide, $viewContainer = $(".view-container");
                        if (this._select._settings.insideSlide) {
                            if (slide = Sliderin.getLast(), !slide)
                                throw new Error('"insideSlide" specified but no slide could be found');
                            $attachTarget = this._$clickTarget = slide._$element, this.TARGET_WINDOW = Sliderin.TARGET_WINDOW, slide.addDestructible(this._select)
                        } else
                            $viewContainer.length ? ($attachTarget = $viewContainer, this._$clickTarget = $("body")) : $attachTarget = this._$clickTarget = $("body");
                        this._closeCallback = closeCallback, this._select._toggleFocus(!0), this.clearResults(), $attachTarget.append(this._$element), this._$element.removeClass(SLIDE_OUT_CLASS).one(util.CROSS_BROWSER_ANIMATION_END, function(event) {
                            event.target === this._$element[0] && (this._sourcesLoaded ? this._entries ? this.renderResults() : this.updateResults() : this.loadSources(function() {
                                this.updateResults()
                            }.bind(this)))
                        }.bind(this)), this.isOpen = !0, this._$clickTarget.on(CLICK_EVENT + this._id, function(event) {
                            var selectID = (event.originalEvent || {}).selectID, originatedFromWidget = selectID && selectID === this._select._id;
                            originatedFromWidget || selectUtil.eventInsideElement(event, this._$element[0]) || this._closeValidate(!0)
                        }.bind(this)), $(window).on(RESIZE_EVENT + this._id, util.debounce(300, function() {
                            this._sourcesLoaded && this.resizeResults()
                        }.bind(this)))
                    }, SelectionPane.prototype.close = function() {
                        this._$clickTarget && this._$clickTarget.off(CLICK_EVENT + this._id), $(window).off(RESIZE_EVENT + this._id), this._select._toggleFocus(!1), this.isOpen = !1, this._$element.addClass(SLIDE_OUT_CLASS).on(util.CROSS_BROWSER_ANIMATION_END, function() {
                            this.isOpen || this._$element.off(util.CROSS_BROWSER_ANIMATION_END).removeClass(SLIDE_OUT_CLASS).detach()
                        }.bind(this))
                    }, SelectionPane.prototype.toggleInputs = function(enable, focus) {
                        this._$createNew.attr("disabled", !enable), this._$sourceSelection && this._$sourceSelection.find("input").attr("disabled", !enable), enable ? focus ? this._searchInput.enableAndFocus() : this._searchInput.enable() : this._searchInput.disable()
                    }, SelectionPane.prototype.destroy = function() {
                        VirtualResults.prototype.destroy.call(this), this.close(), this._$element.empty().remove()
                    }, SelectionPane.prototype._closeValidate = function(shouldUpdate) {
                        var error, validateFunction = this._select._settings.validateFunction;
                        if ("function" == typeof this._closeCallback) {
                            if (shouldUpdate && "function" == typeof validateFunction && (error = validateFunction(this._select._selected)))
                                return void this._showError(error);
                            this.close(), this._closeCallback(shouldUpdate), shouldUpdate || this._removeError()
                        } else
                            this.close()
                    }, SelectionPane.prototype._showError = function(error) {
                        this._removeError(), this._$error = $('<div class="error-message">' + error + "</div>"), this._$error.insertBefore(this.resultsElement)
                    }, SelectionPane.prototype._removeError = function() {
                        this._$error && (this._$error.remove(), this._$error = null)
                    }, SelectionPane.prototype._afterAdd = function() {
                        this._removeError()
                    }, SelectionPane.prototype._afterChunkRendered = function(noEntries) {
                        this._$createNew.toggleClass("primary", noEntries)
                    }, SelectionPane.prototype._create = function() {
                        var $cancelButton, includeInput = this._select._includeInput, sourcesGrouping = this._sources.getGrouping(), sourceGroups = Object.keys(sourcesGrouping), $titleBar = $('<div class="title-bar"></div>'), $closeIconButton = $('<button class="bare" type="button"><f-icon class="fa-dismiss"></f-icon></button>'), $searchContainer = $('<div class="select-widget-search-container"></div>'), $footer = $('<div class="footer"></div>'), $okButton = $('<button type="button">' + (includeInput ? this._select.CLOSE_TEXT : this._select.OK_TEXT) + "</button>");
                        if (this._$element = $('<div class="selection-pane"></div>'), this._$createNew = $('<button type="button" class="create-new hidden" title="' + this._select.CREATE_NEW_TEXT + '"><f-icon class="fa-plus"></f-icon></button>'), this._$dialog = $('<div class="dialog"></div>').appendTo(this._$element).append($titleBar), $titleBar.append("<h1>" + this._select.PANE_TITLE + "</h1>").append($closeIconButton), $closeIconButton.on("click", function() {
                            this._closeValidate(!1)
                        }.bind(this)), this.setGroup(sourceGroups[0]), this._$sourceSelection = null, sourceGroups.length > 1) {
                            this._$sourceSelection = $('<div class="radio-group"></div>'), sourceGroups.forEach(function(groupName, index) {
                                var id = groupName + this._id, name = "selectionPane" + this._id, $input = $('<input type="radio" id="' + id + '" name="' + name + '" value="' + groupName + '">').attr("disabled", "disabled");
                                0 === index && $input.prop("checked", !0), this._$sourceSelection.append($input), this._$sourceSelection.append('<label for="' + id + '">' + groupName + "</label>")
                            }.bind(this)), this._$sourceSelection.appendTo(this._$dialog);
                            var that = this;
                            this._$sourceSelection.find("input").on("change", function() {
                                that.setGroup(this.value), that._$createNew.toggleClass("hidden", 0 === sourcesGrouping[this.value].createNewSupported.length), that.updateResults()
                            })
                        }
                        $searchContainer.append(this._searchInput.$element).append(this._$createNew), this._$dialog.append($searchContainer), sourcesGrouping[sourceGroups[0]].createNewSupported.length && this._$createNew.removeClass("hidden"), this._$createNew.on("click", function() {
                            this.createNew()
                        }.bind(this)), this._searchInput.onChange(function() {
                            this.setSearchValue(this._searchInput.getValue()), this.updateResults()
                        }.bind(this)), this._$dialog.append(this.resultsElement), $okButton.on("click", function() {
                            this._closeValidate(!0)
                        }.bind(this)), $footer.append($okButton), includeInput || ($okButton.addClass("primary"), $cancelButton = $('<button type="button">' + this._select.CANCEL_TEXT + "</button>").on("click", function() {
                            this._closeValidate(!1)
                        }.bind(this)).appendTo($footer)), this._$dialog.append($footer)
                    }, module.exports = SelectionPane
                }, {"../slide/slide": 26,"../util": 29,"./search-input": 19,"./util": 23,"./virtual-results": 24}],22: [function(require, module, exports) {
                    "use strict";
                    function Sources(select) {
                        var sources, copyObject = function(source) {
                            return $.extend(!0, {}, source)
                        };
                        this._select = select, this._settings = select._settings, sources = this._settings.sources, sources = Array.isArray(sources) ? {DUMMY_GROUP: sources} : "string" == typeof sources ? {DUMMY_GROUP: [sources]} : copyObject(sources), this.preProcessSelected = !1, this._sourceMap = {}, this._sourceGroupMap = {}, this._sourceIndexMap = {}, Object.keys(sources).forEach(function(groupName, groupIndex) {
                            var sourceIndex, key, source, aliases, groupSources = [];
                            for (groupSources.createNewSupported = [], Array.isArray(sources[groupName]) || (sources[groupName] = [sources[groupName]]), sourceIndex = 0; sourceIndex < sources[groupName].length; sourceIndex++) {
                                if (key = sources[groupName][sourceIndex], !(key in this._select.SOURCES))
                                    throw new Error('Source "' + key + "\" doesn't exist");
                                source = copyObject(this._select.SOURCES[key]), source.id = key, this._normalizeSource(source), this._sourceMap[key] = source, this._sourceGroupMap[key] = groupName, 
                                this._sourceIndexMap[key] = groupIndex + "-" + sourceIndex, source.aliasFor ? (aliases = source.aliasFor, Array.isArray(aliases) || (aliases = [aliases]), source.aliases = aliases, aliases.forEach(function(alias) {
                                    this._sourceMap[alias] = source, this._sourceIndexMap[alias] = groupIndex + "-" + sourceIndex
                                }.bind(this))) : this._settings.createNew && source.createNew && groupSources.createNewSupported.push(source), source.preProcessSelected && (this.preProcessSelected = !0), groupSources.push(source)
                            }
                            sources[groupName] = groupSources, this._settings.sortCreateNew && groupSources.createNewSupported.sort(function(sourceA, sourceB) {
                                return fastLocaleCompare(sourceA.name, sourceB.name)
                            })
                        }.bind(this)), this._sources = sources
                    }
                    var $ = jQuery, sort = require("../sort"), fastLocaleCompare = require("../util").fastLocaleCompare, highlighter = require("../highlighter");
                    Sources._CACHE = {}, Sources._METADATA_CACHE = {}, Sources.invalidateCache = function() {
                        Sources._CACHE = {}, Sources._METADATA_CACHE = {}
                    }, Sources.invalidateCacheForSource = function(sourceID) {
                        delete Sources._CACHE[sourceID], delete Sources._METADATA_CACHE[sourceID]
                    }, Sources.prototype._normalizeSource = function(source) {
                        "function" == typeof source.name && (source.name = source.name())
                    }, Sources.prototype.getSource = function(sourceID) {
                        return this._sourceMap[sourceID]
                    }, Sources.prototype.getGrouping = function() {
                        return this._sources
                    }, Sources.prototype.load = function(hardLoad) {
                        var promises = [], loadedSources = [], sourcesPromise = this._sourcesPromise, settings = this._select._settings;
                        return (!sourcesPromise || hardLoad) && (this.sourceMetaData = {}, Object.keys(this._sources).forEach(function(groupName) {
                            var idKey = this._select.ENTRY_ID_KEY;
                            this._sources[groupName].forEach(function(source) {
                                var promise;
                                Sources._CACHE[source.id] && !hardLoad ? promise = Sources._CACHE[source.id] : (promise = source.data(settings.meta), source.dontCache || (Sources._CACHE[source.id] = promise)), promise.then(function(results) {
                                    var list = [], map = {};
                                    results.forEach(function(entry) {
                                        "object" == typeof entry && (entry = $.extend({}, entry)), list.push(entry), map[entry[idKey]] = entry
                                    }), list.mapping = map, source.results = list
                                }), promises.push(promise), "function" == typeof source.metaData && (Sources._METADATA_CACHE[source.id] && !hardLoad ? promise = Sources._METADATA_CACHE[source.id] : (promise = source.metaData(settings.meta), source.dontCache || (Sources._METADATA_CACHE[source.id] = promise)), promise.then(function(results) {
                                    this.sourceMetaData[source.id] = results
                                }.bind(this)), promises.push(promise)), loadedSources.push(source)
                            }.bind(this))
                        }.bind(this)), "function" == typeof settings.extraData && promises.push(settings.extraData(settings.meta).then(function(data) {
                            this.extraData = data
                        }.bind(this))), sourcesPromise = this._sourcesPromise = $.when.apply($, promises).then(function() {
                            var Select, sharedInstancePromises;
                            return this._select._sharedInstance ? void 0 : (Select = require("./select"), sharedInstancePromises = loadedSources.filter(function(source) {
                                return !source.dontCache
                            }).map(function(source) {
                                return Select.getSourceData(source.id)
                            }), $.when.apply($, sharedInstancePromises))
                        }.bind(this))), sourcesPromise
                    }, Sources.prototype.loadAndProcess = function(callback, processingCallback, hardLoad) {
                        var settings = this._select._settings, entryWrapperMap = {}, wrapEntry = function(entryID, entry) {
                            var wrapper = {id: entryID,entry: entry};
                            return entryWrapperMap[entryID] = wrapper, wrapper
                        }.bind(this), processSource = function(processedGroup, source, callback) {
                            var sortFunction, valueFunction, filterFunction = this.getFilterFunction(source.id), synchronousProcessingLength = this._select.MAX_SYNCHRONOUS_PROCESSING_LENGTH, index = 0, sourceLength = source.results.length, results = [], chunkedProcessing = function(done) {
                                var processChunk = function(start, stop, done) {
                                    var i, entry, entryID, valid;
                                    for (i = start; stop >= i; i++)
                                        entry = source.results[i], entryID = this.uniqueEntryID(entry), valid = filterFunction(entry, settings.meta, this.extraData), valid && (results.push(wrapEntry(entryID, entry)), index++), this._loadCount > 1 && !this._previousEntries[entryID] && (this.newEntryIndexMap[entryID] = valid ? index : -1), this._previousEntries[entryID] = !0;
                                    stop === sourceLength - 1 ? done() : setTimeout(function() {
                                        processChunk(stop + 1, Math.min(stop + synchronousProcessingLength, sourceLength - 1), done)
                                    })
                                }.bind(this);
                                processChunk(0, Math.min(synchronousProcessingLength - 1, sourceLength - 1), done)
                            }.bind(this), process = function() {
                                chunkedProcessing(function() {
                                    processedGroup[source.id] = results, this._sourceData[source.id] = source.results, source.aliases && source.aliases.forEach(function(alias) {
                                        this._sourceData[alias] = source.results
                                    }.bind(this)), callback()
                                }.bind(this))
                            }.bind(this);
                            settings.sortResults ? (sortFunction = this.getSourceSortFunction(source.id), valueFunction = this.getValueFunction(source.id), sort(source.results, function(entryA, entryB) {
                                var valueA = valueFunction(entryA), valueB = valueFunction(entryB);
                                return sortFunction(valueA, valueB, entryA, entryB)
                            }, process)) : process()
                        }.bind(this), processGroup = function(processed, name, group, callback) {
                            var i = -1, processedGroup = processed[name] = {}, processNextSource = function() {
                                i++, i === group.length ? callback() : processSource(processedGroup, group[i], processNextSource)
                            };
                            processNextSource()
                        };
                        this._loadCount = this._loadCount ? this._loadCount + 1 : 1, this._previousEntries = this._previousEntries || {}, this.load(hardLoad).then(function() {
                            var i = -1, processed = {}, groupNames = Object.keys(this._sources), processNextGroup = function() {
                                var groupName;
                                i++, i === groupNames.length ? callback(processed, entryWrapperMap) : (groupName = groupNames[i], processGroup(processed, groupName, this._sources[groupName], processNextGroup))
                            }.bind(this);
                            this.sourceDataCached = !0, "function" == typeof processingCallback && processingCallback(), this.newEntryIndexMap = {}, this._sourceData = {}, processNextGroup()
                        }.bind(this))
                    }, Sources.prototype.getSourceData = function(sourceID) {
                        return this._sourceData[sourceID]
                    }, Sources.prototype.formatEntry = function(entry, searchValue, searchMatchType) {
                        var formatFunction, valueFunction, sourceID, formatted, html;
                        return "object" == typeof entry && (sourceID = this.getSourceID(entry)), valueFunction = this.getValueFunction(sourceID), formatFunction = this.getFormatFunction(sourceID), formatted = formatFunction(entry, valueFunction(entry)), html = '<div class="formatted-content">' + formatted + "</div>", (searchMatchType === this.SEARCH_MATCH_TYPE.VALUE || searchMatchType === this.SEARCH_MATCH_TYPE.BOTH) && (html = highlighter.highlightMatchesInHTML(html, searchValue, !0)), searchMatchType === this.SEARCH_MATCH_TYPE.SEARCH_KEYS && (html += '<f-icon class="fa-help-info"></f-icon>'), html
                    }, Sources.prototype.formatCategory = function(name, count) {
                        var formatFunction = this._select.DEFAULT_CATEGORY_FORMAT_FUNCTION;
                        return formatFunction(name, count)
                    }, Sources.prototype.formatSubcategory = function(value, count, sourceID) {
                        var formatFunction = this.getSubcategoryFormatFunction(sourceID);
                        return formatFunction(value, count)
                    }, Sources.prototype.getValueFunction = function(sourceID) {
                        return this._getSpecifiedFunction("valueFunction", "DEFAULT_VALUE_FUNCTION", sourceID)
                    }, Sources.prototype.getFormatFunction = function(sourceID) {
                        return this._getSpecifiedFunction("formatFunction", "DEFAULT_FORMAT_FUNCTION", sourceID)
                    }, Sources.prototype.getSourceSortFunction = function(sourceID) {
                        return this._getSpecifiedFunction("sortFunction", "DEFAULT_SOURCE_SORT_FUNCTION", sourceID)
                    }, Sources.prototype.getSubcategoryValueFunction = function(sourceID) {
                        return this._getSpecifiedFunction("subcategoryValueFunction", "DEFAULT_SUBCATEGORY_VALUE_FUNCTION", sourceID)
                    }, Sources.prototype.getSubcategoryFormatFunction = function(sourceID) {
                        return this._getSpecifiedFunction("subcategoryFormatFunction", "DEFAULT_SUBCATEGORY_FORMAT_FUNCTION", sourceID)
                    }, Sources.prototype.getSubcategorySortFunction = function(sourceID) {
                        return this._getSpecifiedFunction("subcategorySortFunction", "DEFAULT_SUBCATEGORY_SORT_FUNCTION", sourceID)
                    }, Sources.prototype.getFilterFunction = function(sourceID) {
                        var sourceFilter, extraFilter, settings = this._select._settings, fns = [];
                        return sourceFilter = this.getSource(sourceID).filterFunction, sourceFilter && fns.push(sourceFilter), extraFilter = settings.filterFunction, "function" == typeof extraFilter ? fns.push(extraFilter) : null != extraFilter && "function" == typeof extraFilter[sourceID] && fns.push(extraFilter[sourceID]), function(entry) {
                            return fns.every(function(fn) {
                                return fn.apply(this._select, [entry, settings.meta, this.extraData])
                            }.bind(this))
                        }.bind(this)
                    }, Sources.prototype._getSpecifiedFunction = function(key, defaultKey, sourceID) {
                        var fn, settings = this._select._settings, defaultFn = defaultKey ? this._select[defaultKey] : null;
                        return fn = "function" == typeof settings[key] ? settings[key] : sourceID ? (settings[key] || {})[sourceID] || this.getSource(sourceID)[key] || defaultFn : defaultFn
                    }, Sources.prototype.globalSort = function(entryA, entryB) {
                        var valueA, valueB, valueFunction, sortFunction, sourceIDA = this.getSourceID(entryA), sourceIDB = this.getSourceID(entryB), sourceA = this.getSource(sourceIDA), sourceB = this.getSource(sourceIDB);
                        return sourceA ? sourceB ? sourceIDA === sourceIDB ? (valueFunction = this.getValueFunction(sourceIDA), sortFunction = this.getSourceSortFunction(sourceIDA), valueA = valueFunction(entryA), valueB = valueFunction(entryB), sortFunction(valueA, valueB, entryA, entryB)) : this._settings.sortCategories ? (valueA = this.getSource(sourceIDA).name, valueA = this.getSource(sourceIDB).name, fastLocaleCompare(valueA, valueB)) : (valueA = this.getSourceIndexString(sourceIDA), valueB = this.getSourceIndexString(sourceIDB), fastLocaleCompare(valueA, valueB)) : 1 : -1
                    }, Sources.prototype.SEARCH_MATCH_TYPE = {NONE: 0,VALUE: 1,SEARCH_KEYS: 2,BOTH: 3}, Sources.prototype.getSearchMatchChecker = function(sourceID) {
                        var searchMapping = this.getSource(sourceID).searchKeys || {}, valueFunction = this.getValueFunction(sourceID), searchKeys = Object.keys(searchMapping), matches = function(value, searchRegex) {
                            return null == value ? !1 : Array.isArray(value) ? value.some(function(v) {
                                return matches(v, searchRegex)
                            }) : "object" == typeof value ? Object.keys(value).some(function(key) {
                                return matches(value[key], searchRegex)
                            }) : searchRegex.test(value)
                        };
                        return function(entry, searchRegex, searchString) {
                            var matchType, value = valueFunction(entry), valueMatches = !1, searchKeysMatch = !1, matchedSearchKeys = {};
                            return matches(value, searchRegex) && (valueMatches = !0), searchKeys.forEach(function(key) {
                                var doesMatch;
                                doesMatch = "function" == typeof searchMapping[key] ? searchMapping[key](entry, searchString, searchRegex) : matches(entry[key], searchRegex), doesMatch && (searchKeysMatch = !0, matchedSearchKeys[key] = !0)
                            }), matchType = valueMatches && searchKeysMatch ? this.SEARCH_MATCH_TYPE.BOTH : valueMatches ? this.SEARCH_MATCH_TYPE.VALUE : searchKeysMatch ? this.SEARCH_MATCH_TYPE.SEARCH_KEYS : this.SEARCH_MATCH_TYPE.NONE, {matchType: matchType,matchedSearchKeys: matchedSearchKeys}
                        }.bind(this)
                    }, Sources.prototype.formatEntryTooltip = function(entry, searchValue, searchMatchType, matchedSearchKeys) {
                        var ID_KEY = this._select.ENTRY_ID_KEY, VALUE_MATCH_TYPES = [this.SEARCH_MATCH_TYPE.VALUE, this.SEARCH_MATCH_TYPE.BOTH], SEARCH_KEYS_MATCH_TYPES = [this.SEARCH_MATCH_TYPE.SEARCH_KEYS, this.SEARCH_MATCH_TYPE.BOTH], html = '<table class="table key-value select-tooltip-table"><tbody>', sourceID = this.getSourceID(entry), source = this.getSource(sourceID), valueFunction = this.getValueFunction(sourceID), nameLabel = source.tooltipNameLabel || source.name, tooltipMapping = {};
                        return tooltipMapping[ID_KEY] = !0, tooltipMapping = $.extend(tooltipMapping, source.tooltipKeys || {}), tooltipMapping[ID_KEY] = [nameLabel, function(entry) {
                                return valueFunction(entry)
                            }], Object.keys(tooltipMapping).forEach(function(key) {
                            var label, value, shouldHightlight, mappingEntry = tooltipMapping[key];
                            Array.isArray(mappingEntry) ? (label = mappingEntry[0], value = mappingEntry[1].call(this._select, entry)) : (label = mappingEntry, value = entry[key]), value && (shouldHightlight = searchValue && matchedSearchKeys && (key === ID_KEY && VALUE_MATCH_TYPES.indexOf(searchMatchType) >= 0 || matchedSearchKeys[key] && SEARCH_KEYS_MATCH_TYPES.indexOf(searchMatchType) >= 0), shouldHightlight && (value = highlighter.highlightMatchesInHTML(value, searchValue, !0)), html += "<tr><td>" + label + "</td><td>" + value + "</td></tr>")
                        }.bind(this)), html += "</tbody></table>"
                    }, Sources.prototype.getSourceID = function(entry) {
                        var sourceID, isObject = "object" == typeof entry;
                        return isObject && (sourceID = this._select.ENTRY_SOURCE_ID_FUNCTION(entry)), isObject && sourceID || (sourceID = this._sources[Object.keys(this._sources)[0]][0].id), sourceID
                    }, Sources.prototype.getSourceIndexString = function(sourceID) {
                        return this._sourceIndexMap[sourceID]
                    }, Sources.prototype.getSourceGroup = function(sourceID) {
                        return this._sourceGroupMap[sourceID]
                    }, Sources.prototype.uniqueEntryID = function(entry) {
                        var entryID, sourceID = this.getSourceID(entry);
                        return entryID = "object" == typeof entry ? entry[this._select.ENTRY_ID_KEY] : entry, entryID + "#" + sourceID
                    }, Sources.prototype.isSameEntry = function(entry1, entry2) {
                        return this.uniqueEntryID(entry1) === this.uniqueEntryID(entry2)
                    }, Sources.prototype.isSolitaryEntry = function(entry) {
                        var entryID, settings = this._select._settings, sourceID = this.getSourceID(entry), solitaryMap = settings.solitaryEntries || this.getSource(sourceID).solitaryEntries || [];
                        return settings.singleSelect ? !1 : settings.allSolitary ? !0 : (entryID = "object" == typeof entry ? entry[this._select.ENTRY_ID_KEY] : entry, entry[this._select.SOLITARY_KEY] || solitaryMap[entryID])
                    }, Sources.prototype.supportedEntry = function(entry) {
                        var sourceID = this.getSourceID(entry), sourceIndexString = this.getSourceIndexString(sourceID), filterFn = sourceIndexString ? this.getFilterFunction(sourceID) : null;
                        return sourceIndexString && filterFn(entry, this._select._settings.meta, this.extraData)
                    }, module.exports = Sources
                }, {"../highlighter": 6,"../sort": 27,"../util": 29,"./select": 20}],23: [function(require, module, exports) {
                    "use strict";
                    var $ = jQuery;
                    module.exports.PREVENT_LOCKUP_TIMEOUT = 75, module.exports.eventInsideElement = function(event, element) {
                        return event.target === element || $.contains(element, event.target)
                    }, module.exports.binaryInsertIndex = function(list, entry, comparator) {
                        var comparison, current, lowerBound, upperBound, length = list.length;
                        if (0 === length)
                            return 0;
                        for (lowerBound = 0, upperBound = length - 1; ; ) {
                            if (current = Math.ceil((lowerBound + upperBound) / 2), comparison = comparator(list[current], entry), 0 === comparison)
                                return current;
                            if (0 > comparison) {
                                if (lowerBound = current + 1, lowerBound > upperBound)
                                    return current + 1
                            } else if (upperBound = current - 1, lowerBound > upperBound)
                                return current
                        }
                    }
                }, {}],24: [function(require, module, exports) {
                    "use strict";
                    function Scroller() {
                        this.element = document.createElement("div"), this.element.className = "scroller"
                    }
                    function VirtualResults(select, sources, selected) {
                        this._select = select, this._sources = sources, this.resultsElement = document.createElement("div"), this.resultsElement.className = "virtual-results", this._scroller = new Scroller, this.resultsElement.appendChild(this._scroller.element), this._loadingElement = document.createElement("div"), this._loadingElement.className = "loading-container", this._loadingElement.innerHTML = '<f-icon class="fa-loading icon-lg"></f-icon>', this._processingElement = document.createElement("div"), this._processingElement.className = "processing", this._processingElement.innerHTML = this._select.PROCESSING_TEXT, this.resultsElement.appendChild(this._loadingElement), this._entryWrapperMap = {}, this.updateSelected(selected), this.resultsElement.addEventListener("scroll", function() {
                            this._hideTooltip(), this._renderScrolledChunk()
                        }.bind(this))
                    }
                    var Tooltip = require("../tooltip"), drag = require("./drag"), selectUtil = require("./util"), util = require("../util"), TOOLTIP_DELAY = 500, WINDOW_BUFFER = 10, $ = jQuery;
                    Scroller.prototype.update = function(height) {
                        this.element.style.display = "", this.element.style.height = height + "px"
                    }, Scroller.prototype.hide = function() {
                        this.element.style.display = "none"
                    }, VirtualResults.prototype.TARGET_WINDOW = window, VirtualResults.prototype.updateSelected = function(selected, reProcess, reload) {
                        var preProcessSelected, settings = this._select._settings, isArray = Array.isArray(selected);
                        if (this._selectedMap = {}, this._initSolitaryTracking(), !isArray && !settings.singleSelect)
                            throw new Error("Selected is not an array");
                        isArray || (selected = selected ? [selected] : []);
                        var update = function() {
                            isArray && settings.sortWidget && selected.sort(this._sources.globalSort.bind(this._sources)), this._select._detachChangeListener(), selected.forEach(function(entry) {
                                this.add(entry)
                            }.bind(this)), this._select._includeInput || this._select._storeOriginallySelected(), this._select._attachChangeListener(), selected.length && this._select._notifyChange()
                        }.bind(this);
                        (reProcess || reload) && this.markSourcesForReload(reload), preProcessSelected = null == settings.preProcessSelected ? this._sources.preProcessSelected : settings.preProcessSelected, preProcessSelected && selected.length && !this._sources.sourceDataCached ? (this._select._toggleLoading(!0), this.loadSources(function() {
                            selected = selected.map(function(entry) {
                                var sourceID = this._sources.getSourceID(entry), data = this._sources.getSourceData(sourceID);
                                return data.mapping[entry[this._select.ENTRY_ID_KEY]]
                            }.bind(this)), this._select._toggleLoading(!1), update()
                        }.bind(this))) : update()
                    }, VirtualResults.prototype.clearResults = function() {
                        this._removeEntries(), this._scroller.hide(), this.resultsElement.appendChild(this._loadingElement)
                    }, VirtualResults.prototype.markSourcesForReload = function(hardLoad) {
                        this._hardLoadSources = hardLoad, this._sourcesLoaded = !1, this.clearResults(), this.toggleInputs(!1)
                    }, VirtualResults.prototype.loadSources = function(callback) {
                        this._newEntryAnimated = {}, this._sources.loadAndProcess(function(results, entryWrapperMap) {
                            this._results = results, this._entryWrapperMap = entryWrapperMap, this._hardLoadSources = !1, this._sourcesLoaded = !0, this._processingElement.parentNode && this._loadingElement.removeChild(this._processingElement), "function" == typeof callback && callback()
                        }.bind(this), function() {
                            this._loadingElement.insertBefore(this._processingElement, this._loadingElement.firstChild)
                        }.bind(this), this._hardLoadSources)
                    }, VirtualResults.prototype.setGroup = function(groupName) {
                        this._currentGroup = groupName
                    }, VirtualResults.prototype.getGroup = function() {
                        return this._currentGroup
                    }, VirtualResults.prototype.setSearchValue = function(searchValue) {
                        this._searchValue = searchValue
                    }, VirtualResults.prototype.updateResults = function() {
                        var categorizedEntries = this._results[this._currentGroup], categories = Object.keys(categorizedEntries), settings = this._select._settings;
                        this._entryCount = {}, this._collapsedCategories = {}, this._newEntryIndexMap = $.extend({}, this._sources.newEntryIndexMap);
                        var update = function() {
                            var searchRegex, filtered = {};
                            this._searchValue && (searchRegex = new RegExp(util.preRegexEscape(this._searchValue), "i")), categories.length > 1 && settings.sortCategories && categories.sort(function(sourceIDA, sourceIDB) {
                                var valueA = this._sources.getSource(sourceIDA).name, valueB = this._sources.getSource(sourceIDB).name;
                                return util.fastLocaleCompare(valueA, valueB)
                            }.bind(this)), categories.forEach(function(sourceID) {
                                var subcategorized, subcategoryValueFunction, subcategorySortFunction, source = this._sources.getSource(sourceID), subcategorization = settings.subcategories && source.subcategories, searchMatchChecker = this._sources.getSearchMatchChecker(sourceID), entryCount = 0, matchesSearch = function(entryWrapper) {
                                    var match, result = !0;
                                    return this._searchValue ? (match = searchMatchChecker(entryWrapper.entry, searchRegex, this._searchValue), entryWrapper.searchMatchType = match.matchType, entryWrapper.matchedSearchKeys = match.matchedSearchKeys, result = match.matchType !== this._sources.SEARCH_MATCH_TYPE.NONE) : entryWrapper.searchMatchType = this._sources.SEARCH_MATCH_TYPE.NONE, result
                                }.bind(this);
                                subcategorization ? (subcategorized = filtered[sourceID] = {}, subcategoryValueFunction = this._sources.getSubcategoryValueFunction(sourceID), subcategorySortFunction = this._sources.getSubcategorySortFunction(sourceID), categorizedEntries[sourceID].forEach(function(entryWrapper) {
                                    var subcategoryValue;
                                    matchesSearch(entryWrapper) && (subcategoryValue = subcategoryValueFunction(entryWrapper.entry), subcategorized[subcategoryValue] ? subcategorized[subcategoryValue].push(entryWrapper) : subcategorized[subcategoryValue] = [entryWrapper], entryCount++)
                                }), this._sortedSubcategoryValues = Object.keys(subcategorized).sort(function(a, b) {
                                    return subcategorySortFunction.call(this._select, a, b, settings.meta, this._sources.extraData)
                                }.bind(this))) : (filtered[sourceID] = categorizedEntries[sourceID].filter(function(entryWrapper) {
                                    return matchesSearch(entryWrapper)
                                }.bind(this)), entryCount = filtered[sourceID].length), this._entryCount[sourceID] = entryCount
                            }.bind(this)), this._processedCategories = filtered, this._collectEntriesAndRender()
                        }.bind(this);
                        this._searchValue || this._searchValue !== this._previousSearchValue ? (this._hideTooltip(), this._scroller.hide(), this._removeEntries(), this.resultsElement.scrollTop = 0, this.resultsElement.appendChild(this._loadingElement), this._entries = null, window.setTimeout(update, selectUtil.PREVENT_LOCKUP_TIMEOUT), this._previousSearchValue = this._searchValue) : update()
                    }, VirtualResults.prototype.renderResults = function() {
                        var newEntryKeys, entryIndex;
                        this._entries && null != this.resultsElement.offsetParent && (this._initializeTooltip(), this._calculateScrollingDimensions(), this._lastRepaintScroll = 0, this._loadingElement.parentNode && this.resultsElement.removeChild(this._loadingElement), this.toggleInputs(!0, !0), this._scrollToNew && (newEntryKeys = Object.keys(this._newEntryIndexMap)).length ? (entryIndex = this._newEntryIndexMap[newEntryKeys[0]], this.resultsElement.scrollTop = this._calculateEntryOffset(entryIndex) - this._displayBuffer / 2 + this._entryHeight / 2, this._renderScrolledChunk(!0)) : this._maintainScrollPosition ? this._renderScrolledChunk(!0) : (this.resultsElement.scrollTop = 0, this._renderChunk(0)), this._scrollToNew = !1, this._maintainScrollPosition = !1)
                    }, VirtualResults.prototype.scrollToNewNextRender = function() {
                        this._scrollToNew = !0
                    }, VirtualResults.prototype.resizeResults = function() {
                        this._calculateScrollingDimensions(), this._lastRepaintScroll = null, this._renderScrolledChunk()
                    }, VirtualResults.prototype.createNew = function() {
                        var createNewElement, returnButton, titleElement, createNewSources = this._sources.getGrouping()[this._currentGroup].createNewSupported, createNew = function(sourceID) {
                            var promise;
                            this._select._queueSourceChangeReloads(), promise = this._select.DEFAULT_CREATE_NEW_FUNCTION(sourceID, this._searchValue), $.when(promise).always(function() {
                                this._select._dequeueSourceChangeReloads()
                            }.bind(this))
                        }.bind(this), returnToResults = function(event, focusInputs) {
                            event.stopPropagation(), this.toggleInputs(!0, focusInputs), createNewElement.parentElement.insertBefore(this.resultsElement, createNewElement), createNewElement.parentElement.removeChild(createNewElement)
                        }.bind(this);
                        createNewSources.length > 1 ? null != this.resultsElement.offsetParent && (createNewElement = document.createElement("div"), createNewElement.className = "virtual-results", returnButton = document.createElement("button"), returnButton.className = "bare", returnButton.setAttribute("title", this._select.RETURN_TITLE), returnButton.innerHTML = '<f-icon class="fa-arrow-left"></f-icon>', returnButton.addEventListener("click", function(event) {
                            returnToResults(event, !0)
                        }), titleElement = document.createElement("div"), titleElement.className = "create-new-title", titleElement.innerHTML = "<span>" + this._select.CREATE_NEW_TEXT + "</span>", titleElement.appendChild(returnButton), createNewElement.appendChild(titleElement), createNewSources.forEach(function(source) {
                            var entryElement = document.createElement("div");
                            entryElement.className = "entry entry-static", entryElement.innerHTML = '<f-icon class="fa-plus icon-sm"></f-icon><span>' + source.name + "</span>", entryElement.addEventListener("click", function(event) {
                                returnToResults(event, !1), createNew(source.id)
                            }), createNewElement.appendChild(entryElement)
                        }), this.toggleInputs(!1), this.resultsElement.parentElement.insertBefore(createNewElement, this.resultsElement), this.resultsElement.parentElement.removeChild(this.resultsElement)) : createNewSources.length && createNew(createNewSources[0].id)
                    }, VirtualResults.prototype.destroy = function() {
                        this._tooltip && this._tooltip.destroy()
                    }, VirtualResults.prototype.canAdd = function(entry) {
                        var max = this._select._settings.max, selectedCount = Object.keys(this._selectedMap).length;
        