fweb_define("jquery.textarea", ["jquery"], null, function($) {
    "use strict";
    $.fn.textarea = function(userOptions) {
        var options = $.extend({}, $.fn.textarea.defaults, userOptions);
        return this.each(function() {
            function resize() {
                function adjustHeight() {
                    var lineHeight = parseFloat($textarea.css("line-height"));
                    isNaN(lineHeight) && (lineHeight = 1.2 * parseFloat($textarea.css("font-size")));
                    var lines = $textarea.attr("rows") || $textarea.prop("rows");
                    "" === $textarea.val() && (lines = 1);
                    var padding = "border-box" === $textarea.css("box-sizing") ? $textarea.outerHeight() - $textarea.height() : 0;
                    $textarea.css("height", lines * lineHeight + padding)
                }
                if ($textarea.is(":visible")) {
                    for (var textarea = $textarea[0]; textarea.rows > minRows && textarea.scrollHeight < textarea.offsetHeight; )
                        textarea.rows--, adjustHeight();
                    for (; textarea.scrollHeight > textarea.offsetHeight; )
                        textarea.rows++, adjustHeight();
                    options.expandable.extraLine && textarea.rows++, adjustHeight()
                }
            }
            function addTextCount() {
                function checkLength() {
                    var textarea = $textarea[0], length = textarea.value.getBytesCRLF(!0);
                    if (length > options.maxLength) {
                        for (var text = textarea.value.substr(0, options.maxLength); text.getBytesCRLF(!0) > options.maxLength && text.length > 0; )
                            text = text.slice(0, -1);
                        var sel = {start: textarea.selectionStart,end: textarea.selectionEnd};
                        textarea.value = text, textarea.selectionStart = sel.start, textarea.selectionEnd = sel.end, options.textCount.onlimit(this)
                    }
                    var args = {$textarea: $textarea,byteLength: length,maxLength: options.maxLength};
                    options.textCount.onedit(args), $textarea.scrollTop(textarea.scrollHeight)
                }
                $("<span></span>").addClass("ui-textarea-elem-text-count").insertAfter($textarea), $textarea.keyup(function() {
                    checkLength()
                }), $textarea.on("input paste cut", function() {
                    setTimeout(checkLength, 250)
                }), checkLength()
            }
            if ("textarea" !== this.type)
                return !1;
            var $textarea = $(this), useTextCount = !1;
            $.extend(options, {resize: resize});
            var dataOptions = $textarea.data("jquery.textarea");
            if (options.maxLength = options.maxLength || parseInt($textarea.attr("maxlength")) || -1, !dataOptions || dataOptions.maxLength !== options.maxLength) {
                var $textCount = $textarea.next(".ui-textarea-elem-text-count");
                options.textCount.use && options.maxLength > 0 ? $textCount.length || (useTextCount = !0) : $textCount.remove()
            }
            if (dataOptions)
                dataOptions.maxLength = options.maxLength, dataOptions.resize && dataOptions.resize();
            else {
                $textarea.data("jquery.textarea", options);
                var minRows = options.expandable.minRows;
                if (minRows || (minRows = parseInt($textarea.attr("rows")) || 1), options.wrap !== !1) {
                    var $wrapperDiv = $("<div></div>").addClass("textarea-wrapper").css({position: "relative"});
                    $textarea.wrap($wrapperDiv)
                }
                options.expandable.use && ($textarea.css("overflow", "hidden"), $textarea.keyup(function() {
                    resize()
                }), $textarea.on("input paste cut", function() {
                    setTimeout(resize, 250)
                }), resize())
            }
            useTextCount && (addTextCount(), resize())
        })
    }, $.fn.textarea.defaults = {textCount: {use: !0,onedit: function(args) {
                args.$textarea.siblings(".ui-textarea-elem-text-count").text(args.byteLength + "/" + args.maxLength)
            },onlimit: function() {
            }},expandable: {use: !0,extraLine: !1}}
}), fweb_define("jquery.validate", ["jquery"], null, function() {
    var define = void 0;
    !function(factory) {
        "function" == typeof define && define.amd ? define(["jquery"], factory) : factory(jQuery)
    }(function($) {
        $.extend($.fn, {validate: function(options) {
                if (!this.length)
                    return void (options && options.debug && window.console && console.warn("Nothing selected, can't validate, returning nothing."));
                var validator = $.data(this[0], "validator");
                return validator ? validator : (this.attr("novalidate", "novalidate"), validator = new $.validator(options, this[0]), $.data(this[0], "validator", validator), validator.settings.onsubmit && (this.validateDelegate(":submit", "click", function(event) {
                    validator.settings.submitHandler && (validator.submitButton = event.target), $(event.target).hasClass("cancel") && (validator.cancelSubmit = !0), void 0 !== $(event.target).attr("formnovalidate") && (validator.cancelSubmit = !0)
                }), this.submit(function(event) {
                    function handle() {
                        var hidden, result;
                        return validator.settings.submitHandler ? (validator.submitButton && (hidden = $("<input type='hidden'/>").attr("name", validator.submitButton.name).val($(validator.submitButton).val()).appendTo(validator.currentForm)), result = validator.settings.submitHandler.call(validator, validator.currentForm, event), validator.submitButton && hidden.remove(), void 0 !== result ? result : !1) : !0
                    }
                    return validator.settings.debug && event.preventDefault(), validator.cancelSubmit ? (validator.cancelSubmit = !1, handle()) : validator.form() ? validator.pendingRequest ? (validator.formSubmitted = !0, !1) : handle() : (validator.focusInvalid(), !1)
                })), validator)
            },valid: function() {
                var valid, validator;
                return $(this[0]).is("form") ? valid = this.validate().form() : (valid = !0, validator = $(this[0].form).validate(), this.each(function() {
                    valid = validator.element(this) && valid
                })), valid
            },removeAttrs: function(attributes) {
                var result = {}, $element = this;
                return $.each(attributes.split(/\s/), function(index, value) {
                    result[value] = $element.attr(value), $element.removeAttr(value)
                }), result
            },rules: function(command, argument) {
                var settings, staticRules, existingRules, data, param, filtered, element = this[0];
                if (command)
                    switch (settings = $.data(element.form, "validator").settings, staticRules = settings.rules, existingRules = $.validator.staticRules(element), command) {
                        case "add":
                            $.extend(existingRules, $.validator.normalizeRule(argument)), delete existingRules.messages, staticRules[element.name] = existingRules, argument.messages && (settings.messages[element.name] = $.extend(settings.messages[element.name], argument.messages));
                            break;
                        case "remove":
                            return argument ? (filtered = {}, $.each(argument.split(/\s/), function(index, method) {
                                filtered[method] = existingRules[method], delete existingRules[method], "required" === method && $(element).removeAttr("aria-required")
                            }), filtered) : (delete staticRules[element.name], existingRules)
                    }
                return data = $.validator.normalizeRules($.extend({}, $.validator.classRules(element), $.validator.attributeRules(element), $.validator.dataRules(element), $.validator.staticRules(element)), element), data.required && (param = data.required, delete data.required, data = $.extend({required: param}, data), $(element).attr("aria-required", "true")), data.remote && (param = data.remote, delete data.remote, data = $.extend(data, {remote: param})), data
            }}), $.extend($.expr[":"], {blank: function(a) {
                return !$.trim("" + $(a).val())
            },filled: function(a) {
                return !!$.trim("" + $(a).val())
            },unchecked: function(a) {
                return !$(a).prop("checked")
            }}), $.validator = function(options, form) {
            this.settings = $.extend(!0, {}, $.validator.defaults, options), this.currentForm = form, this.init()
        }, $.validator.format = function(source, params) {
            return 1 === arguments.length ? function() {
                var args = $.makeArray(arguments);
                return args.unshift(source), $.validator.format.apply(this, args)
            } : (arguments.length > 2 && params.constructor !== Array && (params = $.makeArray(arguments).slice(1)), params.constructor !== Array && (params = [params]), $.each(params, function(i, n) {
                source = source.replace(new RegExp("\\{" + i + "\\}", "g"), function() {
                    return n
                })
            }), source)
        }, $.extend($.validator, {defaults: {messages: {},groups: {},rules: {},errorClass: "error",validClass: "valid",errorElement: "label",focusCleanup: !1,focusInvalid: !0,errorContainer: $([]),errorLabelContainer: $([]),onsubmit: !0,ignore: ":hidden",ignoreTitle: !1,onfocusin: function(element) {
                    this.lastActive = element, this.settings.focusCleanup && (this.settings.unhighlight && this.settings.unhighlight.call(this, element, this.settings.errorClass, this.settings.validClass), this.hideThese(this.errorsFor(element)))
                },onfocusout: function(element) {
                    this.checkable(element) || !(element.name in this.submitted) && this.optional(element) || this.element(element)
                },onkeyup: function(element, event) {
                    (9 !== event.which || "" !== this.elementValue(element)) && (element.name in this.submitted || element === this.lastElement) && this.element(element)
                },onclick: function(element) {
                    element.name in this.submitted ? this.element(element) : element.parentNode.name in this.submitted && this.element(element.parentNode)
                },highlight: function(element, errorClass, validClass) {
                    "radio" === element.type ? this.findByName(element.name).addClass(errorClass).removeClass(validClass) : $(element).addClass(errorClass).removeClass(validClass)
                },unhighlight: function(element, errorClass, validClass) {
                    "radio" === element.type ? this.findByName(element.name).removeClass(errorClass).addClass(validClass) : $(element).removeClass(errorClass).addClass(validClass)
                }},setDefaults: function(settings) {
                $.extend($.validator.defaults, settings)
            },messages: {required: "This field is required.",remote: "Please fix this field.",email: "Please enter a valid email address.",url: "Please enter a valid URL.",date: "Please enter a valid date.",dateISO: "Please enter a valid date ( ISO ).",number: "Please enter a valid number.",digits: "Please enter only digits.",creditcard: "Please enter a valid credit card number.",equalTo: "Please enter the same value again.",maxlength: $.validator.format("Please enter no more than {0} characters."),minlength: $.validator.format("Please enter at least {0} characters."),rangelength: $.validator.format("Please enter a value between {0} and {1} characters long."),range: $.validator.format("Please enter a value between {0} and {1}."),max: $.validator.format("Please enter a value less than or equal to {0}."),min: $.validator.format("Please enter a value greater than or equal to {0}.")},autoCreateRanges: !1,prototype: {init: function() {
                    function delegate(event) {
                        var validator = $.data(this[0].form, "validator"), eventType = "on" + event.type.replace(/^validate/, ""), settings = validator.settings;
                        settings[eventType] && !this.is(settings.ignore) && settings[eventType].call(validator, this[0], event)
                    }
                    this.labelContainer = $(this.settings.errorLabelContainer), this.errorContext = this.labelContainer.length && this.labelContainer || $(this.currentForm), this.containers = $(this.settings.errorContainer).add(this.settings.errorLabelContainer), this.submitted = {}, this.valueCache = {}, this.pendingRequest = 0, this.pending = {}, this.invalid = {}, this.reset();
                    var rules, groups = this.groups = {};
                    $.each(this.settings.groups, function(key, value) {
                        "string" == typeof value && (value = value.split(/\s/)), $.each(value, function(index, name) {
                            groups[name] = key
                        })
                    }), rules = this.settings.rules, $.each(rules, function(key, value) {
                        rules[key] = $.validator.normalizeRule(value)
                    }), $(this.currentForm).validateDelegate(":text, [type='password'], [type='file'], select, textarea, [type='number'], [type='search'] ,[type='tel'], [type='url'], [type='email'], [type='datetime'], [type='date'], [type='month'], [type='week'], [type='time'], [type='datetime-local'], [type='range'], [type='color'], [type='radio'], [type='checkbox']", "focusin focusout keyup", delegate).validateDelegate("select, option, [type='radio'], [type='checkbox']", "click", delegate), this.settings.invalidHandler && $(this.currentForm).bind("invalid-form.validate", this.settings.invalidHandler), $(this.currentForm).find("[required], [data-rule-required], .required").attr("aria-required", "true")
                },form: function() {
                    return this.checkForm(), $.extend(this.submitted, this.errorMap), this.invalid = $.extend({}, this.errorMap), this.valid() || $(this.currentForm).triggerHandler("invalid-form", [this]), this.showErrors(), this.valid()
                },checkForm: function() {
                    this.prepareForm();
                    for (var i = 0, elements = this.currentElements = this.elements(); elements[i]; i++)
                        this.check(elements[i]);
                    return this.valid()
                },element: function(element) {
                    var cleanElement = this.clean(element), checkElement = this.validationTargetFor(cleanElement), result = !0;
                    return this.lastElement = checkElement, void 0 === checkElement ? delete this.invalid[cleanElement.name] : (this.prepareElement(checkElement), this.currentElements = $(checkElement), result = this.check(checkElement) !== !1, result ? delete this.invalid[checkElement.name] : this.invalid[checkElement.name] = !0), $(element).attr("aria-invalid", !result), this.numberOfInvalids() || (this.toHide = this.toHide.add(this.containers)), this.showErrors(), result
                },showErrors: function(errors) {
                    if (errors) {
                        $.extend(this.errorMap, errors), this.errorList = [];
                        for (var name in errors)
                            this.errorList.push({message: errors[name],element: this.findByName(name)[0]});
                        this.successList = $.grep(this.successList, function(element) {
                            return !(element.name in errors)
                        })
                    }
                    this.settings.showErrors ? this.settings.showErrors.call(this, this.errorMap, this.errorList) : this.defaultShowErrors()
                },resetForm: function() {
                    $.fn.resetForm && $(this.currentForm).resetForm(), this.submitted = {}, this.lastElement = null, this.prepareForm(), this.hideErrors(), this.elements().removeClass(this.settings.errorClass).removeData("previousValue").removeAttr("aria-invalid")
                },numberOfInvalids: function() {
                    return this.objectLength(this.invalid)
                },objectLength: function(obj) {
                    var i, count = 0;
                    for (i in obj)
                        count++;
                    return count
                },hideErrors: function() {
                    this.hideThese(this.toHide)
                },hideThese: function(errors) {
                    errors.not(this.containers).text(""), this.addWrapper(errors).hide()
                },valid: function() {
                    return 0 === this.size()
                },size: function() {
                    return this.errorList.length
                },focusInvalid: function() {
                    if (this.settings.focusInvalid)
                        try {
                            $(this.findLastActive() || this.errorList.length && this.errorList[0].element || []).filter(":visible").focus().trigger("focusin")
                        } catch (e) {
                        }
                },findLastActive: function() {
                    var lastActive = this.lastActive;
                    return lastActive && 1 === $.grep(this.errorList, function(n) {
                        return n.element.name === lastActive.name
                    }).length && lastActive
                },elements: function() {
                    var validator = this, rulesCache = {};
                    return $(this.currentForm).find("input, select, textarea").not(":submit, :reset, :image, [disabled], [readonly]").not(this.settings.ignore).filter(function() {
                        return !this.name && validator.settings.debug && window.console && console.error("%o has no name assigned", this), this.name in rulesCache || !validator.objectLength($(this).rules()) ? !1 : (rulesCache[this.name] = !0, !0)
                    })
                },clean: function(selector) {
                    return $(selector)[0]
                },errors: function() {
                    var errorClass = this.settings.errorClass.split(" ").join(".");
                    return $(this.settings.errorElement + "." + errorClass, this.errorContext)
                },reset: function() {
                    this.successList = [], this.errorList = [], this.errorMap = {}, this.toShow = $([]), this.toHide = $([]), this.currentElements = $([])
                },prepareForm: function() {
                    this.reset(), this.toHide = this.errors().add(this.containers)
                },prepareElement: function(element) {
                    this.reset(), this.toHide = this.errorsFor(element)
                },elementValue: function(element) {
                    var val, $element = $(element), type = element.type;
                    return "radio" === type || "checkbox" === type ? $("input[name='" + element.name + "']:checked").val() : "number" === type && "undefined" != typeof element.validity ? element.validity.badInput ? !1 : $element.val() : (val = $element.val(), "string" == typeof val ? val.replace(/\r/g, "") : val)
                },check: function(element) {
                    element = this.validationTargetFor(this.clean(element));
                    var result, method, rule, rules = $(element).rules(), rulesCount = $.map(rules, function(n, i) {
                        return i
                    }).length, dependencyMismatch = !1, val = this.elementValue(element);
                    for (method in rules) {
                        rule = {method: method,parameters: rules[method]};
                        try {
                            if (result = $.validator.methods[method].call(this, val, element, rule.parameters), "dependency-mismatch" === result && 1 === rulesCount) {
                                dependencyMismatch = !0;
                                continue
                            }
                            if (dependencyMismatch = !1, "pending" === result)
                                return void (this.toHide = this.toHide.not(this.errorsFor(element)));
                            if (!result)
                                return this.formatAndAdd(element, rule), !1
                        } catch (e) {
                            throw this.settings.debug && window.console && console.log("Exception occurred when checking element " + element.id + ", check the '" + rule.method + "' method.", e), e
                        }
                    }
                    if (!dependencyMismatch)
                        return this.objectLength(rules) && this.successList.push(element), !0
                },customDataMessage: function(element, method) {
                    return $(element).data("msg" + method.charAt(0).toUpperCase() + method.substring(1).toLowerCase()) || $(element).data("msg")
                },customMessage: function(name, method) {
                    var m = this.settings.messages[name];
                    return m && (m.constructor === String ? m : m[method])
                },findDefined: function() {
                    for (var i = 0; i < arguments.length; i++)
                        if (void 0 !== arguments[i])
                            return arguments[i]
                },defaultMessage: function(element, method) {
                    return this.findDefined(this.customMessage(element.name, method), this.customDataMessage(element, method), !this.settings.ignoreTitle && element.title || void 0, $.validator.messages[method], "<strong>Warning: No message defined for " + element.name + "</strong>")
                },formatAndAdd: function(element, rule) {
                    var message = this.defaultMessage(element, rule.method), theregex = /\$?\{(\d+)\}/g;
                    "function" == typeof message ? message = message.call(this, rule.parameters, element) : theregex.test(message) && (message = $.validator.format(message.replace(theregex, "{$1}"), rule.parameters)), this.errorList.push({message: message,element: element,method: rule.method}), this.errorMap[element.name] = message, this.submitted[element.name] = message
                },addWrapper: function(toToggle) {
                    return this.settings.wrapper && (toToggle = toToggle.add(toToggle.parent(this.settings.wrapper))), toToggle
                },defaultShowErrors: function() {
                    var i, elements, error;
                    for (i = 0; this.errorList[i]; i++)
                        error = this.errorList[i], this.settings.highlight && this.settings.highlight.call(this, error.element, this.settings.errorClass, this.settings.validClass), this.showLabel(error.element, error.message);
                    if (this.errorList.length && (this.toShow = this.toShow.add(this.containers)), this.settings.success)
                        for (i = 0; this.successList[i]; i++)
                            this.showLabel(this.successList[i]);
                    if (this.settings.unhighlight)
                        for (i = 0, elements = this.validElements(); elements[i]; i++)
                            this.settings.unhighlight.call(this, elements[i], this.settings.errorClass, this.settings.validClass);
                    this.toHide = this.toHide.not(this.toShow), this.hideErrors(), this.addWrapper(this.toShow).show()
                },validElements: function() {
                    return this.currentElements.not(this.invalidElements())
                },invalidElements: function() {
                    return $(this.errorList).map(function() {
                        return this.element
                    })
                },showLabel: function(element, message) {
                    var place, group, errorID, error = this.errorsFor(element), elementID = this.idOrName(element), describedBy = $(element).attr("aria-describedby");
                    error.length ? (error.removeClass(this.settings.validClass).addClass(this.settings.errorClass), error.html(message)) : (error = $("<" + this.settings.errorElement + ">").attr("id", elementID + "-error").addClass(this.settings.errorClass).html(message || ""), place = error, this.settings.wrapper && (place = error.hide().show().wrap("<" + this.settings.wrapper + "/>").parent()), this.labelContainer.length ? this.labelContainer.append(place) : this.settings.errorPlacement ? this.settings.errorPlacement(place, $(element)) : place.insertAfter(element), error.is("label") ? error.attr("for", elementID) : 0 === error.parents("label[for='" + elementID + "']").length && (errorID = error.attr("id").replace(/(:|\.|\[|\])/g, "\\$1"), describedBy ? describedBy.match(new RegExp("\\b" + errorID + "\\b")) || (describedBy += " " + errorID) : describedBy = errorID, $(element).attr("aria-describedby", describedBy), group = this.groups[element.name], group && $.each(this.groups, function(name, testgroup) {
                        testgroup === group && $("[name='" + name + "']", this.currentForm).attr("aria-describedby", error.attr("id"))
                    }))), !message && this.settings.success && (error.text(""), "string" == typeof this.settings.success ? error.addClass(this.settings.success) : this.settings.success(error, element)), this.toShow = this.toShow.add(error)
                },errorsFor: function(element) {
                    var name = this.idOrName(element), describer = $(element).attr("aria-describedby"), selector = "label[for='" + name + "'], label[for='" + name + "'] *";
                    return describer && (selector = selector + ", #" + describer.replace(/\s+/g, ", #")), this.errors().filter(selector)
                },idOrName: function(element) {
                    return this.groups[element.name] || (this.checkable(element) ? element.name : element.id || element.name)
                },validationTargetFor: function(element) {
                    return this.checkable(element) && (element = this.findByName(element.name)), $(element).not(this.settings.ignore)[0]
                },checkable: function(element) {
                    return /radio|checkbox/i.test(element.type)
                },findByName: function(name) {
                    return $(this.currentForm).find("[name='" + name + "']")
                },getLength: function(value, element) {
                    switch (element.nodeName.toLowerCase()) {
                        case "select":
                            return $("option:selected", element).length;
                        case "input":
                            if (this.checkable(element))
                                return this.findByName(element.name).filter(":checked").length
                    }
                    return value.length
                },depend: function(param, element) {
                    return this.dependTypes[typeof param] ? this.dependTypes[typeof param](param, element) : !0
                },dependTypes: {"boolean": function(param) {
                        return param
                    },string: function(param, element) {
                        return !!$(param, element.form).length
                    },"function": function(param, element) {
                        return param(element)
                    }},optional: function(element) {
                    var val = this.elementValue(element);
                    return !$.validator.methods.required.call(this, val, element) && "dependency-mismatch"
                },startRequest: function(element) {
                    this.pending[element.name] || (this.pendingRequest++, this.pending[element.name] = !0)
                },stopRequest: function(element, valid) {
                    this.pendingRequest--, this.pendingRequest < 0 && (this.pendingRequest = 0), delete this.pending[element.name], valid && 0 === this.pendingRequest && this.formSubmitted && this.form() ? ($(this.currentForm).submit(), this.formSubmitted = !1) : !valid && 0 === this.pendingRequest && this.formSubmitted && ($(this.currentForm).triggerHandler("invalid-form", [this]), this.formSubmitted = !1)
                },previousValue: function(element) {
                    return $.data(element, "previousValue") || $.data(element, "previousValue", {old: null,valid: !0,message: this.defaultMessage(element, "remote")})
                }},classRuleSettings: {required: {required: !0},email: {email: !0},url: {url: !0},date: {date: !0},dateISO: {dateISO: !0},number: {number: !0},digits: {digits: !0},creditcard: {creditcard: !0}},addClassRules: function(className, rules) {
                className.constructor === String ? this.classRuleSettings[className] = rules : $.extend(this.classRuleSettings, className)
            },classRules: function(element) {
                var rules = {}, classes = $(element).attr("class");
                return classes && $.each(classes.split(" "), function() {
                    this in $.validator.classRuleSettings && $.extend(rules, $.validator.classRuleSettings[this])
                }), rules
            },attributeRules: function(element) {
                var method, value, rules = {}, $element = $(element), type = element.getAttribute("type");
                for (method in $.validator.methods)
                    "required" === method ? (value = element.getAttribute(method), "" === value && (value = !0), value = !!value) : value = $element.attr(method), /min|max/.test(method) && (null === type || /number|range|text/.test(type)) && (value = Number(value)), value || 0 === value ? rules[method] = value : type === method && "range" !== type && (rules[method] = !0);
                return rules.maxlength && /-1|2147483647|524288/.test(rules.maxlength) && delete rules.maxlength, rules
            },dataRules: function(element) {
                var method, value, rules = {}, $element = $(element);
                for (method in $.validator.methods)
                    value = $element.data("rule" + method.charAt(0).toUpperCase() + method.substring(1).toLowerCase()), void 0 !== value && (rules[method] = value);
                return rules
            },staticRules: function(element) {
                var rules = {}, validator = $.data(element.form, "validator");
                return validator.settings.rules && (rules = $.validator.normalizeRule(validator.settings.rules[element.name]) || {}), rules
            },normalizeRules: function(rules, element) {
                return $.each(rules, function(prop, val) {
                    if (val === !1)
                        return void delete rules[prop];
                    if (val.param || val.depends) {
                        var keepRule = !0;
                        switch (typeof val.depends) {
                            case "string":
                                keepRule = !!$(val.depends, element.form).length;
                                break;
                            case "function":
                                keepRule = val.depends.call(element, element)
                        }
                        keepRule ? rules[prop] = void 0 !== val.param ? val.param : !0 : delete rules[prop]
                    }
                }), $.each(rules, function(rule, parameter) {
                    rules[rule] = $.isFunction(parameter) ? parameter(element) : parameter
                }), $.each(["minlength", "maxlength"], function() {
                    rules[this] && (rules[this] = Number(rules[this]))
                }), $.each(["rangelength", "range"], function() {
                    var parts;
                    rules[this] && ($.isArray(rules[this]) ? rules[this] = [Number(rules[this][0]), Number(rules[this][1])] : "string" == typeof rules[this] && (parts = rules[this].replace(/[\[\]]/g, "").split(/[\s,]+/), rules[this] = [Number(parts[0]), Number(parts[1])]))
                }), $.validator.autoCreateRanges && (null != rules.min && null != rules.max && (rules.range = [rules.min, rules.max], delete rules.min, delete rules.max), null != rules.minlength && null != rules.maxlength && (rules.rangelength = [rules.minlength, rules.maxlength], delete rules.minlength, delete rules.maxlength)), rules
            },normalizeRule: function(data) {
                if ("string" == typeof data) {
                    var transformed = {};
                    $.each(data.split(/\s/), function() {
                        transformed[this] = !0
                    }), data = transformed
                }
                return data
            },addMethod: function(name, method, message) {
                $.validator.methods[name] = method, $.validator.messages[name] = void 0 !== message ? message : $.validator.messages[name], method.length < 3 && $.validator.addClassRules(name, $.validator.normalizeRule(name))
            },methods: {required: function(value, element, param) {
                    if (!this.depend(param, element))
                        return "dependency-mismatch";
                    if ("select" === element.nodeName.toLowerCase()) {
                        var val = $(element).val();
                        return val && val.length > 0
                    }
                    return this.checkable(element) ? this.getLength(value, element) > 0 : $.trim(value).length > 0
                },email: function(value, element) {
                    return this.optional(element) || /^[a-zA-Z0-9.!#$%&'*+\/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$/.test(value)
                },url: function(value, element) {
                    return this.optional(element) || /^(https?|s?ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i.test(value)
                },date: function(value, element) {
                    return this.optional(element) || !/Invalid|NaN/.test(new Date(value).toString())
                },dateISO: function(value, element) {
                    return this.optional(element) || /^\d{4}[\/\-](0?[1-9]|1[012])[\/\-](0?[1-9]|[12][0-9]|3[01])$/.test(value)
                },number: function(value, element) {
                    return this.optional(element) || /^-?(?:\d+|\d{1,3}(?:,\d{3})+)?(?:\.\d+)?$/.test(value)
                },digits: function(value, element) {
                    return this.optional(element) || /^\d+$/.test(value)
                },creditcard: function(value, element) {
                    if (this.optional(element))
                        return "dependency-mismatch";
                    if (/[^0-9 \-]+/.test(value))
                        return !1;
                    var n, cDigit, nCheck = 0, nDigit = 0, bEven = !1;
                    if (value = value.replace(/\D/g, ""), value.length < 13 || value.length > 19)
                        return !1;
                    for (n = value.length - 1; n >= 0; n--)
                        cDigit = value.charAt(n), nDigit = parseInt(cDigit, 10), bEven && (nDigit *= 2) > 9 && (nDigit -= 9), nCheck += nDigit, bEven = !bEven;
                    return nCheck % 10 === 0
                },minlength: function(value, element, param) {
                    var length = $.isArray(value) ? value.length : this.getLength(value, element);
                    return this.optional(element) || length >= param
                },maxlength: function(value, element, param) {
                    var length = $.isArray(value) ? value.length : this.getLength(value, element);
                    return this.optional(element) || param >= length
                },rangelength: function(value, element, param) {
                    var length = $.isArray(value) ? value.length : this.getLength(value, element);
                    return this.optional(element) || length >= param[0] && length <= param[1]
                },min: function(value, element, param) {
                    return this.optional(element) || value >= param
                },max: function(value, element, param) {
                    return this.optional(element) || param >= value
                },range: function(value, element, param) {
                    return this.optional(element) || value >= param[0] && value <= param[1]
                },equalTo: function(value, element, param) {
                    var target = $(param);
                    return this.settings.onfocusout && target.unbind(".validate-equalTo").bind("blur.validate-equalTo", function() {
                        $(element).valid()
                    }), value === target.val()
                },remote: function(value, element, param) {
                    if (this.optional(element))
                        return "dependency-mismatch";
                    var validator, data, previous = this.previousValue(element);
                    return this.settings.messages[element.name] || (this.settings.messages[element.name] = {}), previous.originalMessage = this.settings.messages[element.name].remote, this.settings.messages[element.name].remote = previous.message, param = "string" == typeof param && {url: param} || param, previous.old === value ? previous.valid : (previous.old = value, validator = this, this.startRequest(element), data = {}, data[element.name] = value, $.ajax($.extend(!0, {url: param,mode: "abort",port: "validate" + element.name,dataType: "json",data: data,context: validator.currentForm,success: function(response) {
                            var errors, message, submitted, valid = response === !0 || "true" === response;
                            validator.settings.messages[element.name].remote = previous.originalMessage, valid ? (submitted = validator.formSubmitted, validator.prepareElement(element), validator.formSubmitted = submitted, validator.successList.push(element), delete validator.invalid[element.name], validator.showErrors()) : (errors = {}, message = response || validator.defaultMessage(element, "remote"), errors[element.name] = previous.message = $.isFunction(message) ? message(value) : message, validator.invalid[element.name] = !0, validator.showErrors(errors)), previous.valid = valid, validator.stopRequest(element, valid)
                        }}, param)), "pending")
                }}}), $.format = function() {
            throw "$.format has been deprecated. Please use $.validator.format instead."
        };
        var ajax, pendingRequests = {};
        $.ajaxPrefilter ? $.ajaxPrefilter(function(settings, _, xhr) {
            var port = settings.port;
            "abort" === settings.mode && (pendingRequests[port] && pendingRequests[port].abort(), pendingRequests[port] = xhr)
        }) : (ajax = $.ajax, $.ajax = function(settings) {
            var mode = ("mode" in settings ? settings : $.ajaxSettings).mode, port = ("port" in settings ? settings : $.ajaxSettings).port;
            return "abort" === mode ? (pendingRequests[port] && pendingRequests[port].abort(), pendingRequests[port] = ajax.apply(this, arguments), pendingRequests[port]) : ajax.apply(this, arguments)
        }), $.extend($.fn, {validateDelegate: function(delegate, type, handler) {
                return this.bind(type, function(event) {
                    var target = $(event.target);
                    return target.is(delegate) ? handler.apply(target, arguments) : void 0
                })
            }})
    })
}), fweb_define("jquery.ezmark", ["jquery"], null, function($) {
    "use strict";
    $.fn.ezMark = function(options) {
        options = options || {};
        var defaultOpt = {checkboxCls: options.checkboxCls || "ez-checkbox",radioCls: options.radioCls || "ez-radio",checkedCls: options.checkedCls || "ez-checked",selectedCls: options.selectedCls || "ez-selected",hideCls: "ez-hide",clsReplace: options.clsReplace || !1}, $ezMarks = $();
        return $.propHooks.checked = {set: function(el, value) {
                0 !== $ezMarks.filter(el).length && (el.checked = value, $(el).trigger("change"))
            }}, this.each(function() {
            var $this = $(this);
            $ezMarks = $ezMarks.add(this);
            var wrapTag = "checkbox" === $this.attr("type") ? '<div class="' + defaultOpt.checkboxCls + '">' : '<div class="' + defaultOpt.radioCls + '">';
            "checkbox" === $this.attr("type") ? $this.addClass(defaultOpt.hideCls).wrap(wrapTag).change(function() {
                var $chk = $(this);
                $chk.is(":checked") ? ($chk.parent().addClass(defaultOpt.checkedCls), defaultOpt.clsReplace && $chk.parent().removeClass(defaultOpt.checkboxCls)) : ($chk.parent().removeClass(defaultOpt.checkedCls), defaultOpt.clsReplace && $chk.parent().addClass(defaultOpt.checkboxCls)), $this.blur()
            }).change() : "radio" === $this.attr("type") && $this.addClass(defaultOpt.hideCls).wrap(wrapTag).change(function() {
                $('input[name="' + $(this).attr("name") + '"]').each(function() {
                    var $rdo = $(this);
                    $rdo.is(":checked") ? ($rdo.parent().addClass(defaultOpt.selectedCls), defaultOpt.clsReplace && $rdo.parent().removeClass(defaultOpt.radioCls)) : ($rdo.parent().removeClass(defaultOpt.selectedCls), defaultOpt.clsReplace && $rdo.parent().addClass(defaultOpt.radioCls))
                }), $this.blur()
            }).change()
        })
    }
}), fweb_define("jquery.qtip", ["jquery"], null, function() {
    var define = void 0;
    !function(window, document, undefined) {
        !function(factory) {
            "use strict";
            "function" == typeof define && define.amd ? define(["jquery"], factory) : jQuery && !jQuery.fn.qtip && factory(jQuery)
        }(function($) {
            "use strict";
            function QTip(target, options, id, attr) {
                this.id = id, this.target = target, this.tooltip = NULL, this.elements = {target: target}, this._id = NAMESPACE + "-" + id, this.timers = {img: {}}, this.options = options, this.plugins = {}, this.cache = {event: {},target: $(),disabled: FALSE,attr: attr,onTooltip: FALSE,lastClass: ""}, this.rendered = this.destroyed = this.disabled = this.waiting = this.hiddenDuringWait = this.positioning = this.triggering = FALSE
            }
            function invalidOpt(a) {
                return a === NULL || "object" !== $.type(a)
            }
            function invalidContent(c) {
                return !($.isFunction(c) || c && c.attr || c.length || "object" === $.type(c) && (c.jquery || c.then))
            }
            function sanitizeOptions(opts) {
                var content, text, ajax, once;
                return invalidOpt(opts) ? FALSE : (invalidOpt(opts.metadata) && (opts.metadata = {type: opts.metadata}), "content" in opts && (content = opts.content, invalidOpt(content) || content.jquery || content.done ? content = opts.content = {text: text = invalidContent(content) ? FALSE : content} : text = content.text, "ajax" in content && (ajax = content.ajax, once = ajax && ajax.once !== FALSE, delete content.ajax, content.text = function(event, api) {
                    var loading = text || $(this).attr(api.options.content.attr) || "Loading...", deferred = $.ajax($.extend({}, ajax, {context: api})).then(ajax.success, NULL, ajax.error).then(function(content) {
                        return content && once && api.set("content.text", content), content
                    }, function(xhr, status, error) {
                        api.destroyed || 0 === xhr.status || api.set("content.text", status + ": " + error)
                    });
                    return once ? loading : (api.set("content.text", loading), deferred)
                }), "title" in content && (invalidOpt(content.title) || (content.button = content.title.button, content.title = content.title.text), invalidContent(content.title || FALSE) && (content.title = FALSE))), "position" in opts && invalidOpt(opts.position) && (opts.position = {my: opts.position,at: opts.position}), "show" in opts && invalidOpt(opts.show) && (opts.show = opts.show.jquery ? {target: opts.show} : opts.show === TRUE ? {ready: TRUE} : {event: opts.show}), "hide" in opts && invalidOpt(opts.hide) && (opts.hide = opts.hide.jquery ? {target: opts.hide} : {event: opts.hide}), "style" in opts && invalidOpt(opts.style) && (opts.style = {classes: opts.style}), $.each(PLUGINS, function() {
                    this.sanitize && this.sanitize(opts)
                }), opts)
            }
            function convertNotation(options, notation) {
                for (var obj, i = 0, option = options, levels = notation.split("."); option = option[levels[i++]]; )
                    i < levels.length && (obj = option);
                return [obj || options, levels.pop()]
            }
            function setCallback(notation, args) {
                var category, rule, match;
                for (category in this.checks)
                    for (rule in this.checks[category])
                        (match = new RegExp(rule, "i").exec(notation)) && (args.push(match), ("builtin" === category || this.plugins[category]) && this.checks[category][rule].apply(this.plugins[category] || this, args))
            }
            function createWidgetClass(cls) {
                return WIDGET.concat("").join(cls ? "-" + cls + " " : " ")
            }
            function cloneEvent(event) {
                return event && {type: event.type,pageX: event.pageX,pageY: event.pageY,target: event.target,relatedTarget: event.relatedTarget,scrollX: event.scrollX || window.pageXOffset || document.body.scrollLeft || document.documentElement.scrollLeft,scrollY: event.scrollY || window.pageYOffset || document.body.scrollTop || document.documentElement.scrollTop} || {}
            }
            function delay(callback, duration) {
                return duration > 0 ? setTimeout($.proxy(callback, this), duration) : void callback.call(this)
            }
            function showMethod(event) {
                return this.tooltip.hasClass(CLASS_DISABLED) ? FALSE : (clearTimeout(this.timers.show), clearTimeout(this.timers.hide), void (this.timers.show = delay.call(this, function() {
                    this.toggle(TRUE, event)
                }, this.options.show.delay)))
            }
            function hideMethod(event) {
                if (this.tooltip.hasClass(CLASS_DISABLED))
                    return FALSE;
                var relatedTarget = $(event.relatedTarget), ontoTooltip = relatedTarget.closest(SELECTOR)[0] === this.tooltip[0], ontoTarget = relatedTarget[0] === this.options.show.target[0];
                if (clearTimeout(this.timers.show), clearTimeout(this.timers.hide), this !== relatedTarget[0] && "mouse" === this.options.position.target && ontoTooltip || this.options.hide.fixed && /mouse(out|leave|move)/.test(event.type) && (ontoTooltip || ontoTarget))
                    try {
                        event.preventDefault(), event.stopImmediatePropagation()
                    } catch (e) {
                    }
                else
                    this.timers.hide = delay.call(this, function() {
                        this.toggle(FALSE, event)
                    }, this.options.hide.delay, this)
            }
            function inactiveMethod(event) {
                return this.tooltip.hasClass(CLASS_DISABLED) || !this.options.hide.inactive ? FALSE : (clearTimeout(this.timers.inactive), void (this.timers.inactive = delay.call(this, function() {
                    this.hide(event)
                }, this.options.hide.inactive)))
            }
            function repositionMethod(event) {
                this.rendered && this.tooltip[0].offsetWidth > 0 && this.reposition(event)
            }
            function delegate(selector, events, method) {
                $(document.body).delegate(selector, (events.split ? events : events.join(ns + " ")) + ns, function() {
                    var api = QTIP.api[$.attr(this, ATTR_ID)];
                    api && !api.disabled && method.apply(api, arguments)
                })
            }
            function init(elem, id, opts) {
                var obj, posOptions, attr, config, title, docBody = $(document.body), newTarget = elem[0] === document ? docBody : elem, metadata = elem.metadata ? elem.metadata(opts.metadata) : NULL, metadata5 = "html5" === opts.metadata.type && metadata ? metadata[opts.metadata.name] : NULL, html5 = elem.data(opts.metadata.name || "qtipopts");
                try {
                    html5 = "string" == typeof html5 ? $.parseJSON(html5) : html5
                } catch (e) {
                }
                if (config = $.extend(TRUE, {}, QTIP.defaults, opts, "object" == typeof html5 ? sanitizeOptions(html5) : NULL, sanitizeOptions(metadata5 || metadata)), posOptions = config.position, config.id = id, "boolean" == typeof config.content.text) {
                    if (attr = elem.attr(config.content.attr), config.content.attr === FALSE || !attr)
                        return FALSE;
                    config.content.text = attr
                }
                if (posOptions.container.length || (posOptions.container = docBody), posOptions.target === FALSE && (posOptions.target = newTarget), config.show.target === FALSE && (config.show.target = newTarget), config.show.solo === TRUE && (config.show.solo = posOptions.container.closest("body")), config.hide.target === FALSE && (config.hide.target = newTarget), config.position.viewport === TRUE && (config.position.viewport = posOptions.container), posOptions.container = posOptions.container.eq(0), posOptions.at = new CORNER(posOptions.at, TRUE), posOptions.my = new CORNER(posOptions.my), elem.data(NAMESPACE))
                    if (config.overwrite)
                        elem.qtip("destroy", !0);
                    else if (config.overwrite === FALSE)
                        return FALSE;
                return elem.attr(ATTR_HAS, id), config.suppress && (title = elem.attr("title")) && elem.removeAttr("title").attr(oldtitle, title).attr("title", ""), obj = new QTip(elem, config, id, !!attr), elem.data(NAMESPACE, obj), elem.one("remove.qtip-" + id + " removeqtip.qtip-" + id, function() {
                    var api;
                    (api = $(this).data(NAMESPACE)) && api.destroy(!0)
                }), obj
            }
            var QTIP, PROTOTYPE, CORNER, CHECKS, trackingBound, TRUE = !0, FALSE = !1, NULL = null, X = "x", Y = "y", WIDTH = "width", HEIGHT = "height", TOP = "top", LEFT = "left", BOTTOM = "bottom", RIGHT = "right", CENTER = "center", FLIPINVERT = "flipinvert", SHIFT = "shift", PLUGINS = {}, NAMESPACE = "qtip", ATTR_HAS = "data-hasqtip", ATTR_ID = "data-qtip-id", WIDGET = ["ui-widget", "ui-tooltip"], SELECTOR = "." + NAMESPACE, INACTIVE_EVENTS = "click dblclick mousedown mouseup mousemove mouseleave mouseenter".split(" "), CLASS_FIXED = NAMESPACE + "-fixed", CLASS_DEFAULT = NAMESPACE + "-default", CLASS_FOCUS = NAMESPACE + "-focus", CLASS_HOVER = NAMESPACE + "-hover", CLASS_DISABLED = NAMESPACE + "-disabled", replaceSuffix = "_replacedByqTip", oldtitle = "oldtitle", BROWSER = {ie: function() {
                    for (var v = 3, div = document.createElement("div"); (div.innerHTML = "<!--[if gt IE " + ++v + "]><i></i><![endif]-->") && div.getElementsByTagName("i")[0]; )
                        ;
                    return v > 4 ? v : NaN
                }(),iOS: parseFloat(("" + (/CPU.*OS ([0-9_]{1,5})|(CPU like).*AppleWebKit.*Mobile/i.exec(navigator.userAgent) || [0, ""])[1]).replace("undefined", "3_2").replace("_", ".").replace("_", "")) || FALSE};
            PROTOTYPE = QTip.prototype, PROTOTYPE._when = function(deferreds) {
                return $.when.apply($, deferreds)
            }, PROTOTYPE.render = function(show) {
                if (this.rendered || this.destroyed)
                    return this;
                var tooltip, self = this, options = this.options, cache = this.cache, elements = this.elements, text = options.content.text, title = options.content.title, button = options.content.button, posOptions = options.position, deferreds = ("." + this._id + " ", []);
                return $.attr(this.target[0], "aria-describedby", this._id), this.tooltip = elements.tooltip = tooltip = $("<div/>", {id: this._id,"class": [NAMESPACE, CLASS_DEFAULT, options.style.classes, NAMESPACE + "-pos-" + options.position.my.abbrev()].join(" "),width: options.style.width || "",height: options.style.height || "",tracking: "mouse" === posOptions.target && posOptions.adjust.mouse,role: "alert","aria-live": "polite","aria-atomic": FALSE,"aria-describedby": this._id + "-content","aria-hidden": TRUE}).toggleClass(CLASS_DISABLED, this.disabled).attr(ATTR_ID, this.id).data(NAMESPACE, this).appendTo(posOptions.container).append(elements.content = $("<div />", {"class": NAMESPACE + "-content",id: this._id + "-content","aria-atomic": TRUE})), this.rendered = -1, this.positioning = TRUE, title && (this._createTitle(), $.isFunction(title) || deferreds.push(this._updateTitle(title, FALSE))), button && this._createButton(), $.isFunction(text) || deferreds.push(this._updateContent(text, FALSE)), this.rendered = TRUE, this._setWidget(), $.each(PLUGINS, function(name) {
                    var instance;
                    "render" === this.initialize && (instance = this(self)) && (self.plugins[name] = instance)
                }), this._unassignEvents(), this._assignEvents(), this._when(deferreds).then(function() {
                    self._trigger("render"), self.positioning = FALSE, self.hiddenDuringWait || !options.show.ready && !show || self.toggle(TRUE, cache.event, FALSE), self.hiddenDuringWait = FALSE
                }), QTIP.api[this.id] = this, this
            }, PROTOTYPE.destroy = function(immediate) {
                function process() {
                    if (!this.destroyed) {
                        this.destroyed = TRUE;
                        var target = this.target, title = target.attr(oldtitle);
                        this.rendered && this.tooltip.stop(1, 0).find("*").remove().end().remove(), $.each(this.plugins, function(name) {
                            this.destroy && this.destroy()
                        }), clearTimeout(this.timers.show), clearTimeout(this.timers.hide), this._unassignEvents(), target.removeData(NAMESPACE).removeAttr(ATTR_ID).removeAttr(ATTR_HAS).removeAttr("aria-describedby"), this.options.suppress && title && target.attr("title", title).removeAttr(oldtitle), this._unbind(target), this.options = this.elements = this.cache = this.timers = this.plugins = this.mouse = NULL, delete QTIP.api[this.id]
                    }
                }
                return this.destroyed ? this.target : (immediate === TRUE && "hide" !== this.triggering || !this.rendered ? process.call(this) : (this.tooltip.one("tooltiphidden", $.proxy(process, this)), !this.triggering && this.hide()), this.target)
            }, CHECKS = PROTOTYPE.checks = {builtin: {"^id$": function(obj, o, v, prev) {
                        var id = v === TRUE ? QTIP.nextid : v, new_id = NAMESPACE + "-" + id;
                        id !== FALSE && id.length > 0 && !$("#" + new_id).length ? (this._id = new_id, this.rendered && (this.tooltip[0].id = this._id, this.elements.content[0].id = this._id + "-content", this.elements.title[0].id = this._id + "-title")) : obj[o] = prev
                    },"^prerender": function(obj, o, v) {
                        v && !this.rendered && this.render(this.options.show.ready)
                    },"^content.text$": function(obj, o, v) {
                        this._updateContent(v)
                    },"^content.attr$": function(obj, o, v, prev) {
                        this.options.content.text === this.target.attr(prev) && this._updateContent(this.target.attr(v))
                    },"^content.title$": function(obj, o, v) {
                        return v ? (v && !this.elements.title && this._createTitle(), void this._updateTitle(v)) : this._removeTitle()
                    },"^content.button$": function(obj, o, v) {
                        this._updateButton(v)
                    },"^content.title.(text|button)$": function(obj, o, v) {
                        this.set("content." + o, v)
                    },"^position.(my|at)$": function(obj, o, v) {
                        "string" == typeof v && (obj[o] = new CORNER(v, "at" === o))
                    },"^position.container$": function(obj, o, v) {
                        this.rendered && this.tooltip.appendTo(v)
                    },"^show.ready$": function(obj, o, v) {
                        v && (!this.rendered && this.render(TRUE) || this.toggle(TRUE))
                    },"^style.classes$": function(obj, o, v, p) {
                        this.rendered && this.tooltip.removeClass(p).addClass(v)
                    },"^style.(width|height)": function(obj, o, v) {
                        this.rendered && this.tooltip.css(o, v)
                    },"^style.widget|content.title": function() {
                        this.rendered && this._setWidget()
                    },"^style.def": function(obj, o, v) {
                        this.rendered && this.tooltip.toggleClass(CLASS_DEFAULT, !!v)
                    },"^events.(render|show|move|hide|focus|blur)$": function(obj, o, v) {
                        this.rendered && this.tooltip[($.isFunction(v) ? "" : "un") + "bind"]("tooltip" + o, v)
                    },"^(show|hide|position).(event|target|fixed|inactive|leave|distance|viewport|adjust)": function() {
                        if (this.rendered) {
                            var posOptions = this.options.position;
                            this.tooltip.attr("tracking", "mouse" === posOptions.target && posOptions.adjust.mouse), this._unassignEvents(), this._assignEvents()
                        }
                    }}}, PROTOTYPE.get = function(notation) {
                if (this.destroyed)
                    return this;
                var o = convertNotation(this.options, notation.toLowerCase()), result = o[0][o[1]];
                return result.precedance ? result.string() : result
            };
            var rmove = /^position\.(my|at|adjust|target|container|viewport)|style|content|show\.ready/i, rrender = /^prerender|show\.ready/i;
            PROTOTYPE.set = function(option, value) {
                if (this.destroyed)
                    return this;
                var name, rendered = this.rendered, reposition = FALSE, options = this.options;
                this.checks;
                return "string" == typeof option ? (name = option, option = {}, option[name] = value) : option = $.extend({}, option), $.each(option, function(notation, value) {
                    if (rendered && rrender.test(notation))
                        return void delete option[notation];
                    var previous, obj = convertNotation(options, notation.toLowerCase());
                    previous = obj[0][obj[1]], obj[0][obj[1]] = value && value.nodeType ? $(value) : value, reposition = rmove.test(notation) || reposition, option[notation] = [obj[0], obj[1], value, previous]
                }), sanitizeOptions(options), this.positioning = TRUE, $.each(option, $.proxy(setCallback, this)), this.positioning = FALSE, this.rendered && this.tooltip[0].offsetWidth > 0 && reposition && this.reposition("mouse" === options.position.target ? NULL : this.cache.event), this
            }, PROTOTYPE._update = function(content, element, reposition) {
                var self = this, cache = this.cache;
                return this.rendered && content ? ($.isFunction(content) && (content = content.call(this.elements.target, cache.event, this) || ""), $.isFunction(content.then) ? (cache.waiting = TRUE, content.then(function(c) {
                    return cache.waiting = FALSE, self._update(c, element)
                }, NULL, function(e) {
                    return self._update(e, element)
                })) : content === FALSE || !content && "" !== content ? FALSE : (content.jquery && content.length > 0 ? element.empty().append(content.css({display: "block",visibility: "visible"})) : element.html(content), this._waitForContent(element).then(function(images) {
                    images.images && images.images.length && self.rendered && self.tooltip[0].offsetWidth > 0 && self.reposition(cache.event, !images.length)
                }))) : FALSE
            }, PROTOTYPE._waitForContent = function(element) {
                var cache = this.cache;
                return cache.waiting = TRUE, ($.fn.imagesLoaded ? element.imagesLoaded() : $.Deferred().resolve([])).done(function() {
                    cache.waiting = FALSE
                }).promise()
            }, PROTOTYPE._updateContent = function(content, reposition) {
                this._update(content, this.elements.content, reposition)
            }, PROTOTYPE._updateTitle = function(content, reposition) {
                this._update(content, this.elements.title, reposition) === FALSE && this._removeTitle(FALSE)
            }, PROTOTYPE._createTitle = function() {
                var elements = this.elements, id = this._id + "-title";
                elements.titlebar && this._removeTitle(), elements.titlebar = $("<div />", {"class": NAMESPACE + "-titlebar " + (this.options.style.widget ? createWidgetClass("header") : "")}).append(elements.title = $("<div />", {id: id,"class": NAMESPACE + "-title","aria-atomic": TRUE})).insertBefore(elements.content).delegate(".qtip-close", "mousedown keydown mouseup keyup mouseout", function(event) {
                    $(this).toggleClass("ui-state-active ui-state-focus", "down" === event.type.substr(-4))
                }).delegate(".qtip-close", "mouseover mouseout", function(event) {
                    $(this).toggleClass("ui-state-hover", "mouseover" === event.type)
                }), this.options.content.button && this._createButton()
            }, PROTOTYPE._removeTitle = function(reposition) {
                var elements = this.elements;
                elements.title && (elements.titlebar.remove(), elements.titlebar = elements.title = elements.button = NULL, reposition !== FALSE && this.reposition())
            }, PROTOTYPE.reposition = function(event, effect) {
                if (!this.rendered || this.positioning || this.destroyed)
                    return this;
                this.positioning = TRUE;
                var pluginCalculations, offset, cache = this.cache, tooltip = this.tooltip, posOptions = this.options.position, target = posOptions.target, my = posOptions.my, at = posOptions.at, viewport = posOptions.viewport, container = posOptions.container, adjust = posOptions.adjust, method = adjust.method.split(" "), tooltipWidth = tooltip.outerWidth(FALSE), tooltipHeight = tooltip.outerHeight(FALSE), targetWidth = 0, targetHeight = 0, type = tooltip.css("position"), position = {left: 0,top: 0}, visible = tooltip[0].offsetWidth > 0, isScroll = event && "scroll" === event.type, win = $(window), doc = container[0].ownerDocument, mouse = this.mouse;
                if ($.isArray(target) && 2 === target.length)
                    at = {x: LEFT,y: TOP}, position = {left: target[0],top: target[1]};
                else if ("mouse" === target)
                    at = {x: LEFT,y: TOP}, !mouse || !mouse.pageX || !adjust.mouse && event && event.pageX ? event && event.pageX || ((!adjust.mouse || this.options.show.distance) && cache.origin && cache.origin.pageX ? event = cache.origin : (!event || event && ("resize" === event.type || "scroll" === event.type)) && (event = cache.event)) : event = mouse, "static" !== type && (position = container.offset()), doc.body.offsetWidth !== (window.innerWidth || doc.documentElement.clientWidth) && (offset = $(document.body).offset()), position = {left: event.pageX - position.left + (offset && offset.left || 0),top: event.pageY - position.top + (offset && offset.top || 0)}, adjust.mouse && isScroll && mouse && (position.left -= (mouse.scrollX || 0) - win.scrollLeft(), position.top -= (mouse.scrollY || 0) - win.scrollTop());
                else {
                    if ("event" === target ? event && event.target && "scroll" !== event.type && "resize" !== event.type ? cache.target = $(event.target) : event.target || (cache.target = this.elements.target) : "event" !== target && (cache.target = $(target.jquery ? target : this.elements.target)), target = cache.target, target = $(target).eq(0), 0 === target.length)
                        return this;
                    target[0] === document || target[0] === window ? (targetWidth = BROWSER.iOS ? window.innerWidth : target.width(), targetHeight = BROWSER.iOS ? window.innerHeight : target.height(), target[0] === window && (position = {top: (viewport || target).scrollTop(),left: (viewport || target).scrollLeft()})) : PLUGINS.imagemap && target.is("area") ? pluginCalculations = PLUGINS.imagemap(this, target, at, PLUGINS.viewport ? method : FALSE) : PLUGINS.svg && target && target[0].ownerSVGElement ? pluginCalculations = PLUGINS.svg(this, target, at, PLUGINS.viewport ? method : FALSE) : (targetWidth = target.outerWidth(FALSE), targetHeight = target.outerHeight(FALSE), position = target.offset()), pluginCalculations && (targetWidth = pluginCalculations.width, targetHeight = pluginCalculations.height, offset = pluginCalculations.offset, position = pluginCalculations.position), position = this.reposition.offset(target, position, container), (BROWSER.iOS > 3.1 && BROWSER.iOS < 4.1 || BROWSER.iOS >= 4.3 && BROWSER.iOS < 4.33 || !BROWSER.iOS && "fixed" === type) && (position.left -= win.scrollLeft(), position.top -= win.scrollTop()), (!pluginCalculations || pluginCalculations && pluginCalculations.adjustable !== FALSE) && (position.left += at.x === RIGHT ? targetWidth : at.x === CENTER ? targetWidth / 2 : 0, position.top += at.y === BOTTOM ? targetHeight : at.y === CENTER ? targetHeight / 2 : 0)
                }
                return position.left += adjust.x + (my.x === RIGHT ? -tooltipWidth : my.x === CENTER ? -tooltipWidth / 2 : 0), position.top += adjust.y + (my.y === BOTTOM ? -tooltipHeight : my.y === CENTER ? -tooltipHeight / 2 : 0), PLUGINS.viewport ? (position.adjusted = PLUGINS.viewport(this, position, posOptions, targetWidth, targetHeight, tooltipWidth, tooltipHeight), offset && position.adjusted.left && (position.left += offset.left), offset && position.adjusted.top && (position.top += offset.top)) : position.adjusted = {left: 0,top: 0}, this._trigger("move", [position, viewport.elem || viewport], event) ? (delete position.adjusted, effect === FALSE || !visible || isNaN(position.left) || isNaN(position.top) || "mouse" === target || !$.isFunction(posOptions.effect) ? tooltip.css(position) : $.isFunction(posOptions.effect) && (posOptions.effect.call(tooltip, this, $.extend({}, position)), tooltip.queue(function(next) {
                    $(this).css({opacity: "",height: ""}), BROWSER.ie && this.style.removeAttribute("filter"), next()
                })), this.positioning = FALSE, this) : this
            }, PROTOTYPE.reposition.offset = function(elem, pos, container) {
                function scroll(e, i) {
                    pos.left += i * e.scrollLeft(), pos.top += i * e.scrollTop()
                }
                if (!container[0])
                    return pos;
                var scrolled, position, parentOffset, overflow, ownerDocument = $(elem[0].ownerDocument), quirks = !!BROWSER.ie && "CSS1Compat" !== document.compatMode, parent = container[0];
                do
                    "static" !== (position = $.css(parent, "position")) && ("fixed" === position ? (parentOffset = parent.getBoundingClientRect(), scroll(ownerDocument, -1)) : (parentOffset = $(parent).position(), parentOffset.left += parseFloat($.css(parent, "borderLeftWidth")) || 0, parentOffset.top += parseFloat($.css(parent, "borderTopWidth")) || 0), pos.left -= parentOffset.left + (parseFloat($.css(parent, "marginLeft")) || 0), pos.top -= parentOffset.top + (parseFloat($.css(parent, "marginTop")) || 0), scrolled || "hidden" === (overflow = $.css(parent, "overflow")) || "visible" === overflow || (scrolled = $(parent)));
                while (parent = parent.offsetParent);
                return scrolled && (scrolled[0] !== ownerDocument[0] || quirks) && scroll(scrolled, 1), pos
            };
            var C = (CORNER = PROTOTYPE.reposition.Corner = function(corner, forceY) {
                corner = ("" + corner).replace(/([A-Z])/, " $1").replace(/middle/gi, CENTER).toLowerCase(), this.x = (corner.match(/left|right/i) || corner.match(/center/) || ["inherit"])[0].toLowerCase(), this.y = (corner.match(/top|bottom|center/i) || ["inherit"])[0].toLowerCase(), this.forceY = !!forceY;
                var f = corner.charAt(0);
                this.precedance = "t" === f || "b" === f ? Y : X
            }).prototype;
            C.invert = function(z, center) {
                this[z] = this[z] === LEFT ? RIGHT : this[z] === RIGHT ? LEFT : center || this[z]
            }, C.string = function() {
                var x = this.x, y = this.y;
                return x === y ? x : this.precedance === Y || this.forceY && "center" !== y ? y + " " + x : x + " " + y
            }, C.abbrev = function() {
                var result = this.string().split(" ");
                return result[0].charAt(0) + (result[1] && result[1].charAt(0) || "")
            }, C.clone = function() {
                return new CORNER(this.string(), this.forceY)
            }, PROTOTYPE.toggle = function(state, event) {
                var cache = this.cache, options = this.options, tooltip = this.tooltip;
                if (event) {
                    if (/over|enter/.test(event.type) && /out|leave/.test(cache.event.type) && options.show.target.add(event.target).length === options.show.target.length && tooltip.has(event.relatedTarget).length)
                        return this;
                    cache.event = cloneEvent(event)
                }
                if (this.waiting && !state && (this.hiddenDuringWait = TRUE), !this.rendered)
                    return state ? this.render(1) : this;
                if (this.destroyed || this.disabled)
                    return this;
                var identicalState, allow, after, type = state ? "show" : "hide", opts = this.options[type], posOptions = (this.options[state ? "hide" : "show"], this.options.position), contentOptions = this.options.content, width = this.tooltip.css("width"), visible = this.tooltip.is(":visible"), animate = state || 1 === opts.target.length, sameTarget = !event || opts.target.length < 2 || cache.target[0] === event.target;
                return (typeof state).search("boolean|number") && (state = !visible), identicalState = !tooltip.is(":animated") && visible === state && sameTarget, allow = identicalState ? NULL : !!this._trigger(type, [90]), this.destroyed ? this : (allow !== FALSE && state && this.focus(event), !allow || identicalState ? this : ($.attr(tooltip[0], "aria-hidden", !state), state ? (cache.origin = cloneEvent(this.mouse), $.isFunction(contentOptions.text) && this._updateContent(contentOptions.text, FALSE), $.isFunction(contentOptions.title) && this._updateTitle(contentOptions.title, FALSE), !trackingBound && "mouse" === posOptions.target && posOptions.adjust.mouse && ($(document).bind("mousemove." + NAMESPACE, this._storeMouse), trackingBound = TRUE), width || tooltip.css("width", tooltip.outerWidth(FALSE)), this.reposition(event, arguments[2]), width || tooltip.css("width", ""), opts.solo && ("string" == typeof opts.solo ? $(opts.solo) : $(SELECTOR, opts.solo)).not(tooltip).not(opts.target).qtip("hide", $.Event("tooltipsolo"))) : (clearTimeout(this.timers.show), delete cache.origin, trackingBound && !$(SELECTOR + '[tracking="true"]:visible', opts.solo).not(tooltip).length && ($(document).unbind("mousemove." + NAMESPACE), trackingBound = FALSE), this.blur(event)), after = $.proxy(function() {
                    state ? (BROWSER.ie && tooltip[0].style.removeAttribute("filter"), tooltip.css("overflow", ""), "string" == typeof opts.autofocus && $(this.options.show.autofocus, tooltip).focus(), this.options.show.target.trigger("qtip-" + this.id + "-inactive")) : tooltip.css({display: "",visibility: "",opacity: "",left: "",top: ""}), this._trigger(state ? "visible" : "hidden")
                }, this), opts.effect === FALSE || animate === FALSE ? (tooltip[type](), after()) : $.isFunction(opts.effect) ? (tooltip.stop(1, 1), opts.effect.call(tooltip, this), tooltip.queue("fx", function(n) {
                    after(), n()
                })) : tooltip.fadeTo(90, state ? 1 : 0, after), state && opts.target.trigger("qtip-" + this.id + "-inactive"), this))
            }, PROTOTYPE.show = function(event) {
                return this.toggle(TRUE, event)
            }, PROTOTYPE.hide = function(event) {
                return this.toggle(FALSE, event)
            }, PROTOTYPE.focus = function(event) {
                if (!this.rendered || this.destroyed)
                    return this;
                var qtips = $(SELECTOR), tooltip = this.tooltip, curIndex = parseInt(tooltip[0].style.zIndex, 10), newIndex = QTIP.zindex + qtips.length;
                return tooltip.hasClass(CLASS_FOCUS) || this._trigger("focus", [newIndex], event) && (curIndex !== newIndex && (qtips.each(function() {
                    this.style.zIndex > curIndex && (this.style.zIndex = this.style.zIndex - 1)
                }), qtips.filter("." + CLASS_FOCUS).qtip("blur", event)), tooltip.addClass(CLASS_FOCUS)[0].style.zIndex = newIndex), this
            }, PROTOTYPE.blur = function(event) {
                return !this.rendered || this.destroyed ? this : (this.tooltip.removeClass(CLASS_FOCUS), this._trigger("blur", [this.tooltip.css("zIndex")], event), this)
            }, PROTOTYPE.disable = function(state) {
                return this.destroyed ? this : ("toggle" === state ? state = !(this.rendered ? this.tooltip.hasClass(CLASS_DISABLED) : this.disabled) : "boolean" != typeof state && (state = TRUE), this.rendered && this.tooltip.toggleClass(CLASS_DISABLED, state).attr("aria-disabled", state), this.disabled = !!state, this)
            }, PROTOTYPE.enable = function() {
                return this.disable(FALSE)
            }, PROTOTYPE._createButton = function() {
                var self = this, elements = this.elements, tooltip = elements.tooltip, button = this.options.content.button, isString = "string" == typeof button, close = isString ? button : "Close tooltip";
                elements.button && elements.button.remove(), button.jquery ? elements.button = button : elements.button = $("<a />", {"class": "qtip-close " + (this.options.style.widget ? "" : NAMESPACE + "-icon"),title: close,"aria-label": close}).prepend($("<span />", {"class": "ui-icon ui-icon-close",html: "&times;"})), elements.button.appendTo(elements.titlebar || tooltip).attr("role", "button").click(function(event) {
                    return tooltip.hasClass(CLASS_DISABLED) || self.hide(event), FALSE
                })
            }, PROTOTYPE._updateButton = function(button) {
                if (!this.rendered)
                    return FALSE;
                var elem = this.elements.button;
                button ? this._createButton() : elem.remove()
            }, PROTOTYPE._setWidget = function() {
                var on = this.options.style.widget, elements = this.elements, tooltip = elements.tooltip, disabled = tooltip.hasClass(CLASS_DISABLED);
                tooltip.removeClass(CLASS_DISABLED), CLASS_DISABLED = on ? "ui-state-disabled" : "qtip-disabled", tooltip.toggleClass(CLASS_DISABLED, disabled), tooltip.toggleClass("ui-helper-reset " + createWidgetClass(), on).toggleClass(CLASS_DEFAULT, this.options.style.def && !on), elements.content && elements.content.toggleClass(createWidgetClass("content"), on), elements.titlebar && elements.titlebar.toggleClass(createWidgetClass("header"), on), elements.button && elements.button.toggleClass(NAMESPACE + "-icon", !on)
            }, PROTOTYPE._storeMouse = function(event) {
                (this.mouse = cloneEvent(event)).type = "mousemove"
            }, PROTOTYPE._bind = function(targets, events, method, suffix, context) {
                var ns = "." + this._id + (suffix ? "-" + suffix : "");
                events.length && $(targets).bind((events.split ? events : events.join(ns + " ")) + ns, $.proxy(method, context || this))
            }, PROTOTYPE._unbind = function(targets, suffix) {
                $(targets).unbind("." + this._id + (suffix ? "-" + suffix : ""))
            };
            var ns = "." + NAMESPACE;
            $(function() {
                delegate(SELECTOR, ["mouseenter", "mouseleave"], function(event) {
                    var state = "mouseenter" === event.type, tooltip = $(event.currentTarget), target = $(event.relatedTarget || event.target), options = this.options;
                    state ? (this.focus(event), tooltip.hasClass(CLASS_FIXED) && !tooltip.hasClass(CLASS_DISABLED) && clearTimeout(this.timers.hide)) : "mouse" === options.position.target && options.hide.event && options.show.target && !target.closest(options.show.target[0]).length && this.hide(event), tooltip.toggleClass(CLASS_HOVER, state)
                }), delegate("[" + ATTR_ID + "]", INACTIVE_EVENTS, inactiveMethod)
            }), PROTOTYPE._trigger = function(type, args, event) {
                var callback = $.Event("tooltip" + type);
                return callback.originalEvent = event && $.extend({}, event) || this.cache.event || NULL, this.triggering = type, this.tooltip.trigger(callback, [this].concat(args || [])), this.triggering = FALSE, !callback.isDefaultPrevented()
            }, PROTOTYPE._bindEvents = function(showEvents, hideEvents, showTarget, hideTarget, showMethod, hideMethod) {
                if (hideTarget.add(showTarget).length === hideTarget.length) {
                    var toggleEvents = [];
                    hideEvents = $.map(hideEvents, function(type) {
                        var showIndex = $.inArray(type, showEvents);
                        return showIndex > -1 ? void toggleEvents.push(showEvents.splice(showIndex, 1)[0]) : type
                    }), toggleEvents.length && this._bind(showTarget, toggleEvents, function(event) {
                        var state = this.rendered ? this.tooltip[0].offsetWidth > 0 : !1;
                        (state ? hideMethod : showMethod).call(this, event)
                    })
                }
                this._bind(showTarget, showEvents, showMethod), this._bind(hideTarget, hideEvents, hideMethod)
            }, PROTOTYPE._assignInitialEvents = function(event) {
                function hoverIntent(event) {
                    return this.disabled || this.destroyed ? FALSE : (this.cache.event = cloneEvent(event), this.cache.target = event ? $(event.target) : [undefined], clearTimeout(this.timers.show), void (this.timers.show = delay.call(this, function() {
                        this.render("object" == typeof event || options.show.ready)
                    }, options.show.delay)))
                }
                var options = this.options, showTarget = options.show.target, hideTarget = options.hide.target, showEvents = options.show.event ? $.trim("" + options.show.event).split(" ") : [], hideEvents = options.hide.event ? $.trim("" + options.hide.event).split(" ") : [];
                /mouse(over|enter)/i.test(options.show.event) && !/mouse(out|leave)/i.test(options.hide.event) && hideEvents.push("mouseleave"), this._bind(showTarget, "mousemove", function(event) {
                    this._storeMouse(event), this.cache.onTarget = TRUE
                }), this._bindEvents(showEvents, hideEvents, showTarget, hideTarget, hoverIntent, function() {
                    clearTimeout(this.timers.show)
                }), (options.show.ready || options.prerender) && hoverIntent.call(this, event)
            }, PROTOTYPE._assignEvents = function() {
                var self = this, options = this.options, posOptions = options.position, tooltip = this.tooltip, showTarget = options.show.target, hideTarget = options.hide.target, containerTarget = posOptions.container, viewportTarget = posOptions.viewport, documentTarget = $(document), windowTarget = ($(document.body), $(window)), showEvents = options.show.event ? $.trim("" + options.show.event).split(" ") : [], hideEvents = options.hide.event ? $.trim("" + options.hide.event).split(" ") : [];
                $.each(options.events, function(name, callback) {
                    self._bind(tooltip, "toggle" === name ? ["tooltipshow", "tooltiphide"] : ["tooltip" + name], callback, null, tooltip)
                }), /mouse(out|leave)/i.test(options.hide.event) && "window" === options.hide.leave && this._bind(documentTarget, ["mouseout", "blur"], function(event) {
                    /select|option/.test(event.target.nodeName) || event.relatedTarget || this.hide(event)
                }), options.hide.fixed ? hideTarget = hideTarget.add(tooltip.addClass(CLASS_FIXED)) : /mouse(over|enter)/i.test(options.show.event) && this._bind(hideTarget, "mouseleave", function() {
                    clearTimeout(this.timers.show)
                }), ("" + options.hide.event).indexOf("unfocus") > -1 && this._bind(containerTarget.closest("html"), ["mousedown", "touchstart"], function(event) {
                    var elem = $(event.target), enabled = this.rendered && !this.tooltip.hasClass(CLASS_DISABLED) && this.tooltip[0].offsetWidth > 0, isAncestor = elem.parents(SELECTOR).filter(this.tooltip[0]).length > 0;
                    elem[0] === this.target[0] || elem[0] === this.tooltip[0] || isAncestor || this.target.has(elem[0]).length || !enabled || this.hide(event)
                }), "number" == typeof options.hide.inactive && (this._bind(showTarget, "qtip-" + this.id + "-inactive", inactiveMethod), this._bind(hideTarget.add(tooltip), QTIP.inactiveEvents, inactiveMethod, "-inactive")), this._bindEvents(showEvents, hideEvents, showTarget, hideTarget, showMethod, hideMethod), this._bind(showTarget.add(tooltip), "mousemove", function(event) {
                    if ("number" == typeof options.hide.distance) {
                        var origin = this.cache.origin || {}, limit = this.options.hide.distance, abs = Math.abs;
                        (abs(event.pageX - origin.pageX) >= limit || abs(event.pageY - origin.pageY) >= limit) && this.hide(event)
                    }
                    this._storeMouse(event)
                }), "mouse" === posOptions.target && posOptions.adjust.mouse && (options.hide.event && this._bind(showTarget, ["mouseenter", "mouseleave"], function(event) {
                    this.cache.onTarget = "mouseenter" === event.type
                }), this._bind(documentTarget, "mousemove", function(event) {
                    this.rendered && this.cache.onTarget && !this.tooltip.hasClass(CLASS_DISABLED) && this.tooltip[0].offsetWidth > 0 && this.reposition(event)
                })), (posOptions.adjust.resize || viewportTarget.length) && this._bind($.event.special.resize ? viewportTarget : windowTarget, "resize", repositionMethod), posOptions.adjust.scroll && this._bind(windowTarget.add(posOptions.container), "scroll", repositionMethod)
            }, PROTOTYPE._unassignEvents = function() {
                var targets = [this.options.show.target[0], this.options.hide.target[0], this.rendered && this.tooltip[0], this.options.position.container[0], this.options.position.viewport[0], this.options.position.container.closest("html")[0], window, document];
                this._unbind($([]).pushStack($.grep(targets, function(i) {
                    return "object" == typeof i
                })))
            }, QTIP = $.fn.qtip = function(options, notation, newValue) {
                var command = ("" + options).toLowerCase(), returned = NULL, args = $.makeArray(arguments).slice(1), event = args[args.length - 1], opts = this[0] ? $.data(this[0], NAMESPACE) : NULL;
                return !arguments.length && opts || "api" === command ? opts : "string" == typeof options ? (this.each(function() {
                    var api = $.data(this, NAMESPACE);
                    if (!api)
                        return TRUE;
                    if (event && event.timeStamp && (api.cache.event = event), !notation || "option" !== command && "options" !== command)
                        api[command] && api[command].apply(api, args);
                    else {
                        if (newValue === undefined && !$.isPlainObject(notation))
                            return returned = api.get(notation), FALSE;
                        api.set(notation, newValue)
                    }
                }), returned !== NULL ? returned : this) : "object" != typeof options && arguments.length ? void 0 : (opts = sanitizeOptions($.extend(TRUE, {}, options)), this.each(function(i) {
                    var api, id;
                    return id = $.isArray(opts.id) ? opts.id[i] : opts.id, id = !id || id === FALSE || id.length < 1 || QTIP.api[id] ? QTIP.nextid++ : id, api = init($(this), id, opts), api === FALSE ? TRUE : (QTIP.api[id] = api, $.each(PLUGINS, function() {
                        "initialize" === this.initialize && this(api)
                    }), void api._assignInitialEvents(event))
                }))
            }, $.qtip = QTip, QTIP.api = {}, $.each({attr: function(attr, val) {
                    if (this.length) {
                        var self = this[0], title = "title", api = $.data(self, "qtip");
                        if (attr === title && api && "object" == typeof api && api.options.suppress)
                            return arguments.length < 2 ? $.attr(self, oldtitle) : (api && api.options.content.attr === title && api.cache.attr && api.set("content.text", val), this.attr(oldtitle, val))
                    }
                    return $.fn["attr" + replaceSuffix].apply(this, arguments)
                },clone: function(keepData) {
                    var elems = ($([]), $.fn["clone" + replaceSuffix].apply(this, arguments));
                    return keepData || elems.filter("[" + oldtitle + "]").attr("title", function() {
                        return $.attr(this, oldtitle)
                    }).removeAttr(oldtitle), elems
                }}, function(name, func) {
                if (!func || $.fn[name + replaceSuffix])
                    return TRUE;
                var old = $.fn[name + replaceSuffix] = $.fn[name];
                $.fn[name] = function() {
                    return func.apply(this, arguments) || old.apply(this, arguments)
                }
            }), $.ui || ($["cleanData" + replaceSuffix] = $.cleanData, $.cleanData = function(elems) {
                for (var elem, i = 0; (elem = $(elems[i])).length; i++)
                    if (elem.attr(ATTR_HAS))
                        try {
                            elem.triggerHandler("removeqtip")
                        } catch (e) {
                        }
                $["cleanData" + replaceSuffix].apply(this, arguments)
            }), QTIP.version = "2.2.0", QTIP.nextid = 0, QTIP.inactiveEvents = INACTIVE_EVENTS, QTIP.zindex = 15e3, QTIP.defaults = {prerender: FALSE,id: FALSE,overwrite: TRUE,suppress: TRUE,content: {text: TRUE,attr: "title",title: FALSE,button: FALSE},position: {my: "top left",at: "bottom right",target: FALSE,container: FALSE,viewport: FALSE,adjust: {x: 0,y: 0,mouse: TRUE,scroll: TRUE,resize: TRUE,method: "flipinvert flipinvert"},effect: function(api, pos, viewport) {
                        $(this).animate(pos, {duration: 200,queue: FALSE})
                    }},show: {target: FALSE,event: "mouseenter",effect: TRUE,delay: 90,solo: FALSE,ready: FALSE,autofocus: FALSE},hide: {target: FALSE,event: "mouseleave",effect: TRUE,delay: 0,fixed: FALSE,inactive: FALSE,leave: "window",distance: FALSE},style: {classes: "",widget: FALSE,width: FALSE,height: FALSE,def: TRUE},events: {render: NULL,move: NULL,show: NULL,hide: NULL,toggle: NULL,visible: NULL,hidden: NULL,focus: NULL,blur: NULL}}, PLUGINS.viewport = function(api, position, posOptions, targetWidth, targetHeight, elemWidth, elemHeight) {
                function calculate(side, otherSide, type, adjust, side1, side2, lengthName, targetLength, elemLength) {
                    var initialPos = position[side1], mySide = my[side], atSide = at[side], isShift = type === SHIFT, myLength = mySide === side1 ? elemLength : mySide === side2 ? -elemLength : -elemLength / 2, atLength = atSide === side1 ? targetLength : atSide === side2 ? -targetLength : -targetLength / 2, sideOffset = viewportScroll[side1] + viewportOffset[side1] - (containerStatic ? 0 : containerOffset[side1]), overflow1 = sideOffset - initialPos, overflow2 = initialPos + elemLength - (lengthName === WIDTH ? viewportWidth : viewportHeight) - sideOffset, offset = myLength - (my.precedance === side || mySide === my[otherSide] ? atLength : 0) - (atSide === CENTER ? targetLength / 2 : 0);
                    return isShift ? (offset = (mySide === side1 ? 1 : -1) * myLength, position[side1] += overflow1 > 0 ? overflow1 : overflow2 > 0 ? -overflow2 : 0, position[side1] = Math.max(-containerOffset[side1] + viewportOffset[side1], initialPos - offset, Math.min(Math.max(-containerOffset[side1] + viewportOffset[side1] + (lengthName === WIDTH ? viewportWidth : viewportHeight), initialPos + offset), position[side1], "center" === mySide ? initialPos - myLength : 1e9))) : (adjust *= type === FLIPINVERT ? 2 : 0, overflow1 > 0 && (mySide !== side1 || overflow2 > 0) ? (position[side1] -= offset + adjust, newMy.invert(side, side1)) : overflow2 > 0 && (mySide !== side2 || overflow1 > 0) && (position[side1] -= (mySide === CENTER ? -offset : offset) + adjust, newMy.invert(side, side2)), position[side1] < viewportScroll && -position[side1] > overflow2 && (position[side1] = initialPos, newMy = my.clone())), position[side1] - initialPos
                }
                var fixed, newMy, newClass, containerOffset, containerStatic, viewportWidth, viewportHeight, viewportScroll, viewportOffset, target = posOptions.target, tooltip = api.elements.tooltip, my = posOptions.my, at = posOptions.at, adjust = posOptions.adjust, method = adjust.method.split(" "), methodX = method[0], methodY = method[1] || method[0], viewport = posOptions.viewport, container = posOptions.container, cache = api.cache, adjusted = {left: 0,top: 0};
                return viewport.jquery && target[0] !== window && target[0] !== document.body && "none" !== adjust.method ? (containerOffset = container.offset() || adjusted, containerStatic = "static" === container.css("position"), fixed = "fixed" === tooltip.css("position"), viewportWidth = viewport[0] === window ? viewport.width() : viewport.outerWidth(FALSE), viewportHeight = viewport[0] === window ? viewport.height() : viewport.outerHeight(FALSE), viewportScroll = {left: fixed ? 0 : viewport.scrollLeft(),top: fixed ? 0 : viewport.scrollTop()}, viewportOffset = viewport.offset() || adjusted, ("shift" !== methodX || "shift" !== methodY) && (newMy = my.clone()), adjusted = {left: "none" !== methodX ? calculate(X, Y, methodX, adjust.x, LEFT, RIGHT, WIDTH, targetWidth, elemWidth) : 0,top: "none" !== methodY ? calculate(Y, X, methodY, adjust.y, TOP, BOTTOM, HEIGHT, targetHeight, elemHeight) : 0}, newMy && cache.lastClass !== (newClass = NAMESPACE + "-pos-" + newMy.abbrev()) && tooltip.removeClass(api.cache.lastClass).addClass(api.cache.lastClass = newClass), adjusted) : adjusted
            }
        })
    }(window, document)
}), fweb_define("jquery.resize", ["jquery"], null, function() {
    !function($, window, undefined) {
        "$:nomunge";
        function loopy() {
            timeout_id = window[str_setTimeout](function() {
                elems.each(function() {
                    var elem = $(this), width = elem.width(), height = elem.height(), data = $.data(this, str_data);
                    return data ? void ((width !== data.w || height !== data.h) && elem.trigger(str_resize, [data.w = width, data.h = height])) : void elems.splice($.inArray(this, elems), 1)
                }), loopy()
            }, jq_resize[str_delay])
        }
        var timeout_id, elems = $([]), jq_resize = $.resize = $.extend($.resize, {}), str_setTimeout = "setTimeout", str_resize = "resize", str_data = str_resize + "-special-event", str_delay = "delay", str_throttle = "throttleWindow";
        jq_resize[str_delay] = 250, jq_resize[str_throttle] = !0, $.event.special[str_resize] = {setup: function() {
                if (!jq_resize[str_throttle] && this[str_setTimeout])
                    return !1;
                var elem = $(this);
                elems = elems.add(elem), $.data(this, str_data, {w: elem.width(),h: elem.height()}), 1 === elems.length && loopy()
            },teardown: function() {
                if (!jq_resize[str_throttle] && this[str_setTimeout])
                    return !1;
                var elem = $(this);
                elems = elems.not(elem), elem.removeData(str_data), elems.length || clearTimeout(timeout_id)
            },add: function(handleObj) {
                function new_handler(e, w, h) {
                    var elem = $(this), data = $.data(this, str_data);
                    data.w = w !== undefined ? w : elem.width(), data.h = h !== undefined ? h : elem.height(), old_handler.apply(this, arguments)
                }
                if (!jq_resize[str_throttle] && this[str_setTimeout])
                    return !1;
                var old_handler;
                return $.isFunction(handleObj) ? (old_handler = handleObj, new_handler) : (old_handler = handleObj.handler, void (handleObj.handler = new_handler))
            }}, $.event.special.windowResize = {add: function(handleObj) {
                var elem = this;
                jQuery._data(elem);
                elem.addEventListener ? elem.addEventListener("resize", handleObj.handler, !1) : elem.attachEvent && elem.attachEvent("onresize", handleObj.handler)
            }}
    }(jQuery, this)
}), fweb_define("jquery.form", ["jquery"], null, function() {
    if (function($) {
        "use strict";
        function doAjaxSubmit(e) {
            var options = e.data;
            e.isDefaultPrevented() || (e.preventDefault(), $(this).ajaxSubmit(options))
        }
        function captureSubmittingElement(e) {
            var target = e.target, $el = $(target);
            if (!$el.is(":submit,input:image")) {
                var t = $el.closest(":submit");
                if (0 === t.length)
                    return;
                target = t[0]
            }
            var form = this;
            if (form.clk = target, "image" == target.type)
                if (void 0 !== e.offsetX)
                    form.clk_x = e.offsetX, form.clk_y = e.offsetY;
                else if ("function" == typeof $.fn.offset) {
                    var offset = $el.offset();
                    form.clk_x = e.pageX - offset.left, form.clk_y = e.pageY - offset.top
                } else
                    form.clk_x = e.pageX - target.offsetLeft, form.clk_y = e.pageY - target.offsetTop;
            setTimeout(function() {
                form.clk = form.clk_x = form.clk_y = null
            }, 100)
        }
        function log() {
            if ($.fn.ajaxSubmit.debug) {
                var msg = "[jquery.form] " + Array.prototype.join.call(arguments, "");
                window.console && window.console.log ? window.console.log(msg) : window.opera && window.opera.postError && window.opera.postError(msg)
            }
        }
        var feature = {};
        feature.fileapi = void 0 !== $("<input type='file'/>").get(0).files, feature.formdata = void 0 !== window.FormData, $.fn.ajaxSubmit = function(options) {
            function deepSerialize(extraData) {
                var i, part, serialized = $.param(extraData).split("&"), len = serialized.length, result = {};
                for (i = 0; len > i; i++)
                    part = serialized[i].split("="), result[decodeURIComponent(part[0])] = decodeURIComponent(part[1]);
                return result
            }
            function fileUploadXhr(a) {
                for (var formdata = new FormData, i = 0; i < a.length; i++)
                    formdata.append(a[i].name, a[i].value);
                if (options.extraData) {
                    var serializedData = deepSerialize(options.extraData);
                    for (var p in serializedData)
                        serializedData.hasOwnProperty(p) && formdata.append(p, serializedData[p])
                }
                options.data = null;
                var s = $.extend(!0, {}, $.ajaxSettings, options, {contentType: !1,processData: !1,cache: !1,type: method || "POST"});
                options.uploadProgress && (s.xhr = function() {
                    var xhr = jQuery.ajaxSettings.xhr();
                    return xhr.upload && (xhr.upload.onprogress = function(event) {
                        var percent = 0, position = event.loaded || event.position, total = event.total;
                        event.lengthComputable && (percent = Math.ceil(position / total * 100)), options.uploadProgress(event, position, total, percent)
                    }), xhr
                }), s.data = null;
                var beforeSend = s.beforeSend;
                return s.beforeSend = function(xhr, o) {
                    o.data = formdata, beforeSend && beforeSend.call(this, xhr, o)
                }, $.ajax(s)
            }
            function fileUploadIframe(a) {
                function getDoc(frame) {
                    var doc = frame.contentWindow ? frame.contentWindow.document : frame.contentDocument ? frame.contentDocument : frame.document;
                    return doc
                }
                function doSubmit() {
                    function checkState() {
                        try {
                            var state = getDoc(io).readyState;
                            log("state = " + state), state && "uninitialized" == state.toLowerCase() && setTimeout(checkState, 50)
                        } catch (e) {
                            log("Server abort: ", e, " (", e.name, ")"), cb(SERVER_ABORT), timeoutHandle && clearTimeout(timeoutHandle), timeoutHandle = void 0
                        }
                    }
                    var t = $form.attr("target"), a = $form.attr("action");
                    form.setAttribute("target", id), method || form.setAttribute("method", "POST"), a != s.url && form.setAttribute("action", s.url), s.skipEncodingOverride || method && !/post/i.test(method) || $form.attr({encoding: "multipart/form-data",enctype: "multipart/form-data"}), s.timeout && (timeoutHandle = setTimeout(function() {
                        timedOut = !0, cb(CLIENT_TIMEOUT_ABORT)
                    }, s.timeout));
                    var extraInputs = [];
                    try {
                        if (s.extraData)
                            for (var n in s.extraData)
                                s.extraData.hasOwnProperty(n) && ($.isPlainObject(s.extraData[n]) && s.extraData[n].hasOwnProperty("name") && s.extraData[n].hasOwnProperty("value") ? extraInputs.push($('<input type="hidden" name="' + s.extraData[n].name + '">').attr("value", s.extraData[n].value).appendTo(form)[0]) : extraInputs.push($('<input type="hidden" name="' + n + '">').attr("value", s.extraData[n]).appendTo(form)[0]));
                        s.iframeTarget || ($io.appendTo("body"), io.attachEvent ? io.attachEvent("onload", cb) : io.addEventListener("load", cb, !1)), setTimeout(checkState, 15), form.submit()
                    }finally {
                        form.setAttribute("action", a), t ? form.setAttribute("target", t) : $form.removeAttr("target"), $(extraInputs).remove()
                    }
                }
                function cb(e) {
                    if (!xhr.aborted && !callbackProcessed) {
                        try {
                            doc = getDoc(io)
                        } catch (ex) {
                            log("cannot access response document: ", ex), e = SERVER_ABORT
                        }
                        if (e === CLIENT_TIMEOUT_ABORT && xhr)
                            return xhr.abort("timeout"), void deferred.reject(xhr, "timeout");
                        if (e == SERVER_ABORT && xhr)
                            return xhr.abort("server abort"), void deferred.reject(xhr, "error", "server abort");
                        if (doc && doc.location.href != s.iframeSrc || timedOut) {
                            io.detachEvent ? io.detachEvent("onload", cb) : io.removeEventListener("load", cb, !1);
                            var errMsg, status = "success";
                            try {
                                if (timedOut)
                                    throw "timeout";
                                var isXml = "xml" == s.dataType || doc.XMLDocument || $.isXMLDoc(doc);
                                if (log("isXml=" + isXml), !isXml && window.opera && (null === doc.body || !doc.body.innerHTML) && --domCheckCount)
                                    return log("requeing onLoad callback, DOM not available"), void setTimeout(cb, 250);
                                var docRoot = doc.body ? doc.body : doc.documentElement;
                                xhr.responseText = docRoot ? docRoot.innerHTML : null, xhr.responseXML = doc.XMLDocument ? doc.XMLDocument : doc, isXml && (s.dataType = "xml"), xhr.getResponseHeader = function(header) {
                                    var headers = {"content-type": s.dataType};
                                    return headers[header]
                                }, docRoot && (xhr.status = Number(docRoot.getAttribute("status")) || xhr.status, xhr.statusText = docRoot.getAttribute("statusText") || xhr.statusText);
                                var dt = (s.dataType || "").toLowerCase(), scr = /(json|script|text)/.test(dt);
                                if (scr || s.textarea) {
                                    var ta = doc.getElementsByTagName("textarea")[0];
                                    if (ta)
                                        xhr.responseText = ta.value, xhr.status = Number(ta.getAttribute("status")) || xhr.status, xhr.statusText = ta.getAttribute("statusText") || xhr.statusText;
                                    else if (scr) {
                                        var pre = doc.getElementsByTagName("pre")[0], b = doc.getElementsByTagName("body")[0];
                                        pre ? xhr.responseText = pre.textContent ? pre.textContent : pre.innerText : b && (xhr.responseText = b.textContent ? b.textContent : b.innerText)
                                    }
                                } else
                                    "xml" == dt && !xhr.responseXML && xhr.responseText && (xhr.responseXML = toXml(xhr.responseText));
                                try {
                                    data = httpData(xhr, dt, s)
                                } catch (e) {
                                    status = "parsererror", xhr.error = errMsg = e || status
                                }
                            } catch (e) {
                                log("error caught: ", e), status = "error", xhr.error = errMsg = e || status
                            }
                            xhr.aborted && (log("upload aborted"), status = null), xhr.status && (status = xhr.status >= 200 && xhr.status < 300 || 304 === xhr.status ? "success" : "error"), "success" === status ? (s.success && s.success.call(s.context, data, "success", xhr), deferred.resolve(xhr.responseText, "success", xhr), g && $.event.trigger("ajaxSuccess", [xhr, s])) : status && (void 0 === errMsg && (errMsg = xhr.statusText), s.error && s.error.call(s.context, xhr, status, errMsg), deferred.reject(xhr, "error", errMsg), g && $.event.trigger("ajaxError", [xhr, s, errMsg])), g && $.event.trigger("ajaxComplete", [xhr, s]), g && !--$.active && $.event.trigger("ajaxStop"), s.complete && s.complete.call(s.context, xhr, status), callbackProcessed = !0, s.timeout && clearTimeout(timeoutHandle), setTimeout(function() {
                                s.iframeTarget || $io.remove(), xhr.responseXML = null
                            }, 100)
                        }
                    }
                }
                var el, i, s, g, id, $io, io, xhr, sub, n, timedOut, timeoutHandle, form = $form[0], useProp = !!$.fn.prop, deferred = $.Deferred();
                if ($(":input[name=submit],:input[id=submit]", form).length)
                    return alert('Error: Form elements must not have name or id of "submit".'), deferred.reject(), deferred;
                if (a)
                    for (i = 0; i < elements.length; i++)
                        el = $(elements[i]), useProp ? el.prop("disabled", !1) : el.removeAttr("disabled");
                if (s = $.extend(!0, {}, $.ajaxSettings, options), s.context = s.context || s, id = "jqFormIO" + (new Date).getTime(), s.iframeTarget ? ($io = $(s.iframeTarget), n = $io.attr("name"), n ? id = n : $io.attr("name", id)) : ($io = $('<iframe name="' + id + '" src="' + s.iframeSrc + '" />'), $io.css({position: "absolute",top: "-1000px",left: "-1000px"})), io = $io[0], xhr = {aborted: 0,responseText: null,responseXML: null,status: 0,statusText: "n/a",getAllResponseHeaders: function() {
                    },getResponseHeader: function() {
                    },setRequestHeader: function() {
                    },abort: function(status) {
                        var e = "timeout" === status ? "timeout" : "aborted";
                        if (log("aborting upload... " + e), this.aborted = 1, io.contentWindow.document.execCommand)
                            try {
                                io.contentWindow.document.execCommand("Stop")
                            } catch (ignore) {
                            }
                        $io.attr("src", s.iframeSrc), xhr.error = e, s.error && s.error.call(s.context, xhr, e, status), g && $.event.trigger("ajaxError", [xhr, s, e]), s.complete && s.complete.call(s.context, xhr, e)
                    }}, g = s.global, g && 0 === $.active++ && $.event.trigger("ajaxStart"), g && $.event.trigger("ajaxSend", [xhr, s]), s.beforeSend && s.beforeSend.call(s.context, xhr, s) === !1)
                    return s.global && $.active--, deferred.reject(), deferred;
                if (xhr.aborted)
                    return deferred.reject(), deferred;
                sub = form.clk, sub && (n = sub.name, n && !sub.disabled && (s.extraData = s.extraData || {}, s.extraData[n] = sub.value, "image" == sub.type && (s.extraData[n + ".x"] = form.clk_x, s.extraData[n + ".y"] = form.clk_y)));
                var CLIENT_TIMEOUT_ABORT = 1, SERVER_ABORT = 2, csrf_token = $("meta[name=csrf-token]").attr("content"), csrf_param = $("meta[name=csrf-param]").attr("content");
                csrf_param && csrf_token && (s.extraData = s.extraData || {}, s.extraData[csrf_param] = csrf_token), s.forceSync ? doSubmit() : setTimeout(doSubmit, 10);
                var data, doc, callbackProcessed, domCheckCount = 50, toXml = $.parseXML || function(s, doc) {
                    return window.ActiveXObject ? (doc = new ActiveXObject("Microsoft.XMLDOM"), doc.async = "false", doc.loadXML(s)) : doc = (new DOMParser).parseFromString(s, "text/xml"), doc && doc.documentElement && "parsererror" != doc.documentElement.nodeName ? doc : null
                }, parseJSON = $.parseJSON || function(s) {
                    return window.eval("(" + s + ")")
                }, httpData = function(xhr, type, s) {
                    var ct = xhr.getResponseHeader("content-type") || "", xml = "xml" === type || !type && ct.indexOf("xml") >= 0, data = xml ? xhr.responseXML : xhr.responseText;
                    return xml && "parsererror" === data.documentElement.nodeName && $.error && $.error("parsererror"), s && s.dataFilter && (data = s.dataFilter(data, type)), "string" == typeof data && ("json" === type || !type && ct.indexOf("json") >= 0 ? data = parseJSON(data) : ("script" === type || !type && ct.indexOf("javascript") >= 0) && $.globalEval(data)), data
                };
                return deferred
            }
            if (!this.length)
                return log("ajaxSubmit: skipping submit process - no element selected"), this;
            var method, action, url, $form = this;
            "function" == typeof options && (options = {success: options}), method = this.attr("method"), action = this.attr("action"), url = "string" == typeof action ? $.trim(action) : "", url = url || window.location.href || "", url && (url = (url.match(/^([^#]+)/) || [])[1]), options = $.extend(!0, {url: url,success: $.ajaxSettings.success,type: method || "GET",iframeSrc: /^https/i.test(window.location.href || "") ? "javascript:false" : "about:blank"}, options);
            var veto = {};
            if (this.trigger("form-pre-serialize", [this, options, veto]), veto.veto)
                return log("ajaxSubmit: submit vetoed via form-pre-serialize trigger"), this;
            if (options.beforeSerialize && options.beforeSerialize(this, options) === !1)
                return log("ajaxSubmit: submit aborted via beforeSerialize callback"), this;
            var traditional = options.traditional;
            void 0 === traditional && (traditional = $.ajaxSettings.traditional);
            var qx, elements = [], a = this.formToArray(options.semantic, elements);
            if (options.data && (options.extraData = options.data, qx = $.param(options.data, traditional)), options.beforeSubmit && options.beforeSubmit(a, this, options) === !1)
                return log("ajaxSubmit: submit aborted via beforeSubmit callback"), this;
            if (this.trigger("form-submit-validate", [a, this, options, veto]), veto.veto)
                return log("ajaxSubmit: submit vetoed via form-submit-validate trigger"), this;
            var q = $.param(a, traditional);
            qx && (q = q ? q + "&" + qx : qx), "GET" == options.type.toUpperCase() ? (options.url += (options.url.indexOf("?") >= 0 ? "&" : "?") + q, options.data = null) : options.data = q;
            var callbacks = [];
            if (options.resetForm && callbacks.push(function() {
                $form.resetForm()
            }), options.clearForm && callbacks.push(function() {
                $form.clearForm(options.includeHidden)
            }), !options.dataType && options.target) {
                var oldSuccess = options.success || function() {
                };
                callbacks.push(function(data) {
                    var fn = options.replaceTarget ? "replaceWith" : "html";
                    $(options.target)[fn](data).each(oldSuccess, arguments)
                })
            } else
                options.success && callbacks.push(options.success);
            options.success = function(data, status, xhr) {
                for (var context = options.context || this, i = 0, max = callbacks.length; max > i; i++)
                    callbacks[i].apply(context, [data, status, xhr || $form, $form])
            };
            var fileInputs = $("input:file:enabled[value]", this), hasFileInputs = fileInputs.length > 0, mp = "multipart/form-data", multipart = $form.attr("enctype") == mp || $form.attr("encoding") == mp, fileAPI = feature.fileapi && feature.formdata;
            log("fileAPI :" + fileAPI);
            var jqxhr, shouldUseFrame = (hasFileInputs || multipart) && !fileAPI;
            options.iframe !== !1 && (options.iframe || shouldUseFrame) ? options.closeKeepAlive ? $.get(options.closeKeepAlive, function() {
                jqxhr = fileUploadIframe(a)
            }) : jqxhr = fileUploadIframe(a) : jqxhr = (hasFileInputs || multipart) && fileAPI ? fileUploadXhr(a) : $.ajax(options), $form.removeData("jqxhr").data("jqxhr", jqxhr);
            for (var k = 0; k < elements.length; k++)
                elements[k] = null;
            return this.trigger("form-submit-notify", [this, options]), this
        }, $.fn.ajaxForm = function(options) {
            if (options = options || {}, options.delegation = options.delegation && $.isFunction($.fn.on), !options.delegation && 0 === this.length) {
                var o = {s: this.selector,c: this.context};
                return !$.isReady && o.s ? (log("DOM not ready, queuing ajaxForm"), $(function() {
                    $(o.s, o.c).ajaxForm(options)
                }), this) : (log("terminating; zero elements found by selector" + ($.isReady ? "" : " (DOM not ready)")), this)
            }
            return options.delegation ? ($(document).off("submit.form-plugin", this.selector, doAjaxSubmit).off("click.form-plugin", this.selector, captureSubmittingElement).on("submit.form-plugin", this.selector, options, doAjaxSubmit).on("click.form-plugin", this.selector, options, captureSubmittingElement), this) : this.ajaxFormUnbind().bind("submit.form-plugin", options, doAjaxSubmit).bind("click.form-plugin", options, captureSubmittingElement)
        }, $.fn.ajaxFormUnbind = function() {
            return this.unbind("submit.form-plugin click.form-plugin")
        }, $.fn.formToArray = function(semantic, elements) {
            var a = [];
            if (0 === this.length)
                return a;
            var form = this[0], els = semantic ? form.getElementsByTagName("*") : form.elements;
            if (!els)
                return a;
            var i, j, n, v, el, max, jmax;
            for (i = 0, max = els.length; max > i; i++)
                if (el = els[i], n = el.name)
                    if (semantic && form.clk && "image" == el.type)
                        el.disabled || form.clk != el || (a.push({name: n,value: $(el).val(),type: el.type}), a.push({name: n + ".x",value: form.clk_x}, {name: n + ".y",value: form.clk_y}));
                    else if (v = $.fieldValue(el, !0), v && v.constructor == Array)
                        for (elements && elements.push(el), j = 0, jmax = v.length; jmax > j; j++)
                            a.push({name: n,value: v[j]});
                    else if (feature.fileapi && "file" == el.type && !el.disabled) {
                        elements && elements.push(el);
                        var files = el.files;
                        if (files.length)
                            for (j = 0; j < files.length; j++)
                                a.push({name: n,value: files[j],type: el.type});
                        else
                            a.push({name: n,value: "",type: el.type})
                    } else
                        null !== v && "undefined" != typeof v && (elements && elements.push(el), a.push({name: n,value: v,type: el.type,required: el.required}));
            if (!semantic && form.clk) {
                var $input = $(form.clk), input = $input[0];
                n = input.name, n && !input.disabled && "image" == input.type && (a.push({name: n,value: $input.val()}), a.push({name: n + ".x",value: form.clk_x}, {name: n + ".y",value: form.clk_y}))
            }
            return a
        }, $.fn.formSerialize = function(semantic) {
            return $.param(this.formToArray(semantic))
        }, $.fn.fieldSerialize = function(successful) {
            var a = [];
            return this.each(function() {
                var n = this.name;
                if (n) {
                    var v = $.fieldValue(this, successful);
                    if (v && v.constructor == Array)
                        for (var i = 0, max = v.length; max > i; i++)
                            a.push({name: n,value: v[i]});
                    else
                        null !== v && "undefined" != typeof v && a.push({name: this.name,value: v})
                }
            }), $.param(a)
        }, $.fn.fieldValue = function(successful) {
            for (var val = [], i = 0, max = this.length; max > i; i++) {
                var el = this[i], v = $.fieldValue(el, successful);
                null === v || "undefined" == typeof v || v.constructor == Array && !v.length || (v.constructor == Array ? $.merge(val, v) : val.push(v))
            }
            return val
        }, $.fieldValue = function(el, successful) {
            var n = el.name, t = el.type, tag = el.tagName.toLowerCase();
            if (void 0 === successful && (successful = !0), successful && (!n || el.disabled || "reset" == t || "button" == t || ("checkbox" == t || "radio" == t) && !el.checked || ("submit" == t || "image" == t) && el.form && el.form.clk != el || "select" == tag && -1 == el.selectedIndex))
                return null;
            if ("select" == tag) {
                var index = el.selectedIndex;
                if (0 > index)
                    return null;
                for (var a = [], ops = el.options, one = "select-one" == t, max = one ? index + 1 : ops.length, i = one ? index : 0; max > i; i++) {
                    var op = ops[i];
                    if (op.selected) {
                        var v = op.value;
                        if (v || (v = op.attributes && op.attributes.value && !op.attributes.value.specified ? op.text : op.value), one)
                            return v;
                        a.push(v)
                    }
                }
                return a
            }
            return $(el).val()
        }, $.fn.clearForm = function(includeHidden) {
            return this.each(function() {
                $("input,select,textarea", this).clearFields(includeHidden)
            })
        }, $.fn.clearFields = $.fn.clearInputs = function(includeHidden) {
            var re = /^(?:color|date|datetime|email|month|number|password|range|search|tel|text|time|url|week)$/i;
            return this.each(function() {
                var t = this.type, tag = this.tagName.toLowerCase();
                re.test(t) || "textarea" == tag ? this.value = "" : "checkbox" == t || "radio" == t ? this.checked = !1 : "select" == tag ? this.selectedIndex = -1 : includeHidden && (includeHidden === !0 && /hidden/.test(t) || "string" == typeof includeHidden && $(this).is(includeHidden)) && (this.value = "")
            })
        }, $.fn.resetForm = function() {
            return this.each(function() {
                ("function" == typeof this.reset || "object" == typeof this.reset && !this.reset.nodeType) && this.reset()
            })
        }, $.fn.enable = function(b) {
            return void 0 === b && (b = !0), this.each(function() {
                this.disabled = !b
            })
        }, $.fn.selected = function(select) {
            return void 0 === select && (select = !0), this.each(function() {
                var t = this.type;
                if ("checkbox" == t || "radio" == t)
                    this.checked = select;
                else if ("option" == this.tagName.toLowerCase()) {
                    var $sel = $(this).parent("select");
                    select && $sel[0] && "select-one" == $sel[0].type && $sel.find("option").selected(!1), this.selected = select
                }
            })
        }, $.fn.ajaxSubmit.debug = !1
    }(jQuery), null == window.jQuery.fn.ajaxSubmit)
        throw new Error('Grunt Requireize: module does not define "window.jQuery.fn.ajaxSubmit"');
    return window.jQuery.fn.ajaxSubmit
}), fweb_define("jquery.ng_app", ["jquery", "fweb"], null, function($, fweb) {
    "use strict";
    function StubProvider() {
    }
    var module = {DEFAULT_QLIST_MENU_ITEMS_CONTROLLER: "QlistCustomMenuItems"}, BASE_REQUIRE_MODULES = ["angular", "ng/services/loader", "ng/services/interceptor", "ng/services/persistent_storage", "ng/services/volatile_storage", "ng/directives/ftnt", "ng/directives/menu/menu", "ng/filters/ftnt"], BASE_NG_MODULES = ["ftnt", "ftnt-gui", "ngResource", "ngCookies", "ngSanitize", "ui.jq", "ui.event", "ui.sortable"], running_apps = {};
    return StubProvider.prototype.$get = function() {
        return {}
    }, $.fn.ng_app = function(params) {
        if (this.length) {
            params = params || {};
            var element = this[0], deferred = $.Deferred(), require_modules = BASE_REQUIRE_MODULES.concat(params.require || []), ng_modules = BASE_NG_MODULES.concat(params.modules || []), app_name = element.getAttribute("f-ng-app");
            if (!app_name)
                throw new Error('Element doesn\'t have an "f-ng-app" attribute');
            if (running_apps[app_name])
                throw new Error('A ng app named "' + app_name + '" already exists');
            return require(require_modules, function(ng, loader) {
                var $controllerProvider, angular = arguments[0], app = angular.module(app_name, ng_modules), lazy_modules = Array.prototype.slice.call(arguments, BASE_REQUIRE_MODULES.length).filter(function(module) {
                    return angular.isFunction(module)
                });
                app.service("$route", StubProvider), app.config(["$controllerProvider", "$httpProvider", "$compileProvider", function(_$controllerProvider_, $httpProvider, $compileProvider) {
                        $controllerProvider = _$controllerProvider_, $compileProvider.debugInfoEnabled(fweb.BUILD.CONFIG.CONFIG_DEBUG), $httpProvider.interceptors.push("ftntInterceptor")
                    }]);
                var loader_ready = null;
                lazy_modules.length && (loader_ready = loader.preloadModules(lazy_modules)), app.run(function($rootScope, $window, $injector, $controller, loader) {
                    lazy_modules.length && loader.initModules(lazy_modules), $rootScope.ADMIN_RO = $window.is_rw_admin === !1;
                    var testScope = $rootScope.$new();
                    testScope.__TESTING__ = !0;
                    try {
                        $controller(module.DEFAULT_QLIST_MENU_ITEMS_CONTROLLER, {$scope: testScope})
                    } catch (ex) {
                        var noController = "Argument '" + module.DEFAULT_QLIST_MENU_ITEMS_CONTROLLER + "' is not a function, got undefined";
                        if (!(ex.message.indexOf(noController) > -1))
                            throw ex;
                        $controllerProvider.register(module.DEFAULT_QLIST_MENU_ITEMS_CONTROLLER, angular.noop)
                    }
                    testScope.$destroy(), fweb.DEBUG && (app._injector = $injector)
                }), params.run && app.run(params.run), $.when(loader_ready).then(function(all_lazy_modules) {
                    all_lazy_modules && (lazy_modules = all_lazy_modules), angular.bootstrap(element, [app_name]), running_apps[app_name] = app, deferred.resolve(app)
                })
            }), deferred.promise()
        }
    }, module
}), fweb_define("legacy.util", ["fweb"], null, function(fweb) {
    window.cloneObject = function(src, dst) {
        for (var attr in src)
            dst[attr] = src[attr];
        return dst
    }, window.check = function(obj) {
        obj.checked = !0
    }, window.uncheck = function(obj) {
        obj.checked = !1
    }, window.enable = function(obj) {
        obj.disabled = !1
    }, window.disable = function(obj) {
        obj.disabled = !0
    }, window.show = function(obj) {
        obj.style.display = ""
    }, window.hide = function(obj) {
        obj.style.display = "none"
    }, window.display = function(obj, isYes) {
        isYes ? show(obj) : hide(obj)
    }, window.isUnchecked = function(obj) {
        return !obj.checked
    }, window.isEnabled = function(obj) {
        return !obj.disabled
    }, window.setProperty = function(obj, property, value) {
        obj[property] = value
    }, window.setPropertyById = function(id, property, value) {
        var obj;
        (obj = document.getElementById(id)) && setProperty(obj, property, value)
    }, window.setPropertyByIds = function(idArray, property, value) {
        var i;
        for (i = 0; i < idArray.length; i++)
            setPropertyById(idArray[i], property, value)
    }, window.getElementsByNameRegex = function(rootObj, elementNames, re) {
        var i, j, objElementArray, coll = [];
        for (i = 0; i < elementNames.length; i++)
            for (objElementArray = rootObj.getElementsByTagName(elementNames[i]), j = 0; j < objElementArray.length; j++)
                objElementArray[j].name ? re.test(objElementArray[j].name) && coll.push(objElementArray[j]) : objElementArray[j].id && re.test(objElementArray[j].id) && coll.push(objElementArray[j]);
        return coll
    }, window.setPropertyByName = function(rootObj, elementNames, nameExp, property, value) {
        var i, j, objElementArray, re = new RegExp(nameExp);
        for (i = 0; i < elementNames.length; i++)
            for (objElementArray = rootObj.getElementsByTagName(elementNames[i]), j = 0; j < objElementArray.length; j++)
                !re.test(objElementArray[j].name) || objElementArray[j].disabled && "disabled" != property || setProperty(objElementArray[j], property, value)
    }, window.disableElementsById = function(idArray, disabled) {
        setPropertyByIds(idArray, "disabled", disabled)
    }, window.disableElementsByName = function(rootObj, elementNames, nameExp, disabled) {
        setPropertyByName(rootObj, elementNames, nameExp, "disabled", disabled)
    }, window.checkInputByName = function(rootObj, nameExp, checked) {
        setPropertyByName(rootObj, ["input"], nameExp, "checked", checked)
    }, window.hideSection = function(controlObj, idArray) {
        for (var $idArray = $(), i = 0; i < idArray.length; ++i)
            $idArray = $idArray.add($("#" + idArray[i]));
        var hidden = !$idArray.first().is(":visible");
        $idArray.toggle(hidden), $(controlObj).attr("src", "/" + fweb.CONFIG_GUI_NO + "/theme/images/twistie_" + (hidden ? "expanded" : "collapsed") + ".gif")
    }, window.change_icon = function(object) {
        var image = object, strArr = image.src.split("/"), imgsrc = strArr[strArr.length - 1];
        return "twistie_collapsed.gif" == imgsrc ? (image.src = "/" + fweb.CONFIG_GUI_NO + "/theme/images/twistie_expanded.gif", !0) : (image.src = "/" + fweb.CONFIG_GUI_NO + "/theme/images/twistie_collapsed.gif", !1)
    }, window.qlist_toggle_section = function(img, classNames) {
        var bExpanded = change_icon(img);
        "undefined" == typeof classNames && (classNames = ".qlist_row");
        var aTrs = $(img).closest("tr");
        if (aTrs.length) {
            for (var cur_row = aTrs.next("tr"); cur_row && cur_row.is(classNames); )
                cur_row = cur_row.toggle(bExpanded).next("tr");
            return bExpanded
        }
    }, window.tree_control = function(obj) {
        return qlist_toggle_section(obj, ".odd, .category, .disabled")
    }, window.implodeField = function(field, separator, onlySelected) {
        var i, str = "";
        for (i = 0; i < field.length; i++)
            onlySelected ? field[i].selected && (str.length > 0 && (str += separator), str += field[i].value) : (str.length > 0 && (str += separator), str += field[i].value);
        return str
    }, window.removeOptions = function(field) {
        var i, removedOptions = document.createElement("select"), j = 0;
        for (i = 0; i < field.options.length; i++)
            field.options[i].selected && (removedOptions.options[j] = new Option, removedOptions.options[j].text = field.options[i].text, removedOptions.options[j].value = field.options[i].value, removedOptions.options[j].selected = !0, field.options[i] = null, i--, j++);
        return removedOptions
    }, window.moveOptionField = function(fromField, toField) {
        var selectedOptions, i, insertIndex = toField.options.length;
        for (i = 0; i < toField.options.length; i++)
            toField.options[i].selected && (insertIndex = i + 1, toField.options[i].selected = !1);
        for (selectedOptions = removeOptions(fromField), toField.options.length += selectedOptions.options.length, i = toField.options.length - 1; i >= insertIndex + selectedOptions.options.length; i--)
            toField.options[i].text = toField.options[i - selectedOptions.options.length].text, toField.options[i].value = toField.options[i - selectedOptions.options.length].value;
        for (i = 0; i < selectedOptions.options.length; i++, insertIndex++)
            toField.options[insertIndex].text = selectedOptions.options[i].text, toField.options[insertIndex].value = selectedOptions.options[i].value, toField.options[insertIndex].selected = !0
    }, window.moveOptionUp = function(selectField) {
        var i, oOption = new Option, length = selectField.options.length;
        if (0 === length || selectField.options[0].selected)
            return 0;
        for (i = 1; length > i; i++)
            selectField.options[i].selected && (oOption.text = selectField.options[i - 1].text, 
            oOption.value = selectField.options[i - 1].value, selectField.options[i - 1].text = selectField.options[i].text, selectField.options[i - 1].value = selectField.options[i].value, selectField.options[i - 1].selected = !0, selectField.options[i].text = oOption.text, selectField.options[i].value = oOption.value, selectField.options[i].selected = !1)
    }, window.moveOptionDown = function(selectField) {
        var i, oOption = new Option, length = selectField.options.length;
        if (0 === length || selectField.options[length - 1].selected)
            return 0;
        for (i = length - 1; i >= 0; i--)
            selectField.options[i].selected && (oOption.text = selectField.options[i + 1].text, oOption.value = selectField.options[i + 1].value, selectField.options[i + 1].text = selectField.options[i].text, selectField.options[i + 1].value = selectField.options[i].value, selectField.options[i + 1].selected = !0, selectField.options[i].text = oOption.text, selectField.options[i].value = oOption.value, selectField.options[i].selected = !1)
    }, window.selectOptions = function(selectObj, optionArray, compareFn, selectValue, scroll) {
        for (var numberSelected = 0, objOption = null, i = 0; i < selectObj.length; i++)
            for (var j = 0; j < optionArray.length; j++)
                if (0 === compareFn(selectObj[i], optionArray[j])) {
                    selectObj[i].selected = selectValue, numberSelected++, objOption = selectObj[i];
                    break
                }
        return scroll && objOption && objOption.scrollIntoView(), numberSelected
    }, window.moveOptions = function(fromObj, toObj, sort) {
        var optionArray = [];
        return optionArray = optionsToArray(fromObj, 1, 1), insertOptions(toObj, optionArray, toObj.selectedIndex + 1), toObj.selectedIndex = -1, selectOptions(toObj, optionArray, compareObjTextString, !0, !1), sort && sortOptions(toObj, compareObjTextString), optionArray
    }, window.fastMoveOptions = function(fromObj, toObj, sort) {
        var option, i = 0, j = 0, endIndexFrom = fromObj.length, endIndexTo = toObj.length, IE = !1;
        for (toObj.selectedIndex = -1; endIndexFrom > i; )
            if (fromObj.options[i].selected) {
                if (option = fromObj.options[i], fromObj.remove(i), sort) {
                    for (; endIndexTo > j && !(option.text <= toObj.options[j].text); )
                        j++;
                    try {
                        IE ? toObj.add(option, j) : toObj.add(option, toObj.options[j])
                    } catch (ex) {
                        IE = !0, toObj.add(option, j)
                    }
                    toObj.options[j].selected = !0, j++
                } else {
                    try {
                        IE ? toObj.add(option) : toObj.add(option, null)
                    } catch (ex) {
                        IE = !0, toObj.add(option)
                    }
                    toObj.options[toObj.length].selected = !0
                }
                endIndexFrom--, endIndexTo++
            } else
                i++
    }, window.insertOptions = function(selectObj, optionArray, index) {
        var resultArray;
        resultArray = optionsToArray(selectObj, 2, 1), arrayToOptions(selectObj, resultArray.splice(0, index).concat(optionArray).concat(resultArray))
    }, window.optionsToArray = function(selectObj, mode, remove, startIndex, endIndex) {
        var optionArray = [], i = startIndex ? startIndex : 0;
        for (endIndex = endIndex ? endIndex : selectObj.length; endIndex > i; )
            switch (mode) {
                case 0:
                    if (!selectObj[i].selected && (optionArray[optionArray.length] = selectObj[i], remove)) {
                        selectObj.removeChild(selectObj[i]), endIndex--;
                        break
                    }
                    i++;
                    break;
                case 1:
                    if (selectObj[i].selected && (optionArray[optionArray.length] = selectObj[i], 1 == remove)) {
                        selectObj.removeChild(selectObj[i]), endIndex--;
                        break
                    }
                    i++;
                    break;
                default:
                    if (optionArray[optionArray.length] = selectObj[i], 1 == remove) {
                        selectObj.removeChild(selectObj[i]), endIndex--;
                        break
                    }
                    i++
            }
        return optionArray
    }, window.arrayToOptions = function(selectObj, optionArray, text, value) {
        text || (text = "text"), value || (value = "value");
        for (var i = 0; i < optionArray.length; i++)
            selectObj.options[selectObj.options.length] = new Option(optionArray[i][text], optionArray[i][value], optionArray[i].selected), selectObj.options[selectObj.options.length - 1].selected = optionArray[i].selected
    }, window.stringToOption = function(stringArray) {
        for (var optionArray = [], i = 0; i < stringArray.length; i++)
            optionArray[i] = new Option(stringArray[i], stringArray[i], !1), optionArray[i].selected = !1;
        return optionArray
    }, window.optionToString = function(optionArray) {
        for (var i = 0; i < optionArray.length; i++)
            optionArray[i] = optionArray[i].value;
        return optionArray
    }, window.optionTextToString = function(optionArray) {
        for (var i = 0; i < optionArray.length; i++)
            optionArray[i] = optionArray[i].text;
        return optionArray
    }, window.sortOptions = function(selectObj, compareFn) {
        var optionArray = optionsToArray(selectObj, 2, 1);
        optionArray.sort(compareFn), arrayToOptions(selectObj, optionArray)
    }, window.compareObjTextString = function(a, b) {
        return a.text < b.text ? -1 : a.text > b.text ? 1 : 0
    }, window.compareObjValueString = function(a, b) {
        return a.value < b.value ? -1 : a.value > b.value ? 1 : 0
    }, window.uniquefyArray = function(array1) {
        for (var array2 = [], found = 0, i = 0; i < array1.length; i++) {
            found = 0;
            for (var j = 0; j < array2.length; j++)
                if (array1[i] == array2[j]) {
                    found = 1;
                    break
                }
            found || (array2[array2.length] = array1[i])
        }
        return array2
    }, window.matchArray = function(array1, array2) {
        for (var array3 = [], i = 0; i < array1.length; i++)
            for (var j = 0; j < array2.length; j++)
                array1[i] == array2[j] && (array3[array3.length] = array1[i]);
        return array3
    }, window.removeTextNodes = function(node) {
        for (var i = 0; i < node.childNodes.length; i++)
            3 == node.childNodes.item(i).nodeType && node.removeChild(node.childNodes.item(i))
    }, window.swapChildNodes = function(node, childNode1, childNode2) {
        var temp;
        childNode1 != childNode2 && (temp = childNode1.cloneNode(!0), node.replaceChild(temp, childNode1), node.replaceChild(childNode1, childNode2), node.replaceChild(childNode2, temp))
    }, window.quicksortChildNodes = function(node, left, right, attributeName) {
        var i, j, pivot, childNodes = node.childNodes;
        if (right > left) {
            for (swapChildNodes(node, childNodes.item(Math.floor((left + right) / 2)), childNodes.item(right)), pivot = childNodes.item(right).getAttribute(attributeName), i = left - 1, j = right; ; ) {
                for (; childNodes.item(++i).getAttribute(attributeName) < pivot; )
                    ;
                for (; j > 0 && childNodes.item(--j).getAttribute(attributeName) > pivot; )
                    ;
                if (!(j > i))
                    break;
                swapChildNodes(node, childNodes.item(i), childNodes.item(j))
            }
            swapChildNodes(node, childNodes.item(i), childNodes.item(right)), quicksortChildNodes(node, left, i - 1, attributeName), quicksortChildNodes(node, i + 1, right, attributeName)
        }
    }, window.RegExpCommon = new function() {
        this.EMAIL_ADDRESS = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/, this.IP_HOST = fweb.util.patterns.commonRegExp.IP_HOST, this.IP_MASK = fweb.util.patterns.commonRegExp.IP_MASK, this.IP_RANGE = fweb.util.patterns.commonRegExp.IP_RANGE, this.IP_RANGE_SPACES = fweb.util.patterns.commonRegExp.IP_RANGE_SPACES, this.IP_RANGE2 = fweb.util.patterns.commonRegExp.IP_RANGE2, this.IP_WILDCARD = fweb.util.patterns.commonRegExp.IP_WILDCARD, this.MAC_ADDRESS = fweb.util.patterns.commonRegExp.MAC_ADDRESS, this.IP_SUBNET = fweb.util.patterns.commonRegExp.IP_SUBNET, this.SUBNET = fweb.util.patterns.commonRegExp.SUBNET, this.IP6_HOST = fweb.util.patterns.commonRegExp.IP6_HOST, this.IP6_SUBNET = fweb.util.patterns.commonRegExp.IP6_SUBNET, this.MULTICAST_IP_HOST = fweb.util.patterns.commonRegExp.MULTICAST_IP_HOST, this.MULTICAST_IP_RANGE = fweb.util.patterns.commonRegExp.MULTICAST_IP_RANGE, this.INTEGER = /^-?[0-9]+$/, this.HEX_INTEGER = /^[0-9A-Fa-f]+$/, this.NAME = /^[^<>#()"']+$/, this.NAME_NODOLLAR = fweb.util.patterns.commonRegExp.NAME_NODOLLAR, this.XSS = fweb.util.patterns.commonRegExp.XSS, this.RANGE_INT = /^[0-9]*-[0-9]+$|^([0-9]+-?)$/, this.TIME = /^(([0-1]?[0-9]|[2][0-3]):([0-5]?[0-9]):([0-5]?[0-9]))?$/, this.DATE = /^([0-9]{4}-([0]?[0-9]|[1][0-2])-([0-2]?[0-9]|3[0-1]))?$/, this.MD5 = /^[0-9a-fA-F]{32}$/, this.GUID = /^(([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})|(\s*\*\s*)|\s*)$/, this.FQDN = /^([a-zA-Z0-9\-]{1,63}\.?)+$/, this.DOMAIN_NAME = fweb.util.patterns.commonRegExp.DOMAIN_NAME, this.FQDN_WILDCARD = /^([a-zA-Z0-9\-\*\?]{1,63}\.?)+$/
    }, window.matchFieldExp = function(str, regExpTestArray) {
        for (var i = 0; i < regExpTestArray.length; i++)
            if (regExpTestArray[i].test(str))
                return i;
        return -1
    }, window.alert_focus = function(input, msg) {
        return window.alert(msg), input.focus && input.focus(), input.select && input.select(), !1
    }, window.checkFieldExp = function(field, regExpTestArray, errorMessage) {
        return matchFieldExp(field.value.toString(), regExpTestArray) < 0 ? (window.alert(errorMessage), field.focus(), field.select(), !1) : !0
    }, window.getRadioValue = function(radioObj) {
        var i;
        if (!radioObj.length && radioObj.checked)
            return radioObj.value;
        for (i = 0; i < radioObj.length; i++)
            if (radioObj[i].checked)
                return radioObj[i].value ? radioObj[i].value : i;
        return null
    }, window.initForm = function() {
        $("textarea[expand]").textarea();
        try {
            $(":input:visible:enabled:first").focus()
        } catch (e) {
        }
    }, window.insertOption = function(selectField, oOption, compareFn, selectOption) {
        var i;
        if (compareFn) {
            for (i = 0; i < selectField.length; i++)
                if (compareFn(oOption, selectField.options[i]) < 0) {
                    for (var j = selectField.length; j > i; j--)
                        selectField.options[j] = new Option(selectField.options[j - 1].text, selectField.options[j - 1].value, selectField.options[j - 1].defaultSelected, selectField.options[j - 1].selected);
                    break
                }
        } else
            i = selectField.length;
        selectField.options[i] = oOption, selectOption && (selectField[i].selected = !0)
    }, window.popup_generic_i = function(link, windowName, width, height, attrs, alignment_parent) {
        alignment_parent || (alignment_parent = window.parent ? window.parent.top : window.top);
        var x = ((window.innerWidth ? window.innerWidth : document.body.offsetWidth) - width) / 2, y = ((window.innerHeight ? window.innerHeight : document.body.offsetHeight) - height) / 2;
        if (alignment_parent) {
            var wd_o = alignment_parent.innerWidth ? alignment_parent.innerWidth : alignment_parent.document.body.offsetWidth, ht_o = alignment_parent.innerHeight ? alignment_parent.innerHeight : alignment_parent.document.body.offsetHeight;
            x = (wd_o - width) / 2, y = (ht_o - height) / 2;
            var root = alignment_parent.document.documentElement, wd = root.clientWidth ? root.clientWidth : root.offsetWidth, ht = root.clientHeight ? root.clientHeight : root.offsetHeight;
            x = (wd - width) / 2, y = (ht - height) / 2 + 50
        }
        0 > x && (x = 0), 0 > y && (y = 0);
        var popupWindow = window.open(link, windowName, attrs + ",width=" + width + ",height=" + height + ",top=" + y + ",left=" + x + ",screenX=" + x + ",screenY=" + y);
        return popupWindow ? (popupWindow.resizeTo(width, height), popupWindow.moveTo(x, y), popupWindow.focus(), popupWindow) : null
    }, window.popup_resizable = function(link, windowName, width, height) {
        return popup_generic_i(link, windowName, width, height, "dependent=yes,scrollbars=yes,resizable=1")
    }, window.popup = function(link, windowName, width, height) {
        return popup_generic_i(link, windowName, width, height, "dependent=yes,scrollbars=yes,resizable=no")
    }, window.popup_nonscrollable = function(link, windowName, width, height) {
        return popup_generic_i(link, windowName, width, height, "dependent=yes,scrollbars=no,resizable=1")
    }, window.popup_autosizing = function(link, windowName, width, height, alignment_parent) {
        return popup_generic_i(link, windowName, width, height, "dependent=yes,scrollbars=yes,resizable=no", alignment_parent)
    }, window.callFunctionArray = function(functionArray) {
        for (var i = 0; functionArray[i]; i++)
            functionArray[i]()
    }, window.obj_del = function(msg, url, obj) {
        var row_obj = obj.parentNode.parentNode, class_old = "";
        return row_obj && "TR" == row_obj.tagName && row_obj.set_class && (row_obj.onmouseout = null, class_old = row_obj.className, row_obj.set_class("over")), confirm(msg) ? void $.submitPOST(url) : void (row_obj && "TR" == row_obj.tagName && row_obj.set_class && (row_obj.onmouseout = tt_mout, row_obj.set_class(class_old)))
    }, window.obj_del_child = function(msg, path, name, mkey, child, child_key) {
        confirm(msg) && CMDB.delete_child(path, name, mkey, child, child_key, function() {
            window.location.reload()
        })
    }, window.clear_all = function(msg, url) {
        window.confirm(msg) && (document.location = url)
    }, window.serializeArray = function(inputArray) {
        if (!inputArray)
            return "";
        for (var arr = [], i = 0; i < inputArray.length; i++) {
            var entry = inputArray[i];
            "object" == typeof entry && entry.length ? arr.push(encodeURIComponent(serializeArray(entry))) : arr.push(encodeURIComponent(entry))
        }
        return arr.join("&") + "&"
    }, window.deserializeArray = function(arrayString) {
        var elementString, stringArray = arrayString.split("&");
        stringArray.length -= 1;
        for (var i = 0; i < stringArray.length; i++)
            if (elementString = decodeURIComponent(stringArray[i]), elementString.indexOf("&") < 0) {
                if (stringArray[i] = elementString, elementString.indexOf("=") >= 0) {
                    var fieldArray = elementString.split("=");
                    stringArray[fieldArray[0]] = fieldArray[1]
                }
            } else
                stringArray[i] = deserializeArray(elementString);
        return stringArray
    }, window.dlg_close = function(url, resolveBool) {
        fweb.log.warn('Using deprecated "dlg_close"'), url = url || $("#redir").val(), fweb.util.location.go_back(url, resolveBool)
    }, window.appendFormField = function(thisForm, name, value) {
        var obj;
        obj = document.createElement("input"), obj.type = "hidden", obj.name = name, obj.value = value, thisForm.appendChild(obj)
    }, window.get_xmlhttp = function() {
        var xmlhttp = null;
        try {
            xmlhttp = new ActiveXObject("Msxml2.XMLHTTP")
        } catch (e) {
            try {
                xmlhttp = new ActiveXObject("Microsoft.XMLHTTP")
            } catch (oc) {
                xmlhttp = null
            }
        }
        return xmlhttp || "undefined" == typeof XMLHttpRequest || (xmlhttp = new XMLHttpRequest), xmlhttp
    }, window.send_request = function(str_url, str_body) {
        var xmlhttp = get_xmlhttp(), str_method = "" === str_body ? "GET" : "POST";
        return xmlhttp.open(str_method, str_url, !1), xmlhttp.send(str_body), xmlhttp.responseText
    }, window.send_simple_async_request = function(str_url, str_body) {
        var xmlhttp = get_xmlhttp(), str_method = "" === str_body ? "GET" : "POST";
        xmlhttp.open(str_method, str_url, !0), xmlhttp.setRequestHeader("Pragma", "no-cache"), xmlhttp.setRequestHeader("Cache-Control", "no-store, no-cache, must-revalidate"), xmlhttp.setRequestHeader("If-Modified-Since", "Sat, 1 Jan 2000 00:00:00 GMT"), xmlhttp.setRequestHeader("X-CSRFTOKEN", fweb.util.persist.getCsrfToken()), xmlhttp.send(str_body)
    }, window.getObjectsByProperty = function(rootObj, elementNames, property, propertyExp) {
        for (var objElementArray, re = new RegExp(propertyExp), objArray = [], i = 0; i < elementNames.length; i++) {
            objElementArray = rootObj.getElementsByTagName(elementNames[i]);
            for (var j = 0; j < objElementArray.length; j++)
                re.test(objElementArray[j][property]) && (objArray[objArray.length] = objElementArray[j])
        }
        return objArray
    }, window.nodeToArray = function(parentNode, remove) {
        for (var nodeArray = [], i = 0; i < parentNode.childNodes.length; )
            nodeArray[nodeArray.length] = parentNode.childNodes[i], remove ? parentNode.removeChild(parentNode.childNodes[i]) : i++;
        return nodeArray
    }, window.arrayToNode = function(parentNode, nodeArray) {
        for (var i = 0; i < nodeArray.length; i++)
            parentNode.appendChild(nodeArray[i]);
        return parentNode
    }, window.swapArrayElements = function(thisArray, index1, index2) {
        var temp;
        return temp = thisArray[index1], thisArray[index1] = thisArray[index2], thisArray[index2] = temp, thisArray
    }, window.moveNode = function(nodeObj, distance) {
        var parentNode = nodeObj.parentNode, nodeArray = nodeToArray(parentNode, !0), index1 = findInArray(nodeArray, nodeObj), index2 = index1 + distance;
        return index2 > nodeArray.length - 1 && (index2 = nodeArray.length - 1), 0 > index2 && (index2 = 0), nodeArray = swapArrayElements(nodeArray, index1, index2), arrayToNode(parentNode, nodeArray), nodeArray
    }, window.arrangeNodesByAttribute = function(nodeArray, attributeArray, attributeName) {
        for (var i = 0; i < attributeArray.length; i++)
            for (var j = i; j < nodeArray.length; j++)
                if (1 == nodeArray[j].nodeType && nodeArray[j].getAttribute(attributeName) == attributeArray[i]) {
                    swapArrayElements(nodeArray, j, i);
                    break
                }
        return nodeArray
    }, window.findInArray = function(thisArray, elementToFind) {
        for (var index = -1, i = 0; i < thisArray.length; i++)
            if (thisArray[i] == elementToFind) {
                index = i;
                break
            }
        return index
    }, window.nodeToString = function(nodeArray, attributeName) {
        for (var i = 0; i < nodeArray.length; i++)
            nodeArray[i] = nodeArray[i].getAttribute(attributeName);
        return nodeArray
    }, window.getRows = function(parentNode, cookieName) {
        var cookieString = getCookie(cookieName);
        cookieString || (cookieString = "");
        var idArray = deserializeArray(cookieString);
        removeTextNodes(parentNode);
        var nodeArray = nodeToArray(parentNode, !0);
        nodeArray = arrangeNodesByAttribute(nodeArray, idArray, "id"), arrayToNode(parentNode, nodeArray)
    }, window.setRows = function(parentNode, cookieName) {
        var nodeArray = nodeToArray(parentNode, !1);
        nodeArray = nodeToString(nodeArray, "id"), setCookie(cookieName, serializeArray(nodeArray))
    }, window.moveRow = function(id, distance) {
        var rowNode = document.getElementById(id);
        moveNode(rowNode, distance)
    }, window.cat_members = function(obj_sel, obj_mem) {
        var i, len = obj_sel.length, members = "";
        if (len > 0) {
            for (members = obj_sel.options[0].text, i = 1; len > i; i++)
                members = members + "#" + obj_sel.options[i].text;
            obj_mem.value = members
        }
    }, window.validateFieldRange = function(fieldObj, minValue, maxValue, errorMessage) {
        var v = fieldObj.value, fieldValue = parseInt(v, 10);
        return -1 != fieldValue && fieldValue >= minValue && maxValue >= fieldValue ? !0 : (alert(errorMessage), fieldObj.focus(), fieldObj.select(), !1)
    }, window.setFilterDisplay = function(filterCookieArray, filter) {
        if (!filter)
            return filterCookieArray;
        filterCookieArray || (filterCookieArray = []);
        for (var i = 0; i < filterCookieArray.length; i++)
            if (filterCookieArray[i][0] == filter.fieldName)
                return filterCookieArray[i] = filter.toArray(), filterCookieArray;
        return filterCookieArray[filterCookieArray.length] = filter.toArray(), filterCookieArray
    }, window.removeFilterDisplay = function(filterCookieArray, fieldName) {
        filterCookieArray || (filterCookieArray = []);
        for (var i = 0; i < filterCookieArray.length; i++)
            if (filterCookieArray[i][0] == fieldName) {
                filterCookieArray.splice(i, 1);
                break
            }
        return filterCookieArray
    }, window.addEvent = function(obj, type, fn) {
        obj.addEventListener ? obj.addEventListener(type, fn, !1) : obj.attachEvent && (obj["e" + type + fn] = fn, obj[type + fn] = function() {
            obj["e" + type + fn](window.event)
        }, obj.attachEvent("on" + type, obj[type + fn]))
    }, window.removeEvent = function(obj, type, fn) {
        obj.removeEventListener ? obj.removeEventListener(type, fn, !1) : obj.detachEvent && (obj.detachEvent("on" + type, obj[type + fn]), obj[type + fn] = null, obj["e" + type + fn] = null)
    }, window.buttonHideAllDropdown = function(e) {
        var remove = 1, obj = e.target ? e.target : e.srcElement, ul_obj = null;
        try {
            ul_obj = "options_button" == obj.className ? obj.parentNode.parentNode.parentNode.parentNode.getElementsByTagName("ul")[0] : null
        } catch (err) {
            ul_obj = null
        }
        for (var coll = document.getElementsByTagName("ul"), i = 0; i < coll.length; i++)
            coll[i] == ul_obj ? "" === ul_obj.style.display && (remove = 0) : "dropdown" == coll[i].className && (coll[i].style.display = "none");
        remove && removeEvent(document, "click", buttonHideAllDropdown)
    }, window.getCheckedValues = function(re) {
        var i, objElementArray, coll = [];
        for (objElementArray = document.getElementsByTagName("input"), i = 0; i < objElementArray.length; i++)
            re.test(objElementArray[i].name) && objElementArray[i].checked && coll.push(objElementArray[i].value);
        return coll
    }, window.xnode2String = function(s) {
        var str = "";
        if (!s)
            return "";
        for (var i = 0; i < s.length; i++)
            s[i].firstChild && (str += s[i].firstChild.nodeValue);
        return str
    }, window.Request = {}, window.Request.send = function(url, method, callback, data, urlencoded) {
        var req = get_xmlhttp(), readychange = function() {
            4 == req.readyState && (200 == req.status ? "POST" == method ? callback && (callback(req), callback = null) : callback && (callback(req, data), callback = null) : "undefined" == typeof req || "undefined" == typeof req.status ? callback && (callback = null) : 404 == req.status && (alert("Request URL was not found."), callback && (callback(req), callback = null)))
        };
        return window.do_request = function() {
            "POST" == method ? (req.open("POST", url, !0), urlencoded && req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded"), req.setRequestHeader("X-CSRFTOKEN", fweb.util.persist.getCsrfToken()), req.onreadystatechange = readychange, req.send(data)) : (req.open("GET", url, !0), req.onreadystatechange = readychange, req.send(null))
        }, do_request(), req
    }, window.Request.sendRawPOST = function(url, data, callback) {
        Request.send(url, "POST", callback, data, !1)
    }, window.Request.sendPOST = function(url, data, callback) {
        Request.send(url, "POST", callback, data, !0)
    }, window.Request.sendGET = function(url, callback, args) {
        return Request.send(url, "GET", callback, args)
    }, window.get_last_child_of_type = function(obj, type) {
        var i, len;
        try {
            len = obj.childNodes.length
        } catch (e) {
            return null
        }
        for (i = len - 1; i >= 0; i--)
            if (obj.childNodes[i].nodeName == type)
                return obj.childNodes[i];
        return null
    }, window.tbl_realign_columns = function(tbl_hdr, tbl) {
        function get_hdr_elems() {
            return $("tr.heading", tbl_hdr).each(function(i) {
                hdrElems = $(hdrElems).add(this.cells), tblElems = $(tblElems).add(tbl.rows[i].cells)
            }), hdrElems.length
        }
        var tblElems = [], hdrElems = [];
        get_hdr_elems() && tblElems.length == hdrElems.length && ($(tbl_hdr).width($(tbl).width()).css("min-width", ($("#main_window")[0] || $("body")[0]).clientWidth), $(hdrElems).each(function(i) {
            var w = tblElems[i].offsetWidth;
            $("div:first", this).width(w), $(this).width($(this).attr("defWidth") ? "" : w)
        }))
    }, window.relocate_tbl_hdr = function(contentTable, headerTable) {
        function locate_table_header() {
            var hdr = contentTable && contentTable.rows[0];
            return $(hdr.cells).each(function() {
                var r = $(this).attr("rowspan");
                r > rows && (rows = r)
            }), hdr
        }
        var rows = 1;
        if (locate_table_header()) {
            $(headerTable).addClass($(contentTable).attr("class")), $(headerTable).attr("cellspacing", $(contentTable).attr("cellspacing")), $(headerTable).attr("cellpadding", 0), $(contentTable).attr("cellpadding", 0);
            for (var i = 0; rows > i; i++)
                $(contentTable.rows[i]).clone().appendTo(headerTable).children().each(function() {
                    $(this).html("<div class=tbh_spacer height=1 width=1>" + $(this).html() + "</div>")
                });
            tbl_realign_columns(headerTable, contentTable), $(window).resize(function() {
                tbl_realign_columns(headerTable, contentTable)
            }), $(document).click(function() {
                tbl_realign_columns(headerTable, contentTable)
            }), $(window).scroll(function() {
                $("#hrdtc").css("left", -$(this).scrollLeft())
            })
        }
    }, window.tbl_realign_tbl_columns = function(tbl_hdr, tbl) {
        function get_hdr_elems() {
            return $("tr.heading", tbl_hdr).each(function(i) {
                hdrElems = $(hdrElems).add(this.cells), tblElems = $(tblElems).add(tbl.rows[i].cells)
            }), hdrElems.length
        }
        var tblElems = [], hdrElems = [];
        get_hdr_elems() && tblElems.length == hdrElems.length && ($(hdrElems).each(function(i) {
            var w = this.offsetWidth;
            if ($("div:first", this).width(w), $(this).attr("defWidth")) {
                var minw = parseInt($(this).attr("defWidth"), 10);
                $(tblElems[i]).width(minw >= w ? minw : "")
            } else
                $(tblElems[i]).width(w)
        }), $(tbl_hdr).width($(tbl).width()))
    }, window.relocate_tbl_hdr2 = function(contentTable, headerTable) {
        function locate_table_header() {
            var cell, hdr = $("thead", contentTable);
            return $("th,td", hdr).each(function() {
                cell = $(this), lastCell = cell, widths.push([cell, cell.width()])
            }), $(lastCell).attr("defWidth", $(lastCell).width()).css("min-width", "30px"), $(widths).each(function() {
                this[1] < 2 || this[0].width(this[1])
            }), hdr
        }
        var lastCell, widths = [];
        locate_table_header() && ($(contentTable).addClass("oneline").css("table-layout", "fixed"), $(headerTable).addClass($(contentTable).attr("class")).css("table-layout", $(contentTable).css("table-layout")).attr("cellspacing", $(contentTable).attr("cellspacing")).attr("cellpadding", $(contentTable).attr("cellpadding")), $(headerTable).width($(contentTable).width()).css("min-width", ($("#main_window")[0] || $("body")[0]).clientWidth), $("thead", contentTable).clone().appendTo(headerTable), $("th,td", $("thead", headerTable)).each(function(i) {
            if (!(widths[i][1] < 2)) {
                var that = this;
                $(this).wrapInner($("<div class=tbh_spacer></div>")), $("div:first", this).width(widths[i][1]).resizable({minWidth: 30,maxWidth: 600,handles: "e",alsoResize: this,start: function(event, ui) {
                        $(headerTable).width(""), $(lastCell).width("")
                    },resize: function(e, ui) {
                    },stop: function(event, ui) {
                        $(this).height(""), $(that).height(""), that == lastCell && $(lastCell).attr("defWidth", $(lastCell).width()), tbl_realign_tbl_columns(headerTable, contentTable), tbl_save_column_widths(headerTable), $("#hrdtc").css("margin-left", "-" + $("#main_window").scrollLeft() + "px"), qlist_realign_floating_header(), qlist_realign_floating_footer()
                    }}), lastCell = this
            }
        }), $(window).scroll(function() {
            $("#hrdtc").css("left", -$(this).scrollLeft())
        }), $(window).resize(function() {
            tbl_realign_columns(headerTable, contentTable)
        }))
    }, window.tbl_save_column_widths = function(table) {
        var cx, fx, cell, label, id, column_info = [], log_id = logdisplay_opts.type;
        for (cx = 0; cx < table.rows[0].cells.length; cx++) {
            for (cell = table.rows[0].cells[cx], label = $.trim($(cell).text()), id = "", fx = 0; fx < filter_columns.length; fx++)
                if (filter_columns[fx][1] == label) {
                    id = filter_columns[fx][0];
                    break
                }
            id && column_info.push({name: id,value: $(cell).width()})
        }
        setCookie("log/display/size" + log_id, $.param(column_info))
    }, window.getParentProperty = function(obj, property, re) {
        for (var value, objArray = []; obj && obj.style; )
            value = obj[property], re.test(value) && objArray.push(obj), obj = obj.parentNode;
        return objArray
    }, window.List = function(id, form, size) {
        this.id = id, this.list = [], this.max_size = size, this.form = form, this.fields = [], this.checkDuplicate = !0, this.find = function(key) {
            for (var i = 0; i < this.list.length; i++)
                if (key == this.list[i][0])
                    return i;
            return -1
        }, this.addEntry = function(valueArray) {
            if (this.list.length >= this.max_size)
                throw new Error("err_max_size");
            if (this.checkDuplicate && this.find(valueArray[0]) >= 0)
                throw new Error("err_duplicate");
            var newArray = valueArray.toString().split(",");
            this.list.push(newArray);
            var tr = this.createListEntry(this.list.length - 1);
            return document.getElementById(this.id).tBodies.item(0).appendChild(tr), !0
        }, this.editEntry = function(index, valueArray) {
            if (0 > index && this.list.length >= this.max_size)
                throw new Error("err_max_size");
            if (this.find(valueArray[0]) >= 0 && this.find(valueArray[0]) != index)
                throw new Error("err_duplicate");
            var newArray = valueArray.toString().split(",");
            if (0 > index) {
                this.list.push(newArray);
                var tr = this.createListEntry(this.list.length - 1);
                document.getElementById(this.id).tBodies.item(0).appendChild(tr)
            } else
                this.list[index] = newArray, this.displayList();
            return !0
        }, this.deleteEntry = function(index) {
            this.list.splice(index, 1), this.displayList()
        }, this.setToForm = function() {
            for (var currentField = this.form[this.id + "_" + this.fields[0]], currentFieldLength = currentField.length ? currentField.length : 1, i = 0; i < this.list.length; i++) {
                var j;
                if (currentFieldLength > i)
                    for (j = 0; j < this.fields.length; j++)
                        currentField = this.form[this.id + "_" + this.fields[j]][i], currentField.value = this.list[i][j];
                else
                    for (j = 0; j < this.fields.length; j++)
                        appendFormField(this.form, this.id + "_" + this.fields[j], this.list[i][j])
            }
        }, this.toForm = function() {
            for (var i = 0; i < this.list.length; i++)
                for (var j = 0; j < this.fields.length; j++)
                    appendFormField(this.form, this.id + "_" + this.fields[j], this.list[i][j])
        }, this.displayList = function() {
            var tbl, tbody, tr, i;
            for (tbl = document.getElementById(this.id), tbody = tbl.tBodies.item(0), tbl.removeChild(tbody), tbody = document.createElement("TBODY"), tbl.insertBefore(tbody, null), i = 0; i < this.list.length; i++)
                tr = this.createListEntry(i), tbody.insertBefore(tr, null)
        }
    }, List.prototype.createListEntry = function(index) {
        var tr, td, text, a, img;
        tr = document.createElement("TR"), td = document.createElement("TD"), text = document.createTextNode(index + 1), tr.insertBefore(td, null), td.insertBefore(text, null);
        for (var i = 0; i < this.list[index].length; i++)
            td = document.createElement("TD"), text = document.createTextNode(this.list[index][i]), tr.insertBefore(td, null), td.insertBefore(text, null);
        return td = document.createElement("TD"), a = document.createElement("A"), a.href = "javascript: deleteEntry(" + +index + ");", img = document.createElement("IMG"), img.setAttribute("src", "/images/delete.gif"), tr.insertBefore(td, null), td.insertBefore(a, null), a.insertBefore(img, null), tr
    }, window.setPaging = function(lineCurrent, lineTotal, linesPerPage, url, name, source, target) {
        var lineNew = 0;
        0 >= linesPerPage && (linesPerPage = Math.pow(2, 32) - 1);
        var obj, pageTotal = Math.ceil(lineTotal / linesPerPage), pageCurrent = Math.ceil(lineCurrent / linesPerPage);
        0 >= pageTotal && (pageTotal = 1), this.gotoUrl = function() {
            target.location.replace(this.getAttribute("url"))
        }, this.gotoPage = function(event) {
            event || (event = window.event), event || (event = parent.action.window.event);
            var key = event.which ? event.which : event.keyCode;
            if (13 == key) {
                var pageNum = parseInt(this.value, 10);
                return isNaN(pageNum) || 1 > pageNum || pageNum > pageTotal ? alert(this.getAttribute("err_page_current")) : (lineNew = (pageNum - 1) * linesPerPage + 1, target.location.replace(setQueryValue(url, name, lineNew))), !1
            }
        }, source || (source = document), target || (target = document), url || (url = target.location.toString()), obj = source.getElementById("page_first"), obj && (1 >= pageCurrent ? (obj.className = "list_button_disabled", obj.onclick = null) : (lineNew = 1, obj.className = "list_button", obj.setAttribute("url", setQueryValue(url, name, lineNew)), obj.onclick = this.gotoUrl)), obj = source.getElementById("page_prev"), obj && (1 >= pageCurrent ? (obj.className = "list_button_disabled", obj.onclick = null) : (lineNew = (pageCurrent - 2) * linesPerPage + 1, obj.className = "list_button", obj.setAttribute("url", setQueryValue(url, name, lineNew)), obj.onclick = this.gotoUrl)), obj = source.getElementById("page_current"), obj && (obj.value = pageCurrent, obj.disabled = 1 >= pageTotal, obj.onkeypress = this.gotoPage), obj = source.getElementById("page_total"), obj && (obj.innerHTML = pageTotal), obj = source.getElementById("page_next"), obj && (pageCurrent >= pageTotal ? (obj.className = "list_button_disabled", obj.onclick = null) : (lineNew = pageCurrent * linesPerPage + 1, obj.className = "list_button", obj.setAttribute("url", setQueryValue(url, name, lineNew)), obj.onclick = this.gotoUrl)), obj = source.getElementById("page_last"), obj && (pageCurrent >= pageTotal ? (obj.className = "list_button_disabled", obj.onclick = null) : (lineNew = (pageTotal - 1) * linesPerPage + 1, obj.className = "list_button", obj.setAttribute("url", setQueryValue(url, name, lineNew)), obj.onclick = this.gotoUrl))
    }, window.getQueryValue = function(url, name) {
        name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
        var regexS = "[\\?&]" + name + "=([^&#]*)", regex = new RegExp(regexS), results = regex.exec(url);
        return null == results ? "" : decodeURIComponent(results[1].replace(/\+/g, " "))
    }, window.getParams = function(params) {
        var key, href = location.href;
        for (key in params)
            if (params.hasOwnProperty(key)) {
                var val = getQueryValue(href, key);
                val && (params[key] = val)
            }
        return params
    }, window.setQueryValue = function(url, name, value) {
        var re = new RegExp("([?|&])" + name + "=.*?(&|$)"), str = null == value ? "" : name + "=" + encodeURIComponent(value), done = 0, newUrl = (url || "").replace(re, function($m, $1, $2) {
            return done = 1, str ? $1 + str + $2 : "?" == $1 ? $1 : $2
        });
        return done ? newUrl.indexOf("?") == newUrl.length - 1 && (newUrl = newUrl.substr(0, newUrl.length - 1)) : str && (newUrl += (newUrl.indexOf("?") < 0 ? "?" : "&") + str), newUrl
    }, window.setQueryValues = function(url, names, values) {
        for (var re, newUrl, i = 0; i < names.length; i++)
            re = new RegExp("(&|\\?)(" + names[i] + ")[^&]*"), newUrl = null == values ? url.replace(re, "$1") : url.replace(re, "$1$2=" + encodeURIComponent(values[i])), newUrl == url && (newUrl = url + (url.indexOf("?") < 0 ? "?" : "&") + names[i] + "=" + encodeURIComponent(values[i])), url = newUrl;
        return newUrl
    }, window.removeQueryValue = function(url, name) {
        var re = new RegExp("(&|\\?)(" + name + ")[^&]*(&|$)"), newUrl = url.replace(re, "$1");
        return newUrl
    }, window.resetFieldValue = function(el) {
        el && "" !== el.style.color && (el.value = "", el.style.color = "")
    }, window.get_iframe_object = function(iframe_name, wnd) {
        var iframe = wnd.document.getElementById(iframe_name), loc_str = String(wnd.document.location);
        return wnd.opener || window.opener || -1 != loc_str.indexOf("detach") ? void 0 : (iframe || (iframe = document.getElementById(iframe_name)), iframe)
    }, window.get_iframe_body = function(iframe) {
        var doc = iframe.contentWindow || iframe.contentDocument;
        return doc.document && (doc = doc.document), doc && doc.body ? doc.body : null
    }, window.get_iframe_height = function(iframe) {
        var body = get_iframe_body(iframe);
        if (body)
            return body.style.height = "auto", $(body).outerHeight()
    }, window.update_iframe_height = function(iframe_id, win_obj, clear_height, min_height) {
        var auto_size_height_ratio = .8, wnd = win_obj ? win_obj : window, iframe = get_iframe_object(iframe_id, wnd);
        if (iframe) {
            clear_height && (iframe.style.height = "5px");
            var height = get_iframe_height(iframe);
            if ("undefined" != typeof wnd.jQuery) {
                var max_height = Math.floor(wnd.jQuery(wnd).height() * auto_size_height_ratio);
                height > max_height && (height = max_height)
            }
            "number" == typeof min_height && (height = Math.max(height, min_height)), height > 0 && (iframe.style.height = height + 3 + "px")
        }
    }, window.doSort = function(sort_field_array, sort_cookie_name) {
        sort_cookie_name || (sort_cookie_name = "sort_cookie"), setCookie(sort_cookie_name, sort_field_array.join(",")), document.location.reload()
    }, window.is_left_button_event = function(ev) {
        return ev.button ? 1 & ev.button ? !0 : !1 : !0
    }, window.update_url_component = function(url, attr, val) {
        function append_url_fragment() {
            var idx = url.indexOf("?"), sep_char = 0 > idx ? "?" : "&";
            return url += sep_char + attr + "=" + val
        }
        function replace_url_fragment(idx) {
            var end_idx = url.indexOf("&", idx + attr.length), new_url = url.substring(0, idx + 1) + attr + "=" + val;
            return end_idx > 0 && (new_url += url.substring(end_idx)), new_url
        }
        var srch_str = "?" + attr + "=", idx = url.indexOf(srch_str);
        return idx >= 0 ? replace_url_fragment(idx) : (srch_str = "&" + attr + "=", idx = url.indexOf(srch_str), idx >= 0 ? replace_url_fragment(idx) : append_url_fragment())
    }, window.extract_url_parameter = function(url, name) {
        var search_str = name + "=", len = search_str.length, idx = url.indexOf(search_str);
        if (idx > 0) {
            idx += len;
            var idx2 = url.indexOf("&", idx);
            return idx2 > 0 ? url.substring(idx, idx2) : url.substring(idx);
        }
        return null
    }, window.get_full_url = function(url_path) {
        var loc = window.location, url = "" + loc.protocol + "//" + loc.host + url_path;
        return url
    }, window.refresh_page_absolute = function(url_path) {
        window.location.href = get_full_url(url_path)
    };
    var getIEVersion = window.getInternetExplorerVersion = function() {
        var rv = -1;
        if ("Microsoft Internet Explorer" == navigator.appName) {
            var ua = navigator.userAgent, re = new RegExp("MSIE ([0-9]{1,}[.0-9]{0,})");
            null != re.exec(ua) && (rv = parseFloat(RegExp.$1))
        }
        return rv
    };
    !function(version) {
        version > -1 && (document.documentElement.className += " ie" + version)
    }(getIEVersion()), window.ack_alert_msg = function(idx, id) {
        var AckURL = "/system/status/status?ack_alert=" + idx, callback = function() {
            var dashboard = window.dashboard;
            dashboard && dashboard.refreshModule(id);
            var wnd = fweb.opener();
            wnd.dashboard && wnd != window && (wnd.dashboard.refreshModule(id), window.location.href = window.location.href)
        };
        return Request.sendPOST(AckURL, null, callback), !1
    }, window.ConvertToGroups = function(num) {
        if (isNaN(num))
            return "N/A";
        for (var s = num.toString(), rgx = /(\d+)(\d{3})/; rgx.test(s); )
            s = s.replace(rgx, "$1,$2");
        return s
    }, window.uncache_url = function(url) {
        var d = new Date, time = d.getTime();
        return url + (url.indexOf("?") < 0 ? "?" : "&") + "time=" + time
    }, window.uncache_param = function(param) {
        return param.time = (new Date).getTime(), param
    }, window.addObj = function(oName, aName, idx) {
        jQuery("#" + oName + (idx + 1)).show(), jQuery("#" + aName + idx).hide(), jQuery("#" + aName + (idx + 1)).show()
    }, window.delObj = function(oName, aName, idx) {
        jQuery("#" + oName + idx).hide(), jQuery("#" + aName + (idx - 1)).show(), jQuery("#" + aName + idx).hide()
    }, window.loadAction = function(oName, aName, max) {
        var i, o;
        for (i = max; i >= 0; i--)
            if (o = $("#" + oName + i), o.length > 0 && o.is(":visible")) {
                $("#" + aName + i).show();
                break
            }
    }, String.prototype.getBytes = function() {
        return encodeURIComponent(this).replace(/%../g, "x").length
    }, String.prototype.getBytesCRLF = function(is_not_escaped_html) {
        var str = this.replace(/\n/g, "xx");
        return is_not_escaped_html ? str.length : str.replace(/%../g, "x").length
    }, window.setDefaultColumns = function(shows) {
        var chosen = $("select[name=chosen]"), available = $("select[name=available]");
        $("option", chosen).appendTo(available), chosen.empty();
        for (var i = 0; i < shows.length; ++i)
            $('option[value="' + shows[i] + '"]', available).appendTo(chosen);
        $("option", available).sortElements(compareObjTextString)
    }, window.setColumns = function(ck_name) {
        var csv = implodeField(document.forms[0].chosen, ",", 0);
        parent.document.forms[0] && parent.document.forms[0].columns_csv && (parent.document.forms[0].columns_csv.value = csv), setCookie(ck_name, csv), window.parent.dlg_close()
    }, window.maskDlg = function(exclude_selectors) {
        if ($(":input").each(function(q, x) {
            x.disabled = !0
        }), exclude_selectors && "length" in exclude_selectors)
            for (var i = 0; i < exclude_selectors.length; i++)
                $(exclude_selectors[i]).each(function(q, x) {
                    x.disabled = !1
                })
    }, window.formatDateTime = function(d, showTime, useEnglishLabel) {
        null == d && (d = new Date);
        var show_year = !(d.getFullYear() === (new Date).getFullYear()), pad = function(n) {
            return 10 > n ? "0" + n : n
        }, months_en_labels = {jan: "Jan",feb: "Feb",mar: "Mar",apr: "Apr",may: "May",jun: "Jun",july: "July",aug: "Aug",sept: "Sept",oct: "Oct",nov: "Nov",dec: "Dec"}, months = $.map(["jan", "feb", "mar", "apr", "may", "jun", "july", "aug", "sept", "oct", "nov", "dec"], function(key) {
            var value = $.getInfo(key);
            return useEnglishLabel ? months_en_labels[key] : value
        }), result = months[d.getMonth()] + " " + pad(d.getDate()) + (show_year ? ", " + d.getFullYear() : "");
        return ("undefined" == typeof showTime || showTime) && (result += ", " + pad(d.getHours() % 12 || 12) + ":" + pad(d.getMinutes()) + " " + (d.getHours() < 12 ? $.getInfo("am") : $.getInfo("pm"))), result
    }, window.util = {wildcard2Regex: function(value) {
            var replace = util.wildcard2Regex._replace;
            return replace || (replace = util.wildcard2Regex._replace = {"?": ".","*": ".*"}, $.each("\\^$.[]|(){}+/".split(""), function(i, v) {
                replace[v] = "\\" + v
            })), value = value.replace(/[?*\\^$.[]|(){}+]/g, function(m) {
                return replace[m] || m
            })
        }}, "undefined" == typeof document || "classList" in document.createElement("a") || !function(view) {
        "use strict";
        if (null != (view.HTMLElement && view.Element)) {
            var classListProp = "classList", protoProp = "prototype", elemCtrProto = (view.HTMLElement || view.Element)[protoProp], objCtr = Object, strTrim = String[protoProp].trim || function() {
                return this.replace(/^\s+|\s+$/g, "")
            }, arrIndexOf = Array[protoProp].indexOf || function(item) {
                for (var i = 0, len = this.length; len > i; i++)
                    if (i in this && this[i] === item)
                        return i;
                return -1
            }, DOMEx = function(type, message) {
                this.name = type, this.code = DOMException[type], this.message = message
            }, checkTokenAndGetIndex = function(classList, token) {
                if ("" === token)
                    throw new DOMEx("SYNTAX_ERR", "An invalid or illegal string was specified");
                if (/\s/.test(token))
                    throw new DOMEx("INVALID_CHARACTER_ERR", "String contains an invalid character");
                return arrIndexOf.call(classList, token)
            }, ClassList = function(elem) {
                for (var trimmedClasses = strTrim.call(elem.className), classes = trimmedClasses ? trimmedClasses.split(/\s+/) : [], i = 0, len = classes.length; len > i; i++)
                    this.push(classes[i]);
                this._updateClassName = function() {
                    elem.className = this.toString()
                }
            }, classListProto = ClassList[protoProp] = [], classListGetter = function() {
                return new ClassList(this)
            };
            if (DOMEx[protoProp] = Error[protoProp], classListProto.item = function(i) {
                return this[i] || null
            }, classListProto.contains = function(token) {
                return token += "", -1 !== checkTokenAndGetIndex(this, token)
            }, classListProto.add = function(token) {
                token += "", -1 === checkTokenAndGetIndex(this, token) && (this.push(token), this._updateClassName())
            }, classListProto.remove = function(token) {
                token += "";
                var index = checkTokenAndGetIndex(this, token);
                -1 !== index && (this.splice(index, 1), this._updateClassName())
            }, classListProto.toggle = function(token) {
                token += "", -1 === checkTokenAndGetIndex(this, token) ? this.add(token) : this.remove(token)
            }, classListProto.toString = function() {
                return this.join(" ")
            }, objCtr.defineProperty) {
                var classListPropDesc = {get: classListGetter,enumerable: !0,configurable: !0};
                try {
                    objCtr.defineProperty(elemCtrProto, classListProp, classListPropDesc)
                } catch (ex) {
                    -2146823252 === ex.number && (classListPropDesc.enumerable = !1, objCtr.defineProperty(elemCtrProto, classListProp, classListPropDesc))
                }
            } else
                objCtr[protoProp].__defineGetter__ && elemCtrProto.__defineGetter__(classListProp, classListGetter)
        }
    }(self), window.getLocalDate = fweb.util.datetime.getLocalDate, window.escapeHTML = fweb.util.dom.escapeHTML, window.convertNumberToUnits = fweb.util.formatters.metric_bytes, window.ConvertBitsToUnits = fweb.util.formatters.metric_bits_per_second, window.setCookie = fweb.util.persist.setCookie, window.getCookie = fweb.util.persist.getCookie, window.hasCookie = fweb.util.persist.hasCookie, window.removeCookie = fweb.util.persist.removeCookie
}), fweb_define("jquery.util", ["jquery", "fweb", "jquery.util_core", "legacy.util"], null, function($, fweb) {
    window.$j = $;
    $j.fn.reverse = [].reverse, $j.fn.check = function(checked) {
        return "undefined" == typeof checked && (checked = !0), this.each(function() {
            "undefined" != typeof this.checked && (this.checked = checked)
        })
    }, $j.fn.uncheck = function() {
        return this.check(!1)
    }, $j.fn.enable = function(enabled) {
        return "undefined" == typeof enabled && (enabled = !0), this.each(function() {
            "undefined" != typeof this.disabled && (this.disabled = !enabled)
        })
    }, $j.fn.disable = function() {
        return this.enable(!1)
    }, $j.fn.sortElements = function() {
        var sort = [].sort;
        return function(comparator) {
            return sort.call(this, comparator).each(function() {
                this.parentNode.appendChild(this)
            })
        }
    }(), $j.deserializeArray = function(url) {
        var pair_in_str, pairs_in_str, i, len, pairs = [];
        if ("undefined" == typeof url || "" === url)
            return null;
        for (pairs_in_str = url.split("&"), len = pairs_in_str.length, i = 0; len > i; i++)
            0 !== pairs_in_str[i].length && (pair_in_str = pairs_in_str[i].split("="), pairs.push({key: pair_in_str[0],value: pair_in_str.length >= 2 ? decodeURIComponent(pair_in_str[1]) : ""}));
        return pairs
    }, $j.deserialize = function(pairs, start, len) {
        if ("undefined" == typeof pairs)
            return "";
        "undefined" == typeof start && (start = 0), "undefined" == typeof len && (len = pairs.length);
        for (var elts = [], end = start + len; end > start; start++) {
            var input = $j("<input />").attr({type: "hidden",name: pairs[start].key,value: pairs[start].value});
            elts.push(input)
        }
        return elts
    }, $j.submitPOST = function(url) {
        if ("undefined" == typeof url || "" === url)
            return !1;
        var is_python = /^\/p\//.test(url), token = is_python ? fweb.util.persist.getPythonCsrfToken() : fweb.util.persist.getCsrfToken(), key = is_python ? "csrfmiddlewaretoken" : "CSRF_TOKEN";
        url = setQueryValue(url, key, token);
        var comp_start = url.indexOf("?"), action = "", comps = "";
        comp_start >= 0 ? (action = url.substring(0, comp_start), comps = url.substring(comp_start + 1)) : action = url;
        var frag = document.createDocumentFragment(), form = $j("<form id='__post_submit'  method='post' action='" + action + "'></form>");
        if (frag.appendChild(form[0]), "" !== comps)
            for (var elmts = $j.deserializeArray(comps), len = elmts.length, start = 0; len > start; start += 1e3) {
                var elts = $j.deserialize(elmts, start, len - start > 1e3 ? 1e3 : len - start);
                form.append(elts)
            }
        return document.body.appendChild(frag), form.submit(), !0
    }, $j.waitModalPrompt = function(wait_confirm, wait_msg) {
        if (window.confirm(wait_confirm ? wait_confirm : qed_strtbl.wait_confirm)) {
            var msg = "<div style='padding:25px;'><img src='/" + fweb.CONFIG_GUI_NO + '/images/loading.gif\'><span style="font-size:14px"> ' + (wait_msg ? wait_msg : qed_strtbl.wait_msg) + "</span></div>";
            return fweb.dialog(msg)
        }
        return !1
    }, $j.fn.updateImage = function(url) {
        $j(this).css("position", "absolute").each(function() {
            var img = $j(this), w = img.parent().width(), h = img.parent().height(), src = url || img.attr("url") || img.attr("src");
            src = setQueryValue(src, "w", w), src = setQueryValue(src, "h", h), src = setQueryValue(src, "q", Math.random()), img.attr("src", src);
            var refresh = img.attr("refresh");
            refresh && (clearTimeout(img.data("timer")), img.data("timer", setTimeout(function() {
                img.updateImage()
            }, 1e3 * refresh)))
        })
    }, $j.internationalizeLanguageEntries = function() {
        $j(document).internationalizeLanguageEntries()
    }, $j.fn.internationalizeLanguageEntries = function() {
        var get_lang_entry = $j.getInfo, attr_name = "lang_key";
        return this.each(function(e) {
            $j("[" + attr_name + "]", e).each(function() {
                var $obj = $j(this), lang_key = $obj.attr(attr_name), lang_val = get_lang_entry(lang_key);
                lang_val || (lang_val = "#" + lang_key), $obj.is(":input") ? $obj.val(lang_val) : $obj.html(lang_val)
            }), $j("[help_lang_key]", e).each(function() {
                var $obj = $j(this), help_lang_val = get_lang_entry($obj.attr("help_lang_key"));
                $obj.attr("title", help_lang_val)
            })
        })
    }, $j.fn.walk = function(visit, post_order) {
        0 !== this.length && this.each(function(i) {
            return post_order || visit.call(this, i, this) !== !1 ? ($j(this).children().walk(visit, post_order), post_order ? visit.call(this, i, this) : void 0) : !1
        })
    }, $j.fn.walkTextNodes = function(visit) {
        var breakvar, parent = this;
        return this.each(function(i) {
            return breakvar = 3 === this.nodeType ? visit.call(this, i, parent, this) : $j(this).contents().walkTextNodes(visit)
        }), breakvar
    }, $j.fn.walkTextChunks = function(visit) {
        var breakvar, currentText = "";
        return this.each(function() {
            if (3 === this.nodeType)
                currentText += this.nodeValue;
            else {
                if ("" !== currentText && (breakvar = visit(currentText), currentText = "", breakvar === !1))
                    return !1;
                breakvar = $j(this).contents().walkTextChunks(visit)
            }
            return breakvar
        }), breakvar === !1 ? !1 : visit(currentText)
    }, $j.fn.autoHeight = function(related) {
        function init_vars() {
            d = jo.outerHeight(!0) - jo.height(), n = 0, jo.siblings(":visible").each(function() {
                jQuery(this).position().top < n && (n = jQuery(this).position().top), n += jQuery(this).outerHeight(!0)
            })
        }
        function resizeHeight() {
            init_vars(), jo.show().height("");
            var h = jo.parent().height() - d - n;
            h > 0 ? (jo.parent().css("overflow-y", "hidden"), jo.height(h)) : jo.hide()
        }
        var jo = jQuery(this);
        if (!jo.length || !jo.is(":visible"))
            return jo;
        var d = 0, n = 0;
        return init_vars(), jQuery(related || window).resize(resizeHeight), resizeHeight(), jo
    }, $j.isSubset = function(first_arr, second_arr, trim_first) {
        for (var i = 0; i < first_arr.length; ++i) {
            var elem = first_arr[i];
            if (trim_first && (elem = $j.trim(elem)), -1 != $j.inArray(elem, second_arr))
                return !0
        }
        return !1
    }, $j.pad = function(number, width) {
        for (var sn = number.toString(); sn.length < (width || 2); )
            sn = "0" + sn;
        return sn
    }, $j.sortCompareText = function(a, b) {
        return a.toLowerCase() > b.toLowerCase() || -(a != b)
    }, $j.makeObject = function(array, getKey) {
        var object = array && {};
        return $j(array).each(function(i, val) {
            object[(getKey || function() {
                return this
            }).call(this, i, val)] = this
        }), object
    }, $j.alert = function(message, level) {
        fweb.log.warn('Using deprecated "$.alert"'), fweb.util.slide.alert(message, level)
    }, $j.confirm = function(params, callback) {
        fweb.log.warn('Using deprecated "$.confirm"');
        var message = params.message || params, level = params.css_class, promise = fweb.util.slide.confirm(message, level, {okButtonLabel: params.ok_text,cancelButtonLabel: params.cancel_text});
        return "function" == typeof callback && promise.then(callback), promise
    }, $j.modal = function(html) {
        fweb.log.warn('Using deprecated "$.modal"');
        var slide = new Sliderin({content: html});
        slide.open()
    }, $j.format_date_friendly = function(date_old, date_now) {
        null == date_now && (date_now = new Date);
        var diff = Math.floor((date_now - date_old + 1) / 1e3), result = 0 > diff ? date_old.toLocaleString() : date_old.toLocaleDateString();
        return weekdays = [$j.getInfo("sun"), $j.getInfo("mon"), $j.getInfo("tues"), $j.getInfo("wed"), $j.getInfo("thur"), $j.getInfo("fri"), $j.getInfo("sat")], 0 > diff || (2 > diff ? result = $j.getInfo("second_ago") : 60 > diff ? result = String(diff) + " " + $j.getInfo("seconds_ago") : 120 > diff ? result = $j.getInfo("minute_ago") : 3600 > diff ? result = String(Math.floor(diff / 60)) + " " + $j.getInfo("minutes_ago") : 7200 > diff ? result = $j.getInfo("hour_ago") : 18e3 > diff ? result = String(Math.floor(diff / 3600)) + " " + $j.getInfo("hours_ago") : 172800 > diff && (date_old.getDay() + 1) % 7 == date_now.getDay() ? result = $j.getInfo("yesterday") : 604800 > diff && (result = weekdays[date_old.getDay()])), result
    }
}), fweb_define("fweb.cmdbClone", ["jquery", "fweb", "cmdb", "notify"], "fweb.cmdbClone", function($, fweb, CMDB, Notify) {
    "use strict";
    var cmdbClone = function(args) {
        var message, hidden, attribs, name, $prompt, slide, params = {mkey: "",nkey: "",path: "",name: "",qType: "-1",maxLength: 35}, numeric = !1;
        return $.extend(params, args), params.mkey_type && "integer" === params.mkey_type ? (numeric = !0, params.title = $.getInfo("clone"), message = params.message || $.getInfo("Are you sure you want to clone this object?"), hidden = !0, attribs = 'value="0"') : (name = $.validator.format($.getInfo("Clone of"), params.mkey).slice(0, params.maxLength), message = params.message || $.getInfo("clone_msg"), attribs = 'type="text" value="' + name + '" maxlength="' + params.maxLength + '"'), $prompt = $('<section><div class="info-message">' + message + '</div><div class="error-message hidden"></div></section>').append('<section class="' + (hidden ? "hidden" : "") + '"><div class="field"><label for="clone-name">' + $.getInfo("Name") + '</label><div><input id="clone-name"' + attribs + "/></div></div></section>"), slide = new Sliderin({content: $prompt,title: params.title || $.getInfo("clone") + ' "' + params.mkey + '"',buttons: !0,okButtonClick: function() {
                var nkey = $("#clone-name", $prompt).val();
                nkey ? CMDB.clone(params.path, params.name, params.mkey, nkey, null, {type: params.qType}).done(function(data) {
                    data.error ? $(".error-message", $prompt).html($.getInfo(data.error)).removeClass("hidden") : slide.done(numeric ? data.mkey : nkey)
                }).fail(function() {
                    $(".error-message", $prompt).html($.getInfo("error")).removeClass("hidden")
                }) : $(".error-message", $prompt).html($.getInfo("err_name")).removeClass("hidden")
            }}), slide.open(), slide.promise
    };
    return cmdbClone.wfProfile = function(mkey, bwordMkey, urlfilterMkey) {
        function failed(reason, newProfileMkey, newBwordId, newUrlfilterId) {
            var msg = $.getInfo("Failed to create new webfilter profile {0}: {1}");
            newBwordId && CMDB["delete"]("webfilter", "content", newBwordId), newUrlfilterId && CMDB["delete"]("webfilter", "urlfilter", newUrlfilterId), newProfileMkey && (CMDB["delete"]("webfilter", "profile", newProfileMkey), msg = $.validator.format(msg, newProfileMkey, reason), Notify.post(msg, "error"))
        }
        function cloneSubtables(newProfileMkey) {
            var cloneBword, cloneUrlfilter;
            return bwordMkey && (cloneBword = CMDB.clone("webfilter", "content", bwordMkey, 0, null, {}, {name: newProfileMkey})), urlfilterMkey && (cloneUrlfilter = CMDB.clone("webfilter", "urlfilter", urlfilterMkey, 0, null, {}, {name: newProfileMkey})), $.when(cloneBword, cloneUrlfilter, newProfileMkey).fail(function(failData) {
                var reason;
                failData && "object" == typeof failData && failData.error ? (reason = $.getInfo("unable to create profile subtable ({0})"), reason = $.validator.format(reason, $.getInfo(failData.error))) : reason = $.getInfo("unable to create profile subtable"), failed(reason, newProfileMkey, bwordMkey, urlfilterMkey)
            })
        }
        function storeSubtableIDs(newBwordId, newUrlfilterId, newProfileMkey) {
            var editProfileIds, newIds = {};
            return bwordMkey || urlfilterMkey ? (bwordMkey && (newIds["bword-table"] = newBwordId.mkey), urlfilterMkey && (newIds["urlfilter-table"] = newUrlfilterId.mkey), editProfileIds = CMDB.edit("webfilter", "profile", newProfileMkey, {web: newIds}).fail(function() {
                failed($.getInfo("failed to store subtable IDs"), newProfileMkey, newBwordId.mkey, newUrlfilterId.mkey)
            })) : editProfileIds = {mkey: newProfileMkey}, editProfileIds
        }
        var cloneProfile = fweb.cmdbClone({mkey: mkey,mkey_type: "string",path: "webfilter",name: "profile"});
        return cloneProfile.then(cloneSubtables).then(storeSubtableIDs)
    }, cmdbClone.DNSFilterProfile = function(mkey, urlfilterMkey) {
        function failed(reason, newProfileMkey, newUrlfilterId) {
            var msg = $.getInfo("Failed to create new dnsfilter profile {0}: {1}");
            newUrlfilterId && CMDB["delete"]("dnsfilter", "urlfilter", newUrlfilterId), newProfileMkey && (CMDB["delete"]("dnsfilter", "profile", newProfileMkey), msg = $.validator.format(msg, newProfileMkey, reason), Notify.post(msg, "error"))
        }
        function cloneSubtables(newProfileMkey) {
            var cloneUrlfilter;
            return urlfilterMkey && (cloneUrlfilter = CMDB.clone("dnsfilter", "urlfilter", urlfilterMkey, 0, null, {}, {name: newProfileMkey})), $.when(cloneUrlfilter, newProfileMkey).fail(function(failData) {
                var reason;
                failData && "object" == typeof failData && failData.error ? (reason = $.getInfo("unable to create profile subtable ({0})"), reason = $.validator.format(reason, $.getInfo(failData.error))) : reason = $.getInfo("unable to create profile subtable"), failed(reason, newProfileMkey, urlfilterMkey)
            })
        }
        function storeSubtableIDs(newUrlfilterId, newProfileMkey) {
            var editProfileIds, newIds = {};
            return urlfilterMkey ? (newIds["urlfilter-table"] = newUrlfilterId.mkey, editProfileIds = CMDB.edit("dnsfilter", "profile", newProfileMkey, {urlfilter: newIds}).fail(function() {
                failed($.getInfo("failed to store subtable IDs"), newProfileMkey, newUrlfilterId.mkey)
            })) : editProfileIds = {mkey: newProfileMkey}, editProfileIds
        }
        var cloneProfile = fweb.cmdbClone({mkey: mkey,mkey_type: "string",path: "dnsfilter",name: "profile"});
        return cloneProfile.then(cloneSubtables).then(storeSubtableIDs)
    }, cmdbClone.emailFilterProfile = function(mkey, bwlMkey) {
        function failed(reason, newProfileMkey, newBwlId) {
            var msg = $.getInfo("Failed to create new email filter profile {0}: {1}");
            newBwlId && CMDB["delete"]("spamfilter", "bwl", newBwlId), newProfileMkey && (CMDB["delete"]("spamfilter", "profile", newProfileMkey), msg = $.validator.format(msg, newProfileMkey, reason), Notify.post(msg, "error"))
        }
        function cloneSubtable(newProfileMkey) {
            var cloneBwl;
            return bwlMkey && (cloneBwl = CMDB.clone("spamfilter", "bwl", bwlMkey, 0, null, {}, {name: newProfileMkey})), $.when(cloneBwl, newProfileMkey).fail(function(failData) {
                var reason;
                failData && "object" == typeof failData && failData.error ? (reason = $.getInfo("unable to create profile subtable ({0})"), reason = $.validator.format(reason, $.getInfo(failData.error))) : reason = $.getInfo("unable to create profile subtable"), failed(reason, newProfileMkey, 0)
            })
        }
        function storeSubtableID(newBwlId, newProfileMkey) {
            var editProfileId;
            return editProfileId = bwlMkey ? CMDB.edit("spamfilter", "profile", newProfileMkey, {"spam-bwl-table": newBwlId.mkey}).fail(function() {
                failed($.getInfo("failed to store subtable ID"), newProfileMkey, newBwlId)
            }) : {mkey: newProfileMkey}
        }
        var cloneProfile = fweb.cmdbClone({mkey: mkey,mkey_type: "string",path: "spamfilter",name: "profile"});
        return cloneProfile.then(cloneSubtable).then(storeSubtableID)
    }, cmdbClone
}), fweb_define("jquery.validate.methods", ["jquery", "fweb.util/patterns", "fweb.util/ip", "jquery.validate"], null, function($, f_patterns, f_ip) {
    "use strict";
    function RequireSources(option) {
        function splitOr(value) {
            return value.split(/ *\|\| */g)
        }
        function splitAnd(value) {
            return value.split(/ *\&\& */g)
        }
        this._expression = splitOr(option).map(splitAnd)
    }
    return $(function() {
        if ($.valHooks.textarea = {get: function(elem) {
                return elem.value.replace(/\r?\n/g, "\r\n")
            }}, $.validator) {
            $.addLang("", "com_info"), $.extend($.validator.messages, {required: $.getInfo("validate_msg_required"),remote: $.getInfo("validate_msg_remote"),email: $.getInfo("validate_msg_email"),url: $.getInfo("validate_msg_url"),date: $.getInfo("validate_msg_date"),dateISO: $.getInfo("validate_msg_dateISO"),number: $.getInfo("validate_msg_number"),digits: $.getInfo("validate_msg_digits"),creditcard: $.getInfo("validate_msg_creditcard"),equalTo: $.getInfo("validate_msg_equalTo"),maxlength: $.validator.format($.getInfo("validate_msg_maxlength")),minlength: $.validator.format($.getInfo("validate_msg_minlength")),rangelength: $.validator.format($.getInfo("validate_msg_rangelength")),range: $.validator.format($.getInfo("validate_msg_range")),max: $.validator.format($.getInfo("validate_msg_max")),min: $.validator.format($.getInfo("validate_msg_min")),minItems: $.validator.format($.getInfo("validate_msg_minItems"))}), $.validator.submitFlagSubmitHandler = function(form) {
                form.submitFlag || (form.submitFlag = !0, form.submit())
            };
            var v_check = $.validator.prototype.check;
            $.validator.prototype.check = function(element) {
                var result = v_check.apply(this, arguments);
                return $(element).triggerHandler("validated", result), result
            };
            var v_defaultMessage = $.validator.prototype.defaultMessage;
            $.validator.prototype.defaultMessage = function(element) {
                function make_inline_icon(message) {
                    return $(element).is(".inline-edit, .inline-display") && (message = $('<f-icon class="fa-negate" title="' + message + '"></f-icon>'), message.qtip()), message
                }
                var result = v_defaultMessage.apply(this, arguments);
                return "function" == typeof result ? function() {
                    return make_inline_icon(result.apply(this, arguments))
                } : make_inline_icon(result)
            };
            var highlightExtra = function(highlightFn) {
                return function(element, errorClass, validClass) {
                    highlightFn.apply(this, arguments);
                    var $ml = $(element).closest(".multiList-container"), $selectWidget = $(element).siblings().filter(".select-widget");
                    $ml.length && highlightFn.call(this, $ml, errorClass, validClass), $selectWidget.length && highlightFn.call(this, $selectWidget, errorClass, validClass)
                }
            };
            $.validator.setDefaults({ignore: ':hidden:not(".multiList-container:visible>*"):not(:visible .validate_hidden):not(".select-widget:visible + input"):not(".select-widget:visible + textarea")',errorPlacement: function(error, element) {
                    var $qlist = element.closest(".qlist"), $field = element.closest(".field");
                    $qlist.length ? (element.is(".inline-edit, .inline-display") || (element = element.closest(".inline-edit, .inline-display")), error.insertAfter(element)) : $field.length ? error.appendTo($field) : element.hasClass("ui-spinner-input") ? error.insertAfter(element.parent()) : error.insertAfter(element)
                },highlight: highlightExtra($.validator.defaults.highlight),unhighlight: highlightExtra($.validator.defaults.unhighlight)});
            var original_required = $.validator.methods.required;
            $.validator.addMethod("required", function(value, element) {
                return element.getAttribute("data-select-widget") ? (value = JSON.parse(value), Array.isArray(value) ? value.length : value) : original_required.apply(this, arguments)
            }), jQuery.validator.addMethod("require-sources", function(value, element, option) {
                var sources = new RequireSources(option), instance = $(element).omniselect("getInstance");
                return instance && sources.requirementsMetBy(instance.getSelected())
            }, function(option) {
                var sources = new RequireSources(option);
                return $.getInfo("Please select a {REQUIRED_SOURCES}.", [sources.toString()])
            }), $.validator.addMethod("minItems", function(value, element, param) {
                return value = JSON.parse(value), $.validator.methods.minlength.call(this, value, element, param)
            }), $.validator.addMethod("time", function(value, element) {
                return this.optional(element) || /^(([0-1]?[0-9])|([2][0-3])):([0-5]?[0-9])(:([0-5]?[0-9]))?$/i.test(value)
            }, $.getInfo("-134")), $.validator.addMethod("datetimenosec", function(value, element) {
                return this.optional(element) || /^[0-9]{4}-(1[0-2]|0[1-9])-([0-2][0-9]|3[0-1]) ([0-1][0-9]|2[0-4]):([0-5][0-9])$/.test(value)
            }, "YYYY-MM-DD HH:MM"), $.validator.addMethod("emails", function(value, element) {
                if (this.optional(element))
                    return !0;
                for (var emails = value.indexOf(",") > 0 ? value.split(",") : value.split(";"), i = 0, len = emails.length; len > i; i++) {
                    var email = emails[i];
                    if (!jQuery.validator.methods.email.call(this, email, element))
                        return !1
                }
                return !0
            }, $.validator.messages.email), $.validator.addMethod("MacAddressChecker", function(value) {
                return RegExpCommon.MAC_ADDRESS.test(value)
            }, $.getInfo("-33")), $.validator.addMethod("IP4Checker", function(value, element, params) {
                if (this.optional(element))
                    return !0;
                if (!RegExpCommon.IP_HOST.test(value))
                    return !1;
                if ($.isPlainObject(params) && params.is_unicast_ip) {
                    var octets = value.split(".");
                    if (octets.length && octets[0] > 223)
                        return !1
                }
                return !0
            }, $.getInfo("-8")), $.validator.addClassRules("IP4Checker", {IP4Checker: !0}), $.validator.addMethod("IP4SubnetmaskRequired", function(value, element) {
                return this.optional(element) ? !0 : f_patterns.commonRegExp.SUBNET.test(value) && !f_patterns.commonRegExp.IP_HOST.test(value)
            }, $.getInfo("err_mask_required")), $.validator.addMethod("Hostname", function(value, element) {
                return this.optional(element) || RegExpCommon.IP_HOST.test(value) || RegExpCommon.FQDN.test(value)
            }, $.getInfo("-257")), $.validator.addMethod("domain_name", function(value, element) {
                return this.optional(element) || RegExpCommon.DOMAIN_NAME.test(value)
            }, $.getInfo("Invalid Domain Name")), $.validator.addMethod("IP6Hostname", function(value, element) {
                return this.optional(element) || RegExpCommon.IP6_HOST.test(value) || RegExpCommon.FQDN.test(value)
            }, $.getInfo("-257")), $.validator.addMethod("FQDN", function(value, element) {
                return this.optional(element) || RegExpCommon.FQDN.test(value)
            }, $.getInfo("err_fqdn")), $.validator.addMethod("FQDN_WILDCARD", function(value, element) {
                return this.optional(element) || RegExpCommon.FQDN_WILDCARD.test(value) && value && (value.indexOf("*") > -1 || value.indexOf("?") > -1)
            }, $.getInfo("err_wildcard_fqdn")), $.validator.addMethod("IP6Checker", function(value, element) {
                return this.optional(element) || RegExpCommon.IP6_HOST.test(value)
            }, $.getInfo("-255")), $.validator.addMethod("IP4NetmaskChecker", function(value) {
                return value ? RegExpCommon.IP_MASK.test(value) : !0
            }, $.getInfo("-9")), $.validator.addMethod("IP4SubnetChecker", function(value, element) {
                return this.optional(element) ? !0 : RegExpCommon.IP_SUBNET.test(value)
            }, $.getInfo("-9")), $.validator.addMethod("IP4VipSrcFilter", function(value, element) {
                var ADDR0 = /^0\.0\.0\.0$/, RANGE0 = /^0\.0\.0\.0\-(0|0\.0\.0\.0)$/, SUBNET0 = /^0\.0\.0\.0\/(32|0\.0\.0\.0)$/;
                return this.optional(element) ? !0 : RegExpCommon.IP_HOST.test(value) ? !ADDR0.test(value) : RegExpCommon.IP_SUBNET.test(value) ? !SUBNET0.test(value) : RegExpCommon.IP_RANGE.test(value) ? !RANGE0.test(value) : !1
            }, $.getInfo("err_vip_src_filter")), $.validator.addMethod("IP6VipSrcFilter", function(value, element) {
                return this.optional(element) ? !0 : RegExpCommon.IP6_HOST.test(value) || RegExpCommon.IP6_SUBNET.test(value) || $.validator.methods.IP6RangeChecker.call(this, value, element)
            }, $.getInfo("err_vip_src_filter")), $.validator.addMethod("IP4ListChecker", function(value, element) {
                if (this.optional(element))
                    return !0;
                var ips = value.split(/[,]+/), len = ips.length;
                if (!len)
                    return !1;
                for (var ip_set = {}, ip = "", i = 0; len > i; i++) {
                    if (ip = $.trim(ips[i]), ip in ip_set)
                        return !1;
                    if (ip_set[ip] = "", !(RegExpCommon.IP_SUBNET.test(ip) || RegExpCommon.IP_HOST.test(ip) || RegExpCommon.IP_WILDCARD.test(ip) || RegExpCommon.IP_RANGE.test(ip) || RegExpCommon.IP_RANGE2.test(ip)))
                        return !1
                }
                return !0
            }, $.getInfo("err_ip_mask_list"));
            var IP4NetChecker = function(value, element, opts) {
                if (this.optional(element))
                    return !0;
                if (value = $.trim(value), opts = $.extend({any: 1,multiple: 0}, opts), !RegExpCommon.IP_SUBNET.test(value))
                    return !1;
                var ipmask = f_ip.IpMask.parse(value), ip = ipmask.numbered();
                return opts.multiple && ipmask.netmask[3] >= 255 ? !1 : 0 === ip && opts.any || ipmask.addr[0] > 0 && 127 !== ipmask.addr[0] && ipmask.addr[0] < 224 || ipmask.netmask[3] >= 254 || ip !== ipmask.numbered(f_ip.IpMask.NETWORK) && ip !== ipmask.numbered(f_ip.IpMask.BROADCAST)
            };
            $.validator.addMethod("IP4IntfChecker", function(value, element) {
                return IP4NetChecker.call(this, value, element)
            }, $.getInfo("-9")), $.validator.addMethod("IP4NetList", function(value, element) {
                for (var addr, addresses = value.split(/[, ]/), i = 0, len = addresses.length; len > i; i++)
                    if (addr = addresses[i], !IP4NetChecker.call(this, addr, element, {any: 0,multiple: 1}))
                        return !1;
                return !0
            }, $.getInfo("-9")), $.validator.addMethod("IntfSubnetOverlap", function(value, element, params) {
                var ipmask = f_ip.IpMask.parse(value);
                if (!(params && params.ipmasks && params.overlap && value && 0 !== ipmask.numbered()))
                    return !0;
                var overlap_setting = $.isFunction(params.overlap) ? params.overlap() : params.overlap;
                if ("enable" === overlap_setting)
                    return !0;
                var existing_intf_ipmasks;
                if ($.isFunction(params.ipmasks))
                    existing_intf_ipmasks = params.ipmasks();
                else {
                    if (!$.isArray(params.ipmasks))
                        return !0;
                    existing_intf_ipmasks = params.ipmasks
                }
                var i, j, intf_ipmasks_len, intf_ipmask, elem_name = element.name, intf_name = params.intf_name || "", validator = this, existing_intf_ipmasks_len = existing_intf_ipmasks.length;
                validator.settings.messages[elem_name] || (validator.settings.messages[elem_name] = {});
                var general_msg = $.getInfo("-54");
                for (validator.settings.messages[elem_name].IntfSubnetOverlap = general_msg, i = 0; existing_intf_ipmasks_len > i; i++)
                    for (intf_ipmask = existing_intf_ipmasks[i], intf_ipmasks_len = intf_ipmask.ipmasks.length, j = 0; intf_ipmasks_len > j; j++)
                        if (intf_ipmask.intf !== intf_name && intf_ipmask.ipmasks[j].overlaps(value)) {
                            var msg = $.getInfo("Conflicts with other interface subnet");
                            return validator.settings.messages[elem_name].IntfSubnetOverlap = $.validator.format(msg, intf_ipmask.intf), !1
                        }
                return !0
            }, $.getInfo("-54")), $.validator.addMethod("IPConflictDetection", function(value, element, params) {
                function other_validation_error(error_obj) {
                    return error_obj.element && error_obj.element.name === elem_name && "IPConflictDetection" !== error_obj.method ? !0 : !1
                }
                function done_cb(response) {
                    var errors, submitted, valid = no_conflict(response, devs, value);
                    if (valid) {
                        var current_errorList = validator.errorList.slice(0), other_current_errors = current_errorList.filter(other_validation_error);
                        other_current_errors.length ? validator.showErrors() : (submitted = validator.formSubmitted, validator.prepareElement(element), validator.formSubmitted = submitted, validator.successList.push(element), delete validator.invalid[elem_name], validator.showErrors(), previous.valid = valid)
                    } else
                        errors = {}, errors[elem_name] = validator.defaultMessage(element, "IPConflictDetection"), validator.invalid[element.name] = !0, validator.showErrors(errors), previous.valid = valid;
                    validator.stopRequest(element, valid)
                }
                function get_all_dev_strs(devs) {
                    var i, dev_i, members, strs = [], devs_len = devs.length || 0;
                    for (i = 0; devs_len > i; i++)
                        dev_i = devs[i], "string" == typeof dev_i ? strs.push(dev_i) : (members = (dev_i || {}).members || [], strs = strs.concat(members));
                    return strs
                }
                function no_conflict(data, devs, ip) {
                    var _no_conflict = !0;
                    if (data && "success" === data.status) {
                        var i, result, results = data.results || [], len = results.length, dev_strs = get_all_dev_strs(devs);
                        for (i = 0; len > i; i++)
                            if (result = results[i], $.inArray(result.dev, dev_strs) >= 0 && result.ipaddr === ip && result.is_conflict) {
                                if (result.mac) {
                                    var msg = $.getInfo("This IP address is already in use by device");
                                    validator.settings.messages[elem_name].IPConflictDetection = $.validator.format(msg, result.mac)
                                } else
                                    validator.settings.messages[elem_name].IPConflictDetection = general_msg;
                                _no_conflict = !1;
                                break
                            }
                    }
                    return _no_conflict
                }
                var ipmask = f_ip.IpMask.parse(value);
                if (this.optional(element) || 0 === ipmask.numbered() || !params)
                    return !0;
                var validator, previous = this.previousValue(element), elem_name = element.name;
                if (previous.old === value)
                    return previous.valid;
                this.settings.messages[elem_name] || (this.settings.messages[elem_name] = {});
                var dev;
                if (dev = "string" == typeof params ? params : $.isFunction(params.dev) ? params.dev() : params.dev, !dev)
                    return !0;
                var devs = $.isArray(dev) ? dev : [dev];
                if (0 !== devs.length) {
                    previous.old = value, validator = this, validator.startRequest(element);
                    var API_URL = "/api/v2/monitor/system/ipconf/", req_json_str = JSON.stringify({devs: devs,ipaddr: value}), ajax_params = $.extend(!0, {url: API_URL,mode: "abort",port: "validate" + elem_name,
                        dataType: "json",data: {json: req_json_str},context: validator.currentForm}, params), general_msg = $.getInfo("This IP address conflicts with another device on the network"), dfd = $.ajax(ajax_params);
                    return dfd.done(done_cb), "pending"
                }
            }, $.getInfo("This IP address conflicts with another device on the network"));
            var parse_ip4_address = function(value) {
                var ipmask = f_ip.IpMask.parse(value), prefix = ipmask.numbered(f_ip.IpMask.NETWORK), ip = f_ip.IpMask.toNumber(ipmask.addr);
                return {ipmask: ipmask,prefix: prefix,ip: ip}
            }, ip4_subnetwork_validate_error = function(element) {
                if (!RegExpCommon.IP_SUBNET.test(element.value))
                    return $.getInfo("ip_subnet");
                var address = parse_ip4_address(element.value);
                return 0 === address.ip && 0 === address.prefix ? $.getInfo("err_ip4") : $.getInfo("err_subnet") + " " + f_ip.IpMask.toDotted(address.prefix).join(".") + "/" + address.ipmask.netmask.join(".")
            };
            $.validator.addMethod("IP4Subnetwork", function(value, element) {
                if (this.optional(element))
                    return !0;
                if (!RegExpCommon.IP_SUBNET.test(value))
                    return !1;
                var address = parse_ip4_address(element.value);
                return address.ip === address.prefix
            }, function(params, element) {
                return ip4_subnetwork_validate_error(element)
            }), $.validator.addMethod("StrictIP4Subnetwork", function(value, element) {
                if (this.optional(element))
                    return !0;
                if (!RegExpCommon.IP_SUBNET.test(value))
                    return !1;
                var address = parse_ip4_address(element.value);
                return address.ip === address.prefix && 0 !== address.ip && 0 !== address.prefix
            }, function(params, element) {
                return ip4_subnetwork_validate_error(element)
            }), $.validator.addMethod("IP6SubnetChecker", function(value, element) {
                return this.optional(element) ? !0 : RegExpCommon.IP6_SUBNET.test(value)
            }, $.getInfo("-255")), $.validator.addMethod("IP4ConflictChecker", function(value) {
                if (!parent || !parent.wizard)
                    return !0;
                if ("0.0.0.0" === value)
                    return !0;
                var value_mask = $('input[name="netmask"]').val();
                value_mask || (value_mask = "255.255.255.255");
                var value_ip = ipStrToNum(value);
                value_mask = ipStrToNum(value_mask);
                for (var data, data_ip, data_mask, history = parent.wizard.state.history, i = 0; i < history.length; i++)
                    if (data = history[i].data, data.ip && data.netmask && "0.0.0.0" !== data.ip && "static" === data.mode && (data_ip = ipStrToNum(data.ip), data_mask = ipStrToNum(data.netmask), (data_ip & data_mask) === (value_ip & data_mask) || (data_ip & value_mask) === (value_ip & value_mask)))
                        return !1;
                return !0
            }, $.getInfo("err_ip_conflict"));
            var isIP4Range = function(start_ip, end_ip, netmask) {
                return start_ip = ipStrToNum(start_ip), end_ip = ipStrToNum(end_ip), netmask = ipStrToNum(netmask), start_ip && end_ip ? (start_ip & netmask) !== (end_ip & netmask) || start_ip > end_ip ? !1 : !0 : !1
            };
            $.validator.addMethod("IP4RangeChecker", function(value, element, params) {
                var ip4range_fields = params || ["start-ip", "end-ip", "netmask"], start_ip = ip4range_fields[0], end_ip = ip4range_fields[1], netmask = ip4range_fields[2];
                return start_ip && end_ip ? (start_ip = $('input[name="' + start_ip + '"]').val(), end_ip = $('input[name="' + end_ip + '"]').val(), netmask = $('input[name="' + netmask + '"]').val() || "0.0.0.0", start_ip && end_ip ? isIP4Range(start_ip, end_ip, netmask) : !1) : !1
            }, $.getInfo("err_ip_range")), $.validator.addMethod("IP6RangeChecker", function(value, element) {
                if (this.optional(element))
                    return !0;
                var ip6range = value.replace(/ /g, "");
                if (ip6range = ip6range.split("-"), ip6range.length < 2)
                    return !1;
                var start_ip = ip6range[0], end_ip = ip6range[1];
                if (!$.validator.methods.IP6Checker.call(this, start_ip, element) || !$.validator.methods.IP6Checker.call(this, end_ip, element))
                    return !1;
                var start_ip_num = new goog.net.Ipv6Address(start_ip).toInteger(), end_ip_num = new goog.net.Ipv6Address(end_ip).toInteger();
                return start_ip_num.greaterThanOrEqual(end_ip_num) ? !1 : !0
            }, $.getInfo("err_ip_range")), $.validator.addMethod("IP4PoolRange", function(value) {
                return RegExpCommon.IP_RANGE.test(value) || RegExpCommon.IP_RANGE2.test(value) || RegExpCommon.IP_SUBNET.test(value) || RegExpCommon.IP_HOST.test(value) || RegExpCommon.IP_WILDCARD.test(value)
            }, $.getInfo("err_ip_range")), $.validator.addMethod("XSSChecker", function(value) {
                return RegExpCommon.XSS.test(value)
            }, $.getInfo("err_xss")), $.validator.addMethod("IdentifierChecker", function(value) {
                return RegExpCommon.NAME_NODOLLAR.test(value)
            }, $.getInfo("err_char")), $.validator.addMethod("nameRequired", $.validator.methods.required, $.getInfo("err_name")), $.validator.addClassRules("js-valid-name", {IdentifierChecker: !0,nameRequired: !0}), $.validator.addMethod("minlengthWarning", function() {
                return $.validator.methods.minlength.apply(this, arguments) || "warning"
            }, $.getInfo("err_pwd3")), $.validator.addClassRules("js-valid-password", {required: !0,minlengthWarning: 6}), $.validator.addMethod("CommentChecker", function(value, element) {
                return jQuery.validator.methods.maxlength.call(this, value, element, 63)
            }, $.getInfo("err_comment")), $.validator.addMethod("PortChecker", function(value, element) {
                return value ? RegExpCommon.INTEGER.test(value) ? 1 > value || value > 65535 ? !1 : !0 : !1 : this.optional(element)
            }, $.getInfo("-252")), $.validator.addMethod("PortlistChecker", function(value, element) {
                if ("string" != typeof value)
                    return !1;
                if (!value)
                    return this.optional(element);
                var portlist = value.split(/[,\-]/);
                if (portlist && portlist.length)
                    for (var i = 0; i < portlist.length; i++) {
                        var port = portlist[i].replace(/^\s+|\s+$/g, "");
                        if (!$.validator.methods.PortChecker.call(this, port))
                            return !1
                    }
                return !0
            }, $.getInfo("-252")), $.validator.addMethod("WeightChecker", function(value) {
                return RegExpCommon.INTEGER.test(value) ? 0 > value || value > 255 ? !1 : !0 : !1
            }, $.getInfo("err_weight")), $.validator.addMethod("SpilloverThresholdChecker", function(value) {
                return RegExpCommon.INTEGER.test(value) ? 0 > value || value > 2097e3 ? !1 : !0 : !1
            }, $.getInfo("err_range") + " 0-2097000"), $.validator.addMethod("DuplicateValueChecker", function(value, element, requests) {
                var ret = !0;
                try {
                    $.each(requests, function(idx, request) {
                        var path = request.path, name = request.name, key = request.key, exempt = request.exempt, dependency = request.dependency, vdom = request.vdom, exempt_vals = {}, dependency_vals = {};
                        $.each(exempt || {}, function(key) {
                            exempt_vals[key] = $(exempt[key]).val()
                        }), $.each(dependency || {}, function(key) {
                            dependency_vals[key] = $(dependency[key]).val()
                        });
                        var filter = {key: key,pattern: value,vdom: vdom};
                        CMDB.fetch(path, name, filter, function(response) {
                            function get_match_fn(a, b) {
                                return function(key) {
                                    return String(a[key]) === String(b[key])
                                }
                            }
                            for (var results = response.results, i = 0; i < results.length; i++) {
                                var dep_keys = Object.keys(dependency_vals), dependency_conflict = dep_keys.length && dep_keys.some(get_match_fn(dependency_vals, results[i])), is_conflict = !dependency || dependency_conflict, same_vdom = !(vdom && results[i].vdom && vdom !== results[i].vdom), exempt_keys = Object.keys(exempt_vals), is_exempt = exempt_keys.length && exempt_keys.some(get_match_fn(exempt_vals, results[i]));
                                if (!is_exempt && is_conflict && same_vdom)
                                    throw response
                            }
                        }, !1)
                    })
                } catch (err) {
                    ret = !1
                }
                return ret
            }, $.getInfo("err_duplicate_value")), $.validator.addMethod("ValueDupChecker", function(value, element) {
                return -1 === $(element).data("ValueDupChecker")().indexOf(value)
            }, $.getInfo("err_duplicate_value")), $.validator.addMethod("DuplicateEntryChecker", function(value, element, requests) {
                var JSONRPC = fweb_require("legacy.jsonrpc"), defaults = {mkeySelector: "#mkey"}, ret = !0, params = {};
                if ($.extend(requests, defaults), value === $(requests.mkeySelector).val())
                    return !0;
                for (var i = 0; i < requests.length; i++)
                    requests[i].mkey = value;
                return params.batch = requests, JSONRPC.Batch.send(params, {async: !1,on_success: function(response) {
                        var result;
                        try {
                            for (var i = 0; i < response.length; i++)
                                if (result = response[i].result)
                                    throw result
                        } catch (err) {
                            ret = !1
                        }
                    }}), ret
            }, $.getInfo("-15"));
            var rangeRegex = /\[ *['"]?([^'",]*)['"]? *, *['"]?([^'",]*)['"]? *\]/;
            $.validator.addMethod("RangeChecker", function(value, element, range) {
                if ("undefined" == typeof range && element.getAttribute("range")) {
                    var min, max, execResult = rangeRegex.exec(element.getAttribute("range"));
                    min = parseInt(execResult[1], 10), max = parseInt(execResult[2], 10), isNaN(min) || isNaN(max) || (range = [min, max])
                }
                return (!range || !range.length || range.length < 2) && (range = [0, Math.pow(2, 32) - 1]), $.validator.messages.RangeChecker = $.getInfo("err_range") + " " + range[0] + "-" + range[1], RegExpCommon.INTEGER.test(value) && value >= range[0] && value <= range[1]
            }, $.validator.messages.RangeChecker), $.validator.addMethod("PwdEqChecker", function(value, element) {
                var pwd_fields = element.getAttribute("password");
                pwd_fields && (pwd_fields = JSON.parse(pwd_fields)), pwd_fields || (pwd_fields = ["password", "password2"]);
                var pwd = pwd_fields[0], pwd2 = pwd_fields[1];
                if (!pwd || !pwd2)
                    return !1;
                var $pwd = $('input[name="' + pwd + '"]'), $pwd2 = $('input[name="' + pwd2 + '"]');
                return 0 === $pwd.length && 0 === $pwd2.length ? !0 : $pwd.val() === $pwd2.val() ? !0 : !1
            }, $.getInfo("err_pwd_match"));
            var confirm_password_method = function(value, element, param) {
                var $password, autoparam, _ref, $el = $(element), $form = $el.closest("form");
                return ("string" !== $.type(param) || param.length <= 0) && (param = "input[type=password]", autoparam = null != (_ref = /^(.+)2$/.exec($el.attr("name"))) ? 'input[name="' + _ref[1] + '"]' : null), null != autoparam && $form.length > 0 && ($password = $form.find(autoparam)), (null == $password || $password.length <= 0) && ($password = ($form.length > 0 ? $form.find(param) : $(param)).not($el).first()), $.validator.methods.equalTo.call(this, value, $el, $password)
            };
            $.validator.addMethod("confirm-password", confirm_password_method, $.getInfo("err_pwd_match")), $.validator.addMethod("confirm-password-name", function(value, element, param) {
                return confirm_password_method.call(this, value, element, 'input[name="' + param + '"]')
            }, $.getInfo("err_pwd_match")), $.validator.addMethod("host_mask_list", function(value, element) {
                if (this.optional(element))
                    return !0;
                for (var hosts = value.split(","), i = 0; i < hosts.length; i++) {
                    var host = $.trim(hosts[i]);
                    if (!RegExpCommon.IP_SUBNET.test(host) && !RegExpCommon.IP_HOST.test(host) && !RegExpCommon.IP_RANGE.test(host))
                        return !1
                }
                return !0
            }, "192.168.1.0/24, 172.16.1.1-172.16.1.20"), $.validator.addMethod("ip_fqdn", function(value, element) {
                if (this.optional(element))
                    return !0;
                var ret = RegExpCommon.IP_RANGE.test(value);
                if (ret)
                    return ret;
                if (ret = RegExpCommon.IP_RANGE2.test(value))
                    return ret;
                for (var hosts = value.split(/[\s,]+/), ip_exist = !1, fqdn_exist = !1, i = 0; i < hosts.length; i++) {
                    var host = $.trim(hosts[i]), is_ip_subnet = RegExpCommon.IP_SUBNET.test(host), is_ip_host = RegExpCommon.IP_HOST.test(host), is_fqdn = RegExpCommon.FQDN.test(host);
                    if (!is_ip_subnet && !is_ip_host && !is_fqdn)
                        return !1;
                    if ((is_ip_subnet || is_ip_host) && (ip_exist = !0), is_fqdn && !ip_exist && (fqdn_exist = !0), ip_exist && fqdn_exist)
                        return !1
                }
                return !0
            }, $.getInfo("err_ip_fqdn")), $.validator.addMethod("multicast_addr", function(value, element, param) {
                if (this.optional(element))
                    return !0;
                "undefined" == typeof param && (param = {});
                var ADDR0 = /^0\.0\.0\.0$/, ADDR_RANGE0 = /^0\.0\.0\.0-0\.0\.0\.0$/, allow0 = param.allow0 === !0, single = param.single === !0, range = param.range === !0;
                return single ? allow0 && ADDR0.test(value) ? !0 : RegExpCommon.MULTICAST_IP_HOST.test(value) : range ? allow0 && ADDR_RANGE0.test(value) ? !0 : RegExpCommon.MULTICAST_IP_RANGE.test(value) : allow0 ? RegExpCommon.MULTICAST_IP_HOST.test(value) || RegExpCommon.MULTICAST_IP_RANGE.test(value) || ADDR0.test(value) || ADDR_RANGE0.test(value) : RegExpCommon.MULTICAST_IP_HOST.test(value) || RegExpCommon.MULTICAST_IP_RANGE.test(value)
            }, $.getInfo("err_multicast_addr")), $.validator.addMethod("ipv4_range", function(value, element) {
                if (this.optional(element))
                    return !0;
                var default_range_check = RegExpCommon.IP_RANGE.test(value) || RegExpCommon.IP_RANGE2.test(value) || RegExpCommon.IP_HOST.test(value), is_in_range = !0;
                if ("string" == typeof value) {
                    var ips = value.split("-");
                    ips.push("0.0.0.0"), ips.length > 2 && (is_in_range = isIP4Range(ips[0], ips[1], ips[2]))
                }
                return default_range_check && is_in_range
            }, $.getInfo("err_ip_range")), $.validator.addMethod("number_list", function(value, element, param) {
                if (this.optional(element))
                    return !0;
                "undefined" == typeof param && (param = {});
                var separator = ",";
                "undefined" != typeof param.separator && (separator = param.separator);
                var values = value.split(separator);
                if ("undefined" != typeof param.max_values && values.length > param.max_values)
                    return !1;
                for (var min_required = "undefined" != typeof param.min, max_required = "undefined" != typeof param.max, i = 0; i < values.length; i++) {
                    var val = $.trim(values[i]);
                    if (!/^\d+$/.test(val))
                        return !1;
                    if (min_required && val < param.min || max_required && val > param.max)
                        return !1
                }
                return !0
            }, $.getInfo("custom")), $.validator.addMethod("number_range_list", function(value, element, param) {
                if (this.optional(element))
                    return !0;
                "undefined" == typeof param && (param = {});
                var total_values = 0, ranges = value.split(","), min_required = null != param.min, max_required = null != param.max, custom_error_message = function() {
                    return min_required && max_required && ($.validator.messages.number_range_list = param.min + "-" + param.max), !1
                };
                if (void 0 !== param.max_values && ranges.length > param.max_values || void 0 !== param.min_values && ranges.length < param.min_values)
                    return custom_error_message();
                for (var i = 0; i < ranges.length; i++) {
                    var r = $.trim(ranges[i]);
                    if (!/^\d+(-\d+)?$/.test(r))
                        return custom_error_message();
                    var v = r.split("-");
                    total_values += 1;
                    var v0 = parseInt(v[0], 10);
                    if (min_required && v0 < param.min || max_required && v0 > param.max)
                        return custom_error_message();
                    if (2 === v.length) {
                        var v1 = parseInt(v[1], 10);
                        if (min_required && v1 < param.min || max_required && v1 > param.max)
                            return custom_error_message();
                        if (v0 > v1)
                            return custom_error_message();
                        total_values += v1 - v0
                    }
                }
                return "undefined" != typeof param.max_total && total_values > param.max_total ? custom_error_message() : !0
            }, $.getInfo("custom")), $.validator.addMethod("hex-number", function(value, element) {
                return this.optional(element) || /\b(0x)?[0-9a-fA-F]+\b$/.test(value)
            }, $.getInfo("err_hex_number")), $.validator.addMethod("integer", function(value) {
                return RegExpCommon.INTEGER.test(value)
            }, $.getInfo("integer")), $.validator.addMethod("XML", function(value, element) {
                var isXml;
                if (this.optional(element))
                    return !0;
                try {
                    isXml = $.parseXML(value)
                } catch (e) {
                    isXml = !1
                }
                return isXml !== !1
            }, $.getInfo("err_invalid_xml")), jQuery.validator.addMethod("require_from_group", function(value, element, options) {
                var selector = options[1], validOrNot = $(selector, element.form).filter(function() {
                    return $(this).val()
                }).length >= options[0];
                if (!$(element).data("being_validated")) {
                    var fields = $(selector, element.form);
                    fields.data("being_validated", !0), fields.valid(), fields.data("being_validated", !1)
                }
                return validOrNot
            }, $.getInfo("err_require_from_group")), jQuery.validator.addMethod("skip_or_fill_minimum", function(value, element, options) {
                var numberRequired = options[0], selector = options[1], numberFilled = $(selector, element.form).filter(function() {
                    return $(this).val()
                }).length, valid = numberFilled >= numberRequired || 0 === numberFilled;
                if (!$(element).data("being_validated")) {
                    var fields = $(selector, element.form);
                    fields.data("being_validated", !0), fields.valid(), fields.data("being_validated", !1)
                }
                return valid
            }, $.getInfo("err_skip_or_fill_minimum")), jQuery.validator.addMethod("match_mask", function(value, element) {
                for (var tests = $(element).data("maskedinput_tests") || [], i = 0; i < tests.length; ++i)
                    if (tests[i] && !tests[i].test(value.charAt(i)))
                        return !1;
                return !0
            }, $.getInfo("err_match_mask")), jQuery.validator.addMethod("intf_diff", function(value, element, options) {
                var src = options[0], dst = options[1], src_val = $(src).val(), dst_val = $(dst).val();
                return "" === src_val || "" === dst_val ? !0 : "any" === src_val && "any" === dst_val ? !0 : src_val !== dst_val
            }, $.getInfo("err_intf_diff")), jQuery.validator.addMethod("url_noscheme", function(value, element) {
                return this.optional(element) || /^((https?|s?ftp):\/\/)?(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i.test(value)
            }, jQuery.validator.messages.url), jQuery.validator.addMethod("SimpleUrlChecker", function(value) {
                function testUrl(value) {
                    var components = value.split(/^(([^:\/?#]*):\/\/)?([^\/?#]*)?([^?#]*)(\?([^#]*))?(#(.*))?/), urlRegex = /(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i, pathRegex = /(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?/, hasSchema = void 0 !== components[2], hasAuthority = void 0 !== components[3], hasPath = void 0 !== components[4];
                    return hasSchema && -1 === ["https", "http"].indexOf(components[2].toLowerCase()) ? !1 : !hasAuthority && hasPath ? pathRegex.test(value) : urlRegex.test(value)
                }
                var valid = "localhost" === value || RegExpCommon.IP_HOST.test(value) || RegExpCommon.IP6_HOST.test(value.slice(1, -1)) && "[" === value.charAt(0) && "]" === value.charAt(value.length - 1);
                return valid ? valid : testUrl(value)
            }, jQuery.getInfo("err_urlfilter_url")), jQuery.validator.addMethod("SimpleDomainFilterChecker", function(value) {
                return $.validator.methods.SimpleUrlChecker.call(this, value)
            }, jQuery.getInfo("err_domain_filter")), jQuery.validator.addMethod("regex", function(value, element) {
                try {
                    return this.optional(element) || new RegExp(value)
                } catch (ex) {
                    return !1
                }
            }, function(params, element) {
                try {
                    new RegExp($(element).val())
                } catch (ex) {
                    var result = ex.message;
                    return /expr/i.test(result) || ($.loadedScript = [], result = $.getInfo("-653").replace(/\.$/, "") + ": " + result), result
                }
            }), jQuery.validator.addMethod("regex_match", function(value, element, regexp) {
                try {
                    var re = new RegExp(regexp);
                    return this.optional(element) || re.test(value)
                } catch (ex) {
                    return !1
                }
            }, $.getInfo("-50")), jQuery.validator.addMethod("required_one", function(value, element, options) {
                var opt1 = $(options[0]).val(), jopt2 = $(options[1]), opt2 = jopt2.val(), opt1_selected = "" !== opt1 && "none" !== opt1, opt2_selected = "" !== opt2 && "none" !== opt2 && (jopt2.is(":visible") || jopt2.closest(".multiList-container").is(":visible"));
                return opt1_selected || opt2_selected
            }, $.getInfo("err_auth_method_required")), $.validator.bakeMethod = function(method, param, name, message) {
                null == name && (name = "" + method + param), $.validator.addMethod(name, function(value, element) {
                    return $.validator.methods[method].call(this, value, element, param)
                }, null != message ? message : function(parameters, element) {
                    return $.validator.defaultMessage.call(this, element, method)
                })
            }, jQuery.validator.addMethod("smsphoneLengthChecker", function(value, element, options) {
                var country_code = $(options[0]).text(), country_code_custom = $(options[1]).val(), phone_num = $(options[2]).val().replace(/_/g, ""), max_length = 15, phone = country_code.replace("+", "") + country_code_custom + phone_num;
                return phone.length <= max_length
            }, $.getInfo("sms_phone_length")), jQuery.validator.addMethod("lowest-version", function(value, element, option) {
                function makeInt(n) {
                    return parseInt(n, 10)
                }
                for (var part, minPart, minVer = option.split(".").map(makeInt), ver = value.split(".").map(makeInt), len = Math.min(minVer.length, ver.length), i = 0; len > i; ++i) {
                    if (part = ver[i], minPart = minVer[i], part > minPart)
                        return !0;
                    if (minPart > part)
                        return !1
                }
                return !0
            }, $.getInfo("Lowest supported version is {VERSION}")), jQuery.validator.addMethod("seq-version-parts", function(value, element, option) {
                var seqLen = parseInt(option, 10), test = RegExp.prototype.test.bind(/^\d$/), parts = value.split(".");
                return "" === value || parts.length === seqLen && parts.every(test)
            }, $.getInfo("Invalid version number. Must contain {0} numeric parts, separated by a .")), jQuery.validator.addClassRules("seq-version-parts", {"seq-version-parts": 3})
        }
    }), RequireSources.prototype = {toString: function() {
            function joinAnd(arr) {
                return arr.map(translate).join(" and ")
            }
            function translate(source) {
                return $.getInfo(source)
            }
            return this._expression.map(joinAnd).join(" or ")
        },requirementsMetBy: function(values) {
            function everySourcePresent(sources) {
                return sources.every(present)
            }
            function present(source) {
                return values.some(function(value) {
                    return value.q_path + "." + value.q_name === source
                })
            }
            return this._expression.some(everySourcePresent)
        }}, {RequireSources: RequireSources}
}), fweb_define("legacy.checkip", null, null, function() {
    window.alertWinIP = function(IP, errmsg) {
        window.alert(IP + " " + errmsg)
    }, window.isInt = function(numStr) {
        var i, c;
        for (i = 0; i < numStr.length; i++)
            if (c = numStr.charAt(i), "0" > c || c > "9")
                return !1;
        return !0
    }, window.isIP = function(ip_str) {
        var octetInt, ipArray = ip_str.split(".");
        if (4 != ipArray.length)
            return !1;
        for (var i = 0; 4 > i; i++) {
            if (!isInt(ipArray[i]))
                return !1;
            if (octetInt = parseInt(ipArray[i], 10), 0 > octetInt || octetInt > 255)
                return !1
        }
        return "0" == ipArray[0] ? !1 : !0
    }, window.ipStrToNum = function(ip_str) {
        for (var ipValue = 0, ipArray = ip_str.split("."), i = 0; 4 > i; i++)
            ipValue <<= 8, ipValue += parseInt(ipArray[i], 10);
        return ipValue
    }, window.verifyIP = function(cntrl, errmsg) {
        for (var k, val = [], i = 0, index = 0, longIPVal = 0, ip_str = cntrl.value; index < ip_str.lastIndexOf(".") && (k = index, index = ip_str.indexOf(".", index), val[i] = parseInt(ip_str.substring(k, index), 10), !(val[i] < 0 || val[i] > 255)); )
            i++, index++;
        if (127 == val[0] && (i = 0), 3 == i)
            if (ip_str.length > index) {
                if (val[i] = parseInt(ip_str.substring(index, ip_str.length), 10), !(val[i] < 0 || val[i] > 255))
                    return val[0] = val[0] * Math.pow(2, 24), val[1] = val[1] * Math.pow(2, 16), val[2] = val[2] * Math.pow(2, 8), longIPVal = val[0] + val[1] + val[2] + val[3];
                i = 2
            } else
                i = 2;
        return 3 != i ? (alertWinIP(cntrl.value, errmsg), cntrl.select(), 999999) : !0
    }, window.stringToNumber = function(str) {
        return parseInt(str, 10)
    }, window.verifyIPAndMask = function(cntrl, errmsg) {
        var i, parts, first, second, ip_mask_str = cntrl.value, tokens = ip_mask_str.split(".");
        if (tokens.length < 4)
            return alertWinIP(cntrl.value, errmsg), !1;
        for (i = 0; 3 > i; i++)
            if (stringToNumber(tokens[i]) < 0 || stringToNumber(tokens[i]) > 255)
                return alertWinIP(cntrl.value, errmsg), !1;
        if (4 == tokens.length) {
            if (stringToNumber(tokens[3]) >= 0 && stringToNumber(tokens[i]) <= 255)
                return !0;
            if (0 === tokens[3].indexOf("*"))
                return !0;
            if (parts = tokens[3].split("/"), 2 == parts.length)
                return stringToNumber(parts[0]) < 0 || stringToNumber(parts[0]) > 255 ? (alertWinIP(cntrl.value, errmsg), !1) : stringToNumber(parts[1]) < 0 || stringToNumber(parts[1]) > 32 ? (alertWinIP(cntrl.value, errmsg), !1) : !0;
            if (parts = tokens[3].split("-"), 2 == parts.length && (first = stringToNumber(parts[0].substring(1, parts[0].length)), second = stringToNumber(parts[1].substring(0, parts[1].length - 1)), 0 === parts[0].indexOf("[") && first >= 0 && 255 >= first && parts[1].indexOf("]") == parts[1].length - 1 && second >= 0 && 255 >= second && second >= first))
                return !0
        }
        if (7 == tokens.length) {
            for (i = 0; 7 > i; i++)
                if (3 != i && (stringToNumber(tokens[i]) < 0 || stringToNumber(tokens[i]) > 255))
                    return alertWinIP(cntrl.value, errmsg), !1;
            if (parts = tokens[3].split("/"), 2 == parts.length)
                return stringToNumber(parts[0]) < 0 || stringToNumber(parts[0]) > 255 ? (alertWinIP(cntrl.value, errmsg), !1) : stringToNumber(parts[1]) < 0 || stringToNumber(parts[1]) > 255 ? (alertWinIP(cntrl.value, errmsg), !1) : !0;
            if (parts = tokens[3].split("-"), 2 == parts.length && (first = stringToNumber(parts[0].substring(0, parts[0].length)), second = stringToNumber(parts[1].substring(0, parts[1].length)), first >= 0 && 255 >= first && second >= 0 && 255 >= second))
                return !0
        }
        return alertWinIP(cntrl.value, errmsg), !1
    }
}), fweb_define("legacy.not_prototype", null, "NotPrototype", function() {
    var PrototypeFormElementSerializers = {input: function(element) {
            switch (element.type.toLowerCase()) {
                case "checkbox":
                case "radio":
                    return PrototypeFormElementSerializers.inputSelector(element);
                default:
                    return PrototypeFormElementSerializers.textarea(element)
            }
        },inputSelector: function(element) {
            return element.checked ? element.value : null
        },textarea: function(element) {
            return element.value
        },select: function(element) {
            return this["select-one" == element.type ? "selectOne" : "selectMany"](element)
        },selectOne: function(element) {
            var index = element.selectedIndex;
            return index >= 0 ? this.optionValue(element.options[index]) : null
        },selectMany: function(element) {
            var values, i, length = element.length;
            if (!length)
                return null;
            for (i = 0, values = []; length > i; i++) {
                var opt = element.options[i];
                opt.selected && values.push(this.optionValue(opt))
            }
            return values
        },optionValue: function(opt) {
            return opt.hasAttribute("value") ? opt.value : opt.text
        }}, NotPrototype = {Browser: {IE: !(!window.attachEvent || window.opera),WebKit: navigator.userAgent.indexOf("AppleWebKit/") > -1},Form: {getElements: function(form) {
                return jQuery.map(form.getElementsByTagName("*"), function(child) {
                    return PrototypeFormElementSerializers[child.tagName.toLowerCase()] ? child : void 0
                })
            },getValue: function(element) {
                var method = element.tagName.toLowerCase();
                return PrototypeFormElementSerializers[method](element)
            }},Event: {stop: function(event) {
                event.preventDefault ? (event.preventDefault(), event.stopPropagation()) : (event.returnValue = !1, event.cancelBubble = !0)
            }},Position: {cumulativeOffset: function(element) {
                var valueT = 0, valueL = 0;
                do
                    valueT += element.offsetTop || 0, valueL += element.offsetLeft || 0, element = element.offsetParent;
                while (element);
                return [valueL, valueT]
            },positionedOffset: function(element) {
                var valueT = 0, valueL = 0;
                do
                    if (valueT += element.offsetTop || 0, valueL += element.offsetLeft || 0, element = element.offsetParent) {
                        if ("body" == element.tagName.toLowerCase())
                            break;
                        var p = jQuery(element).css("position");
                        if ("relative" == p || "absolute" == p)
                            break
                    }
                while (element);
                return [valueL, valueT]
            },page: function(forElement) {
                var valueT = 0, valueL = 0, element = forElement;
                do
                    if (valueT += element.offsetTop || 0, valueL += element.offsetLeft || 0, element.offsetParent == document.body && "absolute" == jQuery(element).css("position"))
                        break;
                while (element = element.offsetParent);
                element = forElement;
                do
                    window.opera && "body" != element.tagName.toLowerCase() || (valueT -= element.scrollTop || 0, valueL -= element.scrollLeft || 0);
                while (element = element.parentNode);
                return [valueL, valueT]
            },absolutize: function(element) {
                var $element = jQuery(element);
                if ("absolute" != $element.css("position")) {
                    var position = $element.position(), top = position.top, left = position.left, width = element.clientWidth, height = element.clientHeight;
                    $element.data("absolutize_original", {left: left - parseFloat($element.css("left") || 0),top: top - parseFloat($element.css("top") || 0),width: $element.css("width"),height: $element.css("height")}).css({top: top + "px",left: left + "px",width: width + "px",height: height + "px",position: "absolute"})
                }
            }},String: {toQueryParams: function(string, separator) {
                var match = string.trim().match(/([^?#]*)(#.*)?$/);
                return match ? match[1].split(separator || "&").reduce(function(hash, pair) {
                    if ((pair = pair.split("="))[0]) {
                        var key = decodeURIComponent(pair.shift()), value = pair.length > 1 ? pair.join("=") : pair[0];
                        null != value && (value = decodeURIComponent(value)), key in hash ? (hash[key].constructor != Array && (hash[key] = [hash[key]]), hash[key].push(value)) : hash[key] = value
                    }
                    return hash
                }, {}) : {}
            }}};
    return NotPrototype.Browser.WebKit && (NotPrototype.Position.cumulativeOffset = function(element) {
        var valueT = 0, valueL = 0;
        do {
            if (valueT += element.offsetTop || 0, valueL += element.offsetLeft || 0, element.offsetParent == document.body && "absolute" == Element.getStyle(element, "position"))
                break;
            element = element.offsetParent
        } while (element);
        return [valueL, valueT]
    }), window.Option || (window.Option = function(text, value, defaultSelected, selected) {
        var opt = document.createElement("option");
        return opt.textContent = text, opt.value = value, opt.defaultSelected = defaultSelected, opt.selected = selected, opt
    }), NotPrototype
}), fweb_define("jquery.support", ["jquery"], null, function($) {
    "use strict";
    var detector = document.createElement("div"), has_style_support = function(property, value) {
        return detector.style[property] = value, detector.style[property] === value
    }, support = {flexbox: ["flex", "-webkit-flex", "-webkit-box", "-ms-flexbox"].some(has_style_support.bind(null, "display")),transitionEvent: "TransitionEvent" in window};
    for (var i in support)
        i in $.support || ($.support[i] = support[i]);
    support.flexbox || (document.documentElement.className += " no-flexbox")
}), fweb_define("legacy.savetree_cookie", null, null, function() {
    var _fgtCookieName = null, _fgtCookieValue = null;
    window.BeginSetCookie = function(prefix, cookieName) {
        _fgtCookieName = prefix + "/" + cookieName, _fgtCookieValue = new String
    }, window.AddCookieValue = function(value) {
        for (var i, escValue = new String, i = 0; i < value.length; i++) {
            var oneChar = value.substring(i, i + 1);
            (" " == oneChar || "\\" == oneChar) && (escValue += "\\"), escValue += oneChar
        }
        _fgtCookieValue += escValue + " "
    }, window.EndSetCookie = function() {
        pathname = location.pathname, pathname = pathname.substring(0, pathname.lastIndexOf("/")) + "/";
        var expireDate = new Date;
        expireDate.setTime(expireDate.getTime() + 31536e6), document.cookie = _fgtCookieName + "=" + escape(_fgtCookieValue) + "; expires=" + expireDate.toGMTString() + "; path=" + pathname
    }, window.getCookieVal = function(offset) {
        var endstr = document.cookie.indexOf(";", offset);
        return -1 == endstr && (endstr = document.cookie.length), unescape(document.cookie.substring(offset, endstr))
    }, window.GetCookie = function(name) {
        for (var arg = "FortiGate" + name + "=", alen = arg.length, clen = document.cookie.length, i = 0; clen > i; ) {
            var j = i + alen;
            if (document.cookie.substring(i, j) == arg)
                return getCookieVal(j);
            if (i = document.cookie.indexOf(" ", i) + 1, 0 == i)
                break
        }
        return null
    }, window.save_tree_state = function(prefix, cname) {
        BeginSetCookie(prefix, cname), $j("[name=tree] img:first-child").each(function() {
            var img_obj = this, txt_obj = this.nextSibling.nextSibling;
            txt_obj && img_obj.src.match(/twistie_expanded.gif$/) && AddCookieValue(txt_obj.innerHTML)
        }), EndSetCookie()
    }
}), fweb_define("legacy.wij_modal_core", null, null, function() {
    var IE = window.ActiveXObject, IE6 = (navigator.userAgent.indexOf("Gecko") > 0, IE && getInternetExplorerVersion() < 7), have_position_fixed = !IE6, propagate_modal_mask = !0, modal_op_dialog = 1, modal_op_rename = 2, modal_op_menu = 3, modal_op_auxiliary = 4, InlineModal = {in_modal_op: !1,op_type: 0,maskdiv_callbacks_init: !1,mask_div: null,dlg_div: null,end_contextmenu_cb: null,scroll_contextmenu_cb: null,end_rename_cb: null,aux_target_wnd: null,in_rename_op: function() {
            return this.in_modal_op && this.op_type == modal_op_rename
        }}, wij_modal_show_timer = null;
    if (!mlogger)
        var mlogger = {debug: function(msg) {
            }};
    var wij_align_modal_dlg = (window.wij_in_modal_op = function() {
        return InlineModal.in_modal_op && InlineModal.op_type == modal_op_dialog
    }, window.handle_maskdiv_click = function() {
        var oModal = InlineModal;
        return oModal.in_modal_op ? void (oModal.op_type == modal_op_rename ? wij_end_modal_rename(!0) : oModal.op_type == modal_op_menu ? wij_end_contextmenu_mask() : oModal.op_type == modal_op_auxiliary && oModal.aux_target_wnd.handle_maskdiv_click()) : !1
    }, window.wij_align_modal_dlg = function() {
        if (mlogger.debug("wij_align_modal_dlg"), !InlineModal.in_modal_op)
            return void mlogger.debug("wij_align_modal_dlg - skip alignment");
        var dlg_div = InlineModal.dlg_div, root = document.documentElement, w_dlg = dlg_div.offsetWidth || dlg_div.firstChild && dlg_div.firstChild.offsetWidth || 400, h_dlg = dlg_div.offsetHeight || dlg_div.firstChild && dlg_div.firstChild.offsetHeight || 300, w_pg = root.clientWidth, h_pg = root.clientHeight, h_off = (h_pg - h_dlg - 100) / 2;
        0 > h_off && (h_off = 0);
        var l = (w_pg - w_dlg) / 2, t = h_off;
        mlogger.debug("w_pg=" + w_pg + ", w_dlg=" + w_dlg + ", l=" + l), 
        mlogger.debug("h_pg=" + h_pg + ", h_dlg=" + h_dlg + ", t=" + t), dlg_div.style.left = l + "px", dlg_div.style.top = t + "px"
    }), wij_adjust_mask_size = window.wij_adjust_mask_size = function() {
        var mask_div = InlineModal.mask_div, root = document.documentElement, bd = document.body, h_pg = (root.clientWidth, root.clientHeight), h_bd = (bd.offsetWidth, bd.offsetHeight), h = Math.max(h_pg, h_bd);
        mask_div.style.height = h + "px"
    }, wij_modal_onscroll = window.wij_modal_onscroll = function() {
        if (!have_position_fixed) {
            var oModal = InlineModal;
            if (oModal.in_modal_op)
                if (oModal.op_type == modal_op_dialog) {
                    var dv_dialog = oModal.dlg_div;
                    dv_dialog.style.visibility = "hidden", wij_modal_show_timer && clearTimeout(wij_modal_show_timer), wij_modal_show_timer = setTimeout(wij_align_and_show_modal_dlg, 50)
                } else
                    oModal.op_type == modal_op_menu && oModal.scroll_contextmenu_cb && oModal.scroll_contextmenu_cb()
        }
    }, wij_modal_onresize = window.wij_modal_onresize = function() {
        var oModal = InlineModal;
        oModal.in_modal_op && (wij_adjust_mask_size(), oModal.op_type == modal_op_dialog && wij_align_modal_dlg())
    }, setup_maskdiv_callbacks = window.setup_maskdiv_callbacks = function() {
        InlineModal.maskdiv_callbacks_init || (addEvent(window, "resize", wij_modal_onresize), addEvent(window, "scroll", wij_modal_onscroll), IE && addEvent(document.body.firstChild, "resize", wij_modal_onresize), InlineModal.maskdiv_callbacks_init = !0)
    }, setup_mask_div = window.setup_mask_div = function() {
        var mask_div = InlineModal.mask_div;
        if (mask_div)
            return mask_div;
        var tmp_div = document.createElement("DIV");
        return tmp_div.innerHTML = '<div id="maskDiv" style="display: none; background-color: black; position: absolute; left: 0; top: 0; z-index: 10000; height: 100%; width: 100%; -moz-opacity: 0.5; opacity: 0.5; filter: alpha(opacity=50);"  onclick="handle_maskdiv_click()" onmousedown="return false" onmousemove="return false"  onmouseup="return false" ondblclick="return false" onselectstart="return false" oncontextmenu="return false"></div>', mask_div = tmp_div.childNodes[0], $j(mask_div).appendTo("body"), InlineModal.mask_div = mask_div, mask_div
    }, display_mask_div = window.display_mask_div = function(opacity) {
        var mask_div = InlineModal.mask_div;
        if ($j(mask_div).css("opacity", opacity), mask_div.style.visibility = "hidden", mask_div.style.display = "", wij_adjust_mask_size(), mask_div.style.visibility = "visible", setup_maskdiv_callbacks(), propagate_modal_mask && top != window && top.display_auxiliary_mask) {
            var wnd = window.parent;
            if (wnd && wnd.wij_in_modal_op && wnd.wij_in_modal_op())
                return;
            var panels_adjusted = 0;
            top.$j(".layout-center").css("z-index", ""), top.$j(".layout-main").each(function() {
                var elem = $j(this);
                elem.data("zIndex", elem.css("z-index")), elem.css("z-index", 10100), panels_adjusted++
            }), panels_adjusted > 0 && top.display_auxiliary_mask(window, opacity)
        }
    }, hide_mask_div = (window.display_auxiliary_mask = function(target_wnd, opacity) {
        var oModal = InlineModal;
        if (!oModal.in_modal_op && target_wnd != window) {
            oModal.in_modal_op = !0, oModal.op_type = modal_op_auxiliary, oModal.aux_target_wnd = target_wnd;
            var mask_div = setup_mask_div();
            $j(mask_div).css("opacity", opacity), mask_div.style.visibility = "hidden", mask_div.style.display = "", wij_adjust_mask_size(), mask_div.style.visibility = "visible", setup_maskdiv_callbacks()
        }
    }, window.hide_mask_div = function() {
        var mask_div = InlineModal.mask_div;
        if (mask_div.style.display = "none", propagate_modal_mask && top != window && top.hide_auxiliary_mask) {
            var wnd = window.parent;
            if (wnd && wnd.wij_in_modal_op && wnd.wij_in_modal_op())
                return;
            top.$j(".layout-center").css("z-index", 1), top.$j(".layout-main").each(function() {
                var elem = $j(this);
                elem.css("z-index", elem.data("zIndex"))
            }), top.hide_auxiliary_mask(window)
        }
    }), setup_modal_dlg = (window.hide_auxiliary_mask = function(target_wnd) {
        if (target_wnd != window) {
            var mask_div = InlineModal.mask_div;
            mask_div.style.display = "none";
            var oModal = InlineModal;
            oModal.in_modal_op && oModal.op_type == modal_op_auxiliary && (oModal.in_modal_op = !1, oModal.op_type = 0)
        }
    }, window.setup_modal_dlg = function() {
        var dv_modal = InlineModal.dlg_div;
        if (dv_modal)
            return dv_modal;
        var tmp_div = document.createElement("DIV");
        return tmp_div.innerHTML = '<div id="modal_div" style="position:absolute; overflow:hidden; display:none; visibility:hidden; background-color: white; left: -1000; top: -1000; z-index: 10001"></div>', dv_modal = tmp_div.childNodes[0], $j(dv_modal).appendTo("body"), InlineModal.dlg_div = dv_modal, dv_modal
    }), crack_kbd_event = (window.wij_set_modal_options = function(opts) {
        var oModal = InlineModal;
        if (oModal.height = "auto", oModal.width = 300, oModal.close_button = !0, oModal.callback_handlers = !0, oModal.bg_color = "#ddd", oModal.escape_to_exit = !0, "object" == typeof opts)
            for (var prop in opts)
                prop in oModal && (oModal[prop] = opts[prop])
    }, window.crack_kbd_event = function(evt) {
        return evt.which ? evt.which : evt.keyCode ? evt.keyCode : (clogger.debug("crack_kbd_event - No key code in keypress!"), 0)
    }), on_rename_keypress = window.on_rename_keypress = function(ev) {
        ev || (ev = window.event);
        var key_code = crack_kbd_event(ev);
        return 13 == key_code ? wij_end_modal_rename(!0) : 27 == key_code && wij_end_modal_rename(!1), !0
    }, on_rename_blur = window.on_rename_blur = function(ev) {
        wij_end_modal_rename(!0)
    }, wij_end_modal_rename = (window.wij_display_rename_dlg = function(dv_main, edit_ctrl, cb_fn) {
        clogger.debug("wij_display_rename_dlg");
        var oModal = InlineModal;
        oModal.in_modal_op = !0, oModal.op_type = modal_op_rename, oModal.end_rename_cb = cb_fn;
        var dv_dialog = setup_modal_dlg(), root = (setup_mask_div(), document.documentElement);
        dv_dialog.innerHTML = "", dv_dialog.appendChild(dv_main), dv_dialog.style.position = "absolute", dv_dialog.style.left = 0, dv_dialog.style.top = 0, dv_dialog.style.width = root.offsetWidth + "px", dv_dialog.style.height = root.offsetHeight + "px", dv_dialog.style.backgroundColor = "", dv_dialog.style.display = "", dv_dialog.style.visibility = "visible", display_mask_div(.3), edit_ctrl.onkeypress = on_rename_keypress, edit_ctrl.onblur = on_rename_blur, edit_ctrl.focus()
    }, window.wij_end_modal_rename = function(bCommit) {
        var oModal = InlineModal, dv_dialog = oModal.dlg_div;
        clogger.debug("wij_end_modal_rename - invoking callback");
        var edit_ctrl = $j(dv_dialog).children(":first").get(0);
        oModal.end_rename_cb(edit_ctrl, bCommit), oModal.in_modal_op = !1, oModal.op_type = 0, dv_dialog.innerHTML = "", dv_dialog.style.display = "none", hide_mask_div()
    }), reposition_top_aligned_menu = (window.wij_display_contextmenu_mask = function(cb_end, oMenu) {
        var oModal = InlineModal;
        if (oModal.in_modal_op = !0, oModal.op_type = modal_op_menu, oModal.end_contextmenu_cb = cb_end, oMenu.ignore_y_coord)
            if (have_position_fixed)
                oMenu.element.style.position = "fixed", oModal.scroll_contextmenu_cb = null;
            else {
                var mk_cb_scroll = function(oMenu) {
                    return function() {
                        reposition_top_aligned_menu(oMenu)
                    }
                }, cb_scroll = oMenu.ignore_y_coord ? mk_cb_scroll(oMenu) : null;
                oModal.scroll_contextmenu_cb = cb_scroll
            }
        else
            oMenu.element.style.position = "absolute", oModal.scroll_contextmenu_cb = null;
        setup_mask_div();
        display_mask_div(.15)
    }, window.reposition_top_aligned_menu = function(oMenu) {
        var bd = oMenu.output_document.documentElement, scroll_pos = bd.scrollTop, dv_menu = oMenu.element;
        dv_menu.style.top = scroll_pos + "px"
    }), in_wij_end_contextmenu_mask_cb = !1, wij_end_contextmenu_mask = window.wij_end_contextmenu_mask = function() {
        if (!in_wij_end_contextmenu_mask_cb) {
            var oModal = InlineModal;
            in_wij_end_contextmenu_mask_cb = !0, oModal.end_contextmenu_cb(), in_wij_end_contextmenu_mask_cb = !1, oModal.in_modal_op = !1, oModal.op_type = 0, hide_mask_div()
        }
    };
    window.wij_display_genericmenu_mask = function(cb_end, elem) {
        var oModal = InlineModal;
        oModal.in_modal_op = !0, oModal.op_type = modal_op_menu, oModal.scroll_contextmenu_cb = null, oModal.end_contextmenu_cb = cb_end, elem.style.position = "absolute", propagate_modal_mask = !1;
        setup_mask_div();
        display_mask_div(.15)
    }, window.wij_auto_resize_iframe = function() {
        return mlogger.debug("wij_auto_resize_iframe"), InlineModal.in_modal_op ? ($j("iframe", InlineModal.dlg_div).each(function() {
            this.scrolling = "no", "auto" == InlineModal.height && update_iframe_height(this.id), this.scrolling = "auto"
        }), void wij_align_modal_dlg()) : void mlogger.debug("wij_auto_resize_iframe - skip alignment")
    }, window.wij_add_close_button = function() {
        mlogger.debug("wij_add_close_button");
        var wnd = window.parent, doc_width = $j(document).width();
        $j("table.header tr td").append('<img id="wij_modal_close_btn_abs" src="/images/x_small.gif">'), $j("#wij_modal_close_btn_abs").each(function() {
            var img = $j(this), img_w = 15;
            img.css({top: 4,left: doc_width - img_w - 4,position: "absolute",cursor: "pointer"})
        }).click(function() {
            wnd.dlg_close()
        }), $j("h1").append('<img id="wij_modal_close_btn_fixed" src="/images/x_small.gif">'), $j("#wij_modal_close_btn_fixed").css({right: 4,top: 4,position: "fixed",cursor: "pointer"}).click(function() {
            wnd.dlg_close()
        })
    }
}), fweb_define("legacy.popup", null, null, function() {
    window.new_win = function(url, id, width, height) {
        close_popup(), set_popup_RefID(window.open(url, id, "scrollbars,resizable,width=" + width + ",height=" + height))
    }, window.set_popup_RefID = function(id) {
        id && (new NewPopup, NewPopup.ref_id = id, NewPopup.ref_id.focus())
    }, window.close_popup = function() {
        NewPopup.ref_id && !NewPopup.ref_id.closed && (NewPopup.ref_id.close(), NewPopup.ref_id = 0)
    }, window.NewPopup = function() {
    }
}), fweb_define("legacy.jsonrpc", ["jquery"], "JSONRPC", function($) {
    function jsonrpc_on_success(response, textStatus) {
        alert("jsonrpc success: \n\n" + JSON.stringify(response))
    }
    function jsonrpc_on_error(response, textStatus) {
        alert("jsonrpc error: \n\n" + JSON.stringify(response))
    }
    function jsonrpc_send(request, args) {
        request && ("undefined" == typeof request.id && (request.id = id++), args || (args = {}), args.on_error || (args.on_error = jsonrpc_on_error), args.on_success || (args.on_success = jsonrpc_on_success), $.ajax({url: url,cache: !1,dataType: "json",type: "POST",data: {json: JSON.stringify(request)},async: "boolean" == typeof args.async ? args.async : !0,success: function(response, textStatus) {
                response && (response.error ? args.on_error(response.error, textStatus) : response.result ? args.on_success(response.result, textStatus) : response instanceof Array && args.on_success(response, textStatus))
            },error: function(XMLHttpRequest, textStatus, errorThrown) {
                var response = {id: null,error: {code: -32e3,message: "Connection error",data: {XMLHttpRequest: XMLHttpRequest,textStatus: textStatus,errorThrown: errorThrown}}};
                args.on_error(response.error, textStatus)
            }}))
    }
    function jsonrpc_batch_send(params, args) {
        if (params) {
            args || (args = {});
            var request = $.extend(!0, {}, JSONRPC.Batch.Request);
            request.params = $.extend(!0, {}, params), JSONRPC.send(request, args)
        }
    }
    var id = 0, url = "/json", Request = {method: "batch",params: {batch: []}};
    return {send: jsonrpc_send,Batch: {Request: Request,send: jsonrpc_batch_send}}
}), fweb_define("legacy.jsonrpc_cmdb", ["jquery"], "JSONRPC.CMDB", function($) {
    "use strict";
    function jsonrpc_cmdb_select(params, args) {
        send("Select", params, args)
    }
    function jsonrpc_cmdb_get(params, args) {
        send("Get", params, args)
    }
    function jsonrpc_cmdb_append(params, args) {
        send("Append", params, args)
    }
    function jsonrpc_cmdb_insert(params, args) {
        send("Insert", params, args)
    }
    function jsonrpc_cmdb_move(params, args) {
        send("Move", params, args)
    }
    function jsonrpc_cmdb_edit(params, args) {
        send("Edit", params, args)
    }
    function jsonrpc_cmdb_delete(params, args) {
        send("Delete", params, args)
    }
    function jsonrpc_cmdb_clear(params, args) {
        send("Clear", params, args)
    }
    function send(method, params, args) {
        var default_args = {on_error: jsonrpc_cmdb_on_error,on_success: jsonrpc_cmdb_on_success};
        if (params) {
            if (args = $.extend({}, default_args, args), $.isArray(params)) {
                for (var batch_params = {batch: []}, i = 0; i < params.length; i++)
                    batch_params.batch.push(JSONRPC.CMDB.create(method, params[i]));
                return void JSONRPC.Batch.send(batch_params, args)
            }
            params = $.extend(!0, {}, params);
            var request = $.extend(!0, {}, Request);
            request.params = $.extend(!0, {}, Method[method], params), JSONRPC.send(request, args)
        }
    }
    function create(method, params, args) {
        var default_args = {};
        if (params) {
            params = $.extend(!0, {}, params), args = $.extend({}, default_args, args);
            var request = $.extend(!0, {}, JSONRPC.CMDB.Request);
            return request.params = $.extend(!0, {}, JSONRPC.CMDB.Method[method], params), request.id = request.params.path + "." + request.params.name, request
        }
    }
    function jsonrpc_cmdb_on_error(error) {
        alert("cmdb error: \n\n" + JSON.stringify(error))
    }
    function jsonrpc_cmdb_on_success(result) {
        alert("cmdb success: \n\n" + JSON.stringify(result))
    }
    var Request = {method: "cmdb",params: {}}, Method = {Select: {method: "select",filters: [{key: "name",type: "string"}],params: {method: "get"}},Get: {method: "get"},Append: {method: "append",overwrite: !0},Insert: {method: "insert",type: "index",location: 0},Move: {method: "move",type: "index",from: 1,to: 2},Edit: {method: "edit"},Delete: {method: "delete"},Clear: {method: "clear"}};
    return {Request: Request,Method: Method,send: send,create: create,select: jsonrpc_cmdb_select,get: jsonrpc_cmdb_get,append: jsonrpc_cmdb_append,insert: jsonrpc_cmdb_insert,move: jsonrpc_cmdb_move,edit: jsonrpc_cmdb_edit,"delete": jsonrpc_cmdb_delete,clear: jsonrpc_cmdb_clear}
}), fweb_define("jquery.twistiebox", ["jquery"], null, function($) {
    "use strict";
    $.fn.twistiebox = function(params) {
        var settings = {expandHTML: '<a href="#" style="font-family:monospace">[+]</a>',collapseHTML: '<a href="#" style="font-family:monospace">[-]</a>',headingClass: "twistiebox-header",bodyClass: "twistiebox-body"};
        return settings = $.extend(settings, params), $.each(this, function() {
            function setupTwistBox(obj) {
                function handleExpand() {
                    return setCollapseState(!0), !1
                }
                function handleCollapse() {
                    return setCollapseState(!1), !1
                }
                function setCollapseState(state) {
                    $(ctrlExpand).toggle(!state), $(ctrlCollapse).toggle(state), $(twistieBody).toggle(state)
                }
                var twistieHead, twistieBody, ctrlExpand = $(settings.expandHTML).click(handleExpand), ctrlCollapse = $(settings.collapseHTML).click(handleCollapse);
                twistieBody = $("." + settings.bodyClass, obj), $(twistieBody).length < 1 && (twistieBody = $('<div class="' + settings.bodyClass + '"></div>').html($(obj).html()), $(obj).html(twistieBody)), twistieHead = $("." + settings.headingClass, obj), $(twistieHead).length < 1 && (twistieHead = $('<div class="' + settings.headingClass + '"></div>').prependTo($(obj))), $(ctrlExpand).prependTo(twistieHead), $(ctrlCollapse).prependTo(twistieHead), setCollapseState($(obj).hasClass("open"))
            }
            setupTwistBox(this)
        }), this
    }
}), fweb_define("jquery.ui_dependencies", ["jquery"], "jQuery.fn.ui_dependencies", function($) {
    "use strict";
    function jqHook(ATTR_CHANGE_EVENT, TRIGGER_CLASS, DATA_KEY, DATA_BIT, ATTR_BIT, CLASS_BIT) {
        function hasBit(bit) {
            return function(dep) {
                return dep.depType & bit
            }
        }
        var T = "UI_TRIGGERING_DATA_ATTR", $_fn = ["data", "attr", "addClass", "removeClass"].reduce(function(fns, name) {
            return fns[name] = $.fn[name], $.fn[name] = function(dataOrClassName) {
                var trigger, deps, result = $_fn[name].apply(this, arguments), skip = "data" === name && [T, DATA_KEY].indexOf(dataOrClassName) > -1 || "addClass" === name && dataOrClassName === TRIGGER_CLASS || $_fn.data.call(this, T);
                return skip ? result : ($_fn.data.call(this, T, !0), deps = $_fn.data.call(this, DATA_KEY), deps && (trigger = "data" === name ? 2 === arguments.length && deps.some(hasBit(DATA_BIT)) : "attr" === name ? deps.some(hasBit(ATTR_BIT)) : deps.some(hasBit(CLASS_BIT)), trigger = trigger && this.hasClass(TRIGGER_CLASS), trigger && this.trigger(ATTR_CHANGE_EVENT)), this.removeData(T), result)
            }, fns
        }, {})
    }
    function nice_toggle(show, duration) {
        return duration ? show ? this.slideDown(duration) : this.slideUp(duration) : this.css("display", show ? "" : "none")
    }
    function nice_show() {
        nice_toggle.call(this, !0)
    }
    function makeValues(values) {
        return /^\/.*\/$/.test(values) ? new RegExp(values.substr(1, values.length - 2)) : values.split(",")
    }
    function is_match(match_def, has_class) {
        function get_attr_elem($input) {
            return "select" === String($input.get(0).tagName).toLowerCase() ? $input.find("option:selected") : $input
        }
        var match = match_def.$inputs.toArray().some(function(input, i) {
            var result, $input = $(input);
            if (null == match_def.values)
                result = input.checked;
            else if (has_class)
                result = match_def.values.some(function(value) {
                    return get_attr_elem($input).hasClass(value)
                });
            else {
                var value;
                value = match_def.dataAttr ? String(get_attr_elem($input).data(match_def.dataAttr)) : match_def.attr ? String(get_attr_elem($input).attr(match_def.attr)) : input.value, result = match_def.values instanceof RegExp ? match_def.values.test(value) : $.inArray(value, match_def.values) > -1
            }
            return result && match_def.visibility[i].test($input)
        });
        return match_def.negate ? !match : match
    }
    function and_radio_options($radio) {
        return $radio.map(function(i, radio) {
            var s = '[type=radio][name="' + radio.name + '"]';
            return "radio" === radio.type ? $(s).get() : radio
        })
    }
    function fixOptions($options, match) {
        function wrapped() {
            return "span" === String(this.parentNode.tagName).toLowerCase()
        }
        match ? $options.removeAttr("disabled").filter(wrapped).unwrap() : $options.attr("disabled", "disabled").not(wrapped).wrap("<span>").parent().hide(), $options = $options.filter(":selected:disabled"), !match && $options.length && $.unique($options.parent()).each(function() {
            var $select = $(this);
            this.selectedIndex = $select.find("option").not(":disabled").first().index(), $select.change()
        })
    }
    function Dependency(depType, $elem, selector, duration, $context) {
        function selector_tok(tokenExpr, otherExpr) {
            tokenExpr = tokenExpr || firstToken, otherExpr = otherExpr || otherTokens;
            var result = selector.replace(otherExpr, "");
            return selector = selector.replace(tokenExpr, ""), result
        }
        function inputVisible($input) {
            if (this.ignore)
                return !0;
            var hiddenVisible = "hidden" === $input[0].type && $input.parent().is(":visible");
            return hiddenVisible || $input.is(":visible") || $input.parent(".multiList-container").is(":visible")
        }
        function getInitialVisibility(input) {
            var $input = $(input), ignore = $input.data(DEP_IGNORE_VISIBILITY_KEY);
            return void 0 === ignore && (ignore = !!$input.closest(DEP_IGNORE_VISIBILITY_SELECTOR).length, $input.data(DEP_IGNORE_VISIBILITY_KEY, ignore)), {ignore: ignore,test: inputVisible}
        }
        if (this.ns = function(eventNames) {
            return eventNames.split(" ").map(function(en) {
                return en + ".dependencies-dep" + Dependency.nsid++
            }).join(" ")
        }, this.$elem = $elem, this.$scope = this.get_scope($context), this.depType = depType, this.duration = duration, this.selector = selector, this.depType === DEP_NICH)
            this.addTo($elem.not("[name]"));
        else {
            this.matches = [];
            var match, ex_match, firstToken = /^[^\s]*\s/, otherTokens = /\s.*$/, attrNameToken = /^[^=]*=/, attrNameOther = /=.*$/;
            CLASS_BIT & this.depType && (this.toggleClass = selector_tok());
            for (var and_split_expr = /((?:\s*\/[^\/\\]*(?:\\.[^\/\\]*)?\/)?[^\$$]+)\$?/g, selectors_to_split = selector; ex_match = and_split_expr.exec(selectors_to_split); )
                match = {}, match.selector = ex_match[1].trim(), selector = match.selector, this.matches.push(match), match.negate = "!" === selector.replace(otherTokens, ""), match.negate && (selector = selector.replace(firstToken, "")), ATTR_BIT & this.depType && (match.attr = selector_tok(attrNameToken, attrNameOther)), DATA_BIT & this.depType && (match.dataAttr = selector_tok(attrNameToken, attrNameOther)), VALUE_BIT & this.depType && (match.values = makeValues(selector_tok())), NAME_BIT & this.depType && (this.name = selector_tok()), match.$inputs = this.$scope.find(selector), match.visibility = match.$inputs.toArray().map(getInitialVisibility);
            INSERT_BIT & this.depType && this.setup_insert(), this.register_events()
        }
    }
    function ui_dependencies() {
        var $context = this === $ ? $(document) : this, $depends = $context.find(DEPEND_SELECTOR).add($context.filter(DEPEND_SELECTOR));
        return $depends.each(function(i, elem) {
            var selector, duration, $elem = $(elem);
            duration = $elem.data("duration"), $.each(depData, function(key, depType) {
                selector = $elem.data(key), selector && new Dependency(depType, $elem, selector, duration, $context)
            })
        }), this
    }
    $.extend({ui_dependencies: ui_dependencies}), $.fn.ui_dependencies = ui_dependencies, $.fn.niceToggle = nice_toggle, $.fn.niceShow = nice_show;
    var VALUE_BIT = 1, CLASS_BIT = 2, CHECK_BIT = 4, SHOW_BIT = 8, NAME_BIT = 16, CHANGED_BIT = 32, DATA_BIT = 64, ATTR_BIT = 128, ENABLE_BIT = 256, HAS_CLASS_BIT = 512, TO_CHECK_BIT = 1024, INSERT_BIT = 2048, DEP_SIC = SHOW_BIT | CHECK_BIT, DEP_SIV = SHOW_BIT | VALUE_BIT, DEP_SID = SHOW_BIT | DATA_BIT | VALUE_BIT, DEP_SIA = SHOW_BIT | ATTR_BIT | VALUE_BIT, DEP_SICL = SHOW_BIT | HAS_CLASS_BIT | VALUE_BIT, DEP_CIC = CLASS_BIT | CHECK_BIT, DEP_CIV = CLASS_BIT | VALUE_BIT, DEP_CID = CLASS_BIT | DATA_BIT | VALUE_BIT, DEP_CIA = CLASS_BIT | ATTR_BIT | VALUE_BIT, DEP_CICL = CLASS_BIT | HAS_CLASS_BIT | VALUE_BIT, DEP_EIC = ENABLE_BIT | CHECK_BIT, DEP_EIV = ENABLE_BIT | VALUE_BIT, DEP_EID = ENABLE_BIT | DATA_BIT | VALUE_BIT, DEP_EIA = ENABLE_BIT | ATTR_BIT | VALUE_BIT, DEP_EICL = ENABLE_BIT | HAS_CLASS_BIT | VALUE_BIT, DEP_NIC = NAME_BIT | CHECK_BIT, DEP_TCIC = TO_CHECK_BIT | CHECK_BIT, DEP_IIC = INSERT_BIT | CHECK_BIT, DEP_IIV = INSERT_BIT | VALUE_BIT, DEP_IID = INSERT_BIT | DATA_BIT | VALUE_BIT, DEP_IIA = INSERT_BIT | ATTR_BIT | VALUE_BIT, DEP_IICL = INSERT_BIT | HAS_CLASS_BIT | VALUE_BIT, DEP_CICH = CLASS_BIT | CHANGED_BIT, DEP_NICH = NAME_BIT | CHANGED_BIT, ATTR_CHANGE_EVENT = "ui_dependencies_attr_change", CHANGE_EVENT = "dependency_change", DATA_KEY = "ui_dependencies", DEP_IGNORE_VISIBILITY_KEY = "ui_dependencies_ignore_visibility", DEP_IGNORE_VISIBILITY_SELECTOR = ".dependency_ignore_visibility", CHANGE_BIND_EVENT = "change validated " + ATTR_CHANGE_EVENT, TRIGGER_CLASS = "dependency_trigger", TRIGGER_SELECTOR = "." + TRIGGER_CLASS, DEPEND_SELECTOR = ".depends", depData = {"show-if-value": DEP_SIV,"show-if-checked": DEP_SIC,"show-if-data": DEP_SID,"show-if-attr": DEP_SIA,"show-if-class": DEP_SICL,"class-if-value": DEP_CIV,"class-if-checked": DEP_CIC,"class-if-data": DEP_CID,"class-if-class": DEP_CICL,"name-if-changed": DEP_NICH,"class-if-changed": DEP_CICH,"class-if-attr": DEP_CIA,"enable-if-checked": DEP_EIC,"enable-if-value": DEP_EIV,"enable-if-data": DEP_EID,"enable-if-attr": DEP_EIA,"enable-if-class": DEP_EICL,"name-if-checked": DEP_NIC,"check-if-checked": DEP_TCIC,"insert-if-value": DEP_IIV,"insert-if-checked": DEP_IIC,"insert-if-data": DEP_IID,"insert-if-attr": DEP_IIA,"insert-if-class": DEP_IICL}, depDataInverse = Object.keys(depData).reduce(function(result, key) {
        return result[depData[key]] = key, result
    }, {}), INSERT_CHANGE_EVENT_DATA = {};
    jqHook(ATTR_CHANGE_EVENT, TRIGGER_CLASS, DATA_KEY, DATA_BIT, ATTR_BIT, CLASS_BIT), Dependency._triggering = 0, Dependency._insert = [], Dependency.nsid = 0, Dependency.on_change = function(eo, data) {
        var input = this, changed = 0, deps = $(this).data(DATA_KEY);
        if (deps || $.error("No dependencies found!"), changed = deps.reduce(function(list, dep) {
            return dep.changed(input, eo, data) && list.push(dep), list
        }, []), 0 === Dependency._triggering) {
            var i, len = changed.length;
            for (i = 0; len > i; ++i)
                changed[i].$elem.trigger(CHANGE_EVENT, [changed[i], eo])
        }
    }, Dependency.prototype.register_events = function(trigger_change) {
        trigger_change = trigger_change || !1, this.matches.forEach(function(m) {
            var $inputs = m.$inputs;
            $inputs.length && ($inputs.each(function(i, input) {
                this.changed(input)
            }.bind(this)), CHECK_BIT & this.depType && ($inputs = and_radio_options($inputs)), this.addTo($inputs), trigger_change = !0)
        }.bind(this)), trigger_change && this.$elem.trigger(CHANGE_EVENT, [this, null])
    }, Dependency.prototype.get_scope = function($context) {
        var $scopes = this.$elem.parents(".dependency_scope"), ignore = +(this.$elem.data("dependency-ignore-scope") || 0), $result = $context;
        return $scopes.length && $scopes.length > ignore && ($result = $scopes.eq(ignore)), $result
    }, Dependency.prototype.changed = function(input, eo, data) {
        var $input, match, $options, result = 0;
        if (this.depType & CHANGED_BIT)
            eo && eo.currentTarget === input && !Dependency._triggering && data !== INSERT_CHANGE_EVENT_DATA && ($input = $(input), this.depType & NAME_BIT && (input.name = $input.data("name-if-changed"), $input.removeAttr("name-if-changed")), this.depType & CLASS_BIT && ($input.addClass($input.data("class-if-changed")), $input.removeAttr("class-if-changed")), this.removeFrom($input));
        else {
            if (match = this.matches.filter(function(m) {
                return m.$inputs.length
            }).every(function(m) {
                return is_match(m, HAS_CLASS_BIT & this.depType)
            }.bind(this)), match !== this._lastMatch && (CLASS_BIT & this.depType ? (this.$elem.toggleClass(this.toggleClass, match), ++result) : SHOW_BIT & this.depType ? (this.$elem.niceToggle(match, this.duration), ++result, $options = this.$elem.filter("option"), $options.length && fixOptions($options, match)) : ENABLE_BIT & this.depType ? (this.$elem.enable(match), ++result) : NAME_BIT & this.depType ? (this.$elem.prop("name", match ? this.name : null), ++result) : TO_CHECK_BIT & this.depType ? this.$elem.is(":checked") || (this.$elem.check(match), ++result) : INSERT_BIT & this.depType && this.insert(match)), eo && !this._triggering && match !== this._lastMatch) {
                ++Dependency._triggering, this._triggering = !0;
                try {
                    this.$elem.find(TRIGGER_SELECTOR).change()
                } catch (ie8) {
                    throw ie8
                }finally {
                    this._triggering = !1, --Dependency._triggering
                }
            }
            this._lastMatch = match
        }
        return Dependency._triggering ? 0 : result
    }, Dependency.prototype.setup_insert = function() {
        setTimeout(function() {
            var depKey = depDataInverse[this.depType];
            this.$insertionPoint = $("<!-- dependency insert point for " + depKey + '="' + this.selector + '"-->'), this.$elem.after(this.$insertionPoint), this.$elem.detach(), this.$nodes = this.$elem.children(), void 0 === this._present ? (this.insert(!0, !0), this.$elem.trigger(CHANGE_EVENT, [this, null])) : this.insert(this._present, !0)
        }.bind(this))
    }, Dependency.prototype.insert = function(match, force) {
        var changed = this._present !== match;
        this._present = match, this.$nodes && (changed || force) && (match ? (this.$insertionPoint.after(this.$nodes), this.register_events(!0), this.$nodes.find("input, select").trigger("change", INSERT_CHANGE_EVENT_DATA)) : this.$nodes.detach())
    }, Dependency.prototype.addTo = function($inputs) {
        var dep = this;
        $inputs.each(function(i, input) {
            var $input = $(input);
            $input.off(dep.ns(CHANGE_BIND_EVENT)).on(dep.ns(CHANGE_BIND_EVENT), Dependency.on_change);
            var deps = $input.data(DATA_KEY) || [];
            deps.push(dep), $input.addClass(TRIGGER_CLASS).data(DATA_KEY, deps)
        })
    }, Dependency.prototype.removeFrom = function($inputs) {
        var event_names, deps = $inputs.data(DATA_KEY) || [];
        deps = deps.filter(function(dep) {
            return dep !== this
        }), event_names = deps.map(function(dep) {
            return dep.ns(CHANGE_BIND_EVENT)
        }).join(" "), $inputs.data(DATA_KEY, deps.length ? deps : null), 0 === deps.length && $inputs.off(event_names).removeClass(TRIGGER_CLASS)
    }, ui_dependencies.ATTR_CHANGE_EVENT = ATTR_CHANGE_EVENT
}), fweb_define("jquery.maskedinput", ["jquery"], null, function() {
    if (function($) {
        function getPasteEvent() {
            var el = document.createElement("input"), name = "onpaste";
            return el.setAttribute(name, ""), "function" == typeof el[name] ? "paste" : "input"
        }
        var caretTimeoutId, pasteEventName = getPasteEvent() + ".mask", ua = navigator.userAgent, iPhone = /iphone/i.test(ua), android = /android/i.test(ua);
        $.mask = {definitions: {9: "[0-9]",a: "[A-Za-z]","*": "[A-Za-z0-9]"},dataName: "rawMaskFn",placeholder: "_"}, $.fn.extend({caret: function(begin, end) {
                var range;
                if (0 !== this.length && !this.is(":hidden"))
                    return "number" == typeof begin ? (end = "number" == typeof end ? end : begin, this.each(function() {
                        this.setSelectionRange ? this.setSelectionRange(begin, end) : this.createTextRange && (range = this.createTextRange(), range.collapse(!0), range.moveEnd("character", end), range.moveStart("character", begin), range.select())
                    })) : (this[0].setSelectionRange ? (begin = this[0].selectionStart, end = this[0].selectionEnd) : document.selection && document.selection.createRange && (range = document.selection.createRange(), begin = 0 - range.duplicate().moveStart("character", -1e5), end = begin + range.text.length), {begin: begin,end: end})
            },unmask: function() {
                return this.trigger("unmask")
            },mask: function(mask, settings) {
                var input, defs, tests, partialPosition, firstNonMaskPos, len;
                return !mask && this.length > 0 ? (input = $(this[0]), input.data($.mask.dataName)()) : (settings = $.extend({placeholder: $.mask.placeholder,completed: null}, settings), defs = $.mask.definitions, tests = [], partialPosition = len = mask.length, firstNonMaskPos = null, $.each(mask.split(""), function(i, c) {
                    "?" == c ? (len--, partialPosition = i) : defs[c] ? (tests.push(new RegExp(defs[c])), null === firstNonMaskPos && (firstNonMaskPos = tests.length - 1)) : tests.push(null)
                }), this.trigger("unmask").each(function() {
                    function seekNext(pos) {
                        for (; ++pos < len && !tests[pos]; )
                            ;
                        return pos
                    }
                    function seekPrev(pos) {
                        for (; --pos >= 0 && !tests[pos]; )
                            ;
                        return pos
                    }
                    function shiftL(begin, end) {
                        var i, j;
                        if (!(0 > begin)) {
                            for (i = begin, j = seekNext(end); len > i; i++)
                                if (tests[i]) {
                                    if (!(len > j && tests[i].test(buffer[j])))
                                        break;
                                    buffer[i] = buffer[j], buffer[j] = settings.placeholder, j = seekNext(j)
                                }
                            writeBuffer(), input.caret(Math.max(firstNonMaskPos, begin))
                        }
                    }
                    function shiftR(pos) {
                        var i, c, j, t;
                        for (i = pos, c = settings.placeholder; len > i; i++)
                            if (tests[i]) {
                                if (j = seekNext(i), t = buffer[i], buffer[i] = c, !(len > j && tests[j].test(t)))
                                    break;
                                c = t
                            }
                    }
                    function keydownEvent(e) {
                        var pos, begin, end, k = e.which;
                        8 === k || 46 === k || iPhone && 127 === k ? (pos = input.caret(), begin = pos.begin, end = pos.end, end - begin === 0 && (begin = 46 !== k ? seekPrev(begin) : end = seekNext(begin - 1), end = 46 === k ? seekNext(end) : end), clearBuffer(begin, end), shiftL(begin, end - 1), e.preventDefault()) : 27 == k && (input.val(focusText), input.caret(0, checkVal()), e.preventDefault())
                    }
                    function keypressEvent(e) {
                        var p, c, next, k = e.which, pos = input.caret();
                        e.ctrlKey || e.altKey || e.metaKey || 32 > k || k && (pos.end - pos.begin !== 0 && (clearBuffer(pos.begin, pos.end), shiftL(pos.begin, pos.end - 1)), p = seekNext(pos.begin - 1), len > p && (c = String.fromCharCode(k), tests[p].test(c) && (shiftR(p), buffer[p] = c, writeBuffer(), next = seekNext(p), android ? setTimeout($.proxy($.fn.caret, input, next), 0) : input.caret(next), settings.completed && next >= len && settings.completed.call(input))), e.preventDefault())
                    }
                    function clearBuffer(start, end) {
                        var i;
                        for (i = start; end > i && len > i; i++)
                            tests[i] && (buffer[i] = settings.placeholder)
                    }
                    function writeBuffer() {
                        input.val(buffer.join(""))
                    }
                    function checkVal(allow) {
                        var i, c, test = input.val(), lastMatch = -1;
                        for (i = 0, pos = 0; len > i; i++)
                            if (tests[i]) {
                                for (buffer[i] = settings.placeholder; pos++ < test.length; )
                                    if (c = test.charAt(pos - 1), tests[i].test(c)) {
                                        buffer[i] = c, lastMatch = i;
                                        break
                                    }
                                if (pos > test.length)
                                    break
                            } else
                                buffer[i] === test.charAt(pos) && i !== partialPosition && (pos++, lastMatch = i);
                        return allow ? writeBuffer() : partialPosition > lastMatch + 1 ? (input.val(""), clearBuffer(0, len)) : (writeBuffer(), input.val(input.val().substring(0, lastMatch + 1))), partialPosition ? i : firstNonMaskPos
                    }
                    var input = $(this), buffer = $.map(mask.split(""), function(c, i) {
                        return "?" != c ? defs[c] ? settings.placeholder : c : void 0
                    }), focusText = input.val();
                    input.data($.mask.dataName, function() {
                        return $.map(buffer, function(c, i) {
                            return tests[i] && c != settings.placeholder ? c : null
                        }).join("")
                    }), input.attr("readonly") || input.one("unmask", function() {
                        input.unbind(".mask").removeData($.mask.dataName)
                    }).bind("focus.mask", function() {
                        clearTimeout(caretTimeoutId);
                        var pos;
                        focusText = input.val(), pos = checkVal(), caretTimeoutId = setTimeout(function() {
                            writeBuffer(), pos == mask.length ? input.caret(0, pos) : input.caret(pos)
                        }, 10)
                    }).bind("blur.mask", function() {
                        checkVal(), input.val() != focusText && input.change()
                    }).bind("keydown.mask", keydownEvent).bind("keypress.mask", keypressEvent).bind(pasteEventName, function() {
                        setTimeout(function() {
                            var pos = checkVal(!0);
                            input.caret(pos), settings.completed && pos == input.val().length && settings.completed.call(input)
                        }, 0)
                    }), checkVal()
                }))
            }})
    }(jQuery), null == window.jQuery.fn.mask)
        throw new Error('Grunt Requireize: module does not define "window.jQuery.fn.mask"');
    return window.jQuery.fn.mask
}), fweb_define("fgd_common", ["jquery", "fweb", "legacy.util"], "fgd_common", function($, fweb) {
    "use strict";
    function gen_botnet_pkg_stat_message(license_status, stats_response) {
        var botnet_pkg = this, total_entries = stats_response[0].results.total_entries, has_license = "LICENSED" === license_status.str, info_html = $.getInfo(botnet_pkg.lang.info, [total_entries, '&nbsp;<a href="#">' + $.getInfo("botnet package") + "</a>"]), warning = $.getInfo(botnet_pkg.lang.warning);
        return format(PKG_STAT_INNER_HTML, {info_html: "<p>" + info_html + "</p>",warning_html: has_license ? "" : "<p>" + warning + "</p>",icon_class: has_license ? "fa-info-circle" : "fa-warning"})
    }
    function init_license_status_map(response) {
        var status_keys = Object.keys(response.status);
        license_status_map = {}, status_keys.forEach(function(key) {
            license_status_map[response.status[key]] = key
        })
    }
    var LICENSE_INFO_URL = "/p/system/widget/license_info/", PKG_STAT_INNER_HTML = '<f-icon class="{{ icon_class }}"></f-icon><div class="message-content">{{ info_html }}{{ warning_html }}</div>', license_promise = null, license_status_map = null, format = fweb.util.dom.renderTemplate, fgd_common = {PACKAGES: {BDDB: {license: "mobile_malware",lang: {info: "{COUNT} domains in {PACKAGE}.",warning: "Botnet package update unavailable, FortiCare subscription not found."},url: {stat: "/api/v2/monitor/system/botnet-domains/stat",details: "/p/system/botnet/?by_domain=true"},format_fn: gen_botnet_pkg_stat_message},IRDB: {license: "mobile_malware",lang: {info: "{COUNT} IP Addresses in {PACKAGE}.",warning: "Botnet package update unavailable, FortiCare subscription not found."},url: {stat: "/api/v2/monitor/system/botnet/stat",details: "/p/system/botnet/?by_ip=true"},format_fn: gen_botnet_pkg_stat_message},UWDB: {license: "web_filtering"},FFDB: {license: "web_filtering",url: {details: "/p/firewall/internet_service/"
                }}},default_selector: "#qlistqlist a, #qlist a",getidtable: {fromclass: function(jthis) {
                for (var classes = jthis.attr("class").split(" "), i = 0; i < classes.length; ++i) {
                    var _class = classes[i], match = _class.match(/id_(\d+)/);
                    if (match)
                        return match[1]
                }
                return -1
            },fromlink: function(jthis) {
                return jthis.attr("href").replace("http://www.fortinet.com/ids/VID", "")
            }},_query_fortiflow_database: function(unknown_apps) {
            var hash = function() {
                var app, _i, _len, _results;
                for (_results = [], _i = 0, _len = unknown_apps.length; _len > _i; _i++)
                    app = unknown_apps[_i], _results.push(this._gen_app_hash_key(app));
                return _results
            }.call(this).join("##"), cached_query = this._request_cache[hash];
            return null == cached_query && (cached_query = $.getJSON("/api/monitor", {path: "utm",name: "app-lookup",json: JSON.stringify({hosts: unknown_apps})}), this._request_cache[hash] = cached_query), cached_query
        },_request_cache: {},_gen_app_hash_key: function(app) {
            return [app.address, app.dst_port, app.protocol].join("#")
        },gen_app_html: function(app_id, app_name, host_info, extra_class, title) {
            return extra_class || (extra_class = ""), title || (title = ""), -1 === app_id ? '<f-icon class="fa-cloud"></f-icon><span>' + escapeHTML(app_name) + "</span>" : '<span class="fgd-app tooltip id_' + app_id + " " + extra_class + '" data-address="' + host_info.address + '" data-dport="' + host_info.dst_port + '" data-protocol="' + host_info.protocol + '" ><span class="app_icon app' + app_id + '" ></span><label class="app_label" title="' + title + '">' + escapeHTML(app_name) + "</label></span>"
        },gen_wf_html: function(cat_id, cat_name) {
            return '<span class="tooltip wf_category id_' + cat_id + '" ><span class="wf_icon wf' + cat_id + '" ></span><label class="wf_label" title="' + cat_name + '">' + cat_name + "</label></span>"
        },gen_wf_html_no_icon: function(cat_id, cat_name) {
            return '<span class="tooltip wf_category id_' + cat_id + '"><label class="wf_label" title="' + cat_name + '">' + cat_name + "</label></span>"
        },gen_app_cat_html: function(cat_name) {
            return '<span class="tooltip ac_category dont-use-id" data-cat="' + cat_name + '"><label class="ac_label" title="' + cat_name + '">' + cat_name + "</label></span>"
        },_update_unknown_apps: function(data, app_cache) {
            for (var r = data.results, i = 0; i < r.length; i++) {
                var c_app, host = r[i];
                if (host && host.apps) {
                    var key = fgd_common._gen_app_hash_key(host);
                    if (c_app = app_cache[key]) {
                        for (var html = "", j = 0; j < host.apps.length; j++) {
                            var app = host.apps[j];
                            j > 0 && (html += ", "), html += fgd_common.gen_app_html(-1, app.app_name, host, "app_queried")
                        }
                        c_app.replaceWith(html).data("app-fortiflow-done", !0).data("app-tooltip-done", null)
                    }
                }
            }
        },_setup_tooltips: function(selector, idmethod, query_fortiflow, adjust) {
            "undefined" == typeof selector && (selector = fgd_common.default_selector);
            var elements = selector;
            "function" == typeof selector && (elements = selector()), "undefined" == typeof adjust && (adjust = {});
            var unknown_apps = [], app_cache = {}, othis = this;
            $(elements).each(function() {
                var jthis = $(this);
                if (jthis.data("app-tooltip-done"))
                    return !0;
                jthis.data("app-tooltip-done", !0), $(this).click(function(e) {
                    e.preventDefault()
                });
                var text = jthis.text(), id = -1;
                if (!(text.length < 1)) {
                    if (!jthis.hasClass("dont-use-id")) {
                        if (othis.getidtable[idmethod] || (idmethod = "fromlink"), (id = othis.getidtable[idmethod](jthis)) < 0)
                            return;
                        if (0 === +id) {
                            if (jthis.data("app-fortiflow-done"))
                                return;
                            var address = jthis.data("address"), dport = jthis.data("dport"), protocol = jthis.data("protocol");
                            if (address && dport && protocol) {
                                var app = {address: address,dst_port: dport,protocol: protocol}, key = fgd_common._gen_app_hash_key(app);
                                key in app_cache ? app_cache[key] = app_cache[key].add(jthis) : (unknown_apps.push(app), app_cache[key] = jthis)
                            }
                            return
                        }
                        0 === $("a", jthis).length && jthis.wrapInner('<a href="javascript: void 0" onclick="return false;"/>')
                    }
                    var src = document.location.protocol + "//www.fortiguard.com/", _width = 300, _height = 200;
                    if (jthis.hasClass("wf_category")) {
                        if (id >= 107)
                            return;
                        src += "wf/" + id + ".html", _width = 400, _height = 225
                    } else
                        jthis.hasClass("ac_category") ? (src += "ac/" + jthis.data("cat").replace(/\//gi, ".") + ".html", _width = 390, _height = 185) : jthis.hasClass("waf_sig") ? (src = "/p/utm/waf/signature_details/" + jthis.data("sig-id") + "/", text = jthis.data("sig-title"), _width = 390, _height = 185) : src += "fos/" + id;
                    $("a", jthis).prop("href", src).qtip({content: {text: '<iframe width="' + (_width + 30) + '" height="' + _height + '" frameBorder="0" src="' + src + '"/>',title: {text: '<div style="width: ' + _width + 'px; overflow: hidden; text-overflow: ellipsis;">' + text + "</div>",button: !0}},hide: {event: "unfocus"},show: {event: "click",solo: !0},position: {my: "top center",at: "bottom left",adjust: adjust,viewport: $(window)}})
                }
            }), unknown_apps.length && query_fortiflow && fgd_common._query_fortiflow_database(unknown_apps).done(function(data) {
                fgd_common._update_unknown_apps(data, app_cache), fgd_common._setup_tooltips(selector, idmethod, query_fortiflow, adjust)
            })
        },_setup_tooltips_iframe: function(selector, idmethod, query_fortiflow) {
            if (window.frameElement) {
                "undefined" == typeof selector && (selector = fgd_common.default_selector);
                var $iframe = window.parent.$j(window.frameElement);
                if (selector.nodeType && 1 === selector.nodeType)
                    window.parent.fgd_common._setup_tooltips(selector, idmethod);
                else {
                    var adjust = {x: $iframe.offset().left,y: $iframe.offset().top};
                    window.parent.fgd_common._setup_tooltips(function() {
                        var $contents = $iframe;
                        try {
                            $contents = $iframe.$contents()
                        } catch (ex) {
                        }
                        return $contents.find(selector)
                    }, idmethod, query_fortiflow, adjust)
                }
            }
        },setup_tooltips: function(selector, idmethod, query_fortiflow, forceIframe) {
            return window.parent !== top && window.parent !== window || forceIframe ? fgd_common._setup_tooltips_iframe(selector, idmethod, query_fortiflow) : fgd_common._setup_tooltips(selector, idmethod, query_fortiflow)
        },get_license_status_for: function(pkg) {
            return license_promise || (license_promise = $.getJSON(LICENSE_INFO_URL)), license_promise.then(function(response) {
                license_status_map || init_license_status_map(response);
                var enum_status = response[pkg.license].status, str_status = license_status_map[enum_status];
                return {"enum": enum_status,str: str_status}
            })
        },gen_stat_inline_message_for: function(pkg) {
            return $.when(this.get_license_status_for(pkg), $.getJSON(pkg.url.stat)).then(function(license_status, stat) {
                return pkg.format_fn(license_status, stat)
            }.bind(this))
        }};
    return fgd_common
}), fweb_define("byod_common", ["jquery", "fweb", "fweb.util/dom", "fweb.util/avatars", "cmdb"], "byod_common", function($, fweb, dom, avatars, CMDB) {
    "use strict";
    var byod_common = {default_selector: ".byod_details",gen_icon: function(className, value, title, icon_sprite) {
            var html = '<f-icon class="' + (icon_sprite || "") + " " + className + '"';
            return title && (html += ' title="' + title + '"'), html += "></f-icon>", value && (html += "<span>" + value + "</span>"), html
        },gen_fw_icon: function(className, value, title) {
            return this.gen_icon(className, value, title)
        },gen_fw_device_icon: function(mac, device, alias, classNameOnly) {
            device || (device = "unknown");
            var className = this.gen_fw_device_class(device);
            if (alias = alias ? dom.escapeHTML(alias) : mac, alias && (className += " " + avatars.generateObjectClass("user", "device", alias)), classNameOnly)
                return className;
            var html = '<span class="byod_details" data-mac-address="' + mac + '">';
            return html += this.gen_fw_icon(className, alias, device), html + "</span>"
        },gen_fw_device_sort_fn: function(mac_key, alias_key) {
            var alias_fn = $.isFunction(alias_key) ? alias_key : function(x) {
                return x[alias_key]
            }, fn = function(a, b, default_sort_fn) {
                var a_alias = alias_fn(a), b_alias = alias_fn(b);
                return a_alias || b_alias ? default_sort_fn(a_alias, b_alias) : default_sort_fn(a[mac_key], b[mac_key])
            };
            return fn.kind = "comp_row", fn
        },device_class_map: {"android-phone": "fa-device-android","android-tablet": "fa-device-android","blackberry-phone": "fa-mobile","blackberry-playbook": "fa-tablet",forticam: "ftnt-device-fortinet",fortifone: "ftnt-device-fortinet","fortinet-device": "ftnt-device-fortinet","gaming-console": "fa-gamepad","ip-phone": "fa-phone","linux-pc": "fa-linux",mac: "fa-device-apple",ipad: "fa-device-apple",iphone: "fa-device-apple","media-streaming": "fa-music",printer: "fa-print","windows-pc": "fa-device-windows","windows-phone": "fa-device-windows","windows-tablet": "fa-device-windows"},forticlient_state_map: {quarantined: {"class": "ftnt-forticlient-quarantined"},registered: {"class": "ftnt-forticlient-registered",lang_key: "Registered"},unregistered: {"class": "ftnt-forticlient-unregistered"},blocked: {"class": "ftnt-forticlient-blocked"},capture: {"class": "ftnt-forticlient-captive",lang_key: "Blocked/Captive Portal"},"registered-online-offnet": {"class": "ftnt-forticlient-registered-offnet",lang_key: "Registered - Online - Off-Net"},"registered-online-onnet": {"class": "ftnt-forticlient-registered-onnet",lang_key: "Registered - Online - On-Net"},"registered-online": {"class": "ftnt-forticlient-registered-onnet",lang_key: "Registered - Online"},"registered-offline": {"class": "ftnt-forticlient-registered-offline",lang_key: "Registered - Offline"}},device_state_map: {online: {"class": "fa-status-up",lang_key: "online"},offline: {"class": "fa-status-down",lang_key: "offline"}},gen_fw_device_class: function(device) {
            return this.device_class_map[device] || "ftnt-device"
        },_setup_device_tooltips: function(target, adjust, solo) {
            "undefined" == typeof target && (target = byod_common.default_selector), "undefined" == typeof adjust && (adjust = {});
            var $target = $(target);
            $target.each(function() {
                var jthis = $(this), mac_address = jthis.data("macAddress");
                if (mac_address && "undefined" !== mac_address) {
                    var src = "/p/user/device_details/" + mac_address + "/";
                    jthis.qtip({content: {text: '<iframe width="330" height="170" frameBorder="0" src="' + src + '"/>',title: {text: "Device Details",button: !0}},position: {my: "top left",at: "bottom left",adjust: adjust,viewport: $(window)},hide: {event: "unfocus"},show: {delay: 500,solo: void 0 === solo ? !0 : solo}})
                }
            })
        },_setup_device_tooltips_iframe: function(selector) {
            if (window.frameElement && window.parent.jQuery) {
                "undefined" == typeof selector && (selector = byod_common.default_selector);
                var $iframe = window.parent.$j(window.frameElement), contents = $iframe.contents().find(selector), adjust = {x: $iframe.offset().left,y: $iframe.offset().top};
                window.parent.byod_common._setup_device_tooltips(contents, adjust)
            }
        },setup_device_tooltips: function(selector) {
            return window.parent === top || window.parent === window ? byod_common._setup_device_tooltips(selector) : byod_common._setup_device_tooltips_iframe(selector)
        },isDevice: {Windows: function() {
                return /Windows NT/i.test(navigator.userAgent)
            },Mac: function() {
                return /Mac/i.test(navigator.userAgent)
            },iOS: function() {
                return /iPhone|iPad|iPod/i.test(navigator.userAgent)
            },Android: function() {
                return /Android/i.test(navigator.userAgent)
            },WindowsPhone: function() {
                return /Windows Phone/i.test(navigator.userAgent)
            },Mobile: function() {
                return this.iOS() || this.Android() || this.WindowsPhone()
            }},isDeviceDeletable: function(entry) {
            var numDevices = entry.devices || 0, numRef = entry.q_ref || 0;
            return numDevices > numRef
        },combineEndpointDevice: function(endpoints, devices, processFunc) {
            var endpointMacs = endpoints.map(function(entry) {
                return entry.mac
            }), filterDevice = function(entry) {
                return -1 === endpointMacs.indexOf(entry.mac) && entry["interface"] && !!entry.intf_allow_fortiheartbeat
            }, extraDevices = devices.filter(filterDevice), makeMap = function(key) {
                return function(previous, current) {
                    return previous[current[key]] = current, previous
                }
            }, deviceMap = devices.reduce(makeMap("mac"), {}), filterEndpoint = function(entry) {
                return !!entry.intf_allow_fortiheartbeat || ["quarantined", "registered"].indexOf(entry.state) > -1
            };
            return $.isFunction(processFunc) ? endpoints.filter(filterEndpoint).concat(extraDevices).map(processFunc(deviceMap)) : endpoints.filter(filterEndpoint).concat(extraDevices)
        },genComplianceStatInlineMsg: function(intfName, vdom) {
            var deviceUrl = "/api/v2/monitor/user/device/select/?compliance_visibility=true", forticlientUrl = "/api/v2/monitor/endpoint-control/record-list/select/";
            return deviceUrl = setQueryValue(deviceUrl, "vdom", vdom), deviceUrl = setQueryValue(deviceUrl, "intf_name", intfName), forticlientUrl = setQueryValue(forticlientUrl, "vdom", vdom), forticlientUrl = setQueryValue(forticlientUrl, "intf_name", intfName), $.when($.getJSON(deviceUrl), $.getJSON(forticlientUrl)).then(function(devices, forticlients) {
                function processEntry(device_map) {
                    return function(entry) {
                        var device = device_map[entry.mac] || {}, data = $.extend({}, device, entry);
                        return "quarantined" !== entry.compliance_status && "exempt" === device.compliance_status && (data.compliance_status = device.compliance_status), data
                    }
                }
                function countDevices(status) {
                    return function(counter, entry) {
                        return entry.compliance_status === status && (counter += 1), counter
                    }
                }
                var results = byod_common.combineEndpointDevice(forticlients[0].results, devices[0].results, processEntry), notCompliant = results.reduce(countDevices("non-compliant"), 0), exempt = results.reduce(countDevices("exempt"), 0), html = "";
                if (notCompliant || exempt) {
                    var notCompliantMsg = "<div>{{ non_compliant_number }}&nbsp;{{ non_compliant_device_info }}</div>", exemptMsg = "<div>{{ exempt_number }}&nbsp;{{ exempt_device_info }}</div>", template = '<div class="warning-message"><f-icon class="fa-warning"></f-icon><div class="message-content">' + (notCompliant ? notCompliantMsg : "") + (exempt ? exemptMsg : "") + '<p><a href="#">{{ action }}</a></p></div></div>';
                    html = fweb.util.dom.renderTemplate(template, {non_compliant_number: notCompliant,non_compliant_device_info: $.getInfo("ComplianceStat::Msg::non_compliant"),exempt_device_info: $.getInfo("ComplianceStat::Msg::exempt"),exempt_number: exempt,action: $.getInfo("ComplianceStat::Msg::action")})
                }
                return html
            })
        },_editExemptList: function(mkey, device) {
            return function(rule) {
                return rule.push({id: 0,devices: [{name: device}]}), CMDB.edit("user", "security-exempt-list", mkey, {rule: rule})
            }
        },_createExemptList: function(mkey, device) {
            return function() {
                var rule = [{id: 0,devices: [{name: device}]}];
                return CMDB.append("user", "security-exempt-list", mkey, {name: mkey,rule: rule})
            }
        },_updateInterfaceExemptList: function(intfName, intfType, exemptListName) {
            return function() {
                var data = {"security-exempt-list": exemptListName};
                return "vap-switch" === intfType ? CMDB.edit("wireless-controller", "vap", intfName, data) : CMDB.edit("system", "interface", intfName, data)
            }
        },_getExemptListName: function(intfName, intfType) {
            var interfaceUrl = "/api/v2/cmdb/system/interface/", vapUrl = "/api/v2/cmdb/wireless-controller/vap/", url = ("vap-switch" === intfType ? vapUrl : interfaceUrl) + intfName + "/?format=security-exempt-list";
            return $.getJSON(url).then(function(data) {
                return data.results[0]["security-exempt-list"]
            })
        },_getExemptListRule: function(exemptListName) {
            var url = "/api/v2/cmdb/user/security-exempt-list/" + exemptListName;
            return $.getJSON(url).then(function(data) {
                return data.results[0].rule
            })
        },_exemptDevice: function(intfName, intfType, exemptDevice) {
            return byod_common._getExemptListName(intfName, intfType).then(function(name) {
                var exemptListName = name || intfName + "-exempt-list";
                return byod_common._getExemptListRule(exemptListName).then(byod_common._editExemptList(exemptListName, exemptDevice), byod_common._createExemptList(exemptListName, exemptDevice)).then(name ? $.when({results: {status: "success"}}) : byod_common._updateInterfaceExemptList(intfName, intfType, exemptListName))
            })
        },exemptDeviceType: function(intfName, intfType, deviceType) {
            return byod_common._exemptDevice(intfName, intfType, deviceType)
        },exemptDevice: function(intfName, intfType, params) {
            function createCustomDevice() {
                var mkey = params.host_name || params.mac, data = {alias: mkey,mac: params.mac,type: params.device_type};
                return CMDB.append("user", "device", mkey, data)
            }
            return params.alias ? byod_common._exemptDevice(intfName, intfType, params.alias) : createCustomDevice().then(byod_common._exemptDevice(intfName, intfType, params.host_name || params.mac))
        }};
    return byod_common
}), fweb_define("csrf", ["jquery", "fweb.util/persist"], null, function($, persist) {
    "use strict";
    $.ajaxSetup({beforeSend: function(jqxhr, settings) {
            var url, token;
            "GET" !== settings.type && (url = /^\//.test(settings.url) ? settings.url : window.location.pathname, token = /^\/p\//.test(url) ? persist.getPythonCsrfToken() : persist.getCsrfToken(), jqxhr.setRequestHeader("X-CSRFTOKEN", token))
        }})
}), fweb_define("jquery.validate.rules", ["jquery.validate.methods", "legacy.jsonrpc", "csrf"], null, function() {
    "use strict";
    var module = {firewall: {address: {name: {nameRequired: !0,XSSChecker: !0,IdentifierChecker: !0,DuplicateEntryChecker: [{path: "firewall",name: "address"}, {path: "firewall",name: "addrgrp"}, {path: "firewall",name: "vip"}, {path: "firewall",name: "vipgrp"}]}},address6: {name: {nameRequired: !0,XSSChecker: !0,IdentifierChecker: !0,DuplicateEntryChecker: [{path: "firewall",name: "address6"}, {path: "firewall",name: "addrgrp6"}]}}}};
    return module.firewall.addrgrp = module.firewall.address, module.firewall.addrgrp6 = module.firewall.address6, module
});


// ========== Inactivity timer ===========

// saved_inactivity_timeout_val - save the last timeout value in case we want to reset the timer.
var saved_inactivity_timeout_val;
// inactivity_timer_expired - mark when the timer is currently expired so that pages can take different
// onbeforeunload actions during auto-logout.
var inactivity_timer_expired = false;

function inactiveCountDown(force)
{
    var logout_url = "/logout?timeout=1";
    inactivity_timer_expired = true;
    if (window.top.main) {
        //ng/#/vpn/edit consumes this event to prevent beforeunload dialog.
        window.top.main.postMessage('timeout', window.location.origin);
    }
    //wait for firefox to process the message event
    setTimeout(function() {
        if (window.opener) {
            window.opener.top.location = logout_url;
            self.close();
        } else {
            top.location = logout_url;
        }
    });
}