/*
  jquery.collapsible.js - jQuery collapsible form element plugin code. 
  init Nov 2010 by J. Thompson 
  Wireless Controller Improvements project
  Copyright Fortinet Inc
*/

(function($) {

$.fn.collapsible = function(settings) {
    function csUpdateLabel( inputElem, inputLabel )
    {
        var labelText = "";

        if ($("option:selected", inputElem).length)
        {
            labelText = $("option:selected", inputElem).html();
        }
        else
        {
            labelText = inputElem.val();
        }

        inputLabel.html( labelText );
    }

    var config = $.extend({}, $.fn.collapsible.defaults, settings);

    return this.each( function() {
        var inputElem = $(this)
            .addClass("ui-collapsible-elem")
            .hide()
        ;
      
        var inputLabel = $("<label></label>")
            .addClass("ui-collapsible-elem-label")
            .insertBefore(inputElem)
        ;
  
        var changeButton = $("<a></a>")
            .addClass("ui-collapsible-elem-change")
            .attr("href", "#")
            .html(config.changeText)
            .insertAfter(inputElem)
        ;

        var applyButton = $("<a></a>")
            .hide()
            .addClass("ui-collapsible-elem-apply")
            .attr("href", "#")
            .html(config.applyText)
            .insertAfter(changeButton)
        ;

        changeButton.click( function() {
            inputLabel.hide();
            inputElem.show();
            changeButton.hide();
            applyButton.fadeIn("slow");
            return false;
        });
        
        applyButton.click( function() {
            csUpdateLabel( inputElem, inputLabel );
      
            inputLabel.show();
            inputElem.hide();
            applyButton.hide();
            changeButton.fadeIn("slow");
            return false;
        });

        csUpdateLabel( inputElem, inputLabel );
    });
};

$.fn.collapsible.defaults = {
    "applyText" : "[Apply]",
    "changeText" : "[Change]",
    "readOnly" : false
};

})(jQuery);

