/*
  jquery.colorSelector.js - jQuery colorSelector plugin code. 
  init May 2010 by J. Thompson 
  Policy Table GUI Improvements project
  Copyright Fortinet Inc
*/

(function($) {
    $.fn.colorSelector = function(settings) {
        // Override plugin defaults.
        var config = $.extend({}, $.fn.colorSelector.defaults, settings);

        this.each( function( index ) {

            var $inputElement = $("<input name='" + config.formElementPrefix + (index + 1) + "' type='hidden'>").appendTo(this);

            var currentColor = this.getAttribute("csColorValue") || 0;

            if (!config.enabled)
            {
                $inputElement.val( currentColor );

                $(this).parents("tr:first").hide();

                return;
            }

            // Build default color select area.
            var $colorArea = $( createColorArea() ).appendTo( document.body );

            var colorPreviewClass = null;
            var $previewObject = null;

            if (config.colorPreviewObject)
            {
                $previewObject = $(config.colorPreviewObject).attr("colorClassPrefix", config.colorClassPrefix);
            }

            setColor( currentColor );

            $(this).click( function(e) {
                var offset = {"left": e.pageX, "top": e.pageY};
                showColorArea(this, offset);
            });

            if (config.resetButton)
            {
                // Reset color index to 0 (will use default value for plugin).
                $(config.resetButton).click( function() {
                    setColor( 0 );
                    return false;
                });
            }

            $("ul li", $colorArea)
                // TODO: .live() doesn't work for this.
                .bind("click", function() {
                    var color_value = this.getAttribute("csColorValue");

                    setColor( color_value );

                    return false;
                 })

                 // Add wrapping to color box.
                 .filter(":nth-child(" + config.colorsPerRow + "n+1)").addClass("csColorWrap");
            ;

            $(".csColorCloseButton").click( function() {
                closeColorArea();
            });

            function createColorArea()
            {
                var html = "<div class='csColorSelector'>";
                html += "<div class='csColorHeader'>";

                if (config.headerCaption)
                {
                    html += config.headerCaption;
                }

                html += "<span class='csColorCloseButton'></span></div>";

                html += "<ul class='csColorList'>";
                for (i=0; i< config.colorList.length; i++)
                {
                    html += "<li style='background-color: " + config.colorList[i] + ";' csColorValue='" + (i+1) + "'> </li>";
                }

                html += "</ul></div>";
                return html;
            }

            function showColorArea(o, offset)
            {
                // Adjust position.
                if (!offset) offset = $(o).offset();
                $colorArea.css(offset);

                // Hide previous selections.
                $("li", $colorArea).removeClass("csColorSelected");

                // Select current color.
                var selectedIndex = $inputElement.val();
                if (selectedIndex == 0 && typeof config.defaultValue == "number")
                {
                    selectedIndex = config.defaultValue;
                }

                $("li:nth-child(" + selectedIndex + ")", $colorArea).addClass("csColorSelected");

                // Show area
                $colorArea.show();
            }

            function closeColorArea()
            {
                // Hide area
                $colorArea.hide();
            }

            function setColor( color_value )
            {
                // Store current color value.
                $inputElement.val( color_value );

                // Hide color selector.
                closeColorArea();

                setIconPreview( color_value );

                if (typeof config.onColorSet == "function")
                {
                    config.onColorSet( color_value );
                }
            }

            function setIconPreview( index )
            {
                if (!$previewObject) return;

                if (config.colorClassPrefix)
                {
                    setIconPreviewClass( index );
                }
                // If a class prefix is not set, the plugin will set the background color
                // on the preview object directly, based on the color list specified.
                else
                {
                    setIconPreviewColor( index );
                }
            }

            function setIconPreviewColor( index )
            {
                var bgColor = config.colorList[index - 1] || config.defaultValue;

                $previewObject.css("background-color", bgColor);
            }

            function setIconPreviewClass( index )
            {
                var prefix = $previewObject.attr("colorClassPrefix");
                if (!prefix) prefix = config.colorClassPrefix;

                var newClassName = prefix + ((index > 0) ? index : config.defaultValue)

                if (colorPreviewClass)
                {
                    $previewObject.removeClass( colorPreviewClass );
                }

                $previewObject.addClass( newClassName );
                colorPreviewClass = newClassName;
            }
        });

        return this;
    };

    // Plugin defaults.
    $.fn.colorSelector.defaults = {
        // List of colors to show in the "Color Selector" dialog.
        "colorList": [
            "#ffcf32", "#ffff00", "#ffff99", "#ffe5e5", "#ffcc99", "#ff9966", "#ff6600", "#cc6600",
            "#cc9933", "#ff99ff", "#ff00cc", "#cc33ff", "#cc0000", "#660000", "#000000", "#6600ff",
            "#ccccff", "#cccc99", "#cccc33", "#cccccc", "#999999", "#666666", "#ccffcc", "#ccff00",
            "#66ff00", "#66cc00", "#009933", "#006600", "#66ffff", "#66ccff", "#0099ff", "#0000ff"
        ],

        // Number of colors in colorList to show in each row. The last entry in each row will
        // have the "csColorWrap" class added to it.
        "colorsPerRow": 8,

        // Caption string to use in the title bar of the color selector dialog. Will
        // be blank if set to null.
        "headerCaption": null,

        // Prefix to use in the name of the hidden element which will store the selected
        // color value. The input elements will be 1 based, ie: iconColor1.
        "formElementPrefix": "csColor",

        // Prefix used for CSS class set to "colorPreviewObject" before onColorSet is called.
        // The current color value will be appended to the end of this class prefix.
        // If this is set to "null", the background color on colorPreviewObject will be set
        // instead.
        "colorClassPrefix": "colorSelector",

        // Object/selector which will have its class updated when the color is changed. This
        // will use the colorClassPrefix + color index.
        "colorPreviewObject": null,

        // defaultValue - The default color index / color string in case a color is not specified, or
        // is specified as 0. This will be used when resetButton is clicked and on initial load.
        "defaultValue": 1,

        // resetButton - Object/selector which will have a click event bound to it resetting
        // the color to "defaultValue".
        "resetButton": null,

        // Callback which occurs after a color has been selected. Accepts a single parameter which
        // is the new color value.
        "onColorSet": null
    };
})(jQuery);
