/*global moveOptions,optionToString,optionsToArray,escapeHTML,RegExpCommon*/
(function($) {

    function text(obj, def) { return escapeHTML(obj || def || ""); }

    $.fn.filterConsole = function(settings) {
        var config = {
            "lang": {
                "heading":   $.getInfo("heading"),
                "ok":       $.getInfo("ok"),
                "apply":    $.getInfo("apply"),
                "cancel":   $.getInfo("cancel"),
                "from":     $.getInfo("from"),
                "to":       $.getInfo("to"),
                "format":   $.getInfo("format"),
                "value":    $.getInfo("value"),
                "change":   $.getInfo("change"),
                "fieldName":$.getInfo("fieldName"),
                "input":    $.getInfo("input"),
                "select":   "[ " + $.getInfo("select") + " ]",
                "addFilter":$.getInfo("addFilter"),
                "clearFilter":  $.getInfo("clearFilter"),
                "rmHint":   $.getInfo("rmHint"),
                "not": $.getInfo("filter_negate")
            },
            "panelClass" : "filterConsolePanel",
            "targetSelector" : 'th img[src*="filter"]',
            // default expanded filter name
            "expanded": "",
            // columns: [{
            //    key:string,
            //    label:string, support:{NOT, OR, RANGE, RANGE_EXCLUSIVE}(boolean),
            //    selection[]/{},
            //    validate:function(oflt:filters object),
            //    is: {(data, ip, ipport)}
            // }, ... ]
            "columns" : [],
            // filters, [ {id, logic{NOT, OR, RANGE}, value}, ... ]
            "filters": [],
            "action": function(panel) {}
        };

        $.extend(true, config, settings);

        // Deprecate: setup a way for external scripts to get the current filters list
        // should use $j().filterSection(callback) to receive current filters
        window.getFilters = function () {
            return config.filters;
        };

        config.columns = config.columns.sort(function (a, b) {
            return a.label > b.label ? 1 : (a.label < b.label ? -1 : 0);
        });

        // lookup filter
        function filterGetFilter(fieldName) {
            var flt;

            for (var i = 0; (flt = config.filters[i]); i++) {
                if (flt.id == fieldName) {
                    return flt;
                }
            }
            return {};
        }

        // lookup column
        function filterGetField(fieldName) {
            return getFilterByField(fieldName, config.columns);
        }

        this.each(function() {
            var panel = $(filterPanelTemplate(config));
            // add the panel at least to the DOM so that jQuery.remove will
            // clean up data, events. It's display: none, so it shouldn't
            // interfere with layout.
            // TODO: document this gotcha, warn other developers.
            // TODO: add a logging statement to jQuery.data for debugging
            //       purposes, and continue this memory leak quest
            // TODO: this is currently just a kludge to overcome the poor design
            //       of filterConsole. this file should be simplified and fixed.
            $(this).append(panel);
            panel.data('filterConsole_config', config);

            // filter icon click
            $.addStyle("/css/jquery.qtip.css");
            //$.addStyle("/css/main-fortiweb.css");

            $(config.targetSelector, this).qtip({
                suppress: false,
                content: {
                    text: function(api) {
                        var fieldName = $.trim($(this).parent().text());
                        var flt = filterGetField(fieldName);
                        var oflt = filterGetFilter(flt.key);
                        var val = oflt.value;
                        // ignore result of setupFilterSection
                        setupFilterSection(flt, oflt);
                        var sec =  $('<div class="filterSection filterSectionSelected" fieldName="' + flt.key + '"></div>')
                            .html(flt.html);
                        extendFilter(sec, flt, oflt);
                        var foot = $(footerTemplate(val));
                        var that = $(this);
                        $(".option_button", sec).click(
                            function() {
                                return filterOptionMoveSection.call(this, sec);
                            });
                        $(".option_select", sec).dblclick(
                            function() {
                                return filterOptionMoveSection.call(this, sec);
                            });
                        $('.cancel', foot).click(function(event) {
                            that.qtip('hide', event);
                        });
                        $('.del', foot).click(function(event) {
                            var nsec = findSection(flt.key);
                            nsec.remove();
                            that.qtip('hide', event);
                            $("form", panel).submit();
                        });
                        var applyFilterFn = function(event) {
                            var nsec = filterEditFilter(flt.key);
                            $('select', sec).each(function() {
                                var jthis = $(this);
                                var name = jthis.attr('name');
                                if (!name) {
                                    return;
                                }
                                var input = $('select[name=' + name + ']', nsec);
                                input.html(jthis.html());
                            });
                            $('input, select', sec).each(function() {
                                var jthis = $(this);
                                var name = jthis.attr('name');
                                if (!name) {
                                    return;
                                }
                                var input = $('[name=' + name + ']', nsec);
                                input.prop('checked', jthis.prop('checked'));
                                input.val(jthis.val());
                            });
                            that.qtip('hide', event);
                            $("form", panel).submit();
                        };
                        $('.apply', foot).click(applyFilterFn);
                        $('.textInput', sec).keyup(function (e) {
                            if (e.keyCode === $.ui.keyCode.ENTER) {
                                applyFilterFn.apply($('.apply', sec).first(), arguments);
                            }
                        });
                        return $("<div/>").append(sec).append(foot).children();
                    },
                    title: {
                        text: function(api) {
                            return $.getInfo('filter') +
                                ' &lt;' + $.trim($(this).parent().text()) + '&gt;';
                        },
                        button: true
                    }
                },
                hide: {
                    event: false
                },
                show: {
                    event: 'click',
                    solo: true
                },
                style: {
                    widget: true,
                    classes: 'ui-tooltip-plain ui-tooltip-shadow ui-tooltip-filter'
                },
                position: {
                    my: 'top left',
                    at: 'bottom center',
                    viewport: $j(window)
                },
                events: {
                    visible: function(event, api) {
                        $(":input:visible:enabled:first", api.elements.tooltip).focus();
                    },
                    show: function(event, api) {
                        var $target =  api.elements.target;
                        var $fixed_thead = $target.parents('div.ql-inner-container')
                                                  .find('.qlist_fixed_column_header_container');
                        // The qlist with fixed theader needs to
                        // set the position.target to the corresponding th in its fixed theader.
                        if ($fixed_thead.length > 0) {
                            var index = $target.closest('th').index();
                            var selector = 'th:nth-child(' + (index + 1) + ')';
                            var $fixed_target = $fixed_thead.find(selector);
                            $target.qtip('option', 'position.target', $fixed_target);
                        }
                    }
                }
            }).click(function(event){event.stopPropagation();});

            // filter apply
            $("form", panel).submit(function(event) { return config.action(panel, event) });

            // load filters
            filterBuildFilter();

            // call specific functions
            function filterBuildFilter() {
                // append cookie filters to filter panel
                var flt;
                for (var i = config.columns.length - 1; i >= 0 && (flt = config.columns[i]); i--) {
                    // try to load from cookie
                    var oflt = filterGetFilter(flt.key);
                    if (oflt.value != null) {
                        var sec = $(setupFilterSection(flt, oflt));
                        $("ul", panel).prepend(sec);
                        extendFilter(sec, flt, oflt);
                    }
                }
            }

            // filter extension
            function extendFilter(sec, flt, oflt)
            {
                $('input[name$="_from_value"]', sec).change(function() {
                    var to = $('input[name$="_to_value"]', sec);
                    if (to.attr("init") == to.val()) {
                        to.attr("init", this.value);
                        to.val(this.value);
                    }
                });

                if (!flt.is) return;

                if (flt.is.date)
                {
                    var values = [(oflt.value[0] || " ").split(' '), (oflt.value[1] || " ").split(' ')];

                    var fr = $('input[name$="_from_value"]', sec)[0];
                    var to = $('input[name$="_to_value"]', sec)[0];

                    var dates = $([fr, to]).datepicker({
                            "constrainInput": false,
                            "onSelect": function(selectedDate) {
                                var option = this.name.indexOf("_from_value") > 0 ? "minDate" : "maxDate";
                                var instance = $(this).data("datepicker");
                                var date = $.datepicker.parseDate(
                                    instance.settings.dateFormat ||
                                    $.datepicker._defaults.dateFormat,
                                    selectedDate, instance.settings);
                                dates.not(this).datepicker("option", option, date);
                                if (fr.value && !fr.value.split(' ')[1]) fr.value += " 00:00:00";
                                if (to.value && !to.value.split(' ')[1]) to.value += " 23:59:59";
                            }
                        });

                    var arr = [];
                    // convert date formate to locale format
                    if (values[0][0]) arr[0] = $.datepicker.parseDate("yy-mm-dd", values[0][0]);
                    if (values[1][0]) arr[1] = $.datepicker.parseDate("yy-mm-dd", values[1][0]);

                    $(fr).datepicker("setDate", arr[0]);
                    fr.value += " " + values[0][1];
                    $(to).datepicker("setDate", arr[1]);
                    to.value += " " + values[1][1];
                }

            }

            function findSection(fieldName) {
                var sec;
                // select corresponding section
                $(".filterSection", panel).each(function () {
                    sec = $(this);
                    if (sec.attr("fieldName") == fieldName) {
                        return false;
                    }
                });
                return sec;
            }

            function filterEditFilter(fieldName) {
                // lookup by field text
                var flt = filterGetField(fieldName);

                // select corresponding section
                var sec = findSection(flt.key);

                // if activate sec is new filter section
                if (flt.key && $("[name=_field_name]", sec).val("").size() > 0) {
                    // generate new filter section according to flt
                    var oflt = filterGetFilter(flt.key);
                    sec = $(setupFilterSection(flt, oflt)).insertBefore(sec);
                    extendFilter(sec, flt, oflt);
                }

                // activate
                $(".filterLabel>a", sec).click();
                return sec;
            }

            function filterOptionMoveSection(sec) {
                var fieldName = sec.attr("fieldName");

                return this.name.indexOf("_available_list") > 0 || this.value.indexOf("->") > 0 ?
                    moveOptions($("select[name="+fieldName+"_available_list]", sec).get(0), $("select[name="+fieldName+"_value_list]", sec).get(0))
                    : moveOptions($("select[name="+fieldName+"_value_list]", sec).get(0), $("select[name="+fieldName+"_available_list]", sec).get(0));
            }

            function filterOptionMove() {
                return filterOptionMoveSection.call(this,
                    $(".filterSectionSelected", panel));
            }
        });

        // generating filter section html code
        // flt: column object, oflt: filter object
        function setupFilterSection(flt, oflt) {
            if (oflt.logic == null)
                oflt.logic = {};
            else {
                // force convert to boolean, '0' -> false
                oflt.logic.NOT = oflt.logic.NOT == true;
                oflt.logic.RANGE = oflt.logic.RANGE == true;
                oflt.logic.RANGE_EXCLUSIVE = oflt.logic.RANGE_EXCLUSIVE == true;
                oflt.logic.OR = oflt.logic.OR == true;
            }
            if (oflt.value == null) oflt.value = [];
            if (typeof(oflt.value) == "string") oflt.value = [oflt.value];

            var val_text;

            // ip[range]:port[range] type
            if (flt.is && flt.is.ipport) {
                var ipv6 = RegExpCommon.IP6_HOST.test(oflt.value[0]);
                var addr = ipv6 ? [oflt.value[0]] : (oflt.value[0] || "").split(':');
                // add ip address
                val_text = addr[0];
                // add ip range
                if (oflt.value[1]) {
                    val_text += '-' + oflt.value[1];
                }
                // add ports
                if (addr[1]) {
                    val_text += ':' + addr[1];
                }
                flt.html = "<p>"
                    + "<label for="+flt.key+"_text_input>"+config.lang.value+": </label>"
                    + "<input id="+flt.key+"_text_input name="+flt.key+"_text_value class=textInput value=\""+text(val_text)+"\"> "
                    + (flt.support.NOT ? notLabelTemplate(flt, oflt, config.lang) : "")
                    + " </p>";

            // selection like type
            } else if (flt.selection) {
                // regular selection
                if (!flt.support.OR) {
                    // single selection
                    flt.html = regularSingleSelectionSectionTemplate(flt, oflt, config.lang);
                }
                else {
                    // multiple selection
                    flt.html = regularMultipleSelectionSectionTemplate(flt, oflt, config.lang);
                }

            // int like type
            } else if (flt.support.RANGE) {
                val_text = "";

                if (oflt.value.join("").length) {
                    if (oflt.logic.RANGE && oflt.value.length == 2) {
                        if (!oflt.value[0]) {
                            val_text = (oflt.logic.RANGE_EXCLUSIVE ?
                                " < " : " <= ") + oflt.value[1];
                        }
                        else if (!oflt.value[1]) {
                            val_text = (oflt.logic.RANGE_EXCLUSIVE ?
                                " > " : " >= ") + oflt.value[0];
                        }
                        else
                            val_text = oflt.value.join(" - ");
                    } else {
                        val_text = oflt.value.join(", ");
                    }
                }

                if (!flt.support.OR && !flt.is.ip) {
                    // just range only, show from - to
                    flt.html = rangeSectionTemplate(flt, oflt, config.lang);
                }
                else {
                    // range/or, show input box
                    flt.html = rangeOptionSectionTemplate(flt, oflt, config.lang, { val_text: val_text });
                }

            // string like type
            } else {
                var values = [];
                // format expression display
                for (var str, i = 0; str = oflt.value[i]; i++) {
                    str = str.toString().replace(/^\s|\s$/, "");
                    var arr = str.match(/[^" ']*"[^"]*"[^ ]*|[^" ']*'[^']*'[^ ]*|[^ ]+/g);
                    values.push(arr.join(" AND "));
                }

                flt.html = stringSectionTemplate(flt, oflt, config.lang);
            }


            // help
            if (flt.help) {
                flt.html += "<p>" + flt.help + "</p>";
            }

            // display callback
            if ($.isFunction(flt.display)) {
                flt.display(oflt);
            }

            return $("<li class=filterSection fieldName='"+flt.key+"'></li>")
                .html($("<div class=filterEdit style='display:none'></div>").html(flt.html));
        }

        return this;
    };

    // client side templates

    function filterPanelTemplate(config) {
        var html = "<div class=\"" + config.panelClass + "\" style='display: none'>"
            + "<h3>" + config.lang.heading + ":</h3>"
            + "<form>"
            + "<ul>";

        // add new filter
        html += "<li class=filterSection>"
            + "<div class=filterLabel><a><div class=icon><b class='icon_sprite tool_add'></b></div></a>"
            + "<span class=filterText>" + config.lang.addFilter + "</span></div>"
            + "<div class=filterEdit>"
            + "<p>" + config.lang.fieldName + ": ";

        html += "<select name=_field_name>";
        html += "</select></p>";

        html += "<p>" + config.lang.input + ": "
            + "<br><input name=_field_name class=textInput>"
            + "</p>";

        html += "</div>"
            + "</li>";

        // clear all filter
        html += "<li>"
            + "<div class=filterLabel><div class=icon><b class='icon_sprite tool_clear'></b></div><span class=filterText>" + config.lang.clearFilter + "</span></div>"
            + "</li>";

        // end filter section
        html += "</ul>"
            + "<input name=expanded type=hidden>"
            + "<p>"
            + "<input class=\"button\" type=\"submit\" value=\"" + config.lang.ok + "\" />\n"
            + "<input class=\"button\" type=\"submit\" value=\"" + config.lang.apply + "\" />\n"
            + "<input class=\"button\" type=\"button\" value=\"" + config.lang.cancel + "\" />\n"
            + "</p>"
            + "</form>"
            + "</div>";

        return html;
    }

    function footerTemplate(val) {
        var ftr = '<div style="' + (val ? 'min-width: 400px' : '') + '"><div style="float:left">';
        if (val) {
            ftr += '<input class="del button" type="button" style="margin-right: 40px" value="' + $.getInfo('del') + '">';
        }
        ftr += '</div><div style="float:right">' +
            '<input class="apply button" style="margin-right: 5px" type="button" value="' + $.getInfo('apply') + '">' +
            '<input class="cancel button" type="button" value="' + $.getInfo('cancel') + '">' +
            '</div></div>';
        return ftr;
    }

    // TODO: convert to use a client-side templating library (_.template if we use visualSearch.js)
    function regularSingleSelectionSectionTemplate(flt, oflt, lang) {
        var opt, html;

        html = "<p>" + lang.value + ": <select name=" + flt.key + "_text_value>";
            for (var i = 0; (opt = flt.selection[i]); i++) {
                var slt;
                if (typeof(opt) == "string") opt = [opt];
                if (!oflt.value || (","+oflt.value.join(",")+",").indexOf(","+opt[0]+",") < 0)
                    slt = "";
                else {
                    slt = " selected";
                }
                html += "<option value=\"" + text(opt[0]) + "\"" + slt + ">" + text(opt[1], opt[0]) + "</option>";
            }
        html += "</select></p>";
        return html;
    }

    function regularMultipleSelectionSectionTemplate(flt, oflt, lang) {
        var opt, avl_opts = "", slt_opts = "", flt_selection = flt.selection;
        if ($.isArray(flt_selection)) {
            flt_selection = flt_selection.filter(function(v, i, a) { return a.indexOf(v) == i });
        }
        for (var i = 0; (opt = flt_selection[i]); i++) {
            if (typeof(opt) == "string") opt = [opt];
            var s = "<option value=\"" + text(opt[0]) + "\">" + text(opt[1], opt[0]) + "</option>";
            if (!oflt.value || (","+oflt.value.join(",")+",").indexOf(","+opt[0]+",") < 0) {
                avl_opts += s;
            }
            else {
                slt_opts += s;
            }
        }

        return "<table>"
            + (flt.support.NOT ? "<tr><td colspan=2></td><td>"+notLabelTemplate(flt, oflt, lang)+"</td></tr>" : "")
            + "<tr><td><select name="+flt.key+"_available_list class=option_select size=10 multiple='multiple'>"
            + avl_opts
            + "</select></td>"
            + "<td><div>"
            + "<input type=button class=option_button value=\" -> \"><br>&nbsp;<br>"
            + "<input type=button class=option_button value=\" <- \"></div></td>"
            + "<td><select name="+flt.key+"_value_list class=option_select size=10 multiple='multiple'>"
            + slt_opts
            + "</select></td>"
            + "</tr></table>";
    }

    function rangeSectionTemplate(flt, oflt, lang) {
        var from = text(oflt.value[0]);
        var to = text(oflt.value[oflt.value.length - 1]);
        return "<table cellspacing=0 colspacing=0>"
            + (flt.support.NOT ? "<tr><td></td><td>"+notLabelTemplate(flt, oflt, lang)+"</td></tr>" : "")
            + "<tr><td>"+lang.from+":</td><td><input name="+flt.key+"_from_value class=dateInput size=10 value=\""+from+"\"></td></tr>"
            + "<tr><td>"+lang.to+":</td><td><input name="+flt.key+"_to_value class=dateInput size=10 init=\""+to+"\" value=\""+to+"\"></td></tr>"
            + "</table>";
    }

    function rangeOptionSectionTemplate(flt, oflt, lang, params) {
        return "<p><label for="+flt.key+"_text_input>"+lang.value+": </label><input id="+flt.key+"_text_input name="+flt.key+"_text_value class=textInput value=\""+text(params.val_text)+"\"> "
            + (flt.support.NOT ? notLabelTemplate(flt, oflt, lang) : "")
            + "</p>";
    }

    function stringSectionTemplate(flt, oflt, lang) {
        var value = oflt.value.join(", ");
        return "<p><label for="+flt.key+"_text_input>"+lang.value+": </label><input id="+flt.key+"_text_input name="+flt.key+"_text_value class=textInput value=\""+text(value)+"\"> "
            + (flt.support.NOT ? notLabelTemplate(flt, oflt, lang) : "")
            + " </p>";
    }

    function notLabelTemplate(flt, oflt, lang) {
        return "<label><input name=" + flt.key + "_negate type=checkbox" + (oflt.logic.NOT ? " checked" : "") + "> " + lang.not + "</label>";
    }

    // extracts the filter object from the panel that defines the how the
    // given field/section (??) should be filtered. See the below oflt
    // variable's initialization for the spec of the returned object
    function getSecFilter(fieldName, panel, flt) {
        var sec = $(".filterSection[fieldName="+fieldName+"]", panel);
        if (!sec.length) return {};

        var f = $("form", panel).get(0);
        // this is the object that will finally get returned from this function.
        var oflt = {
            "id": fieldName,
            // how the filter matches the value - NOT, OR, RANGE, RANGE_EXCLUSIVE
            "logic": {}
            // value: [string] of the value to match
        };
        var arr, val, mat, ext;

        if (f[fieldName + "_negate"] && f[fieldName + "_negate"].checked) {
            oflt.logic.NOT = 1;
        }

        // selection case
        if (flt.selection) {
            // single selection
            if (!flt.support.OR) {
                oflt.value = [f[fieldName + "_text_value"].value];
            }
            else {
                // multiple selection
                oflt.value = optionToString(optionsToArray(f[fieldName + "_value_list"], 2, 0));
            }

            if (oflt.value.length > 1) oflt.logic.OR = 1;
        }

        // int case
        else if (flt.support.RANGE) {
            if (!flt.support.OR && !flt.is.ip) {
                oflt.logic.RANGE = 1;
                oflt.value = [
                    $.trim(f[fieldName+"_from_value"].value),
                    $.trim(f[fieldName+"_to_value"].value)
                ];
            }
            else {
                if (flt.support.OR) {
                    oflt.value = $.map(f[fieldName + "_text_value"].value.split(","), $.trim);
                } else {
                    oflt.value = [$.trim(f[fieldName + "_text_value"].value)];
                }

                if (oflt.value.length > 1) {
                    oflt.logic.OR = 1;
                }
                else {
                    val = oflt.value[0];
                    // test extend part
                    if (flt.is.ipport) {
                        // for ip:port, only ip part will take care
                        var addr = val.split(':');
                        val = addr[0];
                        if (addr[1]) {
                            ext = ':' + addr[1];
                        }
                    } else if (flt.is.ip) {
                        // 10.0.0.[1-2] same as 10.0.0.1-2
                        val = val.replace('[', '').replace(']','');
                    }
                    // test operator, except within []
                    // test range "-"
                    if ((mat = val.match(/[^\[]*\[[^\]]+\][^\-]*|[^\[\-]+/g)) && mat.length == 2) {
                        arr = $.map(mat, $.trim);
                    }
                    // test ">="
                    else if (val.match(/^\s*\>\=.+$/)) {
                        arr = val.split(">=");
                        arr[0] = $.trim(arr[1]);
                        arr[1] = "";
                    }
                    // test ">"
                    else if (val.match(/^\s*\>.+$/)) {
                        arr = val.split(">");
                        arr[0] = $.trim(arr[1]);
                        arr[1] = "";
                        oflt.logic.RANGE_EXCLUSIVE = true;
                    }
                    // test "<="
                    else if (val.match(/^\s*<\=.+$/)) {
                        arr = $.map(val.split("<="), $.trim);
                    }
                    // test "<"
                    else if (val.match(/^\s*<.+$/)) {
                        arr = $.map(val.split("<"), $.trim);
                        oflt.logic.RANGE_EXCLUSIVE = true;
                    }

                    if (arr && arr.length == 2) {
                        // ip in shortcut ['10.0.0.1','2'] convert to ['10.0.0.1', '10.0.0.2']
                        if (flt.is.ip && arr[1].indexOf('.') < 0 && arr[1].indexOf(':') < 0) {
                            var sp = arr[0].lastIndexOf('.') + 1 || arr[0].lastIndexOf(':') + 1;
                            arr[1] = arr[0].substr(0, sp) + arr[1];
                        }
                        if (ext) arr[0] += ext;
                        oflt.logic.RANGE = 1;
                        oflt.value = arr;
                    }
                }
            }
        }

        // string case
        else {
            // please note: ',' does not support in search string
            val = f[fieldName + "_text_value"].value;
            oflt.value = val.match(/[^,"']*".*"[^,]*|[^,"']*'.*'[^,]*|[^,"']+/g);
            if (oflt.value && oflt.value.length > 1) oflt.logic.OR = 1;
        }

        // clean up values
        if (oflt.value) {
            for (var i = 0; i < oflt.value.length; i++) {
                // trim string
                oflt.value[i] = oflt.value[i].toString().replace(/^\s+|\s+$/, "");
            }
        }

        // filter extension
        if (flt.is) {
            // datepicker extension
            if (flt.is.date) {
                // convert date formate to yyyy-mm-dd
                // there is some cases that oflt.value is empty
                // TODO: need to check if those cases are normal
                var values  = [(oflt.value[0] || $(f[fieldName+"_from_value"])[0].value || " ").split(" "),
                               (oflt.value[1] || $(f[fieldName+"_to_value"])[0].value || " ").split(" ")];
                values[0][0] = $.datepicker.formatDate("yy-mm-dd", $(f[fieldName+"_from_value"]).datepicker("getDate"));
                if (!values[0][1]) {
                    values[0][1] = "00:00:00";
                }
                oflt.value[0] = values[0].join(" ");
                values[1][0] = $.datepicker.formatDate("yy-mm-dd", $(f[fieldName+"_to_value"]).datepicker("getDate"));
                if (!values[1][1]) {
                    values[1][1] = "23:59:59";
                }
                oflt.value[1] = values[1].join(" ");
            }
        }

        return oflt;
    }

    function getFilterByField(fieldName, columns) {
        var flt, i;
        for (i = 0; (flt = columns[i]); i++) {
            if (flt.key == fieldName || flt.label == fieldName) { return flt; }
        }
        return {};
    }

    $.fn.filterSection = function(callback) {
        this.each(function () {
            var $panel = $(this);
            var data = $panel.data('filterConsole_config');
            $panel.find(".filterSection").each(function () {
                var $this = $(this);
                var fieldName = $this.attr("fieldName");
                if (!fieldName) return;

                var flt = getFilterByField(fieldName, data.columns);
                callback.call(this, getSecFilter(fieldName, $panel, flt), flt);
            });
        });
    };

    if ($._filterConsole == null) { $._filterConsole = {}; }
    $._filterConsole.getFilterByField = getFilterByField;

})(jQuery);

//@ sourceURL=jquery.filterConsole.js
