(function ($) {
    $.fn.popupTable = function (settings) {
        var tableHandle;
        var config = {
        };

        $.extend(config, settings);

        this.each(function () {
            var myself = this;
            var loading = false;
            var data = {};
            var header;
            var pos_x;
            var pos_y;

            $(this).click(showDataTable);

            function createHeader() {
                var hdr = $("<div class=\"popupTable-header\"><a class=\"popupTable-close\" href=\"#\">close</a></div>");
                
                $("a.popupTable-close", hdr).click(closeDataTable);

                return hdr;
            }

            function getData () {
                var path = $(myself).attr("cmdb_path");
                var name = $(myself).attr("cmdb_name");

                var params = {
                    "key" : $(myself).attr("cmdb_key"),
                    "pattern" : $(myself).attr("cmdb_pattern")
                };

                loading = true;

                CMDB.fetch(path, name, params, updateData);
            }

            function updateData (jsonObj) {
                if (jsonObj.results.length && typeof(jsonObj.results[0]) !== "undefined") {
                    data = jsonObj.results[0];
                } else {
                    data = jsonObj.results;
                }

                loading = false;

                createDataTable();
            }

            function createDataTable () {
                var str = "";
                var idx, idy;
                var header;
                var viewport_h;
                var values;    
                var high;
                var keys = $(myself).attr("cmdb_highlight").split(",");

                str = "<div class=\"popupTable-container\">";
                str += "<div class=\"popupTable-scrollarea\"><table class=\"popupTable-infotable\">";
                for ( key in data ) {
                    if (!data[key] || typeof(data[key]) !== "string") {
                        continue;
                    }

                    high = "";

                    for (idx=0; idx<keys.length; idx++) {
                        if (keys[idx] == key) {
                            high = " class=\"highlight\"";
                        }
                    }

                    str += "<tr" + high + "><th>" + key + "</th>";

                    if (data[key].size) {
                        str += "<td>";

                        if (data[key].length) {
                            str += "<em>[multiple]</em>";
                        } else {
                            str += "<em>[child table]</em>";
                        }

                        str += "</td>";
                    } else {
                        str += "<td>" + data[key] + "</td>";
                    }

                    str += "</tr>";
                }
                str += "</table></div></div>";
                
                header = createHeader();
                tableHandle = $(str).prepend(header).prependTo(document.body);

                $("table.popupTable-infotable tr:odd", tableHandle).addClass("odd");

                if (window.parent.InlineModal) {
                    $(tableHandle).css("position", "relative");
                    $("div.popupTable-scrollarea", tableHandle).css("height", "auto");

                    window.parent.InlineModal.height = "auto";
                    window.parent.wij_auto_resize_iframe();

                    $(tableHandle).css("position", "fixed");
                }

                viewport_h = $(window).height();
                $("div.popupTable-scrollarea", tableHandle).css("height", (viewport_h - 62) + "px");
            }

            function showDataTable (e) {
                pos_x = e.pageX;
                pos_y = e.pageY;

                if (loading === false) {
                    if (tableHandle) {
                        closeDataTable();
                    }

                    getData();
                }

                return false;
            }

            function closeDataTable () {
                if (tableHandle) {
                    $(tableHandle).remove();
                }

                if (window.parent.InlineModal) {
                    window.parent.InlineModal.height = "auto";
                    window.parent.wij_auto_resize_iframe();
                }

                return false;
            }
        });

        return this;
    };
})(jQuery);
