(function($) {
    $.fn.qlist = function (parameters) {
        // these menu items are handled specially, since they are hard-coded into the qlist config
        var skip_menu_items = [ "create_new", "edit", "delete" ];
        var defaults = {
            "prefix" : "qlist",
            "menu_items" : {
            },
            "options" : {
                "ref_column" : false
            },
            "handle_selection_change" : null
        };
        var config = $.extend({}, defaults, parameters);

        if (typeof(qlist_obj) === "undefined") {
            return this;
        }

        this.each(function() {
            var my_qlist = {};
            var qlist_overrides = {};

            window.is_rw_admin = true;

            qlist_overrides.customize_menu_fn = qlist_init_custom_menu;
            qlist_overrides.handle_selection_change_fn = qlist_handle_custom_selection_change;
            qlist_overrides.prefix = config.prefix;
            qlist_overrides.id = this.id;
            qlist_overrides.hdr_cb = config.prefix + "_qlist_hdr_cb";
            qlist_overrides.enable_ref_col = config.options["ref_column"];
            qlist_overrides.create_elem_fn = config.menu_items["create_new"]["handler"];
            qlist_overrides.edit_elem_fn = config.menu_items["edit"]["handler"];
            qlist_overrides.delete_elems_fn = config.menu_items["delete"]["handler"];

            $.extend(my_qlist, qlist_obj, qlist_overrides);

            $(this).addClass("list").addClass("qlist");

            $("thead tr", this).addClass("heading").prepend("<th><input type=\"checkbox\" id=\"" + my_qlist.hdr_cb + "\" class=\"qlist_cb_hdr\" /></th>");
            $("tbody tr", this).addClass("qlist_row").prepend("<td><input type=\"checkbox\" class=\"qlist_cb\" /></td>");
            $("thead tr", this).addClass("heading");

            my_qlist.init();

            $(this).wrap("<div />");

            var container = $(this).parent("div");
            var menubar_id = config.prefix + "_qlist_yui_menubar";
            var menubar_container_id = config.prefix + "_qlist_yui_menubar_container";

            var menubar_container = $("<div id=\"" + menubar_container_id + "\" />")
                .addClass("qlist_hdrbar")
                .append("<div id=\"" + menubar_id + "\"></div>")
                .prependTo(container);

            $("body").addClass("yui-skin-sam");

            var oMB = qmenu_create_menubar(menubar_id, my_qlist, is_rw_admin);
            oMB.render(menubar_container.get(0));

            // Setup event handlers for the data table.
            my_qlist.setup_listitem_event_handlers();

            // Set the initial state of the button bar buttons.
            my_qlist.init_menubutton_state();
            my_qlist.build_context_menu();

            function qlist_init_custom_menu(item_list) {
                var item_config;
                var item;
                var id;

                for (id in config.menu_items) {
                    if (typeof(config.menu_items[id]) !== "object") {
                        continue;
                    }

                    if ($.inArray(id, skip_menu_items) !== -1) {
                        continue;
                    }

                    item_config = config.menu_items[id];

                    item = Page.createMenuItem({
                            "id" : id + "_" + config.prefix,
                            "spriteClass" : item_config["class"],
                            "single_only" : item_config["single_only"],
                            "text": item_config["label"],
                            "click" : { "fn": item_config["handler"] }
                        });

                    item_list.push(item);
                }
            }

            function qlist_handle_custom_selection_change() {
                qlist_handle_selection_change(my_qlist);

                if (typeof(config.handle_selection_change) == "function") {
                    config.handle_selection_change(my_qlist);
                }
            }
        });

        return this;
    };

    function qlist_append_row (table, item) {
        $(item).addClass("qlist_row")
            .prepend("<td><input type=\"checkbox\" class=\"qlist_cb\" /></td>")
            .appendTo(table);
    }

    // expose some utility functions
    window.qlist_append_row = qlist_append_row;
})(jQuery);
